

#DEFPARAMS
#END

#DEFTAG
ShaderName = "DisneyBk"
RenderQueue = "Transparent"
#END

#DEFPASS ForwardBase
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS } 
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { FORWARDBASE }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
// #include "utils.inc"

struct appdata   
{
	float3 vertex : POSITION;
	float2 uv1 : TEXCOORD0;
};

struct v2f
{
	float4 vertex : SV_POSITION;
	float2 uv1 : TEXCOORD0;
};

sampler2D TEXTURE_SRC;
float4x4 PARAMS;
float2 ganSize;
float2 srcSize;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = float4(v.vertex,1.0);
	
    o.vertex.xy = float2((v.vertex.x) / srcSize.x * 2.0 - 1.0, (1-v.vertex.y / srcSize.y) * 2.0 - 1.0);
    o.vertex.x = o.vertex.x < -1+1/srcSize.x ? -1+1/srcSize.x : o.vertex.x;
    o.vertex.x = o.vertex.x > 1-1/srcSize.x ? 1-1/srcSize.x : o.vertex.x;
    o.vertex.y = o.vertex.y < -1+1/srcSize.x ? -1+1/srcSize.x : o.vertex.y;
    o.vertex.y = o.vertex.y > 1-1/srcSize.x ? 1-1/srcSize.x : o.vertex.y;

	o.vertex = UniformNDC(o.vertex);

	o.uv1 = v.uv1.xy / srcSize;
    o.uv1.x = o.uv1.x < 1/srcSize.x ? 1/srcSize.x : o.uv1.x;
    o.uv1.x = o.uv1.x > 1-1/srcSize.x ? 1-1/srcSize.x : o.uv1.x;
    o.uv1.y = o.uv1.y < 1/srcSize.y ? 1/srcSize.y : o.uv1.y;
    o.uv1.y = o.uv1.y > 1-1/srcSize.y ? 1-1/srcSize.y : o.uv1.y;
	
	return o;
}

float3 lab2xyz(const in float3 c) {
    float fy = (c.x + 16.0) * 0.008620;
    float fx = c.y * 0.002 + fy;
    float fz = fy - c.z * 0.005;
    return float3(95.047 * ((fx > 0.206897) ? fx * fx * fx: (fx - 16.0 * 0.008620) * 0.128419), 100.000 * ((fy > 0.206897) ? fy * fy * fy: (fy - 16.0 * 0.008620) * 0.128419), 108.883 * ((fz > 0.206897) ? fz * fz * fz: (fz - 16.0 * 0.008620) * 0.128419));
}

float3 rgb2xyz(const in float3 c) {
    float3 tmp;
    tmp.x = (c.r > 0.04045) ? pow((c.r + 0.055) * 0.947867, 2.4) : c.r * 0.077399;
    tmp.y = (c.g > 0.04045) ? pow((c.g + 0.055) * 0.947867, 2.4) : c.g * 0.077399;
    tmp.z = (c.b > 0.04045) ? pow((c.b + 0.055) * 0.947867, 2.4) : c.b * 0.077399;
    // float3x3 mat = {0.4124, 0.3576, 0.1805,
    //                 0.2126, 0.7152, 0.0722,
    //                 0.0193, 0.1192, 0.9505
    //                 };

    float3x3 mat = {0.4124,0.2126, 0.0193,
                    0.3576,0.7152, 0.1192,
                    0.1805,0.0722, 0.9505 };
    return 100.0* mul(tmp ,mat);
}

float3 xyz2rgb(const in float3 c) {
    // float3x3 mat = {3.2406, -1.5372, -0.4986,
    //                 -0.9689, 1.8758, 0.0415, 
    //                 0.0557, -0.2040, 1.0570

    // };
    float3x3 mat = { 3.2406, -0.9689, 0.0557,
                    -1.5372, 1.8758, -0.2040, 
                    -0.4986, 0.0415, 1.0570

    };
    float3 v = mul(c * 0.01,mat);
    float3 r;
    r.x = (v.r > 0.0031308) ? ((1.055 * pow(v.r, 0.416667)) - 0.055) : 12.92 * v.r;
    r.y = (v.g > 0.0031308) ? ((1.055 * pow(v.g, 0.416667)) - 0.055) : 12.92 * v.g;
    r.z = (v.b > 0.0031308) ? ((1.055 * pow(v.b, 0.416667)) - 0.055) : 12.92 * v.b;
    return r;
}

float3 xyz2lab(const in float3 c) {
    float3 n = c / float3(95.047, 100, 108.883);
    float3 v;
    v.x = (n.x > 0.008856) ? pow(n.x, 0.333333) : (7.787 * n.x) + 0.137931;
    v.y = (n.y > 0.008856) ? pow(n.y, 0.333333) : (7.787 * n.y) + 0.137931;
    v.z = (n.z > 0.008856) ? pow(n.z, 0.333333) : (7.787 * n.z) + 0.137931;
    return float3((116.0 * v.y) - 16.0, 500.0 * (v.x - v.y), 200.0 * (v.y - v.z));
}
float3 lab2rgb(const in float3 c) {
    return xyz2rgb(lab2xyz(float3(100.0 * c.x, 2.0 * 127.0 * (c.y - 0.5), 2.0 * 127.0 * (c.z - 0.5))));
}

float3 rgb2lab(const in float3 c) {
    float3 lab = xyz2lab(rgb2xyz(c));
    return float3(lab.x * 0.01, 0.5 + lab.y * 0.003937, 0.5 + lab.z * 0.003937);
}

float clamp(float base, float mx, float mn){
    if (base > mx){
        base = mx;
    }
    if (base < mn){
        base = mn;
    }
    return base;
}

float3 clamp(float3 base, float m, float n){
    return float3(clamp(base.r,m,n),clamp(base.g,m,n),clamp(base.b,m,n));
}

float transform2color(float base, float mean1,float mean2,float std1,float std2){
    return (base - mean1/255.0)/(std1/255.0) * (std2/255.0) + mean2/255.0;
    // return (base - mean1) / std1 * std2 + mean2;
}
float3 transform2color(float3 base, float4x4 params){
    float3 lab_base = rgb2lab(base);
    // lab_base = float3(transform2color(lab_base.r,params[0].x,params[0].y,params[0].z,params[0].w),
    //                 transform2color(lab_base.g,params[1].x,params[1].y,params[1].z,params[1].w),
    //                 transform2color(lab_base.b,params[2].x,params[2].y,params[2].z,params[2].w));
     lab_base = float3(transform2color(lab_base.r,params[0].x,params[1].x,params[2].x,params[3].x),
                    transform2color(lab_base.g,params[0].y,params[1].y,params[2].y,params[3].y),
                    transform2color(lab_base.b,params[0].z,params[1].z,params[2].z,params[3].z));
    // lab_base = float3(transform2color(lab_base.x,0, 0, 255, 255),
    //                 transform2color(lab_base.y,0, 0, 255, 255),
    //                 transform2color(lab_base.z,0, 0, 255, 255));
    lab_base = clamp(lab_base,1.0,0.0);
    
    return lab2rgb(lab_base);
}

float mix(float base1,float base2, float alpha){
    return base1 * (1-alpha) + base2 * alpha;
}

float3 mix(float3 base1,float3 base2, float alpha){
    return float3(mix(base1.r,base2.r,alpha),mix(base1.g,base2.g,alpha),mix(base1.b,base2.b,alpha));
}

float4 frag(v2f i) : SV_Target
{

    float4 srcColor = tex2D(TEXTURE_SRC,i.uv1);
  
    float4 transform_src = float4(transform2color(srcColor.rgb,PARAMS),1.0);
  
    float4 col = float4(transform_src.rgb,1.0);
 
	
  return col;
}
ENDCG
#END
