

#DEFPARAMS
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "white" },
BlUR_LENGTH = { "BlurLength", FLOAT, "10.0"},
ANGLE = { "Angle", VEC2, "0.0, 1.0"},
#END

#DEFTAG
ShaderName = "directionalblur"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
  float4 vertex : POSITION;
  float2 uv : TEXCOORD0;
};

struct v2f
{
  float4 vertex : SV_POSITION;
  float2 uv : TEXCOORD0;
};

sampler2D TEXTURE_DIFFUSE;
float2 ANGLE;
float BlUR_LENGTH;

v2f vert(appdata v)
{
  v2f o;
  o.vertex = UniformNDC(v.vertex);  
  o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
    float4 color = tex2D(TEXTURE_DIFFUSE, i.uv);
	float weight = 1;
    for (int k = 1; k <= BlUR_LENGTH; k++)
    {
		//float w = max(k - 0.8*BlUR_LENGTH,1.0);
		int w = BlUR_LENGTH - k + 1;
        color += tex2D(TEXTURE_DIFFUSE, i.uv + ANGLE * k) * w;
		weight += w;
    }
    for (int k = 1; k <= BlUR_LENGTH; k++)
    {
		//float w = max(k - 0.8*BlUR_LENGTH,1.0);
		int w = BlUR_LENGTH - k + 1;
        color += tex2D(TEXTURE_DIFFUSE, i.uv - ANGLE * k) * w;
		weight += w;
    }
    float4 finalColor = color / weight;
    return finalColor;
	//return float4(finalColor.xyz, 1.0);
}
ENDCG
#END
