#DEFPARAMS
UNIFORM_DEBUGCAPSULE = {"UNIFORM_DEBUGCAPSULE", VEC2, "0.0,0.0"},
COLOR = { "COLOR", VEC3, "0.2, 0.9, 0.2" },
#END

#DEFTAG
ShaderName = "DebugCapsule"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
	float4 color : COLOR0;
};

float2 UNIFORM_DEBUGCAPSULE;
float3 COLOR;
struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

v2f vert(appdata v)
{
	v2f o;
	float4 in_Position = v.vertex;
	float4 in_Color = v.color;
    float2 in_CapsuleTrans = UNIFORM_DEBUGCAPSULE;
    float4x4 in_Transfrom = LOCALWORLD_TRANSFORM;
    float4x4 in_ViewPorj = CAMERA_VIEWPROJ;
    float4 out_PositionTemp = float4(in_Position.xyz * in_CapsuleTrans.y * in_Color.y, 1.0);
    float4 out_PositionUD = float4(out_PositionTemp.x, out_PositionTemp.y + (in_Color.z - 0.5) * in_CapsuleTrans.x, out_PositionTemp.z, 1.0);
    float4 out_PositionWS = mul(in_Transfrom, out_PositionUD);
    float4 out_Position = mul(in_ViewPorj, out_PositionWS);
	o.vertex = UniformNDC(out_Position);
	o.uv = v.uv.xy;
	return o;
}

float4 frag(v2f i) : SV_Target
{
    return float4(COLOR, 1.0);
}
ENDCG
#END