
#DEFPARAMS
_InputTexture = { "Current Tex", TEXTURE2D, "white" },
_ScanValue = { "Scan Value", FLOAT, "0.0" },
_LineScale = { "Line Scale", FLOAT, "0.05" },
_Orientation = { "Orientation", FLOAT, "0.0" },
#END

#DEFTAG
ShaderName = "ScanningLine"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "commonvar.inc"
#include "common.inc"

struct appdata
{
    float4 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
};

sampler2D _InputTexture;
float _ScanValue;
float _LineScale;
float _Orientation;


v2f vert(appdata v)
{
    v2f o;
    float3 pos = v.vertex.xyz;
    pos.x = pos.x * _LineScale; //line pic is vertical
    //rotate 90 or not  and  move the axis to left or top
    pos.xy = step(_Orientation, 0.5) * float2(pos.x-1.0+2.0*_ScanValue, pos.y) + step(0.5, _Orientation) * float2(-pos.y, pos.x+1.0-2.0*_ScanValue); 
    o.vertex = UniformNDC(float4(pos.xyz, 1.0));
    o.uv = v.uv.xy;
    return o;
}

float4 frag(v2f i) : SV_Target
{
  return tex2D(_InputTexture, i.uv);
}
ENDCG
#END
