
function DefineParams()
	Properties = 
	{
		
_InputTexture = { "Current Tex", TEXTURE2D, "white" },
_ScanValue = { "Scan Value", FLOAT, "0.0" },
_LineScale = { "Line Scale", FLOAT, "0.05" },
_Orientation = { "Orientation", FLOAT, "0.0" },

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "ScanningLine"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ScanValue",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_LineScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Orientation",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_InputTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _ScanValue;
uniform highp float _LineScale;
uniform highp float _Orientation;
out highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec3 pos_1;
  pos_1.yz = _glesVertex.yz;
  pos_1.x = (_glesVertex.x * _LineScale);
  highp vec2 tmpvar_2;
  highp float tmpvar_3;
  tmpvar_3 = (2.0 * _ScanValue);
  tmpvar_2.x = ((pos_1.x - 1.0) + tmpvar_3);
  tmpvar_2.y = pos_1.y;
  highp vec2 tmpvar_4;
  tmpvar_4.x = -(_glesVertex.y);
  tmpvar_4.y = ((pos_1.x + 1.0) - tmpvar_3);
  pos_1.xy = ((float(
    (0.5 >= _Orientation)
  ) * tmpvar_2) + (float(
    (_Orientation >= 0.5)
  ) * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = pos_1;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_6 * tmpvar_5);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D _InputTexture;
in highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture (_InputTexture, xlv_TEXCOORD0);
  tmpvar_1 = tmpvar_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
}

end
