
#DEFPARAMS
_HisTexture = { "History Tex", TEXTURE2D, "white" },
_InputTexture = { "Current Tex", TEXTURE2D, "white" },
_ScanValue = { "Scan Value", FLOAT, "0.0" },
_Orientation = { "Orientation", FLOAT, "0.0" },
#END

#DEFTAG
ShaderName = "FreezePhoto"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "commonvar.inc"
#include "common.inc"

struct appdata
{
    float4 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
};

sampler2D _HisTexture;
sampler2D _InputTexture;
float _ScanValue;
float _Orientation;


v2f vert(appdata v)
{
    v2f o;
    o.vertex = UniformNDC(v.vertex);
    o.uv = v.uv.xy;
    return o;
}

float4 frag(v2f i) : SV_Target
{


  float2 textureCoord = i.uv;
  float4 hisColor = tex2D(_HisTexture, textureCoord);
  float4 InputColor = tex2D(_InputTexture, textureCoord);
  float4 OutputColor = float4(0.0,0.0,0.0,0.0);
  /*if(_Orientation == 0.0)
  {
    OutputColor = step(_ScanValue, textureCoord.x)*InputColor + step(textureCoord.x, _ScanValue)*hisColor;
  }
  else
  {
    OutputColor = step(_ScanValue, textureCoord.y)*InputColor + step(textureCoord.y, _ScanValue)*hisColor;
  }*/ 

  OutputColor = step(_Orientation, 0.5)*(step(_ScanValue, textureCoord.x)*InputColor + step(textureCoord.x, _ScanValue)*hisColor) + step(0.5, _Orientation)*(step(_ScanValue, textureCoord.y)*InputColor + step(textureCoord.y, _ScanValue)*hisColor);

  return OutputColor;
}
ENDCG
#END
