

function DefineParams()
	Properties = 
	{
		
_MainTex = { "Main Tex", TEXTURE2D, "white" },
_MaskInfo = {"MaskInfo",VEC4,"0.0,0.0,0.0,0.0"},

_BlendSrc = {"Blend Src", FLOAT, "4.0"},

_BlendDst = {"Blend Dst", FLOAT, "5.0"},
_BlendMode = {"Blend Mode", FLOAT, "1.0"},

_ViewMode = {"View Mode", FLOAT, "0.0"},

	}
	Attributes = 
	{
		_BlendSrc = "Enum(BlendFactor)", 
		_BlendDst = "Enum(BlendFactor)", 
		_ViewMode = "Keywords(SCENE_VIEW,GAME_VIEW)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "makeup_test"
RenderQueue = "Transparent+1"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc", "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"SCENE_VIEW"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 _MaskInfo;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec2 uv2pos_1;
  highp vec2 tmpvar_2;
  tmpvar_2.x = (1000.0 / _MaskInfo.z);
  tmpvar_2.y = (1500.0 / _MaskInfo.w);
  highp vec2 tmpvar_3;
  tmpvar_3.x = (_glesMultiTexCoord0.x - (_MaskInfo.x / 1000.0));
  tmpvar_3.y = (_glesMultiTexCoord0.y - (_MaskInfo.y / 1500.0));
  uv2pos_1.x = ((_glesMultiTexCoord0.x - 0.5) * 0.24);
  uv2pos_1.y = ((_glesMultiTexCoord0.y - 0.5614035) * 0.285);
  highp vec4 tmpvar_4;
  tmpvar_4.zw = vec2(-0.03, 1.0);
  tmpvar_4.x = uv2pos_1.x;
  tmpvar_4.y = -(uv2pos_1.y);
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_4.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (tmpvar_3 * tmpvar_2);
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = texture2D (_MainTex, xlv_TEXCOORD0);
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GAME_VIEW"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 _MaskInfo;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = (1000.0 / _MaskInfo.z);
  tmpvar_1.y = (1500.0 / _MaskInfo.w);
  highp vec2 tmpvar_2;
  tmpvar_2.x = (_glesMultiTexCoord0.x - (_MaskInfo.x / 1000.0));
  tmpvar_2.y = (_glesMultiTexCoord0.y - (_MaskInfo.y / 1500.0));
  highp vec4 tmpvar_3;
  tmpvar_3.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_3.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (tmpvar_2 * tmpvar_1);
  gl_Position = (tmpvar_3 * (LOCALWORLD_TRANSFORM * (_glesVertex * 
    (1.0/(_glesVertex.w))
  )));
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = texture2D (_MainTex, xlv_TEXCOORD0);
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
}

end
