

#DEFPARAMS
_MainTex = { "Main Tex", TEXTURE2D, "black" },
_MaskMap = {"MaskTex", TEXTURE2D, "white" },
_EditorMaskMap = {"EditorMaskTex", TEXTURE2D, "white" },
_LutMap = {"Lut Map", TEXTURE2D, "white" },
_MaskInfo = {"MaskInfo",VEC4,"0.0,0.0,0.0,0.0"},
_MaskScaleInfo = {"MaskScaleInfo",VEC4,"0.0,0.0,0.0,0.0"},
_Opacity = { "Opacity", FLOATRANGE, "0.5, 1, 0" },
_Strength = { "Strength", FLOAT, "1" },
[Enum(BlendFactor)]
_BlendSrc = {"Blend Src", FLOAT, "8.0"},
[Enum(BlendFactor)]
_BlendDst = {"Blend Dst", FLOAT, "0.0"},
[Enum(PolygonMode)]
_Polygon = {"Polygon Mode", FLOAT, "2.0"},
[Keywords(BLEND_NORMAL, BLEND_MULTIPLY, BLEND_SCREEN, BLEND_Hue, BLEND_SATURATION, BLEND_LUMINOSITY, BLEND_COLOR, BLEND_BLEND,BLEND_EXCLUSION,BLEND_HARDLIGHT,BLEND_VIVIDLIGHT,BLEND_OVERLAY,BLEND_COLORBURN,BLEND_COLORDODGE,BLEND_SOFTLIGHT,BLEND_HARDMIX,BLEND_PINLIGHT,BLEND_LINEARLIGHT,BLEND_DIFF,BLEND_LINEARBURN,BLEND_SUB,BLEND_LUT)]
_BlendMode = {"Blend Mode", FLOAT, "1.0"},
_DefMode = { "def Mode", FLOAT, "2.0"},
_UseMask = { "Mask On", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "makeup"
RenderQueue = "Transparent+1"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc", "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }
POLYGON_MODE = { "%_Polygon" }
POINT_SIZE = 5

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fbfetch
#include "common.inc"
#pragma multi_compile BLEND_NORMAL BLEND_MULTIPLY BLEND_SCREEN BLEND_Hue BLEND_SATURATION BLEND_LUMINOSITY BLEND_COLOR BLEND_BLEND BLEND_EXCLUSION BLEND_HARDLIGHT BLEND_VIVIDLIGHT BLEND_OVERLAY BLEND_COLORBURN BLEND_COLORDODGE BLEND_SOFTLIGHT BLEND_HARDMIX BLEND_PINLIGHT BLEND_LINEARLIGHT BLEND_DIFF BLEND_LINEARBURN BLEND_SUB BLEND_LUT

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
	
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
	float4 screenPos : TEXCOORD1;
	float reliability: TEXCOORD2;
	float2 maskuv : TEXCOORD3;
	float isEditor : TEXCOORD4;
};

uniform float _UseMask;
uniform sampler2D _MaskMap;
uniform sampler2D _EditorMaskMap;
uniform float4 _MaskScaleInfo;

sampler2D _MainTex;
sampler2D _LutMap;
float4 _MaskInfo;
float _DefMode;

v2f vert(appdata v)
{
	v2f o = (v2f)0;

	//float2 mask_scale = float2(1000.0/_MaskInfo.z,1500.0/_MaskInfo.w);
	//float2 uv_offset = float2(v.uv.x - _MaskInfo.x/1000.0,v.uv.y - _MaskInfo.y/1500.0) * mask_scale;
	float uOffset = (v.uv.x * 1000.0 - _MaskInfo.x) / _MaskInfo.z;
	float vOffset = (v.uv.y * 1500.0 - _MaskInfo.y) / _MaskInfo.w;
	float2 uv_offset = float2(uOffset, vOffset);
	o.uv = uv_offset;
	float sceneType = v.vertex.w;
	float4 pos;
	if(sceneType > 0.1)
	{
		float scene2DRectWidth = 0.2;
		float scene2DRectHeight = 0.3;
		float xCenter = 0.1/scene2DRectWidth;
		float yCenter = 1.0 - 0.12/scene2DRectHeight;
		float2 uv2pos;
		uv2pos.x = (v.uv.x - xCenter) * scene2DRectWidth;
		uv2pos.y = ( v.uv.y - yCenter) * scene2DRectHeight;
		pos = float4(uv2pos.x, -uv2pos.y, 0.0,1.0);
		pos = ObjectToClipPos(pos);
		o.screenPos = ComputeScreenPos(pos);
		o.reliability = 1.0;
		if(_UseMask > 0.1)
		{
			o.maskuv = float2(v.uv.x*1000.0 - _MaskScaleInfo.x, v.uv.y*1500.0 - _MaskScaleInfo.y) / float2(_MaskScaleInfo.z, _MaskScaleInfo.w);
		}
	}
	else
	{
		o.reliability = v.vertex.z;
		pos = float4(v.vertex.x,v.vertex.y,0.0,1.0);
		pos = mul(LOCALWORLD_TRANSFORM, pos);
		o.screenPos = ComputeScreenPos(pos);
		if(_UseMask > 0.1)
		{
			o.maskuv = o.screenPos.xy / o.screenPos.w;;
		}
	}

	o.vertex = UniformNDC(pos);
	return o;
}

float _Opacity;
float _Strength;

float3 RGBtoHCV(float3 rgb)
{
	float4 p = (rgb.g < rgb.b) ? float4(rgb.bg, -1.0, 2.0/3.0) : float4(rgb.gb, 0.0, -1.0/3.0);
	float4 q = (rgb.r < p.x) ? float4(p.xyw, rgb.r) : float4(rgb.r, p.yzx);
	
   	float c = q.x - min(q.w, q.y);
	float h = abs((q.w - q.y) / (6.0*c + 1e-7) + q.z);
	float v = q.x;
	
	return float3(h, c, v);
}

float3 RGBToHSL(float3 rgb)
{
	float3 hcv = RGBtoHCV(rgb);
	float lum = hcv.z - hcv.y * 0.5;
	float sat = hcv.y / (1.0 - abs(2.0*lum - 1.0) + 1e-7);
	
	return float3(hcv.x, sat, lum);
}

float3 HUEtoRGB(float hue)
{
	float r = abs(6.0*hue - 3.0) - 1.0;
	float g = 2.0 - abs(6.0*hue - 2.0);
	float b = 2.0 - abs(6.0*hue - 4.0);
	float3 blackColor = float3(0.0, 0.0, 0.0);
	float3 whiteColor = float3(1.0, 1.0, 1.0);
	return clamp(float3(r, g, b), blackColor, whiteColor);
}

float3 HSLToRGB(float3 hsl)
{
	float3 rgb = HUEtoRGB(hsl.x);
	float c = (1.0 - abs(2.0 * hsl.z - 1.0)) * hsl.y;
	rgb = (rgb - 0.5) * c + hsl.z;
	return rgb;
}

float4 GetSourceColor(v2f i, float4 fbColor)
{
#ifdef FRAMEBUFFER_FETCH 
	return fbColor; 
#else
	float2 uvCoord = i.screenPos.xy / i.screenPos.w;
	float4 srcColor = tex2D(TEXTURE_GRAP, uvCoord);
	return srcColor;
#endif
}

float3 BlendExclusion(float3 base, float3 blend)
{
	return (base + blend - 2.0 * (base) * (blend));
}

float BlendOverlayf(float base, float blend)
{
    return (base < 0.5 ? (2.0 * (base) * (blend)) : (1.0 - 2.0 * (1.0 - (base)) * (1.0 - (blend))));
}

float3 BlendOverlay(float3 base, float3 blend)
{
	return float3(BlendOverlayf(base.r, blend.r), BlendOverlayf(base.g, blend.g), BlendOverlayf(base.b, blend.b));
}

float3 BlendHardLight(float3 base, float3 blend)
{
	return BlendOverlay(blend, base);
}

float BlendSoftLightf(float base, float blend)
{
    return ((1.0 - 2.0 * (blend))*(base)*(base) + 2.0 * (base) * (blend));
}
float BlendColorDodgef(float base, float blend)
{
    return ((blend == 1.0) ? blend : min((base) / (1.0 - (blend)), 1.0));
}

float BlendColorBurnf(float base, float blend)
{
    return ((blend == 0.0) ? blend : max((1.0 - ((1.0 - (base)) / (blend))), 0.0));
}

float BlendVividLightf(float base, float blend)
{
    if(blend < 0.5)
	{
        return BlendColorBurnf(base, 2.0 * blend);
    }
    else
	{
        return BlendColorDodgef(base, 2.0 * (blend - 0.5));
    }
}

float3 BlendVividLight(float3 base, float3 blend)
{
	return float3(BlendVividLightf(base.r, blend.r), BlendVividLightf(base.g, blend.g), BlendVividLightf(base.b, blend.b));
}

float3 BlendColorBurn(float3 base, float3 blend)
{
	return float3(BlendColorBurnf(base.r, blend.r), BlendColorBurnf(base.g, blend.g), BlendColorBurnf(base.b, blend.b));
}

float3 BlendColorDodge(float3 base, float3 blend)
{
	return float3(BlendColorDodgef(base.r, blend.r), BlendColorDodgef(base.g, blend.g), BlendColorDodgef(base.b, blend.b));
}

float3 BlendSoftLight(float3 base, float3 blend)
{
	return float3(BlendSoftLightf(base.r, blend.r),BlendSoftLightf(base.g, blend.g),BlendSoftLightf(base.b, blend.b));
}

float BlendHardMixf(float base, float blend)
{
    if(BlendVividLightf(base, blend) < 0.5)
	{
        return 0.0;
    }
    else
	{
        return 1.0;
    }
}

float3 BlendHardMix(float3 base, float3 blend)
{
	return float3(BlendHardMixf(base.r, blend.r), BlendHardMixf(base.g, blend.g), BlendHardMixf(base.b, blend.b));
}

float BlendLightenf(float base, float blend)
{
    return max(blend, base);
}

float BlendDarkenf(float base, float blend)
{
    return min(blend, base);
}

float BlendPinLightf(float base, float blend) 
{
    if(blend < 0.5)
	{
        return BlendDarkenf(base, 2.0 * blend);
    }
    else
	{
        return BlendLightenf(base, 2.0 * (blend - 0.5));
    }
}

float3 BlendPinLight(float3 base, float3 blend)
{
	return float3(BlendPinLightf(base.r, blend.r), BlendPinLightf(base.g, blend.g), BlendPinLightf(base.b, blend.b));
}

float BlendLinearBurnf(float base, float blend)
{
    return max(base + blend - 1.0, 0.0);
}

float BlendLinearDodgef(float base, float blend)
{
    return min(base + blend, 1.0);
}

float BlendLinearLightf(float base, float blend)
{
    if(blend < 0.5)
	{
        return BlendLinearBurnf(base, 2.0 * blend);
    }
    else 
	{
        return BlendLinearDodgef(base, 2.0 * (blend - 0.5));
    }
}

float3 BlendLinearLight(float3 base, float3 blend)
{
	return float3(BlendLinearLightf(base.r, blend.r), BlendLinearLightf(base.g, blend.g), BlendLinearLightf(base.b, blend.b));
}

float3 BlendDiff(float3 base, float3 blend)
{
	return abs(base - blend);
}

float3 BlendLinearBurn(float3 base, float3 blend)
{
	return float3(BlendLinearBurnf(base.r, blend.r), BlendLinearBurnf(base.g, blend.g), BlendLinearBurnf(base.b, blend.b));
}

float3 BlendSub(float3 base, float3 blend)
{
	return max(base - blend, float3(0.0, 0.0, 0.0));
}

#ifdef FRAMEBUFFER_FETCH
void frag(v2f i, inout float4 fbColor:COLOR0)
#else
fixed4 frag(v2f i) : SV_Target
#endif
{
	float4 param1 = float4(0.0, 0.0, i.uv.x, i.uv.y);
	float4 param2 = float4(i.uv.x, i.uv.y, 1.0, 1.0);
	float alphaValue = 0.0;
	if(i.uv.x>0.0&&i.uv.x<1.0&&i.uv.y>0.0&&i.uv.y<1.0) 
	{
	    alphaValue = 1.0;
	}

	// sample the texture
	float4 materialColor = tex2D(_MainTex, i.uv);
	float factor = 1.0;
	factor = materialColor.a * _Strength * _Opacity * i.reliability * alphaValue;
	float3 blendColor = materialColor.rgb;

	if(_UseMask > 0.1)
	{
		if(i.isEditor > 0.1)
		{
			factor *= (tex2D(_EditorMaskMap, i.maskuv)).r;
		}
		else
		{
			factor *= (tex2D(_MaskMap, i.maskuv)).r;
		}
	}

	float4 resultColor = float4(1.0, 1.0, 1.0, 1.0);

#ifdef FRAMEBUFFER_FETCH 
	float4 fbc = fbColor;
#else
	float4 fbc = resultColor;
#endif

	#ifdef BLEND_NORMAL
		resultColor = float4(blendColor.r, blendColor.g, blendColor.b, factor);
	#elif BLEND_MULTIPLY
		float3 whiteColor = float3(1.0, 1.0, 1.0);
		blendColor = whiteColor - factor * (whiteColor - blendColor);
		resultColor = float4(blendColor.r, blendColor.g, blendColor.b, 1.0);
	#elif BLEND_SCREEN
		blendColor = factor * blendColor;
		resultColor = float4(blendColor.r, blendColor.g, blendColor.b, 1.0);
	#elif BLEND_Hue
		float4 srcColor = GetSourceColor(i, fbc);
		float3 baseHSL = RGBToHSL(srcColor.rgb);
		float3 blendHSL = RGBToHSL(blendColor.rgb);
		float3 resHSLColor = HSLToRGB(float3(blendHSL.r, baseHSL.g, baseHSL.b));
		resultColor.rgb = lerp(srcColor, resHSLColor, factor);
		resultColor.a = 1.0;
	#elif BLEND_SATURATION
		float4 srcColor = GetSourceColor(i, fbc);
		float3 baseHSL = RGBToHSL(srcColor.rgb);
		float3 blendHSL = RGBToHSL(blendColor.rgb);
		float3 resHSLColor = HSLToRGB(float3(baseHSL.r, blendHSL.g, baseHSL.b));
		resultColor.rgb = lerp(srcColor, resHSLColor, factor);
		resultColor.a = 1.0;
	#elif BLEND_LUMINOSITY
		float4 srcColor = GetSourceColor(i, fbc);
		float3 baseHSL = RGBToHSL(srcColor.rgb);
		float3 blendHSL = RGBToHSL(blendColor.rgb);
		float3 resHSLColor = HSLToRGB(float3(baseHSL.r, baseHSL.g, blendHSL.b));
		resultColor.rgb = lerp(srcColor, resHSLColor, factor);
		resultColor.a = 1.0;
	#elif BLEND_COLOR
		float4 srcColor = GetSourceColor(i, fbc);
		float3 baseHSL = RGBToHSL(srcColor.rgb);
		float3 blendHSL = RGBToHSL(blendColor.rgb);
		float3 resHSLColor = HSLToRGB(float3(blendHSL.r, blendHSL.g, baseHSL.b));
		resultColor.rgb = lerp(srcColor, resHSLColor, factor);
		resultColor.a = 1.0;
	#elif BLEND_BLEND
		float4 srcColor = GetSourceColor(i, fbc);
		float imgIntensity = dot(float3(0.2990,0.5870,0.1140), srcColor.rgb);
		float3 resIntColor = (imgIntensity * 1.68) * blendColor.rgb;
		resultColor.rgb = lerp(srcColor, resIntColor, factor);
		resultColor.a = 1.0;
	#elif BLEND_EXCLUSION
		float4 base = GetSourceColor(i, fbc);
		float4 blend = materialColor;
		float3 resColor = BlendExclusion(base, blend);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	#elif BLEND_HARDLIGHT
		float4 base = GetSourceColor(i, fbc);
		float4 blend = materialColor;
		float3 resColor = BlendHardLight(base.rgb, blend.rgb);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	#elif BLEND_VIVIDLIGHT
		float4 base = GetSourceColor(i, fbc);
		float4 blend = materialColor;
		float3 resColor = BlendVividLight(base.rgb, blend.rgb);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	#elif BLEND_OVERLAY
		float4 base = GetSourceColor(i, fbc);
		float4 blend = materialColor;
		float3 resColor = BlendOverlay(base.rgb, blend.rgb);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	#elif BLEND_COLORBURN
		float4 base = GetSourceColor(i, fbc);
		float4 blend = materialColor;
		float3 resColor = BlendColorBurn(base.rgb, blend.rgb);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	#elif BLEND_COLORDODGE
		float4 base = GetSourceColor(i, fbc);
		float4 blend = materialColor;
		float3 resColor = BlendColorDodge(base.rgb, blend.rgb);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	#elif BLEND_SOFTLIGHT
		float4 base = GetSourceColor(i, fbc);
		float4 blend = materialColor;
		float3 resColor = BlendSoftLight(base.rgb, blend.rgb);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	#elif BLEND_HARDMIX
		float4 base = GetSourceColor(i, fbc);
		float4 blend = materialColor;
		float3 resColor = BlendHardMix(base.rgb, blend.rgb);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	#elif BLEND_PINLIGHT
		float4 base = GetSourceColor(i, fbc);
		float4 blend = materialColor;
		float3 resColor = BlendPinLight(base.rgb, blend.rgb);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	#elif BLEND_LINEARLIGHT
		float4 base = GetSourceColor(i, fbc);
		float4 blend = materialColor;
		float3 resColor = BlendLinearLight(base.rgb, blend.rgb);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	#elif BLEND_DIFF
		float4 base = GetSourceColor(i, fbc);
		float4 blend = materialColor;
		float3 resColor = BlendDiff(base.rgb, blend.rgb);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	#elif BLEND_LINEARBURN
		float4 base = GetSourceColor(i, fbc);
		float4 blend = materialColor;
		float3 resColor = BlendLinearBurn(base.rgb, blend.rgb);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	#elif BLEND_SUB
		float4 base = GetSourceColor(i, fbc);
		float4 blend = materialColor;
		float3 resColor = BlendSub(base.rgb, blend.rgb);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	#elif BLEND_LUT
		float4 srcColor = GetSourceColor(i, fbc);
		float3 resColor;
		resColor.r = tex2D(_LutMap, float2(blendColor.r, srcColor.r)).r;
		resColor.g = tex2D(_LutMap, float2(blendColor.g, srcColor.g)).g;
		resColor.b = tex2D(_LutMap, float2(blendColor.b, srcColor.b)).b;

		resultColor.rgb = lerp(srcColor, resColor, factor);
		resultColor.a = 1.0;
	#endif

#ifndef FRAMEBUFFER_FETCH
	return resultColor;
#else
	fbColor = resultColor;
#endif
}
ENDCG
#END
