#DEFPARAMS
TEXTURE_DIFFUSE = {"TEXTURE_DIFFUSE", TEXTURE2D, "white" },
TEXTURE_TO_COLOR = {"TEXTURE_TO_COLOR", TEXTURE2D, "white" },
TEXTURE_MASK = {"TEXTURE_MASK", TEXTURE2D, "white" },
BIRGHTNESS = {"BIRGHTNESS", FLOAT, "0.83"},
STRENGTH = {"STRENGTH", FLOAT, "0.8"},
MASKRATIO = {"MASKRATIO", FLOAT, "1.0"},
ISPURECOLOR = {"ISPURECOLOR", FLOAT, "1.0"},
isEditor = {"isEditor", FLOAT, "0.0"},
PURECOLOR = { "PURECOLOR", VEC4, "0.0,0.0,0.0,0.0"},
#END

#DEFTAG
ShaderName = "haircolor_changecolor_kuai"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 in_Position : POSITION;
	float2 in_Coordinate : TEXCOORD0;
};

struct v2f
{
	float2 out_Coordinate : TEXCOORD0;
    float2 out_Coordinate2: TEXCOORD1;
    float4 screenPos : TEXCOORD2;
	float4 vertex : SV_POSITION;
};

float isEditor;

v2f vert(appdata v)
{
	v2f o;
    float4 pos;
    if(isEditor > 0.1)
	{
		float scene2DRectWidth = 0.2;
		float scene2DRectHeight = 0.3;
		float xCenter = 0.1/scene2DRectWidth;
		float yCenter = 1.0 - 0.12/scene2DRectHeight;
		float2 uv2pos;
		uv2pos.x = (v.in_Coordinate.x - 0.5) * scene2DRectWidth;
		uv2pos.y = ( v.in_Coordinate.y - yCenter) * scene2DRectHeight;
		pos = float4(uv2pos.x, -uv2pos.y, 0.0,1.0);
		pos = ObjectToClipPos(pos);
		o.screenPos = ComputeScreenPos(pos);
        o.vertex = UniformNDC(pos);
        o.out_Coordinate = v.in_Coordinate.xy;
        o.out_Coordinate2 = o.screenPos.xy / o.screenPos.w;
	}
	else
	{
		pos = float4(v.in_Position.x,v.in_Position.y,0.0,1.0);
		//pos = mul(LOCALWORLD_TRANSFORM, pos);
		o.screenPos = ComputeScreenPos(pos);
        o.vertex = UniformNDC(pos);
        o.out_Coordinate = o.screenPos.xy / o.screenPos.w;
        o.out_Coordinate2 = o.screenPos.xy / o.screenPos.w;
    }
	
	//o.vertex = UniformNDC(v.in_Position);
    //o.vertex = UniformNDC(pos);
	//o.out_Coordinate = v.in_Coordinate.xy;
    //o.out_Coordinate2 = (float2(o.vertex.x, -o.vertex.y) / o.vertex.w + 1.0) / 2.0;
	return o;
}

sampler2D TEXTURE_DIFFUSE;
sampler2D TEXTURE_TO_COLOR;
sampler2D TEXTURE_MASK;
float BIRGHTNESS;
float STRENGTH;
float MASKRATIO;

float ISPURECOLOR;
float4 PURECOLOR;

float rgbToL(float4 RGBColor)
{
    float3 rgb = RGBColor.xyz;  // input is 0-1
    float y = 0.212671*rgb.x + 0.715160*rgb.y + 0.072169*rgb.z;
    float l  = y > 0.008856 ? (116.0 * pow(y,1.0/3.0) - 16.0) : (903.3 * y); 
    l = l / 100.0 * 255.0;    //output 0-255
    return l;
}

float4 frag(v2f i) : SV_Target
{
	#define in_SrcTexture TEXTURE_DIFFUSE
	#define in_ToColorTex TEXTURE_TO_COLOR
	#define in_ColorMask TEXTURE_MASK
    #define mask_ratio MASKRATIO

	float2 in_TexCoordinate = i.out_Coordinate;
    //float2 in_TexCoordinate2 = i.out_Coordinate2;
	float brightness = BIRGHTNESS;
    float strength = STRENGTH;
    float2 uvCoord = i.out_Coordinate2; //i.screenPos.xy / i.screenPos.w;

    float4 mask = tex2D(in_ColorMask, float2(in_TexCoordinate.x, in_TexCoordinate.y));
    float4 img_color = tex2D(TEXTURE_GRAP, float2(uvCoord.x, uvCoord.y));
    float4 hair_color = tex2D(in_ToColorTex, float2(in_TexCoordinate.x, in_TexCoordinate.y))*1.5;
    int color_mode = int(ISPURECOLOR + 0.5);
    if (color_mode == 1)
    {
        hair_color = PURECOLOR;// float4(0.5,0.0,0.0,1.0);//PURECOLOR;
    }

    float l = rgbToL(img_color) / brightness;
    float mask_a = clamp((mask.a) * mask_ratio , 0.0, 1.0);
    l = (1.0 / (1.0 + exp(-1.0*(l/200.0)))-0.5) * 800.0;
    if (l <= 0.0)
    {
        l = rgbToL(img_color);
    }
    l = l * mask_a + 255.0 * (1.0 - mask_a);
    float l_alpha = (img_color.r+img_color.g+img_color.b)/3.0;
    float _strength = clamp((strength)*(1.0+l_alpha),0.0,1.0);

    float4 c = (hair_color * (_strength) + img_color * (1-_strength)) * mask_a + img_color * (1.0 - mask_a); //get new reflector
    float4 result = l * c  / 255.0;
    result = clamp(result, float4(0.0,0.0,0.0,0.0), float4(1.0,1.0,1.0,1.0));
    float4 outColor = float4(result.rgb,1);
  //outColor = float4(0,0,0,0);

  return outColor;
}

ENDCG
#END
