#DEFPARAMS
TEXTURE_DIFFUSE = {"TEXTURE_DIFFUSE", TEXTURE2D, "white" },
TEXTURE_TO_COLOR = {"TEXTURE_TO_COLOR", TEXTURE2D, "white" },
_LutMap = {"Lut Map", TEXTURE2D, "white" },
TEXTURE_MASK = {"TEXTURE_MASK", TEXTURE2D, "white" },
BLEND_MODE = {"BLEND_MODE", FLOAT, "0.0"},
BlendOpacity = {"Blend_Opacity", FLOAT, "1.0"},
MASKRATIO = {"MASKRATIO", FLOAT, "1.0"},
ISPURECOLOR = {"ISPURECOLOR", FLOAT, "1.0"},
isEditor = {"isEditor", FLOAT, "0.0"},
PURECOLOR = { "PURECOLOR", VEC4, "0.0,0.0,0.0,0.0"},
#END

#DEFTAG
ShaderName = "haircolor_changecolor_base"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
//#include "blendfunc.inc"

struct appdata
{
	float4 in_Position : POSITION;
	float2 in_Coordinate : TEXCOORD0;
};

struct v2f
{
	float2 out_Coordinate : TEXCOORD0;
	float2 out_Coordinate2: TEXCOORD1;
	float4 screenPos : TEXCOORD2;
	float4 vertex : SV_POSITION;
};

float isEditor;

v2f vert(appdata v)
{
	v2f o;
	float4 pos;
    if(isEditor > 0.1)
	{
		float scene2DRectWidth = 0.2;
		float scene2DRectHeight = 0.3;
		float xCenter = 0.1/scene2DRectWidth;
		float yCenter = 1.0 - 0.12/scene2DRectHeight;
		float2 uv2pos;
		uv2pos.x = (v.in_Coordinate.x - 0.5) * scene2DRectWidth;
		uv2pos.y = ( v.in_Coordinate.y - yCenter) * scene2DRectHeight;
		pos = float4(uv2pos.x, -uv2pos.y, 0.0,1.0);
		pos = ObjectToClipPos(pos);
		o.screenPos = ComputeScreenPos(pos);
		o.vertex = UniformNDC(pos);
        o.out_Coordinate = v.in_Coordinate.xy;
        o.out_Coordinate2 = o.screenPos.xy / o.screenPos.w;
	}
	else
	{
		pos = float4(v.in_Position.x,v.in_Position.y,0.0,1.0);
		o.screenPos = ComputeScreenPos(pos);
		o.vertex = UniformNDC(pos);
        o.out_Coordinate = o.screenPos.xy / o.screenPos.w;
        o.out_Coordinate2 = o.screenPos.xy / o.screenPos.w;
	}

	// o.vertex = UniformNDC(pos);
	// o.out_Coordinate = v.in_Coordinate.xy;
    // o.out_Coordinate2 = (float2(o.vertex.x, -o.vertex.y) / o.vertex.w + 1.0) / 2.0;
	return o;
}

sampler2D TEXTURE_DIFFUSE;
sampler2D TEXTURE_TO_COLOR;
sampler2D TEXTURE_MASK;
sampler2D _LutMap;
float BLEND_MODE;
float BlendOpacity;
float MASKRATIO;

float ISPURECOLOR;
float4 PURECOLOR;


float3 RGBtoHCV(float3 rgb)
{
	float4 p = (rgb.g < rgb.b) ? float4(rgb.bg, -1.0, 2.0/3.0) : float4(rgb.gb, 0.0, -1.0/3.0);
	float4 q = (rgb.r < p.x) ? float4(p.xyw, rgb.r) : float4(rgb.r, p.yzx);
	
   	float c = q.x - min(q.w, q.y);
	float h = abs((q.w - q.y) / (6.0*c + 1e-7) + q.z);
	float v = q.x;
	
	return float3(h, c, v);
}

float3 RGBToHSL(float3 rgb)
{
	float3 hcv = RGBtoHCV(rgb);
	float lum = hcv.z - hcv.y * 0.5;
	float sat = hcv.y / (1.0 - abs(2.0*lum - 1.0) + 1e-7);
	
	return float3(hcv.x, sat, lum);
}

float3 HUEtoRGB(float hue)
{
	float r = abs(6.0*hue - 3.0) - 1.0;
	float g = 2.0 - abs(6.0*hue - 2.0);
	float b = 2.0 - abs(6.0*hue - 4.0);
	float3 blackColor = float3(0.0, 0.0, 0.0);
	float3 whiteColor = float3(1.0, 1.0, 1.0);
	return clamp(float3(r, g, b), blackColor, whiteColor);
}

float3 HSLToRGB(float3 hsl)
{
	float3 rgb = HUEtoRGB(hsl.x);
	float c = (1.0 - abs(2.0 * hsl.z - 1.0)) * hsl.y;
	rgb = (rgb - 0.5) * c + hsl.z;
	return rgb;
}

float3 BlendExclusion(float3 base, float3 blend)
{
	return (base + blend - 2.0 * (base) * (blend));
}

float BlendOverlayf(float base, float blend)
{
    return (base < 0.5 ? (2.0 * (base) * (blend)) : (1.0 - 2.0 * (1.0 - (base)) * (1.0 - (blend))));
}

float3 BlendOverlay(float3 base, float3 blend)
{
	return float3(BlendOverlayf(base.r, blend.r), BlendOverlayf(base.g, blend.g), BlendOverlayf(base.b, blend.b));
}

float3 BlendHardLight(float3 base, float3 blend)
{
	return BlendOverlay(blend, base);
}

float BlendSoftLightf(float base, float blend)
{
    return ((1.0 - 2.0 * (blend))*(base)*(base) + 2.0 * (base) * (blend));
}
float BlendColorDodgef(float base, float blend)
{
    return ((blend == 1.0) ? blend : min((base) / (1.0 - (blend)), 1.0));
}

float BlendColorBurnf(float base, float blend)
{
    return ((blend == 0.0) ? blend : max((1.0 - ((1.0 - (base)) / (blend))), 0.0));
}

float BlendVividLightf(float base, float blend)
{
    if(blend < 0.5)
	{
        return BlendColorBurnf(base, 2.0 * blend);
    }
    else
	{
        return BlendColorDodgef(base, 2.0 * (blend - 0.5));
    }
}

float3 BlendVividLight(float3 base, float3 blend)
{
	return float3(BlendVividLightf(base.r, blend.r), BlendVividLightf(base.g, blend.g), BlendVividLightf(base.b, blend.b));
}

float3 BlendColorBurn(float3 base, float3 blend)
{
	return float3(BlendColorBurnf(base.r, blend.r), BlendColorBurnf(base.g, blend.g), BlendColorBurnf(base.b, blend.b));
}

float3 BlendColorDodge(float3 base, float3 blend)
{
	return float3(BlendColorDodgef(base.r, blend.r), BlendColorDodgef(base.g, blend.g), BlendColorDodgef(base.b, blend.b));
}

float3 BlendSoftLight(float3 base, float3 blend)
{
	return float3(BlendSoftLightf(base.r, blend.r),BlendSoftLightf(base.g, blend.g),BlendSoftLightf(base.b, blend.b));
}

float BlendHardMixf(float base, float blend)
{
    if(BlendVividLightf(base, blend) < 0.5)
	{
        return 0.0;
    }
    else
	{
        return 1.0;
    }
}

float3 BlendHardMix(float3 base, float3 blend)
{
	return float3(BlendHardMixf(base.r, blend.r), BlendHardMixf(base.g, blend.g), BlendHardMixf(base.b, blend.b));
}

float BlendLightenf(float base, float blend)
{
    return max(blend, base);
}

float BlendDarkenf(float base, float blend)
{
    return min(blend, base);
}

float BlendPinLightf(float base, float blend) 
{
    if(blend < 0.5)
	{
        return BlendDarkenf(base, 2.0 * blend);
    }
    else
	{
        return BlendLightenf(base, 2.0 * (blend - 0.5));
    }
}

float3 BlendPinLight(float3 base, float3 blend)
{
	return float3(BlendPinLightf(base.r, blend.r), BlendPinLightf(base.g, blend.g), BlendPinLightf(base.b, blend.b));
}

float BlendLinearBurnf(float base, float blend)
{
    return max(base + blend - 1.0, 0.0);
}

float BlendLinearDodgef(float base, float blend)
{
    return min(base + blend, 1.0);
}

float BlendLinearLightf(float base, float blend)
{
    if(blend < 0.5)
	{
        return BlendLinearBurnf(base, 2.0 * blend);
    }
    else 
	{
        return BlendLinearDodgef(base, 2.0 * (blend - 0.5));
    }
}

float3 BlendLinearLight(float3 base, float3 blend)
{
	return float3(BlendLinearLightf(base.r, blend.r), BlendLinearLightf(base.g, blend.g), BlendLinearLightf(base.b, blend.b));
}

float3 BlendDiff(float3 base, float3 blend)
{
	return abs(base - blend);
}

float3 BlendLinearBurn(float3 base, float3 blend)
{
	return float3(BlendLinearBurnf(base.r, blend.r), BlendLinearBurnf(base.g, blend.g), BlendLinearBurnf(base.b, blend.b));
}

float3 BlendSub(float3 base, float3 blend)
{
	return max(base - blend, float3(0.0, 0.0, 0.0));
}


float4 frag(v2f i) : SV_Target
{
	#define in_SrcTexture TEXTURE_DIFFUSE
	#define in_ToColorTex TEXTURE_TO_COLOR
	#define in_ColorMask TEXTURE_MASK
	#define in_blend_mode BLEND_MODE
	#define in_blend_opacity BlendOpacity
	#define mask_ratio MASKRATIO

	float2 in_TexCoordinate = i.out_Coordinate;
	float2 in_TexCoordinate2 = i.out_Coordinate2;

	float2 uvCoord = i.out_Coordinate2;

	float4 mask = tex2D(in_ColorMask, float2(in_TexCoordinate.x, in_TexCoordinate.y));
    float4 img_color = tex2D(TEXTURE_GRAP, float2(uvCoord.x, uvCoord.y));
    float4 hair_color = tex2D(in_ToColorTex, float2(in_TexCoordinate.x, in_TexCoordinate.y));

	int color_mode = int(ISPURECOLOR + 0.5);
	if (color_mode == 1)
	{
		hair_color = PURECOLOR;// float4(0.5,0.0,0.0,1.0);//PURECOLOR;
	}

	float mask_a = clamp(mask.a * mask_ratio , 0.0, 1.0);
    float4 resultColor;
    int blend_mode = int(in_blend_mode + 0.5);
	float3 blendR = float3(1.0,0.0,0.0);
	float factor = BlendOpacity * mask_a;
	float3 blendColor = hair_color.rgb;
	float4 srcColor = img_color;
	float4 base = srcColor;
	float3 blend = float4(hair_color.rgb,mask_a);

	if (blend_mode == 1)//#ifdef BLEND_NORMAL
	{
		resultColor = float4(blendColor.r, blendColor.g, blendColor.b, mask_a);
	}
	else if (blend_mode == 2) //#elif BLEND_MULTIPLY
	{
		float3 whiteColor = float3(1.0, 1.0, 1.0);
		blendColor = whiteColor - factor * (whiteColor - blendColor);
		resultColor = float4(blendColor.r, blendColor.g, blendColor.b, mask_a);
	}
	else if (blend_mode == 3) //#elif BLEND_SCREEN
	{
		blendColor = factor * blendColor;
		resultColor = float4(blendColor.r, blendColor.g, blendColor.b, mask_a);
	}
	else if (blend_mode == 4) //#elif BLEND_Hue
	{
		float3 baseHSL = RGBToHSL(srcColor.rgb);
		float3 blendHSL = RGBToHSL(blendColor.rgb);
		float3 resHSLColor = HSLToRGB(float3(blendHSL.r, baseHSL.g, baseHSL.b));
		resHSLColor = clamp(resHSLColor, float3(0.0,0.0,0.0), float3(1.0,1.0,1.0));
		resultColor.rgb = lerp(srcColor, resHSLColor, factor);
		resultColor.a = 1.0;
	}
	else if (blend_mode == 5) //#elif BLEND_SATURATION
	{
		float3 baseHSL = RGBToHSL(srcColor.rgb);
		float3 blendHSL = RGBToHSL(blendColor.rgb);
		float3 resHSLColor = HSLToRGB(float3(baseHSL.r, blendHSL.g, baseHSL.b));
		resHSLColor = clamp(resHSLColor, float3(0.0,0.0,0.0), float3(1.0,1.0,1.0));
		resultColor.rgb = lerp(srcColor, resHSLColor, factor);
		resultColor.a = 1.0;
	}
	else if (blend_mode == 6) //#elif BLEND_LUMINOSITY
	{
		float3 baseHSL = RGBToHSL(srcColor.rgb);
		float3 blendHSL = RGBToHSL(blendColor.rgb);
		float3 resHSLColor = HSLToRGB(float3(baseHSL.r, baseHSL.g, blendHSL.b));
		resHSLColor = clamp(resHSLColor, float3(0.0,0.0,0.0), float3(1.0,1.0,1.0));
		resultColor.rgb = lerp(srcColor, resHSLColor, factor);
		resultColor.a = 1.0;
	}
	else if (blend_mode == 7) //#elif BLEND_COLOR
	{
		float3 baseHSL = RGBToHSL(srcColor.rgb);
		float3 blendHSL = RGBToHSL(blendColor.rgb);
		float3 resHSLColor = HSLToRGB(float3(blendHSL.r, blendHSL.g, baseHSL.b));
		resHSLColor = clamp(resHSLColor, float3(0.0,0.0,0.0), float3(1.0,1.0,1.0));
		resultColor.rgb = lerp(srcColor, resHSLColor, factor);
		resultColor.a = 1.0;
	}
	else if (blend_mode == 8) //#elif BLEND_BLEND
	{
		float imgIntensity = dot(float3(0.2990,0.5870,0.1140), srcColor.rgb);
		float3 resIntColor = (imgIntensity * 1.68) * blendColor.rgb;
		resultColor.rgb = lerp(srcColor, resIntColor, factor);
		resultColor.a = 1.0;
	}
	else if (blend_mode == 9) //#elif BLEND_EXCLUSION
	{
		float3 resColor = BlendExclusion(base, blend);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	}
	else if (blend_mode == 10) //#elif BLEND_HARDLIGHT
	{
		float3 resColor = BlendHardLight(base.rgb, blend.rgb);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	}
	else if (blend_mode == 11) //#elif BLEND_VIVIDLIGHT
	{
		float3 resColor = BlendVividLight(base.rgb, blend.rgb);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	}
	else if (blend_mode == 12) //#elif BLEND_OVERLAY
	{
		float3 resColor = BlendOverlay(base.rgb, blend.rgb);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	}
	else if (blend_mode == 13) //#elif BLEND_COLORBURN
	{
		float3 resColor = BlendColorBurn(base.rgb, blend.rgb);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	}
	else if (blend_mode == 14) //#elif BLEND_COLORDODGE
	{
		float3 resColor = BlendColorDodge(base.rgb, blend.rgb);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	}
	else if (blend_mode == 15) //#elif BLEND_SOFTLIGHT
	{
		float3 resColor = BlendSoftLight(base.rgb, blend.rgb);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	}
	else if (blend_mode == 16) //#elif BLEND_HARDMIX
	{
		float3 resColor = BlendHardMix(base.rgb, blend.rgb);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	}
	else if (blend_mode == 17) //#elif BLEND_PINLIGHT
	{
		float3 resColor = BlendPinLight(base.rgb, blend.rgb);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	}
	else if (blend_mode == 18) //#elif BLEND_LINEARLIGHT
	{
		float3 resColor = BlendLinearLight(base.rgb, blend.rgb);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	}
	else if (blend_mode == 19) //#elif BLEND_DIFF
	{
		float3 resColor = BlendDiff(base.rgb, blend.rgb);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	}
	else if (blend_mode == 20) //#elif BLEND_LINEARBURN
	{
		float3 resColor = BlendLinearBurn(base.rgb, blend.rgb);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	}
	else if (blend_mode == 21) //#elif BLEND_SUB
	{
		float3 resColor = BlendSub(base.rgb, blend.rgb);
		resultColor.rgb = lerp(base.rgb, resColor.rgb, factor);
		resultColor.a = 1.0;
	}
	else if (blend_mode >= 22) //#elif BLEND_LUT
	{
		float3 resColor;
		resColor.r = tex2D(_LutMap, float2(blendColor.r, srcColor.r)).r;
		resColor.g = tex2D(_LutMap, float2(blendColor.g, srcColor.g)).g;
		resColor.b = tex2D(_LutMap, float2(blendColor.b, srcColor.b)).b;

		resultColor.rgb = lerp(srcColor, resColor, factor);
		resultColor.a = 1.0;
	}
	// if (in_blend_opacity >= 1.0){
	// 	blendR = blend(blend_mode,img_color, outColor);
	// }else {
	// 	blendR = blend(blend_mode, img_color, outColor, in_blend_opacity );
	// }
    // outColor = float4(blendR.rgb, 1);
    //return outColor;
	return resultColor;
}

ENDCG
#END
