function DefineParams()
	Properties = 
	{
		
TEXTURE_DIFFUSE = {"TEXTURE_DIFFUSE", TEXTURE2D, "white" },
TEXTURE_TO_COLOR = {"TEXTURE_TO_COLOR", TEXTURE2D, "white" },
_LutMap = {"Lut Map", TEXTURE2D, "white" },
TEXTURE_MASK = {"TEXTURE_MASK", TEXTURE2D, "white" },
BLEND_MODE = {"BLEND_MODE", FLOAT, "0.0"},
BlendOpacity = {"Blend_Opacity", FLOAT, "1.0"},
MASKRATIO = {"MASKRATIO", FLOAT, "1.0"},
ISPURECOLOR = {"ISPURECOLOR", FLOAT, "1.0"},
isEditor = {"isEditor", FLOAT, "0.0"},
PURECOLOR = { "PURECOLOR", VEC4, "0.0,0.0,0.0,0.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "haircolor_changecolor_base"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "isEditor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_TO_COLOR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_MASK",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_LutMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BLEND_MODE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BlendOpacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASKRATIO",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ISPURECOLOR",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PURECOLOR",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float isEditor;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord0.xy;
  highp vec2 tmpvar_3;
  highp vec2 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  if ((isEditor > 0.1)) {
    highp vec2 uv2pos_7;
    uv2pos_7.x = ((_glesMultiTexCoord0.x - 0.5) * 0.2);
    uv2pos_7.y = ((_glesMultiTexCoord0.y - 0.6) * 0.3);
    highp vec4 tmpvar_8;
    tmpvar_8.zw = vec2(0.0, 1.0);
    tmpvar_8.x = uv2pos_7.x;
    tmpvar_8.y = -(uv2pos_7.y);
    highp vec4 tmpvar_9;
    highp vec4 tmpvar_10;
    tmpvar_10.w = 1.0;
    tmpvar_10.xyz = tmpvar_8.xyz;
    tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_10));
    highp vec4 o_11;
    highp vec4 tmpvar_12;
    tmpvar_12 = (tmpvar_9 * 0.5);
    o_11.zw = tmpvar_12.zw;
    o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
    o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
    o_11.zw = tmpvar_9.zw;
    tmpvar_5 = o_11;
    highp vec4 tmpvar_13;
    tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
    tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
    tmpvar_6 = (tmpvar_13 * tmpvar_9);
    tmpvar_3 = tmpvar_2;
    tmpvar_4 = (o_11.xy / tmpvar_9.w);
  } else {
    highp vec4 tmpvar_14;
    tmpvar_14.zw = vec2(0.0, 1.0);
    tmpvar_14.xy = tmpvar_1.xy;
    highp vec4 o_15;
    highp vec4 tmpvar_16;
    tmpvar_16 = (tmpvar_14 * 0.5);
    o_15.zw = tmpvar_16.zw;
    o_15.xy = (tmpvar_16.xy + tmpvar_16.ww);
    o_15.y = ((2.0 * tmpvar_16.w) - o_15.y);
    o_15.zw = vec2(0.0, 1.0);
    tmpvar_5 = o_15;
    highp vec4 tmpvar_17;
    tmpvar_17.xzw = vec3(1.0, 1.0, 1.0);
    tmpvar_17.y = DEVICE_COORDINATE_Y_FLIP;
    tmpvar_6 = (tmpvar_17 * tmpvar_14);
    tmpvar_3 = o_15.xy;
    tmpvar_4 = o_15.xy;
  };
  xlv_TEXCOORD0 = tmpvar_3;
  xlv_TEXCOORD1 = tmpvar_4;
  xlv_TEXCOORD2 = tmpvar_5;
  gl_Position = tmpvar_6;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_TO_COLOR;
uniform sampler2D TEXTURE_MASK;
uniform sampler2D _LutMap;
uniform highp float BLEND_MODE;
uniform highp float BlendOpacity;
uniform highp float MASKRATIO;
uniform highp float ISPURECOLOR;
uniform highp vec4 PURECOLOR;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec3 blendColor_1;
  highp vec4 resultColor_2;
  highp vec4 hair_color_3;
  highp vec4 img_color_4;
  highp vec4 mask_5;
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_MASK, xlv_TEXCOORD0);
  mask_5 = tmpvar_6;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_GRAP, xlv_TEXCOORD1);
  img_color_4 = tmpvar_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_TO_COLOR, xlv_TEXCOORD0);
  hair_color_3 = tmpvar_8;
  highp int tmpvar_9;
  tmpvar_9 = int((ISPURECOLOR + 0.5));
  if ((tmpvar_9 == 1)) {
    hair_color_3 = PURECOLOR;
  };
  highp float tmpvar_10;
  tmpvar_10 = clamp ((mask_5.w * MASKRATIO), 0.0, 1.0);
  highp int tmpvar_11;
  tmpvar_11 = int((BLEND_MODE + 0.5));
  highp float tmpvar_12;
  tmpvar_12 = (BlendOpacity * tmpvar_10);
  highp vec3 tmpvar_13;
  tmpvar_13 = hair_color_3.xyz;
  blendColor_1 = tmpvar_13;
  highp vec4 tmpvar_14;
  tmpvar_14.xyz = hair_color_3.xyz;
  tmpvar_14.w = tmpvar_10;
  highp vec3 tmpvar_15;
  tmpvar_15 = tmpvar_14.xyz;
  if ((tmpvar_11 == 1)) {
    highp vec4 tmpvar_16;
    tmpvar_16.xyz = tmpvar_13;
    tmpvar_16.w = tmpvar_10;
    resultColor_2 = tmpvar_16;
  } else {
    if ((tmpvar_11 == 2)) {
      blendColor_1 = (vec3(1.0, 1.0, 1.0) - (tmpvar_12 * (vec3(1.0, 1.0, 1.0) - hair_color_3.xyz)));
      highp vec4 tmpvar_17;
      tmpvar_17.xyz = blendColor_1;
      tmpvar_17.w = tmpvar_10;
      resultColor_2 = tmpvar_17;
    } else {
      if ((tmpvar_11 == 3)) {
        blendColor_1 = (tmpvar_12 * blendColor_1);
        highp vec4 tmpvar_18;
        tmpvar_18.xyz = blendColor_1;
        tmpvar_18.w = tmpvar_10;
        resultColor_2 = tmpvar_18;
      } else {
        if ((tmpvar_11 == 4)) {
          highp vec3 rgb_19;
          rgb_19 = img_color_4.xyz;
          highp vec4 tmpvar_20;
          if ((img_color_4.y < img_color_4.z)) {
            highp vec4 tmpvar_21;
            tmpvar_21.zw = vec2(-1.0, 0.6666667);
            tmpvar_21.xy = rgb_19.zy;
            tmpvar_20 = tmpvar_21;
          } else {
            highp vec4 tmpvar_22;
            tmpvar_22.zw = vec2(0.0, -0.3333333);
            tmpvar_22.xy = rgb_19.yz;
            tmpvar_20 = tmpvar_22;
          };
          highp vec4 tmpvar_23;
          if ((img_color_4.x < tmpvar_20.x)) {
            highp vec4 tmpvar_24;
            tmpvar_24.xyz = tmpvar_20.xyw;
            tmpvar_24.w = rgb_19.x;
            tmpvar_23 = tmpvar_24;
          } else {
            highp vec4 tmpvar_25;
            tmpvar_25.x = rgb_19.x;
            tmpvar_25.yzw = tmpvar_20.yzx;
            tmpvar_23 = tmpvar_25;
          };
          highp float tmpvar_26;
          tmpvar_26 = (tmpvar_23.x - min (tmpvar_23.w, tmpvar_23.y));
          highp vec3 tmpvar_27;
          tmpvar_27.x = abs(((
            (tmpvar_23.w - tmpvar_23.y)
           / 
            ((6.0 * tmpvar_26) + 1e-7)
          ) + tmpvar_23.z));
          tmpvar_27.y = tmpvar_26;
          tmpvar_27.z = tmpvar_23.x;
          highp float tmpvar_28;
          tmpvar_28 = (tmpvar_23.x - (tmpvar_26 * 0.5));
          highp vec3 tmpvar_29;
          tmpvar_29.x = tmpvar_27.x;
          tmpvar_29.y = (tmpvar_26 / ((1.0 - 
            abs(((2.0 * tmpvar_28) - 1.0))
          ) + 1e-7));
          tmpvar_29.z = tmpvar_28;
          highp vec4 tmpvar_30;
          if ((blendColor_1.y < blendColor_1.z)) {
            highp vec4 tmpvar_31;
            tmpvar_31.zw = vec2(-1.0, 0.6666667);
            tmpvar_31.xy = blendColor_1.zy;
            tmpvar_30 = tmpvar_31;
          } else {
            highp vec4 tmpvar_32;
            tmpvar_32.zw = vec2(0.0, -0.3333333);
            tmpvar_32.xy = blendColor_1.yz;
            tmpvar_30 = tmpvar_32;
          };
          highp vec4 tmpvar_33;
          if ((blendColor_1.x < tmpvar_30.x)) {
            highp vec4 tmpvar_34;
            tmpvar_34.xyz = tmpvar_30.xyw;
            tmpvar_34.w = blendColor_1.x;
            tmpvar_33 = tmpvar_34;
          } else {
            highp vec4 tmpvar_35;
            tmpvar_35.x = blendColor_1.x;
            tmpvar_35.yzw = tmpvar_30.yzx;
            tmpvar_33 = tmpvar_35;
          };
          highp float tmpvar_36;
          tmpvar_36 = (tmpvar_33.x - min (tmpvar_33.w, tmpvar_33.y));
          highp vec3 tmpvar_37;
          tmpvar_37.x = abs(((
            (tmpvar_33.w - tmpvar_33.y)
           / 
            ((6.0 * tmpvar_36) + 1e-7)
          ) + tmpvar_33.z));
          tmpvar_37.y = tmpvar_36;
          tmpvar_37.z = tmpvar_33.x;
          highp vec3 tmpvar_38;
          tmpvar_38.x = (abs((
            (6.0 * tmpvar_37.x)
           - 3.0)) - 1.0);
          tmpvar_38.y = (2.0 - abs((
            (6.0 * tmpvar_37.x)
           - 2.0)));
          tmpvar_38.z = (2.0 - abs((
            (6.0 * tmpvar_37.x)
           - 4.0)));
          highp vec4 tmpvar_39;
          tmpvar_39.w = 0.0;
          tmpvar_39.xyz = clamp (((
            (clamp (tmpvar_38, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)) - 0.5)
           * 
            ((1.0 - abs((
              (2.0 * tmpvar_28)
             - 1.0))) * tmpvar_29.y)
          ) + tmpvar_28), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
          resultColor_2.xyz = mix (img_color_4, tmpvar_39, vec4(tmpvar_12)).xyz;
          resultColor_2.w = 1.0;
        } else {
          if ((tmpvar_11 == 5)) {
            highp vec3 rgb_40;
            rgb_40 = img_color_4.xyz;
            highp vec4 tmpvar_41;
            if ((img_color_4.y < img_color_4.z)) {
              highp vec4 tmpvar_42;
              tmpvar_42.zw = vec2(-1.0, 0.6666667);
              tmpvar_42.xy = rgb_40.zy;
              tmpvar_41 = tmpvar_42;
            } else {
              highp vec4 tmpvar_43;
              tmpvar_43.zw = vec2(0.0, -0.3333333);
              tmpvar_43.xy = rgb_40.yz;
              tmpvar_41 = tmpvar_43;
            };
            highp vec4 tmpvar_44;
            if ((img_color_4.x < tmpvar_41.x)) {
              highp vec4 tmpvar_45;
              tmpvar_45.xyz = tmpvar_41.xyw;
              tmpvar_45.w = rgb_40.x;
              tmpvar_44 = tmpvar_45;
            } else {
              highp vec4 tmpvar_46;
              tmpvar_46.x = rgb_40.x;
              tmpvar_46.yzw = tmpvar_41.yzx;
              tmpvar_44 = tmpvar_46;
            };
            highp float tmpvar_47;
            tmpvar_47 = (tmpvar_44.x - min (tmpvar_44.w, tmpvar_44.y));
            highp vec3 tmpvar_48;
            tmpvar_48.x = abs(((
              (tmpvar_44.w - tmpvar_44.y)
             / 
              ((6.0 * tmpvar_47) + 1e-7)
            ) + tmpvar_44.z));
            tmpvar_48.y = tmpvar_47;
            tmpvar_48.z = tmpvar_44.x;
            highp float tmpvar_49;
            tmpvar_49 = (tmpvar_44.x - (tmpvar_47 * 0.5));
            highp vec4 tmpvar_50;
            if ((blendColor_1.y < blendColor_1.z)) {
              highp vec4 tmpvar_51;
              tmpvar_51.zw = vec2(-1.0, 0.6666667);
              tmpvar_51.xy = blendColor_1.zy;
              tmpvar_50 = tmpvar_51;
            } else {
              highp vec4 tmpvar_52;
              tmpvar_52.zw = vec2(0.0, -0.3333333);
              tmpvar_52.xy = blendColor_1.yz;
              tmpvar_50 = tmpvar_52;
            };
            highp vec4 tmpvar_53;
            if ((blendColor_1.x < tmpvar_50.x)) {
              highp vec4 tmpvar_54;
              tmpvar_54.xyz = tmpvar_50.xyw;
              tmpvar_54.w = blendColor_1.x;
              tmpvar_53 = tmpvar_54;
            } else {
              highp vec4 tmpvar_55;
              tmpvar_55.x = blendColor_1.x;
              tmpvar_55.yzw = tmpvar_50.yzx;
              tmpvar_53 = tmpvar_55;
            };
            highp float tmpvar_56;
            tmpvar_56 = (tmpvar_53.x - min (tmpvar_53.w, tmpvar_53.y));
            highp vec3 tmpvar_57;
            tmpvar_57.x = abs(((
              (tmpvar_53.w - tmpvar_53.y)
             / 
              ((6.0 * tmpvar_56) + 1e-7)
            ) + tmpvar_53.z));
            tmpvar_57.y = tmpvar_56;
            tmpvar_57.z = tmpvar_53.x;
            highp float tmpvar_58;
            tmpvar_58 = (tmpvar_53.x - (tmpvar_56 * 0.5));
            highp vec3 tmpvar_59;
            tmpvar_59.x = tmpvar_57.x;
            tmpvar_59.y = (tmpvar_56 / ((1.0 - 
              abs(((2.0 * tmpvar_58) - 1.0))
            ) + 1e-7));
            tmpvar_59.z = tmpvar_58;
            highp vec3 tmpvar_60;
            tmpvar_60.x = (abs((
              (6.0 * tmpvar_48.x)
             - 3.0)) - 1.0);
            tmpvar_60.y = (2.0 - abs((
              (6.0 * tmpvar_48.x)
             - 2.0)));
            tmpvar_60.z = (2.0 - abs((
              (6.0 * tmpvar_48.x)
             - 4.0)));
            highp vec4 tmpvar_61;
            tmpvar_61.w = 0.0;
            tmpvar_61.xyz = clamp (((
              (clamp (tmpvar_60, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)) - 0.5)
             * 
              ((1.0 - abs((
                (2.0 * tmpvar_49)
               - 1.0))) * tmpvar_59.y)
            ) + tmpvar_49), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
            resultColor_2.xyz = mix (img_color_4, tmpvar_61, vec4(tmpvar_12)).xyz;
            resultColor_2.w = 1.0;
          } else {
            if ((tmpvar_11 == 6)) {
              highp vec3 rgb_62;
              rgb_62 = img_color_4.xyz;
              highp vec4 tmpvar_63;
              if ((img_color_4.y < img_color_4.z)) {
                highp vec4 tmpvar_64;
                tmpvar_64.zw = vec2(-1.0, 0.6666667);
                tmpvar_64.xy = rgb_62.zy;
                tmpvar_63 = tmpvar_64;
              } else {
                highp vec4 tmpvar_65;
                tmpvar_65.zw = vec2(0.0, -0.3333333);
                tmpvar_65.xy = rgb_62.yz;
                tmpvar_63 = tmpvar_65;
              };
              highp vec4 tmpvar_66;
              if ((img_color_4.x < tmpvar_63.x)) {
                highp vec4 tmpvar_67;
                tmpvar_67.xyz = tmpvar_63.xyw;
                tmpvar_67.w = rgb_62.x;
                tmpvar_66 = tmpvar_67;
              } else {
                highp vec4 tmpvar_68;
                tmpvar_68.x = rgb_62.x;
                tmpvar_68.yzw = tmpvar_63.yzx;
                tmpvar_66 = tmpvar_68;
              };
              highp float tmpvar_69;
              tmpvar_69 = (tmpvar_66.x - min (tmpvar_66.w, tmpvar_66.y));
              highp vec3 tmpvar_70;
              tmpvar_70.x = abs(((
                (tmpvar_66.w - tmpvar_66.y)
               / 
                ((6.0 * tmpvar_69) + 1e-7)
              ) + tmpvar_66.z));
              tmpvar_70.y = tmpvar_69;
              tmpvar_70.z = tmpvar_66.x;
              highp float tmpvar_71;
              tmpvar_71 = (tmpvar_66.x - (tmpvar_69 * 0.5));
              highp vec3 tmpvar_72;
              tmpvar_72.x = tmpvar_70.x;
              tmpvar_72.y = (tmpvar_69 / ((1.0 - 
                abs(((2.0 * tmpvar_71) - 1.0))
              ) + 1e-7));
              tmpvar_72.z = tmpvar_71;
              highp vec4 tmpvar_73;
              if ((blendColor_1.y < blendColor_1.z)) {
                highp vec4 tmpvar_74;
                tmpvar_74.zw = vec2(-1.0, 0.6666667);
                tmpvar_74.xy = blendColor_1.zy;
                tmpvar_73 = tmpvar_74;
              } else {
                highp vec4 tmpvar_75;
                tmpvar_75.zw = vec2(0.0, -0.3333333);
                tmpvar_75.xy = blendColor_1.yz;
                tmpvar_73 = tmpvar_75;
              };
              highp vec4 tmpvar_76;
              if ((blendColor_1.x < tmpvar_73.x)) {
                highp vec4 tmpvar_77;
                tmpvar_77.xyz = tmpvar_73.xyw;
                tmpvar_77.w = blendColor_1.x;
                tmpvar_76 = tmpvar_77;
              } else {
                highp vec4 tmpvar_78;
                tmpvar_78.x = blendColor_1.x;
                tmpvar_78.yzw = tmpvar_73.yzx;
                tmpvar_76 = tmpvar_78;
              };
              highp float tmpvar_79;
              tmpvar_79 = (tmpvar_76.x - ((tmpvar_76.x - 
                min (tmpvar_76.w, tmpvar_76.y)
              ) * 0.5));
              highp vec3 tmpvar_80;
              tmpvar_80.x = (abs((
                (6.0 * tmpvar_70.x)
               - 3.0)) - 1.0);
              tmpvar_80.y = (2.0 - abs((
                (6.0 * tmpvar_70.x)
               - 2.0)));
              tmpvar_80.z = (2.0 - abs((
                (6.0 * tmpvar_70.x)
               - 4.0)));
              highp vec4 tmpvar_81;
              tmpvar_81.w = 0.0;
              tmpvar_81.xyz = clamp (((
                (clamp (tmpvar_80, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)) - 0.5)
               * 
                ((1.0 - abs((
                  (2.0 * tmpvar_79)
                 - 1.0))) * tmpvar_72.y)
              ) + tmpvar_79), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
              resultColor_2.xyz = mix (img_color_4, tmpvar_81, vec4(tmpvar_12)).xyz;
              resultColor_2.w = 1.0;
            } else {
              if ((tmpvar_11 == 7)) {
                highp vec3 rgb_82;
                rgb_82 = img_color_4.xyz;
                highp vec4 tmpvar_83;
                if ((img_color_4.y < img_color_4.z)) {
                  highp vec4 tmpvar_84;
                  tmpvar_84.zw = vec2(-1.0, 0.6666667);
                  tmpvar_84.xy = rgb_82.zy;
                  tmpvar_83 = tmpvar_84;
                } else {
                  highp vec4 tmpvar_85;
                  tmpvar_85.zw = vec2(0.0, -0.3333333);
                  tmpvar_85.xy = rgb_82.yz;
                  tmpvar_83 = tmpvar_85;
                };
                highp vec4 tmpvar_86;
                if ((img_color_4.x < tmpvar_83.x)) {
                  highp vec4 tmpvar_87;
                  tmpvar_87.xyz = tmpvar_83.xyw;
                  tmpvar_87.w = rgb_82.x;
                  tmpvar_86 = tmpvar_87;
                } else {
                  highp vec4 tmpvar_88;
                  tmpvar_88.x = rgb_82.x;
                  tmpvar_88.yzw = tmpvar_83.yzx;
                  tmpvar_86 = tmpvar_88;
                };
                highp float tmpvar_89;
                tmpvar_89 = (tmpvar_86.x - ((tmpvar_86.x - 
                  min (tmpvar_86.w, tmpvar_86.y)
                ) * 0.5));
                highp vec4 tmpvar_90;
                if ((blendColor_1.y < blendColor_1.z)) {
                  highp vec4 tmpvar_91;
                  tmpvar_91.zw = vec2(-1.0, 0.6666667);
                  tmpvar_91.xy = blendColor_1.zy;
                  tmpvar_90 = tmpvar_91;
                } else {
                  highp vec4 tmpvar_92;
                  tmpvar_92.zw = vec2(0.0, -0.3333333);
                  tmpvar_92.xy = blendColor_1.yz;
                  tmpvar_90 = tmpvar_92;
                };
                highp vec4 tmpvar_93;
                if ((blendColor_1.x < tmpvar_90.x)) {
                  highp vec4 tmpvar_94;
                  tmpvar_94.xyz = tmpvar_90.xyw;
                  tmpvar_94.w = blendColor_1.x;
                  tmpvar_93 = tmpvar_94;
                } else {
                  highp vec4 tmpvar_95;
                  tmpvar_95.x = blendColor_1.x;
                  tmpvar_95.yzw = tmpvar_90.yzx;
                  tmpvar_93 = tmpvar_95;
                };
                highp float tmpvar_96;
                tmpvar_96 = (tmpvar_93.x - min (tmpvar_93.w, tmpvar_93.y));
                highp vec3 tmpvar_97;
                tmpvar_97.x = abs(((
                  (tmpvar_93.w - tmpvar_93.y)
                 / 
                  ((6.0 * tmpvar_96) + 1e-7)
                ) + tmpvar_93.z));
                tmpvar_97.y = tmpvar_96;
                tmpvar_97.z = tmpvar_93.x;
                highp float tmpvar_98;
                tmpvar_98 = (tmpvar_93.x - (tmpvar_96 * 0.5));
                highp vec3 tmpvar_99;
                tmpvar_99.x = tmpvar_97.x;
                tmpvar_99.y = (tmpvar_96 / ((1.0 - 
                  abs(((2.0 * tmpvar_98) - 1.0))
                ) + 1e-7));
                tmpvar_99.z = tmpvar_98;
                highp vec3 tmpvar_100;
                tmpvar_100.x = (abs((
                  (6.0 * tmpvar_97.x)
                 - 3.0)) - 1.0);
                tmpvar_100.y = (2.0 - abs((
                  (6.0 * tmpvar_97.x)
                 - 2.0)));
                tmpvar_100.z = (2.0 - abs((
                  (6.0 * tmpvar_97.x)
                 - 4.0)));
                highp vec4 tmpvar_101;
                tmpvar_101.w = 0.0;
                tmpvar_101.xyz = clamp (((
                  (clamp (tmpvar_100, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)) - 0.5)
                 * 
                  ((1.0 - abs((
                    (2.0 * tmpvar_89)
                   - 1.0))) * tmpvar_99.y)
                ) + tmpvar_89), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
                resultColor_2.xyz = mix (img_color_4, tmpvar_101, vec4(tmpvar_12)).xyz;
                resultColor_2.w = 1.0;
              } else {
                if ((tmpvar_11 == 8)) {
                  highp vec4 tmpvar_102;
                  tmpvar_102.w = 0.0;
                  tmpvar_102.xyz = ((dot (vec3(0.299, 0.587, 0.114), img_color_4.xyz) * 1.68) * blendColor_1);
                  resultColor_2.xyz = mix (img_color_4, tmpvar_102, vec4(tmpvar_12)).xyz;
                  resultColor_2.w = 1.0;
                } else {
                  if ((tmpvar_11 == 9)) {
                    resultColor_2.xyz = mix (img_color_4.xyz, ((img_color_4.xyz + hair_color_3.xyz) - (
                      (2.0 * img_color_4.xyz)
                     * hair_color_3.xyz)), vec3(tmpvar_12));
                    resultColor_2.w = 1.0;
                  } else {
                    if ((tmpvar_11 == 10)) {
                      highp float tmpvar_103;
                      if ((hair_color_3.x < 0.5)) {
                        tmpvar_103 = ((2.0 * hair_color_3.x) * img_color_4.x);
                      } else {
                        tmpvar_103 = (1.0 - ((2.0 * 
                          (1.0 - hair_color_3.x)
                        ) * (1.0 - img_color_4.x)));
                      };
                      highp float tmpvar_104;
                      if ((hair_color_3.y < 0.5)) {
                        tmpvar_104 = ((2.0 * hair_color_3.y) * img_color_4.y);
                      } else {
                        tmpvar_104 = (1.0 - ((2.0 * 
                          (1.0 - hair_color_3.y)
                        ) * (1.0 - img_color_4.y)));
                      };
                      highp float tmpvar_105;
                      if ((hair_color_3.z < 0.5)) {
                        tmpvar_105 = ((2.0 * hair_color_3.z) * img_color_4.z);
                      } else {
                        tmpvar_105 = (1.0 - ((2.0 * 
                          (1.0 - hair_color_3.z)
                        ) * (1.0 - img_color_4.z)));
                      };
                      highp vec3 tmpvar_106;
                      tmpvar_106.x = tmpvar_103;
                      tmpvar_106.y = tmpvar_104;
                      tmpvar_106.z = tmpvar_105;
                      resultColor_2.xyz = mix (img_color_4.xyz, tmpvar_106, vec3(tmpvar_12));
                      resultColor_2.w = 1.0;
                    } else {
                      if ((tmpvar_11 == 11)) {
                        highp float tmpvar_107;
                        if ((hair_color_3.x < 0.5)) {
                          highp float blend_108;
                          blend_108 = (2.0 * hair_color_3.x);
                          highp float tmpvar_109;
                          if ((blend_108 == 0.0)) {
                            tmpvar_109 = blend_108;
                          } else {
                            tmpvar_109 = max ((1.0 - (
                              (1.0 - img_color_4.x)
                             / blend_108)), 0.0);
                          };
                          tmpvar_107 = tmpvar_109;
                        } else {
                          highp float blend_110;
                          blend_110 = (2.0 * (hair_color_3.x - 0.5));
                          highp float tmpvar_111;
                          if ((blend_110 == 1.0)) {
                            tmpvar_111 = blend_110;
                          } else {
                            tmpvar_111 = min ((img_color_4.x / (1.0 - blend_110)), 1.0);
                          };
                          tmpvar_107 = tmpvar_111;
                        };
                        highp float tmpvar_112;
                        if ((hair_color_3.y < 0.5)) {
                          highp float blend_113;
                          blend_113 = (2.0 * hair_color_3.y);
                          highp float tmpvar_114;
                          if ((blend_113 == 0.0)) {
                            tmpvar_114 = blend_113;
                          } else {
                            tmpvar_114 = max ((1.0 - (
                              (1.0 - img_color_4.y)
                             / blend_113)), 0.0);
                          };
                          tmpvar_112 = tmpvar_114;
                        } else {
                          highp float blend_115;
                          blend_115 = (2.0 * (hair_color_3.y - 0.5));
                          highp float tmpvar_116;
                          if ((blend_115 == 1.0)) {
                            tmpvar_116 = blend_115;
                          } else {
                            tmpvar_116 = min ((img_color_4.y / (1.0 - blend_115)), 1.0);
                          };
                          tmpvar_112 = tmpvar_116;
                        };
                        highp float tmpvar_117;
                        if ((hair_color_3.z < 0.5)) {
                          highp float blend_118;
                          blend_118 = (2.0 * hair_color_3.z);
                          highp float tmpvar_119;
                          if ((blend_118 == 0.0)) {
                            tmpvar_119 = blend_118;
                          } else {
                            tmpvar_119 = max ((1.0 - (
                              (1.0 - img_color_4.z)
                             / blend_118)), 0.0);
                          };
                          tmpvar_117 = tmpvar_119;
                        } else {
                          highp float blend_120;
                          blend_120 = (2.0 * (hair_color_3.z - 0.5));
                          highp float tmpvar_121;
                          if ((blend_120 == 1.0)) {
                            tmpvar_121 = blend_120;
                          } else {
                            tmpvar_121 = min ((img_color_4.z / (1.0 - blend_120)), 1.0);
                          };
                          tmpvar_117 = tmpvar_121;
                        };
                        highp vec3 tmpvar_122;
                        tmpvar_122.x = tmpvar_107;
                        tmpvar_122.y = tmpvar_112;
                        tmpvar_122.z = tmpvar_117;
                        resultColor_2.xyz = mix (img_color_4.xyz, tmpvar_122, vec3(tmpvar_12));
                        resultColor_2.w = 1.0;
                      } else {
                        if ((tmpvar_11 == 12)) {
                          highp float tmpvar_123;
                          if ((img_color_4.x < 0.5)) {
                            tmpvar_123 = ((2.0 * img_color_4.x) * hair_color_3.x);
                          } else {
                            tmpvar_123 = (1.0 - ((2.0 * 
                              (1.0 - img_color_4.x)
                            ) * (1.0 - hair_color_3.x)));
                          };
                          highp float tmpvar_124;
                          if ((img_color_4.y < 0.5)) {
                            tmpvar_124 = ((2.0 * img_color_4.y) * hair_color_3.y);
                          } else {
                            tmpvar_124 = (1.0 - ((2.0 * 
                              (1.0 - img_color_4.y)
                            ) * (1.0 - hair_color_3.y)));
                          };
                          highp float tmpvar_125;
                          if ((img_color_4.z < 0.5)) {
                            tmpvar_125 = ((2.0 * img_color_4.z) * hair_color_3.z);
                          } else {
                            tmpvar_125 = (1.0 - ((2.0 * 
                              (1.0 - img_color_4.z)
                            ) * (1.0 - hair_color_3.z)));
                          };
                          highp vec3 tmpvar_126;
                          tmpvar_126.x = tmpvar_123;
                          tmpvar_126.y = tmpvar_124;
                          tmpvar_126.z = tmpvar_125;
                          resultColor_2.xyz = mix (img_color_4.xyz, tmpvar_126, vec3(tmpvar_12));
                          resultColor_2.w = 1.0;
                        } else {
                          if ((tmpvar_11 == 13)) {
                            highp float blend_127;
                            blend_127 = tmpvar_15.x;
                            highp float tmpvar_128;
                            if ((hair_color_3.x == 0.0)) {
                              tmpvar_128 = blend_127;
                            } else {
                              tmpvar_128 = max ((1.0 - (
                                (1.0 - img_color_4.x)
                               / hair_color_3.x)), 0.0);
                            };
                            highp float blend_129;
                            blend_129 = tmpvar_15.y;
                            highp float tmpvar_130;
                            if ((hair_color_3.y == 0.0)) {
                              tmpvar_130 = blend_129;
                            } else {
                              tmpvar_130 = max ((1.0 - (
                                (1.0 - img_color_4.y)
                               / hair_color_3.y)), 0.0);
                            };
                            highp float blend_131;
                            blend_131 = tmpvar_15.z;
                            highp float tmpvar_132;
                            if ((hair_color_3.z == 0.0)) {
                              tmpvar_132 = blend_131;
                            } else {
                              tmpvar_132 = max ((1.0 - (
                                (1.0 - img_color_4.z)
                               / hair_color_3.z)), 0.0);
                            };
                            highp vec3 tmpvar_133;
                            tmpvar_133.x = tmpvar_128;
                            tmpvar_133.y = tmpvar_130;
                            tmpvar_133.z = tmpvar_132;
                            resultColor_2.xyz = mix (img_color_4.xyz, tmpvar_133, vec3(tmpvar_12));
                            resultColor_2.w = 1.0;
                          } else {
                            if ((tmpvar_11 == 14)) {
                              highp float blend_134;
                              blend_134 = tmpvar_15.x;
                              highp float tmpvar_135;
                              if ((hair_color_3.x == 1.0)) {
                                tmpvar_135 = blend_134;
                              } else {
                                tmpvar_135 = min ((img_color_4.x / (1.0 - hair_color_3.x)), 1.0);
                              };
                              highp float blend_136;
                              blend_136 = tmpvar_15.y;
                              highp float tmpvar_137;
                              if ((hair_color_3.y == 1.0)) {
                                tmpvar_137 = blend_136;
                              } else {
                                tmpvar_137 = min ((img_color_4.y / (1.0 - hair_color_3.y)), 1.0);
                              };
                              highp float blend_138;
                              blend_138 = tmpvar_15.z;
                              highp float tmpvar_139;
                              if ((hair_color_3.z == 1.0)) {
                                tmpvar_139 = blend_138;
                              } else {
                                tmpvar_139 = min ((img_color_4.z / (1.0 - hair_color_3.z)), 1.0);
                              };
                              highp vec3 tmpvar_140;
                              tmpvar_140.x = tmpvar_135;
                              tmpvar_140.y = tmpvar_137;
                              tmpvar_140.z = tmpvar_139;
                              resultColor_2.xyz = mix (img_color_4.xyz, tmpvar_140, vec3(tmpvar_12));
                              resultColor_2.w = 1.0;
                            } else {
                              if ((tmpvar_11 == 15)) {
                                resultColor_2.xyz = mix (img_color_4.xyz, ((
                                  ((vec3(1.0, 1.0, 1.0) - (vec3(2.0, 2.0, 2.0) * hair_color_3.xyz)) * img_color_4.xyz)
                                 * img_color_4.xyz) + (
                                  (vec3(2.0, 2.0, 2.0) * img_color_4.xyz)
                                 * hair_color_3.xyz)), vec3(tmpvar_12));
                                resultColor_2.w = 1.0;
                              } else {
                                if ((tmpvar_11 == 16)) {
                                  highp float tmpvar_141;
                                  highp float tmpvar_142;
                                  if ((hair_color_3.x < 0.5)) {
                                    highp float blend_143;
                                    blend_143 = (2.0 * hair_color_3.x);
                                    highp float tmpvar_144;
                                    if ((blend_143 == 0.0)) {
                                      tmpvar_144 = blend_143;
                                    } else {
                                      tmpvar_144 = max ((1.0 - (
                                        (1.0 - img_color_4.x)
                                       / blend_143)), 0.0);
                                    };
                                    tmpvar_142 = tmpvar_144;
                                  } else {
                                    highp float blend_145;
                                    blend_145 = (2.0 * (hair_color_3.x - 0.5));
                                    highp float tmpvar_146;
                                    if ((blend_145 == 1.0)) {
                                      tmpvar_146 = blend_145;
                                    } else {
                                      tmpvar_146 = min ((img_color_4.x / (1.0 - blend_145)), 1.0);
                                    };
                                    tmpvar_142 = tmpvar_146;
                                  };
                                  if ((tmpvar_142 < 0.5)) {
                                    tmpvar_141 = 0.0;
                                  } else {
                                    tmpvar_141 = 1.0;
                                  };
                                  highp float tmpvar_147;
                                  highp float tmpvar_148;
                                  if ((hair_color_3.y < 0.5)) {
                                    highp float blend_149;
                                    blend_149 = (2.0 * hair_color_3.y);
                                    highp float tmpvar_150;
                                    if ((blend_149 == 0.0)) {
                                      tmpvar_150 = blend_149;
                                    } else {
                                      tmpvar_150 = max ((1.0 - (
                                        (1.0 - img_color_4.y)
                                       / blend_149)), 0.0);
                                    };
                                    tmpvar_148 = tmpvar_150;
                                  } else {
                                    highp float blend_151;
                                    blend_151 = (2.0 * (hair_color_3.y - 0.5));
                                    highp float tmpvar_152;
                                    if ((blend_151 == 1.0)) {
                                      tmpvar_152 = blend_151;
                                    } else {
                                      tmpvar_152 = min ((img_color_4.y / (1.0 - blend_151)), 1.0);
                                    };
                                    tmpvar_148 = tmpvar_152;
                                  };
                                  if ((tmpvar_148 < 0.5)) {
                                    tmpvar_147 = 0.0;
                                  } else {
                                    tmpvar_147 = 1.0;
                                  };
                                  highp float tmpvar_153;
                                  highp float tmpvar_154;
                                  if ((hair_color_3.z < 0.5)) {
                                    highp float blend_155;
                                    blend_155 = (2.0 * hair_color_3.z);
                                    highp float tmpvar_156;
                                    if ((blend_155 == 0.0)) {
                                      tmpvar_156 = blend_155;
                                    } else {
                                      tmpvar_156 = max ((1.0 - (
                                        (1.0 - img_color_4.z)
                                       / blend_155)), 0.0);
                                    };
                                    tmpvar_154 = tmpvar_156;
                                  } else {
                                    highp float blend_157;
                                    blend_157 = (2.0 * (hair_color_3.z - 0.5));
                                    highp float tmpvar_158;
                                    if ((blend_157 == 1.0)) {
                                      tmpvar_158 = blend_157;
                                    } else {
                                      tmpvar_158 = min ((img_color_4.z / (1.0 - blend_157)), 1.0);
                                    };
                                    tmpvar_154 = tmpvar_158;
                                  };
                                  if ((tmpvar_154 < 0.5)) {
                                    tmpvar_153 = 0.0;
                                  } else {
                                    tmpvar_153 = 1.0;
                                  };
                                  highp vec3 tmpvar_159;
                                  tmpvar_159.x = tmpvar_141;
                                  tmpvar_159.y = tmpvar_147;
                                  tmpvar_159.z = tmpvar_153;
                                  resultColor_2.xyz = mix (img_color_4.xyz, tmpvar_159, vec3(tmpvar_12));
                                  resultColor_2.w = 1.0;
                                } else {
                                  if ((tmpvar_11 == 17)) {
                                    highp float tmpvar_160;
                                    if ((hair_color_3.x < 0.5)) {
                                      tmpvar_160 = min ((2.0 * hair_color_3.x), img_color_4.x);
                                    } else {
                                      tmpvar_160 = max ((2.0 * (hair_color_3.x - 0.5)), img_color_4.x);
                                    };
                                    highp float tmpvar_161;
                                    if ((hair_color_3.y < 0.5)) {
                                      tmpvar_161 = min ((2.0 * hair_color_3.y), img_color_4.y);
                                    } else {
                                      tmpvar_161 = max ((2.0 * (hair_color_3.y - 0.5)), img_color_4.y);
                                    };
                                    highp float tmpvar_162;
                                    if ((hair_color_3.z < 0.5)) {
                                      tmpvar_162 = min ((2.0 * hair_color_3.z), img_color_4.z);
                                    } else {
                                      tmpvar_162 = max ((2.0 * (hair_color_3.z - 0.5)), img_color_4.z);
                                    };
                                    highp vec3 tmpvar_163;
                                    tmpvar_163.x = tmpvar_160;
                                    tmpvar_163.y = tmpvar_161;
                                    tmpvar_163.z = tmpvar_162;
                                    resultColor_2.xyz = mix (img_color_4.xyz, tmpvar_163, vec3(tmpvar_12));
                                    resultColor_2.w = 1.0;
                                  } else {
                                    if ((tmpvar_11 == 18)) {
                                      highp float tmpvar_164;
                                      if ((hair_color_3.x < 0.5)) {
                                        tmpvar_164 = max (((img_color_4.x + 
                                          (2.0 * hair_color_3.x)
                                        ) - 1.0), 0.0);
                                      } else {
                                        tmpvar_164 = min ((img_color_4.x + (2.0 * 
                                          (hair_color_3.x - 0.5)
                                        )), 1.0);
                                      };
                                      highp float tmpvar_165;
                                      if ((hair_color_3.y < 0.5)) {
                                        tmpvar_165 = max (((img_color_4.y + 
                                          (2.0 * hair_color_3.y)
                                        ) - 1.0), 0.0);
                                      } else {
                                        tmpvar_165 = min ((img_color_4.y + (2.0 * 
                                          (hair_color_3.y - 0.5)
                                        )), 1.0);
                                      };
                                      highp float tmpvar_166;
                                      if ((hair_color_3.z < 0.5)) {
                                        tmpvar_166 = max (((img_color_4.z + 
                                          (2.0 * hair_color_3.z)
                                        ) - 1.0), 0.0);
                                      } else {
                                        tmpvar_166 = min ((img_color_4.z + (2.0 * 
                                          (hair_color_3.z - 0.5)
                                        )), 1.0);
                                      };
                                      highp vec3 tmpvar_167;
                                      tmpvar_167.x = tmpvar_164;
                                      tmpvar_167.y = tmpvar_165;
                                      tmpvar_167.z = tmpvar_166;
                                      resultColor_2.xyz = mix (img_color_4.xyz, tmpvar_167, vec3(tmpvar_12));
                                      resultColor_2.w = 1.0;
                                    } else {
                                      if ((tmpvar_11 == 19)) {
                                        resultColor_2.xyz = mix (img_color_4.xyz, abs((img_color_4.xyz - hair_color_3.xyz)), vec3(tmpvar_12));
                                        resultColor_2.w = 1.0;
                                      } else {
                                        if ((tmpvar_11 == 20)) {
                                          resultColor_2.xyz = mix (img_color_4.xyz, max ((
                                            (img_color_4.xyz + hair_color_3.xyz)
                                           - vec3(1.0, 1.0, 1.0)), vec3(0.0, 0.0, 0.0)), vec3(tmpvar_12));
                                          resultColor_2.w = 1.0;
                                        } else {
                                          if ((tmpvar_11 == 21)) {
                                            resultColor_2.xyz = mix (img_color_4.xyz, max ((img_color_4.xyz - hair_color_3.xyz), vec3(0.0, 0.0, 0.0)), vec3(tmpvar_12));
                                            resultColor_2.w = 1.0;
                                          } else {
                                            if ((tmpvar_11 >= 22)) {
                                              highp vec3 resColor_13_168;
                                              highp vec2 tmpvar_169;
                                              tmpvar_169.x = blendColor_1.x;
                                              tmpvar_169.y = img_color_4.x;
                                              lowp vec4 tmpvar_170;
                                              tmpvar_170 = texture2D (_LutMap, tmpvar_169);
                                              resColor_13_168.x = tmpvar_170.x;
                                              highp vec2 tmpvar_171;
                                              tmpvar_171.x = blendColor_1.y;
                                              tmpvar_171.y = img_color_4.y;
                                              lowp vec4 tmpvar_172;
                                              tmpvar_172 = texture2D (_LutMap, tmpvar_171);
                                              resColor_13_168.y = tmpvar_172.y;
                                              highp vec2 tmpvar_173;
                                              tmpvar_173.x = blendColor_1.z;
                                              tmpvar_173.y = img_color_4.z;
                                              lowp vec4 tmpvar_174;
                                              tmpvar_174 = texture2D (_LutMap, tmpvar_173);
                                              resColor_13_168.z = tmpvar_174.z;
                                              highp vec4 tmpvar_175;
                                              tmpvar_175.w = 0.0;
                                              tmpvar_175.xyz = resColor_13_168;
                                              resultColor_2.xyz = mix (img_color_4, tmpvar_175, vec4(tmpvar_12)).xyz;
                                              resultColor_2.w = 1.0;
                                            };
                                          };
                                        };
                                      };
                                    };
                                  };
                                };
                              };
                            };
                          };
                        };
                      };
                    };
                  };
                };
              };
            };
          };
        };
      };
    };
  };
  gl_FragData[0] = resultColor_2;
}

]===],
	},
}

end
