#DEFPARAMS
_MainTex = { "Main Tex", TEXTURE2D, "white" },
_LutMap = {"Lut Map", TEXTURE2D, "white" },
_MainSize = { "Main Size", VEC2, "16, 16" },
_MainPivot = { "Main Pivot", VEC2, "8, 8" },
_Opacity = { "Opacity", FLOATRANGE, "1, 1, 0" },
_Use3DAnchor = { "Use3d Anchor", FLOAT, "0" },
_AnchorPoint = { "Anchor", VEC3, "0, 0, 0" },
_Rotation = { "Rotation", VEC3, "0, 0, 0" },
_Scale = { "Scale", VEC2, "1, 1" },
_VideoSize = { "Video Size", VEC2, "0, 0" },
_HorizontalFlip = {"Horizontal Flip", FLOAT, "0.0"},
_VerticalFlip = {"Vertical Flip", FLOAT, "0.0"},
[Enum(BlendFactor)]
_BlendSrc = {"Blend Src", FLOAT, "4.0"},
[Enum(BlendFactor)]
_BlendDst = {"Blend Dst", FLOAT, "5.0"},
[Keywords(
	BLEND_NORMAL, 
	BLEND_MULTIPLY, 
	BLEND_SCREEN, 
	BLEND_HUE, 
	BLEND_SATURATION,
	BLEND_LUMINOSITY, 
	BLEND_COLOR, 
	BLEND_BLEND,
	BLEND_EXCLUSION,
	BLEND_HARDLIGHT,
	BLEND_VIVIDLIGHT,
	BLEND_OVERLAY,
	BLEND_COLORBURN,
	BLEND_COLORDODGE,
	BLEND_SOFTLIGHT,
	BLEND_HARDMIX,
	BLEND_PINLIGHT,
	BLEND_LINEARLIGHT,
	BLEND_DIFF,
	BLEND_LINEARBURN,
	BLEND_SUB,
	BLEND_LUT
)]
_BlendMode = {"Blend Mode", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "FaceParse_Sticker"
RenderQueue = "Transparent+1"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc", "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag

#include "common.inc"
#include "rgb_hsv.inc"

#pragma multi_compile BLEND_NORMAL BLEND_MULTIPLY BLEND_SCREEN BLEND_HUE BLEND_SATURATION BLEND_LUMINOSITY BLEND_COLOR BLEND_BLEND BLEND_EXCLUSION BLEND_HARDLIGHT BLEND_VIVIDLIGHT BLEND_OVERLAY BLEND_COLORBURN BLEND_COLORDODGE BLEND_SOFTLIGHT BLEND_HARDMIX BLEND_PINLIGHT BLEND_LINEARLIGHT BLEND_DIFF BLEND_LINEARBURN BLEND_SUB BLEND_LUT


struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;	
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 rtuv : TEXCOORD1;
	float4 vertex : SV_POSITION;
};

sampler2D _MainTex;
sampler2D _LutMap;
float2 _MainSize;
float2 _MainPivot;  // ָ
float _Opacity;

float _Use3DAnchor;
float3 _AnchorPoint;
float3 _Rotation; // pitch, yaw, roll (Ŀǰroll)
float2 _Scale;
float2 _VideoSize;
float _HorizontalFlip;
float _VerticalFlip;

float4x4 getTranMatrix()
{
  float4x4 localtrans = float4x4(
    _MainSize.x*0.5, 0, 0, _MainSize.x*0.5,
    0, _MainSize.y*0.5, 0, _MainSize.y*0.5,
    0, 0, 1, 0,
    0, 0, 0, 1
  );

// y˷תҪ
  float4x4 pivotTrans = float4x4(
    1, 0, 0, -_MainPivot.x,
    0, 1, 0, -(_MainSize.y-_MainPivot.y),
    0, 0, 1, 0,
    0, 0, 0, 1
  );
  
  float cos_roll = cos(_Rotation.z);
  float sin_roll = sin(_Rotation.z);
  
  if(_HorizontalFlip > 0.1)
    _Scale.x = -_Scale.x;

  if(_VerticalFlip > 0.1)
    _Scale.y = -_Scale.y;


  float4x4 scalerot = float4x4(
    cos_roll*_Scale.x, -sin_roll*_Scale.y, 0, 0,
    sin_roll*_Scale.x, cos_roll*_Scale.y, 0, 0,
    0, 0, 1, 0,
    0, 0, 0, 1
  );

  float2 anchor = float2(0,0);
  if(_Use3DAnchor > 0.1)
  {
    float4 clippos = WorldToClipPos(_AnchorPoint);
    anchor = clippos.xy/clippos.w;
    anchor = (anchor*0.5+0.5)*_VideoSize;
  }
  else
  {
    anchor = float2(_AnchorPoint.x, _VideoSize.y - _AnchorPoint.y);
  }
  float a = sign(_Rotation.y);
  float b = -sign(_Rotation.x);
  float2x2 rot = float2x2(cos_roll, -sin_roll, sin_roll, cos_roll);
  float2 diff = float2(a * 1.414*sqrt(1.0-cos(_Rotation.y)),  b * 1.414*sqrt(1.0-cos(_Rotation.x)));
  diff = mul(rot, diff);
  //anchor = anchor + diff;

  float4x4 posttrans = float4x4(
    1, 0, 0, anchor.x,
    0, 1, 0, anchor.y,
    0, 0, 1, 0,
    0, 0, 0, 1
  );

  float4x4 ndt = float4x4(
    2/_VideoSize.x, 0, 0, -1,
    0, 2/_VideoSize.y, 0, -1,
    0, 0, 1, 0,
    0, 0, 0, 1
  );
  
  return mul(ndt, mul(posttrans, mul(scalerot, mul(pivotTrans,localtrans))));
}

v2f vert(appdata v)
{
	v2f o = (v2f)0;
  
  o.vertex = mul(getTranMatrix(), v.vertex);
  //o.rtuv = o.vertex.xy * 0.5 + 0.5;
  o.rtuv = ComputeScreenPos(o.vertex);
  o.vertex = UniformNDC(float4(o.vertex.x, o.vertex.y, 0.0, 1.0));
 
  o.uv = v.uv;
  return o;
}


float3 RGBtoHCV(float3 rgb)
{
	float4 p = (rgb.g < rgb.b) ? float4(rgb.bg, -1.0, 2.0/3.0) : float4(rgb.gb, 0.0, -1.0/3.0);
	float4 q = (rgb.r < p.x) ? float4(p.xyw, rgb.r) : float4(rgb.r, p.yzx);
	
   	float c = q.x - min(q.w, q.y);
	float h = abs((q.w - q.y) / (6.0*c + 1e-7) + q.z);
	float v = q.x;
	
	return float3(h, c, v);
}

float3 RGBToHSL(float3 rgb)
{
	float3 hcv = RGBtoHCV(rgb);
	float lum = hcv.z - hcv.y * 0.5;
	float sat = hcv.y / (1.0 - abs(2.0*lum - 1.0) + 1e-7);
	
	return float3(hcv.x, sat, lum);
}

float3 HUEtoRGB(float hue)
{
	float r = abs(6.0*hue - 3.0) - 1.0;
	float g = 2.0 - abs(6.0*hue - 2.0);
	float b = 2.0 - abs(6.0*hue - 4.0);
	float3 blackColor = float3(0.0, 0.0, 0.0);
	float3 whiteColor = float3(1.0, 1.0, 1.0);
	return clamp(float3(r, g, b), blackColor, whiteColor);
}

float3 HSLToRGB(float3 hsl)
{
	float3 rgb = HUEtoRGB(hsl.x);
	float c = (1.0 - abs(2.0 * hsl.z - 1.0)) * hsl.y;
	rgb = (rgb - 0.5) * c + hsl.z;
	return rgb;
}

float3 BlendExclusion(float3 base, float3 blend)
{
	return (base + blend - 2.0 * (base) * (blend));
}

float BlendOverlayf(float base, float blend)
{
    return (base < 0.5 ? (2.0 * (base) * (blend)) : (1.0 - 2.0 * (1.0 - (base)) * (1.0 - (blend))));
}

float3 BlendOverlay(float3 base, float3 blend)
{
	return float3(BlendOverlayf(base.r, blend.r), BlendOverlayf(base.g, blend.g), BlendOverlayf(base.b, blend.b));
}

float3 BlendHardLight(float3 base, float3 blend)
{
	return BlendOverlay(blend, base);
}

float BlendSoftLightf(float base, float blend)
{
    return ((1.0 - 2.0 * (blend))*(base)*(base) + 2.0 * (base) * (blend));
}
float BlendColorDodgef(float base, float blend)
{
    return ((blend == 1.0) ? blend : min((base) / (1.0 - (blend)), 1.0));
}

float BlendColorBurnf(float base, float blend)
{
    return ((blend == 0.0) ? blend : max((1.0 - ((1.0 - (base)) / (blend))), 0.0));
}

float BlendVividLightf(float base, float blend)
{
    if(blend < 0.5)
	{
        return BlendColorBurnf(base, 2.0 * blend);
    }
    else
	{
        return BlendColorDodgef(base, 2.0 * (blend - 0.5));
    }
}

float3 BlendVividLight(float3 base, float3 blend)
{
	return float3(BlendVividLightf(base.r, blend.r), BlendVividLightf(base.g, blend.g), BlendVividLightf(base.b, blend.b));
}

float3 BlendColorBurn(float3 base, float3 blend)
{
	return float3(BlendColorBurnf(base.r, blend.r), BlendColorBurnf(base.g, blend.g), BlendColorBurnf(base.b, blend.b));
}

float3 BlendColorDodge(float3 base, float3 blend)
{
	return float3(BlendColorDodgef(base.r, blend.r), BlendColorDodgef(base.g, blend.g), BlendColorDodgef(base.b, blend.b));
}

float3 BlendSoftLight(float3 base, float3 blend)
{
	return float3(BlendSoftLightf(base.r, blend.r),BlendSoftLightf(base.g, blend.g),BlendSoftLightf(base.b, blend.b));
}

float BlendHardMixf(float base, float blend)
{
    if(BlendVividLightf(base, blend) < 0.5)
	{
        return 0.0;
    }
    else
	{
        return 1.0;
    }
}

float3 BlendHardMix(float3 base, float3 blend)
{
	return float3(BlendHardMixf(base.r, blend.r), BlendHardMixf(base.g, blend.g), BlendHardMixf(base.b, blend.b));
}

float BlendLightenf(float base, float blend)
{
    return max(blend, base);
}

float BlendDarkenf(float base, float blend)
{
    return min(blend, base);
}

float BlendPinLightf(float base, float blend) 
{
    if(blend < 0.5)
	{
        return BlendDarkenf(base, 2.0 * blend);
    }
    else
	{
        return BlendLightenf(base, 2.0 * (blend - 0.5));
    }
}

float3 BlendPinLight(float3 base, float3 blend)
{
	return float3(BlendPinLightf(base.r, blend.r), BlendPinLightf(base.g, blend.g), BlendPinLightf(base.b, blend.b));
}

float BlendLinearBurnf(float base, float blend)
{
    return max(base + blend - 1.0, 0.0);
}

float BlendLinearDodgef(float base, float blend)
{
    return min(base + blend, 1.0);
}

float BlendLinearLightf(float base, float blend)
{
    if(blend < 0.5)
	{
        return BlendLinearBurnf(base, 2.0 * blend);
    }
    else 
	{
        return BlendLinearDodgef(base, 2.0 * (blend - 0.5));
    }
}

float3 BlendLinearLight(float3 base, float3 blend)
{
	return float3(BlendLinearLightf(base.r, blend.r), BlendLinearLightf(base.g, blend.g), BlendLinearLightf(base.b, blend.b));
}

float3 BlendDiff(float3 base, float3 blend)
{
	return abs(base - blend);
}

float3 BlendLinearBurn(float3 base, float3 blend)
{
	return float3(BlendLinearBurnf(base.r, blend.r), BlendLinearBurnf(base.g, blend.g), BlendLinearBurnf(base.b, blend.b));
}

float3 BlendSub(float3 base, float3 blend)
{
	return max(base - blend, float3(0.0, 0.0, 0.0));
}





fixed4 frag(v2f i) : SV_Target
{
	const float epsilon = 0.0001;
	float4 MColor = tex2D(_MainTex, i.uv);
	float3 srcColor = MColor.rgb;
	float alpha = MColor.a * _Opacity;

#if !(BLEND_NORMAL || BLEND_MULTIPLY || BLEND_SCREEN)
    float2 _RTUV = i.rtuv.xy/i.rtuv.w;
	float4 RColor = tex2D(TEXTURE_GRAP, _RTUV);
	float3 dstColor = RColor.rgb;
#endif

	//srcAlpha 1-srcAlpha by default
#ifdef BLEND_NORMAL
	float3 color = srcColor;
	float final_alpha = alpha;
#elif BLEND_MULTIPLY
	float3 whiteColor = float3(1.0, 1.0, 1.0);
	float3 color = whiteColor - alpha * (whiteColor - srcColor);
	float final_alpha = 1.0;
#elif BLEND_SCREEN
	float3 color = alpha * srcColor;
	float final_alpha = 1.0;
#elif BLEND_HUE
	float3 baseHSL = RGBToHSL(dstColor);
	float3 blendHSL = RGBToHSL(srcColor);
	float3 resHSLColor = HSLToRGB(float3(blendHSL.r, baseHSL.g, baseHSL.b));
	float3 color = lerp(dstColor, resHSLColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_SATURATION
	float3 baseHSL = RGBToHSL(dstColor);
	float3 blendHSL = RGBToHSL(srcColor);
	float3 resHSLColor = HSLToRGB(float3(baseHSL.r, blendHSL.g, baseHSL.b));
	float3 color = lerp(dstColor, resHSLColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_LUMINOSITY
	float3 baseHSL = RGBToHSL(dstColor);
	float3 blendHSL = RGBToHSL(srcColor);
	float3 resHSLColor = HSLToRGB(float3(baseHSL.r, baseHSL.g, blendHSL.b));
	float3 color = lerp(dstColor, resHSLColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_COLOR
	float3 baseHSL = RGBToHSL(dstColor);
	float3 blendHSL = RGBToHSL(srcColor);
	float3 resHSLColor = HSLToRGB(float3(blendHSL.r, blendHSL.g, baseHSL.b));
	float3 color = lerp(dstColor, resHSLColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_BLEND
	float imgIntensity = dot(float3(0.2990,0.5870,0.1140), dstColor);
	float3 resIntColor = (imgIntensity * 1.68) * srcColor;
	float3 color = lerp(dstColor, resIntColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_EXCLUSION
	float3 resColor = BlendExclusion(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_HARDLIGHT
	float3 resColor = BlendHardLight(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_VIVIDLIGHT
	float3 resColor = BlendVividLight(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_OVERLAY
	float3 resColor = BlendOverlay(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_COLORBURN
	float3 resColor = BlendColorBurn(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_COLORDODGE
	float3 resColor = BlendColorDodge(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_SOFTLIGHT
	float3 resColor = BlendSoftLight(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_HARDMIX
	float3 resColor = BlendHardMix(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_PINLIGHT
	float3 resColor = BlendPinLight(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_LINEARLIGHT
	float3 resColor = BlendLinearLight(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_DIFF
	float3 resColor = BlendDiff(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_LINEARBURN
	float3 resColor = BlendLinearBurn(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_SUB
	float3 resColor = BlendSub(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_LUT
	float3 resColor;
	resColor.r = tex2D(_LutMap, float2(srcColor.r, dstColor.r)).r;
	resColor.g = tex2D(_LutMap, float2(srcColor.g, dstColor.g)).g;
	resColor.b = tex2D(_LutMap, float2(srcColor.b, dstColor.b)).b;

	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#endif

	return float4(color, final_alpha);
}
ENDCG
#END
