function DefineParams()
	Properties = 
	{
		
_MainTex = { "Main Tex", TEXTURE2D, "white" },
_LutMap = {"Lut Map", TEXTURE2D, "white" },
_MainSize = { "Main Size", VEC2, "16, 16" },
_MainPivot = { "Main Pivot", VEC2, "8, 8" },
_Opacity = { "Opacity", FLOATRANGE, "1, 1, 0" },
_Use3DAnchor = { "Use3d Anchor", FLOAT, "0" },
_AnchorPoint = { "Anchor", VEC3, "0, 0, 0" },
_Rotation = { "Rotation", VEC3, "0, 0, 0" },
_Scale = { "Scale", VEC2, "1, 1" },
_VideoSize = { "Video Size", VEC2, "0, 0" },
_HorizontalFlip = {"Horizontal Flip", FLOAT, "0.0"},
_VerticalFlip = {"Vertical Flip", FLOAT, "0.0"},

_BlendSrc = {"Blend Src", FLOAT, "4.0"},

_BlendDst = {"Blend Dst", FLOAT, "5.0"},

_BlendMode = {"Blend Mode", FLOAT, "0.0"},

	}
	Attributes = 
	{
		_BlendSrc = "Enum(BlendFactor)", 
		_BlendDst = "Enum(BlendFactor)", 
		_BlendMode = "Keywords(BLEND_NORMAL,BLEND_MULTIPLY,BLEND_SCREEN,BLEND_HUE,BLEND_SATURATION,BLEND_LUMINOSITY,BLEND_COLOR,BLEND_BLEND,BLEND_EXCLUSION,BLEND_HARDLIGHT,BLEND_VIVIDLIGHT,BLEND_OVERLAY,BLEND_COLORBURN,BLEND_COLORDODGE,BLEND_SOFTLIGHT,BLEND_HARDMIX,BLEND_PINLIGHT,BLEND_LINEARLIGHT,BLEND_DIFF,BLEND_LINEARBURN,BLEND_SUB,BLEND_LUT)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "FaceParse_Sticker"
RenderQueue = "Transparent+1"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc", "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Use3DAnchor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_AnchorPoint",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Rotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Scale",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_HorizontalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VerticalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainSize;
uniform highp vec2 _MainPivot;
uniform highp float _Use3DAnchor;
uniform highp vec3 _AnchorPoint;
uniform highp vec3 _Rotation;
uniform highp vec2 _Scale;
uniform highp vec2 _VideoSize;
uniform highp float _HorizontalFlip;
uniform highp float _VerticalFlip;
highp vec2 xlat_mutable_Scale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  xlat_mutable_Scale = _Scale;
  highp vec2 tmpvar_1;
  tmpvar_1 = _glesMultiTexCoord0.xy;
  highp vec4 tmpvar_2;
  tmpvar_2 = vec4(0.0, 0.0, 0.0, 0.0);
  highp vec2 anchor_3;
  highp mat4 tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (_MainSize.x * 0.5);
  tmpvar_4[0].x = tmpvar_5;
  tmpvar_4[0].y = 0.0;
  tmpvar_4[0].z = 0.0;
  tmpvar_4[0].w = 0.0;
  tmpvar_4[1].x = 0.0;
  highp float tmpvar_6;
  tmpvar_6 = (_MainSize.y * 0.5);
  tmpvar_4[1].y = tmpvar_6;
  tmpvar_4[1].z = 0.0;
  tmpvar_4[1].w = 0.0;
  tmpvar_4[2].x = 0.0;
  tmpvar_4[2].y = 0.0;
  tmpvar_4[2].z = 1.0;
  tmpvar_4[2].w = 0.0;
  tmpvar_4[3].x = tmpvar_5;
  tmpvar_4[3].y = tmpvar_6;
  tmpvar_4[3].z = 0.0;
  tmpvar_4[3].w = 1.0;
  highp mat4 tmpvar_7;
  tmpvar_7[0].x = 1.0;
  tmpvar_7[0].y = 0.0;
  tmpvar_7[0].z = 0.0;
  tmpvar_7[0].w = 0.0;
  tmpvar_7[1].x = 0.0;
  tmpvar_7[1].y = 1.0;
  tmpvar_7[1].z = 0.0;
  tmpvar_7[1].w = 0.0;
  tmpvar_7[2].x = 0.0;
  tmpvar_7[2].y = 0.0;
  tmpvar_7[2].z = 1.0;
  tmpvar_7[2].w = 0.0;
  tmpvar_7[3].x = -(_MainPivot.x);
  tmpvar_7[3].y = (_MainPivot.y - _MainSize.y);
  tmpvar_7[3].z = 0.0;
  tmpvar_7[3].w = 1.0;
  highp float tmpvar_8;
  tmpvar_8 = cos(_Rotation.z);
  highp float tmpvar_9;
  tmpvar_9 = sin(_Rotation.z);
  if ((_HorizontalFlip > 0.1)) {
    xlat_mutable_Scale.x = -(_Scale.x);
  };
  if ((_VerticalFlip > 0.1)) {
    xlat_mutable_Scale.y = -(_Scale.y);
  };
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = (tmpvar_8 * xlat_mutable_Scale.x);
  tmpvar_10[0].y = (tmpvar_9 * xlat_mutable_Scale.x);
  tmpvar_10[0].z = 0.0;
  tmpvar_10[0].w = 0.0;
  tmpvar_10[1].x = (-(tmpvar_9) * xlat_mutable_Scale.y);
  tmpvar_10[1].y = (tmpvar_8 * xlat_mutable_Scale.y);
  tmpvar_10[1].z = 0.0;
  tmpvar_10[1].w = 0.0;
  tmpvar_10[2].x = 0.0;
  tmpvar_10[2].y = 0.0;
  tmpvar_10[2].z = 1.0;
  tmpvar_10[2].w = 0.0;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  anchor_3 = vec2(0.0, 0.0);
  if ((_Use3DAnchor > 0.1)) {
    highp vec4 tmpvar_11;
    highp vec4 tmpvar_12;
    tmpvar_12.w = 1.0;
    tmpvar_12.xyz = _AnchorPoint;
    tmpvar_11 = (CAMERA_VIEWPROJ * tmpvar_12);
    anchor_3 = (tmpvar_11.xy / tmpvar_11.w);
    anchor_3 = (((anchor_3 * 0.5) + 0.5) * _VideoSize);
  } else {
    highp vec2 tmpvar_13;
    tmpvar_13.x = _AnchorPoint.x;
    tmpvar_13.y = (_VideoSize.y - _AnchorPoint.y);
    anchor_3 = tmpvar_13;
  };
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 1.0;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.0;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 1.0;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.0;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 1.0;
  tmpvar_14[2].w = 0.0;
  tmpvar_14[3].x = anchor_3.x;
  tmpvar_14[3].y = anchor_3.y;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = (2.0 / _VideoSize.x);
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.0;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = (2.0 / _VideoSize.y);
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.0;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 1.0;
  tmpvar_15[2].w = 0.0;
  tmpvar_15[3].x = -1.0;
  tmpvar_15[3].y = -1.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  tmpvar_2 = ((tmpvar_15 * (tmpvar_14 * 
    (tmpvar_10 * (tmpvar_7 * tmpvar_4))
  )) * _glesVertex);
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_2 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_2.zw;
  highp vec4 tmpvar_18;
  tmpvar_18.zw = vec2(0.0, 1.0);
  tmpvar_18.xy = tmpvar_2.xy;
  highp vec4 tmpvar_19;
  tmpvar_19.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_19.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_18);
  tmpvar_2 = tmpvar_20;
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = o_16;
  gl_Position = tmpvar_20;
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 MColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture2D (_MainTex, xlv_TEXCOORD0);
  MColor_2 = tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.xyz = MColor_2.xyz;
  tmpvar_4.w = (MColor_2.w * _Opacity);
  tmpvar_1 = tmpvar_4;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_MULTIPLY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Use3DAnchor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_AnchorPoint",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Rotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Scale",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_HorizontalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VerticalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainSize;
uniform highp vec2 _MainPivot;
uniform highp float _Use3DAnchor;
uniform highp vec3 _AnchorPoint;
uniform highp vec3 _Rotation;
uniform highp vec2 _Scale;
uniform highp vec2 _VideoSize;
uniform highp float _HorizontalFlip;
uniform highp float _VerticalFlip;
highp vec2 xlat_mutable_Scale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  xlat_mutable_Scale = _Scale;
  highp vec2 tmpvar_1;
  tmpvar_1 = _glesMultiTexCoord0.xy;
  highp vec4 tmpvar_2;
  tmpvar_2 = vec4(0.0, 0.0, 0.0, 0.0);
  highp vec2 anchor_3;
  highp mat4 tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (_MainSize.x * 0.5);
  tmpvar_4[0].x = tmpvar_5;
  tmpvar_4[0].y = 0.0;
  tmpvar_4[0].z = 0.0;
  tmpvar_4[0].w = 0.0;
  tmpvar_4[1].x = 0.0;
  highp float tmpvar_6;
  tmpvar_6 = (_MainSize.y * 0.5);
  tmpvar_4[1].y = tmpvar_6;
  tmpvar_4[1].z = 0.0;
  tmpvar_4[1].w = 0.0;
  tmpvar_4[2].x = 0.0;
  tmpvar_4[2].y = 0.0;
  tmpvar_4[2].z = 1.0;
  tmpvar_4[2].w = 0.0;
  tmpvar_4[3].x = tmpvar_5;
  tmpvar_4[3].y = tmpvar_6;
  tmpvar_4[3].z = 0.0;
  tmpvar_4[3].w = 1.0;
  highp mat4 tmpvar_7;
  tmpvar_7[0].x = 1.0;
  tmpvar_7[0].y = 0.0;
  tmpvar_7[0].z = 0.0;
  tmpvar_7[0].w = 0.0;
  tmpvar_7[1].x = 0.0;
  tmpvar_7[1].y = 1.0;
  tmpvar_7[1].z = 0.0;
  tmpvar_7[1].w = 0.0;
  tmpvar_7[2].x = 0.0;
  tmpvar_7[2].y = 0.0;
  tmpvar_7[2].z = 1.0;
  tmpvar_7[2].w = 0.0;
  tmpvar_7[3].x = -(_MainPivot.x);
  tmpvar_7[3].y = (_MainPivot.y - _MainSize.y);
  tmpvar_7[3].z = 0.0;
  tmpvar_7[3].w = 1.0;
  highp float tmpvar_8;
  tmpvar_8 = cos(_Rotation.z);
  highp float tmpvar_9;
  tmpvar_9 = sin(_Rotation.z);
  if ((_HorizontalFlip > 0.1)) {
    xlat_mutable_Scale.x = -(_Scale.x);
  };
  if ((_VerticalFlip > 0.1)) {
    xlat_mutable_Scale.y = -(_Scale.y);
  };
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = (tmpvar_8 * xlat_mutable_Scale.x);
  tmpvar_10[0].y = (tmpvar_9 * xlat_mutable_Scale.x);
  tmpvar_10[0].z = 0.0;
  tmpvar_10[0].w = 0.0;
  tmpvar_10[1].x = (-(tmpvar_9) * xlat_mutable_Scale.y);
  tmpvar_10[1].y = (tmpvar_8 * xlat_mutable_Scale.y);
  tmpvar_10[1].z = 0.0;
  tmpvar_10[1].w = 0.0;
  tmpvar_10[2].x = 0.0;
  tmpvar_10[2].y = 0.0;
  tmpvar_10[2].z = 1.0;
  tmpvar_10[2].w = 0.0;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  anchor_3 = vec2(0.0, 0.0);
  if ((_Use3DAnchor > 0.1)) {
    highp vec4 tmpvar_11;
    highp vec4 tmpvar_12;
    tmpvar_12.w = 1.0;
    tmpvar_12.xyz = _AnchorPoint;
    tmpvar_11 = (CAMERA_VIEWPROJ * tmpvar_12);
    anchor_3 = (tmpvar_11.xy / tmpvar_11.w);
    anchor_3 = (((anchor_3 * 0.5) + 0.5) * _VideoSize);
  } else {
    highp vec2 tmpvar_13;
    tmpvar_13.x = _AnchorPoint.x;
    tmpvar_13.y = (_VideoSize.y - _AnchorPoint.y);
    anchor_3 = tmpvar_13;
  };
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 1.0;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.0;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 1.0;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.0;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 1.0;
  tmpvar_14[2].w = 0.0;
  tmpvar_14[3].x = anchor_3.x;
  tmpvar_14[3].y = anchor_3.y;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = (2.0 / _VideoSize.x);
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.0;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = (2.0 / _VideoSize.y);
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.0;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 1.0;
  tmpvar_15[2].w = 0.0;
  tmpvar_15[3].x = -1.0;
  tmpvar_15[3].y = -1.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  tmpvar_2 = ((tmpvar_15 * (tmpvar_14 * 
    (tmpvar_10 * (tmpvar_7 * tmpvar_4))
  )) * _glesVertex);
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_2 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_2.zw;
  highp vec4 tmpvar_18;
  tmpvar_18.zw = vec2(0.0, 1.0);
  tmpvar_18.xy = tmpvar_2.xy;
  highp vec4 tmpvar_19;
  tmpvar_19.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_19.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_18);
  tmpvar_2 = tmpvar_20;
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = o_16;
  gl_Position = tmpvar_20;
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 MColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture2D (_MainTex, xlv_TEXCOORD0);
  MColor_2 = tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.xyz = (vec3(1.0, 1.0, 1.0) - ((MColor_2.w * _Opacity) * (vec3(1.0, 1.0, 1.0) - MColor_2.xyz)));
  tmpvar_4.w = 1.0;
  tmpvar_1 = tmpvar_4;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_SCREEN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Use3DAnchor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_AnchorPoint",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Rotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Scale",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_HorizontalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VerticalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainSize;
uniform highp vec2 _MainPivot;
uniform highp float _Use3DAnchor;
uniform highp vec3 _AnchorPoint;
uniform highp vec3 _Rotation;
uniform highp vec2 _Scale;
uniform highp vec2 _VideoSize;
uniform highp float _HorizontalFlip;
uniform highp float _VerticalFlip;
highp vec2 xlat_mutable_Scale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  xlat_mutable_Scale = _Scale;
  highp vec2 tmpvar_1;
  tmpvar_1 = _glesMultiTexCoord0.xy;
  highp vec4 tmpvar_2;
  tmpvar_2 = vec4(0.0, 0.0, 0.0, 0.0);
  highp vec2 anchor_3;
  highp mat4 tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (_MainSize.x * 0.5);
  tmpvar_4[0].x = tmpvar_5;
  tmpvar_4[0].y = 0.0;
  tmpvar_4[0].z = 0.0;
  tmpvar_4[0].w = 0.0;
  tmpvar_4[1].x = 0.0;
  highp float tmpvar_6;
  tmpvar_6 = (_MainSize.y * 0.5);
  tmpvar_4[1].y = tmpvar_6;
  tmpvar_4[1].z = 0.0;
  tmpvar_4[1].w = 0.0;
  tmpvar_4[2].x = 0.0;
  tmpvar_4[2].y = 0.0;
  tmpvar_4[2].z = 1.0;
  tmpvar_4[2].w = 0.0;
  tmpvar_4[3].x = tmpvar_5;
  tmpvar_4[3].y = tmpvar_6;
  tmpvar_4[3].z = 0.0;
  tmpvar_4[3].w = 1.0;
  highp mat4 tmpvar_7;
  tmpvar_7[0].x = 1.0;
  tmpvar_7[0].y = 0.0;
  tmpvar_7[0].z = 0.0;
  tmpvar_7[0].w = 0.0;
  tmpvar_7[1].x = 0.0;
  tmpvar_7[1].y = 1.0;
  tmpvar_7[1].z = 0.0;
  tmpvar_7[1].w = 0.0;
  tmpvar_7[2].x = 0.0;
  tmpvar_7[2].y = 0.0;
  tmpvar_7[2].z = 1.0;
  tmpvar_7[2].w = 0.0;
  tmpvar_7[3].x = -(_MainPivot.x);
  tmpvar_7[3].y = (_MainPivot.y - _MainSize.y);
  tmpvar_7[3].z = 0.0;
  tmpvar_7[3].w = 1.0;
  highp float tmpvar_8;
  tmpvar_8 = cos(_Rotation.z);
  highp float tmpvar_9;
  tmpvar_9 = sin(_Rotation.z);
  if ((_HorizontalFlip > 0.1)) {
    xlat_mutable_Scale.x = -(_Scale.x);
  };
  if ((_VerticalFlip > 0.1)) {
    xlat_mutable_Scale.y = -(_Scale.y);
  };
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = (tmpvar_8 * xlat_mutable_Scale.x);
  tmpvar_10[0].y = (tmpvar_9 * xlat_mutable_Scale.x);
  tmpvar_10[0].z = 0.0;
  tmpvar_10[0].w = 0.0;
  tmpvar_10[1].x = (-(tmpvar_9) * xlat_mutable_Scale.y);
  tmpvar_10[1].y = (tmpvar_8 * xlat_mutable_Scale.y);
  tmpvar_10[1].z = 0.0;
  tmpvar_10[1].w = 0.0;
  tmpvar_10[2].x = 0.0;
  tmpvar_10[2].y = 0.0;
  tmpvar_10[2].z = 1.0;
  tmpvar_10[2].w = 0.0;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  anchor_3 = vec2(0.0, 0.0);
  if ((_Use3DAnchor > 0.1)) {
    highp vec4 tmpvar_11;
    highp vec4 tmpvar_12;
    tmpvar_12.w = 1.0;
    tmpvar_12.xyz = _AnchorPoint;
    tmpvar_11 = (CAMERA_VIEWPROJ * tmpvar_12);
    anchor_3 = (tmpvar_11.xy / tmpvar_11.w);
    anchor_3 = (((anchor_3 * 0.5) + 0.5) * _VideoSize);
  } else {
    highp vec2 tmpvar_13;
    tmpvar_13.x = _AnchorPoint.x;
    tmpvar_13.y = (_VideoSize.y - _AnchorPoint.y);
    anchor_3 = tmpvar_13;
  };
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 1.0;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.0;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 1.0;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.0;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 1.0;
  tmpvar_14[2].w = 0.0;
  tmpvar_14[3].x = anchor_3.x;
  tmpvar_14[3].y = anchor_3.y;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = (2.0 / _VideoSize.x);
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.0;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = (2.0 / _VideoSize.y);
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.0;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 1.0;
  tmpvar_15[2].w = 0.0;
  tmpvar_15[3].x = -1.0;
  tmpvar_15[3].y = -1.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  tmpvar_2 = ((tmpvar_15 * (tmpvar_14 * 
    (tmpvar_10 * (tmpvar_7 * tmpvar_4))
  )) * _glesVertex);
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_2 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_2.zw;
  highp vec4 tmpvar_18;
  tmpvar_18.zw = vec2(0.0, 1.0);
  tmpvar_18.xy = tmpvar_2.xy;
  highp vec4 tmpvar_19;
  tmpvar_19.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_19.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_18);
  tmpvar_2 = tmpvar_20;
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = o_16;
  gl_Position = tmpvar_20;
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 MColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture2D (_MainTex, xlv_TEXCOORD0);
  MColor_2 = tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.xyz = ((MColor_2.w * _Opacity) * MColor_2.xyz);
  tmpvar_4.w = 1.0;
  tmpvar_1 = tmpvar_4;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_HUE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Use3DAnchor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_AnchorPoint",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Rotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Scale",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_HorizontalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VerticalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainSize;
uniform highp vec2 _MainPivot;
uniform highp float _Use3DAnchor;
uniform highp vec3 _AnchorPoint;
uniform highp vec3 _Rotation;
uniform highp vec2 _Scale;
uniform highp vec2 _VideoSize;
uniform highp float _HorizontalFlip;
uniform highp float _VerticalFlip;
highp vec2 xlat_mutable_Scale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  xlat_mutable_Scale = _Scale;
  highp vec2 tmpvar_1;
  tmpvar_1 = _glesMultiTexCoord0.xy;
  highp vec4 tmpvar_2;
  tmpvar_2 = vec4(0.0, 0.0, 0.0, 0.0);
  highp vec2 anchor_3;
  highp mat4 tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (_MainSize.x * 0.5);
  tmpvar_4[0].x = tmpvar_5;
  tmpvar_4[0].y = 0.0;
  tmpvar_4[0].z = 0.0;
  tmpvar_4[0].w = 0.0;
  tmpvar_4[1].x = 0.0;
  highp float tmpvar_6;
  tmpvar_6 = (_MainSize.y * 0.5);
  tmpvar_4[1].y = tmpvar_6;
  tmpvar_4[1].z = 0.0;
  tmpvar_4[1].w = 0.0;
  tmpvar_4[2].x = 0.0;
  tmpvar_4[2].y = 0.0;
  tmpvar_4[2].z = 1.0;
  tmpvar_4[2].w = 0.0;
  tmpvar_4[3].x = tmpvar_5;
  tmpvar_4[3].y = tmpvar_6;
  tmpvar_4[3].z = 0.0;
  tmpvar_4[3].w = 1.0;
  highp mat4 tmpvar_7;
  tmpvar_7[0].x = 1.0;
  tmpvar_7[0].y = 0.0;
  tmpvar_7[0].z = 0.0;
  tmpvar_7[0].w = 0.0;
  tmpvar_7[1].x = 0.0;
  tmpvar_7[1].y = 1.0;
  tmpvar_7[1].z = 0.0;
  tmpvar_7[1].w = 0.0;
  tmpvar_7[2].x = 0.0;
  tmpvar_7[2].y = 0.0;
  tmpvar_7[2].z = 1.0;
  tmpvar_7[2].w = 0.0;
  tmpvar_7[3].x = -(_MainPivot.x);
  tmpvar_7[3].y = (_MainPivot.y - _MainSize.y);
  tmpvar_7[3].z = 0.0;
  tmpvar_7[3].w = 1.0;
  highp float tmpvar_8;
  tmpvar_8 = cos(_Rotation.z);
  highp float tmpvar_9;
  tmpvar_9 = sin(_Rotation.z);
  if ((_HorizontalFlip > 0.1)) {
    xlat_mutable_Scale.x = -(_Scale.x);
  };
  if ((_VerticalFlip > 0.1)) {
    xlat_mutable_Scale.y = -(_Scale.y);
  };
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = (tmpvar_8 * xlat_mutable_Scale.x);
  tmpvar_10[0].y = (tmpvar_9 * xlat_mutable_Scale.x);
  tmpvar_10[0].z = 0.0;
  tmpvar_10[0].w = 0.0;
  tmpvar_10[1].x = (-(tmpvar_9) * xlat_mutable_Scale.y);
  tmpvar_10[1].y = (tmpvar_8 * xlat_mutable_Scale.y);
  tmpvar_10[1].z = 0.0;
  tmpvar_10[1].w = 0.0;
  tmpvar_10[2].x = 0.0;
  tmpvar_10[2].y = 0.0;
  tmpvar_10[2].z = 1.0;
  tmpvar_10[2].w = 0.0;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  anchor_3 = vec2(0.0, 0.0);
  if ((_Use3DAnchor > 0.1)) {
    highp vec4 tmpvar_11;
    highp vec4 tmpvar_12;
    tmpvar_12.w = 1.0;
    tmpvar_12.xyz = _AnchorPoint;
    tmpvar_11 = (CAMERA_VIEWPROJ * tmpvar_12);
    anchor_3 = (tmpvar_11.xy / tmpvar_11.w);
    anchor_3 = (((anchor_3 * 0.5) + 0.5) * _VideoSize);
  } else {
    highp vec2 tmpvar_13;
    tmpvar_13.x = _AnchorPoint.x;
    tmpvar_13.y = (_VideoSize.y - _AnchorPoint.y);
    anchor_3 = tmpvar_13;
  };
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 1.0;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.0;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 1.0;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.0;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 1.0;
  tmpvar_14[2].w = 0.0;
  tmpvar_14[3].x = anchor_3.x;
  tmpvar_14[3].y = anchor_3.y;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = (2.0 / _VideoSize.x);
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.0;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = (2.0 / _VideoSize.y);
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.0;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 1.0;
  tmpvar_15[2].w = 0.0;
  tmpvar_15[3].x = -1.0;
  tmpvar_15[3].y = -1.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  tmpvar_2 = ((tmpvar_15 * (tmpvar_14 * 
    (tmpvar_10 * (tmpvar_7 * tmpvar_4))
  )) * _glesVertex);
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_2 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_2.zw;
  highp vec4 tmpvar_18;
  tmpvar_18.zw = vec2(0.0, 1.0);
  tmpvar_18.xy = tmpvar_2.xy;
  highp vec4 tmpvar_19;
  tmpvar_19.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_19.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_18);
  tmpvar_2 = tmpvar_20;
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = o_16;
  gl_Position = tmpvar_20;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_MainTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = MColor_3.xyz;
  highp float tmpvar_6;
  tmpvar_6 = (MColor_3.w * _Opacity);
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_GRAP, tmpvar_7);
  RColor_2 = tmpvar_8;
  highp vec3 tmpvar_9;
  tmpvar_9 = RColor_2.xyz;
  highp vec4 tmpvar_10;
  if ((RColor_2.y < RColor_2.z)) {
    highp vec4 tmpvar_11;
    tmpvar_11.zw = vec2(-1.0, 0.6666667);
    tmpvar_11.xy = tmpvar_9.zy;
    tmpvar_10 = tmpvar_11;
  } else {
    highp vec4 tmpvar_12;
    tmpvar_12.zw = vec2(0.0, -0.3333333);
    tmpvar_12.xy = tmpvar_9.yz;
    tmpvar_10 = tmpvar_12;
  };
  highp vec4 tmpvar_13;
  if ((RColor_2.x < tmpvar_10.x)) {
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = tmpvar_10.xyw;
    tmpvar_14.w = tmpvar_9.x;
    tmpvar_13 = tmpvar_14;
  } else {
    highp vec4 tmpvar_15;
    tmpvar_15.x = tmpvar_9.x;
    tmpvar_15.yzw = tmpvar_10.yzx;
    tmpvar_13 = tmpvar_15;
  };
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_13.x - min (tmpvar_13.w, tmpvar_13.y));
  highp vec3 tmpvar_17;
  tmpvar_17.x = abs(((
    (tmpvar_13.w - tmpvar_13.y)
   / 
    ((6.0 * tmpvar_16) + 1e-7)
  ) + tmpvar_13.z));
  tmpvar_17.y = tmpvar_16;
  tmpvar_17.z = tmpvar_13.x;
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_13.x - (tmpvar_16 * 0.5));
  highp vec3 tmpvar_19;
  tmpvar_19.x = tmpvar_17.x;
  tmpvar_19.y = (tmpvar_16 / ((1.0 - 
    abs(((2.0 * tmpvar_18) - 1.0))
  ) + 1e-7));
  tmpvar_19.z = tmpvar_18;
  highp vec4 tmpvar_20;
  if ((MColor_3.y < MColor_3.z)) {
    highp vec4 tmpvar_21;
    tmpvar_21.zw = vec2(-1.0, 0.6666667);
    tmpvar_21.xy = tmpvar_5.zy;
    tmpvar_20 = tmpvar_21;
  } else {
    highp vec4 tmpvar_22;
    tmpvar_22.zw = vec2(0.0, -0.3333333);
    tmpvar_22.xy = tmpvar_5.yz;
    tmpvar_20 = tmpvar_22;
  };
  highp vec4 tmpvar_23;
  if ((MColor_3.x < tmpvar_20.x)) {
    highp vec4 tmpvar_24;
    tmpvar_24.xyz = tmpvar_20.xyw;
    tmpvar_24.w = tmpvar_5.x;
    tmpvar_23 = tmpvar_24;
  } else {
    highp vec4 tmpvar_25;
    tmpvar_25.x = tmpvar_5.x;
    tmpvar_25.yzw = tmpvar_20.yzx;
    tmpvar_23 = tmpvar_25;
  };
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_23.x - min (tmpvar_23.w, tmpvar_23.y));
  highp vec3 tmpvar_27;
  tmpvar_27.x = abs(((
    (tmpvar_23.w - tmpvar_23.y)
   / 
    ((6.0 * tmpvar_26) + 1e-7)
  ) + tmpvar_23.z));
  tmpvar_27.y = tmpvar_26;
  tmpvar_27.z = tmpvar_23.x;
  highp vec3 tmpvar_28;
  tmpvar_28.x = (abs((
    (6.0 * tmpvar_27.x)
   - 3.0)) - 1.0);
  tmpvar_28.y = (2.0 - abs((
    (6.0 * tmpvar_27.x)
   - 2.0)));
  tmpvar_28.z = (2.0 - abs((
    (6.0 * tmpvar_27.x)
   - 4.0)));
  highp vec4 tmpvar_29;
  tmpvar_29.xyz = mix (RColor_2.xyz, ((
    (clamp (tmpvar_28, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)) - 0.5)
   * 
    ((1.0 - abs((
      (2.0 * tmpvar_18)
     - 1.0))) * tmpvar_19.y)
  ) + tmpvar_18), vec3(tmpvar_6));
  tmpvar_29.w = 1.0;
  tmpvar_1 = tmpvar_29;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_SATURATION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Use3DAnchor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_AnchorPoint",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Rotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Scale",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_HorizontalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VerticalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainSize;
uniform highp vec2 _MainPivot;
uniform highp float _Use3DAnchor;
uniform highp vec3 _AnchorPoint;
uniform highp vec3 _Rotation;
uniform highp vec2 _Scale;
uniform highp vec2 _VideoSize;
uniform highp float _HorizontalFlip;
uniform highp float _VerticalFlip;
highp vec2 xlat_mutable_Scale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  xlat_mutable_Scale = _Scale;
  highp vec2 tmpvar_1;
  tmpvar_1 = _glesMultiTexCoord0.xy;
  highp vec4 tmpvar_2;
  tmpvar_2 = vec4(0.0, 0.0, 0.0, 0.0);
  highp vec2 anchor_3;
  highp mat4 tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (_MainSize.x * 0.5);
  tmpvar_4[0].x = tmpvar_5;
  tmpvar_4[0].y = 0.0;
  tmpvar_4[0].z = 0.0;
  tmpvar_4[0].w = 0.0;
  tmpvar_4[1].x = 0.0;
  highp float tmpvar_6;
  tmpvar_6 = (_MainSize.y * 0.5);
  tmpvar_4[1].y = tmpvar_6;
  tmpvar_4[1].z = 0.0;
  tmpvar_4[1].w = 0.0;
  tmpvar_4[2].x = 0.0;
  tmpvar_4[2].y = 0.0;
  tmpvar_4[2].z = 1.0;
  tmpvar_4[2].w = 0.0;
  tmpvar_4[3].x = tmpvar_5;
  tmpvar_4[3].y = tmpvar_6;
  tmpvar_4[3].z = 0.0;
  tmpvar_4[3].w = 1.0;
  highp mat4 tmpvar_7;
  tmpvar_7[0].x = 1.0;
  tmpvar_7[0].y = 0.0;
  tmpvar_7[0].z = 0.0;
  tmpvar_7[0].w = 0.0;
  tmpvar_7[1].x = 0.0;
  tmpvar_7[1].y = 1.0;
  tmpvar_7[1].z = 0.0;
  tmpvar_7[1].w = 0.0;
  tmpvar_7[2].x = 0.0;
  tmpvar_7[2].y = 0.0;
  tmpvar_7[2].z = 1.0;
  tmpvar_7[2].w = 0.0;
  tmpvar_7[3].x = -(_MainPivot.x);
  tmpvar_7[3].y = (_MainPivot.y - _MainSize.y);
  tmpvar_7[3].z = 0.0;
  tmpvar_7[3].w = 1.0;
  highp float tmpvar_8;
  tmpvar_8 = cos(_Rotation.z);
  highp float tmpvar_9;
  tmpvar_9 = sin(_Rotation.z);
  if ((_HorizontalFlip > 0.1)) {
    xlat_mutable_Scale.x = -(_Scale.x);
  };
  if ((_VerticalFlip > 0.1)) {
    xlat_mutable_Scale.y = -(_Scale.y);
  };
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = (tmpvar_8 * xlat_mutable_Scale.x);
  tmpvar_10[0].y = (tmpvar_9 * xlat_mutable_Scale.x);
  tmpvar_10[0].z = 0.0;
  tmpvar_10[0].w = 0.0;
  tmpvar_10[1].x = (-(tmpvar_9) * xlat_mutable_Scale.y);
  tmpvar_10[1].y = (tmpvar_8 * xlat_mutable_Scale.y);
  tmpvar_10[1].z = 0.0;
  tmpvar_10[1].w = 0.0;
  tmpvar_10[2].x = 0.0;
  tmpvar_10[2].y = 0.0;
  tmpvar_10[2].z = 1.0;
  tmpvar_10[2].w = 0.0;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  anchor_3 = vec2(0.0, 0.0);
  if ((_Use3DAnchor > 0.1)) {
    highp vec4 tmpvar_11;
    highp vec4 tmpvar_12;
    tmpvar_12.w = 1.0;
    tmpvar_12.xyz = _AnchorPoint;
    tmpvar_11 = (CAMERA_VIEWPROJ * tmpvar_12);
    anchor_3 = (tmpvar_11.xy / tmpvar_11.w);
    anchor_3 = (((anchor_3 * 0.5) + 0.5) * _VideoSize);
  } else {
    highp vec2 tmpvar_13;
    tmpvar_13.x = _AnchorPoint.x;
    tmpvar_13.y = (_VideoSize.y - _AnchorPoint.y);
    anchor_3 = tmpvar_13;
  };
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 1.0;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.0;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 1.0;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.0;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 1.0;
  tmpvar_14[2].w = 0.0;
  tmpvar_14[3].x = anchor_3.x;
  tmpvar_14[3].y = anchor_3.y;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = (2.0 / _VideoSize.x);
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.0;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = (2.0 / _VideoSize.y);
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.0;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 1.0;
  tmpvar_15[2].w = 0.0;
  tmpvar_15[3].x = -1.0;
  tmpvar_15[3].y = -1.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  tmpvar_2 = ((tmpvar_15 * (tmpvar_14 * 
    (tmpvar_10 * (tmpvar_7 * tmpvar_4))
  )) * _glesVertex);
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_2 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_2.zw;
  highp vec4 tmpvar_18;
  tmpvar_18.zw = vec2(0.0, 1.0);
  tmpvar_18.xy = tmpvar_2.xy;
  highp vec4 tmpvar_19;
  tmpvar_19.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_19.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_18);
  tmpvar_2 = tmpvar_20;
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = o_16;
  gl_Position = tmpvar_20;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_MainTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = MColor_3.xyz;
  highp float tmpvar_6;
  tmpvar_6 = (MColor_3.w * _Opacity);
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_GRAP, tmpvar_7);
  RColor_2 = tmpvar_8;
  highp vec3 tmpvar_9;
  tmpvar_9 = RColor_2.xyz;
  highp vec4 tmpvar_10;
  if ((RColor_2.y < RColor_2.z)) {
    highp vec4 tmpvar_11;
    tmpvar_11.zw = vec2(-1.0, 0.6666667);
    tmpvar_11.xy = tmpvar_9.zy;
    tmpvar_10 = tmpvar_11;
  } else {
    highp vec4 tmpvar_12;
    tmpvar_12.zw = vec2(0.0, -0.3333333);
    tmpvar_12.xy = tmpvar_9.yz;
    tmpvar_10 = tmpvar_12;
  };
  highp vec4 tmpvar_13;
  if ((RColor_2.x < tmpvar_10.x)) {
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = tmpvar_10.xyw;
    tmpvar_14.w = tmpvar_9.x;
    tmpvar_13 = tmpvar_14;
  } else {
    highp vec4 tmpvar_15;
    tmpvar_15.x = tmpvar_9.x;
    tmpvar_15.yzw = tmpvar_10.yzx;
    tmpvar_13 = tmpvar_15;
  };
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_13.x - min (tmpvar_13.w, tmpvar_13.y));
  highp vec3 tmpvar_17;
  tmpvar_17.x = abs(((
    (tmpvar_13.w - tmpvar_13.y)
   / 
    ((6.0 * tmpvar_16) + 1e-7)
  ) + tmpvar_13.z));
  tmpvar_17.y = tmpvar_16;
  tmpvar_17.z = tmpvar_13.x;
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_13.x - (tmpvar_16 * 0.5));
  highp vec4 tmpvar_19;
  if ((MColor_3.y < MColor_3.z)) {
    highp vec4 tmpvar_20;
    tmpvar_20.zw = vec2(-1.0, 0.6666667);
    tmpvar_20.xy = tmpvar_5.zy;
    tmpvar_19 = tmpvar_20;
  } else {
    highp vec4 tmpvar_21;
    tmpvar_21.zw = vec2(0.0, -0.3333333);
    tmpvar_21.xy = tmpvar_5.yz;
    tmpvar_19 = tmpvar_21;
  };
  highp vec4 tmpvar_22;
  if ((MColor_3.x < tmpvar_19.x)) {
    highp vec4 tmpvar_23;
    tmpvar_23.xyz = tmpvar_19.xyw;
    tmpvar_23.w = tmpvar_5.x;
    tmpvar_22 = tmpvar_23;
  } else {
    highp vec4 tmpvar_24;
    tmpvar_24.x = tmpvar_5.x;
    tmpvar_24.yzw = tmpvar_19.yzx;
    tmpvar_22 = tmpvar_24;
  };
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_22.x - min (tmpvar_22.w, tmpvar_22.y));
  highp vec3 tmpvar_26;
  tmpvar_26.x = abs(((
    (tmpvar_22.w - tmpvar_22.y)
   / 
    ((6.0 * tmpvar_25) + 1e-7)
  ) + tmpvar_22.z));
  tmpvar_26.y = tmpvar_25;
  tmpvar_26.z = tmpvar_22.x;
  highp float tmpvar_27;
  tmpvar_27 = (tmpvar_22.x - (tmpvar_25 * 0.5));
  highp vec3 tmpvar_28;
  tmpvar_28.x = tmpvar_26.x;
  tmpvar_28.y = (tmpvar_25 / ((1.0 - 
    abs(((2.0 * tmpvar_27) - 1.0))
  ) + 1e-7));
  tmpvar_28.z = tmpvar_27;
  highp vec3 tmpvar_29;
  tmpvar_29.x = (abs((
    (6.0 * tmpvar_17.x)
   - 3.0)) - 1.0);
  tmpvar_29.y = (2.0 - abs((
    (6.0 * tmpvar_17.x)
   - 2.0)));
  tmpvar_29.z = (2.0 - abs((
    (6.0 * tmpvar_17.x)
   - 4.0)));
  highp vec4 tmpvar_30;
  tmpvar_30.xyz = mix (RColor_2.xyz, ((
    (clamp (tmpvar_29, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)) - 0.5)
   * 
    ((1.0 - abs((
      (2.0 * tmpvar_18)
     - 1.0))) * tmpvar_28.y)
  ) + tmpvar_18), vec3(tmpvar_6));
  tmpvar_30.w = 1.0;
  tmpvar_1 = tmpvar_30;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LUMINOSITY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Use3DAnchor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_AnchorPoint",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Rotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Scale",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_HorizontalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VerticalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainSize;
uniform highp vec2 _MainPivot;
uniform highp float _Use3DAnchor;
uniform highp vec3 _AnchorPoint;
uniform highp vec3 _Rotation;
uniform highp vec2 _Scale;
uniform highp vec2 _VideoSize;
uniform highp float _HorizontalFlip;
uniform highp float _VerticalFlip;
highp vec2 xlat_mutable_Scale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  xlat_mutable_Scale = _Scale;
  highp vec2 tmpvar_1;
  tmpvar_1 = _glesMultiTexCoord0.xy;
  highp vec4 tmpvar_2;
  tmpvar_2 = vec4(0.0, 0.0, 0.0, 0.0);
  highp vec2 anchor_3;
  highp mat4 tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (_MainSize.x * 0.5);
  tmpvar_4[0].x = tmpvar_5;
  tmpvar_4[0].y = 0.0;
  tmpvar_4[0].z = 0.0;
  tmpvar_4[0].w = 0.0;
  tmpvar_4[1].x = 0.0;
  highp float tmpvar_6;
  tmpvar_6 = (_MainSize.y * 0.5);
  tmpvar_4[1].y = tmpvar_6;
  tmpvar_4[1].z = 0.0;
  tmpvar_4[1].w = 0.0;
  tmpvar_4[2].x = 0.0;
  tmpvar_4[2].y = 0.0;
  tmpvar_4[2].z = 1.0;
  tmpvar_4[2].w = 0.0;
  tmpvar_4[3].x = tmpvar_5;
  tmpvar_4[3].y = tmpvar_6;
  tmpvar_4[3].z = 0.0;
  tmpvar_4[3].w = 1.0;
  highp mat4 tmpvar_7;
  tmpvar_7[0].x = 1.0;
  tmpvar_7[0].y = 0.0;
  tmpvar_7[0].z = 0.0;
  tmpvar_7[0].w = 0.0;
  tmpvar_7[1].x = 0.0;
  tmpvar_7[1].y = 1.0;
  tmpvar_7[1].z = 0.0;
  tmpvar_7[1].w = 0.0;
  tmpvar_7[2].x = 0.0;
  tmpvar_7[2].y = 0.0;
  tmpvar_7[2].z = 1.0;
  tmpvar_7[2].w = 0.0;
  tmpvar_7[3].x = -(_MainPivot.x);
  tmpvar_7[3].y = (_MainPivot.y - _MainSize.y);
  tmpvar_7[3].z = 0.0;
  tmpvar_7[3].w = 1.0;
  highp float tmpvar_8;
  tmpvar_8 = cos(_Rotation.z);
  highp float tmpvar_9;
  tmpvar_9 = sin(_Rotation.z);
  if ((_HorizontalFlip > 0.1)) {
    xlat_mutable_Scale.x = -(_Scale.x);
  };
  if ((_VerticalFlip > 0.1)) {
    xlat_mutable_Scale.y = -(_Scale.y);
  };
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = (tmpvar_8 * xlat_mutable_Scale.x);
  tmpvar_10[0].y = (tmpvar_9 * xlat_mutable_Scale.x);
  tmpvar_10[0].z = 0.0;
  tmpvar_10[0].w = 0.0;
  tmpvar_10[1].x = (-(tmpvar_9) * xlat_mutable_Scale.y);
  tmpvar_10[1].y = (tmpvar_8 * xlat_mutable_Scale.y);
  tmpvar_10[1].z = 0.0;
  tmpvar_10[1].w = 0.0;
  tmpvar_10[2].x = 0.0;
  tmpvar_10[2].y = 0.0;
  tmpvar_10[2].z = 1.0;
  tmpvar_10[2].w = 0.0;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  anchor_3 = vec2(0.0, 0.0);
  if ((_Use3DAnchor > 0.1)) {
    highp vec4 tmpvar_11;
    highp vec4 tmpvar_12;
    tmpvar_12.w = 1.0;
    tmpvar_12.xyz = _AnchorPoint;
    tmpvar_11 = (CAMERA_VIEWPROJ * tmpvar_12);
    anchor_3 = (tmpvar_11.xy / tmpvar_11.w);
    anchor_3 = (((anchor_3 * 0.5) + 0.5) * _VideoSize);
  } else {
    highp vec2 tmpvar_13;
    tmpvar_13.x = _AnchorPoint.x;
    tmpvar_13.y = (_VideoSize.y - _AnchorPoint.y);
    anchor_3 = tmpvar_13;
  };
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 1.0;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.0;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 1.0;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.0;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 1.0;
  tmpvar_14[2].w = 0.0;
  tmpvar_14[3].x = anchor_3.x;
  tmpvar_14[3].y = anchor_3.y;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = (2.0 / _VideoSize.x);
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.0;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = (2.0 / _VideoSize.y);
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.0;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 1.0;
  tmpvar_15[2].w = 0.0;
  tmpvar_15[3].x = -1.0;
  tmpvar_15[3].y = -1.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  tmpvar_2 = ((tmpvar_15 * (tmpvar_14 * 
    (tmpvar_10 * (tmpvar_7 * tmpvar_4))
  )) * _glesVertex);
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_2 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_2.zw;
  highp vec4 tmpvar_18;
  tmpvar_18.zw = vec2(0.0, 1.0);
  tmpvar_18.xy = tmpvar_2.xy;
  highp vec4 tmpvar_19;
  tmpvar_19.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_19.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_18);
  tmpvar_2 = tmpvar_20;
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = o_16;
  gl_Position = tmpvar_20;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_MainTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = MColor_3.xyz;
  highp float tmpvar_6;
  tmpvar_6 = (MColor_3.w * _Opacity);
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_GRAP, tmpvar_7);
  RColor_2 = tmpvar_8;
  highp vec3 tmpvar_9;
  tmpvar_9 = RColor_2.xyz;
  highp vec4 tmpvar_10;
  if ((RColor_2.y < RColor_2.z)) {
    highp vec4 tmpvar_11;
    tmpvar_11.zw = vec2(-1.0, 0.6666667);
    tmpvar_11.xy = tmpvar_9.zy;
    tmpvar_10 = tmpvar_11;
  } else {
    highp vec4 tmpvar_12;
    tmpvar_12.zw = vec2(0.0, -0.3333333);
    tmpvar_12.xy = tmpvar_9.yz;
    tmpvar_10 = tmpvar_12;
  };
  highp vec4 tmpvar_13;
  if ((RColor_2.x < tmpvar_10.x)) {
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = tmpvar_10.xyw;
    tmpvar_14.w = tmpvar_9.x;
    tmpvar_13 = tmpvar_14;
  } else {
    highp vec4 tmpvar_15;
    tmpvar_15.x = tmpvar_9.x;
    tmpvar_15.yzw = tmpvar_10.yzx;
    tmpvar_13 = tmpvar_15;
  };
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_13.x - min (tmpvar_13.w, tmpvar_13.y));
  highp vec3 tmpvar_17;
  tmpvar_17.x = abs(((
    (tmpvar_13.w - tmpvar_13.y)
   / 
    ((6.0 * tmpvar_16) + 1e-7)
  ) + tmpvar_13.z));
  tmpvar_17.y = tmpvar_16;
  tmpvar_17.z = tmpvar_13.x;
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_13.x - (tmpvar_16 * 0.5));
  highp vec3 tmpvar_19;
  tmpvar_19.x = tmpvar_17.x;
  tmpvar_19.y = (tmpvar_16 / ((1.0 - 
    abs(((2.0 * tmpvar_18) - 1.0))
  ) + 1e-7));
  tmpvar_19.z = tmpvar_18;
  highp vec4 tmpvar_20;
  if ((MColor_3.y < MColor_3.z)) {
    highp vec4 tmpvar_21;
    tmpvar_21.zw = vec2(-1.0, 0.6666667);
    tmpvar_21.xy = tmpvar_5.zy;
    tmpvar_20 = tmpvar_21;
  } else {
    highp vec4 tmpvar_22;
    tmpvar_22.zw = vec2(0.0, -0.3333333);
    tmpvar_22.xy = tmpvar_5.yz;
    tmpvar_20 = tmpvar_22;
  };
  highp vec4 tmpvar_23;
  if ((MColor_3.x < tmpvar_20.x)) {
    highp vec4 tmpvar_24;
    tmpvar_24.xyz = tmpvar_20.xyw;
    tmpvar_24.w = tmpvar_5.x;
    tmpvar_23 = tmpvar_24;
  } else {
    highp vec4 tmpvar_25;
    tmpvar_25.x = tmpvar_5.x;
    tmpvar_25.yzw = tmpvar_20.yzx;
    tmpvar_23 = tmpvar_25;
  };
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_23.x - ((tmpvar_23.x - 
    min (tmpvar_23.w, tmpvar_23.y)
  ) * 0.5));
  highp vec3 tmpvar_27;
  tmpvar_27.x = (abs((
    (6.0 * tmpvar_17.x)
   - 3.0)) - 1.0);
  tmpvar_27.y = (2.0 - abs((
    (6.0 * tmpvar_17.x)
   - 2.0)));
  tmpvar_27.z = (2.0 - abs((
    (6.0 * tmpvar_17.x)
   - 4.0)));
  highp vec4 tmpvar_28;
  tmpvar_28.xyz = mix (RColor_2.xyz, ((
    (clamp (tmpvar_27, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)) - 0.5)
   * 
    ((1.0 - abs((
      (2.0 * tmpvar_26)
     - 1.0))) * tmpvar_19.y)
  ) + tmpvar_26), vec3(tmpvar_6));
  tmpvar_28.w = 1.0;
  tmpvar_1 = tmpvar_28;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_COLOR"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Use3DAnchor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_AnchorPoint",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Rotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Scale",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_HorizontalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VerticalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainSize;
uniform highp vec2 _MainPivot;
uniform highp float _Use3DAnchor;
uniform highp vec3 _AnchorPoint;
uniform highp vec3 _Rotation;
uniform highp vec2 _Scale;
uniform highp vec2 _VideoSize;
uniform highp float _HorizontalFlip;
uniform highp float _VerticalFlip;
highp vec2 xlat_mutable_Scale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  xlat_mutable_Scale = _Scale;
  highp vec2 tmpvar_1;
  tmpvar_1 = _glesMultiTexCoord0.xy;
  highp vec4 tmpvar_2;
  tmpvar_2 = vec4(0.0, 0.0, 0.0, 0.0);
  highp vec2 anchor_3;
  highp mat4 tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (_MainSize.x * 0.5);
  tmpvar_4[0].x = tmpvar_5;
  tmpvar_4[0].y = 0.0;
  tmpvar_4[0].z = 0.0;
  tmpvar_4[0].w = 0.0;
  tmpvar_4[1].x = 0.0;
  highp float tmpvar_6;
  tmpvar_6 = (_MainSize.y * 0.5);
  tmpvar_4[1].y = tmpvar_6;
  tmpvar_4[1].z = 0.0;
  tmpvar_4[1].w = 0.0;
  tmpvar_4[2].x = 0.0;
  tmpvar_4[2].y = 0.0;
  tmpvar_4[2].z = 1.0;
  tmpvar_4[2].w = 0.0;
  tmpvar_4[3].x = tmpvar_5;
  tmpvar_4[3].y = tmpvar_6;
  tmpvar_4[3].z = 0.0;
  tmpvar_4[3].w = 1.0;
  highp mat4 tmpvar_7;
  tmpvar_7[0].x = 1.0;
  tmpvar_7[0].y = 0.0;
  tmpvar_7[0].z = 0.0;
  tmpvar_7[0].w = 0.0;
  tmpvar_7[1].x = 0.0;
  tmpvar_7[1].y = 1.0;
  tmpvar_7[1].z = 0.0;
  tmpvar_7[1].w = 0.0;
  tmpvar_7[2].x = 0.0;
  tmpvar_7[2].y = 0.0;
  tmpvar_7[2].z = 1.0;
  tmpvar_7[2].w = 0.0;
  tmpvar_7[3].x = -(_MainPivot.x);
  tmpvar_7[3].y = (_MainPivot.y - _MainSize.y);
  tmpvar_7[3].z = 0.0;
  tmpvar_7[3].w = 1.0;
  highp float tmpvar_8;
  tmpvar_8 = cos(_Rotation.z);
  highp float tmpvar_9;
  tmpvar_9 = sin(_Rotation.z);
  if ((_HorizontalFlip > 0.1)) {
    xlat_mutable_Scale.x = -(_Scale.x);
  };
  if ((_VerticalFlip > 0.1)) {
    xlat_mutable_Scale.y = -(_Scale.y);
  };
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = (tmpvar_8 * xlat_mutable_Scale.x);
  tmpvar_10[0].y = (tmpvar_9 * xlat_mutable_Scale.x);
  tmpvar_10[0].z = 0.0;
  tmpvar_10[0].w = 0.0;
  tmpvar_10[1].x = (-(tmpvar_9) * xlat_mutable_Scale.y);
  tmpvar_10[1].y = (tmpvar_8 * xlat_mutable_Scale.y);
  tmpvar_10[1].z = 0.0;
  tmpvar_10[1].w = 0.0;
  tmpvar_10[2].x = 0.0;
  tmpvar_10[2].y = 0.0;
  tmpvar_10[2].z = 1.0;
  tmpvar_10[2].w = 0.0;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  anchor_3 = vec2(0.0, 0.0);
  if ((_Use3DAnchor > 0.1)) {
    highp vec4 tmpvar_11;
    highp vec4 tmpvar_12;
    tmpvar_12.w = 1.0;
    tmpvar_12.xyz = _AnchorPoint;
    tmpvar_11 = (CAMERA_VIEWPROJ * tmpvar_12);
    anchor_3 = (tmpvar_11.xy / tmpvar_11.w);
    anchor_3 = (((anchor_3 * 0.5) + 0.5) * _VideoSize);
  } else {
    highp vec2 tmpvar_13;
    tmpvar_13.x = _AnchorPoint.x;
    tmpvar_13.y = (_VideoSize.y - _AnchorPoint.y);
    anchor_3 = tmpvar_13;
  };
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 1.0;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.0;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 1.0;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.0;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 1.0;
  tmpvar_14[2].w = 0.0;
  tmpvar_14[3].x = anchor_3.x;
  tmpvar_14[3].y = anchor_3.y;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = (2.0 / _VideoSize.x);
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.0;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = (2.0 / _VideoSize.y);
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.0;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 1.0;
  tmpvar_15[2].w = 0.0;
  tmpvar_15[3].x = -1.0;
  tmpvar_15[3].y = -1.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  tmpvar_2 = ((tmpvar_15 * (tmpvar_14 * 
    (tmpvar_10 * (tmpvar_7 * tmpvar_4))
  )) * _glesVertex);
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_2 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_2.zw;
  highp vec4 tmpvar_18;
  tmpvar_18.zw = vec2(0.0, 1.0);
  tmpvar_18.xy = tmpvar_2.xy;
  highp vec4 tmpvar_19;
  tmpvar_19.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_19.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_18);
  tmpvar_2 = tmpvar_20;
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = o_16;
  gl_Position = tmpvar_20;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_MainTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = MColor_3.xyz;
  highp float tmpvar_6;
  tmpvar_6 = (MColor_3.w * _Opacity);
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_GRAP, tmpvar_7);
  RColor_2 = tmpvar_8;
  highp vec3 tmpvar_9;
  tmpvar_9 = RColor_2.xyz;
  highp vec4 tmpvar_10;
  if ((RColor_2.y < RColor_2.z)) {
    highp vec4 tmpvar_11;
    tmpvar_11.zw = vec2(-1.0, 0.6666667);
    tmpvar_11.xy = tmpvar_9.zy;
    tmpvar_10 = tmpvar_11;
  } else {
    highp vec4 tmpvar_12;
    tmpvar_12.zw = vec2(0.0, -0.3333333);
    tmpvar_12.xy = tmpvar_9.yz;
    tmpvar_10 = tmpvar_12;
  };
  highp vec4 tmpvar_13;
  if ((RColor_2.x < tmpvar_10.x)) {
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = tmpvar_10.xyw;
    tmpvar_14.w = tmpvar_9.x;
    tmpvar_13 = tmpvar_14;
  } else {
    highp vec4 tmpvar_15;
    tmpvar_15.x = tmpvar_9.x;
    tmpvar_15.yzw = tmpvar_10.yzx;
    tmpvar_13 = tmpvar_15;
  };
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_13.x - ((tmpvar_13.x - 
    min (tmpvar_13.w, tmpvar_13.y)
  ) * 0.5));
  highp vec4 tmpvar_17;
  if ((MColor_3.y < MColor_3.z)) {
    highp vec4 tmpvar_18;
    tmpvar_18.zw = vec2(-1.0, 0.6666667);
    tmpvar_18.xy = tmpvar_5.zy;
    tmpvar_17 = tmpvar_18;
  } else {
    highp vec4 tmpvar_19;
    tmpvar_19.zw = vec2(0.0, -0.3333333);
    tmpvar_19.xy = tmpvar_5.yz;
    tmpvar_17 = tmpvar_19;
  };
  highp vec4 tmpvar_20;
  if ((MColor_3.x < tmpvar_17.x)) {
    highp vec4 tmpvar_21;
    tmpvar_21.xyz = tmpvar_17.xyw;
    tmpvar_21.w = tmpvar_5.x;
    tmpvar_20 = tmpvar_21;
  } else {
    highp vec4 tmpvar_22;
    tmpvar_22.x = tmpvar_5.x;
    tmpvar_22.yzw = tmpvar_17.yzx;
    tmpvar_20 = tmpvar_22;
  };
  highp float tmpvar_23;
  tmpvar_23 = (tmpvar_20.x - min (tmpvar_20.w, tmpvar_20.y));
  highp vec3 tmpvar_24;
  tmpvar_24.x = abs(((
    (tmpvar_20.w - tmpvar_20.y)
   / 
    ((6.0 * tmpvar_23) + 1e-7)
  ) + tmpvar_20.z));
  tmpvar_24.y = tmpvar_23;
  tmpvar_24.z = tmpvar_20.x;
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_20.x - (tmpvar_23 * 0.5));
  highp vec3 tmpvar_26;
  tmpvar_26.x = tmpvar_24.x;
  tmpvar_26.y = (tmpvar_23 / ((1.0 - 
    abs(((2.0 * tmpvar_25) - 1.0))
  ) + 1e-7));
  tmpvar_26.z = tmpvar_25;
  highp vec3 tmpvar_27;
  tmpvar_27.x = (abs((
    (6.0 * tmpvar_24.x)
   - 3.0)) - 1.0);
  tmpvar_27.y = (2.0 - abs((
    (6.0 * tmpvar_24.x)
   - 2.0)));
  tmpvar_27.z = (2.0 - abs((
    (6.0 * tmpvar_24.x)
   - 4.0)));
  highp vec4 tmpvar_28;
  tmpvar_28.xyz = mix (RColor_2.xyz, ((
    (clamp (tmpvar_27, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)) - 0.5)
   * 
    ((1.0 - abs((
      (2.0 * tmpvar_16)
     - 1.0))) * tmpvar_26.y)
  ) + tmpvar_16), vec3(tmpvar_6));
  tmpvar_28.w = 1.0;
  tmpvar_1 = tmpvar_28;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_BLEND"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Use3DAnchor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_AnchorPoint",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Rotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Scale",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_HorizontalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VerticalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainSize;
uniform highp vec2 _MainPivot;
uniform highp float _Use3DAnchor;
uniform highp vec3 _AnchorPoint;
uniform highp vec3 _Rotation;
uniform highp vec2 _Scale;
uniform highp vec2 _VideoSize;
uniform highp float _HorizontalFlip;
uniform highp float _VerticalFlip;
highp vec2 xlat_mutable_Scale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  xlat_mutable_Scale = _Scale;
  highp vec2 tmpvar_1;
  tmpvar_1 = _glesMultiTexCoord0.xy;
  highp vec4 tmpvar_2;
  tmpvar_2 = vec4(0.0, 0.0, 0.0, 0.0);
  highp vec2 anchor_3;
  highp mat4 tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (_MainSize.x * 0.5);
  tmpvar_4[0].x = tmpvar_5;
  tmpvar_4[0].y = 0.0;
  tmpvar_4[0].z = 0.0;
  tmpvar_4[0].w = 0.0;
  tmpvar_4[1].x = 0.0;
  highp float tmpvar_6;
  tmpvar_6 = (_MainSize.y * 0.5);
  tmpvar_4[1].y = tmpvar_6;
  tmpvar_4[1].z = 0.0;
  tmpvar_4[1].w = 0.0;
  tmpvar_4[2].x = 0.0;
  tmpvar_4[2].y = 0.0;
  tmpvar_4[2].z = 1.0;
  tmpvar_4[2].w = 0.0;
  tmpvar_4[3].x = tmpvar_5;
  tmpvar_4[3].y = tmpvar_6;
  tmpvar_4[3].z = 0.0;
  tmpvar_4[3].w = 1.0;
  highp mat4 tmpvar_7;
  tmpvar_7[0].x = 1.0;
  tmpvar_7[0].y = 0.0;
  tmpvar_7[0].z = 0.0;
  tmpvar_7[0].w = 0.0;
  tmpvar_7[1].x = 0.0;
  tmpvar_7[1].y = 1.0;
  tmpvar_7[1].z = 0.0;
  tmpvar_7[1].w = 0.0;
  tmpvar_7[2].x = 0.0;
  tmpvar_7[2].y = 0.0;
  tmpvar_7[2].z = 1.0;
  tmpvar_7[2].w = 0.0;
  tmpvar_7[3].x = -(_MainPivot.x);
  tmpvar_7[3].y = (_MainPivot.y - _MainSize.y);
  tmpvar_7[3].z = 0.0;
  tmpvar_7[3].w = 1.0;
  highp float tmpvar_8;
  tmpvar_8 = cos(_Rotation.z);
  highp float tmpvar_9;
  tmpvar_9 = sin(_Rotation.z);
  if ((_HorizontalFlip > 0.1)) {
    xlat_mutable_Scale.x = -(_Scale.x);
  };
  if ((_VerticalFlip > 0.1)) {
    xlat_mutable_Scale.y = -(_Scale.y);
  };
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = (tmpvar_8 * xlat_mutable_Scale.x);
  tmpvar_10[0].y = (tmpvar_9 * xlat_mutable_Scale.x);
  tmpvar_10[0].z = 0.0;
  tmpvar_10[0].w = 0.0;
  tmpvar_10[1].x = (-(tmpvar_9) * xlat_mutable_Scale.y);
  tmpvar_10[1].y = (tmpvar_8 * xlat_mutable_Scale.y);
  tmpvar_10[1].z = 0.0;
  tmpvar_10[1].w = 0.0;
  tmpvar_10[2].x = 0.0;
  tmpvar_10[2].y = 0.0;
  tmpvar_10[2].z = 1.0;
  tmpvar_10[2].w = 0.0;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  anchor_3 = vec2(0.0, 0.0);
  if ((_Use3DAnchor > 0.1)) {
    highp vec4 tmpvar_11;
    highp vec4 tmpvar_12;
    tmpvar_12.w = 1.0;
    tmpvar_12.xyz = _AnchorPoint;
    tmpvar_11 = (CAMERA_VIEWPROJ * tmpvar_12);
    anchor_3 = (tmpvar_11.xy / tmpvar_11.w);
    anchor_3 = (((anchor_3 * 0.5) + 0.5) * _VideoSize);
  } else {
    highp vec2 tmpvar_13;
    tmpvar_13.x = _AnchorPoint.x;
    tmpvar_13.y = (_VideoSize.y - _AnchorPoint.y);
    anchor_3 = tmpvar_13;
  };
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 1.0;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.0;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 1.0;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.0;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 1.0;
  tmpvar_14[2].w = 0.0;
  tmpvar_14[3].x = anchor_3.x;
  tmpvar_14[3].y = anchor_3.y;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = (2.0 / _VideoSize.x);
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.0;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = (2.0 / _VideoSize.y);
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.0;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 1.0;
  tmpvar_15[2].w = 0.0;
  tmpvar_15[3].x = -1.0;
  tmpvar_15[3].y = -1.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  tmpvar_2 = ((tmpvar_15 * (tmpvar_14 * 
    (tmpvar_10 * (tmpvar_7 * tmpvar_4))
  )) * _glesVertex);
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_2 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_2.zw;
  highp vec4 tmpvar_18;
  tmpvar_18.zw = vec2(0.0, 1.0);
  tmpvar_18.xy = tmpvar_2.xy;
  highp vec4 tmpvar_19;
  tmpvar_19.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_19.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_18);
  tmpvar_2 = tmpvar_20;
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = o_16;
  gl_Position = tmpvar_20;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_MainTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_5 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_GRAP, tmpvar_5);
  RColor_2 = tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.xyz = mix (RColor_2.xyz, ((
    dot (vec3(0.299, 0.587, 0.114), RColor_2.xyz)
   * 1.68) * MColor_3.xyz), vec3((MColor_3.w * _Opacity)));
  tmpvar_7.w = 1.0;
  tmpvar_1 = tmpvar_7;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_EXCLUSION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Use3DAnchor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_AnchorPoint",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Rotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Scale",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_HorizontalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VerticalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainSize;
uniform highp vec2 _MainPivot;
uniform highp float _Use3DAnchor;
uniform highp vec3 _AnchorPoint;
uniform highp vec3 _Rotation;
uniform highp vec2 _Scale;
uniform highp vec2 _VideoSize;
uniform highp float _HorizontalFlip;
uniform highp float _VerticalFlip;
highp vec2 xlat_mutable_Scale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  xlat_mutable_Scale = _Scale;
  highp vec2 tmpvar_1;
  tmpvar_1 = _glesMultiTexCoord0.xy;
  highp vec4 tmpvar_2;
  tmpvar_2 = vec4(0.0, 0.0, 0.0, 0.0);
  highp vec2 anchor_3;
  highp mat4 tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (_MainSize.x * 0.5);
  tmpvar_4[0].x = tmpvar_5;
  tmpvar_4[0].y = 0.0;
  tmpvar_4[0].z = 0.0;
  tmpvar_4[0].w = 0.0;
  tmpvar_4[1].x = 0.0;
  highp float tmpvar_6;
  tmpvar_6 = (_MainSize.y * 0.5);
  tmpvar_4[1].y = tmpvar_6;
  tmpvar_4[1].z = 0.0;
  tmpvar_4[1].w = 0.0;
  tmpvar_4[2].x = 0.0;
  tmpvar_4[2].y = 0.0;
  tmpvar_4[2].z = 1.0;
  tmpvar_4[2].w = 0.0;
  tmpvar_4[3].x = tmpvar_5;
  tmpvar_4[3].y = tmpvar_6;
  tmpvar_4[3].z = 0.0;
  tmpvar_4[3].w = 1.0;
  highp mat4 tmpvar_7;
  tmpvar_7[0].x = 1.0;
  tmpvar_7[0].y = 0.0;
  tmpvar_7[0].z = 0.0;
  tmpvar_7[0].w = 0.0;
  tmpvar_7[1].x = 0.0;
  tmpvar_7[1].y = 1.0;
  tmpvar_7[1].z = 0.0;
  tmpvar_7[1].w = 0.0;
  tmpvar_7[2].x = 0.0;
  tmpvar_7[2].y = 0.0;
  tmpvar_7[2].z = 1.0;
  tmpvar_7[2].w = 0.0;
  tmpvar_7[3].x = -(_MainPivot.x);
  tmpvar_7[3].y = (_MainPivot.y - _MainSize.y);
  tmpvar_7[3].z = 0.0;
  tmpvar_7[3].w = 1.0;
  highp float tmpvar_8;
  tmpvar_8 = cos(_Rotation.z);
  highp float tmpvar_9;
  tmpvar_9 = sin(_Rotation.z);
  if ((_HorizontalFlip > 0.1)) {
    xlat_mutable_Scale.x = -(_Scale.x);
  };
  if ((_VerticalFlip > 0.1)) {
    xlat_mutable_Scale.y = -(_Scale.y);
  };
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = (tmpvar_8 * xlat_mutable_Scale.x);
  tmpvar_10[0].y = (tmpvar_9 * xlat_mutable_Scale.x);
  tmpvar_10[0].z = 0.0;
  tmpvar_10[0].w = 0.0;
  tmpvar_10[1].x = (-(tmpvar_9) * xlat_mutable_Scale.y);
  tmpvar_10[1].y = (tmpvar_8 * xlat_mutable_Scale.y);
  tmpvar_10[1].z = 0.0;
  tmpvar_10[1].w = 0.0;
  tmpvar_10[2].x = 0.0;
  tmpvar_10[2].y = 0.0;
  tmpvar_10[2].z = 1.0;
  tmpvar_10[2].w = 0.0;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  anchor_3 = vec2(0.0, 0.0);
  if ((_Use3DAnchor > 0.1)) {
    highp vec4 tmpvar_11;
    highp vec4 tmpvar_12;
    tmpvar_12.w = 1.0;
    tmpvar_12.xyz = _AnchorPoint;
    tmpvar_11 = (CAMERA_VIEWPROJ * tmpvar_12);
    anchor_3 = (tmpvar_11.xy / tmpvar_11.w);
    anchor_3 = (((anchor_3 * 0.5) + 0.5) * _VideoSize);
  } else {
    highp vec2 tmpvar_13;
    tmpvar_13.x = _AnchorPoint.x;
    tmpvar_13.y = (_VideoSize.y - _AnchorPoint.y);
    anchor_3 = tmpvar_13;
  };
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 1.0;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.0;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 1.0;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.0;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 1.0;
  tmpvar_14[2].w = 0.0;
  tmpvar_14[3].x = anchor_3.x;
  tmpvar_14[3].y = anchor_3.y;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = (2.0 / _VideoSize.x);
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.0;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = (2.0 / _VideoSize.y);
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.0;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 1.0;
  tmpvar_15[2].w = 0.0;
  tmpvar_15[3].x = -1.0;
  tmpvar_15[3].y = -1.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  tmpvar_2 = ((tmpvar_15 * (tmpvar_14 * 
    (tmpvar_10 * (tmpvar_7 * tmpvar_4))
  )) * _glesVertex);
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_2 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_2.zw;
  highp vec4 tmpvar_18;
  tmpvar_18.zw = vec2(0.0, 1.0);
  tmpvar_18.xy = tmpvar_2.xy;
  highp vec4 tmpvar_19;
  tmpvar_19.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_19.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_18);
  tmpvar_2 = tmpvar_20;
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = o_16;
  gl_Position = tmpvar_20;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_MainTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_5 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_GRAP, tmpvar_5);
  RColor_2 = tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.xyz = mix (RColor_2.xyz, ((RColor_2.xyz + MColor_3.xyz) - (
    (2.0 * RColor_2.xyz)
   * MColor_3.xyz)), vec3((MColor_3.w * _Opacity)));
  tmpvar_7.w = 1.0;
  tmpvar_1 = tmpvar_7;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_HARDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Use3DAnchor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_AnchorPoint",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Rotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Scale",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_HorizontalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VerticalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainSize;
uniform highp vec2 _MainPivot;
uniform highp float _Use3DAnchor;
uniform highp vec3 _AnchorPoint;
uniform highp vec3 _Rotation;
uniform highp vec2 _Scale;
uniform highp vec2 _VideoSize;
uniform highp float _HorizontalFlip;
uniform highp float _VerticalFlip;
highp vec2 xlat_mutable_Scale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  xlat_mutable_Scale = _Scale;
  highp vec2 tmpvar_1;
  tmpvar_1 = _glesMultiTexCoord0.xy;
  highp vec4 tmpvar_2;
  tmpvar_2 = vec4(0.0, 0.0, 0.0, 0.0);
  highp vec2 anchor_3;
  highp mat4 tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (_MainSize.x * 0.5);
  tmpvar_4[0].x = tmpvar_5;
  tmpvar_4[0].y = 0.0;
  tmpvar_4[0].z = 0.0;
  tmpvar_4[0].w = 0.0;
  tmpvar_4[1].x = 0.0;
  highp float tmpvar_6;
  tmpvar_6 = (_MainSize.y * 0.5);
  tmpvar_4[1].y = tmpvar_6;
  tmpvar_4[1].z = 0.0;
  tmpvar_4[1].w = 0.0;
  tmpvar_4[2].x = 0.0;
  tmpvar_4[2].y = 0.0;
  tmpvar_4[2].z = 1.0;
  tmpvar_4[2].w = 0.0;
  tmpvar_4[3].x = tmpvar_5;
  tmpvar_4[3].y = tmpvar_6;
  tmpvar_4[3].z = 0.0;
  tmpvar_4[3].w = 1.0;
  highp mat4 tmpvar_7;
  tmpvar_7[0].x = 1.0;
  tmpvar_7[0].y = 0.0;
  tmpvar_7[0].z = 0.0;
  tmpvar_7[0].w = 0.0;
  tmpvar_7[1].x = 0.0;
  tmpvar_7[1].y = 1.0;
  tmpvar_7[1].z = 0.0;
  tmpvar_7[1].w = 0.0;
  tmpvar_7[2].x = 0.0;
  tmpvar_7[2].y = 0.0;
  tmpvar_7[2].z = 1.0;
  tmpvar_7[2].w = 0.0;
  tmpvar_7[3].x = -(_MainPivot.x);
  tmpvar_7[3].y = (_MainPivot.y - _MainSize.y);
  tmpvar_7[3].z = 0.0;
  tmpvar_7[3].w = 1.0;
  highp float tmpvar_8;
  tmpvar_8 = cos(_Rotation.z);
  highp float tmpvar_9;
  tmpvar_9 = sin(_Rotation.z);
  if ((_HorizontalFlip > 0.1)) {
    xlat_mutable_Scale.x = -(_Scale.x);
  };
  if ((_VerticalFlip > 0.1)) {
    xlat_mutable_Scale.y = -(_Scale.y);
  };
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = (tmpvar_8 * xlat_mutable_Scale.x);
  tmpvar_10[0].y = (tmpvar_9 * xlat_mutable_Scale.x);
  tmpvar_10[0].z = 0.0;
  tmpvar_10[0].w = 0.0;
  tmpvar_10[1].x = (-(tmpvar_9) * xlat_mutable_Scale.y);
  tmpvar_10[1].y = (tmpvar_8 * xlat_mutable_Scale.y);
  tmpvar_10[1].z = 0.0;
  tmpvar_10[1].w = 0.0;
  tmpvar_10[2].x = 0.0;
  tmpvar_10[2].y = 0.0;
  tmpvar_10[2].z = 1.0;
  tmpvar_10[2].w = 0.0;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  anchor_3 = vec2(0.0, 0.0);
  if ((_Use3DAnchor > 0.1)) {
    highp vec4 tmpvar_11;
    highp vec4 tmpvar_12;
    tmpvar_12.w = 1.0;
    tmpvar_12.xyz = _AnchorPoint;
    tmpvar_11 = (CAMERA_VIEWPROJ * tmpvar_12);
    anchor_3 = (tmpvar_11.xy / tmpvar_11.w);
    anchor_3 = (((anchor_3 * 0.5) + 0.5) * _VideoSize);
  } else {
    highp vec2 tmpvar_13;
    tmpvar_13.x = _AnchorPoint.x;
    tmpvar_13.y = (_VideoSize.y - _AnchorPoint.y);
    anchor_3 = tmpvar_13;
  };
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 1.0;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.0;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 1.0;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.0;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 1.0;
  tmpvar_14[2].w = 0.0;
  tmpvar_14[3].x = anchor_3.x;
  tmpvar_14[3].y = anchor_3.y;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = (2.0 / _VideoSize.x);
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.0;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = (2.0 / _VideoSize.y);
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.0;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 1.0;
  tmpvar_15[2].w = 0.0;
  tmpvar_15[3].x = -1.0;
  tmpvar_15[3].y = -1.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  tmpvar_2 = ((tmpvar_15 * (tmpvar_14 * 
    (tmpvar_10 * (tmpvar_7 * tmpvar_4))
  )) * _glesVertex);
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_2 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_2.zw;
  highp vec4 tmpvar_18;
  tmpvar_18.zw = vec2(0.0, 1.0);
  tmpvar_18.xy = tmpvar_2.xy;
  highp vec4 tmpvar_19;
  tmpvar_19.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_19.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_18);
  tmpvar_2 = tmpvar_20;
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = o_16;
  gl_Position = tmpvar_20;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_MainTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (MColor_3.w * _Opacity);
  highp vec2 tmpvar_6;
  tmpvar_6 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_GRAP, tmpvar_6);
  RColor_2 = tmpvar_7;
  highp float tmpvar_8;
  if ((MColor_3.x < 0.5)) {
    tmpvar_8 = ((2.0 * MColor_3.x) * RColor_2.x);
  } else {
    tmpvar_8 = (1.0 - ((2.0 * 
      (1.0 - MColor_3.x)
    ) * (1.0 - RColor_2.x)));
  };
  highp float tmpvar_9;
  if ((MColor_3.y < 0.5)) {
    tmpvar_9 = ((2.0 * MColor_3.y) * RColor_2.y);
  } else {
    tmpvar_9 = (1.0 - ((2.0 * 
      (1.0 - MColor_3.y)
    ) * (1.0 - RColor_2.y)));
  };
  highp float tmpvar_10;
  if ((MColor_3.z < 0.5)) {
    tmpvar_10 = ((2.0 * MColor_3.z) * RColor_2.z);
  } else {
    tmpvar_10 = (1.0 - ((2.0 * 
      (1.0 - MColor_3.z)
    ) * (1.0 - RColor_2.z)));
  };
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_8;
  tmpvar_11.y = tmpvar_9;
  tmpvar_11.z = tmpvar_10;
  highp vec4 tmpvar_12;
  tmpvar_12.xyz = mix (RColor_2.xyz, tmpvar_11, vec3(tmpvar_5));
  tmpvar_12.w = 1.0;
  tmpvar_1 = tmpvar_12;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_VIVIDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Use3DAnchor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_AnchorPoint",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Rotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Scale",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_HorizontalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VerticalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainSize;
uniform highp vec2 _MainPivot;
uniform highp float _Use3DAnchor;
uniform highp vec3 _AnchorPoint;
uniform highp vec3 _Rotation;
uniform highp vec2 _Scale;
uniform highp vec2 _VideoSize;
uniform highp float _HorizontalFlip;
uniform highp float _VerticalFlip;
highp vec2 xlat_mutable_Scale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  xlat_mutable_Scale = _Scale;
  highp vec2 tmpvar_1;
  tmpvar_1 = _glesMultiTexCoord0.xy;
  highp vec4 tmpvar_2;
  tmpvar_2 = vec4(0.0, 0.0, 0.0, 0.0);
  highp vec2 anchor_3;
  highp mat4 tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (_MainSize.x * 0.5);
  tmpvar_4[0].x = tmpvar_5;
  tmpvar_4[0].y = 0.0;
  tmpvar_4[0].z = 0.0;
  tmpvar_4[0].w = 0.0;
  tmpvar_4[1].x = 0.0;
  highp float tmpvar_6;
  tmpvar_6 = (_MainSize.y * 0.5);
  tmpvar_4[1].y = tmpvar_6;
  tmpvar_4[1].z = 0.0;
  tmpvar_4[1].w = 0.0;
  tmpvar_4[2].x = 0.0;
  tmpvar_4[2].y = 0.0;
  tmpvar_4[2].z = 1.0;
  tmpvar_4[2].w = 0.0;
  tmpvar_4[3].x = tmpvar_5;
  tmpvar_4[3].y = tmpvar_6;
  tmpvar_4[3].z = 0.0;
  tmpvar_4[3].w = 1.0;
  highp mat4 tmpvar_7;
  tmpvar_7[0].x = 1.0;
  tmpvar_7[0].y = 0.0;
  tmpvar_7[0].z = 0.0;
  tmpvar_7[0].w = 0.0;
  tmpvar_7[1].x = 0.0;
  tmpvar_7[1].y = 1.0;
  tmpvar_7[1].z = 0.0;
  tmpvar_7[1].w = 0.0;
  tmpvar_7[2].x = 0.0;
  tmpvar_7[2].y = 0.0;
  tmpvar_7[2].z = 1.0;
  tmpvar_7[2].w = 0.0;
  tmpvar_7[3].x = -(_MainPivot.x);
  tmpvar_7[3].y = (_MainPivot.y - _MainSize.y);
  tmpvar_7[3].z = 0.0;
  tmpvar_7[3].w = 1.0;
  highp float tmpvar_8;
  tmpvar_8 = cos(_Rotation.z);
  highp float tmpvar_9;
  tmpvar_9 = sin(_Rotation.z);
  if ((_HorizontalFlip > 0.1)) {
    xlat_mutable_Scale.x = -(_Scale.x);
  };
  if ((_VerticalFlip > 0.1)) {
    xlat_mutable_Scale.y = -(_Scale.y);
  };
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = (tmpvar_8 * xlat_mutable_Scale.x);
  tmpvar_10[0].y = (tmpvar_9 * xlat_mutable_Scale.x);
  tmpvar_10[0].z = 0.0;
  tmpvar_10[0].w = 0.0;
  tmpvar_10[1].x = (-(tmpvar_9) * xlat_mutable_Scale.y);
  tmpvar_10[1].y = (tmpvar_8 * xlat_mutable_Scale.y);
  tmpvar_10[1].z = 0.0;
  tmpvar_10[1].w = 0.0;
  tmpvar_10[2].x = 0.0;
  tmpvar_10[2].y = 0.0;
  tmpvar_10[2].z = 1.0;
  tmpvar_10[2].w = 0.0;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  anchor_3 = vec2(0.0, 0.0);
  if ((_Use3DAnchor > 0.1)) {
    highp vec4 tmpvar_11;
    highp vec4 tmpvar_12;
    tmpvar_12.w = 1.0;
    tmpvar_12.xyz = _AnchorPoint;
    tmpvar_11 = (CAMERA_VIEWPROJ * tmpvar_12);
    anchor_3 = (tmpvar_11.xy / tmpvar_11.w);
    anchor_3 = (((anchor_3 * 0.5) + 0.5) * _VideoSize);
  } else {
    highp vec2 tmpvar_13;
    tmpvar_13.x = _AnchorPoint.x;
    tmpvar_13.y = (_VideoSize.y - _AnchorPoint.y);
    anchor_3 = tmpvar_13;
  };
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 1.0;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.0;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 1.0;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.0;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 1.0;
  tmpvar_14[2].w = 0.0;
  tmpvar_14[3].x = anchor_3.x;
  tmpvar_14[3].y = anchor_3.y;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = (2.0 / _VideoSize.x);
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.0;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = (2.0 / _VideoSize.y);
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.0;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 1.0;
  tmpvar_15[2].w = 0.0;
  tmpvar_15[3].x = -1.0;
  tmpvar_15[3].y = -1.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  tmpvar_2 = ((tmpvar_15 * (tmpvar_14 * 
    (tmpvar_10 * (tmpvar_7 * tmpvar_4))
  )) * _glesVertex);
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_2 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_2.zw;
  highp vec4 tmpvar_18;
  tmpvar_18.zw = vec2(0.0, 1.0);
  tmpvar_18.xy = tmpvar_2.xy;
  highp vec4 tmpvar_19;
  tmpvar_19.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_19.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_18);
  tmpvar_2 = tmpvar_20;
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = o_16;
  gl_Position = tmpvar_20;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp float alpha_3;
  highp vec4 MColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_MainTex, xlv_TEXCOORD0);
  MColor_4 = tmpvar_5;
  alpha_3 = (MColor_4.w * _Opacity);
  highp vec2 tmpvar_6;
  tmpvar_6 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_GRAP, tmpvar_6);
  RColor_2 = tmpvar_7;
  highp float tmpvar_8;
  if ((MColor_4.x < 0.5)) {
    highp float blend_9;
    blend_9 = (2.0 * MColor_4.x);
    highp float tmpvar_10;
    if ((blend_9 == 0.0)) {
      tmpvar_10 = blend_9;
    } else {
      tmpvar_10 = max ((1.0 - (
        (1.0 - RColor_2.x)
       / blend_9)), 0.0);
    };
    tmpvar_8 = tmpvar_10;
  } else {
    highp float blend_11;
    blend_11 = (2.0 * (MColor_4.x - 0.5));
    highp float tmpvar_12;
    if ((blend_11 == 1.0)) {
      tmpvar_12 = blend_11;
    } else {
      tmpvar_12 = min ((RColor_2.x / (1.0 - blend_11)), 1.0);
    };
    tmpvar_8 = tmpvar_12;
  };
  highp float tmpvar_13;
  if ((MColor_4.y < 0.5)) {
    highp float blend_14;
    blend_14 = (2.0 * MColor_4.y);
    highp float tmpvar_15;
    if ((blend_14 == 0.0)) {
      tmpvar_15 = blend_14;
    } else {
      tmpvar_15 = max ((1.0 - (
        (1.0 - RColor_2.y)
       / blend_14)), 0.0);
    };
    tmpvar_13 = tmpvar_15;
  } else {
    highp float blend_16;
    blend_16 = (2.0 * (MColor_4.y - 0.5));
    highp float tmpvar_17;
    if ((blend_16 == 1.0)) {
      tmpvar_17 = blend_16;
    } else {
      tmpvar_17 = min ((RColor_2.y / (1.0 - blend_16)), 1.0);
    };
    tmpvar_13 = tmpvar_17;
  };
  highp float tmpvar_18;
  if ((MColor_4.z < 0.5)) {
    highp float blend_19;
    blend_19 = (2.0 * MColor_4.z);
    highp float tmpvar_20;
    if ((blend_19 == 0.0)) {
      tmpvar_20 = blend_19;
    } else {
      tmpvar_20 = max ((1.0 - (
        (1.0 - RColor_2.z)
       / blend_19)), 0.0);
    };
    tmpvar_18 = tmpvar_20;
  } else {
    highp float blend_21;
    blend_21 = (2.0 * (MColor_4.z - 0.5));
    highp float tmpvar_22;
    if ((blend_21 == 1.0)) {
      tmpvar_22 = blend_21;
    } else {
      tmpvar_22 = min ((RColor_2.z / (1.0 - blend_21)), 1.0);
    };
    tmpvar_18 = tmpvar_22;
  };
  highp vec3 tmpvar_23;
  tmpvar_23.x = tmpvar_8;
  tmpvar_23.y = tmpvar_13;
  tmpvar_23.z = tmpvar_18;
  highp vec4 tmpvar_24;
  tmpvar_24.xyz = mix (RColor_2.xyz, tmpvar_23, vec3(alpha_3));
  tmpvar_24.w = 1.0;
  tmpvar_1 = tmpvar_24;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_OVERLAY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Use3DAnchor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_AnchorPoint",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Rotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Scale",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_HorizontalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VerticalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainSize;
uniform highp vec2 _MainPivot;
uniform highp float _Use3DAnchor;
uniform highp vec3 _AnchorPoint;
uniform highp vec3 _Rotation;
uniform highp vec2 _Scale;
uniform highp vec2 _VideoSize;
uniform highp float _HorizontalFlip;
uniform highp float _VerticalFlip;
highp vec2 xlat_mutable_Scale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  xlat_mutable_Scale = _Scale;
  highp vec2 tmpvar_1;
  tmpvar_1 = _glesMultiTexCoord0.xy;
  highp vec4 tmpvar_2;
  tmpvar_2 = vec4(0.0, 0.0, 0.0, 0.0);
  highp vec2 anchor_3;
  highp mat4 tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (_MainSize.x * 0.5);
  tmpvar_4[0].x = tmpvar_5;
  tmpvar_4[0].y = 0.0;
  tmpvar_4[0].z = 0.0;
  tmpvar_4[0].w = 0.0;
  tmpvar_4[1].x = 0.0;
  highp float tmpvar_6;
  tmpvar_6 = (_MainSize.y * 0.5);
  tmpvar_4[1].y = tmpvar_6;
  tmpvar_4[1].z = 0.0;
  tmpvar_4[1].w = 0.0;
  tmpvar_4[2].x = 0.0;
  tmpvar_4[2].y = 0.0;
  tmpvar_4[2].z = 1.0;
  tmpvar_4[2].w = 0.0;
  tmpvar_4[3].x = tmpvar_5;
  tmpvar_4[3].y = tmpvar_6;
  tmpvar_4[3].z = 0.0;
  tmpvar_4[3].w = 1.0;
  highp mat4 tmpvar_7;
  tmpvar_7[0].x = 1.0;
  tmpvar_7[0].y = 0.0;
  tmpvar_7[0].z = 0.0;
  tmpvar_7[0].w = 0.0;
  tmpvar_7[1].x = 0.0;
  tmpvar_7[1].y = 1.0;
  tmpvar_7[1].z = 0.0;
  tmpvar_7[1].w = 0.0;
  tmpvar_7[2].x = 0.0;
  tmpvar_7[2].y = 0.0;
  tmpvar_7[2].z = 1.0;
  tmpvar_7[2].w = 0.0;
  tmpvar_7[3].x = -(_MainPivot.x);
  tmpvar_7[3].y = (_MainPivot.y - _MainSize.y);
  tmpvar_7[3].z = 0.0;
  tmpvar_7[3].w = 1.0;
  highp float tmpvar_8;
  tmpvar_8 = cos(_Rotation.z);
  highp float tmpvar_9;
  tmpvar_9 = sin(_Rotation.z);
  if ((_HorizontalFlip > 0.1)) {
    xlat_mutable_Scale.x = -(_Scale.x);
  };
  if ((_VerticalFlip > 0.1)) {
    xlat_mutable_Scale.y = -(_Scale.y);
  };
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = (tmpvar_8 * xlat_mutable_Scale.x);
  tmpvar_10[0].y = (tmpvar_9 * xlat_mutable_Scale.x);
  tmpvar_10[0].z = 0.0;
  tmpvar_10[0].w = 0.0;
  tmpvar_10[1].x = (-(tmpvar_9) * xlat_mutable_Scale.y);
  tmpvar_10[1].y = (tmpvar_8 * xlat_mutable_Scale.y);
  tmpvar_10[1].z = 0.0;
  tmpvar_10[1].w = 0.0;
  tmpvar_10[2].x = 0.0;
  tmpvar_10[2].y = 0.0;
  tmpvar_10[2].z = 1.0;
  tmpvar_10[2].w = 0.0;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  anchor_3 = vec2(0.0, 0.0);
  if ((_Use3DAnchor > 0.1)) {
    highp vec4 tmpvar_11;
    highp vec4 tmpvar_12;
    tmpvar_12.w = 1.0;
    tmpvar_12.xyz = _AnchorPoint;
    tmpvar_11 = (CAMERA_VIEWPROJ * tmpvar_12);
    anchor_3 = (tmpvar_11.xy / tmpvar_11.w);
    anchor_3 = (((anchor_3 * 0.5) + 0.5) * _VideoSize);
  } else {
    highp vec2 tmpvar_13;
    tmpvar_13.x = _AnchorPoint.x;
    tmpvar_13.y = (_VideoSize.y - _AnchorPoint.y);
    anchor_3 = tmpvar_13;
  };
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 1.0;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.0;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 1.0;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.0;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 1.0;
  tmpvar_14[2].w = 0.0;
  tmpvar_14[3].x = anchor_3.x;
  tmpvar_14[3].y = anchor_3.y;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = (2.0 / _VideoSize.x);
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.0;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = (2.0 / _VideoSize.y);
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.0;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 1.0;
  tmpvar_15[2].w = 0.0;
  tmpvar_15[3].x = -1.0;
  tmpvar_15[3].y = -1.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  tmpvar_2 = ((tmpvar_15 * (tmpvar_14 * 
    (tmpvar_10 * (tmpvar_7 * tmpvar_4))
  )) * _glesVertex);
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_2 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_2.zw;
  highp vec4 tmpvar_18;
  tmpvar_18.zw = vec2(0.0, 1.0);
  tmpvar_18.xy = tmpvar_2.xy;
  highp vec4 tmpvar_19;
  tmpvar_19.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_19.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_18);
  tmpvar_2 = tmpvar_20;
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = o_16;
  gl_Position = tmpvar_20;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_MainTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (MColor_3.w * _Opacity);
  highp vec2 tmpvar_6;
  tmpvar_6 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_GRAP, tmpvar_6);
  RColor_2 = tmpvar_7;
  highp float tmpvar_8;
  if ((RColor_2.x < 0.5)) {
    tmpvar_8 = ((2.0 * RColor_2.x) * MColor_3.x);
  } else {
    tmpvar_8 = (1.0 - ((2.0 * 
      (1.0 - RColor_2.x)
    ) * (1.0 - MColor_3.x)));
  };
  highp float tmpvar_9;
  if ((RColor_2.y < 0.5)) {
    tmpvar_9 = ((2.0 * RColor_2.y) * MColor_3.y);
  } else {
    tmpvar_9 = (1.0 - ((2.0 * 
      (1.0 - RColor_2.y)
    ) * (1.0 - MColor_3.y)));
  };
  highp float tmpvar_10;
  if ((RColor_2.z < 0.5)) {
    tmpvar_10 = ((2.0 * RColor_2.z) * MColor_3.z);
  } else {
    tmpvar_10 = (1.0 - ((2.0 * 
      (1.0 - RColor_2.z)
    ) * (1.0 - MColor_3.z)));
  };
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_8;
  tmpvar_11.y = tmpvar_9;
  tmpvar_11.z = tmpvar_10;
  highp vec4 tmpvar_12;
  tmpvar_12.xyz = mix (RColor_2.xyz, tmpvar_11, vec3(tmpvar_5));
  tmpvar_12.w = 1.0;
  tmpvar_1 = tmpvar_12;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_COLORBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Use3DAnchor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_AnchorPoint",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Rotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Scale",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_HorizontalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VerticalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainSize;
uniform highp vec2 _MainPivot;
uniform highp float _Use3DAnchor;
uniform highp vec3 _AnchorPoint;
uniform highp vec3 _Rotation;
uniform highp vec2 _Scale;
uniform highp vec2 _VideoSize;
uniform highp float _HorizontalFlip;
uniform highp float _VerticalFlip;
highp vec2 xlat_mutable_Scale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  xlat_mutable_Scale = _Scale;
  highp vec2 tmpvar_1;
  tmpvar_1 = _glesMultiTexCoord0.xy;
  highp vec4 tmpvar_2;
  tmpvar_2 = vec4(0.0, 0.0, 0.0, 0.0);
  highp vec2 anchor_3;
  highp mat4 tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (_MainSize.x * 0.5);
  tmpvar_4[0].x = tmpvar_5;
  tmpvar_4[0].y = 0.0;
  tmpvar_4[0].z = 0.0;
  tmpvar_4[0].w = 0.0;
  tmpvar_4[1].x = 0.0;
  highp float tmpvar_6;
  tmpvar_6 = (_MainSize.y * 0.5);
  tmpvar_4[1].y = tmpvar_6;
  tmpvar_4[1].z = 0.0;
  tmpvar_4[1].w = 0.0;
  tmpvar_4[2].x = 0.0;
  tmpvar_4[2].y = 0.0;
  tmpvar_4[2].z = 1.0;
  tmpvar_4[2].w = 0.0;
  tmpvar_4[3].x = tmpvar_5;
  tmpvar_4[3].y = tmpvar_6;
  tmpvar_4[3].z = 0.0;
  tmpvar_4[3].w = 1.0;
  highp mat4 tmpvar_7;
  tmpvar_7[0].x = 1.0;
  tmpvar_7[0].y = 0.0;
  tmpvar_7[0].z = 0.0;
  tmpvar_7[0].w = 0.0;
  tmpvar_7[1].x = 0.0;
  tmpvar_7[1].y = 1.0;
  tmpvar_7[1].z = 0.0;
  tmpvar_7[1].w = 0.0;
  tmpvar_7[2].x = 0.0;
  tmpvar_7[2].y = 0.0;
  tmpvar_7[2].z = 1.0;
  tmpvar_7[2].w = 0.0;
  tmpvar_7[3].x = -(_MainPivot.x);
  tmpvar_7[3].y = (_MainPivot.y - _MainSize.y);
  tmpvar_7[3].z = 0.0;
  tmpvar_7[3].w = 1.0;
  highp float tmpvar_8;
  tmpvar_8 = cos(_Rotation.z);
  highp float tmpvar_9;
  tmpvar_9 = sin(_Rotation.z);
  if ((_HorizontalFlip > 0.1)) {
    xlat_mutable_Scale.x = -(_Scale.x);
  };
  if ((_VerticalFlip > 0.1)) {
    xlat_mutable_Scale.y = -(_Scale.y);
  };
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = (tmpvar_8 * xlat_mutable_Scale.x);
  tmpvar_10[0].y = (tmpvar_9 * xlat_mutable_Scale.x);
  tmpvar_10[0].z = 0.0;
  tmpvar_10[0].w = 0.0;
  tmpvar_10[1].x = (-(tmpvar_9) * xlat_mutable_Scale.y);
  tmpvar_10[1].y = (tmpvar_8 * xlat_mutable_Scale.y);
  tmpvar_10[1].z = 0.0;
  tmpvar_10[1].w = 0.0;
  tmpvar_10[2].x = 0.0;
  tmpvar_10[2].y = 0.0;
  tmpvar_10[2].z = 1.0;
  tmpvar_10[2].w = 0.0;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  anchor_3 = vec2(0.0, 0.0);
  if ((_Use3DAnchor > 0.1)) {
    highp vec4 tmpvar_11;
    highp vec4 tmpvar_12;
    tmpvar_12.w = 1.0;
    tmpvar_12.xyz = _AnchorPoint;
    tmpvar_11 = (CAMERA_VIEWPROJ * tmpvar_12);
    anchor_3 = (tmpvar_11.xy / tmpvar_11.w);
    anchor_3 = (((anchor_3 * 0.5) + 0.5) * _VideoSize);
  } else {
    highp vec2 tmpvar_13;
    tmpvar_13.x = _AnchorPoint.x;
    tmpvar_13.y = (_VideoSize.y - _AnchorPoint.y);
    anchor_3 = tmpvar_13;
  };
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 1.0;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.0;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 1.0;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.0;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 1.0;
  tmpvar_14[2].w = 0.0;
  tmpvar_14[3].x = anchor_3.x;
  tmpvar_14[3].y = anchor_3.y;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = (2.0 / _VideoSize.x);
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.0;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = (2.0 / _VideoSize.y);
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.0;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 1.0;
  tmpvar_15[2].w = 0.0;
  tmpvar_15[3].x = -1.0;
  tmpvar_15[3].y = -1.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  tmpvar_2 = ((tmpvar_15 * (tmpvar_14 * 
    (tmpvar_10 * (tmpvar_7 * tmpvar_4))
  )) * _glesVertex);
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_2 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_2.zw;
  highp vec4 tmpvar_18;
  tmpvar_18.zw = vec2(0.0, 1.0);
  tmpvar_18.xy = tmpvar_2.xy;
  highp vec4 tmpvar_19;
  tmpvar_19.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_19.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_18);
  tmpvar_2 = tmpvar_20;
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = o_16;
  gl_Position = tmpvar_20;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_MainTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = MColor_3.xyz;
  highp float tmpvar_6;
  tmpvar_6 = (MColor_3.w * _Opacity);
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_GRAP, tmpvar_7);
  RColor_2 = tmpvar_8;
  highp float blend_9;
  blend_9 = tmpvar_5.x;
  highp float tmpvar_10;
  if ((MColor_3.x == 0.0)) {
    tmpvar_10 = blend_9;
  } else {
    tmpvar_10 = max ((1.0 - (
      (1.0 - RColor_2.x)
     / MColor_3.x)), 0.0);
  };
  highp float blend_11;
  blend_11 = tmpvar_5.y;
  highp float tmpvar_12;
  if ((MColor_3.y == 0.0)) {
    tmpvar_12 = blend_11;
  } else {
    tmpvar_12 = max ((1.0 - (
      (1.0 - RColor_2.y)
     / MColor_3.y)), 0.0);
  };
  highp float blend_13;
  blend_13 = tmpvar_5.z;
  highp float tmpvar_14;
  if ((MColor_3.z == 0.0)) {
    tmpvar_14 = blend_13;
  } else {
    tmpvar_14 = max ((1.0 - (
      (1.0 - RColor_2.z)
     / MColor_3.z)), 0.0);
  };
  highp vec3 tmpvar_15;
  tmpvar_15.x = tmpvar_10;
  tmpvar_15.y = tmpvar_12;
  tmpvar_15.z = tmpvar_14;
  highp vec4 tmpvar_16;
  tmpvar_16.xyz = mix (RColor_2.xyz, tmpvar_15, vec3(tmpvar_6));
  tmpvar_16.w = 1.0;
  tmpvar_1 = tmpvar_16;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_COLORDODGE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Use3DAnchor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_AnchorPoint",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Rotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Scale",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_HorizontalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VerticalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainSize;
uniform highp vec2 _MainPivot;
uniform highp float _Use3DAnchor;
uniform highp vec3 _AnchorPoint;
uniform highp vec3 _Rotation;
uniform highp vec2 _Scale;
uniform highp vec2 _VideoSize;
uniform highp float _HorizontalFlip;
uniform highp float _VerticalFlip;
highp vec2 xlat_mutable_Scale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  xlat_mutable_Scale = _Scale;
  highp vec2 tmpvar_1;
  tmpvar_1 = _glesMultiTexCoord0.xy;
  highp vec4 tmpvar_2;
  tmpvar_2 = vec4(0.0, 0.0, 0.0, 0.0);
  highp vec2 anchor_3;
  highp mat4 tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (_MainSize.x * 0.5);
  tmpvar_4[0].x = tmpvar_5;
  tmpvar_4[0].y = 0.0;
  tmpvar_4[0].z = 0.0;
  tmpvar_4[0].w = 0.0;
  tmpvar_4[1].x = 0.0;
  highp float tmpvar_6;
  tmpvar_6 = (_MainSize.y * 0.5);
  tmpvar_4[1].y = tmpvar_6;
  tmpvar_4[1].z = 0.0;
  tmpvar_4[1].w = 0.0;
  tmpvar_4[2].x = 0.0;
  tmpvar_4[2].y = 0.0;
  tmpvar_4[2].z = 1.0;
  tmpvar_4[2].w = 0.0;
  tmpvar_4[3].x = tmpvar_5;
  tmpvar_4[3].y = tmpvar_6;
  tmpvar_4[3].z = 0.0;
  tmpvar_4[3].w = 1.0;
  highp mat4 tmpvar_7;
  tmpvar_7[0].x = 1.0;
  tmpvar_7[0].y = 0.0;
  tmpvar_7[0].z = 0.0;
  tmpvar_7[0].w = 0.0;
  tmpvar_7[1].x = 0.0;
  tmpvar_7[1].y = 1.0;
  tmpvar_7[1].z = 0.0;
  tmpvar_7[1].w = 0.0;
  tmpvar_7[2].x = 0.0;
  tmpvar_7[2].y = 0.0;
  tmpvar_7[2].z = 1.0;
  tmpvar_7[2].w = 0.0;
  tmpvar_7[3].x = -(_MainPivot.x);
  tmpvar_7[3].y = (_MainPivot.y - _MainSize.y);
  tmpvar_7[3].z = 0.0;
  tmpvar_7[3].w = 1.0;
  highp float tmpvar_8;
  tmpvar_8 = cos(_Rotation.z);
  highp float tmpvar_9;
  tmpvar_9 = sin(_Rotation.z);
  if ((_HorizontalFlip > 0.1)) {
    xlat_mutable_Scale.x = -(_Scale.x);
  };
  if ((_VerticalFlip > 0.1)) {
    xlat_mutable_Scale.y = -(_Scale.y);
  };
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = (tmpvar_8 * xlat_mutable_Scale.x);
  tmpvar_10[0].y = (tmpvar_9 * xlat_mutable_Scale.x);
  tmpvar_10[0].z = 0.0;
  tmpvar_10[0].w = 0.0;
  tmpvar_10[1].x = (-(tmpvar_9) * xlat_mutable_Scale.y);
  tmpvar_10[1].y = (tmpvar_8 * xlat_mutable_Scale.y);
  tmpvar_10[1].z = 0.0;
  tmpvar_10[1].w = 0.0;
  tmpvar_10[2].x = 0.0;
  tmpvar_10[2].y = 0.0;
  tmpvar_10[2].z = 1.0;
  tmpvar_10[2].w = 0.0;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  anchor_3 = vec2(0.0, 0.0);
  if ((_Use3DAnchor > 0.1)) {
    highp vec4 tmpvar_11;
    highp vec4 tmpvar_12;
    tmpvar_12.w = 1.0;
    tmpvar_12.xyz = _AnchorPoint;
    tmpvar_11 = (CAMERA_VIEWPROJ * tmpvar_12);
    anchor_3 = (tmpvar_11.xy / tmpvar_11.w);
    anchor_3 = (((anchor_3 * 0.5) + 0.5) * _VideoSize);
  } else {
    highp vec2 tmpvar_13;
    tmpvar_13.x = _AnchorPoint.x;
    tmpvar_13.y = (_VideoSize.y - _AnchorPoint.y);
    anchor_3 = tmpvar_13;
  };
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 1.0;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.0;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 1.0;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.0;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 1.0;
  tmpvar_14[2].w = 0.0;
  tmpvar_14[3].x = anchor_3.x;
  tmpvar_14[3].y = anchor_3.y;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = (2.0 / _VideoSize.x);
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.0;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = (2.0 / _VideoSize.y);
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.0;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 1.0;
  tmpvar_15[2].w = 0.0;
  tmpvar_15[3].x = -1.0;
  tmpvar_15[3].y = -1.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  tmpvar_2 = ((tmpvar_15 * (tmpvar_14 * 
    (tmpvar_10 * (tmpvar_7 * tmpvar_4))
  )) * _glesVertex);
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_2 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_2.zw;
  highp vec4 tmpvar_18;
  tmpvar_18.zw = vec2(0.0, 1.0);
  tmpvar_18.xy = tmpvar_2.xy;
  highp vec4 tmpvar_19;
  tmpvar_19.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_19.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_18);
  tmpvar_2 = tmpvar_20;
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = o_16;
  gl_Position = tmpvar_20;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_MainTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = MColor_3.xyz;
  highp float tmpvar_6;
  tmpvar_6 = (MColor_3.w * _Opacity);
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_GRAP, tmpvar_7);
  RColor_2 = tmpvar_8;
  highp float blend_9;
  blend_9 = tmpvar_5.x;
  highp float tmpvar_10;
  if ((MColor_3.x == 1.0)) {
    tmpvar_10 = blend_9;
  } else {
    tmpvar_10 = min ((RColor_2.x / (1.0 - MColor_3.x)), 1.0);
  };
  highp float blend_11;
  blend_11 = tmpvar_5.y;
  highp float tmpvar_12;
  if ((MColor_3.y == 1.0)) {
    tmpvar_12 = blend_11;
  } else {
    tmpvar_12 = min ((RColor_2.y / (1.0 - MColor_3.y)), 1.0);
  };
  highp float blend_13;
  blend_13 = tmpvar_5.z;
  highp float tmpvar_14;
  if ((MColor_3.z == 1.0)) {
    tmpvar_14 = blend_13;
  } else {
    tmpvar_14 = min ((RColor_2.z / (1.0 - MColor_3.z)), 1.0);
  };
  highp vec3 tmpvar_15;
  tmpvar_15.x = tmpvar_10;
  tmpvar_15.y = tmpvar_12;
  tmpvar_15.z = tmpvar_14;
  highp vec4 tmpvar_16;
  tmpvar_16.xyz = mix (RColor_2.xyz, tmpvar_15, vec3(tmpvar_6));
  tmpvar_16.w = 1.0;
  tmpvar_1 = tmpvar_16;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_SOFTLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Use3DAnchor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_AnchorPoint",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Rotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Scale",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_HorizontalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VerticalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainSize;
uniform highp vec2 _MainPivot;
uniform highp float _Use3DAnchor;
uniform highp vec3 _AnchorPoint;
uniform highp vec3 _Rotation;
uniform highp vec2 _Scale;
uniform highp vec2 _VideoSize;
uniform highp float _HorizontalFlip;
uniform highp float _VerticalFlip;
highp vec2 xlat_mutable_Scale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  xlat_mutable_Scale = _Scale;
  highp vec2 tmpvar_1;
  tmpvar_1 = _glesMultiTexCoord0.xy;
  highp vec4 tmpvar_2;
  tmpvar_2 = vec4(0.0, 0.0, 0.0, 0.0);
  highp vec2 anchor_3;
  highp mat4 tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (_MainSize.x * 0.5);
  tmpvar_4[0].x = tmpvar_5;
  tmpvar_4[0].y = 0.0;
  tmpvar_4[0].z = 0.0;
  tmpvar_4[0].w = 0.0;
  tmpvar_4[1].x = 0.0;
  highp float tmpvar_6;
  tmpvar_6 = (_MainSize.y * 0.5);
  tmpvar_4[1].y = tmpvar_6;
  tmpvar_4[1].z = 0.0;
  tmpvar_4[1].w = 0.0;
  tmpvar_4[2].x = 0.0;
  tmpvar_4[2].y = 0.0;
  tmpvar_4[2].z = 1.0;
  tmpvar_4[2].w = 0.0;
  tmpvar_4[3].x = tmpvar_5;
  tmpvar_4[3].y = tmpvar_6;
  tmpvar_4[3].z = 0.0;
  tmpvar_4[3].w = 1.0;
  highp mat4 tmpvar_7;
  tmpvar_7[0].x = 1.0;
  tmpvar_7[0].y = 0.0;
  tmpvar_7[0].z = 0.0;
  tmpvar_7[0].w = 0.0;
  tmpvar_7[1].x = 0.0;
  tmpvar_7[1].y = 1.0;
  tmpvar_7[1].z = 0.0;
  tmpvar_7[1].w = 0.0;
  tmpvar_7[2].x = 0.0;
  tmpvar_7[2].y = 0.0;
  tmpvar_7[2].z = 1.0;
  tmpvar_7[2].w = 0.0;
  tmpvar_7[3].x = -(_MainPivot.x);
  tmpvar_7[3].y = (_MainPivot.y - _MainSize.y);
  tmpvar_7[3].z = 0.0;
  tmpvar_7[3].w = 1.0;
  highp float tmpvar_8;
  tmpvar_8 = cos(_Rotation.z);
  highp float tmpvar_9;
  tmpvar_9 = sin(_Rotation.z);
  if ((_HorizontalFlip > 0.1)) {
    xlat_mutable_Scale.x = -(_Scale.x);
  };
  if ((_VerticalFlip > 0.1)) {
    xlat_mutable_Scale.y = -(_Scale.y);
  };
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = (tmpvar_8 * xlat_mutable_Scale.x);
  tmpvar_10[0].y = (tmpvar_9 * xlat_mutable_Scale.x);
  tmpvar_10[0].z = 0.0;
  tmpvar_10[0].w = 0.0;
  tmpvar_10[1].x = (-(tmpvar_9) * xlat_mutable_Scale.y);
  tmpvar_10[1].y = (tmpvar_8 * xlat_mutable_Scale.y);
  tmpvar_10[1].z = 0.0;
  tmpvar_10[1].w = 0.0;
  tmpvar_10[2].x = 0.0;
  tmpvar_10[2].y = 0.0;
  tmpvar_10[2].z = 1.0;
  tmpvar_10[2].w = 0.0;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  anchor_3 = vec2(0.0, 0.0);
  if ((_Use3DAnchor > 0.1)) {
    highp vec4 tmpvar_11;
    highp vec4 tmpvar_12;
    tmpvar_12.w = 1.0;
    tmpvar_12.xyz = _AnchorPoint;
    tmpvar_11 = (CAMERA_VIEWPROJ * tmpvar_12);
    anchor_3 = (tmpvar_11.xy / tmpvar_11.w);
    anchor_3 = (((anchor_3 * 0.5) + 0.5) * _VideoSize);
  } else {
    highp vec2 tmpvar_13;
    tmpvar_13.x = _AnchorPoint.x;
    tmpvar_13.y = (_VideoSize.y - _AnchorPoint.y);
    anchor_3 = tmpvar_13;
  };
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 1.0;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.0;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 1.0;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.0;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 1.0;
  tmpvar_14[2].w = 0.0;
  tmpvar_14[3].x = anchor_3.x;
  tmpvar_14[3].y = anchor_3.y;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = (2.0 / _VideoSize.x);
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.0;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = (2.0 / _VideoSize.y);
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.0;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 1.0;
  tmpvar_15[2].w = 0.0;
  tmpvar_15[3].x = -1.0;
  tmpvar_15[3].y = -1.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  tmpvar_2 = ((tmpvar_15 * (tmpvar_14 * 
    (tmpvar_10 * (tmpvar_7 * tmpvar_4))
  )) * _glesVertex);
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_2 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_2.zw;
  highp vec4 tmpvar_18;
  tmpvar_18.zw = vec2(0.0, 1.0);
  tmpvar_18.xy = tmpvar_2.xy;
  highp vec4 tmpvar_19;
  tmpvar_19.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_19.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_18);
  tmpvar_2 = tmpvar_20;
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = o_16;
  gl_Position = tmpvar_20;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_MainTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_5 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_GRAP, tmpvar_5);
  RColor_2 = tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.xyz = mix (RColor_2.xyz, ((
    ((vec3(1.0, 1.0, 1.0) - (vec3(2.0, 2.0, 2.0) * MColor_3.xyz)) * RColor_2.xyz)
   * RColor_2.xyz) + (
    (vec3(2.0, 2.0, 2.0) * RColor_2.xyz)
   * MColor_3.xyz)), vec3((MColor_3.w * _Opacity)));
  tmpvar_7.w = 1.0;
  tmpvar_1 = tmpvar_7;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_HARDMIX"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Use3DAnchor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_AnchorPoint",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Rotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Scale",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_HorizontalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VerticalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainSize;
uniform highp vec2 _MainPivot;
uniform highp float _Use3DAnchor;
uniform highp vec3 _AnchorPoint;
uniform highp vec3 _Rotation;
uniform highp vec2 _Scale;
uniform highp vec2 _VideoSize;
uniform highp float _HorizontalFlip;
uniform highp float _VerticalFlip;
highp vec2 xlat_mutable_Scale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  xlat_mutable_Scale = _Scale;
  highp vec2 tmpvar_1;
  tmpvar_1 = _glesMultiTexCoord0.xy;
  highp vec4 tmpvar_2;
  tmpvar_2 = vec4(0.0, 0.0, 0.0, 0.0);
  highp vec2 anchor_3;
  highp mat4 tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (_MainSize.x * 0.5);
  tmpvar_4[0].x = tmpvar_5;
  tmpvar_4[0].y = 0.0;
  tmpvar_4[0].z = 0.0;
  tmpvar_4[0].w = 0.0;
  tmpvar_4[1].x = 0.0;
  highp float tmpvar_6;
  tmpvar_6 = (_MainSize.y * 0.5);
  tmpvar_4[1].y = tmpvar_6;
  tmpvar_4[1].z = 0.0;
  tmpvar_4[1].w = 0.0;
  tmpvar_4[2].x = 0.0;
  tmpvar_4[2].y = 0.0;
  tmpvar_4[2].z = 1.0;
  tmpvar_4[2].w = 0.0;
  tmpvar_4[3].x = tmpvar_5;
  tmpvar_4[3].y = tmpvar_6;
  tmpvar_4[3].z = 0.0;
  tmpvar_4[3].w = 1.0;
  highp mat4 tmpvar_7;
  tmpvar_7[0].x = 1.0;
  tmpvar_7[0].y = 0.0;
  tmpvar_7[0].z = 0.0;
  tmpvar_7[0].w = 0.0;
  tmpvar_7[1].x = 0.0;
  tmpvar_7[1].y = 1.0;
  tmpvar_7[1].z = 0.0;
  tmpvar_7[1].w = 0.0;
  tmpvar_7[2].x = 0.0;
  tmpvar_7[2].y = 0.0;
  tmpvar_7[2].z = 1.0;
  tmpvar_7[2].w = 0.0;
  tmpvar_7[3].x = -(_MainPivot.x);
  tmpvar_7[3].y = (_MainPivot.y - _MainSize.y);
  tmpvar_7[3].z = 0.0;
  tmpvar_7[3].w = 1.0;
  highp float tmpvar_8;
  tmpvar_8 = cos(_Rotation.z);
  highp float tmpvar_9;
  tmpvar_9 = sin(_Rotation.z);
  if ((_HorizontalFlip > 0.1)) {
    xlat_mutable_Scale.x = -(_Scale.x);
  };
  if ((_VerticalFlip > 0.1)) {
    xlat_mutable_Scale.y = -(_Scale.y);
  };
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = (tmpvar_8 * xlat_mutable_Scale.x);
  tmpvar_10[0].y = (tmpvar_9 * xlat_mutable_Scale.x);
  tmpvar_10[0].z = 0.0;
  tmpvar_10[0].w = 0.0;
  tmpvar_10[1].x = (-(tmpvar_9) * xlat_mutable_Scale.y);
  tmpvar_10[1].y = (tmpvar_8 * xlat_mutable_Scale.y);
  tmpvar_10[1].z = 0.0;
  tmpvar_10[1].w = 0.0;
  tmpvar_10[2].x = 0.0;
  tmpvar_10[2].y = 0.0;
  tmpvar_10[2].z = 1.0;
  tmpvar_10[2].w = 0.0;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  anchor_3 = vec2(0.0, 0.0);
  if ((_Use3DAnchor > 0.1)) {
    highp vec4 tmpvar_11;
    highp vec4 tmpvar_12;
    tmpvar_12.w = 1.0;
    tmpvar_12.xyz = _AnchorPoint;
    tmpvar_11 = (CAMERA_VIEWPROJ * tmpvar_12);
    anchor_3 = (tmpvar_11.xy / tmpvar_11.w);
    anchor_3 = (((anchor_3 * 0.5) + 0.5) * _VideoSize);
  } else {
    highp vec2 tmpvar_13;
    tmpvar_13.x = _AnchorPoint.x;
    tmpvar_13.y = (_VideoSize.y - _AnchorPoint.y);
    anchor_3 = tmpvar_13;
  };
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 1.0;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.0;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 1.0;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.0;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 1.0;
  tmpvar_14[2].w = 0.0;
  tmpvar_14[3].x = anchor_3.x;
  tmpvar_14[3].y = anchor_3.y;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = (2.0 / _VideoSize.x);
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.0;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = (2.0 / _VideoSize.y);
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.0;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 1.0;
  tmpvar_15[2].w = 0.0;
  tmpvar_15[3].x = -1.0;
  tmpvar_15[3].y = -1.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  tmpvar_2 = ((tmpvar_15 * (tmpvar_14 * 
    (tmpvar_10 * (tmpvar_7 * tmpvar_4))
  )) * _glesVertex);
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_2 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_2.zw;
  highp vec4 tmpvar_18;
  tmpvar_18.zw = vec2(0.0, 1.0);
  tmpvar_18.xy = tmpvar_2.xy;
  highp vec4 tmpvar_19;
  tmpvar_19.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_19.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_18);
  tmpvar_2 = tmpvar_20;
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = o_16;
  gl_Position = tmpvar_20;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp float alpha_3;
  highp vec4 MColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_MainTex, xlv_TEXCOORD0);
  MColor_4 = tmpvar_5;
  alpha_3 = (MColor_4.w * _Opacity);
  highp vec2 tmpvar_6;
  tmpvar_6 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_GRAP, tmpvar_6);
  RColor_2 = tmpvar_7;
  highp float tmpvar_8;
  highp float tmpvar_9;
  if ((MColor_4.x < 0.5)) {
    highp float blend_10;
    blend_10 = (2.0 * MColor_4.x);
    highp float tmpvar_11;
    if ((blend_10 == 0.0)) {
      tmpvar_11 = blend_10;
    } else {
      tmpvar_11 = max ((1.0 - (
        (1.0 - RColor_2.x)
       / blend_10)), 0.0);
    };
    tmpvar_9 = tmpvar_11;
  } else {
    highp float blend_12;
    blend_12 = (2.0 * (MColor_4.x - 0.5));
    highp float tmpvar_13;
    if ((blend_12 == 1.0)) {
      tmpvar_13 = blend_12;
    } else {
      tmpvar_13 = min ((RColor_2.x / (1.0 - blend_12)), 1.0);
    };
    tmpvar_9 = tmpvar_13;
  };
  if ((tmpvar_9 < 0.5)) {
    tmpvar_8 = 0.0;
  } else {
    tmpvar_8 = 1.0;
  };
  highp float tmpvar_14;
  highp float tmpvar_15;
  if ((MColor_4.y < 0.5)) {
    highp float blend_16;
    blend_16 = (2.0 * MColor_4.y);
    highp float tmpvar_17;
    if ((blend_16 == 0.0)) {
      tmpvar_17 = blend_16;
    } else {
      tmpvar_17 = max ((1.0 - (
        (1.0 - RColor_2.y)
       / blend_16)), 0.0);
    };
    tmpvar_15 = tmpvar_17;
  } else {
    highp float blend_18;
    blend_18 = (2.0 * (MColor_4.y - 0.5));
    highp float tmpvar_19;
    if ((blend_18 == 1.0)) {
      tmpvar_19 = blend_18;
    } else {
      tmpvar_19 = min ((RColor_2.y / (1.0 - blend_18)), 1.0);
    };
    tmpvar_15 = tmpvar_19;
  };
  if ((tmpvar_15 < 0.5)) {
    tmpvar_14 = 0.0;
  } else {
    tmpvar_14 = 1.0;
  };
  highp float tmpvar_20;
  highp float tmpvar_21;
  if ((MColor_4.z < 0.5)) {
    highp float blend_22;
    blend_22 = (2.0 * MColor_4.z);
    highp float tmpvar_23;
    if ((blend_22 == 0.0)) {
      tmpvar_23 = blend_22;
    } else {
      tmpvar_23 = max ((1.0 - (
        (1.0 - RColor_2.z)
       / blend_22)), 0.0);
    };
    tmpvar_21 = tmpvar_23;
  } else {
    highp float blend_24;
    blend_24 = (2.0 * (MColor_4.z - 0.5));
    highp float tmpvar_25;
    if ((blend_24 == 1.0)) {
      tmpvar_25 = blend_24;
    } else {
      tmpvar_25 = min ((RColor_2.z / (1.0 - blend_24)), 1.0);
    };
    tmpvar_21 = tmpvar_25;
  };
  if ((tmpvar_21 < 0.5)) {
    tmpvar_20 = 0.0;
  } else {
    tmpvar_20 = 1.0;
  };
  highp vec3 tmpvar_26;
  tmpvar_26.x = tmpvar_8;
  tmpvar_26.y = tmpvar_14;
  tmpvar_26.z = tmpvar_20;
  highp vec4 tmpvar_27;
  tmpvar_27.xyz = mix (RColor_2.xyz, tmpvar_26, vec3(alpha_3));
  tmpvar_27.w = 1.0;
  tmpvar_1 = tmpvar_27;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_PINLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Use3DAnchor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_AnchorPoint",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Rotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Scale",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_HorizontalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VerticalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainSize;
uniform highp vec2 _MainPivot;
uniform highp float _Use3DAnchor;
uniform highp vec3 _AnchorPoint;
uniform highp vec3 _Rotation;
uniform highp vec2 _Scale;
uniform highp vec2 _VideoSize;
uniform highp float _HorizontalFlip;
uniform highp float _VerticalFlip;
highp vec2 xlat_mutable_Scale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  xlat_mutable_Scale = _Scale;
  highp vec2 tmpvar_1;
  tmpvar_1 = _glesMultiTexCoord0.xy;
  highp vec4 tmpvar_2;
  tmpvar_2 = vec4(0.0, 0.0, 0.0, 0.0);
  highp vec2 anchor_3;
  highp mat4 tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (_MainSize.x * 0.5);
  tmpvar_4[0].x = tmpvar_5;
  tmpvar_4[0].y = 0.0;
  tmpvar_4[0].z = 0.0;
  tmpvar_4[0].w = 0.0;
  tmpvar_4[1].x = 0.0;
  highp float tmpvar_6;
  tmpvar_6 = (_MainSize.y * 0.5);
  tmpvar_4[1].y = tmpvar_6;
  tmpvar_4[1].z = 0.0;
  tmpvar_4[1].w = 0.0;
  tmpvar_4[2].x = 0.0;
  tmpvar_4[2].y = 0.0;
  tmpvar_4[2].z = 1.0;
  tmpvar_4[2].w = 0.0;
  tmpvar_4[3].x = tmpvar_5;
  tmpvar_4[3].y = tmpvar_6;
  tmpvar_4[3].z = 0.0;
  tmpvar_4[3].w = 1.0;
  highp mat4 tmpvar_7;
  tmpvar_7[0].x = 1.0;
  tmpvar_7[0].y = 0.0;
  tmpvar_7[0].z = 0.0;
  tmpvar_7[0].w = 0.0;
  tmpvar_7[1].x = 0.0;
  tmpvar_7[1].y = 1.0;
  tmpvar_7[1].z = 0.0;
  tmpvar_7[1].w = 0.0;
  tmpvar_7[2].x = 0.0;
  tmpvar_7[2].y = 0.0;
  tmpvar_7[2].z = 1.0;
  tmpvar_7[2].w = 0.0;
  tmpvar_7[3].x = -(_MainPivot.x);
  tmpvar_7[3].y = (_MainPivot.y - _MainSize.y);
  tmpvar_7[3].z = 0.0;
  tmpvar_7[3].w = 1.0;
  highp float tmpvar_8;
  tmpvar_8 = cos(_Rotation.z);
  highp float tmpvar_9;
  tmpvar_9 = sin(_Rotation.z);
  if ((_HorizontalFlip > 0.1)) {
    xlat_mutable_Scale.x = -(_Scale.x);
  };
  if ((_VerticalFlip > 0.1)) {
    xlat_mutable_Scale.y = -(_Scale.y);
  };
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = (tmpvar_8 * xlat_mutable_Scale.x);
  tmpvar_10[0].y = (tmpvar_9 * xlat_mutable_Scale.x);
  tmpvar_10[0].z = 0.0;
  tmpvar_10[0].w = 0.0;
  tmpvar_10[1].x = (-(tmpvar_9) * xlat_mutable_Scale.y);
  tmpvar_10[1].y = (tmpvar_8 * xlat_mutable_Scale.y);
  tmpvar_10[1].z = 0.0;
  tmpvar_10[1].w = 0.0;
  tmpvar_10[2].x = 0.0;
  tmpvar_10[2].y = 0.0;
  tmpvar_10[2].z = 1.0;
  tmpvar_10[2].w = 0.0;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  anchor_3 = vec2(0.0, 0.0);
  if ((_Use3DAnchor > 0.1)) {
    highp vec4 tmpvar_11;
    highp vec4 tmpvar_12;
    tmpvar_12.w = 1.0;
    tmpvar_12.xyz = _AnchorPoint;
    tmpvar_11 = (CAMERA_VIEWPROJ * tmpvar_12);
    anchor_3 = (tmpvar_11.xy / tmpvar_11.w);
    anchor_3 = (((anchor_3 * 0.5) + 0.5) * _VideoSize);
  } else {
    highp vec2 tmpvar_13;
    tmpvar_13.x = _AnchorPoint.x;
    tmpvar_13.y = (_VideoSize.y - _AnchorPoint.y);
    anchor_3 = tmpvar_13;
  };
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 1.0;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.0;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 1.0;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.0;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 1.0;
  tmpvar_14[2].w = 0.0;
  tmpvar_14[3].x = anchor_3.x;
  tmpvar_14[3].y = anchor_3.y;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = (2.0 / _VideoSize.x);
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.0;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = (2.0 / _VideoSize.y);
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.0;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 1.0;
  tmpvar_15[2].w = 0.0;
  tmpvar_15[3].x = -1.0;
  tmpvar_15[3].y = -1.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  tmpvar_2 = ((tmpvar_15 * (tmpvar_14 * 
    (tmpvar_10 * (tmpvar_7 * tmpvar_4))
  )) * _glesVertex);
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_2 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_2.zw;
  highp vec4 tmpvar_18;
  tmpvar_18.zw = vec2(0.0, 1.0);
  tmpvar_18.xy = tmpvar_2.xy;
  highp vec4 tmpvar_19;
  tmpvar_19.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_19.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_18);
  tmpvar_2 = tmpvar_20;
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = o_16;
  gl_Position = tmpvar_20;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp float alpha_3;
  highp vec4 MColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_MainTex, xlv_TEXCOORD0);
  MColor_4 = tmpvar_5;
  alpha_3 = (MColor_4.w * _Opacity);
  highp vec2 tmpvar_6;
  tmpvar_6 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_GRAP, tmpvar_6);
  RColor_2 = tmpvar_7;
  highp float tmpvar_8;
  if ((MColor_4.x < 0.5)) {
    tmpvar_8 = min ((2.0 * MColor_4.x), RColor_2.x);
  } else {
    tmpvar_8 = max ((2.0 * (MColor_4.x - 0.5)), RColor_2.x);
  };
  highp float tmpvar_9;
  if ((MColor_4.y < 0.5)) {
    tmpvar_9 = min ((2.0 * MColor_4.y), RColor_2.y);
  } else {
    tmpvar_9 = max ((2.0 * (MColor_4.y - 0.5)), RColor_2.y);
  };
  highp float tmpvar_10;
  if ((MColor_4.z < 0.5)) {
    tmpvar_10 = min ((2.0 * MColor_4.z), RColor_2.z);
  } else {
    tmpvar_10 = max ((2.0 * (MColor_4.z - 0.5)), RColor_2.z);
  };
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_8;
  tmpvar_11.y = tmpvar_9;
  tmpvar_11.z = tmpvar_10;
  highp vec4 tmpvar_12;
  tmpvar_12.xyz = mix (RColor_2.xyz, tmpvar_11, vec3(alpha_3));
  tmpvar_12.w = 1.0;
  tmpvar_1 = tmpvar_12;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LINEARLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Use3DAnchor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_AnchorPoint",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Rotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Scale",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_HorizontalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VerticalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainSize;
uniform highp vec2 _MainPivot;
uniform highp float _Use3DAnchor;
uniform highp vec3 _AnchorPoint;
uniform highp vec3 _Rotation;
uniform highp vec2 _Scale;
uniform highp vec2 _VideoSize;
uniform highp float _HorizontalFlip;
uniform highp float _VerticalFlip;
highp vec2 xlat_mutable_Scale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  xlat_mutable_Scale = _Scale;
  highp vec2 tmpvar_1;
  tmpvar_1 = _glesMultiTexCoord0.xy;
  highp vec4 tmpvar_2;
  tmpvar_2 = vec4(0.0, 0.0, 0.0, 0.0);
  highp vec2 anchor_3;
  highp mat4 tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (_MainSize.x * 0.5);
  tmpvar_4[0].x = tmpvar_5;
  tmpvar_4[0].y = 0.0;
  tmpvar_4[0].z = 0.0;
  tmpvar_4[0].w = 0.0;
  tmpvar_4[1].x = 0.0;
  highp float tmpvar_6;
  tmpvar_6 = (_MainSize.y * 0.5);
  tmpvar_4[1].y = tmpvar_6;
  tmpvar_4[1].z = 0.0;
  tmpvar_4[1].w = 0.0;
  tmpvar_4[2].x = 0.0;
  tmpvar_4[2].y = 0.0;
  tmpvar_4[2].z = 1.0;
  tmpvar_4[2].w = 0.0;
  tmpvar_4[3].x = tmpvar_5;
  tmpvar_4[3].y = tmpvar_6;
  tmpvar_4[3].z = 0.0;
  tmpvar_4[3].w = 1.0;
  highp mat4 tmpvar_7;
  tmpvar_7[0].x = 1.0;
  tmpvar_7[0].y = 0.0;
  tmpvar_7[0].z = 0.0;
  tmpvar_7[0].w = 0.0;
  tmpvar_7[1].x = 0.0;
  tmpvar_7[1].y = 1.0;
  tmpvar_7[1].z = 0.0;
  tmpvar_7[1].w = 0.0;
  tmpvar_7[2].x = 0.0;
  tmpvar_7[2].y = 0.0;
  tmpvar_7[2].z = 1.0;
  tmpvar_7[2].w = 0.0;
  tmpvar_7[3].x = -(_MainPivot.x);
  tmpvar_7[3].y = (_MainPivot.y - _MainSize.y);
  tmpvar_7[3].z = 0.0;
  tmpvar_7[3].w = 1.0;
  highp float tmpvar_8;
  tmpvar_8 = cos(_Rotation.z);
  highp float tmpvar_9;
  tmpvar_9 = sin(_Rotation.z);
  if ((_HorizontalFlip > 0.1)) {
    xlat_mutable_Scale.x = -(_Scale.x);
  };
  if ((_VerticalFlip > 0.1)) {
    xlat_mutable_Scale.y = -(_Scale.y);
  };
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = (tmpvar_8 * xlat_mutable_Scale.x);
  tmpvar_10[0].y = (tmpvar_9 * xlat_mutable_Scale.x);
  tmpvar_10[0].z = 0.0;
  tmpvar_10[0].w = 0.0;
  tmpvar_10[1].x = (-(tmpvar_9) * xlat_mutable_Scale.y);
  tmpvar_10[1].y = (tmpvar_8 * xlat_mutable_Scale.y);
  tmpvar_10[1].z = 0.0;
  tmpvar_10[1].w = 0.0;
  tmpvar_10[2].x = 0.0;
  tmpvar_10[2].y = 0.0;
  tmpvar_10[2].z = 1.0;
  tmpvar_10[2].w = 0.0;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  anchor_3 = vec2(0.0, 0.0);
  if ((_Use3DAnchor > 0.1)) {
    highp vec4 tmpvar_11;
    highp vec4 tmpvar_12;
    tmpvar_12.w = 1.0;
    tmpvar_12.xyz = _AnchorPoint;
    tmpvar_11 = (CAMERA_VIEWPROJ * tmpvar_12);
    anchor_3 = (tmpvar_11.xy / tmpvar_11.w);
    anchor_3 = (((anchor_3 * 0.5) + 0.5) * _VideoSize);
  } else {
    highp vec2 tmpvar_13;
    tmpvar_13.x = _AnchorPoint.x;
    tmpvar_13.y = (_VideoSize.y - _AnchorPoint.y);
    anchor_3 = tmpvar_13;
  };
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 1.0;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.0;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 1.0;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.0;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 1.0;
  tmpvar_14[2].w = 0.0;
  tmpvar_14[3].x = anchor_3.x;
  tmpvar_14[3].y = anchor_3.y;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = (2.0 / _VideoSize.x);
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.0;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = (2.0 / _VideoSize.y);
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.0;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 1.0;
  tmpvar_15[2].w = 0.0;
  tmpvar_15[3].x = -1.0;
  tmpvar_15[3].y = -1.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  tmpvar_2 = ((tmpvar_15 * (tmpvar_14 * 
    (tmpvar_10 * (tmpvar_7 * tmpvar_4))
  )) * _glesVertex);
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_2 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_2.zw;
  highp vec4 tmpvar_18;
  tmpvar_18.zw = vec2(0.0, 1.0);
  tmpvar_18.xy = tmpvar_2.xy;
  highp vec4 tmpvar_19;
  tmpvar_19.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_19.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_18);
  tmpvar_2 = tmpvar_20;
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = o_16;
  gl_Position = tmpvar_20;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp float alpha_3;
  highp vec4 MColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_MainTex, xlv_TEXCOORD0);
  MColor_4 = tmpvar_5;
  alpha_3 = (MColor_4.w * _Opacity);
  highp vec2 tmpvar_6;
  tmpvar_6 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_GRAP, tmpvar_6);
  RColor_2 = tmpvar_7;
  highp float tmpvar_8;
  if ((MColor_4.x < 0.5)) {
    tmpvar_8 = max (((RColor_2.x + 
      (2.0 * MColor_4.x)
    ) - 1.0), 0.0);
  } else {
    tmpvar_8 = min ((RColor_2.x + (2.0 * 
      (MColor_4.x - 0.5)
    )), 1.0);
  };
  highp float tmpvar_9;
  if ((MColor_4.y < 0.5)) {
    tmpvar_9 = max (((RColor_2.y + 
      (2.0 * MColor_4.y)
    ) - 1.0), 0.0);
  } else {
    tmpvar_9 = min ((RColor_2.y + (2.0 * 
      (MColor_4.y - 0.5)
    )), 1.0);
  };
  highp float tmpvar_10;
  if ((MColor_4.z < 0.5)) {
    tmpvar_10 = max (((RColor_2.z + 
      (2.0 * MColor_4.z)
    ) - 1.0), 0.0);
  } else {
    tmpvar_10 = min ((RColor_2.z + (2.0 * 
      (MColor_4.z - 0.5)
    )), 1.0);
  };
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_8;
  tmpvar_11.y = tmpvar_9;
  tmpvar_11.z = tmpvar_10;
  highp vec4 tmpvar_12;
  tmpvar_12.xyz = mix (RColor_2.xyz, tmpvar_11, vec3(alpha_3));
  tmpvar_12.w = 1.0;
  tmpvar_1 = tmpvar_12;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_DIFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Use3DAnchor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_AnchorPoint",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Rotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Scale",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_HorizontalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VerticalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainSize;
uniform highp vec2 _MainPivot;
uniform highp float _Use3DAnchor;
uniform highp vec3 _AnchorPoint;
uniform highp vec3 _Rotation;
uniform highp vec2 _Scale;
uniform highp vec2 _VideoSize;
uniform highp float _HorizontalFlip;
uniform highp float _VerticalFlip;
highp vec2 xlat_mutable_Scale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  xlat_mutable_Scale = _Scale;
  highp vec2 tmpvar_1;
  tmpvar_1 = _glesMultiTexCoord0.xy;
  highp vec4 tmpvar_2;
  tmpvar_2 = vec4(0.0, 0.0, 0.0, 0.0);
  highp vec2 anchor_3;
  highp mat4 tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (_MainSize.x * 0.5);
  tmpvar_4[0].x = tmpvar_5;
  tmpvar_4[0].y = 0.0;
  tmpvar_4[0].z = 0.0;
  tmpvar_4[0].w = 0.0;
  tmpvar_4[1].x = 0.0;
  highp float tmpvar_6;
  tmpvar_6 = (_MainSize.y * 0.5);
  tmpvar_4[1].y = tmpvar_6;
  tmpvar_4[1].z = 0.0;
  tmpvar_4[1].w = 0.0;
  tmpvar_4[2].x = 0.0;
  tmpvar_4[2].y = 0.0;
  tmpvar_4[2].z = 1.0;
  tmpvar_4[2].w = 0.0;
  tmpvar_4[3].x = tmpvar_5;
  tmpvar_4[3].y = tmpvar_6;
  tmpvar_4[3].z = 0.0;
  tmpvar_4[3].w = 1.0;
  highp mat4 tmpvar_7;
  tmpvar_7[0].x = 1.0;
  tmpvar_7[0].y = 0.0;
  tmpvar_7[0].z = 0.0;
  tmpvar_7[0].w = 0.0;
  tmpvar_7[1].x = 0.0;
  tmpvar_7[1].y = 1.0;
  tmpvar_7[1].z = 0.0;
  tmpvar_7[1].w = 0.0;
  tmpvar_7[2].x = 0.0;
  tmpvar_7[2].y = 0.0;
  tmpvar_7[2].z = 1.0;
  tmpvar_7[2].w = 0.0;
  tmpvar_7[3].x = -(_MainPivot.x);
  tmpvar_7[3].y = (_MainPivot.y - _MainSize.y);
  tmpvar_7[3].z = 0.0;
  tmpvar_7[3].w = 1.0;
  highp float tmpvar_8;
  tmpvar_8 = cos(_Rotation.z);
  highp float tmpvar_9;
  tmpvar_9 = sin(_Rotation.z);
  if ((_HorizontalFlip > 0.1)) {
    xlat_mutable_Scale.x = -(_Scale.x);
  };
  if ((_VerticalFlip > 0.1)) {
    xlat_mutable_Scale.y = -(_Scale.y);
  };
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = (tmpvar_8 * xlat_mutable_Scale.x);
  tmpvar_10[0].y = (tmpvar_9 * xlat_mutable_Scale.x);
  tmpvar_10[0].z = 0.0;
  tmpvar_10[0].w = 0.0;
  tmpvar_10[1].x = (-(tmpvar_9) * xlat_mutable_Scale.y);
  tmpvar_10[1].y = (tmpvar_8 * xlat_mutable_Scale.y);
  tmpvar_10[1].z = 0.0;
  tmpvar_10[1].w = 0.0;
  tmpvar_10[2].x = 0.0;
  tmpvar_10[2].y = 0.0;
  tmpvar_10[2].z = 1.0;
  tmpvar_10[2].w = 0.0;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  anchor_3 = vec2(0.0, 0.0);
  if ((_Use3DAnchor > 0.1)) {
    highp vec4 tmpvar_11;
    highp vec4 tmpvar_12;
    tmpvar_12.w = 1.0;
    tmpvar_12.xyz = _AnchorPoint;
    tmpvar_11 = (CAMERA_VIEWPROJ * tmpvar_12);
    anchor_3 = (tmpvar_11.xy / tmpvar_11.w);
    anchor_3 = (((anchor_3 * 0.5) + 0.5) * _VideoSize);
  } else {
    highp vec2 tmpvar_13;
    tmpvar_13.x = _AnchorPoint.x;
    tmpvar_13.y = (_VideoSize.y - _AnchorPoint.y);
    anchor_3 = tmpvar_13;
  };
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 1.0;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.0;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 1.0;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.0;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 1.0;
  tmpvar_14[2].w = 0.0;
  tmpvar_14[3].x = anchor_3.x;
  tmpvar_14[3].y = anchor_3.y;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = (2.0 / _VideoSize.x);
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.0;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = (2.0 / _VideoSize.y);
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.0;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 1.0;
  tmpvar_15[2].w = 0.0;
  tmpvar_15[3].x = -1.0;
  tmpvar_15[3].y = -1.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  tmpvar_2 = ((tmpvar_15 * (tmpvar_14 * 
    (tmpvar_10 * (tmpvar_7 * tmpvar_4))
  )) * _glesVertex);
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_2 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_2.zw;
  highp vec4 tmpvar_18;
  tmpvar_18.zw = vec2(0.0, 1.0);
  tmpvar_18.xy = tmpvar_2.xy;
  highp vec4 tmpvar_19;
  tmpvar_19.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_19.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_18);
  tmpvar_2 = tmpvar_20;
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = o_16;
  gl_Position = tmpvar_20;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_MainTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_5 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_GRAP, tmpvar_5);
  RColor_2 = tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.xyz = mix (RColor_2.xyz, abs((RColor_2.xyz - MColor_3.xyz)), vec3((MColor_3.w * _Opacity)));
  tmpvar_7.w = 1.0;
  tmpvar_1 = tmpvar_7;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LINEARBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Use3DAnchor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_AnchorPoint",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Rotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Scale",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_HorizontalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VerticalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainSize;
uniform highp vec2 _MainPivot;
uniform highp float _Use3DAnchor;
uniform highp vec3 _AnchorPoint;
uniform highp vec3 _Rotation;
uniform highp vec2 _Scale;
uniform highp vec2 _VideoSize;
uniform highp float _HorizontalFlip;
uniform highp float _VerticalFlip;
highp vec2 xlat_mutable_Scale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  xlat_mutable_Scale = _Scale;
  highp vec2 tmpvar_1;
  tmpvar_1 = _glesMultiTexCoord0.xy;
  highp vec4 tmpvar_2;
  tmpvar_2 = vec4(0.0, 0.0, 0.0, 0.0);
  highp vec2 anchor_3;
  highp mat4 tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (_MainSize.x * 0.5);
  tmpvar_4[0].x = tmpvar_5;
  tmpvar_4[0].y = 0.0;
  tmpvar_4[0].z = 0.0;
  tmpvar_4[0].w = 0.0;
  tmpvar_4[1].x = 0.0;
  highp float tmpvar_6;
  tmpvar_6 = (_MainSize.y * 0.5);
  tmpvar_4[1].y = tmpvar_6;
  tmpvar_4[1].z = 0.0;
  tmpvar_4[1].w = 0.0;
  tmpvar_4[2].x = 0.0;
  tmpvar_4[2].y = 0.0;
  tmpvar_4[2].z = 1.0;
  tmpvar_4[2].w = 0.0;
  tmpvar_4[3].x = tmpvar_5;
  tmpvar_4[3].y = tmpvar_6;
  tmpvar_4[3].z = 0.0;
  tmpvar_4[3].w = 1.0;
  highp mat4 tmpvar_7;
  tmpvar_7[0].x = 1.0;
  tmpvar_7[0].y = 0.0;
  tmpvar_7[0].z = 0.0;
  tmpvar_7[0].w = 0.0;
  tmpvar_7[1].x = 0.0;
  tmpvar_7[1].y = 1.0;
  tmpvar_7[1].z = 0.0;
  tmpvar_7[1].w = 0.0;
  tmpvar_7[2].x = 0.0;
  tmpvar_7[2].y = 0.0;
  tmpvar_7[2].z = 1.0;
  tmpvar_7[2].w = 0.0;
  tmpvar_7[3].x = -(_MainPivot.x);
  tmpvar_7[3].y = (_MainPivot.y - _MainSize.y);
  tmpvar_7[3].z = 0.0;
  tmpvar_7[3].w = 1.0;
  highp float tmpvar_8;
  tmpvar_8 = cos(_Rotation.z);
  highp float tmpvar_9;
  tmpvar_9 = sin(_Rotation.z);
  if ((_HorizontalFlip > 0.1)) {
    xlat_mutable_Scale.x = -(_Scale.x);
  };
  if ((_VerticalFlip > 0.1)) {
    xlat_mutable_Scale.y = -(_Scale.y);
  };
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = (tmpvar_8 * xlat_mutable_Scale.x);
  tmpvar_10[0].y = (tmpvar_9 * xlat_mutable_Scale.x);
  tmpvar_10[0].z = 0.0;
  tmpvar_10[0].w = 0.0;
  tmpvar_10[1].x = (-(tmpvar_9) * xlat_mutable_Scale.y);
  tmpvar_10[1].y = (tmpvar_8 * xlat_mutable_Scale.y);
  tmpvar_10[1].z = 0.0;
  tmpvar_10[1].w = 0.0;
  tmpvar_10[2].x = 0.0;
  tmpvar_10[2].y = 0.0;
  tmpvar_10[2].z = 1.0;
  tmpvar_10[2].w = 0.0;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  anchor_3 = vec2(0.0, 0.0);
  if ((_Use3DAnchor > 0.1)) {
    highp vec4 tmpvar_11;
    highp vec4 tmpvar_12;
    tmpvar_12.w = 1.0;
    tmpvar_12.xyz = _AnchorPoint;
    tmpvar_11 = (CAMERA_VIEWPROJ * tmpvar_12);
    anchor_3 = (tmpvar_11.xy / tmpvar_11.w);
    anchor_3 = (((anchor_3 * 0.5) + 0.5) * _VideoSize);
  } else {
    highp vec2 tmpvar_13;
    tmpvar_13.x = _AnchorPoint.x;
    tmpvar_13.y = (_VideoSize.y - _AnchorPoint.y);
    anchor_3 = tmpvar_13;
  };
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 1.0;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.0;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 1.0;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.0;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 1.0;
  tmpvar_14[2].w = 0.0;
  tmpvar_14[3].x = anchor_3.x;
  tmpvar_14[3].y = anchor_3.y;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = (2.0 / _VideoSize.x);
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.0;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = (2.0 / _VideoSize.y);
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.0;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 1.0;
  tmpvar_15[2].w = 0.0;
  tmpvar_15[3].x = -1.0;
  tmpvar_15[3].y = -1.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  tmpvar_2 = ((tmpvar_15 * (tmpvar_14 * 
    (tmpvar_10 * (tmpvar_7 * tmpvar_4))
  )) * _glesVertex);
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_2 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_2.zw;
  highp vec4 tmpvar_18;
  tmpvar_18.zw = vec2(0.0, 1.0);
  tmpvar_18.xy = tmpvar_2.xy;
  highp vec4 tmpvar_19;
  tmpvar_19.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_19.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_18);
  tmpvar_2 = tmpvar_20;
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = o_16;
  gl_Position = tmpvar_20;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_MainTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_5 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_GRAP, tmpvar_5);
  RColor_2 = tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.xyz = mix (RColor_2.xyz, max ((
    (RColor_2.xyz + MColor_3.xyz)
   - vec3(1.0, 1.0, 1.0)), vec3(0.0, 0.0, 0.0)), vec3((MColor_3.w * _Opacity)));
  tmpvar_7.w = 1.0;
  tmpvar_1 = tmpvar_7;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_SUB"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Use3DAnchor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_AnchorPoint",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Rotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Scale",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_HorizontalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VerticalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainSize;
uniform highp vec2 _MainPivot;
uniform highp float _Use3DAnchor;
uniform highp vec3 _AnchorPoint;
uniform highp vec3 _Rotation;
uniform highp vec2 _Scale;
uniform highp vec2 _VideoSize;
uniform highp float _HorizontalFlip;
uniform highp float _VerticalFlip;
highp vec2 xlat_mutable_Scale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  xlat_mutable_Scale = _Scale;
  highp vec2 tmpvar_1;
  tmpvar_1 = _glesMultiTexCoord0.xy;
  highp vec4 tmpvar_2;
  tmpvar_2 = vec4(0.0, 0.0, 0.0, 0.0);
  highp vec2 anchor_3;
  highp mat4 tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (_MainSize.x * 0.5);
  tmpvar_4[0].x = tmpvar_5;
  tmpvar_4[0].y = 0.0;
  tmpvar_4[0].z = 0.0;
  tmpvar_4[0].w = 0.0;
  tmpvar_4[1].x = 0.0;
  highp float tmpvar_6;
  tmpvar_6 = (_MainSize.y * 0.5);
  tmpvar_4[1].y = tmpvar_6;
  tmpvar_4[1].z = 0.0;
  tmpvar_4[1].w = 0.0;
  tmpvar_4[2].x = 0.0;
  tmpvar_4[2].y = 0.0;
  tmpvar_4[2].z = 1.0;
  tmpvar_4[2].w = 0.0;
  tmpvar_4[3].x = tmpvar_5;
  tmpvar_4[3].y = tmpvar_6;
  tmpvar_4[3].z = 0.0;
  tmpvar_4[3].w = 1.0;
  highp mat4 tmpvar_7;
  tmpvar_7[0].x = 1.0;
  tmpvar_7[0].y = 0.0;
  tmpvar_7[0].z = 0.0;
  tmpvar_7[0].w = 0.0;
  tmpvar_7[1].x = 0.0;
  tmpvar_7[1].y = 1.0;
  tmpvar_7[1].z = 0.0;
  tmpvar_7[1].w = 0.0;
  tmpvar_7[2].x = 0.0;
  tmpvar_7[2].y = 0.0;
  tmpvar_7[2].z = 1.0;
  tmpvar_7[2].w = 0.0;
  tmpvar_7[3].x = -(_MainPivot.x);
  tmpvar_7[3].y = (_MainPivot.y - _MainSize.y);
  tmpvar_7[3].z = 0.0;
  tmpvar_7[3].w = 1.0;
  highp float tmpvar_8;
  tmpvar_8 = cos(_Rotation.z);
  highp float tmpvar_9;
  tmpvar_9 = sin(_Rotation.z);
  if ((_HorizontalFlip > 0.1)) {
    xlat_mutable_Scale.x = -(_Scale.x);
  };
  if ((_VerticalFlip > 0.1)) {
    xlat_mutable_Scale.y = -(_Scale.y);
  };
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = (tmpvar_8 * xlat_mutable_Scale.x);
  tmpvar_10[0].y = (tmpvar_9 * xlat_mutable_Scale.x);
  tmpvar_10[0].z = 0.0;
  tmpvar_10[0].w = 0.0;
  tmpvar_10[1].x = (-(tmpvar_9) * xlat_mutable_Scale.y);
  tmpvar_10[1].y = (tmpvar_8 * xlat_mutable_Scale.y);
  tmpvar_10[1].z = 0.0;
  tmpvar_10[1].w = 0.0;
  tmpvar_10[2].x = 0.0;
  tmpvar_10[2].y = 0.0;
  tmpvar_10[2].z = 1.0;
  tmpvar_10[2].w = 0.0;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  anchor_3 = vec2(0.0, 0.0);
  if ((_Use3DAnchor > 0.1)) {
    highp vec4 tmpvar_11;
    highp vec4 tmpvar_12;
    tmpvar_12.w = 1.0;
    tmpvar_12.xyz = _AnchorPoint;
    tmpvar_11 = (CAMERA_VIEWPROJ * tmpvar_12);
    anchor_3 = (tmpvar_11.xy / tmpvar_11.w);
    anchor_3 = (((anchor_3 * 0.5) + 0.5) * _VideoSize);
  } else {
    highp vec2 tmpvar_13;
    tmpvar_13.x = _AnchorPoint.x;
    tmpvar_13.y = (_VideoSize.y - _AnchorPoint.y);
    anchor_3 = tmpvar_13;
  };
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 1.0;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.0;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 1.0;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.0;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 1.0;
  tmpvar_14[2].w = 0.0;
  tmpvar_14[3].x = anchor_3.x;
  tmpvar_14[3].y = anchor_3.y;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = (2.0 / _VideoSize.x);
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.0;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = (2.0 / _VideoSize.y);
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.0;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 1.0;
  tmpvar_15[2].w = 0.0;
  tmpvar_15[3].x = -1.0;
  tmpvar_15[3].y = -1.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  tmpvar_2 = ((tmpvar_15 * (tmpvar_14 * 
    (tmpvar_10 * (tmpvar_7 * tmpvar_4))
  )) * _glesVertex);
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_2 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_2.zw;
  highp vec4 tmpvar_18;
  tmpvar_18.zw = vec2(0.0, 1.0);
  tmpvar_18.xy = tmpvar_2.xy;
  highp vec4 tmpvar_19;
  tmpvar_19.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_19.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_18);
  tmpvar_2 = tmpvar_20;
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = o_16;
  gl_Position = tmpvar_20;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _MainTex;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 RColor_2;
  highp vec4 MColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_MainTex, xlv_TEXCOORD0);
  MColor_3 = tmpvar_4;
  highp vec2 tmpvar_5;
  tmpvar_5 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_GRAP, tmpvar_5);
  RColor_2 = tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.xyz = mix (RColor_2.xyz, max ((RColor_2.xyz - MColor_3.xyz), vec3(0.0, 0.0, 0.0)), vec3((MColor_3.w * _Opacity)));
  tmpvar_7.w = 1.0;
  tmpvar_1 = tmpvar_7;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LUT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainPivot",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Use3DAnchor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_AnchorPoint",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Rotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Scale",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_HorizontalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_VerticalFlip",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_LutMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainSize;
uniform highp vec2 _MainPivot;
uniform highp float _Use3DAnchor;
uniform highp vec3 _AnchorPoint;
uniform highp vec3 _Rotation;
uniform highp vec2 _Scale;
uniform highp vec2 _VideoSize;
uniform highp float _HorizontalFlip;
uniform highp float _VerticalFlip;
highp vec2 xlat_mutable_Scale;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  xlat_mutable_Scale = _Scale;
  highp vec2 tmpvar_1;
  tmpvar_1 = _glesMultiTexCoord0.xy;
  highp vec4 tmpvar_2;
  tmpvar_2 = vec4(0.0, 0.0, 0.0, 0.0);
  highp vec2 anchor_3;
  highp mat4 tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (_MainSize.x * 0.5);
  tmpvar_4[0].x = tmpvar_5;
  tmpvar_4[0].y = 0.0;
  tmpvar_4[0].z = 0.0;
  tmpvar_4[0].w = 0.0;
  tmpvar_4[1].x = 0.0;
  highp float tmpvar_6;
  tmpvar_6 = (_MainSize.y * 0.5);
  tmpvar_4[1].y = tmpvar_6;
  tmpvar_4[1].z = 0.0;
  tmpvar_4[1].w = 0.0;
  tmpvar_4[2].x = 0.0;
  tmpvar_4[2].y = 0.0;
  tmpvar_4[2].z = 1.0;
  tmpvar_4[2].w = 0.0;
  tmpvar_4[3].x = tmpvar_5;
  tmpvar_4[3].y = tmpvar_6;
  tmpvar_4[3].z = 0.0;
  tmpvar_4[3].w = 1.0;
  highp mat4 tmpvar_7;
  tmpvar_7[0].x = 1.0;
  tmpvar_7[0].y = 0.0;
  tmpvar_7[0].z = 0.0;
  tmpvar_7[0].w = 0.0;
  tmpvar_7[1].x = 0.0;
  tmpvar_7[1].y = 1.0;
  tmpvar_7[1].z = 0.0;
  tmpvar_7[1].w = 0.0;
  tmpvar_7[2].x = 0.0;
  tmpvar_7[2].y = 0.0;
  tmpvar_7[2].z = 1.0;
  tmpvar_7[2].w = 0.0;
  tmpvar_7[3].x = -(_MainPivot.x);
  tmpvar_7[3].y = (_MainPivot.y - _MainSize.y);
  tmpvar_7[3].z = 0.0;
  tmpvar_7[3].w = 1.0;
  highp float tmpvar_8;
  tmpvar_8 = cos(_Rotation.z);
  highp float tmpvar_9;
  tmpvar_9 = sin(_Rotation.z);
  if ((_HorizontalFlip > 0.1)) {
    xlat_mutable_Scale.x = -(_Scale.x);
  };
  if ((_VerticalFlip > 0.1)) {
    xlat_mutable_Scale.y = -(_Scale.y);
  };
  highp mat4 tmpvar_10;
  tmpvar_10[0].x = (tmpvar_8 * xlat_mutable_Scale.x);
  tmpvar_10[0].y = (tmpvar_9 * xlat_mutable_Scale.x);
  tmpvar_10[0].z = 0.0;
  tmpvar_10[0].w = 0.0;
  tmpvar_10[1].x = (-(tmpvar_9) * xlat_mutable_Scale.y);
  tmpvar_10[1].y = (tmpvar_8 * xlat_mutable_Scale.y);
  tmpvar_10[1].z = 0.0;
  tmpvar_10[1].w = 0.0;
  tmpvar_10[2].x = 0.0;
  tmpvar_10[2].y = 0.0;
  tmpvar_10[2].z = 1.0;
  tmpvar_10[2].w = 0.0;
  tmpvar_10[3].x = 0.0;
  tmpvar_10[3].y = 0.0;
  tmpvar_10[3].z = 0.0;
  tmpvar_10[3].w = 1.0;
  anchor_3 = vec2(0.0, 0.0);
  if ((_Use3DAnchor > 0.1)) {
    highp vec4 tmpvar_11;
    highp vec4 tmpvar_12;
    tmpvar_12.w = 1.0;
    tmpvar_12.xyz = _AnchorPoint;
    tmpvar_11 = (CAMERA_VIEWPROJ * tmpvar_12);
    anchor_3 = (tmpvar_11.xy / tmpvar_11.w);
    anchor_3 = (((anchor_3 * 0.5) + 0.5) * _VideoSize);
  } else {
    highp vec2 tmpvar_13;
    tmpvar_13.x = _AnchorPoint.x;
    tmpvar_13.y = (_VideoSize.y - _AnchorPoint.y);
    anchor_3 = tmpvar_13;
  };
  highp mat4 tmpvar_14;
  tmpvar_14[0].x = 1.0;
  tmpvar_14[0].y = 0.0;
  tmpvar_14[0].z = 0.0;
  tmpvar_14[0].w = 0.0;
  tmpvar_14[1].x = 0.0;
  tmpvar_14[1].y = 1.0;
  tmpvar_14[1].z = 0.0;
  tmpvar_14[1].w = 0.0;
  tmpvar_14[2].x = 0.0;
  tmpvar_14[2].y = 0.0;
  tmpvar_14[2].z = 1.0;
  tmpvar_14[2].w = 0.0;
  tmpvar_14[3].x = anchor_3.x;
  tmpvar_14[3].y = anchor_3.y;
  tmpvar_14[3].z = 0.0;
  tmpvar_14[3].w = 1.0;
  highp mat4 tmpvar_15;
  tmpvar_15[0].x = (2.0 / _VideoSize.x);
  tmpvar_15[0].y = 0.0;
  tmpvar_15[0].z = 0.0;
  tmpvar_15[0].w = 0.0;
  tmpvar_15[1].x = 0.0;
  tmpvar_15[1].y = (2.0 / _VideoSize.y);
  tmpvar_15[1].z = 0.0;
  tmpvar_15[1].w = 0.0;
  tmpvar_15[2].x = 0.0;
  tmpvar_15[2].y = 0.0;
  tmpvar_15[2].z = 1.0;
  tmpvar_15[2].w = 0.0;
  tmpvar_15[3].x = -1.0;
  tmpvar_15[3].y = -1.0;
  tmpvar_15[3].z = 0.0;
  tmpvar_15[3].w = 1.0;
  tmpvar_2 = ((tmpvar_15 * (tmpvar_14 * 
    (tmpvar_10 * (tmpvar_7 * tmpvar_4))
  )) * _glesVertex);
  highp vec4 o_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = (tmpvar_2 * 0.5);
  o_16.zw = tmpvar_17.zw;
  o_16.xy = (tmpvar_17.xy + tmpvar_17.ww);
  o_16.y = ((2.0 * tmpvar_17.w) - o_16.y);
  o_16.zw = tmpvar_2.zw;
  highp vec4 tmpvar_18;
  tmpvar_18.zw = vec2(0.0, 1.0);
  tmpvar_18.xy = tmpvar_2.xy;
  highp vec4 tmpvar_19;
  tmpvar_19.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_19.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_18);
  tmpvar_2 = tmpvar_20;
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = o_16;
  gl_Position = tmpvar_20;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _MainTex;
uniform sampler2D _LutMap;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec3 resColor_2;
  highp vec4 RColor_3;
  highp vec4 MColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_MainTex, xlv_TEXCOORD0);
  MColor_4 = tmpvar_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = MColor_4.xyz;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD1.xy / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_GRAP, tmpvar_7);
  RColor_3 = tmpvar_8;
  highp vec3 tmpvar_9;
  tmpvar_9 = RColor_3.xyz;
  highp vec2 tmpvar_10;
  tmpvar_10.x = tmpvar_6.x;
  tmpvar_10.y = tmpvar_9.x;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_LutMap, tmpvar_10);
  resColor_2.x = tmpvar_11.x;
  highp vec2 tmpvar_12;
  tmpvar_12.x = tmpvar_6.y;
  tmpvar_12.y = tmpvar_9.y;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_LutMap, tmpvar_12);
  resColor_2.y = tmpvar_13.y;
  highp vec2 tmpvar_14;
  tmpvar_14.x = tmpvar_6.z;
  tmpvar_14.y = tmpvar_9.z;
  lowp vec4 tmpvar_15;
  tmpvar_15 = texture2D (_LutMap, tmpvar_14);
  resColor_2.z = tmpvar_15.z;
  highp vec4 tmpvar_16;
  tmpvar_16.xyz = mix (RColor_3.xyz, resColor_2, vec3((MColor_4.w * _Opacity)));
  tmpvar_16.w = 1.0;
  tmpvar_1 = tmpvar_16;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
}

end
