

#DEFPARAMS
_FgTex = { "Foreground Tex", TEXTURE2D, "white" },
_BgTex = { "Background Tex", TEXTURE2D, "black" },
_MatFgToBg1 = { "", VEC3, "0, 0, 0" },
_MatFgToBg2 = { "", VEC3, "0, 0, 0" },
_MatFgToBg3 = { "", VEC3, "0, 0, 0" },
_BgSize = { "", VEC2, "1, 1" },
_BgAnchor1 = { "", VEC2, "0, 0" },
_BgAnchor2 = { "", VEC2, "0, 0" },
_BgAnchor3 = { "", VEC2, "0, 0" },
_BgAnchor4 = { "", VEC2, "0, 0" },
_AlphaAdjust = { "", FLOAT, "1" },
#END

#DEFTAG
ShaderName = "FaceSkin"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
#include "rgb_hsv.inc"

struct appdata
{
    float2 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
};

sampler2D _FgTex;
sampler2D _BgTex;
float3 _MatFgToBg1;
float3 _MatFgToBg2;
float3 _MatFgToBg3;
float2 _BgSize;
float2 _BgAnchor1;
float2 _BgAnchor2;
float2 _BgAnchor3;
float2 _BgAnchor4;
float _AlphaAdjust;

v2f vert(appdata v)
{
    v2f o;
    float3 xy = float3((v.vertex.xy + 1.0) * 0.5, 1.0);

    float3x3 mat = float3x3(_MatFgToBg1, _MatFgToBg2, _MatFgToBg3);

    xy = mul(xy, mat);

    o.vertex = UniformNDC(float4(xy.xy * 2.0 - 1.0, 0.0, 1.0));
    o.uv = v.uv;
    o.uv.y = 1.0 - o.uv.y;
    return o;
}

float3 getBgColor(float2 uv, float3x3 mat)
{
    float3 p = mul(float3(uv, 1.0), mat);
    p.y = 1.0 - p.y;
    uv = p.xy;
    return tex2D(_BgTex, uv).rgb;
}

bool checkHSV(float3 hsv, float3 hsv1, float3 hsv2, float3 hsv3)
{
    bool checkHue = hsv.x < 0.16666667;
    bool checkSat = hsv.y < 0.75;
    return checkHue && checkSat;
}

float4 frag(v2f i) : SV_Target
{
    float alpha = tex2D(_FgTex, i.uv).a;
    alpha = 1.0 - pow(1.0 - alpha, _AlphaAdjust);

    float3x3 mat = float3x3(_MatFgToBg1, _MatFgToBg2, _MatFgToBg3);

    float2 bgSizeInv = float2(1.0/_BgSize.x, 1.0/_BgSize.y);
    float2 bgUV1 = _BgAnchor1 * bgSizeInv;
    float2 bgUV2 = _BgAnchor2 * bgSizeInv;
    float2 bgUV3 = _BgAnchor3 * bgSizeInv;
    float2 bgUV4 = _BgAnchor4 * bgSizeInv;

    float2 bgUV = mul(float3(i.uv, 1.0), mat).xy;
    bgUV.y = 1.0 - bgUV.y;
    float3 colBg = tex2D(_BgTex, bgUV).rgb;

    float3 col1 = tex2D(_BgTex, bgUV1).rgb;
    float3 col2 = tex2D(_BgTex, bgUV2).rgb;
    float3 col3 = tex2D(_BgTex, bgUV3).rgb;
    float3 col4 = tex2D(_BgTex, bgUV4).rgb;

    float3 hsv1 = (rgb2hsv(col1));
    float3 hsv2 = (rgb2hsv(col2));
    float3 hsv3 = (rgb2hsv(col3));
    float3 hsv4 = (rgb2hsv(col4));

    bool check1 = checkHSV(hsv1, hsv2, hsv3, hsv4);
    bool check2 = checkHSV(hsv2, hsv3, hsv4, hsv1);
    bool check3 = checkHSV(hsv3, hsv4, hsv1, hsv2);
    bool check4 = checkHSV(hsv4, hsv1, hsv2, hsv3);

    float4 col = 0.0;
    col += check1 ? float4(col1, 1.0) : 0.0;
    col += check2 ? float4(col2, 1.0) : 0.0;
    col += check3 ? float4(col3, 1.0) : 0.0;
    col += check4 ? float4(col4, 1.0) : 0.0;

    float4 colFinal = col.a > 0 ? float4(col.rgb/col.a, alpha) : float4(colBg, 1.0);
    
    /*
    //debug green points begin
    float2 bgPos = bgUV * _BgSize;
    float length1 = length(bgPos - _BgAnchor1);
    float length2 = length(bgPos - _BgAnchor2);
    float length3 = length(bgPos - _BgAnchor3);
    float length4 = length(bgPos - _BgAnchor4);
    const float drawPointThr = 2.5;
    const float4 green = float4(0.0, 1.0, 0.0, 1.0);
    const float4 red = float4(1.0, 0.0, 0.0, 1.0);
    if (length1 <= drawPointThr)
    {
        colFinal = check1 ? green : red;
    }
    else if (length2 <= drawPointThr)
    {
        colFinal = check2 ? green : red;
    }
    else if (length3 <= drawPointThr)
    {
        colFinal = check3 ? green : red;
    }
    else if (length4 <= drawPointThr)
    {
        colFinal = check4 ? green : red;
    }
    //debug green points end
    */

    return colFinal;
}

ENDCG
#END
