#DEFPARAMS
_FgTex = { "Fg Tex", TEXTURE2D, "white" },
_FgRatio = { "Fg Ratio", VEC2, "1, 1" },
_FgPivot = { "Fg Pivot", VEC2, "0.5, 0.5" },
_Opacity = { "Opacity", FLOATRANGE, "1, 1, 0" },
[Enum(BlendFactor)]
_BlendSrc = {"Blend Src", FLOAT, "4.0"},
[Enum(BlendFactor)]
_BlendDst = {"Blend Dst", FLOAT, "5.0"},
[Keywords(
	BLEND_NORMAL, 
	BLEND_DARKEN,
	BLEND_MULTIPLY, 
	BLEND_COLORBURN,
	BLEND_LINEARBURN,
	BLEND_DARKER_COLOR,
	BLEND_LIGHTEN,
	BLEND_SCREEN,
	BLEND_COLORDODGE,
	BLEND_LINEARDODGE,
	BLEND_LIGHTER_COLOR,
	BLEND_OVERLAY,
	BLEND_SOFTLIGHT,
	BLEND_HARDLIGHT,
	BLEND_VIVIDLIGHT,
	BLEND_LINEARLIGHT,
	BLEND_PINLIGHT,
	BLEND_HARDMIX,
	BLEND_DIFFERENCE,
	BLEND_EXCLUSION,
	BLEND_SUBTRACT,
	BLEND_DIVIDE,
	BLEND_HUE,
	BLEND_SATURATION,
	BLEND_COLOR,
	BLEND_LUMINOSITY,
	BLEND_BLEND,
)]
_BlendMode = {"Blend Mode", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "FaceParse"
RenderQueue = "Transparent+1"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc", "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag

#include "common.inc"
#include "rgb_hsv.inc"

#pragma multi_compile BLEND_NORMAL BLEND_DARKEN BLEND_MULTIPLY BLEND_COLORBURN BLEND_LINEARBURN BLEND_DARKER_COLOR BLEND_LIGHTEN BLEND_SCREEN BLEND_COLORDODGE BLEND_LINEARDODGE BLEND_LIGHTER_COLOR BLEND_OVERLAY BLEND_SOFTLIGHT BLEND_HARDLIGHT BLEND_VIVIDLIGHT BLEND_LINEARLIGHT BLEND_PINLIGHT BLEND_HARDMIX BLEND_DIFFERENCE BLEND_EXCLUSION BLEND_SUBTRACT BLEND_DIVIDE BLEND_HUE BLEND_SATURATION BLEND_COLOR BLEND_LUMINOSITY BLEND_BLEND


struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;	
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float2 rtuv : TEXCOORD1;
	float4 vertex : SV_POSITION;
};

sampler2D _FgTex;
float2 _FgRatio;
float2 _FgPivot;
float _Opacity;


v2f vert(appdata v)
{
	v2f o = (v2f)0;

	//uv
	o.uv = v.uv;
	//convert pivot from image-coord to meth-coord
	float2 pivot = float2(_FgPivot.x, 1.0 - _FgPivot.y) * 2.0 - 1.0;
	//pivot offset
	float2 xy = v.vertex.xy - pivot;
	//adjust size
	xy *= _FgRatio;
	//to ndc
	float4 pos = ObjectToClipPos(float3(xy, 0.0));
	//float4 pos = float4(xy, 0.0, 1.0);
	o.vertex = UniformNDC(pos);
	//to rtuv
	pos = ComputeScreenPos(pos);
	o.rtuv = pos.xy / pos.w;

	return o;
}

fixed4 frag(v2f i) : SV_Target
{
	const float epsilon = 0.0001;
	float4 MColor = tex2D(_FgTex, i.uv);
	float3 srcColor = MColor.rgb;
	float alpha = MColor.a * _Opacity;

#if !(BLEND_NORMAL || BLEND_MULTIPLY || BLEND_SCREEN || BLEND_LINEARDODGE)
	float4 RColor = tex2D(TEXTURE_GRAP, i.rtuv);
	float3 dstColor = RColor.rgb;
#endif

	//srcAlpha 1-srcAlpha by default
#if   BLEND_NORMAL
	float3 color = srcColor;
#elif BLEND_DARKEN
	float3 color = min(srcColor, dstColor);
#elif BLEND_MULTIPLY
	//dstColor 0
	//float3 color = srcColor * dstColor;
	float3 color = 1.0 - alpha * (1.0 - srcColor);
#elif BLEND_COLORBURN
	float3 color = dstColor - (1.0 - srcColor) * (1.0 - dstColor) / (srcColor + epsilon);
#elif BLEND_LINEARBURN
	float3 color = srcColor + dstColor - 1.0;
#elif BLEND_DARKER_COLOR
	float3 srcHSL = hsv2hsl(rgb2hsv(srcColor));
	float3 dstHSL = hsv2hsl(rgb2hsv(dstColor));
	float s = step(srcHSL.b, dstHSL.b);
	float3 color = srcColor * s + dstColor * (1.0 - s);
#elif BLEND_LIGHTEN
	float3 color = max(srcColor, dstColor);
#elif BLEND_SCREEN
	//1 1-srcColor
	//float3 color = 1.0 - (1.0 - srcColor) * (1.0 - dstColor);
	float3 color = srcColor * alpha;
#elif BLEND_COLORDODGE
	float3 color = dstColor + srcColor * dstColor / (1.0 - srcColor + epsilon);
#elif BLEND_LINEARDODGE
	//srcAlpha 1
	//float3 color = srcColor + dstColor;
	float3 color = srcColor;
#elif BLEND_LIGHTER_COLOR
	float3 srcHSL = hsv2hsl(rgb2hsv(srcColor));
	float3 dstHSL = hsv2hsl(rgb2hsv(dstColor));
	float s = step(srcHSL.b, dstHSL.b);
	float3 color = srcColor * (1.0 - s) + dstColor * s;
#elif BLEND_OVERLAY
	float3 s = step(dstColor, 0.5);
	float3 p1 = 2.0 * srcColor * dstColor;
	float3 p2 = 1.0 - 2.0 * (1.0 - srcColor) * (1.0 - dstColor);
	float3 color = p1 * s + p2 * (1.0 - s);
#elif BLEND_SOFTLIGHT
	float3 s = step(srcColor, 0.5);
	float3 p1 = 2.0 * srcColor * dstColor + dstColor * dstColor * (1.0 - 2.0 * srcColor);
	float3 p2 = 2.0 * (1.0 - srcColor) * dstColor + sqrt(dstColor) * (2.0 * srcColor - 1.0);
	float3 color = p1 * s + p2 * (1.0 - s);
#elif BLEND_HARDLIGHT
	float3 s = step(srcColor, 0.5);
	float3 p1 = 2.0 * srcColor * dstColor;
	float3 p2 = 1.0 - 2.0 * (1.0 - srcColor) * (1.0 - dstColor);
	float3 color = p1 * s + p2 * (1.0 - s);
#elif BLEND_VIVIDLIGHT
	float3 s = step(srcColor, 0.5);
	float3 p1 = dstColor - (1.0 - dstColor) * (1.0 - 2.0 * srcColor) / (2.0 * srcColor + epsilon);
	float3 p2 = dstColor + dstColor * (2.0 * srcColor - 1.0) / (2.0 * (1.0 - srcColor) + epsilon);
	float3 color = p1 * s + p2 * (1.0 - s);
#elif BLEND_LINEARLIGHT
	float3 color = dstColor + 2.0 * srcColor - 1.0;
#elif BLEND_PINLIGHT
	float3 s = step(srcColor, 0.5);
	float3 p1 = min(dstColor, 2.0 * srcColor);
	float3 p2 = min(dstColor, 2.0 * srcColor - 1.0);
	float3 color = p1 * s + p2 * (1.0 - s);
#elif BLEND_HARDMIX
	float3 s = step(1.0, srcColor + dstColor);
	float3 color = s;
#elif BLEND_DIFFERENCE
	float3 color = abs(dstColor - srcColor);
#elif BLEND_EXCLUSION
	float3 color = srcColor + dstColor - 2.0 * srcColor * dstColor;
#elif BLEND_SUBTRACT
	float3 color = max(dstColor - srcColor, float3(0.0, 0.0, 0.0));
#elif BLEND_DIVIDE
	float3 color = min(dstColor / (srcColor + epsilon), float3(1.0, 1.0, 1.0));
#elif BLEND_HUE
	float3 srcHSL = hsv2hsl(rgb2hsv(srcColor));
	float3 dstHSL = hsv2hsl(rgb2hsv(dstColor));
	float3 color = hsv2rgb(hsl2hsv(float3(srcHSL.r, dstHSL.g, dstHSL.b)));
#elif BLEND_SATURATION
	float3 srcHSL = hsv2hsl(rgb2hsv(srcColor));
	float3 dstHSL = hsv2hsl(rgb2hsv(dstColor));
	float3 color = hsv2rgb(hsl2hsv(float3(dstHSL.r, srcHSL.g, dstHSL.b)));
#elif BLEND_LUMINOSITY
	float3 srcHSL = hsv2hsl(rgb2hsv(srcColor));
	float3 dstHSL = hsv2hsl(rgb2hsv(dstColor));
	float3 color = hsv2rgb(hsl2hsv(float3(dstHSL.r, dstHSL.g, srcHSL.b)));
#elif BLEND_COLOR
	float3 srcHSL = hsv2hsl(rgb2hsv(srcColor));
	float3 dstHSL = hsv2hsl(rgb2hsv(dstColor));
	float3 color = hsv2rgb(hsl2hsv(float3(srcHSL.r, srcHSL.g, dstHSL.b)));
#elif BLEND_BLEND
	float intensity = dot(float3(0.2990, 0.5870, 0.1140), dstColor);
	float3 color = srcColor * intensity * 1.68;
#else
	float3 color = srcColor;
#endif

	return float4(color, alpha);
	//return float4(1.0, 0.0, 0.0, 1.0);
}
ENDCG
#END
