function DefineParams()
	Properties = 
	{
		
MainTex = { "main Color", TEXTURE2D, "white" },
NormalTexture = {"Normal Map", TEXTURE2D, "white"},
SpecularTex = {"Specular Map", TEXTURE2D, "white"},
BRDFTex = {"BRDF Map", TEXTURE2D, "white"},
skybox = {"SkyBox", TEXTURECUBE, "black"},

ShadeColor = {"Shade Color", COLOR, "0.0,0.0,0.0,1.0"},
ShadowColor = {"Shadow Color", COLOR, "0.0,0.0,0.0,1.0"},
SpecularColor = {"Specular Color", COLOR, "0.0,0.0,0.0,1.0"},
RimColor = {"Rim Color", COLOR, "0.0,0.0,0.0,1.0"},
RimPower = {"Rim Pow", FLOAT, "0.5"},

Fresnel = { "Fresnel", FLOAT, "0.5" },
extraShadeRange = { "extraShadeRange", FLOAT, "0.5" },


	}
	Attributes = 
	{
	}
	
end

  

function Init()
	PassNames = 
	{
		"ForwardBase","ForwardAdd","Depth"
	}

ShaderName = "StandardSkin"
RenderQueue = "Opaque"
end
  
function ForwardBase()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BRDFTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "skybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RimColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RimPower",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[uint(0)].x = row0_6.x;
  tmpvar_11[uint(0)].y = row0_6.y;
  tmpvar_11[uint(0)].z = row0_6.z;
  tmpvar_11[uint(0)].w = row0_6.w;
  tmpvar_11[1u].x = row1_5.x;
  tmpvar_11[1u].y = row1_5.y;
  tmpvar_11[1u].z = row1_5.z;
  tmpvar_11[1u].w = row1_5.w;
  tmpvar_11[2u].x = row2_4.x;
  tmpvar_11[2u].y = row2_4.y;
  tmpvar_11[2u].z = row2_4.z;
  tmpvar_11[2u].w = row2_4.w;
  tmpvar_11[3u].x = 0.0;
  tmpvar_11[3u].y = 0.0;
  tmpvar_11[3u].z = 0.0;
  tmpvar_11[3u].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_14[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_14[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_15[1u] = tmpvar_11[1u].xyz;
  tmpvar_15[2u] = tmpvar_11[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_17[1u] = tmpvar_11[1u].xyz;
  tmpvar_17[2u] = tmpvar_11[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_19[1u] = tmpvar_11[1u].xyz;
  tmpvar_19[2u] = tmpvar_11[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform sampler2D BRDFTex;
uniform lowp samplerCube skybox;
uniform highp vec4 ShadeColor;
uniform highp vec4 SpecularColor;
uniform highp vec4 RimColor;
uniform highp float RimPower;
uniform highp float Fresnel;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 brdfColor_4;
  highp vec3 specular_5;
  highp vec3 mainColor_6;
  highp vec3 mainNormal_7;
  highp vec3 tmpvar_8;
  tmpvar_8.x = xlv_TEXCOORD1.w;
  tmpvar_8.y = xlv_TEXCOORD2.w;
  tmpvar_8.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize((CAMERA_WORLDPOSITION - tmpvar_8));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_7 = tmpvar_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = ((mainNormal_7 * 2.0) - 1.0);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((
    (tmpvar_11.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_11.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_11.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_13;
  tmpvar_13 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_14;
  tmpvar_14 = max (dot (tmpvar_12, tmpvar_9), 0.0);
  highp float tmpvar_15;
  tmpvar_15 = max (dot (tmpvar_12, normalize(
    (tmpvar_9 + tmpvar_13)
  )), 0.0);
  lowp vec3 tmpvar_16;
  tmpvar_16 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_6 = tmpvar_16;
  mainColor_6 = (mainColor_6 * mainColor_6);
  lowp vec3 tmpvar_17;
  tmpvar_17 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_5 = tmpvar_17;
  highp float tmpvar_18;
  tmpvar_18 = (1.0 - specular_5.x);
  highp vec2 tmpvar_19;
  tmpvar_19.x = ((dot (tmpvar_12, tmpvar_13) * 0.5) + 0.5);
  tmpvar_19.y = specular_5.y;
  lowp vec3 tmpvar_20;
  tmpvar_20 = texture (BRDFTex, tmpvar_19).xyz;
  brdfColor_4 = tmpvar_20;
  highp vec3 I_21;
  I_21 = -(tmpvar_9);
  reflectDir_3.xyz = (I_21 - (2.0 * (
    dot (tmpvar_12, I_21)
   * tmpvar_12)));
  reflectDir_3.w = (tmpvar_18 * 4.0);
  lowp vec4 tmpvar_22;
  tmpvar_22 = textureLod (skybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_23;
  tmpvar_23 = tmpvar_22;
  iblColor_2.w = tmpvar_23.w;
  iblColor_2.xyz = ((tmpvar_23.xyz * tmpvar_23.w) * 4.0);
  highp float tmpvar_24;
  tmpvar_24 = max ((tmpvar_18 * tmpvar_18), 0.1);
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_24 * tmpvar_24);
  highp float tmpvar_26;
  tmpvar_26 = (((
    (tmpvar_15 * tmpvar_25)
   - tmpvar_15) * tmpvar_15) + 1.0);
  d_1 = ((0.3183099 * tmpvar_25) / ((tmpvar_26 * tmpvar_26) + 1e-7));
  highp float tmpvar_27;
  tmpvar_27 = min (d_1, 100.0);
  d_1 = tmpvar_27;
  highp vec4 tmpvar_28;
  tmpvar_28.w = 1.0;
  tmpvar_28.xyz = (((
    (((tmpvar_27 * mix (Fresnel, 1.0, 
      (1.0 - tmpvar_14)
    )) * LIGHT_COLOR) + (((iblColor_2.xyz * 0.5) * (
      ((min ((Fresnel * 2.0), 1.0) - Fresnel) * pow ((1.0 - tmpvar_14), 4.0))
     + Fresnel)) * AMBIENT_COLOR))
   * SpecularColor.xyz) + (
    (((brdfColor_4 * LIGHT_COLOR) * mainColor_6) + (AMBIENT_COLOR * mainColor_6))
   * 
    mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, tmpvar_14, (1.0 - specular_5.z))))
  )) + (RimColor * pow (
    (1.0 - max (0.0, dot (tmpvar_9, tmpvar_12)))
  , 
    (1.0/(RimPower))
  )).xyz);
  _glesFragData[0] = tmpvar_28;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BRDFTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "skybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RimColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RimPower",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[uint(0)].x = row0_6.x;
  tmpvar_11[uint(0)].y = row0_6.y;
  tmpvar_11[uint(0)].z = row0_6.z;
  tmpvar_11[uint(0)].w = row0_6.w;
  tmpvar_11[1u].x = row1_5.x;
  tmpvar_11[1u].y = row1_5.y;
  tmpvar_11[1u].z = row1_5.z;
  tmpvar_11[1u].w = row1_5.w;
  tmpvar_11[2u].x = row2_4.x;
  tmpvar_11[2u].y = row2_4.y;
  tmpvar_11[2u].z = row2_4.z;
  tmpvar_11[2u].w = row2_4.w;
  tmpvar_11[3u].x = 0.0;
  tmpvar_11[3u].y = 0.0;
  tmpvar_11[3u].z = 0.0;
  tmpvar_11[3u].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_14[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_14[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_15[1u] = tmpvar_11[1u].xyz;
  tmpvar_15[2u] = tmpvar_11[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_17[1u] = tmpvar_11[1u].xyz;
  tmpvar_17[2u] = tmpvar_11[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_19[1u] = tmpvar_11[1u].xyz;
  tmpvar_19[2u] = tmpvar_11[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform sampler2D BRDFTex;
uniform lowp samplerCube skybox;
uniform highp vec4 ShadeColor;
uniform highp vec4 SpecularColor;
uniform highp vec4 RimColor;
uniform highp float RimPower;
uniform highp float Fresnel;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 brdfColor_4;
  highp vec3 specular_5;
  highp vec3 mainColor_6;
  highp vec3 mainNormal_7;
  highp vec3 tmpvar_8;
  tmpvar_8.x = xlv_TEXCOORD1.w;
  tmpvar_8.y = xlv_TEXCOORD2.w;
  tmpvar_8.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize((CAMERA_WORLDPOSITION - tmpvar_8));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_7 = tmpvar_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = ((mainNormal_7 * 2.0) - 1.0);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((
    (tmpvar_11.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_11.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_11.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_13;
  tmpvar_13 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_14;
  tmpvar_14 = max (dot (tmpvar_12, tmpvar_9), 0.0);
  highp float tmpvar_15;
  tmpvar_15 = max (dot (tmpvar_12, normalize(
    (tmpvar_9 + tmpvar_13)
  )), 0.0);
  lowp vec3 tmpvar_16;
  tmpvar_16 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_6 = tmpvar_16;
  mainColor_6 = (mainColor_6 * mainColor_6);
  lowp vec3 tmpvar_17;
  tmpvar_17 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_5 = tmpvar_17;
  highp float tmpvar_18;
  tmpvar_18 = (1.0 - specular_5.x);
  highp vec2 tmpvar_19;
  tmpvar_19.x = ((dot (tmpvar_12, tmpvar_13) * 0.5) + 0.5);
  tmpvar_19.y = specular_5.y;
  lowp vec3 tmpvar_20;
  tmpvar_20 = texture (BRDFTex, tmpvar_19).xyz;
  brdfColor_4 = tmpvar_20;
  highp vec3 I_21;
  I_21 = -(tmpvar_9);
  reflectDir_3.xyz = (I_21 - (2.0 * (
    dot (tmpvar_12, I_21)
   * tmpvar_12)));
  reflectDir_3.w = (tmpvar_18 * 4.0);
  lowp vec4 tmpvar_22;
  tmpvar_22 = textureLod (skybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_23;
  tmpvar_23 = tmpvar_22;
  iblColor_2.w = tmpvar_23.w;
  iblColor_2.xyz = ((tmpvar_23.xyz * tmpvar_23.w) * 4.0);
  highp float tmpvar_24;
  tmpvar_24 = max ((tmpvar_18 * tmpvar_18), 0.1);
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_24 * tmpvar_24);
  highp float tmpvar_26;
  tmpvar_26 = (((
    (tmpvar_15 * tmpvar_25)
   - tmpvar_15) * tmpvar_15) + 1.0);
  d_1 = ((0.3183099 * tmpvar_25) / ((tmpvar_26 * tmpvar_26) + 1e-7));
  highp float tmpvar_27;
  tmpvar_27 = min (d_1, 100.0);
  d_1 = tmpvar_27;
  highp vec4 tmpvar_28;
  tmpvar_28.w = 1.0;
  tmpvar_28.xyz = (((
    (((tmpvar_27 * mix (Fresnel, 1.0, 
      (1.0 - tmpvar_14)
    )) * LIGHT_COLOR) + (((iblColor_2.xyz * 0.5) * (
      ((min ((Fresnel * 2.0), 1.0) - Fresnel) * pow ((1.0 - tmpvar_14), 4.0))
     + Fresnel)) * AMBIENT_COLOR))
   * SpecularColor.xyz) + (
    (((brdfColor_4 * LIGHT_COLOR) * mainColor_6) + (AMBIENT_COLOR * mainColor_6))
   * 
    mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, tmpvar_14, (1.0 - specular_5.z))))
  )) + (RimColor * pow (
    (1.0 - max (0.0, dot (tmpvar_9, tmpvar_12)))
  , 
    (1.0/(RimPower))
  )).xyz);
  _glesFragData[0] = tmpvar_28;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BRDFTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "skybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadowColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RimColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RimPower",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform sampler2D BRDFTex;
uniform lowp samplerCube skybox;
uniform highp vec4 ShadeColor;
uniform highp vec4 ShadowColor;
uniform highp vec4 SpecularColor;
uniform highp vec4 RimColor;
uniform highp float RimPower;
uniform highp float Fresnel;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 brdfColor_4;
  highp vec3 specular_5;
  highp vec3 mainColor_6;
  highp vec3 mainNormal_7;
  highp vec4 shadowCoord_8;
  shadowCoord_8 = xlv_TEXCOORD4;
  highp float tmpvar_9;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_9 = 1.0;
  } else {
    shadowCoord_8.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_10;
    highp vec2 fetchesOffsetsU_11;
    highp float shadow_12;
    highp vec2 tmpvar_13;
    tmpvar_13 = (shadowCoord_8.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_14;
    tmpvar_14 = floor((tmpvar_13 + 0.5));
    highp vec2 tmpvar_15;
    tmpvar_15 = (tmpvar_13 - tmpvar_14);
    highp vec4 computedWeight_16;
    highp vec4 computedArea_17;
    highp vec4 computedAreaUncut_18;
    highp float tmpvar_19;
    tmpvar_19 = (((tmpvar_15.x + 0.5) * (tmpvar_15.x + 0.5)) * 0.5);
    highp float tmpvar_20;
    tmpvar_20 = (tmpvar_19 - tmpvar_15.x);
    computedArea_17.x = tmpvar_20;
    computedAreaUncut_18.x = tmpvar_20;
    computedArea_17.w = tmpvar_19;
    computedAreaUncut_18.w = tmpvar_19;
    computedAreaUncut_18.y = ((1.5 - tmpvar_15.x) - 0.5);
    highp float tmpvar_21;
    tmpvar_21 = min (tmpvar_15.x, 0.0);
    computedArea_17.y = (computedAreaUncut_18.y - (tmpvar_21 * tmpvar_21));
    computedAreaUncut_18.z = ((1.5 + tmpvar_15.x) - 0.5);
    highp float tmpvar_22;
    tmpvar_22 = max (tmpvar_15.x, 0.0);
    computedArea_17.z = (computedAreaUncut_18.z - (tmpvar_22 * tmpvar_22));
    computedWeight_16 = (computedArea_17 * 0.44444);
    highp vec4 computedWeight_23;
    highp vec4 computedArea_24;
    highp vec4 computedAreaUncut_25;
    highp float tmpvar_26;
    tmpvar_26 = (((tmpvar_15.y + 0.5) * (tmpvar_15.y + 0.5)) * 0.5);
    highp float tmpvar_27;
    tmpvar_27 = (tmpvar_26 - tmpvar_15.y);
    computedArea_24.x = tmpvar_27;
    computedAreaUncut_25.x = tmpvar_27;
    computedArea_24.w = tmpvar_26;
    computedAreaUncut_25.w = tmpvar_26;
    computedAreaUncut_25.y = ((1.5 - tmpvar_15.y) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = min (tmpvar_15.y, 0.0);
    computedArea_24.y = (computedAreaUncut_25.y - (tmpvar_28 * tmpvar_28));
    computedAreaUncut_25.z = ((1.5 + tmpvar_15.y) - 0.5);
    highp float tmpvar_29;
    tmpvar_29 = max (tmpvar_15.y, 0.0);
    computedArea_24.z = (computedAreaUncut_25.z - (tmpvar_29 * tmpvar_29));
    computedWeight_23 = (computedArea_24 * 0.44444);
    highp vec2 tmpvar_30;
    tmpvar_30 = (computedWeight_16.xz + computedWeight_16.yw);
    highp vec2 tmpvar_31;
    tmpvar_31 = (computedWeight_23.xz + computedWeight_23.yw);
    fetchesOffsetsU_11 = (((computedWeight_16.yw / tmpvar_30) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_10 = (((computedWeight_23.yw / tmpvar_31) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_32;
    tmpvar_32 = (tmpvar_14 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_33;
    tmpvar_33.x = fetchesOffsetsU_11.x;
    tmpvar_33.y = fetchesOffsetsV_10.x;
    highp vec3 tmpvar_34;
    tmpvar_34.xy = (tmpvar_32 + tmpvar_33);
    tmpvar_34.z = shadowCoord_8.z;
    mediump float tmpvar_35;
    tmpvar_35 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_34);
    shadow_12 = ((tmpvar_30.x * tmpvar_31.x) * tmpvar_35);
    highp vec2 tmpvar_36;
    tmpvar_36.x = fetchesOffsetsU_11.y;
    tmpvar_36.y = fetchesOffsetsV_10.x;
    highp vec3 tmpvar_37;
    tmpvar_37.xy = (tmpvar_32 + tmpvar_36);
    tmpvar_37.z = shadowCoord_8.z;
    mediump float tmpvar_38;
    tmpvar_38 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_37);
    shadow_12 = (shadow_12 + ((tmpvar_30.y * tmpvar_31.x) * tmpvar_38));
    highp vec2 tmpvar_39;
    tmpvar_39.x = fetchesOffsetsU_11.x;
    tmpvar_39.y = fetchesOffsetsV_10.y;
    highp vec3 tmpvar_40;
    tmpvar_40.xy = (tmpvar_32 + tmpvar_39);
    tmpvar_40.z = shadowCoord_8.z;
    mediump float tmpvar_41;
    tmpvar_41 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_40);
    shadow_12 = (shadow_12 + ((tmpvar_30.x * tmpvar_31.y) * tmpvar_41));
    highp vec2 tmpvar_42;
    tmpvar_42.x = fetchesOffsetsU_11.y;
    tmpvar_42.y = fetchesOffsetsV_10.y;
    highp vec3 tmpvar_43;
    tmpvar_43.xy = (tmpvar_32 + tmpvar_42);
    tmpvar_43.z = shadowCoord_8.z;
    mediump float tmpvar_44;
    tmpvar_44 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_43);
    shadow_12 = (shadow_12 + ((tmpvar_30.y * tmpvar_31.y) * tmpvar_44));
    tmpvar_9 = mix (1.0, shadow_12, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_45;
  tmpvar_45.x = xlv_TEXCOORD1.w;
  tmpvar_45.y = xlv_TEXCOORD2.w;
  tmpvar_45.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_46;
  tmpvar_46 = normalize((CAMERA_WORLDPOSITION - tmpvar_45));
  lowp vec3 tmpvar_47;
  tmpvar_47 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_7 = tmpvar_47;
  highp vec3 tmpvar_48;
  tmpvar_48 = ((mainNormal_7 * 2.0) - 1.0);
  highp vec3 tmpvar_49;
  tmpvar_49 = normalize(((
    (tmpvar_48.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_48.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_48.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_50;
  tmpvar_50 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_51;
  tmpvar_51 = max (dot (tmpvar_49, tmpvar_46), 0.0);
  highp float tmpvar_52;
  tmpvar_52 = max (dot (tmpvar_49, normalize(
    (tmpvar_46 + tmpvar_50)
  )), 0.0);
  lowp vec3 tmpvar_53;
  tmpvar_53 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_6 = tmpvar_53;
  mainColor_6 = (mainColor_6 * mainColor_6);
  lowp vec3 tmpvar_54;
  tmpvar_54 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_5 = tmpvar_54;
  highp float tmpvar_55;
  tmpvar_55 = (1.0 - specular_5.x);
  highp vec2 tmpvar_56;
  tmpvar_56.x = ((dot (tmpvar_49, tmpvar_50) * 0.5) + 0.5);
  tmpvar_56.y = specular_5.y;
  lowp vec3 tmpvar_57;
  tmpvar_57 = texture (BRDFTex, tmpvar_56).xyz;
  brdfColor_4 = tmpvar_57;
  highp vec3 I_58;
  I_58 = -(tmpvar_46);
  reflectDir_3.xyz = (I_58 - (2.0 * (
    dot (tmpvar_49, I_58)
   * tmpvar_49)));
  reflectDir_3.w = (tmpvar_55 * 4.0);
  lowp vec4 tmpvar_59;
  tmpvar_59 = textureLod (skybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_60;
  tmpvar_60 = tmpvar_59;
  iblColor_2.w = tmpvar_60.w;
  iblColor_2.xyz = ((tmpvar_60.xyz * tmpvar_60.w) * 4.0);
  highp float tmpvar_61;
  tmpvar_61 = max ((tmpvar_55 * tmpvar_55), 0.1);
  highp float tmpvar_62;
  tmpvar_62 = (tmpvar_61 * tmpvar_61);
  highp float tmpvar_63;
  tmpvar_63 = (((
    (tmpvar_52 * tmpvar_62)
   - tmpvar_52) * tmpvar_52) + 1.0);
  d_1 = ((0.3183099 * tmpvar_62) / ((tmpvar_63 * tmpvar_63) + 1e-7));
  highp float tmpvar_64;
  tmpvar_64 = min (d_1, 100.0);
  d_1 = tmpvar_64;
  highp vec4 tmpvar_65;
  tmpvar_65.w = 1.0;
  tmpvar_65.xyz = (((
    (((tmpvar_64 * mix (Fresnel, 1.0, 
      (1.0 - tmpvar_51)
    )) * LIGHT_COLOR) + (((iblColor_2.xyz * 0.5) * (
      ((min ((Fresnel * 2.0), 1.0) - Fresnel) * pow ((1.0 - tmpvar_51), 4.0))
     + Fresnel)) * AMBIENT_COLOR))
   * SpecularColor.xyz) + (
    (((mix (ShadowColor.xyz, brdfColor_4, vec3(tmpvar_9)) * LIGHT_COLOR) * mainColor_6) + (AMBIENT_COLOR * mainColor_6))
   * 
    mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, tmpvar_51, (1.0 - specular_5.z))))
  )) + (RimColor * pow (
    (1.0 - max (0.0, dot (tmpvar_46, tmpvar_49)))
  , 
    (1.0/(RimPower))
  )).xyz);
  _glesFragData[0] = tmpvar_65;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BRDFTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "skybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadowColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RimColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RimPower",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform sampler2D BRDFTex;
uniform lowp samplerCube skybox;
uniform highp vec4 ShadeColor;
uniform highp vec4 ShadowColor;
uniform highp vec4 SpecularColor;
uniform highp vec4 RimColor;
uniform highp float RimPower;
uniform highp float Fresnel;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 brdfColor_4;
  highp vec3 specular_5;
  highp vec3 mainColor_6;
  highp vec3 mainNormal_7;
  highp vec4 shadowCoord_8;
  shadowCoord_8 = xlv_TEXCOORD4;
  highp float tmpvar_9;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_9 = 1.0;
  } else {
    shadowCoord_8.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_10;
    highp vec3 fetchesOffsetsU_11;
    highp float shadow_12;
    highp vec2 tmpvar_13;
    tmpvar_13 = (shadowCoord_8.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_14;
    tmpvar_14 = floor((tmpvar_13 + 0.5));
    highp vec2 tmpvar_15;
    tmpvar_15 = (tmpvar_13 - tmpvar_14);
    highp vec3 texelsWeightsA_16;
    highp vec3 texelsWeightsB_17;
    highp vec4 computedArea_18;
    highp vec4 computedAreaUncut_19;
    highp float tmpvar_20;
    tmpvar_20 = (((tmpvar_15.x + 0.5) * (tmpvar_15.x + 0.5)) * 0.5);
    highp float tmpvar_21;
    tmpvar_21 = (tmpvar_20 - tmpvar_15.x);
    computedArea_18.x = tmpvar_21;
    computedAreaUncut_19.x = tmpvar_21;
    computedArea_18.w = tmpvar_20;
    computedAreaUncut_19.w = tmpvar_20;
    computedAreaUncut_19.y = ((1.5 - tmpvar_15.x) - 0.5);
    highp float tmpvar_22;
    tmpvar_22 = min (tmpvar_15.x, 0.0);
    computedArea_18.y = (computedAreaUncut_19.y - (tmpvar_22 * tmpvar_22));
    computedAreaUncut_19.z = ((1.5 + tmpvar_15.x) - 0.5);
    highp float tmpvar_23;
    tmpvar_23 = max (tmpvar_15.x, 0.0);
    computedArea_18.z = (computedAreaUncut_19.z - (tmpvar_23 * tmpvar_23));
    texelsWeightsA_16.x = (0.16 * tmpvar_21);
    texelsWeightsA_16.y = (0.16 * computedAreaUncut_19.y);
    texelsWeightsA_16.z = (0.16 * (computedArea_18.y + 1.0));
    texelsWeightsB_17.x = (0.16 * (computedArea_18.z + 1.0));
    texelsWeightsB_17.y = (0.16 * computedAreaUncut_19.z);
    texelsWeightsB_17.z = (0.16 * tmpvar_20);
    highp vec3 texelsWeightsA_24;
    highp vec3 texelsWeightsB_25;
    highp vec4 computedArea_26;
    highp vec4 computedAreaUncut_27;
    highp float tmpvar_28;
    tmpvar_28 = (((tmpvar_15.y + 0.5) * (tmpvar_15.y + 0.5)) * 0.5);
    highp float tmpvar_29;
    tmpvar_29 = (tmpvar_28 - tmpvar_15.y);
    computedArea_26.x = tmpvar_29;
    computedAreaUncut_27.x = tmpvar_29;
    computedArea_26.w = tmpvar_28;
    computedAreaUncut_27.w = tmpvar_28;
    computedAreaUncut_27.y = ((1.5 - tmpvar_15.y) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = min (tmpvar_15.y, 0.0);
    computedArea_26.y = (computedAreaUncut_27.y - (tmpvar_30 * tmpvar_30));
    computedAreaUncut_27.z = ((1.5 + tmpvar_15.y) - 0.5);
    highp float tmpvar_31;
    tmpvar_31 = max (tmpvar_15.y, 0.0);
    computedArea_26.z = (computedAreaUncut_27.z - (tmpvar_31 * tmpvar_31));
    texelsWeightsA_24.x = (0.16 * tmpvar_29);
    texelsWeightsA_24.y = (0.16 * computedAreaUncut_27.y);
    texelsWeightsA_24.z = (0.16 * (computedArea_26.y + 1.0));
    texelsWeightsB_25.x = (0.16 * (computedArea_26.z + 1.0));
    texelsWeightsB_25.y = (0.16 * computedAreaUncut_27.z);
    texelsWeightsB_25.z = (0.16 * tmpvar_28);
    highp vec3 tmpvar_32;
    tmpvar_32.xy = texelsWeightsA_16.xz;
    tmpvar_32.z = texelsWeightsB_17.y;
    highp vec3 tmpvar_33;
    tmpvar_33.x = texelsWeightsA_16.y;
    tmpvar_33.yz = texelsWeightsB_17.xz;
    highp vec3 tmpvar_34;
    tmpvar_34 = (tmpvar_32 + tmpvar_33);
    highp vec3 tmpvar_35;
    tmpvar_35.xy = texelsWeightsA_24.xz;
    tmpvar_35.z = texelsWeightsB_25.y;
    highp vec3 tmpvar_36;
    tmpvar_36.x = texelsWeightsA_24.y;
    tmpvar_36.yz = texelsWeightsB_25.xz;
    highp vec3 tmpvar_37;
    tmpvar_37 = (tmpvar_35 + tmpvar_36);
    highp vec3 tmpvar_38;
    tmpvar_38.x = texelsWeightsA_16.y;
    tmpvar_38.yz = texelsWeightsB_17.xz;
    highp vec3 tmpvar_39;
    tmpvar_39.x = texelsWeightsA_24.y;
    tmpvar_39.yz = texelsWeightsB_25.xz;
    fetchesOffsetsU_11 = (((tmpvar_38 / tmpvar_34) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_10 = (((tmpvar_39 / tmpvar_37) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_40;
    tmpvar_40 = (tmpvar_14 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_11.x;
    tmpvar_41.y = fetchesOffsetsV_10.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_40 + tmpvar_41);
    tmpvar_42.z = shadowCoord_8.z;
    mediump float tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_12 = ((tmpvar_34.x * tmpvar_37.x) * tmpvar_43);
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_11.y;
    tmpvar_44.y = fetchesOffsetsV_10.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_40 + tmpvar_44);
    tmpvar_45.z = shadowCoord_8.z;
    mediump float tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_12 = (shadow_12 + ((tmpvar_34.y * tmpvar_37.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_11.z;
    tmpvar_47.y = fetchesOffsetsV_10.x;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_40 + tmpvar_47);
    tmpvar_48.z = shadowCoord_8.z;
    mediump float tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_12 = (shadow_12 + ((tmpvar_34.z * tmpvar_37.x) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_11.x;
    tmpvar_50.y = fetchesOffsetsV_10.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_40 + tmpvar_50);
    tmpvar_51.z = shadowCoord_8.z;
    mediump float tmpvar_52;
    tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_12 = (shadow_12 + ((tmpvar_34.x * tmpvar_37.y) * tmpvar_52));
    highp vec2 tmpvar_53;
    tmpvar_53.x = fetchesOffsetsU_11.y;
    tmpvar_53.y = fetchesOffsetsV_10.y;
    highp vec3 tmpvar_54;
    tmpvar_54.xy = (tmpvar_40 + tmpvar_53);
    tmpvar_54.z = shadowCoord_8.z;
    mediump float tmpvar_55;
    tmpvar_55 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_54);
    shadow_12 = (shadow_12 + ((tmpvar_34.y * tmpvar_37.y) * tmpvar_55));
    highp vec2 tmpvar_56;
    tmpvar_56.x = fetchesOffsetsU_11.z;
    tmpvar_56.y = fetchesOffsetsV_10.y;
    highp vec3 tmpvar_57;
    tmpvar_57.xy = (tmpvar_40 + tmpvar_56);
    tmpvar_57.z = shadowCoord_8.z;
    mediump float tmpvar_58;
    tmpvar_58 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_57);
    shadow_12 = (shadow_12 + ((tmpvar_34.z * tmpvar_37.y) * tmpvar_58));
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_11.x;
    tmpvar_59.y = fetchesOffsetsV_10.z;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_40 + tmpvar_59);
    tmpvar_60.z = shadowCoord_8.z;
    mediump float tmpvar_61;
    tmpvar_61 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_12 = (shadow_12 + ((tmpvar_34.x * tmpvar_37.z) * tmpvar_61));
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_11.y;
    tmpvar_62.y = fetchesOffsetsV_10.z;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_40 + tmpvar_62);
    tmpvar_63.z = shadowCoord_8.z;
    mediump float tmpvar_64;
    tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_12 = (shadow_12 + ((tmpvar_34.y * tmpvar_37.z) * tmpvar_64));
    highp vec2 tmpvar_65;
    tmpvar_65.x = fetchesOffsetsU_11.z;
    tmpvar_65.y = fetchesOffsetsV_10.z;
    highp vec3 tmpvar_66;
    tmpvar_66.xy = (tmpvar_40 + tmpvar_65);
    tmpvar_66.z = shadowCoord_8.z;
    mediump float tmpvar_67;
    tmpvar_67 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_66);
    shadow_12 = (shadow_12 + ((tmpvar_34.z * tmpvar_37.z) * tmpvar_67));
    tmpvar_9 = mix (1.0, shadow_12, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_68;
  tmpvar_68.x = xlv_TEXCOORD1.w;
  tmpvar_68.y = xlv_TEXCOORD2.w;
  tmpvar_68.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_69;
  tmpvar_69 = normalize((CAMERA_WORLDPOSITION - tmpvar_68));
  lowp vec3 tmpvar_70;
  tmpvar_70 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_7 = tmpvar_70;
  highp vec3 tmpvar_71;
  tmpvar_71 = ((mainNormal_7 * 2.0) - 1.0);
  highp vec3 tmpvar_72;
  tmpvar_72 = normalize(((
    (tmpvar_71.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_71.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_71.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_73;
  tmpvar_73 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_74;
  tmpvar_74 = max (dot (tmpvar_72, tmpvar_69), 0.0);
  highp float tmpvar_75;
  tmpvar_75 = max (dot (tmpvar_72, normalize(
    (tmpvar_69 + tmpvar_73)
  )), 0.0);
  lowp vec3 tmpvar_76;
  tmpvar_76 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_6 = tmpvar_76;
  mainColor_6 = (mainColor_6 * mainColor_6);
  lowp vec3 tmpvar_77;
  tmpvar_77 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_5 = tmpvar_77;
  highp float tmpvar_78;
  tmpvar_78 = (1.0 - specular_5.x);
  highp vec2 tmpvar_79;
  tmpvar_79.x = ((dot (tmpvar_72, tmpvar_73) * 0.5) + 0.5);
  tmpvar_79.y = specular_5.y;
  lowp vec3 tmpvar_80;
  tmpvar_80 = texture (BRDFTex, tmpvar_79).xyz;
  brdfColor_4 = tmpvar_80;
  highp vec3 I_81;
  I_81 = -(tmpvar_69);
  reflectDir_3.xyz = (I_81 - (2.0 * (
    dot (tmpvar_72, I_81)
   * tmpvar_72)));
  reflectDir_3.w = (tmpvar_78 * 4.0);
  lowp vec4 tmpvar_82;
  tmpvar_82 = textureLod (skybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_83;
  tmpvar_83 = tmpvar_82;
  iblColor_2.w = tmpvar_83.w;
  iblColor_2.xyz = ((tmpvar_83.xyz * tmpvar_83.w) * 4.0);
  highp float tmpvar_84;
  tmpvar_84 = max ((tmpvar_78 * tmpvar_78), 0.1);
  highp float tmpvar_85;
  tmpvar_85 = (tmpvar_84 * tmpvar_84);
  highp float tmpvar_86;
  tmpvar_86 = (((
    (tmpvar_75 * tmpvar_85)
   - tmpvar_75) * tmpvar_75) + 1.0);
  d_1 = ((0.3183099 * tmpvar_85) / ((tmpvar_86 * tmpvar_86) + 1e-7));
  highp float tmpvar_87;
  tmpvar_87 = min (d_1, 100.0);
  d_1 = tmpvar_87;
  highp vec4 tmpvar_88;
  tmpvar_88.w = 1.0;
  tmpvar_88.xyz = (((
    (((tmpvar_87 * mix (Fresnel, 1.0, 
      (1.0 - tmpvar_74)
    )) * LIGHT_COLOR) + (((iblColor_2.xyz * 0.5) * (
      ((min ((Fresnel * 2.0), 1.0) - Fresnel) * pow ((1.0 - tmpvar_74), 4.0))
     + Fresnel)) * AMBIENT_COLOR))
   * SpecularColor.xyz) + (
    (((mix (ShadowColor.xyz, brdfColor_4, vec3(tmpvar_9)) * LIGHT_COLOR) * mainColor_6) + (AMBIENT_COLOR * mainColor_6))
   * 
    mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, tmpvar_74, (1.0 - specular_5.z))))
  )) + (RimColor * pow (
    (1.0 - max (0.0, dot (tmpvar_69, tmpvar_72)))
  , 
    (1.0/(RimPower))
  )).xyz);
  _glesFragData[0] = tmpvar_88;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BRDFTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "skybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadowColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RimColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RimPower",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform sampler2D BRDFTex;
uniform lowp samplerCube skybox;
uniform highp vec4 ShadeColor;
uniform highp vec4 ShadowColor;
uniform highp vec4 SpecularColor;
uniform highp vec4 RimColor;
uniform highp float RimPower;
uniform highp float Fresnel;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 brdfColor_4;
  highp vec3 specular_5;
  highp vec3 mainColor_6;
  highp vec3 mainNormal_7;
  highp vec4 shadowCoord_8;
  shadowCoord_8 = xlv_TEXCOORD4;
  highp float tmpvar_9;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_9 = 1.0;
  } else {
    shadowCoord_8.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_10;
    highp vec4 fetchesOffsetsU_11;
    highp float shadow_12;
    highp vec2 tmpvar_13;
    tmpvar_13 = (shadowCoord_8.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_14;
    tmpvar_14 = floor((tmpvar_13 + 0.5));
    highp vec2 tmpvar_15;
    tmpvar_15 = (tmpvar_13 - tmpvar_14);
    highp vec4 texelsWeightsA_16;
    highp vec4 texelsWeightsB_17;
    highp vec4 computedArea_18;
    highp vec4 computedAreaUncut_19;
    highp float tmpvar_20;
    tmpvar_20 = (((tmpvar_15.x + 0.5) * (tmpvar_15.x + 0.5)) * 0.5);
    highp float tmpvar_21;
    tmpvar_21 = (tmpvar_20 - tmpvar_15.x);
    computedArea_18.x = tmpvar_21;
    computedAreaUncut_19.x = tmpvar_21;
    computedArea_18.w = tmpvar_20;
    computedAreaUncut_19.w = tmpvar_20;
    computedAreaUncut_19.y = ((1.5 - tmpvar_15.x) - 0.5);
    highp float tmpvar_22;
    tmpvar_22 = min (tmpvar_15.x, 0.0);
    computedArea_18.y = (computedAreaUncut_19.y - (tmpvar_22 * tmpvar_22));
    computedAreaUncut_19.z = ((1.5 + tmpvar_15.x) - 0.5);
    highp float tmpvar_23;
    tmpvar_23 = max (tmpvar_15.x, 0.0);
    computedArea_18.z = (computedAreaUncut_19.z - (tmpvar_23 * tmpvar_23));
    texelsWeightsA_16.x = (0.081632 * tmpvar_21);
    texelsWeightsA_16.y = (0.081632 * computedAreaUncut_19.y);
    texelsWeightsA_16.z = (0.081632 * (computedAreaUncut_19.y + 1.0));
    texelsWeightsA_16.w = (0.081632 * (computedArea_18.y + 2.0));
    texelsWeightsB_17.x = (0.081632 * (computedArea_18.z + 2.0));
    texelsWeightsB_17.y = (0.081632 * (computedAreaUncut_19.z + 1.0));
    texelsWeightsB_17.z = (0.081632 * computedAreaUncut_19.z);
    texelsWeightsB_17.w = (0.081632 * tmpvar_20);
    highp vec4 texelsWeightsA_24;
    highp vec4 texelsWeightsB_25;
    highp vec4 computedArea_26;
    highp vec4 computedAreaUncut_27;
    highp float tmpvar_28;
    tmpvar_28 = (((tmpvar_15.y + 0.5) * (tmpvar_15.y + 0.5)) * 0.5);
    highp float tmpvar_29;
    tmpvar_29 = (tmpvar_28 - tmpvar_15.y);
    computedArea_26.x = tmpvar_29;
    computedAreaUncut_27.x = tmpvar_29;
    computedArea_26.w = tmpvar_28;
    computedAreaUncut_27.w = tmpvar_28;
    computedAreaUncut_27.y = ((1.5 - tmpvar_15.y) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = min (tmpvar_15.y, 0.0);
    computedArea_26.y = (computedAreaUncut_27.y - (tmpvar_30 * tmpvar_30));
    computedAreaUncut_27.z = ((1.5 + tmpvar_15.y) - 0.5);
    highp float tmpvar_31;
    tmpvar_31 = max (tmpvar_15.y, 0.0);
    computedArea_26.z = (computedAreaUncut_27.z - (tmpvar_31 * tmpvar_31));
    texelsWeightsA_24.x = (0.081632 * tmpvar_29);
    texelsWeightsA_24.y = (0.081632 * computedAreaUncut_27.y);
    texelsWeightsA_24.z = (0.081632 * (computedAreaUncut_27.y + 1.0));
    texelsWeightsA_24.w = (0.081632 * (computedArea_26.y + 2.0));
    texelsWeightsB_25.x = (0.081632 * (computedArea_26.z + 2.0));
    texelsWeightsB_25.y = (0.081632 * (computedAreaUncut_27.z + 1.0));
    texelsWeightsB_25.z = (0.081632 * computedAreaUncut_27.z);
    texelsWeightsB_25.w = (0.081632 * tmpvar_28);
    highp vec4 tmpvar_32;
    tmpvar_32.xy = texelsWeightsA_16.xz;
    tmpvar_32.zw = texelsWeightsB_17.xz;
    highp vec4 tmpvar_33;
    tmpvar_33.xy = texelsWeightsA_16.yw;
    tmpvar_33.zw = texelsWeightsB_17.yw;
    highp vec4 tmpvar_34;
    tmpvar_34 = (tmpvar_32 + tmpvar_33);
    highp vec4 tmpvar_35;
    tmpvar_35.xy = texelsWeightsA_24.xz;
    tmpvar_35.zw = texelsWeightsB_25.xz;
    highp vec4 tmpvar_36;
    tmpvar_36.xy = texelsWeightsA_24.yw;
    tmpvar_36.zw = texelsWeightsB_25.yw;
    highp vec4 tmpvar_37;
    tmpvar_37 = (tmpvar_35 + tmpvar_36);
    highp vec4 tmpvar_38;
    tmpvar_38.xy = texelsWeightsA_16.yw;
    tmpvar_38.zw = texelsWeightsB_17.yw;
    highp vec4 tmpvar_39;
    tmpvar_39.xy = texelsWeightsA_24.yw;
    tmpvar_39.zw = texelsWeightsB_25.yw;
    fetchesOffsetsU_11 = (((tmpvar_38 / tmpvar_34) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_10 = (((tmpvar_39 / tmpvar_37) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_40;
    tmpvar_40 = (tmpvar_14 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_11.x;
    tmpvar_41.y = fetchesOffsetsV_10.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_40 + tmpvar_41);
    tmpvar_42.z = shadowCoord_8.z;
    mediump float tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_12 = ((tmpvar_34.x * tmpvar_37.x) * tmpvar_43);
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_11.y;
    tmpvar_44.y = fetchesOffsetsV_10.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_40 + tmpvar_44);
    tmpvar_45.z = shadowCoord_8.z;
    mediump float tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_12 = (shadow_12 + ((tmpvar_34.y * tmpvar_37.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_11.z;
    tmpvar_47.y = fetchesOffsetsV_10.x;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_40 + tmpvar_47);
    tmpvar_48.z = shadowCoord_8.z;
    mediump float tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_12 = (shadow_12 + ((tmpvar_34.z * tmpvar_37.x) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_11.w;
    tmpvar_50.y = fetchesOffsetsV_10.x;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_40 + tmpvar_50);
    tmpvar_51.z = shadowCoord_8.z;
    mediump float tmpvar_52;
    tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_12 = (shadow_12 + ((tmpvar_34.w * tmpvar_37.x) * tmpvar_52));
    highp vec2 tmpvar_53;
    tmpvar_53.x = fetchesOffsetsU_11.x;
    tmpvar_53.y = fetchesOffsetsV_10.y;
    highp vec3 tmpvar_54;
    tmpvar_54.xy = (tmpvar_40 + tmpvar_53);
    tmpvar_54.z = shadowCoord_8.z;
    mediump float tmpvar_55;
    tmpvar_55 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_54);
    shadow_12 = (shadow_12 + ((tmpvar_34.x * tmpvar_37.y) * tmpvar_55));
    highp vec2 tmpvar_56;
    tmpvar_56.x = fetchesOffsetsU_11.y;
    tmpvar_56.y = fetchesOffsetsV_10.y;
    highp vec3 tmpvar_57;
    tmpvar_57.xy = (tmpvar_40 + tmpvar_56);
    tmpvar_57.z = shadowCoord_8.z;
    mediump float tmpvar_58;
    tmpvar_58 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_57);
    shadow_12 = (shadow_12 + ((tmpvar_34.y * tmpvar_37.y) * tmpvar_58));
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_11.z;
    tmpvar_59.y = fetchesOffsetsV_10.y;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_40 + tmpvar_59);
    tmpvar_60.z = shadowCoord_8.z;
    mediump float tmpvar_61;
    tmpvar_61 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_12 = (shadow_12 + ((tmpvar_34.z * tmpvar_37.y) * tmpvar_61));
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_11.w;
    tmpvar_62.y = fetchesOffsetsV_10.y;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_40 + tmpvar_62);
    tmpvar_63.z = shadowCoord_8.z;
    mediump float tmpvar_64;
    tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_12 = (shadow_12 + ((tmpvar_34.w * tmpvar_37.y) * tmpvar_64));
    highp vec2 tmpvar_65;
    tmpvar_65.x = fetchesOffsetsU_11.x;
    tmpvar_65.y = fetchesOffsetsV_10.z;
    highp vec3 tmpvar_66;
    tmpvar_66.xy = (tmpvar_40 + tmpvar_65);
    tmpvar_66.z = shadowCoord_8.z;
    mediump float tmpvar_67;
    tmpvar_67 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_66);
    shadow_12 = (shadow_12 + ((tmpvar_34.x * tmpvar_37.z) * tmpvar_67));
    highp vec2 tmpvar_68;
    tmpvar_68.x = fetchesOffsetsU_11.y;
    tmpvar_68.y = fetchesOffsetsV_10.z;
    highp vec3 tmpvar_69;
    tmpvar_69.xy = (tmpvar_40 + tmpvar_68);
    tmpvar_69.z = shadowCoord_8.z;
    mediump float tmpvar_70;
    tmpvar_70 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_69);
    shadow_12 = (shadow_12 + ((tmpvar_34.y * tmpvar_37.z) * tmpvar_70));
    highp vec2 tmpvar_71;
    tmpvar_71.x = fetchesOffsetsU_11.z;
    tmpvar_71.y = fetchesOffsetsV_10.z;
    highp vec3 tmpvar_72;
    tmpvar_72.xy = (tmpvar_40 + tmpvar_71);
    tmpvar_72.z = shadowCoord_8.z;
    mediump float tmpvar_73;
    tmpvar_73 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_72);
    shadow_12 = (shadow_12 + ((tmpvar_34.z * tmpvar_37.z) * tmpvar_73));
    highp vec2 tmpvar_74;
    tmpvar_74.x = fetchesOffsetsU_11.w;
    tmpvar_74.y = fetchesOffsetsV_10.z;
    highp vec3 tmpvar_75;
    tmpvar_75.xy = (tmpvar_40 + tmpvar_74);
    tmpvar_75.z = shadowCoord_8.z;
    mediump float tmpvar_76;
    tmpvar_76 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_75);
    shadow_12 = (shadow_12 + ((tmpvar_34.w * tmpvar_37.z) * tmpvar_76));
    highp vec2 tmpvar_77;
    tmpvar_77.x = fetchesOffsetsU_11.x;
    tmpvar_77.y = fetchesOffsetsV_10.w;
    highp vec3 tmpvar_78;
    tmpvar_78.xy = (tmpvar_40 + tmpvar_77);
    tmpvar_78.z = shadowCoord_8.z;
    mediump float tmpvar_79;
    tmpvar_79 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_78);
    shadow_12 = (shadow_12 + ((tmpvar_34.x * tmpvar_37.w) * tmpvar_79));
    highp vec2 tmpvar_80;
    tmpvar_80.x = fetchesOffsetsU_11.y;
    tmpvar_80.y = fetchesOffsetsV_10.w;
    highp vec3 tmpvar_81;
    tmpvar_81.xy = (tmpvar_40 + tmpvar_80);
    tmpvar_81.z = shadowCoord_8.z;
    mediump float tmpvar_82;
    tmpvar_82 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_81);
    shadow_12 = (shadow_12 + ((tmpvar_34.y * tmpvar_37.w) * tmpvar_82));
    highp vec2 tmpvar_83;
    tmpvar_83.x = fetchesOffsetsU_11.z;
    tmpvar_83.y = fetchesOffsetsV_10.w;
    highp vec3 tmpvar_84;
    tmpvar_84.xy = (tmpvar_40 + tmpvar_83);
    tmpvar_84.z = shadowCoord_8.z;
    mediump float tmpvar_85;
    tmpvar_85 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_84);
    shadow_12 = (shadow_12 + ((tmpvar_34.z * tmpvar_37.w) * tmpvar_85));
    highp vec2 tmpvar_86;
    tmpvar_86.x = fetchesOffsetsU_11.w;
    tmpvar_86.y = fetchesOffsetsV_10.w;
    highp vec3 tmpvar_87;
    tmpvar_87.xy = (tmpvar_40 + tmpvar_86);
    tmpvar_87.z = shadowCoord_8.z;
    mediump float tmpvar_88;
    tmpvar_88 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_87);
    shadow_12 = (shadow_12 + ((tmpvar_34.w * tmpvar_37.w) * tmpvar_88));
    tmpvar_9 = mix (1.0, shadow_12, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_89;
  tmpvar_89.x = xlv_TEXCOORD1.w;
  tmpvar_89.y = xlv_TEXCOORD2.w;
  tmpvar_89.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_90;
  tmpvar_90 = normalize((CAMERA_WORLDPOSITION - tmpvar_89));
  lowp vec3 tmpvar_91;
  tmpvar_91 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_7 = tmpvar_91;
  highp vec3 tmpvar_92;
  tmpvar_92 = ((mainNormal_7 * 2.0) - 1.0);
  highp vec3 tmpvar_93;
  tmpvar_93 = normalize(((
    (tmpvar_92.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_92.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_92.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_94;
  tmpvar_94 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_95;
  tmpvar_95 = max (dot (tmpvar_93, tmpvar_90), 0.0);
  highp float tmpvar_96;
  tmpvar_96 = max (dot (tmpvar_93, normalize(
    (tmpvar_90 + tmpvar_94)
  )), 0.0);
  lowp vec3 tmpvar_97;
  tmpvar_97 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_6 = tmpvar_97;
  mainColor_6 = (mainColor_6 * mainColor_6);
  lowp vec3 tmpvar_98;
  tmpvar_98 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_5 = tmpvar_98;
  highp float tmpvar_99;
  tmpvar_99 = (1.0 - specular_5.x);
  highp vec2 tmpvar_100;
  tmpvar_100.x = ((dot (tmpvar_93, tmpvar_94) * 0.5) + 0.5);
  tmpvar_100.y = specular_5.y;
  lowp vec3 tmpvar_101;
  tmpvar_101 = texture (BRDFTex, tmpvar_100).xyz;
  brdfColor_4 = tmpvar_101;
  highp vec3 I_102;
  I_102 = -(tmpvar_90);
  reflectDir_3.xyz = (I_102 - (2.0 * (
    dot (tmpvar_93, I_102)
   * tmpvar_93)));
  reflectDir_3.w = (tmpvar_99 * 4.0);
  lowp vec4 tmpvar_103;
  tmpvar_103 = textureLod (skybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_104;
  tmpvar_104 = tmpvar_103;
  iblColor_2.w = tmpvar_104.w;
  iblColor_2.xyz = ((tmpvar_104.xyz * tmpvar_104.w) * 4.0);
  highp float tmpvar_105;
  tmpvar_105 = max ((tmpvar_99 * tmpvar_99), 0.1);
  highp float tmpvar_106;
  tmpvar_106 = (tmpvar_105 * tmpvar_105);
  highp float tmpvar_107;
  tmpvar_107 = (((
    (tmpvar_96 * tmpvar_106)
   - tmpvar_96) * tmpvar_96) + 1.0);
  d_1 = ((0.3183099 * tmpvar_106) / ((tmpvar_107 * tmpvar_107) + 1e-7));
  highp float tmpvar_108;
  tmpvar_108 = min (d_1, 100.0);
  d_1 = tmpvar_108;
  highp vec4 tmpvar_109;
  tmpvar_109.w = 1.0;
  tmpvar_109.xyz = (((
    (((tmpvar_108 * mix (Fresnel, 1.0, 
      (1.0 - tmpvar_95)
    )) * LIGHT_COLOR) + (((iblColor_2.xyz * 0.5) * (
      ((min ((Fresnel * 2.0), 1.0) - Fresnel) * pow ((1.0 - tmpvar_95), 4.0))
     + Fresnel)) * AMBIENT_COLOR))
   * SpecularColor.xyz) + (
    (((mix (ShadowColor.xyz, brdfColor_4, vec3(tmpvar_9)) * LIGHT_COLOR) * mainColor_6) + (AMBIENT_COLOR * mainColor_6))
   * 
    mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, tmpvar_95, (1.0 - specular_5.z))))
  )) + (RimColor * pow (
    (1.0 - max (0.0, dot (tmpvar_90, tmpvar_93)))
  , 
    (1.0/(RimPower))
  )).xyz);
  _glesFragData[0] = tmpvar_109;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BRDFTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "skybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadowColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RimColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RimPower",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform sampler2D BRDFTex;
uniform lowp samplerCube skybox;
uniform highp vec4 ShadeColor;
uniform highp vec4 ShadowColor;
uniform highp vec4 SpecularColor;
uniform highp vec4 RimColor;
uniform highp float RimPower;
uniform highp float Fresnel;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 brdfColor_4;
  highp vec3 specular_5;
  highp vec3 mainColor_6;
  highp vec3 mainNormal_7;
  highp vec4 shadowCoord_8;
  shadowCoord_8 = xlv_TEXCOORD4;
  highp float tmpvar_9;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_9 = 1.0;
  } else {
    highp vec2 tmpvar_10;
    tmpvar_10.x = LIGHT_PARAM.z;
    tmpvar_10.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_11;
    tmpvar_11.xy = tmpvar_10;
    highp float tmpvar_12;
    tmpvar_12 = (1.0/(LIGHT_PARAM.z));
    tmpvar_11.z = tmpvar_12;
    tmpvar_11.w = tmpvar_12;
    shadowCoord_8.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_13;
    highp vec2 tmpvar_14;
    tmpvar_14 = tmpvar_11.xy;
    shadow_13 = 0.0;
    highp vec3 tmpvar_15;
    tmpvar_15.xy = (shadowCoord_8.xy - LIGHT_PARAM.zz);
    tmpvar_15.z = shadowCoord_8.z;
    highp vec4 tmpvar_16;
    tmpvar_16 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_15.xy);
    highp float tmpvar_17;
    if ((tmpvar_16.x < xlv_TEXCOORD4.z)) {
      tmpvar_17 = 0.0;
    } else {
      tmpvar_17 = 1.0;
    };
    shadow_13 = tmpvar_17;
    highp vec2 tmpvar_18;
    tmpvar_18.x = 0.0;
    tmpvar_18.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_19;
    tmpvar_19.xy = (shadowCoord_8.xy + tmpvar_18);
    tmpvar_19.z = shadowCoord_8.z;
    highp vec4 tmpvar_20;
    tmpvar_20 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_19.xy);
    highp float tmpvar_21;
    if ((tmpvar_20.x < xlv_TEXCOORD4.z)) {
      tmpvar_21 = 0.0;
    } else {
      tmpvar_21 = 1.0;
    };
    shadow_13 = (tmpvar_17 + tmpvar_21);
    highp vec2 tmpvar_22;
    tmpvar_22.x = tmpvar_14.x;
    tmpvar_22.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_23;
    tmpvar_23.xy = (shadowCoord_8.xy + tmpvar_22);
    tmpvar_23.z = shadowCoord_8.z;
    highp vec4 tmpvar_24;
    tmpvar_24 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_23.xy);
    highp float tmpvar_25;
    if ((tmpvar_24.x < xlv_TEXCOORD4.z)) {
      tmpvar_25 = 0.0;
    } else {
      tmpvar_25 = 1.0;
    };
    shadow_13 = (shadow_13 + tmpvar_25);
    highp vec2 tmpvar_26;
    tmpvar_26.y = 0.0;
    tmpvar_26.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_27;
    tmpvar_27.xy = (shadowCoord_8.xy + tmpvar_26);
    tmpvar_27.z = shadowCoord_8.z;
    highp vec4 tmpvar_28;
    tmpvar_28 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_27.xy);
    highp float tmpvar_29;
    if ((tmpvar_28.x < xlv_TEXCOORD4.z)) {
      tmpvar_29 = 0.0;
    } else {
      tmpvar_29 = 1.0;
    };
    shadow_13 = (shadow_13 + tmpvar_29);
    highp vec4 tmpvar_30;
    tmpvar_30 = texture (TEXTURE_SHADOW_DEPTH, shadowCoord_8.xy);
    highp float tmpvar_31;
    if ((tmpvar_30.x < xlv_TEXCOORD4.z)) {
      tmpvar_31 = 0.0;
    } else {
      tmpvar_31 = 1.0;
    };
    shadow_13 = (shadow_13 + tmpvar_31);
    highp vec2 tmpvar_32;
    tmpvar_32.y = 0.0;
    tmpvar_32.x = tmpvar_14.x;
    highp vec3 tmpvar_33;
    tmpvar_33.xy = (shadowCoord_8.xy + tmpvar_32);
    tmpvar_33.z = shadowCoord_8.z;
    highp vec4 tmpvar_34;
    tmpvar_34 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_33.xy);
    highp float tmpvar_35;
    if ((tmpvar_34.x < xlv_TEXCOORD4.z)) {
      tmpvar_35 = 0.0;
    } else {
      tmpvar_35 = 1.0;
    };
    shadow_13 = (shadow_13 + tmpvar_35);
    highp vec2 tmpvar_36;
    tmpvar_36.x = -(LIGHT_PARAM.z);
    tmpvar_36.y = tmpvar_14.y;
    highp vec3 tmpvar_37;
    tmpvar_37.xy = (shadowCoord_8.xy + tmpvar_36);
    tmpvar_37.z = shadowCoord_8.z;
    highp vec4 tmpvar_38;
    tmpvar_38 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_37.xy);
    highp float tmpvar_39;
    if ((tmpvar_38.x < xlv_TEXCOORD4.z)) {
      tmpvar_39 = 0.0;
    } else {
      tmpvar_39 = 1.0;
    };
    shadow_13 = (shadow_13 + tmpvar_39);
    highp vec2 tmpvar_40;
    tmpvar_40.x = 0.0;
    tmpvar_40.y = tmpvar_14.y;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (shadowCoord_8.xy + tmpvar_40);
    tmpvar_41.z = shadowCoord_8.z;
    highp vec4 tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41.xy);
    highp float tmpvar_43;
    if ((tmpvar_42.x < xlv_TEXCOORD4.z)) {
      tmpvar_43 = 0.0;
    } else {
      tmpvar_43 = 1.0;
    };
    shadow_13 = (shadow_13 + tmpvar_43);
    highp vec3 tmpvar_44;
    tmpvar_44.xy = (shadowCoord_8.xy + LIGHT_PARAM.zz);
    tmpvar_44.z = shadowCoord_8.z;
    highp vec4 tmpvar_45;
    tmpvar_45 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_44.xy);
    highp float tmpvar_46;
    if ((tmpvar_45.x < xlv_TEXCOORD4.z)) {
      tmpvar_46 = 0.0;
    } else {
      tmpvar_46 = 1.0;
    };
    shadow_13 = (shadow_13 + tmpvar_46);
    shadow_13 = (shadow_13 / 9.0);
    tmpvar_9 = mix (1.0, shadow_13, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_47;
  tmpvar_47.x = xlv_TEXCOORD1.w;
  tmpvar_47.y = xlv_TEXCOORD2.w;
  tmpvar_47.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_48;
  tmpvar_48 = normalize((CAMERA_WORLDPOSITION - tmpvar_47));
  lowp vec3 tmpvar_49;
  tmpvar_49 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_7 = tmpvar_49;
  highp vec3 tmpvar_50;
  tmpvar_50 = ((mainNormal_7 * 2.0) - 1.0);
  highp vec3 tmpvar_51;
  tmpvar_51 = normalize(((
    (tmpvar_50.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_50.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_50.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_52;
  tmpvar_52 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_53;
  tmpvar_53 = max (dot (tmpvar_51, tmpvar_48), 0.0);
  highp float tmpvar_54;
  tmpvar_54 = max (dot (tmpvar_51, normalize(
    (tmpvar_48 + tmpvar_52)
  )), 0.0);
  lowp vec3 tmpvar_55;
  tmpvar_55 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_6 = tmpvar_55;
  mainColor_6 = (mainColor_6 * mainColor_6);
  lowp vec3 tmpvar_56;
  tmpvar_56 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_5 = tmpvar_56;
  highp float tmpvar_57;
  tmpvar_57 = (1.0 - specular_5.x);
  highp vec2 tmpvar_58;
  tmpvar_58.x = ((dot (tmpvar_51, tmpvar_52) * 0.5) + 0.5);
  tmpvar_58.y = specular_5.y;
  lowp vec3 tmpvar_59;
  tmpvar_59 = texture (BRDFTex, tmpvar_58).xyz;
  brdfColor_4 = tmpvar_59;
  highp vec3 I_60;
  I_60 = -(tmpvar_48);
  reflectDir_3.xyz = (I_60 - (2.0 * (
    dot (tmpvar_51, I_60)
   * tmpvar_51)));
  reflectDir_3.w = (tmpvar_57 * 4.0);
  lowp vec4 tmpvar_61;
  tmpvar_61 = textureLod (skybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_62;
  tmpvar_62 = tmpvar_61;
  iblColor_2.w = tmpvar_62.w;
  iblColor_2.xyz = ((tmpvar_62.xyz * tmpvar_62.w) * 4.0);
  highp float tmpvar_63;
  tmpvar_63 = max ((tmpvar_57 * tmpvar_57), 0.1);
  highp float tmpvar_64;
  tmpvar_64 = (tmpvar_63 * tmpvar_63);
  highp float tmpvar_65;
  tmpvar_65 = (((
    (tmpvar_54 * tmpvar_64)
   - tmpvar_54) * tmpvar_54) + 1.0);
  d_1 = ((0.3183099 * tmpvar_64) / ((tmpvar_65 * tmpvar_65) + 1e-7));
  highp float tmpvar_66;
  tmpvar_66 = min (d_1, 100.0);
  d_1 = tmpvar_66;
  highp vec4 tmpvar_67;
  tmpvar_67.w = 1.0;
  tmpvar_67.xyz = (((
    (((tmpvar_66 * mix (Fresnel, 1.0, 
      (1.0 - tmpvar_53)
    )) * LIGHT_COLOR) + (((iblColor_2.xyz * 0.5) * (
      ((min ((Fresnel * 2.0), 1.0) - Fresnel) * pow ((1.0 - tmpvar_53), 4.0))
     + Fresnel)) * AMBIENT_COLOR))
   * SpecularColor.xyz) + (
    (((mix (ShadowColor.xyz, brdfColor_4, vec3(tmpvar_9)) * LIGHT_COLOR) * mainColor_6) + (AMBIENT_COLOR * mainColor_6))
   * 
    mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, tmpvar_53, (1.0 - specular_5.z))))
  )) + (RimColor * pow (
    (1.0 - max (0.0, dot (tmpvar_48, tmpvar_51)))
  , 
    (1.0/(RimPower))
  )).xyz);
  _glesFragData[0] = tmpvar_67;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BRDFTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "skybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RimColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RimPower",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_9[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_9[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform sampler2D BRDFTex;
uniform lowp samplerCube skybox;
uniform highp vec4 ShadeColor;
uniform highp vec4 SpecularColor;
uniform highp vec4 RimColor;
uniform highp float RimPower;
uniform highp float Fresnel;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 brdfColor_4;
  highp vec3 specular_5;
  highp vec3 mainColor_6;
  highp vec3 mainNormal_7;
  highp vec3 tmpvar_8;
  tmpvar_8.x = xlv_TEXCOORD1.w;
  tmpvar_8.y = xlv_TEXCOORD2.w;
  tmpvar_8.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize((CAMERA_WORLDPOSITION - tmpvar_8));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_7 = tmpvar_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = ((mainNormal_7 * 2.0) - 1.0);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((
    (tmpvar_11.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_11.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_11.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_13;
  tmpvar_13 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_14;
  tmpvar_14 = max (dot (tmpvar_12, tmpvar_9), 0.0);
  highp float tmpvar_15;
  tmpvar_15 = max (dot (tmpvar_12, normalize(
    (tmpvar_9 + tmpvar_13)
  )), 0.0);
  lowp vec3 tmpvar_16;
  tmpvar_16 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_6 = tmpvar_16;
  mainColor_6 = (mainColor_6 * mainColor_6);
  lowp vec3 tmpvar_17;
  tmpvar_17 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_5 = tmpvar_17;
  highp float tmpvar_18;
  tmpvar_18 = (1.0 - specular_5.x);
  highp vec2 tmpvar_19;
  tmpvar_19.x = ((dot (tmpvar_12, tmpvar_13) * 0.5) + 0.5);
  tmpvar_19.y = specular_5.y;
  lowp vec3 tmpvar_20;
  tmpvar_20 = texture (BRDFTex, tmpvar_19).xyz;
  brdfColor_4 = tmpvar_20;
  highp vec3 I_21;
  I_21 = -(tmpvar_9);
  reflectDir_3.xyz = (I_21 - (2.0 * (
    dot (tmpvar_12, I_21)
   * tmpvar_12)));
  reflectDir_3.w = (tmpvar_18 * 4.0);
  lowp vec4 tmpvar_22;
  tmpvar_22 = textureLod (skybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_23;
  tmpvar_23 = tmpvar_22;
  iblColor_2.w = tmpvar_23.w;
  iblColor_2.xyz = ((tmpvar_23.xyz * tmpvar_23.w) * 4.0);
  highp float tmpvar_24;
  tmpvar_24 = max ((tmpvar_18 * tmpvar_18), 0.1);
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_24 * tmpvar_24);
  highp float tmpvar_26;
  tmpvar_26 = (((
    (tmpvar_15 * tmpvar_25)
   - tmpvar_15) * tmpvar_15) + 1.0);
  d_1 = ((0.3183099 * tmpvar_25) / ((tmpvar_26 * tmpvar_26) + 1e-7));
  highp float tmpvar_27;
  tmpvar_27 = min (d_1, 100.0);
  d_1 = tmpvar_27;
  highp vec4 tmpvar_28;
  tmpvar_28.w = 1.0;
  tmpvar_28.xyz = (((
    (((tmpvar_27 * mix (Fresnel, 1.0, 
      (1.0 - tmpvar_14)
    )) * LIGHT_COLOR) + (((iblColor_2.xyz * 0.5) * (
      ((min ((Fresnel * 2.0), 1.0) - Fresnel) * pow ((1.0 - tmpvar_14), 4.0))
     + Fresnel)) * AMBIENT_COLOR))
   * SpecularColor.xyz) + (
    (((brdfColor_4 * LIGHT_COLOR) * mainColor_6) + (AMBIENT_COLOR * mainColor_6))
   * 
    mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, tmpvar_14, (1.0 - specular_5.z))))
  )) + (RimColor * pow (
    (1.0 - max (0.0, dot (tmpvar_9, tmpvar_12)))
  , 
    (1.0/(RimPower))
  )).xyz);
  _glesFragData[0] = tmpvar_28;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BRDFTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "skybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RimColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RimPower",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_9[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_9[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform sampler2D BRDFTex;
uniform lowp samplerCube skybox;
uniform highp vec4 ShadeColor;
uniform highp vec4 SpecularColor;
uniform highp vec4 RimColor;
uniform highp float RimPower;
uniform highp float Fresnel;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 brdfColor_4;
  highp vec3 specular_5;
  highp vec3 mainColor_6;
  highp vec3 mainNormal_7;
  highp vec3 tmpvar_8;
  tmpvar_8.x = xlv_TEXCOORD1.w;
  tmpvar_8.y = xlv_TEXCOORD2.w;
  tmpvar_8.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize((CAMERA_WORLDPOSITION - tmpvar_8));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_7 = tmpvar_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = ((mainNormal_7 * 2.0) - 1.0);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((
    (tmpvar_11.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_11.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_11.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_13;
  tmpvar_13 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_14;
  tmpvar_14 = max (dot (tmpvar_12, tmpvar_9), 0.0);
  highp float tmpvar_15;
  tmpvar_15 = max (dot (tmpvar_12, normalize(
    (tmpvar_9 + tmpvar_13)
  )), 0.0);
  lowp vec3 tmpvar_16;
  tmpvar_16 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_6 = tmpvar_16;
  mainColor_6 = (mainColor_6 * mainColor_6);
  lowp vec3 tmpvar_17;
  tmpvar_17 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_5 = tmpvar_17;
  highp float tmpvar_18;
  tmpvar_18 = (1.0 - specular_5.x);
  highp vec2 tmpvar_19;
  tmpvar_19.x = ((dot (tmpvar_12, tmpvar_13) * 0.5) + 0.5);
  tmpvar_19.y = specular_5.y;
  lowp vec3 tmpvar_20;
  tmpvar_20 = texture (BRDFTex, tmpvar_19).xyz;
  brdfColor_4 = tmpvar_20;
  highp vec3 I_21;
  I_21 = -(tmpvar_9);
  reflectDir_3.xyz = (I_21 - (2.0 * (
    dot (tmpvar_12, I_21)
   * tmpvar_12)));
  reflectDir_3.w = (tmpvar_18 * 4.0);
  lowp vec4 tmpvar_22;
  tmpvar_22 = textureLod (skybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_23;
  tmpvar_23 = tmpvar_22;
  iblColor_2.w = tmpvar_23.w;
  iblColor_2.xyz = ((tmpvar_23.xyz * tmpvar_23.w) * 4.0);
  highp float tmpvar_24;
  tmpvar_24 = max ((tmpvar_18 * tmpvar_18), 0.1);
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_24 * tmpvar_24);
  highp float tmpvar_26;
  tmpvar_26 = (((
    (tmpvar_15 * tmpvar_25)
   - tmpvar_15) * tmpvar_15) + 1.0);
  d_1 = ((0.3183099 * tmpvar_25) / ((tmpvar_26 * tmpvar_26) + 1e-7));
  highp float tmpvar_27;
  tmpvar_27 = min (d_1, 100.0);
  d_1 = tmpvar_27;
  highp vec4 tmpvar_28;
  tmpvar_28.w = 1.0;
  tmpvar_28.xyz = (((
    (((tmpvar_27 * mix (Fresnel, 1.0, 
      (1.0 - tmpvar_14)
    )) * LIGHT_COLOR) + (((iblColor_2.xyz * 0.5) * (
      ((min ((Fresnel * 2.0), 1.0) - Fresnel) * pow ((1.0 - tmpvar_14), 4.0))
     + Fresnel)) * AMBIENT_COLOR))
   * SpecularColor.xyz) + (
    (((brdfColor_4 * LIGHT_COLOR) * mainColor_6) + (AMBIENT_COLOR * mainColor_6))
   * 
    mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, tmpvar_14, (1.0 - specular_5.z))))
  )) + (RimColor * pow (
    (1.0 - max (0.0, dot (tmpvar_9, tmpvar_12)))
  , 
    (1.0/(RimPower))
  )).xyz);
  _glesFragData[0] = tmpvar_28;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BRDFTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "skybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadowColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RimColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RimPower",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform sampler2D BRDFTex;
uniform lowp samplerCube skybox;
uniform highp vec4 ShadeColor;
uniform highp vec4 ShadowColor;
uniform highp vec4 SpecularColor;
uniform highp vec4 RimColor;
uniform highp float RimPower;
uniform highp float Fresnel;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 brdfColor_4;
  highp vec3 specular_5;
  highp vec3 mainColor_6;
  highp vec3 mainNormal_7;
  highp vec4 shadowCoord_8;
  shadowCoord_8 = xlv_TEXCOORD4;
  highp float tmpvar_9;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_9 = 1.0;
  } else {
    shadowCoord_8.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_10;
    highp vec2 fetchesOffsetsU_11;
    highp float shadow_12;
    highp vec2 tmpvar_13;
    tmpvar_13 = (shadowCoord_8.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_14;
    tmpvar_14 = floor((tmpvar_13 + 0.5));
    highp vec2 tmpvar_15;
    tmpvar_15 = (tmpvar_13 - tmpvar_14);
    highp vec4 computedWeight_16;
    highp vec4 computedArea_17;
    highp vec4 computedAreaUncut_18;
    highp float tmpvar_19;
    tmpvar_19 = (((tmpvar_15.x + 0.5) * (tmpvar_15.x + 0.5)) * 0.5);
    highp float tmpvar_20;
    tmpvar_20 = (tmpvar_19 - tmpvar_15.x);
    computedArea_17.x = tmpvar_20;
    computedAreaUncut_18.x = tmpvar_20;
    computedArea_17.w = tmpvar_19;
    computedAreaUncut_18.w = tmpvar_19;
    computedAreaUncut_18.y = ((1.5 - tmpvar_15.x) - 0.5);
    highp float tmpvar_21;
    tmpvar_21 = min (tmpvar_15.x, 0.0);
    computedArea_17.y = (computedAreaUncut_18.y - (tmpvar_21 * tmpvar_21));
    computedAreaUncut_18.z = ((1.5 + tmpvar_15.x) - 0.5);
    highp float tmpvar_22;
    tmpvar_22 = max (tmpvar_15.x, 0.0);
    computedArea_17.z = (computedAreaUncut_18.z - (tmpvar_22 * tmpvar_22));
    computedWeight_16 = (computedArea_17 * 0.44444);
    highp vec4 computedWeight_23;
    highp vec4 computedArea_24;
    highp vec4 computedAreaUncut_25;
    highp float tmpvar_26;
    tmpvar_26 = (((tmpvar_15.y + 0.5) * (tmpvar_15.y + 0.5)) * 0.5);
    highp float tmpvar_27;
    tmpvar_27 = (tmpvar_26 - tmpvar_15.y);
    computedArea_24.x = tmpvar_27;
    computedAreaUncut_25.x = tmpvar_27;
    computedArea_24.w = tmpvar_26;
    computedAreaUncut_25.w = tmpvar_26;
    computedAreaUncut_25.y = ((1.5 - tmpvar_15.y) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = min (tmpvar_15.y, 0.0);
    computedArea_24.y = (computedAreaUncut_25.y - (tmpvar_28 * tmpvar_28));
    computedAreaUncut_25.z = ((1.5 + tmpvar_15.y) - 0.5);
    highp float tmpvar_29;
    tmpvar_29 = max (tmpvar_15.y, 0.0);
    computedArea_24.z = (computedAreaUncut_25.z - (tmpvar_29 * tmpvar_29));
    computedWeight_23 = (computedArea_24 * 0.44444);
    highp vec2 tmpvar_30;
    tmpvar_30 = (computedWeight_16.xz + computedWeight_16.yw);
    highp vec2 tmpvar_31;
    tmpvar_31 = (computedWeight_23.xz + computedWeight_23.yw);
    fetchesOffsetsU_11 = (((computedWeight_16.yw / tmpvar_30) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_10 = (((computedWeight_23.yw / tmpvar_31) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_32;
    tmpvar_32 = (tmpvar_14 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_33;
    tmpvar_33.x = fetchesOffsetsU_11.x;
    tmpvar_33.y = fetchesOffsetsV_10.x;
    highp vec3 tmpvar_34;
    tmpvar_34.xy = (tmpvar_32 + tmpvar_33);
    tmpvar_34.z = shadowCoord_8.z;
    mediump float tmpvar_35;
    tmpvar_35 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_34);
    shadow_12 = ((tmpvar_30.x * tmpvar_31.x) * tmpvar_35);
    highp vec2 tmpvar_36;
    tmpvar_36.x = fetchesOffsetsU_11.y;
    tmpvar_36.y = fetchesOffsetsV_10.x;
    highp vec3 tmpvar_37;
    tmpvar_37.xy = (tmpvar_32 + tmpvar_36);
    tmpvar_37.z = shadowCoord_8.z;
    mediump float tmpvar_38;
    tmpvar_38 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_37);
    shadow_12 = (shadow_12 + ((tmpvar_30.y * tmpvar_31.x) * tmpvar_38));
    highp vec2 tmpvar_39;
    tmpvar_39.x = fetchesOffsetsU_11.x;
    tmpvar_39.y = fetchesOffsetsV_10.y;
    highp vec3 tmpvar_40;
    tmpvar_40.xy = (tmpvar_32 + tmpvar_39);
    tmpvar_40.z = shadowCoord_8.z;
    mediump float tmpvar_41;
    tmpvar_41 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_40);
    shadow_12 = (shadow_12 + ((tmpvar_30.x * tmpvar_31.y) * tmpvar_41));
    highp vec2 tmpvar_42;
    tmpvar_42.x = fetchesOffsetsU_11.y;
    tmpvar_42.y = fetchesOffsetsV_10.y;
    highp vec3 tmpvar_43;
    tmpvar_43.xy = (tmpvar_32 + tmpvar_42);
    tmpvar_43.z = shadowCoord_8.z;
    mediump float tmpvar_44;
    tmpvar_44 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_43);
    shadow_12 = (shadow_12 + ((tmpvar_30.y * tmpvar_31.y) * tmpvar_44));
    tmpvar_9 = mix (1.0, shadow_12, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_45;
  tmpvar_45.x = xlv_TEXCOORD1.w;
  tmpvar_45.y = xlv_TEXCOORD2.w;
  tmpvar_45.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_46;
  tmpvar_46 = normalize((CAMERA_WORLDPOSITION - tmpvar_45));
  lowp vec3 tmpvar_47;
  tmpvar_47 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_7 = tmpvar_47;
  highp vec3 tmpvar_48;
  tmpvar_48 = ((mainNormal_7 * 2.0) - 1.0);
  highp vec3 tmpvar_49;
  tmpvar_49 = normalize(((
    (tmpvar_48.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_48.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_48.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_50;
  tmpvar_50 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_51;
  tmpvar_51 = max (dot (tmpvar_49, tmpvar_46), 0.0);
  highp float tmpvar_52;
  tmpvar_52 = max (dot (tmpvar_49, normalize(
    (tmpvar_46 + tmpvar_50)
  )), 0.0);
  lowp vec3 tmpvar_53;
  tmpvar_53 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_6 = tmpvar_53;
  mainColor_6 = (mainColor_6 * mainColor_6);
  lowp vec3 tmpvar_54;
  tmpvar_54 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_5 = tmpvar_54;
  highp float tmpvar_55;
  tmpvar_55 = (1.0 - specular_5.x);
  highp vec2 tmpvar_56;
  tmpvar_56.x = ((dot (tmpvar_49, tmpvar_50) * 0.5) + 0.5);
  tmpvar_56.y = specular_5.y;
  lowp vec3 tmpvar_57;
  tmpvar_57 = texture (BRDFTex, tmpvar_56).xyz;
  brdfColor_4 = tmpvar_57;
  highp vec3 I_58;
  I_58 = -(tmpvar_46);
  reflectDir_3.xyz = (I_58 - (2.0 * (
    dot (tmpvar_49, I_58)
   * tmpvar_49)));
  reflectDir_3.w = (tmpvar_55 * 4.0);
  lowp vec4 tmpvar_59;
  tmpvar_59 = textureLod (skybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_60;
  tmpvar_60 = tmpvar_59;
  iblColor_2.w = tmpvar_60.w;
  iblColor_2.xyz = ((tmpvar_60.xyz * tmpvar_60.w) * 4.0);
  highp float tmpvar_61;
  tmpvar_61 = max ((tmpvar_55 * tmpvar_55), 0.1);
  highp float tmpvar_62;
  tmpvar_62 = (tmpvar_61 * tmpvar_61);
  highp float tmpvar_63;
  tmpvar_63 = (((
    (tmpvar_52 * tmpvar_62)
   - tmpvar_52) * tmpvar_52) + 1.0);
  d_1 = ((0.3183099 * tmpvar_62) / ((tmpvar_63 * tmpvar_63) + 1e-7));
  highp float tmpvar_64;
  tmpvar_64 = min (d_1, 100.0);
  d_1 = tmpvar_64;
  highp vec4 tmpvar_65;
  tmpvar_65.w = 1.0;
  tmpvar_65.xyz = (((
    (((tmpvar_64 * mix (Fresnel, 1.0, 
      (1.0 - tmpvar_51)
    )) * LIGHT_COLOR) + (((iblColor_2.xyz * 0.5) * (
      ((min ((Fresnel * 2.0), 1.0) - Fresnel) * pow ((1.0 - tmpvar_51), 4.0))
     + Fresnel)) * AMBIENT_COLOR))
   * SpecularColor.xyz) + (
    (((mix (ShadowColor.xyz, brdfColor_4, vec3(tmpvar_9)) * LIGHT_COLOR) * mainColor_6) + (AMBIENT_COLOR * mainColor_6))
   * 
    mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, tmpvar_51, (1.0 - specular_5.z))))
  )) + (RimColor * pow (
    (1.0 - max (0.0, dot (tmpvar_46, tmpvar_49)))
  , 
    (1.0/(RimPower))
  )).xyz);
  _glesFragData[0] = tmpvar_65;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BRDFTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "skybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadowColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RimColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RimPower",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform sampler2D BRDFTex;
uniform lowp samplerCube skybox;
uniform highp vec4 ShadeColor;
uniform highp vec4 ShadowColor;
uniform highp vec4 SpecularColor;
uniform highp vec4 RimColor;
uniform highp float RimPower;
uniform highp float Fresnel;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 brdfColor_4;
  highp vec3 specular_5;
  highp vec3 mainColor_6;
  highp vec3 mainNormal_7;
  highp vec4 shadowCoord_8;
  shadowCoord_8 = xlv_TEXCOORD4;
  highp float tmpvar_9;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_9 = 1.0;
  } else {
    shadowCoord_8.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_10;
    highp vec3 fetchesOffsetsU_11;
    highp float shadow_12;
    highp vec2 tmpvar_13;
    tmpvar_13 = (shadowCoord_8.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_14;
    tmpvar_14 = floor((tmpvar_13 + 0.5));
    highp vec2 tmpvar_15;
    tmpvar_15 = (tmpvar_13 - tmpvar_14);
    highp vec3 texelsWeightsA_16;
    highp vec3 texelsWeightsB_17;
    highp vec4 computedArea_18;
    highp vec4 computedAreaUncut_19;
    highp float tmpvar_20;
    tmpvar_20 = (((tmpvar_15.x + 0.5) * (tmpvar_15.x + 0.5)) * 0.5);
    highp float tmpvar_21;
    tmpvar_21 = (tmpvar_20 - tmpvar_15.x);
    computedArea_18.x = tmpvar_21;
    computedAreaUncut_19.x = tmpvar_21;
    computedArea_18.w = tmpvar_20;
    computedAreaUncut_19.w = tmpvar_20;
    computedAreaUncut_19.y = ((1.5 - tmpvar_15.x) - 0.5);
    highp float tmpvar_22;
    tmpvar_22 = min (tmpvar_15.x, 0.0);
    computedArea_18.y = (computedAreaUncut_19.y - (tmpvar_22 * tmpvar_22));
    computedAreaUncut_19.z = ((1.5 + tmpvar_15.x) - 0.5);
    highp float tmpvar_23;
    tmpvar_23 = max (tmpvar_15.x, 0.0);
    computedArea_18.z = (computedAreaUncut_19.z - (tmpvar_23 * tmpvar_23));
    texelsWeightsA_16.x = (0.16 * tmpvar_21);
    texelsWeightsA_16.y = (0.16 * computedAreaUncut_19.y);
    texelsWeightsA_16.z = (0.16 * (computedArea_18.y + 1.0));
    texelsWeightsB_17.x = (0.16 * (computedArea_18.z + 1.0));
    texelsWeightsB_17.y = (0.16 * computedAreaUncut_19.z);
    texelsWeightsB_17.z = (0.16 * tmpvar_20);
    highp vec3 texelsWeightsA_24;
    highp vec3 texelsWeightsB_25;
    highp vec4 computedArea_26;
    highp vec4 computedAreaUncut_27;
    highp float tmpvar_28;
    tmpvar_28 = (((tmpvar_15.y + 0.5) * (tmpvar_15.y + 0.5)) * 0.5);
    highp float tmpvar_29;
    tmpvar_29 = (tmpvar_28 - tmpvar_15.y);
    computedArea_26.x = tmpvar_29;
    computedAreaUncut_27.x = tmpvar_29;
    computedArea_26.w = tmpvar_28;
    computedAreaUncut_27.w = tmpvar_28;
    computedAreaUncut_27.y = ((1.5 - tmpvar_15.y) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = min (tmpvar_15.y, 0.0);
    computedArea_26.y = (computedAreaUncut_27.y - (tmpvar_30 * tmpvar_30));
    computedAreaUncut_27.z = ((1.5 + tmpvar_15.y) - 0.5);
    highp float tmpvar_31;
    tmpvar_31 = max (tmpvar_15.y, 0.0);
    computedArea_26.z = (computedAreaUncut_27.z - (tmpvar_31 * tmpvar_31));
    texelsWeightsA_24.x = (0.16 * tmpvar_29);
    texelsWeightsA_24.y = (0.16 * computedAreaUncut_27.y);
    texelsWeightsA_24.z = (0.16 * (computedArea_26.y + 1.0));
    texelsWeightsB_25.x = (0.16 * (computedArea_26.z + 1.0));
    texelsWeightsB_25.y = (0.16 * computedAreaUncut_27.z);
    texelsWeightsB_25.z = (0.16 * tmpvar_28);
    highp vec3 tmpvar_32;
    tmpvar_32.xy = texelsWeightsA_16.xz;
    tmpvar_32.z = texelsWeightsB_17.y;
    highp vec3 tmpvar_33;
    tmpvar_33.x = texelsWeightsA_16.y;
    tmpvar_33.yz = texelsWeightsB_17.xz;
    highp vec3 tmpvar_34;
    tmpvar_34 = (tmpvar_32 + tmpvar_33);
    highp vec3 tmpvar_35;
    tmpvar_35.xy = texelsWeightsA_24.xz;
    tmpvar_35.z = texelsWeightsB_25.y;
    highp vec3 tmpvar_36;
    tmpvar_36.x = texelsWeightsA_24.y;
    tmpvar_36.yz = texelsWeightsB_25.xz;
    highp vec3 tmpvar_37;
    tmpvar_37 = (tmpvar_35 + tmpvar_36);
    highp vec3 tmpvar_38;
    tmpvar_38.x = texelsWeightsA_16.y;
    tmpvar_38.yz = texelsWeightsB_17.xz;
    highp vec3 tmpvar_39;
    tmpvar_39.x = texelsWeightsA_24.y;
    tmpvar_39.yz = texelsWeightsB_25.xz;
    fetchesOffsetsU_11 = (((tmpvar_38 / tmpvar_34) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_10 = (((tmpvar_39 / tmpvar_37) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_40;
    tmpvar_40 = (tmpvar_14 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_11.x;
    tmpvar_41.y = fetchesOffsetsV_10.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_40 + tmpvar_41);
    tmpvar_42.z = shadowCoord_8.z;
    mediump float tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_12 = ((tmpvar_34.x * tmpvar_37.x) * tmpvar_43);
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_11.y;
    tmpvar_44.y = fetchesOffsetsV_10.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_40 + tmpvar_44);
    tmpvar_45.z = shadowCoord_8.z;
    mediump float tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_12 = (shadow_12 + ((tmpvar_34.y * tmpvar_37.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_11.z;
    tmpvar_47.y = fetchesOffsetsV_10.x;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_40 + tmpvar_47);
    tmpvar_48.z = shadowCoord_8.z;
    mediump float tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_12 = (shadow_12 + ((tmpvar_34.z * tmpvar_37.x) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_11.x;
    tmpvar_50.y = fetchesOffsetsV_10.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_40 + tmpvar_50);
    tmpvar_51.z = shadowCoord_8.z;
    mediump float tmpvar_52;
    tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_12 = (shadow_12 + ((tmpvar_34.x * tmpvar_37.y) * tmpvar_52));
    highp vec2 tmpvar_53;
    tmpvar_53.x = fetchesOffsetsU_11.y;
    tmpvar_53.y = fetchesOffsetsV_10.y;
    highp vec3 tmpvar_54;
    tmpvar_54.xy = (tmpvar_40 + tmpvar_53);
    tmpvar_54.z = shadowCoord_8.z;
    mediump float tmpvar_55;
    tmpvar_55 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_54);
    shadow_12 = (shadow_12 + ((tmpvar_34.y * tmpvar_37.y) * tmpvar_55));
    highp vec2 tmpvar_56;
    tmpvar_56.x = fetchesOffsetsU_11.z;
    tmpvar_56.y = fetchesOffsetsV_10.y;
    highp vec3 tmpvar_57;
    tmpvar_57.xy = (tmpvar_40 + tmpvar_56);
    tmpvar_57.z = shadowCoord_8.z;
    mediump float tmpvar_58;
    tmpvar_58 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_57);
    shadow_12 = (shadow_12 + ((tmpvar_34.z * tmpvar_37.y) * tmpvar_58));
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_11.x;
    tmpvar_59.y = fetchesOffsetsV_10.z;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_40 + tmpvar_59);
    tmpvar_60.z = shadowCoord_8.z;
    mediump float tmpvar_61;
    tmpvar_61 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_12 = (shadow_12 + ((tmpvar_34.x * tmpvar_37.z) * tmpvar_61));
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_11.y;
    tmpvar_62.y = fetchesOffsetsV_10.z;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_40 + tmpvar_62);
    tmpvar_63.z = shadowCoord_8.z;
    mediump float tmpvar_64;
    tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_12 = (shadow_12 + ((tmpvar_34.y * tmpvar_37.z) * tmpvar_64));
    highp vec2 tmpvar_65;
    tmpvar_65.x = fetchesOffsetsU_11.z;
    tmpvar_65.y = fetchesOffsetsV_10.z;
    highp vec3 tmpvar_66;
    tmpvar_66.xy = (tmpvar_40 + tmpvar_65);
    tmpvar_66.z = shadowCoord_8.z;
    mediump float tmpvar_67;
    tmpvar_67 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_66);
    shadow_12 = (shadow_12 + ((tmpvar_34.z * tmpvar_37.z) * tmpvar_67));
    tmpvar_9 = mix (1.0, shadow_12, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_68;
  tmpvar_68.x = xlv_TEXCOORD1.w;
  tmpvar_68.y = xlv_TEXCOORD2.w;
  tmpvar_68.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_69;
  tmpvar_69 = normalize((CAMERA_WORLDPOSITION - tmpvar_68));
  lowp vec3 tmpvar_70;
  tmpvar_70 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_7 = tmpvar_70;
  highp vec3 tmpvar_71;
  tmpvar_71 = ((mainNormal_7 * 2.0) - 1.0);
  highp vec3 tmpvar_72;
  tmpvar_72 = normalize(((
    (tmpvar_71.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_71.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_71.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_73;
  tmpvar_73 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_74;
  tmpvar_74 = max (dot (tmpvar_72, tmpvar_69), 0.0);
  highp float tmpvar_75;
  tmpvar_75 = max (dot (tmpvar_72, normalize(
    (tmpvar_69 + tmpvar_73)
  )), 0.0);
  lowp vec3 tmpvar_76;
  tmpvar_76 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_6 = tmpvar_76;
  mainColor_6 = (mainColor_6 * mainColor_6);
  lowp vec3 tmpvar_77;
  tmpvar_77 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_5 = tmpvar_77;
  highp float tmpvar_78;
  tmpvar_78 = (1.0 - specular_5.x);
  highp vec2 tmpvar_79;
  tmpvar_79.x = ((dot (tmpvar_72, tmpvar_73) * 0.5) + 0.5);
  tmpvar_79.y = specular_5.y;
  lowp vec3 tmpvar_80;
  tmpvar_80 = texture (BRDFTex, tmpvar_79).xyz;
  brdfColor_4 = tmpvar_80;
  highp vec3 I_81;
  I_81 = -(tmpvar_69);
  reflectDir_3.xyz = (I_81 - (2.0 * (
    dot (tmpvar_72, I_81)
   * tmpvar_72)));
  reflectDir_3.w = (tmpvar_78 * 4.0);
  lowp vec4 tmpvar_82;
  tmpvar_82 = textureLod (skybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_83;
  tmpvar_83 = tmpvar_82;
  iblColor_2.w = tmpvar_83.w;
  iblColor_2.xyz = ((tmpvar_83.xyz * tmpvar_83.w) * 4.0);
  highp float tmpvar_84;
  tmpvar_84 = max ((tmpvar_78 * tmpvar_78), 0.1);
  highp float tmpvar_85;
  tmpvar_85 = (tmpvar_84 * tmpvar_84);
  highp float tmpvar_86;
  tmpvar_86 = (((
    (tmpvar_75 * tmpvar_85)
   - tmpvar_75) * tmpvar_75) + 1.0);
  d_1 = ((0.3183099 * tmpvar_85) / ((tmpvar_86 * tmpvar_86) + 1e-7));
  highp float tmpvar_87;
  tmpvar_87 = min (d_1, 100.0);
  d_1 = tmpvar_87;
  highp vec4 tmpvar_88;
  tmpvar_88.w = 1.0;
  tmpvar_88.xyz = (((
    (((tmpvar_87 * mix (Fresnel, 1.0, 
      (1.0 - tmpvar_74)
    )) * LIGHT_COLOR) + (((iblColor_2.xyz * 0.5) * (
      ((min ((Fresnel * 2.0), 1.0) - Fresnel) * pow ((1.0 - tmpvar_74), 4.0))
     + Fresnel)) * AMBIENT_COLOR))
   * SpecularColor.xyz) + (
    (((mix (ShadowColor.xyz, brdfColor_4, vec3(tmpvar_9)) * LIGHT_COLOR) * mainColor_6) + (AMBIENT_COLOR * mainColor_6))
   * 
    mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, tmpvar_74, (1.0 - specular_5.z))))
  )) + (RimColor * pow (
    (1.0 - max (0.0, dot (tmpvar_69, tmpvar_72)))
  , 
    (1.0/(RimPower))
  )).xyz);
  _glesFragData[0] = tmpvar_88;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BRDFTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "skybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadowColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RimColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RimPower",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform sampler2D BRDFTex;
uniform lowp samplerCube skybox;
uniform highp vec4 ShadeColor;
uniform highp vec4 ShadowColor;
uniform highp vec4 SpecularColor;
uniform highp vec4 RimColor;
uniform highp float RimPower;
uniform highp float Fresnel;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 brdfColor_4;
  highp vec3 specular_5;
  highp vec3 mainColor_6;
  highp vec3 mainNormal_7;
  highp vec4 shadowCoord_8;
  shadowCoord_8 = xlv_TEXCOORD4;
  highp float tmpvar_9;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_9 = 1.0;
  } else {
    shadowCoord_8.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_10;
    highp vec4 fetchesOffsetsU_11;
    highp float shadow_12;
    highp vec2 tmpvar_13;
    tmpvar_13 = (shadowCoord_8.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_14;
    tmpvar_14 = floor((tmpvar_13 + 0.5));
    highp vec2 tmpvar_15;
    tmpvar_15 = (tmpvar_13 - tmpvar_14);
    highp vec4 texelsWeightsA_16;
    highp vec4 texelsWeightsB_17;
    highp vec4 computedArea_18;
    highp vec4 computedAreaUncut_19;
    highp float tmpvar_20;
    tmpvar_20 = (((tmpvar_15.x + 0.5) * (tmpvar_15.x + 0.5)) * 0.5);
    highp float tmpvar_21;
    tmpvar_21 = (tmpvar_20 - tmpvar_15.x);
    computedArea_18.x = tmpvar_21;
    computedAreaUncut_19.x = tmpvar_21;
    computedArea_18.w = tmpvar_20;
    computedAreaUncut_19.w = tmpvar_20;
    computedAreaUncut_19.y = ((1.5 - tmpvar_15.x) - 0.5);
    highp float tmpvar_22;
    tmpvar_22 = min (tmpvar_15.x, 0.0);
    computedArea_18.y = (computedAreaUncut_19.y - (tmpvar_22 * tmpvar_22));
    computedAreaUncut_19.z = ((1.5 + tmpvar_15.x) - 0.5);
    highp float tmpvar_23;
    tmpvar_23 = max (tmpvar_15.x, 0.0);
    computedArea_18.z = (computedAreaUncut_19.z - (tmpvar_23 * tmpvar_23));
    texelsWeightsA_16.x = (0.081632 * tmpvar_21);
    texelsWeightsA_16.y = (0.081632 * computedAreaUncut_19.y);
    texelsWeightsA_16.z = (0.081632 * (computedAreaUncut_19.y + 1.0));
    texelsWeightsA_16.w = (0.081632 * (computedArea_18.y + 2.0));
    texelsWeightsB_17.x = (0.081632 * (computedArea_18.z + 2.0));
    texelsWeightsB_17.y = (0.081632 * (computedAreaUncut_19.z + 1.0));
    texelsWeightsB_17.z = (0.081632 * computedAreaUncut_19.z);
    texelsWeightsB_17.w = (0.081632 * tmpvar_20);
    highp vec4 texelsWeightsA_24;
    highp vec4 texelsWeightsB_25;
    highp vec4 computedArea_26;
    highp vec4 computedAreaUncut_27;
    highp float tmpvar_28;
    tmpvar_28 = (((tmpvar_15.y + 0.5) * (tmpvar_15.y + 0.5)) * 0.5);
    highp float tmpvar_29;
    tmpvar_29 = (tmpvar_28 - tmpvar_15.y);
    computedArea_26.x = tmpvar_29;
    computedAreaUncut_27.x = tmpvar_29;
    computedArea_26.w = tmpvar_28;
    computedAreaUncut_27.w = tmpvar_28;
    computedAreaUncut_27.y = ((1.5 - tmpvar_15.y) - 0.5);
    highp float tmpvar_30;
    tmpvar_30 = min (tmpvar_15.y, 0.0);
    computedArea_26.y = (computedAreaUncut_27.y - (tmpvar_30 * tmpvar_30));
    computedAreaUncut_27.z = ((1.5 + tmpvar_15.y) - 0.5);
    highp float tmpvar_31;
    tmpvar_31 = max (tmpvar_15.y, 0.0);
    computedArea_26.z = (computedAreaUncut_27.z - (tmpvar_31 * tmpvar_31));
    texelsWeightsA_24.x = (0.081632 * tmpvar_29);
    texelsWeightsA_24.y = (0.081632 * computedAreaUncut_27.y);
    texelsWeightsA_24.z = (0.081632 * (computedAreaUncut_27.y + 1.0));
    texelsWeightsA_24.w = (0.081632 * (computedArea_26.y + 2.0));
    texelsWeightsB_25.x = (0.081632 * (computedArea_26.z + 2.0));
    texelsWeightsB_25.y = (0.081632 * (computedAreaUncut_27.z + 1.0));
    texelsWeightsB_25.z = (0.081632 * computedAreaUncut_27.z);
    texelsWeightsB_25.w = (0.081632 * tmpvar_28);
    highp vec4 tmpvar_32;
    tmpvar_32.xy = texelsWeightsA_16.xz;
    tmpvar_32.zw = texelsWeightsB_17.xz;
    highp vec4 tmpvar_33;
    tmpvar_33.xy = texelsWeightsA_16.yw;
    tmpvar_33.zw = texelsWeightsB_17.yw;
    highp vec4 tmpvar_34;
    tmpvar_34 = (tmpvar_32 + tmpvar_33);
    highp vec4 tmpvar_35;
    tmpvar_35.xy = texelsWeightsA_24.xz;
    tmpvar_35.zw = texelsWeightsB_25.xz;
    highp vec4 tmpvar_36;
    tmpvar_36.xy = texelsWeightsA_24.yw;
    tmpvar_36.zw = texelsWeightsB_25.yw;
    highp vec4 tmpvar_37;
    tmpvar_37 = (tmpvar_35 + tmpvar_36);
    highp vec4 tmpvar_38;
    tmpvar_38.xy = texelsWeightsA_16.yw;
    tmpvar_38.zw = texelsWeightsB_17.yw;
    highp vec4 tmpvar_39;
    tmpvar_39.xy = texelsWeightsA_24.yw;
    tmpvar_39.zw = texelsWeightsB_25.yw;
    fetchesOffsetsU_11 = (((tmpvar_38 / tmpvar_34) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_10 = (((tmpvar_39 / tmpvar_37) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_40;
    tmpvar_40 = (tmpvar_14 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_11.x;
    tmpvar_41.y = fetchesOffsetsV_10.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_40 + tmpvar_41);
    tmpvar_42.z = shadowCoord_8.z;
    mediump float tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_12 = ((tmpvar_34.x * tmpvar_37.x) * tmpvar_43);
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_11.y;
    tmpvar_44.y = fetchesOffsetsV_10.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_40 + tmpvar_44);
    tmpvar_45.z = shadowCoord_8.z;
    mediump float tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_12 = (shadow_12 + ((tmpvar_34.y * tmpvar_37.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_11.z;
    tmpvar_47.y = fetchesOffsetsV_10.x;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_40 + tmpvar_47);
    tmpvar_48.z = shadowCoord_8.z;
    mediump float tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_12 = (shadow_12 + ((tmpvar_34.z * tmpvar_37.x) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_11.w;
    tmpvar_50.y = fetchesOffsetsV_10.x;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_40 + tmpvar_50);
    tmpvar_51.z = shadowCoord_8.z;
    mediump float tmpvar_52;
    tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_12 = (shadow_12 + ((tmpvar_34.w * tmpvar_37.x) * tmpvar_52));
    highp vec2 tmpvar_53;
    tmpvar_53.x = fetchesOffsetsU_11.x;
    tmpvar_53.y = fetchesOffsetsV_10.y;
    highp vec3 tmpvar_54;
    tmpvar_54.xy = (tmpvar_40 + tmpvar_53);
    tmpvar_54.z = shadowCoord_8.z;
    mediump float tmpvar_55;
    tmpvar_55 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_54);
    shadow_12 = (shadow_12 + ((tmpvar_34.x * tmpvar_37.y) * tmpvar_55));
    highp vec2 tmpvar_56;
    tmpvar_56.x = fetchesOffsetsU_11.y;
    tmpvar_56.y = fetchesOffsetsV_10.y;
    highp vec3 tmpvar_57;
    tmpvar_57.xy = (tmpvar_40 + tmpvar_56);
    tmpvar_57.z = shadowCoord_8.z;
    mediump float tmpvar_58;
    tmpvar_58 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_57);
    shadow_12 = (shadow_12 + ((tmpvar_34.y * tmpvar_37.y) * tmpvar_58));
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_11.z;
    tmpvar_59.y = fetchesOffsetsV_10.y;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_40 + tmpvar_59);
    tmpvar_60.z = shadowCoord_8.z;
    mediump float tmpvar_61;
    tmpvar_61 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_12 = (shadow_12 + ((tmpvar_34.z * tmpvar_37.y) * tmpvar_61));
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_11.w;
    tmpvar_62.y = fetchesOffsetsV_10.y;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_40 + tmpvar_62);
    tmpvar_63.z = shadowCoord_8.z;
    mediump float tmpvar_64;
    tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_12 = (shadow_12 + ((tmpvar_34.w * tmpvar_37.y) * tmpvar_64));
    highp vec2 tmpvar_65;
    tmpvar_65.x = fetchesOffsetsU_11.x;
    tmpvar_65.y = fetchesOffsetsV_10.z;
    highp vec3 tmpvar_66;
    tmpvar_66.xy = (tmpvar_40 + tmpvar_65);
    tmpvar_66.z = shadowCoord_8.z;
    mediump float tmpvar_67;
    tmpvar_67 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_66);
    shadow_12 = (shadow_12 + ((tmpvar_34.x * tmpvar_37.z) * tmpvar_67));
    highp vec2 tmpvar_68;
    tmpvar_68.x = fetchesOffsetsU_11.y;
    tmpvar_68.y = fetchesOffsetsV_10.z;
    highp vec3 tmpvar_69;
    tmpvar_69.xy = (tmpvar_40 + tmpvar_68);
    tmpvar_69.z = shadowCoord_8.z;
    mediump float tmpvar_70;
    tmpvar_70 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_69);
    shadow_12 = (shadow_12 + ((tmpvar_34.y * tmpvar_37.z) * tmpvar_70));
    highp vec2 tmpvar_71;
    tmpvar_71.x = fetchesOffsetsU_11.z;
    tmpvar_71.y = fetchesOffsetsV_10.z;
    highp vec3 tmpvar_72;
    tmpvar_72.xy = (tmpvar_40 + tmpvar_71);
    tmpvar_72.z = shadowCoord_8.z;
    mediump float tmpvar_73;
    tmpvar_73 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_72);
    shadow_12 = (shadow_12 + ((tmpvar_34.z * tmpvar_37.z) * tmpvar_73));
    highp vec2 tmpvar_74;
    tmpvar_74.x = fetchesOffsetsU_11.w;
    tmpvar_74.y = fetchesOffsetsV_10.z;
    highp vec3 tmpvar_75;
    tmpvar_75.xy = (tmpvar_40 + tmpvar_74);
    tmpvar_75.z = shadowCoord_8.z;
    mediump float tmpvar_76;
    tmpvar_76 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_75);
    shadow_12 = (shadow_12 + ((tmpvar_34.w * tmpvar_37.z) * tmpvar_76));
    highp vec2 tmpvar_77;
    tmpvar_77.x = fetchesOffsetsU_11.x;
    tmpvar_77.y = fetchesOffsetsV_10.w;
    highp vec3 tmpvar_78;
    tmpvar_78.xy = (tmpvar_40 + tmpvar_77);
    tmpvar_78.z = shadowCoord_8.z;
    mediump float tmpvar_79;
    tmpvar_79 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_78);
    shadow_12 = (shadow_12 + ((tmpvar_34.x * tmpvar_37.w) * tmpvar_79));
    highp vec2 tmpvar_80;
    tmpvar_80.x = fetchesOffsetsU_11.y;
    tmpvar_80.y = fetchesOffsetsV_10.w;
    highp vec3 tmpvar_81;
    tmpvar_81.xy = (tmpvar_40 + tmpvar_80);
    tmpvar_81.z = shadowCoord_8.z;
    mediump float tmpvar_82;
    tmpvar_82 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_81);
    shadow_12 = (shadow_12 + ((tmpvar_34.y * tmpvar_37.w) * tmpvar_82));
    highp vec2 tmpvar_83;
    tmpvar_83.x = fetchesOffsetsU_11.z;
    tmpvar_83.y = fetchesOffsetsV_10.w;
    highp vec3 tmpvar_84;
    tmpvar_84.xy = (tmpvar_40 + tmpvar_83);
    tmpvar_84.z = shadowCoord_8.z;
    mediump float tmpvar_85;
    tmpvar_85 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_84);
    shadow_12 = (shadow_12 + ((tmpvar_34.z * tmpvar_37.w) * tmpvar_85));
    highp vec2 tmpvar_86;
    tmpvar_86.x = fetchesOffsetsU_11.w;
    tmpvar_86.y = fetchesOffsetsV_10.w;
    highp vec3 tmpvar_87;
    tmpvar_87.xy = (tmpvar_40 + tmpvar_86);
    tmpvar_87.z = shadowCoord_8.z;
    mediump float tmpvar_88;
    tmpvar_88 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_87);
    shadow_12 = (shadow_12 + ((tmpvar_34.w * tmpvar_37.w) * tmpvar_88));
    tmpvar_9 = mix (1.0, shadow_12, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_89;
  tmpvar_89.x = xlv_TEXCOORD1.w;
  tmpvar_89.y = xlv_TEXCOORD2.w;
  tmpvar_89.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_90;
  tmpvar_90 = normalize((CAMERA_WORLDPOSITION - tmpvar_89));
  lowp vec3 tmpvar_91;
  tmpvar_91 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_7 = tmpvar_91;
  highp vec3 tmpvar_92;
  tmpvar_92 = ((mainNormal_7 * 2.0) - 1.0);
  highp vec3 tmpvar_93;
  tmpvar_93 = normalize(((
    (tmpvar_92.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_92.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_92.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_94;
  tmpvar_94 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_95;
  tmpvar_95 = max (dot (tmpvar_93, tmpvar_90), 0.0);
  highp float tmpvar_96;
  tmpvar_96 = max (dot (tmpvar_93, normalize(
    (tmpvar_90 + tmpvar_94)
  )), 0.0);
  lowp vec3 tmpvar_97;
  tmpvar_97 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_6 = tmpvar_97;
  mainColor_6 = (mainColor_6 * mainColor_6);
  lowp vec3 tmpvar_98;
  tmpvar_98 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_5 = tmpvar_98;
  highp float tmpvar_99;
  tmpvar_99 = (1.0 - specular_5.x);
  highp vec2 tmpvar_100;
  tmpvar_100.x = ((dot (tmpvar_93, tmpvar_94) * 0.5) + 0.5);
  tmpvar_100.y = specular_5.y;
  lowp vec3 tmpvar_101;
  tmpvar_101 = texture (BRDFTex, tmpvar_100).xyz;
  brdfColor_4 = tmpvar_101;
  highp vec3 I_102;
  I_102 = -(tmpvar_90);
  reflectDir_3.xyz = (I_102 - (2.0 * (
    dot (tmpvar_93, I_102)
   * tmpvar_93)));
  reflectDir_3.w = (tmpvar_99 * 4.0);
  lowp vec4 tmpvar_103;
  tmpvar_103 = textureLod (skybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_104;
  tmpvar_104 = tmpvar_103;
  iblColor_2.w = tmpvar_104.w;
  iblColor_2.xyz = ((tmpvar_104.xyz * tmpvar_104.w) * 4.0);
  highp float tmpvar_105;
  tmpvar_105 = max ((tmpvar_99 * tmpvar_99), 0.1);
  highp float tmpvar_106;
  tmpvar_106 = (tmpvar_105 * tmpvar_105);
  highp float tmpvar_107;
  tmpvar_107 = (((
    (tmpvar_96 * tmpvar_106)
   - tmpvar_96) * tmpvar_96) + 1.0);
  d_1 = ((0.3183099 * tmpvar_106) / ((tmpvar_107 * tmpvar_107) + 1e-7));
  highp float tmpvar_108;
  tmpvar_108 = min (d_1, 100.0);
  d_1 = tmpvar_108;
  highp vec4 tmpvar_109;
  tmpvar_109.w = 1.0;
  tmpvar_109.xyz = (((
    (((tmpvar_108 * mix (Fresnel, 1.0, 
      (1.0 - tmpvar_95)
    )) * LIGHT_COLOR) + (((iblColor_2.xyz * 0.5) * (
      ((min ((Fresnel * 2.0), 1.0) - Fresnel) * pow ((1.0 - tmpvar_95), 4.0))
     + Fresnel)) * AMBIENT_COLOR))
   * SpecularColor.xyz) + (
    (((mix (ShadowColor.xyz, brdfColor_4, vec3(tmpvar_9)) * LIGHT_COLOR) * mainColor_6) + (AMBIENT_COLOR * mainColor_6))
   * 
    mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, tmpvar_95, (1.0 - specular_5.z))))
  )) + (RimColor * pow (
    (1.0 - max (0.0, dot (tmpvar_90, tmpvar_93)))
  , 
    (1.0/(RimPower))
  )).xyz);
  _glesFragData[0] = tmpvar_109;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BRDFTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "skybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadowColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RimColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RimPower",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform sampler2D BRDFTex;
uniform lowp samplerCube skybox;
uniform highp vec4 ShadeColor;
uniform highp vec4 ShadowColor;
uniform highp vec4 SpecularColor;
uniform highp vec4 RimColor;
uniform highp float RimPower;
uniform highp float Fresnel;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 brdfColor_4;
  highp vec3 specular_5;
  highp vec3 mainColor_6;
  highp vec3 mainNormal_7;
  highp vec4 shadowCoord_8;
  shadowCoord_8 = xlv_TEXCOORD4;
  highp float tmpvar_9;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_9 = 1.0;
  } else {
    highp vec2 tmpvar_10;
    tmpvar_10.x = LIGHT_PARAM.z;
    tmpvar_10.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_11;
    tmpvar_11.xy = tmpvar_10;
    highp float tmpvar_12;
    tmpvar_12 = (1.0/(LIGHT_PARAM.z));
    tmpvar_11.z = tmpvar_12;
    tmpvar_11.w = tmpvar_12;
    shadowCoord_8.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_13;
    highp vec2 tmpvar_14;
    tmpvar_14 = tmpvar_11.xy;
    shadow_13 = 0.0;
    highp vec3 tmpvar_15;
    tmpvar_15.xy = (shadowCoord_8.xy - LIGHT_PARAM.zz);
    tmpvar_15.z = shadowCoord_8.z;
    highp vec4 tmpvar_16;
    tmpvar_16 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_15.xy);
    highp float tmpvar_17;
    if ((tmpvar_16.x < xlv_TEXCOORD4.z)) {
      tmpvar_17 = 0.0;
    } else {
      tmpvar_17 = 1.0;
    };
    shadow_13 = tmpvar_17;
    highp vec2 tmpvar_18;
    tmpvar_18.x = 0.0;
    tmpvar_18.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_19;
    tmpvar_19.xy = (shadowCoord_8.xy + tmpvar_18);
    tmpvar_19.z = shadowCoord_8.z;
    highp vec4 tmpvar_20;
    tmpvar_20 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_19.xy);
    highp float tmpvar_21;
    if ((tmpvar_20.x < xlv_TEXCOORD4.z)) {
      tmpvar_21 = 0.0;
    } else {
      tmpvar_21 = 1.0;
    };
    shadow_13 = (tmpvar_17 + tmpvar_21);
    highp vec2 tmpvar_22;
    tmpvar_22.x = tmpvar_14.x;
    tmpvar_22.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_23;
    tmpvar_23.xy = (shadowCoord_8.xy + tmpvar_22);
    tmpvar_23.z = shadowCoord_8.z;
    highp vec4 tmpvar_24;
    tmpvar_24 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_23.xy);
    highp float tmpvar_25;
    if ((tmpvar_24.x < xlv_TEXCOORD4.z)) {
      tmpvar_25 = 0.0;
    } else {
      tmpvar_25 = 1.0;
    };
    shadow_13 = (shadow_13 + tmpvar_25);
    highp vec2 tmpvar_26;
    tmpvar_26.y = 0.0;
    tmpvar_26.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_27;
    tmpvar_27.xy = (shadowCoord_8.xy + tmpvar_26);
    tmpvar_27.z = shadowCoord_8.z;
    highp vec4 tmpvar_28;
    tmpvar_28 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_27.xy);
    highp float tmpvar_29;
    if ((tmpvar_28.x < xlv_TEXCOORD4.z)) {
      tmpvar_29 = 0.0;
    } else {
      tmpvar_29 = 1.0;
    };
    shadow_13 = (shadow_13 + tmpvar_29);
    highp vec4 tmpvar_30;
    tmpvar_30 = texture (TEXTURE_SHADOW_DEPTH, shadowCoord_8.xy);
    highp float tmpvar_31;
    if ((tmpvar_30.x < xlv_TEXCOORD4.z)) {
      tmpvar_31 = 0.0;
    } else {
      tmpvar_31 = 1.0;
    };
    shadow_13 = (shadow_13 + tmpvar_31);
    highp vec2 tmpvar_32;
    tmpvar_32.y = 0.0;
    tmpvar_32.x = tmpvar_14.x;
    highp vec3 tmpvar_33;
    tmpvar_33.xy = (shadowCoord_8.xy + tmpvar_32);
    tmpvar_33.z = shadowCoord_8.z;
    highp vec4 tmpvar_34;
    tmpvar_34 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_33.xy);
    highp float tmpvar_35;
    if ((tmpvar_34.x < xlv_TEXCOORD4.z)) {
      tmpvar_35 = 0.0;
    } else {
      tmpvar_35 = 1.0;
    };
    shadow_13 = (shadow_13 + tmpvar_35);
    highp vec2 tmpvar_36;
    tmpvar_36.x = -(LIGHT_PARAM.z);
    tmpvar_36.y = tmpvar_14.y;
    highp vec3 tmpvar_37;
    tmpvar_37.xy = (shadowCoord_8.xy + tmpvar_36);
    tmpvar_37.z = shadowCoord_8.z;
    highp vec4 tmpvar_38;
    tmpvar_38 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_37.xy);
    highp float tmpvar_39;
    if ((tmpvar_38.x < xlv_TEXCOORD4.z)) {
      tmpvar_39 = 0.0;
    } else {
      tmpvar_39 = 1.0;
    };
    shadow_13 = (shadow_13 + tmpvar_39);
    highp vec2 tmpvar_40;
    tmpvar_40.x = 0.0;
    tmpvar_40.y = tmpvar_14.y;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (shadowCoord_8.xy + tmpvar_40);
    tmpvar_41.z = shadowCoord_8.z;
    highp vec4 tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41.xy);
    highp float tmpvar_43;
    if ((tmpvar_42.x < xlv_TEXCOORD4.z)) {
      tmpvar_43 = 0.0;
    } else {
      tmpvar_43 = 1.0;
    };
    shadow_13 = (shadow_13 + tmpvar_43);
    highp vec3 tmpvar_44;
    tmpvar_44.xy = (shadowCoord_8.xy + LIGHT_PARAM.zz);
    tmpvar_44.z = shadowCoord_8.z;
    highp vec4 tmpvar_45;
    tmpvar_45 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_44.xy);
    highp float tmpvar_46;
    if ((tmpvar_45.x < xlv_TEXCOORD4.z)) {
      tmpvar_46 = 0.0;
    } else {
      tmpvar_46 = 1.0;
    };
    shadow_13 = (shadow_13 + tmpvar_46);
    shadow_13 = (shadow_13 / 9.0);
    tmpvar_9 = mix (1.0, shadow_13, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_47;
  tmpvar_47.x = xlv_TEXCOORD1.w;
  tmpvar_47.y = xlv_TEXCOORD2.w;
  tmpvar_47.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_48;
  tmpvar_48 = normalize((CAMERA_WORLDPOSITION - tmpvar_47));
  lowp vec3 tmpvar_49;
  tmpvar_49 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_7 = tmpvar_49;
  highp vec3 tmpvar_50;
  tmpvar_50 = ((mainNormal_7 * 2.0) - 1.0);
  highp vec3 tmpvar_51;
  tmpvar_51 = normalize(((
    (tmpvar_50.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_50.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_50.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_52;
  tmpvar_52 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_53;
  tmpvar_53 = max (dot (tmpvar_51, tmpvar_48), 0.0);
  highp float tmpvar_54;
  tmpvar_54 = max (dot (tmpvar_51, normalize(
    (tmpvar_48 + tmpvar_52)
  )), 0.0);
  lowp vec3 tmpvar_55;
  tmpvar_55 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_6 = tmpvar_55;
  mainColor_6 = (mainColor_6 * mainColor_6);
  lowp vec3 tmpvar_56;
  tmpvar_56 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_5 = tmpvar_56;
  highp float tmpvar_57;
  tmpvar_57 = (1.0 - specular_5.x);
  highp vec2 tmpvar_58;
  tmpvar_58.x = ((dot (tmpvar_51, tmpvar_52) * 0.5) + 0.5);
  tmpvar_58.y = specular_5.y;
  lowp vec3 tmpvar_59;
  tmpvar_59 = texture (BRDFTex, tmpvar_58).xyz;
  brdfColor_4 = tmpvar_59;
  highp vec3 I_60;
  I_60 = -(tmpvar_48);
  reflectDir_3.xyz = (I_60 - (2.0 * (
    dot (tmpvar_51, I_60)
   * tmpvar_51)));
  reflectDir_3.w = (tmpvar_57 * 4.0);
  lowp vec4 tmpvar_61;
  tmpvar_61 = textureLod (skybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_62;
  tmpvar_62 = tmpvar_61;
  iblColor_2.w = tmpvar_62.w;
  iblColor_2.xyz = ((tmpvar_62.xyz * tmpvar_62.w) * 4.0);
  highp float tmpvar_63;
  tmpvar_63 = max ((tmpvar_57 * tmpvar_57), 0.1);
  highp float tmpvar_64;
  tmpvar_64 = (tmpvar_63 * tmpvar_63);
  highp float tmpvar_65;
  tmpvar_65 = (((
    (tmpvar_54 * tmpvar_64)
   - tmpvar_54) * tmpvar_54) + 1.0);
  d_1 = ((0.3183099 * tmpvar_64) / ((tmpvar_65 * tmpvar_65) + 1e-7));
  highp float tmpvar_66;
  tmpvar_66 = min (d_1, 100.0);
  d_1 = tmpvar_66;
  highp vec4 tmpvar_67;
  tmpvar_67.w = 1.0;
  tmpvar_67.xyz = (((
    (((tmpvar_66 * mix (Fresnel, 1.0, 
      (1.0 - tmpvar_53)
    )) * LIGHT_COLOR) + (((iblColor_2.xyz * 0.5) * (
      ((min ((Fresnel * 2.0), 1.0) - Fresnel) * pow ((1.0 - tmpvar_53), 4.0))
     + Fresnel)) * AMBIENT_COLOR))
   * SpecularColor.xyz) + (
    (((mix (ShadowColor.xyz, brdfColor_4, vec3(tmpvar_9)) * LIGHT_COLOR) * mainColor_6) + (AMBIENT_COLOR * mainColor_6))
   * 
    mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, tmpvar_53, (1.0 - specular_5.z))))
  )) + (RimColor * pow (
    (1.0 - max (0.0, dot (tmpvar_48, tmpvar_51)))
  , 
    (1.0/(RimPower))
  )).xyz);
  _glesFragData[0] = tmpvar_67;
}

]===],
	},
}


end 

function ForwardAdd()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, ONE, ONE, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LEQUAL }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDADD }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[uint(0)].x = row0_6.x;
  tmpvar_11[uint(0)].y = row0_6.y;
  tmpvar_11[uint(0)].z = row0_6.z;
  tmpvar_11[uint(0)].w = row0_6.w;
  tmpvar_11[1u].x = row1_5.x;
  tmpvar_11[1u].y = row1_5.y;
  tmpvar_11[1u].z = row1_5.z;
  tmpvar_11[1u].w = row1_5.w;
  tmpvar_11[2u].x = row2_4.x;
  tmpvar_11[2u].y = row2_4.y;
  tmpvar_11[2u].z = row2_4.z;
  tmpvar_11[2u].w = row2_4.w;
  tmpvar_11[3u].x = 0.0;
  tmpvar_11[3u].y = 0.0;
  tmpvar_11[3u].z = 0.0;
  tmpvar_11[3u].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_14[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_14[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_15[1u] = tmpvar_11[1u].xyz;
  tmpvar_15[2u] = tmpvar_11[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_17[1u] = tmpvar_11[1u].xyz;
  tmpvar_17[2u] = tmpvar_11[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_19[1u] = tmpvar_11[1u].xyz;
  tmpvar_19[2u] = tmpvar_11[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform highp vec4 ShadeColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec3 backLight_1;
  highp float nl2_2;
  highp vec3 specular_3;
  highp vec3 mainColor_4;
  highp vec3 mainNormal_5;
  highp vec3 tmpvar_6;
  tmpvar_6.x = xlv_TEXCOORD1.w;
  tmpvar_6.y = xlv_TEXCOORD2.w;
  tmpvar_6.z = xlv_TEXCOORD3.w;
  lowp vec3 tmpvar_7;
  tmpvar_7 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_5 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = ((mainNormal_5 * 2.0) - 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(((
    (tmpvar_8.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_8.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_8.z * xlv_TEXCOORD1.xyz)));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_4 = tmpvar_10;
  mainColor_4 = (mainColor_4 * mainColor_4);
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_3 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = max (((
    dot (tmpvar_9, -(LIGHT_GIVEN_DIRECTION))
   + 0.5) * 0.7), 0.0);
  nl2_2 = (tmpvar_12 * tmpvar_12);
  nl2_2 = (nl2_2 * nl2_2);
  nl2_2 = (nl2_2 * nl2_2);
  backLight_1 = ((nl2_2 * LIGHT_COLOR) * (mainColor_4 * mainNormal_5.z));
  backLight_1 = (backLight_1 / (vec3(1.0, 1.0, 1.0) + backLight_1));
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = (backLight_1 * mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, 
    max (dot (tmpvar_9, normalize((CAMERA_WORLDPOSITION - tmpvar_6))), 0.0)
  , 
    (1.0 - specular_3.z)
  ))));
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform highp vec4 ShadeColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec3 backLight_1;
  highp float nl2_2;
  highp vec3 specular_3;
  highp vec3 mainColor_4;
  highp vec3 mainNormal_5;
  highp vec3 tmpvar_6;
  tmpvar_6.x = xlv_TEXCOORD1.w;
  tmpvar_6.y = xlv_TEXCOORD2.w;
  tmpvar_6.z = xlv_TEXCOORD3.w;
  lowp vec3 tmpvar_7;
  tmpvar_7 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_5 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = ((mainNormal_5 * 2.0) - 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(((
    (tmpvar_8.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_8.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_8.z * xlv_TEXCOORD1.xyz)));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_4 = tmpvar_10;
  mainColor_4 = (mainColor_4 * mainColor_4);
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_3 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = max (((
    dot (tmpvar_9, -(LIGHT_GIVEN_DIRECTION))
   + 0.5) * 0.7), 0.0);
  nl2_2 = (tmpvar_12 * tmpvar_12);
  nl2_2 = (nl2_2 * nl2_2);
  nl2_2 = (nl2_2 * nl2_2);
  backLight_1 = ((nl2_2 * LIGHT_COLOR) * (mainColor_4 * mainNormal_5.z));
  backLight_1 = (backLight_1 / (vec3(1.0, 1.0, 1.0) + backLight_1));
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = (backLight_1 * mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, 
    max (dot (tmpvar_9, normalize((CAMERA_WORLDPOSITION - tmpvar_6))), 0.0)
  , 
    (1.0 - specular_3.z)
  ))));
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform highp vec4 ShadeColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec3 backLight_1;
  highp float nl2_2;
  highp vec3 specular_3;
  highp vec3 mainColor_4;
  highp vec3 mainNormal_5;
  highp vec3 tmpvar_6;
  tmpvar_6.x = xlv_TEXCOORD1.w;
  tmpvar_6.y = xlv_TEXCOORD2.w;
  tmpvar_6.z = xlv_TEXCOORD3.w;
  lowp vec3 tmpvar_7;
  tmpvar_7 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_5 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = ((mainNormal_5 * 2.0) - 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(((
    (tmpvar_8.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_8.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_8.z * xlv_TEXCOORD1.xyz)));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_4 = tmpvar_10;
  mainColor_4 = (mainColor_4 * mainColor_4);
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_3 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = max (((
    dot (tmpvar_9, -(LIGHT_GIVEN_DIRECTION))
   + 0.5) * 0.7), 0.0);
  nl2_2 = (tmpvar_12 * tmpvar_12);
  nl2_2 = (nl2_2 * nl2_2);
  nl2_2 = (nl2_2 * nl2_2);
  backLight_1 = ((nl2_2 * LIGHT_COLOR) * (mainColor_4 * mainNormal_5.z));
  backLight_1 = (backLight_1 / (vec3(1.0, 1.0, 1.0) + backLight_1));
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = (backLight_1 * mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, 
    max (dot (tmpvar_9, normalize((CAMERA_WORLDPOSITION - tmpvar_6))), 0.0)
  , 
    (1.0 - specular_3.z)
  ))));
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform highp vec4 ShadeColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec3 backLight_1;
  highp float nl2_2;
  highp vec3 specular_3;
  highp vec3 mainColor_4;
  highp vec3 mainNormal_5;
  highp vec3 tmpvar_6;
  tmpvar_6.x = xlv_TEXCOORD1.w;
  tmpvar_6.y = xlv_TEXCOORD2.w;
  tmpvar_6.z = xlv_TEXCOORD3.w;
  lowp vec3 tmpvar_7;
  tmpvar_7 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_5 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = ((mainNormal_5 * 2.0) - 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(((
    (tmpvar_8.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_8.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_8.z * xlv_TEXCOORD1.xyz)));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_4 = tmpvar_10;
  mainColor_4 = (mainColor_4 * mainColor_4);
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_3 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = max (((
    dot (tmpvar_9, -(LIGHT_GIVEN_DIRECTION))
   + 0.5) * 0.7), 0.0);
  nl2_2 = (tmpvar_12 * tmpvar_12);
  nl2_2 = (nl2_2 * nl2_2);
  nl2_2 = (nl2_2 * nl2_2);
  backLight_1 = ((nl2_2 * LIGHT_COLOR) * (mainColor_4 * mainNormal_5.z));
  backLight_1 = (backLight_1 / (vec3(1.0, 1.0, 1.0) + backLight_1));
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = (backLight_1 * mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, 
    max (dot (tmpvar_9, normalize((CAMERA_WORLDPOSITION - tmpvar_6))), 0.0)
  , 
    (1.0 - specular_3.z)
  ))));
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform highp vec4 ShadeColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec3 backLight_1;
  highp float nl2_2;
  highp vec3 specular_3;
  highp vec3 mainColor_4;
  highp vec3 mainNormal_5;
  highp vec3 tmpvar_6;
  tmpvar_6.x = xlv_TEXCOORD1.w;
  tmpvar_6.y = xlv_TEXCOORD2.w;
  tmpvar_6.z = xlv_TEXCOORD3.w;
  lowp vec3 tmpvar_7;
  tmpvar_7 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_5 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = ((mainNormal_5 * 2.0) - 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(((
    (tmpvar_8.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_8.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_8.z * xlv_TEXCOORD1.xyz)));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_4 = tmpvar_10;
  mainColor_4 = (mainColor_4 * mainColor_4);
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_3 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = max (((
    dot (tmpvar_9, -(LIGHT_GIVEN_DIRECTION))
   + 0.5) * 0.7), 0.0);
  nl2_2 = (tmpvar_12 * tmpvar_12);
  nl2_2 = (nl2_2 * nl2_2);
  nl2_2 = (nl2_2 * nl2_2);
  backLight_1 = ((nl2_2 * LIGHT_COLOR) * (mainColor_4 * mainNormal_5.z));
  backLight_1 = (backLight_1 / (vec3(1.0, 1.0, 1.0) + backLight_1));
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = (backLight_1 * mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, 
    max (dot (tmpvar_9, normalize((CAMERA_WORLDPOSITION - tmpvar_6))), 0.0)
  , 
    (1.0 - specular_3.z)
  ))));
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[uint(0)].x = row0_6.x;
  tmpvar_11[uint(0)].y = row0_6.y;
  tmpvar_11[uint(0)].z = row0_6.z;
  tmpvar_11[uint(0)].w = row0_6.w;
  tmpvar_11[1u].x = row1_5.x;
  tmpvar_11[1u].y = row1_5.y;
  tmpvar_11[1u].z = row1_5.z;
  tmpvar_11[1u].w = row1_5.w;
  tmpvar_11[2u].x = row2_4.x;
  tmpvar_11[2u].y = row2_4.y;
  tmpvar_11[2u].z = row2_4.z;
  tmpvar_11[2u].w = row2_4.w;
  tmpvar_11[3u].x = 0.0;
  tmpvar_11[3u].y = 0.0;
  tmpvar_11[3u].z = 0.0;
  tmpvar_11[3u].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_14[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_14[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_15[1u] = tmpvar_11[1u].xyz;
  tmpvar_15[2u] = tmpvar_11[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_17[1u] = tmpvar_11[1u].xyz;
  tmpvar_17[2u] = tmpvar_11[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_19[1u] = tmpvar_11[1u].xyz;
  tmpvar_19[2u] = tmpvar_11[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform highp vec4 ShadeColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec3 backLight_1;
  highp float nl2_2;
  highp vec3 specular_3;
  highp vec3 mainColor_4;
  highp vec3 mainNormal_5;
  highp vec3 tmpvar_6;
  tmpvar_6.x = xlv_TEXCOORD1.w;
  tmpvar_6.y = xlv_TEXCOORD2.w;
  tmpvar_6.z = xlv_TEXCOORD3.w;
  lowp vec3 tmpvar_7;
  tmpvar_7 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_5 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = ((mainNormal_5 * 2.0) - 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(((
    (tmpvar_8.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_8.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_8.z * xlv_TEXCOORD1.xyz)));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_4 = tmpvar_10;
  mainColor_4 = (mainColor_4 * mainColor_4);
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_3 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = max (((
    dot (tmpvar_9, -(LIGHT_GIVEN_DIRECTION))
   + 0.5) * 0.7), 0.0);
  nl2_2 = (tmpvar_12 * tmpvar_12);
  nl2_2 = (nl2_2 * nl2_2);
  nl2_2 = (nl2_2 * nl2_2);
  backLight_1 = ((nl2_2 * LIGHT_COLOR) * (mainColor_4 * mainNormal_5.z));
  backLight_1 = (backLight_1 / (vec3(1.0, 1.0, 1.0) + backLight_1));
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = (backLight_1 * mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, 
    max (dot (tmpvar_9, normalize((CAMERA_WORLDPOSITION - tmpvar_6))), 0.0)
  , 
    (1.0 - specular_3.z)
  ))));
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  tmpvar_4.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform highp vec4 ShadeColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec3 backLight_1;
  highp float nl2_2;
  highp vec3 specular_3;
  highp vec3 mainColor_4;
  highp vec3 mainNormal_5;
  highp vec3 tmpvar_6;
  tmpvar_6.x = xlv_TEXCOORD1.w;
  tmpvar_6.y = xlv_TEXCOORD2.w;
  tmpvar_6.z = xlv_TEXCOORD3.w;
  lowp vec3 tmpvar_7;
  tmpvar_7 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_5 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = ((mainNormal_5 * 2.0) - 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(((
    (tmpvar_8.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_8.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_8.z * xlv_TEXCOORD1.xyz)));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_4 = tmpvar_10;
  mainColor_4 = (mainColor_4 * mainColor_4);
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_3 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = max (((
    dot (tmpvar_9, -(LIGHT_GIVEN_DIRECTION))
   + 0.5) * 0.7), 0.0);
  nl2_2 = (tmpvar_12 * tmpvar_12);
  nl2_2 = (nl2_2 * nl2_2);
  nl2_2 = (nl2_2 * nl2_2);
  backLight_1 = ((nl2_2 * LIGHT_COLOR) * (mainColor_4 * mainNormal_5.z));
  backLight_1 = (backLight_1 / (vec3(1.0, 1.0, 1.0) + backLight_1));
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = (backLight_1 * mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, 
    max (dot (tmpvar_9, normalize((CAMERA_WORLDPOSITION - tmpvar_6))), 0.0)
  , 
    (1.0 - specular_3.z)
  ))));
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  tmpvar_4.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform highp vec4 ShadeColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec3 backLight_1;
  highp float nl2_2;
  highp vec3 specular_3;
  highp vec3 mainColor_4;
  highp vec3 mainNormal_5;
  highp vec3 tmpvar_6;
  tmpvar_6.x = xlv_TEXCOORD1.w;
  tmpvar_6.y = xlv_TEXCOORD2.w;
  tmpvar_6.z = xlv_TEXCOORD3.w;
  lowp vec3 tmpvar_7;
  tmpvar_7 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_5 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = ((mainNormal_5 * 2.0) - 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(((
    (tmpvar_8.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_8.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_8.z * xlv_TEXCOORD1.xyz)));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_4 = tmpvar_10;
  mainColor_4 = (mainColor_4 * mainColor_4);
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_3 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = max (((
    dot (tmpvar_9, -(LIGHT_GIVEN_DIRECTION))
   + 0.5) * 0.7), 0.0);
  nl2_2 = (tmpvar_12 * tmpvar_12);
  nl2_2 = (nl2_2 * nl2_2);
  nl2_2 = (nl2_2 * nl2_2);
  backLight_1 = ((nl2_2 * LIGHT_COLOR) * (mainColor_4 * mainNormal_5.z));
  backLight_1 = (backLight_1 / (vec3(1.0, 1.0, 1.0) + backLight_1));
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = (backLight_1 * mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, 
    max (dot (tmpvar_9, normalize((CAMERA_WORLDPOSITION - tmpvar_6))), 0.0)
  , 
    (1.0 - specular_3.z)
  ))));
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  tmpvar_4.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform highp vec4 ShadeColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec3 backLight_1;
  highp float nl2_2;
  highp vec3 specular_3;
  highp vec3 mainColor_4;
  highp vec3 mainNormal_5;
  highp vec3 tmpvar_6;
  tmpvar_6.x = xlv_TEXCOORD1.w;
  tmpvar_6.y = xlv_TEXCOORD2.w;
  tmpvar_6.z = xlv_TEXCOORD3.w;
  lowp vec3 tmpvar_7;
  tmpvar_7 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_5 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = ((mainNormal_5 * 2.0) - 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(((
    (tmpvar_8.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_8.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_8.z * xlv_TEXCOORD1.xyz)));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_4 = tmpvar_10;
  mainColor_4 = (mainColor_4 * mainColor_4);
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_3 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = max (((
    dot (tmpvar_9, -(LIGHT_GIVEN_DIRECTION))
   + 0.5) * 0.7), 0.0);
  nl2_2 = (tmpvar_12 * tmpvar_12);
  nl2_2 = (nl2_2 * nl2_2);
  nl2_2 = (nl2_2 * nl2_2);
  backLight_1 = ((nl2_2 * LIGHT_COLOR) * (mainColor_4 * mainNormal_5.z));
  backLight_1 = (backLight_1 / (vec3(1.0, 1.0, 1.0) + backLight_1));
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = (backLight_1 * mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, 
    max (dot (tmpvar_9, normalize((CAMERA_WORLDPOSITION - tmpvar_6))), 0.0)
  , 
    (1.0 - specular_3.z)
  ))));
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  tmpvar_4.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform highp vec4 ShadeColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec3 backLight_1;
  highp float nl2_2;
  highp vec3 specular_3;
  highp vec3 mainColor_4;
  highp vec3 mainNormal_5;
  highp vec3 tmpvar_6;
  tmpvar_6.x = xlv_TEXCOORD1.w;
  tmpvar_6.y = xlv_TEXCOORD2.w;
  tmpvar_6.z = xlv_TEXCOORD3.w;
  lowp vec3 tmpvar_7;
  tmpvar_7 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_5 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = ((mainNormal_5 * 2.0) - 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(((
    (tmpvar_8.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_8.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_8.z * xlv_TEXCOORD1.xyz)));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_4 = tmpvar_10;
  mainColor_4 = (mainColor_4 * mainColor_4);
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_3 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = max (((
    dot (tmpvar_9, -(LIGHT_GIVEN_DIRECTION))
   + 0.5) * 0.7), 0.0);
  nl2_2 = (tmpvar_12 * tmpvar_12);
  nl2_2 = (nl2_2 * nl2_2);
  nl2_2 = (nl2_2 * nl2_2);
  backLight_1 = ((nl2_2 * LIGHT_COLOR) * (mainColor_4 * mainNormal_5.z));
  backLight_1 = (backLight_1 / (vec3(1.0, 1.0, 1.0) + backLight_1));
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = (backLight_1 * mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, 
    max (dot (tmpvar_9, normalize((CAMERA_WORLDPOSITION - tmpvar_6))), 0.0)
  , 
    (1.0 - specular_3.z)
  ))));
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","PointLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[uint(0)].x = row0_6.x;
  tmpvar_11[uint(0)].y = row0_6.y;
  tmpvar_11[uint(0)].z = row0_6.z;
  tmpvar_11[uint(0)].w = row0_6.w;
  tmpvar_11[1u].x = row1_5.x;
  tmpvar_11[1u].y = row1_5.y;
  tmpvar_11[1u].z = row1_5.z;
  tmpvar_11[1u].w = row1_5.w;
  tmpvar_11[2u].x = row2_4.x;
  tmpvar_11[2u].y = row2_4.y;
  tmpvar_11[2u].z = row2_4.z;
  tmpvar_11[2u].w = row2_4.w;
  tmpvar_11[3u].x = 0.0;
  tmpvar_11[3u].y = 0.0;
  tmpvar_11[3u].z = 0.0;
  tmpvar_11[3u].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_14[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_14[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_15[1u] = tmpvar_11[1u].xyz;
  tmpvar_15[2u] = tmpvar_11[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_17[1u] = tmpvar_11[1u].xyz;
  tmpvar_17[2u] = tmpvar_11[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_19[1u] = tmpvar_11[1u].xyz;
  tmpvar_19[2u] = tmpvar_11[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform highp vec4 ShadeColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec3 backLight_1;
  highp float nl2_2;
  highp vec3 specular_3;
  highp vec3 mainColor_4;
  highp vec3 mainNormal_5;
  highp vec3 tmpvar_6;
  tmpvar_6.x = xlv_TEXCOORD1.w;
  tmpvar_6.y = xlv_TEXCOORD2.w;
  tmpvar_6.z = xlv_TEXCOORD3.w;
  lowp vec3 tmpvar_7;
  tmpvar_7 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_5 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = ((mainNormal_5 * 2.0) - 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(((
    (tmpvar_8.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_8.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_8.z * xlv_TEXCOORD1.xyz)));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_4 = tmpvar_10;
  mainColor_4 = (mainColor_4 * mainColor_4);
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_3 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = max (((
    dot (tmpvar_9, -(LIGHT_GIVEN_DIRECTION))
   + 0.5) * 0.7), 0.0);
  nl2_2 = (tmpvar_12 * tmpvar_12);
  nl2_2 = (nl2_2 * nl2_2);
  nl2_2 = (nl2_2 * nl2_2);
  backLight_1 = ((nl2_2 * LIGHT_COLOR) * (mainColor_4 * mainNormal_5.z));
  backLight_1 = (backLight_1 / (vec3(1.0, 1.0, 1.0) + backLight_1));
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = (backLight_1 * mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, 
    max (dot (tmpvar_9, normalize((CAMERA_WORLDPOSITION - tmpvar_6))), 0.0)
  , 
    (1.0 - specular_3.z)
  ))));
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","PointLight","ShadowOn"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[uint(0)].x = row0_6.x;
  tmpvar_11[uint(0)].y = row0_6.y;
  tmpvar_11[uint(0)].z = row0_6.z;
  tmpvar_11[uint(0)].w = row0_6.w;
  tmpvar_11[1u].x = row1_5.x;
  tmpvar_11[1u].y = row1_5.y;
  tmpvar_11[1u].z = row1_5.z;
  tmpvar_11[1u].w = row1_5.w;
  tmpvar_11[2u].x = row2_4.x;
  tmpvar_11[2u].y = row2_4.y;
  tmpvar_11[2u].z = row2_4.z;
  tmpvar_11[2u].w = row2_4.w;
  tmpvar_11[3u].x = 0.0;
  tmpvar_11[3u].y = 0.0;
  tmpvar_11[3u].z = 0.0;
  tmpvar_11[3u].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_14[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_14[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_15[1u] = tmpvar_11[1u].xyz;
  tmpvar_15[2u] = tmpvar_11[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_17[1u] = tmpvar_11[1u].xyz;
  tmpvar_17[2u] = tmpvar_11[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_19[1u] = tmpvar_11[1u].xyz;
  tmpvar_19[2u] = tmpvar_11[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform highp vec4 ShadeColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec3 backLight_1;
  highp float nl2_2;
  highp vec3 specular_3;
  highp vec3 mainColor_4;
  highp vec3 mainNormal_5;
  highp vec3 tmpvar_6;
  tmpvar_6.x = xlv_TEXCOORD1.w;
  tmpvar_6.y = xlv_TEXCOORD2.w;
  tmpvar_6.z = xlv_TEXCOORD3.w;
  lowp vec3 tmpvar_7;
  tmpvar_7 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_5 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = ((mainNormal_5 * 2.0) - 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(((
    (tmpvar_8.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_8.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_8.z * xlv_TEXCOORD1.xyz)));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_4 = tmpvar_10;
  mainColor_4 = (mainColor_4 * mainColor_4);
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_3 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = max (((
    dot (tmpvar_9, -(LIGHT_GIVEN_DIRECTION))
   + 0.5) * 0.7), 0.0);
  nl2_2 = (tmpvar_12 * tmpvar_12);
  nl2_2 = (nl2_2 * nl2_2);
  nl2_2 = (nl2_2 * nl2_2);
  backLight_1 = ((nl2_2 * LIGHT_COLOR) * (mainColor_4 * mainNormal_5.z));
  backLight_1 = (backLight_1 / (vec3(1.0, 1.0, 1.0) + backLight_1));
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = (backLight_1 * mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, 
    max (dot (tmpvar_9, normalize((CAMERA_WORLDPOSITION - tmpvar_6))), 0.0)
  , 
    (1.0 - specular_3.z)
  ))));
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_9[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_9[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform highp vec4 ShadeColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec3 backLight_1;
  highp float nl2_2;
  highp vec3 specular_3;
  highp vec3 mainColor_4;
  highp vec3 mainNormal_5;
  highp vec3 tmpvar_6;
  tmpvar_6.x = xlv_TEXCOORD1.w;
  tmpvar_6.y = xlv_TEXCOORD2.w;
  tmpvar_6.z = xlv_TEXCOORD3.w;
  lowp vec3 tmpvar_7;
  tmpvar_7 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_5 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = ((mainNormal_5 * 2.0) - 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(((
    (tmpvar_8.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_8.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_8.z * xlv_TEXCOORD1.xyz)));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_4 = tmpvar_10;
  mainColor_4 = (mainColor_4 * mainColor_4);
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_3 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = max (((
    dot (tmpvar_9, -(LIGHT_GIVEN_DIRECTION))
   + 0.5) * 0.7), 0.0);
  nl2_2 = (tmpvar_12 * tmpvar_12);
  nl2_2 = (nl2_2 * nl2_2);
  nl2_2 = (nl2_2 * nl2_2);
  backLight_1 = ((nl2_2 * LIGHT_COLOR) * (mainColor_4 * mainNormal_5.z));
  backLight_1 = (backLight_1 / (vec3(1.0, 1.0, 1.0) + backLight_1));
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = (backLight_1 * mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, 
    max (dot (tmpvar_9, normalize((CAMERA_WORLDPOSITION - tmpvar_6))), 0.0)
  , 
    (1.0 - specular_3.z)
  ))));
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform highp vec4 ShadeColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec3 backLight_1;
  highp float nl2_2;
  highp vec3 specular_3;
  highp vec3 mainColor_4;
  highp vec3 mainNormal_5;
  highp vec3 tmpvar_6;
  tmpvar_6.x = xlv_TEXCOORD1.w;
  tmpvar_6.y = xlv_TEXCOORD2.w;
  tmpvar_6.z = xlv_TEXCOORD3.w;
  lowp vec3 tmpvar_7;
  tmpvar_7 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_5 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = ((mainNormal_5 * 2.0) - 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(((
    (tmpvar_8.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_8.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_8.z * xlv_TEXCOORD1.xyz)));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_4 = tmpvar_10;
  mainColor_4 = (mainColor_4 * mainColor_4);
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_3 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = max (((
    dot (tmpvar_9, -(LIGHT_GIVEN_DIRECTION))
   + 0.5) * 0.7), 0.0);
  nl2_2 = (tmpvar_12 * tmpvar_12);
  nl2_2 = (nl2_2 * nl2_2);
  nl2_2 = (nl2_2 * nl2_2);
  backLight_1 = ((nl2_2 * LIGHT_COLOR) * (mainColor_4 * mainNormal_5.z));
  backLight_1 = (backLight_1 / (vec3(1.0, 1.0, 1.0) + backLight_1));
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = (backLight_1 * mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, 
    max (dot (tmpvar_9, normalize((CAMERA_WORLDPOSITION - tmpvar_6))), 0.0)
  , 
    (1.0 - specular_3.z)
  ))));
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform highp vec4 ShadeColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec3 backLight_1;
  highp float nl2_2;
  highp vec3 specular_3;
  highp vec3 mainColor_4;
  highp vec3 mainNormal_5;
  highp vec3 tmpvar_6;
  tmpvar_6.x = xlv_TEXCOORD1.w;
  tmpvar_6.y = xlv_TEXCOORD2.w;
  tmpvar_6.z = xlv_TEXCOORD3.w;
  lowp vec3 tmpvar_7;
  tmpvar_7 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_5 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = ((mainNormal_5 * 2.0) - 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(((
    (tmpvar_8.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_8.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_8.z * xlv_TEXCOORD1.xyz)));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_4 = tmpvar_10;
  mainColor_4 = (mainColor_4 * mainColor_4);
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_3 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = max (((
    dot (tmpvar_9, -(LIGHT_GIVEN_DIRECTION))
   + 0.5) * 0.7), 0.0);
  nl2_2 = (tmpvar_12 * tmpvar_12);
  nl2_2 = (nl2_2 * nl2_2);
  nl2_2 = (nl2_2 * nl2_2);
  backLight_1 = ((nl2_2 * LIGHT_COLOR) * (mainColor_4 * mainNormal_5.z));
  backLight_1 = (backLight_1 / (vec3(1.0, 1.0, 1.0) + backLight_1));
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = (backLight_1 * mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, 
    max (dot (tmpvar_9, normalize((CAMERA_WORLDPOSITION - tmpvar_6))), 0.0)
  , 
    (1.0 - specular_3.z)
  ))));
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform highp vec4 ShadeColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec3 backLight_1;
  highp float nl2_2;
  highp vec3 specular_3;
  highp vec3 mainColor_4;
  highp vec3 mainNormal_5;
  highp vec3 tmpvar_6;
  tmpvar_6.x = xlv_TEXCOORD1.w;
  tmpvar_6.y = xlv_TEXCOORD2.w;
  tmpvar_6.z = xlv_TEXCOORD3.w;
  lowp vec3 tmpvar_7;
  tmpvar_7 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_5 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = ((mainNormal_5 * 2.0) - 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(((
    (tmpvar_8.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_8.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_8.z * xlv_TEXCOORD1.xyz)));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_4 = tmpvar_10;
  mainColor_4 = (mainColor_4 * mainColor_4);
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_3 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = max (((
    dot (tmpvar_9, -(LIGHT_GIVEN_DIRECTION))
   + 0.5) * 0.7), 0.0);
  nl2_2 = (tmpvar_12 * tmpvar_12);
  nl2_2 = (nl2_2 * nl2_2);
  nl2_2 = (nl2_2 * nl2_2);
  backLight_1 = ((nl2_2 * LIGHT_COLOR) * (mainColor_4 * mainNormal_5.z));
  backLight_1 = (backLight_1 / (vec3(1.0, 1.0, 1.0) + backLight_1));
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = (backLight_1 * mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, 
    max (dot (tmpvar_9, normalize((CAMERA_WORLDPOSITION - tmpvar_6))), 0.0)
  , 
    (1.0 - specular_3.z)
  ))));
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform highp vec4 ShadeColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec3 backLight_1;
  highp float nl2_2;
  highp vec3 specular_3;
  highp vec3 mainColor_4;
  highp vec3 mainNormal_5;
  highp vec3 tmpvar_6;
  tmpvar_6.x = xlv_TEXCOORD1.w;
  tmpvar_6.y = xlv_TEXCOORD2.w;
  tmpvar_6.z = xlv_TEXCOORD3.w;
  lowp vec3 tmpvar_7;
  tmpvar_7 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_5 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = ((mainNormal_5 * 2.0) - 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(((
    (tmpvar_8.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_8.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_8.z * xlv_TEXCOORD1.xyz)));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_4 = tmpvar_10;
  mainColor_4 = (mainColor_4 * mainColor_4);
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_3 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = max (((
    dot (tmpvar_9, -(LIGHT_GIVEN_DIRECTION))
   + 0.5) * 0.7), 0.0);
  nl2_2 = (tmpvar_12 * tmpvar_12);
  nl2_2 = (nl2_2 * nl2_2);
  nl2_2 = (nl2_2 * nl2_2);
  backLight_1 = ((nl2_2 * LIGHT_COLOR) * (mainColor_4 * mainNormal_5.z));
  backLight_1 = (backLight_1 / (vec3(1.0, 1.0, 1.0) + backLight_1));
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = (backLight_1 * mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, 
    max (dot (tmpvar_9, normalize((CAMERA_WORLDPOSITION - tmpvar_6))), 0.0)
  , 
    (1.0 - specular_3.z)
  ))));
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"SpotLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_9[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_9[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform highp vec4 ShadeColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec3 backLight_1;
  highp float nl2_2;
  highp vec3 specular_3;
  highp vec3 mainColor_4;
  highp vec3 mainNormal_5;
  highp vec3 tmpvar_6;
  tmpvar_6.x = xlv_TEXCOORD1.w;
  tmpvar_6.y = xlv_TEXCOORD2.w;
  tmpvar_6.z = xlv_TEXCOORD3.w;
  lowp vec3 tmpvar_7;
  tmpvar_7 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_5 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = ((mainNormal_5 * 2.0) - 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(((
    (tmpvar_8.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_8.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_8.z * xlv_TEXCOORD1.xyz)));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_4 = tmpvar_10;
  mainColor_4 = (mainColor_4 * mainColor_4);
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_3 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = max (((
    dot (tmpvar_9, -(LIGHT_GIVEN_DIRECTION))
   + 0.5) * 0.7), 0.0);
  nl2_2 = (tmpvar_12 * tmpvar_12);
  nl2_2 = (nl2_2 * nl2_2);
  nl2_2 = (nl2_2 * nl2_2);
  backLight_1 = ((nl2_2 * LIGHT_COLOR) * (mainColor_4 * mainNormal_5.z));
  backLight_1 = (backLight_1 / (vec3(1.0, 1.0, 1.0) + backLight_1));
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = (backLight_1 * mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, 
    max (dot (tmpvar_9, normalize((CAMERA_WORLDPOSITION - tmpvar_6))), 0.0)
  , 
    (1.0 - specular_3.z)
  ))));
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  tmpvar_5.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform highp vec4 ShadeColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec3 backLight_1;
  highp float nl2_2;
  highp vec3 specular_3;
  highp vec3 mainColor_4;
  highp vec3 mainNormal_5;
  highp vec3 tmpvar_6;
  tmpvar_6.x = xlv_TEXCOORD1.w;
  tmpvar_6.y = xlv_TEXCOORD2.w;
  tmpvar_6.z = xlv_TEXCOORD3.w;
  lowp vec3 tmpvar_7;
  tmpvar_7 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_5 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = ((mainNormal_5 * 2.0) - 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(((
    (tmpvar_8.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_8.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_8.z * xlv_TEXCOORD1.xyz)));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_4 = tmpvar_10;
  mainColor_4 = (mainColor_4 * mainColor_4);
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_3 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = max (((
    dot (tmpvar_9, -(LIGHT_GIVEN_DIRECTION))
   + 0.5) * 0.7), 0.0);
  nl2_2 = (tmpvar_12 * tmpvar_12);
  nl2_2 = (nl2_2 * nl2_2);
  nl2_2 = (nl2_2 * nl2_2);
  backLight_1 = ((nl2_2 * LIGHT_COLOR) * (mainColor_4 * mainNormal_5.z));
  backLight_1 = (backLight_1 / (vec3(1.0, 1.0, 1.0) + backLight_1));
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = (backLight_1 * mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, 
    max (dot (tmpvar_9, normalize((CAMERA_WORLDPOSITION - tmpvar_6))), 0.0)
  , 
    (1.0 - specular_3.z)
  ))));
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  tmpvar_5.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform highp vec4 ShadeColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec3 backLight_1;
  highp float nl2_2;
  highp vec3 specular_3;
  highp vec3 mainColor_4;
  highp vec3 mainNormal_5;
  highp vec3 tmpvar_6;
  tmpvar_6.x = xlv_TEXCOORD1.w;
  tmpvar_6.y = xlv_TEXCOORD2.w;
  tmpvar_6.z = xlv_TEXCOORD3.w;
  lowp vec3 tmpvar_7;
  tmpvar_7 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_5 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = ((mainNormal_5 * 2.0) - 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(((
    (tmpvar_8.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_8.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_8.z * xlv_TEXCOORD1.xyz)));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_4 = tmpvar_10;
  mainColor_4 = (mainColor_4 * mainColor_4);
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_3 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = max (((
    dot (tmpvar_9, -(LIGHT_GIVEN_DIRECTION))
   + 0.5) * 0.7), 0.0);
  nl2_2 = (tmpvar_12 * tmpvar_12);
  nl2_2 = (nl2_2 * nl2_2);
  nl2_2 = (nl2_2 * nl2_2);
  backLight_1 = ((nl2_2 * LIGHT_COLOR) * (mainColor_4 * mainNormal_5.z));
  backLight_1 = (backLight_1 / (vec3(1.0, 1.0, 1.0) + backLight_1));
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = (backLight_1 * mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, 
    max (dot (tmpvar_9, normalize((CAMERA_WORLDPOSITION - tmpvar_6))), 0.0)
  , 
    (1.0 - specular_3.z)
  ))));
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  tmpvar_5.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform highp vec4 ShadeColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec3 backLight_1;
  highp float nl2_2;
  highp vec3 specular_3;
  highp vec3 mainColor_4;
  highp vec3 mainNormal_5;
  highp vec3 tmpvar_6;
  tmpvar_6.x = xlv_TEXCOORD1.w;
  tmpvar_6.y = xlv_TEXCOORD2.w;
  tmpvar_6.z = xlv_TEXCOORD3.w;
  lowp vec3 tmpvar_7;
  tmpvar_7 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_5 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = ((mainNormal_5 * 2.0) - 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(((
    (tmpvar_8.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_8.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_8.z * xlv_TEXCOORD1.xyz)));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_4 = tmpvar_10;
  mainColor_4 = (mainColor_4 * mainColor_4);
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_3 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = max (((
    dot (tmpvar_9, -(LIGHT_GIVEN_DIRECTION))
   + 0.5) * 0.7), 0.0);
  nl2_2 = (tmpvar_12 * tmpvar_12);
  nl2_2 = (nl2_2 * nl2_2);
  nl2_2 = (nl2_2 * nl2_2);
  backLight_1 = ((nl2_2 * LIGHT_COLOR) * (mainColor_4 * mainNormal_5.z));
  backLight_1 = (backLight_1 / (vec3(1.0, 1.0, 1.0) + backLight_1));
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = (backLight_1 * mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, 
    max (dot (tmpvar_9, normalize((CAMERA_WORLDPOSITION - tmpvar_6))), 0.0)
  , 
    (1.0 - specular_3.z)
  ))));
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  tmpvar_5.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform highp vec4 ShadeColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec3 backLight_1;
  highp float nl2_2;
  highp vec3 specular_3;
  highp vec3 mainColor_4;
  highp vec3 mainNormal_5;
  highp vec3 tmpvar_6;
  tmpvar_6.x = xlv_TEXCOORD1.w;
  tmpvar_6.y = xlv_TEXCOORD2.w;
  tmpvar_6.z = xlv_TEXCOORD3.w;
  lowp vec3 tmpvar_7;
  tmpvar_7 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_5 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = ((mainNormal_5 * 2.0) - 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(((
    (tmpvar_8.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_8.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_8.z * xlv_TEXCOORD1.xyz)));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_4 = tmpvar_10;
  mainColor_4 = (mainColor_4 * mainColor_4);
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_3 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = max (((
    dot (tmpvar_9, -(LIGHT_GIVEN_DIRECTION))
   + 0.5) * 0.7), 0.0);
  nl2_2 = (tmpvar_12 * tmpvar_12);
  nl2_2 = (nl2_2 * nl2_2);
  nl2_2 = (nl2_2 * nl2_2);
  backLight_1 = ((nl2_2 * LIGHT_COLOR) * (mainColor_4 * mainNormal_5.z));
  backLight_1 = (backLight_1 / (vec3(1.0, 1.0, 1.0) + backLight_1));
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = (backLight_1 * mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, 
    max (dot (tmpvar_9, normalize((CAMERA_WORLDPOSITION - tmpvar_6))), 0.0)
  , 
    (1.0 - specular_3.z)
  ))));
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"PointLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_9[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_9[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform highp vec4 ShadeColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec3 backLight_1;
  highp float nl2_2;
  highp vec3 specular_3;
  highp vec3 mainColor_4;
  highp vec3 mainNormal_5;
  highp vec3 tmpvar_6;
  tmpvar_6.x = xlv_TEXCOORD1.w;
  tmpvar_6.y = xlv_TEXCOORD2.w;
  tmpvar_6.z = xlv_TEXCOORD3.w;
  lowp vec3 tmpvar_7;
  tmpvar_7 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_5 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = ((mainNormal_5 * 2.0) - 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(((
    (tmpvar_8.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_8.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_8.z * xlv_TEXCOORD1.xyz)));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_4 = tmpvar_10;
  mainColor_4 = (mainColor_4 * mainColor_4);
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_3 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = max (((
    dot (tmpvar_9, -(LIGHT_GIVEN_DIRECTION))
   + 0.5) * 0.7), 0.0);
  nl2_2 = (tmpvar_12 * tmpvar_12);
  nl2_2 = (nl2_2 * nl2_2);
  nl2_2 = (nl2_2 * nl2_2);
  backLight_1 = ((nl2_2 * LIGHT_COLOR) * (mainColor_4 * mainNormal_5.z));
  backLight_1 = (backLight_1 / (vec3(1.0, 1.0, 1.0) + backLight_1));
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = (backLight_1 * mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, 
    max (dot (tmpvar_9, normalize((CAMERA_WORLDPOSITION - tmpvar_6))), 0.0)
  , 
    (1.0 - specular_3.z)
  ))));
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"PointLight","ShadowOn"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NormalTexture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SpecularTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ShadeColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_9[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_9[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D MainTex;
uniform sampler2D NormalTexture;
uniform sampler2D SpecularTex;
uniform highp vec4 ShadeColor;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec3 backLight_1;
  highp float nl2_2;
  highp vec3 specular_3;
  highp vec3 mainColor_4;
  highp vec3 mainNormal_5;
  highp vec3 tmpvar_6;
  tmpvar_6.x = xlv_TEXCOORD1.w;
  tmpvar_6.y = xlv_TEXCOORD2.w;
  tmpvar_6.z = xlv_TEXCOORD3.w;
  lowp vec3 tmpvar_7;
  tmpvar_7 = texture (NormalTexture, xlv_TEXCOORD0).xyz;
  mainNormal_5 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = ((mainNormal_5 * 2.0) - 1.0);
  highp vec3 tmpvar_9;
  tmpvar_9 = normalize(((
    (tmpvar_8.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_8.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_8.z * xlv_TEXCOORD1.xyz)));
  lowp vec3 tmpvar_10;
  tmpvar_10 = texture (MainTex, xlv_TEXCOORD0).xyz;
  mainColor_4 = tmpvar_10;
  mainColor_4 = (mainColor_4 * mainColor_4);
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture (SpecularTex, xlv_TEXCOORD0).xyz;
  specular_3 = tmpvar_11;
  highp float tmpvar_12;
  tmpvar_12 = max (((
    dot (tmpvar_9, -(LIGHT_GIVEN_DIRECTION))
   + 0.5) * 0.7), 0.0);
  nl2_2 = (tmpvar_12 * tmpvar_12);
  nl2_2 = (nl2_2 * nl2_2);
  nl2_2 = (nl2_2 * nl2_2);
  backLight_1 = ((nl2_2 * LIGHT_COLOR) * (mainColor_4 * mainNormal_5.z));
  backLight_1 = (backLight_1 / (vec3(1.0, 1.0, 1.0) + backLight_1));
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = (backLight_1 * mix (ShadeColor.xyz, vec3(1.0, 1.0, 1.0), vec3(mix (1.0, 
    max (dot (tmpvar_9, normalize((CAMERA_WORLDPOSITION - tmpvar_6))), 0.0)
  , 
    (1.0 - specular_3.z)
  ))));
  _glesFragData[0] = tmpvar_13;
}

]===],
	},
}


end

function Depth()

	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { DEPTHPASS }

	
Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
void main ()
{
  highp vec4 row2_1;
  highp vec4 row1_2;
  highp vec4 row0_3;
  highp int tmpvar_4;
  tmpvar_4 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.w) * 3);
  row0_3 = (ANIMATION_MATRIX_ARRAY[tmpvar_4] * _glesBlendWeight.x);
  row1_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 1)] * _glesBlendWeight.x);
  row2_1 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 2)] * _glesBlendWeight.x);
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.y));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.y));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.y));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.z));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.z));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.z));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.w));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.w));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_8;
  tmpvar_8[uint(0)].x = row0_3.x;
  tmpvar_8[uint(0)].y = row0_3.y;
  tmpvar_8[uint(0)].z = row0_3.z;
  tmpvar_8[uint(0)].w = row0_3.w;
  tmpvar_8[1u].x = row1_2.x;
  tmpvar_8[1u].y = row1_2.y;
  tmpvar_8[1u].z = row1_2.z;
  tmpvar_8[1u].w = row1_2.w;
  tmpvar_8[2u].x = row2_1.x;
  tmpvar_8[2u].y = row2_1.y;
  tmpvar_8[2u].z = row2_1.z;
  tmpvar_8[2u].w = row2_1.w;
  tmpvar_8[3u].x = 0.0;
  tmpvar_8[3u].y = 0.0;
  tmpvar_8[3u].z = 0.0;
  tmpvar_8[3u].w = 1.0;
  highp vec4 tmpvar_9;
  tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_8)));
  highp vec4 clipPos_10;
  clipPos_10.xyw = tmpvar_9.xyw;
  clipPos_10.z = (tmpvar_9.z + (LIGHT_PARAM.x / tmpvar_9.w));
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  gl_Position = (tmpvar_11 * clipPos_10);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
void main ()
{
  _glesFragData[0] = vec4(0.0, 0.0, 0.0, 1.0);
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 LIGHT_PARAM;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = _glesVertex.xyz;
  tmpvar_1 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2));
  highp vec4 clipPos_3;
  clipPos_3.xyw = tmpvar_1.xyw;
  clipPos_3.z = (tmpvar_1.z + (LIGHT_PARAM.x / tmpvar_1.w));
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  gl_Position = (tmpvar_4 * clipPos_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
void main ()
{
  _glesFragData[0] = vec4(0.0, 0.0, 0.0, 1.0);
}

]===],
	},
}

end