function DefineParams()
	Properties = 
	{
		
DiffuseTex= { "Texture Diffuse", TEXTURE2D, "white" },
TexNormal = {"Texture Normal", TEXTURE2D, "white"},
TexSpecular = {"Texture Specular", TEXTURE2D, "white"},
TexBRDF = {"Texture BRDF", TEXTURE2D, "white"},
TexSkybox = {"Texture SkyBox", TEXTURECUBE, "black"},

ColorShade = {"Shade Color", COLOR, "0.0,0.0,0.0,1.0"},
ColorShadow = {"Shadow Color", COLOR, "0.0,0.0,0.0,1.0"},
ColorSpecular = {"Specular Color", COLOR, "0.0,0.0,0.0,1.0"},

SkinTint = {"Skin Tint", COLOR, "0.0,0.0,0.0,1.0"},
SkinTintMaskTex = {"Skin Mask", TEXTURE2D, "white"},

SkinColor = {"Skin Color", COLOR, "0.933, 0.859, 0.804, 1.0"},


RegionRTint = {"Region Tint R", COLOR, "0.0,0.0,0.0,1.0"},
RegionGTint = {"Region Tint G", COLOR, "0.0,0.0,0.0,1.0"},
RegionBTint = {"Region Tint B", COLOR, "0.0,0.0,0.0,1.0"},
RegionTintMaskTex = { "Region Mask", TEXTURE2D, "white" },
RegionTintBlend = {"Region Blend Strength", VEC3, "1.0,1.0,1.0"},

Fresnel = { "Fresnel", FLOAT, "0.5" },
extraShadeRange = { "extraShadeRange", FLOAT, "0.5" },

LightDir = { "Light Dir", VEC3, "0.0,0.0,1.0" },
LightColor = { "Lighit Color", COLOR, "1.0,1.0,1.0, 1.0" },
LightIntensity = {"Light Intensity", FLOAT, "1.0" },


	}
	Attributes = 
	{
	}
	
end

  

function Init()
	PassNames = 
	{
		"ForwardBase","Depth"
	}

ShaderName = "CustomSkin_Mask"
RenderQueue = "Opaque"
end

function ForwardBase()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexNormal",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSpecular",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexBRDF",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSkybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorShade",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorSpecular",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionRTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionGTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionBTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintBlend",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[uint(0)].x = row0_6.x;
  tmpvar_11[uint(0)].y = row0_6.y;
  tmpvar_11[uint(0)].z = row0_6.z;
  tmpvar_11[uint(0)].w = row0_6.w;
  tmpvar_11[1u].x = row1_5.x;
  tmpvar_11[1u].y = row1_5.y;
  tmpvar_11[1u].z = row1_5.z;
  tmpvar_11[1u].w = row1_5.w;
  tmpvar_11[2u].x = row2_4.x;
  tmpvar_11[2u].y = row2_4.y;
  tmpvar_11[2u].z = row2_4.z;
  tmpvar_11[2u].w = row2_4.w;
  tmpvar_11[3u].x = 0.0;
  tmpvar_11[3u].y = 0.0;
  tmpvar_11[3u].z = 0.0;
  tmpvar_11[3u].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_14[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_14[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_15[1u] = tmpvar_11[1u].xyz;
  tmpvar_15[2u] = tmpvar_11[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_17[1u] = tmpvar_11[1u].xyz;
  tmpvar_17[2u] = tmpvar_11[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_19[1u] = tmpvar_11[1u].xyz;
  tmpvar_19[2u] = tmpvar_11[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D DiffuseTex;
uniform sampler2D TexNormal;
uniform sampler2D TexSpecular;
uniform sampler2D TexBRDF;
uniform lowp samplerCube TexSkybox;
uniform sampler2D RegionTintMaskTex;
uniform sampler2D SkinTintMaskTex;
uniform highp vec4 ColorShade;
uniform highp vec4 ColorSpecular;
uniform highp vec4 SkinTint;
uniform highp vec4 SkinColor;
uniform highp vec4 RegionRTint;
uniform highp vec4 RegionGTint;
uniform highp vec4 RegionBTint;
uniform highp vec3 RegionTintBlend;
uniform highp float Fresnel;
uniform highp vec3 LightDir;
uniform highp vec4 LightColor;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 backLight_4;
  highp float nl2_5;
  highp vec3 brdfColor_6;
  highp vec3 specular_7;
  highp vec3 regionMaskColor_8;
  highp vec3 mainColor_9;
  highp vec4 color_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (TexNormal, xlv_TEXCOORD0).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((
    (tmpvar_15.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_15.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_15.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_17;
  tmpvar_17 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_18;
  tmpvar_18 = normalize(LightDir);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_16, tmpvar_13), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_16, normalize(
    (tmpvar_13 + tmpvar_17)
  )), 0.0);
  lowp vec4 tmpvar_21;
  tmpvar_21 = texture (DiffuseTex, xlv_TEXCOORD0);
  color_10 = tmpvar_21;
  mainColor_9 = color_10.xyz;
  highp float tmpvar_22;
  tmpvar_22 = color_10.w;
  highp float tmpvar_23;
  if ((SkinColor.x > 0.04045)) {
    tmpvar_23 = pow (((SkinColor.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_23 = (SkinColor.x / 12.92);
  };
  highp float tmpvar_24;
  if ((SkinColor.y > 0.04045)) {
    tmpvar_24 = pow (((SkinColor.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_24 = (SkinColor.y / 12.92);
  };
  highp float tmpvar_25;
  if ((SkinColor.z > 0.04045)) {
    tmpvar_25 = pow (((SkinColor.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_25 = (SkinColor.z / 12.92);
  };
  highp float tmpvar_26;
  tmpvar_26 = (((
    (tmpvar_23 * 0.4124564)
   + 
    (tmpvar_24 * 0.3575761)
  ) + (tmpvar_25 * 0.1804375)) / 0.950456);
  highp float tmpvar_27;
  tmpvar_27 = (((tmpvar_23 * 0.2126729) + (tmpvar_24 * 0.7151522)) + (tmpvar_25 * 0.072175));
  highp float tmpvar_28;
  tmpvar_28 = (((
    (tmpvar_23 * 0.0193339)
   + 
    (tmpvar_24 * 0.119192)
  ) + (tmpvar_25 * 0.9503041)) / 1.088754);
  highp float tmpvar_29;
  if ((tmpvar_26 > 0.008856)) {
    tmpvar_29 = pow (tmpvar_26, 0.3333333);
  } else {
    tmpvar_29 = (((903.3 * tmpvar_26) + 16.0) / 116.0);
  };
  highp float tmpvar_30;
  if ((tmpvar_27 > 0.008856)) {
    tmpvar_30 = pow (tmpvar_27, 0.3333333);
  } else {
    tmpvar_30 = (((903.3 * tmpvar_27) + 16.0) / 116.0);
  };
  highp float tmpvar_31;
  if ((tmpvar_28 > 0.008856)) {
    tmpvar_31 = pow (tmpvar_28, 0.3333333);
  } else {
    tmpvar_31 = (((903.3 * tmpvar_28) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_32;
  tmpvar_32.x = (((116.0 * tmpvar_30) - 16.0) / 100.0);
  tmpvar_32.y = (((500.0 * 
    (tmpvar_29 - tmpvar_30)
  ) + 110.0) / 220.0);
  tmpvar_32.z = (((200.0 * 
    (tmpvar_30 - tmpvar_31)
  ) + 110.0) / 220.0);
  highp float tmpvar_33;
  if ((SkinTint.x > 0.04045)) {
    tmpvar_33 = pow (((SkinTint.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_33 = (SkinTint.x / 12.92);
  };
  highp float tmpvar_34;
  if ((SkinTint.y > 0.04045)) {
    tmpvar_34 = pow (((SkinTint.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_34 = (SkinTint.y / 12.92);
  };
  highp float tmpvar_35;
  if ((SkinTint.z > 0.04045)) {
    tmpvar_35 = pow (((SkinTint.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_35 = (SkinTint.z / 12.92);
  };
  highp float tmpvar_36;
  tmpvar_36 = (((
    (tmpvar_33 * 0.4124564)
   + 
    (tmpvar_34 * 0.3575761)
  ) + (tmpvar_35 * 0.1804375)) / 0.950456);
  highp float tmpvar_37;
  tmpvar_37 = (((tmpvar_33 * 0.2126729) + (tmpvar_34 * 0.7151522)) + (tmpvar_35 * 0.072175));
  highp float tmpvar_38;
  tmpvar_38 = (((
    (tmpvar_33 * 0.0193339)
   + 
    (tmpvar_34 * 0.119192)
  ) + (tmpvar_35 * 0.9503041)) / 1.088754);
  highp float tmpvar_39;
  if ((tmpvar_36 > 0.008856)) {
    tmpvar_39 = pow (tmpvar_36, 0.3333333);
  } else {
    tmpvar_39 = (((903.3 * tmpvar_36) + 16.0) / 116.0);
  };
  highp float tmpvar_40;
  if ((tmpvar_37 > 0.008856)) {
    tmpvar_40 = pow (tmpvar_37, 0.3333333);
  } else {
    tmpvar_40 = (((903.3 * tmpvar_37) + 16.0) / 116.0);
  };
  highp float tmpvar_41;
  if ((tmpvar_38 > 0.008856)) {
    tmpvar_41 = pow (tmpvar_38, 0.3333333);
  } else {
    tmpvar_41 = (((903.3 * tmpvar_38) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_42;
  tmpvar_42.x = (((116.0 * tmpvar_40) - 16.0) / 100.0);
  tmpvar_42.y = (((500.0 * 
    (tmpvar_39 - tmpvar_40)
  ) + 110.0) / 220.0);
  tmpvar_42.z = (((200.0 * 
    (tmpvar_40 - tmpvar_41)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_43;
  tmpvar_43 = (tmpvar_42 - tmpvar_32);
  highp float tmpvar_44;
  if ((color_10.x > 0.04045)) {
    tmpvar_44 = pow (((color_10.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_44 = (color_10.x / 12.92);
  };
  highp float tmpvar_45;
  if ((color_10.y > 0.04045)) {
    tmpvar_45 = pow (((color_10.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_45 = (color_10.y / 12.92);
  };
  highp float tmpvar_46;
  if ((color_10.z > 0.04045)) {
    tmpvar_46 = pow (((color_10.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_46 = (color_10.z / 12.92);
  };
  highp float tmpvar_47;
  tmpvar_47 = (((
    (tmpvar_44 * 0.4124564)
   + 
    (tmpvar_45 * 0.3575761)
  ) + (tmpvar_46 * 0.1804375)) / 0.950456);
  highp float tmpvar_48;
  tmpvar_48 = (((tmpvar_44 * 0.2126729) + (tmpvar_45 * 0.7151522)) + (tmpvar_46 * 0.072175));
  highp float tmpvar_49;
  tmpvar_49 = (((
    (tmpvar_44 * 0.0193339)
   + 
    (tmpvar_45 * 0.119192)
  ) + (tmpvar_46 * 0.9503041)) / 1.088754);
  highp float tmpvar_50;
  if ((tmpvar_47 > 0.008856)) {
    tmpvar_50 = pow (tmpvar_47, 0.3333333);
  } else {
    tmpvar_50 = (((903.3 * tmpvar_47) + 16.0) / 116.0);
  };
  highp float tmpvar_51;
  if ((tmpvar_48 > 0.008856)) {
    tmpvar_51 = pow (tmpvar_48, 0.3333333);
  } else {
    tmpvar_51 = (((903.3 * tmpvar_48) + 16.0) / 116.0);
  };
  highp float tmpvar_52;
  if ((tmpvar_49 > 0.008856)) {
    tmpvar_52 = pow (tmpvar_49, 0.3333333);
  } else {
    tmpvar_52 = (((903.3 * tmpvar_49) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_53;
  tmpvar_53.x = (((116.0 * tmpvar_51) - 16.0) / 100.0);
  tmpvar_53.y = (((500.0 * 
    (tmpvar_50 - tmpvar_51)
  ) + 110.0) / 220.0);
  tmpvar_53.z = (((200.0 * 
    (tmpvar_51 - tmpvar_52)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_54;
  tmpvar_54 = clamp ((tmpvar_53 + tmpvar_43), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float z_55;
  highp float x_56;
  highp float tmpvar_57;
  tmpvar_57 = (((tmpvar_54.x * 100.0) + 16.0) / 116.0);
  highp float tmpvar_58;
  tmpvar_58 = (((
    (tmpvar_54.y * 220.0)
   - 110.0) / 500.0) + tmpvar_57);
  x_56 = tmpvar_58;
  highp float tmpvar_59;
  tmpvar_59 = (tmpvar_57 - ((
    (tmpvar_54.z * 220.0)
   - 110.0) / 200.0));
  z_55 = tmpvar_59;
  highp float tmpvar_60;
  tmpvar_60 = pow (tmpvar_58, 3.0);
  highp float tmpvar_61;
  tmpvar_61 = pow (tmpvar_57, 3.0);
  highp float tmpvar_62;
  tmpvar_62 = pow (tmpvar_59, 3.0);
  highp float tmpvar_63;
  if ((tmpvar_60 > 0.008856)) {
    tmpvar_63 = tmpvar_60;
  } else {
    tmpvar_63 = ((tmpvar_58 - 0.137931) / 7.787069);
  };
  x_56 = (tmpvar_63 * 0.950456);
  highp float tmpvar_64;
  if ((tmpvar_61 > 0.008856)) {
    tmpvar_64 = tmpvar_61;
  } else {
    tmpvar_64 = ((tmpvar_57 - 0.137931) / 7.787069);
  };
  highp float tmpvar_65;
  if ((tmpvar_62 > 0.008856)) {
    tmpvar_65 = tmpvar_62;
  } else {
    tmpvar_65 = ((tmpvar_59 - 0.137931) / 7.787069);
  };
  z_55 = (tmpvar_65 * 1.088754);
  highp float tmpvar_66;
  tmpvar_66 = (((x_56 * 3.240454) + (tmpvar_64 * -1.537138)) + (z_55 * -0.4985314));
  highp float tmpvar_67;
  tmpvar_67 = (((x_56 * -0.969266) + (tmpvar_64 * 1.876011)) + (z_55 * 0.041556));
  highp float tmpvar_68;
  tmpvar_68 = (((x_56 * 0.0556434) + (tmpvar_64 * -0.2040259)) + (z_55 * 1.057225));
  highp float tmpvar_69;
  if ((tmpvar_66 > 0.0031308)) {
    tmpvar_69 = ((1.055 * pow (tmpvar_66, 0.4166667)) - 0.055);
  } else {
    tmpvar_69 = (12.92 * tmpvar_66);
  };
  highp float tmpvar_70;
  if ((tmpvar_67 > 0.0031308)) {
    tmpvar_70 = ((1.055 * pow (tmpvar_67, 0.4166667)) - 0.055);
  } else {
    tmpvar_70 = (12.92 * tmpvar_67);
  };
  highp float tmpvar_71;
  if ((tmpvar_68 > 0.0031308)) {
    tmpvar_71 = ((1.055 * pow (tmpvar_68, 0.4166667)) - 0.055);
  } else {
    tmpvar_71 = (12.92 * tmpvar_68);
  };
  highp vec3 tmpvar_72;
  tmpvar_72.x = tmpvar_69;
  tmpvar_72.y = tmpvar_70;
  tmpvar_72.z = tmpvar_71;
  lowp vec3 tmpvar_73;
  tmpvar_73 = texture (SkinTintMaskTex, xlv_TEXCOORD0).xxx;
  highp vec3 tmpvar_74;
  tmpvar_74 = mix (color_10.xyz, tmpvar_72, tmpvar_73);
  mainColor_9 = (tmpvar_74 * tmpvar_74);
  lowp vec3 tmpvar_75;
  tmpvar_75 = texture (RegionTintMaskTex, xlv_TEXCOORD0).xyz;
  regionMaskColor_8 = tmpvar_75;
  highp vec4 tmpvar_76;
  tmpvar_76.w = 0.0;
  tmpvar_76.xyz = mainColor_9;
  highp vec4 tmpvar_77;
  tmpvar_77.w = 0.0;
  tmpvar_77.xyz = mainColor_9;
  highp vec4 tmpvar_78;
  tmpvar_78.w = 0.0;
  tmpvar_78.xyz = mainColor_9;
  mainColor_9 = (((
    (mainColor_9 * (1.0 - ((regionMaskColor_8.x + regionMaskColor_8.y) + regionMaskColor_8.z)))
   + 
    (mix (tmpvar_76, RegionRTint, RegionTintBlend.xxxx) * regionMaskColor_8.x)
  .xyz) + (
    mix (tmpvar_77, RegionGTint, RegionTintBlend.yyyy)
   * regionMaskColor_8.y).xyz) + (mix (tmpvar_78, RegionBTint, RegionTintBlend.zzzz) * regionMaskColor_8.z).xyz);
  lowp vec3 tmpvar_79;
  tmpvar_79 = texture (TexSpecular, xlv_TEXCOORD0).xyz;
  specular_7 = tmpvar_79;
  highp float tmpvar_80;
  tmpvar_80 = (1.0 - specular_7.x);
  highp vec2 tmpvar_81;
  tmpvar_81.x = (((
    dot (tmpvar_16, tmpvar_17)
   * 0.5) + 0.5) * 0.99);
  tmpvar_81.y = specular_7.y;
  lowp vec3 tmpvar_82;
  tmpvar_82 = texture (TexBRDF, tmpvar_81).xyz;
  brdfColor_6 = tmpvar_82;
  highp float tmpvar_83;
  tmpvar_83 = max (((
    dot (tmpvar_16, tmpvar_18)
   + 0.5) * 0.7), 0.0);
  nl2_5 = (tmpvar_83 * tmpvar_83);
  nl2_5 = (nl2_5 * nl2_5);
  nl2_5 = (nl2_5 * nl2_5);
  backLight_4 = ((nl2_5 * LightColor.xyz) * ((LightIntensity * mainColor_9) * mainNormal_11.z));
  backLight_4 = (backLight_4 / (vec3(1.0, 1.0, 1.0) + backLight_4));
  highp vec3 I_84;
  I_84 = -(tmpvar_13);
  reflectDir_3.xyz = (I_84 - (2.0 * (
    dot (tmpvar_16, I_84)
   * tmpvar_16)));
  reflectDir_3.w = (tmpvar_80 * 4.0);
  lowp vec4 tmpvar_85;
  tmpvar_85 = textureLod (TexSkybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_86;
  tmpvar_86 = tmpvar_85;
  iblColor_2.w = tmpvar_86.w;
  iblColor_2.xyz = ((tmpvar_86.xyz * tmpvar_86.w) * 4.0);
  highp float tmpvar_87;
  tmpvar_87 = max ((tmpvar_80 * tmpvar_80), 0.1);
  highp float tmpvar_88;
  tmpvar_88 = (tmpvar_87 * tmpvar_87);
  highp float tmpvar_89;
  tmpvar_89 = (((
    (tmpvar_20 * tmpvar_88)
   - tmpvar_20) * tmpvar_20) + 1.0);
  d_1 = ((0.3183099 * tmpvar_88) / ((tmpvar_89 * tmpvar_89) + 1e-7));
  highp float tmpvar_90;
  tmpvar_90 = min (d_1, 100.0);
  d_1 = tmpvar_90;
  highp vec4 tmpvar_91;
  tmpvar_91.xyz = (((
    ((tmpvar_90 * mix (Fresnel, 1.0, (1.0 - tmpvar_19))) * LIGHT_COLOR)
   + 
    (((iblColor_2.xyz * 0.5) * ((
      (min ((Fresnel * 2.0), 1.0) - Fresnel)
     * 
      pow ((1.0 - tmpvar_19), 4.0)
    ) + Fresnel)) * AMBIENT_COLOR)
  ) * ColorSpecular.xyz) + ((
    (((brdfColor_6 * LIGHT_COLOR) * mainColor_9) + backLight_4)
   + 
    (AMBIENT_COLOR * mainColor_9)
  ) * mix (ColorShade.xyz, vec3(1.0, 1.0, 1.0), vec3(
    mix (1.0, tmpvar_19, (1.0 - specular_7.z))
  ))));
  tmpvar_91.w = tmpvar_22;
  _glesFragData[0] = tmpvar_91;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexNormal",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSpecular",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexBRDF",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSkybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorShade",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorSpecular",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionRTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionGTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionBTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintBlend",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[uint(0)].x = row0_6.x;
  tmpvar_11[uint(0)].y = row0_6.y;
  tmpvar_11[uint(0)].z = row0_6.z;
  tmpvar_11[uint(0)].w = row0_6.w;
  tmpvar_11[1u].x = row1_5.x;
  tmpvar_11[1u].y = row1_5.y;
  tmpvar_11[1u].z = row1_5.z;
  tmpvar_11[1u].w = row1_5.w;
  tmpvar_11[2u].x = row2_4.x;
  tmpvar_11[2u].y = row2_4.y;
  tmpvar_11[2u].z = row2_4.z;
  tmpvar_11[2u].w = row2_4.w;
  tmpvar_11[3u].x = 0.0;
  tmpvar_11[3u].y = 0.0;
  tmpvar_11[3u].z = 0.0;
  tmpvar_11[3u].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_14[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_14[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_15[1u] = tmpvar_11[1u].xyz;
  tmpvar_15[2u] = tmpvar_11[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_17[1u] = tmpvar_11[1u].xyz;
  tmpvar_17[2u] = tmpvar_11[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = tmpvar_11[uint(0)].xyz;
  tmpvar_19[1u] = tmpvar_11[1u].xyz;
  tmpvar_19[2u] = tmpvar_11[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D DiffuseTex;
uniform sampler2D TexNormal;
uniform sampler2D TexSpecular;
uniform sampler2D TexBRDF;
uniform lowp samplerCube TexSkybox;
uniform sampler2D RegionTintMaskTex;
uniform sampler2D SkinTintMaskTex;
uniform highp vec4 ColorShade;
uniform highp vec4 ColorSpecular;
uniform highp vec4 SkinTint;
uniform highp vec4 SkinColor;
uniform highp vec4 RegionRTint;
uniform highp vec4 RegionGTint;
uniform highp vec4 RegionBTint;
uniform highp vec3 RegionTintBlend;
uniform highp float Fresnel;
uniform highp vec3 LightDir;
uniform highp vec4 LightColor;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 backLight_4;
  highp float nl2_5;
  highp vec3 brdfColor_6;
  highp vec3 specular_7;
  highp vec3 regionMaskColor_8;
  highp vec3 mainColor_9;
  highp vec4 color_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (TexNormal, xlv_TEXCOORD0).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((
    (tmpvar_15.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_15.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_15.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_17;
  tmpvar_17 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_18;
  tmpvar_18 = normalize(LightDir);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_16, tmpvar_13), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_16, normalize(
    (tmpvar_13 + tmpvar_17)
  )), 0.0);
  lowp vec4 tmpvar_21;
  tmpvar_21 = texture (DiffuseTex, xlv_TEXCOORD0);
  color_10 = tmpvar_21;
  mainColor_9 = color_10.xyz;
  highp float tmpvar_22;
  tmpvar_22 = color_10.w;
  highp float tmpvar_23;
  if ((SkinColor.x > 0.04045)) {
    tmpvar_23 = pow (((SkinColor.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_23 = (SkinColor.x / 12.92);
  };
  highp float tmpvar_24;
  if ((SkinColor.y > 0.04045)) {
    tmpvar_24 = pow (((SkinColor.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_24 = (SkinColor.y / 12.92);
  };
  highp float tmpvar_25;
  if ((SkinColor.z > 0.04045)) {
    tmpvar_25 = pow (((SkinColor.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_25 = (SkinColor.z / 12.92);
  };
  highp float tmpvar_26;
  tmpvar_26 = (((
    (tmpvar_23 * 0.4124564)
   + 
    (tmpvar_24 * 0.3575761)
  ) + (tmpvar_25 * 0.1804375)) / 0.950456);
  highp float tmpvar_27;
  tmpvar_27 = (((tmpvar_23 * 0.2126729) + (tmpvar_24 * 0.7151522)) + (tmpvar_25 * 0.072175));
  highp float tmpvar_28;
  tmpvar_28 = (((
    (tmpvar_23 * 0.0193339)
   + 
    (tmpvar_24 * 0.119192)
  ) + (tmpvar_25 * 0.9503041)) / 1.088754);
  highp float tmpvar_29;
  if ((tmpvar_26 > 0.008856)) {
    tmpvar_29 = pow (tmpvar_26, 0.3333333);
  } else {
    tmpvar_29 = (((903.3 * tmpvar_26) + 16.0) / 116.0);
  };
  highp float tmpvar_30;
  if ((tmpvar_27 > 0.008856)) {
    tmpvar_30 = pow (tmpvar_27, 0.3333333);
  } else {
    tmpvar_30 = (((903.3 * tmpvar_27) + 16.0) / 116.0);
  };
  highp float tmpvar_31;
  if ((tmpvar_28 > 0.008856)) {
    tmpvar_31 = pow (tmpvar_28, 0.3333333);
  } else {
    tmpvar_31 = (((903.3 * tmpvar_28) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_32;
  tmpvar_32.x = (((116.0 * tmpvar_30) - 16.0) / 100.0);
  tmpvar_32.y = (((500.0 * 
    (tmpvar_29 - tmpvar_30)
  ) + 110.0) / 220.0);
  tmpvar_32.z = (((200.0 * 
    (tmpvar_30 - tmpvar_31)
  ) + 110.0) / 220.0);
  highp float tmpvar_33;
  if ((SkinTint.x > 0.04045)) {
    tmpvar_33 = pow (((SkinTint.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_33 = (SkinTint.x / 12.92);
  };
  highp float tmpvar_34;
  if ((SkinTint.y > 0.04045)) {
    tmpvar_34 = pow (((SkinTint.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_34 = (SkinTint.y / 12.92);
  };
  highp float tmpvar_35;
  if ((SkinTint.z > 0.04045)) {
    tmpvar_35 = pow (((SkinTint.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_35 = (SkinTint.z / 12.92);
  };
  highp float tmpvar_36;
  tmpvar_36 = (((
    (tmpvar_33 * 0.4124564)
   + 
    (tmpvar_34 * 0.3575761)
  ) + (tmpvar_35 * 0.1804375)) / 0.950456);
  highp float tmpvar_37;
  tmpvar_37 = (((tmpvar_33 * 0.2126729) + (tmpvar_34 * 0.7151522)) + (tmpvar_35 * 0.072175));
  highp float tmpvar_38;
  tmpvar_38 = (((
    (tmpvar_33 * 0.0193339)
   + 
    (tmpvar_34 * 0.119192)
  ) + (tmpvar_35 * 0.9503041)) / 1.088754);
  highp float tmpvar_39;
  if ((tmpvar_36 > 0.008856)) {
    tmpvar_39 = pow (tmpvar_36, 0.3333333);
  } else {
    tmpvar_39 = (((903.3 * tmpvar_36) + 16.0) / 116.0);
  };
  highp float tmpvar_40;
  if ((tmpvar_37 > 0.008856)) {
    tmpvar_40 = pow (tmpvar_37, 0.3333333);
  } else {
    tmpvar_40 = (((903.3 * tmpvar_37) + 16.0) / 116.0);
  };
  highp float tmpvar_41;
  if ((tmpvar_38 > 0.008856)) {
    tmpvar_41 = pow (tmpvar_38, 0.3333333);
  } else {
    tmpvar_41 = (((903.3 * tmpvar_38) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_42;
  tmpvar_42.x = (((116.0 * tmpvar_40) - 16.0) / 100.0);
  tmpvar_42.y = (((500.0 * 
    (tmpvar_39 - tmpvar_40)
  ) + 110.0) / 220.0);
  tmpvar_42.z = (((200.0 * 
    (tmpvar_40 - tmpvar_41)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_43;
  tmpvar_43 = (tmpvar_42 - tmpvar_32);
  highp float tmpvar_44;
  if ((color_10.x > 0.04045)) {
    tmpvar_44 = pow (((color_10.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_44 = (color_10.x / 12.92);
  };
  highp float tmpvar_45;
  if ((color_10.y > 0.04045)) {
    tmpvar_45 = pow (((color_10.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_45 = (color_10.y / 12.92);
  };
  highp float tmpvar_46;
  if ((color_10.z > 0.04045)) {
    tmpvar_46 = pow (((color_10.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_46 = (color_10.z / 12.92);
  };
  highp float tmpvar_47;
  tmpvar_47 = (((
    (tmpvar_44 * 0.4124564)
   + 
    (tmpvar_45 * 0.3575761)
  ) + (tmpvar_46 * 0.1804375)) / 0.950456);
  highp float tmpvar_48;
  tmpvar_48 = (((tmpvar_44 * 0.2126729) + (tmpvar_45 * 0.7151522)) + (tmpvar_46 * 0.072175));
  highp float tmpvar_49;
  tmpvar_49 = (((
    (tmpvar_44 * 0.0193339)
   + 
    (tmpvar_45 * 0.119192)
  ) + (tmpvar_46 * 0.9503041)) / 1.088754);
  highp float tmpvar_50;
  if ((tmpvar_47 > 0.008856)) {
    tmpvar_50 = pow (tmpvar_47, 0.3333333);
  } else {
    tmpvar_50 = (((903.3 * tmpvar_47) + 16.0) / 116.0);
  };
  highp float tmpvar_51;
  if ((tmpvar_48 > 0.008856)) {
    tmpvar_51 = pow (tmpvar_48, 0.3333333);
  } else {
    tmpvar_51 = (((903.3 * tmpvar_48) + 16.0) / 116.0);
  };
  highp float tmpvar_52;
  if ((tmpvar_49 > 0.008856)) {
    tmpvar_52 = pow (tmpvar_49, 0.3333333);
  } else {
    tmpvar_52 = (((903.3 * tmpvar_49) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_53;
  tmpvar_53.x = (((116.0 * tmpvar_51) - 16.0) / 100.0);
  tmpvar_53.y = (((500.0 * 
    (tmpvar_50 - tmpvar_51)
  ) + 110.0) / 220.0);
  tmpvar_53.z = (((200.0 * 
    (tmpvar_51 - tmpvar_52)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_54;
  tmpvar_54 = clamp ((tmpvar_53 + tmpvar_43), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float z_55;
  highp float x_56;
  highp float tmpvar_57;
  tmpvar_57 = (((tmpvar_54.x * 100.0) + 16.0) / 116.0);
  highp float tmpvar_58;
  tmpvar_58 = (((
    (tmpvar_54.y * 220.0)
   - 110.0) / 500.0) + tmpvar_57);
  x_56 = tmpvar_58;
  highp float tmpvar_59;
  tmpvar_59 = (tmpvar_57 - ((
    (tmpvar_54.z * 220.0)
   - 110.0) / 200.0));
  z_55 = tmpvar_59;
  highp float tmpvar_60;
  tmpvar_60 = pow (tmpvar_58, 3.0);
  highp float tmpvar_61;
  tmpvar_61 = pow (tmpvar_57, 3.0);
  highp float tmpvar_62;
  tmpvar_62 = pow (tmpvar_59, 3.0);
  highp float tmpvar_63;
  if ((tmpvar_60 > 0.008856)) {
    tmpvar_63 = tmpvar_60;
  } else {
    tmpvar_63 = ((tmpvar_58 - 0.137931) / 7.787069);
  };
  x_56 = (tmpvar_63 * 0.950456);
  highp float tmpvar_64;
  if ((tmpvar_61 > 0.008856)) {
    tmpvar_64 = tmpvar_61;
  } else {
    tmpvar_64 = ((tmpvar_57 - 0.137931) / 7.787069);
  };
  highp float tmpvar_65;
  if ((tmpvar_62 > 0.008856)) {
    tmpvar_65 = tmpvar_62;
  } else {
    tmpvar_65 = ((tmpvar_59 - 0.137931) / 7.787069);
  };
  z_55 = (tmpvar_65 * 1.088754);
  highp float tmpvar_66;
  tmpvar_66 = (((x_56 * 3.240454) + (tmpvar_64 * -1.537138)) + (z_55 * -0.4985314));
  highp float tmpvar_67;
  tmpvar_67 = (((x_56 * -0.969266) + (tmpvar_64 * 1.876011)) + (z_55 * 0.041556));
  highp float tmpvar_68;
  tmpvar_68 = (((x_56 * 0.0556434) + (tmpvar_64 * -0.2040259)) + (z_55 * 1.057225));
  highp float tmpvar_69;
  if ((tmpvar_66 > 0.0031308)) {
    tmpvar_69 = ((1.055 * pow (tmpvar_66, 0.4166667)) - 0.055);
  } else {
    tmpvar_69 = (12.92 * tmpvar_66);
  };
  highp float tmpvar_70;
  if ((tmpvar_67 > 0.0031308)) {
    tmpvar_70 = ((1.055 * pow (tmpvar_67, 0.4166667)) - 0.055);
  } else {
    tmpvar_70 = (12.92 * tmpvar_67);
  };
  highp float tmpvar_71;
  if ((tmpvar_68 > 0.0031308)) {
    tmpvar_71 = ((1.055 * pow (tmpvar_68, 0.4166667)) - 0.055);
  } else {
    tmpvar_71 = (12.92 * tmpvar_68);
  };
  highp vec3 tmpvar_72;
  tmpvar_72.x = tmpvar_69;
  tmpvar_72.y = tmpvar_70;
  tmpvar_72.z = tmpvar_71;
  lowp vec3 tmpvar_73;
  tmpvar_73 = texture (SkinTintMaskTex, xlv_TEXCOORD0).xxx;
  highp vec3 tmpvar_74;
  tmpvar_74 = mix (color_10.xyz, tmpvar_72, tmpvar_73);
  mainColor_9 = (tmpvar_74 * tmpvar_74);
  lowp vec3 tmpvar_75;
  tmpvar_75 = texture (RegionTintMaskTex, xlv_TEXCOORD0).xyz;
  regionMaskColor_8 = tmpvar_75;
  highp vec4 tmpvar_76;
  tmpvar_76.w = 0.0;
  tmpvar_76.xyz = mainColor_9;
  highp vec4 tmpvar_77;
  tmpvar_77.w = 0.0;
  tmpvar_77.xyz = mainColor_9;
  highp vec4 tmpvar_78;
  tmpvar_78.w = 0.0;
  tmpvar_78.xyz = mainColor_9;
  mainColor_9 = (((
    (mainColor_9 * (1.0 - ((regionMaskColor_8.x + regionMaskColor_8.y) + regionMaskColor_8.z)))
   + 
    (mix (tmpvar_76, RegionRTint, RegionTintBlend.xxxx) * regionMaskColor_8.x)
  .xyz) + (
    mix (tmpvar_77, RegionGTint, RegionTintBlend.yyyy)
   * regionMaskColor_8.y).xyz) + (mix (tmpvar_78, RegionBTint, RegionTintBlend.zzzz) * regionMaskColor_8.z).xyz);
  lowp vec3 tmpvar_79;
  tmpvar_79 = texture (TexSpecular, xlv_TEXCOORD0).xyz;
  specular_7 = tmpvar_79;
  highp float tmpvar_80;
  tmpvar_80 = (1.0 - specular_7.x);
  highp vec2 tmpvar_81;
  tmpvar_81.x = (((
    dot (tmpvar_16, tmpvar_17)
   * 0.5) + 0.5) * 0.99);
  tmpvar_81.y = specular_7.y;
  lowp vec3 tmpvar_82;
  tmpvar_82 = texture (TexBRDF, tmpvar_81).xyz;
  brdfColor_6 = tmpvar_82;
  highp float tmpvar_83;
  tmpvar_83 = max (((
    dot (tmpvar_16, tmpvar_18)
   + 0.5) * 0.7), 0.0);
  nl2_5 = (tmpvar_83 * tmpvar_83);
  nl2_5 = (nl2_5 * nl2_5);
  nl2_5 = (nl2_5 * nl2_5);
  backLight_4 = ((nl2_5 * LightColor.xyz) * ((LightIntensity * mainColor_9) * mainNormal_11.z));
  backLight_4 = (backLight_4 / (vec3(1.0, 1.0, 1.0) + backLight_4));
  highp vec3 I_84;
  I_84 = -(tmpvar_13);
  reflectDir_3.xyz = (I_84 - (2.0 * (
    dot (tmpvar_16, I_84)
   * tmpvar_16)));
  reflectDir_3.w = (tmpvar_80 * 4.0);
  lowp vec4 tmpvar_85;
  tmpvar_85 = textureLod (TexSkybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_86;
  tmpvar_86 = tmpvar_85;
  iblColor_2.w = tmpvar_86.w;
  iblColor_2.xyz = ((tmpvar_86.xyz * tmpvar_86.w) * 4.0);
  highp float tmpvar_87;
  tmpvar_87 = max ((tmpvar_80 * tmpvar_80), 0.1);
  highp float tmpvar_88;
  tmpvar_88 = (tmpvar_87 * tmpvar_87);
  highp float tmpvar_89;
  tmpvar_89 = (((
    (tmpvar_20 * tmpvar_88)
   - tmpvar_20) * tmpvar_20) + 1.0);
  d_1 = ((0.3183099 * tmpvar_88) / ((tmpvar_89 * tmpvar_89) + 1e-7));
  highp float tmpvar_90;
  tmpvar_90 = min (d_1, 100.0);
  d_1 = tmpvar_90;
  highp vec4 tmpvar_91;
  tmpvar_91.xyz = (((
    ((tmpvar_90 * mix (Fresnel, 1.0, (1.0 - tmpvar_19))) * LIGHT_COLOR)
   + 
    (((iblColor_2.xyz * 0.5) * ((
      (min ((Fresnel * 2.0), 1.0) - Fresnel)
     * 
      pow ((1.0 - tmpvar_19), 4.0)
    ) + Fresnel)) * AMBIENT_COLOR)
  ) * ColorSpecular.xyz) + ((
    (((brdfColor_6 * LIGHT_COLOR) * mainColor_9) + backLight_4)
   + 
    (AMBIENT_COLOR * mainColor_9)
  ) * mix (ColorShade.xyz, vec3(1.0, 1.0, 1.0), vec3(
    mix (1.0, tmpvar_19, (1.0 - specular_7.z))
  ))));
  tmpvar_91.w = tmpvar_22;
  _glesFragData[0] = tmpvar_91;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexNormal",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSpecular",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexBRDF",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSkybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorShade",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorShadow",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorSpecular",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionRTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionGTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionBTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintBlend",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D DiffuseTex;
uniform sampler2D TexNormal;
uniform sampler2D TexSpecular;
uniform sampler2D TexBRDF;
uniform lowp samplerCube TexSkybox;
uniform sampler2D RegionTintMaskTex;
uniform sampler2D SkinTintMaskTex;
uniform highp vec4 ColorShade;
uniform highp vec4 ColorShadow;
uniform highp vec4 ColorSpecular;
uniform highp vec4 SkinTint;
uniform highp vec4 SkinColor;
uniform highp vec4 RegionRTint;
uniform highp vec4 RegionGTint;
uniform highp vec4 RegionBTint;
uniform highp vec3 RegionTintBlend;
uniform highp float Fresnel;
uniform highp vec3 LightDir;
uniform highp vec4 LightColor;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 backLight_4;
  highp float nl2_5;
  highp vec3 brdfColor_6;
  highp vec3 specular_7;
  highp vec3 regionMaskColor_8;
  highp vec3 mainColor_9;
  highp vec4 color_10;
  highp vec3 mainNormal_11;
  highp vec4 shadowCoord_12;
  shadowCoord_12 = xlv_TEXCOORD4;
  highp float tmpvar_13;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_13 = 1.0;
  } else {
    shadowCoord_12.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_14;
    highp vec2 fetchesOffsetsU_15;
    highp float shadow_16;
    highp vec2 tmpvar_17;
    tmpvar_17 = (shadowCoord_12.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_18;
    tmpvar_18 = floor((tmpvar_17 + 0.5));
    highp vec2 tmpvar_19;
    tmpvar_19 = (tmpvar_17 - tmpvar_18);
    highp vec4 computedWeight_20;
    highp vec4 computedArea_21;
    highp vec4 computedAreaUncut_22;
    highp float tmpvar_23;
    tmpvar_23 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
    highp float tmpvar_24;
    tmpvar_24 = (tmpvar_23 - tmpvar_19.x);
    computedArea_21.x = tmpvar_24;
    computedAreaUncut_22.x = tmpvar_24;
    computedArea_21.w = tmpvar_23;
    computedAreaUncut_22.w = tmpvar_23;
    computedAreaUncut_22.y = ((1.5 - tmpvar_19.x) - 0.5);
    highp float tmpvar_25;
    tmpvar_25 = min (tmpvar_19.x, 0.0);
    computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
    computedAreaUncut_22.z = ((1.5 + tmpvar_19.x) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = max (tmpvar_19.x, 0.0);
    computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
    computedWeight_20 = (computedArea_21 * 0.44444);
    highp vec4 computedWeight_27;
    highp vec4 computedArea_28;
    highp vec4 computedAreaUncut_29;
    highp float tmpvar_30;
    tmpvar_30 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
    highp float tmpvar_31;
    tmpvar_31 = (tmpvar_30 - tmpvar_19.y);
    computedArea_28.x = tmpvar_31;
    computedAreaUncut_29.x = tmpvar_31;
    computedArea_28.w = tmpvar_30;
    computedAreaUncut_29.w = tmpvar_30;
    computedAreaUncut_29.y = ((1.5 - tmpvar_19.y) - 0.5);
    highp float tmpvar_32;
    tmpvar_32 = min (tmpvar_19.y, 0.0);
    computedArea_28.y = (computedAreaUncut_29.y - (tmpvar_32 * tmpvar_32));
    computedAreaUncut_29.z = ((1.5 + tmpvar_19.y) - 0.5);
    highp float tmpvar_33;
    tmpvar_33 = max (tmpvar_19.y, 0.0);
    computedArea_28.z = (computedAreaUncut_29.z - (tmpvar_33 * tmpvar_33));
    computedWeight_27 = (computedArea_28 * 0.44444);
    highp vec2 tmpvar_34;
    tmpvar_34 = (computedWeight_20.xz + computedWeight_20.yw);
    highp vec2 tmpvar_35;
    tmpvar_35 = (computedWeight_27.xz + computedWeight_27.yw);
    fetchesOffsetsU_15 = (((computedWeight_20.yw / tmpvar_34) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_14 = (((computedWeight_27.yw / tmpvar_35) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_36;
    tmpvar_36 = (tmpvar_18 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_37;
    tmpvar_37.x = fetchesOffsetsU_15.x;
    tmpvar_37.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (tmpvar_36 + tmpvar_37);
    tmpvar_38.z = shadowCoord_12.z;
    mediump float tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38);
    shadow_16 = ((tmpvar_34.x * tmpvar_35.x) * tmpvar_39);
    highp vec2 tmpvar_40;
    tmpvar_40.x = fetchesOffsetsU_15.y;
    tmpvar_40.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (tmpvar_36 + tmpvar_40);
    tmpvar_41.z = shadowCoord_12.z;
    mediump float tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41);
    shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.x) * tmpvar_42));
    highp vec2 tmpvar_43;
    tmpvar_43.x = fetchesOffsetsU_15.x;
    tmpvar_43.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_44;
    tmpvar_44.xy = (tmpvar_36 + tmpvar_43);
    tmpvar_44.z = shadowCoord_12.z;
    mediump float tmpvar_45;
    tmpvar_45 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_44);
    shadow_16 = (shadow_16 + ((tmpvar_34.x * tmpvar_35.y) * tmpvar_45));
    highp vec2 tmpvar_46;
    tmpvar_46.x = fetchesOffsetsU_15.y;
    tmpvar_46.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_47;
    tmpvar_47.xy = (tmpvar_36 + tmpvar_46);
    tmpvar_47.z = shadowCoord_12.z;
    mediump float tmpvar_48;
    tmpvar_48 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_47);
    shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.y) * tmpvar_48));
    tmpvar_13 = mix (1.0, shadow_16, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_49;
  tmpvar_49.x = xlv_TEXCOORD1.w;
  tmpvar_49.y = xlv_TEXCOORD2.w;
  tmpvar_49.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_50;
  tmpvar_50 = normalize((CAMERA_WORLDPOSITION - tmpvar_49));
  lowp vec3 tmpvar_51;
  tmpvar_51 = texture (TexNormal, xlv_TEXCOORD0).xyz;
  mainNormal_11 = tmpvar_51;
  highp vec3 tmpvar_52;
  tmpvar_52 = ((mainNormal_11 * 2.0) - 1.0);
  highp vec3 tmpvar_53;
  tmpvar_53 = normalize(((
    (tmpvar_52.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_52.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_52.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_54;
  tmpvar_54 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_55;
  tmpvar_55 = normalize(LightDir);
  highp float tmpvar_56;
  tmpvar_56 = max (dot (tmpvar_53, tmpvar_50), 0.0);
  highp float tmpvar_57;
  tmpvar_57 = max (dot (tmpvar_53, normalize(
    (tmpvar_50 + tmpvar_54)
  )), 0.0);
  lowp vec4 tmpvar_58;
  tmpvar_58 = texture (DiffuseTex, xlv_TEXCOORD0);
  color_10 = tmpvar_58;
  mainColor_9 = color_10.xyz;
  highp float tmpvar_59;
  tmpvar_59 = color_10.w;
  highp float tmpvar_60;
  if ((SkinColor.x > 0.04045)) {
    tmpvar_60 = pow (((SkinColor.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_60 = (SkinColor.x / 12.92);
  };
  highp float tmpvar_61;
  if ((SkinColor.y > 0.04045)) {
    tmpvar_61 = pow (((SkinColor.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_61 = (SkinColor.y / 12.92);
  };
  highp float tmpvar_62;
  if ((SkinColor.z > 0.04045)) {
    tmpvar_62 = pow (((SkinColor.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_62 = (SkinColor.z / 12.92);
  };
  highp float tmpvar_63;
  tmpvar_63 = (((
    (tmpvar_60 * 0.4124564)
   + 
    (tmpvar_61 * 0.3575761)
  ) + (tmpvar_62 * 0.1804375)) / 0.950456);
  highp float tmpvar_64;
  tmpvar_64 = (((tmpvar_60 * 0.2126729) + (tmpvar_61 * 0.7151522)) + (tmpvar_62 * 0.072175));
  highp float tmpvar_65;
  tmpvar_65 = (((
    (tmpvar_60 * 0.0193339)
   + 
    (tmpvar_61 * 0.119192)
  ) + (tmpvar_62 * 0.9503041)) / 1.088754);
  highp float tmpvar_66;
  if ((tmpvar_63 > 0.008856)) {
    tmpvar_66 = pow (tmpvar_63, 0.3333333);
  } else {
    tmpvar_66 = (((903.3 * tmpvar_63) + 16.0) / 116.0);
  };
  highp float tmpvar_67;
  if ((tmpvar_64 > 0.008856)) {
    tmpvar_67 = pow (tmpvar_64, 0.3333333);
  } else {
    tmpvar_67 = (((903.3 * tmpvar_64) + 16.0) / 116.0);
  };
  highp float tmpvar_68;
  if ((tmpvar_65 > 0.008856)) {
    tmpvar_68 = pow (tmpvar_65, 0.3333333);
  } else {
    tmpvar_68 = (((903.3 * tmpvar_65) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_69;
  tmpvar_69.x = (((116.0 * tmpvar_67) - 16.0) / 100.0);
  tmpvar_69.y = (((500.0 * 
    (tmpvar_66 - tmpvar_67)
  ) + 110.0) / 220.0);
  tmpvar_69.z = (((200.0 * 
    (tmpvar_67 - tmpvar_68)
  ) + 110.0) / 220.0);
  highp float tmpvar_70;
  if ((SkinTint.x > 0.04045)) {
    tmpvar_70 = pow (((SkinTint.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_70 = (SkinTint.x / 12.92);
  };
  highp float tmpvar_71;
  if ((SkinTint.y > 0.04045)) {
    tmpvar_71 = pow (((SkinTint.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_71 = (SkinTint.y / 12.92);
  };
  highp float tmpvar_72;
  if ((SkinTint.z > 0.04045)) {
    tmpvar_72 = pow (((SkinTint.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_72 = (SkinTint.z / 12.92);
  };
  highp float tmpvar_73;
  tmpvar_73 = (((
    (tmpvar_70 * 0.4124564)
   + 
    (tmpvar_71 * 0.3575761)
  ) + (tmpvar_72 * 0.1804375)) / 0.950456);
  highp float tmpvar_74;
  tmpvar_74 = (((tmpvar_70 * 0.2126729) + (tmpvar_71 * 0.7151522)) + (tmpvar_72 * 0.072175));
  highp float tmpvar_75;
  tmpvar_75 = (((
    (tmpvar_70 * 0.0193339)
   + 
    (tmpvar_71 * 0.119192)
  ) + (tmpvar_72 * 0.9503041)) / 1.088754);
  highp float tmpvar_76;
  if ((tmpvar_73 > 0.008856)) {
    tmpvar_76 = pow (tmpvar_73, 0.3333333);
  } else {
    tmpvar_76 = (((903.3 * tmpvar_73) + 16.0) / 116.0);
  };
  highp float tmpvar_77;
  if ((tmpvar_74 > 0.008856)) {
    tmpvar_77 = pow (tmpvar_74, 0.3333333);
  } else {
    tmpvar_77 = (((903.3 * tmpvar_74) + 16.0) / 116.0);
  };
  highp float tmpvar_78;
  if ((tmpvar_75 > 0.008856)) {
    tmpvar_78 = pow (tmpvar_75, 0.3333333);
  } else {
    tmpvar_78 = (((903.3 * tmpvar_75) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_79;
  tmpvar_79.x = (((116.0 * tmpvar_77) - 16.0) / 100.0);
  tmpvar_79.y = (((500.0 * 
    (tmpvar_76 - tmpvar_77)
  ) + 110.0) / 220.0);
  tmpvar_79.z = (((200.0 * 
    (tmpvar_77 - tmpvar_78)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_80;
  tmpvar_80 = (tmpvar_79 - tmpvar_69);
  highp float tmpvar_81;
  if ((color_10.x > 0.04045)) {
    tmpvar_81 = pow (((color_10.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_81 = (color_10.x / 12.92);
  };
  highp float tmpvar_82;
  if ((color_10.y > 0.04045)) {
    tmpvar_82 = pow (((color_10.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_82 = (color_10.y / 12.92);
  };
  highp float tmpvar_83;
  if ((color_10.z > 0.04045)) {
    tmpvar_83 = pow (((color_10.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_83 = (color_10.z / 12.92);
  };
  highp float tmpvar_84;
  tmpvar_84 = (((
    (tmpvar_81 * 0.4124564)
   + 
    (tmpvar_82 * 0.3575761)
  ) + (tmpvar_83 * 0.1804375)) / 0.950456);
  highp float tmpvar_85;
  tmpvar_85 = (((tmpvar_81 * 0.2126729) + (tmpvar_82 * 0.7151522)) + (tmpvar_83 * 0.072175));
  highp float tmpvar_86;
  tmpvar_86 = (((
    (tmpvar_81 * 0.0193339)
   + 
    (tmpvar_82 * 0.119192)
  ) + (tmpvar_83 * 0.9503041)) / 1.088754);
  highp float tmpvar_87;
  if ((tmpvar_84 > 0.008856)) {
    tmpvar_87 = pow (tmpvar_84, 0.3333333);
  } else {
    tmpvar_87 = (((903.3 * tmpvar_84) + 16.0) / 116.0);
  };
  highp float tmpvar_88;
  if ((tmpvar_85 > 0.008856)) {
    tmpvar_88 = pow (tmpvar_85, 0.3333333);
  } else {
    tmpvar_88 = (((903.3 * tmpvar_85) + 16.0) / 116.0);
  };
  highp float tmpvar_89;
  if ((tmpvar_86 > 0.008856)) {
    tmpvar_89 = pow (tmpvar_86, 0.3333333);
  } else {
    tmpvar_89 = (((903.3 * tmpvar_86) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_90;
  tmpvar_90.x = (((116.0 * tmpvar_88) - 16.0) / 100.0);
  tmpvar_90.y = (((500.0 * 
    (tmpvar_87 - tmpvar_88)
  ) + 110.0) / 220.0);
  tmpvar_90.z = (((200.0 * 
    (tmpvar_88 - tmpvar_89)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_91;
  tmpvar_91 = clamp ((tmpvar_90 + tmpvar_80), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float z_92;
  highp float x_93;
  highp float tmpvar_94;
  tmpvar_94 = (((tmpvar_91.x * 100.0) + 16.0) / 116.0);
  highp float tmpvar_95;
  tmpvar_95 = (((
    (tmpvar_91.y * 220.0)
   - 110.0) / 500.0) + tmpvar_94);
  x_93 = tmpvar_95;
  highp float tmpvar_96;
  tmpvar_96 = (tmpvar_94 - ((
    (tmpvar_91.z * 220.0)
   - 110.0) / 200.0));
  z_92 = tmpvar_96;
  highp float tmpvar_97;
  tmpvar_97 = pow (tmpvar_95, 3.0);
  highp float tmpvar_98;
  tmpvar_98 = pow (tmpvar_94, 3.0);
  highp float tmpvar_99;
  tmpvar_99 = pow (tmpvar_96, 3.0);
  highp float tmpvar_100;
  if ((tmpvar_97 > 0.008856)) {
    tmpvar_100 = tmpvar_97;
  } else {
    tmpvar_100 = ((tmpvar_95 - 0.137931) / 7.787069);
  };
  x_93 = (tmpvar_100 * 0.950456);
  highp float tmpvar_101;
  if ((tmpvar_98 > 0.008856)) {
    tmpvar_101 = tmpvar_98;
  } else {
    tmpvar_101 = ((tmpvar_94 - 0.137931) / 7.787069);
  };
  highp float tmpvar_102;
  if ((tmpvar_99 > 0.008856)) {
    tmpvar_102 = tmpvar_99;
  } else {
    tmpvar_102 = ((tmpvar_96 - 0.137931) / 7.787069);
  };
  z_92 = (tmpvar_102 * 1.088754);
  highp float tmpvar_103;
  tmpvar_103 = (((x_93 * 3.240454) + (tmpvar_101 * -1.537138)) + (z_92 * -0.4985314));
  highp float tmpvar_104;
  tmpvar_104 = (((x_93 * -0.969266) + (tmpvar_101 * 1.876011)) + (z_92 * 0.041556));
  highp float tmpvar_105;
  tmpvar_105 = (((x_93 * 0.0556434) + (tmpvar_101 * -0.2040259)) + (z_92 * 1.057225));
  highp float tmpvar_106;
  if ((tmpvar_103 > 0.0031308)) {
    tmpvar_106 = ((1.055 * pow (tmpvar_103, 0.4166667)) - 0.055);
  } else {
    tmpvar_106 = (12.92 * tmpvar_103);
  };
  highp float tmpvar_107;
  if ((tmpvar_104 > 0.0031308)) {
    tmpvar_107 = ((1.055 * pow (tmpvar_104, 0.4166667)) - 0.055);
  } else {
    tmpvar_107 = (12.92 * tmpvar_104);
  };
  highp float tmpvar_108;
  if ((tmpvar_105 > 0.0031308)) {
    tmpvar_108 = ((1.055 * pow (tmpvar_105, 0.4166667)) - 0.055);
  } else {
    tmpvar_108 = (12.92 * tmpvar_105);
  };
  highp vec3 tmpvar_109;
  tmpvar_109.x = tmpvar_106;
  tmpvar_109.y = tmpvar_107;
  tmpvar_109.z = tmpvar_108;
  lowp vec3 tmpvar_110;
  tmpvar_110 = texture (SkinTintMaskTex, xlv_TEXCOORD0).xxx;
  highp vec3 tmpvar_111;
  tmpvar_111 = mix (color_10.xyz, tmpvar_109, tmpvar_110);
  mainColor_9 = (tmpvar_111 * tmpvar_111);
  lowp vec3 tmpvar_112;
  tmpvar_112 = texture (RegionTintMaskTex, xlv_TEXCOORD0).xyz;
  regionMaskColor_8 = tmpvar_112;
  highp vec4 tmpvar_113;
  tmpvar_113.w = 0.0;
  tmpvar_113.xyz = mainColor_9;
  highp vec4 tmpvar_114;
  tmpvar_114.w = 0.0;
  tmpvar_114.xyz = mainColor_9;
  highp vec4 tmpvar_115;
  tmpvar_115.w = 0.0;
  tmpvar_115.xyz = mainColor_9;
  mainColor_9 = (((
    (mainColor_9 * (1.0 - ((regionMaskColor_8.x + regionMaskColor_8.y) + regionMaskColor_8.z)))
   + 
    (mix (tmpvar_113, RegionRTint, RegionTintBlend.xxxx) * regionMaskColor_8.x)
  .xyz) + (
    mix (tmpvar_114, RegionGTint, RegionTintBlend.yyyy)
   * regionMaskColor_8.y).xyz) + (mix (tmpvar_115, RegionBTint, RegionTintBlend.zzzz) * regionMaskColor_8.z).xyz);
  lowp vec3 tmpvar_116;
  tmpvar_116 = texture (TexSpecular, xlv_TEXCOORD0).xyz;
  specular_7 = tmpvar_116;
  highp float tmpvar_117;
  tmpvar_117 = (1.0 - specular_7.x);
  highp vec2 tmpvar_118;
  tmpvar_118.x = (((
    dot (tmpvar_53, tmpvar_54)
   * 0.5) + 0.5) * 0.99);
  tmpvar_118.y = specular_7.y;
  lowp vec3 tmpvar_119;
  tmpvar_119 = texture (TexBRDF, tmpvar_118).xyz;
  brdfColor_6 = tmpvar_119;
  highp float tmpvar_120;
  tmpvar_120 = max (((
    dot (tmpvar_53, tmpvar_55)
   + 0.5) * 0.7), 0.0);
  nl2_5 = (tmpvar_120 * tmpvar_120);
  nl2_5 = (nl2_5 * nl2_5);
  nl2_5 = (nl2_5 * nl2_5);
  backLight_4 = ((nl2_5 * LightColor.xyz) * ((LightIntensity * mainColor_9) * mainNormal_11.z));
  backLight_4 = (backLight_4 / (vec3(1.0, 1.0, 1.0) + backLight_4));
  highp vec3 I_121;
  I_121 = -(tmpvar_50);
  reflectDir_3.xyz = (I_121 - (2.0 * (
    dot (tmpvar_53, I_121)
   * tmpvar_53)));
  reflectDir_3.w = (tmpvar_117 * 4.0);
  lowp vec4 tmpvar_122;
  tmpvar_122 = textureLod (TexSkybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_123;
  tmpvar_123 = tmpvar_122;
  iblColor_2.w = tmpvar_123.w;
  iblColor_2.xyz = ((tmpvar_123.xyz * tmpvar_123.w) * 4.0);
  highp float tmpvar_124;
  tmpvar_124 = max ((tmpvar_117 * tmpvar_117), 0.1);
  highp float tmpvar_125;
  tmpvar_125 = (tmpvar_124 * tmpvar_124);
  highp float tmpvar_126;
  tmpvar_126 = (((
    (tmpvar_57 * tmpvar_125)
   - tmpvar_57) * tmpvar_57) + 1.0);
  d_1 = ((0.3183099 * tmpvar_125) / ((tmpvar_126 * tmpvar_126) + 1e-7));
  highp float tmpvar_127;
  tmpvar_127 = min (d_1, 100.0);
  d_1 = tmpvar_127;
  highp vec4 tmpvar_128;
  tmpvar_128.xyz = (((
    ((tmpvar_127 * mix (Fresnel, 1.0, (1.0 - tmpvar_56))) * LIGHT_COLOR)
   + 
    (((iblColor_2.xyz * 0.5) * ((
      (min ((Fresnel * 2.0), 1.0) - Fresnel)
     * 
      pow ((1.0 - tmpvar_56), 4.0)
    ) + Fresnel)) * AMBIENT_COLOR)
  ) * ColorSpecular.xyz) + ((
    (((mix (ColorShadow.xyz, brdfColor_6, vec3(tmpvar_13)) * LIGHT_COLOR) * mainColor_9) + backLight_4)
   + 
    (AMBIENT_COLOR * mainColor_9)
  ) * mix (ColorShade.xyz, vec3(1.0, 1.0, 1.0), vec3(
    mix (1.0, tmpvar_56, (1.0 - specular_7.z))
  ))));
  tmpvar_128.w = tmpvar_59;
  _glesFragData[0] = tmpvar_128;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexNormal",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSpecular",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexBRDF",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSkybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorShade",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorShadow",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorSpecular",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionRTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionGTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionBTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintBlend",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D DiffuseTex;
uniform sampler2D TexNormal;
uniform sampler2D TexSpecular;
uniform sampler2D TexBRDF;
uniform lowp samplerCube TexSkybox;
uniform sampler2D RegionTintMaskTex;
uniform sampler2D SkinTintMaskTex;
uniform highp vec4 ColorShade;
uniform highp vec4 ColorShadow;
uniform highp vec4 ColorSpecular;
uniform highp vec4 SkinTint;
uniform highp vec4 SkinColor;
uniform highp vec4 RegionRTint;
uniform highp vec4 RegionGTint;
uniform highp vec4 RegionBTint;
uniform highp vec3 RegionTintBlend;
uniform highp float Fresnel;
uniform highp vec3 LightDir;
uniform highp vec4 LightColor;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 backLight_4;
  highp float nl2_5;
  highp vec3 brdfColor_6;
  highp vec3 specular_7;
  highp vec3 regionMaskColor_8;
  highp vec3 mainColor_9;
  highp vec4 color_10;
  highp vec3 mainNormal_11;
  highp vec4 shadowCoord_12;
  shadowCoord_12 = xlv_TEXCOORD4;
  highp float tmpvar_13;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_13 = 1.0;
  } else {
    shadowCoord_12.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_14;
    highp vec3 fetchesOffsetsU_15;
    highp float shadow_16;
    highp vec2 tmpvar_17;
    tmpvar_17 = (shadowCoord_12.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_18;
    tmpvar_18 = floor((tmpvar_17 + 0.5));
    highp vec2 tmpvar_19;
    tmpvar_19 = (tmpvar_17 - tmpvar_18);
    highp vec3 texelsWeightsA_20;
    highp vec3 texelsWeightsB_21;
    highp vec4 computedArea_22;
    highp vec4 computedAreaUncut_23;
    highp float tmpvar_24;
    tmpvar_24 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
    highp float tmpvar_25;
    tmpvar_25 = (tmpvar_24 - tmpvar_19.x);
    computedArea_22.x = tmpvar_25;
    computedAreaUncut_23.x = tmpvar_25;
    computedArea_22.w = tmpvar_24;
    computedAreaUncut_23.w = tmpvar_24;
    computedAreaUncut_23.y = ((1.5 - tmpvar_19.x) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = min (tmpvar_19.x, 0.0);
    computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
    computedAreaUncut_23.z = ((1.5 + tmpvar_19.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = max (tmpvar_19.x, 0.0);
    computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
    texelsWeightsA_20.x = (0.16 * tmpvar_25);
    texelsWeightsA_20.y = (0.16 * computedAreaUncut_23.y);
    texelsWeightsA_20.z = (0.16 * (computedArea_22.y + 1.0));
    texelsWeightsB_21.x = (0.16 * (computedArea_22.z + 1.0));
    texelsWeightsB_21.y = (0.16 * computedAreaUncut_23.z);
    texelsWeightsB_21.z = (0.16 * tmpvar_24);
    highp vec3 texelsWeightsA_28;
    highp vec3 texelsWeightsB_29;
    highp vec4 computedArea_30;
    highp vec4 computedAreaUncut_31;
    highp float tmpvar_32;
    tmpvar_32 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
    highp float tmpvar_33;
    tmpvar_33 = (tmpvar_32 - tmpvar_19.y);
    computedArea_30.x = tmpvar_33;
    computedAreaUncut_31.x = tmpvar_33;
    computedArea_30.w = tmpvar_32;
    computedAreaUncut_31.w = tmpvar_32;
    computedAreaUncut_31.y = ((1.5 - tmpvar_19.y) - 0.5);
    highp float tmpvar_34;
    tmpvar_34 = min (tmpvar_19.y, 0.0);
    computedArea_30.y = (computedAreaUncut_31.y - (tmpvar_34 * tmpvar_34));
    computedAreaUncut_31.z = ((1.5 + tmpvar_19.y) - 0.5);
    highp float tmpvar_35;
    tmpvar_35 = max (tmpvar_19.y, 0.0);
    computedArea_30.z = (computedAreaUncut_31.z - (tmpvar_35 * tmpvar_35));
    texelsWeightsA_28.x = (0.16 * tmpvar_33);
    texelsWeightsA_28.y = (0.16 * computedAreaUncut_31.y);
    texelsWeightsA_28.z = (0.16 * (computedArea_30.y + 1.0));
    texelsWeightsB_29.x = (0.16 * (computedArea_30.z + 1.0));
    texelsWeightsB_29.y = (0.16 * computedAreaUncut_31.z);
    texelsWeightsB_29.z = (0.16 * tmpvar_32);
    highp vec3 tmpvar_36;
    tmpvar_36.xy = texelsWeightsA_20.xz;
    tmpvar_36.z = texelsWeightsB_21.y;
    highp vec3 tmpvar_37;
    tmpvar_37.x = texelsWeightsA_20.y;
    tmpvar_37.yz = texelsWeightsB_21.xz;
    highp vec3 tmpvar_38;
    tmpvar_38 = (tmpvar_36 + tmpvar_37);
    highp vec3 tmpvar_39;
    tmpvar_39.xy = texelsWeightsA_28.xz;
    tmpvar_39.z = texelsWeightsB_29.y;
    highp vec3 tmpvar_40;
    tmpvar_40.x = texelsWeightsA_28.y;
    tmpvar_40.yz = texelsWeightsB_29.xz;
    highp vec3 tmpvar_41;
    tmpvar_41 = (tmpvar_39 + tmpvar_40);
    highp vec3 tmpvar_42;
    tmpvar_42.x = texelsWeightsA_20.y;
    tmpvar_42.yz = texelsWeightsB_21.xz;
    highp vec3 tmpvar_43;
    tmpvar_43.x = texelsWeightsA_28.y;
    tmpvar_43.yz = texelsWeightsB_29.xz;
    fetchesOffsetsU_15 = (((tmpvar_42 / tmpvar_38) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_14 = (((tmpvar_43 / tmpvar_41) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_44;
    tmpvar_44 = (tmpvar_18 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_45;
    tmpvar_45.x = fetchesOffsetsU_15.x;
    tmpvar_45.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_46;
    tmpvar_46.xy = (tmpvar_44 + tmpvar_45);
    tmpvar_46.z = shadowCoord_12.z;
    mediump float tmpvar_47;
    tmpvar_47 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_46);
    shadow_16 = ((tmpvar_38.x * tmpvar_41.x) * tmpvar_47);
    highp vec2 tmpvar_48;
    tmpvar_48.x = fetchesOffsetsU_15.y;
    tmpvar_48.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (tmpvar_44 + tmpvar_48);
    tmpvar_49.z = shadowCoord_12.z;
    mediump float tmpvar_50;
    tmpvar_50 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_49);
    shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.x) * tmpvar_50));
    highp vec2 tmpvar_51;
    tmpvar_51.x = fetchesOffsetsU_15.z;
    tmpvar_51.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_52;
    tmpvar_52.xy = (tmpvar_44 + tmpvar_51);
    tmpvar_52.z = shadowCoord_12.z;
    mediump float tmpvar_53;
    tmpvar_53 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_52);
    shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.x) * tmpvar_53));
    highp vec2 tmpvar_54;
    tmpvar_54.x = fetchesOffsetsU_15.x;
    tmpvar_54.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_55;
    tmpvar_55.xy = (tmpvar_44 + tmpvar_54);
    tmpvar_55.z = shadowCoord_12.z;
    mediump float tmpvar_56;
    tmpvar_56 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_55);
    shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.y) * tmpvar_56));
    highp vec2 tmpvar_57;
    tmpvar_57.x = fetchesOffsetsU_15.y;
    tmpvar_57.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_58;
    tmpvar_58.xy = (tmpvar_44 + tmpvar_57);
    tmpvar_58.z = shadowCoord_12.z;
    mediump float tmpvar_59;
    tmpvar_59 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_58);
    shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.y) * tmpvar_59));
    highp vec2 tmpvar_60;
    tmpvar_60.x = fetchesOffsetsU_15.z;
    tmpvar_60.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_61;
    tmpvar_61.xy = (tmpvar_44 + tmpvar_60);
    tmpvar_61.z = shadowCoord_12.z;
    mediump float tmpvar_62;
    tmpvar_62 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_61);
    shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.y) * tmpvar_62));
    highp vec2 tmpvar_63;
    tmpvar_63.x = fetchesOffsetsU_15.x;
    tmpvar_63.y = fetchesOffsetsV_14.z;
    highp vec3 tmpvar_64;
    tmpvar_64.xy = (tmpvar_44 + tmpvar_63);
    tmpvar_64.z = shadowCoord_12.z;
    mediump float tmpvar_65;
    tmpvar_65 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_64);
    shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.z) * tmpvar_65));
    highp vec2 tmpvar_66;
    tmpvar_66.x = fetchesOffsetsU_15.y;
    tmpvar_66.y = fetchesOffsetsV_14.z;
    highp vec3 tmpvar_67;
    tmpvar_67.xy = (tmpvar_44 + tmpvar_66);
    tmpvar_67.z = shadowCoord_12.z;
    mediump float tmpvar_68;
    tmpvar_68 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_67);
    shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.z) * tmpvar_68));
    highp vec2 tmpvar_69;
    tmpvar_69.x = fetchesOffsetsU_15.z;
    tmpvar_69.y = fetchesOffsetsV_14.z;
    highp vec3 tmpvar_70;
    tmpvar_70.xy = (tmpvar_44 + tmpvar_69);
    tmpvar_70.z = shadowCoord_12.z;
    mediump float tmpvar_71;
    tmpvar_71 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_70);
    shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.z) * tmpvar_71));
    tmpvar_13 = mix (1.0, shadow_16, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_72;
  tmpvar_72.x = xlv_TEXCOORD1.w;
  tmpvar_72.y = xlv_TEXCOORD2.w;
  tmpvar_72.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_73;
  tmpvar_73 = normalize((CAMERA_WORLDPOSITION - tmpvar_72));
  lowp vec3 tmpvar_74;
  tmpvar_74 = texture (TexNormal, xlv_TEXCOORD0).xyz;
  mainNormal_11 = tmpvar_74;
  highp vec3 tmpvar_75;
  tmpvar_75 = ((mainNormal_11 * 2.0) - 1.0);
  highp vec3 tmpvar_76;
  tmpvar_76 = normalize(((
    (tmpvar_75.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_75.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_75.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_77;
  tmpvar_77 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_78;
  tmpvar_78 = normalize(LightDir);
  highp float tmpvar_79;
  tmpvar_79 = max (dot (tmpvar_76, tmpvar_73), 0.0);
  highp float tmpvar_80;
  tmpvar_80 = max (dot (tmpvar_76, normalize(
    (tmpvar_73 + tmpvar_77)
  )), 0.0);
  lowp vec4 tmpvar_81;
  tmpvar_81 = texture (DiffuseTex, xlv_TEXCOORD0);
  color_10 = tmpvar_81;
  mainColor_9 = color_10.xyz;
  highp float tmpvar_82;
  tmpvar_82 = color_10.w;
  highp float tmpvar_83;
  if ((SkinColor.x > 0.04045)) {
    tmpvar_83 = pow (((SkinColor.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_83 = (SkinColor.x / 12.92);
  };
  highp float tmpvar_84;
  if ((SkinColor.y > 0.04045)) {
    tmpvar_84 = pow (((SkinColor.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_84 = (SkinColor.y / 12.92);
  };
  highp float tmpvar_85;
  if ((SkinColor.z > 0.04045)) {
    tmpvar_85 = pow (((SkinColor.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_85 = (SkinColor.z / 12.92);
  };
  highp float tmpvar_86;
  tmpvar_86 = (((
    (tmpvar_83 * 0.4124564)
   + 
    (tmpvar_84 * 0.3575761)
  ) + (tmpvar_85 * 0.1804375)) / 0.950456);
  highp float tmpvar_87;
  tmpvar_87 = (((tmpvar_83 * 0.2126729) + (tmpvar_84 * 0.7151522)) + (tmpvar_85 * 0.072175));
  highp float tmpvar_88;
  tmpvar_88 = (((
    (tmpvar_83 * 0.0193339)
   + 
    (tmpvar_84 * 0.119192)
  ) + (tmpvar_85 * 0.9503041)) / 1.088754);
  highp float tmpvar_89;
  if ((tmpvar_86 > 0.008856)) {
    tmpvar_89 = pow (tmpvar_86, 0.3333333);
  } else {
    tmpvar_89 = (((903.3 * tmpvar_86) + 16.0) / 116.0);
  };
  highp float tmpvar_90;
  if ((tmpvar_87 > 0.008856)) {
    tmpvar_90 = pow (tmpvar_87, 0.3333333);
  } else {
    tmpvar_90 = (((903.3 * tmpvar_87) + 16.0) / 116.0);
  };
  highp float tmpvar_91;
  if ((tmpvar_88 > 0.008856)) {
    tmpvar_91 = pow (tmpvar_88, 0.3333333);
  } else {
    tmpvar_91 = (((903.3 * tmpvar_88) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_92;
  tmpvar_92.x = (((116.0 * tmpvar_90) - 16.0) / 100.0);
  tmpvar_92.y = (((500.0 * 
    (tmpvar_89 - tmpvar_90)
  ) + 110.0) / 220.0);
  tmpvar_92.z = (((200.0 * 
    (tmpvar_90 - tmpvar_91)
  ) + 110.0) / 220.0);
  highp float tmpvar_93;
  if ((SkinTint.x > 0.04045)) {
    tmpvar_93 = pow (((SkinTint.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_93 = (SkinTint.x / 12.92);
  };
  highp float tmpvar_94;
  if ((SkinTint.y > 0.04045)) {
    tmpvar_94 = pow (((SkinTint.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_94 = (SkinTint.y / 12.92);
  };
  highp float tmpvar_95;
  if ((SkinTint.z > 0.04045)) {
    tmpvar_95 = pow (((SkinTint.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_95 = (SkinTint.z / 12.92);
  };
  highp float tmpvar_96;
  tmpvar_96 = (((
    (tmpvar_93 * 0.4124564)
   + 
    (tmpvar_94 * 0.3575761)
  ) + (tmpvar_95 * 0.1804375)) / 0.950456);
  highp float tmpvar_97;
  tmpvar_97 = (((tmpvar_93 * 0.2126729) + (tmpvar_94 * 0.7151522)) + (tmpvar_95 * 0.072175));
  highp float tmpvar_98;
  tmpvar_98 = (((
    (tmpvar_93 * 0.0193339)
   + 
    (tmpvar_94 * 0.119192)
  ) + (tmpvar_95 * 0.9503041)) / 1.088754);
  highp float tmpvar_99;
  if ((tmpvar_96 > 0.008856)) {
    tmpvar_99 = pow (tmpvar_96, 0.3333333);
  } else {
    tmpvar_99 = (((903.3 * tmpvar_96) + 16.0) / 116.0);
  };
  highp float tmpvar_100;
  if ((tmpvar_97 > 0.008856)) {
    tmpvar_100 = pow (tmpvar_97, 0.3333333);
  } else {
    tmpvar_100 = (((903.3 * tmpvar_97) + 16.0) / 116.0);
  };
  highp float tmpvar_101;
  if ((tmpvar_98 > 0.008856)) {
    tmpvar_101 = pow (tmpvar_98, 0.3333333);
  } else {
    tmpvar_101 = (((903.3 * tmpvar_98) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_102;
  tmpvar_102.x = (((116.0 * tmpvar_100) - 16.0) / 100.0);
  tmpvar_102.y = (((500.0 * 
    (tmpvar_99 - tmpvar_100)
  ) + 110.0) / 220.0);
  tmpvar_102.z = (((200.0 * 
    (tmpvar_100 - tmpvar_101)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_103;
  tmpvar_103 = (tmpvar_102 - tmpvar_92);
  highp float tmpvar_104;
  if ((color_10.x > 0.04045)) {
    tmpvar_104 = pow (((color_10.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_104 = (color_10.x / 12.92);
  };
  highp float tmpvar_105;
  if ((color_10.y > 0.04045)) {
    tmpvar_105 = pow (((color_10.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_105 = (color_10.y / 12.92);
  };
  highp float tmpvar_106;
  if ((color_10.z > 0.04045)) {
    tmpvar_106 = pow (((color_10.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_106 = (color_10.z / 12.92);
  };
  highp float tmpvar_107;
  tmpvar_107 = (((
    (tmpvar_104 * 0.4124564)
   + 
    (tmpvar_105 * 0.3575761)
  ) + (tmpvar_106 * 0.1804375)) / 0.950456);
  highp float tmpvar_108;
  tmpvar_108 = (((tmpvar_104 * 0.2126729) + (tmpvar_105 * 0.7151522)) + (tmpvar_106 * 0.072175));
  highp float tmpvar_109;
  tmpvar_109 = (((
    (tmpvar_104 * 0.0193339)
   + 
    (tmpvar_105 * 0.119192)
  ) + (tmpvar_106 * 0.9503041)) / 1.088754);
  highp float tmpvar_110;
  if ((tmpvar_107 > 0.008856)) {
    tmpvar_110 = pow (tmpvar_107, 0.3333333);
  } else {
    tmpvar_110 = (((903.3 * tmpvar_107) + 16.0) / 116.0);
  };
  highp float tmpvar_111;
  if ((tmpvar_108 > 0.008856)) {
    tmpvar_111 = pow (tmpvar_108, 0.3333333);
  } else {
    tmpvar_111 = (((903.3 * tmpvar_108) + 16.0) / 116.0);
  };
  highp float tmpvar_112;
  if ((tmpvar_109 > 0.008856)) {
    tmpvar_112 = pow (tmpvar_109, 0.3333333);
  } else {
    tmpvar_112 = (((903.3 * tmpvar_109) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_113;
  tmpvar_113.x = (((116.0 * tmpvar_111) - 16.0) / 100.0);
  tmpvar_113.y = (((500.0 * 
    (tmpvar_110 - tmpvar_111)
  ) + 110.0) / 220.0);
  tmpvar_113.z = (((200.0 * 
    (tmpvar_111 - tmpvar_112)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_114;
  tmpvar_114 = clamp ((tmpvar_113 + tmpvar_103), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float z_115;
  highp float x_116;
  highp float tmpvar_117;
  tmpvar_117 = (((tmpvar_114.x * 100.0) + 16.0) / 116.0);
  highp float tmpvar_118;
  tmpvar_118 = (((
    (tmpvar_114.y * 220.0)
   - 110.0) / 500.0) + tmpvar_117);
  x_116 = tmpvar_118;
  highp float tmpvar_119;
  tmpvar_119 = (tmpvar_117 - ((
    (tmpvar_114.z * 220.0)
   - 110.0) / 200.0));
  z_115 = tmpvar_119;
  highp float tmpvar_120;
  tmpvar_120 = pow (tmpvar_118, 3.0);
  highp float tmpvar_121;
  tmpvar_121 = pow (tmpvar_117, 3.0);
  highp float tmpvar_122;
  tmpvar_122 = pow (tmpvar_119, 3.0);
  highp float tmpvar_123;
  if ((tmpvar_120 > 0.008856)) {
    tmpvar_123 = tmpvar_120;
  } else {
    tmpvar_123 = ((tmpvar_118 - 0.137931) / 7.787069);
  };
  x_116 = (tmpvar_123 * 0.950456);
  highp float tmpvar_124;
  if ((tmpvar_121 > 0.008856)) {
    tmpvar_124 = tmpvar_121;
  } else {
    tmpvar_124 = ((tmpvar_117 - 0.137931) / 7.787069);
  };
  highp float tmpvar_125;
  if ((tmpvar_122 > 0.008856)) {
    tmpvar_125 = tmpvar_122;
  } else {
    tmpvar_125 = ((tmpvar_119 - 0.137931) / 7.787069);
  };
  z_115 = (tmpvar_125 * 1.088754);
  highp float tmpvar_126;
  tmpvar_126 = (((x_116 * 3.240454) + (tmpvar_124 * -1.537138)) + (z_115 * -0.4985314));
  highp float tmpvar_127;
  tmpvar_127 = (((x_116 * -0.969266) + (tmpvar_124 * 1.876011)) + (z_115 * 0.041556));
  highp float tmpvar_128;
  tmpvar_128 = (((x_116 * 0.0556434) + (tmpvar_124 * -0.2040259)) + (z_115 * 1.057225));
  highp float tmpvar_129;
  if ((tmpvar_126 > 0.0031308)) {
    tmpvar_129 = ((1.055 * pow (tmpvar_126, 0.4166667)) - 0.055);
  } else {
    tmpvar_129 = (12.92 * tmpvar_126);
  };
  highp float tmpvar_130;
  if ((tmpvar_127 > 0.0031308)) {
    tmpvar_130 = ((1.055 * pow (tmpvar_127, 0.4166667)) - 0.055);
  } else {
    tmpvar_130 = (12.92 * tmpvar_127);
  };
  highp float tmpvar_131;
  if ((tmpvar_128 > 0.0031308)) {
    tmpvar_131 = ((1.055 * pow (tmpvar_128, 0.4166667)) - 0.055);
  } else {
    tmpvar_131 = (12.92 * tmpvar_128);
  };
  highp vec3 tmpvar_132;
  tmpvar_132.x = tmpvar_129;
  tmpvar_132.y = tmpvar_130;
  tmpvar_132.z = tmpvar_131;
  lowp vec3 tmpvar_133;
  tmpvar_133 = texture (SkinTintMaskTex, xlv_TEXCOORD0).xxx;
  highp vec3 tmpvar_134;
  tmpvar_134 = mix (color_10.xyz, tmpvar_132, tmpvar_133);
  mainColor_9 = (tmpvar_134 * tmpvar_134);
  lowp vec3 tmpvar_135;
  tmpvar_135 = texture (RegionTintMaskTex, xlv_TEXCOORD0).xyz;
  regionMaskColor_8 = tmpvar_135;
  highp vec4 tmpvar_136;
  tmpvar_136.w = 0.0;
  tmpvar_136.xyz = mainColor_9;
  highp vec4 tmpvar_137;
  tmpvar_137.w = 0.0;
  tmpvar_137.xyz = mainColor_9;
  highp vec4 tmpvar_138;
  tmpvar_138.w = 0.0;
  tmpvar_138.xyz = mainColor_9;
  mainColor_9 = (((
    (mainColor_9 * (1.0 - ((regionMaskColor_8.x + regionMaskColor_8.y) + regionMaskColor_8.z)))
   + 
    (mix (tmpvar_136, RegionRTint, RegionTintBlend.xxxx) * regionMaskColor_8.x)
  .xyz) + (
    mix (tmpvar_137, RegionGTint, RegionTintBlend.yyyy)
   * regionMaskColor_8.y).xyz) + (mix (tmpvar_138, RegionBTint, RegionTintBlend.zzzz) * regionMaskColor_8.z).xyz);
  lowp vec3 tmpvar_139;
  tmpvar_139 = texture (TexSpecular, xlv_TEXCOORD0).xyz;
  specular_7 = tmpvar_139;
  highp float tmpvar_140;
  tmpvar_140 = (1.0 - specular_7.x);
  highp vec2 tmpvar_141;
  tmpvar_141.x = (((
    dot (tmpvar_76, tmpvar_77)
   * 0.5) + 0.5) * 0.99);
  tmpvar_141.y = specular_7.y;
  lowp vec3 tmpvar_142;
  tmpvar_142 = texture (TexBRDF, tmpvar_141).xyz;
  brdfColor_6 = tmpvar_142;
  highp float tmpvar_143;
  tmpvar_143 = max (((
    dot (tmpvar_76, tmpvar_78)
   + 0.5) * 0.7), 0.0);
  nl2_5 = (tmpvar_143 * tmpvar_143);
  nl2_5 = (nl2_5 * nl2_5);
  nl2_5 = (nl2_5 * nl2_5);
  backLight_4 = ((nl2_5 * LightColor.xyz) * ((LightIntensity * mainColor_9) * mainNormal_11.z));
  backLight_4 = (backLight_4 / (vec3(1.0, 1.0, 1.0) + backLight_4));
  highp vec3 I_144;
  I_144 = -(tmpvar_73);
  reflectDir_3.xyz = (I_144 - (2.0 * (
    dot (tmpvar_76, I_144)
   * tmpvar_76)));
  reflectDir_3.w = (tmpvar_140 * 4.0);
  lowp vec4 tmpvar_145;
  tmpvar_145 = textureLod (TexSkybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_146;
  tmpvar_146 = tmpvar_145;
  iblColor_2.w = tmpvar_146.w;
  iblColor_2.xyz = ((tmpvar_146.xyz * tmpvar_146.w) * 4.0);
  highp float tmpvar_147;
  tmpvar_147 = max ((tmpvar_140 * tmpvar_140), 0.1);
  highp float tmpvar_148;
  tmpvar_148 = (tmpvar_147 * tmpvar_147);
  highp float tmpvar_149;
  tmpvar_149 = (((
    (tmpvar_80 * tmpvar_148)
   - tmpvar_80) * tmpvar_80) + 1.0);
  d_1 = ((0.3183099 * tmpvar_148) / ((tmpvar_149 * tmpvar_149) + 1e-7));
  highp float tmpvar_150;
  tmpvar_150 = min (d_1, 100.0);
  d_1 = tmpvar_150;
  highp vec4 tmpvar_151;
  tmpvar_151.xyz = (((
    ((tmpvar_150 * mix (Fresnel, 1.0, (1.0 - tmpvar_79))) * LIGHT_COLOR)
   + 
    (((iblColor_2.xyz * 0.5) * ((
      (min ((Fresnel * 2.0), 1.0) - Fresnel)
     * 
      pow ((1.0 - tmpvar_79), 4.0)
    ) + Fresnel)) * AMBIENT_COLOR)
  ) * ColorSpecular.xyz) + ((
    (((mix (ColorShadow.xyz, brdfColor_6, vec3(tmpvar_13)) * LIGHT_COLOR) * mainColor_9) + backLight_4)
   + 
    (AMBIENT_COLOR * mainColor_9)
  ) * mix (ColorShade.xyz, vec3(1.0, 1.0, 1.0), vec3(
    mix (1.0, tmpvar_79, (1.0 - specular_7.z))
  ))));
  tmpvar_151.w = tmpvar_82;
  _glesFragData[0] = tmpvar_151;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexNormal",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSpecular",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexBRDF",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSkybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorShade",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorShadow",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorSpecular",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionRTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionGTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionBTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintBlend",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D DiffuseTex;
uniform sampler2D TexNormal;
uniform sampler2D TexSpecular;
uniform sampler2D TexBRDF;
uniform lowp samplerCube TexSkybox;
uniform sampler2D RegionTintMaskTex;
uniform sampler2D SkinTintMaskTex;
uniform highp vec4 ColorShade;
uniform highp vec4 ColorShadow;
uniform highp vec4 ColorSpecular;
uniform highp vec4 SkinTint;
uniform highp vec4 SkinColor;
uniform highp vec4 RegionRTint;
uniform highp vec4 RegionGTint;
uniform highp vec4 RegionBTint;
uniform highp vec3 RegionTintBlend;
uniform highp float Fresnel;
uniform highp vec3 LightDir;
uniform highp vec4 LightColor;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 backLight_4;
  highp float nl2_5;
  highp vec3 brdfColor_6;
  highp vec3 specular_7;
  highp vec3 regionMaskColor_8;
  highp vec3 mainColor_9;
  highp vec4 color_10;
  highp vec3 mainNormal_11;
  highp vec4 shadowCoord_12;
  shadowCoord_12 = xlv_TEXCOORD4;
  highp float tmpvar_13;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_13 = 1.0;
  } else {
    shadowCoord_12.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_14;
    highp vec4 fetchesOffsetsU_15;
    highp float shadow_16;
    highp vec2 tmpvar_17;
    tmpvar_17 = (shadowCoord_12.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_18;
    tmpvar_18 = floor((tmpvar_17 + 0.5));
    highp vec2 tmpvar_19;
    tmpvar_19 = (tmpvar_17 - tmpvar_18);
    highp vec4 texelsWeightsA_20;
    highp vec4 texelsWeightsB_21;
    highp vec4 computedArea_22;
    highp vec4 computedAreaUncut_23;
    highp float tmpvar_24;
    tmpvar_24 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
    highp float tmpvar_25;
    tmpvar_25 = (tmpvar_24 - tmpvar_19.x);
    computedArea_22.x = tmpvar_25;
    computedAreaUncut_23.x = tmpvar_25;
    computedArea_22.w = tmpvar_24;
    computedAreaUncut_23.w = tmpvar_24;
    computedAreaUncut_23.y = ((1.5 - tmpvar_19.x) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = min (tmpvar_19.x, 0.0);
    computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
    computedAreaUncut_23.z = ((1.5 + tmpvar_19.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = max (tmpvar_19.x, 0.0);
    computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
    texelsWeightsA_20.x = (0.081632 * tmpvar_25);
    texelsWeightsA_20.y = (0.081632 * computedAreaUncut_23.y);
    texelsWeightsA_20.z = (0.081632 * (computedAreaUncut_23.y + 1.0));
    texelsWeightsA_20.w = (0.081632 * (computedArea_22.y + 2.0));
    texelsWeightsB_21.x = (0.081632 * (computedArea_22.z + 2.0));
    texelsWeightsB_21.y = (0.081632 * (computedAreaUncut_23.z + 1.0));
    texelsWeightsB_21.z = (0.081632 * computedAreaUncut_23.z);
    texelsWeightsB_21.w = (0.081632 * tmpvar_24);
    highp vec4 texelsWeightsA_28;
    highp vec4 texelsWeightsB_29;
    highp vec4 computedArea_30;
    highp vec4 computedAreaUncut_31;
    highp float tmpvar_32;
    tmpvar_32 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
    highp float tmpvar_33;
    tmpvar_33 = (tmpvar_32 - tmpvar_19.y);
    computedArea_30.x = tmpvar_33;
    computedAreaUncut_31.x = tmpvar_33;
    computedArea_30.w = tmpvar_32;
    computedAreaUncut_31.w = tmpvar_32;
    computedAreaUncut_31.y = ((1.5 - tmpvar_19.y) - 0.5);
    highp float tmpvar_34;
    tmpvar_34 = min (tmpvar_19.y, 0.0);
    computedArea_30.y = (computedAreaUncut_31.y - (tmpvar_34 * tmpvar_34));
    computedAreaUncut_31.z = ((1.5 + tmpvar_19.y) - 0.5);
    highp float tmpvar_35;
    tmpvar_35 = max (tmpvar_19.y, 0.0);
    computedArea_30.z = (computedAreaUncut_31.z - (tmpvar_35 * tmpvar_35));
    texelsWeightsA_28.x = (0.081632 * tmpvar_33);
    texelsWeightsA_28.y = (0.081632 * computedAreaUncut_31.y);
    texelsWeightsA_28.z = (0.081632 * (computedAreaUncut_31.y + 1.0));
    texelsWeightsA_28.w = (0.081632 * (computedArea_30.y + 2.0));
    texelsWeightsB_29.x = (0.081632 * (computedArea_30.z + 2.0));
    texelsWeightsB_29.y = (0.081632 * (computedAreaUncut_31.z + 1.0));
    texelsWeightsB_29.z = (0.081632 * computedAreaUncut_31.z);
    texelsWeightsB_29.w = (0.081632 * tmpvar_32);
    highp vec4 tmpvar_36;
    tmpvar_36.xy = texelsWeightsA_20.xz;
    tmpvar_36.zw = texelsWeightsB_21.xz;
    highp vec4 tmpvar_37;
    tmpvar_37.xy = texelsWeightsA_20.yw;
    tmpvar_37.zw = texelsWeightsB_21.yw;
    highp vec4 tmpvar_38;
    tmpvar_38 = (tmpvar_36 + tmpvar_37);
    highp vec4 tmpvar_39;
    tmpvar_39.xy = texelsWeightsA_28.xz;
    tmpvar_39.zw = texelsWeightsB_29.xz;
    highp vec4 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_28.yw;
    tmpvar_40.zw = texelsWeightsB_29.yw;
    highp vec4 tmpvar_41;
    tmpvar_41 = (tmpvar_39 + tmpvar_40);
    highp vec4 tmpvar_42;
    tmpvar_42.xy = texelsWeightsA_20.yw;
    tmpvar_42.zw = texelsWeightsB_21.yw;
    highp vec4 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_28.yw;
    tmpvar_43.zw = texelsWeightsB_29.yw;
    fetchesOffsetsU_15 = (((tmpvar_42 / tmpvar_38) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_14 = (((tmpvar_43 / tmpvar_41) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_44;
    tmpvar_44 = (tmpvar_18 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_45;
    tmpvar_45.x = fetchesOffsetsU_15.x;
    tmpvar_45.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_46;
    tmpvar_46.xy = (tmpvar_44 + tmpvar_45);
    tmpvar_46.z = shadowCoord_12.z;
    mediump float tmpvar_47;
    tmpvar_47 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_46);
    shadow_16 = ((tmpvar_38.x * tmpvar_41.x) * tmpvar_47);
    highp vec2 tmpvar_48;
    tmpvar_48.x = fetchesOffsetsU_15.y;
    tmpvar_48.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (tmpvar_44 + tmpvar_48);
    tmpvar_49.z = shadowCoord_12.z;
    mediump float tmpvar_50;
    tmpvar_50 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_49);
    shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.x) * tmpvar_50));
    highp vec2 tmpvar_51;
    tmpvar_51.x = fetchesOffsetsU_15.z;
    tmpvar_51.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_52;
    tmpvar_52.xy = (tmpvar_44 + tmpvar_51);
    tmpvar_52.z = shadowCoord_12.z;
    mediump float tmpvar_53;
    tmpvar_53 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_52);
    shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.x) * tmpvar_53));
    highp vec2 tmpvar_54;
    tmpvar_54.x = fetchesOffsetsU_15.w;
    tmpvar_54.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_55;
    tmpvar_55.xy = (tmpvar_44 + tmpvar_54);
    tmpvar_55.z = shadowCoord_12.z;
    mediump float tmpvar_56;
    tmpvar_56 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_55);
    shadow_16 = (shadow_16 + ((tmpvar_38.w * tmpvar_41.x) * tmpvar_56));
    highp vec2 tmpvar_57;
    tmpvar_57.x = fetchesOffsetsU_15.x;
    tmpvar_57.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_58;
    tmpvar_58.xy = (tmpvar_44 + tmpvar_57);
    tmpvar_58.z = shadowCoord_12.z;
    mediump float tmpvar_59;
    tmpvar_59 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_58);
    shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.y) * tmpvar_59));
    highp vec2 tmpvar_60;
    tmpvar_60.x = fetchesOffsetsU_15.y;
    tmpvar_60.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_61;
    tmpvar_61.xy = (tmpvar_44 + tmpvar_60);
    tmpvar_61.z = shadowCoord_12.z;
    mediump float tmpvar_62;
    tmpvar_62 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_61);
    shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.y) * tmpvar_62));
    highp vec2 tmpvar_63;
    tmpvar_63.x = fetchesOffsetsU_15.z;
    tmpvar_63.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_64;
    tmpvar_64.xy = (tmpvar_44 + tmpvar_63);
    tmpvar_64.z = shadowCoord_12.z;
    mediump float tmpvar_65;
    tmpvar_65 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_64);
    shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.y) * tmpvar_65));
    highp vec2 tmpvar_66;
    tmpvar_66.x = fetchesOffsetsU_15.w;
    tmpvar_66.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_67;
    tmpvar_67.xy = (tmpvar_44 + tmpvar_66);
    tmpvar_67.z = shadowCoord_12.z;
    mediump float tmpvar_68;
    tmpvar_68 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_67);
    shadow_16 = (shadow_16 + ((tmpvar_38.w * tmpvar_41.y) * tmpvar_68));
    highp vec2 tmpvar_69;
    tmpvar_69.x = fetchesOffsetsU_15.x;
    tmpvar_69.y = fetchesOffsetsV_14.z;
    highp vec3 tmpvar_70;
    tmpvar_70.xy = (tmpvar_44 + tmpvar_69);
    tmpvar_70.z = shadowCoord_12.z;
    mediump float tmpvar_71;
    tmpvar_71 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_70);
    shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.z) * tmpvar_71));
    highp vec2 tmpvar_72;
    tmpvar_72.x = fetchesOffsetsU_15.y;
    tmpvar_72.y = fetchesOffsetsV_14.z;
    highp vec3 tmpvar_73;
    tmpvar_73.xy = (tmpvar_44 + tmpvar_72);
    tmpvar_73.z = shadowCoord_12.z;
    mediump float tmpvar_74;
    tmpvar_74 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_73);
    shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.z) * tmpvar_74));
    highp vec2 tmpvar_75;
    tmpvar_75.x = fetchesOffsetsU_15.z;
    tmpvar_75.y = fetchesOffsetsV_14.z;
    highp vec3 tmpvar_76;
    tmpvar_76.xy = (tmpvar_44 + tmpvar_75);
    tmpvar_76.z = shadowCoord_12.z;
    mediump float tmpvar_77;
    tmpvar_77 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_76);
    shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.z) * tmpvar_77));
    highp vec2 tmpvar_78;
    tmpvar_78.x = fetchesOffsetsU_15.w;
    tmpvar_78.y = fetchesOffsetsV_14.z;
    highp vec3 tmpvar_79;
    tmpvar_79.xy = (tmpvar_44 + tmpvar_78);
    tmpvar_79.z = shadowCoord_12.z;
    mediump float tmpvar_80;
    tmpvar_80 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_79);
    shadow_16 = (shadow_16 + ((tmpvar_38.w * tmpvar_41.z) * tmpvar_80));
    highp vec2 tmpvar_81;
    tmpvar_81.x = fetchesOffsetsU_15.x;
    tmpvar_81.y = fetchesOffsetsV_14.w;
    highp vec3 tmpvar_82;
    tmpvar_82.xy = (tmpvar_44 + tmpvar_81);
    tmpvar_82.z = shadowCoord_12.z;
    mediump float tmpvar_83;
    tmpvar_83 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_82);
    shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.w) * tmpvar_83));
    highp vec2 tmpvar_84;
    tmpvar_84.x = fetchesOffsetsU_15.y;
    tmpvar_84.y = fetchesOffsetsV_14.w;
    highp vec3 tmpvar_85;
    tmpvar_85.xy = (tmpvar_44 + tmpvar_84);
    tmpvar_85.z = shadowCoord_12.z;
    mediump float tmpvar_86;
    tmpvar_86 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_85);
    shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.w) * tmpvar_86));
    highp vec2 tmpvar_87;
    tmpvar_87.x = fetchesOffsetsU_15.z;
    tmpvar_87.y = fetchesOffsetsV_14.w;
    highp vec3 tmpvar_88;
    tmpvar_88.xy = (tmpvar_44 + tmpvar_87);
    tmpvar_88.z = shadowCoord_12.z;
    mediump float tmpvar_89;
    tmpvar_89 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_88);
    shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.w) * tmpvar_89));
    highp vec2 tmpvar_90;
    tmpvar_90.x = fetchesOffsetsU_15.w;
    tmpvar_90.y = fetchesOffsetsV_14.w;
    highp vec3 tmpvar_91;
    tmpvar_91.xy = (tmpvar_44 + tmpvar_90);
    tmpvar_91.z = shadowCoord_12.z;
    mediump float tmpvar_92;
    tmpvar_92 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_91);
    shadow_16 = (shadow_16 + ((tmpvar_38.w * tmpvar_41.w) * tmpvar_92));
    tmpvar_13 = mix (1.0, shadow_16, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_93;
  tmpvar_93.x = xlv_TEXCOORD1.w;
  tmpvar_93.y = xlv_TEXCOORD2.w;
  tmpvar_93.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_94;
  tmpvar_94 = normalize((CAMERA_WORLDPOSITION - tmpvar_93));
  lowp vec3 tmpvar_95;
  tmpvar_95 = texture (TexNormal, xlv_TEXCOORD0).xyz;
  mainNormal_11 = tmpvar_95;
  highp vec3 tmpvar_96;
  tmpvar_96 = ((mainNormal_11 * 2.0) - 1.0);
  highp vec3 tmpvar_97;
  tmpvar_97 = normalize(((
    (tmpvar_96.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_96.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_96.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_98;
  tmpvar_98 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_99;
  tmpvar_99 = normalize(LightDir);
  highp float tmpvar_100;
  tmpvar_100 = max (dot (tmpvar_97, tmpvar_94), 0.0);
  highp float tmpvar_101;
  tmpvar_101 = max (dot (tmpvar_97, normalize(
    (tmpvar_94 + tmpvar_98)
  )), 0.0);
  lowp vec4 tmpvar_102;
  tmpvar_102 = texture (DiffuseTex, xlv_TEXCOORD0);
  color_10 = tmpvar_102;
  mainColor_9 = color_10.xyz;
  highp float tmpvar_103;
  tmpvar_103 = color_10.w;
  highp float tmpvar_104;
  if ((SkinColor.x > 0.04045)) {
    tmpvar_104 = pow (((SkinColor.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_104 = (SkinColor.x / 12.92);
  };
  highp float tmpvar_105;
  if ((SkinColor.y > 0.04045)) {
    tmpvar_105 = pow (((SkinColor.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_105 = (SkinColor.y / 12.92);
  };
  highp float tmpvar_106;
  if ((SkinColor.z > 0.04045)) {
    tmpvar_106 = pow (((SkinColor.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_106 = (SkinColor.z / 12.92);
  };
  highp float tmpvar_107;
  tmpvar_107 = (((
    (tmpvar_104 * 0.4124564)
   + 
    (tmpvar_105 * 0.3575761)
  ) + (tmpvar_106 * 0.1804375)) / 0.950456);
  highp float tmpvar_108;
  tmpvar_108 = (((tmpvar_104 * 0.2126729) + (tmpvar_105 * 0.7151522)) + (tmpvar_106 * 0.072175));
  highp float tmpvar_109;
  tmpvar_109 = (((
    (tmpvar_104 * 0.0193339)
   + 
    (tmpvar_105 * 0.119192)
  ) + (tmpvar_106 * 0.9503041)) / 1.088754);
  highp float tmpvar_110;
  if ((tmpvar_107 > 0.008856)) {
    tmpvar_110 = pow (tmpvar_107, 0.3333333);
  } else {
    tmpvar_110 = (((903.3 * tmpvar_107) + 16.0) / 116.0);
  };
  highp float tmpvar_111;
  if ((tmpvar_108 > 0.008856)) {
    tmpvar_111 = pow (tmpvar_108, 0.3333333);
  } else {
    tmpvar_111 = (((903.3 * tmpvar_108) + 16.0) / 116.0);
  };
  highp float tmpvar_112;
  if ((tmpvar_109 > 0.008856)) {
    tmpvar_112 = pow (tmpvar_109, 0.3333333);
  } else {
    tmpvar_112 = (((903.3 * tmpvar_109) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_113;
  tmpvar_113.x = (((116.0 * tmpvar_111) - 16.0) / 100.0);
  tmpvar_113.y = (((500.0 * 
    (tmpvar_110 - tmpvar_111)
  ) + 110.0) / 220.0);
  tmpvar_113.z = (((200.0 * 
    (tmpvar_111 - tmpvar_112)
  ) + 110.0) / 220.0);
  highp float tmpvar_114;
  if ((SkinTint.x > 0.04045)) {
    tmpvar_114 = pow (((SkinTint.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_114 = (SkinTint.x / 12.92);
  };
  highp float tmpvar_115;
  if ((SkinTint.y > 0.04045)) {
    tmpvar_115 = pow (((SkinTint.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_115 = (SkinTint.y / 12.92);
  };
  highp float tmpvar_116;
  if ((SkinTint.z > 0.04045)) {
    tmpvar_116 = pow (((SkinTint.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_116 = (SkinTint.z / 12.92);
  };
  highp float tmpvar_117;
  tmpvar_117 = (((
    (tmpvar_114 * 0.4124564)
   + 
    (tmpvar_115 * 0.3575761)
  ) + (tmpvar_116 * 0.1804375)) / 0.950456);
  highp float tmpvar_118;
  tmpvar_118 = (((tmpvar_114 * 0.2126729) + (tmpvar_115 * 0.7151522)) + (tmpvar_116 * 0.072175));
  highp float tmpvar_119;
  tmpvar_119 = (((
    (tmpvar_114 * 0.0193339)
   + 
    (tmpvar_115 * 0.119192)
  ) + (tmpvar_116 * 0.9503041)) / 1.088754);
  highp float tmpvar_120;
  if ((tmpvar_117 > 0.008856)) {
    tmpvar_120 = pow (tmpvar_117, 0.3333333);
  } else {
    tmpvar_120 = (((903.3 * tmpvar_117) + 16.0) / 116.0);
  };
  highp float tmpvar_121;
  if ((tmpvar_118 > 0.008856)) {
    tmpvar_121 = pow (tmpvar_118, 0.3333333);
  } else {
    tmpvar_121 = (((903.3 * tmpvar_118) + 16.0) / 116.0);
  };
  highp float tmpvar_122;
  if ((tmpvar_119 > 0.008856)) {
    tmpvar_122 = pow (tmpvar_119, 0.3333333);
  } else {
    tmpvar_122 = (((903.3 * tmpvar_119) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_123;
  tmpvar_123.x = (((116.0 * tmpvar_121) - 16.0) / 100.0);
  tmpvar_123.y = (((500.0 * 
    (tmpvar_120 - tmpvar_121)
  ) + 110.0) / 220.0);
  tmpvar_123.z = (((200.0 * 
    (tmpvar_121 - tmpvar_122)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_124;
  tmpvar_124 = (tmpvar_123 - tmpvar_113);
  highp float tmpvar_125;
  if ((color_10.x > 0.04045)) {
    tmpvar_125 = pow (((color_10.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_125 = (color_10.x / 12.92);
  };
  highp float tmpvar_126;
  if ((color_10.y > 0.04045)) {
    tmpvar_126 = pow (((color_10.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_126 = (color_10.y / 12.92);
  };
  highp float tmpvar_127;
  if ((color_10.z > 0.04045)) {
    tmpvar_127 = pow (((color_10.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_127 = (color_10.z / 12.92);
  };
  highp float tmpvar_128;
  tmpvar_128 = (((
    (tmpvar_125 * 0.4124564)
   + 
    (tmpvar_126 * 0.3575761)
  ) + (tmpvar_127 * 0.1804375)) / 0.950456);
  highp float tmpvar_129;
  tmpvar_129 = (((tmpvar_125 * 0.2126729) + (tmpvar_126 * 0.7151522)) + (tmpvar_127 * 0.072175));
  highp float tmpvar_130;
  tmpvar_130 = (((
    (tmpvar_125 * 0.0193339)
   + 
    (tmpvar_126 * 0.119192)
  ) + (tmpvar_127 * 0.9503041)) / 1.088754);
  highp float tmpvar_131;
  if ((tmpvar_128 > 0.008856)) {
    tmpvar_131 = pow (tmpvar_128, 0.3333333);
  } else {
    tmpvar_131 = (((903.3 * tmpvar_128) + 16.0) / 116.0);
  };
  highp float tmpvar_132;
  if ((tmpvar_129 > 0.008856)) {
    tmpvar_132 = pow (tmpvar_129, 0.3333333);
  } else {
    tmpvar_132 = (((903.3 * tmpvar_129) + 16.0) / 116.0);
  };
  highp float tmpvar_133;
  if ((tmpvar_130 > 0.008856)) {
    tmpvar_133 = pow (tmpvar_130, 0.3333333);
  } else {
    tmpvar_133 = (((903.3 * tmpvar_130) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_134;
  tmpvar_134.x = (((116.0 * tmpvar_132) - 16.0) / 100.0);
  tmpvar_134.y = (((500.0 * 
    (tmpvar_131 - tmpvar_132)
  ) + 110.0) / 220.0);
  tmpvar_134.z = (((200.0 * 
    (tmpvar_132 - tmpvar_133)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_135;
  tmpvar_135 = clamp ((tmpvar_134 + tmpvar_124), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float z_136;
  highp float x_137;
  highp float tmpvar_138;
  tmpvar_138 = (((tmpvar_135.x * 100.0) + 16.0) / 116.0);
  highp float tmpvar_139;
  tmpvar_139 = (((
    (tmpvar_135.y * 220.0)
   - 110.0) / 500.0) + tmpvar_138);
  x_137 = tmpvar_139;
  highp float tmpvar_140;
  tmpvar_140 = (tmpvar_138 - ((
    (tmpvar_135.z * 220.0)
   - 110.0) / 200.0));
  z_136 = tmpvar_140;
  highp float tmpvar_141;
  tmpvar_141 = pow (tmpvar_139, 3.0);
  highp float tmpvar_142;
  tmpvar_142 = pow (tmpvar_138, 3.0);
  highp float tmpvar_143;
  tmpvar_143 = pow (tmpvar_140, 3.0);
  highp float tmpvar_144;
  if ((tmpvar_141 > 0.008856)) {
    tmpvar_144 = tmpvar_141;
  } else {
    tmpvar_144 = ((tmpvar_139 - 0.137931) / 7.787069);
  };
  x_137 = (tmpvar_144 * 0.950456);
  highp float tmpvar_145;
  if ((tmpvar_142 > 0.008856)) {
    tmpvar_145 = tmpvar_142;
  } else {
    tmpvar_145 = ((tmpvar_138 - 0.137931) / 7.787069);
  };
  highp float tmpvar_146;
  if ((tmpvar_143 > 0.008856)) {
    tmpvar_146 = tmpvar_143;
  } else {
    tmpvar_146 = ((tmpvar_140 - 0.137931) / 7.787069);
  };
  z_136 = (tmpvar_146 * 1.088754);
  highp float tmpvar_147;
  tmpvar_147 = (((x_137 * 3.240454) + (tmpvar_145 * -1.537138)) + (z_136 * -0.4985314));
  highp float tmpvar_148;
  tmpvar_148 = (((x_137 * -0.969266) + (tmpvar_145 * 1.876011)) + (z_136 * 0.041556));
  highp float tmpvar_149;
  tmpvar_149 = (((x_137 * 0.0556434) + (tmpvar_145 * -0.2040259)) + (z_136 * 1.057225));
  highp float tmpvar_150;
  if ((tmpvar_147 > 0.0031308)) {
    tmpvar_150 = ((1.055 * pow (tmpvar_147, 0.4166667)) - 0.055);
  } else {
    tmpvar_150 = (12.92 * tmpvar_147);
  };
  highp float tmpvar_151;
  if ((tmpvar_148 > 0.0031308)) {
    tmpvar_151 = ((1.055 * pow (tmpvar_148, 0.4166667)) - 0.055);
  } else {
    tmpvar_151 = (12.92 * tmpvar_148);
  };
  highp float tmpvar_152;
  if ((tmpvar_149 > 0.0031308)) {
    tmpvar_152 = ((1.055 * pow (tmpvar_149, 0.4166667)) - 0.055);
  } else {
    tmpvar_152 = (12.92 * tmpvar_149);
  };
  highp vec3 tmpvar_153;
  tmpvar_153.x = tmpvar_150;
  tmpvar_153.y = tmpvar_151;
  tmpvar_153.z = tmpvar_152;
  lowp vec3 tmpvar_154;
  tmpvar_154 = texture (SkinTintMaskTex, xlv_TEXCOORD0).xxx;
  highp vec3 tmpvar_155;
  tmpvar_155 = mix (color_10.xyz, tmpvar_153, tmpvar_154);
  mainColor_9 = (tmpvar_155 * tmpvar_155);
  lowp vec3 tmpvar_156;
  tmpvar_156 = texture (RegionTintMaskTex, xlv_TEXCOORD0).xyz;
  regionMaskColor_8 = tmpvar_156;
  highp vec4 tmpvar_157;
  tmpvar_157.w = 0.0;
  tmpvar_157.xyz = mainColor_9;
  highp vec4 tmpvar_158;
  tmpvar_158.w = 0.0;
  tmpvar_158.xyz = mainColor_9;
  highp vec4 tmpvar_159;
  tmpvar_159.w = 0.0;
  tmpvar_159.xyz = mainColor_9;
  mainColor_9 = (((
    (mainColor_9 * (1.0 - ((regionMaskColor_8.x + regionMaskColor_8.y) + regionMaskColor_8.z)))
   + 
    (mix (tmpvar_157, RegionRTint, RegionTintBlend.xxxx) * regionMaskColor_8.x)
  .xyz) + (
    mix (tmpvar_158, RegionGTint, RegionTintBlend.yyyy)
   * regionMaskColor_8.y).xyz) + (mix (tmpvar_159, RegionBTint, RegionTintBlend.zzzz) * regionMaskColor_8.z).xyz);
  lowp vec3 tmpvar_160;
  tmpvar_160 = texture (TexSpecular, xlv_TEXCOORD0).xyz;
  specular_7 = tmpvar_160;
  highp float tmpvar_161;
  tmpvar_161 = (1.0 - specular_7.x);
  highp vec2 tmpvar_162;
  tmpvar_162.x = (((
    dot (tmpvar_97, tmpvar_98)
   * 0.5) + 0.5) * 0.99);
  tmpvar_162.y = specular_7.y;
  lowp vec3 tmpvar_163;
  tmpvar_163 = texture (TexBRDF, tmpvar_162).xyz;
  brdfColor_6 = tmpvar_163;
  highp float tmpvar_164;
  tmpvar_164 = max (((
    dot (tmpvar_97, tmpvar_99)
   + 0.5) * 0.7), 0.0);
  nl2_5 = (tmpvar_164 * tmpvar_164);
  nl2_5 = (nl2_5 * nl2_5);
  nl2_5 = (nl2_5 * nl2_5);
  backLight_4 = ((nl2_5 * LightColor.xyz) * ((LightIntensity * mainColor_9) * mainNormal_11.z));
  backLight_4 = (backLight_4 / (vec3(1.0, 1.0, 1.0) + backLight_4));
  highp vec3 I_165;
  I_165 = -(tmpvar_94);
  reflectDir_3.xyz = (I_165 - (2.0 * (
    dot (tmpvar_97, I_165)
   * tmpvar_97)));
  reflectDir_3.w = (tmpvar_161 * 4.0);
  lowp vec4 tmpvar_166;
  tmpvar_166 = textureLod (TexSkybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_167;
  tmpvar_167 = tmpvar_166;
  iblColor_2.w = tmpvar_167.w;
  iblColor_2.xyz = ((tmpvar_167.xyz * tmpvar_167.w) * 4.0);
  highp float tmpvar_168;
  tmpvar_168 = max ((tmpvar_161 * tmpvar_161), 0.1);
  highp float tmpvar_169;
  tmpvar_169 = (tmpvar_168 * tmpvar_168);
  highp float tmpvar_170;
  tmpvar_170 = (((
    (tmpvar_101 * tmpvar_169)
   - tmpvar_101) * tmpvar_101) + 1.0);
  d_1 = ((0.3183099 * tmpvar_169) / ((tmpvar_170 * tmpvar_170) + 1e-7));
  highp float tmpvar_171;
  tmpvar_171 = min (d_1, 100.0);
  d_1 = tmpvar_171;
  highp vec4 tmpvar_172;
  tmpvar_172.xyz = (((
    ((tmpvar_171 * mix (Fresnel, 1.0, (1.0 - tmpvar_100))) * LIGHT_COLOR)
   + 
    (((iblColor_2.xyz * 0.5) * ((
      (min ((Fresnel * 2.0), 1.0) - Fresnel)
     * 
      pow ((1.0 - tmpvar_100), 4.0)
    ) + Fresnel)) * AMBIENT_COLOR)
  ) * ColorSpecular.xyz) + ((
    (((mix (ColorShadow.xyz, brdfColor_6, vec3(tmpvar_13)) * LIGHT_COLOR) * mainColor_9) + backLight_4)
   + 
    (AMBIENT_COLOR * mainColor_9)
  ) * mix (ColorShade.xyz, vec3(1.0, 1.0, 1.0), vec3(
    mix (1.0, tmpvar_100, (1.0 - specular_7.z))
  ))));
  tmpvar_172.w = tmpvar_103;
  _glesFragData[0] = tmpvar_172;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexNormal",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSpecular",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexBRDF",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSkybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorShade",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorShadow",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorSpecular",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionRTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionGTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionBTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintBlend",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_15[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_15[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_16[1u] = tmpvar_12[1u].xyz;
  tmpvar_16[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_12[1u].xyz;
  tmpvar_18[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_12[1u].xyz;
  tmpvar_20[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D DiffuseTex;
uniform sampler2D TexNormal;
uniform sampler2D TexSpecular;
uniform sampler2D TexBRDF;
uniform lowp samplerCube TexSkybox;
uniform sampler2D RegionTintMaskTex;
uniform sampler2D SkinTintMaskTex;
uniform highp vec4 ColorShade;
uniform highp vec4 ColorShadow;
uniform highp vec4 ColorSpecular;
uniform highp vec4 SkinTint;
uniform highp vec4 SkinColor;
uniform highp vec4 RegionRTint;
uniform highp vec4 RegionGTint;
uniform highp vec4 RegionBTint;
uniform highp vec3 RegionTintBlend;
uniform highp float Fresnel;
uniform highp vec3 LightDir;
uniform highp vec4 LightColor;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 backLight_4;
  highp float nl2_5;
  highp vec3 brdfColor_6;
  highp vec3 specular_7;
  highp vec3 regionMaskColor_8;
  highp vec3 mainColor_9;
  highp vec4 color_10;
  highp vec3 mainNormal_11;
  highp vec4 shadowCoord_12;
  shadowCoord_12 = xlv_TEXCOORD4;
  highp float tmpvar_13;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_13 = 1.0;
  } else {
    highp vec2 tmpvar_14;
    tmpvar_14.x = LIGHT_PARAM.z;
    tmpvar_14.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_15;
    tmpvar_15.xy = tmpvar_14;
    highp float tmpvar_16;
    tmpvar_16 = (1.0/(LIGHT_PARAM.z));
    tmpvar_15.z = tmpvar_16;
    tmpvar_15.w = tmpvar_16;
    shadowCoord_12.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_17;
    highp vec2 tmpvar_18;
    tmpvar_18 = tmpvar_15.xy;
    shadow_17 = 0.0;
    highp vec3 tmpvar_19;
    tmpvar_19.xy = (shadowCoord_12.xy - LIGHT_PARAM.zz);
    tmpvar_19.z = shadowCoord_12.z;
    highp vec4 tmpvar_20;
    tmpvar_20 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_19.xy);
    highp float tmpvar_21;
    if ((tmpvar_20.x < xlv_TEXCOORD4.z)) {
      tmpvar_21 = 0.0;
    } else {
      tmpvar_21 = 1.0;
    };
    shadow_17 = tmpvar_21;
    highp vec2 tmpvar_22;
    tmpvar_22.x = 0.0;
    tmpvar_22.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_23;
    tmpvar_23.xy = (shadowCoord_12.xy + tmpvar_22);
    tmpvar_23.z = shadowCoord_12.z;
    highp vec4 tmpvar_24;
    tmpvar_24 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_23.xy);
    highp float tmpvar_25;
    if ((tmpvar_24.x < xlv_TEXCOORD4.z)) {
      tmpvar_25 = 0.0;
    } else {
      tmpvar_25 = 1.0;
    };
    shadow_17 = (tmpvar_21 + tmpvar_25);
    highp vec2 tmpvar_26;
    tmpvar_26.x = tmpvar_18.x;
    tmpvar_26.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_27;
    tmpvar_27.xy = (shadowCoord_12.xy + tmpvar_26);
    tmpvar_27.z = shadowCoord_12.z;
    highp vec4 tmpvar_28;
    tmpvar_28 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_27.xy);
    highp float tmpvar_29;
    if ((tmpvar_28.x < xlv_TEXCOORD4.z)) {
      tmpvar_29 = 0.0;
    } else {
      tmpvar_29 = 1.0;
    };
    shadow_17 = (shadow_17 + tmpvar_29);
    highp vec2 tmpvar_30;
    tmpvar_30.y = 0.0;
    tmpvar_30.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_31;
    tmpvar_31.xy = (shadowCoord_12.xy + tmpvar_30);
    tmpvar_31.z = shadowCoord_12.z;
    highp vec4 tmpvar_32;
    tmpvar_32 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_31.xy);
    highp float tmpvar_33;
    if ((tmpvar_32.x < xlv_TEXCOORD4.z)) {
      tmpvar_33 = 0.0;
    } else {
      tmpvar_33 = 1.0;
    };
    shadow_17 = (shadow_17 + tmpvar_33);
    highp vec4 tmpvar_34;
    tmpvar_34 = texture (TEXTURE_SHADOW_DEPTH, shadowCoord_12.xy);
    highp float tmpvar_35;
    if ((tmpvar_34.x < xlv_TEXCOORD4.z)) {
      tmpvar_35 = 0.0;
    } else {
      tmpvar_35 = 1.0;
    };
    shadow_17 = (shadow_17 + tmpvar_35);
    highp vec2 tmpvar_36;
    tmpvar_36.y = 0.0;
    tmpvar_36.x = tmpvar_18.x;
    highp vec3 tmpvar_37;
    tmpvar_37.xy = (shadowCoord_12.xy + tmpvar_36);
    tmpvar_37.z = shadowCoord_12.z;
    highp vec4 tmpvar_38;
    tmpvar_38 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_37.xy);
    highp float tmpvar_39;
    if ((tmpvar_38.x < xlv_TEXCOORD4.z)) {
      tmpvar_39 = 0.0;
    } else {
      tmpvar_39 = 1.0;
    };
    shadow_17 = (shadow_17 + tmpvar_39);
    highp vec2 tmpvar_40;
    tmpvar_40.x = -(LIGHT_PARAM.z);
    tmpvar_40.y = tmpvar_18.y;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (shadowCoord_12.xy + tmpvar_40);
    tmpvar_41.z = shadowCoord_12.z;
    highp vec4 tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41.xy);
    highp float tmpvar_43;
    if ((tmpvar_42.x < xlv_TEXCOORD4.z)) {
      tmpvar_43 = 0.0;
    } else {
      tmpvar_43 = 1.0;
    };
    shadow_17 = (shadow_17 + tmpvar_43);
    highp vec2 tmpvar_44;
    tmpvar_44.x = 0.0;
    tmpvar_44.y = tmpvar_18.y;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (shadowCoord_12.xy + tmpvar_44);
    tmpvar_45.z = shadowCoord_12.z;
    highp vec4 tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45.xy);
    highp float tmpvar_47;
    if ((tmpvar_46.x < xlv_TEXCOORD4.z)) {
      tmpvar_47 = 0.0;
    } else {
      tmpvar_47 = 1.0;
    };
    shadow_17 = (shadow_17 + tmpvar_47);
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (shadowCoord_12.xy + LIGHT_PARAM.zz);
    tmpvar_48.z = shadowCoord_12.z;
    highp vec4 tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48.xy);
    highp float tmpvar_50;
    if ((tmpvar_49.x < xlv_TEXCOORD4.z)) {
      tmpvar_50 = 0.0;
    } else {
      tmpvar_50 = 1.0;
    };
    shadow_17 = (shadow_17 + tmpvar_50);
    shadow_17 = (shadow_17 / 9.0);
    tmpvar_13 = mix (1.0, shadow_17, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_51;
  tmpvar_51.x = xlv_TEXCOORD1.w;
  tmpvar_51.y = xlv_TEXCOORD2.w;
  tmpvar_51.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_52;
  tmpvar_52 = normalize((CAMERA_WORLDPOSITION - tmpvar_51));
  lowp vec3 tmpvar_53;
  tmpvar_53 = texture (TexNormal, xlv_TEXCOORD0).xyz;
  mainNormal_11 = tmpvar_53;
  highp vec3 tmpvar_54;
  tmpvar_54 = ((mainNormal_11 * 2.0) - 1.0);
  highp vec3 tmpvar_55;
  tmpvar_55 = normalize(((
    (tmpvar_54.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_54.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_54.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_56;
  tmpvar_56 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_57;
  tmpvar_57 = normalize(LightDir);
  highp float tmpvar_58;
  tmpvar_58 = max (dot (tmpvar_55, tmpvar_52), 0.0);
  highp float tmpvar_59;
  tmpvar_59 = max (dot (tmpvar_55, normalize(
    (tmpvar_52 + tmpvar_56)
  )), 0.0);
  lowp vec4 tmpvar_60;
  tmpvar_60 = texture (DiffuseTex, xlv_TEXCOORD0);
  color_10 = tmpvar_60;
  mainColor_9 = color_10.xyz;
  highp float tmpvar_61;
  tmpvar_61 = color_10.w;
  highp float tmpvar_62;
  if ((SkinColor.x > 0.04045)) {
    tmpvar_62 = pow (((SkinColor.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_62 = (SkinColor.x / 12.92);
  };
  highp float tmpvar_63;
  if ((SkinColor.y > 0.04045)) {
    tmpvar_63 = pow (((SkinColor.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_63 = (SkinColor.y / 12.92);
  };
  highp float tmpvar_64;
  if ((SkinColor.z > 0.04045)) {
    tmpvar_64 = pow (((SkinColor.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_64 = (SkinColor.z / 12.92);
  };
  highp float tmpvar_65;
  tmpvar_65 = (((
    (tmpvar_62 * 0.4124564)
   + 
    (tmpvar_63 * 0.3575761)
  ) + (tmpvar_64 * 0.1804375)) / 0.950456);
  highp float tmpvar_66;
  tmpvar_66 = (((tmpvar_62 * 0.2126729) + (tmpvar_63 * 0.7151522)) + (tmpvar_64 * 0.072175));
  highp float tmpvar_67;
  tmpvar_67 = (((
    (tmpvar_62 * 0.0193339)
   + 
    (tmpvar_63 * 0.119192)
  ) + (tmpvar_64 * 0.9503041)) / 1.088754);
  highp float tmpvar_68;
  if ((tmpvar_65 > 0.008856)) {
    tmpvar_68 = pow (tmpvar_65, 0.3333333);
  } else {
    tmpvar_68 = (((903.3 * tmpvar_65) + 16.0) / 116.0);
  };
  highp float tmpvar_69;
  if ((tmpvar_66 > 0.008856)) {
    tmpvar_69 = pow (tmpvar_66, 0.3333333);
  } else {
    tmpvar_69 = (((903.3 * tmpvar_66) + 16.0) / 116.0);
  };
  highp float tmpvar_70;
  if ((tmpvar_67 > 0.008856)) {
    tmpvar_70 = pow (tmpvar_67, 0.3333333);
  } else {
    tmpvar_70 = (((903.3 * tmpvar_67) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_71;
  tmpvar_71.x = (((116.0 * tmpvar_69) - 16.0) / 100.0);
  tmpvar_71.y = (((500.0 * 
    (tmpvar_68 - tmpvar_69)
  ) + 110.0) / 220.0);
  tmpvar_71.z = (((200.0 * 
    (tmpvar_69 - tmpvar_70)
  ) + 110.0) / 220.0);
  highp float tmpvar_72;
  if ((SkinTint.x > 0.04045)) {
    tmpvar_72 = pow (((SkinTint.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_72 = (SkinTint.x / 12.92);
  };
  highp float tmpvar_73;
  if ((SkinTint.y > 0.04045)) {
    tmpvar_73 = pow (((SkinTint.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_73 = (SkinTint.y / 12.92);
  };
  highp float tmpvar_74;
  if ((SkinTint.z > 0.04045)) {
    tmpvar_74 = pow (((SkinTint.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_74 = (SkinTint.z / 12.92);
  };
  highp float tmpvar_75;
  tmpvar_75 = (((
    (tmpvar_72 * 0.4124564)
   + 
    (tmpvar_73 * 0.3575761)
  ) + (tmpvar_74 * 0.1804375)) / 0.950456);
  highp float tmpvar_76;
  tmpvar_76 = (((tmpvar_72 * 0.2126729) + (tmpvar_73 * 0.7151522)) + (tmpvar_74 * 0.072175));
  highp float tmpvar_77;
  tmpvar_77 = (((
    (tmpvar_72 * 0.0193339)
   + 
    (tmpvar_73 * 0.119192)
  ) + (tmpvar_74 * 0.9503041)) / 1.088754);
  highp float tmpvar_78;
  if ((tmpvar_75 > 0.008856)) {
    tmpvar_78 = pow (tmpvar_75, 0.3333333);
  } else {
    tmpvar_78 = (((903.3 * tmpvar_75) + 16.0) / 116.0);
  };
  highp float tmpvar_79;
  if ((tmpvar_76 > 0.008856)) {
    tmpvar_79 = pow (tmpvar_76, 0.3333333);
  } else {
    tmpvar_79 = (((903.3 * tmpvar_76) + 16.0) / 116.0);
  };
  highp float tmpvar_80;
  if ((tmpvar_77 > 0.008856)) {
    tmpvar_80 = pow (tmpvar_77, 0.3333333);
  } else {
    tmpvar_80 = (((903.3 * tmpvar_77) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_81;
  tmpvar_81.x = (((116.0 * tmpvar_79) - 16.0) / 100.0);
  tmpvar_81.y = (((500.0 * 
    (tmpvar_78 - tmpvar_79)
  ) + 110.0) / 220.0);
  tmpvar_81.z = (((200.0 * 
    (tmpvar_79 - tmpvar_80)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_82;
  tmpvar_82 = (tmpvar_81 - tmpvar_71);
  highp float tmpvar_83;
  if ((color_10.x > 0.04045)) {
    tmpvar_83 = pow (((color_10.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_83 = (color_10.x / 12.92);
  };
  highp float tmpvar_84;
  if ((color_10.y > 0.04045)) {
    tmpvar_84 = pow (((color_10.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_84 = (color_10.y / 12.92);
  };
  highp float tmpvar_85;
  if ((color_10.z > 0.04045)) {
    tmpvar_85 = pow (((color_10.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_85 = (color_10.z / 12.92);
  };
  highp float tmpvar_86;
  tmpvar_86 = (((
    (tmpvar_83 * 0.4124564)
   + 
    (tmpvar_84 * 0.3575761)
  ) + (tmpvar_85 * 0.1804375)) / 0.950456);
  highp float tmpvar_87;
  tmpvar_87 = (((tmpvar_83 * 0.2126729) + (tmpvar_84 * 0.7151522)) + (tmpvar_85 * 0.072175));
  highp float tmpvar_88;
  tmpvar_88 = (((
    (tmpvar_83 * 0.0193339)
   + 
    (tmpvar_84 * 0.119192)
  ) + (tmpvar_85 * 0.9503041)) / 1.088754);
  highp float tmpvar_89;
  if ((tmpvar_86 > 0.008856)) {
    tmpvar_89 = pow (tmpvar_86, 0.3333333);
  } else {
    tmpvar_89 = (((903.3 * tmpvar_86) + 16.0) / 116.0);
  };
  highp float tmpvar_90;
  if ((tmpvar_87 > 0.008856)) {
    tmpvar_90 = pow (tmpvar_87, 0.3333333);
  } else {
    tmpvar_90 = (((903.3 * tmpvar_87) + 16.0) / 116.0);
  };
  highp float tmpvar_91;
  if ((tmpvar_88 > 0.008856)) {
    tmpvar_91 = pow (tmpvar_88, 0.3333333);
  } else {
    tmpvar_91 = (((903.3 * tmpvar_88) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_92;
  tmpvar_92.x = (((116.0 * tmpvar_90) - 16.0) / 100.0);
  tmpvar_92.y = (((500.0 * 
    (tmpvar_89 - tmpvar_90)
  ) + 110.0) / 220.0);
  tmpvar_92.z = (((200.0 * 
    (tmpvar_90 - tmpvar_91)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_93;
  tmpvar_93 = clamp ((tmpvar_92 + tmpvar_82), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float z_94;
  highp float x_95;
  highp float tmpvar_96;
  tmpvar_96 = (((tmpvar_93.x * 100.0) + 16.0) / 116.0);
  highp float tmpvar_97;
  tmpvar_97 = (((
    (tmpvar_93.y * 220.0)
   - 110.0) / 500.0) + tmpvar_96);
  x_95 = tmpvar_97;
  highp float tmpvar_98;
  tmpvar_98 = (tmpvar_96 - ((
    (tmpvar_93.z * 220.0)
   - 110.0) / 200.0));
  z_94 = tmpvar_98;
  highp float tmpvar_99;
  tmpvar_99 = pow (tmpvar_97, 3.0);
  highp float tmpvar_100;
  tmpvar_100 = pow (tmpvar_96, 3.0);
  highp float tmpvar_101;
  tmpvar_101 = pow (tmpvar_98, 3.0);
  highp float tmpvar_102;
  if ((tmpvar_99 > 0.008856)) {
    tmpvar_102 = tmpvar_99;
  } else {
    tmpvar_102 = ((tmpvar_97 - 0.137931) / 7.787069);
  };
  x_95 = (tmpvar_102 * 0.950456);
  highp float tmpvar_103;
  if ((tmpvar_100 > 0.008856)) {
    tmpvar_103 = tmpvar_100;
  } else {
    tmpvar_103 = ((tmpvar_96 - 0.137931) / 7.787069);
  };
  highp float tmpvar_104;
  if ((tmpvar_101 > 0.008856)) {
    tmpvar_104 = tmpvar_101;
  } else {
    tmpvar_104 = ((tmpvar_98 - 0.137931) / 7.787069);
  };
  z_94 = (tmpvar_104 * 1.088754);
  highp float tmpvar_105;
  tmpvar_105 = (((x_95 * 3.240454) + (tmpvar_103 * -1.537138)) + (z_94 * -0.4985314));
  highp float tmpvar_106;
  tmpvar_106 = (((x_95 * -0.969266) + (tmpvar_103 * 1.876011)) + (z_94 * 0.041556));
  highp float tmpvar_107;
  tmpvar_107 = (((x_95 * 0.0556434) + (tmpvar_103 * -0.2040259)) + (z_94 * 1.057225));
  highp float tmpvar_108;
  if ((tmpvar_105 > 0.0031308)) {
    tmpvar_108 = ((1.055 * pow (tmpvar_105, 0.4166667)) - 0.055);
  } else {
    tmpvar_108 = (12.92 * tmpvar_105);
  };
  highp float tmpvar_109;
  if ((tmpvar_106 > 0.0031308)) {
    tmpvar_109 = ((1.055 * pow (tmpvar_106, 0.4166667)) - 0.055);
  } else {
    tmpvar_109 = (12.92 * tmpvar_106);
  };
  highp float tmpvar_110;
  if ((tmpvar_107 > 0.0031308)) {
    tmpvar_110 = ((1.055 * pow (tmpvar_107, 0.4166667)) - 0.055);
  } else {
    tmpvar_110 = (12.92 * tmpvar_107);
  };
  highp vec3 tmpvar_111;
  tmpvar_111.x = tmpvar_108;
  tmpvar_111.y = tmpvar_109;
  tmpvar_111.z = tmpvar_110;
  lowp vec3 tmpvar_112;
  tmpvar_112 = texture (SkinTintMaskTex, xlv_TEXCOORD0).xxx;
  highp vec3 tmpvar_113;
  tmpvar_113 = mix (color_10.xyz, tmpvar_111, tmpvar_112);
  mainColor_9 = (tmpvar_113 * tmpvar_113);
  lowp vec3 tmpvar_114;
  tmpvar_114 = texture (RegionTintMaskTex, xlv_TEXCOORD0).xyz;
  regionMaskColor_8 = tmpvar_114;
  highp vec4 tmpvar_115;
  tmpvar_115.w = 0.0;
  tmpvar_115.xyz = mainColor_9;
  highp vec4 tmpvar_116;
  tmpvar_116.w = 0.0;
  tmpvar_116.xyz = mainColor_9;
  highp vec4 tmpvar_117;
  tmpvar_117.w = 0.0;
  tmpvar_117.xyz = mainColor_9;
  mainColor_9 = (((
    (mainColor_9 * (1.0 - ((regionMaskColor_8.x + regionMaskColor_8.y) + regionMaskColor_8.z)))
   + 
    (mix (tmpvar_115, RegionRTint, RegionTintBlend.xxxx) * regionMaskColor_8.x)
  .xyz) + (
    mix (tmpvar_116, RegionGTint, RegionTintBlend.yyyy)
   * regionMaskColor_8.y).xyz) + (mix (tmpvar_117, RegionBTint, RegionTintBlend.zzzz) * regionMaskColor_8.z).xyz);
  lowp vec3 tmpvar_118;
  tmpvar_118 = texture (TexSpecular, xlv_TEXCOORD0).xyz;
  specular_7 = tmpvar_118;
  highp float tmpvar_119;
  tmpvar_119 = (1.0 - specular_7.x);
  highp vec2 tmpvar_120;
  tmpvar_120.x = (((
    dot (tmpvar_55, tmpvar_56)
   * 0.5) + 0.5) * 0.99);
  tmpvar_120.y = specular_7.y;
  lowp vec3 tmpvar_121;
  tmpvar_121 = texture (TexBRDF, tmpvar_120).xyz;
  brdfColor_6 = tmpvar_121;
  highp float tmpvar_122;
  tmpvar_122 = max (((
    dot (tmpvar_55, tmpvar_57)
   + 0.5) * 0.7), 0.0);
  nl2_5 = (tmpvar_122 * tmpvar_122);
  nl2_5 = (nl2_5 * nl2_5);
  nl2_5 = (nl2_5 * nl2_5);
  backLight_4 = ((nl2_5 * LightColor.xyz) * ((LightIntensity * mainColor_9) * mainNormal_11.z));
  backLight_4 = (backLight_4 / (vec3(1.0, 1.0, 1.0) + backLight_4));
  highp vec3 I_123;
  I_123 = -(tmpvar_52);
  reflectDir_3.xyz = (I_123 - (2.0 * (
    dot (tmpvar_55, I_123)
   * tmpvar_55)));
  reflectDir_3.w = (tmpvar_119 * 4.0);
  lowp vec4 tmpvar_124;
  tmpvar_124 = textureLod (TexSkybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_125;
  tmpvar_125 = tmpvar_124;
  iblColor_2.w = tmpvar_125.w;
  iblColor_2.xyz = ((tmpvar_125.xyz * tmpvar_125.w) * 4.0);
  highp float tmpvar_126;
  tmpvar_126 = max ((tmpvar_119 * tmpvar_119), 0.1);
  highp float tmpvar_127;
  tmpvar_127 = (tmpvar_126 * tmpvar_126);
  highp float tmpvar_128;
  tmpvar_128 = (((
    (tmpvar_59 * tmpvar_127)
   - tmpvar_59) * tmpvar_59) + 1.0);
  d_1 = ((0.3183099 * tmpvar_127) / ((tmpvar_128 * tmpvar_128) + 1e-7));
  highp float tmpvar_129;
  tmpvar_129 = min (d_1, 100.0);
  d_1 = tmpvar_129;
  highp vec4 tmpvar_130;
  tmpvar_130.xyz = (((
    ((tmpvar_129 * mix (Fresnel, 1.0, (1.0 - tmpvar_58))) * LIGHT_COLOR)
   + 
    (((iblColor_2.xyz * 0.5) * ((
      (min ((Fresnel * 2.0), 1.0) - Fresnel)
     * 
      pow ((1.0 - tmpvar_58), 4.0)
    ) + Fresnel)) * AMBIENT_COLOR)
  ) * ColorSpecular.xyz) + ((
    (((mix (ColorShadow.xyz, brdfColor_6, vec3(tmpvar_13)) * LIGHT_COLOR) * mainColor_9) + backLight_4)
   + 
    (AMBIENT_COLOR * mainColor_9)
  ) * mix (ColorShade.xyz, vec3(1.0, 1.0, 1.0), vec3(
    mix (1.0, tmpvar_58, (1.0 - specular_7.z))
  ))));
  tmpvar_130.w = tmpvar_61;
  _glesFragData[0] = tmpvar_130;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexNormal",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSpecular",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexBRDF",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSkybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorShade",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorSpecular",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionRTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionGTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionBTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintBlend",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_9[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_9[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D DiffuseTex;
uniform sampler2D TexNormal;
uniform sampler2D TexSpecular;
uniform sampler2D TexBRDF;
uniform lowp samplerCube TexSkybox;
uniform sampler2D RegionTintMaskTex;
uniform sampler2D SkinTintMaskTex;
uniform highp vec4 ColorShade;
uniform highp vec4 ColorSpecular;
uniform highp vec4 SkinTint;
uniform highp vec4 SkinColor;
uniform highp vec4 RegionRTint;
uniform highp vec4 RegionGTint;
uniform highp vec4 RegionBTint;
uniform highp vec3 RegionTintBlend;
uniform highp float Fresnel;
uniform highp vec3 LightDir;
uniform highp vec4 LightColor;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 backLight_4;
  highp float nl2_5;
  highp vec3 brdfColor_6;
  highp vec3 specular_7;
  highp vec3 regionMaskColor_8;
  highp vec3 mainColor_9;
  highp vec4 color_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (TexNormal, xlv_TEXCOORD0).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((
    (tmpvar_15.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_15.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_15.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_17;
  tmpvar_17 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_18;
  tmpvar_18 = normalize(LightDir);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_16, tmpvar_13), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_16, normalize(
    (tmpvar_13 + tmpvar_17)
  )), 0.0);
  lowp vec4 tmpvar_21;
  tmpvar_21 = texture (DiffuseTex, xlv_TEXCOORD0);
  color_10 = tmpvar_21;
  mainColor_9 = color_10.xyz;
  highp float tmpvar_22;
  tmpvar_22 = color_10.w;
  highp float tmpvar_23;
  if ((SkinColor.x > 0.04045)) {
    tmpvar_23 = pow (((SkinColor.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_23 = (SkinColor.x / 12.92);
  };
  highp float tmpvar_24;
  if ((SkinColor.y > 0.04045)) {
    tmpvar_24 = pow (((SkinColor.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_24 = (SkinColor.y / 12.92);
  };
  highp float tmpvar_25;
  if ((SkinColor.z > 0.04045)) {
    tmpvar_25 = pow (((SkinColor.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_25 = (SkinColor.z / 12.92);
  };
  highp float tmpvar_26;
  tmpvar_26 = (((
    (tmpvar_23 * 0.4124564)
   + 
    (tmpvar_24 * 0.3575761)
  ) + (tmpvar_25 * 0.1804375)) / 0.950456);
  highp float tmpvar_27;
  tmpvar_27 = (((tmpvar_23 * 0.2126729) + (tmpvar_24 * 0.7151522)) + (tmpvar_25 * 0.072175));
  highp float tmpvar_28;
  tmpvar_28 = (((
    (tmpvar_23 * 0.0193339)
   + 
    (tmpvar_24 * 0.119192)
  ) + (tmpvar_25 * 0.9503041)) / 1.088754);
  highp float tmpvar_29;
  if ((tmpvar_26 > 0.008856)) {
    tmpvar_29 = pow (tmpvar_26, 0.3333333);
  } else {
    tmpvar_29 = (((903.3 * tmpvar_26) + 16.0) / 116.0);
  };
  highp float tmpvar_30;
  if ((tmpvar_27 > 0.008856)) {
    tmpvar_30 = pow (tmpvar_27, 0.3333333);
  } else {
    tmpvar_30 = (((903.3 * tmpvar_27) + 16.0) / 116.0);
  };
  highp float tmpvar_31;
  if ((tmpvar_28 > 0.008856)) {
    tmpvar_31 = pow (tmpvar_28, 0.3333333);
  } else {
    tmpvar_31 = (((903.3 * tmpvar_28) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_32;
  tmpvar_32.x = (((116.0 * tmpvar_30) - 16.0) / 100.0);
  tmpvar_32.y = (((500.0 * 
    (tmpvar_29 - tmpvar_30)
  ) + 110.0) / 220.0);
  tmpvar_32.z = (((200.0 * 
    (tmpvar_30 - tmpvar_31)
  ) + 110.0) / 220.0);
  highp float tmpvar_33;
  if ((SkinTint.x > 0.04045)) {
    tmpvar_33 = pow (((SkinTint.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_33 = (SkinTint.x / 12.92);
  };
  highp float tmpvar_34;
  if ((SkinTint.y > 0.04045)) {
    tmpvar_34 = pow (((SkinTint.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_34 = (SkinTint.y / 12.92);
  };
  highp float tmpvar_35;
  if ((SkinTint.z > 0.04045)) {
    tmpvar_35 = pow (((SkinTint.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_35 = (SkinTint.z / 12.92);
  };
  highp float tmpvar_36;
  tmpvar_36 = (((
    (tmpvar_33 * 0.4124564)
   + 
    (tmpvar_34 * 0.3575761)
  ) + (tmpvar_35 * 0.1804375)) / 0.950456);
  highp float tmpvar_37;
  tmpvar_37 = (((tmpvar_33 * 0.2126729) + (tmpvar_34 * 0.7151522)) + (tmpvar_35 * 0.072175));
  highp float tmpvar_38;
  tmpvar_38 = (((
    (tmpvar_33 * 0.0193339)
   + 
    (tmpvar_34 * 0.119192)
  ) + (tmpvar_35 * 0.9503041)) / 1.088754);
  highp float tmpvar_39;
  if ((tmpvar_36 > 0.008856)) {
    tmpvar_39 = pow (tmpvar_36, 0.3333333);
  } else {
    tmpvar_39 = (((903.3 * tmpvar_36) + 16.0) / 116.0);
  };
  highp float tmpvar_40;
  if ((tmpvar_37 > 0.008856)) {
    tmpvar_40 = pow (tmpvar_37, 0.3333333);
  } else {
    tmpvar_40 = (((903.3 * tmpvar_37) + 16.0) / 116.0);
  };
  highp float tmpvar_41;
  if ((tmpvar_38 > 0.008856)) {
    tmpvar_41 = pow (tmpvar_38, 0.3333333);
  } else {
    tmpvar_41 = (((903.3 * tmpvar_38) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_42;
  tmpvar_42.x = (((116.0 * tmpvar_40) - 16.0) / 100.0);
  tmpvar_42.y = (((500.0 * 
    (tmpvar_39 - tmpvar_40)
  ) + 110.0) / 220.0);
  tmpvar_42.z = (((200.0 * 
    (tmpvar_40 - tmpvar_41)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_43;
  tmpvar_43 = (tmpvar_42 - tmpvar_32);
  highp float tmpvar_44;
  if ((color_10.x > 0.04045)) {
    tmpvar_44 = pow (((color_10.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_44 = (color_10.x / 12.92);
  };
  highp float tmpvar_45;
  if ((color_10.y > 0.04045)) {
    tmpvar_45 = pow (((color_10.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_45 = (color_10.y / 12.92);
  };
  highp float tmpvar_46;
  if ((color_10.z > 0.04045)) {
    tmpvar_46 = pow (((color_10.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_46 = (color_10.z / 12.92);
  };
  highp float tmpvar_47;
  tmpvar_47 = (((
    (tmpvar_44 * 0.4124564)
   + 
    (tmpvar_45 * 0.3575761)
  ) + (tmpvar_46 * 0.1804375)) / 0.950456);
  highp float tmpvar_48;
  tmpvar_48 = (((tmpvar_44 * 0.2126729) + (tmpvar_45 * 0.7151522)) + (tmpvar_46 * 0.072175));
  highp float tmpvar_49;
  tmpvar_49 = (((
    (tmpvar_44 * 0.0193339)
   + 
    (tmpvar_45 * 0.119192)
  ) + (tmpvar_46 * 0.9503041)) / 1.088754);
  highp float tmpvar_50;
  if ((tmpvar_47 > 0.008856)) {
    tmpvar_50 = pow (tmpvar_47, 0.3333333);
  } else {
    tmpvar_50 = (((903.3 * tmpvar_47) + 16.0) / 116.0);
  };
  highp float tmpvar_51;
  if ((tmpvar_48 > 0.008856)) {
    tmpvar_51 = pow (tmpvar_48, 0.3333333);
  } else {
    tmpvar_51 = (((903.3 * tmpvar_48) + 16.0) / 116.0);
  };
  highp float tmpvar_52;
  if ((tmpvar_49 > 0.008856)) {
    tmpvar_52 = pow (tmpvar_49, 0.3333333);
  } else {
    tmpvar_52 = (((903.3 * tmpvar_49) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_53;
  tmpvar_53.x = (((116.0 * tmpvar_51) - 16.0) / 100.0);
  tmpvar_53.y = (((500.0 * 
    (tmpvar_50 - tmpvar_51)
  ) + 110.0) / 220.0);
  tmpvar_53.z = (((200.0 * 
    (tmpvar_51 - tmpvar_52)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_54;
  tmpvar_54 = clamp ((tmpvar_53 + tmpvar_43), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float z_55;
  highp float x_56;
  highp float tmpvar_57;
  tmpvar_57 = (((tmpvar_54.x * 100.0) + 16.0) / 116.0);
  highp float tmpvar_58;
  tmpvar_58 = (((
    (tmpvar_54.y * 220.0)
   - 110.0) / 500.0) + tmpvar_57);
  x_56 = tmpvar_58;
  highp float tmpvar_59;
  tmpvar_59 = (tmpvar_57 - ((
    (tmpvar_54.z * 220.0)
   - 110.0) / 200.0));
  z_55 = tmpvar_59;
  highp float tmpvar_60;
  tmpvar_60 = pow (tmpvar_58, 3.0);
  highp float tmpvar_61;
  tmpvar_61 = pow (tmpvar_57, 3.0);
  highp float tmpvar_62;
  tmpvar_62 = pow (tmpvar_59, 3.0);
  highp float tmpvar_63;
  if ((tmpvar_60 > 0.008856)) {
    tmpvar_63 = tmpvar_60;
  } else {
    tmpvar_63 = ((tmpvar_58 - 0.137931) / 7.787069);
  };
  x_56 = (tmpvar_63 * 0.950456);
  highp float tmpvar_64;
  if ((tmpvar_61 > 0.008856)) {
    tmpvar_64 = tmpvar_61;
  } else {
    tmpvar_64 = ((tmpvar_57 - 0.137931) / 7.787069);
  };
  highp float tmpvar_65;
  if ((tmpvar_62 > 0.008856)) {
    tmpvar_65 = tmpvar_62;
  } else {
    tmpvar_65 = ((tmpvar_59 - 0.137931) / 7.787069);
  };
  z_55 = (tmpvar_65 * 1.088754);
  highp float tmpvar_66;
  tmpvar_66 = (((x_56 * 3.240454) + (tmpvar_64 * -1.537138)) + (z_55 * -0.4985314));
  highp float tmpvar_67;
  tmpvar_67 = (((x_56 * -0.969266) + (tmpvar_64 * 1.876011)) + (z_55 * 0.041556));
  highp float tmpvar_68;
  tmpvar_68 = (((x_56 * 0.0556434) + (tmpvar_64 * -0.2040259)) + (z_55 * 1.057225));
  highp float tmpvar_69;
  if ((tmpvar_66 > 0.0031308)) {
    tmpvar_69 = ((1.055 * pow (tmpvar_66, 0.4166667)) - 0.055);
  } else {
    tmpvar_69 = (12.92 * tmpvar_66);
  };
  highp float tmpvar_70;
  if ((tmpvar_67 > 0.0031308)) {
    tmpvar_70 = ((1.055 * pow (tmpvar_67, 0.4166667)) - 0.055);
  } else {
    tmpvar_70 = (12.92 * tmpvar_67);
  };
  highp float tmpvar_71;
  if ((tmpvar_68 > 0.0031308)) {
    tmpvar_71 = ((1.055 * pow (tmpvar_68, 0.4166667)) - 0.055);
  } else {
    tmpvar_71 = (12.92 * tmpvar_68);
  };
  highp vec3 tmpvar_72;
  tmpvar_72.x = tmpvar_69;
  tmpvar_72.y = tmpvar_70;
  tmpvar_72.z = tmpvar_71;
  lowp vec3 tmpvar_73;
  tmpvar_73 = texture (SkinTintMaskTex, xlv_TEXCOORD0).xxx;
  highp vec3 tmpvar_74;
  tmpvar_74 = mix (color_10.xyz, tmpvar_72, tmpvar_73);
  mainColor_9 = (tmpvar_74 * tmpvar_74);
  lowp vec3 tmpvar_75;
  tmpvar_75 = texture (RegionTintMaskTex, xlv_TEXCOORD0).xyz;
  regionMaskColor_8 = tmpvar_75;
  highp vec4 tmpvar_76;
  tmpvar_76.w = 0.0;
  tmpvar_76.xyz = mainColor_9;
  highp vec4 tmpvar_77;
  tmpvar_77.w = 0.0;
  tmpvar_77.xyz = mainColor_9;
  highp vec4 tmpvar_78;
  tmpvar_78.w = 0.0;
  tmpvar_78.xyz = mainColor_9;
  mainColor_9 = (((
    (mainColor_9 * (1.0 - ((regionMaskColor_8.x + regionMaskColor_8.y) + regionMaskColor_8.z)))
   + 
    (mix (tmpvar_76, RegionRTint, RegionTintBlend.xxxx) * regionMaskColor_8.x)
  .xyz) + (
    mix (tmpvar_77, RegionGTint, RegionTintBlend.yyyy)
   * regionMaskColor_8.y).xyz) + (mix (tmpvar_78, RegionBTint, RegionTintBlend.zzzz) * regionMaskColor_8.z).xyz);
  lowp vec3 tmpvar_79;
  tmpvar_79 = texture (TexSpecular, xlv_TEXCOORD0).xyz;
  specular_7 = tmpvar_79;
  highp float tmpvar_80;
  tmpvar_80 = (1.0 - specular_7.x);
  highp vec2 tmpvar_81;
  tmpvar_81.x = (((
    dot (tmpvar_16, tmpvar_17)
   * 0.5) + 0.5) * 0.99);
  tmpvar_81.y = specular_7.y;
  lowp vec3 tmpvar_82;
  tmpvar_82 = texture (TexBRDF, tmpvar_81).xyz;
  brdfColor_6 = tmpvar_82;
  highp float tmpvar_83;
  tmpvar_83 = max (((
    dot (tmpvar_16, tmpvar_18)
   + 0.5) * 0.7), 0.0);
  nl2_5 = (tmpvar_83 * tmpvar_83);
  nl2_5 = (nl2_5 * nl2_5);
  nl2_5 = (nl2_5 * nl2_5);
  backLight_4 = ((nl2_5 * LightColor.xyz) * ((LightIntensity * mainColor_9) * mainNormal_11.z));
  backLight_4 = (backLight_4 / (vec3(1.0, 1.0, 1.0) + backLight_4));
  highp vec3 I_84;
  I_84 = -(tmpvar_13);
  reflectDir_3.xyz = (I_84 - (2.0 * (
    dot (tmpvar_16, I_84)
   * tmpvar_16)));
  reflectDir_3.w = (tmpvar_80 * 4.0);
  lowp vec4 tmpvar_85;
  tmpvar_85 = textureLod (TexSkybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_86;
  tmpvar_86 = tmpvar_85;
  iblColor_2.w = tmpvar_86.w;
  iblColor_2.xyz = ((tmpvar_86.xyz * tmpvar_86.w) * 4.0);
  highp float tmpvar_87;
  tmpvar_87 = max ((tmpvar_80 * tmpvar_80), 0.1);
  highp float tmpvar_88;
  tmpvar_88 = (tmpvar_87 * tmpvar_87);
  highp float tmpvar_89;
  tmpvar_89 = (((
    (tmpvar_20 * tmpvar_88)
   - tmpvar_20) * tmpvar_20) + 1.0);
  d_1 = ((0.3183099 * tmpvar_88) / ((tmpvar_89 * tmpvar_89) + 1e-7));
  highp float tmpvar_90;
  tmpvar_90 = min (d_1, 100.0);
  d_1 = tmpvar_90;
  highp vec4 tmpvar_91;
  tmpvar_91.xyz = (((
    ((tmpvar_90 * mix (Fresnel, 1.0, (1.0 - tmpvar_19))) * LIGHT_COLOR)
   + 
    (((iblColor_2.xyz * 0.5) * ((
      (min ((Fresnel * 2.0), 1.0) - Fresnel)
     * 
      pow ((1.0 - tmpvar_19), 4.0)
    ) + Fresnel)) * AMBIENT_COLOR)
  ) * ColorSpecular.xyz) + ((
    (((brdfColor_6 * LIGHT_COLOR) * mainColor_9) + backLight_4)
   + 
    (AMBIENT_COLOR * mainColor_9)
  ) * mix (ColorShade.xyz, vec3(1.0, 1.0, 1.0), vec3(
    mix (1.0, tmpvar_19, (1.0 - specular_7.z))
  ))));
  tmpvar_91.w = tmpvar_22;
  _glesFragData[0] = tmpvar_91;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexNormal",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSpecular",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexBRDF",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSkybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorShade",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorSpecular",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionRTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionGTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionBTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintBlend",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_9[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_9[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D DiffuseTex;
uniform sampler2D TexNormal;
uniform sampler2D TexSpecular;
uniform sampler2D TexBRDF;
uniform lowp samplerCube TexSkybox;
uniform sampler2D RegionTintMaskTex;
uniform sampler2D SkinTintMaskTex;
uniform highp vec4 ColorShade;
uniform highp vec4 ColorSpecular;
uniform highp vec4 SkinTint;
uniform highp vec4 SkinColor;
uniform highp vec4 RegionRTint;
uniform highp vec4 RegionGTint;
uniform highp vec4 RegionBTint;
uniform highp vec3 RegionTintBlend;
uniform highp float Fresnel;
uniform highp vec3 LightDir;
uniform highp vec4 LightColor;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 backLight_4;
  highp float nl2_5;
  highp vec3 brdfColor_6;
  highp vec3 specular_7;
  highp vec3 regionMaskColor_8;
  highp vec3 mainColor_9;
  highp vec4 color_10;
  highp vec3 mainNormal_11;
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  tmpvar_13 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture (TexNormal, xlv_TEXCOORD0).xyz;
  mainNormal_11 = tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = ((mainNormal_11 * 2.0) - 1.0);
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((
    (tmpvar_15.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_15.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_15.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_17;
  tmpvar_17 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_18;
  tmpvar_18 = normalize(LightDir);
  highp float tmpvar_19;
  tmpvar_19 = max (dot (tmpvar_16, tmpvar_13), 0.0);
  highp float tmpvar_20;
  tmpvar_20 = max (dot (tmpvar_16, normalize(
    (tmpvar_13 + tmpvar_17)
  )), 0.0);
  lowp vec4 tmpvar_21;
  tmpvar_21 = texture (DiffuseTex, xlv_TEXCOORD0);
  color_10 = tmpvar_21;
  mainColor_9 = color_10.xyz;
  highp float tmpvar_22;
  tmpvar_22 = color_10.w;
  highp float tmpvar_23;
  if ((SkinColor.x > 0.04045)) {
    tmpvar_23 = pow (((SkinColor.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_23 = (SkinColor.x / 12.92);
  };
  highp float tmpvar_24;
  if ((SkinColor.y > 0.04045)) {
    tmpvar_24 = pow (((SkinColor.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_24 = (SkinColor.y / 12.92);
  };
  highp float tmpvar_25;
  if ((SkinColor.z > 0.04045)) {
    tmpvar_25 = pow (((SkinColor.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_25 = (SkinColor.z / 12.92);
  };
  highp float tmpvar_26;
  tmpvar_26 = (((
    (tmpvar_23 * 0.4124564)
   + 
    (tmpvar_24 * 0.3575761)
  ) + (tmpvar_25 * 0.1804375)) / 0.950456);
  highp float tmpvar_27;
  tmpvar_27 = (((tmpvar_23 * 0.2126729) + (tmpvar_24 * 0.7151522)) + (tmpvar_25 * 0.072175));
  highp float tmpvar_28;
  tmpvar_28 = (((
    (tmpvar_23 * 0.0193339)
   + 
    (tmpvar_24 * 0.119192)
  ) + (tmpvar_25 * 0.9503041)) / 1.088754);
  highp float tmpvar_29;
  if ((tmpvar_26 > 0.008856)) {
    tmpvar_29 = pow (tmpvar_26, 0.3333333);
  } else {
    tmpvar_29 = (((903.3 * tmpvar_26) + 16.0) / 116.0);
  };
  highp float tmpvar_30;
  if ((tmpvar_27 > 0.008856)) {
    tmpvar_30 = pow (tmpvar_27, 0.3333333);
  } else {
    tmpvar_30 = (((903.3 * tmpvar_27) + 16.0) / 116.0);
  };
  highp float tmpvar_31;
  if ((tmpvar_28 > 0.008856)) {
    tmpvar_31 = pow (tmpvar_28, 0.3333333);
  } else {
    tmpvar_31 = (((903.3 * tmpvar_28) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_32;
  tmpvar_32.x = (((116.0 * tmpvar_30) - 16.0) / 100.0);
  tmpvar_32.y = (((500.0 * 
    (tmpvar_29 - tmpvar_30)
  ) + 110.0) / 220.0);
  tmpvar_32.z = (((200.0 * 
    (tmpvar_30 - tmpvar_31)
  ) + 110.0) / 220.0);
  highp float tmpvar_33;
  if ((SkinTint.x > 0.04045)) {
    tmpvar_33 = pow (((SkinTint.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_33 = (SkinTint.x / 12.92);
  };
  highp float tmpvar_34;
  if ((SkinTint.y > 0.04045)) {
    tmpvar_34 = pow (((SkinTint.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_34 = (SkinTint.y / 12.92);
  };
  highp float tmpvar_35;
  if ((SkinTint.z > 0.04045)) {
    tmpvar_35 = pow (((SkinTint.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_35 = (SkinTint.z / 12.92);
  };
  highp float tmpvar_36;
  tmpvar_36 = (((
    (tmpvar_33 * 0.4124564)
   + 
    (tmpvar_34 * 0.3575761)
  ) + (tmpvar_35 * 0.1804375)) / 0.950456);
  highp float tmpvar_37;
  tmpvar_37 = (((tmpvar_33 * 0.2126729) + (tmpvar_34 * 0.7151522)) + (tmpvar_35 * 0.072175));
  highp float tmpvar_38;
  tmpvar_38 = (((
    (tmpvar_33 * 0.0193339)
   + 
    (tmpvar_34 * 0.119192)
  ) + (tmpvar_35 * 0.9503041)) / 1.088754);
  highp float tmpvar_39;
  if ((tmpvar_36 > 0.008856)) {
    tmpvar_39 = pow (tmpvar_36, 0.3333333);
  } else {
    tmpvar_39 = (((903.3 * tmpvar_36) + 16.0) / 116.0);
  };
  highp float tmpvar_40;
  if ((tmpvar_37 > 0.008856)) {
    tmpvar_40 = pow (tmpvar_37, 0.3333333);
  } else {
    tmpvar_40 = (((903.3 * tmpvar_37) + 16.0) / 116.0);
  };
  highp float tmpvar_41;
  if ((tmpvar_38 > 0.008856)) {
    tmpvar_41 = pow (tmpvar_38, 0.3333333);
  } else {
    tmpvar_41 = (((903.3 * tmpvar_38) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_42;
  tmpvar_42.x = (((116.0 * tmpvar_40) - 16.0) / 100.0);
  tmpvar_42.y = (((500.0 * 
    (tmpvar_39 - tmpvar_40)
  ) + 110.0) / 220.0);
  tmpvar_42.z = (((200.0 * 
    (tmpvar_40 - tmpvar_41)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_43;
  tmpvar_43 = (tmpvar_42 - tmpvar_32);
  highp float tmpvar_44;
  if ((color_10.x > 0.04045)) {
    tmpvar_44 = pow (((color_10.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_44 = (color_10.x / 12.92);
  };
  highp float tmpvar_45;
  if ((color_10.y > 0.04045)) {
    tmpvar_45 = pow (((color_10.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_45 = (color_10.y / 12.92);
  };
  highp float tmpvar_46;
  if ((color_10.z > 0.04045)) {
    tmpvar_46 = pow (((color_10.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_46 = (color_10.z / 12.92);
  };
  highp float tmpvar_47;
  tmpvar_47 = (((
    (tmpvar_44 * 0.4124564)
   + 
    (tmpvar_45 * 0.3575761)
  ) + (tmpvar_46 * 0.1804375)) / 0.950456);
  highp float tmpvar_48;
  tmpvar_48 = (((tmpvar_44 * 0.2126729) + (tmpvar_45 * 0.7151522)) + (tmpvar_46 * 0.072175));
  highp float tmpvar_49;
  tmpvar_49 = (((
    (tmpvar_44 * 0.0193339)
   + 
    (tmpvar_45 * 0.119192)
  ) + (tmpvar_46 * 0.9503041)) / 1.088754);
  highp float tmpvar_50;
  if ((tmpvar_47 > 0.008856)) {
    tmpvar_50 = pow (tmpvar_47, 0.3333333);
  } else {
    tmpvar_50 = (((903.3 * tmpvar_47) + 16.0) / 116.0);
  };
  highp float tmpvar_51;
  if ((tmpvar_48 > 0.008856)) {
    tmpvar_51 = pow (tmpvar_48, 0.3333333);
  } else {
    tmpvar_51 = (((903.3 * tmpvar_48) + 16.0) / 116.0);
  };
  highp float tmpvar_52;
  if ((tmpvar_49 > 0.008856)) {
    tmpvar_52 = pow (tmpvar_49, 0.3333333);
  } else {
    tmpvar_52 = (((903.3 * tmpvar_49) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_53;
  tmpvar_53.x = (((116.0 * tmpvar_51) - 16.0) / 100.0);
  tmpvar_53.y = (((500.0 * 
    (tmpvar_50 - tmpvar_51)
  ) + 110.0) / 220.0);
  tmpvar_53.z = (((200.0 * 
    (tmpvar_51 - tmpvar_52)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_54;
  tmpvar_54 = clamp ((tmpvar_53 + tmpvar_43), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float z_55;
  highp float x_56;
  highp float tmpvar_57;
  tmpvar_57 = (((tmpvar_54.x * 100.0) + 16.0) / 116.0);
  highp float tmpvar_58;
  tmpvar_58 = (((
    (tmpvar_54.y * 220.0)
   - 110.0) / 500.0) + tmpvar_57);
  x_56 = tmpvar_58;
  highp float tmpvar_59;
  tmpvar_59 = (tmpvar_57 - ((
    (tmpvar_54.z * 220.0)
   - 110.0) / 200.0));
  z_55 = tmpvar_59;
  highp float tmpvar_60;
  tmpvar_60 = pow (tmpvar_58, 3.0);
  highp float tmpvar_61;
  tmpvar_61 = pow (tmpvar_57, 3.0);
  highp float tmpvar_62;
  tmpvar_62 = pow (tmpvar_59, 3.0);
  highp float tmpvar_63;
  if ((tmpvar_60 > 0.008856)) {
    tmpvar_63 = tmpvar_60;
  } else {
    tmpvar_63 = ((tmpvar_58 - 0.137931) / 7.787069);
  };
  x_56 = (tmpvar_63 * 0.950456);
  highp float tmpvar_64;
  if ((tmpvar_61 > 0.008856)) {
    tmpvar_64 = tmpvar_61;
  } else {
    tmpvar_64 = ((tmpvar_57 - 0.137931) / 7.787069);
  };
  highp float tmpvar_65;
  if ((tmpvar_62 > 0.008856)) {
    tmpvar_65 = tmpvar_62;
  } else {
    tmpvar_65 = ((tmpvar_59 - 0.137931) / 7.787069);
  };
  z_55 = (tmpvar_65 * 1.088754);
  highp float tmpvar_66;
  tmpvar_66 = (((x_56 * 3.240454) + (tmpvar_64 * -1.537138)) + (z_55 * -0.4985314));
  highp float tmpvar_67;
  tmpvar_67 = (((x_56 * -0.969266) + (tmpvar_64 * 1.876011)) + (z_55 * 0.041556));
  highp float tmpvar_68;
  tmpvar_68 = (((x_56 * 0.0556434) + (tmpvar_64 * -0.2040259)) + (z_55 * 1.057225));
  highp float tmpvar_69;
  if ((tmpvar_66 > 0.0031308)) {
    tmpvar_69 = ((1.055 * pow (tmpvar_66, 0.4166667)) - 0.055);
  } else {
    tmpvar_69 = (12.92 * tmpvar_66);
  };
  highp float tmpvar_70;
  if ((tmpvar_67 > 0.0031308)) {
    tmpvar_70 = ((1.055 * pow (tmpvar_67, 0.4166667)) - 0.055);
  } else {
    tmpvar_70 = (12.92 * tmpvar_67);
  };
  highp float tmpvar_71;
  if ((tmpvar_68 > 0.0031308)) {
    tmpvar_71 = ((1.055 * pow (tmpvar_68, 0.4166667)) - 0.055);
  } else {
    tmpvar_71 = (12.92 * tmpvar_68);
  };
  highp vec3 tmpvar_72;
  tmpvar_72.x = tmpvar_69;
  tmpvar_72.y = tmpvar_70;
  tmpvar_72.z = tmpvar_71;
  lowp vec3 tmpvar_73;
  tmpvar_73 = texture (SkinTintMaskTex, xlv_TEXCOORD0).xxx;
  highp vec3 tmpvar_74;
  tmpvar_74 = mix (color_10.xyz, tmpvar_72, tmpvar_73);
  mainColor_9 = (tmpvar_74 * tmpvar_74);
  lowp vec3 tmpvar_75;
  tmpvar_75 = texture (RegionTintMaskTex, xlv_TEXCOORD0).xyz;
  regionMaskColor_8 = tmpvar_75;
  highp vec4 tmpvar_76;
  tmpvar_76.w = 0.0;
  tmpvar_76.xyz = mainColor_9;
  highp vec4 tmpvar_77;
  tmpvar_77.w = 0.0;
  tmpvar_77.xyz = mainColor_9;
  highp vec4 tmpvar_78;
  tmpvar_78.w = 0.0;
  tmpvar_78.xyz = mainColor_9;
  mainColor_9 = (((
    (mainColor_9 * (1.0 - ((regionMaskColor_8.x + regionMaskColor_8.y) + regionMaskColor_8.z)))
   + 
    (mix (tmpvar_76, RegionRTint, RegionTintBlend.xxxx) * regionMaskColor_8.x)
  .xyz) + (
    mix (tmpvar_77, RegionGTint, RegionTintBlend.yyyy)
   * regionMaskColor_8.y).xyz) + (mix (tmpvar_78, RegionBTint, RegionTintBlend.zzzz) * regionMaskColor_8.z).xyz);
  lowp vec3 tmpvar_79;
  tmpvar_79 = texture (TexSpecular, xlv_TEXCOORD0).xyz;
  specular_7 = tmpvar_79;
  highp float tmpvar_80;
  tmpvar_80 = (1.0 - specular_7.x);
  highp vec2 tmpvar_81;
  tmpvar_81.x = (((
    dot (tmpvar_16, tmpvar_17)
   * 0.5) + 0.5) * 0.99);
  tmpvar_81.y = specular_7.y;
  lowp vec3 tmpvar_82;
  tmpvar_82 = texture (TexBRDF, tmpvar_81).xyz;
  brdfColor_6 = tmpvar_82;
  highp float tmpvar_83;
  tmpvar_83 = max (((
    dot (tmpvar_16, tmpvar_18)
   + 0.5) * 0.7), 0.0);
  nl2_5 = (tmpvar_83 * tmpvar_83);
  nl2_5 = (nl2_5 * nl2_5);
  nl2_5 = (nl2_5 * nl2_5);
  backLight_4 = ((nl2_5 * LightColor.xyz) * ((LightIntensity * mainColor_9) * mainNormal_11.z));
  backLight_4 = (backLight_4 / (vec3(1.0, 1.0, 1.0) + backLight_4));
  highp vec3 I_84;
  I_84 = -(tmpvar_13);
  reflectDir_3.xyz = (I_84 - (2.0 * (
    dot (tmpvar_16, I_84)
   * tmpvar_16)));
  reflectDir_3.w = (tmpvar_80 * 4.0);
  lowp vec4 tmpvar_85;
  tmpvar_85 = textureLod (TexSkybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_86;
  tmpvar_86 = tmpvar_85;
  iblColor_2.w = tmpvar_86.w;
  iblColor_2.xyz = ((tmpvar_86.xyz * tmpvar_86.w) * 4.0);
  highp float tmpvar_87;
  tmpvar_87 = max ((tmpvar_80 * tmpvar_80), 0.1);
  highp float tmpvar_88;
  tmpvar_88 = (tmpvar_87 * tmpvar_87);
  highp float tmpvar_89;
  tmpvar_89 = (((
    (tmpvar_20 * tmpvar_88)
   - tmpvar_20) * tmpvar_20) + 1.0);
  d_1 = ((0.3183099 * tmpvar_88) / ((tmpvar_89 * tmpvar_89) + 1e-7));
  highp float tmpvar_90;
  tmpvar_90 = min (d_1, 100.0);
  d_1 = tmpvar_90;
  highp vec4 tmpvar_91;
  tmpvar_91.xyz = (((
    ((tmpvar_90 * mix (Fresnel, 1.0, (1.0 - tmpvar_19))) * LIGHT_COLOR)
   + 
    (((iblColor_2.xyz * 0.5) * ((
      (min ((Fresnel * 2.0), 1.0) - Fresnel)
     * 
      pow ((1.0 - tmpvar_19), 4.0)
    ) + Fresnel)) * AMBIENT_COLOR)
  ) * ColorSpecular.xyz) + ((
    (((brdfColor_6 * LIGHT_COLOR) * mainColor_9) + backLight_4)
   + 
    (AMBIENT_COLOR * mainColor_9)
  ) * mix (ColorShade.xyz, vec3(1.0, 1.0, 1.0), vec3(
    mix (1.0, tmpvar_19, (1.0 - specular_7.z))
  ))));
  tmpvar_91.w = tmpvar_22;
  _glesFragData[0] = tmpvar_91;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexNormal",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSpecular",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexBRDF",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSkybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorShade",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorShadow",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorSpecular",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionRTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionGTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionBTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintBlend",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D DiffuseTex;
uniform sampler2D TexNormal;
uniform sampler2D TexSpecular;
uniform sampler2D TexBRDF;
uniform lowp samplerCube TexSkybox;
uniform sampler2D RegionTintMaskTex;
uniform sampler2D SkinTintMaskTex;
uniform highp vec4 ColorShade;
uniform highp vec4 ColorShadow;
uniform highp vec4 ColorSpecular;
uniform highp vec4 SkinTint;
uniform highp vec4 SkinColor;
uniform highp vec4 RegionRTint;
uniform highp vec4 RegionGTint;
uniform highp vec4 RegionBTint;
uniform highp vec3 RegionTintBlend;
uniform highp float Fresnel;
uniform highp vec3 LightDir;
uniform highp vec4 LightColor;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 backLight_4;
  highp float nl2_5;
  highp vec3 brdfColor_6;
  highp vec3 specular_7;
  highp vec3 regionMaskColor_8;
  highp vec3 mainColor_9;
  highp vec4 color_10;
  highp vec3 mainNormal_11;
  highp vec4 shadowCoord_12;
  shadowCoord_12 = xlv_TEXCOORD4;
  highp float tmpvar_13;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_13 = 1.0;
  } else {
    shadowCoord_12.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_14;
    highp vec2 fetchesOffsetsU_15;
    highp float shadow_16;
    highp vec2 tmpvar_17;
    tmpvar_17 = (shadowCoord_12.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_18;
    tmpvar_18 = floor((tmpvar_17 + 0.5));
    highp vec2 tmpvar_19;
    tmpvar_19 = (tmpvar_17 - tmpvar_18);
    highp vec4 computedWeight_20;
    highp vec4 computedArea_21;
    highp vec4 computedAreaUncut_22;
    highp float tmpvar_23;
    tmpvar_23 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
    highp float tmpvar_24;
    tmpvar_24 = (tmpvar_23 - tmpvar_19.x);
    computedArea_21.x = tmpvar_24;
    computedAreaUncut_22.x = tmpvar_24;
    computedArea_21.w = tmpvar_23;
    computedAreaUncut_22.w = tmpvar_23;
    computedAreaUncut_22.y = ((1.5 - tmpvar_19.x) - 0.5);
    highp float tmpvar_25;
    tmpvar_25 = min (tmpvar_19.x, 0.0);
    computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
    computedAreaUncut_22.z = ((1.5 + tmpvar_19.x) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = max (tmpvar_19.x, 0.0);
    computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
    computedWeight_20 = (computedArea_21 * 0.44444);
    highp vec4 computedWeight_27;
    highp vec4 computedArea_28;
    highp vec4 computedAreaUncut_29;
    highp float tmpvar_30;
    tmpvar_30 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
    highp float tmpvar_31;
    tmpvar_31 = (tmpvar_30 - tmpvar_19.y);
    computedArea_28.x = tmpvar_31;
    computedAreaUncut_29.x = tmpvar_31;
    computedArea_28.w = tmpvar_30;
    computedAreaUncut_29.w = tmpvar_30;
    computedAreaUncut_29.y = ((1.5 - tmpvar_19.y) - 0.5);
    highp float tmpvar_32;
    tmpvar_32 = min (tmpvar_19.y, 0.0);
    computedArea_28.y = (computedAreaUncut_29.y - (tmpvar_32 * tmpvar_32));
    computedAreaUncut_29.z = ((1.5 + tmpvar_19.y) - 0.5);
    highp float tmpvar_33;
    tmpvar_33 = max (tmpvar_19.y, 0.0);
    computedArea_28.z = (computedAreaUncut_29.z - (tmpvar_33 * tmpvar_33));
    computedWeight_27 = (computedArea_28 * 0.44444);
    highp vec2 tmpvar_34;
    tmpvar_34 = (computedWeight_20.xz + computedWeight_20.yw);
    highp vec2 tmpvar_35;
    tmpvar_35 = (computedWeight_27.xz + computedWeight_27.yw);
    fetchesOffsetsU_15 = (((computedWeight_20.yw / tmpvar_34) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_14 = (((computedWeight_27.yw / tmpvar_35) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_36;
    tmpvar_36 = (tmpvar_18 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_37;
    tmpvar_37.x = fetchesOffsetsU_15.x;
    tmpvar_37.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (tmpvar_36 + tmpvar_37);
    tmpvar_38.z = shadowCoord_12.z;
    mediump float tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38);
    shadow_16 = ((tmpvar_34.x * tmpvar_35.x) * tmpvar_39);
    highp vec2 tmpvar_40;
    tmpvar_40.x = fetchesOffsetsU_15.y;
    tmpvar_40.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (tmpvar_36 + tmpvar_40);
    tmpvar_41.z = shadowCoord_12.z;
    mediump float tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41);
    shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.x) * tmpvar_42));
    highp vec2 tmpvar_43;
    tmpvar_43.x = fetchesOffsetsU_15.x;
    tmpvar_43.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_44;
    tmpvar_44.xy = (tmpvar_36 + tmpvar_43);
    tmpvar_44.z = shadowCoord_12.z;
    mediump float tmpvar_45;
    tmpvar_45 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_44);
    shadow_16 = (shadow_16 + ((tmpvar_34.x * tmpvar_35.y) * tmpvar_45));
    highp vec2 tmpvar_46;
    tmpvar_46.x = fetchesOffsetsU_15.y;
    tmpvar_46.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_47;
    tmpvar_47.xy = (tmpvar_36 + tmpvar_46);
    tmpvar_47.z = shadowCoord_12.z;
    mediump float tmpvar_48;
    tmpvar_48 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_47);
    shadow_16 = (shadow_16 + ((tmpvar_34.y * tmpvar_35.y) * tmpvar_48));
    tmpvar_13 = mix (1.0, shadow_16, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_49;
  tmpvar_49.x = xlv_TEXCOORD1.w;
  tmpvar_49.y = xlv_TEXCOORD2.w;
  tmpvar_49.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_50;
  tmpvar_50 = normalize((CAMERA_WORLDPOSITION - tmpvar_49));
  lowp vec3 tmpvar_51;
  tmpvar_51 = texture (TexNormal, xlv_TEXCOORD0).xyz;
  mainNormal_11 = tmpvar_51;
  highp vec3 tmpvar_52;
  tmpvar_52 = ((mainNormal_11 * 2.0) - 1.0);
  highp vec3 tmpvar_53;
  tmpvar_53 = normalize(((
    (tmpvar_52.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_52.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_52.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_54;
  tmpvar_54 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_55;
  tmpvar_55 = normalize(LightDir);
  highp float tmpvar_56;
  tmpvar_56 = max (dot (tmpvar_53, tmpvar_50), 0.0);
  highp float tmpvar_57;
  tmpvar_57 = max (dot (tmpvar_53, normalize(
    (tmpvar_50 + tmpvar_54)
  )), 0.0);
  lowp vec4 tmpvar_58;
  tmpvar_58 = texture (DiffuseTex, xlv_TEXCOORD0);
  color_10 = tmpvar_58;
  mainColor_9 = color_10.xyz;
  highp float tmpvar_59;
  tmpvar_59 = color_10.w;
  highp float tmpvar_60;
  if ((SkinColor.x > 0.04045)) {
    tmpvar_60 = pow (((SkinColor.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_60 = (SkinColor.x / 12.92);
  };
  highp float tmpvar_61;
  if ((SkinColor.y > 0.04045)) {
    tmpvar_61 = pow (((SkinColor.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_61 = (SkinColor.y / 12.92);
  };
  highp float tmpvar_62;
  if ((SkinColor.z > 0.04045)) {
    tmpvar_62 = pow (((SkinColor.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_62 = (SkinColor.z / 12.92);
  };
  highp float tmpvar_63;
  tmpvar_63 = (((
    (tmpvar_60 * 0.4124564)
   + 
    (tmpvar_61 * 0.3575761)
  ) + (tmpvar_62 * 0.1804375)) / 0.950456);
  highp float tmpvar_64;
  tmpvar_64 = (((tmpvar_60 * 0.2126729) + (tmpvar_61 * 0.7151522)) + (tmpvar_62 * 0.072175));
  highp float tmpvar_65;
  tmpvar_65 = (((
    (tmpvar_60 * 0.0193339)
   + 
    (tmpvar_61 * 0.119192)
  ) + (tmpvar_62 * 0.9503041)) / 1.088754);
  highp float tmpvar_66;
  if ((tmpvar_63 > 0.008856)) {
    tmpvar_66 = pow (tmpvar_63, 0.3333333);
  } else {
    tmpvar_66 = (((903.3 * tmpvar_63) + 16.0) / 116.0);
  };
  highp float tmpvar_67;
  if ((tmpvar_64 > 0.008856)) {
    tmpvar_67 = pow (tmpvar_64, 0.3333333);
  } else {
    tmpvar_67 = (((903.3 * tmpvar_64) + 16.0) / 116.0);
  };
  highp float tmpvar_68;
  if ((tmpvar_65 > 0.008856)) {
    tmpvar_68 = pow (tmpvar_65, 0.3333333);
  } else {
    tmpvar_68 = (((903.3 * tmpvar_65) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_69;
  tmpvar_69.x = (((116.0 * tmpvar_67) - 16.0) / 100.0);
  tmpvar_69.y = (((500.0 * 
    (tmpvar_66 - tmpvar_67)
  ) + 110.0) / 220.0);
  tmpvar_69.z = (((200.0 * 
    (tmpvar_67 - tmpvar_68)
  ) + 110.0) / 220.0);
  highp float tmpvar_70;
  if ((SkinTint.x > 0.04045)) {
    tmpvar_70 = pow (((SkinTint.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_70 = (SkinTint.x / 12.92);
  };
  highp float tmpvar_71;
  if ((SkinTint.y > 0.04045)) {
    tmpvar_71 = pow (((SkinTint.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_71 = (SkinTint.y / 12.92);
  };
  highp float tmpvar_72;
  if ((SkinTint.z > 0.04045)) {
    tmpvar_72 = pow (((SkinTint.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_72 = (SkinTint.z / 12.92);
  };
  highp float tmpvar_73;
  tmpvar_73 = (((
    (tmpvar_70 * 0.4124564)
   + 
    (tmpvar_71 * 0.3575761)
  ) + (tmpvar_72 * 0.1804375)) / 0.950456);
  highp float tmpvar_74;
  tmpvar_74 = (((tmpvar_70 * 0.2126729) + (tmpvar_71 * 0.7151522)) + (tmpvar_72 * 0.072175));
  highp float tmpvar_75;
  tmpvar_75 = (((
    (tmpvar_70 * 0.0193339)
   + 
    (tmpvar_71 * 0.119192)
  ) + (tmpvar_72 * 0.9503041)) / 1.088754);
  highp float tmpvar_76;
  if ((tmpvar_73 > 0.008856)) {
    tmpvar_76 = pow (tmpvar_73, 0.3333333);
  } else {
    tmpvar_76 = (((903.3 * tmpvar_73) + 16.0) / 116.0);
  };
  highp float tmpvar_77;
  if ((tmpvar_74 > 0.008856)) {
    tmpvar_77 = pow (tmpvar_74, 0.3333333);
  } else {
    tmpvar_77 = (((903.3 * tmpvar_74) + 16.0) / 116.0);
  };
  highp float tmpvar_78;
  if ((tmpvar_75 > 0.008856)) {
    tmpvar_78 = pow (tmpvar_75, 0.3333333);
  } else {
    tmpvar_78 = (((903.3 * tmpvar_75) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_79;
  tmpvar_79.x = (((116.0 * tmpvar_77) - 16.0) / 100.0);
  tmpvar_79.y = (((500.0 * 
    (tmpvar_76 - tmpvar_77)
  ) + 110.0) / 220.0);
  tmpvar_79.z = (((200.0 * 
    (tmpvar_77 - tmpvar_78)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_80;
  tmpvar_80 = (tmpvar_79 - tmpvar_69);
  highp float tmpvar_81;
  if ((color_10.x > 0.04045)) {
    tmpvar_81 = pow (((color_10.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_81 = (color_10.x / 12.92);
  };
  highp float tmpvar_82;
  if ((color_10.y > 0.04045)) {
    tmpvar_82 = pow (((color_10.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_82 = (color_10.y / 12.92);
  };
  highp float tmpvar_83;
  if ((color_10.z > 0.04045)) {
    tmpvar_83 = pow (((color_10.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_83 = (color_10.z / 12.92);
  };
  highp float tmpvar_84;
  tmpvar_84 = (((
    (tmpvar_81 * 0.4124564)
   + 
    (tmpvar_82 * 0.3575761)
  ) + (tmpvar_83 * 0.1804375)) / 0.950456);
  highp float tmpvar_85;
  tmpvar_85 = (((tmpvar_81 * 0.2126729) + (tmpvar_82 * 0.7151522)) + (tmpvar_83 * 0.072175));
  highp float tmpvar_86;
  tmpvar_86 = (((
    (tmpvar_81 * 0.0193339)
   + 
    (tmpvar_82 * 0.119192)
  ) + (tmpvar_83 * 0.9503041)) / 1.088754);
  highp float tmpvar_87;
  if ((tmpvar_84 > 0.008856)) {
    tmpvar_87 = pow (tmpvar_84, 0.3333333);
  } else {
    tmpvar_87 = (((903.3 * tmpvar_84) + 16.0) / 116.0);
  };
  highp float tmpvar_88;
  if ((tmpvar_85 > 0.008856)) {
    tmpvar_88 = pow (tmpvar_85, 0.3333333);
  } else {
    tmpvar_88 = (((903.3 * tmpvar_85) + 16.0) / 116.0);
  };
  highp float tmpvar_89;
  if ((tmpvar_86 > 0.008856)) {
    tmpvar_89 = pow (tmpvar_86, 0.3333333);
  } else {
    tmpvar_89 = (((903.3 * tmpvar_86) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_90;
  tmpvar_90.x = (((116.0 * tmpvar_88) - 16.0) / 100.0);
  tmpvar_90.y = (((500.0 * 
    (tmpvar_87 - tmpvar_88)
  ) + 110.0) / 220.0);
  tmpvar_90.z = (((200.0 * 
    (tmpvar_88 - tmpvar_89)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_91;
  tmpvar_91 = clamp ((tmpvar_90 + tmpvar_80), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float z_92;
  highp float x_93;
  highp float tmpvar_94;
  tmpvar_94 = (((tmpvar_91.x * 100.0) + 16.0) / 116.0);
  highp float tmpvar_95;
  tmpvar_95 = (((
    (tmpvar_91.y * 220.0)
   - 110.0) / 500.0) + tmpvar_94);
  x_93 = tmpvar_95;
  highp float tmpvar_96;
  tmpvar_96 = (tmpvar_94 - ((
    (tmpvar_91.z * 220.0)
   - 110.0) / 200.0));
  z_92 = tmpvar_96;
  highp float tmpvar_97;
  tmpvar_97 = pow (tmpvar_95, 3.0);
  highp float tmpvar_98;
  tmpvar_98 = pow (tmpvar_94, 3.0);
  highp float tmpvar_99;
  tmpvar_99 = pow (tmpvar_96, 3.0);
  highp float tmpvar_100;
  if ((tmpvar_97 > 0.008856)) {
    tmpvar_100 = tmpvar_97;
  } else {
    tmpvar_100 = ((tmpvar_95 - 0.137931) / 7.787069);
  };
  x_93 = (tmpvar_100 * 0.950456);
  highp float tmpvar_101;
  if ((tmpvar_98 > 0.008856)) {
    tmpvar_101 = tmpvar_98;
  } else {
    tmpvar_101 = ((tmpvar_94 - 0.137931) / 7.787069);
  };
  highp float tmpvar_102;
  if ((tmpvar_99 > 0.008856)) {
    tmpvar_102 = tmpvar_99;
  } else {
    tmpvar_102 = ((tmpvar_96 - 0.137931) / 7.787069);
  };
  z_92 = (tmpvar_102 * 1.088754);
  highp float tmpvar_103;
  tmpvar_103 = (((x_93 * 3.240454) + (tmpvar_101 * -1.537138)) + (z_92 * -0.4985314));
  highp float tmpvar_104;
  tmpvar_104 = (((x_93 * -0.969266) + (tmpvar_101 * 1.876011)) + (z_92 * 0.041556));
  highp float tmpvar_105;
  tmpvar_105 = (((x_93 * 0.0556434) + (tmpvar_101 * -0.2040259)) + (z_92 * 1.057225));
  highp float tmpvar_106;
  if ((tmpvar_103 > 0.0031308)) {
    tmpvar_106 = ((1.055 * pow (tmpvar_103, 0.4166667)) - 0.055);
  } else {
    tmpvar_106 = (12.92 * tmpvar_103);
  };
  highp float tmpvar_107;
  if ((tmpvar_104 > 0.0031308)) {
    tmpvar_107 = ((1.055 * pow (tmpvar_104, 0.4166667)) - 0.055);
  } else {
    tmpvar_107 = (12.92 * tmpvar_104);
  };
  highp float tmpvar_108;
  if ((tmpvar_105 > 0.0031308)) {
    tmpvar_108 = ((1.055 * pow (tmpvar_105, 0.4166667)) - 0.055);
  } else {
    tmpvar_108 = (12.92 * tmpvar_105);
  };
  highp vec3 tmpvar_109;
  tmpvar_109.x = tmpvar_106;
  tmpvar_109.y = tmpvar_107;
  tmpvar_109.z = tmpvar_108;
  lowp vec3 tmpvar_110;
  tmpvar_110 = texture (SkinTintMaskTex, xlv_TEXCOORD0).xxx;
  highp vec3 tmpvar_111;
  tmpvar_111 = mix (color_10.xyz, tmpvar_109, tmpvar_110);
  mainColor_9 = (tmpvar_111 * tmpvar_111);
  lowp vec3 tmpvar_112;
  tmpvar_112 = texture (RegionTintMaskTex, xlv_TEXCOORD0).xyz;
  regionMaskColor_8 = tmpvar_112;
  highp vec4 tmpvar_113;
  tmpvar_113.w = 0.0;
  tmpvar_113.xyz = mainColor_9;
  highp vec4 tmpvar_114;
  tmpvar_114.w = 0.0;
  tmpvar_114.xyz = mainColor_9;
  highp vec4 tmpvar_115;
  tmpvar_115.w = 0.0;
  tmpvar_115.xyz = mainColor_9;
  mainColor_9 = (((
    (mainColor_9 * (1.0 - ((regionMaskColor_8.x + regionMaskColor_8.y) + regionMaskColor_8.z)))
   + 
    (mix (tmpvar_113, RegionRTint, RegionTintBlend.xxxx) * regionMaskColor_8.x)
  .xyz) + (
    mix (tmpvar_114, RegionGTint, RegionTintBlend.yyyy)
   * regionMaskColor_8.y).xyz) + (mix (tmpvar_115, RegionBTint, RegionTintBlend.zzzz) * regionMaskColor_8.z).xyz);
  lowp vec3 tmpvar_116;
  tmpvar_116 = texture (TexSpecular, xlv_TEXCOORD0).xyz;
  specular_7 = tmpvar_116;
  highp float tmpvar_117;
  tmpvar_117 = (1.0 - specular_7.x);
  highp vec2 tmpvar_118;
  tmpvar_118.x = (((
    dot (tmpvar_53, tmpvar_54)
   * 0.5) + 0.5) * 0.99);
  tmpvar_118.y = specular_7.y;
  lowp vec3 tmpvar_119;
  tmpvar_119 = texture (TexBRDF, tmpvar_118).xyz;
  brdfColor_6 = tmpvar_119;
  highp float tmpvar_120;
  tmpvar_120 = max (((
    dot (tmpvar_53, tmpvar_55)
   + 0.5) * 0.7), 0.0);
  nl2_5 = (tmpvar_120 * tmpvar_120);
  nl2_5 = (nl2_5 * nl2_5);
  nl2_5 = (nl2_5 * nl2_5);
  backLight_4 = ((nl2_5 * LightColor.xyz) * ((LightIntensity * mainColor_9) * mainNormal_11.z));
  backLight_4 = (backLight_4 / (vec3(1.0, 1.0, 1.0) + backLight_4));
  highp vec3 I_121;
  I_121 = -(tmpvar_50);
  reflectDir_3.xyz = (I_121 - (2.0 * (
    dot (tmpvar_53, I_121)
   * tmpvar_53)));
  reflectDir_3.w = (tmpvar_117 * 4.0);
  lowp vec4 tmpvar_122;
  tmpvar_122 = textureLod (TexSkybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_123;
  tmpvar_123 = tmpvar_122;
  iblColor_2.w = tmpvar_123.w;
  iblColor_2.xyz = ((tmpvar_123.xyz * tmpvar_123.w) * 4.0);
  highp float tmpvar_124;
  tmpvar_124 = max ((tmpvar_117 * tmpvar_117), 0.1);
  highp float tmpvar_125;
  tmpvar_125 = (tmpvar_124 * tmpvar_124);
  highp float tmpvar_126;
  tmpvar_126 = (((
    (tmpvar_57 * tmpvar_125)
   - tmpvar_57) * tmpvar_57) + 1.0);
  d_1 = ((0.3183099 * tmpvar_125) / ((tmpvar_126 * tmpvar_126) + 1e-7));
  highp float tmpvar_127;
  tmpvar_127 = min (d_1, 100.0);
  d_1 = tmpvar_127;
  highp vec4 tmpvar_128;
  tmpvar_128.xyz = (((
    ((tmpvar_127 * mix (Fresnel, 1.0, (1.0 - tmpvar_56))) * LIGHT_COLOR)
   + 
    (((iblColor_2.xyz * 0.5) * ((
      (min ((Fresnel * 2.0), 1.0) - Fresnel)
     * 
      pow ((1.0 - tmpvar_56), 4.0)
    ) + Fresnel)) * AMBIENT_COLOR)
  ) * ColorSpecular.xyz) + ((
    (((mix (ColorShadow.xyz, brdfColor_6, vec3(tmpvar_13)) * LIGHT_COLOR) * mainColor_9) + backLight_4)
   + 
    (AMBIENT_COLOR * mainColor_9)
  ) * mix (ColorShade.xyz, vec3(1.0, 1.0, 1.0), vec3(
    mix (1.0, tmpvar_56, (1.0 - specular_7.z))
  ))));
  tmpvar_128.w = tmpvar_59;
  _glesFragData[0] = tmpvar_128;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexNormal",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSpecular",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexBRDF",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSkybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorShade",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorShadow",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorSpecular",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionRTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionGTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionBTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintBlend",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D DiffuseTex;
uniform sampler2D TexNormal;
uniform sampler2D TexSpecular;
uniform sampler2D TexBRDF;
uniform lowp samplerCube TexSkybox;
uniform sampler2D RegionTintMaskTex;
uniform sampler2D SkinTintMaskTex;
uniform highp vec4 ColorShade;
uniform highp vec4 ColorShadow;
uniform highp vec4 ColorSpecular;
uniform highp vec4 SkinTint;
uniform highp vec4 SkinColor;
uniform highp vec4 RegionRTint;
uniform highp vec4 RegionGTint;
uniform highp vec4 RegionBTint;
uniform highp vec3 RegionTintBlend;
uniform highp float Fresnel;
uniform highp vec3 LightDir;
uniform highp vec4 LightColor;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 backLight_4;
  highp float nl2_5;
  highp vec3 brdfColor_6;
  highp vec3 specular_7;
  highp vec3 regionMaskColor_8;
  highp vec3 mainColor_9;
  highp vec4 color_10;
  highp vec3 mainNormal_11;
  highp vec4 shadowCoord_12;
  shadowCoord_12 = xlv_TEXCOORD4;
  highp float tmpvar_13;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_13 = 1.0;
  } else {
    shadowCoord_12.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_14;
    highp vec3 fetchesOffsetsU_15;
    highp float shadow_16;
    highp vec2 tmpvar_17;
    tmpvar_17 = (shadowCoord_12.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_18;
    tmpvar_18 = floor((tmpvar_17 + 0.5));
    highp vec2 tmpvar_19;
    tmpvar_19 = (tmpvar_17 - tmpvar_18);
    highp vec3 texelsWeightsA_20;
    highp vec3 texelsWeightsB_21;
    highp vec4 computedArea_22;
    highp vec4 computedAreaUncut_23;
    highp float tmpvar_24;
    tmpvar_24 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
    highp float tmpvar_25;
    tmpvar_25 = (tmpvar_24 - tmpvar_19.x);
    computedArea_22.x = tmpvar_25;
    computedAreaUncut_23.x = tmpvar_25;
    computedArea_22.w = tmpvar_24;
    computedAreaUncut_23.w = tmpvar_24;
    computedAreaUncut_23.y = ((1.5 - tmpvar_19.x) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = min (tmpvar_19.x, 0.0);
    computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
    computedAreaUncut_23.z = ((1.5 + tmpvar_19.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = max (tmpvar_19.x, 0.0);
    computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
    texelsWeightsA_20.x = (0.16 * tmpvar_25);
    texelsWeightsA_20.y = (0.16 * computedAreaUncut_23.y);
    texelsWeightsA_20.z = (0.16 * (computedArea_22.y + 1.0));
    texelsWeightsB_21.x = (0.16 * (computedArea_22.z + 1.0));
    texelsWeightsB_21.y = (0.16 * computedAreaUncut_23.z);
    texelsWeightsB_21.z = (0.16 * tmpvar_24);
    highp vec3 texelsWeightsA_28;
    highp vec3 texelsWeightsB_29;
    highp vec4 computedArea_30;
    highp vec4 computedAreaUncut_31;
    highp float tmpvar_32;
    tmpvar_32 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
    highp float tmpvar_33;
    tmpvar_33 = (tmpvar_32 - tmpvar_19.y);
    computedArea_30.x = tmpvar_33;
    computedAreaUncut_31.x = tmpvar_33;
    computedArea_30.w = tmpvar_32;
    computedAreaUncut_31.w = tmpvar_32;
    computedAreaUncut_31.y = ((1.5 - tmpvar_19.y) - 0.5);
    highp float tmpvar_34;
    tmpvar_34 = min (tmpvar_19.y, 0.0);
    computedArea_30.y = (computedAreaUncut_31.y - (tmpvar_34 * tmpvar_34));
    computedAreaUncut_31.z = ((1.5 + tmpvar_19.y) - 0.5);
    highp float tmpvar_35;
    tmpvar_35 = max (tmpvar_19.y, 0.0);
    computedArea_30.z = (computedAreaUncut_31.z - (tmpvar_35 * tmpvar_35));
    texelsWeightsA_28.x = (0.16 * tmpvar_33);
    texelsWeightsA_28.y = (0.16 * computedAreaUncut_31.y);
    texelsWeightsA_28.z = (0.16 * (computedArea_30.y + 1.0));
    texelsWeightsB_29.x = (0.16 * (computedArea_30.z + 1.0));
    texelsWeightsB_29.y = (0.16 * computedAreaUncut_31.z);
    texelsWeightsB_29.z = (0.16 * tmpvar_32);
    highp vec3 tmpvar_36;
    tmpvar_36.xy = texelsWeightsA_20.xz;
    tmpvar_36.z = texelsWeightsB_21.y;
    highp vec3 tmpvar_37;
    tmpvar_37.x = texelsWeightsA_20.y;
    tmpvar_37.yz = texelsWeightsB_21.xz;
    highp vec3 tmpvar_38;
    tmpvar_38 = (tmpvar_36 + tmpvar_37);
    highp vec3 tmpvar_39;
    tmpvar_39.xy = texelsWeightsA_28.xz;
    tmpvar_39.z = texelsWeightsB_29.y;
    highp vec3 tmpvar_40;
    tmpvar_40.x = texelsWeightsA_28.y;
    tmpvar_40.yz = texelsWeightsB_29.xz;
    highp vec3 tmpvar_41;
    tmpvar_41 = (tmpvar_39 + tmpvar_40);
    highp vec3 tmpvar_42;
    tmpvar_42.x = texelsWeightsA_20.y;
    tmpvar_42.yz = texelsWeightsB_21.xz;
    highp vec3 tmpvar_43;
    tmpvar_43.x = texelsWeightsA_28.y;
    tmpvar_43.yz = texelsWeightsB_29.xz;
    fetchesOffsetsU_15 = (((tmpvar_42 / tmpvar_38) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_14 = (((tmpvar_43 / tmpvar_41) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_44;
    tmpvar_44 = (tmpvar_18 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_45;
    tmpvar_45.x = fetchesOffsetsU_15.x;
    tmpvar_45.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_46;
    tmpvar_46.xy = (tmpvar_44 + tmpvar_45);
    tmpvar_46.z = shadowCoord_12.z;
    mediump float tmpvar_47;
    tmpvar_47 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_46);
    shadow_16 = ((tmpvar_38.x * tmpvar_41.x) * tmpvar_47);
    highp vec2 tmpvar_48;
    tmpvar_48.x = fetchesOffsetsU_15.y;
    tmpvar_48.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (tmpvar_44 + tmpvar_48);
    tmpvar_49.z = shadowCoord_12.z;
    mediump float tmpvar_50;
    tmpvar_50 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_49);
    shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.x) * tmpvar_50));
    highp vec2 tmpvar_51;
    tmpvar_51.x = fetchesOffsetsU_15.z;
    tmpvar_51.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_52;
    tmpvar_52.xy = (tmpvar_44 + tmpvar_51);
    tmpvar_52.z = shadowCoord_12.z;
    mediump float tmpvar_53;
    tmpvar_53 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_52);
    shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.x) * tmpvar_53));
    highp vec2 tmpvar_54;
    tmpvar_54.x = fetchesOffsetsU_15.x;
    tmpvar_54.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_55;
    tmpvar_55.xy = (tmpvar_44 + tmpvar_54);
    tmpvar_55.z = shadowCoord_12.z;
    mediump float tmpvar_56;
    tmpvar_56 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_55);
    shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.y) * tmpvar_56));
    highp vec2 tmpvar_57;
    tmpvar_57.x = fetchesOffsetsU_15.y;
    tmpvar_57.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_58;
    tmpvar_58.xy = (tmpvar_44 + tmpvar_57);
    tmpvar_58.z = shadowCoord_12.z;
    mediump float tmpvar_59;
    tmpvar_59 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_58);
    shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.y) * tmpvar_59));
    highp vec2 tmpvar_60;
    tmpvar_60.x = fetchesOffsetsU_15.z;
    tmpvar_60.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_61;
    tmpvar_61.xy = (tmpvar_44 + tmpvar_60);
    tmpvar_61.z = shadowCoord_12.z;
    mediump float tmpvar_62;
    tmpvar_62 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_61);
    shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.y) * tmpvar_62));
    highp vec2 tmpvar_63;
    tmpvar_63.x = fetchesOffsetsU_15.x;
    tmpvar_63.y = fetchesOffsetsV_14.z;
    highp vec3 tmpvar_64;
    tmpvar_64.xy = (tmpvar_44 + tmpvar_63);
    tmpvar_64.z = shadowCoord_12.z;
    mediump float tmpvar_65;
    tmpvar_65 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_64);
    shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.z) * tmpvar_65));
    highp vec2 tmpvar_66;
    tmpvar_66.x = fetchesOffsetsU_15.y;
    tmpvar_66.y = fetchesOffsetsV_14.z;
    highp vec3 tmpvar_67;
    tmpvar_67.xy = (tmpvar_44 + tmpvar_66);
    tmpvar_67.z = shadowCoord_12.z;
    mediump float tmpvar_68;
    tmpvar_68 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_67);
    shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.z) * tmpvar_68));
    highp vec2 tmpvar_69;
    tmpvar_69.x = fetchesOffsetsU_15.z;
    tmpvar_69.y = fetchesOffsetsV_14.z;
    highp vec3 tmpvar_70;
    tmpvar_70.xy = (tmpvar_44 + tmpvar_69);
    tmpvar_70.z = shadowCoord_12.z;
    mediump float tmpvar_71;
    tmpvar_71 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_70);
    shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.z) * tmpvar_71));
    tmpvar_13 = mix (1.0, shadow_16, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_72;
  tmpvar_72.x = xlv_TEXCOORD1.w;
  tmpvar_72.y = xlv_TEXCOORD2.w;
  tmpvar_72.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_73;
  tmpvar_73 = normalize((CAMERA_WORLDPOSITION - tmpvar_72));
  lowp vec3 tmpvar_74;
  tmpvar_74 = texture (TexNormal, xlv_TEXCOORD0).xyz;
  mainNormal_11 = tmpvar_74;
  highp vec3 tmpvar_75;
  tmpvar_75 = ((mainNormal_11 * 2.0) - 1.0);
  highp vec3 tmpvar_76;
  tmpvar_76 = normalize(((
    (tmpvar_75.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_75.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_75.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_77;
  tmpvar_77 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_78;
  tmpvar_78 = normalize(LightDir);
  highp float tmpvar_79;
  tmpvar_79 = max (dot (tmpvar_76, tmpvar_73), 0.0);
  highp float tmpvar_80;
  tmpvar_80 = max (dot (tmpvar_76, normalize(
    (tmpvar_73 + tmpvar_77)
  )), 0.0);
  lowp vec4 tmpvar_81;
  tmpvar_81 = texture (DiffuseTex, xlv_TEXCOORD0);
  color_10 = tmpvar_81;
  mainColor_9 = color_10.xyz;
  highp float tmpvar_82;
  tmpvar_82 = color_10.w;
  highp float tmpvar_83;
  if ((SkinColor.x > 0.04045)) {
    tmpvar_83 = pow (((SkinColor.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_83 = (SkinColor.x / 12.92);
  };
  highp float tmpvar_84;
  if ((SkinColor.y > 0.04045)) {
    tmpvar_84 = pow (((SkinColor.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_84 = (SkinColor.y / 12.92);
  };
  highp float tmpvar_85;
  if ((SkinColor.z > 0.04045)) {
    tmpvar_85 = pow (((SkinColor.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_85 = (SkinColor.z / 12.92);
  };
  highp float tmpvar_86;
  tmpvar_86 = (((
    (tmpvar_83 * 0.4124564)
   + 
    (tmpvar_84 * 0.3575761)
  ) + (tmpvar_85 * 0.1804375)) / 0.950456);
  highp float tmpvar_87;
  tmpvar_87 = (((tmpvar_83 * 0.2126729) + (tmpvar_84 * 0.7151522)) + (tmpvar_85 * 0.072175));
  highp float tmpvar_88;
  tmpvar_88 = (((
    (tmpvar_83 * 0.0193339)
   + 
    (tmpvar_84 * 0.119192)
  ) + (tmpvar_85 * 0.9503041)) / 1.088754);
  highp float tmpvar_89;
  if ((tmpvar_86 > 0.008856)) {
    tmpvar_89 = pow (tmpvar_86, 0.3333333);
  } else {
    tmpvar_89 = (((903.3 * tmpvar_86) + 16.0) / 116.0);
  };
  highp float tmpvar_90;
  if ((tmpvar_87 > 0.008856)) {
    tmpvar_90 = pow (tmpvar_87, 0.3333333);
  } else {
    tmpvar_90 = (((903.3 * tmpvar_87) + 16.0) / 116.0);
  };
  highp float tmpvar_91;
  if ((tmpvar_88 > 0.008856)) {
    tmpvar_91 = pow (tmpvar_88, 0.3333333);
  } else {
    tmpvar_91 = (((903.3 * tmpvar_88) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_92;
  tmpvar_92.x = (((116.0 * tmpvar_90) - 16.0) / 100.0);
  tmpvar_92.y = (((500.0 * 
    (tmpvar_89 - tmpvar_90)
  ) + 110.0) / 220.0);
  tmpvar_92.z = (((200.0 * 
    (tmpvar_90 - tmpvar_91)
  ) + 110.0) / 220.0);
  highp float tmpvar_93;
  if ((SkinTint.x > 0.04045)) {
    tmpvar_93 = pow (((SkinTint.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_93 = (SkinTint.x / 12.92);
  };
  highp float tmpvar_94;
  if ((SkinTint.y > 0.04045)) {
    tmpvar_94 = pow (((SkinTint.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_94 = (SkinTint.y / 12.92);
  };
  highp float tmpvar_95;
  if ((SkinTint.z > 0.04045)) {
    tmpvar_95 = pow (((SkinTint.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_95 = (SkinTint.z / 12.92);
  };
  highp float tmpvar_96;
  tmpvar_96 = (((
    (tmpvar_93 * 0.4124564)
   + 
    (tmpvar_94 * 0.3575761)
  ) + (tmpvar_95 * 0.1804375)) / 0.950456);
  highp float tmpvar_97;
  tmpvar_97 = (((tmpvar_93 * 0.2126729) + (tmpvar_94 * 0.7151522)) + (tmpvar_95 * 0.072175));
  highp float tmpvar_98;
  tmpvar_98 = (((
    (tmpvar_93 * 0.0193339)
   + 
    (tmpvar_94 * 0.119192)
  ) + (tmpvar_95 * 0.9503041)) / 1.088754);
  highp float tmpvar_99;
  if ((tmpvar_96 > 0.008856)) {
    tmpvar_99 = pow (tmpvar_96, 0.3333333);
  } else {
    tmpvar_99 = (((903.3 * tmpvar_96) + 16.0) / 116.0);
  };
  highp float tmpvar_100;
  if ((tmpvar_97 > 0.008856)) {
    tmpvar_100 = pow (tmpvar_97, 0.3333333);
  } else {
    tmpvar_100 = (((903.3 * tmpvar_97) + 16.0) / 116.0);
  };
  highp float tmpvar_101;
  if ((tmpvar_98 > 0.008856)) {
    tmpvar_101 = pow (tmpvar_98, 0.3333333);
  } else {
    tmpvar_101 = (((903.3 * tmpvar_98) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_102;
  tmpvar_102.x = (((116.0 * tmpvar_100) - 16.0) / 100.0);
  tmpvar_102.y = (((500.0 * 
    (tmpvar_99 - tmpvar_100)
  ) + 110.0) / 220.0);
  tmpvar_102.z = (((200.0 * 
    (tmpvar_100 - tmpvar_101)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_103;
  tmpvar_103 = (tmpvar_102 - tmpvar_92);
  highp float tmpvar_104;
  if ((color_10.x > 0.04045)) {
    tmpvar_104 = pow (((color_10.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_104 = (color_10.x / 12.92);
  };
  highp float tmpvar_105;
  if ((color_10.y > 0.04045)) {
    tmpvar_105 = pow (((color_10.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_105 = (color_10.y / 12.92);
  };
  highp float tmpvar_106;
  if ((color_10.z > 0.04045)) {
    tmpvar_106 = pow (((color_10.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_106 = (color_10.z / 12.92);
  };
  highp float tmpvar_107;
  tmpvar_107 = (((
    (tmpvar_104 * 0.4124564)
   + 
    (tmpvar_105 * 0.3575761)
  ) + (tmpvar_106 * 0.1804375)) / 0.950456);
  highp float tmpvar_108;
  tmpvar_108 = (((tmpvar_104 * 0.2126729) + (tmpvar_105 * 0.7151522)) + (tmpvar_106 * 0.072175));
  highp float tmpvar_109;
  tmpvar_109 = (((
    (tmpvar_104 * 0.0193339)
   + 
    (tmpvar_105 * 0.119192)
  ) + (tmpvar_106 * 0.9503041)) / 1.088754);
  highp float tmpvar_110;
  if ((tmpvar_107 > 0.008856)) {
    tmpvar_110 = pow (tmpvar_107, 0.3333333);
  } else {
    tmpvar_110 = (((903.3 * tmpvar_107) + 16.0) / 116.0);
  };
  highp float tmpvar_111;
  if ((tmpvar_108 > 0.008856)) {
    tmpvar_111 = pow (tmpvar_108, 0.3333333);
  } else {
    tmpvar_111 = (((903.3 * tmpvar_108) + 16.0) / 116.0);
  };
  highp float tmpvar_112;
  if ((tmpvar_109 > 0.008856)) {
    tmpvar_112 = pow (tmpvar_109, 0.3333333);
  } else {
    tmpvar_112 = (((903.3 * tmpvar_109) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_113;
  tmpvar_113.x = (((116.0 * tmpvar_111) - 16.0) / 100.0);
  tmpvar_113.y = (((500.0 * 
    (tmpvar_110 - tmpvar_111)
  ) + 110.0) / 220.0);
  tmpvar_113.z = (((200.0 * 
    (tmpvar_111 - tmpvar_112)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_114;
  tmpvar_114 = clamp ((tmpvar_113 + tmpvar_103), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float z_115;
  highp float x_116;
  highp float tmpvar_117;
  tmpvar_117 = (((tmpvar_114.x * 100.0) + 16.0) / 116.0);
  highp float tmpvar_118;
  tmpvar_118 = (((
    (tmpvar_114.y * 220.0)
   - 110.0) / 500.0) + tmpvar_117);
  x_116 = tmpvar_118;
  highp float tmpvar_119;
  tmpvar_119 = (tmpvar_117 - ((
    (tmpvar_114.z * 220.0)
   - 110.0) / 200.0));
  z_115 = tmpvar_119;
  highp float tmpvar_120;
  tmpvar_120 = pow (tmpvar_118, 3.0);
  highp float tmpvar_121;
  tmpvar_121 = pow (tmpvar_117, 3.0);
  highp float tmpvar_122;
  tmpvar_122 = pow (tmpvar_119, 3.0);
  highp float tmpvar_123;
  if ((tmpvar_120 > 0.008856)) {
    tmpvar_123 = tmpvar_120;
  } else {
    tmpvar_123 = ((tmpvar_118 - 0.137931) / 7.787069);
  };
  x_116 = (tmpvar_123 * 0.950456);
  highp float tmpvar_124;
  if ((tmpvar_121 > 0.008856)) {
    tmpvar_124 = tmpvar_121;
  } else {
    tmpvar_124 = ((tmpvar_117 - 0.137931) / 7.787069);
  };
  highp float tmpvar_125;
  if ((tmpvar_122 > 0.008856)) {
    tmpvar_125 = tmpvar_122;
  } else {
    tmpvar_125 = ((tmpvar_119 - 0.137931) / 7.787069);
  };
  z_115 = (tmpvar_125 * 1.088754);
  highp float tmpvar_126;
  tmpvar_126 = (((x_116 * 3.240454) + (tmpvar_124 * -1.537138)) + (z_115 * -0.4985314));
  highp float tmpvar_127;
  tmpvar_127 = (((x_116 * -0.969266) + (tmpvar_124 * 1.876011)) + (z_115 * 0.041556));
  highp float tmpvar_128;
  tmpvar_128 = (((x_116 * 0.0556434) + (tmpvar_124 * -0.2040259)) + (z_115 * 1.057225));
  highp float tmpvar_129;
  if ((tmpvar_126 > 0.0031308)) {
    tmpvar_129 = ((1.055 * pow (tmpvar_126, 0.4166667)) - 0.055);
  } else {
    tmpvar_129 = (12.92 * tmpvar_126);
  };
  highp float tmpvar_130;
  if ((tmpvar_127 > 0.0031308)) {
    tmpvar_130 = ((1.055 * pow (tmpvar_127, 0.4166667)) - 0.055);
  } else {
    tmpvar_130 = (12.92 * tmpvar_127);
  };
  highp float tmpvar_131;
  if ((tmpvar_128 > 0.0031308)) {
    tmpvar_131 = ((1.055 * pow (tmpvar_128, 0.4166667)) - 0.055);
  } else {
    tmpvar_131 = (12.92 * tmpvar_128);
  };
  highp vec3 tmpvar_132;
  tmpvar_132.x = tmpvar_129;
  tmpvar_132.y = tmpvar_130;
  tmpvar_132.z = tmpvar_131;
  lowp vec3 tmpvar_133;
  tmpvar_133 = texture (SkinTintMaskTex, xlv_TEXCOORD0).xxx;
  highp vec3 tmpvar_134;
  tmpvar_134 = mix (color_10.xyz, tmpvar_132, tmpvar_133);
  mainColor_9 = (tmpvar_134 * tmpvar_134);
  lowp vec3 tmpvar_135;
  tmpvar_135 = texture (RegionTintMaskTex, xlv_TEXCOORD0).xyz;
  regionMaskColor_8 = tmpvar_135;
  highp vec4 tmpvar_136;
  tmpvar_136.w = 0.0;
  tmpvar_136.xyz = mainColor_9;
  highp vec4 tmpvar_137;
  tmpvar_137.w = 0.0;
  tmpvar_137.xyz = mainColor_9;
  highp vec4 tmpvar_138;
  tmpvar_138.w = 0.0;
  tmpvar_138.xyz = mainColor_9;
  mainColor_9 = (((
    (mainColor_9 * (1.0 - ((regionMaskColor_8.x + regionMaskColor_8.y) + regionMaskColor_8.z)))
   + 
    (mix (tmpvar_136, RegionRTint, RegionTintBlend.xxxx) * regionMaskColor_8.x)
  .xyz) + (
    mix (tmpvar_137, RegionGTint, RegionTintBlend.yyyy)
   * regionMaskColor_8.y).xyz) + (mix (tmpvar_138, RegionBTint, RegionTintBlend.zzzz) * regionMaskColor_8.z).xyz);
  lowp vec3 tmpvar_139;
  tmpvar_139 = texture (TexSpecular, xlv_TEXCOORD0).xyz;
  specular_7 = tmpvar_139;
  highp float tmpvar_140;
  tmpvar_140 = (1.0 - specular_7.x);
  highp vec2 tmpvar_141;
  tmpvar_141.x = (((
    dot (tmpvar_76, tmpvar_77)
   * 0.5) + 0.5) * 0.99);
  tmpvar_141.y = specular_7.y;
  lowp vec3 tmpvar_142;
  tmpvar_142 = texture (TexBRDF, tmpvar_141).xyz;
  brdfColor_6 = tmpvar_142;
  highp float tmpvar_143;
  tmpvar_143 = max (((
    dot (tmpvar_76, tmpvar_78)
   + 0.5) * 0.7), 0.0);
  nl2_5 = (tmpvar_143 * tmpvar_143);
  nl2_5 = (nl2_5 * nl2_5);
  nl2_5 = (nl2_5 * nl2_5);
  backLight_4 = ((nl2_5 * LightColor.xyz) * ((LightIntensity * mainColor_9) * mainNormal_11.z));
  backLight_4 = (backLight_4 / (vec3(1.0, 1.0, 1.0) + backLight_4));
  highp vec3 I_144;
  I_144 = -(tmpvar_73);
  reflectDir_3.xyz = (I_144 - (2.0 * (
    dot (tmpvar_76, I_144)
   * tmpvar_76)));
  reflectDir_3.w = (tmpvar_140 * 4.0);
  lowp vec4 tmpvar_145;
  tmpvar_145 = textureLod (TexSkybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_146;
  tmpvar_146 = tmpvar_145;
  iblColor_2.w = tmpvar_146.w;
  iblColor_2.xyz = ((tmpvar_146.xyz * tmpvar_146.w) * 4.0);
  highp float tmpvar_147;
  tmpvar_147 = max ((tmpvar_140 * tmpvar_140), 0.1);
  highp float tmpvar_148;
  tmpvar_148 = (tmpvar_147 * tmpvar_147);
  highp float tmpvar_149;
  tmpvar_149 = (((
    (tmpvar_80 * tmpvar_148)
   - tmpvar_80) * tmpvar_80) + 1.0);
  d_1 = ((0.3183099 * tmpvar_148) / ((tmpvar_149 * tmpvar_149) + 1e-7));
  highp float tmpvar_150;
  tmpvar_150 = min (d_1, 100.0);
  d_1 = tmpvar_150;
  highp vec4 tmpvar_151;
  tmpvar_151.xyz = (((
    ((tmpvar_150 * mix (Fresnel, 1.0, (1.0 - tmpvar_79))) * LIGHT_COLOR)
   + 
    (((iblColor_2.xyz * 0.5) * ((
      (min ((Fresnel * 2.0), 1.0) - Fresnel)
     * 
      pow ((1.0 - tmpvar_79), 4.0)
    ) + Fresnel)) * AMBIENT_COLOR)
  ) * ColorSpecular.xyz) + ((
    (((mix (ColorShadow.xyz, brdfColor_6, vec3(tmpvar_13)) * LIGHT_COLOR) * mainColor_9) + backLight_4)
   + 
    (AMBIENT_COLOR * mainColor_9)
  ) * mix (ColorShade.xyz, vec3(1.0, 1.0, 1.0), vec3(
    mix (1.0, tmpvar_79, (1.0 - specular_7.z))
  ))));
  tmpvar_151.w = tmpvar_82;
  _glesFragData[0] = tmpvar_151;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexNormal",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSpecular",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexBRDF",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSkybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorShade",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorShadow",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorSpecular",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionRTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionGTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionBTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintBlend",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D DiffuseTex;
uniform sampler2D TexNormal;
uniform sampler2D TexSpecular;
uniform sampler2D TexBRDF;
uniform lowp samplerCube TexSkybox;
uniform sampler2D RegionTintMaskTex;
uniform sampler2D SkinTintMaskTex;
uniform highp vec4 ColorShade;
uniform highp vec4 ColorShadow;
uniform highp vec4 ColorSpecular;
uniform highp vec4 SkinTint;
uniform highp vec4 SkinColor;
uniform highp vec4 RegionRTint;
uniform highp vec4 RegionGTint;
uniform highp vec4 RegionBTint;
uniform highp vec3 RegionTintBlend;
uniform highp float Fresnel;
uniform highp vec3 LightDir;
uniform highp vec4 LightColor;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 backLight_4;
  highp float nl2_5;
  highp vec3 brdfColor_6;
  highp vec3 specular_7;
  highp vec3 regionMaskColor_8;
  highp vec3 mainColor_9;
  highp vec4 color_10;
  highp vec3 mainNormal_11;
  highp vec4 shadowCoord_12;
  shadowCoord_12 = xlv_TEXCOORD4;
  highp float tmpvar_13;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_13 = 1.0;
  } else {
    shadowCoord_12.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_14;
    highp vec4 fetchesOffsetsU_15;
    highp float shadow_16;
    highp vec2 tmpvar_17;
    tmpvar_17 = (shadowCoord_12.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_18;
    tmpvar_18 = floor((tmpvar_17 + 0.5));
    highp vec2 tmpvar_19;
    tmpvar_19 = (tmpvar_17 - tmpvar_18);
    highp vec4 texelsWeightsA_20;
    highp vec4 texelsWeightsB_21;
    highp vec4 computedArea_22;
    highp vec4 computedAreaUncut_23;
    highp float tmpvar_24;
    tmpvar_24 = (((tmpvar_19.x + 0.5) * (tmpvar_19.x + 0.5)) * 0.5);
    highp float tmpvar_25;
    tmpvar_25 = (tmpvar_24 - tmpvar_19.x);
    computedArea_22.x = tmpvar_25;
    computedAreaUncut_23.x = tmpvar_25;
    computedArea_22.w = tmpvar_24;
    computedAreaUncut_23.w = tmpvar_24;
    computedAreaUncut_23.y = ((1.5 - tmpvar_19.x) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = min (tmpvar_19.x, 0.0);
    computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
    computedAreaUncut_23.z = ((1.5 + tmpvar_19.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = max (tmpvar_19.x, 0.0);
    computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
    texelsWeightsA_20.x = (0.081632 * tmpvar_25);
    texelsWeightsA_20.y = (0.081632 * computedAreaUncut_23.y);
    texelsWeightsA_20.z = (0.081632 * (computedAreaUncut_23.y + 1.0));
    texelsWeightsA_20.w = (0.081632 * (computedArea_22.y + 2.0));
    texelsWeightsB_21.x = (0.081632 * (computedArea_22.z + 2.0));
    texelsWeightsB_21.y = (0.081632 * (computedAreaUncut_23.z + 1.0));
    texelsWeightsB_21.z = (0.081632 * computedAreaUncut_23.z);
    texelsWeightsB_21.w = (0.081632 * tmpvar_24);
    highp vec4 texelsWeightsA_28;
    highp vec4 texelsWeightsB_29;
    highp vec4 computedArea_30;
    highp vec4 computedAreaUncut_31;
    highp float tmpvar_32;
    tmpvar_32 = (((tmpvar_19.y + 0.5) * (tmpvar_19.y + 0.5)) * 0.5);
    highp float tmpvar_33;
    tmpvar_33 = (tmpvar_32 - tmpvar_19.y);
    computedArea_30.x = tmpvar_33;
    computedAreaUncut_31.x = tmpvar_33;
    computedArea_30.w = tmpvar_32;
    computedAreaUncut_31.w = tmpvar_32;
    computedAreaUncut_31.y = ((1.5 - tmpvar_19.y) - 0.5);
    highp float tmpvar_34;
    tmpvar_34 = min (tmpvar_19.y, 0.0);
    computedArea_30.y = (computedAreaUncut_31.y - (tmpvar_34 * tmpvar_34));
    computedAreaUncut_31.z = ((1.5 + tmpvar_19.y) - 0.5);
    highp float tmpvar_35;
    tmpvar_35 = max (tmpvar_19.y, 0.0);
    computedArea_30.z = (computedAreaUncut_31.z - (tmpvar_35 * tmpvar_35));
    texelsWeightsA_28.x = (0.081632 * tmpvar_33);
    texelsWeightsA_28.y = (0.081632 * computedAreaUncut_31.y);
    texelsWeightsA_28.z = (0.081632 * (computedAreaUncut_31.y + 1.0));
    texelsWeightsA_28.w = (0.081632 * (computedArea_30.y + 2.0));
    texelsWeightsB_29.x = (0.081632 * (computedArea_30.z + 2.0));
    texelsWeightsB_29.y = (0.081632 * (computedAreaUncut_31.z + 1.0));
    texelsWeightsB_29.z = (0.081632 * computedAreaUncut_31.z);
    texelsWeightsB_29.w = (0.081632 * tmpvar_32);
    highp vec4 tmpvar_36;
    tmpvar_36.xy = texelsWeightsA_20.xz;
    tmpvar_36.zw = texelsWeightsB_21.xz;
    highp vec4 tmpvar_37;
    tmpvar_37.xy = texelsWeightsA_20.yw;
    tmpvar_37.zw = texelsWeightsB_21.yw;
    highp vec4 tmpvar_38;
    tmpvar_38 = (tmpvar_36 + tmpvar_37);
    highp vec4 tmpvar_39;
    tmpvar_39.xy = texelsWeightsA_28.xz;
    tmpvar_39.zw = texelsWeightsB_29.xz;
    highp vec4 tmpvar_40;
    tmpvar_40.xy = texelsWeightsA_28.yw;
    tmpvar_40.zw = texelsWeightsB_29.yw;
    highp vec4 tmpvar_41;
    tmpvar_41 = (tmpvar_39 + tmpvar_40);
    highp vec4 tmpvar_42;
    tmpvar_42.xy = texelsWeightsA_20.yw;
    tmpvar_42.zw = texelsWeightsB_21.yw;
    highp vec4 tmpvar_43;
    tmpvar_43.xy = texelsWeightsA_28.yw;
    tmpvar_43.zw = texelsWeightsB_29.yw;
    fetchesOffsetsU_15 = (((tmpvar_42 / tmpvar_38) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_14 = (((tmpvar_43 / tmpvar_41) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_44;
    tmpvar_44 = (tmpvar_18 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_45;
    tmpvar_45.x = fetchesOffsetsU_15.x;
    tmpvar_45.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_46;
    tmpvar_46.xy = (tmpvar_44 + tmpvar_45);
    tmpvar_46.z = shadowCoord_12.z;
    mediump float tmpvar_47;
    tmpvar_47 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_46);
    shadow_16 = ((tmpvar_38.x * tmpvar_41.x) * tmpvar_47);
    highp vec2 tmpvar_48;
    tmpvar_48.x = fetchesOffsetsU_15.y;
    tmpvar_48.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (tmpvar_44 + tmpvar_48);
    tmpvar_49.z = shadowCoord_12.z;
    mediump float tmpvar_50;
    tmpvar_50 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_49);
    shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.x) * tmpvar_50));
    highp vec2 tmpvar_51;
    tmpvar_51.x = fetchesOffsetsU_15.z;
    tmpvar_51.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_52;
    tmpvar_52.xy = (tmpvar_44 + tmpvar_51);
    tmpvar_52.z = shadowCoord_12.z;
    mediump float tmpvar_53;
    tmpvar_53 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_52);
    shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.x) * tmpvar_53));
    highp vec2 tmpvar_54;
    tmpvar_54.x = fetchesOffsetsU_15.w;
    tmpvar_54.y = fetchesOffsetsV_14.x;
    highp vec3 tmpvar_55;
    tmpvar_55.xy = (tmpvar_44 + tmpvar_54);
    tmpvar_55.z = shadowCoord_12.z;
    mediump float tmpvar_56;
    tmpvar_56 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_55);
    shadow_16 = (shadow_16 + ((tmpvar_38.w * tmpvar_41.x) * tmpvar_56));
    highp vec2 tmpvar_57;
    tmpvar_57.x = fetchesOffsetsU_15.x;
    tmpvar_57.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_58;
    tmpvar_58.xy = (tmpvar_44 + tmpvar_57);
    tmpvar_58.z = shadowCoord_12.z;
    mediump float tmpvar_59;
    tmpvar_59 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_58);
    shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.y) * tmpvar_59));
    highp vec2 tmpvar_60;
    tmpvar_60.x = fetchesOffsetsU_15.y;
    tmpvar_60.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_61;
    tmpvar_61.xy = (tmpvar_44 + tmpvar_60);
    tmpvar_61.z = shadowCoord_12.z;
    mediump float tmpvar_62;
    tmpvar_62 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_61);
    shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.y) * tmpvar_62));
    highp vec2 tmpvar_63;
    tmpvar_63.x = fetchesOffsetsU_15.z;
    tmpvar_63.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_64;
    tmpvar_64.xy = (tmpvar_44 + tmpvar_63);
    tmpvar_64.z = shadowCoord_12.z;
    mediump float tmpvar_65;
    tmpvar_65 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_64);
    shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.y) * tmpvar_65));
    highp vec2 tmpvar_66;
    tmpvar_66.x = fetchesOffsetsU_15.w;
    tmpvar_66.y = fetchesOffsetsV_14.y;
    highp vec3 tmpvar_67;
    tmpvar_67.xy = (tmpvar_44 + tmpvar_66);
    tmpvar_67.z = shadowCoord_12.z;
    mediump float tmpvar_68;
    tmpvar_68 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_67);
    shadow_16 = (shadow_16 + ((tmpvar_38.w * tmpvar_41.y) * tmpvar_68));
    highp vec2 tmpvar_69;
    tmpvar_69.x = fetchesOffsetsU_15.x;
    tmpvar_69.y = fetchesOffsetsV_14.z;
    highp vec3 tmpvar_70;
    tmpvar_70.xy = (tmpvar_44 + tmpvar_69);
    tmpvar_70.z = shadowCoord_12.z;
    mediump float tmpvar_71;
    tmpvar_71 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_70);
    shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.z) * tmpvar_71));
    highp vec2 tmpvar_72;
    tmpvar_72.x = fetchesOffsetsU_15.y;
    tmpvar_72.y = fetchesOffsetsV_14.z;
    highp vec3 tmpvar_73;
    tmpvar_73.xy = (tmpvar_44 + tmpvar_72);
    tmpvar_73.z = shadowCoord_12.z;
    mediump float tmpvar_74;
    tmpvar_74 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_73);
    shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.z) * tmpvar_74));
    highp vec2 tmpvar_75;
    tmpvar_75.x = fetchesOffsetsU_15.z;
    tmpvar_75.y = fetchesOffsetsV_14.z;
    highp vec3 tmpvar_76;
    tmpvar_76.xy = (tmpvar_44 + tmpvar_75);
    tmpvar_76.z = shadowCoord_12.z;
    mediump float tmpvar_77;
    tmpvar_77 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_76);
    shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.z) * tmpvar_77));
    highp vec2 tmpvar_78;
    tmpvar_78.x = fetchesOffsetsU_15.w;
    tmpvar_78.y = fetchesOffsetsV_14.z;
    highp vec3 tmpvar_79;
    tmpvar_79.xy = (tmpvar_44 + tmpvar_78);
    tmpvar_79.z = shadowCoord_12.z;
    mediump float tmpvar_80;
    tmpvar_80 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_79);
    shadow_16 = (shadow_16 + ((tmpvar_38.w * tmpvar_41.z) * tmpvar_80));
    highp vec2 tmpvar_81;
    tmpvar_81.x = fetchesOffsetsU_15.x;
    tmpvar_81.y = fetchesOffsetsV_14.w;
    highp vec3 tmpvar_82;
    tmpvar_82.xy = (tmpvar_44 + tmpvar_81);
    tmpvar_82.z = shadowCoord_12.z;
    mediump float tmpvar_83;
    tmpvar_83 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_82);
    shadow_16 = (shadow_16 + ((tmpvar_38.x * tmpvar_41.w) * tmpvar_83));
    highp vec2 tmpvar_84;
    tmpvar_84.x = fetchesOffsetsU_15.y;
    tmpvar_84.y = fetchesOffsetsV_14.w;
    highp vec3 tmpvar_85;
    tmpvar_85.xy = (tmpvar_44 + tmpvar_84);
    tmpvar_85.z = shadowCoord_12.z;
    mediump float tmpvar_86;
    tmpvar_86 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_85);
    shadow_16 = (shadow_16 + ((tmpvar_38.y * tmpvar_41.w) * tmpvar_86));
    highp vec2 tmpvar_87;
    tmpvar_87.x = fetchesOffsetsU_15.z;
    tmpvar_87.y = fetchesOffsetsV_14.w;
    highp vec3 tmpvar_88;
    tmpvar_88.xy = (tmpvar_44 + tmpvar_87);
    tmpvar_88.z = shadowCoord_12.z;
    mediump float tmpvar_89;
    tmpvar_89 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_88);
    shadow_16 = (shadow_16 + ((tmpvar_38.z * tmpvar_41.w) * tmpvar_89));
    highp vec2 tmpvar_90;
    tmpvar_90.x = fetchesOffsetsU_15.w;
    tmpvar_90.y = fetchesOffsetsV_14.w;
    highp vec3 tmpvar_91;
    tmpvar_91.xy = (tmpvar_44 + tmpvar_90);
    tmpvar_91.z = shadowCoord_12.z;
    mediump float tmpvar_92;
    tmpvar_92 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_91);
    shadow_16 = (shadow_16 + ((tmpvar_38.w * tmpvar_41.w) * tmpvar_92));
    tmpvar_13 = mix (1.0, shadow_16, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_93;
  tmpvar_93.x = xlv_TEXCOORD1.w;
  tmpvar_93.y = xlv_TEXCOORD2.w;
  tmpvar_93.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_94;
  tmpvar_94 = normalize((CAMERA_WORLDPOSITION - tmpvar_93));
  lowp vec3 tmpvar_95;
  tmpvar_95 = texture (TexNormal, xlv_TEXCOORD0).xyz;
  mainNormal_11 = tmpvar_95;
  highp vec3 tmpvar_96;
  tmpvar_96 = ((mainNormal_11 * 2.0) - 1.0);
  highp vec3 tmpvar_97;
  tmpvar_97 = normalize(((
    (tmpvar_96.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_96.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_96.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_98;
  tmpvar_98 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_99;
  tmpvar_99 = normalize(LightDir);
  highp float tmpvar_100;
  tmpvar_100 = max (dot (tmpvar_97, tmpvar_94), 0.0);
  highp float tmpvar_101;
  tmpvar_101 = max (dot (tmpvar_97, normalize(
    (tmpvar_94 + tmpvar_98)
  )), 0.0);
  lowp vec4 tmpvar_102;
  tmpvar_102 = texture (DiffuseTex, xlv_TEXCOORD0);
  color_10 = tmpvar_102;
  mainColor_9 = color_10.xyz;
  highp float tmpvar_103;
  tmpvar_103 = color_10.w;
  highp float tmpvar_104;
  if ((SkinColor.x > 0.04045)) {
    tmpvar_104 = pow (((SkinColor.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_104 = (SkinColor.x / 12.92);
  };
  highp float tmpvar_105;
  if ((SkinColor.y > 0.04045)) {
    tmpvar_105 = pow (((SkinColor.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_105 = (SkinColor.y / 12.92);
  };
  highp float tmpvar_106;
  if ((SkinColor.z > 0.04045)) {
    tmpvar_106 = pow (((SkinColor.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_106 = (SkinColor.z / 12.92);
  };
  highp float tmpvar_107;
  tmpvar_107 = (((
    (tmpvar_104 * 0.4124564)
   + 
    (tmpvar_105 * 0.3575761)
  ) + (tmpvar_106 * 0.1804375)) / 0.950456);
  highp float tmpvar_108;
  tmpvar_108 = (((tmpvar_104 * 0.2126729) + (tmpvar_105 * 0.7151522)) + (tmpvar_106 * 0.072175));
  highp float tmpvar_109;
  tmpvar_109 = (((
    (tmpvar_104 * 0.0193339)
   + 
    (tmpvar_105 * 0.119192)
  ) + (tmpvar_106 * 0.9503041)) / 1.088754);
  highp float tmpvar_110;
  if ((tmpvar_107 > 0.008856)) {
    tmpvar_110 = pow (tmpvar_107, 0.3333333);
  } else {
    tmpvar_110 = (((903.3 * tmpvar_107) + 16.0) / 116.0);
  };
  highp float tmpvar_111;
  if ((tmpvar_108 > 0.008856)) {
    tmpvar_111 = pow (tmpvar_108, 0.3333333);
  } else {
    tmpvar_111 = (((903.3 * tmpvar_108) + 16.0) / 116.0);
  };
  highp float tmpvar_112;
  if ((tmpvar_109 > 0.008856)) {
    tmpvar_112 = pow (tmpvar_109, 0.3333333);
  } else {
    tmpvar_112 = (((903.3 * tmpvar_109) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_113;
  tmpvar_113.x = (((116.0 * tmpvar_111) - 16.0) / 100.0);
  tmpvar_113.y = (((500.0 * 
    (tmpvar_110 - tmpvar_111)
  ) + 110.0) / 220.0);
  tmpvar_113.z = (((200.0 * 
    (tmpvar_111 - tmpvar_112)
  ) + 110.0) / 220.0);
  highp float tmpvar_114;
  if ((SkinTint.x > 0.04045)) {
    tmpvar_114 = pow (((SkinTint.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_114 = (SkinTint.x / 12.92);
  };
  highp float tmpvar_115;
  if ((SkinTint.y > 0.04045)) {
    tmpvar_115 = pow (((SkinTint.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_115 = (SkinTint.y / 12.92);
  };
  highp float tmpvar_116;
  if ((SkinTint.z > 0.04045)) {
    tmpvar_116 = pow (((SkinTint.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_116 = (SkinTint.z / 12.92);
  };
  highp float tmpvar_117;
  tmpvar_117 = (((
    (tmpvar_114 * 0.4124564)
   + 
    (tmpvar_115 * 0.3575761)
  ) + (tmpvar_116 * 0.1804375)) / 0.950456);
  highp float tmpvar_118;
  tmpvar_118 = (((tmpvar_114 * 0.2126729) + (tmpvar_115 * 0.7151522)) + (tmpvar_116 * 0.072175));
  highp float tmpvar_119;
  tmpvar_119 = (((
    (tmpvar_114 * 0.0193339)
   + 
    (tmpvar_115 * 0.119192)
  ) + (tmpvar_116 * 0.9503041)) / 1.088754);
  highp float tmpvar_120;
  if ((tmpvar_117 > 0.008856)) {
    tmpvar_120 = pow (tmpvar_117, 0.3333333);
  } else {
    tmpvar_120 = (((903.3 * tmpvar_117) + 16.0) / 116.0);
  };
  highp float tmpvar_121;
  if ((tmpvar_118 > 0.008856)) {
    tmpvar_121 = pow (tmpvar_118, 0.3333333);
  } else {
    tmpvar_121 = (((903.3 * tmpvar_118) + 16.0) / 116.0);
  };
  highp float tmpvar_122;
  if ((tmpvar_119 > 0.008856)) {
    tmpvar_122 = pow (tmpvar_119, 0.3333333);
  } else {
    tmpvar_122 = (((903.3 * tmpvar_119) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_123;
  tmpvar_123.x = (((116.0 * tmpvar_121) - 16.0) / 100.0);
  tmpvar_123.y = (((500.0 * 
    (tmpvar_120 - tmpvar_121)
  ) + 110.0) / 220.0);
  tmpvar_123.z = (((200.0 * 
    (tmpvar_121 - tmpvar_122)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_124;
  tmpvar_124 = (tmpvar_123 - tmpvar_113);
  highp float tmpvar_125;
  if ((color_10.x > 0.04045)) {
    tmpvar_125 = pow (((color_10.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_125 = (color_10.x / 12.92);
  };
  highp float tmpvar_126;
  if ((color_10.y > 0.04045)) {
    tmpvar_126 = pow (((color_10.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_126 = (color_10.y / 12.92);
  };
  highp float tmpvar_127;
  if ((color_10.z > 0.04045)) {
    tmpvar_127 = pow (((color_10.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_127 = (color_10.z / 12.92);
  };
  highp float tmpvar_128;
  tmpvar_128 = (((
    (tmpvar_125 * 0.4124564)
   + 
    (tmpvar_126 * 0.3575761)
  ) + (tmpvar_127 * 0.1804375)) / 0.950456);
  highp float tmpvar_129;
  tmpvar_129 = (((tmpvar_125 * 0.2126729) + (tmpvar_126 * 0.7151522)) + (tmpvar_127 * 0.072175));
  highp float tmpvar_130;
  tmpvar_130 = (((
    (tmpvar_125 * 0.0193339)
   + 
    (tmpvar_126 * 0.119192)
  ) + (tmpvar_127 * 0.9503041)) / 1.088754);
  highp float tmpvar_131;
  if ((tmpvar_128 > 0.008856)) {
    tmpvar_131 = pow (tmpvar_128, 0.3333333);
  } else {
    tmpvar_131 = (((903.3 * tmpvar_128) + 16.0) / 116.0);
  };
  highp float tmpvar_132;
  if ((tmpvar_129 > 0.008856)) {
    tmpvar_132 = pow (tmpvar_129, 0.3333333);
  } else {
    tmpvar_132 = (((903.3 * tmpvar_129) + 16.0) / 116.0);
  };
  highp float tmpvar_133;
  if ((tmpvar_130 > 0.008856)) {
    tmpvar_133 = pow (tmpvar_130, 0.3333333);
  } else {
    tmpvar_133 = (((903.3 * tmpvar_130) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_134;
  tmpvar_134.x = (((116.0 * tmpvar_132) - 16.0) / 100.0);
  tmpvar_134.y = (((500.0 * 
    (tmpvar_131 - tmpvar_132)
  ) + 110.0) / 220.0);
  tmpvar_134.z = (((200.0 * 
    (tmpvar_132 - tmpvar_133)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_135;
  tmpvar_135 = clamp ((tmpvar_134 + tmpvar_124), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float z_136;
  highp float x_137;
  highp float tmpvar_138;
  tmpvar_138 = (((tmpvar_135.x * 100.0) + 16.0) / 116.0);
  highp float tmpvar_139;
  tmpvar_139 = (((
    (tmpvar_135.y * 220.0)
   - 110.0) / 500.0) + tmpvar_138);
  x_137 = tmpvar_139;
  highp float tmpvar_140;
  tmpvar_140 = (tmpvar_138 - ((
    (tmpvar_135.z * 220.0)
   - 110.0) / 200.0));
  z_136 = tmpvar_140;
  highp float tmpvar_141;
  tmpvar_141 = pow (tmpvar_139, 3.0);
  highp float tmpvar_142;
  tmpvar_142 = pow (tmpvar_138, 3.0);
  highp float tmpvar_143;
  tmpvar_143 = pow (tmpvar_140, 3.0);
  highp float tmpvar_144;
  if ((tmpvar_141 > 0.008856)) {
    tmpvar_144 = tmpvar_141;
  } else {
    tmpvar_144 = ((tmpvar_139 - 0.137931) / 7.787069);
  };
  x_137 = (tmpvar_144 * 0.950456);
  highp float tmpvar_145;
  if ((tmpvar_142 > 0.008856)) {
    tmpvar_145 = tmpvar_142;
  } else {
    tmpvar_145 = ((tmpvar_138 - 0.137931) / 7.787069);
  };
  highp float tmpvar_146;
  if ((tmpvar_143 > 0.008856)) {
    tmpvar_146 = tmpvar_143;
  } else {
    tmpvar_146 = ((tmpvar_140 - 0.137931) / 7.787069);
  };
  z_136 = (tmpvar_146 * 1.088754);
  highp float tmpvar_147;
  tmpvar_147 = (((x_137 * 3.240454) + (tmpvar_145 * -1.537138)) + (z_136 * -0.4985314));
  highp float tmpvar_148;
  tmpvar_148 = (((x_137 * -0.969266) + (tmpvar_145 * 1.876011)) + (z_136 * 0.041556));
  highp float tmpvar_149;
  tmpvar_149 = (((x_137 * 0.0556434) + (tmpvar_145 * -0.2040259)) + (z_136 * 1.057225));
  highp float tmpvar_150;
  if ((tmpvar_147 > 0.0031308)) {
    tmpvar_150 = ((1.055 * pow (tmpvar_147, 0.4166667)) - 0.055);
  } else {
    tmpvar_150 = (12.92 * tmpvar_147);
  };
  highp float tmpvar_151;
  if ((tmpvar_148 > 0.0031308)) {
    tmpvar_151 = ((1.055 * pow (tmpvar_148, 0.4166667)) - 0.055);
  } else {
    tmpvar_151 = (12.92 * tmpvar_148);
  };
  highp float tmpvar_152;
  if ((tmpvar_149 > 0.0031308)) {
    tmpvar_152 = ((1.055 * pow (tmpvar_149, 0.4166667)) - 0.055);
  } else {
    tmpvar_152 = (12.92 * tmpvar_149);
  };
  highp vec3 tmpvar_153;
  tmpvar_153.x = tmpvar_150;
  tmpvar_153.y = tmpvar_151;
  tmpvar_153.z = tmpvar_152;
  lowp vec3 tmpvar_154;
  tmpvar_154 = texture (SkinTintMaskTex, xlv_TEXCOORD0).xxx;
  highp vec3 tmpvar_155;
  tmpvar_155 = mix (color_10.xyz, tmpvar_153, tmpvar_154);
  mainColor_9 = (tmpvar_155 * tmpvar_155);
  lowp vec3 tmpvar_156;
  tmpvar_156 = texture (RegionTintMaskTex, xlv_TEXCOORD0).xyz;
  regionMaskColor_8 = tmpvar_156;
  highp vec4 tmpvar_157;
  tmpvar_157.w = 0.0;
  tmpvar_157.xyz = mainColor_9;
  highp vec4 tmpvar_158;
  tmpvar_158.w = 0.0;
  tmpvar_158.xyz = mainColor_9;
  highp vec4 tmpvar_159;
  tmpvar_159.w = 0.0;
  tmpvar_159.xyz = mainColor_9;
  mainColor_9 = (((
    (mainColor_9 * (1.0 - ((regionMaskColor_8.x + regionMaskColor_8.y) + regionMaskColor_8.z)))
   + 
    (mix (tmpvar_157, RegionRTint, RegionTintBlend.xxxx) * regionMaskColor_8.x)
  .xyz) + (
    mix (tmpvar_158, RegionGTint, RegionTintBlend.yyyy)
   * regionMaskColor_8.y).xyz) + (mix (tmpvar_159, RegionBTint, RegionTintBlend.zzzz) * regionMaskColor_8.z).xyz);
  lowp vec3 tmpvar_160;
  tmpvar_160 = texture (TexSpecular, xlv_TEXCOORD0).xyz;
  specular_7 = tmpvar_160;
  highp float tmpvar_161;
  tmpvar_161 = (1.0 - specular_7.x);
  highp vec2 tmpvar_162;
  tmpvar_162.x = (((
    dot (tmpvar_97, tmpvar_98)
   * 0.5) + 0.5) * 0.99);
  tmpvar_162.y = specular_7.y;
  lowp vec3 tmpvar_163;
  tmpvar_163 = texture (TexBRDF, tmpvar_162).xyz;
  brdfColor_6 = tmpvar_163;
  highp float tmpvar_164;
  tmpvar_164 = max (((
    dot (tmpvar_97, tmpvar_99)
   + 0.5) * 0.7), 0.0);
  nl2_5 = (tmpvar_164 * tmpvar_164);
  nl2_5 = (nl2_5 * nl2_5);
  nl2_5 = (nl2_5 * nl2_5);
  backLight_4 = ((nl2_5 * LightColor.xyz) * ((LightIntensity * mainColor_9) * mainNormal_11.z));
  backLight_4 = (backLight_4 / (vec3(1.0, 1.0, 1.0) + backLight_4));
  highp vec3 I_165;
  I_165 = -(tmpvar_94);
  reflectDir_3.xyz = (I_165 - (2.0 * (
    dot (tmpvar_97, I_165)
   * tmpvar_97)));
  reflectDir_3.w = (tmpvar_161 * 4.0);
  lowp vec4 tmpvar_166;
  tmpvar_166 = textureLod (TexSkybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_167;
  tmpvar_167 = tmpvar_166;
  iblColor_2.w = tmpvar_167.w;
  iblColor_2.xyz = ((tmpvar_167.xyz * tmpvar_167.w) * 4.0);
  highp float tmpvar_168;
  tmpvar_168 = max ((tmpvar_161 * tmpvar_161), 0.1);
  highp float tmpvar_169;
  tmpvar_169 = (tmpvar_168 * tmpvar_168);
  highp float tmpvar_170;
  tmpvar_170 = (((
    (tmpvar_101 * tmpvar_169)
   - tmpvar_101) * tmpvar_101) + 1.0);
  d_1 = ((0.3183099 * tmpvar_169) / ((tmpvar_170 * tmpvar_170) + 1e-7));
  highp float tmpvar_171;
  tmpvar_171 = min (d_1, 100.0);
  d_1 = tmpvar_171;
  highp vec4 tmpvar_172;
  tmpvar_172.xyz = (((
    ((tmpvar_171 * mix (Fresnel, 1.0, (1.0 - tmpvar_100))) * LIGHT_COLOR)
   + 
    (((iblColor_2.xyz * 0.5) * ((
      (min ((Fresnel * 2.0), 1.0) - Fresnel)
     * 
      pow ((1.0 - tmpvar_100), 4.0)
    ) + Fresnel)) * AMBIENT_COLOR)
  ) * ColorSpecular.xyz) + ((
    (((mix (ColorShadow.xyz, brdfColor_6, vec3(tmpvar_13)) * LIGHT_COLOR) * mainColor_9) + backLight_4)
   + 
    (AMBIENT_COLOR * mainColor_9)
  ) * mix (ColorShade.xyz, vec3(1.0, 1.0, 1.0), vec3(
    mix (1.0, tmpvar_100, (1.0 - specular_7.z))
  ))));
  tmpvar_172.w = tmpvar_103;
  _glesFragData[0] = tmpvar_172;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DiffuseTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexNormal",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSpecular",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexBRDF",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TexSkybox",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTintMaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorShade",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorShadow",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ColorSpecular",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SkinColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionRTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionGTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionBTint",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RegionTintBlend",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Fresnel",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightDir",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LightIntensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_10[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_10[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D DiffuseTex;
uniform sampler2D TexNormal;
uniform sampler2D TexSpecular;
uniform sampler2D TexBRDF;
uniform lowp samplerCube TexSkybox;
uniform sampler2D RegionTintMaskTex;
uniform sampler2D SkinTintMaskTex;
uniform highp vec4 ColorShade;
uniform highp vec4 ColorShadow;
uniform highp vec4 ColorSpecular;
uniform highp vec4 SkinTint;
uniform highp vec4 SkinColor;
uniform highp vec4 RegionRTint;
uniform highp vec4 RegionGTint;
uniform highp vec4 RegionBTint;
uniform highp vec3 RegionTintBlend;
uniform highp float Fresnel;
uniform highp vec3 LightDir;
uniform highp vec4 LightColor;
uniform highp float LightIntensity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp float d_1;
  highp vec4 iblColor_2;
  highp vec4 reflectDir_3;
  highp vec3 backLight_4;
  highp float nl2_5;
  highp vec3 brdfColor_6;
  highp vec3 specular_7;
  highp vec3 regionMaskColor_8;
  highp vec3 mainColor_9;
  highp vec4 color_10;
  highp vec3 mainNormal_11;
  highp vec4 shadowCoord_12;
  shadowCoord_12 = xlv_TEXCOORD4;
  highp float tmpvar_13;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_13 = 1.0;
  } else {
    highp vec2 tmpvar_14;
    tmpvar_14.x = LIGHT_PARAM.z;
    tmpvar_14.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_15;
    tmpvar_15.xy = tmpvar_14;
    highp float tmpvar_16;
    tmpvar_16 = (1.0/(LIGHT_PARAM.z));
    tmpvar_15.z = tmpvar_16;
    tmpvar_15.w = tmpvar_16;
    shadowCoord_12.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_17;
    highp vec2 tmpvar_18;
    tmpvar_18 = tmpvar_15.xy;
    shadow_17 = 0.0;
    highp vec3 tmpvar_19;
    tmpvar_19.xy = (shadowCoord_12.xy - LIGHT_PARAM.zz);
    tmpvar_19.z = shadowCoord_12.z;
    highp vec4 tmpvar_20;
    tmpvar_20 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_19.xy);
    highp float tmpvar_21;
    if ((tmpvar_20.x < xlv_TEXCOORD4.z)) {
      tmpvar_21 = 0.0;
    } else {
      tmpvar_21 = 1.0;
    };
    shadow_17 = tmpvar_21;
    highp vec2 tmpvar_22;
    tmpvar_22.x = 0.0;
    tmpvar_22.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_23;
    tmpvar_23.xy = (shadowCoord_12.xy + tmpvar_22);
    tmpvar_23.z = shadowCoord_12.z;
    highp vec4 tmpvar_24;
    tmpvar_24 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_23.xy);
    highp float tmpvar_25;
    if ((tmpvar_24.x < xlv_TEXCOORD4.z)) {
      tmpvar_25 = 0.0;
    } else {
      tmpvar_25 = 1.0;
    };
    shadow_17 = (tmpvar_21 + tmpvar_25);
    highp vec2 tmpvar_26;
    tmpvar_26.x = tmpvar_18.x;
    tmpvar_26.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_27;
    tmpvar_27.xy = (shadowCoord_12.xy + tmpvar_26);
    tmpvar_27.z = shadowCoord_12.z;
    highp vec4 tmpvar_28;
    tmpvar_28 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_27.xy);
    highp float tmpvar_29;
    if ((tmpvar_28.x < xlv_TEXCOORD4.z)) {
      tmpvar_29 = 0.0;
    } else {
      tmpvar_29 = 1.0;
    };
    shadow_17 = (shadow_17 + tmpvar_29);
    highp vec2 tmpvar_30;
    tmpvar_30.y = 0.0;
    tmpvar_30.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_31;
    tmpvar_31.xy = (shadowCoord_12.xy + tmpvar_30);
    tmpvar_31.z = shadowCoord_12.z;
    highp vec4 tmpvar_32;
    tmpvar_32 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_31.xy);
    highp float tmpvar_33;
    if ((tmpvar_32.x < xlv_TEXCOORD4.z)) {
      tmpvar_33 = 0.0;
    } else {
      tmpvar_33 = 1.0;
    };
    shadow_17 = (shadow_17 + tmpvar_33);
    highp vec4 tmpvar_34;
    tmpvar_34 = texture (TEXTURE_SHADOW_DEPTH, shadowCoord_12.xy);
    highp float tmpvar_35;
    if ((tmpvar_34.x < xlv_TEXCOORD4.z)) {
      tmpvar_35 = 0.0;
    } else {
      tmpvar_35 = 1.0;
    };
    shadow_17 = (shadow_17 + tmpvar_35);
    highp vec2 tmpvar_36;
    tmpvar_36.y = 0.0;
    tmpvar_36.x = tmpvar_18.x;
    highp vec3 tmpvar_37;
    tmpvar_37.xy = (shadowCoord_12.xy + tmpvar_36);
    tmpvar_37.z = shadowCoord_12.z;
    highp vec4 tmpvar_38;
    tmpvar_38 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_37.xy);
    highp float tmpvar_39;
    if ((tmpvar_38.x < xlv_TEXCOORD4.z)) {
      tmpvar_39 = 0.0;
    } else {
      tmpvar_39 = 1.0;
    };
    shadow_17 = (shadow_17 + tmpvar_39);
    highp vec2 tmpvar_40;
    tmpvar_40.x = -(LIGHT_PARAM.z);
    tmpvar_40.y = tmpvar_18.y;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (shadowCoord_12.xy + tmpvar_40);
    tmpvar_41.z = shadowCoord_12.z;
    highp vec4 tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41.xy);
    highp float tmpvar_43;
    if ((tmpvar_42.x < xlv_TEXCOORD4.z)) {
      tmpvar_43 = 0.0;
    } else {
      tmpvar_43 = 1.0;
    };
    shadow_17 = (shadow_17 + tmpvar_43);
    highp vec2 tmpvar_44;
    tmpvar_44.x = 0.0;
    tmpvar_44.y = tmpvar_18.y;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (shadowCoord_12.xy + tmpvar_44);
    tmpvar_45.z = shadowCoord_12.z;
    highp vec4 tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45.xy);
    highp float tmpvar_47;
    if ((tmpvar_46.x < xlv_TEXCOORD4.z)) {
      tmpvar_47 = 0.0;
    } else {
      tmpvar_47 = 1.0;
    };
    shadow_17 = (shadow_17 + tmpvar_47);
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (shadowCoord_12.xy + LIGHT_PARAM.zz);
    tmpvar_48.z = shadowCoord_12.z;
    highp vec4 tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48.xy);
    highp float tmpvar_50;
    if ((tmpvar_49.x < xlv_TEXCOORD4.z)) {
      tmpvar_50 = 0.0;
    } else {
      tmpvar_50 = 1.0;
    };
    shadow_17 = (shadow_17 + tmpvar_50);
    shadow_17 = (shadow_17 / 9.0);
    tmpvar_13 = mix (1.0, shadow_17, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_51;
  tmpvar_51.x = xlv_TEXCOORD1.w;
  tmpvar_51.y = xlv_TEXCOORD2.w;
  tmpvar_51.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_52;
  tmpvar_52 = normalize((CAMERA_WORLDPOSITION - tmpvar_51));
  lowp vec3 tmpvar_53;
  tmpvar_53 = texture (TexNormal, xlv_TEXCOORD0).xyz;
  mainNormal_11 = tmpvar_53;
  highp vec3 tmpvar_54;
  tmpvar_54 = ((mainNormal_11 * 2.0) - 1.0);
  highp vec3 tmpvar_55;
  tmpvar_55 = normalize(((
    (tmpvar_54.x * xlv_TEXCOORD2.xyz)
   + 
    (tmpvar_54.y * xlv_TEXCOORD3.xyz)
  ) + (tmpvar_54.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_56;
  tmpvar_56 = -(LIGHT_GIVEN_DIRECTION);
  highp vec3 tmpvar_57;
  tmpvar_57 = normalize(LightDir);
  highp float tmpvar_58;
  tmpvar_58 = max (dot (tmpvar_55, tmpvar_52), 0.0);
  highp float tmpvar_59;
  tmpvar_59 = max (dot (tmpvar_55, normalize(
    (tmpvar_52 + tmpvar_56)
  )), 0.0);
  lowp vec4 tmpvar_60;
  tmpvar_60 = texture (DiffuseTex, xlv_TEXCOORD0);
  color_10 = tmpvar_60;
  mainColor_9 = color_10.xyz;
  highp float tmpvar_61;
  tmpvar_61 = color_10.w;
  highp float tmpvar_62;
  if ((SkinColor.x > 0.04045)) {
    tmpvar_62 = pow (((SkinColor.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_62 = (SkinColor.x / 12.92);
  };
  highp float tmpvar_63;
  if ((SkinColor.y > 0.04045)) {
    tmpvar_63 = pow (((SkinColor.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_63 = (SkinColor.y / 12.92);
  };
  highp float tmpvar_64;
  if ((SkinColor.z > 0.04045)) {
    tmpvar_64 = pow (((SkinColor.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_64 = (SkinColor.z / 12.92);
  };
  highp float tmpvar_65;
  tmpvar_65 = (((
    (tmpvar_62 * 0.4124564)
   + 
    (tmpvar_63 * 0.3575761)
  ) + (tmpvar_64 * 0.1804375)) / 0.950456);
  highp float tmpvar_66;
  tmpvar_66 = (((tmpvar_62 * 0.2126729) + (tmpvar_63 * 0.7151522)) + (tmpvar_64 * 0.072175));
  highp float tmpvar_67;
  tmpvar_67 = (((
    (tmpvar_62 * 0.0193339)
   + 
    (tmpvar_63 * 0.119192)
  ) + (tmpvar_64 * 0.9503041)) / 1.088754);
  highp float tmpvar_68;
  if ((tmpvar_65 > 0.008856)) {
    tmpvar_68 = pow (tmpvar_65, 0.3333333);
  } else {
    tmpvar_68 = (((903.3 * tmpvar_65) + 16.0) / 116.0);
  };
  highp float tmpvar_69;
  if ((tmpvar_66 > 0.008856)) {
    tmpvar_69 = pow (tmpvar_66, 0.3333333);
  } else {
    tmpvar_69 = (((903.3 * tmpvar_66) + 16.0) / 116.0);
  };
  highp float tmpvar_70;
  if ((tmpvar_67 > 0.008856)) {
    tmpvar_70 = pow (tmpvar_67, 0.3333333);
  } else {
    tmpvar_70 = (((903.3 * tmpvar_67) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_71;
  tmpvar_71.x = (((116.0 * tmpvar_69) - 16.0) / 100.0);
  tmpvar_71.y = (((500.0 * 
    (tmpvar_68 - tmpvar_69)
  ) + 110.0) / 220.0);
  tmpvar_71.z = (((200.0 * 
    (tmpvar_69 - tmpvar_70)
  ) + 110.0) / 220.0);
  highp float tmpvar_72;
  if ((SkinTint.x > 0.04045)) {
    tmpvar_72 = pow (((SkinTint.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_72 = (SkinTint.x / 12.92);
  };
  highp float tmpvar_73;
  if ((SkinTint.y > 0.04045)) {
    tmpvar_73 = pow (((SkinTint.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_73 = (SkinTint.y / 12.92);
  };
  highp float tmpvar_74;
  if ((SkinTint.z > 0.04045)) {
    tmpvar_74 = pow (((SkinTint.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_74 = (SkinTint.z / 12.92);
  };
  highp float tmpvar_75;
  tmpvar_75 = (((
    (tmpvar_72 * 0.4124564)
   + 
    (tmpvar_73 * 0.3575761)
  ) + (tmpvar_74 * 0.1804375)) / 0.950456);
  highp float tmpvar_76;
  tmpvar_76 = (((tmpvar_72 * 0.2126729) + (tmpvar_73 * 0.7151522)) + (tmpvar_74 * 0.072175));
  highp float tmpvar_77;
  tmpvar_77 = (((
    (tmpvar_72 * 0.0193339)
   + 
    (tmpvar_73 * 0.119192)
  ) + (tmpvar_74 * 0.9503041)) / 1.088754);
  highp float tmpvar_78;
  if ((tmpvar_75 > 0.008856)) {
    tmpvar_78 = pow (tmpvar_75, 0.3333333);
  } else {
    tmpvar_78 = (((903.3 * tmpvar_75) + 16.0) / 116.0);
  };
  highp float tmpvar_79;
  if ((tmpvar_76 > 0.008856)) {
    tmpvar_79 = pow (tmpvar_76, 0.3333333);
  } else {
    tmpvar_79 = (((903.3 * tmpvar_76) + 16.0) / 116.0);
  };
  highp float tmpvar_80;
  if ((tmpvar_77 > 0.008856)) {
    tmpvar_80 = pow (tmpvar_77, 0.3333333);
  } else {
    tmpvar_80 = (((903.3 * tmpvar_77) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_81;
  tmpvar_81.x = (((116.0 * tmpvar_79) - 16.0) / 100.0);
  tmpvar_81.y = (((500.0 * 
    (tmpvar_78 - tmpvar_79)
  ) + 110.0) / 220.0);
  tmpvar_81.z = (((200.0 * 
    (tmpvar_79 - tmpvar_80)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_82;
  tmpvar_82 = (tmpvar_81 - tmpvar_71);
  highp float tmpvar_83;
  if ((color_10.x > 0.04045)) {
    tmpvar_83 = pow (((color_10.x + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_83 = (color_10.x / 12.92);
  };
  highp float tmpvar_84;
  if ((color_10.y > 0.04045)) {
    tmpvar_84 = pow (((color_10.y + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_84 = (color_10.y / 12.92);
  };
  highp float tmpvar_85;
  if ((color_10.z > 0.04045)) {
    tmpvar_85 = pow (((color_10.z + 0.055) / 1.055), 2.4);
  } else {
    tmpvar_85 = (color_10.z / 12.92);
  };
  highp float tmpvar_86;
  tmpvar_86 = (((
    (tmpvar_83 * 0.4124564)
   + 
    (tmpvar_84 * 0.3575761)
  ) + (tmpvar_85 * 0.1804375)) / 0.950456);
  highp float tmpvar_87;
  tmpvar_87 = (((tmpvar_83 * 0.2126729) + (tmpvar_84 * 0.7151522)) + (tmpvar_85 * 0.072175));
  highp float tmpvar_88;
  tmpvar_88 = (((
    (tmpvar_83 * 0.0193339)
   + 
    (tmpvar_84 * 0.119192)
  ) + (tmpvar_85 * 0.9503041)) / 1.088754);
  highp float tmpvar_89;
  if ((tmpvar_86 > 0.008856)) {
    tmpvar_89 = pow (tmpvar_86, 0.3333333);
  } else {
    tmpvar_89 = (((903.3 * tmpvar_86) + 16.0) / 116.0);
  };
  highp float tmpvar_90;
  if ((tmpvar_87 > 0.008856)) {
    tmpvar_90 = pow (tmpvar_87, 0.3333333);
  } else {
    tmpvar_90 = (((903.3 * tmpvar_87) + 16.0) / 116.0);
  };
  highp float tmpvar_91;
  if ((tmpvar_88 > 0.008856)) {
    tmpvar_91 = pow (tmpvar_88, 0.3333333);
  } else {
    tmpvar_91 = (((903.3 * tmpvar_88) + 16.0) / 116.0);
  };
  highp vec3 tmpvar_92;
  tmpvar_92.x = (((116.0 * tmpvar_90) - 16.0) / 100.0);
  tmpvar_92.y = (((500.0 * 
    (tmpvar_89 - tmpvar_90)
  ) + 110.0) / 220.0);
  tmpvar_92.z = (((200.0 * 
    (tmpvar_90 - tmpvar_91)
  ) + 110.0) / 220.0);
  highp vec3 tmpvar_93;
  tmpvar_93 = clamp ((tmpvar_92 + tmpvar_82), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float z_94;
  highp float x_95;
  highp float tmpvar_96;
  tmpvar_96 = (((tmpvar_93.x * 100.0) + 16.0) / 116.0);
  highp float tmpvar_97;
  tmpvar_97 = (((
    (tmpvar_93.y * 220.0)
   - 110.0) / 500.0) + tmpvar_96);
  x_95 = tmpvar_97;
  highp float tmpvar_98;
  tmpvar_98 = (tmpvar_96 - ((
    (tmpvar_93.z * 220.0)
   - 110.0) / 200.0));
  z_94 = tmpvar_98;
  highp float tmpvar_99;
  tmpvar_99 = pow (tmpvar_97, 3.0);
  highp float tmpvar_100;
  tmpvar_100 = pow (tmpvar_96, 3.0);
  highp float tmpvar_101;
  tmpvar_101 = pow (tmpvar_98, 3.0);
  highp float tmpvar_102;
  if ((tmpvar_99 > 0.008856)) {
    tmpvar_102 = tmpvar_99;
  } else {
    tmpvar_102 = ((tmpvar_97 - 0.137931) / 7.787069);
  };
  x_95 = (tmpvar_102 * 0.950456);
  highp float tmpvar_103;
  if ((tmpvar_100 > 0.008856)) {
    tmpvar_103 = tmpvar_100;
  } else {
    tmpvar_103 = ((tmpvar_96 - 0.137931) / 7.787069);
  };
  highp float tmpvar_104;
  if ((tmpvar_101 > 0.008856)) {
    tmpvar_104 = tmpvar_101;
  } else {
    tmpvar_104 = ((tmpvar_98 - 0.137931) / 7.787069);
  };
  z_94 = (tmpvar_104 * 1.088754);
  highp float tmpvar_105;
  tmpvar_105 = (((x_95 * 3.240454) + (tmpvar_103 * -1.537138)) + (z_94 * -0.4985314));
  highp float tmpvar_106;
  tmpvar_106 = (((x_95 * -0.969266) + (tmpvar_103 * 1.876011)) + (z_94 * 0.041556));
  highp float tmpvar_107;
  tmpvar_107 = (((x_95 * 0.0556434) + (tmpvar_103 * -0.2040259)) + (z_94 * 1.057225));
  highp float tmpvar_108;
  if ((tmpvar_105 > 0.0031308)) {
    tmpvar_108 = ((1.055 * pow (tmpvar_105, 0.4166667)) - 0.055);
  } else {
    tmpvar_108 = (12.92 * tmpvar_105);
  };
  highp float tmpvar_109;
  if ((tmpvar_106 > 0.0031308)) {
    tmpvar_109 = ((1.055 * pow (tmpvar_106, 0.4166667)) - 0.055);
  } else {
    tmpvar_109 = (12.92 * tmpvar_106);
  };
  highp float tmpvar_110;
  if ((tmpvar_107 > 0.0031308)) {
    tmpvar_110 = ((1.055 * pow (tmpvar_107, 0.4166667)) - 0.055);
  } else {
    tmpvar_110 = (12.92 * tmpvar_107);
  };
  highp vec3 tmpvar_111;
  tmpvar_111.x = tmpvar_108;
  tmpvar_111.y = tmpvar_109;
  tmpvar_111.z = tmpvar_110;
  lowp vec3 tmpvar_112;
  tmpvar_112 = texture (SkinTintMaskTex, xlv_TEXCOORD0).xxx;
  highp vec3 tmpvar_113;
  tmpvar_113 = mix (color_10.xyz, tmpvar_111, tmpvar_112);
  mainColor_9 = (tmpvar_113 * tmpvar_113);
  lowp vec3 tmpvar_114;
  tmpvar_114 = texture (RegionTintMaskTex, xlv_TEXCOORD0).xyz;
  regionMaskColor_8 = tmpvar_114;
  highp vec4 tmpvar_115;
  tmpvar_115.w = 0.0;
  tmpvar_115.xyz = mainColor_9;
  highp vec4 tmpvar_116;
  tmpvar_116.w = 0.0;
  tmpvar_116.xyz = mainColor_9;
  highp vec4 tmpvar_117;
  tmpvar_117.w = 0.0;
  tmpvar_117.xyz = mainColor_9;
  mainColor_9 = (((
    (mainColor_9 * (1.0 - ((regionMaskColor_8.x + regionMaskColor_8.y) + regionMaskColor_8.z)))
   + 
    (mix (tmpvar_115, RegionRTint, RegionTintBlend.xxxx) * regionMaskColor_8.x)
  .xyz) + (
    mix (tmpvar_116, RegionGTint, RegionTintBlend.yyyy)
   * regionMaskColor_8.y).xyz) + (mix (tmpvar_117, RegionBTint, RegionTintBlend.zzzz) * regionMaskColor_8.z).xyz);
  lowp vec3 tmpvar_118;
  tmpvar_118 = texture (TexSpecular, xlv_TEXCOORD0).xyz;
  specular_7 = tmpvar_118;
  highp float tmpvar_119;
  tmpvar_119 = (1.0 - specular_7.x);
  highp vec2 tmpvar_120;
  tmpvar_120.x = (((
    dot (tmpvar_55, tmpvar_56)
   * 0.5) + 0.5) * 0.99);
  tmpvar_120.y = specular_7.y;
  lowp vec3 tmpvar_121;
  tmpvar_121 = texture (TexBRDF, tmpvar_120).xyz;
  brdfColor_6 = tmpvar_121;
  highp float tmpvar_122;
  tmpvar_122 = max (((
    dot (tmpvar_55, tmpvar_57)
   + 0.5) * 0.7), 0.0);
  nl2_5 = (tmpvar_122 * tmpvar_122);
  nl2_5 = (nl2_5 * nl2_5);
  nl2_5 = (nl2_5 * nl2_5);
  backLight_4 = ((nl2_5 * LightColor.xyz) * ((LightIntensity * mainColor_9) * mainNormal_11.z));
  backLight_4 = (backLight_4 / (vec3(1.0, 1.0, 1.0) + backLight_4));
  highp vec3 I_123;
  I_123 = -(tmpvar_52);
  reflectDir_3.xyz = (I_123 - (2.0 * (
    dot (tmpvar_55, I_123)
   * tmpvar_55)));
  reflectDir_3.w = (tmpvar_119 * 4.0);
  lowp vec4 tmpvar_124;
  tmpvar_124 = textureLod (TexSkybox, reflectDir_3.xyz, reflectDir_3.w);
  highp vec4 tmpvar_125;
  tmpvar_125 = tmpvar_124;
  iblColor_2.w = tmpvar_125.w;
  iblColor_2.xyz = ((tmpvar_125.xyz * tmpvar_125.w) * 4.0);
  highp float tmpvar_126;
  tmpvar_126 = max ((tmpvar_119 * tmpvar_119), 0.1);
  highp float tmpvar_127;
  tmpvar_127 = (tmpvar_126 * tmpvar_126);
  highp float tmpvar_128;
  tmpvar_128 = (((
    (tmpvar_59 * tmpvar_127)
   - tmpvar_59) * tmpvar_59) + 1.0);
  d_1 = ((0.3183099 * tmpvar_127) / ((tmpvar_128 * tmpvar_128) + 1e-7));
  highp float tmpvar_129;
  tmpvar_129 = min (d_1, 100.0);
  d_1 = tmpvar_129;
  highp vec4 tmpvar_130;
  tmpvar_130.xyz = (((
    ((tmpvar_129 * mix (Fresnel, 1.0, (1.0 - tmpvar_58))) * LIGHT_COLOR)
   + 
    (((iblColor_2.xyz * 0.5) * ((
      (min ((Fresnel * 2.0), 1.0) - Fresnel)
     * 
      pow ((1.0 - tmpvar_58), 4.0)
    ) + Fresnel)) * AMBIENT_COLOR)
  ) * ColorSpecular.xyz) + ((
    (((mix (ColorShadow.xyz, brdfColor_6, vec3(tmpvar_13)) * LIGHT_COLOR) * mainColor_9) + backLight_4)
   + 
    (AMBIENT_COLOR * mainColor_9)
  ) * mix (ColorShade.xyz, vec3(1.0, 1.0, 1.0), vec3(
    mix (1.0, tmpvar_58, (1.0 - specular_7.z))
  ))));
  tmpvar_130.w = tmpvar_61;
  _glesFragData[0] = tmpvar_130;
}

]===],
	},
}


end 

function Depth()

    COLOR_MASK = COLOR_RGBA
    ALPAH_MODE = { ALPAH_OFF }
    DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
    STENCIL_MODE = { STENCIL_OFF }
    LIGHT_MODE = { DEPTHPASS }
    
    
Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 LIGHT_PARAM;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = _glesVertex.xyz;
  tmpvar_1 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2));
  highp vec4 clipPos_3;
  clipPos_3.xyw = tmpvar_1.xyw;
  clipPos_3.z = (tmpvar_1.z + (LIGHT_PARAM.x / tmpvar_1.w));
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  gl_Position = (tmpvar_4 * clipPos_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
void main ()
{
  _glesFragData[0] = vec4(0.0, 0.0, 0.0, 1.0);
}

]===],
	},
}

end