#DEFPARAMS
DiffuseTex= { "Texture Diffuse", TEXTURE2D, "white" },
TexNormal = {"Texture Normal", TEXTURE2D, "white"},
TexSpecular = {"Texture Specular", TEXTURE2D, "white"},
TexBRDF = {"Texture BRDF", TEXTURE2D, "white"},
TexSkybox = {"Texture SkyBox", TEXTURECUBE, "black"},

ColorShade = {"Shade Color", COLOR, "0.0,0.0,0.0,1.0"},
ColorShadow = {"Shadow Color", COLOR, "0.0,0.0,0.0,1.0"},
ColorSpecular = {"Specular Color", COLOR, "0.0,0.0,0.0,1.0"},

SkinTint = {"Skin Tint", COLOR, "0.0,0.0,0.0,1.0"},
SkinTintMaskTex = {"Skin Mask", TEXTURE2D, "white"},

SkinColor = {"Skin Color", COLOR, "0.933, 0.859, 0.804, 1.0"},


RegionRTint = {"Region Tint R", COLOR, "0.0,0.0,0.0,1.0"},
RegionGTint = {"Region Tint G", COLOR, "0.0,0.0,0.0,1.0"},
RegionBTint = {"Region Tint B", COLOR, "0.0,0.0,0.0,1.0"},
RegionTintMaskTex = { "Region Mask", TEXTURE2D, "white" },
RegionTintBlend = {"Region Blend Strength", VEC3, "1.0,1.0,1.0"},

Fresnel = { "Fresnel", FLOAT, "0.5" },
extraShadeRange = { "extraShadeRange", FLOAT, "0.5" },

LightDir = { "Light Dir", VEC3, "0.0,0.0,1.0" },
LightColor = { "Lighit Color", COLOR, "1.0,1.0,1.0, 1.0" },
LightIntensity = {"Light Intensity", FLOAT, "1.0" },

#END
  
#DEFTAG
ShaderName = "CustomSkin_Mask"
RenderQueue = "Opaque"
#END

#DEFPASS ForwardBase
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdbase
#include "light.inc"
#include "rgb_lab.inc"

struct appdata
{
    float4 vertex : POSITION;
    float3 normal : NORMAL;
    float3 binoraml : BINORMAL;
    float3 tangent : TANGENT;
    float2 uv : TEXCOORD0;
    ANI_ATTRIBUTE
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 worldnormal : TEXCOORD1;
    float4 worldtangent : TEXCOORD2;
    float4 worldbinormal : TEXCOORD3;
    float4 vertex : SV_POSITION;
    SHADOW_COORDS(4)
};

sampler2D DiffuseTex;
sampler2D TexNormal;
sampler2D TexSpecular;
sampler2D TexBRDF;
samplerCUBE TexSkybox;

sampler2D RegionTintMaskTex;
sampler2D SkinTintMaskTex;

float4 ColorShade;
float4 ColorShadow;
float4 ColorSpecular;
float4 SkinTint;
float4 SkinColor;

float4 RegionRTint;
float4 RegionGTint;
float4 RegionBTint;
float3 RegionTintBlend;

float Fresnel;
float extraShadeRange;

float3 LightDir;
float4 LightColor; 
float LightIntensity;

v2f vert(appdata v)
{
    COMPUTE_BONE_MATERIX(v);
    v2f o;
    float4 pos = ObjectToClipPos(v.vertex);
    o.vertex = UniformNDC(pos);
    o.uv = v.uv.xy;
    float3 worldpos = ObjectToWorldPos(v.vertex).xyz;
    o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;
    o.worldtangent.xyz = ObjectToWorldDir(v.tangent).xyz;
    o.worldbinormal.xyz = ObjectToWorldDir(v.binoraml).xyz;
    
    o.worldnormal.w = worldpos.x;
    o.worldtangent.w = worldpos.y;
    o.worldbinormal.w = worldpos.z;
    TRANSFER_SHADOW(o, v.vertex);
    return o;
}

float4 frag(v2f i) : SV_Target
{
    ColorShade = float4(0.839, 0.475, 0.475, 1);
    ColorShadow = float4(0.855, 0.502, 0.502, 1);
    Fresnel = 1.5;
    LightColor = float4(0.314, 0.314, 0.314, 1);
    SkinColor = float4(0.8, 0.631, 0.584, 1);

    float2 in_Coordinate0 = i.uv;
    float4 in_NormalWS = i.worldnormal;
    float4 in_TangentWS = i.worldtangent;
    float4 in_BinormalWS = i.worldbinormal;

    float atten = SHADOW_ATTEN(i);

    float3 worldPos = float3(in_NormalWS.w, in_TangentWS.w, in_BinormalWS.w);
    float3 viewDir_S = CAMERA_WORLDPOSITION - worldPos.xyz;
    float3 viewDir = normalize(viewDir_S);

    float3 mainNormal = tex2D(TexNormal, in_Coordinate0.xy).xyz;
    float3 groundNormal = mainNormal.xyz * 2.0 - 1.0;

    float3 worldNormal = groundNormal.x * in_TangentWS.xyz + groundNormal.y * in_BinormalWS.xyz
                        + groundNormal.z * in_NormalWS.xyz;
    worldNormal = normalize(worldNormal);

    float3 light1Dir = -(LIGHT_GIVEN_DIRECTION);
    float3 light1Color = LIGHT_COLOR;
    float light1Intensity = 1.0;
    
    float3 light2Dir = normalize(LightDir);
    float3 light2Color = LightColor.xyz;
    float light2Intensity = LightIntensity;
    
    float3 h1 = normalize(viewDir + light1Dir);
    float nv = max(dot(worldNormal, viewDir), 0.0);
    float nh1 = max(dot(worldNormal, h1), 0.0);

    // main color
    float4 color = tex2D(DiffuseTex, in_Coordinate0.xy);
    float3 mainColor = color.xyz;
    float alpha = color.w;
    
    float3 skincolorlab = normalizelab(rgb2lab(SkinColor.xyz));
    float3 skintintlab = normalizelab(rgb2lab(SkinTint.xyz));
    float3 laboffet = skintintlab - skincolorlab;  

    float3 maincolorlab = normalizelab(rgb2lab(mainColor));   
    
    float3 adjustedColor = maincolorlab + laboffet;  
    adjustedColor = clamp(adjustedColor, float3(0.0, 0.0, 0.0), float3(1.0, 1.0, 1.0));
    adjustedColor = lab2rgb(denormalizelab(adjustedColor));
    
    mainColor = lerp(mainColor, adjustedColor, tex2D(SkinTintMaskTex, in_Coordinate0.xy).r); 
    mainColor *= mainColor;
    float3 regionMaskColor = tex2D(RegionTintMaskTex, in_Coordinate0.xy).xyz;
    float skinMask = 1.0 - (regionMaskColor.r + regionMaskColor.g + regionMaskColor.b);
    mainColor = mainColor * skinMask 
                + lerp(mainColor, RegionRTint,  RegionTintBlend.r) * regionMaskColor.r
                + lerp(mainColor, RegionGTint,  RegionTintBlend.g) * regionMaskColor.g
                + lerp(mainColor, RegionBTint,  RegionTintBlend.b) * regionMaskColor.b;
    
    float3 specular = tex2D(TexSpecular, in_Coordinate0.xy).xyz;
    float roughness = 1.0 - specular.x;
    float curveness = specular.y;
    float shadowSelfMask = 1.0 - specular.z;

    // diffuse
    float3 diffuse = float3(0.0, 0.0, 0.0);
    float shaowRange = nv / extraShadeRange;
    float diffuseShadow = lerp(1.0, nv, shadowSelfMask);
    float nl1 = dot(worldNormal, light1Dir);
    float nl1Warp = (nl1 * 0.5) + 0.5;
    nl1Warp *= 0.99;
    
    float2 brdfUV = float2(nl1Warp, curveness);
    float3 brdfColor = tex2D(TexBRDF, brdfUV).xyz;
    
    float shadow = atten;
    float3 adjuseColor = lerp(ColorShadow.xyz, brdfColor.xyz, shadow);
    float3 frontLight = adjuseColor * light1Color * light1Intensity * mainColor;

    float nl2 = (dot(worldNormal, light2Dir) + 0.5) * 0.7;
    nl2 = max(nl2, 0.0);
    nl2 = nl2 * nl2;
    nl2 = nl2 * nl2;
    nl2 = nl2 * nl2;
    float3 backLight = nl2 * light2Color * light2Intensity * mainColor;
    backLight = backLight * mainNormal.z;
    backLight = backLight / (float3(1.0, 1.0, 1.0) + backLight);
    
    float3 ambientLight =  AMBIENT_COLOR.xyz * mainColor;
    float3 white = float3(1.0, 1.0, 1.0);
    float3 diffuseColorShadow = lerp(ColorShade.xyz, white.xyz, diffuseShadow);
    float3 outDiffuse = (frontLight + backLight + ambientLight) * diffuseColorShadow;

    float4 reflectDir;
    reflectDir.xyz = reflect(-viewDir, worldNormal);
    float perceptualRoughness = roughness; //(1.7 - 0.7 * roughness) * roughness;
    float mipmapLevel = perceptualRoughness * 4.0;
    reflectDir.w = mipmapLevel;

    float4 iblColor = texCUBElod(TexSkybox, reflectDir);
    iblColor.xyz = iblColor.xyz * iblColor.w * 4.0;
    
    float f0Inv = min(Fresnel * 2.0, 1.0) - Fresnel;
    float powNV = pow((1.0 - nv), 4.0);
    float SF = f0Inv * powNV + Fresnel;

    float3 envLight = iblColor.xyz * 0.5 * SF * AMBIENT_COLOR.xyz;
    
    // D
    float modifyRoughness = max(roughness * roughness, 0.1);
    float NdotH = nh1;
    float a2 = modifyRoughness * modifyRoughness;
    float d = (NdotH * a2 - NdotH) * NdotH + 1.0f; // 2 mad
    d = 0.31830988618f * a2 / (d * d + 1e-7f);
    d = min(d, 100.0);

    float fLerp = 1.0 - nv;
    float fV = lerp(Fresnel, 1.0, fLerp);
    
    float3 outspecular = (d*fV * light1Color* light1Intensity + envLight) * ColorSpecular.xyz;
    float3 finalCol = outspecular + outDiffuse;

    return float4(finalCol.x, finalCol.y, finalCol.z, alpha);
}
ENDCG

#END 

#DEFPASS Depth
    COLOR_MASK = COLOR_RGBA
    ALPAH_MODE = { ALPAH_OFF }
    DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
    STENCIL_MODE = { STENCIL_OFF }
    LIGHT_MODE = { DEPTHPASS }
    
    CGPROGRAM
    #pragma vertex vert
    #pragma fragment frag
    #include "lightpbr.inc"
    
    struct appdata
    {
        float4 vertex : POSITION;
        float3 normal : NORMAL;
    ANI_ATTRIBUTE
    };
    
    struct v2f
    {
        float4 vertex : SV_POSITION;
    };
    
    v2f vert(appdata v)
    {
    COMPUTE_BONE_MATERIX(v);
        float4 clipPos = ObjectToClipPos(v.vertex);
        clipPos = ApplyShadowBias(clipPos);
    
        v2f o;
        o.vertex = UniformNDC(clipPos);
        return o;
    }
    
    float4 frag(v2f i) : SV_Target
    {
        return float4(0.0, 0.0, 0.0, 1.0);
    }
    ENDCG
#END