#DEFPARAMS
_BlendTex = { "Blend Color", TEXTURE2D, "white" },
_MaskTex = { "Mask Color", TEXTURE2D, "white" },
[Enum(CullMode)]
_CullMode = {"Cull Mode", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "StandardPbr"
RenderQueue = "Opaque"
#END

#DEFPASS ForwardBase
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { "%_CullMode", DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LEQUAL }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdbase
#include "lightpbr.inc"
struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
	float3 binoraml : BINORMAL;
	float3 tangent : TANGENT;
	float2 uv : TEXCOORD0;
	ANI_ATTRIBUTE
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 dstuv : TEXCOORD1;
	float4 vertex : SV_POSITION;
	SHADOW_COORDS(4)
};

sampler2D _BlendTex;
sampler2D _MaskTex;

v2f vert(appdata v)
{
	COMPUTE_BONE_MATERIX(v);

	v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	o.uv = v.uv.xy;
	
	o.dstuv = ComputeScreenPos(pos);

	TRANSFER_SHADOW(o, v.vertex);
	return o;
}

float4 frag(v2f i) : SV_Target
{
	// sample the texture
	float3 screenPos = i.dstuv.xyz/i.dstuv.w;
	float2 uv = screenPos.xy;
	float4 dstColor = tex2D(_BlendTex, uv);
	float atten = SHADOW_ATTEN(i);
	float4 maskCol = tex2D(_MaskTex, i.uv);
	float3 outColor = dstColor.xyz * (1.0 - maskCol.a) + dstColor.xyz * atten * maskCol.a;

	return float4(outColor, 1.0);
}
ENDCG

#END

#DEFPASS Depth
	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { DEPTHPASS }

	CGPROGRAM
	#pragma vertex vert
	#pragma fragment frag
	#include "lightpbr.inc"

	struct appdata
	{
		float4 vertex : POSITION;
		float3 normal : NORMAL;
		ANI_ATTRIBUTE
	};

	struct v2f
	{
		float4 vertex : SV_POSITION;
	};

	v2f vert(appdata v)
	{
		COMPUTE_BONE_MATERIX(v);

		float4 clipPos = ObjectToClipPos(v.vertex);
		clipPos = ApplyShadowBias(clipPos);

		v2f o;
		o.vertex = UniformNDC(clipPos);
		return o;
	}

	float4 frag(v2f i) : SV_Target
	{
		return float4(0.0, 0.0, 0.0, 1.0);
	}
	ENDCG
#END