function DefineParams()
	Properties = 
	{
		
_BlendTex = { "Blend Color", TEXTURE2D, "white" },
_MaskTex = { "Mask Color", TEXTURE2D, "white" },

_CullMode = {"Cull Mode", FLOAT, "0.0"},

	}
	Attributes = 
	{
		_CullMode = "Enum(CullMode)", 
	}
	
end



function Init()
	PassNames = 
	{
		"ForwardBase","Depth"
	}

ShaderName = "StandardPbr"
RenderQueue = "Opaque"
end

function ForwardBase()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { "%_CullMode", DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LEQUAL }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 row2_1;
  highp vec4 row1_2;
  highp vec4 row0_3;
  highp int tmpvar_4;
  tmpvar_4 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.w) * 3);
  row0_3 = (ANIMATION_MATRIX_ARRAY[tmpvar_4] * _glesBlendWeight.x);
  row1_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 1)] * _glesBlendWeight.x);
  row2_1 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 2)] * _glesBlendWeight.x);
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.y));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.y));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.y));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.z));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.z));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.z));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.w));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.w));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_8;
  tmpvar_8[uint(0)].x = row0_3.x;
  tmpvar_8[uint(0)].y = row0_3.y;
  tmpvar_8[uint(0)].z = row0_3.z;
  tmpvar_8[uint(0)].w = row0_3.w;
  tmpvar_8[1u].x = row1_2.x;
  tmpvar_8[1u].y = row1_2.y;
  tmpvar_8[1u].z = row1_2.z;
  tmpvar_8[1u].w = row1_2.w;
  tmpvar_8[2u].x = row2_1.x;
  tmpvar_8[2u].y = row2_1.y;
  tmpvar_8[2u].z = row2_1.z;
  tmpvar_8[2u].w = row2_1.w;
  tmpvar_8[3u].x = 0.0;
  tmpvar_8[3u].y = 0.0;
  tmpvar_8[3u].z = 0.0;
  tmpvar_8[3u].w = 1.0;
  highp vec4 tmpvar_9;
  tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_8)));
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_9 * 0.5);
  o_11.zw = tmpvar_12.zw;
  o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
  o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
  o_11.zw = tmpvar_9.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = o_11;
  gl_Position = (tmpvar_10 * tmpvar_9);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D _BlendTex;
uniform sampler2D _MaskTex;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 dstColor_2;
  highp vec3 tmpvar_3;
  tmpvar_3 = (xlv_TEXCOORD1.xyz / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_BlendTex, tmpvar_3.xy);
  dstColor_2 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = ((dstColor_2.xyz * (1.0 - maskCol_1.w)) + (dstColor_2.xyz * maskCol_1.w));
  _glesFragData[0] = tmpvar_6;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 row2_1;
  highp vec4 row1_2;
  highp vec4 row0_3;
  highp int tmpvar_4;
  tmpvar_4 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.w) * 3);
  row0_3 = (ANIMATION_MATRIX_ARRAY[tmpvar_4] * _glesBlendWeight.x);
  row1_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 1)] * _glesBlendWeight.x);
  row2_1 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 2)] * _glesBlendWeight.x);
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.y));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.y));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.y));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.z));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.z));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.z));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.w));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.w));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_8;
  tmpvar_8[uint(0)].x = row0_3.x;
  tmpvar_8[uint(0)].y = row0_3.y;
  tmpvar_8[uint(0)].z = row0_3.z;
  tmpvar_8[uint(0)].w = row0_3.w;
  tmpvar_8[1u].x = row1_2.x;
  tmpvar_8[1u].y = row1_2.y;
  tmpvar_8[1u].z = row1_2.z;
  tmpvar_8[1u].w = row1_2.w;
  tmpvar_8[2u].x = row2_1.x;
  tmpvar_8[2u].y = row2_1.y;
  tmpvar_8[2u].z = row2_1.z;
  tmpvar_8[2u].w = row2_1.w;
  tmpvar_8[3u].x = 0.0;
  tmpvar_8[3u].y = 0.0;
  tmpvar_8[3u].z = 0.0;
  tmpvar_8[3u].w = 1.0;
  highp vec4 tmpvar_9;
  tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_8)));
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_11;
  highp vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_9 * 0.5);
  o_11.zw = tmpvar_12.zw;
  o_11.xy = (tmpvar_12.xy + tmpvar_12.ww);
  o_11.y = ((2.0 * tmpvar_12.w) - o_11.y);
  o_11.zw = tmpvar_9.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = o_11;
  gl_Position = (tmpvar_10 * tmpvar_9);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D _BlendTex;
uniform sampler2D _MaskTex;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 dstColor_2;
  highp vec3 tmpvar_3;
  tmpvar_3 = (xlv_TEXCOORD1.xyz / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_BlendTex, tmpvar_3.xy);
  dstColor_2 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = ((dstColor_2.xyz * (1.0 - maskCol_1.w)) + (dstColor_2.xyz * maskCol_1.w));
  _glesFragData[0] = tmpvar_6;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[uint(0)].x = row0_4.x;
  tmpvar_9[uint(0)].y = row0_4.y;
  tmpvar_9[uint(0)].z = row0_4.z;
  tmpvar_9[uint(0)].w = row0_4.w;
  tmpvar_9[1u].x = row1_3.x;
  tmpvar_9[1u].y = row1_3.y;
  tmpvar_9[1u].z = row1_3.z;
  tmpvar_9[1u].w = row1_3.w;
  tmpvar_9[2u].x = row2_2.x;
  tmpvar_9[2u].y = row2_2.y;
  tmpvar_9[2u].z = row2_2.z;
  tmpvar_9[2u].w = row2_2.w;
  tmpvar_9[3u].x = 0.0;
  tmpvar_9[3u].y = 0.0;
  tmpvar_9[3u].z = 0.0;
  tmpvar_9[3u].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)));
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_12;
  highp vec4 tmpvar_13;
  tmpvar_13 = (tmpvar_10 * 0.5);
  o_12.zw = tmpvar_13.zw;
  o_12.xy = (tmpvar_13.xy + tmpvar_13.ww);
  o_12.y = ((2.0 * tmpvar_13.w) - o_12.y);
  o_12.zw = tmpvar_10.zw;
  tmpvar_1.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)))
  ).xyz * 0.5) + 0.5);
  tmpvar_1.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = o_12;
  gl_Position = (tmpvar_11 * tmpvar_10);
  xlv_TEXCOORD4 = tmpvar_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _BlendTex;
uniform sampler2D _MaskTex;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 dstColor_2;
  highp vec3 tmpvar_3;
  tmpvar_3 = (xlv_TEXCOORD1.xyz / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_BlendTex, tmpvar_3.xy);
  dstColor_2 = tmpvar_4;
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_7;
    highp vec2 fetchesOffsetsU_8;
    highp float shadow_9;
    highp vec2 tmpvar_10;
    tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_11;
    tmpvar_11 = floor((tmpvar_10 + 0.5));
    highp vec2 tmpvar_12;
    tmpvar_12 = (tmpvar_10 - tmpvar_11);
    highp vec4 computedWeight_13;
    highp vec4 computedArea_14;
    highp vec4 computedAreaUncut_15;
    highp float tmpvar_16;
    tmpvar_16 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
    highp float tmpvar_17;
    tmpvar_17 = (tmpvar_16 - tmpvar_12.x);
    computedArea_14.x = tmpvar_17;
    computedAreaUncut_15.x = tmpvar_17;
    computedArea_14.w = tmpvar_16;
    computedAreaUncut_15.w = tmpvar_16;
    computedAreaUncut_15.y = ((1.5 - tmpvar_12.x) - 0.5);
    highp float tmpvar_18;
    tmpvar_18 = min (tmpvar_12.x, 0.0);
    computedArea_14.y = (computedAreaUncut_15.y - (tmpvar_18 * tmpvar_18));
    computedAreaUncut_15.z = ((1.5 + tmpvar_12.x) - 0.5);
    highp float tmpvar_19;
    tmpvar_19 = max (tmpvar_12.x, 0.0);
    computedArea_14.z = (computedAreaUncut_15.z - (tmpvar_19 * tmpvar_19));
    computedWeight_13 = (computedArea_14 * 0.44444);
    highp vec4 computedWeight_20;
    highp vec4 computedArea_21;
    highp vec4 computedAreaUncut_22;
    highp float tmpvar_23;
    tmpvar_23 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
    highp float tmpvar_24;
    tmpvar_24 = (tmpvar_23 - tmpvar_12.y);
    computedArea_21.x = tmpvar_24;
    computedAreaUncut_22.x = tmpvar_24;
    computedArea_21.w = tmpvar_23;
    computedAreaUncut_22.w = tmpvar_23;
    computedAreaUncut_22.y = ((1.5 - tmpvar_12.y) - 0.5);
    highp float tmpvar_25;
    tmpvar_25 = min (tmpvar_12.y, 0.0);
    computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
    computedAreaUncut_22.z = ((1.5 + tmpvar_12.y) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = max (tmpvar_12.y, 0.0);
    computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
    computedWeight_20 = (computedArea_21 * 0.44444);
    highp vec2 tmpvar_27;
    tmpvar_27 = (computedWeight_13.xz + computedWeight_13.yw);
    highp vec2 tmpvar_28;
    tmpvar_28 = (computedWeight_20.xz + computedWeight_20.yw);
    fetchesOffsetsU_8 = (((computedWeight_13.yw / tmpvar_27) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_7 = (((computedWeight_20.yw / tmpvar_28) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_29;
    tmpvar_29 = (tmpvar_11 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_30;
    tmpvar_30.x = fetchesOffsetsU_8.x;
    tmpvar_30.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_31;
    tmpvar_31.xy = (tmpvar_29 + tmpvar_30);
    tmpvar_31.z = shadowCoord_5.z;
    mediump float tmpvar_32;
    tmpvar_32 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_31);
    shadow_9 = ((tmpvar_27.x * tmpvar_28.x) * tmpvar_32);
    highp vec2 tmpvar_33;
    tmpvar_33.x = fetchesOffsetsU_8.y;
    tmpvar_33.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_34;
    tmpvar_34.xy = (tmpvar_29 + tmpvar_33);
    tmpvar_34.z = shadowCoord_5.z;
    mediump float tmpvar_35;
    tmpvar_35 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_34);
    shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.x) * tmpvar_35));
    highp vec2 tmpvar_36;
    tmpvar_36.x = fetchesOffsetsU_8.x;
    tmpvar_36.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_37;
    tmpvar_37.xy = (tmpvar_29 + tmpvar_36);
    tmpvar_37.z = shadowCoord_5.z;
    mediump float tmpvar_38;
    tmpvar_38 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_37);
    shadow_9 = (shadow_9 + ((tmpvar_27.x * tmpvar_28.y) * tmpvar_38));
    highp vec2 tmpvar_39;
    tmpvar_39.x = fetchesOffsetsU_8.y;
    tmpvar_39.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_40;
    tmpvar_40.xy = (tmpvar_29 + tmpvar_39);
    tmpvar_40.z = shadowCoord_5.z;
    mediump float tmpvar_41;
    tmpvar_41 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_40);
    shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.y) * tmpvar_41));
    tmpvar_6 = mix (1.0, shadow_9, LIGHT_PARAM.y);
  };
  lowp vec4 tmpvar_42;
  tmpvar_42 = texture (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_42;
  highp vec4 tmpvar_43;
  tmpvar_43.w = 1.0;
  tmpvar_43.xyz = ((dstColor_2.xyz * (1.0 - maskCol_1.w)) + ((dstColor_2.xyz * tmpvar_6) * maskCol_1.w));
  _glesFragData[0] = tmpvar_43;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[uint(0)].x = row0_4.x;
  tmpvar_9[uint(0)].y = row0_4.y;
  tmpvar_9[uint(0)].z = row0_4.z;
  tmpvar_9[uint(0)].w = row0_4.w;
  tmpvar_9[1u].x = row1_3.x;
  tmpvar_9[1u].y = row1_3.y;
  tmpvar_9[1u].z = row1_3.z;
  tmpvar_9[1u].w = row1_3.w;
  tmpvar_9[2u].x = row2_2.x;
  tmpvar_9[2u].y = row2_2.y;
  tmpvar_9[2u].z = row2_2.z;
  tmpvar_9[2u].w = row2_2.w;
  tmpvar_9[3u].x = 0.0;
  tmpvar_9[3u].y = 0.0;
  tmpvar_9[3u].z = 0.0;
  tmpvar_9[3u].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)));
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_12;
  highp vec4 tmpvar_13;
  tmpvar_13 = (tmpvar_10 * 0.5);
  o_12.zw = tmpvar_13.zw;
  o_12.xy = (tmpvar_13.xy + tmpvar_13.ww);
  o_12.y = ((2.0 * tmpvar_13.w) - o_12.y);
  o_12.zw = tmpvar_10.zw;
  tmpvar_1.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)))
  ).xyz * 0.5) + 0.5);
  tmpvar_1.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = o_12;
  gl_Position = (tmpvar_11 * tmpvar_10);
  xlv_TEXCOORD4 = tmpvar_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _BlendTex;
uniform sampler2D _MaskTex;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 dstColor_2;
  highp vec3 tmpvar_3;
  tmpvar_3 = (xlv_TEXCOORD1.xyz / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_BlendTex, tmpvar_3.xy);
  dstColor_2 = tmpvar_4;
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_7;
    highp vec3 fetchesOffsetsU_8;
    highp float shadow_9;
    highp vec2 tmpvar_10;
    tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_11;
    tmpvar_11 = floor((tmpvar_10 + 0.5));
    highp vec2 tmpvar_12;
    tmpvar_12 = (tmpvar_10 - tmpvar_11);
    highp vec3 texelsWeightsA_13;
    highp vec3 texelsWeightsB_14;
    highp vec4 computedArea_15;
    highp vec4 computedAreaUncut_16;
    highp float tmpvar_17;
    tmpvar_17 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
    highp float tmpvar_18;
    tmpvar_18 = (tmpvar_17 - tmpvar_12.x);
    computedArea_15.x = tmpvar_18;
    computedAreaUncut_16.x = tmpvar_18;
    computedArea_15.w = tmpvar_17;
    computedAreaUncut_16.w = tmpvar_17;
    computedAreaUncut_16.y = ((1.5 - tmpvar_12.x) - 0.5);
    highp float tmpvar_19;
    tmpvar_19 = min (tmpvar_12.x, 0.0);
    computedArea_15.y = (computedAreaUncut_16.y - (tmpvar_19 * tmpvar_19));
    computedAreaUncut_16.z = ((1.5 + tmpvar_12.x) - 0.5);
    highp float tmpvar_20;
    tmpvar_20 = max (tmpvar_12.x, 0.0);
    computedArea_15.z = (computedAreaUncut_16.z - (tmpvar_20 * tmpvar_20));
    texelsWeightsA_13.x = (0.16 * tmpvar_18);
    texelsWeightsA_13.y = (0.16 * computedAreaUncut_16.y);
    texelsWeightsA_13.z = (0.16 * (computedArea_15.y + 1.0));
    texelsWeightsB_14.x = (0.16 * (computedArea_15.z + 1.0));
    texelsWeightsB_14.y = (0.16 * computedAreaUncut_16.z);
    texelsWeightsB_14.z = (0.16 * tmpvar_17);
    highp vec3 texelsWeightsA_21;
    highp vec3 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_12.y);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_12.y) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_12.y, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_12.y) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_12.y, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.16 * tmpvar_26);
    texelsWeightsA_21.y = (0.16 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.16 * (computedArea_23.y + 1.0));
    texelsWeightsB_22.x = (0.16 * (computedArea_23.z + 1.0));
    texelsWeightsB_22.y = (0.16 * computedAreaUncut_24.z);
    texelsWeightsB_22.z = (0.16 * tmpvar_25);
    highp vec3 tmpvar_29;
    tmpvar_29.xy = texelsWeightsA_13.xz;
    tmpvar_29.z = texelsWeightsB_14.y;
    highp vec3 tmpvar_30;
    tmpvar_30.x = texelsWeightsA_13.y;
    tmpvar_30.yz = texelsWeightsB_14.xz;
    highp vec3 tmpvar_31;
    tmpvar_31 = (tmpvar_29 + tmpvar_30);
    highp vec3 tmpvar_32;
    tmpvar_32.xy = texelsWeightsA_21.xz;
    tmpvar_32.z = texelsWeightsB_22.y;
    highp vec3 tmpvar_33;
    tmpvar_33.x = texelsWeightsA_21.y;
    tmpvar_33.yz = texelsWeightsB_22.xz;
    highp vec3 tmpvar_34;
    tmpvar_34 = (tmpvar_32 + tmpvar_33);
    highp vec3 tmpvar_35;
    tmpvar_35.x = texelsWeightsA_13.y;
    tmpvar_35.yz = texelsWeightsB_14.xz;
    highp vec3 tmpvar_36;
    tmpvar_36.x = texelsWeightsA_21.y;
    tmpvar_36.yz = texelsWeightsB_22.xz;
    fetchesOffsetsU_8 = (((tmpvar_35 / tmpvar_31) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_7 = (((tmpvar_36 / tmpvar_34) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_11 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_38;
    tmpvar_38.x = fetchesOffsetsU_8.x;
    tmpvar_38.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_39;
    tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
    tmpvar_39.z = shadowCoord_5.z;
    mediump float tmpvar_40;
    tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39);
    shadow_9 = ((tmpvar_31.x * tmpvar_34.x) * tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_8.y;
    tmpvar_41.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
    tmpvar_42.z = shadowCoord_5.z;
    mediump float tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.x) * tmpvar_43));
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_8.z;
    tmpvar_44.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
    tmpvar_45.z = shadowCoord_5.z;
    mediump float tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_8.x;
    tmpvar_47.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
    tmpvar_48.z = shadowCoord_5.z;
    mediump float tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.y) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_8.y;
    tmpvar_50.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_37 + tmpvar_50);
    tmpvar_51.z = shadowCoord_5.z;
    mediump float tmpvar_52;
    tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.y) * tmpvar_52));
    highp vec2 tmpvar_53;
    tmpvar_53.x = fetchesOffsetsU_8.z;
    tmpvar_53.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_54;
    tmpvar_54.xy = (tmpvar_37 + tmpvar_53);
    tmpvar_54.z = shadowCoord_5.z;
    mediump float tmpvar_55;
    tmpvar_55 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_54);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.y) * tmpvar_55));
    highp vec2 tmpvar_56;
    tmpvar_56.x = fetchesOffsetsU_8.x;
    tmpvar_56.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_57;
    tmpvar_57.xy = (tmpvar_37 + tmpvar_56);
    tmpvar_57.z = shadowCoord_5.z;
    mediump float tmpvar_58;
    tmpvar_58 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_57);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.z) * tmpvar_58));
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_8.y;
    tmpvar_59.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_37 + tmpvar_59);
    tmpvar_60.z = shadowCoord_5.z;
    mediump float tmpvar_61;
    tmpvar_61 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.z) * tmpvar_61));
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_8.z;
    tmpvar_62.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_37 + tmpvar_62);
    tmpvar_63.z = shadowCoord_5.z;
    mediump float tmpvar_64;
    tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.z) * tmpvar_64));
    tmpvar_6 = mix (1.0, shadow_9, LIGHT_PARAM.y);
  };
  lowp vec4 tmpvar_65;
  tmpvar_65 = texture (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_65;
  highp vec4 tmpvar_66;
  tmpvar_66.w = 1.0;
  tmpvar_66.xyz = ((dstColor_2.xyz * (1.0 - maskCol_1.w)) + ((dstColor_2.xyz * tmpvar_6) * maskCol_1.w));
  _glesFragData[0] = tmpvar_66;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[uint(0)].x = row0_4.x;
  tmpvar_9[uint(0)].y = row0_4.y;
  tmpvar_9[uint(0)].z = row0_4.z;
  tmpvar_9[uint(0)].w = row0_4.w;
  tmpvar_9[1u].x = row1_3.x;
  tmpvar_9[1u].y = row1_3.y;
  tmpvar_9[1u].z = row1_3.z;
  tmpvar_9[1u].w = row1_3.w;
  tmpvar_9[2u].x = row2_2.x;
  tmpvar_9[2u].y = row2_2.y;
  tmpvar_9[2u].z = row2_2.z;
  tmpvar_9[2u].w = row2_2.w;
  tmpvar_9[3u].x = 0.0;
  tmpvar_9[3u].y = 0.0;
  tmpvar_9[3u].z = 0.0;
  tmpvar_9[3u].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)));
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_12;
  highp vec4 tmpvar_13;
  tmpvar_13 = (tmpvar_10 * 0.5);
  o_12.zw = tmpvar_13.zw;
  o_12.xy = (tmpvar_13.xy + tmpvar_13.ww);
  o_12.y = ((2.0 * tmpvar_13.w) - o_12.y);
  o_12.zw = tmpvar_10.zw;
  tmpvar_1.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)))
  ).xyz * 0.5) + 0.5);
  tmpvar_1.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = o_12;
  gl_Position = (tmpvar_11 * tmpvar_10);
  xlv_TEXCOORD4 = tmpvar_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _BlendTex;
uniform sampler2D _MaskTex;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 dstColor_2;
  highp vec3 tmpvar_3;
  tmpvar_3 = (xlv_TEXCOORD1.xyz / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_BlendTex, tmpvar_3.xy);
  dstColor_2 = tmpvar_4;
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_7;
    highp vec4 fetchesOffsetsU_8;
    highp float shadow_9;
    highp vec2 tmpvar_10;
    tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_11;
    tmpvar_11 = floor((tmpvar_10 + 0.5));
    highp vec2 tmpvar_12;
    tmpvar_12 = (tmpvar_10 - tmpvar_11);
    highp vec4 texelsWeightsA_13;
    highp vec4 texelsWeightsB_14;
    highp vec4 computedArea_15;
    highp vec4 computedAreaUncut_16;
    highp float tmpvar_17;
    tmpvar_17 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
    highp float tmpvar_18;
    tmpvar_18 = (tmpvar_17 - tmpvar_12.x);
    computedArea_15.x = tmpvar_18;
    computedAreaUncut_16.x = tmpvar_18;
    computedArea_15.w = tmpvar_17;
    computedAreaUncut_16.w = tmpvar_17;
    computedAreaUncut_16.y = ((1.5 - tmpvar_12.x) - 0.5);
    highp float tmpvar_19;
    tmpvar_19 = min (tmpvar_12.x, 0.0);
    computedArea_15.y = (computedAreaUncut_16.y - (tmpvar_19 * tmpvar_19));
    computedAreaUncut_16.z = ((1.5 + tmpvar_12.x) - 0.5);
    highp float tmpvar_20;
    tmpvar_20 = max (tmpvar_12.x, 0.0);
    computedArea_15.z = (computedAreaUncut_16.z - (tmpvar_20 * tmpvar_20));
    texelsWeightsA_13.x = (0.081632 * tmpvar_18);
    texelsWeightsA_13.y = (0.081632 * computedAreaUncut_16.y);
    texelsWeightsA_13.z = (0.081632 * (computedAreaUncut_16.y + 1.0));
    texelsWeightsA_13.w = (0.081632 * (computedArea_15.y + 2.0));
    texelsWeightsB_14.x = (0.081632 * (computedArea_15.z + 2.0));
    texelsWeightsB_14.y = (0.081632 * (computedAreaUncut_16.z + 1.0));
    texelsWeightsB_14.z = (0.081632 * computedAreaUncut_16.z);
    texelsWeightsB_14.w = (0.081632 * tmpvar_17);
    highp vec4 texelsWeightsA_21;
    highp vec4 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_12.y);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_12.y) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_12.y, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_12.y) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_12.y, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.081632 * tmpvar_26);
    texelsWeightsA_21.y = (0.081632 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.081632 * (computedAreaUncut_24.y + 1.0));
    texelsWeightsA_21.w = (0.081632 * (computedArea_23.y + 2.0));
    texelsWeightsB_22.x = (0.081632 * (computedArea_23.z + 2.0));
    texelsWeightsB_22.y = (0.081632 * (computedAreaUncut_24.z + 1.0));
    texelsWeightsB_22.z = (0.081632 * computedAreaUncut_24.z);
    texelsWeightsB_22.w = (0.081632 * tmpvar_25);
    highp vec4 tmpvar_29;
    tmpvar_29.xy = texelsWeightsA_13.xz;
    tmpvar_29.zw = texelsWeightsB_14.xz;
    highp vec4 tmpvar_30;
    tmpvar_30.xy = texelsWeightsA_13.yw;
    tmpvar_30.zw = texelsWeightsB_14.yw;
    highp vec4 tmpvar_31;
    tmpvar_31 = (tmpvar_29 + tmpvar_30);
    highp vec4 tmpvar_32;
    tmpvar_32.xy = texelsWeightsA_21.xz;
    tmpvar_32.zw = texelsWeightsB_22.xz;
    highp vec4 tmpvar_33;
    tmpvar_33.xy = texelsWeightsA_21.yw;
    tmpvar_33.zw = texelsWeightsB_22.yw;
    highp vec4 tmpvar_34;
    tmpvar_34 = (tmpvar_32 + tmpvar_33);
    highp vec4 tmpvar_35;
    tmpvar_35.xy = texelsWeightsA_13.yw;
    tmpvar_35.zw = texelsWeightsB_14.yw;
    highp vec4 tmpvar_36;
    tmpvar_36.xy = texelsWeightsA_21.yw;
    tmpvar_36.zw = texelsWeightsB_22.yw;
    fetchesOffsetsU_8 = (((tmpvar_35 / tmpvar_31) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_7 = (((tmpvar_36 / tmpvar_34) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_11 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_38;
    tmpvar_38.x = fetchesOffsetsU_8.x;
    tmpvar_38.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_39;
    tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
    tmpvar_39.z = shadowCoord_5.z;
    mediump float tmpvar_40;
    tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39);
    shadow_9 = ((tmpvar_31.x * tmpvar_34.x) * tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_8.y;
    tmpvar_41.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
    tmpvar_42.z = shadowCoord_5.z;
    mediump float tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.x) * tmpvar_43));
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_8.z;
    tmpvar_44.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
    tmpvar_45.z = shadowCoord_5.z;
    mediump float tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_8.w;
    tmpvar_47.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
    tmpvar_48.z = shadowCoord_5.z;
    mediump float tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.x) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_8.x;
    tmpvar_50.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_37 + tmpvar_50);
    tmpvar_51.z = shadowCoord_5.z;
    mediump float tmpvar_52;
    tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.y) * tmpvar_52));
    highp vec2 tmpvar_53;
    tmpvar_53.x = fetchesOffsetsU_8.y;
    tmpvar_53.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_54;
    tmpvar_54.xy = (tmpvar_37 + tmpvar_53);
    tmpvar_54.z = shadowCoord_5.z;
    mediump float tmpvar_55;
    tmpvar_55 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_54);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.y) * tmpvar_55));
    highp vec2 tmpvar_56;
    tmpvar_56.x = fetchesOffsetsU_8.z;
    tmpvar_56.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_57;
    tmpvar_57.xy = (tmpvar_37 + tmpvar_56);
    tmpvar_57.z = shadowCoord_5.z;
    mediump float tmpvar_58;
    tmpvar_58 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_57);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.y) * tmpvar_58));
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_8.w;
    tmpvar_59.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_37 + tmpvar_59);
    tmpvar_60.z = shadowCoord_5.z;
    mediump float tmpvar_61;
    tmpvar_61 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.y) * tmpvar_61));
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_8.x;
    tmpvar_62.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_37 + tmpvar_62);
    tmpvar_63.z = shadowCoord_5.z;
    mediump float tmpvar_64;
    tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.z) * tmpvar_64));
    highp vec2 tmpvar_65;
    tmpvar_65.x = fetchesOffsetsU_8.y;
    tmpvar_65.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_66;
    tmpvar_66.xy = (tmpvar_37 + tmpvar_65);
    tmpvar_66.z = shadowCoord_5.z;
    mediump float tmpvar_67;
    tmpvar_67 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_66);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.z) * tmpvar_67));
    highp vec2 tmpvar_68;
    tmpvar_68.x = fetchesOffsetsU_8.z;
    tmpvar_68.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_69;
    tmpvar_69.xy = (tmpvar_37 + tmpvar_68);
    tmpvar_69.z = shadowCoord_5.z;
    mediump float tmpvar_70;
    tmpvar_70 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_69);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.z) * tmpvar_70));
    highp vec2 tmpvar_71;
    tmpvar_71.x = fetchesOffsetsU_8.w;
    tmpvar_71.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_72;
    tmpvar_72.xy = (tmpvar_37 + tmpvar_71);
    tmpvar_72.z = shadowCoord_5.z;
    mediump float tmpvar_73;
    tmpvar_73 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_72);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.z) * tmpvar_73));
    highp vec2 tmpvar_74;
    tmpvar_74.x = fetchesOffsetsU_8.x;
    tmpvar_74.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_75;
    tmpvar_75.xy = (tmpvar_37 + tmpvar_74);
    tmpvar_75.z = shadowCoord_5.z;
    mediump float tmpvar_76;
    tmpvar_76 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_75);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.w) * tmpvar_76));
    highp vec2 tmpvar_77;
    tmpvar_77.x = fetchesOffsetsU_8.y;
    tmpvar_77.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_78;
    tmpvar_78.xy = (tmpvar_37 + tmpvar_77);
    tmpvar_78.z = shadowCoord_5.z;
    mediump float tmpvar_79;
    tmpvar_79 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_78);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.w) * tmpvar_79));
    highp vec2 tmpvar_80;
    tmpvar_80.x = fetchesOffsetsU_8.z;
    tmpvar_80.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_81;
    tmpvar_81.xy = (tmpvar_37 + tmpvar_80);
    tmpvar_81.z = shadowCoord_5.z;
    mediump float tmpvar_82;
    tmpvar_82 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_81);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.w) * tmpvar_82));
    highp vec2 tmpvar_83;
    tmpvar_83.x = fetchesOffsetsU_8.w;
    tmpvar_83.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_84;
    tmpvar_84.xy = (tmpvar_37 + tmpvar_83);
    tmpvar_84.z = shadowCoord_5.z;
    mediump float tmpvar_85;
    tmpvar_85 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_84);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.w) * tmpvar_85));
    tmpvar_6 = mix (1.0, shadow_9, LIGHT_PARAM.y);
  };
  lowp vec4 tmpvar_86;
  tmpvar_86 = texture (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_86;
  highp vec4 tmpvar_87;
  tmpvar_87.w = 1.0;
  tmpvar_87.xyz = ((dstColor_2.xyz * (1.0 - maskCol_1.w)) + ((dstColor_2.xyz * tmpvar_6) * maskCol_1.w));
  _glesFragData[0] = tmpvar_87;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[uint(0)].x = row0_4.x;
  tmpvar_9[uint(0)].y = row0_4.y;
  tmpvar_9[uint(0)].z = row0_4.z;
  tmpvar_9[uint(0)].w = row0_4.w;
  tmpvar_9[1u].x = row1_3.x;
  tmpvar_9[1u].y = row1_3.y;
  tmpvar_9[1u].z = row1_3.z;
  tmpvar_9[1u].w = row1_3.w;
  tmpvar_9[2u].x = row2_2.x;
  tmpvar_9[2u].y = row2_2.y;
  tmpvar_9[2u].z = row2_2.z;
  tmpvar_9[2u].w = row2_2.w;
  tmpvar_9[3u].x = 0.0;
  tmpvar_9[3u].y = 0.0;
  tmpvar_9[3u].z = 0.0;
  tmpvar_9[3u].w = 1.0;
  highp vec4 tmpvar_10;
  tmpvar_10 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)));
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_12;
  highp vec4 tmpvar_13;
  tmpvar_13 = (tmpvar_10 * 0.5);
  o_12.zw = tmpvar_13.zw;
  o_12.xy = (tmpvar_13.xy + tmpvar_13.ww);
  o_12.y = ((2.0 * tmpvar_13.w) - o_12.y);
  o_12.zw = tmpvar_10.zw;
  tmpvar_1.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)))
  ).xyz * 0.5) + 0.5);
  tmpvar_1.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_9)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = o_12;
  gl_Position = (tmpvar_11 * tmpvar_10);
  xlv_TEXCOORD4 = tmpvar_1;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _BlendTex;
uniform sampler2D _MaskTex;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 dstColor_2;
  highp vec3 tmpvar_3;
  tmpvar_3 = (xlv_TEXCOORD1.xyz / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_BlendTex, tmpvar_3.xy);
  dstColor_2 = tmpvar_4;
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    highp vec2 tmpvar_7;
    tmpvar_7.x = LIGHT_PARAM.z;
    tmpvar_7.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_8;
    tmpvar_8.xy = tmpvar_7;
    highp float tmpvar_9;
    tmpvar_9 = (1.0/(LIGHT_PARAM.z));
    tmpvar_8.z = tmpvar_9;
    tmpvar_8.w = tmpvar_9;
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_10;
    highp vec2 tmpvar_11;
    tmpvar_11 = tmpvar_8.xy;
    shadow_10 = 0.0;
    highp vec3 tmpvar_12;
    tmpvar_12.xy = (shadowCoord_5.xy - LIGHT_PARAM.zz);
    tmpvar_12.z = shadowCoord_5.z;
    highp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_12.xy);
    highp float tmpvar_14;
    if ((tmpvar_13.x < xlv_TEXCOORD4.z)) {
      tmpvar_14 = 0.0;
    } else {
      tmpvar_14 = 1.0;
    };
    shadow_10 = tmpvar_14;
    highp vec2 tmpvar_15;
    tmpvar_15.x = 0.0;
    tmpvar_15.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_16;
    tmpvar_16.xy = (shadowCoord_5.xy + tmpvar_15);
    tmpvar_16.z = shadowCoord_5.z;
    highp vec4 tmpvar_17;
    tmpvar_17 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_16.xy);
    highp float tmpvar_18;
    if ((tmpvar_17.x < xlv_TEXCOORD4.z)) {
      tmpvar_18 = 0.0;
    } else {
      tmpvar_18 = 1.0;
    };
    shadow_10 = (tmpvar_14 + tmpvar_18);
    highp vec2 tmpvar_19;
    tmpvar_19.x = tmpvar_11.x;
    tmpvar_19.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_20;
    tmpvar_20.xy = (shadowCoord_5.xy + tmpvar_19);
    tmpvar_20.z = shadowCoord_5.z;
    highp vec4 tmpvar_21;
    tmpvar_21 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_20.xy);
    highp float tmpvar_22;
    if ((tmpvar_21.x < xlv_TEXCOORD4.z)) {
      tmpvar_22 = 0.0;
    } else {
      tmpvar_22 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_22);
    highp vec2 tmpvar_23;
    tmpvar_23.y = 0.0;
    tmpvar_23.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_24;
    tmpvar_24.xy = (shadowCoord_5.xy + tmpvar_23);
    tmpvar_24.z = shadowCoord_5.z;
    highp vec4 tmpvar_25;
    tmpvar_25 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_24.xy);
    highp float tmpvar_26;
    if ((tmpvar_25.x < xlv_TEXCOORD4.z)) {
      tmpvar_26 = 0.0;
    } else {
      tmpvar_26 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_26);
    highp vec4 tmpvar_27;
    tmpvar_27 = texture (TEXTURE_SHADOW_DEPTH, shadowCoord_5.xy);
    highp float tmpvar_28;
    if ((tmpvar_27.x < xlv_TEXCOORD4.z)) {
      tmpvar_28 = 0.0;
    } else {
      tmpvar_28 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_28);
    highp vec2 tmpvar_29;
    tmpvar_29.y = 0.0;
    tmpvar_29.x = tmpvar_11.x;
    highp vec3 tmpvar_30;
    tmpvar_30.xy = (shadowCoord_5.xy + tmpvar_29);
    tmpvar_30.z = shadowCoord_5.z;
    highp vec4 tmpvar_31;
    tmpvar_31 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_30.xy);
    highp float tmpvar_32;
    if ((tmpvar_31.x < xlv_TEXCOORD4.z)) {
      tmpvar_32 = 0.0;
    } else {
      tmpvar_32 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_32);
    highp vec2 tmpvar_33;
    tmpvar_33.x = -(LIGHT_PARAM.z);
    tmpvar_33.y = tmpvar_11.y;
    highp vec3 tmpvar_34;
    tmpvar_34.xy = (shadowCoord_5.xy + tmpvar_33);
    tmpvar_34.z = shadowCoord_5.z;
    highp vec4 tmpvar_35;
    tmpvar_35 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_34.xy);
    highp float tmpvar_36;
    if ((tmpvar_35.x < xlv_TEXCOORD4.z)) {
      tmpvar_36 = 0.0;
    } else {
      tmpvar_36 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_36);
    highp vec2 tmpvar_37;
    tmpvar_37.x = 0.0;
    tmpvar_37.y = tmpvar_11.y;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (shadowCoord_5.xy + tmpvar_37);
    tmpvar_38.z = shadowCoord_5.z;
    highp vec4 tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38.xy);
    highp float tmpvar_40;
    if ((tmpvar_39.x < xlv_TEXCOORD4.z)) {
      tmpvar_40 = 0.0;
    } else {
      tmpvar_40 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_40);
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (shadowCoord_5.xy + LIGHT_PARAM.zz);
    tmpvar_41.z = shadowCoord_5.z;
    highp vec4 tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41.xy);
    highp float tmpvar_43;
    if ((tmpvar_42.x < xlv_TEXCOORD4.z)) {
      tmpvar_43 = 0.0;
    } else {
      tmpvar_43 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_43);
    shadow_10 = (shadow_10 / 9.0);
    tmpvar_6 = mix (1.0, shadow_10, LIGHT_PARAM.y);
  };
  lowp vec4 tmpvar_44;
  tmpvar_44 = texture (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_44;
  highp vec4 tmpvar_45;
  tmpvar_45.w = 1.0;
  tmpvar_45.xyz = ((dstColor_2.xyz * (1.0 - maskCol_1.w)) + ((dstColor_2.xyz * tmpvar_6) * maskCol_1.w));
  _glesFragData[0] = tmpvar_45;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = _glesVertex.xyz;
  tmpvar_1 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2));
  highp vec4 tmpvar_3;
  tmpvar_3.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_3.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_1 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_1.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = o_4;
  gl_Position = (tmpvar_3 * tmpvar_1);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D _BlendTex;
uniform sampler2D _MaskTex;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 dstColor_2;
  highp vec3 tmpvar_3;
  tmpvar_3 = (xlv_TEXCOORD1.xyz / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_BlendTex, tmpvar_3.xy);
  dstColor_2 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = ((dstColor_2.xyz * (1.0 - maskCol_1.w)) + (dstColor_2.xyz * maskCol_1.w));
  _glesFragData[0] = tmpvar_6;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = _glesVertex.xyz;
  tmpvar_1 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2));
  highp vec4 tmpvar_3;
  tmpvar_3.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_3.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_1 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_1.zw;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = o_4;
  gl_Position = (tmpvar_3 * tmpvar_1);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D _BlendTex;
uniform sampler2D _MaskTex;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 dstColor_2;
  highp vec3 tmpvar_3;
  tmpvar_3 = (xlv_TEXCOORD1.xyz / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_BlendTex, tmpvar_3.xy);
  dstColor_2 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = ((dstColor_2.xyz * (1.0 - maskCol_1.w)) + (dstColor_2.xyz * maskCol_1.w));
  _glesFragData[0] = tmpvar_6;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  tmpvar_2.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_8))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  tmpvar_2.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_9)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = o_6;
  gl_Position = (tmpvar_5 * tmpvar_3);
  xlv_TEXCOORD4 = tmpvar_2;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _BlendTex;
uniform sampler2D _MaskTex;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 dstColor_2;
  highp vec3 tmpvar_3;
  tmpvar_3 = (xlv_TEXCOORD1.xyz / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_BlendTex, tmpvar_3.xy);
  dstColor_2 = tmpvar_4;
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_7;
    highp vec2 fetchesOffsetsU_8;
    highp float shadow_9;
    highp vec2 tmpvar_10;
    tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_11;
    tmpvar_11 = floor((tmpvar_10 + 0.5));
    highp vec2 tmpvar_12;
    tmpvar_12 = (tmpvar_10 - tmpvar_11);
    highp vec4 computedWeight_13;
    highp vec4 computedArea_14;
    highp vec4 computedAreaUncut_15;
    highp float tmpvar_16;
    tmpvar_16 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
    highp float tmpvar_17;
    tmpvar_17 = (tmpvar_16 - tmpvar_12.x);
    computedArea_14.x = tmpvar_17;
    computedAreaUncut_15.x = tmpvar_17;
    computedArea_14.w = tmpvar_16;
    computedAreaUncut_15.w = tmpvar_16;
    computedAreaUncut_15.y = ((1.5 - tmpvar_12.x) - 0.5);
    highp float tmpvar_18;
    tmpvar_18 = min (tmpvar_12.x, 0.0);
    computedArea_14.y = (computedAreaUncut_15.y - (tmpvar_18 * tmpvar_18));
    computedAreaUncut_15.z = ((1.5 + tmpvar_12.x) - 0.5);
    highp float tmpvar_19;
    tmpvar_19 = max (tmpvar_12.x, 0.0);
    computedArea_14.z = (computedAreaUncut_15.z - (tmpvar_19 * tmpvar_19));
    computedWeight_13 = (computedArea_14 * 0.44444);
    highp vec4 computedWeight_20;
    highp vec4 computedArea_21;
    highp vec4 computedAreaUncut_22;
    highp float tmpvar_23;
    tmpvar_23 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
    highp float tmpvar_24;
    tmpvar_24 = (tmpvar_23 - tmpvar_12.y);
    computedArea_21.x = tmpvar_24;
    computedAreaUncut_22.x = tmpvar_24;
    computedArea_21.w = tmpvar_23;
    computedAreaUncut_22.w = tmpvar_23;
    computedAreaUncut_22.y = ((1.5 - tmpvar_12.y) - 0.5);
    highp float tmpvar_25;
    tmpvar_25 = min (tmpvar_12.y, 0.0);
    computedArea_21.y = (computedAreaUncut_22.y - (tmpvar_25 * tmpvar_25));
    computedAreaUncut_22.z = ((1.5 + tmpvar_12.y) - 0.5);
    highp float tmpvar_26;
    tmpvar_26 = max (tmpvar_12.y, 0.0);
    computedArea_21.z = (computedAreaUncut_22.z - (tmpvar_26 * tmpvar_26));
    computedWeight_20 = (computedArea_21 * 0.44444);
    highp vec2 tmpvar_27;
    tmpvar_27 = (computedWeight_13.xz + computedWeight_13.yw);
    highp vec2 tmpvar_28;
    tmpvar_28 = (computedWeight_20.xz + computedWeight_20.yw);
    fetchesOffsetsU_8 = (((computedWeight_13.yw / tmpvar_27) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_7 = (((computedWeight_20.yw / tmpvar_28) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_29;
    tmpvar_29 = (tmpvar_11 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_30;
    tmpvar_30.x = fetchesOffsetsU_8.x;
    tmpvar_30.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_31;
    tmpvar_31.xy = (tmpvar_29 + tmpvar_30);
    tmpvar_31.z = shadowCoord_5.z;
    mediump float tmpvar_32;
    tmpvar_32 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_31);
    shadow_9 = ((tmpvar_27.x * tmpvar_28.x) * tmpvar_32);
    highp vec2 tmpvar_33;
    tmpvar_33.x = fetchesOffsetsU_8.y;
    tmpvar_33.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_34;
    tmpvar_34.xy = (tmpvar_29 + tmpvar_33);
    tmpvar_34.z = shadowCoord_5.z;
    mediump float tmpvar_35;
    tmpvar_35 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_34);
    shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.x) * tmpvar_35));
    highp vec2 tmpvar_36;
    tmpvar_36.x = fetchesOffsetsU_8.x;
    tmpvar_36.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_37;
    tmpvar_37.xy = (tmpvar_29 + tmpvar_36);
    tmpvar_37.z = shadowCoord_5.z;
    mediump float tmpvar_38;
    tmpvar_38 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_37);
    shadow_9 = (shadow_9 + ((tmpvar_27.x * tmpvar_28.y) * tmpvar_38));
    highp vec2 tmpvar_39;
    tmpvar_39.x = fetchesOffsetsU_8.y;
    tmpvar_39.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_40;
    tmpvar_40.xy = (tmpvar_29 + tmpvar_39);
    tmpvar_40.z = shadowCoord_5.z;
    mediump float tmpvar_41;
    tmpvar_41 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_40);
    shadow_9 = (shadow_9 + ((tmpvar_27.y * tmpvar_28.y) * tmpvar_41));
    tmpvar_6 = mix (1.0, shadow_9, LIGHT_PARAM.y);
  };
  lowp vec4 tmpvar_42;
  tmpvar_42 = texture (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_42;
  highp vec4 tmpvar_43;
  tmpvar_43.w = 1.0;
  tmpvar_43.xyz = ((dstColor_2.xyz * (1.0 - maskCol_1.w)) + ((dstColor_2.xyz * tmpvar_6) * maskCol_1.w));
  _glesFragData[0] = tmpvar_43;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  tmpvar_2.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_8))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  tmpvar_2.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_9)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = o_6;
  gl_Position = (tmpvar_5 * tmpvar_3);
  xlv_TEXCOORD4 = tmpvar_2;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _BlendTex;
uniform sampler2D _MaskTex;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 dstColor_2;
  highp vec3 tmpvar_3;
  tmpvar_3 = (xlv_TEXCOORD1.xyz / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_BlendTex, tmpvar_3.xy);
  dstColor_2 = tmpvar_4;
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_7;
    highp vec3 fetchesOffsetsU_8;
    highp float shadow_9;
    highp vec2 tmpvar_10;
    tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_11;
    tmpvar_11 = floor((tmpvar_10 + 0.5));
    highp vec2 tmpvar_12;
    tmpvar_12 = (tmpvar_10 - tmpvar_11);
    highp vec3 texelsWeightsA_13;
    highp vec3 texelsWeightsB_14;
    highp vec4 computedArea_15;
    highp vec4 computedAreaUncut_16;
    highp float tmpvar_17;
    tmpvar_17 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
    highp float tmpvar_18;
    tmpvar_18 = (tmpvar_17 - tmpvar_12.x);
    computedArea_15.x = tmpvar_18;
    computedAreaUncut_16.x = tmpvar_18;
    computedArea_15.w = tmpvar_17;
    computedAreaUncut_16.w = tmpvar_17;
    computedAreaUncut_16.y = ((1.5 - tmpvar_12.x) - 0.5);
    highp float tmpvar_19;
    tmpvar_19 = min (tmpvar_12.x, 0.0);
    computedArea_15.y = (computedAreaUncut_16.y - (tmpvar_19 * tmpvar_19));
    computedAreaUncut_16.z = ((1.5 + tmpvar_12.x) - 0.5);
    highp float tmpvar_20;
    tmpvar_20 = max (tmpvar_12.x, 0.0);
    computedArea_15.z = (computedAreaUncut_16.z - (tmpvar_20 * tmpvar_20));
    texelsWeightsA_13.x = (0.16 * tmpvar_18);
    texelsWeightsA_13.y = (0.16 * computedAreaUncut_16.y);
    texelsWeightsA_13.z = (0.16 * (computedArea_15.y + 1.0));
    texelsWeightsB_14.x = (0.16 * (computedArea_15.z + 1.0));
    texelsWeightsB_14.y = (0.16 * computedAreaUncut_16.z);
    texelsWeightsB_14.z = (0.16 * tmpvar_17);
    highp vec3 texelsWeightsA_21;
    highp vec3 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_12.y);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_12.y) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_12.y, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_12.y) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_12.y, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.16 * tmpvar_26);
    texelsWeightsA_21.y = (0.16 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.16 * (computedArea_23.y + 1.0));
    texelsWeightsB_22.x = (0.16 * (computedArea_23.z + 1.0));
    texelsWeightsB_22.y = (0.16 * computedAreaUncut_24.z);
    texelsWeightsB_22.z = (0.16 * tmpvar_25);
    highp vec3 tmpvar_29;
    tmpvar_29.xy = texelsWeightsA_13.xz;
    tmpvar_29.z = texelsWeightsB_14.y;
    highp vec3 tmpvar_30;
    tmpvar_30.x = texelsWeightsA_13.y;
    tmpvar_30.yz = texelsWeightsB_14.xz;
    highp vec3 tmpvar_31;
    tmpvar_31 = (tmpvar_29 + tmpvar_30);
    highp vec3 tmpvar_32;
    tmpvar_32.xy = texelsWeightsA_21.xz;
    tmpvar_32.z = texelsWeightsB_22.y;
    highp vec3 tmpvar_33;
    tmpvar_33.x = texelsWeightsA_21.y;
    tmpvar_33.yz = texelsWeightsB_22.xz;
    highp vec3 tmpvar_34;
    tmpvar_34 = (tmpvar_32 + tmpvar_33);
    highp vec3 tmpvar_35;
    tmpvar_35.x = texelsWeightsA_13.y;
    tmpvar_35.yz = texelsWeightsB_14.xz;
    highp vec3 tmpvar_36;
    tmpvar_36.x = texelsWeightsA_21.y;
    tmpvar_36.yz = texelsWeightsB_22.xz;
    fetchesOffsetsU_8 = (((tmpvar_35 / tmpvar_31) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_7 = (((tmpvar_36 / tmpvar_34) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_11 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_38;
    tmpvar_38.x = fetchesOffsetsU_8.x;
    tmpvar_38.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_39;
    tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
    tmpvar_39.z = shadowCoord_5.z;
    mediump float tmpvar_40;
    tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39);
    shadow_9 = ((tmpvar_31.x * tmpvar_34.x) * tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_8.y;
    tmpvar_41.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
    tmpvar_42.z = shadowCoord_5.z;
    mediump float tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.x) * tmpvar_43));
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_8.z;
    tmpvar_44.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
    tmpvar_45.z = shadowCoord_5.z;
    mediump float tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_8.x;
    tmpvar_47.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
    tmpvar_48.z = shadowCoord_5.z;
    mediump float tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.y) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_8.y;
    tmpvar_50.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_37 + tmpvar_50);
    tmpvar_51.z = shadowCoord_5.z;
    mediump float tmpvar_52;
    tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.y) * tmpvar_52));
    highp vec2 tmpvar_53;
    tmpvar_53.x = fetchesOffsetsU_8.z;
    tmpvar_53.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_54;
    tmpvar_54.xy = (tmpvar_37 + tmpvar_53);
    tmpvar_54.z = shadowCoord_5.z;
    mediump float tmpvar_55;
    tmpvar_55 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_54);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.y) * tmpvar_55));
    highp vec2 tmpvar_56;
    tmpvar_56.x = fetchesOffsetsU_8.x;
    tmpvar_56.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_57;
    tmpvar_57.xy = (tmpvar_37 + tmpvar_56);
    tmpvar_57.z = shadowCoord_5.z;
    mediump float tmpvar_58;
    tmpvar_58 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_57);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.z) * tmpvar_58));
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_8.y;
    tmpvar_59.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_37 + tmpvar_59);
    tmpvar_60.z = shadowCoord_5.z;
    mediump float tmpvar_61;
    tmpvar_61 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.z) * tmpvar_61));
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_8.z;
    tmpvar_62.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_37 + tmpvar_62);
    tmpvar_63.z = shadowCoord_5.z;
    mediump float tmpvar_64;
    tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.z) * tmpvar_64));
    tmpvar_6 = mix (1.0, shadow_9, LIGHT_PARAM.y);
  };
  lowp vec4 tmpvar_65;
  tmpvar_65 = texture (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_65;
  highp vec4 tmpvar_66;
  tmpvar_66.w = 1.0;
  tmpvar_66.xyz = ((dstColor_2.xyz * (1.0 - maskCol_1.w)) + ((dstColor_2.xyz * tmpvar_6) * maskCol_1.w));
  _glesFragData[0] = tmpvar_66;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  tmpvar_2.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_8))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  tmpvar_2.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_9)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = o_6;
  gl_Position = (tmpvar_5 * tmpvar_3);
  xlv_TEXCOORD4 = tmpvar_2;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _BlendTex;
uniform sampler2D _MaskTex;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 dstColor_2;
  highp vec3 tmpvar_3;
  tmpvar_3 = (xlv_TEXCOORD1.xyz / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_BlendTex, tmpvar_3.xy);
  dstColor_2 = tmpvar_4;
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_7;
    highp vec4 fetchesOffsetsU_8;
    highp float shadow_9;
    highp vec2 tmpvar_10;
    tmpvar_10 = (shadowCoord_5.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_11;
    tmpvar_11 = floor((tmpvar_10 + 0.5));
    highp vec2 tmpvar_12;
    tmpvar_12 = (tmpvar_10 - tmpvar_11);
    highp vec4 texelsWeightsA_13;
    highp vec4 texelsWeightsB_14;
    highp vec4 computedArea_15;
    highp vec4 computedAreaUncut_16;
    highp float tmpvar_17;
    tmpvar_17 = (((tmpvar_12.x + 0.5) * (tmpvar_12.x + 0.5)) * 0.5);
    highp float tmpvar_18;
    tmpvar_18 = (tmpvar_17 - tmpvar_12.x);
    computedArea_15.x = tmpvar_18;
    computedAreaUncut_16.x = tmpvar_18;
    computedArea_15.w = tmpvar_17;
    computedAreaUncut_16.w = tmpvar_17;
    computedAreaUncut_16.y = ((1.5 - tmpvar_12.x) - 0.5);
    highp float tmpvar_19;
    tmpvar_19 = min (tmpvar_12.x, 0.0);
    computedArea_15.y = (computedAreaUncut_16.y - (tmpvar_19 * tmpvar_19));
    computedAreaUncut_16.z = ((1.5 + tmpvar_12.x) - 0.5);
    highp float tmpvar_20;
    tmpvar_20 = max (tmpvar_12.x, 0.0);
    computedArea_15.z = (computedAreaUncut_16.z - (tmpvar_20 * tmpvar_20));
    texelsWeightsA_13.x = (0.081632 * tmpvar_18);
    texelsWeightsA_13.y = (0.081632 * computedAreaUncut_16.y);
    texelsWeightsA_13.z = (0.081632 * (computedAreaUncut_16.y + 1.0));
    texelsWeightsA_13.w = (0.081632 * (computedArea_15.y + 2.0));
    texelsWeightsB_14.x = (0.081632 * (computedArea_15.z + 2.0));
    texelsWeightsB_14.y = (0.081632 * (computedAreaUncut_16.z + 1.0));
    texelsWeightsB_14.z = (0.081632 * computedAreaUncut_16.z);
    texelsWeightsB_14.w = (0.081632 * tmpvar_17);
    highp vec4 texelsWeightsA_21;
    highp vec4 texelsWeightsB_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_12.y + 0.5) * (tmpvar_12.y + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_12.y);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_12.y) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_12.y, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_12.y) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_12.y, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    texelsWeightsA_21.x = (0.081632 * tmpvar_26);
    texelsWeightsA_21.y = (0.081632 * computedAreaUncut_24.y);
    texelsWeightsA_21.z = (0.081632 * (computedAreaUncut_24.y + 1.0));
    texelsWeightsA_21.w = (0.081632 * (computedArea_23.y + 2.0));
    texelsWeightsB_22.x = (0.081632 * (computedArea_23.z + 2.0));
    texelsWeightsB_22.y = (0.081632 * (computedAreaUncut_24.z + 1.0));
    texelsWeightsB_22.z = (0.081632 * computedAreaUncut_24.z);
    texelsWeightsB_22.w = (0.081632 * tmpvar_25);
    highp vec4 tmpvar_29;
    tmpvar_29.xy = texelsWeightsA_13.xz;
    tmpvar_29.zw = texelsWeightsB_14.xz;
    highp vec4 tmpvar_30;
    tmpvar_30.xy = texelsWeightsA_13.yw;
    tmpvar_30.zw = texelsWeightsB_14.yw;
    highp vec4 tmpvar_31;
    tmpvar_31 = (tmpvar_29 + tmpvar_30);
    highp vec4 tmpvar_32;
    tmpvar_32.xy = texelsWeightsA_21.xz;
    tmpvar_32.zw = texelsWeightsB_22.xz;
    highp vec4 tmpvar_33;
    tmpvar_33.xy = texelsWeightsA_21.yw;
    tmpvar_33.zw = texelsWeightsB_22.yw;
    highp vec4 tmpvar_34;
    tmpvar_34 = (tmpvar_32 + tmpvar_33);
    highp vec4 tmpvar_35;
    tmpvar_35.xy = texelsWeightsA_13.yw;
    tmpvar_35.zw = texelsWeightsB_14.yw;
    highp vec4 tmpvar_36;
    tmpvar_36.xy = texelsWeightsA_21.yw;
    tmpvar_36.zw = texelsWeightsB_22.yw;
    fetchesOffsetsU_8 = (((tmpvar_35 / tmpvar_31) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_7 = (((tmpvar_36 / tmpvar_34) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_11 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_38;
    tmpvar_38.x = fetchesOffsetsU_8.x;
    tmpvar_38.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_39;
    tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
    tmpvar_39.z = shadowCoord_5.z;
    mediump float tmpvar_40;
    tmpvar_40 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_39);
    shadow_9 = ((tmpvar_31.x * tmpvar_34.x) * tmpvar_40);
    highp vec2 tmpvar_41;
    tmpvar_41.x = fetchesOffsetsU_8.y;
    tmpvar_41.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_42;
    tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
    tmpvar_42.z = shadowCoord_5.z;
    mediump float tmpvar_43;
    tmpvar_43 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_42);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.x) * tmpvar_43));
    highp vec2 tmpvar_44;
    tmpvar_44.x = fetchesOffsetsU_8.z;
    tmpvar_44.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
    tmpvar_45.z = shadowCoord_5.z;
    mediump float tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.x) * tmpvar_46));
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_8.w;
    tmpvar_47.y = fetchesOffsetsV_7.x;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
    tmpvar_48.z = shadowCoord_5.z;
    mediump float tmpvar_49;
    tmpvar_49 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.x) * tmpvar_49));
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_8.x;
    tmpvar_50.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_37 + tmpvar_50);
    tmpvar_51.z = shadowCoord_5.z;
    mediump float tmpvar_52;
    tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.y) * tmpvar_52));
    highp vec2 tmpvar_53;
    tmpvar_53.x = fetchesOffsetsU_8.y;
    tmpvar_53.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_54;
    tmpvar_54.xy = (tmpvar_37 + tmpvar_53);
    tmpvar_54.z = shadowCoord_5.z;
    mediump float tmpvar_55;
    tmpvar_55 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_54);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.y) * tmpvar_55));
    highp vec2 tmpvar_56;
    tmpvar_56.x = fetchesOffsetsU_8.z;
    tmpvar_56.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_57;
    tmpvar_57.xy = (tmpvar_37 + tmpvar_56);
    tmpvar_57.z = shadowCoord_5.z;
    mediump float tmpvar_58;
    tmpvar_58 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_57);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.y) * tmpvar_58));
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_8.w;
    tmpvar_59.y = fetchesOffsetsV_7.y;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_37 + tmpvar_59);
    tmpvar_60.z = shadowCoord_5.z;
    mediump float tmpvar_61;
    tmpvar_61 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.y) * tmpvar_61));
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_8.x;
    tmpvar_62.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_37 + tmpvar_62);
    tmpvar_63.z = shadowCoord_5.z;
    mediump float tmpvar_64;
    tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.z) * tmpvar_64));
    highp vec2 tmpvar_65;
    tmpvar_65.x = fetchesOffsetsU_8.y;
    tmpvar_65.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_66;
    tmpvar_66.xy = (tmpvar_37 + tmpvar_65);
    tmpvar_66.z = shadowCoord_5.z;
    mediump float tmpvar_67;
    tmpvar_67 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_66);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.z) * tmpvar_67));
    highp vec2 tmpvar_68;
    tmpvar_68.x = fetchesOffsetsU_8.z;
    tmpvar_68.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_69;
    tmpvar_69.xy = (tmpvar_37 + tmpvar_68);
    tmpvar_69.z = shadowCoord_5.z;
    mediump float tmpvar_70;
    tmpvar_70 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_69);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.z) * tmpvar_70));
    highp vec2 tmpvar_71;
    tmpvar_71.x = fetchesOffsetsU_8.w;
    tmpvar_71.y = fetchesOffsetsV_7.z;
    highp vec3 tmpvar_72;
    tmpvar_72.xy = (tmpvar_37 + tmpvar_71);
    tmpvar_72.z = shadowCoord_5.z;
    mediump float tmpvar_73;
    tmpvar_73 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_72);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.z) * tmpvar_73));
    highp vec2 tmpvar_74;
    tmpvar_74.x = fetchesOffsetsU_8.x;
    tmpvar_74.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_75;
    tmpvar_75.xy = (tmpvar_37 + tmpvar_74);
    tmpvar_75.z = shadowCoord_5.z;
    mediump float tmpvar_76;
    tmpvar_76 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_75);
    shadow_9 = (shadow_9 + ((tmpvar_31.x * tmpvar_34.w) * tmpvar_76));
    highp vec2 tmpvar_77;
    tmpvar_77.x = fetchesOffsetsU_8.y;
    tmpvar_77.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_78;
    tmpvar_78.xy = (tmpvar_37 + tmpvar_77);
    tmpvar_78.z = shadowCoord_5.z;
    mediump float tmpvar_79;
    tmpvar_79 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_78);
    shadow_9 = (shadow_9 + ((tmpvar_31.y * tmpvar_34.w) * tmpvar_79));
    highp vec2 tmpvar_80;
    tmpvar_80.x = fetchesOffsetsU_8.z;
    tmpvar_80.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_81;
    tmpvar_81.xy = (tmpvar_37 + tmpvar_80);
    tmpvar_81.z = shadowCoord_5.z;
    mediump float tmpvar_82;
    tmpvar_82 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_81);
    shadow_9 = (shadow_9 + ((tmpvar_31.z * tmpvar_34.w) * tmpvar_82));
    highp vec2 tmpvar_83;
    tmpvar_83.x = fetchesOffsetsU_8.w;
    tmpvar_83.y = fetchesOffsetsV_7.w;
    highp vec3 tmpvar_84;
    tmpvar_84.xy = (tmpvar_37 + tmpvar_83);
    tmpvar_84.z = shadowCoord_5.z;
    mediump float tmpvar_85;
    tmpvar_85 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_84);
    shadow_9 = (shadow_9 + ((tmpvar_31.w * tmpvar_34.w) * tmpvar_85));
    tmpvar_6 = mix (1.0, shadow_9, LIGHT_PARAM.y);
  };
  lowp vec4 tmpvar_86;
  tmpvar_86 = texture (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_86;
  highp vec4 tmpvar_87;
  tmpvar_87.w = 1.0;
  tmpvar_87.xyz = ((dstColor_2.xyz * (1.0 - maskCol_1.w)) + ((dstColor_2.xyz * tmpvar_6) * maskCol_1.w));
  _glesFragData[0] = tmpvar_87;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_3 * 0.5);
  o_6.zw = tmpvar_7.zw;
  o_6.xy = (tmpvar_7.xy + tmpvar_7.ww);
  o_6.y = ((2.0 * tmpvar_7.w) - o_6.y);
  o_6.zw = tmpvar_3.zw;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  tmpvar_2.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_8))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  tmpvar_2.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_9)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = o_6;
  gl_Position = (tmpvar_5 * tmpvar_3);
  xlv_TEXCOORD4 = tmpvar_2;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _BlendTex;
uniform sampler2D _MaskTex;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 dstColor_2;
  highp vec3 tmpvar_3;
  tmpvar_3 = (xlv_TEXCOORD1.xyz / xlv_TEXCOORD1.w);
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_BlendTex, tmpvar_3.xy);
  dstColor_2 = tmpvar_4;
  highp vec4 shadowCoord_5;
  shadowCoord_5 = xlv_TEXCOORD4;
  highp float tmpvar_6;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_6 = 1.0;
  } else {
    highp vec2 tmpvar_7;
    tmpvar_7.x = LIGHT_PARAM.z;
    tmpvar_7.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_8;
    tmpvar_8.xy = tmpvar_7;
    highp float tmpvar_9;
    tmpvar_9 = (1.0/(LIGHT_PARAM.z));
    tmpvar_8.z = tmpvar_9;
    tmpvar_8.w = tmpvar_9;
    shadowCoord_5.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_10;
    highp vec2 tmpvar_11;
    tmpvar_11 = tmpvar_8.xy;
    shadow_10 = 0.0;
    highp vec3 tmpvar_12;
    tmpvar_12.xy = (shadowCoord_5.xy - LIGHT_PARAM.zz);
    tmpvar_12.z = shadowCoord_5.z;
    highp vec4 tmpvar_13;
    tmpvar_13 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_12.xy);
    highp float tmpvar_14;
    if ((tmpvar_13.x < xlv_TEXCOORD4.z)) {
      tmpvar_14 = 0.0;
    } else {
      tmpvar_14 = 1.0;
    };
    shadow_10 = tmpvar_14;
    highp vec2 tmpvar_15;
    tmpvar_15.x = 0.0;
    tmpvar_15.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_16;
    tmpvar_16.xy = (shadowCoord_5.xy + tmpvar_15);
    tmpvar_16.z = shadowCoord_5.z;
    highp vec4 tmpvar_17;
    tmpvar_17 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_16.xy);
    highp float tmpvar_18;
    if ((tmpvar_17.x < xlv_TEXCOORD4.z)) {
      tmpvar_18 = 0.0;
    } else {
      tmpvar_18 = 1.0;
    };
    shadow_10 = (tmpvar_14 + tmpvar_18);
    highp vec2 tmpvar_19;
    tmpvar_19.x = tmpvar_11.x;
    tmpvar_19.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_20;
    tmpvar_20.xy = (shadowCoord_5.xy + tmpvar_19);
    tmpvar_20.z = shadowCoord_5.z;
    highp vec4 tmpvar_21;
    tmpvar_21 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_20.xy);
    highp float tmpvar_22;
    if ((tmpvar_21.x < xlv_TEXCOORD4.z)) {
      tmpvar_22 = 0.0;
    } else {
      tmpvar_22 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_22);
    highp vec2 tmpvar_23;
    tmpvar_23.y = 0.0;
    tmpvar_23.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_24;
    tmpvar_24.xy = (shadowCoord_5.xy + tmpvar_23);
    tmpvar_24.z = shadowCoord_5.z;
    highp vec4 tmpvar_25;
    tmpvar_25 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_24.xy);
    highp float tmpvar_26;
    if ((tmpvar_25.x < xlv_TEXCOORD4.z)) {
      tmpvar_26 = 0.0;
    } else {
      tmpvar_26 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_26);
    highp vec4 tmpvar_27;
    tmpvar_27 = texture (TEXTURE_SHADOW_DEPTH, shadowCoord_5.xy);
    highp float tmpvar_28;
    if ((tmpvar_27.x < xlv_TEXCOORD4.z)) {
      tmpvar_28 = 0.0;
    } else {
      tmpvar_28 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_28);
    highp vec2 tmpvar_29;
    tmpvar_29.y = 0.0;
    tmpvar_29.x = tmpvar_11.x;
    highp vec3 tmpvar_30;
    tmpvar_30.xy = (shadowCoord_5.xy + tmpvar_29);
    tmpvar_30.z = shadowCoord_5.z;
    highp vec4 tmpvar_31;
    tmpvar_31 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_30.xy);
    highp float tmpvar_32;
    if ((tmpvar_31.x < xlv_TEXCOORD4.z)) {
      tmpvar_32 = 0.0;
    } else {
      tmpvar_32 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_32);
    highp vec2 tmpvar_33;
    tmpvar_33.x = -(LIGHT_PARAM.z);
    tmpvar_33.y = tmpvar_11.y;
    highp vec3 tmpvar_34;
    tmpvar_34.xy = (shadowCoord_5.xy + tmpvar_33);
    tmpvar_34.z = shadowCoord_5.z;
    highp vec4 tmpvar_35;
    tmpvar_35 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_34.xy);
    highp float tmpvar_36;
    if ((tmpvar_35.x < xlv_TEXCOORD4.z)) {
      tmpvar_36 = 0.0;
    } else {
      tmpvar_36 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_36);
    highp vec2 tmpvar_37;
    tmpvar_37.x = 0.0;
    tmpvar_37.y = tmpvar_11.y;
    highp vec3 tmpvar_38;
    tmpvar_38.xy = (shadowCoord_5.xy + tmpvar_37);
    tmpvar_38.z = shadowCoord_5.z;
    highp vec4 tmpvar_39;
    tmpvar_39 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_38.xy);
    highp float tmpvar_40;
    if ((tmpvar_39.x < xlv_TEXCOORD4.z)) {
      tmpvar_40 = 0.0;
    } else {
      tmpvar_40 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_40);
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (shadowCoord_5.xy + LIGHT_PARAM.zz);
    tmpvar_41.z = shadowCoord_5.z;
    highp vec4 tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41.xy);
    highp float tmpvar_43;
    if ((tmpvar_42.x < xlv_TEXCOORD4.z)) {
      tmpvar_43 = 0.0;
    } else {
      tmpvar_43 = 1.0;
    };
    shadow_10 = (shadow_10 + tmpvar_43);
    shadow_10 = (shadow_10 / 9.0);
    tmpvar_6 = mix (1.0, shadow_10, LIGHT_PARAM.y);
  };
  lowp vec4 tmpvar_44;
  tmpvar_44 = texture (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_44;
  highp vec4 tmpvar_45;
  tmpvar_45.w = 1.0;
  tmpvar_45.xyz = ((dstColor_2.xyz * (1.0 - maskCol_1.w)) + ((dstColor_2.xyz * tmpvar_6) * maskCol_1.w));
  _glesFragData[0] = tmpvar_45;
}

]===],
	},
}


end

function Depth()

	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { DEPTHPASS }

	
Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 LIGHT_PARAM;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = _glesVertex.xyz;
  tmpvar_1 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2));
  highp vec4 clipPos_3;
  clipPos_3.xyw = tmpvar_1.xyw;
  clipPos_3.z = (tmpvar_1.z + (LIGHT_PARAM.x / tmpvar_1.w));
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  gl_Position = (tmpvar_4 * clipPos_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
void main ()
{
  _glesFragData[0] = vec4(0.0, 0.0, 0.0, 1.0);
}

]===],
	},
}

end