function DefineParams()
	Properties = 
	{
		
_MainTex = { "Main Color", TEXTURE2D, "white" },
_MaskTex = { "Mask Color", TEXTURE2D, "white" },
_BlendTex = { "Blend Color", TEXTURE2D, "white" },
_MetallicGlossMap = {"Metallic Gloss", TEXTURE2D, "white"},
_BumpMap = {"Normal Map", TEXTURE2D, "bump"},
_GlossEnvMap = {"Specular IBL Map", TEXTURECUBE, "black"},
_IrradianceMap = {"Diffuse IBL Map",TEXTURECUBE,"black"},
_Smoothness = {"Smoothness", FLOAT, "0.5" },
_Metallic = { "Metallic", FLOAT, "0.5" },
_EmissionColor = {"Emission Color", COLOR, "0.0,0.0,0.0,1.0"},
_EmissionMap = {"Emission Map",TEXTURE2D,"white"},
_Opacity = { "Opacity", FLOAT, "1.0" },

_BlendType = { "BlendType", FLOAT, "1.0" },

_DepthState = {"Depth State", FLOAT, "1.0"},

_DepthFc = {"Depth Test", FLOAT, "1.0"},

_CullMode = {"Cull Mode", FLOAT, "0.0"},

	}
	Attributes = 
	{
		_BlendType = "Enum(Normal,1.0,Add,2.0,Screen,3.0,Overlay,4.0,SoftLight,5.0,Lighten,6.0,Multiply,7.0)", 
		_DepthState = "Enum(DepthMode)", 
		_DepthFc = "Enum(DepthFunc)", 
		_CullMode = "Enum(CullMode)", 
	}
	
end



function Init()
	PassNames = 
	{
		"ForwardBase","Depth"
	}

ShaderName = "StandardPbr"
RenderQueue = "Transparent"
end

function ForwardBase()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { "%_CullMode", DEPTH_MASK_ON, "%_DepthState", "%_DepthFc" }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendType",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)));
  highp vec4 tmpvar_14;
  tmpvar_14.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_14.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_17[1u] = tmpvar_12[1u].xyz;
  tmpvar_17[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_16 * (_glesNormal * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_19[1u] = tmpvar_12[1u].xyz;
  tmpvar_19[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_18 * (_glesTangent * tmpvar_19)));
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_20[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_20[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_21[1u] = tmpvar_12[1u].xyz;
  tmpvar_21[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_20 * (_glesBinormal * tmpvar_21)));
  tmpvar_1.w = tmpvar_15.x;
  tmpvar_2.w = tmpvar_15.y;
  tmpvar_3.w = tmpvar_15.z;
  tmpvar_4.zw = tmpvar_13.zw;
  tmpvar_4.xy = ((tmpvar_13.xy * 0.5) + (0.5 * tmpvar_13.ww));
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD4 = tmpvar_4;
  gl_Position = (tmpvar_14 * tmpvar_13);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _BlendTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _Opacity;
uniform highp float _BlendType;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 srcColor_1;
  highp vec4 dstColor_2;
  highp vec4 maskCol_3;
  highp vec4 outColor_4;
  highp vec3 tmpvar_5;
  mediump float tmpvar_6;
  mediump float tmpvar_7;
  highp vec3 normalWorld_8;
  highp vec3 normalTangent_9;
  highp vec3 emissionMapColor_10;
  highp vec2 mg_11;
  highp vec4 col_12;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture (_MainTex, xlv_TEXCOORD0);
  col_12 = tmpvar_13;
  lowp vec2 tmpvar_14;
  tmpvar_14 = texture (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_11 = tmpvar_14;
  lowp vec3 tmpvar_15;
  tmpvar_15 = texture (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_10 = tmpvar_15;
  lowp vec3 tmpvar_16;
  tmpvar_16 = texture (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_9 = tmpvar_16;
  normalTangent_9 = ((normalTangent_9 * 2.0) - 1.0);
  normalWorld_8 = normalize(((
    (normalTangent_9.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_9.y * xlv_TEXCOORD2.xyz)
  ) + (normalTangent_9.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_17;
  tmpvar_17.x = xlv_TEXCOORD1.w;
  tmpvar_17.y = xlv_TEXCOORD2.w;
  tmpvar_17.z = xlv_TEXCOORD3.w;
  highp vec4 rgbm_18;
  highp vec3 tmpvar_19;
  highp vec3 I_20;
  I_20 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_17)));
  tmpvar_19 = (I_20 - (2.0 * (
    dot (normalWorld_8, I_20)
   * normalWorld_8)));
  highp mat2 tmpvar_21;
  tmpvar_21[uint(0)].x = 1.0;
  tmpvar_21[uint(0)].y = 0.0;
  tmpvar_21[1u].x = -0.0;
  tmpvar_21[1u].y = 1.0;
  highp vec3 tmpvar_22;
  tmpvar_22.xy = (tmpvar_21 * tmpvar_19.xz);
  tmpvar_22.z = tmpvar_19.y;
  highp vec4 tmpvar_23;
  tmpvar_23.xyz = tmpvar_22.xzy;
  tmpvar_23.w = ((1.0 - (mg_11.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_24;
  tmpvar_24 = textureLod (_GlossEnvMap, tmpvar_22.xzy, tmpvar_23.w);
  highp vec4 tmpvar_25;
  tmpvar_25 = tmpvar_24;
  rgbm_18.w = tmpvar_25.w;
  rgbm_18.xyz = ((tmpvar_25.xyz * tmpvar_25.w) * 6.0);
  highp vec4 rgbm_26;
  lowp vec4 tmpvar_27;
  tmpvar_27 = texture (_IrradianceMap, normalWorld_8);
  highp vec4 tmpvar_28;
  tmpvar_28 = tmpvar_27;
  rgbm_26.w = tmpvar_28.w;
  rgbm_26.xyz = ((tmpvar_28.xyz * tmpvar_28.w) * 6.0);
  tmpvar_5 = col_12.xyz;
  tmpvar_6 = (mg_11.x * _Metallic);
  tmpvar_7 = (mg_11.y * _Smoothness);
  highp float tmpvar_29;
  highp vec3 specularEnv_30;
  highp vec3 color_31;
  mediump float surfaceReduction_32;
  highp float perceptualRoughness_33;
  mediump vec3 tmpvar_34;
  mediump vec3 albedo_35;
  albedo_35 = tmpvar_5;
  mediump float tmpvar_36;
  tmpvar_36 = (0.7790837 - (tmpvar_6 * 0.7790837));
  tmpvar_34 = (albedo_35 * tmpvar_36);
  tmpvar_29 = 0.0;
  mediump float alpha_37;
  alpha_37 = tmpvar_29;
  tmpvar_29 = alpha_37;
  mediump float tmpvar_38;
  tmpvar_38 = (1.0 - tmpvar_7);
  perceptualRoughness_33 = tmpvar_38;
  highp float tmpvar_39;
  tmpvar_39 = abs(dot (normalize(
    (CAMERA_WORLDPOSITION - tmpvar_17)
  ), normalWorld_8));
  highp float tmpvar_40;
  tmpvar_40 = max ((perceptualRoughness_33 * perceptualRoughness_33), 0.002);
  surfaceReduction_32 = (1.0 - ((0.28 * tmpvar_40) * perceptualRoughness_33));
  color_31 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_10));
  color_31 = (color_31 + (tmpvar_34 * rgbm_26.xyz));
  mediump float cosA_41;
  cosA_41 = tmpvar_39;
  mediump float tmpvar_42;
  mediump float x_43;
  x_43 = (1.0 - cosA_41);
  tmpvar_42 = ((x_43 * x_43) * ((x_43 * x_43) * x_43));
  mediump vec3 tmpvar_44;
  tmpvar_44 = (surfaceReduction_32 * ((
    ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_6)) + (albedo_35 * tmpvar_6))
   * 
    (1.0 - tmpvar_42)
  ) + (vec3(
    clamp ((tmpvar_7 + (1.0 - tmpvar_36)), 0.0, 1.0)
  ) * tmpvar_42)));
  specularEnv_30 = tmpvar_44;
  color_31 = (color_31 + (specularEnv_30 * rgbm_18.xyz));
  outColor_4.xyz = color_31;
  lowp vec4 tmpvar_45;
  tmpvar_45 = texture (_MaskTex, xlv_TEXCOORD0);
  maskCol_3 = tmpvar_45;
  outColor_4.w = ((col_12.w * maskCol_3.w) * _Opacity);
  highp vec3 tmpvar_46;
  tmpvar_46 = (xlv_TEXCOORD4.xyz / xlv_TEXCOORD4.w);
  highp vec2 tmpvar_47;
  tmpvar_47.x = tmpvar_46.x;
  tmpvar_47.y = (1.0 - tmpvar_46.y);
  lowp vec4 tmpvar_48;
  tmpvar_48 = texture (_BlendTex, tmpvar_47);
  dstColor_2 = tmpvar_48;
  srcColor_1 = outColor_4;
  outColor_4.w = ((col_12.w * maskCol_3.w) * _Opacity);
  highp int mode_49;
  mode_49 = int(_BlendType);
  bool tmpvar_50;
  tmpvar_50 = bool(1);
  highp vec3 tmpvar_51;
  if ((mode_49 == 1)) {
    tmpvar_51 = ((srcColor_1.www * srcColor_1.xyz) + (vec3((1.0 - srcColor_1.w)) * dstColor_2.xyz));
    tmpvar_50 = bool(0);
  } else {
    if ((mode_49 == 2)) {
      tmpvar_51 = ((srcColor_1.wwww * srcColor_1) + dstColor_2).xyz;
      tmpvar_50 = bool(0);
    } else {
      if ((mode_49 == 3)) {
        tmpvar_51 = (((srcColor_1 + 
          ((vec4(1.0, 1.0, 1.0, 1.0) - srcColor_1) * dstColor_2)
        ).xyz * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
        tmpvar_50 = bool(0);
      } else {
        if ((mode_49 == 4)) {
          highp float tmpvar_52;
          if ((dstColor_2.x < 0.5)) {
            tmpvar_52 = ((2.0 * srcColor_1.x) * dstColor_2.x);
          } else {
            tmpvar_52 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.x)
            ) * (1.0 - dstColor_2.x)));
          };
          highp float tmpvar_53;
          if ((dstColor_2.y < 0.5)) {
            tmpvar_53 = ((2.0 * srcColor_1.y) * dstColor_2.y);
          } else {
            tmpvar_53 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.y)
            ) * (1.0 - dstColor_2.y)));
          };
          highp float tmpvar_54;
          if ((dstColor_2.z < 0.5)) {
            tmpvar_54 = ((2.0 * srcColor_1.z) * dstColor_2.z);
          } else {
            tmpvar_54 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.z)
            ) * (1.0 - dstColor_2.z)));
          };
          highp vec3 tmpvar_55;
          tmpvar_55.x = tmpvar_52;
          tmpvar_55.y = tmpvar_53;
          tmpvar_55.z = tmpvar_54;
          tmpvar_51 = ((tmpvar_55 * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
          tmpvar_50 = bool(0);
        } else {
          if ((mode_49 == 5)) {
            highp float tmpvar_56;
            if ((dstColor_2.x < 0.5)) {
              tmpvar_56 = (((2.0 * dstColor_2.x) * srcColor_1.x) + ((dstColor_2.x * dstColor_2.x) * (1.0 - 
                (2.0 * srcColor_1.x)
              )));
            } else {
              tmpvar_56 = (((2.0 * dstColor_2.x) * (1.0 - srcColor_1.x)) + (sqrt(dstColor_2.x) * (
                (2.0 * srcColor_1.x)
               - 1.0)));
            };
            highp float tmpvar_57;
            if ((dstColor_2.y < 0.5)) {
              tmpvar_57 = (((2.0 * dstColor_2.y) * srcColor_1.y) + ((dstColor_2.y * dstColor_2.y) * (1.0 - 
                (2.0 * srcColor_1.y)
              )));
            } else {
              tmpvar_57 = (((2.0 * dstColor_2.y) * (1.0 - srcColor_1.y)) + (sqrt(dstColor_2.y) * (
                (2.0 * srcColor_1.y)
               - 1.0)));
            };
            highp float tmpvar_58;
            if ((dstColor_2.z < 0.5)) {
              tmpvar_58 = (((2.0 * dstColor_2.z) * srcColor_1.z) + ((dstColor_2.z * dstColor_2.z) * (1.0 - 
                (2.0 * srcColor_1.z)
              )));
            } else {
              tmpvar_58 = (((2.0 * dstColor_2.z) * (1.0 - srcColor_1.z)) + (sqrt(dstColor_2.z) * (
                (2.0 * srcColor_1.z)
               - 1.0)));
            };
            highp vec3 tmpvar_59;
            tmpvar_59.x = tmpvar_56;
            tmpvar_59.y = tmpvar_57;
            tmpvar_59.z = tmpvar_58;
            tmpvar_51 = ((tmpvar_59 * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
            tmpvar_50 = bool(0);
          } else {
            if ((mode_49 == 6)) {
              tmpvar_51 = ((max (srcColor_1.xyz, dstColor_2.xyz) * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
              tmpvar_50 = bool(0);
            } else {
              if ((mode_49 == 7)) {
                tmpvar_51 = (((srcColor_1.xyz * dstColor_2.xyz) * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
                tmpvar_50 = bool(0);
              };
            };
          };
        };
      };
    };
  };
  if (tmpvar_50) {
    tmpvar_51 = vec3(1.0, 0.0, 0.0);
    tmpvar_50 = bool(0);
  };
  outColor_4.xyz = tmpvar_51;
  outColor_4.w = 1.0;
  _glesFragData[0] = outColor_4;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendType",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[uint(0)].x = row0_7.x;
  tmpvar_12[uint(0)].y = row0_7.y;
  tmpvar_12[uint(0)].z = row0_7.z;
  tmpvar_12[uint(0)].w = row0_7.w;
  tmpvar_12[1u].x = row1_6.x;
  tmpvar_12[1u].y = row1_6.y;
  tmpvar_12[1u].z = row1_6.z;
  tmpvar_12[1u].w = row1_6.w;
  tmpvar_12[2u].x = row2_5.x;
  tmpvar_12[2u].y = row2_5.y;
  tmpvar_12[2u].z = row2_5.z;
  tmpvar_12[2u].w = row2_5.w;
  tmpvar_12[3u].x = 0.0;
  tmpvar_12[3u].y = 0.0;
  tmpvar_12[3u].z = 0.0;
  tmpvar_12[3u].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)));
  highp vec4 tmpvar_14;
  tmpvar_14.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_14.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_15;
  tmpvar_15 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_16[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_16[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_17[1u] = tmpvar_12[1u].xyz;
  tmpvar_17[2u] = tmpvar_12[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_16 * (_glesNormal * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_18[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_18[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_19[1u] = tmpvar_12[1u].xyz;
  tmpvar_19[2u] = tmpvar_12[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_18 * (_glesTangent * tmpvar_19)));
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_20[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_20[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)] = tmpvar_12[uint(0)].xyz;
  tmpvar_21[1u] = tmpvar_12[1u].xyz;
  tmpvar_21[2u] = tmpvar_12[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_20 * (_glesBinormal * tmpvar_21)));
  tmpvar_1.w = tmpvar_15.x;
  tmpvar_2.w = tmpvar_15.y;
  tmpvar_3.w = tmpvar_15.z;
  tmpvar_4.zw = tmpvar_13.zw;
  tmpvar_4.xy = ((tmpvar_13.xy * 0.5) + (0.5 * tmpvar_13.ww));
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD4 = tmpvar_4;
  gl_Position = (tmpvar_14 * tmpvar_13);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _BlendTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _Opacity;
uniform highp float _BlendType;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 srcColor_1;
  highp vec4 dstColor_2;
  highp vec4 maskCol_3;
  highp vec4 outColor_4;
  highp vec3 tmpvar_5;
  mediump float tmpvar_6;
  mediump float tmpvar_7;
  highp vec3 normalWorld_8;
  highp vec3 normalTangent_9;
  highp vec3 emissionMapColor_10;
  highp vec2 mg_11;
  highp vec4 col_12;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture (_MainTex, xlv_TEXCOORD0);
  col_12 = tmpvar_13;
  lowp vec2 tmpvar_14;
  tmpvar_14 = texture (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_11 = tmpvar_14;
  lowp vec3 tmpvar_15;
  tmpvar_15 = texture (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_10 = tmpvar_15;
  lowp vec3 tmpvar_16;
  tmpvar_16 = texture (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_9 = tmpvar_16;
  normalTangent_9 = ((normalTangent_9 * 2.0) - 1.0);
  normalWorld_8 = normalize(((
    (normalTangent_9.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_9.y * xlv_TEXCOORD2.xyz)
  ) + (normalTangent_9.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_17;
  tmpvar_17.x = xlv_TEXCOORD1.w;
  tmpvar_17.y = xlv_TEXCOORD2.w;
  tmpvar_17.z = xlv_TEXCOORD3.w;
  highp vec4 rgbm_18;
  highp vec3 tmpvar_19;
  highp vec3 I_20;
  I_20 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_17)));
  tmpvar_19 = (I_20 - (2.0 * (
    dot (normalWorld_8, I_20)
   * normalWorld_8)));
  highp mat2 tmpvar_21;
  tmpvar_21[uint(0)].x = 1.0;
  tmpvar_21[uint(0)].y = 0.0;
  tmpvar_21[1u].x = -0.0;
  tmpvar_21[1u].y = 1.0;
  highp vec3 tmpvar_22;
  tmpvar_22.xy = (tmpvar_21 * tmpvar_19.xz);
  tmpvar_22.z = tmpvar_19.y;
  highp vec4 tmpvar_23;
  tmpvar_23.xyz = tmpvar_22.xzy;
  tmpvar_23.w = ((1.0 - (mg_11.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_24;
  tmpvar_24 = textureLod (_GlossEnvMap, tmpvar_22.xzy, tmpvar_23.w);
  highp vec4 tmpvar_25;
  tmpvar_25 = tmpvar_24;
  rgbm_18.w = tmpvar_25.w;
  rgbm_18.xyz = ((tmpvar_25.xyz * tmpvar_25.w) * 6.0);
  highp vec4 rgbm_26;
  lowp vec4 tmpvar_27;
  tmpvar_27 = texture (_IrradianceMap, normalWorld_8);
  highp vec4 tmpvar_28;
  tmpvar_28 = tmpvar_27;
  rgbm_26.w = tmpvar_28.w;
  rgbm_26.xyz = ((tmpvar_28.xyz * tmpvar_28.w) * 6.0);
  tmpvar_5 = col_12.xyz;
  tmpvar_6 = (mg_11.x * _Metallic);
  tmpvar_7 = (mg_11.y * _Smoothness);
  highp vec3 tmpvar_29;
  highp vec3 tmpvar_30;
  tmpvar_29 = normalize((CAMERA_WORLDPOSITION - tmpvar_17));
  tmpvar_30 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_31;
  highp vec3 specularEnv_32;
  highp vec3 color_33;
  mediump float surfaceReduction_34;
  mediump float diffuseTerm_35;
  highp float perceptualRoughness_36;
  mediump vec3 tmpvar_37;
  mediump vec3 albedo_38;
  albedo_38 = tmpvar_5;
  mediump vec3 specColor_39;
  specColor_39 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_6)) + (albedo_38 * tmpvar_6));
  mediump float tmpvar_40;
  tmpvar_40 = (0.7790837 - (tmpvar_6 * 0.7790837));
  tmpvar_37 = (albedo_38 * tmpvar_40);
  tmpvar_31 = 0.0;
  mediump float alpha_41;
  alpha_41 = tmpvar_31;
  tmpvar_31 = alpha_41;
  mediump float tmpvar_42;
  tmpvar_42 = (1.0 - tmpvar_7);
  perceptualRoughness_36 = tmpvar_42;
  highp vec3 tmpvar_43;
  highp vec3 inVec_44;
  inVec_44 = (tmpvar_30 + tmpvar_29);
  tmpvar_43 = (inVec_44 * inversesqrt(max (0.001, 
    dot (inVec_44, inVec_44)
  )));
  highp float tmpvar_45;
  tmpvar_45 = abs(dot (tmpvar_29, normalWorld_8));
  highp float tmpvar_46;
  tmpvar_46 = clamp (dot (normalWorld_8, tmpvar_30), 0.0, 1.0);
  highp float tmpvar_47;
  tmpvar_47 = clamp (dot (normalWorld_8, tmpvar_43), 0.0, 1.0);
  mediump float tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = clamp (dot (tmpvar_30, tmpvar_43), 0.0, 1.0);
  tmpvar_48 = tmpvar_49;
  mediump float tmpvar_50;
  mediump float NdotV_51;
  NdotV_51 = tmpvar_45;
  mediump float NdotL_52;
  NdotL_52 = tmpvar_46;
  mediump float perceptualRoughness_53;
  perceptualRoughness_53 = perceptualRoughness_36;
  mediump float tmpvar_54;
  tmpvar_54 = (0.5 + ((2.0 * tmpvar_48) * (tmpvar_48 * perceptualRoughness_53)));
  mediump float x_55;
  x_55 = (1.0 - NdotL_52);
  mediump float x_56;
  x_56 = (1.0 - NdotV_51);
  tmpvar_50 = ((1.0 + (
    (tmpvar_54 - 1.0)
   * 
    ((x_55 * x_55) * ((x_55 * x_55) * x_55))
  )) * (1.0 + (
    (tmpvar_54 - 1.0)
   * 
    ((x_56 * x_56) * ((x_56 * x_56) * x_56))
  )));
  highp float tmpvar_57;
  tmpvar_57 = (tmpvar_50 * tmpvar_46);
  diffuseTerm_35 = tmpvar_57;
  highp float tmpvar_58;
  tmpvar_58 = max ((perceptualRoughness_36 * perceptualRoughness_36), 0.002);
  highp float tmpvar_59;
  tmpvar_59 = (tmpvar_58 * tmpvar_58);
  highp float tmpvar_60;
  tmpvar_60 = (((
    (tmpvar_47 * tmpvar_59)
   - tmpvar_47) * tmpvar_47) + 1.0);
  surfaceReduction_34 = (1.0 - ((0.28 * tmpvar_58) * perceptualRoughness_36));
  mediump vec3 tmpvar_61;
  mediump float x_62;
  x_62 = (1.0 - tmpvar_48);
  tmpvar_61 = (specColor_39 + ((1.0 - specColor_39) * (
    (x_62 * x_62)
   * 
    ((x_62 * x_62) * x_62)
  )));
  color_33 = (((tmpvar_37 * LIGHT_COLOR) * diffuseTerm_35) + ((
    max (0.0, (sqrt(max (0.0001, 
      ((((0.3183099 * tmpvar_59) / (
        (tmpvar_60 * tmpvar_60)
       + 1e-7)) * (0.5 / (
        ((tmpvar_46 * ((tmpvar_45 * 
          (1.0 - tmpvar_58)
        ) + tmpvar_58)) + (tmpvar_45 * ((tmpvar_46 * 
          (1.0 - tmpvar_58)
        ) + tmpvar_58)))
       + 0.0001))) * 3.141593)
    )) * tmpvar_46))
   * LIGHT_COLOR) * tmpvar_61));
  color_33 = (color_33 + (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_10)));
  color_33 = (color_33 + (tmpvar_37 * rgbm_26.xyz));
  mediump float cosA_63;
  cosA_63 = tmpvar_45;
  mediump float tmpvar_64;
  mediump float x_65;
  x_65 = (1.0 - cosA_63);
  tmpvar_64 = ((x_65 * x_65) * ((x_65 * x_65) * x_65));
  mediump vec3 tmpvar_66;
  tmpvar_66 = (surfaceReduction_34 * ((specColor_39 * 
    (1.0 - tmpvar_64)
  ) + (vec3(
    clamp ((tmpvar_7 + (1.0 - tmpvar_40)), 0.0, 1.0)
  ) * tmpvar_64)));
  specularEnv_32 = tmpvar_66;
  color_33 = (color_33 + (specularEnv_32 * rgbm_18.xyz));
  outColor_4.xyz = color_33;
  lowp vec4 tmpvar_67;
  tmpvar_67 = texture (_MaskTex, xlv_TEXCOORD0);
  maskCol_3 = tmpvar_67;
  outColor_4.w = ((col_12.w * maskCol_3.w) * _Opacity);
  highp vec3 tmpvar_68;
  tmpvar_68 = (xlv_TEXCOORD4.xyz / xlv_TEXCOORD4.w);
  highp vec2 tmpvar_69;
  tmpvar_69.x = tmpvar_68.x;
  tmpvar_69.y = (1.0 - tmpvar_68.y);
  lowp vec4 tmpvar_70;
  tmpvar_70 = texture (_BlendTex, tmpvar_69);
  dstColor_2 = tmpvar_70;
  srcColor_1 = outColor_4;
  outColor_4.w = ((col_12.w * maskCol_3.w) * _Opacity);
  highp int mode_71;
  mode_71 = int(_BlendType);
  bool tmpvar_72;
  tmpvar_72 = bool(1);
  highp vec3 tmpvar_73;
  if ((mode_71 == 1)) {
    tmpvar_73 = ((srcColor_1.www * srcColor_1.xyz) + (vec3((1.0 - srcColor_1.w)) * dstColor_2.xyz));
    tmpvar_72 = bool(0);
  } else {
    if ((mode_71 == 2)) {
      tmpvar_73 = ((srcColor_1.wwww * srcColor_1) + dstColor_2).xyz;
      tmpvar_72 = bool(0);
    } else {
      if ((mode_71 == 3)) {
        tmpvar_73 = (((srcColor_1 + 
          ((vec4(1.0, 1.0, 1.0, 1.0) - srcColor_1) * dstColor_2)
        ).xyz * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
        tmpvar_72 = bool(0);
      } else {
        if ((mode_71 == 4)) {
          highp float tmpvar_74;
          if ((dstColor_2.x < 0.5)) {
            tmpvar_74 = ((2.0 * srcColor_1.x) * dstColor_2.x);
          } else {
            tmpvar_74 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.x)
            ) * (1.0 - dstColor_2.x)));
          };
          highp float tmpvar_75;
          if ((dstColor_2.y < 0.5)) {
            tmpvar_75 = ((2.0 * srcColor_1.y) * dstColor_2.y);
          } else {
            tmpvar_75 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.y)
            ) * (1.0 - dstColor_2.y)));
          };
          highp float tmpvar_76;
          if ((dstColor_2.z < 0.5)) {
            tmpvar_76 = ((2.0 * srcColor_1.z) * dstColor_2.z);
          } else {
            tmpvar_76 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.z)
            ) * (1.0 - dstColor_2.z)));
          };
          highp vec3 tmpvar_77;
          tmpvar_77.x = tmpvar_74;
          tmpvar_77.y = tmpvar_75;
          tmpvar_77.z = tmpvar_76;
          tmpvar_73 = ((tmpvar_77 * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
          tmpvar_72 = bool(0);
        } else {
          if ((mode_71 == 5)) {
            highp float tmpvar_78;
            if ((dstColor_2.x < 0.5)) {
              tmpvar_78 = (((2.0 * dstColor_2.x) * srcColor_1.x) + ((dstColor_2.x * dstColor_2.x) * (1.0 - 
                (2.0 * srcColor_1.x)
              )));
            } else {
              tmpvar_78 = (((2.0 * dstColor_2.x) * (1.0 - srcColor_1.x)) + (sqrt(dstColor_2.x) * (
                (2.0 * srcColor_1.x)
               - 1.0)));
            };
            highp float tmpvar_79;
            if ((dstColor_2.y < 0.5)) {
              tmpvar_79 = (((2.0 * dstColor_2.y) * srcColor_1.y) + ((dstColor_2.y * dstColor_2.y) * (1.0 - 
                (2.0 * srcColor_1.y)
              )));
            } else {
              tmpvar_79 = (((2.0 * dstColor_2.y) * (1.0 - srcColor_1.y)) + (sqrt(dstColor_2.y) * (
                (2.0 * srcColor_1.y)
               - 1.0)));
            };
            highp float tmpvar_80;
            if ((dstColor_2.z < 0.5)) {
              tmpvar_80 = (((2.0 * dstColor_2.z) * srcColor_1.z) + ((dstColor_2.z * dstColor_2.z) * (1.0 - 
                (2.0 * srcColor_1.z)
              )));
            } else {
              tmpvar_80 = (((2.0 * dstColor_2.z) * (1.0 - srcColor_1.z)) + (sqrt(dstColor_2.z) * (
                (2.0 * srcColor_1.z)
               - 1.0)));
            };
            highp vec3 tmpvar_81;
            tmpvar_81.x = tmpvar_78;
            tmpvar_81.y = tmpvar_79;
            tmpvar_81.z = tmpvar_80;
            tmpvar_73 = ((tmpvar_81 * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
            tmpvar_72 = bool(0);
          } else {
            if ((mode_71 == 6)) {
              tmpvar_73 = ((max (srcColor_1.xyz, dstColor_2.xyz) * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
              tmpvar_72 = bool(0);
            } else {
              if ((mode_71 == 7)) {
                tmpvar_73 = (((srcColor_1.xyz * dstColor_2.xyz) * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
                tmpvar_72 = bool(0);
              };
            };
          };
        };
      };
    };
  };
  if (tmpvar_72) {
    tmpvar_73 = vec3(1.0, 0.0, 0.0);
    tmpvar_72 = bool(0);
  };
  outColor_4.xyz = tmpvar_73;
  outColor_4.w = 1.0;
  _glesFragData[0] = outColor_4;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendType",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 row2_6;
  highp vec4 row1_7;
  highp vec4 row0_8;
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_12;
  tmpvar_12 = (int(_glesBlendIndices.w) * 3);
  row0_8 = (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.x);
  row1_7 = (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.x);
  row2_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.x);
  row0_8 = (row0_8 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.y));
  row1_7 = (row1_7 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.y));
  row2_6 = (row2_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.y));
  row0_8 = (row0_8 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.z));
  row1_7 = (row1_7 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.z));
  row2_6 = (row2_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.z));
  row0_8 = (row0_8 + (ANIMATION_MATRIX_ARRAY[tmpvar_12] * _glesBlendWeight.w));
  row1_7 = (row1_7 + (ANIMATION_MATRIX_ARRAY[(tmpvar_12 + 1)] * _glesBlendWeight.w));
  row2_6 = (row2_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_12 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_13;
  tmpvar_13[uint(0)].x = row0_8.x;
  tmpvar_13[uint(0)].y = row0_8.y;
  tmpvar_13[uint(0)].z = row0_8.z;
  tmpvar_13[uint(0)].w = row0_8.w;
  tmpvar_13[1u].x = row1_7.x;
  tmpvar_13[1u].y = row1_7.y;
  tmpvar_13[1u].z = row1_7.z;
  tmpvar_13[1u].w = row1_7.w;
  tmpvar_13[2u].x = row2_6.x;
  tmpvar_13[2u].y = row2_6.y;
  tmpvar_13[2u].z = row2_6.z;
  tmpvar_13[2u].w = row2_6.w;
  tmpvar_13[3u].x = 0.0;
  tmpvar_13[3u].y = 0.0;
  tmpvar_13[3u].z = 0.0;
  tmpvar_13[3u].w = 1.0;
  highp vec4 tmpvar_14;
  tmpvar_14 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_13)));
  highp vec4 tmpvar_15;
  tmpvar_15.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_15.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_16;
  tmpvar_16 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_13)).xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_13[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_13[1u].xyz;
  tmpvar_18[2u] = tmpvar_13[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_17 * (_glesNormal * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_13[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_13[1u].xyz;
  tmpvar_20[2u] = tmpvar_13[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_19 * (_glesTangent * tmpvar_20)));
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_21[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_21[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)] = tmpvar_13[uint(0)].xyz;
  tmpvar_22[1u] = tmpvar_13[1u].xyz;
  tmpvar_22[2u] = tmpvar_13[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_21 * (_glesBinormal * tmpvar_22)));
  tmpvar_1.w = tmpvar_16.x;
  tmpvar_2.w = tmpvar_16.y;
  tmpvar_3.w = tmpvar_16.z;
  tmpvar_4.zw = tmpvar_14.zw;
  tmpvar_4.xy = ((tmpvar_14.xy * 0.5) + (0.5 * tmpvar_14.ww));
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_13)))
  ).xyz * 0.5) + 0.5);
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_13)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD4 = tmpvar_4;
  gl_Position = (tmpvar_15 * tmpvar_14);
  xlv_TEXCOORD5 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _BlendTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _Opacity;
uniform highp float _BlendType;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
in highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 srcColor_1;
  highp vec4 dstColor_2;
  highp vec4 maskCol_3;
  highp vec4 outColor_4;
  highp vec3 tmpvar_5;
  mediump float tmpvar_6;
  mediump float tmpvar_7;
  highp vec3 tmpvar_8;
  highp vec3 normalWorld_9;
  highp vec3 normalTangent_10;
  highp vec3 emissionMapColor_11;
  highp vec2 mg_12;
  highp vec4 col_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture (_MainTex, xlv_TEXCOORD0);
  col_13 = tmpvar_14;
  lowp vec2 tmpvar_15;
  tmpvar_15 = texture (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_12 = tmpvar_15;
  lowp vec3 tmpvar_16;
  tmpvar_16 = texture (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_11 = tmpvar_16;
  lowp vec3 tmpvar_17;
  tmpvar_17 = texture (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_10 = tmpvar_17;
  normalTangent_10 = ((normalTangent_10 * 2.0) - 1.0);
  normalWorld_9 = normalize(((
    (normalTangent_10.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_10.y * xlv_TEXCOORD2.xyz)
  ) + (normalTangent_10.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_18;
  tmpvar_18.x = xlv_TEXCOORD1.w;
  tmpvar_18.y = xlv_TEXCOORD2.w;
  tmpvar_18.z = xlv_TEXCOORD3.w;
  highp vec4 rgbm_19;
  highp vec3 tmpvar_20;
  highp vec3 I_21;
  I_21 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_18)));
  tmpvar_20 = (I_21 - (2.0 * (
    dot (normalWorld_9, I_21)
   * normalWorld_9)));
  highp mat2 tmpvar_22;
  tmpvar_22[uint(0)].x = 1.0;
  tmpvar_22[uint(0)].y = 0.0;
  tmpvar_22[1u].x = -0.0;
  tmpvar_22[1u].y = 1.0;
  highp vec3 tmpvar_23;
  tmpvar_23.xy = (tmpvar_22 * tmpvar_20.xz);
  tmpvar_23.z = tmpvar_20.y;
  highp vec4 tmpvar_24;
  tmpvar_24.xyz = tmpvar_23.xzy;
  tmpvar_24.w = ((1.0 - (mg_12.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_25;
  tmpvar_25 = textureLod (_GlossEnvMap, tmpvar_23.xzy, tmpvar_24.w);
  highp vec4 tmpvar_26;
  tmpvar_26 = tmpvar_25;
  rgbm_19.w = tmpvar_26.w;
  rgbm_19.xyz = ((tmpvar_26.xyz * tmpvar_26.w) * 6.0);
  highp vec4 rgbm_27;
  lowp vec4 tmpvar_28;
  tmpvar_28 = texture (_IrradianceMap, normalWorld_9);
  highp vec4 tmpvar_29;
  tmpvar_29 = tmpvar_28;
  rgbm_27.w = tmpvar_29.w;
  rgbm_27.xyz = ((tmpvar_29.xyz * tmpvar_29.w) * 6.0);
  tmpvar_5 = col_13.xyz;
  tmpvar_6 = (mg_12.x * _Metallic);
  tmpvar_7 = (mg_12.y * _Smoothness);
  tmpvar_8 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_11));
  highp vec4 shadowCoord_30;
  shadowCoord_30 = xlv_TEXCOORD5;
  highp float tmpvar_31;
  if ((xlv_TEXCOORD5.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_31 = 1.0;
  } else {
    shadowCoord_30.y = (1.0 - xlv_TEXCOORD5.y);
    highp vec2 fetchesOffsetsV_32;
    highp vec2 fetchesOffsetsU_33;
    highp float shadow_34;
    highp vec2 tmpvar_35;
    tmpvar_35 = (shadowCoord_30.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_36;
    tmpvar_36 = floor((tmpvar_35 + 0.5));
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_35 - tmpvar_36);
    highp vec4 computedWeight_38;
    highp vec4 computedArea_39;
    highp vec4 computedAreaUncut_40;
    highp float tmpvar_41;
    tmpvar_41 = (((tmpvar_37.x + 0.5) * (tmpvar_37.x + 0.5)) * 0.5);
    highp float tmpvar_42;
    tmpvar_42 = (tmpvar_41 - tmpvar_37.x);
    computedArea_39.x = tmpvar_42;
    computedAreaUncut_40.x = tmpvar_42;
    computedArea_39.w = tmpvar_41;
    computedAreaUncut_40.w = tmpvar_41;
    computedAreaUncut_40.y = ((1.5 - tmpvar_37.x) - 0.5);
    highp float tmpvar_43;
    tmpvar_43 = min (tmpvar_37.x, 0.0);
    computedArea_39.y = (computedAreaUncut_40.y - (tmpvar_43 * tmpvar_43));
    computedAreaUncut_40.z = ((1.5 + tmpvar_37.x) - 0.5);
    highp float tmpvar_44;
    tmpvar_44 = max (tmpvar_37.x, 0.0);
    computedArea_39.z = (computedAreaUncut_40.z - (tmpvar_44 * tmpvar_44));
    computedWeight_38 = (computedArea_39 * 0.44444);
    highp vec4 computedWeight_45;
    highp vec4 computedArea_46;
    highp vec4 computedAreaUncut_47;
    highp float tmpvar_48;
    tmpvar_48 = (((tmpvar_37.y + 0.5) * (tmpvar_37.y + 0.5)) * 0.5);
    highp float tmpvar_49;
    tmpvar_49 = (tmpvar_48 - tmpvar_37.y);
    computedArea_46.x = tmpvar_49;
    computedAreaUncut_47.x = tmpvar_49;
    computedArea_46.w = tmpvar_48;
    computedAreaUncut_47.w = tmpvar_48;
    computedAreaUncut_47.y = ((1.5 - tmpvar_37.y) - 0.5);
    highp float tmpvar_50;
    tmpvar_50 = min (tmpvar_37.y, 0.0);
    computedArea_46.y = (computedAreaUncut_47.y - (tmpvar_50 * tmpvar_50));
    computedAreaUncut_47.z = ((1.5 + tmpvar_37.y) - 0.5);
    highp float tmpvar_51;
    tmpvar_51 = max (tmpvar_37.y, 0.0);
    computedArea_46.z = (computedAreaUncut_47.z - (tmpvar_51 * tmpvar_51));
    computedWeight_45 = (computedArea_46 * 0.44444);
    highp vec2 tmpvar_52;
    tmpvar_52 = (computedWeight_38.xz + computedWeight_38.yw);
    highp vec2 tmpvar_53;
    tmpvar_53 = (computedWeight_45.xz + computedWeight_45.yw);
    fetchesOffsetsU_33 = (((computedWeight_38.yw / tmpvar_52) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_32 = (((computedWeight_45.yw / tmpvar_53) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_54;
    tmpvar_54 = (tmpvar_36 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_33.x;
    tmpvar_55.y = fetchesOffsetsV_32.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_54 + tmpvar_55);
    tmpvar_56.z = shadowCoord_30.z;
    mediump float tmpvar_57;
    tmpvar_57 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_34 = ((tmpvar_52.x * tmpvar_53.x) * tmpvar_57);
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_33.y;
    tmpvar_58.y = fetchesOffsetsV_32.x;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_54 + tmpvar_58);
    tmpvar_59.z = shadowCoord_30.z;
    mediump float tmpvar_60;
    tmpvar_60 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_34 = (shadow_34 + ((tmpvar_52.y * tmpvar_53.x) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_33.x;
    tmpvar_61.y = fetchesOffsetsV_32.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_54 + tmpvar_61);
    tmpvar_62.z = shadowCoord_30.z;
    mediump float tmpvar_63;
    tmpvar_63 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_34 = (shadow_34 + ((tmpvar_52.x * tmpvar_53.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_33.y;
    tmpvar_64.y = fetchesOffsetsV_32.y;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_54 + tmpvar_64);
    tmpvar_65.z = shadowCoord_30.z;
    mediump float tmpvar_66;
    tmpvar_66 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_34 = (shadow_34 + ((tmpvar_52.y * tmpvar_53.y) * tmpvar_66));
    tmpvar_31 = mix (1.0, shadow_34, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_67;
  highp vec3 tmpvar_68;
  tmpvar_67 = normalize((CAMERA_WORLDPOSITION - tmpvar_18));
  tmpvar_68 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_69;
  highp vec3 specularEnv_70;
  highp vec3 color_71;
  mediump float surfaceReduction_72;
  mediump float diffuseTerm_73;
  highp float perceptualRoughness_74;
  mediump vec3 tmpvar_75;
  mediump vec3 albedo_76;
  albedo_76 = tmpvar_5;
  mediump vec3 specColor_77;
  specColor_77 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_6)) + (albedo_76 * tmpvar_6));
  mediump float tmpvar_78;
  tmpvar_78 = (0.7790837 - (tmpvar_6 * 0.7790837));
  tmpvar_75 = (albedo_76 * tmpvar_78);
  tmpvar_69 = 0.0;
  mediump float alpha_79;
  alpha_79 = tmpvar_69;
  tmpvar_69 = alpha_79;
  mediump float tmpvar_80;
  tmpvar_80 = (1.0 - tmpvar_7);
  perceptualRoughness_74 = tmpvar_80;
  highp vec3 tmpvar_81;
  highp vec3 inVec_82;
  inVec_82 = (tmpvar_68 + tmpvar_67);
  tmpvar_81 = (inVec_82 * inversesqrt(max (0.001, 
    dot (inVec_82, inVec_82)
  )));
  highp float tmpvar_83;
  tmpvar_83 = abs(dot (tmpvar_67, normalWorld_9));
  highp float tmpvar_84;
  tmpvar_84 = clamp (dot (normalWorld_9, tmpvar_68), 0.0, 1.0);
  highp float tmpvar_85;
  tmpvar_85 = clamp (dot (normalWorld_9, tmpvar_81), 0.0, 1.0);
  mediump float tmpvar_86;
  highp float tmpvar_87;
  tmpvar_87 = clamp (dot (tmpvar_68, tmpvar_81), 0.0, 1.0);
  tmpvar_86 = tmpvar_87;
  mediump float tmpvar_88;
  mediump float NdotV_89;
  NdotV_89 = tmpvar_83;
  mediump float NdotL_90;
  NdotL_90 = tmpvar_84;
  mediump float perceptualRoughness_91;
  perceptualRoughness_91 = perceptualRoughness_74;
  mediump float tmpvar_92;
  tmpvar_92 = (0.5 + ((2.0 * tmpvar_86) * (tmpvar_86 * perceptualRoughness_91)));
  mediump float x_93;
  x_93 = (1.0 - NdotL_90);
  mediump float x_94;
  x_94 = (1.0 - NdotV_89);
  tmpvar_88 = ((1.0 + (
    (tmpvar_92 - 1.0)
   * 
    ((x_93 * x_93) * ((x_93 * x_93) * x_93))
  )) * (1.0 + (
    (tmpvar_92 - 1.0)
   * 
    ((x_94 * x_94) * ((x_94 * x_94) * x_94))
  )));
  highp float tmpvar_95;
  tmpvar_95 = (tmpvar_88 * tmpvar_84);
  diffuseTerm_73 = tmpvar_95;
  highp float tmpvar_96;
  tmpvar_96 = max ((perceptualRoughness_74 * perceptualRoughness_74), 0.002);
  highp float tmpvar_97;
  tmpvar_97 = (tmpvar_96 * tmpvar_96);
  highp float tmpvar_98;
  tmpvar_98 = (((
    (tmpvar_85 * tmpvar_97)
   - tmpvar_85) * tmpvar_85) + 1.0);
  surfaceReduction_72 = (1.0 - ((0.28 * tmpvar_96) * perceptualRoughness_74));
  mediump vec3 tmpvar_99;
  mediump float x_100;
  x_100 = (1.0 - tmpvar_86);
  tmpvar_99 = (specColor_77 + ((1.0 - specColor_77) * (
    (x_100 * x_100)
   * 
    ((x_100 * x_100) * x_100)
  )));
  color_71 = (((
    (tmpvar_75 * LIGHT_COLOR)
   * diffuseTerm_73) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_97)
       / 
        ((tmpvar_98 * tmpvar_98) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_84 * (
          (tmpvar_83 * (1.0 - tmpvar_96))
         + tmpvar_96)) + (tmpvar_83 * (
          (tmpvar_84 * (1.0 - tmpvar_96))
         + tmpvar_96))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_84)) * LIGHT_COLOR)
   * tmpvar_99)) * tmpvar_31);
  color_71 = (color_71 + tmpvar_8);
  color_71 = (color_71 + (tmpvar_75 * rgbm_27.xyz));
  mediump float cosA_101;
  cosA_101 = tmpvar_83;
  mediump float tmpvar_102;
  mediump float x_103;
  x_103 = (1.0 - cosA_101);
  tmpvar_102 = ((x_103 * x_103) * ((x_103 * x_103) * x_103));
  mediump vec3 tmpvar_104;
  tmpvar_104 = (surfaceReduction_72 * ((specColor_77 * 
    (1.0 - tmpvar_102)
  ) + (vec3(
    clamp ((tmpvar_7 + (1.0 - tmpvar_78)), 0.0, 1.0)
  ) * tmpvar_102)));
  specularEnv_70 = tmpvar_104;
  color_71 = (color_71 + (specularEnv_70 * rgbm_19.xyz));
  outColor_4.xyz = color_71;
  lowp vec4 tmpvar_105;
  tmpvar_105 = texture (_MaskTex, xlv_TEXCOORD0);
  maskCol_3 = tmpvar_105;
  outColor_4.w = ((col_13.w * maskCol_3.w) * _Opacity);
  highp vec3 tmpvar_106;
  tmpvar_106 = (xlv_TEXCOORD4.xyz / xlv_TEXCOORD4.w);
  highp vec2 tmpvar_107;
  tmpvar_107.x = tmpvar_106.x;
  tmpvar_107.y = (1.0 - tmpvar_106.y);
  lowp vec4 tmpvar_108;
  tmpvar_108 = texture (_BlendTex, tmpvar_107);
  dstColor_2 = tmpvar_108;
  srcColor_1 = outColor_4;
  outColor_4.w = ((col_13.w * maskCol_3.w) * _Opacity);
  highp int mode_109;
  mode_109 = int(_BlendType);
  bool tmpvar_110;
  tmpvar_110 = bool(1);
  highp vec3 tmpvar_111;
  if ((mode_109 == 1)) {
    tmpvar_111 = ((srcColor_1.www * srcColor_1.xyz) + (vec3((1.0 - srcColor_1.w)) * dstColor_2.xyz));
    tmpvar_110 = bool(0);
  } else {
    if ((mode_109 == 2)) {
      tmpvar_111 = ((srcColor_1.wwww * srcColor_1) + dstColor_2).xyz;
      tmpvar_110 = bool(0);
    } else {
      if ((mode_109 == 3)) {
        tmpvar_111 = (((srcColor_1 + 
          ((vec4(1.0, 1.0, 1.0, 1.0) - srcColor_1) * dstColor_2)
        ).xyz * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
        tmpvar_110 = bool(0);
      } else {
        if ((mode_109 == 4)) {
          highp float tmpvar_112;
          if ((dstColor_2.x < 0.5)) {
            tmpvar_112 = ((2.0 * srcColor_1.x) * dstColor_2.x);
          } else {
            tmpvar_112 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.x)
            ) * (1.0 - dstColor_2.x)));
          };
          highp float tmpvar_113;
          if ((dstColor_2.y < 0.5)) {
            tmpvar_113 = ((2.0 * srcColor_1.y) * dstColor_2.y);
          } else {
            tmpvar_113 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.y)
            ) * (1.0 - dstColor_2.y)));
          };
          highp float tmpvar_114;
          if ((dstColor_2.z < 0.5)) {
            tmpvar_114 = ((2.0 * srcColor_1.z) * dstColor_2.z);
          } else {
            tmpvar_114 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.z)
            ) * (1.0 - dstColor_2.z)));
          };
          highp vec3 tmpvar_115;
          tmpvar_115.x = tmpvar_112;
          tmpvar_115.y = tmpvar_113;
          tmpvar_115.z = tmpvar_114;
          tmpvar_111 = ((tmpvar_115 * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
          tmpvar_110 = bool(0);
        } else {
          if ((mode_109 == 5)) {
            highp float tmpvar_116;
            if ((dstColor_2.x < 0.5)) {
              tmpvar_116 = (((2.0 * dstColor_2.x) * srcColor_1.x) + ((dstColor_2.x * dstColor_2.x) * (1.0 - 
                (2.0 * srcColor_1.x)
              )));
            } else {
              tmpvar_116 = (((2.0 * dstColor_2.x) * (1.0 - srcColor_1.x)) + (sqrt(dstColor_2.x) * (
                (2.0 * srcColor_1.x)
               - 1.0)));
            };
            highp float tmpvar_117;
            if ((dstColor_2.y < 0.5)) {
              tmpvar_117 = (((2.0 * dstColor_2.y) * srcColor_1.y) + ((dstColor_2.y * dstColor_2.y) * (1.0 - 
                (2.0 * srcColor_1.y)
              )));
            } else {
              tmpvar_117 = (((2.0 * dstColor_2.y) * (1.0 - srcColor_1.y)) + (sqrt(dstColor_2.y) * (
                (2.0 * srcColor_1.y)
               - 1.0)));
            };
            highp float tmpvar_118;
            if ((dstColor_2.z < 0.5)) {
              tmpvar_118 = (((2.0 * dstColor_2.z) * srcColor_1.z) + ((dstColor_2.z * dstColor_2.z) * (1.0 - 
                (2.0 * srcColor_1.z)
              )));
            } else {
              tmpvar_118 = (((2.0 * dstColor_2.z) * (1.0 - srcColor_1.z)) + (sqrt(dstColor_2.z) * (
                (2.0 * srcColor_1.z)
               - 1.0)));
            };
            highp vec3 tmpvar_119;
            tmpvar_119.x = tmpvar_116;
            tmpvar_119.y = tmpvar_117;
            tmpvar_119.z = tmpvar_118;
            tmpvar_111 = ((tmpvar_119 * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
            tmpvar_110 = bool(0);
          } else {
            if ((mode_109 == 6)) {
              tmpvar_111 = ((max (srcColor_1.xyz, dstColor_2.xyz) * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
              tmpvar_110 = bool(0);
            } else {
              if ((mode_109 == 7)) {
                tmpvar_111 = (((srcColor_1.xyz * dstColor_2.xyz) * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
                tmpvar_110 = bool(0);
              };
            };
          };
        };
      };
    };
  };
  if (tmpvar_110) {
    tmpvar_111 = vec3(1.0, 0.0, 0.0);
    tmpvar_110 = bool(0);
  };
  outColor_4.xyz = tmpvar_111;
  outColor_4.w = 1.0;
  _glesFragData[0] = outColor_4;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendType",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 row2_6;
  highp vec4 row1_7;
  highp vec4 row0_8;
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_12;
  tmpvar_12 = (int(_glesBlendIndices.w) * 3);
  row0_8 = (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.x);
  row1_7 = (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.x);
  row2_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.x);
  row0_8 = (row0_8 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.y));
  row1_7 = (row1_7 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.y));
  row2_6 = (row2_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.y));
  row0_8 = (row0_8 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.z));
  row1_7 = (row1_7 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.z));
  row2_6 = (row2_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.z));
  row0_8 = (row0_8 + (ANIMATION_MATRIX_ARRAY[tmpvar_12] * _glesBlendWeight.w));
  row1_7 = (row1_7 + (ANIMATION_MATRIX_ARRAY[(tmpvar_12 + 1)] * _glesBlendWeight.w));
  row2_6 = (row2_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_12 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_13;
  tmpvar_13[uint(0)].x = row0_8.x;
  tmpvar_13[uint(0)].y = row0_8.y;
  tmpvar_13[uint(0)].z = row0_8.z;
  tmpvar_13[uint(0)].w = row0_8.w;
  tmpvar_13[1u].x = row1_7.x;
  tmpvar_13[1u].y = row1_7.y;
  tmpvar_13[1u].z = row1_7.z;
  tmpvar_13[1u].w = row1_7.w;
  tmpvar_13[2u].x = row2_6.x;
  tmpvar_13[2u].y = row2_6.y;
  tmpvar_13[2u].z = row2_6.z;
  tmpvar_13[2u].w = row2_6.w;
  tmpvar_13[3u].x = 0.0;
  tmpvar_13[3u].y = 0.0;
  tmpvar_13[3u].z = 0.0;
  tmpvar_13[3u].w = 1.0;
  highp vec4 tmpvar_14;
  tmpvar_14 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_13)));
  highp vec4 tmpvar_15;
  tmpvar_15.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_15.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_16;
  tmpvar_16 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_13)).xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_13[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_13[1u].xyz;
  tmpvar_18[2u] = tmpvar_13[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_17 * (_glesNormal * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_13[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_13[1u].xyz;
  tmpvar_20[2u] = tmpvar_13[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_19 * (_glesTangent * tmpvar_20)));
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_21[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_21[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)] = tmpvar_13[uint(0)].xyz;
  tmpvar_22[1u] = tmpvar_13[1u].xyz;
  tmpvar_22[2u] = tmpvar_13[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_21 * (_glesBinormal * tmpvar_22)));
  tmpvar_1.w = tmpvar_16.x;
  tmpvar_2.w = tmpvar_16.y;
  tmpvar_3.w = tmpvar_16.z;
  tmpvar_4.zw = tmpvar_14.zw;
  tmpvar_4.xy = ((tmpvar_14.xy * 0.5) + (0.5 * tmpvar_14.ww));
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_13)))
  ).xyz * 0.5) + 0.5);
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_13)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD4 = tmpvar_4;
  gl_Position = (tmpvar_15 * tmpvar_14);
  xlv_TEXCOORD5 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _BlendTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _Opacity;
uniform highp float _BlendType;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
in highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 srcColor_1;
  highp vec4 dstColor_2;
  highp vec4 maskCol_3;
  highp vec4 outColor_4;
  highp vec3 tmpvar_5;
  mediump float tmpvar_6;
  mediump float tmpvar_7;
  highp vec3 tmpvar_8;
  highp vec3 normalWorld_9;
  highp vec3 normalTangent_10;
  highp vec3 emissionMapColor_11;
  highp vec2 mg_12;
  highp vec4 col_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture (_MainTex, xlv_TEXCOORD0);
  col_13 = tmpvar_14;
  lowp vec2 tmpvar_15;
  tmpvar_15 = texture (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_12 = tmpvar_15;
  lowp vec3 tmpvar_16;
  tmpvar_16 = texture (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_11 = tmpvar_16;
  lowp vec3 tmpvar_17;
  tmpvar_17 = texture (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_10 = tmpvar_17;
  normalTangent_10 = ((normalTangent_10 * 2.0) - 1.0);
  normalWorld_9 = normalize(((
    (normalTangent_10.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_10.y * xlv_TEXCOORD2.xyz)
  ) + (normalTangent_10.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_18;
  tmpvar_18.x = xlv_TEXCOORD1.w;
  tmpvar_18.y = xlv_TEXCOORD2.w;
  tmpvar_18.z = xlv_TEXCOORD3.w;
  highp vec4 rgbm_19;
  highp vec3 tmpvar_20;
  highp vec3 I_21;
  I_21 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_18)));
  tmpvar_20 = (I_21 - (2.0 * (
    dot (normalWorld_9, I_21)
   * normalWorld_9)));
  highp mat2 tmpvar_22;
  tmpvar_22[uint(0)].x = 1.0;
  tmpvar_22[uint(0)].y = 0.0;
  tmpvar_22[1u].x = -0.0;
  tmpvar_22[1u].y = 1.0;
  highp vec3 tmpvar_23;
  tmpvar_23.xy = (tmpvar_22 * tmpvar_20.xz);
  tmpvar_23.z = tmpvar_20.y;
  highp vec4 tmpvar_24;
  tmpvar_24.xyz = tmpvar_23.xzy;
  tmpvar_24.w = ((1.0 - (mg_12.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_25;
  tmpvar_25 = textureLod (_GlossEnvMap, tmpvar_23.xzy, tmpvar_24.w);
  highp vec4 tmpvar_26;
  tmpvar_26 = tmpvar_25;
  rgbm_19.w = tmpvar_26.w;
  rgbm_19.xyz = ((tmpvar_26.xyz * tmpvar_26.w) * 6.0);
  highp vec4 rgbm_27;
  lowp vec4 tmpvar_28;
  tmpvar_28 = texture (_IrradianceMap, normalWorld_9);
  highp vec4 tmpvar_29;
  tmpvar_29 = tmpvar_28;
  rgbm_27.w = tmpvar_29.w;
  rgbm_27.xyz = ((tmpvar_29.xyz * tmpvar_29.w) * 6.0);
  tmpvar_5 = col_13.xyz;
  tmpvar_6 = (mg_12.x * _Metallic);
  tmpvar_7 = (mg_12.y * _Smoothness);
  tmpvar_8 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_11));
  highp vec4 shadowCoord_30;
  shadowCoord_30 = xlv_TEXCOORD5;
  highp float tmpvar_31;
  if ((xlv_TEXCOORD5.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_31 = 1.0;
  } else {
    shadowCoord_30.y = (1.0 - xlv_TEXCOORD5.y);
    highp vec3 fetchesOffsetsV_32;
    highp vec3 fetchesOffsetsU_33;
    highp float shadow_34;
    highp vec2 tmpvar_35;
    tmpvar_35 = (shadowCoord_30.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_36;
    tmpvar_36 = floor((tmpvar_35 + 0.5));
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_35 - tmpvar_36);
    highp vec3 texelsWeightsA_38;
    highp vec3 texelsWeightsB_39;
    highp vec4 computedArea_40;
    highp vec4 computedAreaUncut_41;
    highp float tmpvar_42;
    tmpvar_42 = (((tmpvar_37.x + 0.5) * (tmpvar_37.x + 0.5)) * 0.5);
    highp float tmpvar_43;
    tmpvar_43 = (tmpvar_42 - tmpvar_37.x);
    computedArea_40.x = tmpvar_43;
    computedAreaUncut_41.x = tmpvar_43;
    computedArea_40.w = tmpvar_42;
    computedAreaUncut_41.w = tmpvar_42;
    computedAreaUncut_41.y = ((1.5 - tmpvar_37.x) - 0.5);
    highp float tmpvar_44;
    tmpvar_44 = min (tmpvar_37.x, 0.0);
    computedArea_40.y = (computedAreaUncut_41.y - (tmpvar_44 * tmpvar_44));
    computedAreaUncut_41.z = ((1.5 + tmpvar_37.x) - 0.5);
    highp float tmpvar_45;
    tmpvar_45 = max (tmpvar_37.x, 0.0);
    computedArea_40.z = (computedAreaUncut_41.z - (tmpvar_45 * tmpvar_45));
    texelsWeightsA_38.x = (0.16 * tmpvar_43);
    texelsWeightsA_38.y = (0.16 * computedAreaUncut_41.y);
    texelsWeightsA_38.z = (0.16 * (computedArea_40.y + 1.0));
    texelsWeightsB_39.x = (0.16 * (computedArea_40.z + 1.0));
    texelsWeightsB_39.y = (0.16 * computedAreaUncut_41.z);
    texelsWeightsB_39.z = (0.16 * tmpvar_42);
    highp vec3 texelsWeightsA_46;
    highp vec3 texelsWeightsB_47;
    highp vec4 computedArea_48;
    highp vec4 computedAreaUncut_49;
    highp float tmpvar_50;
    tmpvar_50 = (((tmpvar_37.y + 0.5) * (tmpvar_37.y + 0.5)) * 0.5);
    highp float tmpvar_51;
    tmpvar_51 = (tmpvar_50 - tmpvar_37.y);
    computedArea_48.x = tmpvar_51;
    computedAreaUncut_49.x = tmpvar_51;
    computedArea_48.w = tmpvar_50;
    computedAreaUncut_49.w = tmpvar_50;
    computedAreaUncut_49.y = ((1.5 - tmpvar_37.y) - 0.5);
    highp float tmpvar_52;
    tmpvar_52 = min (tmpvar_37.y, 0.0);
    computedArea_48.y = (computedAreaUncut_49.y - (tmpvar_52 * tmpvar_52));
    computedAreaUncut_49.z = ((1.5 + tmpvar_37.y) - 0.5);
    highp float tmpvar_53;
    tmpvar_53 = max (tmpvar_37.y, 0.0);
    computedArea_48.z = (computedAreaUncut_49.z - (tmpvar_53 * tmpvar_53));
    texelsWeightsA_46.x = (0.16 * tmpvar_51);
    texelsWeightsA_46.y = (0.16 * computedAreaUncut_49.y);
    texelsWeightsA_46.z = (0.16 * (computedArea_48.y + 1.0));
    texelsWeightsB_47.x = (0.16 * (computedArea_48.z + 1.0));
    texelsWeightsB_47.y = (0.16 * computedAreaUncut_49.z);
    texelsWeightsB_47.z = (0.16 * tmpvar_50);
    highp vec3 tmpvar_54;
    tmpvar_54.xy = texelsWeightsA_38.xz;
    tmpvar_54.z = texelsWeightsB_39.y;
    highp vec3 tmpvar_55;
    tmpvar_55.x = texelsWeightsA_38.y;
    tmpvar_55.yz = texelsWeightsB_39.xz;
    highp vec3 tmpvar_56;
    tmpvar_56 = (tmpvar_54 + tmpvar_55);
    highp vec3 tmpvar_57;
    tmpvar_57.xy = texelsWeightsA_46.xz;
    tmpvar_57.z = texelsWeightsB_47.y;
    highp vec3 tmpvar_58;
    tmpvar_58.x = texelsWeightsA_46.y;
    tmpvar_58.yz = texelsWeightsB_47.xz;
    highp vec3 tmpvar_59;
    tmpvar_59 = (tmpvar_57 + tmpvar_58);
    highp vec3 tmpvar_60;
    tmpvar_60.x = texelsWeightsA_38.y;
    tmpvar_60.yz = texelsWeightsB_39.xz;
    highp vec3 tmpvar_61;
    tmpvar_61.x = texelsWeightsA_46.y;
    tmpvar_61.yz = texelsWeightsB_47.xz;
    fetchesOffsetsU_33 = (((tmpvar_60 / tmpvar_56) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_32 = (((tmpvar_61 / tmpvar_59) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_62;
    tmpvar_62 = (tmpvar_36 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_63;
    tmpvar_63.x = fetchesOffsetsU_33.x;
    tmpvar_63.y = fetchesOffsetsV_32.x;
    highp vec3 tmpvar_64;
    tmpvar_64.xy = (tmpvar_62 + tmpvar_63);
    tmpvar_64.z = shadowCoord_30.z;
    mediump float tmpvar_65;
    tmpvar_65 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_64);
    shadow_34 = ((tmpvar_56.x * tmpvar_59.x) * tmpvar_65);
    highp vec2 tmpvar_66;
    tmpvar_66.x = fetchesOffsetsU_33.y;
    tmpvar_66.y = fetchesOffsetsV_32.x;
    highp vec3 tmpvar_67;
    tmpvar_67.xy = (tmpvar_62 + tmpvar_66);
    tmpvar_67.z = shadowCoord_30.z;
    mediump float tmpvar_68;
    tmpvar_68 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_67);
    shadow_34 = (shadow_34 + ((tmpvar_56.y * tmpvar_59.x) * tmpvar_68));
    highp vec2 tmpvar_69;
    tmpvar_69.x = fetchesOffsetsU_33.z;
    tmpvar_69.y = fetchesOffsetsV_32.x;
    highp vec3 tmpvar_70;
    tmpvar_70.xy = (tmpvar_62 + tmpvar_69);
    tmpvar_70.z = shadowCoord_30.z;
    mediump float tmpvar_71;
    tmpvar_71 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_70);
    shadow_34 = (shadow_34 + ((tmpvar_56.z * tmpvar_59.x) * tmpvar_71));
    highp vec2 tmpvar_72;
    tmpvar_72.x = fetchesOffsetsU_33.x;
    tmpvar_72.y = fetchesOffsetsV_32.y;
    highp vec3 tmpvar_73;
    tmpvar_73.xy = (tmpvar_62 + tmpvar_72);
    tmpvar_73.z = shadowCoord_30.z;
    mediump float tmpvar_74;
    tmpvar_74 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_73);
    shadow_34 = (shadow_34 + ((tmpvar_56.x * tmpvar_59.y) * tmpvar_74));
    highp vec2 tmpvar_75;
    tmpvar_75.x = fetchesOffsetsU_33.y;
    tmpvar_75.y = fetchesOffsetsV_32.y;
    highp vec3 tmpvar_76;
    tmpvar_76.xy = (tmpvar_62 + tmpvar_75);
    tmpvar_76.z = shadowCoord_30.z;
    mediump float tmpvar_77;
    tmpvar_77 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_76);
    shadow_34 = (shadow_34 + ((tmpvar_56.y * tmpvar_59.y) * tmpvar_77));
    highp vec2 tmpvar_78;
    tmpvar_78.x = fetchesOffsetsU_33.z;
    tmpvar_78.y = fetchesOffsetsV_32.y;
    highp vec3 tmpvar_79;
    tmpvar_79.xy = (tmpvar_62 + tmpvar_78);
    tmpvar_79.z = shadowCoord_30.z;
    mediump float tmpvar_80;
    tmpvar_80 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_79);
    shadow_34 = (shadow_34 + ((tmpvar_56.z * tmpvar_59.y) * tmpvar_80));
    highp vec2 tmpvar_81;
    tmpvar_81.x = fetchesOffsetsU_33.x;
    tmpvar_81.y = fetchesOffsetsV_32.z;
    highp vec3 tmpvar_82;
    tmpvar_82.xy = (tmpvar_62 + tmpvar_81);
    tmpvar_82.z = shadowCoord_30.z;
    mediump float tmpvar_83;
    tmpvar_83 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_82);
    shadow_34 = (shadow_34 + ((tmpvar_56.x * tmpvar_59.z) * tmpvar_83));
    highp vec2 tmpvar_84;
    tmpvar_84.x = fetchesOffsetsU_33.y;
    tmpvar_84.y = fetchesOffsetsV_32.z;
    highp vec3 tmpvar_85;
    tmpvar_85.xy = (tmpvar_62 + tmpvar_84);
    tmpvar_85.z = shadowCoord_30.z;
    mediump float tmpvar_86;
    tmpvar_86 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_85);
    shadow_34 = (shadow_34 + ((tmpvar_56.y * tmpvar_59.z) * tmpvar_86));
    highp vec2 tmpvar_87;
    tmpvar_87.x = fetchesOffsetsU_33.z;
    tmpvar_87.y = fetchesOffsetsV_32.z;
    highp vec3 tmpvar_88;
    tmpvar_88.xy = (tmpvar_62 + tmpvar_87);
    tmpvar_88.z = shadowCoord_30.z;
    mediump float tmpvar_89;
    tmpvar_89 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_88);
    shadow_34 = (shadow_34 + ((tmpvar_56.z * tmpvar_59.z) * tmpvar_89));
    tmpvar_31 = mix (1.0, shadow_34, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_90;
  highp vec3 tmpvar_91;
  tmpvar_90 = normalize((CAMERA_WORLDPOSITION - tmpvar_18));
  tmpvar_91 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_92;
  highp vec3 specularEnv_93;
  highp vec3 color_94;
  mediump float surfaceReduction_95;
  mediump float diffuseTerm_96;
  highp float perceptualRoughness_97;
  mediump vec3 tmpvar_98;
  mediump vec3 albedo_99;
  albedo_99 = tmpvar_5;
  mediump vec3 specColor_100;
  specColor_100 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_6)) + (albedo_99 * tmpvar_6));
  mediump float tmpvar_101;
  tmpvar_101 = (0.7790837 - (tmpvar_6 * 0.7790837));
  tmpvar_98 = (albedo_99 * tmpvar_101);
  tmpvar_92 = 0.0;
  mediump float alpha_102;
  alpha_102 = tmpvar_92;
  tmpvar_92 = alpha_102;
  mediump float tmpvar_103;
  tmpvar_103 = (1.0 - tmpvar_7);
  perceptualRoughness_97 = tmpvar_103;
  highp vec3 tmpvar_104;
  highp vec3 inVec_105;
  inVec_105 = (tmpvar_91 + tmpvar_90);
  tmpvar_104 = (inVec_105 * inversesqrt(max (0.001, 
    dot (inVec_105, inVec_105)
  )));
  highp float tmpvar_106;
  tmpvar_106 = abs(dot (tmpvar_90, normalWorld_9));
  highp float tmpvar_107;
  tmpvar_107 = clamp (dot (normalWorld_9, tmpvar_91), 0.0, 1.0);
  highp float tmpvar_108;
  tmpvar_108 = clamp (dot (normalWorld_9, tmpvar_104), 0.0, 1.0);
  mediump float tmpvar_109;
  highp float tmpvar_110;
  tmpvar_110 = clamp (dot (tmpvar_91, tmpvar_104), 0.0, 1.0);
  tmpvar_109 = tmpvar_110;
  mediump float tmpvar_111;
  mediump float NdotV_112;
  NdotV_112 = tmpvar_106;
  mediump float NdotL_113;
  NdotL_113 = tmpvar_107;
  mediump float perceptualRoughness_114;
  perceptualRoughness_114 = perceptualRoughness_97;
  mediump float tmpvar_115;
  tmpvar_115 = (0.5 + ((2.0 * tmpvar_109) * (tmpvar_109 * perceptualRoughness_114)));
  mediump float x_116;
  x_116 = (1.0 - NdotL_113);
  mediump float x_117;
  x_117 = (1.0 - NdotV_112);
  tmpvar_111 = ((1.0 + (
    (tmpvar_115 - 1.0)
   * 
    ((x_116 * x_116) * ((x_116 * x_116) * x_116))
  )) * (1.0 + (
    (tmpvar_115 - 1.0)
   * 
    ((x_117 * x_117) * ((x_117 * x_117) * x_117))
  )));
  highp float tmpvar_118;
  tmpvar_118 = (tmpvar_111 * tmpvar_107);
  diffuseTerm_96 = tmpvar_118;
  highp float tmpvar_119;
  tmpvar_119 = max ((perceptualRoughness_97 * perceptualRoughness_97), 0.002);
  highp float tmpvar_120;
  tmpvar_120 = (tmpvar_119 * tmpvar_119);
  highp float tmpvar_121;
  tmpvar_121 = (((
    (tmpvar_108 * tmpvar_120)
   - tmpvar_108) * tmpvar_108) + 1.0);
  surfaceReduction_95 = (1.0 - ((0.28 * tmpvar_119) * perceptualRoughness_97));
  mediump vec3 tmpvar_122;
  mediump float x_123;
  x_123 = (1.0 - tmpvar_109);
  tmpvar_122 = (specColor_100 + ((1.0 - specColor_100) * (
    (x_123 * x_123)
   * 
    ((x_123 * x_123) * x_123)
  )));
  color_94 = (((
    (tmpvar_98 * LIGHT_COLOR)
   * diffuseTerm_96) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_120)
       / 
        ((tmpvar_121 * tmpvar_121) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_107 * (
          (tmpvar_106 * (1.0 - tmpvar_119))
         + tmpvar_119)) + (tmpvar_106 * (
          (tmpvar_107 * (1.0 - tmpvar_119))
         + tmpvar_119))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_107)) * LIGHT_COLOR)
   * tmpvar_122)) * tmpvar_31);
  color_94 = (color_94 + tmpvar_8);
  color_94 = (color_94 + (tmpvar_98 * rgbm_27.xyz));
  mediump float cosA_124;
  cosA_124 = tmpvar_106;
  mediump float tmpvar_125;
  mediump float x_126;
  x_126 = (1.0 - cosA_124);
  tmpvar_125 = ((x_126 * x_126) * ((x_126 * x_126) * x_126));
  mediump vec3 tmpvar_127;
  tmpvar_127 = (surfaceReduction_95 * ((specColor_100 * 
    (1.0 - tmpvar_125)
  ) + (vec3(
    clamp ((tmpvar_7 + (1.0 - tmpvar_101)), 0.0, 1.0)
  ) * tmpvar_125)));
  specularEnv_93 = tmpvar_127;
  color_94 = (color_94 + (specularEnv_93 * rgbm_19.xyz));
  outColor_4.xyz = color_94;
  lowp vec4 tmpvar_128;
  tmpvar_128 = texture (_MaskTex, xlv_TEXCOORD0);
  maskCol_3 = tmpvar_128;
  outColor_4.w = ((col_13.w * maskCol_3.w) * _Opacity);
  highp vec3 tmpvar_129;
  tmpvar_129 = (xlv_TEXCOORD4.xyz / xlv_TEXCOORD4.w);
  highp vec2 tmpvar_130;
  tmpvar_130.x = tmpvar_129.x;
  tmpvar_130.y = (1.0 - tmpvar_129.y);
  lowp vec4 tmpvar_131;
  tmpvar_131 = texture (_BlendTex, tmpvar_130);
  dstColor_2 = tmpvar_131;
  srcColor_1 = outColor_4;
  outColor_4.w = ((col_13.w * maskCol_3.w) * _Opacity);
  highp int mode_132;
  mode_132 = int(_BlendType);
  bool tmpvar_133;
  tmpvar_133 = bool(1);
  highp vec3 tmpvar_134;
  if ((mode_132 == 1)) {
    tmpvar_134 = ((srcColor_1.www * srcColor_1.xyz) + (vec3((1.0 - srcColor_1.w)) * dstColor_2.xyz));
    tmpvar_133 = bool(0);
  } else {
    if ((mode_132 == 2)) {
      tmpvar_134 = ((srcColor_1.wwww * srcColor_1) + dstColor_2).xyz;
      tmpvar_133 = bool(0);
    } else {
      if ((mode_132 == 3)) {
        tmpvar_134 = (((srcColor_1 + 
          ((vec4(1.0, 1.0, 1.0, 1.0) - srcColor_1) * dstColor_2)
        ).xyz * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
        tmpvar_133 = bool(0);
      } else {
        if ((mode_132 == 4)) {
          highp float tmpvar_135;
          if ((dstColor_2.x < 0.5)) {
            tmpvar_135 = ((2.0 * srcColor_1.x) * dstColor_2.x);
          } else {
            tmpvar_135 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.x)
            ) * (1.0 - dstColor_2.x)));
          };
          highp float tmpvar_136;
          if ((dstColor_2.y < 0.5)) {
            tmpvar_136 = ((2.0 * srcColor_1.y) * dstColor_2.y);
          } else {
            tmpvar_136 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.y)
            ) * (1.0 - dstColor_2.y)));
          };
          highp float tmpvar_137;
          if ((dstColor_2.z < 0.5)) {
            tmpvar_137 = ((2.0 * srcColor_1.z) * dstColor_2.z);
          } else {
            tmpvar_137 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.z)
            ) * (1.0 - dstColor_2.z)));
          };
          highp vec3 tmpvar_138;
          tmpvar_138.x = tmpvar_135;
          tmpvar_138.y = tmpvar_136;
          tmpvar_138.z = tmpvar_137;
          tmpvar_134 = ((tmpvar_138 * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
          tmpvar_133 = bool(0);
        } else {
          if ((mode_132 == 5)) {
            highp float tmpvar_139;
            if ((dstColor_2.x < 0.5)) {
              tmpvar_139 = (((2.0 * dstColor_2.x) * srcColor_1.x) + ((dstColor_2.x * dstColor_2.x) * (1.0 - 
                (2.0 * srcColor_1.x)
              )));
            } else {
              tmpvar_139 = (((2.0 * dstColor_2.x) * (1.0 - srcColor_1.x)) + (sqrt(dstColor_2.x) * (
                (2.0 * srcColor_1.x)
               - 1.0)));
            };
            highp float tmpvar_140;
            if ((dstColor_2.y < 0.5)) {
              tmpvar_140 = (((2.0 * dstColor_2.y) * srcColor_1.y) + ((dstColor_2.y * dstColor_2.y) * (1.0 - 
                (2.0 * srcColor_1.y)
              )));
            } else {
              tmpvar_140 = (((2.0 * dstColor_2.y) * (1.0 - srcColor_1.y)) + (sqrt(dstColor_2.y) * (
                (2.0 * srcColor_1.y)
               - 1.0)));
            };
            highp float tmpvar_141;
            if ((dstColor_2.z < 0.5)) {
              tmpvar_141 = (((2.0 * dstColor_2.z) * srcColor_1.z) + ((dstColor_2.z * dstColor_2.z) * (1.0 - 
                (2.0 * srcColor_1.z)
              )));
            } else {
              tmpvar_141 = (((2.0 * dstColor_2.z) * (1.0 - srcColor_1.z)) + (sqrt(dstColor_2.z) * (
                (2.0 * srcColor_1.z)
               - 1.0)));
            };
            highp vec3 tmpvar_142;
            tmpvar_142.x = tmpvar_139;
            tmpvar_142.y = tmpvar_140;
            tmpvar_142.z = tmpvar_141;
            tmpvar_134 = ((tmpvar_142 * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
            tmpvar_133 = bool(0);
          } else {
            if ((mode_132 == 6)) {
              tmpvar_134 = ((max (srcColor_1.xyz, dstColor_2.xyz) * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
              tmpvar_133 = bool(0);
            } else {
              if ((mode_132 == 7)) {
                tmpvar_134 = (((srcColor_1.xyz * dstColor_2.xyz) * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
                tmpvar_133 = bool(0);
              };
            };
          };
        };
      };
    };
  };
  if (tmpvar_133) {
    tmpvar_134 = vec3(1.0, 0.0, 0.0);
    tmpvar_133 = bool(0);
  };
  outColor_4.xyz = tmpvar_134;
  outColor_4.w = 1.0;
  _glesFragData[0] = outColor_4;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendType",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 row2_6;
  highp vec4 row1_7;
  highp vec4 row0_8;
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_12;
  tmpvar_12 = (int(_glesBlendIndices.w) * 3);
  row0_8 = (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.x);
  row1_7 = (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.x);
  row2_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.x);
  row0_8 = (row0_8 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.y));
  row1_7 = (row1_7 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.y));
  row2_6 = (row2_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.y));
  row0_8 = (row0_8 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.z));
  row1_7 = (row1_7 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.z));
  row2_6 = (row2_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.z));
  row0_8 = (row0_8 + (ANIMATION_MATRIX_ARRAY[tmpvar_12] * _glesBlendWeight.w));
  row1_7 = (row1_7 + (ANIMATION_MATRIX_ARRAY[(tmpvar_12 + 1)] * _glesBlendWeight.w));
  row2_6 = (row2_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_12 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_13;
  tmpvar_13[uint(0)].x = row0_8.x;
  tmpvar_13[uint(0)].y = row0_8.y;
  tmpvar_13[uint(0)].z = row0_8.z;
  tmpvar_13[uint(0)].w = row0_8.w;
  tmpvar_13[1u].x = row1_7.x;
  tmpvar_13[1u].y = row1_7.y;
  tmpvar_13[1u].z = row1_7.z;
  tmpvar_13[1u].w = row1_7.w;
  tmpvar_13[2u].x = row2_6.x;
  tmpvar_13[2u].y = row2_6.y;
  tmpvar_13[2u].z = row2_6.z;
  tmpvar_13[2u].w = row2_6.w;
  tmpvar_13[3u].x = 0.0;
  tmpvar_13[3u].y = 0.0;
  tmpvar_13[3u].z = 0.0;
  tmpvar_13[3u].w = 1.0;
  highp vec4 tmpvar_14;
  tmpvar_14 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_13)));
  highp vec4 tmpvar_15;
  tmpvar_15.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_15.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_16;
  tmpvar_16 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_13)).xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_13[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_13[1u].xyz;
  tmpvar_18[2u] = tmpvar_13[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_17 * (_glesNormal * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_13[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_13[1u].xyz;
  tmpvar_20[2u] = tmpvar_13[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_19 * (_glesTangent * tmpvar_20)));
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_21[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_21[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)] = tmpvar_13[uint(0)].xyz;
  tmpvar_22[1u] = tmpvar_13[1u].xyz;
  tmpvar_22[2u] = tmpvar_13[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_21 * (_glesBinormal * tmpvar_22)));
  tmpvar_1.w = tmpvar_16.x;
  tmpvar_2.w = tmpvar_16.y;
  tmpvar_3.w = tmpvar_16.z;
  tmpvar_4.zw = tmpvar_14.zw;
  tmpvar_4.xy = ((tmpvar_14.xy * 0.5) + (0.5 * tmpvar_14.ww));
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_13)))
  ).xyz * 0.5) + 0.5);
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_13)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD4 = tmpvar_4;
  gl_Position = (tmpvar_15 * tmpvar_14);
  xlv_TEXCOORD5 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _BlendTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _Opacity;
uniform highp float _BlendType;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
in highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 srcColor_1;
  highp vec4 dstColor_2;
  highp vec4 maskCol_3;
  highp vec4 outColor_4;
  highp vec3 tmpvar_5;
  mediump float tmpvar_6;
  mediump float tmpvar_7;
  highp vec3 tmpvar_8;
  highp vec3 normalWorld_9;
  highp vec3 normalTangent_10;
  highp vec3 emissionMapColor_11;
  highp vec2 mg_12;
  highp vec4 col_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture (_MainTex, xlv_TEXCOORD0);
  col_13 = tmpvar_14;
  lowp vec2 tmpvar_15;
  tmpvar_15 = texture (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_12 = tmpvar_15;
  lowp vec3 tmpvar_16;
  tmpvar_16 = texture (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_11 = tmpvar_16;
  lowp vec3 tmpvar_17;
  tmpvar_17 = texture (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_10 = tmpvar_17;
  normalTangent_10 = ((normalTangent_10 * 2.0) - 1.0);
  normalWorld_9 = normalize(((
    (normalTangent_10.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_10.y * xlv_TEXCOORD2.xyz)
  ) + (normalTangent_10.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_18;
  tmpvar_18.x = xlv_TEXCOORD1.w;
  tmpvar_18.y = xlv_TEXCOORD2.w;
  tmpvar_18.z = xlv_TEXCOORD3.w;
  highp vec4 rgbm_19;
  highp vec3 tmpvar_20;
  highp vec3 I_21;
  I_21 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_18)));
  tmpvar_20 = (I_21 - (2.0 * (
    dot (normalWorld_9, I_21)
   * normalWorld_9)));
  highp mat2 tmpvar_22;
  tmpvar_22[uint(0)].x = 1.0;
  tmpvar_22[uint(0)].y = 0.0;
  tmpvar_22[1u].x = -0.0;
  tmpvar_22[1u].y = 1.0;
  highp vec3 tmpvar_23;
  tmpvar_23.xy = (tmpvar_22 * tmpvar_20.xz);
  tmpvar_23.z = tmpvar_20.y;
  highp vec4 tmpvar_24;
  tmpvar_24.xyz = tmpvar_23.xzy;
  tmpvar_24.w = ((1.0 - (mg_12.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_25;
  tmpvar_25 = textureLod (_GlossEnvMap, tmpvar_23.xzy, tmpvar_24.w);
  highp vec4 tmpvar_26;
  tmpvar_26 = tmpvar_25;
  rgbm_19.w = tmpvar_26.w;
  rgbm_19.xyz = ((tmpvar_26.xyz * tmpvar_26.w) * 6.0);
  highp vec4 rgbm_27;
  lowp vec4 tmpvar_28;
  tmpvar_28 = texture (_IrradianceMap, normalWorld_9);
  highp vec4 tmpvar_29;
  tmpvar_29 = tmpvar_28;
  rgbm_27.w = tmpvar_29.w;
  rgbm_27.xyz = ((tmpvar_29.xyz * tmpvar_29.w) * 6.0);
  tmpvar_5 = col_13.xyz;
  tmpvar_6 = (mg_12.x * _Metallic);
  tmpvar_7 = (mg_12.y * _Smoothness);
  tmpvar_8 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_11));
  highp vec4 shadowCoord_30;
  shadowCoord_30 = xlv_TEXCOORD5;
  highp float tmpvar_31;
  if ((xlv_TEXCOORD5.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_31 = 1.0;
  } else {
    shadowCoord_30.y = (1.0 - xlv_TEXCOORD5.y);
    highp vec4 fetchesOffsetsV_32;
    highp vec4 fetchesOffsetsU_33;
    highp float shadow_34;
    highp vec2 tmpvar_35;
    tmpvar_35 = (shadowCoord_30.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_36;
    tmpvar_36 = floor((tmpvar_35 + 0.5));
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_35 - tmpvar_36);
    highp vec4 texelsWeightsA_38;
    highp vec4 texelsWeightsB_39;
    highp vec4 computedArea_40;
    highp vec4 computedAreaUncut_41;
    highp float tmpvar_42;
    tmpvar_42 = (((tmpvar_37.x + 0.5) * (tmpvar_37.x + 0.5)) * 0.5);
    highp float tmpvar_43;
    tmpvar_43 = (tmpvar_42 - tmpvar_37.x);
    computedArea_40.x = tmpvar_43;
    computedAreaUncut_41.x = tmpvar_43;
    computedArea_40.w = tmpvar_42;
    computedAreaUncut_41.w = tmpvar_42;
    computedAreaUncut_41.y = ((1.5 - tmpvar_37.x) - 0.5);
    highp float tmpvar_44;
    tmpvar_44 = min (tmpvar_37.x, 0.0);
    computedArea_40.y = (computedAreaUncut_41.y - (tmpvar_44 * tmpvar_44));
    computedAreaUncut_41.z = ((1.5 + tmpvar_37.x) - 0.5);
    highp float tmpvar_45;
    tmpvar_45 = max (tmpvar_37.x, 0.0);
    computedArea_40.z = (computedAreaUncut_41.z - (tmpvar_45 * tmpvar_45));
    texelsWeightsA_38.x = (0.081632 * tmpvar_43);
    texelsWeightsA_38.y = (0.081632 * computedAreaUncut_41.y);
    texelsWeightsA_38.z = (0.081632 * (computedAreaUncut_41.y + 1.0));
    texelsWeightsA_38.w = (0.081632 * (computedArea_40.y + 2.0));
    texelsWeightsB_39.x = (0.081632 * (computedArea_40.z + 2.0));
    texelsWeightsB_39.y = (0.081632 * (computedAreaUncut_41.z + 1.0));
    texelsWeightsB_39.z = (0.081632 * computedAreaUncut_41.z);
    texelsWeightsB_39.w = (0.081632 * tmpvar_42);
    highp vec4 texelsWeightsA_46;
    highp vec4 texelsWeightsB_47;
    highp vec4 computedArea_48;
    highp vec4 computedAreaUncut_49;
    highp float tmpvar_50;
    tmpvar_50 = (((tmpvar_37.y + 0.5) * (tmpvar_37.y + 0.5)) * 0.5);
    highp float tmpvar_51;
    tmpvar_51 = (tmpvar_50 - tmpvar_37.y);
    computedArea_48.x = tmpvar_51;
    computedAreaUncut_49.x = tmpvar_51;
    computedArea_48.w = tmpvar_50;
    computedAreaUncut_49.w = tmpvar_50;
    computedAreaUncut_49.y = ((1.5 - tmpvar_37.y) - 0.5);
    highp float tmpvar_52;
    tmpvar_52 = min (tmpvar_37.y, 0.0);
    computedArea_48.y = (computedAreaUncut_49.y - (tmpvar_52 * tmpvar_52));
    computedAreaUncut_49.z = ((1.5 + tmpvar_37.y) - 0.5);
    highp float tmpvar_53;
    tmpvar_53 = max (tmpvar_37.y, 0.0);
    computedArea_48.z = (computedAreaUncut_49.z - (tmpvar_53 * tmpvar_53));
    texelsWeightsA_46.x = (0.081632 * tmpvar_51);
    texelsWeightsA_46.y = (0.081632 * computedAreaUncut_49.y);
    texelsWeightsA_46.z = (0.081632 * (computedAreaUncut_49.y + 1.0));
    texelsWeightsA_46.w = (0.081632 * (computedArea_48.y + 2.0));
    texelsWeightsB_47.x = (0.081632 * (computedArea_48.z + 2.0));
    texelsWeightsB_47.y = (0.081632 * (computedAreaUncut_49.z + 1.0));
    texelsWeightsB_47.z = (0.081632 * computedAreaUncut_49.z);
    texelsWeightsB_47.w = (0.081632 * tmpvar_50);
    highp vec4 tmpvar_54;
    tmpvar_54.xy = texelsWeightsA_38.xz;
    tmpvar_54.zw = texelsWeightsB_39.xz;
    highp vec4 tmpvar_55;
    tmpvar_55.xy = texelsWeightsA_38.yw;
    tmpvar_55.zw = texelsWeightsB_39.yw;
    highp vec4 tmpvar_56;
    tmpvar_56 = (tmpvar_54 + tmpvar_55);
    highp vec4 tmpvar_57;
    tmpvar_57.xy = texelsWeightsA_46.xz;
    tmpvar_57.zw = texelsWeightsB_47.xz;
    highp vec4 tmpvar_58;
    tmpvar_58.xy = texelsWeightsA_46.yw;
    tmpvar_58.zw = texelsWeightsB_47.yw;
    highp vec4 tmpvar_59;
    tmpvar_59 = (tmpvar_57 + tmpvar_58);
    highp vec4 tmpvar_60;
    tmpvar_60.xy = texelsWeightsA_38.yw;
    tmpvar_60.zw = texelsWeightsB_39.yw;
    highp vec4 tmpvar_61;
    tmpvar_61.xy = texelsWeightsA_46.yw;
    tmpvar_61.zw = texelsWeightsB_47.yw;
    fetchesOffsetsU_33 = (((tmpvar_60 / tmpvar_56) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_32 = (((tmpvar_61 / tmpvar_59) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_62;
    tmpvar_62 = (tmpvar_36 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_63;
    tmpvar_63.x = fetchesOffsetsU_33.x;
    tmpvar_63.y = fetchesOffsetsV_32.x;
    highp vec3 tmpvar_64;
    tmpvar_64.xy = (tmpvar_62 + tmpvar_63);
    tmpvar_64.z = shadowCoord_30.z;
    mediump float tmpvar_65;
    tmpvar_65 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_64);
    shadow_34 = ((tmpvar_56.x * tmpvar_59.x) * tmpvar_65);
    highp vec2 tmpvar_66;
    tmpvar_66.x = fetchesOffsetsU_33.y;
    tmpvar_66.y = fetchesOffsetsV_32.x;
    highp vec3 tmpvar_67;
    tmpvar_67.xy = (tmpvar_62 + tmpvar_66);
    tmpvar_67.z = shadowCoord_30.z;
    mediump float tmpvar_68;
    tmpvar_68 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_67);
    shadow_34 = (shadow_34 + ((tmpvar_56.y * tmpvar_59.x) * tmpvar_68));
    highp vec2 tmpvar_69;
    tmpvar_69.x = fetchesOffsetsU_33.z;
    tmpvar_69.y = fetchesOffsetsV_32.x;
    highp vec3 tmpvar_70;
    tmpvar_70.xy = (tmpvar_62 + tmpvar_69);
    tmpvar_70.z = shadowCoord_30.z;
    mediump float tmpvar_71;
    tmpvar_71 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_70);
    shadow_34 = (shadow_34 + ((tmpvar_56.z * tmpvar_59.x) * tmpvar_71));
    highp vec2 tmpvar_72;
    tmpvar_72.x = fetchesOffsetsU_33.w;
    tmpvar_72.y = fetchesOffsetsV_32.x;
    highp vec3 tmpvar_73;
    tmpvar_73.xy = (tmpvar_62 + tmpvar_72);
    tmpvar_73.z = shadowCoord_30.z;
    mediump float tmpvar_74;
    tmpvar_74 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_73);
    shadow_34 = (shadow_34 + ((tmpvar_56.w * tmpvar_59.x) * tmpvar_74));
    highp vec2 tmpvar_75;
    tmpvar_75.x = fetchesOffsetsU_33.x;
    tmpvar_75.y = fetchesOffsetsV_32.y;
    highp vec3 tmpvar_76;
    tmpvar_76.xy = (tmpvar_62 + tmpvar_75);
    tmpvar_76.z = shadowCoord_30.z;
    mediump float tmpvar_77;
    tmpvar_77 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_76);
    shadow_34 = (shadow_34 + ((tmpvar_56.x * tmpvar_59.y) * tmpvar_77));
    highp vec2 tmpvar_78;
    tmpvar_78.x = fetchesOffsetsU_33.y;
    tmpvar_78.y = fetchesOffsetsV_32.y;
    highp vec3 tmpvar_79;
    tmpvar_79.xy = (tmpvar_62 + tmpvar_78);
    tmpvar_79.z = shadowCoord_30.z;
    mediump float tmpvar_80;
    tmpvar_80 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_79);
    shadow_34 = (shadow_34 + ((tmpvar_56.y * tmpvar_59.y) * tmpvar_80));
    highp vec2 tmpvar_81;
    tmpvar_81.x = fetchesOffsetsU_33.z;
    tmpvar_81.y = fetchesOffsetsV_32.y;
    highp vec3 tmpvar_82;
    tmpvar_82.xy = (tmpvar_62 + tmpvar_81);
    tmpvar_82.z = shadowCoord_30.z;
    mediump float tmpvar_83;
    tmpvar_83 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_82);
    shadow_34 = (shadow_34 + ((tmpvar_56.z * tmpvar_59.y) * tmpvar_83));
    highp vec2 tmpvar_84;
    tmpvar_84.x = fetchesOffsetsU_33.w;
    tmpvar_84.y = fetchesOffsetsV_32.y;
    highp vec3 tmpvar_85;
    tmpvar_85.xy = (tmpvar_62 + tmpvar_84);
    tmpvar_85.z = shadowCoord_30.z;
    mediump float tmpvar_86;
    tmpvar_86 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_85);
    shadow_34 = (shadow_34 + ((tmpvar_56.w * tmpvar_59.y) * tmpvar_86));
    highp vec2 tmpvar_87;
    tmpvar_87.x = fetchesOffsetsU_33.x;
    tmpvar_87.y = fetchesOffsetsV_32.z;
    highp vec3 tmpvar_88;
    tmpvar_88.xy = (tmpvar_62 + tmpvar_87);
    tmpvar_88.z = shadowCoord_30.z;
    mediump float tmpvar_89;
    tmpvar_89 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_88);
    shadow_34 = (shadow_34 + ((tmpvar_56.x * tmpvar_59.z) * tmpvar_89));
    highp vec2 tmpvar_90;
    tmpvar_90.x = fetchesOffsetsU_33.y;
    tmpvar_90.y = fetchesOffsetsV_32.z;
    highp vec3 tmpvar_91;
    tmpvar_91.xy = (tmpvar_62 + tmpvar_90);
    tmpvar_91.z = shadowCoord_30.z;
    mediump float tmpvar_92;
    tmpvar_92 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_91);
    shadow_34 = (shadow_34 + ((tmpvar_56.y * tmpvar_59.z) * tmpvar_92));
    highp vec2 tmpvar_93;
    tmpvar_93.x = fetchesOffsetsU_33.z;
    tmpvar_93.y = fetchesOffsetsV_32.z;
    highp vec3 tmpvar_94;
    tmpvar_94.xy = (tmpvar_62 + tmpvar_93);
    tmpvar_94.z = shadowCoord_30.z;
    mediump float tmpvar_95;
    tmpvar_95 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_94);
    shadow_34 = (shadow_34 + ((tmpvar_56.z * tmpvar_59.z) * tmpvar_95));
    highp vec2 tmpvar_96;
    tmpvar_96.x = fetchesOffsetsU_33.w;
    tmpvar_96.y = fetchesOffsetsV_32.z;
    highp vec3 tmpvar_97;
    tmpvar_97.xy = (tmpvar_62 + tmpvar_96);
    tmpvar_97.z = shadowCoord_30.z;
    mediump float tmpvar_98;
    tmpvar_98 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_97);
    shadow_34 = (shadow_34 + ((tmpvar_56.w * tmpvar_59.z) * tmpvar_98));
    highp vec2 tmpvar_99;
    tmpvar_99.x = fetchesOffsetsU_33.x;
    tmpvar_99.y = fetchesOffsetsV_32.w;
    highp vec3 tmpvar_100;
    tmpvar_100.xy = (tmpvar_62 + tmpvar_99);
    tmpvar_100.z = shadowCoord_30.z;
    mediump float tmpvar_101;
    tmpvar_101 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_100);
    shadow_34 = (shadow_34 + ((tmpvar_56.x * tmpvar_59.w) * tmpvar_101));
    highp vec2 tmpvar_102;
    tmpvar_102.x = fetchesOffsetsU_33.y;
    tmpvar_102.y = fetchesOffsetsV_32.w;
    highp vec3 tmpvar_103;
    tmpvar_103.xy = (tmpvar_62 + tmpvar_102);
    tmpvar_103.z = shadowCoord_30.z;
    mediump float tmpvar_104;
    tmpvar_104 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_103);
    shadow_34 = (shadow_34 + ((tmpvar_56.y * tmpvar_59.w) * tmpvar_104));
    highp vec2 tmpvar_105;
    tmpvar_105.x = fetchesOffsetsU_33.z;
    tmpvar_105.y = fetchesOffsetsV_32.w;
    highp vec3 tmpvar_106;
    tmpvar_106.xy = (tmpvar_62 + tmpvar_105);
    tmpvar_106.z = shadowCoord_30.z;
    mediump float tmpvar_107;
    tmpvar_107 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_106);
    shadow_34 = (shadow_34 + ((tmpvar_56.z * tmpvar_59.w) * tmpvar_107));
    highp vec2 tmpvar_108;
    tmpvar_108.x = fetchesOffsetsU_33.w;
    tmpvar_108.y = fetchesOffsetsV_32.w;
    highp vec3 tmpvar_109;
    tmpvar_109.xy = (tmpvar_62 + tmpvar_108);
    tmpvar_109.z = shadowCoord_30.z;
    mediump float tmpvar_110;
    tmpvar_110 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_109);
    shadow_34 = (shadow_34 + ((tmpvar_56.w * tmpvar_59.w) * tmpvar_110));
    tmpvar_31 = mix (1.0, shadow_34, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_111;
  highp vec3 tmpvar_112;
  tmpvar_111 = normalize((CAMERA_WORLDPOSITION - tmpvar_18));
  tmpvar_112 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_113;
  highp vec3 specularEnv_114;
  highp vec3 color_115;
  mediump float surfaceReduction_116;
  mediump float diffuseTerm_117;
  highp float perceptualRoughness_118;
  mediump vec3 tmpvar_119;
  mediump vec3 albedo_120;
  albedo_120 = tmpvar_5;
  mediump vec3 specColor_121;
  specColor_121 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_6)) + (albedo_120 * tmpvar_6));
  mediump float tmpvar_122;
  tmpvar_122 = (0.7790837 - (tmpvar_6 * 0.7790837));
  tmpvar_119 = (albedo_120 * tmpvar_122);
  tmpvar_113 = 0.0;
  mediump float alpha_123;
  alpha_123 = tmpvar_113;
  tmpvar_113 = alpha_123;
  mediump float tmpvar_124;
  tmpvar_124 = (1.0 - tmpvar_7);
  perceptualRoughness_118 = tmpvar_124;
  highp vec3 tmpvar_125;
  highp vec3 inVec_126;
  inVec_126 = (tmpvar_112 + tmpvar_111);
  tmpvar_125 = (inVec_126 * inversesqrt(max (0.001, 
    dot (inVec_126, inVec_126)
  )));
  highp float tmpvar_127;
  tmpvar_127 = abs(dot (tmpvar_111, normalWorld_9));
  highp float tmpvar_128;
  tmpvar_128 = clamp (dot (normalWorld_9, tmpvar_112), 0.0, 1.0);
  highp float tmpvar_129;
  tmpvar_129 = clamp (dot (normalWorld_9, tmpvar_125), 0.0, 1.0);
  mediump float tmpvar_130;
  highp float tmpvar_131;
  tmpvar_131 = clamp (dot (tmpvar_112, tmpvar_125), 0.0, 1.0);
  tmpvar_130 = tmpvar_131;
  mediump float tmpvar_132;
  mediump float NdotV_133;
  NdotV_133 = tmpvar_127;
  mediump float NdotL_134;
  NdotL_134 = tmpvar_128;
  mediump float perceptualRoughness_135;
  perceptualRoughness_135 = perceptualRoughness_118;
  mediump float tmpvar_136;
  tmpvar_136 = (0.5 + ((2.0 * tmpvar_130) * (tmpvar_130 * perceptualRoughness_135)));
  mediump float x_137;
  x_137 = (1.0 - NdotL_134);
  mediump float x_138;
  x_138 = (1.0 - NdotV_133);
  tmpvar_132 = ((1.0 + (
    (tmpvar_136 - 1.0)
   * 
    ((x_137 * x_137) * ((x_137 * x_137) * x_137))
  )) * (1.0 + (
    (tmpvar_136 - 1.0)
   * 
    ((x_138 * x_138) * ((x_138 * x_138) * x_138))
  )));
  highp float tmpvar_139;
  tmpvar_139 = (tmpvar_132 * tmpvar_128);
  diffuseTerm_117 = tmpvar_139;
  highp float tmpvar_140;
  tmpvar_140 = max ((perceptualRoughness_118 * perceptualRoughness_118), 0.002);
  highp float tmpvar_141;
  tmpvar_141 = (tmpvar_140 * tmpvar_140);
  highp float tmpvar_142;
  tmpvar_142 = (((
    (tmpvar_129 * tmpvar_141)
   - tmpvar_129) * tmpvar_129) + 1.0);
  surfaceReduction_116 = (1.0 - ((0.28 * tmpvar_140) * perceptualRoughness_118));
  mediump vec3 tmpvar_143;
  mediump float x_144;
  x_144 = (1.0 - tmpvar_130);
  tmpvar_143 = (specColor_121 + ((1.0 - specColor_121) * (
    (x_144 * x_144)
   * 
    ((x_144 * x_144) * x_144)
  )));
  color_115 = (((
    (tmpvar_119 * LIGHT_COLOR)
   * diffuseTerm_117) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_141)
       / 
        ((tmpvar_142 * tmpvar_142) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_128 * (
          (tmpvar_127 * (1.0 - tmpvar_140))
         + tmpvar_140)) + (tmpvar_127 * (
          (tmpvar_128 * (1.0 - tmpvar_140))
         + tmpvar_140))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_128)) * LIGHT_COLOR)
   * tmpvar_143)) * tmpvar_31);
  color_115 = (color_115 + tmpvar_8);
  color_115 = (color_115 + (tmpvar_119 * rgbm_27.xyz));
  mediump float cosA_145;
  cosA_145 = tmpvar_127;
  mediump float tmpvar_146;
  mediump float x_147;
  x_147 = (1.0 - cosA_145);
  tmpvar_146 = ((x_147 * x_147) * ((x_147 * x_147) * x_147));
  mediump vec3 tmpvar_148;
  tmpvar_148 = (surfaceReduction_116 * ((specColor_121 * 
    (1.0 - tmpvar_146)
  ) + (vec3(
    clamp ((tmpvar_7 + (1.0 - tmpvar_122)), 0.0, 1.0)
  ) * tmpvar_146)));
  specularEnv_114 = tmpvar_148;
  color_115 = (color_115 + (specularEnv_114 * rgbm_19.xyz));
  outColor_4.xyz = color_115;
  lowp vec4 tmpvar_149;
  tmpvar_149 = texture (_MaskTex, xlv_TEXCOORD0);
  maskCol_3 = tmpvar_149;
  outColor_4.w = ((col_13.w * maskCol_3.w) * _Opacity);
  highp vec3 tmpvar_150;
  tmpvar_150 = (xlv_TEXCOORD4.xyz / xlv_TEXCOORD4.w);
  highp vec2 tmpvar_151;
  tmpvar_151.x = tmpvar_150.x;
  tmpvar_151.y = (1.0 - tmpvar_150.y);
  lowp vec4 tmpvar_152;
  tmpvar_152 = texture (_BlendTex, tmpvar_151);
  dstColor_2 = tmpvar_152;
  srcColor_1 = outColor_4;
  outColor_4.w = ((col_13.w * maskCol_3.w) * _Opacity);
  highp int mode_153;
  mode_153 = int(_BlendType);
  bool tmpvar_154;
  tmpvar_154 = bool(1);
  highp vec3 tmpvar_155;
  if ((mode_153 == 1)) {
    tmpvar_155 = ((srcColor_1.www * srcColor_1.xyz) + (vec3((1.0 - srcColor_1.w)) * dstColor_2.xyz));
    tmpvar_154 = bool(0);
  } else {
    if ((mode_153 == 2)) {
      tmpvar_155 = ((srcColor_1.wwww * srcColor_1) + dstColor_2).xyz;
      tmpvar_154 = bool(0);
    } else {
      if ((mode_153 == 3)) {
        tmpvar_155 = (((srcColor_1 + 
          ((vec4(1.0, 1.0, 1.0, 1.0) - srcColor_1) * dstColor_2)
        ).xyz * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
        tmpvar_154 = bool(0);
      } else {
        if ((mode_153 == 4)) {
          highp float tmpvar_156;
          if ((dstColor_2.x < 0.5)) {
            tmpvar_156 = ((2.0 * srcColor_1.x) * dstColor_2.x);
          } else {
            tmpvar_156 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.x)
            ) * (1.0 - dstColor_2.x)));
          };
          highp float tmpvar_157;
          if ((dstColor_2.y < 0.5)) {
            tmpvar_157 = ((2.0 * srcColor_1.y) * dstColor_2.y);
          } else {
            tmpvar_157 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.y)
            ) * (1.0 - dstColor_2.y)));
          };
          highp float tmpvar_158;
          if ((dstColor_2.z < 0.5)) {
            tmpvar_158 = ((2.0 * srcColor_1.z) * dstColor_2.z);
          } else {
            tmpvar_158 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.z)
            ) * (1.0 - dstColor_2.z)));
          };
          highp vec3 tmpvar_159;
          tmpvar_159.x = tmpvar_156;
          tmpvar_159.y = tmpvar_157;
          tmpvar_159.z = tmpvar_158;
          tmpvar_155 = ((tmpvar_159 * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
          tmpvar_154 = bool(0);
        } else {
          if ((mode_153 == 5)) {
            highp float tmpvar_160;
            if ((dstColor_2.x < 0.5)) {
              tmpvar_160 = (((2.0 * dstColor_2.x) * srcColor_1.x) + ((dstColor_2.x * dstColor_2.x) * (1.0 - 
                (2.0 * srcColor_1.x)
              )));
            } else {
              tmpvar_160 = (((2.0 * dstColor_2.x) * (1.0 - srcColor_1.x)) + (sqrt(dstColor_2.x) * (
                (2.0 * srcColor_1.x)
               - 1.0)));
            };
            highp float tmpvar_161;
            if ((dstColor_2.y < 0.5)) {
              tmpvar_161 = (((2.0 * dstColor_2.y) * srcColor_1.y) + ((dstColor_2.y * dstColor_2.y) * (1.0 - 
                (2.0 * srcColor_1.y)
              )));
            } else {
              tmpvar_161 = (((2.0 * dstColor_2.y) * (1.0 - srcColor_1.y)) + (sqrt(dstColor_2.y) * (
                (2.0 * srcColor_1.y)
               - 1.0)));
            };
            highp float tmpvar_162;
            if ((dstColor_2.z < 0.5)) {
              tmpvar_162 = (((2.0 * dstColor_2.z) * srcColor_1.z) + ((dstColor_2.z * dstColor_2.z) * (1.0 - 
                (2.0 * srcColor_1.z)
              )));
            } else {
              tmpvar_162 = (((2.0 * dstColor_2.z) * (1.0 - srcColor_1.z)) + (sqrt(dstColor_2.z) * (
                (2.0 * srcColor_1.z)
               - 1.0)));
            };
            highp vec3 tmpvar_163;
            tmpvar_163.x = tmpvar_160;
            tmpvar_163.y = tmpvar_161;
            tmpvar_163.z = tmpvar_162;
            tmpvar_155 = ((tmpvar_163 * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
            tmpvar_154 = bool(0);
          } else {
            if ((mode_153 == 6)) {
              tmpvar_155 = ((max (srcColor_1.xyz, dstColor_2.xyz) * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
              tmpvar_154 = bool(0);
            } else {
              if ((mode_153 == 7)) {
                tmpvar_155 = (((srcColor_1.xyz * dstColor_2.xyz) * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
                tmpvar_154 = bool(0);
              };
            };
          };
        };
      };
    };
  };
  if (tmpvar_154) {
    tmpvar_155 = vec3(1.0, 0.0, 0.0);
    tmpvar_154 = bool(0);
  };
  outColor_4.xyz = tmpvar_155;
  outColor_4.w = 1.0;
  _glesFragData[0] = outColor_4;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendType",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 row2_6;
  highp vec4 row1_7;
  highp vec4 row0_8;
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_12;
  tmpvar_12 = (int(_glesBlendIndices.w) * 3);
  row0_8 = (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.x);
  row1_7 = (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.x);
  row2_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.x);
  row0_8 = (row0_8 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.y));
  row1_7 = (row1_7 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.y));
  row2_6 = (row2_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.y));
  row0_8 = (row0_8 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.z));
  row1_7 = (row1_7 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.z));
  row2_6 = (row2_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.z));
  row0_8 = (row0_8 + (ANIMATION_MATRIX_ARRAY[tmpvar_12] * _glesBlendWeight.w));
  row1_7 = (row1_7 + (ANIMATION_MATRIX_ARRAY[(tmpvar_12 + 1)] * _glesBlendWeight.w));
  row2_6 = (row2_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_12 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_13;
  tmpvar_13[uint(0)].x = row0_8.x;
  tmpvar_13[uint(0)].y = row0_8.y;
  tmpvar_13[uint(0)].z = row0_8.z;
  tmpvar_13[uint(0)].w = row0_8.w;
  tmpvar_13[1u].x = row1_7.x;
  tmpvar_13[1u].y = row1_7.y;
  tmpvar_13[1u].z = row1_7.z;
  tmpvar_13[1u].w = row1_7.w;
  tmpvar_13[2u].x = row2_6.x;
  tmpvar_13[2u].y = row2_6.y;
  tmpvar_13[2u].z = row2_6.z;
  tmpvar_13[2u].w = row2_6.w;
  tmpvar_13[3u].x = 0.0;
  tmpvar_13[3u].y = 0.0;
  tmpvar_13[3u].z = 0.0;
  tmpvar_13[3u].w = 1.0;
  highp vec4 tmpvar_14;
  tmpvar_14 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_13)));
  highp vec4 tmpvar_15;
  tmpvar_15.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_15.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_16;
  tmpvar_16 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_13)).xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_17[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_17[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[uint(0)] = tmpvar_13[uint(0)].xyz;
  tmpvar_18[1u] = tmpvar_13[1u].xyz;
  tmpvar_18[2u] = tmpvar_13[2u].xyz;
  tmpvar_1.xyz = normalize((tmpvar_17 * (_glesNormal * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_19[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_19[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)] = tmpvar_13[uint(0)].xyz;
  tmpvar_20[1u] = tmpvar_13[1u].xyz;
  tmpvar_20[2u] = tmpvar_13[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_19 * (_glesTangent * tmpvar_20)));
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_21[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_21[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)] = tmpvar_13[uint(0)].xyz;
  tmpvar_22[1u] = tmpvar_13[1u].xyz;
  tmpvar_22[2u] = tmpvar_13[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_21 * (_glesBinormal * tmpvar_22)));
  tmpvar_1.w = tmpvar_16.x;
  tmpvar_2.w = tmpvar_16.y;
  tmpvar_3.w = tmpvar_16.z;
  tmpvar_4.zw = tmpvar_14.zw;
  tmpvar_4.xy = ((tmpvar_14.xy * 0.5) + (0.5 * tmpvar_14.ww));
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_13)))
  ).xyz * 0.5) + 0.5);
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_13)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  xlv_TEXCOORD4 = tmpvar_4;
  gl_Position = (tmpvar_15 * tmpvar_14);
  xlv_TEXCOORD5 = tmpvar_5;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _BlendTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _Opacity;
uniform highp float _BlendType;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
in highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 srcColor_1;
  highp vec4 dstColor_2;
  highp vec4 maskCol_3;
  highp vec4 outColor_4;
  highp vec3 tmpvar_5;
  mediump float tmpvar_6;
  mediump float tmpvar_7;
  highp vec3 tmpvar_8;
  highp vec3 normalWorld_9;
  highp vec3 normalTangent_10;
  highp vec3 emissionMapColor_11;
  highp vec2 mg_12;
  highp vec4 col_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture (_MainTex, xlv_TEXCOORD0);
  col_13 = tmpvar_14;
  lowp vec2 tmpvar_15;
  tmpvar_15 = texture (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_12 = tmpvar_15;
  lowp vec3 tmpvar_16;
  tmpvar_16 = texture (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_11 = tmpvar_16;
  lowp vec3 tmpvar_17;
  tmpvar_17 = texture (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_10 = tmpvar_17;
  normalTangent_10 = ((normalTangent_10 * 2.0) - 1.0);
  normalWorld_9 = normalize(((
    (normalTangent_10.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_10.y * xlv_TEXCOORD2.xyz)
  ) + (normalTangent_10.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_18;
  tmpvar_18.x = xlv_TEXCOORD1.w;
  tmpvar_18.y = xlv_TEXCOORD2.w;
  tmpvar_18.z = xlv_TEXCOORD3.w;
  highp vec4 rgbm_19;
  highp vec3 tmpvar_20;
  highp vec3 I_21;
  I_21 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_18)));
  tmpvar_20 = (I_21 - (2.0 * (
    dot (normalWorld_9, I_21)
   * normalWorld_9)));
  highp mat2 tmpvar_22;
  tmpvar_22[uint(0)].x = 1.0;
  tmpvar_22[uint(0)].y = 0.0;
  tmpvar_22[1u].x = -0.0;
  tmpvar_22[1u].y = 1.0;
  highp vec3 tmpvar_23;
  tmpvar_23.xy = (tmpvar_22 * tmpvar_20.xz);
  tmpvar_23.z = tmpvar_20.y;
  highp vec4 tmpvar_24;
  tmpvar_24.xyz = tmpvar_23.xzy;
  tmpvar_24.w = ((1.0 - (mg_12.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_25;
  tmpvar_25 = textureLod (_GlossEnvMap, tmpvar_23.xzy, tmpvar_24.w);
  highp vec4 tmpvar_26;
  tmpvar_26 = tmpvar_25;
  rgbm_19.w = tmpvar_26.w;
  rgbm_19.xyz = ((tmpvar_26.xyz * tmpvar_26.w) * 6.0);
  highp vec4 rgbm_27;
  lowp vec4 tmpvar_28;
  tmpvar_28 = texture (_IrradianceMap, normalWorld_9);
  highp vec4 tmpvar_29;
  tmpvar_29 = tmpvar_28;
  rgbm_27.w = tmpvar_29.w;
  rgbm_27.xyz = ((tmpvar_29.xyz * tmpvar_29.w) * 6.0);
  tmpvar_5 = col_13.xyz;
  tmpvar_6 = (mg_12.x * _Metallic);
  tmpvar_7 = (mg_12.y * _Smoothness);
  tmpvar_8 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_11));
  highp vec4 shadowCoord_30;
  shadowCoord_30 = xlv_TEXCOORD5;
  highp float tmpvar_31;
  if ((xlv_TEXCOORD5.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_31 = 1.0;
  } else {
    highp vec2 tmpvar_32;
    tmpvar_32.x = LIGHT_PARAM.z;
    tmpvar_32.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_33;
    tmpvar_33.xy = tmpvar_32;
    highp float tmpvar_34;
    tmpvar_34 = (1.0/(LIGHT_PARAM.z));
    tmpvar_33.z = tmpvar_34;
    tmpvar_33.w = tmpvar_34;
    shadowCoord_30.y = (1.0 - xlv_TEXCOORD5.y);
    highp float shadow_35;
    highp vec2 tmpvar_36;
    tmpvar_36 = tmpvar_33.xy;
    shadow_35 = 0.0;
    highp vec3 tmpvar_37;
    tmpvar_37.xy = (shadowCoord_30.xy - LIGHT_PARAM.zz);
    tmpvar_37.z = shadowCoord_30.z;
    highp vec4 tmpvar_38;
    tmpvar_38 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_37.xy);
    highp float tmpvar_39;
    if ((tmpvar_38.x < xlv_TEXCOORD5.z)) {
      tmpvar_39 = 0.0;
    } else {
      tmpvar_39 = 1.0;
    };
    shadow_35 = tmpvar_39;
    highp vec2 tmpvar_40;
    tmpvar_40.x = 0.0;
    tmpvar_40.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (shadowCoord_30.xy + tmpvar_40);
    tmpvar_41.z = shadowCoord_30.z;
    highp vec4 tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41.xy);
    highp float tmpvar_43;
    if ((tmpvar_42.x < xlv_TEXCOORD5.z)) {
      tmpvar_43 = 0.0;
    } else {
      tmpvar_43 = 1.0;
    };
    shadow_35 = (tmpvar_39 + tmpvar_43);
    highp vec2 tmpvar_44;
    tmpvar_44.x = tmpvar_36.x;
    tmpvar_44.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (shadowCoord_30.xy + tmpvar_44);
    tmpvar_45.z = shadowCoord_30.z;
    highp vec4 tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45.xy);
    highp float tmpvar_47;
    if ((tmpvar_46.x < xlv_TEXCOORD5.z)) {
      tmpvar_47 = 0.0;
    } else {
      tmpvar_47 = 1.0;
    };
    shadow_35 = (shadow_35 + tmpvar_47);
    highp vec2 tmpvar_48;
    tmpvar_48.y = 0.0;
    tmpvar_48.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (shadowCoord_30.xy + tmpvar_48);
    tmpvar_49.z = shadowCoord_30.z;
    highp vec4 tmpvar_50;
    tmpvar_50 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_49.xy);
    highp float tmpvar_51;
    if ((tmpvar_50.x < xlv_TEXCOORD5.z)) {
      tmpvar_51 = 0.0;
    } else {
      tmpvar_51 = 1.0;
    };
    shadow_35 = (shadow_35 + tmpvar_51);
    highp vec4 tmpvar_52;
    tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, shadowCoord_30.xy);
    highp float tmpvar_53;
    if ((tmpvar_52.x < xlv_TEXCOORD5.z)) {
      tmpvar_53 = 0.0;
    } else {
      tmpvar_53 = 1.0;
    };
    shadow_35 = (shadow_35 + tmpvar_53);
    highp vec2 tmpvar_54;
    tmpvar_54.y = 0.0;
    tmpvar_54.x = tmpvar_36.x;
    highp vec3 tmpvar_55;
    tmpvar_55.xy = (shadowCoord_30.xy + tmpvar_54);
    tmpvar_55.z = shadowCoord_30.z;
    highp vec4 tmpvar_56;
    tmpvar_56 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_55.xy);
    highp float tmpvar_57;
    if ((tmpvar_56.x < xlv_TEXCOORD5.z)) {
      tmpvar_57 = 0.0;
    } else {
      tmpvar_57 = 1.0;
    };
    shadow_35 = (shadow_35 + tmpvar_57);
    highp vec2 tmpvar_58;
    tmpvar_58.x = -(LIGHT_PARAM.z);
    tmpvar_58.y = tmpvar_36.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (shadowCoord_30.xy + tmpvar_58);
    tmpvar_59.z = shadowCoord_30.z;
    highp vec4 tmpvar_60;
    tmpvar_60 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_59.xy);
    highp float tmpvar_61;
    if ((tmpvar_60.x < xlv_TEXCOORD5.z)) {
      tmpvar_61 = 0.0;
    } else {
      tmpvar_61 = 1.0;
    };
    shadow_35 = (shadow_35 + tmpvar_61);
    highp vec2 tmpvar_62;
    tmpvar_62.x = 0.0;
    tmpvar_62.y = tmpvar_36.y;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (shadowCoord_30.xy + tmpvar_62);
    tmpvar_63.z = shadowCoord_30.z;
    highp vec4 tmpvar_64;
    tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63.xy);
    highp float tmpvar_65;
    if ((tmpvar_64.x < xlv_TEXCOORD5.z)) {
      tmpvar_65 = 0.0;
    } else {
      tmpvar_65 = 1.0;
    };
    shadow_35 = (shadow_35 + tmpvar_65);
    highp vec3 tmpvar_66;
    tmpvar_66.xy = (shadowCoord_30.xy + LIGHT_PARAM.zz);
    tmpvar_66.z = shadowCoord_30.z;
    highp vec4 tmpvar_67;
    tmpvar_67 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_66.xy);
    highp float tmpvar_68;
    if ((tmpvar_67.x < xlv_TEXCOORD5.z)) {
      tmpvar_68 = 0.0;
    } else {
      tmpvar_68 = 1.0;
    };
    shadow_35 = (shadow_35 + tmpvar_68);
    shadow_35 = (shadow_35 / 9.0);
    tmpvar_31 = mix (1.0, shadow_35, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_69;
  highp vec3 tmpvar_70;
  tmpvar_69 = normalize((CAMERA_WORLDPOSITION - tmpvar_18));
  tmpvar_70 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_71;
  highp vec3 specularEnv_72;
  highp vec3 color_73;
  mediump float surfaceReduction_74;
  mediump float diffuseTerm_75;
  highp float perceptualRoughness_76;
  mediump vec3 tmpvar_77;
  mediump vec3 albedo_78;
  albedo_78 = tmpvar_5;
  mediump vec3 specColor_79;
  specColor_79 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_6)) + (albedo_78 * tmpvar_6));
  mediump float tmpvar_80;
  tmpvar_80 = (0.7790837 - (tmpvar_6 * 0.7790837));
  tmpvar_77 = (albedo_78 * tmpvar_80);
  tmpvar_71 = 0.0;
  mediump float alpha_81;
  alpha_81 = tmpvar_71;
  tmpvar_71 = alpha_81;
  mediump float tmpvar_82;
  tmpvar_82 = (1.0 - tmpvar_7);
  perceptualRoughness_76 = tmpvar_82;
  highp vec3 tmpvar_83;
  highp vec3 inVec_84;
  inVec_84 = (tmpvar_70 + tmpvar_69);
  tmpvar_83 = (inVec_84 * inversesqrt(max (0.001, 
    dot (inVec_84, inVec_84)
  )));
  highp float tmpvar_85;
  tmpvar_85 = abs(dot (tmpvar_69, normalWorld_9));
  highp float tmpvar_86;
  tmpvar_86 = clamp (dot (normalWorld_9, tmpvar_70), 0.0, 1.0);
  highp float tmpvar_87;
  tmpvar_87 = clamp (dot (normalWorld_9, tmpvar_83), 0.0, 1.0);
  mediump float tmpvar_88;
  highp float tmpvar_89;
  tmpvar_89 = clamp (dot (tmpvar_70, tmpvar_83), 0.0, 1.0);
  tmpvar_88 = tmpvar_89;
  mediump float tmpvar_90;
  mediump float NdotV_91;
  NdotV_91 = tmpvar_85;
  mediump float NdotL_92;
  NdotL_92 = tmpvar_86;
  mediump float perceptualRoughness_93;
  perceptualRoughness_93 = perceptualRoughness_76;
  mediump float tmpvar_94;
  tmpvar_94 = (0.5 + ((2.0 * tmpvar_88) * (tmpvar_88 * perceptualRoughness_93)));
  mediump float x_95;
  x_95 = (1.0 - NdotL_92);
  mediump float x_96;
  x_96 = (1.0 - NdotV_91);
  tmpvar_90 = ((1.0 + (
    (tmpvar_94 - 1.0)
   * 
    ((x_95 * x_95) * ((x_95 * x_95) * x_95))
  )) * (1.0 + (
    (tmpvar_94 - 1.0)
   * 
    ((x_96 * x_96) * ((x_96 * x_96) * x_96))
  )));
  highp float tmpvar_97;
  tmpvar_97 = (tmpvar_90 * tmpvar_86);
  diffuseTerm_75 = tmpvar_97;
  highp float tmpvar_98;
  tmpvar_98 = max ((perceptualRoughness_76 * perceptualRoughness_76), 0.002);
  highp float tmpvar_99;
  tmpvar_99 = (tmpvar_98 * tmpvar_98);
  highp float tmpvar_100;
  tmpvar_100 = (((
    (tmpvar_87 * tmpvar_99)
   - tmpvar_87) * tmpvar_87) + 1.0);
  surfaceReduction_74 = (1.0 - ((0.28 * tmpvar_98) * perceptualRoughness_76));
  mediump vec3 tmpvar_101;
  mediump float x_102;
  x_102 = (1.0 - tmpvar_88);
  tmpvar_101 = (specColor_79 + ((1.0 - specColor_79) * (
    (x_102 * x_102)
   * 
    ((x_102 * x_102) * x_102)
  )));
  color_73 = (((
    (tmpvar_77 * LIGHT_COLOR)
   * diffuseTerm_75) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_99)
       / 
        ((tmpvar_100 * tmpvar_100) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_86 * (
          (tmpvar_85 * (1.0 - tmpvar_98))
         + tmpvar_98)) + (tmpvar_85 * (
          (tmpvar_86 * (1.0 - tmpvar_98))
         + tmpvar_98))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_86)) * LIGHT_COLOR)
   * tmpvar_101)) * tmpvar_31);
  color_73 = (color_73 + tmpvar_8);
  color_73 = (color_73 + (tmpvar_77 * rgbm_27.xyz));
  mediump float cosA_103;
  cosA_103 = tmpvar_85;
  mediump float tmpvar_104;
  mediump float x_105;
  x_105 = (1.0 - cosA_103);
  tmpvar_104 = ((x_105 * x_105) * ((x_105 * x_105) * x_105));
  mediump vec3 tmpvar_106;
  tmpvar_106 = (surfaceReduction_74 * ((specColor_79 * 
    (1.0 - tmpvar_104)
  ) + (vec3(
    clamp ((tmpvar_7 + (1.0 - tmpvar_80)), 0.0, 1.0)
  ) * tmpvar_104)));
  specularEnv_72 = tmpvar_106;
  color_73 = (color_73 + (specularEnv_72 * rgbm_19.xyz));
  outColor_4.xyz = color_73;
  lowp vec4 tmpvar_107;
  tmpvar_107 = texture (_MaskTex, xlv_TEXCOORD0);
  maskCol_3 = tmpvar_107;
  outColor_4.w = ((col_13.w * maskCol_3.w) * _Opacity);
  highp vec3 tmpvar_108;
  tmpvar_108 = (xlv_TEXCOORD4.xyz / xlv_TEXCOORD4.w);
  highp vec2 tmpvar_109;
  tmpvar_109.x = tmpvar_108.x;
  tmpvar_109.y = (1.0 - tmpvar_108.y);
  lowp vec4 tmpvar_110;
  tmpvar_110 = texture (_BlendTex, tmpvar_109);
  dstColor_2 = tmpvar_110;
  srcColor_1 = outColor_4;
  outColor_4.w = ((col_13.w * maskCol_3.w) * _Opacity);
  highp int mode_111;
  mode_111 = int(_BlendType);
  bool tmpvar_112;
  tmpvar_112 = bool(1);
  highp vec3 tmpvar_113;
  if ((mode_111 == 1)) {
    tmpvar_113 = ((srcColor_1.www * srcColor_1.xyz) + (vec3((1.0 - srcColor_1.w)) * dstColor_2.xyz));
    tmpvar_112 = bool(0);
  } else {
    if ((mode_111 == 2)) {
      tmpvar_113 = ((srcColor_1.wwww * srcColor_1) + dstColor_2).xyz;
      tmpvar_112 = bool(0);
    } else {
      if ((mode_111 == 3)) {
        tmpvar_113 = (((srcColor_1 + 
          ((vec4(1.0, 1.0, 1.0, 1.0) - srcColor_1) * dstColor_2)
        ).xyz * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
        tmpvar_112 = bool(0);
      } else {
        if ((mode_111 == 4)) {
          highp float tmpvar_114;
          if ((dstColor_2.x < 0.5)) {
            tmpvar_114 = ((2.0 * srcColor_1.x) * dstColor_2.x);
          } else {
            tmpvar_114 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.x)
            ) * (1.0 - dstColor_2.x)));
          };
          highp float tmpvar_115;
          if ((dstColor_2.y < 0.5)) {
            tmpvar_115 = ((2.0 * srcColor_1.y) * dstColor_2.y);
          } else {
            tmpvar_115 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.y)
            ) * (1.0 - dstColor_2.y)));
          };
          highp float tmpvar_116;
          if ((dstColor_2.z < 0.5)) {
            tmpvar_116 = ((2.0 * srcColor_1.z) * dstColor_2.z);
          } else {
            tmpvar_116 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.z)
            ) * (1.0 - dstColor_2.z)));
          };
          highp vec3 tmpvar_117;
          tmpvar_117.x = tmpvar_114;
          tmpvar_117.y = tmpvar_115;
          tmpvar_117.z = tmpvar_116;
          tmpvar_113 = ((tmpvar_117 * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
          tmpvar_112 = bool(0);
        } else {
          if ((mode_111 == 5)) {
            highp float tmpvar_118;
            if ((dstColor_2.x < 0.5)) {
              tmpvar_118 = (((2.0 * dstColor_2.x) * srcColor_1.x) + ((dstColor_2.x * dstColor_2.x) * (1.0 - 
                (2.0 * srcColor_1.x)
              )));
            } else {
              tmpvar_118 = (((2.0 * dstColor_2.x) * (1.0 - srcColor_1.x)) + (sqrt(dstColor_2.x) * (
                (2.0 * srcColor_1.x)
               - 1.0)));
            };
            highp float tmpvar_119;
            if ((dstColor_2.y < 0.5)) {
              tmpvar_119 = (((2.0 * dstColor_2.y) * srcColor_1.y) + ((dstColor_2.y * dstColor_2.y) * (1.0 - 
                (2.0 * srcColor_1.y)
              )));
            } else {
              tmpvar_119 = (((2.0 * dstColor_2.y) * (1.0 - srcColor_1.y)) + (sqrt(dstColor_2.y) * (
                (2.0 * srcColor_1.y)
               - 1.0)));
            };
            highp float tmpvar_120;
            if ((dstColor_2.z < 0.5)) {
              tmpvar_120 = (((2.0 * dstColor_2.z) * srcColor_1.z) + ((dstColor_2.z * dstColor_2.z) * (1.0 - 
                (2.0 * srcColor_1.z)
              )));
            } else {
              tmpvar_120 = (((2.0 * dstColor_2.z) * (1.0 - srcColor_1.z)) + (sqrt(dstColor_2.z) * (
                (2.0 * srcColor_1.z)
               - 1.0)));
            };
            highp vec3 tmpvar_121;
            tmpvar_121.x = tmpvar_118;
            tmpvar_121.y = tmpvar_119;
            tmpvar_121.z = tmpvar_120;
            tmpvar_113 = ((tmpvar_121 * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
            tmpvar_112 = bool(0);
          } else {
            if ((mode_111 == 6)) {
              tmpvar_113 = ((max (srcColor_1.xyz, dstColor_2.xyz) * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
              tmpvar_112 = bool(0);
            } else {
              if ((mode_111 == 7)) {
                tmpvar_113 = (((srcColor_1.xyz * dstColor_2.xyz) * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
                tmpvar_112 = bool(0);
              };
            };
          };
        };
      };
    };
  };
  if (tmpvar_112) {
    tmpvar_113 = vec3(1.0, 0.0, 0.0);
    tmpvar_112 = bool(0);
  };
  outColor_4.xyz = tmpvar_113;
  outColor_4.w = 1.0;
  _glesFragData[0] = outColor_4;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendType",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_6 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_7));
  highp vec4 tmpvar_8;
  tmpvar_8.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_8.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_10;
  tmpvar_10 = (LOCALWORLD_TRANSFORM * tmpvar_9).xyz;
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_11 * _glesNormal));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_12 * _glesTangent));
  highp mat3 tmpvar_13;
  tmpvar_13[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_13[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_13[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_13 * _glesBinormal));
  tmpvar_2.w = tmpvar_10.x;
  tmpvar_3.w = tmpvar_10.y;
  tmpvar_4.w = tmpvar_10.z;
  tmpvar_5.zw = tmpvar_6.zw;
  tmpvar_5.xy = ((tmpvar_6.xy * 0.5) + (0.5 * tmpvar_6.ww));
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD4 = tmpvar_5;
  gl_Position = (tmpvar_8 * tmpvar_6);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _BlendTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _Opacity;
uniform highp float _BlendType;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 srcColor_1;
  highp vec4 dstColor_2;
  highp vec4 maskCol_3;
  highp vec4 outColor_4;
  highp vec3 tmpvar_5;
  mediump float tmpvar_6;
  mediump float tmpvar_7;
  highp vec3 normalWorld_8;
  highp vec3 normalTangent_9;
  highp vec3 emissionMapColor_10;
  highp vec2 mg_11;
  highp vec4 col_12;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture (_MainTex, xlv_TEXCOORD0);
  col_12 = tmpvar_13;
  lowp vec2 tmpvar_14;
  tmpvar_14 = texture (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_11 = tmpvar_14;
  lowp vec3 tmpvar_15;
  tmpvar_15 = texture (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_10 = tmpvar_15;
  lowp vec3 tmpvar_16;
  tmpvar_16 = texture (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_9 = tmpvar_16;
  normalTangent_9 = ((normalTangent_9 * 2.0) - 1.0);
  normalWorld_8 = normalize(((
    (normalTangent_9.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_9.y * xlv_TEXCOORD2.xyz)
  ) + (normalTangent_9.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_17;
  tmpvar_17.x = xlv_TEXCOORD1.w;
  tmpvar_17.y = xlv_TEXCOORD2.w;
  tmpvar_17.z = xlv_TEXCOORD3.w;
  highp vec4 rgbm_18;
  highp vec3 tmpvar_19;
  highp vec3 I_20;
  I_20 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_17)));
  tmpvar_19 = (I_20 - (2.0 * (
    dot (normalWorld_8, I_20)
   * normalWorld_8)));
  highp mat2 tmpvar_21;
  tmpvar_21[uint(0)].x = 1.0;
  tmpvar_21[uint(0)].y = 0.0;
  tmpvar_21[1u].x = -0.0;
  tmpvar_21[1u].y = 1.0;
  highp vec3 tmpvar_22;
  tmpvar_22.xy = (tmpvar_21 * tmpvar_19.xz);
  tmpvar_22.z = tmpvar_19.y;
  highp vec4 tmpvar_23;
  tmpvar_23.xyz = tmpvar_22.xzy;
  tmpvar_23.w = ((1.0 - (mg_11.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_24;
  tmpvar_24 = textureLod (_GlossEnvMap, tmpvar_22.xzy, tmpvar_23.w);
  highp vec4 tmpvar_25;
  tmpvar_25 = tmpvar_24;
  rgbm_18.w = tmpvar_25.w;
  rgbm_18.xyz = ((tmpvar_25.xyz * tmpvar_25.w) * 6.0);
  highp vec4 rgbm_26;
  lowp vec4 tmpvar_27;
  tmpvar_27 = texture (_IrradianceMap, normalWorld_8);
  highp vec4 tmpvar_28;
  tmpvar_28 = tmpvar_27;
  rgbm_26.w = tmpvar_28.w;
  rgbm_26.xyz = ((tmpvar_28.xyz * tmpvar_28.w) * 6.0);
  tmpvar_5 = col_12.xyz;
  tmpvar_6 = (mg_11.x * _Metallic);
  tmpvar_7 = (mg_11.y * _Smoothness);
  highp float tmpvar_29;
  highp vec3 specularEnv_30;
  highp vec3 color_31;
  mediump float surfaceReduction_32;
  highp float perceptualRoughness_33;
  mediump vec3 tmpvar_34;
  mediump vec3 albedo_35;
  albedo_35 = tmpvar_5;
  mediump float tmpvar_36;
  tmpvar_36 = (0.7790837 - (tmpvar_6 * 0.7790837));
  tmpvar_34 = (albedo_35 * tmpvar_36);
  tmpvar_29 = 0.0;
  mediump float alpha_37;
  alpha_37 = tmpvar_29;
  tmpvar_29 = alpha_37;
  mediump float tmpvar_38;
  tmpvar_38 = (1.0 - tmpvar_7);
  perceptualRoughness_33 = tmpvar_38;
  highp float tmpvar_39;
  tmpvar_39 = abs(dot (normalize(
    (CAMERA_WORLDPOSITION - tmpvar_17)
  ), normalWorld_8));
  highp float tmpvar_40;
  tmpvar_40 = max ((perceptualRoughness_33 * perceptualRoughness_33), 0.002);
  surfaceReduction_32 = (1.0 - ((0.28 * tmpvar_40) * perceptualRoughness_33));
  color_31 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_10));
  color_31 = (color_31 + (tmpvar_34 * rgbm_26.xyz));
  mediump float cosA_41;
  cosA_41 = tmpvar_39;
  mediump float tmpvar_42;
  mediump float x_43;
  x_43 = (1.0 - cosA_41);
  tmpvar_42 = ((x_43 * x_43) * ((x_43 * x_43) * x_43));
  mediump vec3 tmpvar_44;
  tmpvar_44 = (surfaceReduction_32 * ((
    ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_6)) + (albedo_35 * tmpvar_6))
   * 
    (1.0 - tmpvar_42)
  ) + (vec3(
    clamp ((tmpvar_7 + (1.0 - tmpvar_36)), 0.0, 1.0)
  ) * tmpvar_42)));
  specularEnv_30 = tmpvar_44;
  color_31 = (color_31 + (specularEnv_30 * rgbm_18.xyz));
  outColor_4.xyz = color_31;
  lowp vec4 tmpvar_45;
  tmpvar_45 = texture (_MaskTex, xlv_TEXCOORD0);
  maskCol_3 = tmpvar_45;
  outColor_4.w = ((col_12.w * maskCol_3.w) * _Opacity);
  highp vec3 tmpvar_46;
  tmpvar_46 = (xlv_TEXCOORD4.xyz / xlv_TEXCOORD4.w);
  highp vec2 tmpvar_47;
  tmpvar_47.x = tmpvar_46.x;
  tmpvar_47.y = (1.0 - tmpvar_46.y);
  lowp vec4 tmpvar_48;
  tmpvar_48 = texture (_BlendTex, tmpvar_47);
  dstColor_2 = tmpvar_48;
  srcColor_1 = outColor_4;
  outColor_4.w = ((col_12.w * maskCol_3.w) * _Opacity);
  highp int mode_49;
  mode_49 = int(_BlendType);
  bool tmpvar_50;
  tmpvar_50 = bool(1);
  highp vec3 tmpvar_51;
  if ((mode_49 == 1)) {
    tmpvar_51 = ((srcColor_1.www * srcColor_1.xyz) + (vec3((1.0 - srcColor_1.w)) * dstColor_2.xyz));
    tmpvar_50 = bool(0);
  } else {
    if ((mode_49 == 2)) {
      tmpvar_51 = ((srcColor_1.wwww * srcColor_1) + dstColor_2).xyz;
      tmpvar_50 = bool(0);
    } else {
      if ((mode_49 == 3)) {
        tmpvar_51 = (((srcColor_1 + 
          ((vec4(1.0, 1.0, 1.0, 1.0) - srcColor_1) * dstColor_2)
        ).xyz * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
        tmpvar_50 = bool(0);
      } else {
        if ((mode_49 == 4)) {
          highp float tmpvar_52;
          if ((dstColor_2.x < 0.5)) {
            tmpvar_52 = ((2.0 * srcColor_1.x) * dstColor_2.x);
          } else {
            tmpvar_52 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.x)
            ) * (1.0 - dstColor_2.x)));
          };
          highp float tmpvar_53;
          if ((dstColor_2.y < 0.5)) {
            tmpvar_53 = ((2.0 * srcColor_1.y) * dstColor_2.y);
          } else {
            tmpvar_53 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.y)
            ) * (1.0 - dstColor_2.y)));
          };
          highp float tmpvar_54;
          if ((dstColor_2.z < 0.5)) {
            tmpvar_54 = ((2.0 * srcColor_1.z) * dstColor_2.z);
          } else {
            tmpvar_54 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.z)
            ) * (1.0 - dstColor_2.z)));
          };
          highp vec3 tmpvar_55;
          tmpvar_55.x = tmpvar_52;
          tmpvar_55.y = tmpvar_53;
          tmpvar_55.z = tmpvar_54;
          tmpvar_51 = ((tmpvar_55 * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
          tmpvar_50 = bool(0);
        } else {
          if ((mode_49 == 5)) {
            highp float tmpvar_56;
            if ((dstColor_2.x < 0.5)) {
              tmpvar_56 = (((2.0 * dstColor_2.x) * srcColor_1.x) + ((dstColor_2.x * dstColor_2.x) * (1.0 - 
                (2.0 * srcColor_1.x)
              )));
            } else {
              tmpvar_56 = (((2.0 * dstColor_2.x) * (1.0 - srcColor_1.x)) + (sqrt(dstColor_2.x) * (
                (2.0 * srcColor_1.x)
               - 1.0)));
            };
            highp float tmpvar_57;
            if ((dstColor_2.y < 0.5)) {
              tmpvar_57 = (((2.0 * dstColor_2.y) * srcColor_1.y) + ((dstColor_2.y * dstColor_2.y) * (1.0 - 
                (2.0 * srcColor_1.y)
              )));
            } else {
              tmpvar_57 = (((2.0 * dstColor_2.y) * (1.0 - srcColor_1.y)) + (sqrt(dstColor_2.y) * (
                (2.0 * srcColor_1.y)
               - 1.0)));
            };
            highp float tmpvar_58;
            if ((dstColor_2.z < 0.5)) {
              tmpvar_58 = (((2.0 * dstColor_2.z) * srcColor_1.z) + ((dstColor_2.z * dstColor_2.z) * (1.0 - 
                (2.0 * srcColor_1.z)
              )));
            } else {
              tmpvar_58 = (((2.0 * dstColor_2.z) * (1.0 - srcColor_1.z)) + (sqrt(dstColor_2.z) * (
                (2.0 * srcColor_1.z)
               - 1.0)));
            };
            highp vec3 tmpvar_59;
            tmpvar_59.x = tmpvar_56;
            tmpvar_59.y = tmpvar_57;
            tmpvar_59.z = tmpvar_58;
            tmpvar_51 = ((tmpvar_59 * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
            tmpvar_50 = bool(0);
          } else {
            if ((mode_49 == 6)) {
              tmpvar_51 = ((max (srcColor_1.xyz, dstColor_2.xyz) * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
              tmpvar_50 = bool(0);
            } else {
              if ((mode_49 == 7)) {
                tmpvar_51 = (((srcColor_1.xyz * dstColor_2.xyz) * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
                tmpvar_50 = bool(0);
              };
            };
          };
        };
      };
    };
  };
  if (tmpvar_50) {
    tmpvar_51 = vec3(1.0, 0.0, 0.0);
    tmpvar_50 = bool(0);
  };
  outColor_4.xyz = tmpvar_51;
  outColor_4.w = 1.0;
  _glesFragData[0] = outColor_4;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendType",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_6 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_7));
  highp vec4 tmpvar_8;
  tmpvar_8.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_8.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_10;
  tmpvar_10 = (LOCALWORLD_TRANSFORM * tmpvar_9).xyz;
  highp mat3 tmpvar_11;
  tmpvar_11[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_11[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_11[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_11 * _glesNormal));
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_12 * _glesTangent));
  highp mat3 tmpvar_13;
  tmpvar_13[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_13[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_13[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_13 * _glesBinormal));
  tmpvar_2.w = tmpvar_10.x;
  tmpvar_3.w = tmpvar_10.y;
  tmpvar_4.w = tmpvar_10.z;
  tmpvar_5.zw = tmpvar_6.zw;
  tmpvar_5.xy = ((tmpvar_6.xy * 0.5) + (0.5 * tmpvar_6.ww));
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD4 = tmpvar_5;
  gl_Position = (tmpvar_8 * tmpvar_6);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _BlendTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _Opacity;
uniform highp float _BlendType;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 srcColor_1;
  highp vec4 dstColor_2;
  highp vec4 maskCol_3;
  highp vec4 outColor_4;
  highp vec3 tmpvar_5;
  mediump float tmpvar_6;
  mediump float tmpvar_7;
  highp vec3 normalWorld_8;
  highp vec3 normalTangent_9;
  highp vec3 emissionMapColor_10;
  highp vec2 mg_11;
  highp vec4 col_12;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture (_MainTex, xlv_TEXCOORD0);
  col_12 = tmpvar_13;
  lowp vec2 tmpvar_14;
  tmpvar_14 = texture (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_11 = tmpvar_14;
  lowp vec3 tmpvar_15;
  tmpvar_15 = texture (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_10 = tmpvar_15;
  lowp vec3 tmpvar_16;
  tmpvar_16 = texture (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_9 = tmpvar_16;
  normalTangent_9 = ((normalTangent_9 * 2.0) - 1.0);
  normalWorld_8 = normalize(((
    (normalTangent_9.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_9.y * xlv_TEXCOORD2.xyz)
  ) + (normalTangent_9.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_17;
  tmpvar_17.x = xlv_TEXCOORD1.w;
  tmpvar_17.y = xlv_TEXCOORD2.w;
  tmpvar_17.z = xlv_TEXCOORD3.w;
  highp vec4 rgbm_18;
  highp vec3 tmpvar_19;
  highp vec3 I_20;
  I_20 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_17)));
  tmpvar_19 = (I_20 - (2.0 * (
    dot (normalWorld_8, I_20)
   * normalWorld_8)));
  highp mat2 tmpvar_21;
  tmpvar_21[uint(0)].x = 1.0;
  tmpvar_21[uint(0)].y = 0.0;
  tmpvar_21[1u].x = -0.0;
  tmpvar_21[1u].y = 1.0;
  highp vec3 tmpvar_22;
  tmpvar_22.xy = (tmpvar_21 * tmpvar_19.xz);
  tmpvar_22.z = tmpvar_19.y;
  highp vec4 tmpvar_23;
  tmpvar_23.xyz = tmpvar_22.xzy;
  tmpvar_23.w = ((1.0 - (mg_11.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_24;
  tmpvar_24 = textureLod (_GlossEnvMap, tmpvar_22.xzy, tmpvar_23.w);
  highp vec4 tmpvar_25;
  tmpvar_25 = tmpvar_24;
  rgbm_18.w = tmpvar_25.w;
  rgbm_18.xyz = ((tmpvar_25.xyz * tmpvar_25.w) * 6.0);
  highp vec4 rgbm_26;
  lowp vec4 tmpvar_27;
  tmpvar_27 = texture (_IrradianceMap, normalWorld_8);
  highp vec4 tmpvar_28;
  tmpvar_28 = tmpvar_27;
  rgbm_26.w = tmpvar_28.w;
  rgbm_26.xyz = ((tmpvar_28.xyz * tmpvar_28.w) * 6.0);
  tmpvar_5 = col_12.xyz;
  tmpvar_6 = (mg_11.x * _Metallic);
  tmpvar_7 = (mg_11.y * _Smoothness);
  highp vec3 tmpvar_29;
  highp vec3 tmpvar_30;
  tmpvar_29 = normalize((CAMERA_WORLDPOSITION - tmpvar_17));
  tmpvar_30 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_31;
  highp vec3 specularEnv_32;
  highp vec3 color_33;
  mediump float surfaceReduction_34;
  mediump float diffuseTerm_35;
  highp float perceptualRoughness_36;
  mediump vec3 tmpvar_37;
  mediump vec3 albedo_38;
  albedo_38 = tmpvar_5;
  mediump vec3 specColor_39;
  specColor_39 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_6)) + (albedo_38 * tmpvar_6));
  mediump float tmpvar_40;
  tmpvar_40 = (0.7790837 - (tmpvar_6 * 0.7790837));
  tmpvar_37 = (albedo_38 * tmpvar_40);
  tmpvar_31 = 0.0;
  mediump float alpha_41;
  alpha_41 = tmpvar_31;
  tmpvar_31 = alpha_41;
  mediump float tmpvar_42;
  tmpvar_42 = (1.0 - tmpvar_7);
  perceptualRoughness_36 = tmpvar_42;
  highp vec3 tmpvar_43;
  highp vec3 inVec_44;
  inVec_44 = (tmpvar_30 + tmpvar_29);
  tmpvar_43 = (inVec_44 * inversesqrt(max (0.001, 
    dot (inVec_44, inVec_44)
  )));
  highp float tmpvar_45;
  tmpvar_45 = abs(dot (tmpvar_29, normalWorld_8));
  highp float tmpvar_46;
  tmpvar_46 = clamp (dot (normalWorld_8, tmpvar_30), 0.0, 1.0);
  highp float tmpvar_47;
  tmpvar_47 = clamp (dot (normalWorld_8, tmpvar_43), 0.0, 1.0);
  mediump float tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = clamp (dot (tmpvar_30, tmpvar_43), 0.0, 1.0);
  tmpvar_48 = tmpvar_49;
  mediump float tmpvar_50;
  mediump float NdotV_51;
  NdotV_51 = tmpvar_45;
  mediump float NdotL_52;
  NdotL_52 = tmpvar_46;
  mediump float perceptualRoughness_53;
  perceptualRoughness_53 = perceptualRoughness_36;
  mediump float tmpvar_54;
  tmpvar_54 = (0.5 + ((2.0 * tmpvar_48) * (tmpvar_48 * perceptualRoughness_53)));
  mediump float x_55;
  x_55 = (1.0 - NdotL_52);
  mediump float x_56;
  x_56 = (1.0 - NdotV_51);
  tmpvar_50 = ((1.0 + (
    (tmpvar_54 - 1.0)
   * 
    ((x_55 * x_55) * ((x_55 * x_55) * x_55))
  )) * (1.0 + (
    (tmpvar_54 - 1.0)
   * 
    ((x_56 * x_56) * ((x_56 * x_56) * x_56))
  )));
  highp float tmpvar_57;
  tmpvar_57 = (tmpvar_50 * tmpvar_46);
  diffuseTerm_35 = tmpvar_57;
  highp float tmpvar_58;
  tmpvar_58 = max ((perceptualRoughness_36 * perceptualRoughness_36), 0.002);
  highp float tmpvar_59;
  tmpvar_59 = (tmpvar_58 * tmpvar_58);
  highp float tmpvar_60;
  tmpvar_60 = (((
    (tmpvar_47 * tmpvar_59)
   - tmpvar_47) * tmpvar_47) + 1.0);
  surfaceReduction_34 = (1.0 - ((0.28 * tmpvar_58) * perceptualRoughness_36));
  mediump vec3 tmpvar_61;
  mediump float x_62;
  x_62 = (1.0 - tmpvar_48);
  tmpvar_61 = (specColor_39 + ((1.0 - specColor_39) * (
    (x_62 * x_62)
   * 
    ((x_62 * x_62) * x_62)
  )));
  color_33 = (((tmpvar_37 * LIGHT_COLOR) * diffuseTerm_35) + ((
    max (0.0, (sqrt(max (0.0001, 
      ((((0.3183099 * tmpvar_59) / (
        (tmpvar_60 * tmpvar_60)
       + 1e-7)) * (0.5 / (
        ((tmpvar_46 * ((tmpvar_45 * 
          (1.0 - tmpvar_58)
        ) + tmpvar_58)) + (tmpvar_45 * ((tmpvar_46 * 
          (1.0 - tmpvar_58)
        ) + tmpvar_58)))
       + 0.0001))) * 3.141593)
    )) * tmpvar_46))
   * LIGHT_COLOR) * tmpvar_61));
  color_33 = (color_33 + (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_10)));
  color_33 = (color_33 + (tmpvar_37 * rgbm_26.xyz));
  mediump float cosA_63;
  cosA_63 = tmpvar_45;
  mediump float tmpvar_64;
  mediump float x_65;
  x_65 = (1.0 - cosA_63);
  tmpvar_64 = ((x_65 * x_65) * ((x_65 * x_65) * x_65));
  mediump vec3 tmpvar_66;
  tmpvar_66 = (surfaceReduction_34 * ((specColor_39 * 
    (1.0 - tmpvar_64)
  ) + (vec3(
    clamp ((tmpvar_7 + (1.0 - tmpvar_40)), 0.0, 1.0)
  ) * tmpvar_64)));
  specularEnv_32 = tmpvar_66;
  color_33 = (color_33 + (specularEnv_32 * rgbm_18.xyz));
  outColor_4.xyz = color_33;
  lowp vec4 tmpvar_67;
  tmpvar_67 = texture (_MaskTex, xlv_TEXCOORD0);
  maskCol_3 = tmpvar_67;
  outColor_4.w = ((col_12.w * maskCol_3.w) * _Opacity);
  highp vec3 tmpvar_68;
  tmpvar_68 = (xlv_TEXCOORD4.xyz / xlv_TEXCOORD4.w);
  highp vec2 tmpvar_69;
  tmpvar_69.x = tmpvar_68.x;
  tmpvar_69.y = (1.0 - tmpvar_68.y);
  lowp vec4 tmpvar_70;
  tmpvar_70 = texture (_BlendTex, tmpvar_69);
  dstColor_2 = tmpvar_70;
  srcColor_1 = outColor_4;
  outColor_4.w = ((col_12.w * maskCol_3.w) * _Opacity);
  highp int mode_71;
  mode_71 = int(_BlendType);
  bool tmpvar_72;
  tmpvar_72 = bool(1);
  highp vec3 tmpvar_73;
  if ((mode_71 == 1)) {
    tmpvar_73 = ((srcColor_1.www * srcColor_1.xyz) + (vec3((1.0 - srcColor_1.w)) * dstColor_2.xyz));
    tmpvar_72 = bool(0);
  } else {
    if ((mode_71 == 2)) {
      tmpvar_73 = ((srcColor_1.wwww * srcColor_1) + dstColor_2).xyz;
      tmpvar_72 = bool(0);
    } else {
      if ((mode_71 == 3)) {
        tmpvar_73 = (((srcColor_1 + 
          ((vec4(1.0, 1.0, 1.0, 1.0) - srcColor_1) * dstColor_2)
        ).xyz * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
        tmpvar_72 = bool(0);
      } else {
        if ((mode_71 == 4)) {
          highp float tmpvar_74;
          if ((dstColor_2.x < 0.5)) {
            tmpvar_74 = ((2.0 * srcColor_1.x) * dstColor_2.x);
          } else {
            tmpvar_74 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.x)
            ) * (1.0 - dstColor_2.x)));
          };
          highp float tmpvar_75;
          if ((dstColor_2.y < 0.5)) {
            tmpvar_75 = ((2.0 * srcColor_1.y) * dstColor_2.y);
          } else {
            tmpvar_75 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.y)
            ) * (1.0 - dstColor_2.y)));
          };
          highp float tmpvar_76;
          if ((dstColor_2.z < 0.5)) {
            tmpvar_76 = ((2.0 * srcColor_1.z) * dstColor_2.z);
          } else {
            tmpvar_76 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.z)
            ) * (1.0 - dstColor_2.z)));
          };
          highp vec3 tmpvar_77;
          tmpvar_77.x = tmpvar_74;
          tmpvar_77.y = tmpvar_75;
          tmpvar_77.z = tmpvar_76;
          tmpvar_73 = ((tmpvar_77 * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
          tmpvar_72 = bool(0);
        } else {
          if ((mode_71 == 5)) {
            highp float tmpvar_78;
            if ((dstColor_2.x < 0.5)) {
              tmpvar_78 = (((2.0 * dstColor_2.x) * srcColor_1.x) + ((dstColor_2.x * dstColor_2.x) * (1.0 - 
                (2.0 * srcColor_1.x)
              )));
            } else {
              tmpvar_78 = (((2.0 * dstColor_2.x) * (1.0 - srcColor_1.x)) + (sqrt(dstColor_2.x) * (
                (2.0 * srcColor_1.x)
               - 1.0)));
            };
            highp float tmpvar_79;
            if ((dstColor_2.y < 0.5)) {
              tmpvar_79 = (((2.0 * dstColor_2.y) * srcColor_1.y) + ((dstColor_2.y * dstColor_2.y) * (1.0 - 
                (2.0 * srcColor_1.y)
              )));
            } else {
              tmpvar_79 = (((2.0 * dstColor_2.y) * (1.0 - srcColor_1.y)) + (sqrt(dstColor_2.y) * (
                (2.0 * srcColor_1.y)
               - 1.0)));
            };
            highp float tmpvar_80;
            if ((dstColor_2.z < 0.5)) {
              tmpvar_80 = (((2.0 * dstColor_2.z) * srcColor_1.z) + ((dstColor_2.z * dstColor_2.z) * (1.0 - 
                (2.0 * srcColor_1.z)
              )));
            } else {
              tmpvar_80 = (((2.0 * dstColor_2.z) * (1.0 - srcColor_1.z)) + (sqrt(dstColor_2.z) * (
                (2.0 * srcColor_1.z)
               - 1.0)));
            };
            highp vec3 tmpvar_81;
            tmpvar_81.x = tmpvar_78;
            tmpvar_81.y = tmpvar_79;
            tmpvar_81.z = tmpvar_80;
            tmpvar_73 = ((tmpvar_81 * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
            tmpvar_72 = bool(0);
          } else {
            if ((mode_71 == 6)) {
              tmpvar_73 = ((max (srcColor_1.xyz, dstColor_2.xyz) * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
              tmpvar_72 = bool(0);
            } else {
              if ((mode_71 == 7)) {
                tmpvar_73 = (((srcColor_1.xyz * dstColor_2.xyz) * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
                tmpvar_72 = bool(0);
              };
            };
          };
        };
      };
    };
  };
  if (tmpvar_72) {
    tmpvar_73 = vec3(1.0, 0.0, 0.0);
    tmpvar_72 = bool(0);
  };
  outColor_4.xyz = tmpvar_73;
  outColor_4.w = 1.0;
  _glesFragData[0] = outColor_4;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendType",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  tmpvar_7 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_8));
  highp vec4 tmpvar_9;
  tmpvar_9.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_9.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_11;
  tmpvar_11 = (LOCALWORLD_TRANSFORM * tmpvar_10).xyz;
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_12 * _glesNormal));
  highp mat3 tmpvar_13;
  tmpvar_13[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_13[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_13[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_13 * _glesTangent));
  highp mat3 tmpvar_14;
  tmpvar_14[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_14[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_14[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_14 * _glesBinormal));
  tmpvar_2.w = tmpvar_11.x;
  tmpvar_3.w = tmpvar_11.y;
  tmpvar_4.w = tmpvar_11.z;
  tmpvar_5.zw = tmpvar_7.zw;
  tmpvar_5.xy = ((tmpvar_7.xy * 0.5) + (0.5 * tmpvar_7.ww));
  highp vec4 tmpvar_15;
  tmpvar_15.w = 1.0;
  tmpvar_15.xyz = tmpvar_1.xyz;
  tmpvar_6.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_15))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_16;
  tmpvar_16.w = 1.0;
  tmpvar_16.xyz = tmpvar_1.xyz;
  tmpvar_6.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_16)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD4 = tmpvar_5;
  gl_Position = (tmpvar_9 * tmpvar_7);
  xlv_TEXCOORD5 = tmpvar_6;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _BlendTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _Opacity;
uniform highp float _BlendType;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
in highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 srcColor_1;
  highp vec4 dstColor_2;
  highp vec4 maskCol_3;
  highp vec4 outColor_4;
  highp vec3 tmpvar_5;
  mediump float tmpvar_6;
  mediump float tmpvar_7;
  highp vec3 tmpvar_8;
  highp vec3 normalWorld_9;
  highp vec3 normalTangent_10;
  highp vec3 emissionMapColor_11;
  highp vec2 mg_12;
  highp vec4 col_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture (_MainTex, xlv_TEXCOORD0);
  col_13 = tmpvar_14;
  lowp vec2 tmpvar_15;
  tmpvar_15 = texture (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_12 = tmpvar_15;
  lowp vec3 tmpvar_16;
  tmpvar_16 = texture (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_11 = tmpvar_16;
  lowp vec3 tmpvar_17;
  tmpvar_17 = texture (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_10 = tmpvar_17;
  normalTangent_10 = ((normalTangent_10 * 2.0) - 1.0);
  normalWorld_9 = normalize(((
    (normalTangent_10.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_10.y * xlv_TEXCOORD2.xyz)
  ) + (normalTangent_10.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_18;
  tmpvar_18.x = xlv_TEXCOORD1.w;
  tmpvar_18.y = xlv_TEXCOORD2.w;
  tmpvar_18.z = xlv_TEXCOORD3.w;
  highp vec4 rgbm_19;
  highp vec3 tmpvar_20;
  highp vec3 I_21;
  I_21 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_18)));
  tmpvar_20 = (I_21 - (2.0 * (
    dot (normalWorld_9, I_21)
   * normalWorld_9)));
  highp mat2 tmpvar_22;
  tmpvar_22[uint(0)].x = 1.0;
  tmpvar_22[uint(0)].y = 0.0;
  tmpvar_22[1u].x = -0.0;
  tmpvar_22[1u].y = 1.0;
  highp vec3 tmpvar_23;
  tmpvar_23.xy = (tmpvar_22 * tmpvar_20.xz);
  tmpvar_23.z = tmpvar_20.y;
  highp vec4 tmpvar_24;
  tmpvar_24.xyz = tmpvar_23.xzy;
  tmpvar_24.w = ((1.0 - (mg_12.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_25;
  tmpvar_25 = textureLod (_GlossEnvMap, tmpvar_23.xzy, tmpvar_24.w);
  highp vec4 tmpvar_26;
  tmpvar_26 = tmpvar_25;
  rgbm_19.w = tmpvar_26.w;
  rgbm_19.xyz = ((tmpvar_26.xyz * tmpvar_26.w) * 6.0);
  highp vec4 rgbm_27;
  lowp vec4 tmpvar_28;
  tmpvar_28 = texture (_IrradianceMap, normalWorld_9);
  highp vec4 tmpvar_29;
  tmpvar_29 = tmpvar_28;
  rgbm_27.w = tmpvar_29.w;
  rgbm_27.xyz = ((tmpvar_29.xyz * tmpvar_29.w) * 6.0);
  tmpvar_5 = col_13.xyz;
  tmpvar_6 = (mg_12.x * _Metallic);
  tmpvar_7 = (mg_12.y * _Smoothness);
  tmpvar_8 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_11));
  highp vec4 shadowCoord_30;
  shadowCoord_30 = xlv_TEXCOORD5;
  highp float tmpvar_31;
  if ((xlv_TEXCOORD5.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_31 = 1.0;
  } else {
    shadowCoord_30.y = (1.0 - xlv_TEXCOORD5.y);
    highp vec2 fetchesOffsetsV_32;
    highp vec2 fetchesOffsetsU_33;
    highp float shadow_34;
    highp vec2 tmpvar_35;
    tmpvar_35 = (shadowCoord_30.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_36;
    tmpvar_36 = floor((tmpvar_35 + 0.5));
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_35 - tmpvar_36);
    highp vec4 computedWeight_38;
    highp vec4 computedArea_39;
    highp vec4 computedAreaUncut_40;
    highp float tmpvar_41;
    tmpvar_41 = (((tmpvar_37.x + 0.5) * (tmpvar_37.x + 0.5)) * 0.5);
    highp float tmpvar_42;
    tmpvar_42 = (tmpvar_41 - tmpvar_37.x);
    computedArea_39.x = tmpvar_42;
    computedAreaUncut_40.x = tmpvar_42;
    computedArea_39.w = tmpvar_41;
    computedAreaUncut_40.w = tmpvar_41;
    computedAreaUncut_40.y = ((1.5 - tmpvar_37.x) - 0.5);
    highp float tmpvar_43;
    tmpvar_43 = min (tmpvar_37.x, 0.0);
    computedArea_39.y = (computedAreaUncut_40.y - (tmpvar_43 * tmpvar_43));
    computedAreaUncut_40.z = ((1.5 + tmpvar_37.x) - 0.5);
    highp float tmpvar_44;
    tmpvar_44 = max (tmpvar_37.x, 0.0);
    computedArea_39.z = (computedAreaUncut_40.z - (tmpvar_44 * tmpvar_44));
    computedWeight_38 = (computedArea_39 * 0.44444);
    highp vec4 computedWeight_45;
    highp vec4 computedArea_46;
    highp vec4 computedAreaUncut_47;
    highp float tmpvar_48;
    tmpvar_48 = (((tmpvar_37.y + 0.5) * (tmpvar_37.y + 0.5)) * 0.5);
    highp float tmpvar_49;
    tmpvar_49 = (tmpvar_48 - tmpvar_37.y);
    computedArea_46.x = tmpvar_49;
    computedAreaUncut_47.x = tmpvar_49;
    computedArea_46.w = tmpvar_48;
    computedAreaUncut_47.w = tmpvar_48;
    computedAreaUncut_47.y = ((1.5 - tmpvar_37.y) - 0.5);
    highp float tmpvar_50;
    tmpvar_50 = min (tmpvar_37.y, 0.0);
    computedArea_46.y = (computedAreaUncut_47.y - (tmpvar_50 * tmpvar_50));
    computedAreaUncut_47.z = ((1.5 + tmpvar_37.y) - 0.5);
    highp float tmpvar_51;
    tmpvar_51 = max (tmpvar_37.y, 0.0);
    computedArea_46.z = (computedAreaUncut_47.z - (tmpvar_51 * tmpvar_51));
    computedWeight_45 = (computedArea_46 * 0.44444);
    highp vec2 tmpvar_52;
    tmpvar_52 = (computedWeight_38.xz + computedWeight_38.yw);
    highp vec2 tmpvar_53;
    tmpvar_53 = (computedWeight_45.xz + computedWeight_45.yw);
    fetchesOffsetsU_33 = (((computedWeight_38.yw / tmpvar_52) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_32 = (((computedWeight_45.yw / tmpvar_53) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_54;
    tmpvar_54 = (tmpvar_36 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_55;
    tmpvar_55.x = fetchesOffsetsU_33.x;
    tmpvar_55.y = fetchesOffsetsV_32.x;
    highp vec3 tmpvar_56;
    tmpvar_56.xy = (tmpvar_54 + tmpvar_55);
    tmpvar_56.z = shadowCoord_30.z;
    mediump float tmpvar_57;
    tmpvar_57 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_56);
    shadow_34 = ((tmpvar_52.x * tmpvar_53.x) * tmpvar_57);
    highp vec2 tmpvar_58;
    tmpvar_58.x = fetchesOffsetsU_33.y;
    tmpvar_58.y = fetchesOffsetsV_32.x;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (tmpvar_54 + tmpvar_58);
    tmpvar_59.z = shadowCoord_30.z;
    mediump float tmpvar_60;
    tmpvar_60 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_59);
    shadow_34 = (shadow_34 + ((tmpvar_52.y * tmpvar_53.x) * tmpvar_60));
    highp vec2 tmpvar_61;
    tmpvar_61.x = fetchesOffsetsU_33.x;
    tmpvar_61.y = fetchesOffsetsV_32.y;
    highp vec3 tmpvar_62;
    tmpvar_62.xy = (tmpvar_54 + tmpvar_61);
    tmpvar_62.z = shadowCoord_30.z;
    mediump float tmpvar_63;
    tmpvar_63 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_62);
    shadow_34 = (shadow_34 + ((tmpvar_52.x * tmpvar_53.y) * tmpvar_63));
    highp vec2 tmpvar_64;
    tmpvar_64.x = fetchesOffsetsU_33.y;
    tmpvar_64.y = fetchesOffsetsV_32.y;
    highp vec3 tmpvar_65;
    tmpvar_65.xy = (tmpvar_54 + tmpvar_64);
    tmpvar_65.z = shadowCoord_30.z;
    mediump float tmpvar_66;
    tmpvar_66 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_65);
    shadow_34 = (shadow_34 + ((tmpvar_52.y * tmpvar_53.y) * tmpvar_66));
    tmpvar_31 = mix (1.0, shadow_34, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_67;
  highp vec3 tmpvar_68;
  tmpvar_67 = normalize((CAMERA_WORLDPOSITION - tmpvar_18));
  tmpvar_68 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_69;
  highp vec3 specularEnv_70;
  highp vec3 color_71;
  mediump float surfaceReduction_72;
  mediump float diffuseTerm_73;
  highp float perceptualRoughness_74;
  mediump vec3 tmpvar_75;
  mediump vec3 albedo_76;
  albedo_76 = tmpvar_5;
  mediump vec3 specColor_77;
  specColor_77 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_6)) + (albedo_76 * tmpvar_6));
  mediump float tmpvar_78;
  tmpvar_78 = (0.7790837 - (tmpvar_6 * 0.7790837));
  tmpvar_75 = (albedo_76 * tmpvar_78);
  tmpvar_69 = 0.0;
  mediump float alpha_79;
  alpha_79 = tmpvar_69;
  tmpvar_69 = alpha_79;
  mediump float tmpvar_80;
  tmpvar_80 = (1.0 - tmpvar_7);
  perceptualRoughness_74 = tmpvar_80;
  highp vec3 tmpvar_81;
  highp vec3 inVec_82;
  inVec_82 = (tmpvar_68 + tmpvar_67);
  tmpvar_81 = (inVec_82 * inversesqrt(max (0.001, 
    dot (inVec_82, inVec_82)
  )));
  highp float tmpvar_83;
  tmpvar_83 = abs(dot (tmpvar_67, normalWorld_9));
  highp float tmpvar_84;
  tmpvar_84 = clamp (dot (normalWorld_9, tmpvar_68), 0.0, 1.0);
  highp float tmpvar_85;
  tmpvar_85 = clamp (dot (normalWorld_9, tmpvar_81), 0.0, 1.0);
  mediump float tmpvar_86;
  highp float tmpvar_87;
  tmpvar_87 = clamp (dot (tmpvar_68, tmpvar_81), 0.0, 1.0);
  tmpvar_86 = tmpvar_87;
  mediump float tmpvar_88;
  mediump float NdotV_89;
  NdotV_89 = tmpvar_83;
  mediump float NdotL_90;
  NdotL_90 = tmpvar_84;
  mediump float perceptualRoughness_91;
  perceptualRoughness_91 = perceptualRoughness_74;
  mediump float tmpvar_92;
  tmpvar_92 = (0.5 + ((2.0 * tmpvar_86) * (tmpvar_86 * perceptualRoughness_91)));
  mediump float x_93;
  x_93 = (1.0 - NdotL_90);
  mediump float x_94;
  x_94 = (1.0 - NdotV_89);
  tmpvar_88 = ((1.0 + (
    (tmpvar_92 - 1.0)
   * 
    ((x_93 * x_93) * ((x_93 * x_93) * x_93))
  )) * (1.0 + (
    (tmpvar_92 - 1.0)
   * 
    ((x_94 * x_94) * ((x_94 * x_94) * x_94))
  )));
  highp float tmpvar_95;
  tmpvar_95 = (tmpvar_88 * tmpvar_84);
  diffuseTerm_73 = tmpvar_95;
  highp float tmpvar_96;
  tmpvar_96 = max ((perceptualRoughness_74 * perceptualRoughness_74), 0.002);
  highp float tmpvar_97;
  tmpvar_97 = (tmpvar_96 * tmpvar_96);
  highp float tmpvar_98;
  tmpvar_98 = (((
    (tmpvar_85 * tmpvar_97)
   - tmpvar_85) * tmpvar_85) + 1.0);
  surfaceReduction_72 = (1.0 - ((0.28 * tmpvar_96) * perceptualRoughness_74));
  mediump vec3 tmpvar_99;
  mediump float x_100;
  x_100 = (1.0 - tmpvar_86);
  tmpvar_99 = (specColor_77 + ((1.0 - specColor_77) * (
    (x_100 * x_100)
   * 
    ((x_100 * x_100) * x_100)
  )));
  color_71 = (((
    (tmpvar_75 * LIGHT_COLOR)
   * diffuseTerm_73) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_97)
       / 
        ((tmpvar_98 * tmpvar_98) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_84 * (
          (tmpvar_83 * (1.0 - tmpvar_96))
         + tmpvar_96)) + (tmpvar_83 * (
          (tmpvar_84 * (1.0 - tmpvar_96))
         + tmpvar_96))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_84)) * LIGHT_COLOR)
   * tmpvar_99)) * tmpvar_31);
  color_71 = (color_71 + tmpvar_8);
  color_71 = (color_71 + (tmpvar_75 * rgbm_27.xyz));
  mediump float cosA_101;
  cosA_101 = tmpvar_83;
  mediump float tmpvar_102;
  mediump float x_103;
  x_103 = (1.0 - cosA_101);
  tmpvar_102 = ((x_103 * x_103) * ((x_103 * x_103) * x_103));
  mediump vec3 tmpvar_104;
  tmpvar_104 = (surfaceReduction_72 * ((specColor_77 * 
    (1.0 - tmpvar_102)
  ) + (vec3(
    clamp ((tmpvar_7 + (1.0 - tmpvar_78)), 0.0, 1.0)
  ) * tmpvar_102)));
  specularEnv_70 = tmpvar_104;
  color_71 = (color_71 + (specularEnv_70 * rgbm_19.xyz));
  outColor_4.xyz = color_71;
  lowp vec4 tmpvar_105;
  tmpvar_105 = texture (_MaskTex, xlv_TEXCOORD0);
  maskCol_3 = tmpvar_105;
  outColor_4.w = ((col_13.w * maskCol_3.w) * _Opacity);
  highp vec3 tmpvar_106;
  tmpvar_106 = (xlv_TEXCOORD4.xyz / xlv_TEXCOORD4.w);
  highp vec2 tmpvar_107;
  tmpvar_107.x = tmpvar_106.x;
  tmpvar_107.y = (1.0 - tmpvar_106.y);
  lowp vec4 tmpvar_108;
  tmpvar_108 = texture (_BlendTex, tmpvar_107);
  dstColor_2 = tmpvar_108;
  srcColor_1 = outColor_4;
  outColor_4.w = ((col_13.w * maskCol_3.w) * _Opacity);
  highp int mode_109;
  mode_109 = int(_BlendType);
  bool tmpvar_110;
  tmpvar_110 = bool(1);
  highp vec3 tmpvar_111;
  if ((mode_109 == 1)) {
    tmpvar_111 = ((srcColor_1.www * srcColor_1.xyz) + (vec3((1.0 - srcColor_1.w)) * dstColor_2.xyz));
    tmpvar_110 = bool(0);
  } else {
    if ((mode_109 == 2)) {
      tmpvar_111 = ((srcColor_1.wwww * srcColor_1) + dstColor_2).xyz;
      tmpvar_110 = bool(0);
    } else {
      if ((mode_109 == 3)) {
        tmpvar_111 = (((srcColor_1 + 
          ((vec4(1.0, 1.0, 1.0, 1.0) - srcColor_1) * dstColor_2)
        ).xyz * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
        tmpvar_110 = bool(0);
      } else {
        if ((mode_109 == 4)) {
          highp float tmpvar_112;
          if ((dstColor_2.x < 0.5)) {
            tmpvar_112 = ((2.0 * srcColor_1.x) * dstColor_2.x);
          } else {
            tmpvar_112 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.x)
            ) * (1.0 - dstColor_2.x)));
          };
          highp float tmpvar_113;
          if ((dstColor_2.y < 0.5)) {
            tmpvar_113 = ((2.0 * srcColor_1.y) * dstColor_2.y);
          } else {
            tmpvar_113 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.y)
            ) * (1.0 - dstColor_2.y)));
          };
          highp float tmpvar_114;
          if ((dstColor_2.z < 0.5)) {
            tmpvar_114 = ((2.0 * srcColor_1.z) * dstColor_2.z);
          } else {
            tmpvar_114 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.z)
            ) * (1.0 - dstColor_2.z)));
          };
          highp vec3 tmpvar_115;
          tmpvar_115.x = tmpvar_112;
          tmpvar_115.y = tmpvar_113;
          tmpvar_115.z = tmpvar_114;
          tmpvar_111 = ((tmpvar_115 * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
          tmpvar_110 = bool(0);
        } else {
          if ((mode_109 == 5)) {
            highp float tmpvar_116;
            if ((dstColor_2.x < 0.5)) {
              tmpvar_116 = (((2.0 * dstColor_2.x) * srcColor_1.x) + ((dstColor_2.x * dstColor_2.x) * (1.0 - 
                (2.0 * srcColor_1.x)
              )));
            } else {
              tmpvar_116 = (((2.0 * dstColor_2.x) * (1.0 - srcColor_1.x)) + (sqrt(dstColor_2.x) * (
                (2.0 * srcColor_1.x)
               - 1.0)));
            };
            highp float tmpvar_117;
            if ((dstColor_2.y < 0.5)) {
              tmpvar_117 = (((2.0 * dstColor_2.y) * srcColor_1.y) + ((dstColor_2.y * dstColor_2.y) * (1.0 - 
                (2.0 * srcColor_1.y)
              )));
            } else {
              tmpvar_117 = (((2.0 * dstColor_2.y) * (1.0 - srcColor_1.y)) + (sqrt(dstColor_2.y) * (
                (2.0 * srcColor_1.y)
               - 1.0)));
            };
            highp float tmpvar_118;
            if ((dstColor_2.z < 0.5)) {
              tmpvar_118 = (((2.0 * dstColor_2.z) * srcColor_1.z) + ((dstColor_2.z * dstColor_2.z) * (1.0 - 
                (2.0 * srcColor_1.z)
              )));
            } else {
              tmpvar_118 = (((2.0 * dstColor_2.z) * (1.0 - srcColor_1.z)) + (sqrt(dstColor_2.z) * (
                (2.0 * srcColor_1.z)
               - 1.0)));
            };
            highp vec3 tmpvar_119;
            tmpvar_119.x = tmpvar_116;
            tmpvar_119.y = tmpvar_117;
            tmpvar_119.z = tmpvar_118;
            tmpvar_111 = ((tmpvar_119 * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
            tmpvar_110 = bool(0);
          } else {
            if ((mode_109 == 6)) {
              tmpvar_111 = ((max (srcColor_1.xyz, dstColor_2.xyz) * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
              tmpvar_110 = bool(0);
            } else {
              if ((mode_109 == 7)) {
                tmpvar_111 = (((srcColor_1.xyz * dstColor_2.xyz) * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
                tmpvar_110 = bool(0);
              };
            };
          };
        };
      };
    };
  };
  if (tmpvar_110) {
    tmpvar_111 = vec3(1.0, 0.0, 0.0);
    tmpvar_110 = bool(0);
  };
  outColor_4.xyz = tmpvar_111;
  outColor_4.w = 1.0;
  _glesFragData[0] = outColor_4;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendType",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  tmpvar_7 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_8));
  highp vec4 tmpvar_9;
  tmpvar_9.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_9.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_11;
  tmpvar_11 = (LOCALWORLD_TRANSFORM * tmpvar_10).xyz;
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_12 * _glesNormal));
  highp mat3 tmpvar_13;
  tmpvar_13[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_13[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_13[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_13 * _glesTangent));
  highp mat3 tmpvar_14;
  tmpvar_14[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_14[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_14[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_14 * _glesBinormal));
  tmpvar_2.w = tmpvar_11.x;
  tmpvar_3.w = tmpvar_11.y;
  tmpvar_4.w = tmpvar_11.z;
  tmpvar_5.zw = tmpvar_7.zw;
  tmpvar_5.xy = ((tmpvar_7.xy * 0.5) + (0.5 * tmpvar_7.ww));
  highp vec4 tmpvar_15;
  tmpvar_15.w = 1.0;
  tmpvar_15.xyz = tmpvar_1.xyz;
  tmpvar_6.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_15))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_16;
  tmpvar_16.w = 1.0;
  tmpvar_16.xyz = tmpvar_1.xyz;
  tmpvar_6.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_16)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD4 = tmpvar_5;
  gl_Position = (tmpvar_9 * tmpvar_7);
  xlv_TEXCOORD5 = tmpvar_6;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _BlendTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _Opacity;
uniform highp float _BlendType;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
in highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 srcColor_1;
  highp vec4 dstColor_2;
  highp vec4 maskCol_3;
  highp vec4 outColor_4;
  highp vec3 tmpvar_5;
  mediump float tmpvar_6;
  mediump float tmpvar_7;
  highp vec3 tmpvar_8;
  highp vec3 normalWorld_9;
  highp vec3 normalTangent_10;
  highp vec3 emissionMapColor_11;
  highp vec2 mg_12;
  highp vec4 col_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture (_MainTex, xlv_TEXCOORD0);
  col_13 = tmpvar_14;
  lowp vec2 tmpvar_15;
  tmpvar_15 = texture (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_12 = tmpvar_15;
  lowp vec3 tmpvar_16;
  tmpvar_16 = texture (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_11 = tmpvar_16;
  lowp vec3 tmpvar_17;
  tmpvar_17 = texture (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_10 = tmpvar_17;
  normalTangent_10 = ((normalTangent_10 * 2.0) - 1.0);
  normalWorld_9 = normalize(((
    (normalTangent_10.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_10.y * xlv_TEXCOORD2.xyz)
  ) + (normalTangent_10.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_18;
  tmpvar_18.x = xlv_TEXCOORD1.w;
  tmpvar_18.y = xlv_TEXCOORD2.w;
  tmpvar_18.z = xlv_TEXCOORD3.w;
  highp vec4 rgbm_19;
  highp vec3 tmpvar_20;
  highp vec3 I_21;
  I_21 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_18)));
  tmpvar_20 = (I_21 - (2.0 * (
    dot (normalWorld_9, I_21)
   * normalWorld_9)));
  highp mat2 tmpvar_22;
  tmpvar_22[uint(0)].x = 1.0;
  tmpvar_22[uint(0)].y = 0.0;
  tmpvar_22[1u].x = -0.0;
  tmpvar_22[1u].y = 1.0;
  highp vec3 tmpvar_23;
  tmpvar_23.xy = (tmpvar_22 * tmpvar_20.xz);
  tmpvar_23.z = tmpvar_20.y;
  highp vec4 tmpvar_24;
  tmpvar_24.xyz = tmpvar_23.xzy;
  tmpvar_24.w = ((1.0 - (mg_12.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_25;
  tmpvar_25 = textureLod (_GlossEnvMap, tmpvar_23.xzy, tmpvar_24.w);
  highp vec4 tmpvar_26;
  tmpvar_26 = tmpvar_25;
  rgbm_19.w = tmpvar_26.w;
  rgbm_19.xyz = ((tmpvar_26.xyz * tmpvar_26.w) * 6.0);
  highp vec4 rgbm_27;
  lowp vec4 tmpvar_28;
  tmpvar_28 = texture (_IrradianceMap, normalWorld_9);
  highp vec4 tmpvar_29;
  tmpvar_29 = tmpvar_28;
  rgbm_27.w = tmpvar_29.w;
  rgbm_27.xyz = ((tmpvar_29.xyz * tmpvar_29.w) * 6.0);
  tmpvar_5 = col_13.xyz;
  tmpvar_6 = (mg_12.x * _Metallic);
  tmpvar_7 = (mg_12.y * _Smoothness);
  tmpvar_8 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_11));
  highp vec4 shadowCoord_30;
  shadowCoord_30 = xlv_TEXCOORD5;
  highp float tmpvar_31;
  if ((xlv_TEXCOORD5.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_31 = 1.0;
  } else {
    shadowCoord_30.y = (1.0 - xlv_TEXCOORD5.y);
    highp vec3 fetchesOffsetsV_32;
    highp vec3 fetchesOffsetsU_33;
    highp float shadow_34;
    highp vec2 tmpvar_35;
    tmpvar_35 = (shadowCoord_30.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_36;
    tmpvar_36 = floor((tmpvar_35 + 0.5));
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_35 - tmpvar_36);
    highp vec3 texelsWeightsA_38;
    highp vec3 texelsWeightsB_39;
    highp vec4 computedArea_40;
    highp vec4 computedAreaUncut_41;
    highp float tmpvar_42;
    tmpvar_42 = (((tmpvar_37.x + 0.5) * (tmpvar_37.x + 0.5)) * 0.5);
    highp float tmpvar_43;
    tmpvar_43 = (tmpvar_42 - tmpvar_37.x);
    computedArea_40.x = tmpvar_43;
    computedAreaUncut_41.x = tmpvar_43;
    computedArea_40.w = tmpvar_42;
    computedAreaUncut_41.w = tmpvar_42;
    computedAreaUncut_41.y = ((1.5 - tmpvar_37.x) - 0.5);
    highp float tmpvar_44;
    tmpvar_44 = min (tmpvar_37.x, 0.0);
    computedArea_40.y = (computedAreaUncut_41.y - (tmpvar_44 * tmpvar_44));
    computedAreaUncut_41.z = ((1.5 + tmpvar_37.x) - 0.5);
    highp float tmpvar_45;
    tmpvar_45 = max (tmpvar_37.x, 0.0);
    computedArea_40.z = (computedAreaUncut_41.z - (tmpvar_45 * tmpvar_45));
    texelsWeightsA_38.x = (0.16 * tmpvar_43);
    texelsWeightsA_38.y = (0.16 * computedAreaUncut_41.y);
    texelsWeightsA_38.z = (0.16 * (computedArea_40.y + 1.0));
    texelsWeightsB_39.x = (0.16 * (computedArea_40.z + 1.0));
    texelsWeightsB_39.y = (0.16 * computedAreaUncut_41.z);
    texelsWeightsB_39.z = (0.16 * tmpvar_42);
    highp vec3 texelsWeightsA_46;
    highp vec3 texelsWeightsB_47;
    highp vec4 computedArea_48;
    highp vec4 computedAreaUncut_49;
    highp float tmpvar_50;
    tmpvar_50 = (((tmpvar_37.y + 0.5) * (tmpvar_37.y + 0.5)) * 0.5);
    highp float tmpvar_51;
    tmpvar_51 = (tmpvar_50 - tmpvar_37.y);
    computedArea_48.x = tmpvar_51;
    computedAreaUncut_49.x = tmpvar_51;
    computedArea_48.w = tmpvar_50;
    computedAreaUncut_49.w = tmpvar_50;
    computedAreaUncut_49.y = ((1.5 - tmpvar_37.y) - 0.5);
    highp float tmpvar_52;
    tmpvar_52 = min (tmpvar_37.y, 0.0);
    computedArea_48.y = (computedAreaUncut_49.y - (tmpvar_52 * tmpvar_52));
    computedAreaUncut_49.z = ((1.5 + tmpvar_37.y) - 0.5);
    highp float tmpvar_53;
    tmpvar_53 = max (tmpvar_37.y, 0.0);
    computedArea_48.z = (computedAreaUncut_49.z - (tmpvar_53 * tmpvar_53));
    texelsWeightsA_46.x = (0.16 * tmpvar_51);
    texelsWeightsA_46.y = (0.16 * computedAreaUncut_49.y);
    texelsWeightsA_46.z = (0.16 * (computedArea_48.y + 1.0));
    texelsWeightsB_47.x = (0.16 * (computedArea_48.z + 1.0));
    texelsWeightsB_47.y = (0.16 * computedAreaUncut_49.z);
    texelsWeightsB_47.z = (0.16 * tmpvar_50);
    highp vec3 tmpvar_54;
    tmpvar_54.xy = texelsWeightsA_38.xz;
    tmpvar_54.z = texelsWeightsB_39.y;
    highp vec3 tmpvar_55;
    tmpvar_55.x = texelsWeightsA_38.y;
    tmpvar_55.yz = texelsWeightsB_39.xz;
    highp vec3 tmpvar_56;
    tmpvar_56 = (tmpvar_54 + tmpvar_55);
    highp vec3 tmpvar_57;
    tmpvar_57.xy = texelsWeightsA_46.xz;
    tmpvar_57.z = texelsWeightsB_47.y;
    highp vec3 tmpvar_58;
    tmpvar_58.x = texelsWeightsA_46.y;
    tmpvar_58.yz = texelsWeightsB_47.xz;
    highp vec3 tmpvar_59;
    tmpvar_59 = (tmpvar_57 + tmpvar_58);
    highp vec3 tmpvar_60;
    tmpvar_60.x = texelsWeightsA_38.y;
    tmpvar_60.yz = texelsWeightsB_39.xz;
    highp vec3 tmpvar_61;
    tmpvar_61.x = texelsWeightsA_46.y;
    tmpvar_61.yz = texelsWeightsB_47.xz;
    fetchesOffsetsU_33 = (((tmpvar_60 / tmpvar_56) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_32 = (((tmpvar_61 / tmpvar_59) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_62;
    tmpvar_62 = (tmpvar_36 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_63;
    tmpvar_63.x = fetchesOffsetsU_33.x;
    tmpvar_63.y = fetchesOffsetsV_32.x;
    highp vec3 tmpvar_64;
    tmpvar_64.xy = (tmpvar_62 + tmpvar_63);
    tmpvar_64.z = shadowCoord_30.z;
    mediump float tmpvar_65;
    tmpvar_65 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_64);
    shadow_34 = ((tmpvar_56.x * tmpvar_59.x) * tmpvar_65);
    highp vec2 tmpvar_66;
    tmpvar_66.x = fetchesOffsetsU_33.y;
    tmpvar_66.y = fetchesOffsetsV_32.x;
    highp vec3 tmpvar_67;
    tmpvar_67.xy = (tmpvar_62 + tmpvar_66);
    tmpvar_67.z = shadowCoord_30.z;
    mediump float tmpvar_68;
    tmpvar_68 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_67);
    shadow_34 = (shadow_34 + ((tmpvar_56.y * tmpvar_59.x) * tmpvar_68));
    highp vec2 tmpvar_69;
    tmpvar_69.x = fetchesOffsetsU_33.z;
    tmpvar_69.y = fetchesOffsetsV_32.x;
    highp vec3 tmpvar_70;
    tmpvar_70.xy = (tmpvar_62 + tmpvar_69);
    tmpvar_70.z = shadowCoord_30.z;
    mediump float tmpvar_71;
    tmpvar_71 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_70);
    shadow_34 = (shadow_34 + ((tmpvar_56.z * tmpvar_59.x) * tmpvar_71));
    highp vec2 tmpvar_72;
    tmpvar_72.x = fetchesOffsetsU_33.x;
    tmpvar_72.y = fetchesOffsetsV_32.y;
    highp vec3 tmpvar_73;
    tmpvar_73.xy = (tmpvar_62 + tmpvar_72);
    tmpvar_73.z = shadowCoord_30.z;
    mediump float tmpvar_74;
    tmpvar_74 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_73);
    shadow_34 = (shadow_34 + ((tmpvar_56.x * tmpvar_59.y) * tmpvar_74));
    highp vec2 tmpvar_75;
    tmpvar_75.x = fetchesOffsetsU_33.y;
    tmpvar_75.y = fetchesOffsetsV_32.y;
    highp vec3 tmpvar_76;
    tmpvar_76.xy = (tmpvar_62 + tmpvar_75);
    tmpvar_76.z = shadowCoord_30.z;
    mediump float tmpvar_77;
    tmpvar_77 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_76);
    shadow_34 = (shadow_34 + ((tmpvar_56.y * tmpvar_59.y) * tmpvar_77));
    highp vec2 tmpvar_78;
    tmpvar_78.x = fetchesOffsetsU_33.z;
    tmpvar_78.y = fetchesOffsetsV_32.y;
    highp vec3 tmpvar_79;
    tmpvar_79.xy = (tmpvar_62 + tmpvar_78);
    tmpvar_79.z = shadowCoord_30.z;
    mediump float tmpvar_80;
    tmpvar_80 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_79);
    shadow_34 = (shadow_34 + ((tmpvar_56.z * tmpvar_59.y) * tmpvar_80));
    highp vec2 tmpvar_81;
    tmpvar_81.x = fetchesOffsetsU_33.x;
    tmpvar_81.y = fetchesOffsetsV_32.z;
    highp vec3 tmpvar_82;
    tmpvar_82.xy = (tmpvar_62 + tmpvar_81);
    tmpvar_82.z = shadowCoord_30.z;
    mediump float tmpvar_83;
    tmpvar_83 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_82);
    shadow_34 = (shadow_34 + ((tmpvar_56.x * tmpvar_59.z) * tmpvar_83));
    highp vec2 tmpvar_84;
    tmpvar_84.x = fetchesOffsetsU_33.y;
    tmpvar_84.y = fetchesOffsetsV_32.z;
    highp vec3 tmpvar_85;
    tmpvar_85.xy = (tmpvar_62 + tmpvar_84);
    tmpvar_85.z = shadowCoord_30.z;
    mediump float tmpvar_86;
    tmpvar_86 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_85);
    shadow_34 = (shadow_34 + ((tmpvar_56.y * tmpvar_59.z) * tmpvar_86));
    highp vec2 tmpvar_87;
    tmpvar_87.x = fetchesOffsetsU_33.z;
    tmpvar_87.y = fetchesOffsetsV_32.z;
    highp vec3 tmpvar_88;
    tmpvar_88.xy = (tmpvar_62 + tmpvar_87);
    tmpvar_88.z = shadowCoord_30.z;
    mediump float tmpvar_89;
    tmpvar_89 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_88);
    shadow_34 = (shadow_34 + ((tmpvar_56.z * tmpvar_59.z) * tmpvar_89));
    tmpvar_31 = mix (1.0, shadow_34, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_90;
  highp vec3 tmpvar_91;
  tmpvar_90 = normalize((CAMERA_WORLDPOSITION - tmpvar_18));
  tmpvar_91 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_92;
  highp vec3 specularEnv_93;
  highp vec3 color_94;
  mediump float surfaceReduction_95;
  mediump float diffuseTerm_96;
  highp float perceptualRoughness_97;
  mediump vec3 tmpvar_98;
  mediump vec3 albedo_99;
  albedo_99 = tmpvar_5;
  mediump vec3 specColor_100;
  specColor_100 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_6)) + (albedo_99 * tmpvar_6));
  mediump float tmpvar_101;
  tmpvar_101 = (0.7790837 - (tmpvar_6 * 0.7790837));
  tmpvar_98 = (albedo_99 * tmpvar_101);
  tmpvar_92 = 0.0;
  mediump float alpha_102;
  alpha_102 = tmpvar_92;
  tmpvar_92 = alpha_102;
  mediump float tmpvar_103;
  tmpvar_103 = (1.0 - tmpvar_7);
  perceptualRoughness_97 = tmpvar_103;
  highp vec3 tmpvar_104;
  highp vec3 inVec_105;
  inVec_105 = (tmpvar_91 + tmpvar_90);
  tmpvar_104 = (inVec_105 * inversesqrt(max (0.001, 
    dot (inVec_105, inVec_105)
  )));
  highp float tmpvar_106;
  tmpvar_106 = abs(dot (tmpvar_90, normalWorld_9));
  highp float tmpvar_107;
  tmpvar_107 = clamp (dot (normalWorld_9, tmpvar_91), 0.0, 1.0);
  highp float tmpvar_108;
  tmpvar_108 = clamp (dot (normalWorld_9, tmpvar_104), 0.0, 1.0);
  mediump float tmpvar_109;
  highp float tmpvar_110;
  tmpvar_110 = clamp (dot (tmpvar_91, tmpvar_104), 0.0, 1.0);
  tmpvar_109 = tmpvar_110;
  mediump float tmpvar_111;
  mediump float NdotV_112;
  NdotV_112 = tmpvar_106;
  mediump float NdotL_113;
  NdotL_113 = tmpvar_107;
  mediump float perceptualRoughness_114;
  perceptualRoughness_114 = perceptualRoughness_97;
  mediump float tmpvar_115;
  tmpvar_115 = (0.5 + ((2.0 * tmpvar_109) * (tmpvar_109 * perceptualRoughness_114)));
  mediump float x_116;
  x_116 = (1.0 - NdotL_113);
  mediump float x_117;
  x_117 = (1.0 - NdotV_112);
  tmpvar_111 = ((1.0 + (
    (tmpvar_115 - 1.0)
   * 
    ((x_116 * x_116) * ((x_116 * x_116) * x_116))
  )) * (1.0 + (
    (tmpvar_115 - 1.0)
   * 
    ((x_117 * x_117) * ((x_117 * x_117) * x_117))
  )));
  highp float tmpvar_118;
  tmpvar_118 = (tmpvar_111 * tmpvar_107);
  diffuseTerm_96 = tmpvar_118;
  highp float tmpvar_119;
  tmpvar_119 = max ((perceptualRoughness_97 * perceptualRoughness_97), 0.002);
  highp float tmpvar_120;
  tmpvar_120 = (tmpvar_119 * tmpvar_119);
  highp float tmpvar_121;
  tmpvar_121 = (((
    (tmpvar_108 * tmpvar_120)
   - tmpvar_108) * tmpvar_108) + 1.0);
  surfaceReduction_95 = (1.0 - ((0.28 * tmpvar_119) * perceptualRoughness_97));
  mediump vec3 tmpvar_122;
  mediump float x_123;
  x_123 = (1.0 - tmpvar_109);
  tmpvar_122 = (specColor_100 + ((1.0 - specColor_100) * (
    (x_123 * x_123)
   * 
    ((x_123 * x_123) * x_123)
  )));
  color_94 = (((
    (tmpvar_98 * LIGHT_COLOR)
   * diffuseTerm_96) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_120)
       / 
        ((tmpvar_121 * tmpvar_121) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_107 * (
          (tmpvar_106 * (1.0 - tmpvar_119))
         + tmpvar_119)) + (tmpvar_106 * (
          (tmpvar_107 * (1.0 - tmpvar_119))
         + tmpvar_119))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_107)) * LIGHT_COLOR)
   * tmpvar_122)) * tmpvar_31);
  color_94 = (color_94 + tmpvar_8);
  color_94 = (color_94 + (tmpvar_98 * rgbm_27.xyz));
  mediump float cosA_124;
  cosA_124 = tmpvar_106;
  mediump float tmpvar_125;
  mediump float x_126;
  x_126 = (1.0 - cosA_124);
  tmpvar_125 = ((x_126 * x_126) * ((x_126 * x_126) * x_126));
  mediump vec3 tmpvar_127;
  tmpvar_127 = (surfaceReduction_95 * ((specColor_100 * 
    (1.0 - tmpvar_125)
  ) + (vec3(
    clamp ((tmpvar_7 + (1.0 - tmpvar_101)), 0.0, 1.0)
  ) * tmpvar_125)));
  specularEnv_93 = tmpvar_127;
  color_94 = (color_94 + (specularEnv_93 * rgbm_19.xyz));
  outColor_4.xyz = color_94;
  lowp vec4 tmpvar_128;
  tmpvar_128 = texture (_MaskTex, xlv_TEXCOORD0);
  maskCol_3 = tmpvar_128;
  outColor_4.w = ((col_13.w * maskCol_3.w) * _Opacity);
  highp vec3 tmpvar_129;
  tmpvar_129 = (xlv_TEXCOORD4.xyz / xlv_TEXCOORD4.w);
  highp vec2 tmpvar_130;
  tmpvar_130.x = tmpvar_129.x;
  tmpvar_130.y = (1.0 - tmpvar_129.y);
  lowp vec4 tmpvar_131;
  tmpvar_131 = texture (_BlendTex, tmpvar_130);
  dstColor_2 = tmpvar_131;
  srcColor_1 = outColor_4;
  outColor_4.w = ((col_13.w * maskCol_3.w) * _Opacity);
  highp int mode_132;
  mode_132 = int(_BlendType);
  bool tmpvar_133;
  tmpvar_133 = bool(1);
  highp vec3 tmpvar_134;
  if ((mode_132 == 1)) {
    tmpvar_134 = ((srcColor_1.www * srcColor_1.xyz) + (vec3((1.0 - srcColor_1.w)) * dstColor_2.xyz));
    tmpvar_133 = bool(0);
  } else {
    if ((mode_132 == 2)) {
      tmpvar_134 = ((srcColor_1.wwww * srcColor_1) + dstColor_2).xyz;
      tmpvar_133 = bool(0);
    } else {
      if ((mode_132 == 3)) {
        tmpvar_134 = (((srcColor_1 + 
          ((vec4(1.0, 1.0, 1.0, 1.0) - srcColor_1) * dstColor_2)
        ).xyz * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
        tmpvar_133 = bool(0);
      } else {
        if ((mode_132 == 4)) {
          highp float tmpvar_135;
          if ((dstColor_2.x < 0.5)) {
            tmpvar_135 = ((2.0 * srcColor_1.x) * dstColor_2.x);
          } else {
            tmpvar_135 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.x)
            ) * (1.0 - dstColor_2.x)));
          };
          highp float tmpvar_136;
          if ((dstColor_2.y < 0.5)) {
            tmpvar_136 = ((2.0 * srcColor_1.y) * dstColor_2.y);
          } else {
            tmpvar_136 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.y)
            ) * (1.0 - dstColor_2.y)));
          };
          highp float tmpvar_137;
          if ((dstColor_2.z < 0.5)) {
            tmpvar_137 = ((2.0 * srcColor_1.z) * dstColor_2.z);
          } else {
            tmpvar_137 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.z)
            ) * (1.0 - dstColor_2.z)));
          };
          highp vec3 tmpvar_138;
          tmpvar_138.x = tmpvar_135;
          tmpvar_138.y = tmpvar_136;
          tmpvar_138.z = tmpvar_137;
          tmpvar_134 = ((tmpvar_138 * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
          tmpvar_133 = bool(0);
        } else {
          if ((mode_132 == 5)) {
            highp float tmpvar_139;
            if ((dstColor_2.x < 0.5)) {
              tmpvar_139 = (((2.0 * dstColor_2.x) * srcColor_1.x) + ((dstColor_2.x * dstColor_2.x) * (1.0 - 
                (2.0 * srcColor_1.x)
              )));
            } else {
              tmpvar_139 = (((2.0 * dstColor_2.x) * (1.0 - srcColor_1.x)) + (sqrt(dstColor_2.x) * (
                (2.0 * srcColor_1.x)
               - 1.0)));
            };
            highp float tmpvar_140;
            if ((dstColor_2.y < 0.5)) {
              tmpvar_140 = (((2.0 * dstColor_2.y) * srcColor_1.y) + ((dstColor_2.y * dstColor_2.y) * (1.0 - 
                (2.0 * srcColor_1.y)
              )));
            } else {
              tmpvar_140 = (((2.0 * dstColor_2.y) * (1.0 - srcColor_1.y)) + (sqrt(dstColor_2.y) * (
                (2.0 * srcColor_1.y)
               - 1.0)));
            };
            highp float tmpvar_141;
            if ((dstColor_2.z < 0.5)) {
              tmpvar_141 = (((2.0 * dstColor_2.z) * srcColor_1.z) + ((dstColor_2.z * dstColor_2.z) * (1.0 - 
                (2.0 * srcColor_1.z)
              )));
            } else {
              tmpvar_141 = (((2.0 * dstColor_2.z) * (1.0 - srcColor_1.z)) + (sqrt(dstColor_2.z) * (
                (2.0 * srcColor_1.z)
               - 1.0)));
            };
            highp vec3 tmpvar_142;
            tmpvar_142.x = tmpvar_139;
            tmpvar_142.y = tmpvar_140;
            tmpvar_142.z = tmpvar_141;
            tmpvar_134 = ((tmpvar_142 * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
            tmpvar_133 = bool(0);
          } else {
            if ((mode_132 == 6)) {
              tmpvar_134 = ((max (srcColor_1.xyz, dstColor_2.xyz) * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
              tmpvar_133 = bool(0);
            } else {
              if ((mode_132 == 7)) {
                tmpvar_134 = (((srcColor_1.xyz * dstColor_2.xyz) * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
                tmpvar_133 = bool(0);
              };
            };
          };
        };
      };
    };
  };
  if (tmpvar_133) {
    tmpvar_134 = vec3(1.0, 0.0, 0.0);
    tmpvar_133 = bool(0);
  };
  outColor_4.xyz = tmpvar_134;
  outColor_4.w = 1.0;
  _glesFragData[0] = outColor_4;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendType",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  tmpvar_7 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_8));
  highp vec4 tmpvar_9;
  tmpvar_9.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_9.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_11;
  tmpvar_11 = (LOCALWORLD_TRANSFORM * tmpvar_10).xyz;
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_12 * _glesNormal));
  highp mat3 tmpvar_13;
  tmpvar_13[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_13[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_13[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_13 * _glesTangent));
  highp mat3 tmpvar_14;
  tmpvar_14[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_14[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_14[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_14 * _glesBinormal));
  tmpvar_2.w = tmpvar_11.x;
  tmpvar_3.w = tmpvar_11.y;
  tmpvar_4.w = tmpvar_11.z;
  tmpvar_5.zw = tmpvar_7.zw;
  tmpvar_5.xy = ((tmpvar_7.xy * 0.5) + (0.5 * tmpvar_7.ww));
  highp vec4 tmpvar_15;
  tmpvar_15.w = 1.0;
  tmpvar_15.xyz = tmpvar_1.xyz;
  tmpvar_6.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_15))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_16;
  tmpvar_16.w = 1.0;
  tmpvar_16.xyz = tmpvar_1.xyz;
  tmpvar_6.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_16)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD4 = tmpvar_5;
  gl_Position = (tmpvar_9 * tmpvar_7);
  xlv_TEXCOORD5 = tmpvar_6;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _BlendTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _Opacity;
uniform highp float _BlendType;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
in highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 srcColor_1;
  highp vec4 dstColor_2;
  highp vec4 maskCol_3;
  highp vec4 outColor_4;
  highp vec3 tmpvar_5;
  mediump float tmpvar_6;
  mediump float tmpvar_7;
  highp vec3 tmpvar_8;
  highp vec3 normalWorld_9;
  highp vec3 normalTangent_10;
  highp vec3 emissionMapColor_11;
  highp vec2 mg_12;
  highp vec4 col_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture (_MainTex, xlv_TEXCOORD0);
  col_13 = tmpvar_14;
  lowp vec2 tmpvar_15;
  tmpvar_15 = texture (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_12 = tmpvar_15;
  lowp vec3 tmpvar_16;
  tmpvar_16 = texture (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_11 = tmpvar_16;
  lowp vec3 tmpvar_17;
  tmpvar_17 = texture (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_10 = tmpvar_17;
  normalTangent_10 = ((normalTangent_10 * 2.0) - 1.0);
  normalWorld_9 = normalize(((
    (normalTangent_10.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_10.y * xlv_TEXCOORD2.xyz)
  ) + (normalTangent_10.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_18;
  tmpvar_18.x = xlv_TEXCOORD1.w;
  tmpvar_18.y = xlv_TEXCOORD2.w;
  tmpvar_18.z = xlv_TEXCOORD3.w;
  highp vec4 rgbm_19;
  highp vec3 tmpvar_20;
  highp vec3 I_21;
  I_21 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_18)));
  tmpvar_20 = (I_21 - (2.0 * (
    dot (normalWorld_9, I_21)
   * normalWorld_9)));
  highp mat2 tmpvar_22;
  tmpvar_22[uint(0)].x = 1.0;
  tmpvar_22[uint(0)].y = 0.0;
  tmpvar_22[1u].x = -0.0;
  tmpvar_22[1u].y = 1.0;
  highp vec3 tmpvar_23;
  tmpvar_23.xy = (tmpvar_22 * tmpvar_20.xz);
  tmpvar_23.z = tmpvar_20.y;
  highp vec4 tmpvar_24;
  tmpvar_24.xyz = tmpvar_23.xzy;
  tmpvar_24.w = ((1.0 - (mg_12.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_25;
  tmpvar_25 = textureLod (_GlossEnvMap, tmpvar_23.xzy, tmpvar_24.w);
  highp vec4 tmpvar_26;
  tmpvar_26 = tmpvar_25;
  rgbm_19.w = tmpvar_26.w;
  rgbm_19.xyz = ((tmpvar_26.xyz * tmpvar_26.w) * 6.0);
  highp vec4 rgbm_27;
  lowp vec4 tmpvar_28;
  tmpvar_28 = texture (_IrradianceMap, normalWorld_9);
  highp vec4 tmpvar_29;
  tmpvar_29 = tmpvar_28;
  rgbm_27.w = tmpvar_29.w;
  rgbm_27.xyz = ((tmpvar_29.xyz * tmpvar_29.w) * 6.0);
  tmpvar_5 = col_13.xyz;
  tmpvar_6 = (mg_12.x * _Metallic);
  tmpvar_7 = (mg_12.y * _Smoothness);
  tmpvar_8 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_11));
  highp vec4 shadowCoord_30;
  shadowCoord_30 = xlv_TEXCOORD5;
  highp float tmpvar_31;
  if ((xlv_TEXCOORD5.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_31 = 1.0;
  } else {
    shadowCoord_30.y = (1.0 - xlv_TEXCOORD5.y);
    highp vec4 fetchesOffsetsV_32;
    highp vec4 fetchesOffsetsU_33;
    highp float shadow_34;
    highp vec2 tmpvar_35;
    tmpvar_35 = (shadowCoord_30.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_36;
    tmpvar_36 = floor((tmpvar_35 + 0.5));
    highp vec2 tmpvar_37;
    tmpvar_37 = (tmpvar_35 - tmpvar_36);
    highp vec4 texelsWeightsA_38;
    highp vec4 texelsWeightsB_39;
    highp vec4 computedArea_40;
    highp vec4 computedAreaUncut_41;
    highp float tmpvar_42;
    tmpvar_42 = (((tmpvar_37.x + 0.5) * (tmpvar_37.x + 0.5)) * 0.5);
    highp float tmpvar_43;
    tmpvar_43 = (tmpvar_42 - tmpvar_37.x);
    computedArea_40.x = tmpvar_43;
    computedAreaUncut_41.x = tmpvar_43;
    computedArea_40.w = tmpvar_42;
    computedAreaUncut_41.w = tmpvar_42;
    computedAreaUncut_41.y = ((1.5 - tmpvar_37.x) - 0.5);
    highp float tmpvar_44;
    tmpvar_44 = min (tmpvar_37.x, 0.0);
    computedArea_40.y = (computedAreaUncut_41.y - (tmpvar_44 * tmpvar_44));
    computedAreaUncut_41.z = ((1.5 + tmpvar_37.x) - 0.5);
    highp float tmpvar_45;
    tmpvar_45 = max (tmpvar_37.x, 0.0);
    computedArea_40.z = (computedAreaUncut_41.z - (tmpvar_45 * tmpvar_45));
    texelsWeightsA_38.x = (0.081632 * tmpvar_43);
    texelsWeightsA_38.y = (0.081632 * computedAreaUncut_41.y);
    texelsWeightsA_38.z = (0.081632 * (computedAreaUncut_41.y + 1.0));
    texelsWeightsA_38.w = (0.081632 * (computedArea_40.y + 2.0));
    texelsWeightsB_39.x = (0.081632 * (computedArea_40.z + 2.0));
    texelsWeightsB_39.y = (0.081632 * (computedAreaUncut_41.z + 1.0));
    texelsWeightsB_39.z = (0.081632 * computedAreaUncut_41.z);
    texelsWeightsB_39.w = (0.081632 * tmpvar_42);
    highp vec4 texelsWeightsA_46;
    highp vec4 texelsWeightsB_47;
    highp vec4 computedArea_48;
    highp vec4 computedAreaUncut_49;
    highp float tmpvar_50;
    tmpvar_50 = (((tmpvar_37.y + 0.5) * (tmpvar_37.y + 0.5)) * 0.5);
    highp float tmpvar_51;
    tmpvar_51 = (tmpvar_50 - tmpvar_37.y);
    computedArea_48.x = tmpvar_51;
    computedAreaUncut_49.x = tmpvar_51;
    computedArea_48.w = tmpvar_50;
    computedAreaUncut_49.w = tmpvar_50;
    computedAreaUncut_49.y = ((1.5 - tmpvar_37.y) - 0.5);
    highp float tmpvar_52;
    tmpvar_52 = min (tmpvar_37.y, 0.0);
    computedArea_48.y = (computedAreaUncut_49.y - (tmpvar_52 * tmpvar_52));
    computedAreaUncut_49.z = ((1.5 + tmpvar_37.y) - 0.5);
    highp float tmpvar_53;
    tmpvar_53 = max (tmpvar_37.y, 0.0);
    computedArea_48.z = (computedAreaUncut_49.z - (tmpvar_53 * tmpvar_53));
    texelsWeightsA_46.x = (0.081632 * tmpvar_51);
    texelsWeightsA_46.y = (0.081632 * computedAreaUncut_49.y);
    texelsWeightsA_46.z = (0.081632 * (computedAreaUncut_49.y + 1.0));
    texelsWeightsA_46.w = (0.081632 * (computedArea_48.y + 2.0));
    texelsWeightsB_47.x = (0.081632 * (computedArea_48.z + 2.0));
    texelsWeightsB_47.y = (0.081632 * (computedAreaUncut_49.z + 1.0));
    texelsWeightsB_47.z = (0.081632 * computedAreaUncut_49.z);
    texelsWeightsB_47.w = (0.081632 * tmpvar_50);
    highp vec4 tmpvar_54;
    tmpvar_54.xy = texelsWeightsA_38.xz;
    tmpvar_54.zw = texelsWeightsB_39.xz;
    highp vec4 tmpvar_55;
    tmpvar_55.xy = texelsWeightsA_38.yw;
    tmpvar_55.zw = texelsWeightsB_39.yw;
    highp vec4 tmpvar_56;
    tmpvar_56 = (tmpvar_54 + tmpvar_55);
    highp vec4 tmpvar_57;
    tmpvar_57.xy = texelsWeightsA_46.xz;
    tmpvar_57.zw = texelsWeightsB_47.xz;
    highp vec4 tmpvar_58;
    tmpvar_58.xy = texelsWeightsA_46.yw;
    tmpvar_58.zw = texelsWeightsB_47.yw;
    highp vec4 tmpvar_59;
    tmpvar_59 = (tmpvar_57 + tmpvar_58);
    highp vec4 tmpvar_60;
    tmpvar_60.xy = texelsWeightsA_38.yw;
    tmpvar_60.zw = texelsWeightsB_39.yw;
    highp vec4 tmpvar_61;
    tmpvar_61.xy = texelsWeightsA_46.yw;
    tmpvar_61.zw = texelsWeightsB_47.yw;
    fetchesOffsetsU_33 = (((tmpvar_60 / tmpvar_56) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_32 = (((tmpvar_61 / tmpvar_59) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_62;
    tmpvar_62 = (tmpvar_36 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_63;
    tmpvar_63.x = fetchesOffsetsU_33.x;
    tmpvar_63.y = fetchesOffsetsV_32.x;
    highp vec3 tmpvar_64;
    tmpvar_64.xy = (tmpvar_62 + tmpvar_63);
    tmpvar_64.z = shadowCoord_30.z;
    mediump float tmpvar_65;
    tmpvar_65 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_64);
    shadow_34 = ((tmpvar_56.x * tmpvar_59.x) * tmpvar_65);
    highp vec2 tmpvar_66;
    tmpvar_66.x = fetchesOffsetsU_33.y;
    tmpvar_66.y = fetchesOffsetsV_32.x;
    highp vec3 tmpvar_67;
    tmpvar_67.xy = (tmpvar_62 + tmpvar_66);
    tmpvar_67.z = shadowCoord_30.z;
    mediump float tmpvar_68;
    tmpvar_68 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_67);
    shadow_34 = (shadow_34 + ((tmpvar_56.y * tmpvar_59.x) * tmpvar_68));
    highp vec2 tmpvar_69;
    tmpvar_69.x = fetchesOffsetsU_33.z;
    tmpvar_69.y = fetchesOffsetsV_32.x;
    highp vec3 tmpvar_70;
    tmpvar_70.xy = (tmpvar_62 + tmpvar_69);
    tmpvar_70.z = shadowCoord_30.z;
    mediump float tmpvar_71;
    tmpvar_71 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_70);
    shadow_34 = (shadow_34 + ((tmpvar_56.z * tmpvar_59.x) * tmpvar_71));
    highp vec2 tmpvar_72;
    tmpvar_72.x = fetchesOffsetsU_33.w;
    tmpvar_72.y = fetchesOffsetsV_32.x;
    highp vec3 tmpvar_73;
    tmpvar_73.xy = (tmpvar_62 + tmpvar_72);
    tmpvar_73.z = shadowCoord_30.z;
    mediump float tmpvar_74;
    tmpvar_74 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_73);
    shadow_34 = (shadow_34 + ((tmpvar_56.w * tmpvar_59.x) * tmpvar_74));
    highp vec2 tmpvar_75;
    tmpvar_75.x = fetchesOffsetsU_33.x;
    tmpvar_75.y = fetchesOffsetsV_32.y;
    highp vec3 tmpvar_76;
    tmpvar_76.xy = (tmpvar_62 + tmpvar_75);
    tmpvar_76.z = shadowCoord_30.z;
    mediump float tmpvar_77;
    tmpvar_77 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_76);
    shadow_34 = (shadow_34 + ((tmpvar_56.x * tmpvar_59.y) * tmpvar_77));
    highp vec2 tmpvar_78;
    tmpvar_78.x = fetchesOffsetsU_33.y;
    tmpvar_78.y = fetchesOffsetsV_32.y;
    highp vec3 tmpvar_79;
    tmpvar_79.xy = (tmpvar_62 + tmpvar_78);
    tmpvar_79.z = shadowCoord_30.z;
    mediump float tmpvar_80;
    tmpvar_80 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_79);
    shadow_34 = (shadow_34 + ((tmpvar_56.y * tmpvar_59.y) * tmpvar_80));
    highp vec2 tmpvar_81;
    tmpvar_81.x = fetchesOffsetsU_33.z;
    tmpvar_81.y = fetchesOffsetsV_32.y;
    highp vec3 tmpvar_82;
    tmpvar_82.xy = (tmpvar_62 + tmpvar_81);
    tmpvar_82.z = shadowCoord_30.z;
    mediump float tmpvar_83;
    tmpvar_83 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_82);
    shadow_34 = (shadow_34 + ((tmpvar_56.z * tmpvar_59.y) * tmpvar_83));
    highp vec2 tmpvar_84;
    tmpvar_84.x = fetchesOffsetsU_33.w;
    tmpvar_84.y = fetchesOffsetsV_32.y;
    highp vec3 tmpvar_85;
    tmpvar_85.xy = (tmpvar_62 + tmpvar_84);
    tmpvar_85.z = shadowCoord_30.z;
    mediump float tmpvar_86;
    tmpvar_86 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_85);
    shadow_34 = (shadow_34 + ((tmpvar_56.w * tmpvar_59.y) * tmpvar_86));
    highp vec2 tmpvar_87;
    tmpvar_87.x = fetchesOffsetsU_33.x;
    tmpvar_87.y = fetchesOffsetsV_32.z;
    highp vec3 tmpvar_88;
    tmpvar_88.xy = (tmpvar_62 + tmpvar_87);
    tmpvar_88.z = shadowCoord_30.z;
    mediump float tmpvar_89;
    tmpvar_89 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_88);
    shadow_34 = (shadow_34 + ((tmpvar_56.x * tmpvar_59.z) * tmpvar_89));
    highp vec2 tmpvar_90;
    tmpvar_90.x = fetchesOffsetsU_33.y;
    tmpvar_90.y = fetchesOffsetsV_32.z;
    highp vec3 tmpvar_91;
    tmpvar_91.xy = (tmpvar_62 + tmpvar_90);
    tmpvar_91.z = shadowCoord_30.z;
    mediump float tmpvar_92;
    tmpvar_92 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_91);
    shadow_34 = (shadow_34 + ((tmpvar_56.y * tmpvar_59.z) * tmpvar_92));
    highp vec2 tmpvar_93;
    tmpvar_93.x = fetchesOffsetsU_33.z;
    tmpvar_93.y = fetchesOffsetsV_32.z;
    highp vec3 tmpvar_94;
    tmpvar_94.xy = (tmpvar_62 + tmpvar_93);
    tmpvar_94.z = shadowCoord_30.z;
    mediump float tmpvar_95;
    tmpvar_95 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_94);
    shadow_34 = (shadow_34 + ((tmpvar_56.z * tmpvar_59.z) * tmpvar_95));
    highp vec2 tmpvar_96;
    tmpvar_96.x = fetchesOffsetsU_33.w;
    tmpvar_96.y = fetchesOffsetsV_32.z;
    highp vec3 tmpvar_97;
    tmpvar_97.xy = (tmpvar_62 + tmpvar_96);
    tmpvar_97.z = shadowCoord_30.z;
    mediump float tmpvar_98;
    tmpvar_98 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_97);
    shadow_34 = (shadow_34 + ((tmpvar_56.w * tmpvar_59.z) * tmpvar_98));
    highp vec2 tmpvar_99;
    tmpvar_99.x = fetchesOffsetsU_33.x;
    tmpvar_99.y = fetchesOffsetsV_32.w;
    highp vec3 tmpvar_100;
    tmpvar_100.xy = (tmpvar_62 + tmpvar_99);
    tmpvar_100.z = shadowCoord_30.z;
    mediump float tmpvar_101;
    tmpvar_101 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_100);
    shadow_34 = (shadow_34 + ((tmpvar_56.x * tmpvar_59.w) * tmpvar_101));
    highp vec2 tmpvar_102;
    tmpvar_102.x = fetchesOffsetsU_33.y;
    tmpvar_102.y = fetchesOffsetsV_32.w;
    highp vec3 tmpvar_103;
    tmpvar_103.xy = (tmpvar_62 + tmpvar_102);
    tmpvar_103.z = shadowCoord_30.z;
    mediump float tmpvar_104;
    tmpvar_104 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_103);
    shadow_34 = (shadow_34 + ((tmpvar_56.y * tmpvar_59.w) * tmpvar_104));
    highp vec2 tmpvar_105;
    tmpvar_105.x = fetchesOffsetsU_33.z;
    tmpvar_105.y = fetchesOffsetsV_32.w;
    highp vec3 tmpvar_106;
    tmpvar_106.xy = (tmpvar_62 + tmpvar_105);
    tmpvar_106.z = shadowCoord_30.z;
    mediump float tmpvar_107;
    tmpvar_107 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_106);
    shadow_34 = (shadow_34 + ((tmpvar_56.z * tmpvar_59.w) * tmpvar_107));
    highp vec2 tmpvar_108;
    tmpvar_108.x = fetchesOffsetsU_33.w;
    tmpvar_108.y = fetchesOffsetsV_32.w;
    highp vec3 tmpvar_109;
    tmpvar_109.xy = (tmpvar_62 + tmpvar_108);
    tmpvar_109.z = shadowCoord_30.z;
    mediump float tmpvar_110;
    tmpvar_110 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_109);
    shadow_34 = (shadow_34 + ((tmpvar_56.w * tmpvar_59.w) * tmpvar_110));
    tmpvar_31 = mix (1.0, shadow_34, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_111;
  highp vec3 tmpvar_112;
  tmpvar_111 = normalize((CAMERA_WORLDPOSITION - tmpvar_18));
  tmpvar_112 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_113;
  highp vec3 specularEnv_114;
  highp vec3 color_115;
  mediump float surfaceReduction_116;
  mediump float diffuseTerm_117;
  highp float perceptualRoughness_118;
  mediump vec3 tmpvar_119;
  mediump vec3 albedo_120;
  albedo_120 = tmpvar_5;
  mediump vec3 specColor_121;
  specColor_121 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_6)) + (albedo_120 * tmpvar_6));
  mediump float tmpvar_122;
  tmpvar_122 = (0.7790837 - (tmpvar_6 * 0.7790837));
  tmpvar_119 = (albedo_120 * tmpvar_122);
  tmpvar_113 = 0.0;
  mediump float alpha_123;
  alpha_123 = tmpvar_113;
  tmpvar_113 = alpha_123;
  mediump float tmpvar_124;
  tmpvar_124 = (1.0 - tmpvar_7);
  perceptualRoughness_118 = tmpvar_124;
  highp vec3 tmpvar_125;
  highp vec3 inVec_126;
  inVec_126 = (tmpvar_112 + tmpvar_111);
  tmpvar_125 = (inVec_126 * inversesqrt(max (0.001, 
    dot (inVec_126, inVec_126)
  )));
  highp float tmpvar_127;
  tmpvar_127 = abs(dot (tmpvar_111, normalWorld_9));
  highp float tmpvar_128;
  tmpvar_128 = clamp (dot (normalWorld_9, tmpvar_112), 0.0, 1.0);
  highp float tmpvar_129;
  tmpvar_129 = clamp (dot (normalWorld_9, tmpvar_125), 0.0, 1.0);
  mediump float tmpvar_130;
  highp float tmpvar_131;
  tmpvar_131 = clamp (dot (tmpvar_112, tmpvar_125), 0.0, 1.0);
  tmpvar_130 = tmpvar_131;
  mediump float tmpvar_132;
  mediump float NdotV_133;
  NdotV_133 = tmpvar_127;
  mediump float NdotL_134;
  NdotL_134 = tmpvar_128;
  mediump float perceptualRoughness_135;
  perceptualRoughness_135 = perceptualRoughness_118;
  mediump float tmpvar_136;
  tmpvar_136 = (0.5 + ((2.0 * tmpvar_130) * (tmpvar_130 * perceptualRoughness_135)));
  mediump float x_137;
  x_137 = (1.0 - NdotL_134);
  mediump float x_138;
  x_138 = (1.0 - NdotV_133);
  tmpvar_132 = ((1.0 + (
    (tmpvar_136 - 1.0)
   * 
    ((x_137 * x_137) * ((x_137 * x_137) * x_137))
  )) * (1.0 + (
    (tmpvar_136 - 1.0)
   * 
    ((x_138 * x_138) * ((x_138 * x_138) * x_138))
  )));
  highp float tmpvar_139;
  tmpvar_139 = (tmpvar_132 * tmpvar_128);
  diffuseTerm_117 = tmpvar_139;
  highp float tmpvar_140;
  tmpvar_140 = max ((perceptualRoughness_118 * perceptualRoughness_118), 0.002);
  highp float tmpvar_141;
  tmpvar_141 = (tmpvar_140 * tmpvar_140);
  highp float tmpvar_142;
  tmpvar_142 = (((
    (tmpvar_129 * tmpvar_141)
   - tmpvar_129) * tmpvar_129) + 1.0);
  surfaceReduction_116 = (1.0 - ((0.28 * tmpvar_140) * perceptualRoughness_118));
  mediump vec3 tmpvar_143;
  mediump float x_144;
  x_144 = (1.0 - tmpvar_130);
  tmpvar_143 = (specColor_121 + ((1.0 - specColor_121) * (
    (x_144 * x_144)
   * 
    ((x_144 * x_144) * x_144)
  )));
  color_115 = (((
    (tmpvar_119 * LIGHT_COLOR)
   * diffuseTerm_117) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_141)
       / 
        ((tmpvar_142 * tmpvar_142) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_128 * (
          (tmpvar_127 * (1.0 - tmpvar_140))
         + tmpvar_140)) + (tmpvar_127 * (
          (tmpvar_128 * (1.0 - tmpvar_140))
         + tmpvar_140))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_128)) * LIGHT_COLOR)
   * tmpvar_143)) * tmpvar_31);
  color_115 = (color_115 + tmpvar_8);
  color_115 = (color_115 + (tmpvar_119 * rgbm_27.xyz));
  mediump float cosA_145;
  cosA_145 = tmpvar_127;
  mediump float tmpvar_146;
  mediump float x_147;
  x_147 = (1.0 - cosA_145);
  tmpvar_146 = ((x_147 * x_147) * ((x_147 * x_147) * x_147));
  mediump vec3 tmpvar_148;
  tmpvar_148 = (surfaceReduction_116 * ((specColor_121 * 
    (1.0 - tmpvar_146)
  ) + (vec3(
    clamp ((tmpvar_7 + (1.0 - tmpvar_122)), 0.0, 1.0)
  ) * tmpvar_146)));
  specularEnv_114 = tmpvar_148;
  color_115 = (color_115 + (specularEnv_114 * rgbm_19.xyz));
  outColor_4.xyz = color_115;
  lowp vec4 tmpvar_149;
  tmpvar_149 = texture (_MaskTex, xlv_TEXCOORD0);
  maskCol_3 = tmpvar_149;
  outColor_4.w = ((col_13.w * maskCol_3.w) * _Opacity);
  highp vec3 tmpvar_150;
  tmpvar_150 = (xlv_TEXCOORD4.xyz / xlv_TEXCOORD4.w);
  highp vec2 tmpvar_151;
  tmpvar_151.x = tmpvar_150.x;
  tmpvar_151.y = (1.0 - tmpvar_150.y);
  lowp vec4 tmpvar_152;
  tmpvar_152 = texture (_BlendTex, tmpvar_151);
  dstColor_2 = tmpvar_152;
  srcColor_1 = outColor_4;
  outColor_4.w = ((col_13.w * maskCol_3.w) * _Opacity);
  highp int mode_153;
  mode_153 = int(_BlendType);
  bool tmpvar_154;
  tmpvar_154 = bool(1);
  highp vec3 tmpvar_155;
  if ((mode_153 == 1)) {
    tmpvar_155 = ((srcColor_1.www * srcColor_1.xyz) + (vec3((1.0 - srcColor_1.w)) * dstColor_2.xyz));
    tmpvar_154 = bool(0);
  } else {
    if ((mode_153 == 2)) {
      tmpvar_155 = ((srcColor_1.wwww * srcColor_1) + dstColor_2).xyz;
      tmpvar_154 = bool(0);
    } else {
      if ((mode_153 == 3)) {
        tmpvar_155 = (((srcColor_1 + 
          ((vec4(1.0, 1.0, 1.0, 1.0) - srcColor_1) * dstColor_2)
        ).xyz * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
        tmpvar_154 = bool(0);
      } else {
        if ((mode_153 == 4)) {
          highp float tmpvar_156;
          if ((dstColor_2.x < 0.5)) {
            tmpvar_156 = ((2.0 * srcColor_1.x) * dstColor_2.x);
          } else {
            tmpvar_156 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.x)
            ) * (1.0 - dstColor_2.x)));
          };
          highp float tmpvar_157;
          if ((dstColor_2.y < 0.5)) {
            tmpvar_157 = ((2.0 * srcColor_1.y) * dstColor_2.y);
          } else {
            tmpvar_157 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.y)
            ) * (1.0 - dstColor_2.y)));
          };
          highp float tmpvar_158;
          if ((dstColor_2.z < 0.5)) {
            tmpvar_158 = ((2.0 * srcColor_1.z) * dstColor_2.z);
          } else {
            tmpvar_158 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.z)
            ) * (1.0 - dstColor_2.z)));
          };
          highp vec3 tmpvar_159;
          tmpvar_159.x = tmpvar_156;
          tmpvar_159.y = tmpvar_157;
          tmpvar_159.z = tmpvar_158;
          tmpvar_155 = ((tmpvar_159 * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
          tmpvar_154 = bool(0);
        } else {
          if ((mode_153 == 5)) {
            highp float tmpvar_160;
            if ((dstColor_2.x < 0.5)) {
              tmpvar_160 = (((2.0 * dstColor_2.x) * srcColor_1.x) + ((dstColor_2.x * dstColor_2.x) * (1.0 - 
                (2.0 * srcColor_1.x)
              )));
            } else {
              tmpvar_160 = (((2.0 * dstColor_2.x) * (1.0 - srcColor_1.x)) + (sqrt(dstColor_2.x) * (
                (2.0 * srcColor_1.x)
               - 1.0)));
            };
            highp float tmpvar_161;
            if ((dstColor_2.y < 0.5)) {
              tmpvar_161 = (((2.0 * dstColor_2.y) * srcColor_1.y) + ((dstColor_2.y * dstColor_2.y) * (1.0 - 
                (2.0 * srcColor_1.y)
              )));
            } else {
              tmpvar_161 = (((2.0 * dstColor_2.y) * (1.0 - srcColor_1.y)) + (sqrt(dstColor_2.y) * (
                (2.0 * srcColor_1.y)
               - 1.0)));
            };
            highp float tmpvar_162;
            if ((dstColor_2.z < 0.5)) {
              tmpvar_162 = (((2.0 * dstColor_2.z) * srcColor_1.z) + ((dstColor_2.z * dstColor_2.z) * (1.0 - 
                (2.0 * srcColor_1.z)
              )));
            } else {
              tmpvar_162 = (((2.0 * dstColor_2.z) * (1.0 - srcColor_1.z)) + (sqrt(dstColor_2.z) * (
                (2.0 * srcColor_1.z)
               - 1.0)));
            };
            highp vec3 tmpvar_163;
            tmpvar_163.x = tmpvar_160;
            tmpvar_163.y = tmpvar_161;
            tmpvar_163.z = tmpvar_162;
            tmpvar_155 = ((tmpvar_163 * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
            tmpvar_154 = bool(0);
          } else {
            if ((mode_153 == 6)) {
              tmpvar_155 = ((max (srcColor_1.xyz, dstColor_2.xyz) * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
              tmpvar_154 = bool(0);
            } else {
              if ((mode_153 == 7)) {
                tmpvar_155 = (((srcColor_1.xyz * dstColor_2.xyz) * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
                tmpvar_154 = bool(0);
              };
            };
          };
        };
      };
    };
  };
  if (tmpvar_154) {
    tmpvar_155 = vec3(1.0, 0.0, 0.0);
    tmpvar_154 = bool(0);
  };
  outColor_4.xyz = tmpvar_155;
  outColor_4.w = 1.0;
  _glesFragData[0] = outColor_4;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendType",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
in highp vec3 _glesBinormal;
in highp vec3 _glesTangent;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD3;
out highp vec4 xlv_TEXCOORD4;
out highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  tmpvar_7 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_8));
  highp vec4 tmpvar_9;
  tmpvar_9.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_9.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_11;
  tmpvar_11 = (LOCALWORLD_TRANSFORM * tmpvar_10).xyz;
  highp mat3 tmpvar_12;
  tmpvar_12[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_12[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_12[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_2.xyz = normalize((tmpvar_12 * _glesNormal));
  highp mat3 tmpvar_13;
  tmpvar_13[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_13[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_13[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_3.xyz = normalize((tmpvar_13 * _glesTangent));
  highp mat3 tmpvar_14;
  tmpvar_14[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_14[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_14[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  tmpvar_4.xyz = normalize((tmpvar_14 * _glesBinormal));
  tmpvar_2.w = tmpvar_11.x;
  tmpvar_3.w = tmpvar_11.y;
  tmpvar_4.w = tmpvar_11.z;
  tmpvar_5.zw = tmpvar_7.zw;
  tmpvar_5.xy = ((tmpvar_7.xy * 0.5) + (0.5 * tmpvar_7.ww));
  highp vec4 tmpvar_15;
  tmpvar_15.w = 1.0;
  tmpvar_15.xyz = tmpvar_1.xyz;
  tmpvar_6.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_15))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_16;
  tmpvar_16.w = 1.0;
  tmpvar_16.xyz = tmpvar_1.xyz;
  tmpvar_6.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_16)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  xlv_TEXCOORD4 = tmpvar_5;
  gl_Position = (tmpvar_9 * tmpvar_7);
  xlv_TEXCOORD5 = tmpvar_6;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _BlendTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _Opacity;
uniform highp float _BlendType;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD3;
in highp vec4 xlv_TEXCOORD4;
in highp vec4 xlv_TEXCOORD5;
void main ()
{
  highp vec4 srcColor_1;
  highp vec4 dstColor_2;
  highp vec4 maskCol_3;
  highp vec4 outColor_4;
  highp vec3 tmpvar_5;
  mediump float tmpvar_6;
  mediump float tmpvar_7;
  highp vec3 tmpvar_8;
  highp vec3 normalWorld_9;
  highp vec3 normalTangent_10;
  highp vec3 emissionMapColor_11;
  highp vec2 mg_12;
  highp vec4 col_13;
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture (_MainTex, xlv_TEXCOORD0);
  col_13 = tmpvar_14;
  lowp vec2 tmpvar_15;
  tmpvar_15 = texture (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_12 = tmpvar_15;
  lowp vec3 tmpvar_16;
  tmpvar_16 = texture (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_11 = tmpvar_16;
  lowp vec3 tmpvar_17;
  tmpvar_17 = texture (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_10 = tmpvar_17;
  normalTangent_10 = ((normalTangent_10 * 2.0) - 1.0);
  normalWorld_9 = normalize(((
    (normalTangent_10.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_10.y * xlv_TEXCOORD2.xyz)
  ) + (normalTangent_10.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_18;
  tmpvar_18.x = xlv_TEXCOORD1.w;
  tmpvar_18.y = xlv_TEXCOORD2.w;
  tmpvar_18.z = xlv_TEXCOORD3.w;
  highp vec4 rgbm_19;
  highp vec3 tmpvar_20;
  highp vec3 I_21;
  I_21 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_18)));
  tmpvar_20 = (I_21 - (2.0 * (
    dot (normalWorld_9, I_21)
   * normalWorld_9)));
  highp mat2 tmpvar_22;
  tmpvar_22[uint(0)].x = 1.0;
  tmpvar_22[uint(0)].y = 0.0;
  tmpvar_22[1u].x = -0.0;
  tmpvar_22[1u].y = 1.0;
  highp vec3 tmpvar_23;
  tmpvar_23.xy = (tmpvar_22 * tmpvar_20.xz);
  tmpvar_23.z = tmpvar_20.y;
  highp vec4 tmpvar_24;
  tmpvar_24.xyz = tmpvar_23.xzy;
  tmpvar_24.w = ((1.0 - (mg_12.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_25;
  tmpvar_25 = textureLod (_GlossEnvMap, tmpvar_23.xzy, tmpvar_24.w);
  highp vec4 tmpvar_26;
  tmpvar_26 = tmpvar_25;
  rgbm_19.w = tmpvar_26.w;
  rgbm_19.xyz = ((tmpvar_26.xyz * tmpvar_26.w) * 6.0);
  highp vec4 rgbm_27;
  lowp vec4 tmpvar_28;
  tmpvar_28 = texture (_IrradianceMap, normalWorld_9);
  highp vec4 tmpvar_29;
  tmpvar_29 = tmpvar_28;
  rgbm_27.w = tmpvar_29.w;
  rgbm_27.xyz = ((tmpvar_29.xyz * tmpvar_29.w) * 6.0);
  tmpvar_5 = col_13.xyz;
  tmpvar_6 = (mg_12.x * _Metallic);
  tmpvar_7 = (mg_12.y * _Smoothness);
  tmpvar_8 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_11));
  highp vec4 shadowCoord_30;
  shadowCoord_30 = xlv_TEXCOORD5;
  highp float tmpvar_31;
  if ((xlv_TEXCOORD5.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_31 = 1.0;
  } else {
    highp vec2 tmpvar_32;
    tmpvar_32.x = LIGHT_PARAM.z;
    tmpvar_32.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_33;
    tmpvar_33.xy = tmpvar_32;
    highp float tmpvar_34;
    tmpvar_34 = (1.0/(LIGHT_PARAM.z));
    tmpvar_33.z = tmpvar_34;
    tmpvar_33.w = tmpvar_34;
    shadowCoord_30.y = (1.0 - xlv_TEXCOORD5.y);
    highp float shadow_35;
    highp vec2 tmpvar_36;
    tmpvar_36 = tmpvar_33.xy;
    shadow_35 = 0.0;
    highp vec3 tmpvar_37;
    tmpvar_37.xy = (shadowCoord_30.xy - LIGHT_PARAM.zz);
    tmpvar_37.z = shadowCoord_30.z;
    highp vec4 tmpvar_38;
    tmpvar_38 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_37.xy);
    highp float tmpvar_39;
    if ((tmpvar_38.x < xlv_TEXCOORD5.z)) {
      tmpvar_39 = 0.0;
    } else {
      tmpvar_39 = 1.0;
    };
    shadow_35 = tmpvar_39;
    highp vec2 tmpvar_40;
    tmpvar_40.x = 0.0;
    tmpvar_40.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (shadowCoord_30.xy + tmpvar_40);
    tmpvar_41.z = shadowCoord_30.z;
    highp vec4 tmpvar_42;
    tmpvar_42 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_41.xy);
    highp float tmpvar_43;
    if ((tmpvar_42.x < xlv_TEXCOORD5.z)) {
      tmpvar_43 = 0.0;
    } else {
      tmpvar_43 = 1.0;
    };
    shadow_35 = (tmpvar_39 + tmpvar_43);
    highp vec2 tmpvar_44;
    tmpvar_44.x = tmpvar_36.x;
    tmpvar_44.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (shadowCoord_30.xy + tmpvar_44);
    tmpvar_45.z = shadowCoord_30.z;
    highp vec4 tmpvar_46;
    tmpvar_46 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_45.xy);
    highp float tmpvar_47;
    if ((tmpvar_46.x < xlv_TEXCOORD5.z)) {
      tmpvar_47 = 0.0;
    } else {
      tmpvar_47 = 1.0;
    };
    shadow_35 = (shadow_35 + tmpvar_47);
    highp vec2 tmpvar_48;
    tmpvar_48.y = 0.0;
    tmpvar_48.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (shadowCoord_30.xy + tmpvar_48);
    tmpvar_49.z = shadowCoord_30.z;
    highp vec4 tmpvar_50;
    tmpvar_50 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_49.xy);
    highp float tmpvar_51;
    if ((tmpvar_50.x < xlv_TEXCOORD5.z)) {
      tmpvar_51 = 0.0;
    } else {
      tmpvar_51 = 1.0;
    };
    shadow_35 = (shadow_35 + tmpvar_51);
    highp vec4 tmpvar_52;
    tmpvar_52 = texture (TEXTURE_SHADOW_DEPTH, shadowCoord_30.xy);
    highp float tmpvar_53;
    if ((tmpvar_52.x < xlv_TEXCOORD5.z)) {
      tmpvar_53 = 0.0;
    } else {
      tmpvar_53 = 1.0;
    };
    shadow_35 = (shadow_35 + tmpvar_53);
    highp vec2 tmpvar_54;
    tmpvar_54.y = 0.0;
    tmpvar_54.x = tmpvar_36.x;
    highp vec3 tmpvar_55;
    tmpvar_55.xy = (shadowCoord_30.xy + tmpvar_54);
    tmpvar_55.z = shadowCoord_30.z;
    highp vec4 tmpvar_56;
    tmpvar_56 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_55.xy);
    highp float tmpvar_57;
    if ((tmpvar_56.x < xlv_TEXCOORD5.z)) {
      tmpvar_57 = 0.0;
    } else {
      tmpvar_57 = 1.0;
    };
    shadow_35 = (shadow_35 + tmpvar_57);
    highp vec2 tmpvar_58;
    tmpvar_58.x = -(LIGHT_PARAM.z);
    tmpvar_58.y = tmpvar_36.y;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (shadowCoord_30.xy + tmpvar_58);
    tmpvar_59.z = shadowCoord_30.z;
    highp vec4 tmpvar_60;
    tmpvar_60 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_59.xy);
    highp float tmpvar_61;
    if ((tmpvar_60.x < xlv_TEXCOORD5.z)) {
      tmpvar_61 = 0.0;
    } else {
      tmpvar_61 = 1.0;
    };
    shadow_35 = (shadow_35 + tmpvar_61);
    highp vec2 tmpvar_62;
    tmpvar_62.x = 0.0;
    tmpvar_62.y = tmpvar_36.y;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (shadowCoord_30.xy + tmpvar_62);
    tmpvar_63.z = shadowCoord_30.z;
    highp vec4 tmpvar_64;
    tmpvar_64 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_63.xy);
    highp float tmpvar_65;
    if ((tmpvar_64.x < xlv_TEXCOORD5.z)) {
      tmpvar_65 = 0.0;
    } else {
      tmpvar_65 = 1.0;
    };
    shadow_35 = (shadow_35 + tmpvar_65);
    highp vec3 tmpvar_66;
    tmpvar_66.xy = (shadowCoord_30.xy + LIGHT_PARAM.zz);
    tmpvar_66.z = shadowCoord_30.z;
    highp vec4 tmpvar_67;
    tmpvar_67 = texture (TEXTURE_SHADOW_DEPTH, tmpvar_66.xy);
    highp float tmpvar_68;
    if ((tmpvar_67.x < xlv_TEXCOORD5.z)) {
      tmpvar_68 = 0.0;
    } else {
      tmpvar_68 = 1.0;
    };
    shadow_35 = (shadow_35 + tmpvar_68);
    shadow_35 = (shadow_35 / 9.0);
    tmpvar_31 = mix (1.0, shadow_35, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_69;
  highp vec3 tmpvar_70;
  tmpvar_69 = normalize((CAMERA_WORLDPOSITION - tmpvar_18));
  tmpvar_70 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_71;
  highp vec3 specularEnv_72;
  highp vec3 color_73;
  mediump float surfaceReduction_74;
  mediump float diffuseTerm_75;
  highp float perceptualRoughness_76;
  mediump vec3 tmpvar_77;
  mediump vec3 albedo_78;
  albedo_78 = tmpvar_5;
  mediump vec3 specColor_79;
  specColor_79 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_6)) + (albedo_78 * tmpvar_6));
  mediump float tmpvar_80;
  tmpvar_80 = (0.7790837 - (tmpvar_6 * 0.7790837));
  tmpvar_77 = (albedo_78 * tmpvar_80);
  tmpvar_71 = 0.0;
  mediump float alpha_81;
  alpha_81 = tmpvar_71;
  tmpvar_71 = alpha_81;
  mediump float tmpvar_82;
  tmpvar_82 = (1.0 - tmpvar_7);
  perceptualRoughness_76 = tmpvar_82;
  highp vec3 tmpvar_83;
  highp vec3 inVec_84;
  inVec_84 = (tmpvar_70 + tmpvar_69);
  tmpvar_83 = (inVec_84 * inversesqrt(max (0.001, 
    dot (inVec_84, inVec_84)
  )));
  highp float tmpvar_85;
  tmpvar_85 = abs(dot (tmpvar_69, normalWorld_9));
  highp float tmpvar_86;
  tmpvar_86 = clamp (dot (normalWorld_9, tmpvar_70), 0.0, 1.0);
  highp float tmpvar_87;
  tmpvar_87 = clamp (dot (normalWorld_9, tmpvar_83), 0.0, 1.0);
  mediump float tmpvar_88;
  highp float tmpvar_89;
  tmpvar_89 = clamp (dot (tmpvar_70, tmpvar_83), 0.0, 1.0);
  tmpvar_88 = tmpvar_89;
  mediump float tmpvar_90;
  mediump float NdotV_91;
  NdotV_91 = tmpvar_85;
  mediump float NdotL_92;
  NdotL_92 = tmpvar_86;
  mediump float perceptualRoughness_93;
  perceptualRoughness_93 = perceptualRoughness_76;
  mediump float tmpvar_94;
  tmpvar_94 = (0.5 + ((2.0 * tmpvar_88) * (tmpvar_88 * perceptualRoughness_93)));
  mediump float x_95;
  x_95 = (1.0 - NdotL_92);
  mediump float x_96;
  x_96 = (1.0 - NdotV_91);
  tmpvar_90 = ((1.0 + (
    (tmpvar_94 - 1.0)
   * 
    ((x_95 * x_95) * ((x_95 * x_95) * x_95))
  )) * (1.0 + (
    (tmpvar_94 - 1.0)
   * 
    ((x_96 * x_96) * ((x_96 * x_96) * x_96))
  )));
  highp float tmpvar_97;
  tmpvar_97 = (tmpvar_90 * tmpvar_86);
  diffuseTerm_75 = tmpvar_97;
  highp float tmpvar_98;
  tmpvar_98 = max ((perceptualRoughness_76 * perceptualRoughness_76), 0.002);
  highp float tmpvar_99;
  tmpvar_99 = (tmpvar_98 * tmpvar_98);
  highp float tmpvar_100;
  tmpvar_100 = (((
    (tmpvar_87 * tmpvar_99)
   - tmpvar_87) * tmpvar_87) + 1.0);
  surfaceReduction_74 = (1.0 - ((0.28 * tmpvar_98) * perceptualRoughness_76));
  mediump vec3 tmpvar_101;
  mediump float x_102;
  x_102 = (1.0 - tmpvar_88);
  tmpvar_101 = (specColor_79 + ((1.0 - specColor_79) * (
    (x_102 * x_102)
   * 
    ((x_102 * x_102) * x_102)
  )));
  color_73 = (((
    (tmpvar_77 * LIGHT_COLOR)
   * diffuseTerm_75) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_99)
       / 
        ((tmpvar_100 * tmpvar_100) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_86 * (
          (tmpvar_85 * (1.0 - tmpvar_98))
         + tmpvar_98)) + (tmpvar_85 * (
          (tmpvar_86 * (1.0 - tmpvar_98))
         + tmpvar_98))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_86)) * LIGHT_COLOR)
   * tmpvar_101)) * tmpvar_31);
  color_73 = (color_73 + tmpvar_8);
  color_73 = (color_73 + (tmpvar_77 * rgbm_27.xyz));
  mediump float cosA_103;
  cosA_103 = tmpvar_85;
  mediump float tmpvar_104;
  mediump float x_105;
  x_105 = (1.0 - cosA_103);
  tmpvar_104 = ((x_105 * x_105) * ((x_105 * x_105) * x_105));
  mediump vec3 tmpvar_106;
  tmpvar_106 = (surfaceReduction_74 * ((specColor_79 * 
    (1.0 - tmpvar_104)
  ) + (vec3(
    clamp ((tmpvar_7 + (1.0 - tmpvar_80)), 0.0, 1.0)
  ) * tmpvar_104)));
  specularEnv_72 = tmpvar_106;
  color_73 = (color_73 + (specularEnv_72 * rgbm_19.xyz));
  outColor_4.xyz = color_73;
  lowp vec4 tmpvar_107;
  tmpvar_107 = texture (_MaskTex, xlv_TEXCOORD0);
  maskCol_3 = tmpvar_107;
  outColor_4.w = ((col_13.w * maskCol_3.w) * _Opacity);
  highp vec3 tmpvar_108;
  tmpvar_108 = (xlv_TEXCOORD4.xyz / xlv_TEXCOORD4.w);
  highp vec2 tmpvar_109;
  tmpvar_109.x = tmpvar_108.x;
  tmpvar_109.y = (1.0 - tmpvar_108.y);
  lowp vec4 tmpvar_110;
  tmpvar_110 = texture (_BlendTex, tmpvar_109);
  dstColor_2 = tmpvar_110;
  srcColor_1 = outColor_4;
  outColor_4.w = ((col_13.w * maskCol_3.w) * _Opacity);
  highp int mode_111;
  mode_111 = int(_BlendType);
  bool tmpvar_112;
  tmpvar_112 = bool(1);
  highp vec3 tmpvar_113;
  if ((mode_111 == 1)) {
    tmpvar_113 = ((srcColor_1.www * srcColor_1.xyz) + (vec3((1.0 - srcColor_1.w)) * dstColor_2.xyz));
    tmpvar_112 = bool(0);
  } else {
    if ((mode_111 == 2)) {
      tmpvar_113 = ((srcColor_1.wwww * srcColor_1) + dstColor_2).xyz;
      tmpvar_112 = bool(0);
    } else {
      if ((mode_111 == 3)) {
        tmpvar_113 = (((srcColor_1 + 
          ((vec4(1.0, 1.0, 1.0, 1.0) - srcColor_1) * dstColor_2)
        ).xyz * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
        tmpvar_112 = bool(0);
      } else {
        if ((mode_111 == 4)) {
          highp float tmpvar_114;
          if ((dstColor_2.x < 0.5)) {
            tmpvar_114 = ((2.0 * srcColor_1.x) * dstColor_2.x);
          } else {
            tmpvar_114 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.x)
            ) * (1.0 - dstColor_2.x)));
          };
          highp float tmpvar_115;
          if ((dstColor_2.y < 0.5)) {
            tmpvar_115 = ((2.0 * srcColor_1.y) * dstColor_2.y);
          } else {
            tmpvar_115 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.y)
            ) * (1.0 - dstColor_2.y)));
          };
          highp float tmpvar_116;
          if ((dstColor_2.z < 0.5)) {
            tmpvar_116 = ((2.0 * srcColor_1.z) * dstColor_2.z);
          } else {
            tmpvar_116 = (1.0 - ((2.0 * 
              (1.0 - srcColor_1.z)
            ) * (1.0 - dstColor_2.z)));
          };
          highp vec3 tmpvar_117;
          tmpvar_117.x = tmpvar_114;
          tmpvar_117.y = tmpvar_115;
          tmpvar_117.z = tmpvar_116;
          tmpvar_113 = ((tmpvar_117 * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
          tmpvar_112 = bool(0);
        } else {
          if ((mode_111 == 5)) {
            highp float tmpvar_118;
            if ((dstColor_2.x < 0.5)) {
              tmpvar_118 = (((2.0 * dstColor_2.x) * srcColor_1.x) + ((dstColor_2.x * dstColor_2.x) * (1.0 - 
                (2.0 * srcColor_1.x)
              )));
            } else {
              tmpvar_118 = (((2.0 * dstColor_2.x) * (1.0 - srcColor_1.x)) + (sqrt(dstColor_2.x) * (
                (2.0 * srcColor_1.x)
               - 1.0)));
            };
            highp float tmpvar_119;
            if ((dstColor_2.y < 0.5)) {
              tmpvar_119 = (((2.0 * dstColor_2.y) * srcColor_1.y) + ((dstColor_2.y * dstColor_2.y) * (1.0 - 
                (2.0 * srcColor_1.y)
              )));
            } else {
              tmpvar_119 = (((2.0 * dstColor_2.y) * (1.0 - srcColor_1.y)) + (sqrt(dstColor_2.y) * (
                (2.0 * srcColor_1.y)
               - 1.0)));
            };
            highp float tmpvar_120;
            if ((dstColor_2.z < 0.5)) {
              tmpvar_120 = (((2.0 * dstColor_2.z) * srcColor_1.z) + ((dstColor_2.z * dstColor_2.z) * (1.0 - 
                (2.0 * srcColor_1.z)
              )));
            } else {
              tmpvar_120 = (((2.0 * dstColor_2.z) * (1.0 - srcColor_1.z)) + (sqrt(dstColor_2.z) * (
                (2.0 * srcColor_1.z)
               - 1.0)));
            };
            highp vec3 tmpvar_121;
            tmpvar_121.x = tmpvar_118;
            tmpvar_121.y = tmpvar_119;
            tmpvar_121.z = tmpvar_120;
            tmpvar_113 = ((tmpvar_121 * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
            tmpvar_112 = bool(0);
          } else {
            if ((mode_111 == 6)) {
              tmpvar_113 = ((max (srcColor_1.xyz, dstColor_2.xyz) * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
              tmpvar_112 = bool(0);
            } else {
              if ((mode_111 == 7)) {
                tmpvar_113 = (((srcColor_1.xyz * dstColor_2.xyz) * srcColor_1.w) + (dstColor_2.xyz * (1.0 - srcColor_1.w)));
                tmpvar_112 = bool(0);
              };
            };
          };
        };
      };
    };
  };
  if (tmpvar_112) {
    tmpvar_113 = vec3(1.0, 0.0, 0.0);
    tmpvar_112 = bool(0);
  };
  outColor_4.xyz = tmpvar_113;
  outColor_4.w = 1.0;
  _glesFragData[0] = outColor_4;
}

]===],
	},
}


end

function Depth()

	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { DEPTHPASS }

	
Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 LIGHT_PARAM;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = _glesVertex.xyz;
  tmpvar_1 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2));
  highp vec4 clipPos_3;
  clipPos_3.xyw = tmpvar_1.xyw;
  clipPos_3.z = (tmpvar_1.z + (LIGHT_PARAM.x / tmpvar_1.w));
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  gl_Position = (tmpvar_4 * clipPos_3);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
void main ()
{
  _glesFragData[0] = vec4(0.0, 0.0, 0.0, 1.0);
}

]===],
	},
}

end