

function DefineParams()
	Properties = 
	{
		
_MainTex = { "Main Color", TEXTURE2D, "white" },
_MaskTex = { "Mask Color", TEXTURE2D, "white" },
_MetallicGlossMap = {"Metallic Gloss", TEXTURE2D, "white"},
_BumpMap = {"Normal Map", TEXTURE2D, "bump"},
_GlossEnvMap = {"Specular IBL Map", TEXTURECUBE, "black"},
_IrradianceMap = {"Diffuse IBL Map",TEXTURECUBE,"black"},
_Smoothness = {"Smoothness", FLOAT, "0.5" },
_Metallic = { "Metallic", FLOAT, "0.5" },
_EmissionColor = {"Emission Color", COLOR, "0.0,0.0,0.0,1.0"},
_EmissionMap = {"Emission Map",TEXTURE2D,"white"},
_Opacity = { "Opacity", FLOAT, "1.0" },
_IBLRotation =  { "IBLRotation", VEC3, "0.0,0.0,0.0" },

_BlendState = {"Blend State", FLOAT, "0.0"},

_BlendSrc = {"Blend Src", FLOAT, "4.0"},

_BlendDst = {"Blend Dst", FLOAT, "5.0"},

_DepthState = {"Depth State", FLOAT, "1.0"},

_DepthFc = {"Depth Test", FLOAT, "1.0"},

_CullMode = {"Cull Mode", FLOAT, "0.0"},

	}
	Attributes = 
	{
		_BlendState = "Enum(BlendOnOff)", 
		_BlendSrc = "Enum(BlendFactor)", 
		_BlendDst = "Enum(BlendFactor)", 
		_DepthState = "Enum(DepthMode)", 
		_DepthFc = "Enum(DepthFunc)", 
		_CullMode = "Enum(CullMode)", 
	}
	
end



function Init()
	PassNames = 
	{
		"ForwardBase","ForwardAdd","Depth"
	}

ShaderName = "StandardPbr"
RenderQueue = "Transparent"
end

function ForwardBase()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { "%_BlendState", "%_BlendSrc", "%_BlendDst", ONE, ONE }
DRAW_MODE = { "%_CullMode", DEPTH_MASK_ON, "%_DepthState", "%_DepthFc" }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IBLRotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = tmpvar_11[0].xyz;
  tmpvar_15[1] = tmpvar_11[1].xyz;
  tmpvar_15[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_16[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_16[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = tmpvar_11[0].xyz;
  tmpvar_17[1] = tmpvar_11[1].xyz;
  tmpvar_17[2] = tmpvar_11[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_11[0].xyz;
  tmpvar_19[1] = tmpvar_11[1].xyz;
  tmpvar_19[2] = tmpvar_11[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[#extension GL_EXT_shader_texture_lod : enable
lowp vec4 impl_low_textureCubeLodEXT(lowp samplerCube sampler, highp vec3 coord, mediump float lod)
{
#if defined(GL_EXT_shader_texture_lod)
	return textureCubeLodEXT(sampler, coord, lod);
#else
	return textureCube(sampler, coord, lod);
#endif
}

uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _Opacity;
uniform highp vec3 _IBLRotation;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 normalWorld_6;
  highp vec3 normalTangent_7;
  highp vec3 emissionMapColor_8;
  highp vec2 mg_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  lowp vec2 tmpvar_12;
  tmpvar_12 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_9 = tmpvar_12;
  lowp vec3 tmpvar_13;
  tmpvar_13 = texture2D (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_8 = tmpvar_13;
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_7 = tmpvar_14;
  normalTangent_7 = ((normalTangent_7 * 2.0) - 1.0);
  normalWorld_6 = normalize(((
    (normalTangent_7.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_7.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  highp float tmpvar_16;
  tmpvar_16 = cos(_IBLRotation.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_IBLRotation.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_IBLRotation.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_IBLRotation.z);
  highp float tmpvar_20;
  tmpvar_20 = cos(_IBLRotation.x);
  highp float tmpvar_21;
  tmpvar_21 = sin(_IBLRotation.x);
  highp mat4 tmpvar_22;
  tmpvar_22[0].x = (tmpvar_16 * tmpvar_18);
  tmpvar_22[0].y = ((tmpvar_17 * tmpvar_21) - ((tmpvar_16 * tmpvar_19) * tmpvar_20));
  tmpvar_22[0].z = (((tmpvar_16 * tmpvar_19) * tmpvar_21) + (tmpvar_17 * tmpvar_20));
  tmpvar_22[0].w = 0.0;
  tmpvar_22[1].x = tmpvar_19;
  tmpvar_22[1].y = (tmpvar_18 * tmpvar_20);
  tmpvar_22[1].z = (-(tmpvar_18) * tmpvar_21);
  tmpvar_22[1].w = 0.0;
  tmpvar_22[2].x = (-(tmpvar_17) * tmpvar_18);
  tmpvar_22[2].y = (((tmpvar_17 * tmpvar_19) * tmpvar_20) + (tmpvar_16 * tmpvar_21));
  tmpvar_22[2].z = (((
    -(tmpvar_17)
   * tmpvar_19) * tmpvar_21) + (tmpvar_16 * tmpvar_20));
  tmpvar_22[2].w = 0.0;
  tmpvar_22[3].x = 0.0;
  tmpvar_22[3].y = 0.0;
  tmpvar_22[3].z = 0.0;
  tmpvar_22[3].w = 1.0;
  highp vec4 rgbm_23;
  highp vec3 I_24;
  I_24 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_15)));
  highp vec4 tmpvar_25;
  tmpvar_25.w = 0.0;
  tmpvar_25.xyz = (I_24 - (2.0 * (
    dot (normalWorld_6, I_24)
   * normalWorld_6)));
  highp vec3 tmpvar_26;
  tmpvar_26 = normalize((tmpvar_22 * tmpvar_25).xyz);
  highp vec4 tmpvar_27;
  tmpvar_27.xyz = tmpvar_26;
  tmpvar_27.w = ((1.0 - (mg_9.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_28;
  tmpvar_28 = impl_low_textureCubeLodEXT (_GlossEnvMap, tmpvar_26, tmpvar_27.w);
  highp vec4 tmpvar_29;
  tmpvar_29 = tmpvar_28;
  rgbm_23.w = tmpvar_29.w;
  rgbm_23.xyz = ((tmpvar_29.xyz * tmpvar_29.w) * 6.0);
  highp vec4 rgbm_30;
  lowp vec4 tmpvar_31;
  tmpvar_31 = textureCube (_IrradianceMap, normalWorld_6);
  highp vec4 tmpvar_32;
  tmpvar_32 = tmpvar_31;
  rgbm_30.w = tmpvar_32.w;
  rgbm_30.xyz = ((tmpvar_32.xyz * tmpvar_32.w) * 6.0);
  tmpvar_3 = col_10.xyz;
  tmpvar_4 = (mg_9.x * _Metallic);
  tmpvar_5 = (mg_9.y * _Smoothness);
  highp float tmpvar_33;
  highp vec3 specularEnv_34;
  highp vec3 color_35;
  mediump float surfaceReduction_36;
  highp float perceptualRoughness_37;
  mediump vec3 tmpvar_38;
  mediump vec3 albedo_39;
  albedo_39 = tmpvar_3;
  mediump float tmpvar_40;
  tmpvar_40 = (0.7790837 - (tmpvar_4 * 0.7790837));
  tmpvar_38 = (albedo_39 * tmpvar_40);
  tmpvar_33 = 0.0;
  mediump float alpha_41;
  alpha_41 = tmpvar_33;
  tmpvar_33 = alpha_41;
  mediump float tmpvar_42;
  tmpvar_42 = (1.0 - tmpvar_5);
  perceptualRoughness_37 = tmpvar_42;
  highp float tmpvar_43;
  tmpvar_43 = abs(dot (normalize(
    (CAMERA_WORLDPOSITION - tmpvar_15)
  ), normalWorld_6));
  highp float tmpvar_44;
  tmpvar_44 = max ((perceptualRoughness_37 * perceptualRoughness_37), 0.002);
  surfaceReduction_36 = (1.0 - ((0.28 * tmpvar_44) * perceptualRoughness_37));
  color_35 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_8));
  color_35 = (color_35 + (tmpvar_38 * rgbm_30.xyz));
  mediump float cosA_45;
  cosA_45 = tmpvar_43;
  mediump float tmpvar_46;
  mediump float x_47;
  x_47 = (1.0 - cosA_45);
  tmpvar_46 = ((x_47 * x_47) * ((x_47 * x_47) * x_47));
  mediump vec3 tmpvar_48;
  tmpvar_48 = (surfaceReduction_36 * ((
    ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_39 * tmpvar_4))
   * 
    (1.0 - tmpvar_46)
  ) + (vec3(
    clamp ((tmpvar_5 + (1.0 - tmpvar_40)), 0.0, 1.0)
  ) * tmpvar_46)));
  specularEnv_34 = tmpvar_48;
  color_35 = (color_35 + (specularEnv_34 * rgbm_23.xyz));
  outColor_2.xyz = color_35;
  lowp vec4 tmpvar_49;
  tmpvar_49 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_49;
  outColor_2.w = ((col_10.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IBLRotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = tmpvar_11[0].xyz;
  tmpvar_15[1] = tmpvar_11[1].xyz;
  tmpvar_15[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_16[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_16[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = tmpvar_11[0].xyz;
  tmpvar_17[1] = tmpvar_11[1].xyz;
  tmpvar_17[2] = tmpvar_11[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_11[0].xyz;
  tmpvar_19[1] = tmpvar_11[1].xyz;
  tmpvar_19[2] = tmpvar_11[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[#extension GL_EXT_shader_texture_lod : enable
lowp vec4 impl_low_textureCubeLodEXT(lowp samplerCube sampler, highp vec3 coord, mediump float lod)
{
#if defined(GL_EXT_shader_texture_lod)
	return textureCubeLodEXT(sampler, coord, lod);
#else
	return textureCube(sampler, coord, lod);
#endif
}

uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _Opacity;
uniform highp vec3 _IBLRotation;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 normalWorld_6;
  highp vec3 normalTangent_7;
  highp vec3 emissionMapColor_8;
  highp vec2 mg_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  lowp vec2 tmpvar_12;
  tmpvar_12 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_9 = tmpvar_12;
  lowp vec3 tmpvar_13;
  tmpvar_13 = texture2D (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_8 = tmpvar_13;
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_7 = tmpvar_14;
  normalTangent_7 = ((normalTangent_7 * 2.0) - 1.0);
  normalWorld_6 = normalize(((
    (normalTangent_7.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_7.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  highp float tmpvar_16;
  tmpvar_16 = cos(_IBLRotation.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_IBLRotation.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_IBLRotation.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_IBLRotation.z);
  highp float tmpvar_20;
  tmpvar_20 = cos(_IBLRotation.x);
  highp float tmpvar_21;
  tmpvar_21 = sin(_IBLRotation.x);
  highp mat4 tmpvar_22;
  tmpvar_22[0].x = (tmpvar_16 * tmpvar_18);
  tmpvar_22[0].y = ((tmpvar_17 * tmpvar_21) - ((tmpvar_16 * tmpvar_19) * tmpvar_20));
  tmpvar_22[0].z = (((tmpvar_16 * tmpvar_19) * tmpvar_21) + (tmpvar_17 * tmpvar_20));
  tmpvar_22[0].w = 0.0;
  tmpvar_22[1].x = tmpvar_19;
  tmpvar_22[1].y = (tmpvar_18 * tmpvar_20);
  tmpvar_22[1].z = (-(tmpvar_18) * tmpvar_21);
  tmpvar_22[1].w = 0.0;
  tmpvar_22[2].x = (-(tmpvar_17) * tmpvar_18);
  tmpvar_22[2].y = (((tmpvar_17 * tmpvar_19) * tmpvar_20) + (tmpvar_16 * tmpvar_21));
  tmpvar_22[2].z = (((
    -(tmpvar_17)
   * tmpvar_19) * tmpvar_21) + (tmpvar_16 * tmpvar_20));
  tmpvar_22[2].w = 0.0;
  tmpvar_22[3].x = 0.0;
  tmpvar_22[3].y = 0.0;
  tmpvar_22[3].z = 0.0;
  tmpvar_22[3].w = 1.0;
  highp vec4 rgbm_23;
  highp vec3 I_24;
  I_24 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_15)));
  highp vec4 tmpvar_25;
  tmpvar_25.w = 0.0;
  tmpvar_25.xyz = (I_24 - (2.0 * (
    dot (normalWorld_6, I_24)
   * normalWorld_6)));
  highp vec3 tmpvar_26;
  tmpvar_26 = normalize((tmpvar_22 * tmpvar_25).xyz);
  highp vec4 tmpvar_27;
  tmpvar_27.xyz = tmpvar_26;
  tmpvar_27.w = ((1.0 - (mg_9.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_28;
  tmpvar_28 = impl_low_textureCubeLodEXT (_GlossEnvMap, tmpvar_26, tmpvar_27.w);
  highp vec4 tmpvar_29;
  tmpvar_29 = tmpvar_28;
  rgbm_23.w = tmpvar_29.w;
  rgbm_23.xyz = ((tmpvar_29.xyz * tmpvar_29.w) * 6.0);
  highp vec4 rgbm_30;
  lowp vec4 tmpvar_31;
  tmpvar_31 = textureCube (_IrradianceMap, normalWorld_6);
  highp vec4 tmpvar_32;
  tmpvar_32 = tmpvar_31;
  rgbm_30.w = tmpvar_32.w;
  rgbm_30.xyz = ((tmpvar_32.xyz * tmpvar_32.w) * 6.0);
  tmpvar_3 = col_10.xyz;
  tmpvar_4 = (mg_9.x * _Metallic);
  tmpvar_5 = (mg_9.y * _Smoothness);
  highp vec3 tmpvar_33;
  highp vec3 tmpvar_34;
  tmpvar_33 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_34 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_35;
  highp vec3 specularEnv_36;
  highp vec3 color_37;
  mediump float surfaceReduction_38;
  mediump float diffuseTerm_39;
  highp float perceptualRoughness_40;
  mediump vec3 tmpvar_41;
  mediump vec3 albedo_42;
  albedo_42 = tmpvar_3;
  mediump vec3 specColor_43;
  specColor_43 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_42 * tmpvar_4));
  mediump float tmpvar_44;
  tmpvar_44 = (0.7790837 - (tmpvar_4 * 0.7790837));
  tmpvar_41 = (albedo_42 * tmpvar_44);
  tmpvar_35 = 0.0;
  mediump float alpha_45;
  alpha_45 = tmpvar_35;
  tmpvar_35 = alpha_45;
  mediump float tmpvar_46;
  tmpvar_46 = (1.0 - tmpvar_5);
  perceptualRoughness_40 = tmpvar_46;
  highp vec3 tmpvar_47;
  highp vec3 inVec_48;
  inVec_48 = (tmpvar_34 + tmpvar_33);
  tmpvar_47 = (inVec_48 * inversesqrt(max (0.001, 
    dot (inVec_48, inVec_48)
  )));
  highp float tmpvar_49;
  tmpvar_49 = abs(dot (tmpvar_33, normalWorld_6));
  highp float tmpvar_50;
  tmpvar_50 = clamp (dot (normalWorld_6, tmpvar_34), 0.0, 1.0);
  highp float tmpvar_51;
  tmpvar_51 = clamp (dot (normalWorld_6, tmpvar_47), 0.0, 1.0);
  mediump float tmpvar_52;
  highp float tmpvar_53;
  tmpvar_53 = clamp (dot (tmpvar_34, tmpvar_47), 0.0, 1.0);
  tmpvar_52 = tmpvar_53;
  mediump float tmpvar_54;
  mediump float NdotV_55;
  NdotV_55 = tmpvar_49;
  mediump float NdotL_56;
  NdotL_56 = tmpvar_50;
  mediump float perceptualRoughness_57;
  perceptualRoughness_57 = perceptualRoughness_40;
  mediump float tmpvar_58;
  tmpvar_58 = (0.5 + ((2.0 * tmpvar_52) * (tmpvar_52 * perceptualRoughness_57)));
  mediump float x_59;
  x_59 = (1.0 - NdotL_56);
  mediump float x_60;
  x_60 = (1.0 - NdotV_55);
  tmpvar_54 = ((1.0 + (
    (tmpvar_58 - 1.0)
   * 
    ((x_59 * x_59) * ((x_59 * x_59) * x_59))
  )) * (1.0 + (
    (tmpvar_58 - 1.0)
   * 
    ((x_60 * x_60) * ((x_60 * x_60) * x_60))
  )));
  highp float tmpvar_61;
  tmpvar_61 = (tmpvar_54 * tmpvar_50);
  diffuseTerm_39 = tmpvar_61;
  highp float tmpvar_62;
  tmpvar_62 = max ((perceptualRoughness_40 * perceptualRoughness_40), 0.002);
  highp float tmpvar_63;
  tmpvar_63 = (tmpvar_62 * tmpvar_62);
  highp float tmpvar_64;
  tmpvar_64 = (((
    (tmpvar_51 * tmpvar_63)
   - tmpvar_51) * tmpvar_51) + 1.0);
  surfaceReduction_38 = (1.0 - ((0.28 * tmpvar_62) * perceptualRoughness_40));
  mediump vec3 tmpvar_65;
  mediump float x_66;
  x_66 = (1.0 - tmpvar_52);
  tmpvar_65 = (specColor_43 + ((1.0 - specColor_43) * (
    (x_66 * x_66)
   * 
    ((x_66 * x_66) * x_66)
  )));
  color_37 = (((tmpvar_41 * LIGHT_COLOR) * diffuseTerm_39) + ((
    max (0.0, (sqrt(max (0.0001, 
      ((((0.3183099 * tmpvar_63) / (
        (tmpvar_64 * tmpvar_64)
       + 1e-7)) * (0.5 / (
        ((tmpvar_50 * ((tmpvar_49 * 
          (1.0 - tmpvar_62)
        ) + tmpvar_62)) + (tmpvar_49 * ((tmpvar_50 * 
          (1.0 - tmpvar_62)
        ) + tmpvar_62)))
       + 0.0001))) * 3.141593)
    )) * tmpvar_50))
   * LIGHT_COLOR) * tmpvar_65));
  color_37 = (color_37 + (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_8)));
  color_37 = (color_37 + (tmpvar_41 * rgbm_30.xyz));
  mediump float cosA_67;
  cosA_67 = tmpvar_49;
  mediump float tmpvar_68;
  mediump float x_69;
  x_69 = (1.0 - cosA_67);
  tmpvar_68 = ((x_69 * x_69) * ((x_69 * x_69) * x_69));
  mediump vec3 tmpvar_70;
  tmpvar_70 = (surfaceReduction_38 * ((specColor_43 * 
    (1.0 - tmpvar_68)
  ) + (vec3(
    clamp ((tmpvar_5 + (1.0 - tmpvar_44)), 0.0, 1.0)
  ) * tmpvar_68)));
  specularEnv_36 = tmpvar_70;
  color_37 = (color_37 + (specularEnv_36 * rgbm_23.xyz));
  outColor_2.xyz = color_37;
  lowp vec4 tmpvar_71;
  tmpvar_71 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_71;
  outColor_2.w = ((col_10.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IBLRotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_texture_lod : enable
#extension GL_EXT_shadow_samplers : enable
lowp vec4 impl_low_textureCubeLodEXT(lowp samplerCube sampler, highp vec3 coord, mediump float lod)
{
#if defined(GL_EXT_shader_texture_lod)
	return textureCubeLodEXT(sampler, coord, lod);
#else
	return textureCube(sampler, coord, lod);
#endif
}

uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _Opacity;
uniform highp vec3 _IBLRotation;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec3 normalWorld_7;
  highp vec3 normalTangent_8;
  highp vec3 emissionMapColor_9;
  highp vec2 mg_10;
  highp vec4 col_11;
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_11 = tmpvar_12;
  lowp vec2 tmpvar_13;
  tmpvar_13 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_10 = tmpvar_13;
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture2D (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_9 = tmpvar_14;
  lowp vec3 tmpvar_15;
  tmpvar_15 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_8 = tmpvar_15;
  normalTangent_8 = ((normalTangent_8 * 2.0) - 1.0);
  normalWorld_7 = normalize(((
    (normalTangent_8.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_8.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_8.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_16;
  tmpvar_16.x = xlv_TEXCOORD1.w;
  tmpvar_16.y = xlv_TEXCOORD2.w;
  tmpvar_16.z = xlv_TEXCOORD3.w;
  highp float tmpvar_17;
  tmpvar_17 = cos(_IBLRotation.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_IBLRotation.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_IBLRotation.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_IBLRotation.z);
  highp float tmpvar_21;
  tmpvar_21 = cos(_IBLRotation.x);
  highp float tmpvar_22;
  tmpvar_22 = sin(_IBLRotation.x);
  highp mat4 tmpvar_23;
  tmpvar_23[0].x = (tmpvar_17 * tmpvar_19);
  tmpvar_23[0].y = ((tmpvar_18 * tmpvar_22) - ((tmpvar_17 * tmpvar_20) * tmpvar_21));
  tmpvar_23[0].z = (((tmpvar_17 * tmpvar_20) * tmpvar_22) + (tmpvar_18 * tmpvar_21));
  tmpvar_23[0].w = 0.0;
  tmpvar_23[1].x = tmpvar_20;
  tmpvar_23[1].y = (tmpvar_19 * tmpvar_21);
  tmpvar_23[1].z = (-(tmpvar_19) * tmpvar_22);
  tmpvar_23[1].w = 0.0;
  tmpvar_23[2].x = (-(tmpvar_18) * tmpvar_19);
  tmpvar_23[2].y = (((tmpvar_18 * tmpvar_20) * tmpvar_21) + (tmpvar_17 * tmpvar_22));
  tmpvar_23[2].z = (((
    -(tmpvar_18)
   * tmpvar_20) * tmpvar_22) + (tmpvar_17 * tmpvar_21));
  tmpvar_23[2].w = 0.0;
  tmpvar_23[3].x = 0.0;
  tmpvar_23[3].y = 0.0;
  tmpvar_23[3].z = 0.0;
  tmpvar_23[3].w = 1.0;
  highp vec4 rgbm_24;
  highp vec3 I_25;
  I_25 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_16)));
  highp vec4 tmpvar_26;
  tmpvar_26.w = 0.0;
  tmpvar_26.xyz = (I_25 - (2.0 * (
    dot (normalWorld_7, I_25)
   * normalWorld_7)));
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize((tmpvar_23 * tmpvar_26).xyz);
  highp vec4 tmpvar_28;
  tmpvar_28.xyz = tmpvar_27;
  tmpvar_28.w = ((1.0 - (mg_10.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_29;
  tmpvar_29 = impl_low_textureCubeLodEXT (_GlossEnvMap, tmpvar_27, tmpvar_28.w);
  highp vec4 tmpvar_30;
  tmpvar_30 = tmpvar_29;
  rgbm_24.w = tmpvar_30.w;
  rgbm_24.xyz = ((tmpvar_30.xyz * tmpvar_30.w) * 6.0);
  highp vec4 rgbm_31;
  lowp vec4 tmpvar_32;
  tmpvar_32 = textureCube (_IrradianceMap, normalWorld_7);
  highp vec4 tmpvar_33;
  tmpvar_33 = tmpvar_32;
  rgbm_31.w = tmpvar_33.w;
  rgbm_31.xyz = ((tmpvar_33.xyz * tmpvar_33.w) * 6.0);
  tmpvar_3 = col_11.xyz;
  tmpvar_4 = (mg_10.x * _Metallic);
  tmpvar_5 = (mg_10.y * _Smoothness);
  tmpvar_6 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_9));
  highp vec4 shadowCoord_34;
  shadowCoord_34 = xlv_TEXCOORD4;
  highp float tmpvar_35;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_35 = 1.0;
  } else {
    shadowCoord_34.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_36;
    highp vec2 fetchesOffsetsU_37;
    highp float shadow_38;
    highp vec2 tmpvar_39;
    tmpvar_39 = (shadowCoord_34.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_40;
    tmpvar_40 = floor((tmpvar_39 + 0.5));
    highp vec2 tmpvar_41;
    tmpvar_41 = (tmpvar_39 - tmpvar_40);
    highp vec4 computedWeight_42;
    highp vec4 computedArea_43;
    highp vec4 computedAreaUncut_44;
    highp float tmpvar_45;
    tmpvar_45 = (((tmpvar_41.x + 0.5) * (tmpvar_41.x + 0.5)) * 0.5);
    highp float tmpvar_46;
    tmpvar_46 = (tmpvar_45 - tmpvar_41.x);
    computedArea_43.x = tmpvar_46;
    computedAreaUncut_44.x = tmpvar_46;
    computedArea_43.w = tmpvar_45;
    computedAreaUncut_44.w = tmpvar_45;
    computedAreaUncut_44.y = ((1.5 - tmpvar_41.x) - 0.5);
    highp float tmpvar_47;
    tmpvar_47 = min (tmpvar_41.x, 0.0);
    computedArea_43.y = (computedAreaUncut_44.y - (tmpvar_47 * tmpvar_47));
    computedAreaUncut_44.z = ((1.5 + tmpvar_41.x) - 0.5);
    highp float tmpvar_48;
    tmpvar_48 = max (tmpvar_41.x, 0.0);
    computedArea_43.z = (computedAreaUncut_44.z - (tmpvar_48 * tmpvar_48));
    computedWeight_42 = (computedArea_43 * 0.44444);
    highp vec4 computedWeight_49;
    highp vec4 computedArea_50;
    highp vec4 computedAreaUncut_51;
    highp float tmpvar_52;
    tmpvar_52 = (((tmpvar_41.y + 0.5) * (tmpvar_41.y + 0.5)) * 0.5);
    highp float tmpvar_53;
    tmpvar_53 = (tmpvar_52 - tmpvar_41.y);
    computedArea_50.x = tmpvar_53;
    computedAreaUncut_51.x = tmpvar_53;
    computedArea_50.w = tmpvar_52;
    computedAreaUncut_51.w = tmpvar_52;
    computedAreaUncut_51.y = ((1.5 - tmpvar_41.y) - 0.5);
    highp float tmpvar_54;
    tmpvar_54 = min (tmpvar_41.y, 0.0);
    computedArea_50.y = (computedAreaUncut_51.y - (tmpvar_54 * tmpvar_54));
    computedAreaUncut_51.z = ((1.5 + tmpvar_41.y) - 0.5);
    highp float tmpvar_55;
    tmpvar_55 = max (tmpvar_41.y, 0.0);
    computedArea_50.z = (computedAreaUncut_51.z - (tmpvar_55 * tmpvar_55));
    computedWeight_49 = (computedArea_50 * 0.44444);
    highp vec2 tmpvar_56;
    tmpvar_56 = (computedWeight_42.xz + computedWeight_42.yw);
    highp vec2 tmpvar_57;
    tmpvar_57 = (computedWeight_49.xz + computedWeight_49.yw);
    fetchesOffsetsU_37 = (((computedWeight_42.yw / tmpvar_56) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_36 = (((computedWeight_49.yw / tmpvar_57) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_58;
    tmpvar_58 = (tmpvar_40 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_37.x;
    tmpvar_59.y = fetchesOffsetsV_36.x;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_58 + tmpvar_59);
    tmpvar_60.z = shadowCoord_34.z;
    lowp float tmpvar_61;
    tmpvar_61 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_38 = ((tmpvar_56.x * tmpvar_57.x) * tmpvar_61);
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_37.y;
    tmpvar_62.y = fetchesOffsetsV_36.x;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_58 + tmpvar_62);
    tmpvar_63.z = shadowCoord_34.z;
    lowp float tmpvar_64;
    tmpvar_64 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_38 = (shadow_38 + ((tmpvar_56.y * tmpvar_57.x) * tmpvar_64));
    highp vec2 tmpvar_65;
    tmpvar_65.x = fetchesOffsetsU_37.x;
    tmpvar_65.y = fetchesOffsetsV_36.y;
    highp vec3 tmpvar_66;
    tmpvar_66.xy = (tmpvar_58 + tmpvar_65);
    tmpvar_66.z = shadowCoord_34.z;
    lowp float tmpvar_67;
    tmpvar_67 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_66);
    shadow_38 = (shadow_38 + ((tmpvar_56.x * tmpvar_57.y) * tmpvar_67));
    highp vec2 tmpvar_68;
    tmpvar_68.x = fetchesOffsetsU_37.y;
    tmpvar_68.y = fetchesOffsetsV_36.y;
    highp vec3 tmpvar_69;
    tmpvar_69.xy = (tmpvar_58 + tmpvar_68);
    tmpvar_69.z = shadowCoord_34.z;
    lowp float tmpvar_70;
    tmpvar_70 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_69);
    shadow_38 = (shadow_38 + ((tmpvar_56.y * tmpvar_57.y) * tmpvar_70));
    tmpvar_35 = mix (1.0, shadow_38, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_71;
  highp vec3 tmpvar_72;
  tmpvar_71 = normalize((CAMERA_WORLDPOSITION - tmpvar_16));
  tmpvar_72 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_73;
  highp vec3 specularEnv_74;
  highp vec3 color_75;
  mediump float surfaceReduction_76;
  mediump float diffuseTerm_77;
  highp float perceptualRoughness_78;
  mediump vec3 tmpvar_79;
  mediump vec3 albedo_80;
  albedo_80 = tmpvar_3;
  mediump vec3 specColor_81;
  specColor_81 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_80 * tmpvar_4));
  mediump float tmpvar_82;
  tmpvar_82 = (0.7790837 - (tmpvar_4 * 0.7790837));
  tmpvar_79 = (albedo_80 * tmpvar_82);
  tmpvar_73 = 0.0;
  mediump float alpha_83;
  alpha_83 = tmpvar_73;
  tmpvar_73 = alpha_83;
  mediump float tmpvar_84;
  tmpvar_84 = (1.0 - tmpvar_5);
  perceptualRoughness_78 = tmpvar_84;
  highp vec3 tmpvar_85;
  highp vec3 inVec_86;
  inVec_86 = (tmpvar_72 + tmpvar_71);
  tmpvar_85 = (inVec_86 * inversesqrt(max (0.001, 
    dot (inVec_86, inVec_86)
  )));
  highp float tmpvar_87;
  tmpvar_87 = abs(dot (tmpvar_71, normalWorld_7));
  highp float tmpvar_88;
  tmpvar_88 = clamp (dot (normalWorld_7, tmpvar_72), 0.0, 1.0);
  highp float tmpvar_89;
  tmpvar_89 = clamp (dot (normalWorld_7, tmpvar_85), 0.0, 1.0);
  mediump float tmpvar_90;
  highp float tmpvar_91;
  tmpvar_91 = clamp (dot (tmpvar_72, tmpvar_85), 0.0, 1.0);
  tmpvar_90 = tmpvar_91;
  mediump float tmpvar_92;
  mediump float NdotV_93;
  NdotV_93 = tmpvar_87;
  mediump float NdotL_94;
  NdotL_94 = tmpvar_88;
  mediump float perceptualRoughness_95;
  perceptualRoughness_95 = perceptualRoughness_78;
  mediump float tmpvar_96;
  tmpvar_96 = (0.5 + ((2.0 * tmpvar_90) * (tmpvar_90 * perceptualRoughness_95)));
  mediump float x_97;
  x_97 = (1.0 - NdotL_94);
  mediump float x_98;
  x_98 = (1.0 - NdotV_93);
  tmpvar_92 = ((1.0 + (
    (tmpvar_96 - 1.0)
   * 
    ((x_97 * x_97) * ((x_97 * x_97) * x_97))
  )) * (1.0 + (
    (tmpvar_96 - 1.0)
   * 
    ((x_98 * x_98) * ((x_98 * x_98) * x_98))
  )));
  highp float tmpvar_99;
  tmpvar_99 = (tmpvar_92 * tmpvar_88);
  diffuseTerm_77 = tmpvar_99;
  highp float tmpvar_100;
  tmpvar_100 = max ((perceptualRoughness_78 * perceptualRoughness_78), 0.002);
  highp float tmpvar_101;
  tmpvar_101 = (tmpvar_100 * tmpvar_100);
  highp float tmpvar_102;
  tmpvar_102 = (((
    (tmpvar_89 * tmpvar_101)
   - tmpvar_89) * tmpvar_89) + 1.0);
  surfaceReduction_76 = (1.0 - ((0.28 * tmpvar_100) * perceptualRoughness_78));
  mediump vec3 tmpvar_103;
  mediump float x_104;
  x_104 = (1.0 - tmpvar_90);
  tmpvar_103 = (specColor_81 + ((1.0 - specColor_81) * (
    (x_104 * x_104)
   * 
    ((x_104 * x_104) * x_104)
  )));
  color_75 = (((
    (tmpvar_79 * LIGHT_COLOR)
   * diffuseTerm_77) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_101)
       / 
        ((tmpvar_102 * tmpvar_102) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_88 * (
          (tmpvar_87 * (1.0 - tmpvar_100))
         + tmpvar_100)) + (tmpvar_87 * (
          (tmpvar_88 * (1.0 - tmpvar_100))
         + tmpvar_100))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_88)) * LIGHT_COLOR)
   * tmpvar_103)) * tmpvar_35);
  color_75 = (color_75 + tmpvar_6);
  color_75 = (color_75 + (tmpvar_79 * rgbm_31.xyz));
  mediump float cosA_105;
  cosA_105 = tmpvar_87;
  mediump float tmpvar_106;
  mediump float x_107;
  x_107 = (1.0 - cosA_105);
  tmpvar_106 = ((x_107 * x_107) * ((x_107 * x_107) * x_107));
  mediump vec3 tmpvar_108;
  tmpvar_108 = (surfaceReduction_76 * ((specColor_81 * 
    (1.0 - tmpvar_106)
  ) + (vec3(
    clamp ((tmpvar_5 + (1.0 - tmpvar_82)), 0.0, 1.0)
  ) * tmpvar_106)));
  specularEnv_74 = tmpvar_108;
  color_75 = (color_75 + (specularEnv_74 * rgbm_24.xyz));
  outColor_2.xyz = color_75;
  lowp vec4 tmpvar_109;
  tmpvar_109 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_109;
  outColor_2.w = ((col_11.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IBLRotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_texture_lod : enable
#extension GL_EXT_shadow_samplers : enable
lowp vec4 impl_low_textureCubeLodEXT(lowp samplerCube sampler, highp vec3 coord, mediump float lod)
{
#if defined(GL_EXT_shader_texture_lod)
	return textureCubeLodEXT(sampler, coord, lod);
#else
	return textureCube(sampler, coord, lod);
#endif
}

uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _Opacity;
uniform highp vec3 _IBLRotation;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec3 normalWorld_7;
  highp vec3 normalTangent_8;
  highp vec3 emissionMapColor_9;
  highp vec2 mg_10;
  highp vec4 col_11;
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_11 = tmpvar_12;
  lowp vec2 tmpvar_13;
  tmpvar_13 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_10 = tmpvar_13;
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture2D (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_9 = tmpvar_14;
  lowp vec3 tmpvar_15;
  tmpvar_15 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_8 = tmpvar_15;
  normalTangent_8 = ((normalTangent_8 * 2.0) - 1.0);
  normalWorld_7 = normalize(((
    (normalTangent_8.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_8.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_8.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_16;
  tmpvar_16.x = xlv_TEXCOORD1.w;
  tmpvar_16.y = xlv_TEXCOORD2.w;
  tmpvar_16.z = xlv_TEXCOORD3.w;
  highp float tmpvar_17;
  tmpvar_17 = cos(_IBLRotation.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_IBLRotation.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_IBLRotation.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_IBLRotation.z);
  highp float tmpvar_21;
  tmpvar_21 = cos(_IBLRotation.x);
  highp float tmpvar_22;
  tmpvar_22 = sin(_IBLRotation.x);
  highp mat4 tmpvar_23;
  tmpvar_23[0].x = (tmpvar_17 * tmpvar_19);
  tmpvar_23[0].y = ((tmpvar_18 * tmpvar_22) - ((tmpvar_17 * tmpvar_20) * tmpvar_21));
  tmpvar_23[0].z = (((tmpvar_17 * tmpvar_20) * tmpvar_22) + (tmpvar_18 * tmpvar_21));
  tmpvar_23[0].w = 0.0;
  tmpvar_23[1].x = tmpvar_20;
  tmpvar_23[1].y = (tmpvar_19 * tmpvar_21);
  tmpvar_23[1].z = (-(tmpvar_19) * tmpvar_22);
  tmpvar_23[1].w = 0.0;
  tmpvar_23[2].x = (-(tmpvar_18) * tmpvar_19);
  tmpvar_23[2].y = (((tmpvar_18 * tmpvar_20) * tmpvar_21) + (tmpvar_17 * tmpvar_22));
  tmpvar_23[2].z = (((
    -(tmpvar_18)
   * tmpvar_20) * tmpvar_22) + (tmpvar_17 * tmpvar_21));
  tmpvar_23[2].w = 0.0;
  tmpvar_23[3].x = 0.0;
  tmpvar_23[3].y = 0.0;
  tmpvar_23[3].z = 0.0;
  tmpvar_23[3].w = 1.0;
  highp vec4 rgbm_24;
  highp vec3 I_25;
  I_25 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_16)));
  highp vec4 tmpvar_26;
  tmpvar_26.w = 0.0;
  tmpvar_26.xyz = (I_25 - (2.0 * (
    dot (normalWorld_7, I_25)
   * normalWorld_7)));
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize((tmpvar_23 * tmpvar_26).xyz);
  highp vec4 tmpvar_28;
  tmpvar_28.xyz = tmpvar_27;
  tmpvar_28.w = ((1.0 - (mg_10.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_29;
  tmpvar_29 = impl_low_textureCubeLodEXT (_GlossEnvMap, tmpvar_27, tmpvar_28.w);
  highp vec4 tmpvar_30;
  tmpvar_30 = tmpvar_29;
  rgbm_24.w = tmpvar_30.w;
  rgbm_24.xyz = ((tmpvar_30.xyz * tmpvar_30.w) * 6.0);
  highp vec4 rgbm_31;
  lowp vec4 tmpvar_32;
  tmpvar_32 = textureCube (_IrradianceMap, normalWorld_7);
  highp vec4 tmpvar_33;
  tmpvar_33 = tmpvar_32;
  rgbm_31.w = tmpvar_33.w;
  rgbm_31.xyz = ((tmpvar_33.xyz * tmpvar_33.w) * 6.0);
  tmpvar_3 = col_11.xyz;
  tmpvar_4 = (mg_10.x * _Metallic);
  tmpvar_5 = (mg_10.y * _Smoothness);
  tmpvar_6 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_9));
  highp vec4 shadowCoord_34;
  shadowCoord_34 = xlv_TEXCOORD4;
  highp float tmpvar_35;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_35 = 1.0;
  } else {
    shadowCoord_34.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_36;
    highp vec3 fetchesOffsetsU_37;
    highp float shadow_38;
    highp vec2 tmpvar_39;
    tmpvar_39 = (shadowCoord_34.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_40;
    tmpvar_40 = floor((tmpvar_39 + 0.5));
    highp vec2 tmpvar_41;
    tmpvar_41 = (tmpvar_39 - tmpvar_40);
    highp vec3 texelsWeightsA_42;
    highp vec3 texelsWeightsB_43;
    highp vec4 computedArea_44;
    highp vec4 computedAreaUncut_45;
    highp float tmpvar_46;
    tmpvar_46 = (((tmpvar_41.x + 0.5) * (tmpvar_41.x + 0.5)) * 0.5);
    highp float tmpvar_47;
    tmpvar_47 = (tmpvar_46 - tmpvar_41.x);
    computedArea_44.x = tmpvar_47;
    computedAreaUncut_45.x = tmpvar_47;
    computedArea_44.w = tmpvar_46;
    computedAreaUncut_45.w = tmpvar_46;
    computedAreaUncut_45.y = ((1.5 - tmpvar_41.x) - 0.5);
    highp float tmpvar_48;
    tmpvar_48 = min (tmpvar_41.x, 0.0);
    computedArea_44.y = (computedAreaUncut_45.y - (tmpvar_48 * tmpvar_48));
    computedAreaUncut_45.z = ((1.5 + tmpvar_41.x) - 0.5);
    highp float tmpvar_49;
    tmpvar_49 = max (tmpvar_41.x, 0.0);
    computedArea_44.z = (computedAreaUncut_45.z - (tmpvar_49 * tmpvar_49));
    texelsWeightsA_42.x = (0.16 * tmpvar_47);
    texelsWeightsA_42.y = (0.16 * computedAreaUncut_45.y);
    texelsWeightsA_42.z = (0.16 * (computedArea_44.y + 1.0));
    texelsWeightsB_43.x = (0.16 * (computedArea_44.z + 1.0));
    texelsWeightsB_43.y = (0.16 * computedAreaUncut_45.z);
    texelsWeightsB_43.z = (0.16 * tmpvar_46);
    highp vec3 texelsWeightsA_50;
    highp vec3 texelsWeightsB_51;
    highp vec4 computedArea_52;
    highp vec4 computedAreaUncut_53;
    highp float tmpvar_54;
    tmpvar_54 = (((tmpvar_41.y + 0.5) * (tmpvar_41.y + 0.5)) * 0.5);
    highp float tmpvar_55;
    tmpvar_55 = (tmpvar_54 - tmpvar_41.y);
    computedArea_52.x = tmpvar_55;
    computedAreaUncut_53.x = tmpvar_55;
    computedArea_52.w = tmpvar_54;
    computedAreaUncut_53.w = tmpvar_54;
    computedAreaUncut_53.y = ((1.5 - tmpvar_41.y) - 0.5);
    highp float tmpvar_56;
    tmpvar_56 = min (tmpvar_41.y, 0.0);
    computedArea_52.y = (computedAreaUncut_53.y - (tmpvar_56 * tmpvar_56));
    computedAreaUncut_53.z = ((1.5 + tmpvar_41.y) - 0.5);
    highp float tmpvar_57;
    tmpvar_57 = max (tmpvar_41.y, 0.0);
    computedArea_52.z = (computedAreaUncut_53.z - (tmpvar_57 * tmpvar_57));
    texelsWeightsA_50.x = (0.16 * tmpvar_55);
    texelsWeightsA_50.y = (0.16 * computedAreaUncut_53.y);
    texelsWeightsA_50.z = (0.16 * (computedArea_52.y + 1.0));
    texelsWeightsB_51.x = (0.16 * (computedArea_52.z + 1.0));
    texelsWeightsB_51.y = (0.16 * computedAreaUncut_53.z);
    texelsWeightsB_51.z = (0.16 * tmpvar_54);
    highp vec3 tmpvar_58;
    tmpvar_58.xy = texelsWeightsA_42.xz;
    tmpvar_58.z = texelsWeightsB_43.y;
    highp vec3 tmpvar_59;
    tmpvar_59.x = texelsWeightsA_42.y;
    tmpvar_59.yz = texelsWeightsB_43.xz;
    highp vec3 tmpvar_60;
    tmpvar_60 = (tmpvar_58 + tmpvar_59);
    highp vec3 tmpvar_61;
    tmpvar_61.xy = texelsWeightsA_50.xz;
    tmpvar_61.z = texelsWeightsB_51.y;
    highp vec3 tmpvar_62;
    tmpvar_62.x = texelsWeightsA_50.y;
    tmpvar_62.yz = texelsWeightsB_51.xz;
    highp vec3 tmpvar_63;
    tmpvar_63 = (tmpvar_61 + tmpvar_62);
    highp vec3 tmpvar_64;
    tmpvar_64.x = texelsWeightsA_42.y;
    tmpvar_64.yz = texelsWeightsB_43.xz;
    highp vec3 tmpvar_65;
    tmpvar_65.x = texelsWeightsA_50.y;
    tmpvar_65.yz = texelsWeightsB_51.xz;
    fetchesOffsetsU_37 = (((tmpvar_64 / tmpvar_60) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_36 = (((tmpvar_65 / tmpvar_63) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_66;
    tmpvar_66 = (tmpvar_40 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_37.x;
    tmpvar_67.y = fetchesOffsetsV_36.x;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_66 + tmpvar_67);
    tmpvar_68.z = shadowCoord_34.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_38 = ((tmpvar_60.x * tmpvar_63.x) * tmpvar_69);
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_37.y;
    tmpvar_70.y = fetchesOffsetsV_36.x;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_66 + tmpvar_70);
    tmpvar_71.z = shadowCoord_34.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_38 = (shadow_38 + ((tmpvar_60.y * tmpvar_63.x) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_37.z;
    tmpvar_73.y = fetchesOffsetsV_36.x;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_66 + tmpvar_73);
    tmpvar_74.z = shadowCoord_34.z;
    lowp float tmpvar_75;
    tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_38 = (shadow_38 + ((tmpvar_60.z * tmpvar_63.x) * tmpvar_75));
    highp vec2 tmpvar_76;
    tmpvar_76.x = fetchesOffsetsU_37.x;
    tmpvar_76.y = fetchesOffsetsV_36.y;
    highp vec3 tmpvar_77;
    tmpvar_77.xy = (tmpvar_66 + tmpvar_76);
    tmpvar_77.z = shadowCoord_34.z;
    lowp float tmpvar_78;
    tmpvar_78 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_77);
    shadow_38 = (shadow_38 + ((tmpvar_60.x * tmpvar_63.y) * tmpvar_78));
    highp vec2 tmpvar_79;
    tmpvar_79.x = fetchesOffsetsU_37.y;
    tmpvar_79.y = fetchesOffsetsV_36.y;
    highp vec3 tmpvar_80;
    tmpvar_80.xy = (tmpvar_66 + tmpvar_79);
    tmpvar_80.z = shadowCoord_34.z;
    lowp float tmpvar_81;
    tmpvar_81 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_80);
    shadow_38 = (shadow_38 + ((tmpvar_60.y * tmpvar_63.y) * tmpvar_81));
    highp vec2 tmpvar_82;
    tmpvar_82.x = fetchesOffsetsU_37.z;
    tmpvar_82.y = fetchesOffsetsV_36.y;
    highp vec3 tmpvar_83;
    tmpvar_83.xy = (tmpvar_66 + tmpvar_82);
    tmpvar_83.z = shadowCoord_34.z;
    lowp float tmpvar_84;
    tmpvar_84 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_83);
    shadow_38 = (shadow_38 + ((tmpvar_60.z * tmpvar_63.y) * tmpvar_84));
    highp vec2 tmpvar_85;
    tmpvar_85.x = fetchesOffsetsU_37.x;
    tmpvar_85.y = fetchesOffsetsV_36.z;
    highp vec3 tmpvar_86;
    tmpvar_86.xy = (tmpvar_66 + tmpvar_85);
    tmpvar_86.z = shadowCoord_34.z;
    lowp float tmpvar_87;
    tmpvar_87 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_86);
    shadow_38 = (shadow_38 + ((tmpvar_60.x * tmpvar_63.z) * tmpvar_87));
    highp vec2 tmpvar_88;
    tmpvar_88.x = fetchesOffsetsU_37.y;
    tmpvar_88.y = fetchesOffsetsV_36.z;
    highp vec3 tmpvar_89;
    tmpvar_89.xy = (tmpvar_66 + tmpvar_88);
    tmpvar_89.z = shadowCoord_34.z;
    lowp float tmpvar_90;
    tmpvar_90 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_89);
    shadow_38 = (shadow_38 + ((tmpvar_60.y * tmpvar_63.z) * tmpvar_90));
    highp vec2 tmpvar_91;
    tmpvar_91.x = fetchesOffsetsU_37.z;
    tmpvar_91.y = fetchesOffsetsV_36.z;
    highp vec3 tmpvar_92;
    tmpvar_92.xy = (tmpvar_66 + tmpvar_91);
    tmpvar_92.z = shadowCoord_34.z;
    lowp float tmpvar_93;
    tmpvar_93 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_92);
    shadow_38 = (shadow_38 + ((tmpvar_60.z * tmpvar_63.z) * tmpvar_93));
    tmpvar_35 = mix (1.0, shadow_38, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_94;
  highp vec3 tmpvar_95;
  tmpvar_94 = normalize((CAMERA_WORLDPOSITION - tmpvar_16));
  tmpvar_95 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_96;
  highp vec3 specularEnv_97;
  highp vec3 color_98;
  mediump float surfaceReduction_99;
  mediump float diffuseTerm_100;
  highp float perceptualRoughness_101;
  mediump vec3 tmpvar_102;
  mediump vec3 albedo_103;
  albedo_103 = tmpvar_3;
  mediump vec3 specColor_104;
  specColor_104 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_103 * tmpvar_4));
  mediump float tmpvar_105;
  tmpvar_105 = (0.7790837 - (tmpvar_4 * 0.7790837));
  tmpvar_102 = (albedo_103 * tmpvar_105);
  tmpvar_96 = 0.0;
  mediump float alpha_106;
  alpha_106 = tmpvar_96;
  tmpvar_96 = alpha_106;
  mediump float tmpvar_107;
  tmpvar_107 = (1.0 - tmpvar_5);
  perceptualRoughness_101 = tmpvar_107;
  highp vec3 tmpvar_108;
  highp vec3 inVec_109;
  inVec_109 = (tmpvar_95 + tmpvar_94);
  tmpvar_108 = (inVec_109 * inversesqrt(max (0.001, 
    dot (inVec_109, inVec_109)
  )));
  highp float tmpvar_110;
  tmpvar_110 = abs(dot (tmpvar_94, normalWorld_7));
  highp float tmpvar_111;
  tmpvar_111 = clamp (dot (normalWorld_7, tmpvar_95), 0.0, 1.0);
  highp float tmpvar_112;
  tmpvar_112 = clamp (dot (normalWorld_7, tmpvar_108), 0.0, 1.0);
  mediump float tmpvar_113;
  highp float tmpvar_114;
  tmpvar_114 = clamp (dot (tmpvar_95, tmpvar_108), 0.0, 1.0);
  tmpvar_113 = tmpvar_114;
  mediump float tmpvar_115;
  mediump float NdotV_116;
  NdotV_116 = tmpvar_110;
  mediump float NdotL_117;
  NdotL_117 = tmpvar_111;
  mediump float perceptualRoughness_118;
  perceptualRoughness_118 = perceptualRoughness_101;
  mediump float tmpvar_119;
  tmpvar_119 = (0.5 + ((2.0 * tmpvar_113) * (tmpvar_113 * perceptualRoughness_118)));
  mediump float x_120;
  x_120 = (1.0 - NdotL_117);
  mediump float x_121;
  x_121 = (1.0 - NdotV_116);
  tmpvar_115 = ((1.0 + (
    (tmpvar_119 - 1.0)
   * 
    ((x_120 * x_120) * ((x_120 * x_120) * x_120))
  )) * (1.0 + (
    (tmpvar_119 - 1.0)
   * 
    ((x_121 * x_121) * ((x_121 * x_121) * x_121))
  )));
  highp float tmpvar_122;
  tmpvar_122 = (tmpvar_115 * tmpvar_111);
  diffuseTerm_100 = tmpvar_122;
  highp float tmpvar_123;
  tmpvar_123 = max ((perceptualRoughness_101 * perceptualRoughness_101), 0.002);
  highp float tmpvar_124;
  tmpvar_124 = (tmpvar_123 * tmpvar_123);
  highp float tmpvar_125;
  tmpvar_125 = (((
    (tmpvar_112 * tmpvar_124)
   - tmpvar_112) * tmpvar_112) + 1.0);
  surfaceReduction_99 = (1.0 - ((0.28 * tmpvar_123) * perceptualRoughness_101));
  mediump vec3 tmpvar_126;
  mediump float x_127;
  x_127 = (1.0 - tmpvar_113);
  tmpvar_126 = (specColor_104 + ((1.0 - specColor_104) * (
    (x_127 * x_127)
   * 
    ((x_127 * x_127) * x_127)
  )));
  color_98 = (((
    (tmpvar_102 * LIGHT_COLOR)
   * diffuseTerm_100) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_124)
       / 
        ((tmpvar_125 * tmpvar_125) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_111 * (
          (tmpvar_110 * (1.0 - tmpvar_123))
         + tmpvar_123)) + (tmpvar_110 * (
          (tmpvar_111 * (1.0 - tmpvar_123))
         + tmpvar_123))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_111)) * LIGHT_COLOR)
   * tmpvar_126)) * tmpvar_35);
  color_98 = (color_98 + tmpvar_6);
  color_98 = (color_98 + (tmpvar_102 * rgbm_31.xyz));
  mediump float cosA_128;
  cosA_128 = tmpvar_110;
  mediump float tmpvar_129;
  mediump float x_130;
  x_130 = (1.0 - cosA_128);
  tmpvar_129 = ((x_130 * x_130) * ((x_130 * x_130) * x_130));
  mediump vec3 tmpvar_131;
  tmpvar_131 = (surfaceReduction_99 * ((specColor_104 * 
    (1.0 - tmpvar_129)
  ) + (vec3(
    clamp ((tmpvar_5 + (1.0 - tmpvar_105)), 0.0, 1.0)
  ) * tmpvar_129)));
  specularEnv_97 = tmpvar_131;
  color_98 = (color_98 + (specularEnv_97 * rgbm_24.xyz));
  outColor_2.xyz = color_98;
  lowp vec4 tmpvar_132;
  tmpvar_132 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_132;
  outColor_2.w = ((col_11.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IBLRotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_texture_lod : enable
#extension GL_EXT_shadow_samplers : enable
lowp vec4 impl_low_textureCubeLodEXT(lowp samplerCube sampler, highp vec3 coord, mediump float lod)
{
#if defined(GL_EXT_shader_texture_lod)
	return textureCubeLodEXT(sampler, coord, lod);
#else
	return textureCube(sampler, coord, lod);
#endif
}

uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _Opacity;
uniform highp vec3 _IBLRotation;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec3 normalWorld_7;
  highp vec3 normalTangent_8;
  highp vec3 emissionMapColor_9;
  highp vec2 mg_10;
  highp vec4 col_11;
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_11 = tmpvar_12;
  lowp vec2 tmpvar_13;
  tmpvar_13 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_10 = tmpvar_13;
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture2D (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_9 = tmpvar_14;
  lowp vec3 tmpvar_15;
  tmpvar_15 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_8 = tmpvar_15;
  normalTangent_8 = ((normalTangent_8 * 2.0) - 1.0);
  normalWorld_7 = normalize(((
    (normalTangent_8.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_8.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_8.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_16;
  tmpvar_16.x = xlv_TEXCOORD1.w;
  tmpvar_16.y = xlv_TEXCOORD2.w;
  tmpvar_16.z = xlv_TEXCOORD3.w;
  highp float tmpvar_17;
  tmpvar_17 = cos(_IBLRotation.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_IBLRotation.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_IBLRotation.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_IBLRotation.z);
  highp float tmpvar_21;
  tmpvar_21 = cos(_IBLRotation.x);
  highp float tmpvar_22;
  tmpvar_22 = sin(_IBLRotation.x);
  highp mat4 tmpvar_23;
  tmpvar_23[0].x = (tmpvar_17 * tmpvar_19);
  tmpvar_23[0].y = ((tmpvar_18 * tmpvar_22) - ((tmpvar_17 * tmpvar_20) * tmpvar_21));
  tmpvar_23[0].z = (((tmpvar_17 * tmpvar_20) * tmpvar_22) + (tmpvar_18 * tmpvar_21));
  tmpvar_23[0].w = 0.0;
  tmpvar_23[1].x = tmpvar_20;
  tmpvar_23[1].y = (tmpvar_19 * tmpvar_21);
  tmpvar_23[1].z = (-(tmpvar_19) * tmpvar_22);
  tmpvar_23[1].w = 0.0;
  tmpvar_23[2].x = (-(tmpvar_18) * tmpvar_19);
  tmpvar_23[2].y = (((tmpvar_18 * tmpvar_20) * tmpvar_21) + (tmpvar_17 * tmpvar_22));
  tmpvar_23[2].z = (((
    -(tmpvar_18)
   * tmpvar_20) * tmpvar_22) + (tmpvar_17 * tmpvar_21));
  tmpvar_23[2].w = 0.0;
  tmpvar_23[3].x = 0.0;
  tmpvar_23[3].y = 0.0;
  tmpvar_23[3].z = 0.0;
  tmpvar_23[3].w = 1.0;
  highp vec4 rgbm_24;
  highp vec3 I_25;
  I_25 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_16)));
  highp vec4 tmpvar_26;
  tmpvar_26.w = 0.0;
  tmpvar_26.xyz = (I_25 - (2.0 * (
    dot (normalWorld_7, I_25)
   * normalWorld_7)));
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize((tmpvar_23 * tmpvar_26).xyz);
  highp vec4 tmpvar_28;
  tmpvar_28.xyz = tmpvar_27;
  tmpvar_28.w = ((1.0 - (mg_10.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_29;
  tmpvar_29 = impl_low_textureCubeLodEXT (_GlossEnvMap, tmpvar_27, tmpvar_28.w);
  highp vec4 tmpvar_30;
  tmpvar_30 = tmpvar_29;
  rgbm_24.w = tmpvar_30.w;
  rgbm_24.xyz = ((tmpvar_30.xyz * tmpvar_30.w) * 6.0);
  highp vec4 rgbm_31;
  lowp vec4 tmpvar_32;
  tmpvar_32 = textureCube (_IrradianceMap, normalWorld_7);
  highp vec4 tmpvar_33;
  tmpvar_33 = tmpvar_32;
  rgbm_31.w = tmpvar_33.w;
  rgbm_31.xyz = ((tmpvar_33.xyz * tmpvar_33.w) * 6.0);
  tmpvar_3 = col_11.xyz;
  tmpvar_4 = (mg_10.x * _Metallic);
  tmpvar_5 = (mg_10.y * _Smoothness);
  tmpvar_6 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_9));
  highp vec4 shadowCoord_34;
  shadowCoord_34 = xlv_TEXCOORD4;
  highp float tmpvar_35;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_35 = 1.0;
  } else {
    shadowCoord_34.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_36;
    highp vec4 fetchesOffsetsU_37;
    highp float shadow_38;
    highp vec2 tmpvar_39;
    tmpvar_39 = (shadowCoord_34.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_40;
    tmpvar_40 = floor((tmpvar_39 + 0.5));
    highp vec2 tmpvar_41;
    tmpvar_41 = (tmpvar_39 - tmpvar_40);
    highp vec4 texelsWeightsA_42;
    highp vec4 texelsWeightsB_43;
    highp vec4 computedArea_44;
    highp vec4 computedAreaUncut_45;
    highp float tmpvar_46;
    tmpvar_46 = (((tmpvar_41.x + 0.5) * (tmpvar_41.x + 0.5)) * 0.5);
    highp float tmpvar_47;
    tmpvar_47 = (tmpvar_46 - tmpvar_41.x);
    computedArea_44.x = tmpvar_47;
    computedAreaUncut_45.x = tmpvar_47;
    computedArea_44.w = tmpvar_46;
    computedAreaUncut_45.w = tmpvar_46;
    computedAreaUncut_45.y = ((1.5 - tmpvar_41.x) - 0.5);
    highp float tmpvar_48;
    tmpvar_48 = min (tmpvar_41.x, 0.0);
    computedArea_44.y = (computedAreaUncut_45.y - (tmpvar_48 * tmpvar_48));
    computedAreaUncut_45.z = ((1.5 + tmpvar_41.x) - 0.5);
    highp float tmpvar_49;
    tmpvar_49 = max (tmpvar_41.x, 0.0);
    computedArea_44.z = (computedAreaUncut_45.z - (tmpvar_49 * tmpvar_49));
    texelsWeightsA_42.x = (0.081632 * tmpvar_47);
    texelsWeightsA_42.y = (0.081632 * computedAreaUncut_45.y);
    texelsWeightsA_42.z = (0.081632 * (computedAreaUncut_45.y + 1.0));
    texelsWeightsA_42.w = (0.081632 * (computedArea_44.y + 2.0));
    texelsWeightsB_43.x = (0.081632 * (computedArea_44.z + 2.0));
    texelsWeightsB_43.y = (0.081632 * (computedAreaUncut_45.z + 1.0));
    texelsWeightsB_43.z = (0.081632 * computedAreaUncut_45.z);
    texelsWeightsB_43.w = (0.081632 * tmpvar_46);
    highp vec4 texelsWeightsA_50;
    highp vec4 texelsWeightsB_51;
    highp vec4 computedArea_52;
    highp vec4 computedAreaUncut_53;
    highp float tmpvar_54;
    tmpvar_54 = (((tmpvar_41.y + 0.5) * (tmpvar_41.y + 0.5)) * 0.5);
    highp float tmpvar_55;
    tmpvar_55 = (tmpvar_54 - tmpvar_41.y);
    computedArea_52.x = tmpvar_55;
    computedAreaUncut_53.x = tmpvar_55;
    computedArea_52.w = tmpvar_54;
    computedAreaUncut_53.w = tmpvar_54;
    computedAreaUncut_53.y = ((1.5 - tmpvar_41.y) - 0.5);
    highp float tmpvar_56;
    tmpvar_56 = min (tmpvar_41.y, 0.0);
    computedArea_52.y = (computedAreaUncut_53.y - (tmpvar_56 * tmpvar_56));
    computedAreaUncut_53.z = ((1.5 + tmpvar_41.y) - 0.5);
    highp float tmpvar_57;
    tmpvar_57 = max (tmpvar_41.y, 0.0);
    computedArea_52.z = (computedAreaUncut_53.z - (tmpvar_57 * tmpvar_57));
    texelsWeightsA_50.x = (0.081632 * tmpvar_55);
    texelsWeightsA_50.y = (0.081632 * computedAreaUncut_53.y);
    texelsWeightsA_50.z = (0.081632 * (computedAreaUncut_53.y + 1.0));
    texelsWeightsA_50.w = (0.081632 * (computedArea_52.y + 2.0));
    texelsWeightsB_51.x = (0.081632 * (computedArea_52.z + 2.0));
    texelsWeightsB_51.y = (0.081632 * (computedAreaUncut_53.z + 1.0));
    texelsWeightsB_51.z = (0.081632 * computedAreaUncut_53.z);
    texelsWeightsB_51.w = (0.081632 * tmpvar_54);
    highp vec4 tmpvar_58;
    tmpvar_58.xy = texelsWeightsA_42.xz;
    tmpvar_58.zw = texelsWeightsB_43.xz;
    highp vec4 tmpvar_59;
    tmpvar_59.xy = texelsWeightsA_42.yw;
    tmpvar_59.zw = texelsWeightsB_43.yw;
    highp vec4 tmpvar_60;
    tmpvar_60 = (tmpvar_58 + tmpvar_59);
    highp vec4 tmpvar_61;
    tmpvar_61.xy = texelsWeightsA_50.xz;
    tmpvar_61.zw = texelsWeightsB_51.xz;
    highp vec4 tmpvar_62;
    tmpvar_62.xy = texelsWeightsA_50.yw;
    tmpvar_62.zw = texelsWeightsB_51.yw;
    highp vec4 tmpvar_63;
    tmpvar_63 = (tmpvar_61 + tmpvar_62);
    highp vec4 tmpvar_64;
    tmpvar_64.xy = texelsWeightsA_42.yw;
    tmpvar_64.zw = texelsWeightsB_43.yw;
    highp vec4 tmpvar_65;
    tmpvar_65.xy = texelsWeightsA_50.yw;
    tmpvar_65.zw = texelsWeightsB_51.yw;
    fetchesOffsetsU_37 = (((tmpvar_64 / tmpvar_60) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_36 = (((tmpvar_65 / tmpvar_63) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_66;
    tmpvar_66 = (tmpvar_40 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_37.x;
    tmpvar_67.y = fetchesOffsetsV_36.x;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_66 + tmpvar_67);
    tmpvar_68.z = shadowCoord_34.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_38 = ((tmpvar_60.x * tmpvar_63.x) * tmpvar_69);
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_37.y;
    tmpvar_70.y = fetchesOffsetsV_36.x;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_66 + tmpvar_70);
    tmpvar_71.z = shadowCoord_34.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_38 = (shadow_38 + ((tmpvar_60.y * tmpvar_63.x) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_37.z;
    tmpvar_73.y = fetchesOffsetsV_36.x;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_66 + tmpvar_73);
    tmpvar_74.z = shadowCoord_34.z;
    lowp float tmpvar_75;
    tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_38 = (shadow_38 + ((tmpvar_60.z * tmpvar_63.x) * tmpvar_75));
    highp vec2 tmpvar_76;
    tmpvar_76.x = fetchesOffsetsU_37.w;
    tmpvar_76.y = fetchesOffsetsV_36.x;
    highp vec3 tmpvar_77;
    tmpvar_77.xy = (tmpvar_66 + tmpvar_76);
    tmpvar_77.z = shadowCoord_34.z;
    lowp float tmpvar_78;
    tmpvar_78 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_77);
    shadow_38 = (shadow_38 + ((tmpvar_60.w * tmpvar_63.x) * tmpvar_78));
    highp vec2 tmpvar_79;
    tmpvar_79.x = fetchesOffsetsU_37.x;
    tmpvar_79.y = fetchesOffsetsV_36.y;
    highp vec3 tmpvar_80;
    tmpvar_80.xy = (tmpvar_66 + tmpvar_79);
    tmpvar_80.z = shadowCoord_34.z;
    lowp float tmpvar_81;
    tmpvar_81 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_80);
    shadow_38 = (shadow_38 + ((tmpvar_60.x * tmpvar_63.y) * tmpvar_81));
    highp vec2 tmpvar_82;
    tmpvar_82.x = fetchesOffsetsU_37.y;
    tmpvar_82.y = fetchesOffsetsV_36.y;
    highp vec3 tmpvar_83;
    tmpvar_83.xy = (tmpvar_66 + tmpvar_82);
    tmpvar_83.z = shadowCoord_34.z;
    lowp float tmpvar_84;
    tmpvar_84 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_83);
    shadow_38 = (shadow_38 + ((tmpvar_60.y * tmpvar_63.y) * tmpvar_84));
    highp vec2 tmpvar_85;
    tmpvar_85.x = fetchesOffsetsU_37.z;
    tmpvar_85.y = fetchesOffsetsV_36.y;
    highp vec3 tmpvar_86;
    tmpvar_86.xy = (tmpvar_66 + tmpvar_85);
    tmpvar_86.z = shadowCoord_34.z;
    lowp float tmpvar_87;
    tmpvar_87 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_86);
    shadow_38 = (shadow_38 + ((tmpvar_60.z * tmpvar_63.y) * tmpvar_87));
    highp vec2 tmpvar_88;
    tmpvar_88.x = fetchesOffsetsU_37.w;
    tmpvar_88.y = fetchesOffsetsV_36.y;
    highp vec3 tmpvar_89;
    tmpvar_89.xy = (tmpvar_66 + tmpvar_88);
    tmpvar_89.z = shadowCoord_34.z;
    lowp float tmpvar_90;
    tmpvar_90 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_89);
    shadow_38 = (shadow_38 + ((tmpvar_60.w * tmpvar_63.y) * tmpvar_90));
    highp vec2 tmpvar_91;
    tmpvar_91.x = fetchesOffsetsU_37.x;
    tmpvar_91.y = fetchesOffsetsV_36.z;
    highp vec3 tmpvar_92;
    tmpvar_92.xy = (tmpvar_66 + tmpvar_91);
    tmpvar_92.z = shadowCoord_34.z;
    lowp float tmpvar_93;
    tmpvar_93 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_92);
    shadow_38 = (shadow_38 + ((tmpvar_60.x * tmpvar_63.z) * tmpvar_93));
    highp vec2 tmpvar_94;
    tmpvar_94.x = fetchesOffsetsU_37.y;
    tmpvar_94.y = fetchesOffsetsV_36.z;
    highp vec3 tmpvar_95;
    tmpvar_95.xy = (tmpvar_66 + tmpvar_94);
    tmpvar_95.z = shadowCoord_34.z;
    lowp float tmpvar_96;
    tmpvar_96 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_95);
    shadow_38 = (shadow_38 + ((tmpvar_60.y * tmpvar_63.z) * tmpvar_96));
    highp vec2 tmpvar_97;
    tmpvar_97.x = fetchesOffsetsU_37.z;
    tmpvar_97.y = fetchesOffsetsV_36.z;
    highp vec3 tmpvar_98;
    tmpvar_98.xy = (tmpvar_66 + tmpvar_97);
    tmpvar_98.z = shadowCoord_34.z;
    lowp float tmpvar_99;
    tmpvar_99 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_98);
    shadow_38 = (shadow_38 + ((tmpvar_60.z * tmpvar_63.z) * tmpvar_99));
    highp vec2 tmpvar_100;
    tmpvar_100.x = fetchesOffsetsU_37.w;
    tmpvar_100.y = fetchesOffsetsV_36.z;
    highp vec3 tmpvar_101;
    tmpvar_101.xy = (tmpvar_66 + tmpvar_100);
    tmpvar_101.z = shadowCoord_34.z;
    lowp float tmpvar_102;
    tmpvar_102 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_101);
    shadow_38 = (shadow_38 + ((tmpvar_60.w * tmpvar_63.z) * tmpvar_102));
    highp vec2 tmpvar_103;
    tmpvar_103.x = fetchesOffsetsU_37.x;
    tmpvar_103.y = fetchesOffsetsV_36.w;
    highp vec3 tmpvar_104;
    tmpvar_104.xy = (tmpvar_66 + tmpvar_103);
    tmpvar_104.z = shadowCoord_34.z;
    lowp float tmpvar_105;
    tmpvar_105 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_104);
    shadow_38 = (shadow_38 + ((tmpvar_60.x * tmpvar_63.w) * tmpvar_105));
    highp vec2 tmpvar_106;
    tmpvar_106.x = fetchesOffsetsU_37.y;
    tmpvar_106.y = fetchesOffsetsV_36.w;
    highp vec3 tmpvar_107;
    tmpvar_107.xy = (tmpvar_66 + tmpvar_106);
    tmpvar_107.z = shadowCoord_34.z;
    lowp float tmpvar_108;
    tmpvar_108 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_107);
    shadow_38 = (shadow_38 + ((tmpvar_60.y * tmpvar_63.w) * tmpvar_108));
    highp vec2 tmpvar_109;
    tmpvar_109.x = fetchesOffsetsU_37.z;
    tmpvar_109.y = fetchesOffsetsV_36.w;
    highp vec3 tmpvar_110;
    tmpvar_110.xy = (tmpvar_66 + tmpvar_109);
    tmpvar_110.z = shadowCoord_34.z;
    lowp float tmpvar_111;
    tmpvar_111 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_110);
    shadow_38 = (shadow_38 + ((tmpvar_60.z * tmpvar_63.w) * tmpvar_111));
    highp vec2 tmpvar_112;
    tmpvar_112.x = fetchesOffsetsU_37.w;
    tmpvar_112.y = fetchesOffsetsV_36.w;
    highp vec3 tmpvar_113;
    tmpvar_113.xy = (tmpvar_66 + tmpvar_112);
    tmpvar_113.z = shadowCoord_34.z;
    lowp float tmpvar_114;
    tmpvar_114 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_113);
    shadow_38 = (shadow_38 + ((tmpvar_60.w * tmpvar_63.w) * tmpvar_114));
    tmpvar_35 = mix (1.0, shadow_38, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_115;
  highp vec3 tmpvar_116;
  tmpvar_115 = normalize((CAMERA_WORLDPOSITION - tmpvar_16));
  tmpvar_116 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_117;
  highp vec3 specularEnv_118;
  highp vec3 color_119;
  mediump float surfaceReduction_120;
  mediump float diffuseTerm_121;
  highp float perceptualRoughness_122;
  mediump vec3 tmpvar_123;
  mediump vec3 albedo_124;
  albedo_124 = tmpvar_3;
  mediump vec3 specColor_125;
  specColor_125 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_124 * tmpvar_4));
  mediump float tmpvar_126;
  tmpvar_126 = (0.7790837 - (tmpvar_4 * 0.7790837));
  tmpvar_123 = (albedo_124 * tmpvar_126);
  tmpvar_117 = 0.0;
  mediump float alpha_127;
  alpha_127 = tmpvar_117;
  tmpvar_117 = alpha_127;
  mediump float tmpvar_128;
  tmpvar_128 = (1.0 - tmpvar_5);
  perceptualRoughness_122 = tmpvar_128;
  highp vec3 tmpvar_129;
  highp vec3 inVec_130;
  inVec_130 = (tmpvar_116 + tmpvar_115);
  tmpvar_129 = (inVec_130 * inversesqrt(max (0.001, 
    dot (inVec_130, inVec_130)
  )));
  highp float tmpvar_131;
  tmpvar_131 = abs(dot (tmpvar_115, normalWorld_7));
  highp float tmpvar_132;
  tmpvar_132 = clamp (dot (normalWorld_7, tmpvar_116), 0.0, 1.0);
  highp float tmpvar_133;
  tmpvar_133 = clamp (dot (normalWorld_7, tmpvar_129), 0.0, 1.0);
  mediump float tmpvar_134;
  highp float tmpvar_135;
  tmpvar_135 = clamp (dot (tmpvar_116, tmpvar_129), 0.0, 1.0);
  tmpvar_134 = tmpvar_135;
  mediump float tmpvar_136;
  mediump float NdotV_137;
  NdotV_137 = tmpvar_131;
  mediump float NdotL_138;
  NdotL_138 = tmpvar_132;
  mediump float perceptualRoughness_139;
  perceptualRoughness_139 = perceptualRoughness_122;
  mediump float tmpvar_140;
  tmpvar_140 = (0.5 + ((2.0 * tmpvar_134) * (tmpvar_134 * perceptualRoughness_139)));
  mediump float x_141;
  x_141 = (1.0 - NdotL_138);
  mediump float x_142;
  x_142 = (1.0 - NdotV_137);
  tmpvar_136 = ((1.0 + (
    (tmpvar_140 - 1.0)
   * 
    ((x_141 * x_141) * ((x_141 * x_141) * x_141))
  )) * (1.0 + (
    (tmpvar_140 - 1.0)
   * 
    ((x_142 * x_142) * ((x_142 * x_142) * x_142))
  )));
  highp float tmpvar_143;
  tmpvar_143 = (tmpvar_136 * tmpvar_132);
  diffuseTerm_121 = tmpvar_143;
  highp float tmpvar_144;
  tmpvar_144 = max ((perceptualRoughness_122 * perceptualRoughness_122), 0.002);
  highp float tmpvar_145;
  tmpvar_145 = (tmpvar_144 * tmpvar_144);
  highp float tmpvar_146;
  tmpvar_146 = (((
    (tmpvar_133 * tmpvar_145)
   - tmpvar_133) * tmpvar_133) + 1.0);
  surfaceReduction_120 = (1.0 - ((0.28 * tmpvar_144) * perceptualRoughness_122));
  mediump vec3 tmpvar_147;
  mediump float x_148;
  x_148 = (1.0 - tmpvar_134);
  tmpvar_147 = (specColor_125 + ((1.0 - specColor_125) * (
    (x_148 * x_148)
   * 
    ((x_148 * x_148) * x_148)
  )));
  color_119 = (((
    (tmpvar_123 * LIGHT_COLOR)
   * diffuseTerm_121) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_145)
       / 
        ((tmpvar_146 * tmpvar_146) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_132 * (
          (tmpvar_131 * (1.0 - tmpvar_144))
         + tmpvar_144)) + (tmpvar_131 * (
          (tmpvar_132 * (1.0 - tmpvar_144))
         + tmpvar_144))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_132)) * LIGHT_COLOR)
   * tmpvar_147)) * tmpvar_35);
  color_119 = (color_119 + tmpvar_6);
  color_119 = (color_119 + (tmpvar_123 * rgbm_31.xyz));
  mediump float cosA_149;
  cosA_149 = tmpvar_131;
  mediump float tmpvar_150;
  mediump float x_151;
  x_151 = (1.0 - cosA_149);
  tmpvar_150 = ((x_151 * x_151) * ((x_151 * x_151) * x_151));
  mediump vec3 tmpvar_152;
  tmpvar_152 = (surfaceReduction_120 * ((specColor_125 * 
    (1.0 - tmpvar_150)
  ) + (vec3(
    clamp ((tmpvar_5 + (1.0 - tmpvar_126)), 0.0, 1.0)
  ) * tmpvar_150)));
  specularEnv_118 = tmpvar_152;
  color_119 = (color_119 + (specularEnv_118 * rgbm_24.xyz));
  outColor_2.xyz = color_119;
  lowp vec4 tmpvar_153;
  tmpvar_153 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_153;
  outColor_2.w = ((col_11.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IBLRotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_texture_lod : enable
lowp vec4 impl_low_textureCubeLodEXT(lowp samplerCube sampler, highp vec3 coord, mediump float lod)
{
#if defined(GL_EXT_shader_texture_lod)
	return textureCubeLodEXT(sampler, coord, lod);
#else
	return textureCube(sampler, coord, lod);
#endif
}

uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _Opacity;
uniform highp vec3 _IBLRotation;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec3 normalWorld_7;
  highp vec3 normalTangent_8;
  highp vec3 emissionMapColor_9;
  highp vec2 mg_10;
  highp vec4 col_11;
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_11 = tmpvar_12;
  lowp vec2 tmpvar_13;
  tmpvar_13 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_10 = tmpvar_13;
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture2D (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_9 = tmpvar_14;
  lowp vec3 tmpvar_15;
  tmpvar_15 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_8 = tmpvar_15;
  normalTangent_8 = ((normalTangent_8 * 2.0) - 1.0);
  normalWorld_7 = normalize(((
    (normalTangent_8.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_8.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_8.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_16;
  tmpvar_16.x = xlv_TEXCOORD1.w;
  tmpvar_16.y = xlv_TEXCOORD2.w;
  tmpvar_16.z = xlv_TEXCOORD3.w;
  highp float tmpvar_17;
  tmpvar_17 = cos(_IBLRotation.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_IBLRotation.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_IBLRotation.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_IBLRotation.z);
  highp float tmpvar_21;
  tmpvar_21 = cos(_IBLRotation.x);
  highp float tmpvar_22;
  tmpvar_22 = sin(_IBLRotation.x);
  highp mat4 tmpvar_23;
  tmpvar_23[0].x = (tmpvar_17 * tmpvar_19);
  tmpvar_23[0].y = ((tmpvar_18 * tmpvar_22) - ((tmpvar_17 * tmpvar_20) * tmpvar_21));
  tmpvar_23[0].z = (((tmpvar_17 * tmpvar_20) * tmpvar_22) + (tmpvar_18 * tmpvar_21));
  tmpvar_23[0].w = 0.0;
  tmpvar_23[1].x = tmpvar_20;
  tmpvar_23[1].y = (tmpvar_19 * tmpvar_21);
  tmpvar_23[1].z = (-(tmpvar_19) * tmpvar_22);
  tmpvar_23[1].w = 0.0;
  tmpvar_23[2].x = (-(tmpvar_18) * tmpvar_19);
  tmpvar_23[2].y = (((tmpvar_18 * tmpvar_20) * tmpvar_21) + (tmpvar_17 * tmpvar_22));
  tmpvar_23[2].z = (((
    -(tmpvar_18)
   * tmpvar_20) * tmpvar_22) + (tmpvar_17 * tmpvar_21));
  tmpvar_23[2].w = 0.0;
  tmpvar_23[3].x = 0.0;
  tmpvar_23[3].y = 0.0;
  tmpvar_23[3].z = 0.0;
  tmpvar_23[3].w = 1.0;
  highp vec4 rgbm_24;
  highp vec3 I_25;
  I_25 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_16)));
  highp vec4 tmpvar_26;
  tmpvar_26.w = 0.0;
  tmpvar_26.xyz = (I_25 - (2.0 * (
    dot (normalWorld_7, I_25)
   * normalWorld_7)));
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize((tmpvar_23 * tmpvar_26).xyz);
  highp vec4 tmpvar_28;
  tmpvar_28.xyz = tmpvar_27;
  tmpvar_28.w = ((1.0 - (mg_10.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_29;
  tmpvar_29 = impl_low_textureCubeLodEXT (_GlossEnvMap, tmpvar_27, tmpvar_28.w);
  highp vec4 tmpvar_30;
  tmpvar_30 = tmpvar_29;
  rgbm_24.w = tmpvar_30.w;
  rgbm_24.xyz = ((tmpvar_30.xyz * tmpvar_30.w) * 6.0);
  highp vec4 rgbm_31;
  lowp vec4 tmpvar_32;
  tmpvar_32 = textureCube (_IrradianceMap, normalWorld_7);
  highp vec4 tmpvar_33;
  tmpvar_33 = tmpvar_32;
  rgbm_31.w = tmpvar_33.w;
  rgbm_31.xyz = ((tmpvar_33.xyz * tmpvar_33.w) * 6.0);
  tmpvar_3 = col_11.xyz;
  tmpvar_4 = (mg_10.x * _Metallic);
  tmpvar_5 = (mg_10.y * _Smoothness);
  tmpvar_6 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_9));
  highp vec4 shadowCoord_34;
  shadowCoord_34 = xlv_TEXCOORD4;
  highp float tmpvar_35;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_35 = 1.0;
  } else {
    highp vec2 tmpvar_36;
    tmpvar_36.x = LIGHT_PARAM.z;
    tmpvar_36.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_37;
    tmpvar_37.xy = tmpvar_36;
    highp float tmpvar_38;
    tmpvar_38 = (1.0/(LIGHT_PARAM.z));
    tmpvar_37.z = tmpvar_38;
    tmpvar_37.w = tmpvar_38;
    shadowCoord_34.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_39;
    highp vec2 tmpvar_40;
    tmpvar_40 = tmpvar_37.xy;
    shadow_39 = 0.0;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (shadowCoord_34.xy - LIGHT_PARAM.zz);
    tmpvar_41.z = shadowCoord_34.z;
    highp vec4 tmpvar_42;
    tmpvar_42 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_41.xy);
    highp float tmpvar_43;
    if ((tmpvar_42.x < xlv_TEXCOORD4.z)) {
      tmpvar_43 = 0.0;
    } else {
      tmpvar_43 = 1.0;
    };
    shadow_39 = tmpvar_43;
    highp vec2 tmpvar_44;
    tmpvar_44.x = 0.0;
    tmpvar_44.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (shadowCoord_34.xy + tmpvar_44);
    tmpvar_45.z = shadowCoord_34.z;
    highp vec4 tmpvar_46;
    tmpvar_46 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_45.xy);
    highp float tmpvar_47;
    if ((tmpvar_46.x < xlv_TEXCOORD4.z)) {
      tmpvar_47 = 0.0;
    } else {
      tmpvar_47 = 1.0;
    };
    shadow_39 = (tmpvar_43 + tmpvar_47);
    highp vec2 tmpvar_48;
    tmpvar_48.x = tmpvar_40.x;
    tmpvar_48.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (shadowCoord_34.xy + tmpvar_48);
    tmpvar_49.z = shadowCoord_34.z;
    highp vec4 tmpvar_50;
    tmpvar_50 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_49.xy);
    highp float tmpvar_51;
    if ((tmpvar_50.x < xlv_TEXCOORD4.z)) {
      tmpvar_51 = 0.0;
    } else {
      tmpvar_51 = 1.0;
    };
    shadow_39 = (shadow_39 + tmpvar_51);
    highp vec2 tmpvar_52;
    tmpvar_52.y = 0.0;
    tmpvar_52.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (shadowCoord_34.xy + tmpvar_52);
    tmpvar_53.z = shadowCoord_34.z;
    highp vec4 tmpvar_54;
    tmpvar_54 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_53.xy);
    highp float tmpvar_55;
    if ((tmpvar_54.x < xlv_TEXCOORD4.z)) {
      tmpvar_55 = 0.0;
    } else {
      tmpvar_55 = 1.0;
    };
    shadow_39 = (shadow_39 + tmpvar_55);
    highp vec4 tmpvar_56;
    tmpvar_56 = texture2D (TEXTURE_SHADOW_DEPTH, shadowCoord_34.xy);
    highp float tmpvar_57;
    if ((tmpvar_56.x < xlv_TEXCOORD4.z)) {
      tmpvar_57 = 0.0;
    } else {
      tmpvar_57 = 1.0;
    };
    shadow_39 = (shadow_39 + tmpvar_57);
    highp vec2 tmpvar_58;
    tmpvar_58.y = 0.0;
    tmpvar_58.x = tmpvar_40.x;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (shadowCoord_34.xy + tmpvar_58);
    tmpvar_59.z = shadowCoord_34.z;
    highp vec4 tmpvar_60;
    tmpvar_60 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_59.xy);
    highp float tmpvar_61;
    if ((tmpvar_60.x < xlv_TEXCOORD4.z)) {
      tmpvar_61 = 0.0;
    } else {
      tmpvar_61 = 1.0;
    };
    shadow_39 = (shadow_39 + tmpvar_61);
    highp vec2 tmpvar_62;
    tmpvar_62.x = -(LIGHT_PARAM.z);
    tmpvar_62.y = tmpvar_40.y;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (shadowCoord_34.xy + tmpvar_62);
    tmpvar_63.z = shadowCoord_34.z;
    highp vec4 tmpvar_64;
    tmpvar_64 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_63.xy);
    highp float tmpvar_65;
    if ((tmpvar_64.x < xlv_TEXCOORD4.z)) {
      tmpvar_65 = 0.0;
    } else {
      tmpvar_65 = 1.0;
    };
    shadow_39 = (shadow_39 + tmpvar_65);
    highp vec2 tmpvar_66;
    tmpvar_66.x = 0.0;
    tmpvar_66.y = tmpvar_40.y;
    highp vec3 tmpvar_67;
    tmpvar_67.xy = (shadowCoord_34.xy + tmpvar_66);
    tmpvar_67.z = shadowCoord_34.z;
    highp vec4 tmpvar_68;
    tmpvar_68 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_67.xy);
    highp float tmpvar_69;
    if ((tmpvar_68.x < xlv_TEXCOORD4.z)) {
      tmpvar_69 = 0.0;
    } else {
      tmpvar_69 = 1.0;
    };
    shadow_39 = (shadow_39 + tmpvar_69);
    highp vec3 tmpvar_70;
    tmpvar_70.xy = (shadowCoord_34.xy + LIGHT_PARAM.zz);
    tmpvar_70.z = shadowCoord_34.z;
    highp vec4 tmpvar_71;
    tmpvar_71 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_70.xy);
    highp float tmpvar_72;
    if ((tmpvar_71.x < xlv_TEXCOORD4.z)) {
      tmpvar_72 = 0.0;
    } else {
      tmpvar_72 = 1.0;
    };
    shadow_39 = (shadow_39 + tmpvar_72);
    shadow_39 = (shadow_39 / 9.0);
    tmpvar_35 = mix (1.0, shadow_39, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_73;
  highp vec3 tmpvar_74;
  tmpvar_73 = normalize((CAMERA_WORLDPOSITION - tmpvar_16));
  tmpvar_74 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_75;
  highp vec3 specularEnv_76;
  highp vec3 color_77;
  mediump float surfaceReduction_78;
  mediump float diffuseTerm_79;
  highp float perceptualRoughness_80;
  mediump vec3 tmpvar_81;
  mediump vec3 albedo_82;
  albedo_82 = tmpvar_3;
  mediump vec3 specColor_83;
  specColor_83 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_82 * tmpvar_4));
  mediump float tmpvar_84;
  tmpvar_84 = (0.7790837 - (tmpvar_4 * 0.7790837));
  tmpvar_81 = (albedo_82 * tmpvar_84);
  tmpvar_75 = 0.0;
  mediump float alpha_85;
  alpha_85 = tmpvar_75;
  tmpvar_75 = alpha_85;
  mediump float tmpvar_86;
  tmpvar_86 = (1.0 - tmpvar_5);
  perceptualRoughness_80 = tmpvar_86;
  highp vec3 tmpvar_87;
  highp vec3 inVec_88;
  inVec_88 = (tmpvar_74 + tmpvar_73);
  tmpvar_87 = (inVec_88 * inversesqrt(max (0.001, 
    dot (inVec_88, inVec_88)
  )));
  highp float tmpvar_89;
  tmpvar_89 = abs(dot (tmpvar_73, normalWorld_7));
  highp float tmpvar_90;
  tmpvar_90 = clamp (dot (normalWorld_7, tmpvar_74), 0.0, 1.0);
  highp float tmpvar_91;
  tmpvar_91 = clamp (dot (normalWorld_7, tmpvar_87), 0.0, 1.0);
  mediump float tmpvar_92;
  highp float tmpvar_93;
  tmpvar_93 = clamp (dot (tmpvar_74, tmpvar_87), 0.0, 1.0);
  tmpvar_92 = tmpvar_93;
  mediump float tmpvar_94;
  mediump float NdotV_95;
  NdotV_95 = tmpvar_89;
  mediump float NdotL_96;
  NdotL_96 = tmpvar_90;
  mediump float perceptualRoughness_97;
  perceptualRoughness_97 = perceptualRoughness_80;
  mediump float tmpvar_98;
  tmpvar_98 = (0.5 + ((2.0 * tmpvar_92) * (tmpvar_92 * perceptualRoughness_97)));
  mediump float x_99;
  x_99 = (1.0 - NdotL_96);
  mediump float x_100;
  x_100 = (1.0 - NdotV_95);
  tmpvar_94 = ((1.0 + (
    (tmpvar_98 - 1.0)
   * 
    ((x_99 * x_99) * ((x_99 * x_99) * x_99))
  )) * (1.0 + (
    (tmpvar_98 - 1.0)
   * 
    ((x_100 * x_100) * ((x_100 * x_100) * x_100))
  )));
  highp float tmpvar_101;
  tmpvar_101 = (tmpvar_94 * tmpvar_90);
  diffuseTerm_79 = tmpvar_101;
  highp float tmpvar_102;
  tmpvar_102 = max ((perceptualRoughness_80 * perceptualRoughness_80), 0.002);
  highp float tmpvar_103;
  tmpvar_103 = (tmpvar_102 * tmpvar_102);
  highp float tmpvar_104;
  tmpvar_104 = (((
    (tmpvar_91 * tmpvar_103)
   - tmpvar_91) * tmpvar_91) + 1.0);
  surfaceReduction_78 = (1.0 - ((0.28 * tmpvar_102) * perceptualRoughness_80));
  mediump vec3 tmpvar_105;
  mediump float x_106;
  x_106 = (1.0 - tmpvar_92);
  tmpvar_105 = (specColor_83 + ((1.0 - specColor_83) * (
    (x_106 * x_106)
   * 
    ((x_106 * x_106) * x_106)
  )));
  color_77 = (((
    (tmpvar_81 * LIGHT_COLOR)
   * diffuseTerm_79) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_103)
       / 
        ((tmpvar_104 * tmpvar_104) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_90 * (
          (tmpvar_89 * (1.0 - tmpvar_102))
         + tmpvar_102)) + (tmpvar_89 * (
          (tmpvar_90 * (1.0 - tmpvar_102))
         + tmpvar_102))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_90)) * LIGHT_COLOR)
   * tmpvar_105)) * tmpvar_35);
  color_77 = (color_77 + tmpvar_6);
  color_77 = (color_77 + (tmpvar_81 * rgbm_31.xyz));
  mediump float cosA_107;
  cosA_107 = tmpvar_89;
  mediump float tmpvar_108;
  mediump float x_109;
  x_109 = (1.0 - cosA_107);
  tmpvar_108 = ((x_109 * x_109) * ((x_109 * x_109) * x_109));
  mediump vec3 tmpvar_110;
  tmpvar_110 = (surfaceReduction_78 * ((specColor_83 * 
    (1.0 - tmpvar_108)
  ) + (vec3(
    clamp ((tmpvar_5 + (1.0 - tmpvar_84)), 0.0, 1.0)
  ) * tmpvar_108)));
  specularEnv_76 = tmpvar_110;
  color_77 = (color_77 + (specularEnv_76 * rgbm_24.xyz));
  outColor_2.xyz = color_77;
  lowp vec4 tmpvar_111;
  tmpvar_111 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_111;
  outColor_2.w = ((col_11.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IBLRotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_9[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_9[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[#extension GL_EXT_shader_texture_lod : enable
lowp vec4 impl_low_textureCubeLodEXT(lowp samplerCube sampler, highp vec3 coord, mediump float lod)
{
#if defined(GL_EXT_shader_texture_lod)
	return textureCubeLodEXT(sampler, coord, lod);
#else
	return textureCube(sampler, coord, lod);
#endif
}

uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _Opacity;
uniform highp vec3 _IBLRotation;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 normalWorld_6;
  highp vec3 normalTangent_7;
  highp vec3 emissionMapColor_8;
  highp vec2 mg_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  lowp vec2 tmpvar_12;
  tmpvar_12 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_9 = tmpvar_12;
  lowp vec3 tmpvar_13;
  tmpvar_13 = texture2D (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_8 = tmpvar_13;
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_7 = tmpvar_14;
  normalTangent_7 = ((normalTangent_7 * 2.0) - 1.0);
  normalWorld_6 = normalize(((
    (normalTangent_7.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_7.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  highp float tmpvar_16;
  tmpvar_16 = cos(_IBLRotation.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_IBLRotation.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_IBLRotation.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_IBLRotation.z);
  highp float tmpvar_20;
  tmpvar_20 = cos(_IBLRotation.x);
  highp float tmpvar_21;
  tmpvar_21 = sin(_IBLRotation.x);
  highp mat4 tmpvar_22;
  tmpvar_22[0].x = (tmpvar_16 * tmpvar_18);
  tmpvar_22[0].y = ((tmpvar_17 * tmpvar_21) - ((tmpvar_16 * tmpvar_19) * tmpvar_20));
  tmpvar_22[0].z = (((tmpvar_16 * tmpvar_19) * tmpvar_21) + (tmpvar_17 * tmpvar_20));
  tmpvar_22[0].w = 0.0;
  tmpvar_22[1].x = tmpvar_19;
  tmpvar_22[1].y = (tmpvar_18 * tmpvar_20);
  tmpvar_22[1].z = (-(tmpvar_18) * tmpvar_21);
  tmpvar_22[1].w = 0.0;
  tmpvar_22[2].x = (-(tmpvar_17) * tmpvar_18);
  tmpvar_22[2].y = (((tmpvar_17 * tmpvar_19) * tmpvar_20) + (tmpvar_16 * tmpvar_21));
  tmpvar_22[2].z = (((
    -(tmpvar_17)
   * tmpvar_19) * tmpvar_21) + (tmpvar_16 * tmpvar_20));
  tmpvar_22[2].w = 0.0;
  tmpvar_22[3].x = 0.0;
  tmpvar_22[3].y = 0.0;
  tmpvar_22[3].z = 0.0;
  tmpvar_22[3].w = 1.0;
  highp vec4 rgbm_23;
  highp vec3 I_24;
  I_24 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_15)));
  highp vec4 tmpvar_25;
  tmpvar_25.w = 0.0;
  tmpvar_25.xyz = (I_24 - (2.0 * (
    dot (normalWorld_6, I_24)
   * normalWorld_6)));
  highp vec3 tmpvar_26;
  tmpvar_26 = normalize((tmpvar_22 * tmpvar_25).xyz);
  highp vec4 tmpvar_27;
  tmpvar_27.xyz = tmpvar_26;
  tmpvar_27.w = ((1.0 - (mg_9.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_28;
  tmpvar_28 = impl_low_textureCubeLodEXT (_GlossEnvMap, tmpvar_26, tmpvar_27.w);
  highp vec4 tmpvar_29;
  tmpvar_29 = tmpvar_28;
  rgbm_23.w = tmpvar_29.w;
  rgbm_23.xyz = ((tmpvar_29.xyz * tmpvar_29.w) * 6.0);
  highp vec4 rgbm_30;
  lowp vec4 tmpvar_31;
  tmpvar_31 = textureCube (_IrradianceMap, normalWorld_6);
  highp vec4 tmpvar_32;
  tmpvar_32 = tmpvar_31;
  rgbm_30.w = tmpvar_32.w;
  rgbm_30.xyz = ((tmpvar_32.xyz * tmpvar_32.w) * 6.0);
  tmpvar_3 = col_10.xyz;
  tmpvar_4 = (mg_9.x * _Metallic);
  tmpvar_5 = (mg_9.y * _Smoothness);
  highp float tmpvar_33;
  highp vec3 specularEnv_34;
  highp vec3 color_35;
  mediump float surfaceReduction_36;
  highp float perceptualRoughness_37;
  mediump vec3 tmpvar_38;
  mediump vec3 albedo_39;
  albedo_39 = tmpvar_3;
  mediump float tmpvar_40;
  tmpvar_40 = (0.7790837 - (tmpvar_4 * 0.7790837));
  tmpvar_38 = (albedo_39 * tmpvar_40);
  tmpvar_33 = 0.0;
  mediump float alpha_41;
  alpha_41 = tmpvar_33;
  tmpvar_33 = alpha_41;
  mediump float tmpvar_42;
  tmpvar_42 = (1.0 - tmpvar_5);
  perceptualRoughness_37 = tmpvar_42;
  highp float tmpvar_43;
  tmpvar_43 = abs(dot (normalize(
    (CAMERA_WORLDPOSITION - tmpvar_15)
  ), normalWorld_6));
  highp float tmpvar_44;
  tmpvar_44 = max ((perceptualRoughness_37 * perceptualRoughness_37), 0.002);
  surfaceReduction_36 = (1.0 - ((0.28 * tmpvar_44) * perceptualRoughness_37));
  color_35 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_8));
  color_35 = (color_35 + (tmpvar_38 * rgbm_30.xyz));
  mediump float cosA_45;
  cosA_45 = tmpvar_43;
  mediump float tmpvar_46;
  mediump float x_47;
  x_47 = (1.0 - cosA_45);
  tmpvar_46 = ((x_47 * x_47) * ((x_47 * x_47) * x_47));
  mediump vec3 tmpvar_48;
  tmpvar_48 = (surfaceReduction_36 * ((
    ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_39 * tmpvar_4))
   * 
    (1.0 - tmpvar_46)
  ) + (vec3(
    clamp ((tmpvar_5 + (1.0 - tmpvar_40)), 0.0, 1.0)
  ) * tmpvar_46)));
  specularEnv_34 = tmpvar_48;
  color_35 = (color_35 + (specularEnv_34 * rgbm_23.xyz));
  outColor_2.xyz = color_35;
  lowp vec4 tmpvar_49;
  tmpvar_49 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_49;
  outColor_2.w = ((col_10.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IBLRotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_9[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_9[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[#extension GL_EXT_shader_texture_lod : enable
lowp vec4 impl_low_textureCubeLodEXT(lowp samplerCube sampler, highp vec3 coord, mediump float lod)
{
#if defined(GL_EXT_shader_texture_lod)
	return textureCubeLodEXT(sampler, coord, lod);
#else
	return textureCube(sampler, coord, lod);
#endif
}

uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _Opacity;
uniform highp vec3 _IBLRotation;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 normalWorld_6;
  highp vec3 normalTangent_7;
  highp vec3 emissionMapColor_8;
  highp vec2 mg_9;
  highp vec4 col_10;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_10 = tmpvar_11;
  lowp vec2 tmpvar_12;
  tmpvar_12 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_9 = tmpvar_12;
  lowp vec3 tmpvar_13;
  tmpvar_13 = texture2D (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_8 = tmpvar_13;
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_7 = tmpvar_14;
  normalTangent_7 = ((normalTangent_7 * 2.0) - 1.0);
  normalWorld_6 = normalize(((
    (normalTangent_7.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_7.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_15;
  tmpvar_15.x = xlv_TEXCOORD1.w;
  tmpvar_15.y = xlv_TEXCOORD2.w;
  tmpvar_15.z = xlv_TEXCOORD3.w;
  highp float tmpvar_16;
  tmpvar_16 = cos(_IBLRotation.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_IBLRotation.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_IBLRotation.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_IBLRotation.z);
  highp float tmpvar_20;
  tmpvar_20 = cos(_IBLRotation.x);
  highp float tmpvar_21;
  tmpvar_21 = sin(_IBLRotation.x);
  highp mat4 tmpvar_22;
  tmpvar_22[0].x = (tmpvar_16 * tmpvar_18);
  tmpvar_22[0].y = ((tmpvar_17 * tmpvar_21) - ((tmpvar_16 * tmpvar_19) * tmpvar_20));
  tmpvar_22[0].z = (((tmpvar_16 * tmpvar_19) * tmpvar_21) + (tmpvar_17 * tmpvar_20));
  tmpvar_22[0].w = 0.0;
  tmpvar_22[1].x = tmpvar_19;
  tmpvar_22[1].y = (tmpvar_18 * tmpvar_20);
  tmpvar_22[1].z = (-(tmpvar_18) * tmpvar_21);
  tmpvar_22[1].w = 0.0;
  tmpvar_22[2].x = (-(tmpvar_17) * tmpvar_18);
  tmpvar_22[2].y = (((tmpvar_17 * tmpvar_19) * tmpvar_20) + (tmpvar_16 * tmpvar_21));
  tmpvar_22[2].z = (((
    -(tmpvar_17)
   * tmpvar_19) * tmpvar_21) + (tmpvar_16 * tmpvar_20));
  tmpvar_22[2].w = 0.0;
  tmpvar_22[3].x = 0.0;
  tmpvar_22[3].y = 0.0;
  tmpvar_22[3].z = 0.0;
  tmpvar_22[3].w = 1.0;
  highp vec4 rgbm_23;
  highp vec3 I_24;
  I_24 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_15)));
  highp vec4 tmpvar_25;
  tmpvar_25.w = 0.0;
  tmpvar_25.xyz = (I_24 - (2.0 * (
    dot (normalWorld_6, I_24)
   * normalWorld_6)));
  highp vec3 tmpvar_26;
  tmpvar_26 = normalize((tmpvar_22 * tmpvar_25).xyz);
  highp vec4 tmpvar_27;
  tmpvar_27.xyz = tmpvar_26;
  tmpvar_27.w = ((1.0 - (mg_9.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_28;
  tmpvar_28 = impl_low_textureCubeLodEXT (_GlossEnvMap, tmpvar_26, tmpvar_27.w);
  highp vec4 tmpvar_29;
  tmpvar_29 = tmpvar_28;
  rgbm_23.w = tmpvar_29.w;
  rgbm_23.xyz = ((tmpvar_29.xyz * tmpvar_29.w) * 6.0);
  highp vec4 rgbm_30;
  lowp vec4 tmpvar_31;
  tmpvar_31 = textureCube (_IrradianceMap, normalWorld_6);
  highp vec4 tmpvar_32;
  tmpvar_32 = tmpvar_31;
  rgbm_30.w = tmpvar_32.w;
  rgbm_30.xyz = ((tmpvar_32.xyz * tmpvar_32.w) * 6.0);
  tmpvar_3 = col_10.xyz;
  tmpvar_4 = (mg_9.x * _Metallic);
  tmpvar_5 = (mg_9.y * _Smoothness);
  highp vec3 tmpvar_33;
  highp vec3 tmpvar_34;
  tmpvar_33 = normalize((CAMERA_WORLDPOSITION - tmpvar_15));
  tmpvar_34 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_35;
  highp vec3 specularEnv_36;
  highp vec3 color_37;
  mediump float surfaceReduction_38;
  mediump float diffuseTerm_39;
  highp float perceptualRoughness_40;
  mediump vec3 tmpvar_41;
  mediump vec3 albedo_42;
  albedo_42 = tmpvar_3;
  mediump vec3 specColor_43;
  specColor_43 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_42 * tmpvar_4));
  mediump float tmpvar_44;
  tmpvar_44 = (0.7790837 - (tmpvar_4 * 0.7790837));
  tmpvar_41 = (albedo_42 * tmpvar_44);
  tmpvar_35 = 0.0;
  mediump float alpha_45;
  alpha_45 = tmpvar_35;
  tmpvar_35 = alpha_45;
  mediump float tmpvar_46;
  tmpvar_46 = (1.0 - tmpvar_5);
  perceptualRoughness_40 = tmpvar_46;
  highp vec3 tmpvar_47;
  highp vec3 inVec_48;
  inVec_48 = (tmpvar_34 + tmpvar_33);
  tmpvar_47 = (inVec_48 * inversesqrt(max (0.001, 
    dot (inVec_48, inVec_48)
  )));
  highp float tmpvar_49;
  tmpvar_49 = abs(dot (tmpvar_33, normalWorld_6));
  highp float tmpvar_50;
  tmpvar_50 = clamp (dot (normalWorld_6, tmpvar_34), 0.0, 1.0);
  highp float tmpvar_51;
  tmpvar_51 = clamp (dot (normalWorld_6, tmpvar_47), 0.0, 1.0);
  mediump float tmpvar_52;
  highp float tmpvar_53;
  tmpvar_53 = clamp (dot (tmpvar_34, tmpvar_47), 0.0, 1.0);
  tmpvar_52 = tmpvar_53;
  mediump float tmpvar_54;
  mediump float NdotV_55;
  NdotV_55 = tmpvar_49;
  mediump float NdotL_56;
  NdotL_56 = tmpvar_50;
  mediump float perceptualRoughness_57;
  perceptualRoughness_57 = perceptualRoughness_40;
  mediump float tmpvar_58;
  tmpvar_58 = (0.5 + ((2.0 * tmpvar_52) * (tmpvar_52 * perceptualRoughness_57)));
  mediump float x_59;
  x_59 = (1.0 - NdotL_56);
  mediump float x_60;
  x_60 = (1.0 - NdotV_55);
  tmpvar_54 = ((1.0 + (
    (tmpvar_58 - 1.0)
   * 
    ((x_59 * x_59) * ((x_59 * x_59) * x_59))
  )) * (1.0 + (
    (tmpvar_58 - 1.0)
   * 
    ((x_60 * x_60) * ((x_60 * x_60) * x_60))
  )));
  highp float tmpvar_61;
  tmpvar_61 = (tmpvar_54 * tmpvar_50);
  diffuseTerm_39 = tmpvar_61;
  highp float tmpvar_62;
  tmpvar_62 = max ((perceptualRoughness_40 * perceptualRoughness_40), 0.002);
  highp float tmpvar_63;
  tmpvar_63 = (tmpvar_62 * tmpvar_62);
  highp float tmpvar_64;
  tmpvar_64 = (((
    (tmpvar_51 * tmpvar_63)
   - tmpvar_51) * tmpvar_51) + 1.0);
  surfaceReduction_38 = (1.0 - ((0.28 * tmpvar_62) * perceptualRoughness_40));
  mediump vec3 tmpvar_65;
  mediump float x_66;
  x_66 = (1.0 - tmpvar_52);
  tmpvar_65 = (specColor_43 + ((1.0 - specColor_43) * (
    (x_66 * x_66)
   * 
    ((x_66 * x_66) * x_66)
  )));
  color_37 = (((tmpvar_41 * LIGHT_COLOR) * diffuseTerm_39) + ((
    max (0.0, (sqrt(max (0.0001, 
      ((((0.3183099 * tmpvar_63) / (
        (tmpvar_64 * tmpvar_64)
       + 1e-7)) * (0.5 / (
        ((tmpvar_50 * ((tmpvar_49 * 
          (1.0 - tmpvar_62)
        ) + tmpvar_62)) + (tmpvar_49 * ((tmpvar_50 * 
          (1.0 - tmpvar_62)
        ) + tmpvar_62)))
       + 0.0001))) * 3.141593)
    )) * tmpvar_50))
   * LIGHT_COLOR) * tmpvar_65));
  color_37 = (color_37 + (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_8)));
  color_37 = (color_37 + (tmpvar_41 * rgbm_30.xyz));
  mediump float cosA_67;
  cosA_67 = tmpvar_49;
  mediump float tmpvar_68;
  mediump float x_69;
  x_69 = (1.0 - cosA_67);
  tmpvar_68 = ((x_69 * x_69) * ((x_69 * x_69) * x_69));
  mediump vec3 tmpvar_70;
  tmpvar_70 = (surfaceReduction_38 * ((specColor_43 * 
    (1.0 - tmpvar_68)
  ) + (vec3(
    clamp ((tmpvar_5 + (1.0 - tmpvar_44)), 0.0, 1.0)
  ) * tmpvar_68)));
  specularEnv_36 = tmpvar_70;
  color_37 = (color_37 + (specularEnv_36 * rgbm_23.xyz));
  outColor_2.xyz = color_37;
  lowp vec4 tmpvar_71;
  tmpvar_71 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_71;
  outColor_2.w = ((col_10.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IBLRotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shader_texture_lod : enable
#extension GL_EXT_shadow_samplers : enable
lowp vec4 impl_low_textureCubeLodEXT(lowp samplerCube sampler, highp vec3 coord, mediump float lod)
{
#if defined(GL_EXT_shader_texture_lod)
	return textureCubeLodEXT(sampler, coord, lod);
#else
	return textureCube(sampler, coord, lod);
#endif
}

uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _Opacity;
uniform highp vec3 _IBLRotation;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec3 normalWorld_7;
  highp vec3 normalTangent_8;
  highp vec3 emissionMapColor_9;
  highp vec2 mg_10;
  highp vec4 col_11;
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_11 = tmpvar_12;
  lowp vec2 tmpvar_13;
  tmpvar_13 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_10 = tmpvar_13;
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture2D (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_9 = tmpvar_14;
  lowp vec3 tmpvar_15;
  tmpvar_15 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_8 = tmpvar_15;
  normalTangent_8 = ((normalTangent_8 * 2.0) - 1.0);
  normalWorld_7 = normalize(((
    (normalTangent_8.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_8.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_8.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_16;
  tmpvar_16.x = xlv_TEXCOORD1.w;
  tmpvar_16.y = xlv_TEXCOORD2.w;
  tmpvar_16.z = xlv_TEXCOORD3.w;
  highp float tmpvar_17;
  tmpvar_17 = cos(_IBLRotation.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_IBLRotation.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_IBLRotation.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_IBLRotation.z);
  highp float tmpvar_21;
  tmpvar_21 = cos(_IBLRotation.x);
  highp float tmpvar_22;
  tmpvar_22 = sin(_IBLRotation.x);
  highp mat4 tmpvar_23;
  tmpvar_23[0].x = (tmpvar_17 * tmpvar_19);
  tmpvar_23[0].y = ((tmpvar_18 * tmpvar_22) - ((tmpvar_17 * tmpvar_20) * tmpvar_21));
  tmpvar_23[0].z = (((tmpvar_17 * tmpvar_20) * tmpvar_22) + (tmpvar_18 * tmpvar_21));
  tmpvar_23[0].w = 0.0;
  tmpvar_23[1].x = tmpvar_20;
  tmpvar_23[1].y = (tmpvar_19 * tmpvar_21);
  tmpvar_23[1].z = (-(tmpvar_19) * tmpvar_22);
  tmpvar_23[1].w = 0.0;
  tmpvar_23[2].x = (-(tmpvar_18) * tmpvar_19);
  tmpvar_23[2].y = (((tmpvar_18 * tmpvar_20) * tmpvar_21) + (tmpvar_17 * tmpvar_22));
  tmpvar_23[2].z = (((
    -(tmpvar_18)
   * tmpvar_20) * tmpvar_22) + (tmpvar_17 * tmpvar_21));
  tmpvar_23[2].w = 0.0;
  tmpvar_23[3].x = 0.0;
  tmpvar_23[3].y = 0.0;
  tmpvar_23[3].z = 0.0;
  tmpvar_23[3].w = 1.0;
  highp vec4 rgbm_24;
  highp vec3 I_25;
  I_25 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_16)));
  highp vec4 tmpvar_26;
  tmpvar_26.w = 0.0;
  tmpvar_26.xyz = (I_25 - (2.0 * (
    dot (normalWorld_7, I_25)
   * normalWorld_7)));
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize((tmpvar_23 * tmpvar_26).xyz);
  highp vec4 tmpvar_28;
  tmpvar_28.xyz = tmpvar_27;
  tmpvar_28.w = ((1.0 - (mg_10.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_29;
  tmpvar_29 = impl_low_textureCubeLodEXT (_GlossEnvMap, tmpvar_27, tmpvar_28.w);
  highp vec4 tmpvar_30;
  tmpvar_30 = tmpvar_29;
  rgbm_24.w = tmpvar_30.w;
  rgbm_24.xyz = ((tmpvar_30.xyz * tmpvar_30.w) * 6.0);
  highp vec4 rgbm_31;
  lowp vec4 tmpvar_32;
  tmpvar_32 = textureCube (_IrradianceMap, normalWorld_7);
  highp vec4 tmpvar_33;
  tmpvar_33 = tmpvar_32;
  rgbm_31.w = tmpvar_33.w;
  rgbm_31.xyz = ((tmpvar_33.xyz * tmpvar_33.w) * 6.0);
  tmpvar_3 = col_11.xyz;
  tmpvar_4 = (mg_10.x * _Metallic);
  tmpvar_5 = (mg_10.y * _Smoothness);
  tmpvar_6 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_9));
  highp vec4 shadowCoord_34;
  shadowCoord_34 = xlv_TEXCOORD4;
  highp float tmpvar_35;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_35 = 1.0;
  } else {
    shadowCoord_34.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_36;
    highp vec2 fetchesOffsetsU_37;
    highp float shadow_38;
    highp vec2 tmpvar_39;
    tmpvar_39 = (shadowCoord_34.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_40;
    tmpvar_40 = floor((tmpvar_39 + 0.5));
    highp vec2 tmpvar_41;
    tmpvar_41 = (tmpvar_39 - tmpvar_40);
    highp vec4 computedWeight_42;
    highp vec4 computedArea_43;
    highp vec4 computedAreaUncut_44;
    highp float tmpvar_45;
    tmpvar_45 = (((tmpvar_41.x + 0.5) * (tmpvar_41.x + 0.5)) * 0.5);
    highp float tmpvar_46;
    tmpvar_46 = (tmpvar_45 - tmpvar_41.x);
    computedArea_43.x = tmpvar_46;
    computedAreaUncut_44.x = tmpvar_46;
    computedArea_43.w = tmpvar_45;
    computedAreaUncut_44.w = tmpvar_45;
    computedAreaUncut_44.y = ((1.5 - tmpvar_41.x) - 0.5);
    highp float tmpvar_47;
    tmpvar_47 = min (tmpvar_41.x, 0.0);
    computedArea_43.y = (computedAreaUncut_44.y - (tmpvar_47 * tmpvar_47));
    computedAreaUncut_44.z = ((1.5 + tmpvar_41.x) - 0.5);
    highp float tmpvar_48;
    tmpvar_48 = max (tmpvar_41.x, 0.0);
    computedArea_43.z = (computedAreaUncut_44.z - (tmpvar_48 * tmpvar_48));
    computedWeight_42 = (computedArea_43 * 0.44444);
    highp vec4 computedWeight_49;
    highp vec4 computedArea_50;
    highp vec4 computedAreaUncut_51;
    highp float tmpvar_52;
    tmpvar_52 = (((tmpvar_41.y + 0.5) * (tmpvar_41.y + 0.5)) * 0.5);
    highp float tmpvar_53;
    tmpvar_53 = (tmpvar_52 - tmpvar_41.y);
    computedArea_50.x = tmpvar_53;
    computedAreaUncut_51.x = tmpvar_53;
    computedArea_50.w = tmpvar_52;
    computedAreaUncut_51.w = tmpvar_52;
    computedAreaUncut_51.y = ((1.5 - tmpvar_41.y) - 0.5);
    highp float tmpvar_54;
    tmpvar_54 = min (tmpvar_41.y, 0.0);
    computedArea_50.y = (computedAreaUncut_51.y - (tmpvar_54 * tmpvar_54));
    computedAreaUncut_51.z = ((1.5 + tmpvar_41.y) - 0.5);
    highp float tmpvar_55;
    tmpvar_55 = max (tmpvar_41.y, 0.0);
    computedArea_50.z = (computedAreaUncut_51.z - (tmpvar_55 * tmpvar_55));
    computedWeight_49 = (computedArea_50 * 0.44444);
    highp vec2 tmpvar_56;
    tmpvar_56 = (computedWeight_42.xz + computedWeight_42.yw);
    highp vec2 tmpvar_57;
    tmpvar_57 = (computedWeight_49.xz + computedWeight_49.yw);
    fetchesOffsetsU_37 = (((computedWeight_42.yw / tmpvar_56) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_36 = (((computedWeight_49.yw / tmpvar_57) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_58;
    tmpvar_58 = (tmpvar_40 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_37.x;
    tmpvar_59.y = fetchesOffsetsV_36.x;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_58 + tmpvar_59);
    tmpvar_60.z = shadowCoord_34.z;
    lowp float tmpvar_61;
    tmpvar_61 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_38 = ((tmpvar_56.x * tmpvar_57.x) * tmpvar_61);
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_37.y;
    tmpvar_62.y = fetchesOffsetsV_36.x;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_58 + tmpvar_62);
    tmpvar_63.z = shadowCoord_34.z;
    lowp float tmpvar_64;
    tmpvar_64 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_38 = (shadow_38 + ((tmpvar_56.y * tmpvar_57.x) * tmpvar_64));
    highp vec2 tmpvar_65;
    tmpvar_65.x = fetchesOffsetsU_37.x;
    tmpvar_65.y = fetchesOffsetsV_36.y;
    highp vec3 tmpvar_66;
    tmpvar_66.xy = (tmpvar_58 + tmpvar_65);
    tmpvar_66.z = shadowCoord_34.z;
    lowp float tmpvar_67;
    tmpvar_67 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_66);
    shadow_38 = (shadow_38 + ((tmpvar_56.x * tmpvar_57.y) * tmpvar_67));
    highp vec2 tmpvar_68;
    tmpvar_68.x = fetchesOffsetsU_37.y;
    tmpvar_68.y = fetchesOffsetsV_36.y;
    highp vec3 tmpvar_69;
    tmpvar_69.xy = (tmpvar_58 + tmpvar_68);
    tmpvar_69.z = shadowCoord_34.z;
    lowp float tmpvar_70;
    tmpvar_70 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_69);
    shadow_38 = (shadow_38 + ((tmpvar_56.y * tmpvar_57.y) * tmpvar_70));
    tmpvar_35 = mix (1.0, shadow_38, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_71;
  highp vec3 tmpvar_72;
  tmpvar_71 = normalize((CAMERA_WORLDPOSITION - tmpvar_16));
  tmpvar_72 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_73;
  highp vec3 specularEnv_74;
  highp vec3 color_75;
  mediump float surfaceReduction_76;
  mediump float diffuseTerm_77;
  highp float perceptualRoughness_78;
  mediump vec3 tmpvar_79;
  mediump vec3 albedo_80;
  albedo_80 = tmpvar_3;
  mediump vec3 specColor_81;
  specColor_81 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_80 * tmpvar_4));
  mediump float tmpvar_82;
  tmpvar_82 = (0.7790837 - (tmpvar_4 * 0.7790837));
  tmpvar_79 = (albedo_80 * tmpvar_82);
  tmpvar_73 = 0.0;
  mediump float alpha_83;
  alpha_83 = tmpvar_73;
  tmpvar_73 = alpha_83;
  mediump float tmpvar_84;
  tmpvar_84 = (1.0 - tmpvar_5);
  perceptualRoughness_78 = tmpvar_84;
  highp vec3 tmpvar_85;
  highp vec3 inVec_86;
  inVec_86 = (tmpvar_72 + tmpvar_71);
  tmpvar_85 = (inVec_86 * inversesqrt(max (0.001, 
    dot (inVec_86, inVec_86)
  )));
  highp float tmpvar_87;
  tmpvar_87 = abs(dot (tmpvar_71, normalWorld_7));
  highp float tmpvar_88;
  tmpvar_88 = clamp (dot (normalWorld_7, tmpvar_72), 0.0, 1.0);
  highp float tmpvar_89;
  tmpvar_89 = clamp (dot (normalWorld_7, tmpvar_85), 0.0, 1.0);
  mediump float tmpvar_90;
  highp float tmpvar_91;
  tmpvar_91 = clamp (dot (tmpvar_72, tmpvar_85), 0.0, 1.0);
  tmpvar_90 = tmpvar_91;
  mediump float tmpvar_92;
  mediump float NdotV_93;
  NdotV_93 = tmpvar_87;
  mediump float NdotL_94;
  NdotL_94 = tmpvar_88;
  mediump float perceptualRoughness_95;
  perceptualRoughness_95 = perceptualRoughness_78;
  mediump float tmpvar_96;
  tmpvar_96 = (0.5 + ((2.0 * tmpvar_90) * (tmpvar_90 * perceptualRoughness_95)));
  mediump float x_97;
  x_97 = (1.0 - NdotL_94);
  mediump float x_98;
  x_98 = (1.0 - NdotV_93);
  tmpvar_92 = ((1.0 + (
    (tmpvar_96 - 1.0)
   * 
    ((x_97 * x_97) * ((x_97 * x_97) * x_97))
  )) * (1.0 + (
    (tmpvar_96 - 1.0)
   * 
    ((x_98 * x_98) * ((x_98 * x_98) * x_98))
  )));
  highp float tmpvar_99;
  tmpvar_99 = (tmpvar_92 * tmpvar_88);
  diffuseTerm_77 = tmpvar_99;
  highp float tmpvar_100;
  tmpvar_100 = max ((perceptualRoughness_78 * perceptualRoughness_78), 0.002);
  highp float tmpvar_101;
  tmpvar_101 = (tmpvar_100 * tmpvar_100);
  highp float tmpvar_102;
  tmpvar_102 = (((
    (tmpvar_89 * tmpvar_101)
   - tmpvar_89) * tmpvar_89) + 1.0);
  surfaceReduction_76 = (1.0 - ((0.28 * tmpvar_100) * perceptualRoughness_78));
  mediump vec3 tmpvar_103;
  mediump float x_104;
  x_104 = (1.0 - tmpvar_90);
  tmpvar_103 = (specColor_81 + ((1.0 - specColor_81) * (
    (x_104 * x_104)
   * 
    ((x_104 * x_104) * x_104)
  )));
  color_75 = (((
    (tmpvar_79 * LIGHT_COLOR)
   * diffuseTerm_77) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_101)
       / 
        ((tmpvar_102 * tmpvar_102) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_88 * (
          (tmpvar_87 * (1.0 - tmpvar_100))
         + tmpvar_100)) + (tmpvar_87 * (
          (tmpvar_88 * (1.0 - tmpvar_100))
         + tmpvar_100))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_88)) * LIGHT_COLOR)
   * tmpvar_103)) * tmpvar_35);
  color_75 = (color_75 + tmpvar_6);
  color_75 = (color_75 + (tmpvar_79 * rgbm_31.xyz));
  mediump float cosA_105;
  cosA_105 = tmpvar_87;
  mediump float tmpvar_106;
  mediump float x_107;
  x_107 = (1.0 - cosA_105);
  tmpvar_106 = ((x_107 * x_107) * ((x_107 * x_107) * x_107));
  mediump vec3 tmpvar_108;
  tmpvar_108 = (surfaceReduction_76 * ((specColor_81 * 
    (1.0 - tmpvar_106)
  ) + (vec3(
    clamp ((tmpvar_5 + (1.0 - tmpvar_82)), 0.0, 1.0)
  ) * tmpvar_106)));
  specularEnv_74 = tmpvar_108;
  color_75 = (color_75 + (specularEnv_74 * rgbm_24.xyz));
  outColor_2.xyz = color_75;
  lowp vec4 tmpvar_109;
  tmpvar_109 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_109;
  outColor_2.w = ((col_11.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IBLRotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shader_texture_lod : enable
#extension GL_EXT_shadow_samplers : enable
lowp vec4 impl_low_textureCubeLodEXT(lowp samplerCube sampler, highp vec3 coord, mediump float lod)
{
#if defined(GL_EXT_shader_texture_lod)
	return textureCubeLodEXT(sampler, coord, lod);
#else
	return textureCube(sampler, coord, lod);
#endif
}

uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _Opacity;
uniform highp vec3 _IBLRotation;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec3 normalWorld_7;
  highp vec3 normalTangent_8;
  highp vec3 emissionMapColor_9;
  highp vec2 mg_10;
  highp vec4 col_11;
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_11 = tmpvar_12;
  lowp vec2 tmpvar_13;
  tmpvar_13 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_10 = tmpvar_13;
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture2D (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_9 = tmpvar_14;
  lowp vec3 tmpvar_15;
  tmpvar_15 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_8 = tmpvar_15;
  normalTangent_8 = ((normalTangent_8 * 2.0) - 1.0);
  normalWorld_7 = normalize(((
    (normalTangent_8.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_8.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_8.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_16;
  tmpvar_16.x = xlv_TEXCOORD1.w;
  tmpvar_16.y = xlv_TEXCOORD2.w;
  tmpvar_16.z = xlv_TEXCOORD3.w;
  highp float tmpvar_17;
  tmpvar_17 = cos(_IBLRotation.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_IBLRotation.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_IBLRotation.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_IBLRotation.z);
  highp float tmpvar_21;
  tmpvar_21 = cos(_IBLRotation.x);
  highp float tmpvar_22;
  tmpvar_22 = sin(_IBLRotation.x);
  highp mat4 tmpvar_23;
  tmpvar_23[0].x = (tmpvar_17 * tmpvar_19);
  tmpvar_23[0].y = ((tmpvar_18 * tmpvar_22) - ((tmpvar_17 * tmpvar_20) * tmpvar_21));
  tmpvar_23[0].z = (((tmpvar_17 * tmpvar_20) * tmpvar_22) + (tmpvar_18 * tmpvar_21));
  tmpvar_23[0].w = 0.0;
  tmpvar_23[1].x = tmpvar_20;
  tmpvar_23[1].y = (tmpvar_19 * tmpvar_21);
  tmpvar_23[1].z = (-(tmpvar_19) * tmpvar_22);
  tmpvar_23[1].w = 0.0;
  tmpvar_23[2].x = (-(tmpvar_18) * tmpvar_19);
  tmpvar_23[2].y = (((tmpvar_18 * tmpvar_20) * tmpvar_21) + (tmpvar_17 * tmpvar_22));
  tmpvar_23[2].z = (((
    -(tmpvar_18)
   * tmpvar_20) * tmpvar_22) + (tmpvar_17 * tmpvar_21));
  tmpvar_23[2].w = 0.0;
  tmpvar_23[3].x = 0.0;
  tmpvar_23[3].y = 0.0;
  tmpvar_23[3].z = 0.0;
  tmpvar_23[3].w = 1.0;
  highp vec4 rgbm_24;
  highp vec3 I_25;
  I_25 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_16)));
  highp vec4 tmpvar_26;
  tmpvar_26.w = 0.0;
  tmpvar_26.xyz = (I_25 - (2.0 * (
    dot (normalWorld_7, I_25)
   * normalWorld_7)));
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize((tmpvar_23 * tmpvar_26).xyz);
  highp vec4 tmpvar_28;
  tmpvar_28.xyz = tmpvar_27;
  tmpvar_28.w = ((1.0 - (mg_10.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_29;
  tmpvar_29 = impl_low_textureCubeLodEXT (_GlossEnvMap, tmpvar_27, tmpvar_28.w);
  highp vec4 tmpvar_30;
  tmpvar_30 = tmpvar_29;
  rgbm_24.w = tmpvar_30.w;
  rgbm_24.xyz = ((tmpvar_30.xyz * tmpvar_30.w) * 6.0);
  highp vec4 rgbm_31;
  lowp vec4 tmpvar_32;
  tmpvar_32 = textureCube (_IrradianceMap, normalWorld_7);
  highp vec4 tmpvar_33;
  tmpvar_33 = tmpvar_32;
  rgbm_31.w = tmpvar_33.w;
  rgbm_31.xyz = ((tmpvar_33.xyz * tmpvar_33.w) * 6.0);
  tmpvar_3 = col_11.xyz;
  tmpvar_4 = (mg_10.x * _Metallic);
  tmpvar_5 = (mg_10.y * _Smoothness);
  tmpvar_6 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_9));
  highp vec4 shadowCoord_34;
  shadowCoord_34 = xlv_TEXCOORD4;
  highp float tmpvar_35;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_35 = 1.0;
  } else {
    shadowCoord_34.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_36;
    highp vec3 fetchesOffsetsU_37;
    highp float shadow_38;
    highp vec2 tmpvar_39;
    tmpvar_39 = (shadowCoord_34.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_40;
    tmpvar_40 = floor((tmpvar_39 + 0.5));
    highp vec2 tmpvar_41;
    tmpvar_41 = (tmpvar_39 - tmpvar_40);
    highp vec3 texelsWeightsA_42;
    highp vec3 texelsWeightsB_43;
    highp vec4 computedArea_44;
    highp vec4 computedAreaUncut_45;
    highp float tmpvar_46;
    tmpvar_46 = (((tmpvar_41.x + 0.5) * (tmpvar_41.x + 0.5)) * 0.5);
    highp float tmpvar_47;
    tmpvar_47 = (tmpvar_46 - tmpvar_41.x);
    computedArea_44.x = tmpvar_47;
    computedAreaUncut_45.x = tmpvar_47;
    computedArea_44.w = tmpvar_46;
    computedAreaUncut_45.w = tmpvar_46;
    computedAreaUncut_45.y = ((1.5 - tmpvar_41.x) - 0.5);
    highp float tmpvar_48;
    tmpvar_48 = min (tmpvar_41.x, 0.0);
    computedArea_44.y = (computedAreaUncut_45.y - (tmpvar_48 * tmpvar_48));
    computedAreaUncut_45.z = ((1.5 + tmpvar_41.x) - 0.5);
    highp float tmpvar_49;
    tmpvar_49 = max (tmpvar_41.x, 0.0);
    computedArea_44.z = (computedAreaUncut_45.z - (tmpvar_49 * tmpvar_49));
    texelsWeightsA_42.x = (0.16 * tmpvar_47);
    texelsWeightsA_42.y = (0.16 * computedAreaUncut_45.y);
    texelsWeightsA_42.z = (0.16 * (computedArea_44.y + 1.0));
    texelsWeightsB_43.x = (0.16 * (computedArea_44.z + 1.0));
    texelsWeightsB_43.y = (0.16 * computedAreaUncut_45.z);
    texelsWeightsB_43.z = (0.16 * tmpvar_46);
    highp vec3 texelsWeightsA_50;
    highp vec3 texelsWeightsB_51;
    highp vec4 computedArea_52;
    highp vec4 computedAreaUncut_53;
    highp float tmpvar_54;
    tmpvar_54 = (((tmpvar_41.y + 0.5) * (tmpvar_41.y + 0.5)) * 0.5);
    highp float tmpvar_55;
    tmpvar_55 = (tmpvar_54 - tmpvar_41.y);
    computedArea_52.x = tmpvar_55;
    computedAreaUncut_53.x = tmpvar_55;
    computedArea_52.w = tmpvar_54;
    computedAreaUncut_53.w = tmpvar_54;
    computedAreaUncut_53.y = ((1.5 - tmpvar_41.y) - 0.5);
    highp float tmpvar_56;
    tmpvar_56 = min (tmpvar_41.y, 0.0);
    computedArea_52.y = (computedAreaUncut_53.y - (tmpvar_56 * tmpvar_56));
    computedAreaUncut_53.z = ((1.5 + tmpvar_41.y) - 0.5);
    highp float tmpvar_57;
    tmpvar_57 = max (tmpvar_41.y, 0.0);
    computedArea_52.z = (computedAreaUncut_53.z - (tmpvar_57 * tmpvar_57));
    texelsWeightsA_50.x = (0.16 * tmpvar_55);
    texelsWeightsA_50.y = (0.16 * computedAreaUncut_53.y);
    texelsWeightsA_50.z = (0.16 * (computedArea_52.y + 1.0));
    texelsWeightsB_51.x = (0.16 * (computedArea_52.z + 1.0));
    texelsWeightsB_51.y = (0.16 * computedAreaUncut_53.z);
    texelsWeightsB_51.z = (0.16 * tmpvar_54);
    highp vec3 tmpvar_58;
    tmpvar_58.xy = texelsWeightsA_42.xz;
    tmpvar_58.z = texelsWeightsB_43.y;
    highp vec3 tmpvar_59;
    tmpvar_59.x = texelsWeightsA_42.y;
    tmpvar_59.yz = texelsWeightsB_43.xz;
    highp vec3 tmpvar_60;
    tmpvar_60 = (tmpvar_58 + tmpvar_59);
    highp vec3 tmpvar_61;
    tmpvar_61.xy = texelsWeightsA_50.xz;
    tmpvar_61.z = texelsWeightsB_51.y;
    highp vec3 tmpvar_62;
    tmpvar_62.x = texelsWeightsA_50.y;
    tmpvar_62.yz = texelsWeightsB_51.xz;
    highp vec3 tmpvar_63;
    tmpvar_63 = (tmpvar_61 + tmpvar_62);
    highp vec3 tmpvar_64;
    tmpvar_64.x = texelsWeightsA_42.y;
    tmpvar_64.yz = texelsWeightsB_43.xz;
    highp vec3 tmpvar_65;
    tmpvar_65.x = texelsWeightsA_50.y;
    tmpvar_65.yz = texelsWeightsB_51.xz;
    fetchesOffsetsU_37 = (((tmpvar_64 / tmpvar_60) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_36 = (((tmpvar_65 / tmpvar_63) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_66;
    tmpvar_66 = (tmpvar_40 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_37.x;
    tmpvar_67.y = fetchesOffsetsV_36.x;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_66 + tmpvar_67);
    tmpvar_68.z = shadowCoord_34.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_38 = ((tmpvar_60.x * tmpvar_63.x) * tmpvar_69);
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_37.y;
    tmpvar_70.y = fetchesOffsetsV_36.x;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_66 + tmpvar_70);
    tmpvar_71.z = shadowCoord_34.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_38 = (shadow_38 + ((tmpvar_60.y * tmpvar_63.x) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_37.z;
    tmpvar_73.y = fetchesOffsetsV_36.x;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_66 + tmpvar_73);
    tmpvar_74.z = shadowCoord_34.z;
    lowp float tmpvar_75;
    tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_38 = (shadow_38 + ((tmpvar_60.z * tmpvar_63.x) * tmpvar_75));
    highp vec2 tmpvar_76;
    tmpvar_76.x = fetchesOffsetsU_37.x;
    tmpvar_76.y = fetchesOffsetsV_36.y;
    highp vec3 tmpvar_77;
    tmpvar_77.xy = (tmpvar_66 + tmpvar_76);
    tmpvar_77.z = shadowCoord_34.z;
    lowp float tmpvar_78;
    tmpvar_78 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_77);
    shadow_38 = (shadow_38 + ((tmpvar_60.x * tmpvar_63.y) * tmpvar_78));
    highp vec2 tmpvar_79;
    tmpvar_79.x = fetchesOffsetsU_37.y;
    tmpvar_79.y = fetchesOffsetsV_36.y;
    highp vec3 tmpvar_80;
    tmpvar_80.xy = (tmpvar_66 + tmpvar_79);
    tmpvar_80.z = shadowCoord_34.z;
    lowp float tmpvar_81;
    tmpvar_81 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_80);
    shadow_38 = (shadow_38 + ((tmpvar_60.y * tmpvar_63.y) * tmpvar_81));
    highp vec2 tmpvar_82;
    tmpvar_82.x = fetchesOffsetsU_37.z;
    tmpvar_82.y = fetchesOffsetsV_36.y;
    highp vec3 tmpvar_83;
    tmpvar_83.xy = (tmpvar_66 + tmpvar_82);
    tmpvar_83.z = shadowCoord_34.z;
    lowp float tmpvar_84;
    tmpvar_84 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_83);
    shadow_38 = (shadow_38 + ((tmpvar_60.z * tmpvar_63.y) * tmpvar_84));
    highp vec2 tmpvar_85;
    tmpvar_85.x = fetchesOffsetsU_37.x;
    tmpvar_85.y = fetchesOffsetsV_36.z;
    highp vec3 tmpvar_86;
    tmpvar_86.xy = (tmpvar_66 + tmpvar_85);
    tmpvar_86.z = shadowCoord_34.z;
    lowp float tmpvar_87;
    tmpvar_87 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_86);
    shadow_38 = (shadow_38 + ((tmpvar_60.x * tmpvar_63.z) * tmpvar_87));
    highp vec2 tmpvar_88;
    tmpvar_88.x = fetchesOffsetsU_37.y;
    tmpvar_88.y = fetchesOffsetsV_36.z;
    highp vec3 tmpvar_89;
    tmpvar_89.xy = (tmpvar_66 + tmpvar_88);
    tmpvar_89.z = shadowCoord_34.z;
    lowp float tmpvar_90;
    tmpvar_90 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_89);
    shadow_38 = (shadow_38 + ((tmpvar_60.y * tmpvar_63.z) * tmpvar_90));
    highp vec2 tmpvar_91;
    tmpvar_91.x = fetchesOffsetsU_37.z;
    tmpvar_91.y = fetchesOffsetsV_36.z;
    highp vec3 tmpvar_92;
    tmpvar_92.xy = (tmpvar_66 + tmpvar_91);
    tmpvar_92.z = shadowCoord_34.z;
    lowp float tmpvar_93;
    tmpvar_93 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_92);
    shadow_38 = (shadow_38 + ((tmpvar_60.z * tmpvar_63.z) * tmpvar_93));
    tmpvar_35 = mix (1.0, shadow_38, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_94;
  highp vec3 tmpvar_95;
  tmpvar_94 = normalize((CAMERA_WORLDPOSITION - tmpvar_16));
  tmpvar_95 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_96;
  highp vec3 specularEnv_97;
  highp vec3 color_98;
  mediump float surfaceReduction_99;
  mediump float diffuseTerm_100;
  highp float perceptualRoughness_101;
  mediump vec3 tmpvar_102;
  mediump vec3 albedo_103;
  albedo_103 = tmpvar_3;
  mediump vec3 specColor_104;
  specColor_104 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_103 * tmpvar_4));
  mediump float tmpvar_105;
  tmpvar_105 = (0.7790837 - (tmpvar_4 * 0.7790837));
  tmpvar_102 = (albedo_103 * tmpvar_105);
  tmpvar_96 = 0.0;
  mediump float alpha_106;
  alpha_106 = tmpvar_96;
  tmpvar_96 = alpha_106;
  mediump float tmpvar_107;
  tmpvar_107 = (1.0 - tmpvar_5);
  perceptualRoughness_101 = tmpvar_107;
  highp vec3 tmpvar_108;
  highp vec3 inVec_109;
  inVec_109 = (tmpvar_95 + tmpvar_94);
  tmpvar_108 = (inVec_109 * inversesqrt(max (0.001, 
    dot (inVec_109, inVec_109)
  )));
  highp float tmpvar_110;
  tmpvar_110 = abs(dot (tmpvar_94, normalWorld_7));
  highp float tmpvar_111;
  tmpvar_111 = clamp (dot (normalWorld_7, tmpvar_95), 0.0, 1.0);
  highp float tmpvar_112;
  tmpvar_112 = clamp (dot (normalWorld_7, tmpvar_108), 0.0, 1.0);
  mediump float tmpvar_113;
  highp float tmpvar_114;
  tmpvar_114 = clamp (dot (tmpvar_95, tmpvar_108), 0.0, 1.0);
  tmpvar_113 = tmpvar_114;
  mediump float tmpvar_115;
  mediump float NdotV_116;
  NdotV_116 = tmpvar_110;
  mediump float NdotL_117;
  NdotL_117 = tmpvar_111;
  mediump float perceptualRoughness_118;
  perceptualRoughness_118 = perceptualRoughness_101;
  mediump float tmpvar_119;
  tmpvar_119 = (0.5 + ((2.0 * tmpvar_113) * (tmpvar_113 * perceptualRoughness_118)));
  mediump float x_120;
  x_120 = (1.0 - NdotL_117);
  mediump float x_121;
  x_121 = (1.0 - NdotV_116);
  tmpvar_115 = ((1.0 + (
    (tmpvar_119 - 1.0)
   * 
    ((x_120 * x_120) * ((x_120 * x_120) * x_120))
  )) * (1.0 + (
    (tmpvar_119 - 1.0)
   * 
    ((x_121 * x_121) * ((x_121 * x_121) * x_121))
  )));
  highp float tmpvar_122;
  tmpvar_122 = (tmpvar_115 * tmpvar_111);
  diffuseTerm_100 = tmpvar_122;
  highp float tmpvar_123;
  tmpvar_123 = max ((perceptualRoughness_101 * perceptualRoughness_101), 0.002);
  highp float tmpvar_124;
  tmpvar_124 = (tmpvar_123 * tmpvar_123);
  highp float tmpvar_125;
  tmpvar_125 = (((
    (tmpvar_112 * tmpvar_124)
   - tmpvar_112) * tmpvar_112) + 1.0);
  surfaceReduction_99 = (1.0 - ((0.28 * tmpvar_123) * perceptualRoughness_101));
  mediump vec3 tmpvar_126;
  mediump float x_127;
  x_127 = (1.0 - tmpvar_113);
  tmpvar_126 = (specColor_104 + ((1.0 - specColor_104) * (
    (x_127 * x_127)
   * 
    ((x_127 * x_127) * x_127)
  )));
  color_98 = (((
    (tmpvar_102 * LIGHT_COLOR)
   * diffuseTerm_100) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_124)
       / 
        ((tmpvar_125 * tmpvar_125) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_111 * (
          (tmpvar_110 * (1.0 - tmpvar_123))
         + tmpvar_123)) + (tmpvar_110 * (
          (tmpvar_111 * (1.0 - tmpvar_123))
         + tmpvar_123))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_111)) * LIGHT_COLOR)
   * tmpvar_126)) * tmpvar_35);
  color_98 = (color_98 + tmpvar_6);
  color_98 = (color_98 + (tmpvar_102 * rgbm_31.xyz));
  mediump float cosA_128;
  cosA_128 = tmpvar_110;
  mediump float tmpvar_129;
  mediump float x_130;
  x_130 = (1.0 - cosA_128);
  tmpvar_129 = ((x_130 * x_130) * ((x_130 * x_130) * x_130));
  mediump vec3 tmpvar_131;
  tmpvar_131 = (surfaceReduction_99 * ((specColor_104 * 
    (1.0 - tmpvar_129)
  ) + (vec3(
    clamp ((tmpvar_5 + (1.0 - tmpvar_105)), 0.0, 1.0)
  ) * tmpvar_129)));
  specularEnv_97 = tmpvar_131;
  color_98 = (color_98 + (specularEnv_97 * rgbm_24.xyz));
  outColor_2.xyz = color_98;
  lowp vec4 tmpvar_132;
  tmpvar_132 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_132;
  outColor_2.w = ((col_11.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IBLRotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shader_texture_lod : enable
#extension GL_EXT_shadow_samplers : enable
lowp vec4 impl_low_textureCubeLodEXT(lowp samplerCube sampler, highp vec3 coord, mediump float lod)
{
#if defined(GL_EXT_shader_texture_lod)
	return textureCubeLodEXT(sampler, coord, lod);
#else
	return textureCube(sampler, coord, lod);
#endif
}

uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _Opacity;
uniform highp vec3 _IBLRotation;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec3 normalWorld_7;
  highp vec3 normalTangent_8;
  highp vec3 emissionMapColor_9;
  highp vec2 mg_10;
  highp vec4 col_11;
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_11 = tmpvar_12;
  lowp vec2 tmpvar_13;
  tmpvar_13 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_10 = tmpvar_13;
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture2D (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_9 = tmpvar_14;
  lowp vec3 tmpvar_15;
  tmpvar_15 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_8 = tmpvar_15;
  normalTangent_8 = ((normalTangent_8 * 2.0) - 1.0);
  normalWorld_7 = normalize(((
    (normalTangent_8.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_8.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_8.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_16;
  tmpvar_16.x = xlv_TEXCOORD1.w;
  tmpvar_16.y = xlv_TEXCOORD2.w;
  tmpvar_16.z = xlv_TEXCOORD3.w;
  highp float tmpvar_17;
  tmpvar_17 = cos(_IBLRotation.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_IBLRotation.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_IBLRotation.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_IBLRotation.z);
  highp float tmpvar_21;
  tmpvar_21 = cos(_IBLRotation.x);
  highp float tmpvar_22;
  tmpvar_22 = sin(_IBLRotation.x);
  highp mat4 tmpvar_23;
  tmpvar_23[0].x = (tmpvar_17 * tmpvar_19);
  tmpvar_23[0].y = ((tmpvar_18 * tmpvar_22) - ((tmpvar_17 * tmpvar_20) * tmpvar_21));
  tmpvar_23[0].z = (((tmpvar_17 * tmpvar_20) * tmpvar_22) + (tmpvar_18 * tmpvar_21));
  tmpvar_23[0].w = 0.0;
  tmpvar_23[1].x = tmpvar_20;
  tmpvar_23[1].y = (tmpvar_19 * tmpvar_21);
  tmpvar_23[1].z = (-(tmpvar_19) * tmpvar_22);
  tmpvar_23[1].w = 0.0;
  tmpvar_23[2].x = (-(tmpvar_18) * tmpvar_19);
  tmpvar_23[2].y = (((tmpvar_18 * tmpvar_20) * tmpvar_21) + (tmpvar_17 * tmpvar_22));
  tmpvar_23[2].z = (((
    -(tmpvar_18)
   * tmpvar_20) * tmpvar_22) + (tmpvar_17 * tmpvar_21));
  tmpvar_23[2].w = 0.0;
  tmpvar_23[3].x = 0.0;
  tmpvar_23[3].y = 0.0;
  tmpvar_23[3].z = 0.0;
  tmpvar_23[3].w = 1.0;
  highp vec4 rgbm_24;
  highp vec3 I_25;
  I_25 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_16)));
  highp vec4 tmpvar_26;
  tmpvar_26.w = 0.0;
  tmpvar_26.xyz = (I_25 - (2.0 * (
    dot (normalWorld_7, I_25)
   * normalWorld_7)));
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize((tmpvar_23 * tmpvar_26).xyz);
  highp vec4 tmpvar_28;
  tmpvar_28.xyz = tmpvar_27;
  tmpvar_28.w = ((1.0 - (mg_10.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_29;
  tmpvar_29 = impl_low_textureCubeLodEXT (_GlossEnvMap, tmpvar_27, tmpvar_28.w);
  highp vec4 tmpvar_30;
  tmpvar_30 = tmpvar_29;
  rgbm_24.w = tmpvar_30.w;
  rgbm_24.xyz = ((tmpvar_30.xyz * tmpvar_30.w) * 6.0);
  highp vec4 rgbm_31;
  lowp vec4 tmpvar_32;
  tmpvar_32 = textureCube (_IrradianceMap, normalWorld_7);
  highp vec4 tmpvar_33;
  tmpvar_33 = tmpvar_32;
  rgbm_31.w = tmpvar_33.w;
  rgbm_31.xyz = ((tmpvar_33.xyz * tmpvar_33.w) * 6.0);
  tmpvar_3 = col_11.xyz;
  tmpvar_4 = (mg_10.x * _Metallic);
  tmpvar_5 = (mg_10.y * _Smoothness);
  tmpvar_6 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_9));
  highp vec4 shadowCoord_34;
  shadowCoord_34 = xlv_TEXCOORD4;
  highp float tmpvar_35;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_35 = 1.0;
  } else {
    shadowCoord_34.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_36;
    highp vec4 fetchesOffsetsU_37;
    highp float shadow_38;
    highp vec2 tmpvar_39;
    tmpvar_39 = (shadowCoord_34.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_40;
    tmpvar_40 = floor((tmpvar_39 + 0.5));
    highp vec2 tmpvar_41;
    tmpvar_41 = (tmpvar_39 - tmpvar_40);
    highp vec4 texelsWeightsA_42;
    highp vec4 texelsWeightsB_43;
    highp vec4 computedArea_44;
    highp vec4 computedAreaUncut_45;
    highp float tmpvar_46;
    tmpvar_46 = (((tmpvar_41.x + 0.5) * (tmpvar_41.x + 0.5)) * 0.5);
    highp float tmpvar_47;
    tmpvar_47 = (tmpvar_46 - tmpvar_41.x);
    computedArea_44.x = tmpvar_47;
    computedAreaUncut_45.x = tmpvar_47;
    computedArea_44.w = tmpvar_46;
    computedAreaUncut_45.w = tmpvar_46;
    computedAreaUncut_45.y = ((1.5 - tmpvar_41.x) - 0.5);
    highp float tmpvar_48;
    tmpvar_48 = min (tmpvar_41.x, 0.0);
    computedArea_44.y = (computedAreaUncut_45.y - (tmpvar_48 * tmpvar_48));
    computedAreaUncut_45.z = ((1.5 + tmpvar_41.x) - 0.5);
    highp float tmpvar_49;
    tmpvar_49 = max (tmpvar_41.x, 0.0);
    computedArea_44.z = (computedAreaUncut_45.z - (tmpvar_49 * tmpvar_49));
    texelsWeightsA_42.x = (0.081632 * tmpvar_47);
    texelsWeightsA_42.y = (0.081632 * computedAreaUncut_45.y);
    texelsWeightsA_42.z = (0.081632 * (computedAreaUncut_45.y + 1.0));
    texelsWeightsA_42.w = (0.081632 * (computedArea_44.y + 2.0));
    texelsWeightsB_43.x = (0.081632 * (computedArea_44.z + 2.0));
    texelsWeightsB_43.y = (0.081632 * (computedAreaUncut_45.z + 1.0));
    texelsWeightsB_43.z = (0.081632 * computedAreaUncut_45.z);
    texelsWeightsB_43.w = (0.081632 * tmpvar_46);
    highp vec4 texelsWeightsA_50;
    highp vec4 texelsWeightsB_51;
    highp vec4 computedArea_52;
    highp vec4 computedAreaUncut_53;
    highp float tmpvar_54;
    tmpvar_54 = (((tmpvar_41.y + 0.5) * (tmpvar_41.y + 0.5)) * 0.5);
    highp float tmpvar_55;
    tmpvar_55 = (tmpvar_54 - tmpvar_41.y);
    computedArea_52.x = tmpvar_55;
    computedAreaUncut_53.x = tmpvar_55;
    computedArea_52.w = tmpvar_54;
    computedAreaUncut_53.w = tmpvar_54;
    computedAreaUncut_53.y = ((1.5 - tmpvar_41.y) - 0.5);
    highp float tmpvar_56;
    tmpvar_56 = min (tmpvar_41.y, 0.0);
    computedArea_52.y = (computedAreaUncut_53.y - (tmpvar_56 * tmpvar_56));
    computedAreaUncut_53.z = ((1.5 + tmpvar_41.y) - 0.5);
    highp float tmpvar_57;
    tmpvar_57 = max (tmpvar_41.y, 0.0);
    computedArea_52.z = (computedAreaUncut_53.z - (tmpvar_57 * tmpvar_57));
    texelsWeightsA_50.x = (0.081632 * tmpvar_55);
    texelsWeightsA_50.y = (0.081632 * computedAreaUncut_53.y);
    texelsWeightsA_50.z = (0.081632 * (computedAreaUncut_53.y + 1.0));
    texelsWeightsA_50.w = (0.081632 * (computedArea_52.y + 2.0));
    texelsWeightsB_51.x = (0.081632 * (computedArea_52.z + 2.0));
    texelsWeightsB_51.y = (0.081632 * (computedAreaUncut_53.z + 1.0));
    texelsWeightsB_51.z = (0.081632 * computedAreaUncut_53.z);
    texelsWeightsB_51.w = (0.081632 * tmpvar_54);
    highp vec4 tmpvar_58;
    tmpvar_58.xy = texelsWeightsA_42.xz;
    tmpvar_58.zw = texelsWeightsB_43.xz;
    highp vec4 tmpvar_59;
    tmpvar_59.xy = texelsWeightsA_42.yw;
    tmpvar_59.zw = texelsWeightsB_43.yw;
    highp vec4 tmpvar_60;
    tmpvar_60 = (tmpvar_58 + tmpvar_59);
    highp vec4 tmpvar_61;
    tmpvar_61.xy = texelsWeightsA_50.xz;
    tmpvar_61.zw = texelsWeightsB_51.xz;
    highp vec4 tmpvar_62;
    tmpvar_62.xy = texelsWeightsA_50.yw;
    tmpvar_62.zw = texelsWeightsB_51.yw;
    highp vec4 tmpvar_63;
    tmpvar_63 = (tmpvar_61 + tmpvar_62);
    highp vec4 tmpvar_64;
    tmpvar_64.xy = texelsWeightsA_42.yw;
    tmpvar_64.zw = texelsWeightsB_43.yw;
    highp vec4 tmpvar_65;
    tmpvar_65.xy = texelsWeightsA_50.yw;
    tmpvar_65.zw = texelsWeightsB_51.yw;
    fetchesOffsetsU_37 = (((tmpvar_64 / tmpvar_60) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_36 = (((tmpvar_65 / tmpvar_63) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_66;
    tmpvar_66 = (tmpvar_40 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_67;
    tmpvar_67.x = fetchesOffsetsU_37.x;
    tmpvar_67.y = fetchesOffsetsV_36.x;
    highp vec3 tmpvar_68;
    tmpvar_68.xy = (tmpvar_66 + tmpvar_67);
    tmpvar_68.z = shadowCoord_34.z;
    lowp float tmpvar_69;
    tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
    shadow_38 = ((tmpvar_60.x * tmpvar_63.x) * tmpvar_69);
    highp vec2 tmpvar_70;
    tmpvar_70.x = fetchesOffsetsU_37.y;
    tmpvar_70.y = fetchesOffsetsV_36.x;
    highp vec3 tmpvar_71;
    tmpvar_71.xy = (tmpvar_66 + tmpvar_70);
    tmpvar_71.z = shadowCoord_34.z;
    lowp float tmpvar_72;
    tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
    shadow_38 = (shadow_38 + ((tmpvar_60.y * tmpvar_63.x) * tmpvar_72));
    highp vec2 tmpvar_73;
    tmpvar_73.x = fetchesOffsetsU_37.z;
    tmpvar_73.y = fetchesOffsetsV_36.x;
    highp vec3 tmpvar_74;
    tmpvar_74.xy = (tmpvar_66 + tmpvar_73);
    tmpvar_74.z = shadowCoord_34.z;
    lowp float tmpvar_75;
    tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
    shadow_38 = (shadow_38 + ((tmpvar_60.z * tmpvar_63.x) * tmpvar_75));
    highp vec2 tmpvar_76;
    tmpvar_76.x = fetchesOffsetsU_37.w;
    tmpvar_76.y = fetchesOffsetsV_36.x;
    highp vec3 tmpvar_77;
    tmpvar_77.xy = (tmpvar_66 + tmpvar_76);
    tmpvar_77.z = shadowCoord_34.z;
    lowp float tmpvar_78;
    tmpvar_78 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_77);
    shadow_38 = (shadow_38 + ((tmpvar_60.w * tmpvar_63.x) * tmpvar_78));
    highp vec2 tmpvar_79;
    tmpvar_79.x = fetchesOffsetsU_37.x;
    tmpvar_79.y = fetchesOffsetsV_36.y;
    highp vec3 tmpvar_80;
    tmpvar_80.xy = (tmpvar_66 + tmpvar_79);
    tmpvar_80.z = shadowCoord_34.z;
    lowp float tmpvar_81;
    tmpvar_81 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_80);
    shadow_38 = (shadow_38 + ((tmpvar_60.x * tmpvar_63.y) * tmpvar_81));
    highp vec2 tmpvar_82;
    tmpvar_82.x = fetchesOffsetsU_37.y;
    tmpvar_82.y = fetchesOffsetsV_36.y;
    highp vec3 tmpvar_83;
    tmpvar_83.xy = (tmpvar_66 + tmpvar_82);
    tmpvar_83.z = shadowCoord_34.z;
    lowp float tmpvar_84;
    tmpvar_84 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_83);
    shadow_38 = (shadow_38 + ((tmpvar_60.y * tmpvar_63.y) * tmpvar_84));
    highp vec2 tmpvar_85;
    tmpvar_85.x = fetchesOffsetsU_37.z;
    tmpvar_85.y = fetchesOffsetsV_36.y;
    highp vec3 tmpvar_86;
    tmpvar_86.xy = (tmpvar_66 + tmpvar_85);
    tmpvar_86.z = shadowCoord_34.z;
    lowp float tmpvar_87;
    tmpvar_87 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_86);
    shadow_38 = (shadow_38 + ((tmpvar_60.z * tmpvar_63.y) * tmpvar_87));
    highp vec2 tmpvar_88;
    tmpvar_88.x = fetchesOffsetsU_37.w;
    tmpvar_88.y = fetchesOffsetsV_36.y;
    highp vec3 tmpvar_89;
    tmpvar_89.xy = (tmpvar_66 + tmpvar_88);
    tmpvar_89.z = shadowCoord_34.z;
    lowp float tmpvar_90;
    tmpvar_90 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_89);
    shadow_38 = (shadow_38 + ((tmpvar_60.w * tmpvar_63.y) * tmpvar_90));
    highp vec2 tmpvar_91;
    tmpvar_91.x = fetchesOffsetsU_37.x;
    tmpvar_91.y = fetchesOffsetsV_36.z;
    highp vec3 tmpvar_92;
    tmpvar_92.xy = (tmpvar_66 + tmpvar_91);
    tmpvar_92.z = shadowCoord_34.z;
    lowp float tmpvar_93;
    tmpvar_93 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_92);
    shadow_38 = (shadow_38 + ((tmpvar_60.x * tmpvar_63.z) * tmpvar_93));
    highp vec2 tmpvar_94;
    tmpvar_94.x = fetchesOffsetsU_37.y;
    tmpvar_94.y = fetchesOffsetsV_36.z;
    highp vec3 tmpvar_95;
    tmpvar_95.xy = (tmpvar_66 + tmpvar_94);
    tmpvar_95.z = shadowCoord_34.z;
    lowp float tmpvar_96;
    tmpvar_96 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_95);
    shadow_38 = (shadow_38 + ((tmpvar_60.y * tmpvar_63.z) * tmpvar_96));
    highp vec2 tmpvar_97;
    tmpvar_97.x = fetchesOffsetsU_37.z;
    tmpvar_97.y = fetchesOffsetsV_36.z;
    highp vec3 tmpvar_98;
    tmpvar_98.xy = (tmpvar_66 + tmpvar_97);
    tmpvar_98.z = shadowCoord_34.z;
    lowp float tmpvar_99;
    tmpvar_99 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_98);
    shadow_38 = (shadow_38 + ((tmpvar_60.z * tmpvar_63.z) * tmpvar_99));
    highp vec2 tmpvar_100;
    tmpvar_100.x = fetchesOffsetsU_37.w;
    tmpvar_100.y = fetchesOffsetsV_36.z;
    highp vec3 tmpvar_101;
    tmpvar_101.xy = (tmpvar_66 + tmpvar_100);
    tmpvar_101.z = shadowCoord_34.z;
    lowp float tmpvar_102;
    tmpvar_102 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_101);
    shadow_38 = (shadow_38 + ((tmpvar_60.w * tmpvar_63.z) * tmpvar_102));
    highp vec2 tmpvar_103;
    tmpvar_103.x = fetchesOffsetsU_37.x;
    tmpvar_103.y = fetchesOffsetsV_36.w;
    highp vec3 tmpvar_104;
    tmpvar_104.xy = (tmpvar_66 + tmpvar_103);
    tmpvar_104.z = shadowCoord_34.z;
    lowp float tmpvar_105;
    tmpvar_105 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_104);
    shadow_38 = (shadow_38 + ((tmpvar_60.x * tmpvar_63.w) * tmpvar_105));
    highp vec2 tmpvar_106;
    tmpvar_106.x = fetchesOffsetsU_37.y;
    tmpvar_106.y = fetchesOffsetsV_36.w;
    highp vec3 tmpvar_107;
    tmpvar_107.xy = (tmpvar_66 + tmpvar_106);
    tmpvar_107.z = shadowCoord_34.z;
    lowp float tmpvar_108;
    tmpvar_108 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_107);
    shadow_38 = (shadow_38 + ((tmpvar_60.y * tmpvar_63.w) * tmpvar_108));
    highp vec2 tmpvar_109;
    tmpvar_109.x = fetchesOffsetsU_37.z;
    tmpvar_109.y = fetchesOffsetsV_36.w;
    highp vec3 tmpvar_110;
    tmpvar_110.xy = (tmpvar_66 + tmpvar_109);
    tmpvar_110.z = shadowCoord_34.z;
    lowp float tmpvar_111;
    tmpvar_111 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_110);
    shadow_38 = (shadow_38 + ((tmpvar_60.z * tmpvar_63.w) * tmpvar_111));
    highp vec2 tmpvar_112;
    tmpvar_112.x = fetchesOffsetsU_37.w;
    tmpvar_112.y = fetchesOffsetsV_36.w;
    highp vec3 tmpvar_113;
    tmpvar_113.xy = (tmpvar_66 + tmpvar_112);
    tmpvar_113.z = shadowCoord_34.z;
    lowp float tmpvar_114;
    tmpvar_114 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_113);
    shadow_38 = (shadow_38 + ((tmpvar_60.w * tmpvar_63.w) * tmpvar_114));
    tmpvar_35 = mix (1.0, shadow_38, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_115;
  highp vec3 tmpvar_116;
  tmpvar_115 = normalize((CAMERA_WORLDPOSITION - tmpvar_16));
  tmpvar_116 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_117;
  highp vec3 specularEnv_118;
  highp vec3 color_119;
  mediump float surfaceReduction_120;
  mediump float diffuseTerm_121;
  highp float perceptualRoughness_122;
  mediump vec3 tmpvar_123;
  mediump vec3 albedo_124;
  albedo_124 = tmpvar_3;
  mediump vec3 specColor_125;
  specColor_125 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_124 * tmpvar_4));
  mediump float tmpvar_126;
  tmpvar_126 = (0.7790837 - (tmpvar_4 * 0.7790837));
  tmpvar_123 = (albedo_124 * tmpvar_126);
  tmpvar_117 = 0.0;
  mediump float alpha_127;
  alpha_127 = tmpvar_117;
  tmpvar_117 = alpha_127;
  mediump float tmpvar_128;
  tmpvar_128 = (1.0 - tmpvar_5);
  perceptualRoughness_122 = tmpvar_128;
  highp vec3 tmpvar_129;
  highp vec3 inVec_130;
  inVec_130 = (tmpvar_116 + tmpvar_115);
  tmpvar_129 = (inVec_130 * inversesqrt(max (0.001, 
    dot (inVec_130, inVec_130)
  )));
  highp float tmpvar_131;
  tmpvar_131 = abs(dot (tmpvar_115, normalWorld_7));
  highp float tmpvar_132;
  tmpvar_132 = clamp (dot (normalWorld_7, tmpvar_116), 0.0, 1.0);
  highp float tmpvar_133;
  tmpvar_133 = clamp (dot (normalWorld_7, tmpvar_129), 0.0, 1.0);
  mediump float tmpvar_134;
  highp float tmpvar_135;
  tmpvar_135 = clamp (dot (tmpvar_116, tmpvar_129), 0.0, 1.0);
  tmpvar_134 = tmpvar_135;
  mediump float tmpvar_136;
  mediump float NdotV_137;
  NdotV_137 = tmpvar_131;
  mediump float NdotL_138;
  NdotL_138 = tmpvar_132;
  mediump float perceptualRoughness_139;
  perceptualRoughness_139 = perceptualRoughness_122;
  mediump float tmpvar_140;
  tmpvar_140 = (0.5 + ((2.0 * tmpvar_134) * (tmpvar_134 * perceptualRoughness_139)));
  mediump float x_141;
  x_141 = (1.0 - NdotL_138);
  mediump float x_142;
  x_142 = (1.0 - NdotV_137);
  tmpvar_136 = ((1.0 + (
    (tmpvar_140 - 1.0)
   * 
    ((x_141 * x_141) * ((x_141 * x_141) * x_141))
  )) * (1.0 + (
    (tmpvar_140 - 1.0)
   * 
    ((x_142 * x_142) * ((x_142 * x_142) * x_142))
  )));
  highp float tmpvar_143;
  tmpvar_143 = (tmpvar_136 * tmpvar_132);
  diffuseTerm_121 = tmpvar_143;
  highp float tmpvar_144;
  tmpvar_144 = max ((perceptualRoughness_122 * perceptualRoughness_122), 0.002);
  highp float tmpvar_145;
  tmpvar_145 = (tmpvar_144 * tmpvar_144);
  highp float tmpvar_146;
  tmpvar_146 = (((
    (tmpvar_133 * tmpvar_145)
   - tmpvar_133) * tmpvar_133) + 1.0);
  surfaceReduction_120 = (1.0 - ((0.28 * tmpvar_144) * perceptualRoughness_122));
  mediump vec3 tmpvar_147;
  mediump float x_148;
  x_148 = (1.0 - tmpvar_134);
  tmpvar_147 = (specColor_125 + ((1.0 - specColor_125) * (
    (x_148 * x_148)
   * 
    ((x_148 * x_148) * x_148)
  )));
  color_119 = (((
    (tmpvar_123 * LIGHT_COLOR)
   * diffuseTerm_121) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_145)
       / 
        ((tmpvar_146 * tmpvar_146) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_132 * (
          (tmpvar_131 * (1.0 - tmpvar_144))
         + tmpvar_144)) + (tmpvar_131 * (
          (tmpvar_132 * (1.0 - tmpvar_144))
         + tmpvar_144))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_132)) * LIGHT_COLOR)
   * tmpvar_147)) * tmpvar_35);
  color_119 = (color_119 + tmpvar_6);
  color_119 = (color_119 + (tmpvar_123 * rgbm_31.xyz));
  mediump float cosA_149;
  cosA_149 = tmpvar_131;
  mediump float tmpvar_150;
  mediump float x_151;
  x_151 = (1.0 - cosA_149);
  tmpvar_150 = ((x_151 * x_151) * ((x_151 * x_151) * x_151));
  mediump vec3 tmpvar_152;
  tmpvar_152 = (surfaceReduction_120 * ((specColor_125 * 
    (1.0 - tmpvar_150)
  ) + (vec3(
    clamp ((tmpvar_5 + (1.0 - tmpvar_126)), 0.0, 1.0)
  ) * tmpvar_150)));
  specularEnv_118 = tmpvar_152;
  color_119 = (color_119 + (specularEnv_118 * rgbm_24.xyz));
  outColor_2.xyz = color_119;
  lowp vec4 tmpvar_153;
  tmpvar_153 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_153;
  outColor_2.w = ((col_11.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMBIENT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GlossEnvMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IrradianceMap",
				varType = "samplerCube",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EmissionColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_IBLRotation",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shader_texture_lod : enable
lowp vec4 impl_low_textureCubeLodEXT(lowp samplerCube sampler, highp vec3 coord, mediump float lod)
{
#if defined(GL_EXT_shader_texture_lod)
	return textureCubeLodEXT(sampler, coord, lod);
#else
	return textureCube(sampler, coord, lod);
#endif
}

uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform sampler2D _EmissionMap;
uniform lowp samplerCube _GlossEnvMap;
uniform lowp samplerCube _IrradianceMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp vec4 _EmissionColor;
uniform highp float _Opacity;
uniform highp vec3 _IBLRotation;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec3 normalWorld_7;
  highp vec3 normalTangent_8;
  highp vec3 emissionMapColor_9;
  highp vec2 mg_10;
  highp vec4 col_11;
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_11 = tmpvar_12;
  lowp vec2 tmpvar_13;
  tmpvar_13 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_10 = tmpvar_13;
  lowp vec3 tmpvar_14;
  tmpvar_14 = texture2D (_EmissionMap, xlv_TEXCOORD0).xyz;
  emissionMapColor_9 = tmpvar_14;
  lowp vec3 tmpvar_15;
  tmpvar_15 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_8 = tmpvar_15;
  normalTangent_8 = ((normalTangent_8 * 2.0) - 1.0);
  normalWorld_7 = normalize(((
    (normalTangent_8.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_8.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_8.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_16;
  tmpvar_16.x = xlv_TEXCOORD1.w;
  tmpvar_16.y = xlv_TEXCOORD2.w;
  tmpvar_16.z = xlv_TEXCOORD3.w;
  highp float tmpvar_17;
  tmpvar_17 = cos(_IBLRotation.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_IBLRotation.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_IBLRotation.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_IBLRotation.z);
  highp float tmpvar_21;
  tmpvar_21 = cos(_IBLRotation.x);
  highp float tmpvar_22;
  tmpvar_22 = sin(_IBLRotation.x);
  highp mat4 tmpvar_23;
  tmpvar_23[0].x = (tmpvar_17 * tmpvar_19);
  tmpvar_23[0].y = ((tmpvar_18 * tmpvar_22) - ((tmpvar_17 * tmpvar_20) * tmpvar_21));
  tmpvar_23[0].z = (((tmpvar_17 * tmpvar_20) * tmpvar_22) + (tmpvar_18 * tmpvar_21));
  tmpvar_23[0].w = 0.0;
  tmpvar_23[1].x = tmpvar_20;
  tmpvar_23[1].y = (tmpvar_19 * tmpvar_21);
  tmpvar_23[1].z = (-(tmpvar_19) * tmpvar_22);
  tmpvar_23[1].w = 0.0;
  tmpvar_23[2].x = (-(tmpvar_18) * tmpvar_19);
  tmpvar_23[2].y = (((tmpvar_18 * tmpvar_20) * tmpvar_21) + (tmpvar_17 * tmpvar_22));
  tmpvar_23[2].z = (((
    -(tmpvar_18)
   * tmpvar_20) * tmpvar_22) + (tmpvar_17 * tmpvar_21));
  tmpvar_23[2].w = 0.0;
  tmpvar_23[3].x = 0.0;
  tmpvar_23[3].y = 0.0;
  tmpvar_23[3].z = 0.0;
  tmpvar_23[3].w = 1.0;
  highp vec4 rgbm_24;
  highp vec3 I_25;
  I_25 = -(normalize((CAMERA_WORLDPOSITION - tmpvar_16)));
  highp vec4 tmpvar_26;
  tmpvar_26.w = 0.0;
  tmpvar_26.xyz = (I_25 - (2.0 * (
    dot (normalWorld_7, I_25)
   * normalWorld_7)));
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize((tmpvar_23 * tmpvar_26).xyz);
  highp vec4 tmpvar_28;
  tmpvar_28.xyz = tmpvar_27;
  tmpvar_28.w = ((1.0 - (mg_10.y * _Smoothness)) * 6.0);
  lowp vec4 tmpvar_29;
  tmpvar_29 = impl_low_textureCubeLodEXT (_GlossEnvMap, tmpvar_27, tmpvar_28.w);
  highp vec4 tmpvar_30;
  tmpvar_30 = tmpvar_29;
  rgbm_24.w = tmpvar_30.w;
  rgbm_24.xyz = ((tmpvar_30.xyz * tmpvar_30.w) * 6.0);
  highp vec4 rgbm_31;
  lowp vec4 tmpvar_32;
  tmpvar_32 = textureCube (_IrradianceMap, normalWorld_7);
  highp vec4 tmpvar_33;
  tmpvar_33 = tmpvar_32;
  rgbm_31.w = tmpvar_33.w;
  rgbm_31.xyz = ((tmpvar_33.xyz * tmpvar_33.w) * 6.0);
  tmpvar_3 = col_11.xyz;
  tmpvar_4 = (mg_10.x * _Metallic);
  tmpvar_5 = (mg_10.y * _Smoothness);
  tmpvar_6 = (AMBIENT_COLOR + (_EmissionColor.xyz * emissionMapColor_9));
  highp vec4 shadowCoord_34;
  shadowCoord_34 = xlv_TEXCOORD4;
  highp float tmpvar_35;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_35 = 1.0;
  } else {
    highp vec2 tmpvar_36;
    tmpvar_36.x = LIGHT_PARAM.z;
    tmpvar_36.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_37;
    tmpvar_37.xy = tmpvar_36;
    highp float tmpvar_38;
    tmpvar_38 = (1.0/(LIGHT_PARAM.z));
    tmpvar_37.z = tmpvar_38;
    tmpvar_37.w = tmpvar_38;
    shadowCoord_34.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_39;
    highp vec2 tmpvar_40;
    tmpvar_40 = tmpvar_37.xy;
    shadow_39 = 0.0;
    highp vec3 tmpvar_41;
    tmpvar_41.xy = (shadowCoord_34.xy - LIGHT_PARAM.zz);
    tmpvar_41.z = shadowCoord_34.z;
    highp vec4 tmpvar_42;
    tmpvar_42 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_41.xy);
    highp float tmpvar_43;
    if ((tmpvar_42.x < xlv_TEXCOORD4.z)) {
      tmpvar_43 = 0.0;
    } else {
      tmpvar_43 = 1.0;
    };
    shadow_39 = tmpvar_43;
    highp vec2 tmpvar_44;
    tmpvar_44.x = 0.0;
    tmpvar_44.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_45;
    tmpvar_45.xy = (shadowCoord_34.xy + tmpvar_44);
    tmpvar_45.z = shadowCoord_34.z;
    highp vec4 tmpvar_46;
    tmpvar_46 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_45.xy);
    highp float tmpvar_47;
    if ((tmpvar_46.x < xlv_TEXCOORD4.z)) {
      tmpvar_47 = 0.0;
    } else {
      tmpvar_47 = 1.0;
    };
    shadow_39 = (tmpvar_43 + tmpvar_47);
    highp vec2 tmpvar_48;
    tmpvar_48.x = tmpvar_40.x;
    tmpvar_48.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (shadowCoord_34.xy + tmpvar_48);
    tmpvar_49.z = shadowCoord_34.z;
    highp vec4 tmpvar_50;
    tmpvar_50 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_49.xy);
    highp float tmpvar_51;
    if ((tmpvar_50.x < xlv_TEXCOORD4.z)) {
      tmpvar_51 = 0.0;
    } else {
      tmpvar_51 = 1.0;
    };
    shadow_39 = (shadow_39 + tmpvar_51);
    highp vec2 tmpvar_52;
    tmpvar_52.y = 0.0;
    tmpvar_52.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_53;
    tmpvar_53.xy = (shadowCoord_34.xy + tmpvar_52);
    tmpvar_53.z = shadowCoord_34.z;
    highp vec4 tmpvar_54;
    tmpvar_54 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_53.xy);
    highp float tmpvar_55;
    if ((tmpvar_54.x < xlv_TEXCOORD4.z)) {
      tmpvar_55 = 0.0;
    } else {
      tmpvar_55 = 1.0;
    };
    shadow_39 = (shadow_39 + tmpvar_55);
    highp vec4 tmpvar_56;
    tmpvar_56 = texture2D (TEXTURE_SHADOW_DEPTH, shadowCoord_34.xy);
    highp float tmpvar_57;
    if ((tmpvar_56.x < xlv_TEXCOORD4.z)) {
      tmpvar_57 = 0.0;
    } else {
      tmpvar_57 = 1.0;
    };
    shadow_39 = (shadow_39 + tmpvar_57);
    highp vec2 tmpvar_58;
    tmpvar_58.y = 0.0;
    tmpvar_58.x = tmpvar_40.x;
    highp vec3 tmpvar_59;
    tmpvar_59.xy = (shadowCoord_34.xy + tmpvar_58);
    tmpvar_59.z = shadowCoord_34.z;
    highp vec4 tmpvar_60;
    tmpvar_60 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_59.xy);
    highp float tmpvar_61;
    if ((tmpvar_60.x < xlv_TEXCOORD4.z)) {
      tmpvar_61 = 0.0;
    } else {
      tmpvar_61 = 1.0;
    };
    shadow_39 = (shadow_39 + tmpvar_61);
    highp vec2 tmpvar_62;
    tmpvar_62.x = -(LIGHT_PARAM.z);
    tmpvar_62.y = tmpvar_40.y;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (shadowCoord_34.xy + tmpvar_62);
    tmpvar_63.z = shadowCoord_34.z;
    highp vec4 tmpvar_64;
    tmpvar_64 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_63.xy);
    highp float tmpvar_65;
    if ((tmpvar_64.x < xlv_TEXCOORD4.z)) {
      tmpvar_65 = 0.0;
    } else {
      tmpvar_65 = 1.0;
    };
    shadow_39 = (shadow_39 + tmpvar_65);
    highp vec2 tmpvar_66;
    tmpvar_66.x = 0.0;
    tmpvar_66.y = tmpvar_40.y;
    highp vec3 tmpvar_67;
    tmpvar_67.xy = (shadowCoord_34.xy + tmpvar_66);
    tmpvar_67.z = shadowCoord_34.z;
    highp vec4 tmpvar_68;
    tmpvar_68 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_67.xy);
    highp float tmpvar_69;
    if ((tmpvar_68.x < xlv_TEXCOORD4.z)) {
      tmpvar_69 = 0.0;
    } else {
      tmpvar_69 = 1.0;
    };
    shadow_39 = (shadow_39 + tmpvar_69);
    highp vec3 tmpvar_70;
    tmpvar_70.xy = (shadowCoord_34.xy + LIGHT_PARAM.zz);
    tmpvar_70.z = shadowCoord_34.z;
    highp vec4 tmpvar_71;
    tmpvar_71 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_70.xy);
    highp float tmpvar_72;
    if ((tmpvar_71.x < xlv_TEXCOORD4.z)) {
      tmpvar_72 = 0.0;
    } else {
      tmpvar_72 = 1.0;
    };
    shadow_39 = (shadow_39 + tmpvar_72);
    shadow_39 = (shadow_39 / 9.0);
    tmpvar_35 = mix (1.0, shadow_39, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_73;
  highp vec3 tmpvar_74;
  tmpvar_73 = normalize((CAMERA_WORLDPOSITION - tmpvar_16));
  tmpvar_74 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_75;
  highp vec3 specularEnv_76;
  highp vec3 color_77;
  mediump float surfaceReduction_78;
  mediump float diffuseTerm_79;
  highp float perceptualRoughness_80;
  mediump vec3 tmpvar_81;
  mediump vec3 albedo_82;
  albedo_82 = tmpvar_3;
  mediump vec3 specColor_83;
  specColor_83 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_82 * tmpvar_4));
  mediump float tmpvar_84;
  tmpvar_84 = (0.7790837 - (tmpvar_4 * 0.7790837));
  tmpvar_81 = (albedo_82 * tmpvar_84);
  tmpvar_75 = 0.0;
  mediump float alpha_85;
  alpha_85 = tmpvar_75;
  tmpvar_75 = alpha_85;
  mediump float tmpvar_86;
  tmpvar_86 = (1.0 - tmpvar_5);
  perceptualRoughness_80 = tmpvar_86;
  highp vec3 tmpvar_87;
  highp vec3 inVec_88;
  inVec_88 = (tmpvar_74 + tmpvar_73);
  tmpvar_87 = (inVec_88 * inversesqrt(max (0.001, 
    dot (inVec_88, inVec_88)
  )));
  highp float tmpvar_89;
  tmpvar_89 = abs(dot (tmpvar_73, normalWorld_7));
  highp float tmpvar_90;
  tmpvar_90 = clamp (dot (normalWorld_7, tmpvar_74), 0.0, 1.0);
  highp float tmpvar_91;
  tmpvar_91 = clamp (dot (normalWorld_7, tmpvar_87), 0.0, 1.0);
  mediump float tmpvar_92;
  highp float tmpvar_93;
  tmpvar_93 = clamp (dot (tmpvar_74, tmpvar_87), 0.0, 1.0);
  tmpvar_92 = tmpvar_93;
  mediump float tmpvar_94;
  mediump float NdotV_95;
  NdotV_95 = tmpvar_89;
  mediump float NdotL_96;
  NdotL_96 = tmpvar_90;
  mediump float perceptualRoughness_97;
  perceptualRoughness_97 = perceptualRoughness_80;
  mediump float tmpvar_98;
  tmpvar_98 = (0.5 + ((2.0 * tmpvar_92) * (tmpvar_92 * perceptualRoughness_97)));
  mediump float x_99;
  x_99 = (1.0 - NdotL_96);
  mediump float x_100;
  x_100 = (1.0 - NdotV_95);
  tmpvar_94 = ((1.0 + (
    (tmpvar_98 - 1.0)
   * 
    ((x_99 * x_99) * ((x_99 * x_99) * x_99))
  )) * (1.0 + (
    (tmpvar_98 - 1.0)
   * 
    ((x_100 * x_100) * ((x_100 * x_100) * x_100))
  )));
  highp float tmpvar_101;
  tmpvar_101 = (tmpvar_94 * tmpvar_90);
  diffuseTerm_79 = tmpvar_101;
  highp float tmpvar_102;
  tmpvar_102 = max ((perceptualRoughness_80 * perceptualRoughness_80), 0.002);
  highp float tmpvar_103;
  tmpvar_103 = (tmpvar_102 * tmpvar_102);
  highp float tmpvar_104;
  tmpvar_104 = (((
    (tmpvar_91 * tmpvar_103)
   - tmpvar_91) * tmpvar_91) + 1.0);
  surfaceReduction_78 = (1.0 - ((0.28 * tmpvar_102) * perceptualRoughness_80));
  mediump vec3 tmpvar_105;
  mediump float x_106;
  x_106 = (1.0 - tmpvar_92);
  tmpvar_105 = (specColor_83 + ((1.0 - specColor_83) * (
    (x_106 * x_106)
   * 
    ((x_106 * x_106) * x_106)
  )));
  color_77 = (((
    (tmpvar_81 * LIGHT_COLOR)
   * diffuseTerm_79) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_103)
       / 
        ((tmpvar_104 * tmpvar_104) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_90 * (
          (tmpvar_89 * (1.0 - tmpvar_102))
         + tmpvar_102)) + (tmpvar_89 * (
          (tmpvar_90 * (1.0 - tmpvar_102))
         + tmpvar_102))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_90)) * LIGHT_COLOR)
   * tmpvar_105)) * tmpvar_35);
  color_77 = (color_77 + tmpvar_6);
  color_77 = (color_77 + (tmpvar_81 * rgbm_31.xyz));
  mediump float cosA_107;
  cosA_107 = tmpvar_89;
  mediump float tmpvar_108;
  mediump float x_109;
  x_109 = (1.0 - cosA_107);
  tmpvar_108 = ((x_109 * x_109) * ((x_109 * x_109) * x_109));
  mediump vec3 tmpvar_110;
  tmpvar_110 = (surfaceReduction_78 * ((specColor_83 * 
    (1.0 - tmpvar_108)
  ) + (vec3(
    clamp ((tmpvar_5 + (1.0 - tmpvar_84)), 0.0, 1.0)
  ) * tmpvar_108)));
  specularEnv_76 = tmpvar_110;
  color_77 = (color_77 + (specularEnv_76 * rgbm_24.xyz));
  outColor_2.xyz = color_77;
  lowp vec4 tmpvar_111;
  tmpvar_111 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_111;
  outColor_2.w = ((col_11.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
}


end

function ForwardAdd()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { "%_BlendState", "%_BlendSrc", ONE, ONE, ONE }
DRAW_MODE = { "%_CullMode", DEPTH_MASK_ON, "%_DepthState", "%_DepthFc" }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDADD }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = tmpvar_11[0].xyz;
  tmpvar_15[1] = tmpvar_11[1].xyz;
  tmpvar_15[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_16[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_16[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = tmpvar_11[0].xyz;
  tmpvar_17[1] = tmpvar_11[1].xyz;
  tmpvar_17[2] = tmpvar_11[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_11[0].xyz;
  tmpvar_19[1] = tmpvar_11[1].xyz;
  tmpvar_19[2] = tmpvar_11[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_3 = col_8.xyz;
  tmpvar_4 = (mg_7.x * _Metallic);
  tmpvar_5 = (mg_7.y * _Smoothness);
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  tmpvar_13 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  tmpvar_14 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_16;
  mediump float diffuseTerm_17;
  highp float perceptualRoughness_18;
  mediump vec3 tmpvar_19;
  mediump vec3 albedo_20;
  albedo_20 = tmpvar_3;
  mediump vec3 specColor_21;
  specColor_21 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_20 * tmpvar_4));
  tmpvar_19 = (albedo_20 * (0.7790837 - (tmpvar_4 * 0.7790837)));
  tmpvar_16 = 0.0;
  mediump float alpha_22;
  alpha_22 = tmpvar_16;
  tmpvar_16 = alpha_22;
  mediump float tmpvar_23;
  tmpvar_23 = (1.0 - tmpvar_5);
  perceptualRoughness_18 = tmpvar_23;
  highp vec3 tmpvar_24;
  highp vec3 inVec_25;
  inVec_25 = (tmpvar_14 + tmpvar_13);
  tmpvar_24 = (inVec_25 * inversesqrt(max (0.001, 
    dot (inVec_25, inVec_25)
  )));
  highp float tmpvar_26;
  tmpvar_26 = abs(dot (tmpvar_13, tmpvar_15));
  highp float tmpvar_27;
  tmpvar_27 = clamp (dot (tmpvar_15, tmpvar_14), 0.0, 1.0);
  highp float tmpvar_28;
  tmpvar_28 = clamp (dot (tmpvar_15, tmpvar_24), 0.0, 1.0);
  mediump float tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = clamp (dot (tmpvar_14, tmpvar_24), 0.0, 1.0);
  tmpvar_29 = tmpvar_30;
  mediump float tmpvar_31;
  mediump float NdotV_32;
  NdotV_32 = tmpvar_26;
  mediump float NdotL_33;
  NdotL_33 = tmpvar_27;
  mediump float perceptualRoughness_34;
  perceptualRoughness_34 = perceptualRoughness_18;
  mediump float tmpvar_35;
  tmpvar_35 = (0.5 + ((2.0 * tmpvar_29) * (tmpvar_29 * perceptualRoughness_34)));
  mediump float x_36;
  x_36 = (1.0 - NdotL_33);
  mediump float x_37;
  x_37 = (1.0 - NdotV_32);
  tmpvar_31 = ((1.0 + (
    (tmpvar_35 - 1.0)
   * 
    ((x_36 * x_36) * ((x_36 * x_36) * x_36))
  )) * (1.0 + (
    (tmpvar_35 - 1.0)
   * 
    ((x_37 * x_37) * ((x_37 * x_37) * x_37))
  )));
  highp float tmpvar_38;
  tmpvar_38 = (tmpvar_31 * tmpvar_27);
  diffuseTerm_17 = tmpvar_38;
  highp float tmpvar_39;
  tmpvar_39 = max ((perceptualRoughness_18 * perceptualRoughness_18), 0.002);
  highp float tmpvar_40;
  tmpvar_40 = (tmpvar_39 * tmpvar_39);
  highp float tmpvar_41;
  tmpvar_41 = (((
    (tmpvar_28 * tmpvar_40)
   - tmpvar_28) * tmpvar_28) + 1.0);
  mediump vec3 tmpvar_42;
  mediump float x_43;
  x_43 = (1.0 - tmpvar_29);
  tmpvar_42 = (specColor_21 + ((1.0 - specColor_21) * (
    (x_43 * x_43)
   * 
    ((x_43 * x_43) * x_43)
  )));
  outColor_2.xyz = (((tmpvar_19 * LIGHT_COLOR) * diffuseTerm_17) + ((
    max (0.0, (sqrt(max (0.0001, 
      ((((0.3183099 * tmpvar_40) / (
        (tmpvar_41 * tmpvar_41)
       + 1e-7)) * (0.5 / (
        ((tmpvar_27 * ((tmpvar_26 * 
          (1.0 - tmpvar_39)
        ) + tmpvar_39)) + (tmpvar_26 * ((tmpvar_27 * 
          (1.0 - tmpvar_39)
        ) + tmpvar_39)))
       + 0.0001))) * 3.141593)
    )) * tmpvar_27))
   * LIGHT_COLOR) * tmpvar_42));
  lowp vec4 tmpvar_44;
  tmpvar_44 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_44;
  outColor_2.w = ((col_8.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec3 normalTangent_7;
  highp vec2 mg_8;
  highp vec4 col_9;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_9 = tmpvar_10;
  lowp vec2 tmpvar_11;
  tmpvar_11 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_8 = tmpvar_11;
  lowp vec3 tmpvar_12;
  tmpvar_12 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_7 = tmpvar_12;
  normalTangent_7 = ((normalTangent_7 * 2.0) - 1.0);
  tmpvar_3 = col_9.xyz;
  tmpvar_4 = (mg_8.x * _Metallic);
  tmpvar_5 = (mg_8.y * _Smoothness);
  tmpvar_6 = normalize(((
    (normalTangent_7.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_7.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_13;
  tmpvar_13.x = xlv_TEXCOORD1.w;
  tmpvar_13.y = xlv_TEXCOORD2.w;
  tmpvar_13.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_14;
  shadowCoord_14 = xlv_TEXCOORD4;
  highp float tmpvar_15;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_15 = 1.0;
  } else {
    shadowCoord_14.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_16;
    highp vec2 fetchesOffsetsU_17;
    highp float shadow_18;
    highp vec2 tmpvar_19;
    tmpvar_19 = (shadowCoord_14.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_20;
    tmpvar_20 = floor((tmpvar_19 + 0.5));
    highp vec2 tmpvar_21;
    tmpvar_21 = (tmpvar_19 - tmpvar_20);
    highp vec4 computedWeight_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_21.x + 0.5) * (tmpvar_21.x + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_21.x);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_21.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_21.x, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_21.x) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_21.x, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    computedWeight_22 = (computedArea_23 * 0.44444);
    highp vec4 computedWeight_29;
    highp vec4 computedArea_30;
    highp vec4 computedAreaUncut_31;
    highp float tmpvar_32;
    tmpvar_32 = (((tmpvar_21.y + 0.5) * (tmpvar_21.y + 0.5)) * 0.5);
    highp float tmpvar_33;
    tmpvar_33 = (tmpvar_32 - tmpvar_21.y);
    computedArea_30.x = tmpvar_33;
    computedAreaUncut_31.x = tmpvar_33;
    computedArea_30.w = tmpvar_32;
    computedAreaUncut_31.w = tmpvar_32;
    computedAreaUncut_31.y = ((1.5 - tmpvar_21.y) - 0.5);
    highp float tmpvar_34;
    tmpvar_34 = min (tmpvar_21.y, 0.0);
    computedArea_30.y = (computedAreaUncut_31.y - (tmpvar_34 * tmpvar_34));
    computedAreaUncut_31.z = ((1.5 + tmpvar_21.y) - 0.5);
    highp float tmpvar_35;
    tmpvar_35 = max (tmpvar_21.y, 0.0);
    computedArea_30.z = (computedAreaUncut_31.z - (tmpvar_35 * tmpvar_35));
    computedWeight_29 = (computedArea_30 * 0.44444);
    highp vec2 tmpvar_36;
    tmpvar_36 = (computedWeight_22.xz + computedWeight_22.yw);
    highp vec2 tmpvar_37;
    tmpvar_37 = (computedWeight_29.xz + computedWeight_29.yw);
    fetchesOffsetsU_17 = (((computedWeight_22.yw / tmpvar_36) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_16 = (((computedWeight_29.yw / tmpvar_37) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_38;
    tmpvar_38 = (tmpvar_20 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_39;
    tmpvar_39.x = fetchesOffsetsU_17.x;
    tmpvar_39.y = fetchesOffsetsV_16.x;
    highp vec3 tmpvar_40;
    tmpvar_40.xy = (tmpvar_38 + tmpvar_39);
    tmpvar_40.z = shadowCoord_14.z;
    lowp float tmpvar_41;
    tmpvar_41 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_40);
    shadow_18 = ((tmpvar_36.x * tmpvar_37.x) * tmpvar_41);
    highp vec2 tmpvar_42;
    tmpvar_42.x = fetchesOffsetsU_17.y;
    tmpvar_42.y = fetchesOffsetsV_16.x;
    highp vec3 tmpvar_43;
    tmpvar_43.xy = (tmpvar_38 + tmpvar_42);
    tmpvar_43.z = shadowCoord_14.z;
    lowp float tmpvar_44;
    tmpvar_44 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_43);
    shadow_18 = (shadow_18 + ((tmpvar_36.y * tmpvar_37.x) * tmpvar_44));
    highp vec2 tmpvar_45;
    tmpvar_45.x = fetchesOffsetsU_17.x;
    tmpvar_45.y = fetchesOffsetsV_16.y;
    highp vec3 tmpvar_46;
    tmpvar_46.xy = (tmpvar_38 + tmpvar_45);
    tmpvar_46.z = shadowCoord_14.z;
    lowp float tmpvar_47;
    tmpvar_47 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_46);
    shadow_18 = (shadow_18 + ((tmpvar_36.x * tmpvar_37.y) * tmpvar_47));
    highp vec2 tmpvar_48;
    tmpvar_48.x = fetchesOffsetsU_17.y;
    tmpvar_48.y = fetchesOffsetsV_16.y;
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (tmpvar_38 + tmpvar_48);
    tmpvar_49.z = shadowCoord_14.z;
    lowp float tmpvar_50;
    tmpvar_50 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_49);
    shadow_18 = (shadow_18 + ((tmpvar_36.y * tmpvar_37.y) * tmpvar_50));
    tmpvar_15 = mix (1.0, shadow_18, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_51;
  highp vec3 tmpvar_52;
  tmpvar_51 = normalize((CAMERA_WORLDPOSITION - tmpvar_13));
  tmpvar_52 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_53;
  mediump float diffuseTerm_54;
  highp float perceptualRoughness_55;
  mediump vec3 tmpvar_56;
  mediump vec3 albedo_57;
  albedo_57 = tmpvar_3;
  mediump vec3 specColor_58;
  specColor_58 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_57 * tmpvar_4));
  tmpvar_56 = (albedo_57 * (0.7790837 - (tmpvar_4 * 0.7790837)));
  tmpvar_53 = 0.0;
  mediump float alpha_59;
  alpha_59 = tmpvar_53;
  tmpvar_53 = alpha_59;
  mediump float tmpvar_60;
  tmpvar_60 = (1.0 - tmpvar_5);
  perceptualRoughness_55 = tmpvar_60;
  highp vec3 tmpvar_61;
  highp vec3 inVec_62;
  inVec_62 = (tmpvar_52 + tmpvar_51);
  tmpvar_61 = (inVec_62 * inversesqrt(max (0.001, 
    dot (inVec_62, inVec_62)
  )));
  highp float tmpvar_63;
  tmpvar_63 = abs(dot (tmpvar_51, tmpvar_6));
  highp float tmpvar_64;
  tmpvar_64 = clamp (dot (tmpvar_6, tmpvar_52), 0.0, 1.0);
  highp float tmpvar_65;
  tmpvar_65 = clamp (dot (tmpvar_6, tmpvar_61), 0.0, 1.0);
  mediump float tmpvar_66;
  highp float tmpvar_67;
  tmpvar_67 = clamp (dot (tmpvar_52, tmpvar_61), 0.0, 1.0);
  tmpvar_66 = tmpvar_67;
  mediump float tmpvar_68;
  mediump float NdotV_69;
  NdotV_69 = tmpvar_63;
  mediump float NdotL_70;
  NdotL_70 = tmpvar_64;
  mediump float perceptualRoughness_71;
  perceptualRoughness_71 = perceptualRoughness_55;
  mediump float tmpvar_72;
  tmpvar_72 = (0.5 + ((2.0 * tmpvar_66) * (tmpvar_66 * perceptualRoughness_71)));
  mediump float x_73;
  x_73 = (1.0 - NdotL_70);
  mediump float x_74;
  x_74 = (1.0 - NdotV_69);
  tmpvar_68 = ((1.0 + (
    (tmpvar_72 - 1.0)
   * 
    ((x_73 * x_73) * ((x_73 * x_73) * x_73))
  )) * (1.0 + (
    (tmpvar_72 - 1.0)
   * 
    ((x_74 * x_74) * ((x_74 * x_74) * x_74))
  )));
  highp float tmpvar_75;
  tmpvar_75 = (tmpvar_68 * tmpvar_64);
  diffuseTerm_54 = tmpvar_75;
  highp float tmpvar_76;
  tmpvar_76 = max ((perceptualRoughness_55 * perceptualRoughness_55), 0.002);
  highp float tmpvar_77;
  tmpvar_77 = (tmpvar_76 * tmpvar_76);
  highp float tmpvar_78;
  tmpvar_78 = (((
    (tmpvar_65 * tmpvar_77)
   - tmpvar_65) * tmpvar_65) + 1.0);
  mediump vec3 tmpvar_79;
  mediump float x_80;
  x_80 = (1.0 - tmpvar_66);
  tmpvar_79 = (specColor_58 + ((1.0 - specColor_58) * (
    (x_80 * x_80)
   * 
    ((x_80 * x_80) * x_80)
  )));
  outColor_2.xyz = (((
    (tmpvar_56 * LIGHT_COLOR)
   * diffuseTerm_54) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_77)
       / 
        ((tmpvar_78 * tmpvar_78) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_64 * (
          (tmpvar_63 * (1.0 - tmpvar_76))
         + tmpvar_76)) + (tmpvar_63 * (
          (tmpvar_64 * (1.0 - tmpvar_76))
         + tmpvar_76))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_64)) * LIGHT_COLOR)
   * tmpvar_79)) * tmpvar_15);
  lowp vec4 tmpvar_81;
  tmpvar_81 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_81;
  outColor_2.w = ((col_9.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec3 normalTangent_7;
  highp vec2 mg_8;
  highp vec4 col_9;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_9 = tmpvar_10;
  lowp vec2 tmpvar_11;
  tmpvar_11 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_8 = tmpvar_11;
  lowp vec3 tmpvar_12;
  tmpvar_12 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_7 = tmpvar_12;
  normalTangent_7 = ((normalTangent_7 * 2.0) - 1.0);
  tmpvar_3 = col_9.xyz;
  tmpvar_4 = (mg_8.x * _Metallic);
  tmpvar_5 = (mg_8.y * _Smoothness);
  tmpvar_6 = normalize(((
    (normalTangent_7.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_7.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_13;
  tmpvar_13.x = xlv_TEXCOORD1.w;
  tmpvar_13.y = xlv_TEXCOORD2.w;
  tmpvar_13.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_14;
  shadowCoord_14 = xlv_TEXCOORD4;
  highp float tmpvar_15;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_15 = 1.0;
  } else {
    shadowCoord_14.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_16;
    highp vec3 fetchesOffsetsU_17;
    highp float shadow_18;
    highp vec2 tmpvar_19;
    tmpvar_19 = (shadowCoord_14.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_20;
    tmpvar_20 = floor((tmpvar_19 + 0.5));
    highp vec2 tmpvar_21;
    tmpvar_21 = (tmpvar_19 - tmpvar_20);
    highp vec3 texelsWeightsA_22;
    highp vec3 texelsWeightsB_23;
    highp vec4 computedArea_24;
    highp vec4 computedAreaUncut_25;
    highp float tmpvar_26;
    tmpvar_26 = (((tmpvar_21.x + 0.5) * (tmpvar_21.x + 0.5)) * 0.5);
    highp float tmpvar_27;
    tmpvar_27 = (tmpvar_26 - tmpvar_21.x);
    computedArea_24.x = tmpvar_27;
    computedAreaUncut_25.x = tmpvar_27;
    computedArea_24.w = tmpvar_26;
    computedAreaUncut_25.w = tmpvar_26;
    computedAreaUncut_25.y = ((1.5 - tmpvar_21.x) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = min (tmpvar_21.x, 0.0);
    computedArea_24.y = (computedAreaUncut_25.y - (tmpvar_28 * tmpvar_28));
    computedAreaUncut_25.z = ((1.5 + tmpvar_21.x) - 0.5);
    highp float tmpvar_29;
    tmpvar_29 = max (tmpvar_21.x, 0.0);
    computedArea_24.z = (computedAreaUncut_25.z - (tmpvar_29 * tmpvar_29));
    texelsWeightsA_22.x = (0.16 * tmpvar_27);
    texelsWeightsA_22.y = (0.16 * computedAreaUncut_25.y);
    texelsWeightsA_22.z = (0.16 * (computedArea_24.y + 1.0));
    texelsWeightsB_23.x = (0.16 * (computedArea_24.z + 1.0));
    texelsWeightsB_23.y = (0.16 * computedAreaUncut_25.z);
    texelsWeightsB_23.z = (0.16 * tmpvar_26);
    highp vec3 texelsWeightsA_30;
    highp vec3 texelsWeightsB_31;
    highp vec4 computedArea_32;
    highp vec4 computedAreaUncut_33;
    highp float tmpvar_34;
    tmpvar_34 = (((tmpvar_21.y + 0.5) * (tmpvar_21.y + 0.5)) * 0.5);
    highp float tmpvar_35;
    tmpvar_35 = (tmpvar_34 - tmpvar_21.y);
    computedArea_32.x = tmpvar_35;
    computedAreaUncut_33.x = tmpvar_35;
    computedArea_32.w = tmpvar_34;
    computedAreaUncut_33.w = tmpvar_34;
    computedAreaUncut_33.y = ((1.5 - tmpvar_21.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = min (tmpvar_21.y, 0.0);
    computedArea_32.y = (computedAreaUncut_33.y - (tmpvar_36 * tmpvar_36));
    computedAreaUncut_33.z = ((1.5 + tmpvar_21.y) - 0.5);
    highp float tmpvar_37;
    tmpvar_37 = max (tmpvar_21.y, 0.0);
    computedArea_32.z = (computedAreaUncut_33.z - (tmpvar_37 * tmpvar_37));
    texelsWeightsA_30.x = (0.16 * tmpvar_35);
    texelsWeightsA_30.y = (0.16 * computedAreaUncut_33.y);
    texelsWeightsA_30.z = (0.16 * (computedArea_32.y + 1.0));
    texelsWeightsB_31.x = (0.16 * (computedArea_32.z + 1.0));
    texelsWeightsB_31.y = (0.16 * computedAreaUncut_33.z);
    texelsWeightsB_31.z = (0.16 * tmpvar_34);
    highp vec3 tmpvar_38;
    tmpvar_38.xy = texelsWeightsA_22.xz;
    tmpvar_38.z = texelsWeightsB_23.y;
    highp vec3 tmpvar_39;
    tmpvar_39.x = texelsWeightsA_22.y;
    tmpvar_39.yz = texelsWeightsB_23.xz;
    highp vec3 tmpvar_40;
    tmpvar_40 = (tmpvar_38 + tmpvar_39);
    highp vec3 tmpvar_41;
    tmpvar_41.xy = texelsWeightsA_30.xz;
    tmpvar_41.z = texelsWeightsB_31.y;
    highp vec3 tmpvar_42;
    tmpvar_42.x = texelsWeightsA_30.y;
    tmpvar_42.yz = texelsWeightsB_31.xz;
    highp vec3 tmpvar_43;
    tmpvar_43 = (tmpvar_41 + tmpvar_42);
    highp vec3 tmpvar_44;
    tmpvar_44.x = texelsWeightsA_22.y;
    tmpvar_44.yz = texelsWeightsB_23.xz;
    highp vec3 tmpvar_45;
    tmpvar_45.x = texelsWeightsA_30.y;
    tmpvar_45.yz = texelsWeightsB_31.xz;
    fetchesOffsetsU_17 = (((tmpvar_44 / tmpvar_40) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_16 = (((tmpvar_45 / tmpvar_43) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_46;
    tmpvar_46 = (tmpvar_20 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_17.x;
    tmpvar_47.y = fetchesOffsetsV_16.x;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_46 + tmpvar_47);
    tmpvar_48.z = shadowCoord_14.z;
    lowp float tmpvar_49;
    tmpvar_49 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_18 = ((tmpvar_40.x * tmpvar_43.x) * tmpvar_49);
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_17.y;
    tmpvar_50.y = fetchesOffsetsV_16.x;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_46 + tmpvar_50);
    tmpvar_51.z = shadowCoord_14.z;
    lowp float tmpvar_52;
    tmpvar_52 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_18 = (shadow_18 + ((tmpvar_40.y * tmpvar_43.x) * tmpvar_52));
    highp vec2 tmpvar_53;
    tmpvar_53.x = fetchesOffsetsU_17.z;
    tmpvar_53.y = fetchesOffsetsV_16.x;
    highp vec3 tmpvar_54;
    tmpvar_54.xy = (tmpvar_46 + tmpvar_53);
    tmpvar_54.z = shadowCoord_14.z;
    lowp float tmpvar_55;
    tmpvar_55 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_54);
    shadow_18 = (shadow_18 + ((tmpvar_40.z * tmpvar_43.x) * tmpvar_55));
    highp vec2 tmpvar_56;
    tmpvar_56.x = fetchesOffsetsU_17.x;
    tmpvar_56.y = fetchesOffsetsV_16.y;
    highp vec3 tmpvar_57;
    tmpvar_57.xy = (tmpvar_46 + tmpvar_56);
    tmpvar_57.z = shadowCoord_14.z;
    lowp float tmpvar_58;
    tmpvar_58 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_57);
    shadow_18 = (shadow_18 + ((tmpvar_40.x * tmpvar_43.y) * tmpvar_58));
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_17.y;
    tmpvar_59.y = fetchesOffsetsV_16.y;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_46 + tmpvar_59);
    tmpvar_60.z = shadowCoord_14.z;
    lowp float tmpvar_61;
    tmpvar_61 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_18 = (shadow_18 + ((tmpvar_40.y * tmpvar_43.y) * tmpvar_61));
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_17.z;
    tmpvar_62.y = fetchesOffsetsV_16.y;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_46 + tmpvar_62);
    tmpvar_63.z = shadowCoord_14.z;
    lowp float tmpvar_64;
    tmpvar_64 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_18 = (shadow_18 + ((tmpvar_40.z * tmpvar_43.y) * tmpvar_64));
    highp vec2 tmpvar_65;
    tmpvar_65.x = fetchesOffsetsU_17.x;
    tmpvar_65.y = fetchesOffsetsV_16.z;
    highp vec3 tmpvar_66;
    tmpvar_66.xy = (tmpvar_46 + tmpvar_65);
    tmpvar_66.z = shadowCoord_14.z;
    lowp float tmpvar_67;
    tmpvar_67 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_66);
    shadow_18 = (shadow_18 + ((tmpvar_40.x * tmpvar_43.z) * tmpvar_67));
    highp vec2 tmpvar_68;
    tmpvar_68.x = fetchesOffsetsU_17.y;
    tmpvar_68.y = fetchesOffsetsV_16.z;
    highp vec3 tmpvar_69;
    tmpvar_69.xy = (tmpvar_46 + tmpvar_68);
    tmpvar_69.z = shadowCoord_14.z;
    lowp float tmpvar_70;
    tmpvar_70 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_69);
    shadow_18 = (shadow_18 + ((tmpvar_40.y * tmpvar_43.z) * tmpvar_70));
    highp vec2 tmpvar_71;
    tmpvar_71.x = fetchesOffsetsU_17.z;
    tmpvar_71.y = fetchesOffsetsV_16.z;
    highp vec3 tmpvar_72;
    tmpvar_72.xy = (tmpvar_46 + tmpvar_71);
    tmpvar_72.z = shadowCoord_14.z;
    lowp float tmpvar_73;
    tmpvar_73 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_72);
    shadow_18 = (shadow_18 + ((tmpvar_40.z * tmpvar_43.z) * tmpvar_73));
    tmpvar_15 = mix (1.0, shadow_18, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_74;
  highp vec3 tmpvar_75;
  tmpvar_74 = normalize((CAMERA_WORLDPOSITION - tmpvar_13));
  tmpvar_75 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_76;
  mediump float diffuseTerm_77;
  highp float perceptualRoughness_78;
  mediump vec3 tmpvar_79;
  mediump vec3 albedo_80;
  albedo_80 = tmpvar_3;
  mediump vec3 specColor_81;
  specColor_81 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_80 * tmpvar_4));
  tmpvar_79 = (albedo_80 * (0.7790837 - (tmpvar_4 * 0.7790837)));
  tmpvar_76 = 0.0;
  mediump float alpha_82;
  alpha_82 = tmpvar_76;
  tmpvar_76 = alpha_82;
  mediump float tmpvar_83;
  tmpvar_83 = (1.0 - tmpvar_5);
  perceptualRoughness_78 = tmpvar_83;
  highp vec3 tmpvar_84;
  highp vec3 inVec_85;
  inVec_85 = (tmpvar_75 + tmpvar_74);
  tmpvar_84 = (inVec_85 * inversesqrt(max (0.001, 
    dot (inVec_85, inVec_85)
  )));
  highp float tmpvar_86;
  tmpvar_86 = abs(dot (tmpvar_74, tmpvar_6));
  highp float tmpvar_87;
  tmpvar_87 = clamp (dot (tmpvar_6, tmpvar_75), 0.0, 1.0);
  highp float tmpvar_88;
  tmpvar_88 = clamp (dot (tmpvar_6, tmpvar_84), 0.0, 1.0);
  mediump float tmpvar_89;
  highp float tmpvar_90;
  tmpvar_90 = clamp (dot (tmpvar_75, tmpvar_84), 0.0, 1.0);
  tmpvar_89 = tmpvar_90;
  mediump float tmpvar_91;
  mediump float NdotV_92;
  NdotV_92 = tmpvar_86;
  mediump float NdotL_93;
  NdotL_93 = tmpvar_87;
  mediump float perceptualRoughness_94;
  perceptualRoughness_94 = perceptualRoughness_78;
  mediump float tmpvar_95;
  tmpvar_95 = (0.5 + ((2.0 * tmpvar_89) * (tmpvar_89 * perceptualRoughness_94)));
  mediump float x_96;
  x_96 = (1.0 - NdotL_93);
  mediump float x_97;
  x_97 = (1.0 - NdotV_92);
  tmpvar_91 = ((1.0 + (
    (tmpvar_95 - 1.0)
   * 
    ((x_96 * x_96) * ((x_96 * x_96) * x_96))
  )) * (1.0 + (
    (tmpvar_95 - 1.0)
   * 
    ((x_97 * x_97) * ((x_97 * x_97) * x_97))
  )));
  highp float tmpvar_98;
  tmpvar_98 = (tmpvar_91 * tmpvar_87);
  diffuseTerm_77 = tmpvar_98;
  highp float tmpvar_99;
  tmpvar_99 = max ((perceptualRoughness_78 * perceptualRoughness_78), 0.002);
  highp float tmpvar_100;
  tmpvar_100 = (tmpvar_99 * tmpvar_99);
  highp float tmpvar_101;
  tmpvar_101 = (((
    (tmpvar_88 * tmpvar_100)
   - tmpvar_88) * tmpvar_88) + 1.0);
  mediump vec3 tmpvar_102;
  mediump float x_103;
  x_103 = (1.0 - tmpvar_89);
  tmpvar_102 = (specColor_81 + ((1.0 - specColor_81) * (
    (x_103 * x_103)
   * 
    ((x_103 * x_103) * x_103)
  )));
  outColor_2.xyz = (((
    (tmpvar_79 * LIGHT_COLOR)
   * diffuseTerm_77) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_100)
       / 
        ((tmpvar_101 * tmpvar_101) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_87 * (
          (tmpvar_86 * (1.0 - tmpvar_99))
         + tmpvar_99)) + (tmpvar_86 * (
          (tmpvar_87 * (1.0 - tmpvar_99))
         + tmpvar_99))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_87)) * LIGHT_COLOR)
   * tmpvar_102)) * tmpvar_15);
  lowp vec4 tmpvar_104;
  tmpvar_104 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_104;
  outColor_2.w = ((col_9.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec3 normalTangent_7;
  highp vec2 mg_8;
  highp vec4 col_9;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_9 = tmpvar_10;
  lowp vec2 tmpvar_11;
  tmpvar_11 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_8 = tmpvar_11;
  lowp vec3 tmpvar_12;
  tmpvar_12 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_7 = tmpvar_12;
  normalTangent_7 = ((normalTangent_7 * 2.0) - 1.0);
  tmpvar_3 = col_9.xyz;
  tmpvar_4 = (mg_8.x * _Metallic);
  tmpvar_5 = (mg_8.y * _Smoothness);
  tmpvar_6 = normalize(((
    (normalTangent_7.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_7.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_13;
  tmpvar_13.x = xlv_TEXCOORD1.w;
  tmpvar_13.y = xlv_TEXCOORD2.w;
  tmpvar_13.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_14;
  shadowCoord_14 = xlv_TEXCOORD4;
  highp float tmpvar_15;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_15 = 1.0;
  } else {
    shadowCoord_14.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_16;
    highp vec4 fetchesOffsetsU_17;
    highp float shadow_18;
    highp vec2 tmpvar_19;
    tmpvar_19 = (shadowCoord_14.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_20;
    tmpvar_20 = floor((tmpvar_19 + 0.5));
    highp vec2 tmpvar_21;
    tmpvar_21 = (tmpvar_19 - tmpvar_20);
    highp vec4 texelsWeightsA_22;
    highp vec4 texelsWeightsB_23;
    highp vec4 computedArea_24;
    highp vec4 computedAreaUncut_25;
    highp float tmpvar_26;
    tmpvar_26 = (((tmpvar_21.x + 0.5) * (tmpvar_21.x + 0.5)) * 0.5);
    highp float tmpvar_27;
    tmpvar_27 = (tmpvar_26 - tmpvar_21.x);
    computedArea_24.x = tmpvar_27;
    computedAreaUncut_25.x = tmpvar_27;
    computedArea_24.w = tmpvar_26;
    computedAreaUncut_25.w = tmpvar_26;
    computedAreaUncut_25.y = ((1.5 - tmpvar_21.x) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = min (tmpvar_21.x, 0.0);
    computedArea_24.y = (computedAreaUncut_25.y - (tmpvar_28 * tmpvar_28));
    computedAreaUncut_25.z = ((1.5 + tmpvar_21.x) - 0.5);
    highp float tmpvar_29;
    tmpvar_29 = max (tmpvar_21.x, 0.0);
    computedArea_24.z = (computedAreaUncut_25.z - (tmpvar_29 * tmpvar_29));
    texelsWeightsA_22.x = (0.081632 * tmpvar_27);
    texelsWeightsA_22.y = (0.081632 * computedAreaUncut_25.y);
    texelsWeightsA_22.z = (0.081632 * (computedAreaUncut_25.y + 1.0));
    texelsWeightsA_22.w = (0.081632 * (computedArea_24.y + 2.0));
    texelsWeightsB_23.x = (0.081632 * (computedArea_24.z + 2.0));
    texelsWeightsB_23.y = (0.081632 * (computedAreaUncut_25.z + 1.0));
    texelsWeightsB_23.z = (0.081632 * computedAreaUncut_25.z);
    texelsWeightsB_23.w = (0.081632 * tmpvar_26);
    highp vec4 texelsWeightsA_30;
    highp vec4 texelsWeightsB_31;
    highp vec4 computedArea_32;
    highp vec4 computedAreaUncut_33;
    highp float tmpvar_34;
    tmpvar_34 = (((tmpvar_21.y + 0.5) * (tmpvar_21.y + 0.5)) * 0.5);
    highp float tmpvar_35;
    tmpvar_35 = (tmpvar_34 - tmpvar_21.y);
    computedArea_32.x = tmpvar_35;
    computedAreaUncut_33.x = tmpvar_35;
    computedArea_32.w = tmpvar_34;
    computedAreaUncut_33.w = tmpvar_34;
    computedAreaUncut_33.y = ((1.5 - tmpvar_21.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = min (tmpvar_21.y, 0.0);
    computedArea_32.y = (computedAreaUncut_33.y - (tmpvar_36 * tmpvar_36));
    computedAreaUncut_33.z = ((1.5 + tmpvar_21.y) - 0.5);
    highp float tmpvar_37;
    tmpvar_37 = max (tmpvar_21.y, 0.0);
    computedArea_32.z = (computedAreaUncut_33.z - (tmpvar_37 * tmpvar_37));
    texelsWeightsA_30.x = (0.081632 * tmpvar_35);
    texelsWeightsA_30.y = (0.081632 * computedAreaUncut_33.y);
    texelsWeightsA_30.z = (0.081632 * (computedAreaUncut_33.y + 1.0));
    texelsWeightsA_30.w = (0.081632 * (computedArea_32.y + 2.0));
    texelsWeightsB_31.x = (0.081632 * (computedArea_32.z + 2.0));
    texelsWeightsB_31.y = (0.081632 * (computedAreaUncut_33.z + 1.0));
    texelsWeightsB_31.z = (0.081632 * computedAreaUncut_33.z);
    texelsWeightsB_31.w = (0.081632 * tmpvar_34);
    highp vec4 tmpvar_38;
    tmpvar_38.xy = texelsWeightsA_22.xz;
    tmpvar_38.zw = texelsWeightsB_23.xz;
    highp vec4 tmpvar_39;
    tmpvar_39.xy = texelsWeightsA_22.yw;
    tmpvar_39.zw = texelsWeightsB_23.yw;
    highp vec4 tmpvar_40;
    tmpvar_40 = (tmpvar_38 + tmpvar_39);
    highp vec4 tmpvar_41;
    tmpvar_41.xy = texelsWeightsA_30.xz;
    tmpvar_41.zw = texelsWeightsB_31.xz;
    highp vec4 tmpvar_42;
    tmpvar_42.xy = texelsWeightsA_30.yw;
    tmpvar_42.zw = texelsWeightsB_31.yw;
    highp vec4 tmpvar_43;
    tmpvar_43 = (tmpvar_41 + tmpvar_42);
    highp vec4 tmpvar_44;
    tmpvar_44.xy = texelsWeightsA_22.yw;
    tmpvar_44.zw = texelsWeightsB_23.yw;
    highp vec4 tmpvar_45;
    tmpvar_45.xy = texelsWeightsA_30.yw;
    tmpvar_45.zw = texelsWeightsB_31.yw;
    fetchesOffsetsU_17 = (((tmpvar_44 / tmpvar_40) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_16 = (((tmpvar_45 / tmpvar_43) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_46;
    tmpvar_46 = (tmpvar_20 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_17.x;
    tmpvar_47.y = fetchesOffsetsV_16.x;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_46 + tmpvar_47);
    tmpvar_48.z = shadowCoord_14.z;
    lowp float tmpvar_49;
    tmpvar_49 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_18 = ((tmpvar_40.x * tmpvar_43.x) * tmpvar_49);
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_17.y;
    tmpvar_50.y = fetchesOffsetsV_16.x;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_46 + tmpvar_50);
    tmpvar_51.z = shadowCoord_14.z;
    lowp float tmpvar_52;
    tmpvar_52 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_18 = (shadow_18 + ((tmpvar_40.y * tmpvar_43.x) * tmpvar_52));
    highp vec2 tmpvar_53;
    tmpvar_53.x = fetchesOffsetsU_17.z;
    tmpvar_53.y = fetchesOffsetsV_16.x;
    highp vec3 tmpvar_54;
    tmpvar_54.xy = (tmpvar_46 + tmpvar_53);
    tmpvar_54.z = shadowCoord_14.z;
    lowp float tmpvar_55;
    tmpvar_55 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_54);
    shadow_18 = (shadow_18 + ((tmpvar_40.z * tmpvar_43.x) * tmpvar_55));
    highp vec2 tmpvar_56;
    tmpvar_56.x = fetchesOffsetsU_17.w;
    tmpvar_56.y = fetchesOffsetsV_16.x;
    highp vec3 tmpvar_57;
    tmpvar_57.xy = (tmpvar_46 + tmpvar_56);
    tmpvar_57.z = shadowCoord_14.z;
    lowp float tmpvar_58;
    tmpvar_58 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_57);
    shadow_18 = (shadow_18 + ((tmpvar_40.w * tmpvar_43.x) * tmpvar_58));
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_17.x;
    tmpvar_59.y = fetchesOffsetsV_16.y;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_46 + tmpvar_59);
    tmpvar_60.z = shadowCoord_14.z;
    lowp float tmpvar_61;
    tmpvar_61 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_18 = (shadow_18 + ((tmpvar_40.x * tmpvar_43.y) * tmpvar_61));
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_17.y;
    tmpvar_62.y = fetchesOffsetsV_16.y;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_46 + tmpvar_62);
    tmpvar_63.z = shadowCoord_14.z;
    lowp float tmpvar_64;
    tmpvar_64 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_18 = (shadow_18 + ((tmpvar_40.y * tmpvar_43.y) * tmpvar_64));
    highp vec2 tmpvar_65;
    tmpvar_65.x = fetchesOffsetsU_17.z;
    tmpvar_65.y = fetchesOffsetsV_16.y;
    highp vec3 tmpvar_66;
    tmpvar_66.xy = (tmpvar_46 + tmpvar_65);
    tmpvar_66.z = shadowCoord_14.z;
    lowp float tmpvar_67;
    tmpvar_67 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_66);
    shadow_18 = (shadow_18 + ((tmpvar_40.z * tmpvar_43.y) * tmpvar_67));
    highp vec2 tmpvar_68;
    tmpvar_68.x = fetchesOffsetsU_17.w;
    tmpvar_68.y = fetchesOffsetsV_16.y;
    highp vec3 tmpvar_69;
    tmpvar_69.xy = (tmpvar_46 + tmpvar_68);
    tmpvar_69.z = shadowCoord_14.z;
    lowp float tmpvar_70;
    tmpvar_70 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_69);
    shadow_18 = (shadow_18 + ((tmpvar_40.w * tmpvar_43.y) * tmpvar_70));
    highp vec2 tmpvar_71;
    tmpvar_71.x = fetchesOffsetsU_17.x;
    tmpvar_71.y = fetchesOffsetsV_16.z;
    highp vec3 tmpvar_72;
    tmpvar_72.xy = (tmpvar_46 + tmpvar_71);
    tmpvar_72.z = shadowCoord_14.z;
    lowp float tmpvar_73;
    tmpvar_73 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_72);
    shadow_18 = (shadow_18 + ((tmpvar_40.x * tmpvar_43.z) * tmpvar_73));
    highp vec2 tmpvar_74;
    tmpvar_74.x = fetchesOffsetsU_17.y;
    tmpvar_74.y = fetchesOffsetsV_16.z;
    highp vec3 tmpvar_75;
    tmpvar_75.xy = (tmpvar_46 + tmpvar_74);
    tmpvar_75.z = shadowCoord_14.z;
    lowp float tmpvar_76;
    tmpvar_76 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_75);
    shadow_18 = (shadow_18 + ((tmpvar_40.y * tmpvar_43.z) * tmpvar_76));
    highp vec2 tmpvar_77;
    tmpvar_77.x = fetchesOffsetsU_17.z;
    tmpvar_77.y = fetchesOffsetsV_16.z;
    highp vec3 tmpvar_78;
    tmpvar_78.xy = (tmpvar_46 + tmpvar_77);
    tmpvar_78.z = shadowCoord_14.z;
    lowp float tmpvar_79;
    tmpvar_79 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_78);
    shadow_18 = (shadow_18 + ((tmpvar_40.z * tmpvar_43.z) * tmpvar_79));
    highp vec2 tmpvar_80;
    tmpvar_80.x = fetchesOffsetsU_17.w;
    tmpvar_80.y = fetchesOffsetsV_16.z;
    highp vec3 tmpvar_81;
    tmpvar_81.xy = (tmpvar_46 + tmpvar_80);
    tmpvar_81.z = shadowCoord_14.z;
    lowp float tmpvar_82;
    tmpvar_82 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_81);
    shadow_18 = (shadow_18 + ((tmpvar_40.w * tmpvar_43.z) * tmpvar_82));
    highp vec2 tmpvar_83;
    tmpvar_83.x = fetchesOffsetsU_17.x;
    tmpvar_83.y = fetchesOffsetsV_16.w;
    highp vec3 tmpvar_84;
    tmpvar_84.xy = (tmpvar_46 + tmpvar_83);
    tmpvar_84.z = shadowCoord_14.z;
    lowp float tmpvar_85;
    tmpvar_85 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_84);
    shadow_18 = (shadow_18 + ((tmpvar_40.x * tmpvar_43.w) * tmpvar_85));
    highp vec2 tmpvar_86;
    tmpvar_86.x = fetchesOffsetsU_17.y;
    tmpvar_86.y = fetchesOffsetsV_16.w;
    highp vec3 tmpvar_87;
    tmpvar_87.xy = (tmpvar_46 + tmpvar_86);
    tmpvar_87.z = shadowCoord_14.z;
    lowp float tmpvar_88;
    tmpvar_88 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_87);
    shadow_18 = (shadow_18 + ((tmpvar_40.y * tmpvar_43.w) * tmpvar_88));
    highp vec2 tmpvar_89;
    tmpvar_89.x = fetchesOffsetsU_17.z;
    tmpvar_89.y = fetchesOffsetsV_16.w;
    highp vec3 tmpvar_90;
    tmpvar_90.xy = (tmpvar_46 + tmpvar_89);
    tmpvar_90.z = shadowCoord_14.z;
    lowp float tmpvar_91;
    tmpvar_91 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_90);
    shadow_18 = (shadow_18 + ((tmpvar_40.z * tmpvar_43.w) * tmpvar_91));
    highp vec2 tmpvar_92;
    tmpvar_92.x = fetchesOffsetsU_17.w;
    tmpvar_92.y = fetchesOffsetsV_16.w;
    highp vec3 tmpvar_93;
    tmpvar_93.xy = (tmpvar_46 + tmpvar_92);
    tmpvar_93.z = shadowCoord_14.z;
    lowp float tmpvar_94;
    tmpvar_94 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_93);
    shadow_18 = (shadow_18 + ((tmpvar_40.w * tmpvar_43.w) * tmpvar_94));
    tmpvar_15 = mix (1.0, shadow_18, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_95;
  highp vec3 tmpvar_96;
  tmpvar_95 = normalize((CAMERA_WORLDPOSITION - tmpvar_13));
  tmpvar_96 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_97;
  mediump float diffuseTerm_98;
  highp float perceptualRoughness_99;
  mediump vec3 tmpvar_100;
  mediump vec3 albedo_101;
  albedo_101 = tmpvar_3;
  mediump vec3 specColor_102;
  specColor_102 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_101 * tmpvar_4));
  tmpvar_100 = (albedo_101 * (0.7790837 - (tmpvar_4 * 0.7790837)));
  tmpvar_97 = 0.0;
  mediump float alpha_103;
  alpha_103 = tmpvar_97;
  tmpvar_97 = alpha_103;
  mediump float tmpvar_104;
  tmpvar_104 = (1.0 - tmpvar_5);
  perceptualRoughness_99 = tmpvar_104;
  highp vec3 tmpvar_105;
  highp vec3 inVec_106;
  inVec_106 = (tmpvar_96 + tmpvar_95);
  tmpvar_105 = (inVec_106 * inversesqrt(max (0.001, 
    dot (inVec_106, inVec_106)
  )));
  highp float tmpvar_107;
  tmpvar_107 = abs(dot (tmpvar_95, tmpvar_6));
  highp float tmpvar_108;
  tmpvar_108 = clamp (dot (tmpvar_6, tmpvar_96), 0.0, 1.0);
  highp float tmpvar_109;
  tmpvar_109 = clamp (dot (tmpvar_6, tmpvar_105), 0.0, 1.0);
  mediump float tmpvar_110;
  highp float tmpvar_111;
  tmpvar_111 = clamp (dot (tmpvar_96, tmpvar_105), 0.0, 1.0);
  tmpvar_110 = tmpvar_111;
  mediump float tmpvar_112;
  mediump float NdotV_113;
  NdotV_113 = tmpvar_107;
  mediump float NdotL_114;
  NdotL_114 = tmpvar_108;
  mediump float perceptualRoughness_115;
  perceptualRoughness_115 = perceptualRoughness_99;
  mediump float tmpvar_116;
  tmpvar_116 = (0.5 + ((2.0 * tmpvar_110) * (tmpvar_110 * perceptualRoughness_115)));
  mediump float x_117;
  x_117 = (1.0 - NdotL_114);
  mediump float x_118;
  x_118 = (1.0 - NdotV_113);
  tmpvar_112 = ((1.0 + (
    (tmpvar_116 - 1.0)
   * 
    ((x_117 * x_117) * ((x_117 * x_117) * x_117))
  )) * (1.0 + (
    (tmpvar_116 - 1.0)
   * 
    ((x_118 * x_118) * ((x_118 * x_118) * x_118))
  )));
  highp float tmpvar_119;
  tmpvar_119 = (tmpvar_112 * tmpvar_108);
  diffuseTerm_98 = tmpvar_119;
  highp float tmpvar_120;
  tmpvar_120 = max ((perceptualRoughness_99 * perceptualRoughness_99), 0.002);
  highp float tmpvar_121;
  tmpvar_121 = (tmpvar_120 * tmpvar_120);
  highp float tmpvar_122;
  tmpvar_122 = (((
    (tmpvar_109 * tmpvar_121)
   - tmpvar_109) * tmpvar_109) + 1.0);
  mediump vec3 tmpvar_123;
  mediump float x_124;
  x_124 = (1.0 - tmpvar_110);
  tmpvar_123 = (specColor_102 + ((1.0 - specColor_102) * (
    (x_124 * x_124)
   * 
    ((x_124 * x_124) * x_124)
  )));
  outColor_2.xyz = (((
    (tmpvar_100 * LIGHT_COLOR)
   * diffuseTerm_98) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_121)
       / 
        ((tmpvar_122 * tmpvar_122) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_108 * (
          (tmpvar_107 * (1.0 - tmpvar_120))
         + tmpvar_120)) + (tmpvar_107 * (
          (tmpvar_108 * (1.0 - tmpvar_120))
         + tmpvar_120))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_108)) * LIGHT_COLOR)
   * tmpvar_123)) * tmpvar_15);
  lowp vec4 tmpvar_125;
  tmpvar_125 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_125;
  outColor_2.w = ((col_9.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)))
  ).xyz * 0.5) + 0.5);
  tmpvar_4.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec3 normalTangent_7;
  highp vec2 mg_8;
  highp vec4 col_9;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_9 = tmpvar_10;
  lowp vec2 tmpvar_11;
  tmpvar_11 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_8 = tmpvar_11;
  lowp vec3 tmpvar_12;
  tmpvar_12 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_7 = tmpvar_12;
  normalTangent_7 = ((normalTangent_7 * 2.0) - 1.0);
  tmpvar_3 = col_9.xyz;
  tmpvar_4 = (mg_8.x * _Metallic);
  tmpvar_5 = (mg_8.y * _Smoothness);
  tmpvar_6 = normalize(((
    (normalTangent_7.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_7.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_13;
  tmpvar_13.x = xlv_TEXCOORD1.w;
  tmpvar_13.y = xlv_TEXCOORD2.w;
  tmpvar_13.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_14;
  shadowCoord_14 = xlv_TEXCOORD4;
  highp float tmpvar_15;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_15 = 1.0;
  } else {
    highp vec2 tmpvar_16;
    tmpvar_16.x = LIGHT_PARAM.z;
    tmpvar_16.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_17;
    tmpvar_17.xy = tmpvar_16;
    highp float tmpvar_18;
    tmpvar_18 = (1.0/(LIGHT_PARAM.z));
    tmpvar_17.z = tmpvar_18;
    tmpvar_17.w = tmpvar_18;
    shadowCoord_14.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_19;
    highp vec2 tmpvar_20;
    tmpvar_20 = tmpvar_17.xy;
    shadow_19 = 0.0;
    highp vec3 tmpvar_21;
    tmpvar_21.xy = (shadowCoord_14.xy - LIGHT_PARAM.zz);
    tmpvar_21.z = shadowCoord_14.z;
    highp vec4 tmpvar_22;
    tmpvar_22 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_21.xy);
    highp float tmpvar_23;
    if ((tmpvar_22.x < xlv_TEXCOORD4.z)) {
      tmpvar_23 = 0.0;
    } else {
      tmpvar_23 = 1.0;
    };
    shadow_19 = tmpvar_23;
    highp vec2 tmpvar_24;
    tmpvar_24.x = 0.0;
    tmpvar_24.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_25;
    tmpvar_25.xy = (shadowCoord_14.xy + tmpvar_24);
    tmpvar_25.z = shadowCoord_14.z;
    highp vec4 tmpvar_26;
    tmpvar_26 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_25.xy);
    highp float tmpvar_27;
    if ((tmpvar_26.x < xlv_TEXCOORD4.z)) {
      tmpvar_27 = 0.0;
    } else {
      tmpvar_27 = 1.0;
    };
    shadow_19 = (tmpvar_23 + tmpvar_27);
    highp vec2 tmpvar_28;
    tmpvar_28.x = tmpvar_20.x;
    tmpvar_28.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_29;
    tmpvar_29.xy = (shadowCoord_14.xy + tmpvar_28);
    tmpvar_29.z = shadowCoord_14.z;
    highp vec4 tmpvar_30;
    tmpvar_30 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_29.xy);
    highp float tmpvar_31;
    if ((tmpvar_30.x < xlv_TEXCOORD4.z)) {
      tmpvar_31 = 0.0;
    } else {
      tmpvar_31 = 1.0;
    };
    shadow_19 = (shadow_19 + tmpvar_31);
    highp vec2 tmpvar_32;
    tmpvar_32.y = 0.0;
    tmpvar_32.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_33;
    tmpvar_33.xy = (shadowCoord_14.xy + tmpvar_32);
    tmpvar_33.z = shadowCoord_14.z;
    highp vec4 tmpvar_34;
    tmpvar_34 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_33.xy);
    highp float tmpvar_35;
    if ((tmpvar_34.x < xlv_TEXCOORD4.z)) {
      tmpvar_35 = 0.0;
    } else {
      tmpvar_35 = 1.0;
    };
    shadow_19 = (shadow_19 + tmpvar_35);
    highp vec4 tmpvar_36;
    tmpvar_36 = texture2D (TEXTURE_SHADOW_DEPTH, shadowCoord_14.xy);
    highp float tmpvar_37;
    if ((tmpvar_36.x < xlv_TEXCOORD4.z)) {
      tmpvar_37 = 0.0;
    } else {
      tmpvar_37 = 1.0;
    };
    shadow_19 = (shadow_19 + tmpvar_37);
    highp vec2 tmpvar_38;
    tmpvar_38.y = 0.0;
    tmpvar_38.x = tmpvar_20.x;
    highp vec3 tmpvar_39;
    tmpvar_39.xy = (shadowCoord_14.xy + tmpvar_38);
    tmpvar_39.z = shadowCoord_14.z;
    highp vec4 tmpvar_40;
    tmpvar_40 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_39.xy);
    highp float tmpvar_41;
    if ((tmpvar_40.x < xlv_TEXCOORD4.z)) {
      tmpvar_41 = 0.0;
    } else {
      tmpvar_41 = 1.0;
    };
    shadow_19 = (shadow_19 + tmpvar_41);
    highp vec2 tmpvar_42;
    tmpvar_42.x = -(LIGHT_PARAM.z);
    tmpvar_42.y = tmpvar_20.y;
    highp vec3 tmpvar_43;
    tmpvar_43.xy = (shadowCoord_14.xy + tmpvar_42);
    tmpvar_43.z = shadowCoord_14.z;
    highp vec4 tmpvar_44;
    tmpvar_44 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_43.xy);
    highp float tmpvar_45;
    if ((tmpvar_44.x < xlv_TEXCOORD4.z)) {
      tmpvar_45 = 0.0;
    } else {
      tmpvar_45 = 1.0;
    };
    shadow_19 = (shadow_19 + tmpvar_45);
    highp vec2 tmpvar_46;
    tmpvar_46.x = 0.0;
    tmpvar_46.y = tmpvar_20.y;
    highp vec3 tmpvar_47;
    tmpvar_47.xy = (shadowCoord_14.xy + tmpvar_46);
    tmpvar_47.z = shadowCoord_14.z;
    highp vec4 tmpvar_48;
    tmpvar_48 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_47.xy);
    highp float tmpvar_49;
    if ((tmpvar_48.x < xlv_TEXCOORD4.z)) {
      tmpvar_49 = 0.0;
    } else {
      tmpvar_49 = 1.0;
    };
    shadow_19 = (shadow_19 + tmpvar_49);
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (shadowCoord_14.xy + LIGHT_PARAM.zz);
    tmpvar_50.z = shadowCoord_14.z;
    highp vec4 tmpvar_51;
    tmpvar_51 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_50.xy);
    highp float tmpvar_52;
    if ((tmpvar_51.x < xlv_TEXCOORD4.z)) {
      tmpvar_52 = 0.0;
    } else {
      tmpvar_52 = 1.0;
    };
    shadow_19 = (shadow_19 + tmpvar_52);
    shadow_19 = (shadow_19 / 9.0);
    tmpvar_15 = mix (1.0, shadow_19, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_53;
  highp vec3 tmpvar_54;
  tmpvar_53 = normalize((CAMERA_WORLDPOSITION - tmpvar_13));
  tmpvar_54 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_55;
  mediump float diffuseTerm_56;
  highp float perceptualRoughness_57;
  mediump vec3 tmpvar_58;
  mediump vec3 albedo_59;
  albedo_59 = tmpvar_3;
  mediump vec3 specColor_60;
  specColor_60 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_59 * tmpvar_4));
  tmpvar_58 = (albedo_59 * (0.7790837 - (tmpvar_4 * 0.7790837)));
  tmpvar_55 = 0.0;
  mediump float alpha_61;
  alpha_61 = tmpvar_55;
  tmpvar_55 = alpha_61;
  mediump float tmpvar_62;
  tmpvar_62 = (1.0 - tmpvar_5);
  perceptualRoughness_57 = tmpvar_62;
  highp vec3 tmpvar_63;
  highp vec3 inVec_64;
  inVec_64 = (tmpvar_54 + tmpvar_53);
  tmpvar_63 = (inVec_64 * inversesqrt(max (0.001, 
    dot (inVec_64, inVec_64)
  )));
  highp float tmpvar_65;
  tmpvar_65 = abs(dot (tmpvar_53, tmpvar_6));
  highp float tmpvar_66;
  tmpvar_66 = clamp (dot (tmpvar_6, tmpvar_54), 0.0, 1.0);
  highp float tmpvar_67;
  tmpvar_67 = clamp (dot (tmpvar_6, tmpvar_63), 0.0, 1.0);
  mediump float tmpvar_68;
  highp float tmpvar_69;
  tmpvar_69 = clamp (dot (tmpvar_54, tmpvar_63), 0.0, 1.0);
  tmpvar_68 = tmpvar_69;
  mediump float tmpvar_70;
  mediump float NdotV_71;
  NdotV_71 = tmpvar_65;
  mediump float NdotL_72;
  NdotL_72 = tmpvar_66;
  mediump float perceptualRoughness_73;
  perceptualRoughness_73 = perceptualRoughness_57;
  mediump float tmpvar_74;
  tmpvar_74 = (0.5 + ((2.0 * tmpvar_68) * (tmpvar_68 * perceptualRoughness_73)));
  mediump float x_75;
  x_75 = (1.0 - NdotL_72);
  mediump float x_76;
  x_76 = (1.0 - NdotV_71);
  tmpvar_70 = ((1.0 + (
    (tmpvar_74 - 1.0)
   * 
    ((x_75 * x_75) * ((x_75 * x_75) * x_75))
  )) * (1.0 + (
    (tmpvar_74 - 1.0)
   * 
    ((x_76 * x_76) * ((x_76 * x_76) * x_76))
  )));
  highp float tmpvar_77;
  tmpvar_77 = (tmpvar_70 * tmpvar_66);
  diffuseTerm_56 = tmpvar_77;
  highp float tmpvar_78;
  tmpvar_78 = max ((perceptualRoughness_57 * perceptualRoughness_57), 0.002);
  highp float tmpvar_79;
  tmpvar_79 = (tmpvar_78 * tmpvar_78);
  highp float tmpvar_80;
  tmpvar_80 = (((
    (tmpvar_67 * tmpvar_79)
   - tmpvar_67) * tmpvar_67) + 1.0);
  mediump vec3 tmpvar_81;
  mediump float x_82;
  x_82 = (1.0 - tmpvar_68);
  tmpvar_81 = (specColor_60 + ((1.0 - specColor_60) * (
    (x_82 * x_82)
   * 
    ((x_82 * x_82) * x_82)
  )));
  outColor_2.xyz = (((
    (tmpvar_58 * LIGHT_COLOR)
   * diffuseTerm_56) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_79)
       / 
        ((tmpvar_80 * tmpvar_80) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_66 * (
          (tmpvar_65 * (1.0 - tmpvar_78))
         + tmpvar_78)) + (tmpvar_65 * (
          (tmpvar_66 * (1.0 - tmpvar_78))
         + tmpvar_78))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_66)) * LIGHT_COLOR)
   * tmpvar_81)) * tmpvar_15);
  lowp vec4 tmpvar_83;
  tmpvar_83 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_83;
  outColor_2.w = ((col_9.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = tmpvar_11[0].xyz;
  tmpvar_15[1] = tmpvar_11[1].xyz;
  tmpvar_15[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_16[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_16[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = tmpvar_11[0].xyz;
  tmpvar_17[1] = tmpvar_11[1].xyz;
  tmpvar_17[2] = tmpvar_11[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_11[0].xyz;
  tmpvar_19[1] = tmpvar_11[1].xyz;
  tmpvar_19[2] = tmpvar_11[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_3 = col_8.xyz;
  tmpvar_4 = (mg_7.x * _Metallic);
  tmpvar_5 = (mg_7.y * _Smoothness);
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  highp vec3 lightDir_15;
  highp vec3 tmpvar_16;
  tmpvar_16 = (LIGHT_POSITION - tmpvar_12);
  highp float tmpvar_17;
  tmpvar_17 = clamp ((sqrt(
    dot (tmpvar_16, tmpvar_16)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_15 = normalize(tmpvar_16);
  tmpvar_14 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  tmpvar_13 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  highp float tmpvar_18;
  mediump float diffuseTerm_19;
  highp float perceptualRoughness_20;
  mediump vec3 tmpvar_21;
  mediump vec3 albedo_22;
  albedo_22 = tmpvar_3;
  mediump vec3 specColor_23;
  specColor_23 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_22 * tmpvar_4));
  tmpvar_21 = (albedo_22 * (0.7790837 - (tmpvar_4 * 0.7790837)));
  tmpvar_18 = 0.0;
  mediump float alpha_24;
  alpha_24 = tmpvar_18;
  tmpvar_18 = alpha_24;
  mediump float tmpvar_25;
  tmpvar_25 = (1.0 - tmpvar_5);
  perceptualRoughness_20 = tmpvar_25;
  highp vec3 tmpvar_26;
  highp vec3 inVec_27;
  inVec_27 = (lightDir_15 + tmpvar_13);
  tmpvar_26 = (inVec_27 * inversesqrt(max (0.001, 
    dot (inVec_27, inVec_27)
  )));
  highp float tmpvar_28;
  tmpvar_28 = abs(dot (tmpvar_13, tmpvar_14));
  highp float tmpvar_29;
  tmpvar_29 = clamp (dot (tmpvar_14, lightDir_15), 0.0, 1.0);
  highp float tmpvar_30;
  tmpvar_30 = clamp (dot (tmpvar_14, tmpvar_26), 0.0, 1.0);
  mediump float tmpvar_31;
  highp float tmpvar_32;
  tmpvar_32 = clamp (dot (lightDir_15, tmpvar_26), 0.0, 1.0);
  tmpvar_31 = tmpvar_32;
  mediump float tmpvar_33;
  mediump float NdotV_34;
  NdotV_34 = tmpvar_28;
  mediump float NdotL_35;
  NdotL_35 = tmpvar_29;
  mediump float perceptualRoughness_36;
  perceptualRoughness_36 = perceptualRoughness_20;
  mediump float tmpvar_37;
  tmpvar_37 = (0.5 + ((2.0 * tmpvar_31) * (tmpvar_31 * perceptualRoughness_36)));
  mediump float x_38;
  x_38 = (1.0 - NdotL_35);
  mediump float x_39;
  x_39 = (1.0 - NdotV_34);
  tmpvar_33 = ((1.0 + (
    (tmpvar_37 - 1.0)
   * 
    ((x_38 * x_38) * ((x_38 * x_38) * x_38))
  )) * (1.0 + (
    (tmpvar_37 - 1.0)
   * 
    ((x_39 * x_39) * ((x_39 * x_39) * x_39))
  )));
  highp float tmpvar_40;
  tmpvar_40 = (tmpvar_33 * tmpvar_29);
  diffuseTerm_19 = tmpvar_40;
  highp float tmpvar_41;
  tmpvar_41 = max ((perceptualRoughness_20 * perceptualRoughness_20), 0.002);
  highp float tmpvar_42;
  tmpvar_42 = (tmpvar_41 * tmpvar_41);
  highp float tmpvar_43;
  tmpvar_43 = (((
    (tmpvar_30 * tmpvar_42)
   - tmpvar_30) * tmpvar_30) + 1.0);
  mediump vec3 tmpvar_44;
  mediump float x_45;
  x_45 = (1.0 - tmpvar_31);
  tmpvar_44 = (specColor_23 + ((1.0 - specColor_23) * (
    (x_45 * x_45)
   * 
    ((x_45 * x_45) * x_45)
  )));
  outColor_2.xyz = (((
    (tmpvar_21 * LIGHT_COLOR)
   * diffuseTerm_19) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_42)
       / 
        ((tmpvar_43 * tmpvar_43) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_29 * (
          (tmpvar_28 * (1.0 - tmpvar_41))
         + tmpvar_41)) + (tmpvar_28 * (
          (tmpvar_29 * (1.0 - tmpvar_41))
         + tmpvar_41))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_29)) * LIGHT_COLOR)
   * tmpvar_44)) * ((
    (1.0 - tmpvar_17)
   / 
    ((LIGHT_ATTENUATION.x + (tmpvar_17 * LIGHT_ATTENUATION.y)) + ((tmpvar_17 * tmpvar_17) * LIGHT_ATTENUATION.z))
  ) * clamp (
    (1.0 - ((LIGHT_INNER_DIFF_INV.x - dot (lightDir_15, 
      -(LIGHT_GIVEN_DIRECTION)
    )) * LIGHT_INNER_DIFF_INV.y))
  , 0.0, 1.0)));
  lowp vec4 tmpvar_46;
  tmpvar_46 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_46;
  outColor_2.w = ((col_8.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  tmpvar_4.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_3 = col_8.xyz;
  tmpvar_4 = (mg_7.x * _Metallic);
  tmpvar_5 = (mg_7.y * _Smoothness);
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_13;
  highp vec4 tmpvar_14;
  tmpvar_14 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_13.w = tmpvar_14.w;
  shadowCoord_13.xyz = (tmpvar_14.xyz / tmpvar_14.w);
  shadowCoord_13.xyz = ((shadowCoord_13.xyz * 0.5) + 0.5);
  shadowCoord_13.y = (1.0 - shadowCoord_13.y);
  highp vec2 fetchesOffsetsV_15;
  highp vec2 fetchesOffsetsU_16;
  highp float shadow_17;
  highp vec2 tmpvar_18;
  tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_19;
  tmpvar_19 = floor((tmpvar_18 + 0.5));
  highp vec2 tmpvar_20;
  tmpvar_20 = (tmpvar_18 - tmpvar_19);
  highp vec4 computedWeight_21;
  highp vec4 computedArea_22;
  highp vec4 computedAreaUncut_23;
  highp float tmpvar_24;
  tmpvar_24 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_24 - tmpvar_20.x);
  computedArea_22.x = tmpvar_25;
  computedAreaUncut_23.x = tmpvar_25;
  computedArea_22.w = tmpvar_24;
  computedAreaUncut_23.w = tmpvar_24;
  computedAreaUncut_23.y = ((1.5 - tmpvar_20.x) - 0.5);
  highp float tmpvar_26;
  tmpvar_26 = min (tmpvar_20.x, 0.0);
  computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
  computedAreaUncut_23.z = ((1.5 + tmpvar_20.x) - 0.5);
  highp float tmpvar_27;
  tmpvar_27 = max (tmpvar_20.x, 0.0);
  computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
  computedWeight_21 = (computedArea_22 * 0.44444);
  highp vec4 computedWeight_28;
  highp vec4 computedArea_29;
  highp vec4 computedAreaUncut_30;
  highp float tmpvar_31;
  tmpvar_31 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
  highp float tmpvar_32;
  tmpvar_32 = (tmpvar_31 - tmpvar_20.y);
  computedArea_29.x = tmpvar_32;
  computedAreaUncut_30.x = tmpvar_32;
  computedArea_29.w = tmpvar_31;
  computedAreaUncut_30.w = tmpvar_31;
  computedAreaUncut_30.y = ((1.5 - tmpvar_20.y) - 0.5);
  highp float tmpvar_33;
  tmpvar_33 = min (tmpvar_20.y, 0.0);
  computedArea_29.y = (computedAreaUncut_30.y - (tmpvar_33 * tmpvar_33));
  computedAreaUncut_30.z = ((1.5 + tmpvar_20.y) - 0.5);
  highp float tmpvar_34;
  tmpvar_34 = max (tmpvar_20.y, 0.0);
  computedArea_29.z = (computedAreaUncut_30.z - (tmpvar_34 * tmpvar_34));
  computedWeight_28 = (computedArea_29 * 0.44444);
  highp vec2 tmpvar_35;
  tmpvar_35 = (computedWeight_21.xz + computedWeight_21.yw);
  highp vec2 tmpvar_36;
  tmpvar_36 = (computedWeight_28.xz + computedWeight_28.yw);
  fetchesOffsetsU_16 = (((computedWeight_21.yw / tmpvar_35) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  fetchesOffsetsV_15 = (((computedWeight_28.yw / tmpvar_36) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  highp vec2 tmpvar_37;
  tmpvar_37 = (tmpvar_19 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_38;
  tmpvar_38.x = fetchesOffsetsU_16.x;
  tmpvar_38.y = fetchesOffsetsV_15.x;
  highp vec3 tmpvar_39;
  tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
  tmpvar_39.z = shadowCoord_13.z;
  lowp float tmpvar_40;
  tmpvar_40 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_39);
  shadow_17 = ((tmpvar_35.x * tmpvar_36.x) * tmpvar_40);
  highp vec2 tmpvar_41;
  tmpvar_41.x = fetchesOffsetsU_16.y;
  tmpvar_41.y = fetchesOffsetsV_15.x;
  highp vec3 tmpvar_42;
  tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
  tmpvar_42.z = shadowCoord_13.z;
  lowp float tmpvar_43;
  tmpvar_43 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_42);
  shadow_17 = (shadow_17 + ((tmpvar_35.y * tmpvar_36.x) * tmpvar_43));
  highp vec2 tmpvar_44;
  tmpvar_44.x = fetchesOffsetsU_16.x;
  tmpvar_44.y = fetchesOffsetsV_15.y;
  highp vec3 tmpvar_45;
  tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
  tmpvar_45.z = shadowCoord_13.z;
  lowp float tmpvar_46;
  tmpvar_46 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_45);
  shadow_17 = (shadow_17 + ((tmpvar_35.x * tmpvar_36.y) * tmpvar_46));
  highp vec2 tmpvar_47;
  tmpvar_47.x = fetchesOffsetsU_16.y;
  tmpvar_47.y = fetchesOffsetsV_15.y;
  highp vec3 tmpvar_48;
  tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
  tmpvar_48.z = shadowCoord_13.z;
  lowp float tmpvar_49;
  tmpvar_49 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_48);
  shadow_17 = (shadow_17 + ((tmpvar_35.y * tmpvar_36.y) * tmpvar_49));
  highp vec3 tmpvar_50;
  highp vec3 tmpvar_51;
  highp vec3 lightDir_52;
  highp vec3 tmpvar_53;
  tmpvar_53 = (LIGHT_POSITION - tmpvar_12);
  highp float tmpvar_54;
  tmpvar_54 = clamp ((sqrt(
    dot (tmpvar_53, tmpvar_53)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_52 = normalize(tmpvar_53);
  tmpvar_51 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  tmpvar_50 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  highp float tmpvar_55;
  mediump float diffuseTerm_56;
  highp float perceptualRoughness_57;
  mediump vec3 tmpvar_58;
  mediump vec3 albedo_59;
  albedo_59 = tmpvar_3;
  mediump vec3 specColor_60;
  specColor_60 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_59 * tmpvar_4));
  tmpvar_58 = (albedo_59 * (0.7790837 - (tmpvar_4 * 0.7790837)));
  tmpvar_55 = 0.0;
  mediump float alpha_61;
  alpha_61 = tmpvar_55;
  tmpvar_55 = alpha_61;
  mediump float tmpvar_62;
  tmpvar_62 = (1.0 - tmpvar_5);
  perceptualRoughness_57 = tmpvar_62;
  highp vec3 tmpvar_63;
  highp vec3 inVec_64;
  inVec_64 = (lightDir_52 + tmpvar_50);
  tmpvar_63 = (inVec_64 * inversesqrt(max (0.001, 
    dot (inVec_64, inVec_64)
  )));
  highp float tmpvar_65;
  tmpvar_65 = abs(dot (tmpvar_50, tmpvar_51));
  highp float tmpvar_66;
  tmpvar_66 = clamp (dot (tmpvar_51, lightDir_52), 0.0, 1.0);
  highp float tmpvar_67;
  tmpvar_67 = clamp (dot (tmpvar_51, tmpvar_63), 0.0, 1.0);
  mediump float tmpvar_68;
  highp float tmpvar_69;
  tmpvar_69 = clamp (dot (lightDir_52, tmpvar_63), 0.0, 1.0);
  tmpvar_68 = tmpvar_69;
  mediump float tmpvar_70;
  mediump float NdotV_71;
  NdotV_71 = tmpvar_65;
  mediump float NdotL_72;
  NdotL_72 = tmpvar_66;
  mediump float perceptualRoughness_73;
  perceptualRoughness_73 = perceptualRoughness_57;
  mediump float tmpvar_74;
  tmpvar_74 = (0.5 + ((2.0 * tmpvar_68) * (tmpvar_68 * perceptualRoughness_73)));
  mediump float x_75;
  x_75 = (1.0 - NdotL_72);
  mediump float x_76;
  x_76 = (1.0 - NdotV_71);
  tmpvar_70 = ((1.0 + (
    (tmpvar_74 - 1.0)
   * 
    ((x_75 * x_75) * ((x_75 * x_75) * x_75))
  )) * (1.0 + (
    (tmpvar_74 - 1.0)
   * 
    ((x_76 * x_76) * ((x_76 * x_76) * x_76))
  )));
  highp float tmpvar_77;
  tmpvar_77 = (tmpvar_70 * tmpvar_66);
  diffuseTerm_56 = tmpvar_77;
  highp float tmpvar_78;
  tmpvar_78 = max ((perceptualRoughness_57 * perceptualRoughness_57), 0.002);
  highp float tmpvar_79;
  tmpvar_79 = (tmpvar_78 * tmpvar_78);
  highp float tmpvar_80;
  tmpvar_80 = (((
    (tmpvar_67 * tmpvar_79)
   - tmpvar_67) * tmpvar_67) + 1.0);
  mediump vec3 tmpvar_81;
  mediump float x_82;
  x_82 = (1.0 - tmpvar_68);
  tmpvar_81 = (specColor_60 + ((1.0 - specColor_60) * (
    (x_82 * x_82)
   * 
    ((x_82 * x_82) * x_82)
  )));
  outColor_2.xyz = (((
    (tmpvar_58 * LIGHT_COLOR)
   * diffuseTerm_56) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_79)
       / 
        ((tmpvar_80 * tmpvar_80) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_66 * (
          (tmpvar_65 * (1.0 - tmpvar_78))
         + tmpvar_78)) + (tmpvar_65 * (
          (tmpvar_66 * (1.0 - tmpvar_78))
         + tmpvar_78))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_66)) * LIGHT_COLOR)
   * tmpvar_81)) * ((
    ((1.0 - tmpvar_54) / ((LIGHT_ATTENUATION.x + (tmpvar_54 * LIGHT_ATTENUATION.y)) + ((tmpvar_54 * tmpvar_54) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_52, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_17, LIGHT_PARAM.y)));
  lowp vec4 tmpvar_83;
  tmpvar_83 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_83;
  outColor_2.w = ((col_8.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  tmpvar_4.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_3 = col_8.xyz;
  tmpvar_4 = (mg_7.x * _Metallic);
  tmpvar_5 = (mg_7.y * _Smoothness);
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_13;
  highp vec4 tmpvar_14;
  tmpvar_14 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_13.w = tmpvar_14.w;
  shadowCoord_13.xyz = (tmpvar_14.xyz / tmpvar_14.w);
  shadowCoord_13.xyz = ((shadowCoord_13.xyz * 0.5) + 0.5);
  shadowCoord_13.y = (1.0 - shadowCoord_13.y);
  highp vec3 fetchesOffsetsV_15;
  highp vec3 fetchesOffsetsU_16;
  highp float shadow_17;
  highp vec2 tmpvar_18;
  tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_19;
  tmpvar_19 = floor((tmpvar_18 + 0.5));
  highp vec2 tmpvar_20;
  tmpvar_20 = (tmpvar_18 - tmpvar_19);
  highp vec3 texelsWeightsA_21;
  highp vec3 texelsWeightsB_22;
  highp vec4 computedArea_23;
  highp vec4 computedAreaUncut_24;
  highp float tmpvar_25;
  tmpvar_25 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_25 - tmpvar_20.x);
  computedArea_23.x = tmpvar_26;
  computedAreaUncut_24.x = tmpvar_26;
  computedArea_23.w = tmpvar_25;
  computedAreaUncut_24.w = tmpvar_25;
  computedAreaUncut_24.y = ((1.5 - tmpvar_20.x) - 0.5);
  highp float tmpvar_27;
  tmpvar_27 = min (tmpvar_20.x, 0.0);
  computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
  computedAreaUncut_24.z = ((1.5 + tmpvar_20.x) - 0.5);
  highp float tmpvar_28;
  tmpvar_28 = max (tmpvar_20.x, 0.0);
  computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
  texelsWeightsA_21.x = (0.16 * tmpvar_26);
  texelsWeightsA_21.y = (0.16 * computedAreaUncut_24.y);
  texelsWeightsA_21.z = (0.16 * (computedArea_23.y + 1.0));
  texelsWeightsB_22.x = (0.16 * (computedArea_23.z + 1.0));
  texelsWeightsB_22.y = (0.16 * computedAreaUncut_24.z);
  texelsWeightsB_22.z = (0.16 * tmpvar_25);
  highp vec3 texelsWeightsA_29;
  highp vec3 texelsWeightsB_30;
  highp vec4 computedArea_31;
  highp vec4 computedAreaUncut_32;
  highp float tmpvar_33;
  tmpvar_33 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
  highp float tmpvar_34;
  tmpvar_34 = (tmpvar_33 - tmpvar_20.y);
  computedArea_31.x = tmpvar_34;
  computedAreaUncut_32.x = tmpvar_34;
  computedArea_31.w = tmpvar_33;
  computedAreaUncut_32.w = tmpvar_33;
  computedAreaUncut_32.y = ((1.5 - tmpvar_20.y) - 0.5);
  highp float tmpvar_35;
  tmpvar_35 = min (tmpvar_20.y, 0.0);
  computedArea_31.y = (computedAreaUncut_32.y - (tmpvar_35 * tmpvar_35));
  computedAreaUncut_32.z = ((1.5 + tmpvar_20.y) - 0.5);
  highp float tmpvar_36;
  tmpvar_36 = max (tmpvar_20.y, 0.0);
  computedArea_31.z = (computedAreaUncut_32.z - (tmpvar_36 * tmpvar_36));
  texelsWeightsA_29.x = (0.16 * tmpvar_34);
  texelsWeightsA_29.y = (0.16 * computedAreaUncut_32.y);
  texelsWeightsA_29.z = (0.16 * (computedArea_31.y + 1.0));
  texelsWeightsB_30.x = (0.16 * (computedArea_31.z + 1.0));
  texelsWeightsB_30.y = (0.16 * computedAreaUncut_32.z);
  texelsWeightsB_30.z = (0.16 * tmpvar_33);
  highp vec3 tmpvar_37;
  tmpvar_37.xy = texelsWeightsA_21.xz;
  tmpvar_37.z = texelsWeightsB_22.y;
  highp vec3 tmpvar_38;
  tmpvar_38.x = texelsWeightsA_21.y;
  tmpvar_38.yz = texelsWeightsB_22.xz;
  highp vec3 tmpvar_39;
  tmpvar_39 = (tmpvar_37 + tmpvar_38);
  highp vec3 tmpvar_40;
  tmpvar_40.xy = texelsWeightsA_29.xz;
  tmpvar_40.z = texelsWeightsB_30.y;
  highp vec3 tmpvar_41;
  tmpvar_41.x = texelsWeightsA_29.y;
  tmpvar_41.yz = texelsWeightsB_30.xz;
  highp vec3 tmpvar_42;
  tmpvar_42 = (tmpvar_40 + tmpvar_41);
  highp vec3 tmpvar_43;
  tmpvar_43.x = texelsWeightsA_21.y;
  tmpvar_43.yz = texelsWeightsB_22.xz;
  highp vec3 tmpvar_44;
  tmpvar_44.x = texelsWeightsA_29.y;
  tmpvar_44.yz = texelsWeightsB_30.xz;
  fetchesOffsetsU_16 = (((tmpvar_43 / tmpvar_39) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
  fetchesOffsetsV_15 = (((tmpvar_44 / tmpvar_42) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
  highp vec2 tmpvar_45;
  tmpvar_45 = (tmpvar_19 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_46;
  tmpvar_46.x = fetchesOffsetsU_16.x;
  tmpvar_46.y = fetchesOffsetsV_15.x;
  highp vec3 tmpvar_47;
  tmpvar_47.xy = (tmpvar_45 + tmpvar_46);
  tmpvar_47.z = shadowCoord_13.z;
  lowp float tmpvar_48;
  tmpvar_48 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_47);
  shadow_17 = ((tmpvar_39.x * tmpvar_42.x) * tmpvar_48);
  highp vec2 tmpvar_49;
  tmpvar_49.x = fetchesOffsetsU_16.y;
  tmpvar_49.y = fetchesOffsetsV_15.x;
  highp vec3 tmpvar_50;
  tmpvar_50.xy = (tmpvar_45 + tmpvar_49);
  tmpvar_50.z = shadowCoord_13.z;
  lowp float tmpvar_51;
  tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
  shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.x) * tmpvar_51));
  highp vec2 tmpvar_52;
  tmpvar_52.x = fetchesOffsetsU_16.z;
  tmpvar_52.y = fetchesOffsetsV_15.x;
  highp vec3 tmpvar_53;
  tmpvar_53.xy = (tmpvar_45 + tmpvar_52);
  tmpvar_53.z = shadowCoord_13.z;
  lowp float tmpvar_54;
  tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
  shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.x) * tmpvar_54));
  highp vec2 tmpvar_55;
  tmpvar_55.x = fetchesOffsetsU_16.x;
  tmpvar_55.y = fetchesOffsetsV_15.y;
  highp vec3 tmpvar_56;
  tmpvar_56.xy = (tmpvar_45 + tmpvar_55);
  tmpvar_56.z = shadowCoord_13.z;
  lowp float tmpvar_57;
  tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
  shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.y) * tmpvar_57));
  highp vec2 tmpvar_58;
  tmpvar_58.x = fetchesOffsetsU_16.y;
  tmpvar_58.y = fetchesOffsetsV_15.y;
  highp vec3 tmpvar_59;
  tmpvar_59.xy = (tmpvar_45 + tmpvar_58);
  tmpvar_59.z = shadowCoord_13.z;
  lowp float tmpvar_60;
  tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
  shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.y) * tmpvar_60));
  highp vec2 tmpvar_61;
  tmpvar_61.x = fetchesOffsetsU_16.z;
  tmpvar_61.y = fetchesOffsetsV_15.y;
  highp vec3 tmpvar_62;
  tmpvar_62.xy = (tmpvar_45 + tmpvar_61);
  tmpvar_62.z = shadowCoord_13.z;
  lowp float tmpvar_63;
  tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
  shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.y) * tmpvar_63));
  highp vec2 tmpvar_64;
  tmpvar_64.x = fetchesOffsetsU_16.x;
  tmpvar_64.y = fetchesOffsetsV_15.z;
  highp vec3 tmpvar_65;
  tmpvar_65.xy = (tmpvar_45 + tmpvar_64);
  tmpvar_65.z = shadowCoord_13.z;
  lowp float tmpvar_66;
  tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
  shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.z) * tmpvar_66));
  highp vec2 tmpvar_67;
  tmpvar_67.x = fetchesOffsetsU_16.y;
  tmpvar_67.y = fetchesOffsetsV_15.z;
  highp vec3 tmpvar_68;
  tmpvar_68.xy = (tmpvar_45 + tmpvar_67);
  tmpvar_68.z = shadowCoord_13.z;
  lowp float tmpvar_69;
  tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
  shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.z) * tmpvar_69));
  highp vec2 tmpvar_70;
  tmpvar_70.x = fetchesOffsetsU_16.z;
  tmpvar_70.y = fetchesOffsetsV_15.z;
  highp vec3 tmpvar_71;
  tmpvar_71.xy = (tmpvar_45 + tmpvar_70);
  tmpvar_71.z = shadowCoord_13.z;
  lowp float tmpvar_72;
  tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
  shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.z) * tmpvar_72));
  highp vec3 tmpvar_73;
  highp vec3 tmpvar_74;
  highp vec3 lightDir_75;
  highp vec3 tmpvar_76;
  tmpvar_76 = (LIGHT_POSITION - tmpvar_12);
  highp float tmpvar_77;
  tmpvar_77 = clamp ((sqrt(
    dot (tmpvar_76, tmpvar_76)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_75 = normalize(tmpvar_76);
  tmpvar_74 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  tmpvar_73 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  highp float tmpvar_78;
  mediump float diffuseTerm_79;
  highp float perceptualRoughness_80;
  mediump vec3 tmpvar_81;
  mediump vec3 albedo_82;
  albedo_82 = tmpvar_3;
  mediump vec3 specColor_83;
  specColor_83 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_82 * tmpvar_4));
  tmpvar_81 = (albedo_82 * (0.7790837 - (tmpvar_4 * 0.7790837)));
  tmpvar_78 = 0.0;
  mediump float alpha_84;
  alpha_84 = tmpvar_78;
  tmpvar_78 = alpha_84;
  mediump float tmpvar_85;
  tmpvar_85 = (1.0 - tmpvar_5);
  perceptualRoughness_80 = tmpvar_85;
  highp vec3 tmpvar_86;
  highp vec3 inVec_87;
  inVec_87 = (lightDir_75 + tmpvar_73);
  tmpvar_86 = (inVec_87 * inversesqrt(max (0.001, 
    dot (inVec_87, inVec_87)
  )));
  highp float tmpvar_88;
  tmpvar_88 = abs(dot (tmpvar_73, tmpvar_74));
  highp float tmpvar_89;
  tmpvar_89 = clamp (dot (tmpvar_74, lightDir_75), 0.0, 1.0);
  highp float tmpvar_90;
  tmpvar_90 = clamp (dot (tmpvar_74, tmpvar_86), 0.0, 1.0);
  mediump float tmpvar_91;
  highp float tmpvar_92;
  tmpvar_92 = clamp (dot (lightDir_75, tmpvar_86), 0.0, 1.0);
  tmpvar_91 = tmpvar_92;
  mediump float tmpvar_93;
  mediump float NdotV_94;
  NdotV_94 = tmpvar_88;
  mediump float NdotL_95;
  NdotL_95 = tmpvar_89;
  mediump float perceptualRoughness_96;
  perceptualRoughness_96 = perceptualRoughness_80;
  mediump float tmpvar_97;
  tmpvar_97 = (0.5 + ((2.0 * tmpvar_91) * (tmpvar_91 * perceptualRoughness_96)));
  mediump float x_98;
  x_98 = (1.0 - NdotL_95);
  mediump float x_99;
  x_99 = (1.0 - NdotV_94);
  tmpvar_93 = ((1.0 + (
    (tmpvar_97 - 1.0)
   * 
    ((x_98 * x_98) * ((x_98 * x_98) * x_98))
  )) * (1.0 + (
    (tmpvar_97 - 1.0)
   * 
    ((x_99 * x_99) * ((x_99 * x_99) * x_99))
  )));
  highp float tmpvar_100;
  tmpvar_100 = (tmpvar_93 * tmpvar_89);
  diffuseTerm_79 = tmpvar_100;
  highp float tmpvar_101;
  tmpvar_101 = max ((perceptualRoughness_80 * perceptualRoughness_80), 0.002);
  highp float tmpvar_102;
  tmpvar_102 = (tmpvar_101 * tmpvar_101);
  highp float tmpvar_103;
  tmpvar_103 = (((
    (tmpvar_90 * tmpvar_102)
   - tmpvar_90) * tmpvar_90) + 1.0);
  mediump vec3 tmpvar_104;
  mediump float x_105;
  x_105 = (1.0 - tmpvar_91);
  tmpvar_104 = (specColor_83 + ((1.0 - specColor_83) * (
    (x_105 * x_105)
   * 
    ((x_105 * x_105) * x_105)
  )));
  outColor_2.xyz = (((
    (tmpvar_81 * LIGHT_COLOR)
   * diffuseTerm_79) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_102)
       / 
        ((tmpvar_103 * tmpvar_103) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_89 * (
          (tmpvar_88 * (1.0 - tmpvar_101))
         + tmpvar_101)) + (tmpvar_88 * (
          (tmpvar_89 * (1.0 - tmpvar_101))
         + tmpvar_101))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_89)) * LIGHT_COLOR)
   * tmpvar_104)) * ((
    ((1.0 - tmpvar_77) / ((LIGHT_ATTENUATION.x + (tmpvar_77 * LIGHT_ATTENUATION.y)) + ((tmpvar_77 * tmpvar_77) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_75, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_17, LIGHT_PARAM.y)));
  lowp vec4 tmpvar_106;
  tmpvar_106 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_106;
  outColor_2.w = ((col_8.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  tmpvar_4.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_3 = col_8.xyz;
  tmpvar_4 = (mg_7.x * _Metallic);
  tmpvar_5 = (mg_7.y * _Smoothness);
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_13;
  highp vec4 tmpvar_14;
  tmpvar_14 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_13.w = tmpvar_14.w;
  shadowCoord_13.xyz = (tmpvar_14.xyz / tmpvar_14.w);
  shadowCoord_13.xyz = ((shadowCoord_13.xyz * 0.5) + 0.5);
  shadowCoord_13.y = (1.0 - shadowCoord_13.y);
  highp vec4 fetchesOffsetsV_15;
  highp vec4 fetchesOffsetsU_16;
  highp float shadow_17;
  highp vec2 tmpvar_18;
  tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_19;
  tmpvar_19 = floor((tmpvar_18 + 0.5));
  highp vec2 tmpvar_20;
  tmpvar_20 = (tmpvar_18 - tmpvar_19);
  highp vec4 texelsWeightsA_21;
  highp vec4 texelsWeightsB_22;
  highp vec4 computedArea_23;
  highp vec4 computedAreaUncut_24;
  highp float tmpvar_25;
  tmpvar_25 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_25 - tmpvar_20.x);
  computedArea_23.x = tmpvar_26;
  computedAreaUncut_24.x = tmpvar_26;
  computedArea_23.w = tmpvar_25;
  computedAreaUncut_24.w = tmpvar_25;
  computedAreaUncut_24.y = ((1.5 - tmpvar_20.x) - 0.5);
  highp float tmpvar_27;
  tmpvar_27 = min (tmpvar_20.x, 0.0);
  computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
  computedAreaUncut_24.z = ((1.5 + tmpvar_20.x) - 0.5);
  highp float tmpvar_28;
  tmpvar_28 = max (tmpvar_20.x, 0.0);
  computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
  texelsWeightsA_21.x = (0.081632 * tmpvar_26);
  texelsWeightsA_21.y = (0.081632 * computedAreaUncut_24.y);
  texelsWeightsA_21.z = (0.081632 * (computedAreaUncut_24.y + 1.0));
  texelsWeightsA_21.w = (0.081632 * (computedArea_23.y + 2.0));
  texelsWeightsB_22.x = (0.081632 * (computedArea_23.z + 2.0));
  texelsWeightsB_22.y = (0.081632 * (computedAreaUncut_24.z + 1.0));
  texelsWeightsB_22.z = (0.081632 * computedAreaUncut_24.z);
  texelsWeightsB_22.w = (0.081632 * tmpvar_25);
  highp vec4 texelsWeightsA_29;
  highp vec4 texelsWeightsB_30;
  highp vec4 computedArea_31;
  highp vec4 computedAreaUncut_32;
  highp float tmpvar_33;
  tmpvar_33 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
  highp float tmpvar_34;
  tmpvar_34 = (tmpvar_33 - tmpvar_20.y);
  computedArea_31.x = tmpvar_34;
  computedAreaUncut_32.x = tmpvar_34;
  computedArea_31.w = tmpvar_33;
  computedAreaUncut_32.w = tmpvar_33;
  computedAreaUncut_32.y = ((1.5 - tmpvar_20.y) - 0.5);
  highp float tmpvar_35;
  tmpvar_35 = min (tmpvar_20.y, 0.0);
  computedArea_31.y = (computedAreaUncut_32.y - (tmpvar_35 * tmpvar_35));
  computedAreaUncut_32.z = ((1.5 + tmpvar_20.y) - 0.5);
  highp float tmpvar_36;
  tmpvar_36 = max (tmpvar_20.y, 0.0);
  computedArea_31.z = (computedAreaUncut_32.z - (tmpvar_36 * tmpvar_36));
  texelsWeightsA_29.x = (0.081632 * tmpvar_34);
  texelsWeightsA_29.y = (0.081632 * computedAreaUncut_32.y);
  texelsWeightsA_29.z = (0.081632 * (computedAreaUncut_32.y + 1.0));
  texelsWeightsA_29.w = (0.081632 * (computedArea_31.y + 2.0));
  texelsWeightsB_30.x = (0.081632 * (computedArea_31.z + 2.0));
  texelsWeightsB_30.y = (0.081632 * (computedAreaUncut_32.z + 1.0));
  texelsWeightsB_30.z = (0.081632 * computedAreaUncut_32.z);
  texelsWeightsB_30.w = (0.081632 * tmpvar_33);
  highp vec4 tmpvar_37;
  tmpvar_37.xy = texelsWeightsA_21.xz;
  tmpvar_37.zw = texelsWeightsB_22.xz;
  highp vec4 tmpvar_38;
  tmpvar_38.xy = texelsWeightsA_21.yw;
  tmpvar_38.zw = texelsWeightsB_22.yw;
  highp vec4 tmpvar_39;
  tmpvar_39 = (tmpvar_37 + tmpvar_38);
  highp vec4 tmpvar_40;
  tmpvar_40.xy = texelsWeightsA_29.xz;
  tmpvar_40.zw = texelsWeightsB_30.xz;
  highp vec4 tmpvar_41;
  tmpvar_41.xy = texelsWeightsA_29.yw;
  tmpvar_41.zw = texelsWeightsB_30.yw;
  highp vec4 tmpvar_42;
  tmpvar_42 = (tmpvar_40 + tmpvar_41);
  highp vec4 tmpvar_43;
  tmpvar_43.xy = texelsWeightsA_21.yw;
  tmpvar_43.zw = texelsWeightsB_22.yw;
  highp vec4 tmpvar_44;
  tmpvar_44.xy = texelsWeightsA_29.yw;
  tmpvar_44.zw = texelsWeightsB_30.yw;
  fetchesOffsetsU_16 = (((tmpvar_43 / tmpvar_39) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
  fetchesOffsetsV_15 = (((tmpvar_44 / tmpvar_42) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
  highp vec2 tmpvar_45;
  tmpvar_45 = (tmpvar_19 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_46;
  tmpvar_46.x = fetchesOffsetsU_16.x;
  tmpvar_46.y = fetchesOffsetsV_15.x;
  highp vec3 tmpvar_47;
  tmpvar_47.xy = (tmpvar_45 + tmpvar_46);
  tmpvar_47.z = shadowCoord_13.z;
  lowp float tmpvar_48;
  tmpvar_48 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_47);
  shadow_17 = ((tmpvar_39.x * tmpvar_42.x) * tmpvar_48);
  highp vec2 tmpvar_49;
  tmpvar_49.x = fetchesOffsetsU_16.y;
  tmpvar_49.y = fetchesOffsetsV_15.x;
  highp vec3 tmpvar_50;
  tmpvar_50.xy = (tmpvar_45 + tmpvar_49);
  tmpvar_50.z = shadowCoord_13.z;
  lowp float tmpvar_51;
  tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
  shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.x) * tmpvar_51));
  highp vec2 tmpvar_52;
  tmpvar_52.x = fetchesOffsetsU_16.z;
  tmpvar_52.y = fetchesOffsetsV_15.x;
  highp vec3 tmpvar_53;
  tmpvar_53.xy = (tmpvar_45 + tmpvar_52);
  tmpvar_53.z = shadowCoord_13.z;
  lowp float tmpvar_54;
  tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
  shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.x) * tmpvar_54));
  highp vec2 tmpvar_55;
  tmpvar_55.x = fetchesOffsetsU_16.w;
  tmpvar_55.y = fetchesOffsetsV_15.x;
  highp vec3 tmpvar_56;
  tmpvar_56.xy = (tmpvar_45 + tmpvar_55);
  tmpvar_56.z = shadowCoord_13.z;
  lowp float tmpvar_57;
  tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
  shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.x) * tmpvar_57));
  highp vec2 tmpvar_58;
  tmpvar_58.x = fetchesOffsetsU_16.x;
  tmpvar_58.y = fetchesOffsetsV_15.y;
  highp vec3 tmpvar_59;
  tmpvar_59.xy = (tmpvar_45 + tmpvar_58);
  tmpvar_59.z = shadowCoord_13.z;
  lowp float tmpvar_60;
  tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
  shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.y) * tmpvar_60));
  highp vec2 tmpvar_61;
  tmpvar_61.x = fetchesOffsetsU_16.y;
  tmpvar_61.y = fetchesOffsetsV_15.y;
  highp vec3 tmpvar_62;
  tmpvar_62.xy = (tmpvar_45 + tmpvar_61);
  tmpvar_62.z = shadowCoord_13.z;
  lowp float tmpvar_63;
  tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
  shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.y) * tmpvar_63));
  highp vec2 tmpvar_64;
  tmpvar_64.x = fetchesOffsetsU_16.z;
  tmpvar_64.y = fetchesOffsetsV_15.y;
  highp vec3 tmpvar_65;
  tmpvar_65.xy = (tmpvar_45 + tmpvar_64);
  tmpvar_65.z = shadowCoord_13.z;
  lowp float tmpvar_66;
  tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
  shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.y) * tmpvar_66));
  highp vec2 tmpvar_67;
  tmpvar_67.x = fetchesOffsetsU_16.w;
  tmpvar_67.y = fetchesOffsetsV_15.y;
  highp vec3 tmpvar_68;
  tmpvar_68.xy = (tmpvar_45 + tmpvar_67);
  tmpvar_68.z = shadowCoord_13.z;
  lowp float tmpvar_69;
  tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
  shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.y) * tmpvar_69));
  highp vec2 tmpvar_70;
  tmpvar_70.x = fetchesOffsetsU_16.x;
  tmpvar_70.y = fetchesOffsetsV_15.z;
  highp vec3 tmpvar_71;
  tmpvar_71.xy = (tmpvar_45 + tmpvar_70);
  tmpvar_71.z = shadowCoord_13.z;
  lowp float tmpvar_72;
  tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
  shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.z) * tmpvar_72));
  highp vec2 tmpvar_73;
  tmpvar_73.x = fetchesOffsetsU_16.y;
  tmpvar_73.y = fetchesOffsetsV_15.z;
  highp vec3 tmpvar_74;
  tmpvar_74.xy = (tmpvar_45 + tmpvar_73);
  tmpvar_74.z = shadowCoord_13.z;
  lowp float tmpvar_75;
  tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
  shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.z) * tmpvar_75));
  highp vec2 tmpvar_76;
  tmpvar_76.x = fetchesOffsetsU_16.z;
  tmpvar_76.y = fetchesOffsetsV_15.z;
  highp vec3 tmpvar_77;
  tmpvar_77.xy = (tmpvar_45 + tmpvar_76);
  tmpvar_77.z = shadowCoord_13.z;
  lowp float tmpvar_78;
  tmpvar_78 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_77);
  shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.z) * tmpvar_78));
  highp vec2 tmpvar_79;
  tmpvar_79.x = fetchesOffsetsU_16.w;
  tmpvar_79.y = fetchesOffsetsV_15.z;
  highp vec3 tmpvar_80;
  tmpvar_80.xy = (tmpvar_45 + tmpvar_79);
  tmpvar_80.z = shadowCoord_13.z;
  lowp float tmpvar_81;
  tmpvar_81 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_80);
  shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.z) * tmpvar_81));
  highp vec2 tmpvar_82;
  tmpvar_82.x = fetchesOffsetsU_16.x;
  tmpvar_82.y = fetchesOffsetsV_15.w;
  highp vec3 tmpvar_83;
  tmpvar_83.xy = (tmpvar_45 + tmpvar_82);
  tmpvar_83.z = shadowCoord_13.z;
  lowp float tmpvar_84;
  tmpvar_84 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_83);
  shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.w) * tmpvar_84));
  highp vec2 tmpvar_85;
  tmpvar_85.x = fetchesOffsetsU_16.y;
  tmpvar_85.y = fetchesOffsetsV_15.w;
  highp vec3 tmpvar_86;
  tmpvar_86.xy = (tmpvar_45 + tmpvar_85);
  tmpvar_86.z = shadowCoord_13.z;
  lowp float tmpvar_87;
  tmpvar_87 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_86);
  shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.w) * tmpvar_87));
  highp vec2 tmpvar_88;
  tmpvar_88.x = fetchesOffsetsU_16.z;
  tmpvar_88.y = fetchesOffsetsV_15.w;
  highp vec3 tmpvar_89;
  tmpvar_89.xy = (tmpvar_45 + tmpvar_88);
  tmpvar_89.z = shadowCoord_13.z;
  lowp float tmpvar_90;
  tmpvar_90 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_89);
  shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.w) * tmpvar_90));
  highp vec2 tmpvar_91;
  tmpvar_91.x = fetchesOffsetsU_16.w;
  tmpvar_91.y = fetchesOffsetsV_15.w;
  highp vec3 tmpvar_92;
  tmpvar_92.xy = (tmpvar_45 + tmpvar_91);
  tmpvar_92.z = shadowCoord_13.z;
  lowp float tmpvar_93;
  tmpvar_93 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_92);
  shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.w) * tmpvar_93));
  highp vec3 tmpvar_94;
  highp vec3 tmpvar_95;
  highp vec3 lightDir_96;
  highp vec3 tmpvar_97;
  tmpvar_97 = (LIGHT_POSITION - tmpvar_12);
  highp float tmpvar_98;
  tmpvar_98 = clamp ((sqrt(
    dot (tmpvar_97, tmpvar_97)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_96 = normalize(tmpvar_97);
  tmpvar_95 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  tmpvar_94 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  highp float tmpvar_99;
  mediump float diffuseTerm_100;
  highp float perceptualRoughness_101;
  mediump vec3 tmpvar_102;
  mediump vec3 albedo_103;
  albedo_103 = tmpvar_3;
  mediump vec3 specColor_104;
  specColor_104 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_103 * tmpvar_4));
  tmpvar_102 = (albedo_103 * (0.7790837 - (tmpvar_4 * 0.7790837)));
  tmpvar_99 = 0.0;
  mediump float alpha_105;
  alpha_105 = tmpvar_99;
  tmpvar_99 = alpha_105;
  mediump float tmpvar_106;
  tmpvar_106 = (1.0 - tmpvar_5);
  perceptualRoughness_101 = tmpvar_106;
  highp vec3 tmpvar_107;
  highp vec3 inVec_108;
  inVec_108 = (lightDir_96 + tmpvar_94);
  tmpvar_107 = (inVec_108 * inversesqrt(max (0.001, 
    dot (inVec_108, inVec_108)
  )));
  highp float tmpvar_109;
  tmpvar_109 = abs(dot (tmpvar_94, tmpvar_95));
  highp float tmpvar_110;
  tmpvar_110 = clamp (dot (tmpvar_95, lightDir_96), 0.0, 1.0);
  highp float tmpvar_111;
  tmpvar_111 = clamp (dot (tmpvar_95, tmpvar_107), 0.0, 1.0);
  mediump float tmpvar_112;
  highp float tmpvar_113;
  tmpvar_113 = clamp (dot (lightDir_96, tmpvar_107), 0.0, 1.0);
  tmpvar_112 = tmpvar_113;
  mediump float tmpvar_114;
  mediump float NdotV_115;
  NdotV_115 = tmpvar_109;
  mediump float NdotL_116;
  NdotL_116 = tmpvar_110;
  mediump float perceptualRoughness_117;
  perceptualRoughness_117 = perceptualRoughness_101;
  mediump float tmpvar_118;
  tmpvar_118 = (0.5 + ((2.0 * tmpvar_112) * (tmpvar_112 * perceptualRoughness_117)));
  mediump float x_119;
  x_119 = (1.0 - NdotL_116);
  mediump float x_120;
  x_120 = (1.0 - NdotV_115);
  tmpvar_114 = ((1.0 + (
    (tmpvar_118 - 1.0)
   * 
    ((x_119 * x_119) * ((x_119 * x_119) * x_119))
  )) * (1.0 + (
    (tmpvar_118 - 1.0)
   * 
    ((x_120 * x_120) * ((x_120 * x_120) * x_120))
  )));
  highp float tmpvar_121;
  tmpvar_121 = (tmpvar_114 * tmpvar_110);
  diffuseTerm_100 = tmpvar_121;
  highp float tmpvar_122;
  tmpvar_122 = max ((perceptualRoughness_101 * perceptualRoughness_101), 0.002);
  highp float tmpvar_123;
  tmpvar_123 = (tmpvar_122 * tmpvar_122);
  highp float tmpvar_124;
  tmpvar_124 = (((
    (tmpvar_111 * tmpvar_123)
   - tmpvar_111) * tmpvar_111) + 1.0);
  mediump vec3 tmpvar_125;
  mediump float x_126;
  x_126 = (1.0 - tmpvar_112);
  tmpvar_125 = (specColor_104 + ((1.0 - specColor_104) * (
    (x_126 * x_126)
   * 
    ((x_126 * x_126) * x_126)
  )));
  outColor_2.xyz = (((
    (tmpvar_102 * LIGHT_COLOR)
   * diffuseTerm_100) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_123)
       / 
        ((tmpvar_124 * tmpvar_124) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_110 * (
          (tmpvar_109 * (1.0 - tmpvar_122))
         + tmpvar_122)) + (tmpvar_109 * (
          (tmpvar_110 * (1.0 - tmpvar_122))
         + tmpvar_122))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_110)) * LIGHT_COLOR)
   * tmpvar_125)) * ((
    ((1.0 - tmpvar_98) / ((LIGHT_ATTENUATION.x + (tmpvar_98 * LIGHT_ATTENUATION.y)) + ((tmpvar_98 * tmpvar_98) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_96, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_17, LIGHT_PARAM.y)));
  lowp vec4 tmpvar_127;
  tmpvar_127 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_127;
  outColor_2.w = ((col_8.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","SpotLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 row2_5;
  highp vec4 row1_6;
  highp vec4 row0_7;
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_11;
  tmpvar_11 = (int(_glesBlendIndices.w) * 3);
  row0_7 = (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.x);
  row1_6 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.x);
  row2_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.x);
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.y));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.y));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.y));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.z));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.z));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.z));
  row0_7 = (row0_7 + (ANIMATION_MATRIX_ARRAY[tmpvar_11] * _glesBlendWeight.w));
  row1_6 = (row1_6 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 1)] * _glesBlendWeight.w));
  row2_5 = (row2_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_11 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_12;
  tmpvar_12[0].x = row0_7.x;
  tmpvar_12[0].y = row0_7.y;
  tmpvar_12[0].z = row0_7.z;
  tmpvar_12[0].w = row0_7.w;
  tmpvar_12[1].x = row1_6.x;
  tmpvar_12[1].y = row1_6.y;
  tmpvar_12[1].z = row1_6.z;
  tmpvar_12[1].w = row1_6.w;
  tmpvar_12[2].x = row2_5.x;
  tmpvar_12[2].y = row2_5.y;
  tmpvar_12[2].z = row2_5.z;
  tmpvar_12[2].w = row2_5.w;
  tmpvar_12[3].x = 0.0;
  tmpvar_12[3].y = 0.0;
  tmpvar_12[3].z = 0.0;
  tmpvar_12[3].w = 1.0;
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_14;
  tmpvar_14 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_15[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_15[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_16;
  tmpvar_16[0] = tmpvar_12[0].xyz;
  tmpvar_16[1] = tmpvar_12[1].xyz;
  tmpvar_16[2] = tmpvar_12[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_15 * (_glesNormal * tmpvar_16)));
  highp mat3 tmpvar_17;
  tmpvar_17[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_17[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_17[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_18;
  tmpvar_18[0] = tmpvar_12[0].xyz;
  tmpvar_18[1] = tmpvar_12[1].xyz;
  tmpvar_18[2] = tmpvar_12[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_17 * (_glesTangent * tmpvar_18)));
  highp mat3 tmpvar_19;
  tmpvar_19[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_19[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_19[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_20;
  tmpvar_20[0] = tmpvar_12[0].xyz;
  tmpvar_20[1] = tmpvar_12[1].xyz;
  tmpvar_20[2] = tmpvar_12[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_19 * (_glesBinormal * tmpvar_20)));
  tmpvar_1.w = tmpvar_14.x;
  tmpvar_2.w = tmpvar_14.y;
  tmpvar_3.w = tmpvar_14.z;
  tmpvar_4.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_12)).xyz;
  tmpvar_4.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_13 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_12)
  )));
  xlv_TEXCOORD4 = tmpvar_4;
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 normalWorld_6;
  highp vec3 normalTangent_7;
  highp vec2 mg_8;
  highp vec4 col_9;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_9 = tmpvar_10;
  lowp vec2 tmpvar_11;
  tmpvar_11 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_8 = tmpvar_11;
  lowp vec3 tmpvar_12;
  tmpvar_12 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_7 = tmpvar_12;
  normalTangent_7 = ((normalTangent_7 * 2.0) - 1.0);
  normalWorld_6 = normalize(((
    (normalTangent_7.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_7.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_7.z * xlv_TEXCOORD1.xyz)));
  tmpvar_3 = col_9.xyz;
  tmpvar_4 = (mg_8.x * _Metallic);
  tmpvar_5 = (mg_8.y * _Smoothness);
  highp vec3 tmpvar_13;
  tmpvar_13.x = xlv_TEXCOORD1.w;
  tmpvar_13.y = xlv_TEXCOORD2.w;
  tmpvar_13.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_14;
  highp vec4 tmpvar_15;
  tmpvar_15 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_14.w = tmpvar_15.w;
  shadowCoord_14.xyz = (tmpvar_15.xyz / tmpvar_15.w);
  shadowCoord_14.xyz = ((shadowCoord_14.xyz * 0.5) + 0.5);
  shadowCoord_14.y = (1.0 - shadowCoord_14.y);
  highp vec2 fetchesOffsetsV_16;
  highp vec2 fetchesOffsetsU_17;
  highp float shadow_18;
  shadow_18 = 1.0;
  highp vec2 tmpvar_19;
  tmpvar_19 = (shadowCoord_14.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_20;
  tmpvar_20 = floor((tmpvar_19 + 0.5));
  highp vec2 tmpvar_21;
  tmpvar_21 = (tmpvar_19 - tmpvar_20);
  highp vec4 computedWeight_22;
  highp vec4 computedArea_23;
  highp vec4 computedAreaUncut_24;
  highp float tmpvar_25;
  tmpvar_25 = (((tmpvar_21.x + 0.5) * (tmpvar_21.x + 0.5)) * 0.5);
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_25 - tmpvar_21.x);
  computedArea_23.x = tmpvar_26;
  computedAreaUncut_24.x = tmpvar_26;
  computedArea_23.w = tmpvar_25;
  computedAreaUncut_24.w = tmpvar_25;
  computedAreaUncut_24.y = ((1.5 - tmpvar_21.x) - 0.5);
  highp float tmpvar_27;
  tmpvar_27 = min (tmpvar_21.x, 0.0);
  computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
  computedAreaUncut_24.z = ((1.5 + tmpvar_21.x) - 0.5);
  highp float tmpvar_28;
  tmpvar_28 = max (tmpvar_21.x, 0.0);
  computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
  computedWeight_22 = (computedArea_23 * 0.44444);
  highp vec4 computedWeight_29;
  highp vec4 computedArea_30;
  highp vec4 computedAreaUncut_31;
  highp float tmpvar_32;
  tmpvar_32 = (((tmpvar_21.y + 0.5) * (tmpvar_21.y + 0.5)) * 0.5);
  highp float tmpvar_33;
  tmpvar_33 = (tmpvar_32 - tmpvar_21.y);
  computedArea_30.x = tmpvar_33;
  computedAreaUncut_31.x = tmpvar_33;
  computedArea_30.w = tmpvar_32;
  computedAreaUncut_31.w = tmpvar_32;
  computedAreaUncut_31.y = ((1.5 - tmpvar_21.y) - 0.5);
  highp float tmpvar_34;
  tmpvar_34 = min (tmpvar_21.y, 0.0);
  computedArea_30.y = (computedAreaUncut_31.y - (tmpvar_34 * tmpvar_34));
  computedAreaUncut_31.z = ((1.5 + tmpvar_21.y) - 0.5);
  highp float tmpvar_35;
  tmpvar_35 = max (tmpvar_21.y, 0.0);
  computedArea_30.z = (computedAreaUncut_31.z - (tmpvar_35 * tmpvar_35));
  computedWeight_29 = (computedArea_30 * 0.44444);
  highp vec2 tmpvar_36;
  tmpvar_36 = (computedWeight_22.xz + computedWeight_22.yw);
  highp vec2 tmpvar_37;
  tmpvar_37 = (computedWeight_29.xz + computedWeight_29.yw);
  fetchesOffsetsU_17 = (((computedWeight_22.yw / tmpvar_36) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  fetchesOffsetsV_16 = (((computedWeight_29.yw / tmpvar_37) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  highp vec2 tmpvar_38;
  tmpvar_38 = (tmpvar_20 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_39;
  tmpvar_39.x = fetchesOffsetsU_17.x;
  tmpvar_39.y = fetchesOffsetsV_16.x;
  highp vec3 tmpvar_40;
  tmpvar_40.xy = (tmpvar_38 + tmpvar_39);
  tmpvar_40.z = shadowCoord_14.z;
  highp vec4 tmpvar_41;
  tmpvar_41 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_40.xy);
  highp float tmpvar_42;
  if ((tmpvar_41.x < shadowCoord_14.z)) {
    tmpvar_42 = 0.0;
  } else {
    tmpvar_42 = 1.0;
  };
  shadow_18 = ((tmpvar_36.x * tmpvar_37.x) * tmpvar_42);
  highp vec2 tmpvar_43;
  tmpvar_43.x = fetchesOffsetsU_17.y;
  tmpvar_43.y = fetchesOffsetsV_16.x;
  highp vec3 tmpvar_44;
  tmpvar_44.xy = (tmpvar_38 + tmpvar_43);
  tmpvar_44.z = shadowCoord_14.z;
  highp vec4 tmpvar_45;
  tmpvar_45 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_44.xy);
  highp float tmpvar_46;
  if ((tmpvar_45.x < shadowCoord_14.z)) {
    tmpvar_46 = 0.0;
  } else {
    tmpvar_46 = 1.0;
  };
  shadow_18 = (shadow_18 + ((tmpvar_36.y * tmpvar_37.x) * tmpvar_46));
  highp vec2 tmpvar_47;
  tmpvar_47.x = fetchesOffsetsU_17.x;
  tmpvar_47.y = fetchesOffsetsV_16.y;
  highp vec3 tmpvar_48;
  tmpvar_48.xy = (tmpvar_38 + tmpvar_47);
  tmpvar_48.z = shadowCoord_14.z;
  highp vec4 tmpvar_49;
  tmpvar_49 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_48.xy);
  highp float tmpvar_50;
  if ((tmpvar_49.x < shadowCoord_14.z)) {
    tmpvar_50 = 0.0;
  } else {
    tmpvar_50 = 1.0;
  };
  shadow_18 = (shadow_18 + ((tmpvar_36.x * tmpvar_37.y) * tmpvar_50));
  highp vec2 tmpvar_51;
  tmpvar_51.x = fetchesOffsetsU_17.y;
  tmpvar_51.y = fetchesOffsetsV_16.y;
  highp vec3 tmpvar_52;
  tmpvar_52.xy = (tmpvar_38 + tmpvar_51);
  tmpvar_52.z = shadowCoord_14.z;
  highp vec4 tmpvar_53;
  tmpvar_53 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_52.xy);
  highp float tmpvar_54;
  if ((tmpvar_53.x < shadowCoord_14.z)) {
    tmpvar_54 = 0.0;
  } else {
    tmpvar_54 = 1.0;
  };
  shadow_18 = (shadow_18 + ((tmpvar_36.y * tmpvar_37.y) * tmpvar_54));
  highp vec3 tmpvar_55;
  highp vec3 lightDir_56;
  highp vec3 tmpvar_57;
  tmpvar_57 = (LIGHT_POSITION - tmpvar_13);
  highp float tmpvar_58;
  tmpvar_58 = clamp ((sqrt(
    dot (tmpvar_57, tmpvar_57)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_56 = normalize(tmpvar_57);
  tmpvar_55 = normalize((CAMERA_WORLDPOSITION - tmpvar_13));
  highp float tmpvar_59;
  mediump float diffuseTerm_60;
  highp float perceptualRoughness_61;
  mediump vec3 tmpvar_62;
  mediump vec3 albedo_63;
  albedo_63 = tmpvar_3;
  mediump vec3 specColor_64;
  specColor_64 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_63 * tmpvar_4));
  tmpvar_62 = (albedo_63 * (0.7790837 - (tmpvar_4 * 0.7790837)));
  tmpvar_59 = 0.0;
  mediump float alpha_65;
  alpha_65 = tmpvar_59;
  tmpvar_59 = alpha_65;
  mediump float tmpvar_66;
  tmpvar_66 = (1.0 - tmpvar_5);
  perceptualRoughness_61 = tmpvar_66;
  highp vec3 tmpvar_67;
  highp vec3 inVec_68;
  inVec_68 = (lightDir_56 + tmpvar_55);
  tmpvar_67 = (inVec_68 * inversesqrt(max (0.001, 
    dot (inVec_68, inVec_68)
  )));
  highp float tmpvar_69;
  tmpvar_69 = abs(dot (tmpvar_55, normalWorld_6));
  highp float tmpvar_70;
  tmpvar_70 = clamp (dot (normalWorld_6, lightDir_56), 0.0, 1.0);
  highp float tmpvar_71;
  tmpvar_71 = clamp (dot (normalWorld_6, tmpvar_67), 0.0, 1.0);
  mediump float tmpvar_72;
  highp float tmpvar_73;
  tmpvar_73 = clamp (dot (lightDir_56, tmpvar_67), 0.0, 1.0);
  tmpvar_72 = tmpvar_73;
  mediump float tmpvar_74;
  mediump float NdotV_75;
  NdotV_75 = tmpvar_69;
  mediump float NdotL_76;
  NdotL_76 = tmpvar_70;
  mediump float perceptualRoughness_77;
  perceptualRoughness_77 = perceptualRoughness_61;
  mediump float tmpvar_78;
  tmpvar_78 = (0.5 + ((2.0 * tmpvar_72) * (tmpvar_72 * perceptualRoughness_77)));
  mediump float x_79;
  x_79 = (1.0 - NdotL_76);
  mediump float x_80;
  x_80 = (1.0 - NdotV_75);
  tmpvar_74 = ((1.0 + (
    (tmpvar_78 - 1.0)
   * 
    ((x_79 * x_79) * ((x_79 * x_79) * x_79))
  )) * (1.0 + (
    (tmpvar_78 - 1.0)
   * 
    ((x_80 * x_80) * ((x_80 * x_80) * x_80))
  )));
  highp float tmpvar_81;
  tmpvar_81 = (tmpvar_74 * tmpvar_70);
  diffuseTerm_60 = tmpvar_81;
  highp float tmpvar_82;
  tmpvar_82 = max ((perceptualRoughness_61 * perceptualRoughness_61), 0.002);
  highp float tmpvar_83;
  tmpvar_83 = (tmpvar_82 * tmpvar_82);
  highp float tmpvar_84;
  tmpvar_84 = (((
    (tmpvar_71 * tmpvar_83)
   - tmpvar_71) * tmpvar_71) + 1.0);
  mediump vec3 tmpvar_85;
  mediump float x_86;
  x_86 = (1.0 - tmpvar_72);
  tmpvar_85 = (specColor_64 + ((1.0 - specColor_64) * (
    (x_86 * x_86)
   * 
    ((x_86 * x_86) * x_86)
  )));
  outColor_2.xyz = (((
    (tmpvar_62 * LIGHT_COLOR)
   * diffuseTerm_60) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_83)
       / 
        ((tmpvar_84 * tmpvar_84) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_70 * (
          (tmpvar_69 * (1.0 - tmpvar_82))
         + tmpvar_82)) + (tmpvar_69 * (
          (tmpvar_70 * (1.0 - tmpvar_82))
         + tmpvar_82))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_70)) * LIGHT_COLOR)
   * tmpvar_85)) * ((
    ((1.0 - tmpvar_58) / ((LIGHT_ATTENUATION.x + (tmpvar_58 * LIGHT_ATTENUATION.y)) + ((tmpvar_58 * tmpvar_58) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_56, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_18, LIGHT_PARAM.y)));
  lowp vec4 tmpvar_87;
  tmpvar_87 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_87;
  outColor_2.w = ((col_9.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","PointLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = tmpvar_11[0].xyz;
  tmpvar_15[1] = tmpvar_11[1].xyz;
  tmpvar_15[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_16[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_16[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = tmpvar_11[0].xyz;
  tmpvar_17[1] = tmpvar_11[1].xyz;
  tmpvar_17[2] = tmpvar_11[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_11[0].xyz;
  tmpvar_19[1] = tmpvar_11[1].xyz;
  tmpvar_19[2] = tmpvar_11[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_3 = col_8.xyz;
  tmpvar_4 = (mg_7.x * _Metallic);
  tmpvar_5 = (mg_7.y * _Smoothness);
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  highp vec3 tmpvar_15;
  highp vec3 tmpvar_16;
  tmpvar_16 = (LIGHT_POSITION - tmpvar_12);
  highp float tmpvar_17;
  tmpvar_17 = clamp ((sqrt(
    dot (tmpvar_16, tmpvar_16)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  tmpvar_15 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  tmpvar_13 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  tmpvar_14 = normalize(tmpvar_16);
  highp float tmpvar_18;
  mediump float diffuseTerm_19;
  highp float perceptualRoughness_20;
  mediump vec3 tmpvar_21;
  mediump vec3 albedo_22;
  albedo_22 = tmpvar_3;
  mediump vec3 specColor_23;
  specColor_23 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_22 * tmpvar_4));
  tmpvar_21 = (albedo_22 * (0.7790837 - (tmpvar_4 * 0.7790837)));
  tmpvar_18 = 0.0;
  mediump float alpha_24;
  alpha_24 = tmpvar_18;
  tmpvar_18 = alpha_24;
  mediump float tmpvar_25;
  tmpvar_25 = (1.0 - tmpvar_5);
  perceptualRoughness_20 = tmpvar_25;
  highp vec3 tmpvar_26;
  highp vec3 inVec_27;
  inVec_27 = (tmpvar_14 + tmpvar_13);
  tmpvar_26 = (inVec_27 * inversesqrt(max (0.001, 
    dot (inVec_27, inVec_27)
  )));
  highp float tmpvar_28;
  tmpvar_28 = abs(dot (tmpvar_13, tmpvar_15));
  highp float tmpvar_29;
  tmpvar_29 = clamp (dot (tmpvar_15, tmpvar_14), 0.0, 1.0);
  highp float tmpvar_30;
  tmpvar_30 = clamp (dot (tmpvar_15, tmpvar_26), 0.0, 1.0);
  mediump float tmpvar_31;
  highp float tmpvar_32;
  tmpvar_32 = clamp (dot (tmpvar_14, tmpvar_26), 0.0, 1.0);
  tmpvar_31 = tmpvar_32;
  mediump float tmpvar_33;
  mediump float NdotV_34;
  NdotV_34 = tmpvar_28;
  mediump float NdotL_35;
  NdotL_35 = tmpvar_29;
  mediump float perceptualRoughness_36;
  perceptualRoughness_36 = perceptualRoughness_20;
  mediump float tmpvar_37;
  tmpvar_37 = (0.5 + ((2.0 * tmpvar_31) * (tmpvar_31 * perceptualRoughness_36)));
  mediump float x_38;
  x_38 = (1.0 - NdotL_35);
  mediump float x_39;
  x_39 = (1.0 - NdotV_34);
  tmpvar_33 = ((1.0 + (
    (tmpvar_37 - 1.0)
   * 
    ((x_38 * x_38) * ((x_38 * x_38) * x_38))
  )) * (1.0 + (
    (tmpvar_37 - 1.0)
   * 
    ((x_39 * x_39) * ((x_39 * x_39) * x_39))
  )));
  highp float tmpvar_40;
  tmpvar_40 = (tmpvar_33 * tmpvar_29);
  diffuseTerm_19 = tmpvar_40;
  highp float tmpvar_41;
  tmpvar_41 = max ((perceptualRoughness_20 * perceptualRoughness_20), 0.002);
  highp float tmpvar_42;
  tmpvar_42 = (tmpvar_41 * tmpvar_41);
  highp float tmpvar_43;
  tmpvar_43 = (((
    (tmpvar_30 * tmpvar_42)
   - tmpvar_30) * tmpvar_30) + 1.0);
  mediump vec3 tmpvar_44;
  mediump float x_45;
  x_45 = (1.0 - tmpvar_31);
  tmpvar_44 = (specColor_23 + ((1.0 - specColor_23) * (
    (x_45 * x_45)
   * 
    ((x_45 * x_45) * x_45)
  )));
  outColor_2.xyz = (((
    (tmpvar_21 * LIGHT_COLOR)
   * diffuseTerm_19) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_42)
       / 
        ((tmpvar_43 * tmpvar_43) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_29 * (
          (tmpvar_28 * (1.0 - tmpvar_41))
         + tmpvar_41)) + (tmpvar_28 * (
          (tmpvar_29 * (1.0 - tmpvar_41))
         + tmpvar_41))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_29)) * LIGHT_COLOR)
   * tmpvar_44)) * ((1.0 - tmpvar_17) / (
    (LIGHT_ATTENUATION.x + (tmpvar_17 * LIGHT_ATTENUATION.y))
   + 
    ((tmpvar_17 * tmpvar_17) * LIGHT_ATTENUATION.z)
  )));
  lowp vec4 tmpvar_46;
  tmpvar_46 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_46;
  outColor_2.w = ((col_8.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","PointLight","ShadowOn"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 row2_4;
  highp vec4 row1_5;
  highp vec4 row0_6;
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_10;
  tmpvar_10 = (int(_glesBlendIndices.w) * 3);
  row0_6 = (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.x);
  row1_5 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.x);
  row2_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.x);
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.y));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.y));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.y));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.z));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.z));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.z));
  row0_6 = (row0_6 + (ANIMATION_MATRIX_ARRAY[tmpvar_10] * _glesBlendWeight.w));
  row1_5 = (row1_5 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 1)] * _glesBlendWeight.w));
  row2_4 = (row2_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_10 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_11;
  tmpvar_11[0].x = row0_6.x;
  tmpvar_11[0].y = row0_6.y;
  tmpvar_11[0].z = row0_6.z;
  tmpvar_11[0].w = row0_6.w;
  tmpvar_11[1].x = row1_5.x;
  tmpvar_11[1].y = row1_5.y;
  tmpvar_11[1].z = row1_5.z;
  tmpvar_11[1].w = row1_5.w;
  tmpvar_11[2].x = row2_4.x;
  tmpvar_11[2].y = row2_4.y;
  tmpvar_11[2].z = row2_4.z;
  tmpvar_11[2].w = row2_4.w;
  tmpvar_11[3].x = 0.0;
  tmpvar_11[3].y = 0.0;
  tmpvar_11[3].z = 0.0;
  tmpvar_11[3].w = 1.0;
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec3 tmpvar_13;
  tmpvar_13 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_11)).xyz;
  highp mat3 tmpvar_14;
  tmpvar_14[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_14[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_14[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_15;
  tmpvar_15[0] = tmpvar_11[0].xyz;
  tmpvar_15[1] = tmpvar_11[1].xyz;
  tmpvar_15[2] = tmpvar_11[2].xyz;
  tmpvar_1.xyz = normalize((tmpvar_14 * (_glesNormal * tmpvar_15)));
  highp mat3 tmpvar_16;
  tmpvar_16[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_16[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_16[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_17;
  tmpvar_17[0] = tmpvar_11[0].xyz;
  tmpvar_17[1] = tmpvar_11[1].xyz;
  tmpvar_17[2] = tmpvar_11[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_16 * (_glesTangent * tmpvar_17)));
  highp mat3 tmpvar_18;
  tmpvar_18[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_18[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_18[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp mat3 tmpvar_19;
  tmpvar_19[0] = tmpvar_11[0].xyz;
  tmpvar_19[1] = tmpvar_11[1].xyz;
  tmpvar_19[2] = tmpvar_11[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_18 * (_glesBinormal * tmpvar_19)));
  tmpvar_1.w = tmpvar_13.x;
  tmpvar_2.w = tmpvar_13.y;
  tmpvar_3.w = tmpvar_13.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD2 = tmpvar_2;
  xlv_TEXCOORD3 = tmpvar_3;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (_glesVertex * tmpvar_11)
  )));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_3 = col_8.xyz;
  tmpvar_4 = (mg_7.x * _Metallic);
  tmpvar_5 = (mg_7.y * _Smoothness);
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  highp vec3 tmpvar_15;
  highp vec3 tmpvar_16;
  tmpvar_16 = (LIGHT_POSITION - tmpvar_12);
  highp float tmpvar_17;
  tmpvar_17 = clamp ((sqrt(
    dot (tmpvar_16, tmpvar_16)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  tmpvar_15 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  tmpvar_13 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  tmpvar_14 = normalize(tmpvar_16);
  highp float tmpvar_18;
  mediump float diffuseTerm_19;
  highp float perceptualRoughness_20;
  mediump vec3 tmpvar_21;
  mediump vec3 albedo_22;
  albedo_22 = tmpvar_3;
  mediump vec3 specColor_23;
  specColor_23 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_22 * tmpvar_4));
  tmpvar_21 = (albedo_22 * (0.7790837 - (tmpvar_4 * 0.7790837)));
  tmpvar_18 = 0.0;
  mediump float alpha_24;
  alpha_24 = tmpvar_18;
  tmpvar_18 = alpha_24;
  mediump float tmpvar_25;
  tmpvar_25 = (1.0 - tmpvar_5);
  perceptualRoughness_20 = tmpvar_25;
  highp vec3 tmpvar_26;
  highp vec3 inVec_27;
  inVec_27 = (tmpvar_14 + tmpvar_13);
  tmpvar_26 = (inVec_27 * inversesqrt(max (0.001, 
    dot (inVec_27, inVec_27)
  )));
  highp float tmpvar_28;
  tmpvar_28 = abs(dot (tmpvar_13, tmpvar_15));
  highp float tmpvar_29;
  tmpvar_29 = clamp (dot (tmpvar_15, tmpvar_14), 0.0, 1.0);
  highp float tmpvar_30;
  tmpvar_30 = clamp (dot (tmpvar_15, tmpvar_26), 0.0, 1.0);
  mediump float tmpvar_31;
  highp float tmpvar_32;
  tmpvar_32 = clamp (dot (tmpvar_14, tmpvar_26), 0.0, 1.0);
  tmpvar_31 = tmpvar_32;
  mediump float tmpvar_33;
  mediump float NdotV_34;
  NdotV_34 = tmpvar_28;
  mediump float NdotL_35;
  NdotL_35 = tmpvar_29;
  mediump float perceptualRoughness_36;
  perceptualRoughness_36 = perceptualRoughness_20;
  mediump float tmpvar_37;
  tmpvar_37 = (0.5 + ((2.0 * tmpvar_31) * (tmpvar_31 * perceptualRoughness_36)));
  mediump float x_38;
  x_38 = (1.0 - NdotL_35);
  mediump float x_39;
  x_39 = (1.0 - NdotV_34);
  tmpvar_33 = ((1.0 + (
    (tmpvar_37 - 1.0)
   * 
    ((x_38 * x_38) * ((x_38 * x_38) * x_38))
  )) * (1.0 + (
    (tmpvar_37 - 1.0)
   * 
    ((x_39 * x_39) * ((x_39 * x_39) * x_39))
  )));
  highp float tmpvar_40;
  tmpvar_40 = (tmpvar_33 * tmpvar_29);
  diffuseTerm_19 = tmpvar_40;
  highp float tmpvar_41;
  tmpvar_41 = max ((perceptualRoughness_20 * perceptualRoughness_20), 0.002);
  highp float tmpvar_42;
  tmpvar_42 = (tmpvar_41 * tmpvar_41);
  highp float tmpvar_43;
  tmpvar_43 = (((
    (tmpvar_30 * tmpvar_42)
   - tmpvar_30) * tmpvar_30) + 1.0);
  mediump vec3 tmpvar_44;
  mediump float x_45;
  x_45 = (1.0 - tmpvar_31);
  tmpvar_44 = (specColor_23 + ((1.0 - specColor_23) * (
    (x_45 * x_45)
   * 
    ((x_45 * x_45) * x_45)
  )));
  outColor_2.xyz = (((
    (tmpvar_21 * LIGHT_COLOR)
   * diffuseTerm_19) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_42)
       / 
        ((tmpvar_43 * tmpvar_43) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_29 * (
          (tmpvar_28 * (1.0 - tmpvar_41))
         + tmpvar_41)) + (tmpvar_28 * (
          (tmpvar_29 * (1.0 - tmpvar_41))
         + tmpvar_41))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_29)) * LIGHT_COLOR)
   * tmpvar_44)) * ((1.0 - tmpvar_17) / (
    (LIGHT_ATTENUATION.x + (tmpvar_17 * LIGHT_ATTENUATION.y))
   + 
    ((tmpvar_17 * tmpvar_17) * LIGHT_ATTENUATION.z)
  )));
  lowp vec4 tmpvar_46;
  tmpvar_46 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_46;
  outColor_2.w = ((col_8.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_9[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_9[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_3 = col_8.xyz;
  tmpvar_4 = (mg_7.x * _Metallic);
  tmpvar_5 = (mg_7.y * _Smoothness);
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  tmpvar_13 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  tmpvar_14 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_16;
  mediump float diffuseTerm_17;
  highp float perceptualRoughness_18;
  mediump vec3 tmpvar_19;
  mediump vec3 albedo_20;
  albedo_20 = tmpvar_3;
  mediump vec3 specColor_21;
  specColor_21 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_20 * tmpvar_4));
  tmpvar_19 = (albedo_20 * (0.7790837 - (tmpvar_4 * 0.7790837)));
  tmpvar_16 = 0.0;
  mediump float alpha_22;
  alpha_22 = tmpvar_16;
  tmpvar_16 = alpha_22;
  mediump float tmpvar_23;
  tmpvar_23 = (1.0 - tmpvar_5);
  perceptualRoughness_18 = tmpvar_23;
  highp vec3 tmpvar_24;
  highp vec3 inVec_25;
  inVec_25 = (tmpvar_14 + tmpvar_13);
  tmpvar_24 = (inVec_25 * inversesqrt(max (0.001, 
    dot (inVec_25, inVec_25)
  )));
  highp float tmpvar_26;
  tmpvar_26 = abs(dot (tmpvar_13, tmpvar_15));
  highp float tmpvar_27;
  tmpvar_27 = clamp (dot (tmpvar_15, tmpvar_14), 0.0, 1.0);
  highp float tmpvar_28;
  tmpvar_28 = clamp (dot (tmpvar_15, tmpvar_24), 0.0, 1.0);
  mediump float tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = clamp (dot (tmpvar_14, tmpvar_24), 0.0, 1.0);
  tmpvar_29 = tmpvar_30;
  mediump float tmpvar_31;
  mediump float NdotV_32;
  NdotV_32 = tmpvar_26;
  mediump float NdotL_33;
  NdotL_33 = tmpvar_27;
  mediump float perceptualRoughness_34;
  perceptualRoughness_34 = perceptualRoughness_18;
  mediump float tmpvar_35;
  tmpvar_35 = (0.5 + ((2.0 * tmpvar_29) * (tmpvar_29 * perceptualRoughness_34)));
  mediump float x_36;
  x_36 = (1.0 - NdotL_33);
  mediump float x_37;
  x_37 = (1.0 - NdotV_32);
  tmpvar_31 = ((1.0 + (
    (tmpvar_35 - 1.0)
   * 
    ((x_36 * x_36) * ((x_36 * x_36) * x_36))
  )) * (1.0 + (
    (tmpvar_35 - 1.0)
   * 
    ((x_37 * x_37) * ((x_37 * x_37) * x_37))
  )));
  highp float tmpvar_38;
  tmpvar_38 = (tmpvar_31 * tmpvar_27);
  diffuseTerm_17 = tmpvar_38;
  highp float tmpvar_39;
  tmpvar_39 = max ((perceptualRoughness_18 * perceptualRoughness_18), 0.002);
  highp float tmpvar_40;
  tmpvar_40 = (tmpvar_39 * tmpvar_39);
  highp float tmpvar_41;
  tmpvar_41 = (((
    (tmpvar_28 * tmpvar_40)
   - tmpvar_28) * tmpvar_28) + 1.0);
  mediump vec3 tmpvar_42;
  mediump float x_43;
  x_43 = (1.0 - tmpvar_29);
  tmpvar_42 = (specColor_21 + ((1.0 - specColor_21) * (
    (x_43 * x_43)
   * 
    ((x_43 * x_43) * x_43)
  )));
  outColor_2.xyz = (((tmpvar_19 * LIGHT_COLOR) * diffuseTerm_17) + ((
    max (0.0, (sqrt(max (0.0001, 
      ((((0.3183099 * tmpvar_40) / (
        (tmpvar_41 * tmpvar_41)
       + 1e-7)) * (0.5 / (
        ((tmpvar_27 * ((tmpvar_26 * 
          (1.0 - tmpvar_39)
        ) + tmpvar_39)) + (tmpvar_26 * ((tmpvar_27 * 
          (1.0 - tmpvar_39)
        ) + tmpvar_39)))
       + 0.0001))) * 3.141593)
    )) * tmpvar_27))
   * LIGHT_COLOR) * tmpvar_42));
  lowp vec4 tmpvar_44;
  tmpvar_44 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_44;
  outColor_2.w = ((col_8.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec3 normalTangent_7;
  highp vec2 mg_8;
  highp vec4 col_9;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_9 = tmpvar_10;
  lowp vec2 tmpvar_11;
  tmpvar_11 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_8 = tmpvar_11;
  lowp vec3 tmpvar_12;
  tmpvar_12 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_7 = tmpvar_12;
  normalTangent_7 = ((normalTangent_7 * 2.0) - 1.0);
  tmpvar_3 = col_9.xyz;
  tmpvar_4 = (mg_8.x * _Metallic);
  tmpvar_5 = (mg_8.y * _Smoothness);
  tmpvar_6 = normalize(((
    (normalTangent_7.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_7.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_13;
  tmpvar_13.x = xlv_TEXCOORD1.w;
  tmpvar_13.y = xlv_TEXCOORD2.w;
  tmpvar_13.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_14;
  shadowCoord_14 = xlv_TEXCOORD4;
  highp float tmpvar_15;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_15 = 1.0;
  } else {
    shadowCoord_14.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec2 fetchesOffsetsV_16;
    highp vec2 fetchesOffsetsU_17;
    highp float shadow_18;
    highp vec2 tmpvar_19;
    tmpvar_19 = (shadowCoord_14.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_20;
    tmpvar_20 = floor((tmpvar_19 + 0.5));
    highp vec2 tmpvar_21;
    tmpvar_21 = (tmpvar_19 - tmpvar_20);
    highp vec4 computedWeight_22;
    highp vec4 computedArea_23;
    highp vec4 computedAreaUncut_24;
    highp float tmpvar_25;
    tmpvar_25 = (((tmpvar_21.x + 0.5) * (tmpvar_21.x + 0.5)) * 0.5);
    highp float tmpvar_26;
    tmpvar_26 = (tmpvar_25 - tmpvar_21.x);
    computedArea_23.x = tmpvar_26;
    computedAreaUncut_24.x = tmpvar_26;
    computedArea_23.w = tmpvar_25;
    computedAreaUncut_24.w = tmpvar_25;
    computedAreaUncut_24.y = ((1.5 - tmpvar_21.x) - 0.5);
    highp float tmpvar_27;
    tmpvar_27 = min (tmpvar_21.x, 0.0);
    computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
    computedAreaUncut_24.z = ((1.5 + tmpvar_21.x) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = max (tmpvar_21.x, 0.0);
    computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
    computedWeight_22 = (computedArea_23 * 0.44444);
    highp vec4 computedWeight_29;
    highp vec4 computedArea_30;
    highp vec4 computedAreaUncut_31;
    highp float tmpvar_32;
    tmpvar_32 = (((tmpvar_21.y + 0.5) * (tmpvar_21.y + 0.5)) * 0.5);
    highp float tmpvar_33;
    tmpvar_33 = (tmpvar_32 - tmpvar_21.y);
    computedArea_30.x = tmpvar_33;
    computedAreaUncut_31.x = tmpvar_33;
    computedArea_30.w = tmpvar_32;
    computedAreaUncut_31.w = tmpvar_32;
    computedAreaUncut_31.y = ((1.5 - tmpvar_21.y) - 0.5);
    highp float tmpvar_34;
    tmpvar_34 = min (tmpvar_21.y, 0.0);
    computedArea_30.y = (computedAreaUncut_31.y - (tmpvar_34 * tmpvar_34));
    computedAreaUncut_31.z = ((1.5 + tmpvar_21.y) - 0.5);
    highp float tmpvar_35;
    tmpvar_35 = max (tmpvar_21.y, 0.0);
    computedArea_30.z = (computedAreaUncut_31.z - (tmpvar_35 * tmpvar_35));
    computedWeight_29 = (computedArea_30 * 0.44444);
    highp vec2 tmpvar_36;
    tmpvar_36 = (computedWeight_22.xz + computedWeight_22.yw);
    highp vec2 tmpvar_37;
    tmpvar_37 = (computedWeight_29.xz + computedWeight_29.yw);
    fetchesOffsetsU_17 = (((computedWeight_22.yw / tmpvar_36) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    fetchesOffsetsV_16 = (((computedWeight_29.yw / tmpvar_37) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
    highp vec2 tmpvar_38;
    tmpvar_38 = (tmpvar_20 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_39;
    tmpvar_39.x = fetchesOffsetsU_17.x;
    tmpvar_39.y = fetchesOffsetsV_16.x;
    highp vec3 tmpvar_40;
    tmpvar_40.xy = (tmpvar_38 + tmpvar_39);
    tmpvar_40.z = shadowCoord_14.z;
    lowp float tmpvar_41;
    tmpvar_41 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_40);
    shadow_18 = ((tmpvar_36.x * tmpvar_37.x) * tmpvar_41);
    highp vec2 tmpvar_42;
    tmpvar_42.x = fetchesOffsetsU_17.y;
    tmpvar_42.y = fetchesOffsetsV_16.x;
    highp vec3 tmpvar_43;
    tmpvar_43.xy = (tmpvar_38 + tmpvar_42);
    tmpvar_43.z = shadowCoord_14.z;
    lowp float tmpvar_44;
    tmpvar_44 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_43);
    shadow_18 = (shadow_18 + ((tmpvar_36.y * tmpvar_37.x) * tmpvar_44));
    highp vec2 tmpvar_45;
    tmpvar_45.x = fetchesOffsetsU_17.x;
    tmpvar_45.y = fetchesOffsetsV_16.y;
    highp vec3 tmpvar_46;
    tmpvar_46.xy = (tmpvar_38 + tmpvar_45);
    tmpvar_46.z = shadowCoord_14.z;
    lowp float tmpvar_47;
    tmpvar_47 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_46);
    shadow_18 = (shadow_18 + ((tmpvar_36.x * tmpvar_37.y) * tmpvar_47));
    highp vec2 tmpvar_48;
    tmpvar_48.x = fetchesOffsetsU_17.y;
    tmpvar_48.y = fetchesOffsetsV_16.y;
    highp vec3 tmpvar_49;
    tmpvar_49.xy = (tmpvar_38 + tmpvar_48);
    tmpvar_49.z = shadowCoord_14.z;
    lowp float tmpvar_50;
    tmpvar_50 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_49);
    shadow_18 = (shadow_18 + ((tmpvar_36.y * tmpvar_37.y) * tmpvar_50));
    tmpvar_15 = mix (1.0, shadow_18, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_51;
  highp vec3 tmpvar_52;
  tmpvar_51 = normalize((CAMERA_WORLDPOSITION - tmpvar_13));
  tmpvar_52 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_53;
  mediump float diffuseTerm_54;
  highp float perceptualRoughness_55;
  mediump vec3 tmpvar_56;
  mediump vec3 albedo_57;
  albedo_57 = tmpvar_3;
  mediump vec3 specColor_58;
  specColor_58 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_57 * tmpvar_4));
  tmpvar_56 = (albedo_57 * (0.7790837 - (tmpvar_4 * 0.7790837)));
  tmpvar_53 = 0.0;
  mediump float alpha_59;
  alpha_59 = tmpvar_53;
  tmpvar_53 = alpha_59;
  mediump float tmpvar_60;
  tmpvar_60 = (1.0 - tmpvar_5);
  perceptualRoughness_55 = tmpvar_60;
  highp vec3 tmpvar_61;
  highp vec3 inVec_62;
  inVec_62 = (tmpvar_52 + tmpvar_51);
  tmpvar_61 = (inVec_62 * inversesqrt(max (0.001, 
    dot (inVec_62, inVec_62)
  )));
  highp float tmpvar_63;
  tmpvar_63 = abs(dot (tmpvar_51, tmpvar_6));
  highp float tmpvar_64;
  tmpvar_64 = clamp (dot (tmpvar_6, tmpvar_52), 0.0, 1.0);
  highp float tmpvar_65;
  tmpvar_65 = clamp (dot (tmpvar_6, tmpvar_61), 0.0, 1.0);
  mediump float tmpvar_66;
  highp float tmpvar_67;
  tmpvar_67 = clamp (dot (tmpvar_52, tmpvar_61), 0.0, 1.0);
  tmpvar_66 = tmpvar_67;
  mediump float tmpvar_68;
  mediump float NdotV_69;
  NdotV_69 = tmpvar_63;
  mediump float NdotL_70;
  NdotL_70 = tmpvar_64;
  mediump float perceptualRoughness_71;
  perceptualRoughness_71 = perceptualRoughness_55;
  mediump float tmpvar_72;
  tmpvar_72 = (0.5 + ((2.0 * tmpvar_66) * (tmpvar_66 * perceptualRoughness_71)));
  mediump float x_73;
  x_73 = (1.0 - NdotL_70);
  mediump float x_74;
  x_74 = (1.0 - NdotV_69);
  tmpvar_68 = ((1.0 + (
    (tmpvar_72 - 1.0)
   * 
    ((x_73 * x_73) * ((x_73 * x_73) * x_73))
  )) * (1.0 + (
    (tmpvar_72 - 1.0)
   * 
    ((x_74 * x_74) * ((x_74 * x_74) * x_74))
  )));
  highp float tmpvar_75;
  tmpvar_75 = (tmpvar_68 * tmpvar_64);
  diffuseTerm_54 = tmpvar_75;
  highp float tmpvar_76;
  tmpvar_76 = max ((perceptualRoughness_55 * perceptualRoughness_55), 0.002);
  highp float tmpvar_77;
  tmpvar_77 = (tmpvar_76 * tmpvar_76);
  highp float tmpvar_78;
  tmpvar_78 = (((
    (tmpvar_65 * tmpvar_77)
   - tmpvar_65) * tmpvar_65) + 1.0);
  mediump vec3 tmpvar_79;
  mediump float x_80;
  x_80 = (1.0 - tmpvar_66);
  tmpvar_79 = (specColor_58 + ((1.0 - specColor_58) * (
    (x_80 * x_80)
   * 
    ((x_80 * x_80) * x_80)
  )));
  outColor_2.xyz = (((
    (tmpvar_56 * LIGHT_COLOR)
   * diffuseTerm_54) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_77)
       / 
        ((tmpvar_78 * tmpvar_78) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_64 * (
          (tmpvar_63 * (1.0 - tmpvar_76))
         + tmpvar_76)) + (tmpvar_63 * (
          (tmpvar_64 * (1.0 - tmpvar_76))
         + tmpvar_76))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_64)) * LIGHT_COLOR)
   * tmpvar_79)) * tmpvar_15);
  lowp vec4 tmpvar_81;
  tmpvar_81 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_81;
  outColor_2.w = ((col_9.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec3 normalTangent_7;
  highp vec2 mg_8;
  highp vec4 col_9;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_9 = tmpvar_10;
  lowp vec2 tmpvar_11;
  tmpvar_11 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_8 = tmpvar_11;
  lowp vec3 tmpvar_12;
  tmpvar_12 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_7 = tmpvar_12;
  normalTangent_7 = ((normalTangent_7 * 2.0) - 1.0);
  tmpvar_3 = col_9.xyz;
  tmpvar_4 = (mg_8.x * _Metallic);
  tmpvar_5 = (mg_8.y * _Smoothness);
  tmpvar_6 = normalize(((
    (normalTangent_7.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_7.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_13;
  tmpvar_13.x = xlv_TEXCOORD1.w;
  tmpvar_13.y = xlv_TEXCOORD2.w;
  tmpvar_13.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_14;
  shadowCoord_14 = xlv_TEXCOORD4;
  highp float tmpvar_15;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_15 = 1.0;
  } else {
    shadowCoord_14.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec3 fetchesOffsetsV_16;
    highp vec3 fetchesOffsetsU_17;
    highp float shadow_18;
    highp vec2 tmpvar_19;
    tmpvar_19 = (shadowCoord_14.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_20;
    tmpvar_20 = floor((tmpvar_19 + 0.5));
    highp vec2 tmpvar_21;
    tmpvar_21 = (tmpvar_19 - tmpvar_20);
    highp vec3 texelsWeightsA_22;
    highp vec3 texelsWeightsB_23;
    highp vec4 computedArea_24;
    highp vec4 computedAreaUncut_25;
    highp float tmpvar_26;
    tmpvar_26 = (((tmpvar_21.x + 0.5) * (tmpvar_21.x + 0.5)) * 0.5);
    highp float tmpvar_27;
    tmpvar_27 = (tmpvar_26 - tmpvar_21.x);
    computedArea_24.x = tmpvar_27;
    computedAreaUncut_25.x = tmpvar_27;
    computedArea_24.w = tmpvar_26;
    computedAreaUncut_25.w = tmpvar_26;
    computedAreaUncut_25.y = ((1.5 - tmpvar_21.x) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = min (tmpvar_21.x, 0.0);
    computedArea_24.y = (computedAreaUncut_25.y - (tmpvar_28 * tmpvar_28));
    computedAreaUncut_25.z = ((1.5 + tmpvar_21.x) - 0.5);
    highp float tmpvar_29;
    tmpvar_29 = max (tmpvar_21.x, 0.0);
    computedArea_24.z = (computedAreaUncut_25.z - (tmpvar_29 * tmpvar_29));
    texelsWeightsA_22.x = (0.16 * tmpvar_27);
    texelsWeightsA_22.y = (0.16 * computedAreaUncut_25.y);
    texelsWeightsA_22.z = (0.16 * (computedArea_24.y + 1.0));
    texelsWeightsB_23.x = (0.16 * (computedArea_24.z + 1.0));
    texelsWeightsB_23.y = (0.16 * computedAreaUncut_25.z);
    texelsWeightsB_23.z = (0.16 * tmpvar_26);
    highp vec3 texelsWeightsA_30;
    highp vec3 texelsWeightsB_31;
    highp vec4 computedArea_32;
    highp vec4 computedAreaUncut_33;
    highp float tmpvar_34;
    tmpvar_34 = (((tmpvar_21.y + 0.5) * (tmpvar_21.y + 0.5)) * 0.5);
    highp float tmpvar_35;
    tmpvar_35 = (tmpvar_34 - tmpvar_21.y);
    computedArea_32.x = tmpvar_35;
    computedAreaUncut_33.x = tmpvar_35;
    computedArea_32.w = tmpvar_34;
    computedAreaUncut_33.w = tmpvar_34;
    computedAreaUncut_33.y = ((1.5 - tmpvar_21.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = min (tmpvar_21.y, 0.0);
    computedArea_32.y = (computedAreaUncut_33.y - (tmpvar_36 * tmpvar_36));
    computedAreaUncut_33.z = ((1.5 + tmpvar_21.y) - 0.5);
    highp float tmpvar_37;
    tmpvar_37 = max (tmpvar_21.y, 0.0);
    computedArea_32.z = (computedAreaUncut_33.z - (tmpvar_37 * tmpvar_37));
    texelsWeightsA_30.x = (0.16 * tmpvar_35);
    texelsWeightsA_30.y = (0.16 * computedAreaUncut_33.y);
    texelsWeightsA_30.z = (0.16 * (computedArea_32.y + 1.0));
    texelsWeightsB_31.x = (0.16 * (computedArea_32.z + 1.0));
    texelsWeightsB_31.y = (0.16 * computedAreaUncut_33.z);
    texelsWeightsB_31.z = (0.16 * tmpvar_34);
    highp vec3 tmpvar_38;
    tmpvar_38.xy = texelsWeightsA_22.xz;
    tmpvar_38.z = texelsWeightsB_23.y;
    highp vec3 tmpvar_39;
    tmpvar_39.x = texelsWeightsA_22.y;
    tmpvar_39.yz = texelsWeightsB_23.xz;
    highp vec3 tmpvar_40;
    tmpvar_40 = (tmpvar_38 + tmpvar_39);
    highp vec3 tmpvar_41;
    tmpvar_41.xy = texelsWeightsA_30.xz;
    tmpvar_41.z = texelsWeightsB_31.y;
    highp vec3 tmpvar_42;
    tmpvar_42.x = texelsWeightsA_30.y;
    tmpvar_42.yz = texelsWeightsB_31.xz;
    highp vec3 tmpvar_43;
    tmpvar_43 = (tmpvar_41 + tmpvar_42);
    highp vec3 tmpvar_44;
    tmpvar_44.x = texelsWeightsA_22.y;
    tmpvar_44.yz = texelsWeightsB_23.xz;
    highp vec3 tmpvar_45;
    tmpvar_45.x = texelsWeightsA_30.y;
    tmpvar_45.yz = texelsWeightsB_31.xz;
    fetchesOffsetsU_17 = (((tmpvar_44 / tmpvar_40) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    fetchesOffsetsV_16 = (((tmpvar_45 / tmpvar_43) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
    highp vec2 tmpvar_46;
    tmpvar_46 = (tmpvar_20 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_17.x;
    tmpvar_47.y = fetchesOffsetsV_16.x;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_46 + tmpvar_47);
    tmpvar_48.z = shadowCoord_14.z;
    lowp float tmpvar_49;
    tmpvar_49 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_18 = ((tmpvar_40.x * tmpvar_43.x) * tmpvar_49);
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_17.y;
    tmpvar_50.y = fetchesOffsetsV_16.x;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_46 + tmpvar_50);
    tmpvar_51.z = shadowCoord_14.z;
    lowp float tmpvar_52;
    tmpvar_52 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_18 = (shadow_18 + ((tmpvar_40.y * tmpvar_43.x) * tmpvar_52));
    highp vec2 tmpvar_53;
    tmpvar_53.x = fetchesOffsetsU_17.z;
    tmpvar_53.y = fetchesOffsetsV_16.x;
    highp vec3 tmpvar_54;
    tmpvar_54.xy = (tmpvar_46 + tmpvar_53);
    tmpvar_54.z = shadowCoord_14.z;
    lowp float tmpvar_55;
    tmpvar_55 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_54);
    shadow_18 = (shadow_18 + ((tmpvar_40.z * tmpvar_43.x) * tmpvar_55));
    highp vec2 tmpvar_56;
    tmpvar_56.x = fetchesOffsetsU_17.x;
    tmpvar_56.y = fetchesOffsetsV_16.y;
    highp vec3 tmpvar_57;
    tmpvar_57.xy = (tmpvar_46 + tmpvar_56);
    tmpvar_57.z = shadowCoord_14.z;
    lowp float tmpvar_58;
    tmpvar_58 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_57);
    shadow_18 = (shadow_18 + ((tmpvar_40.x * tmpvar_43.y) * tmpvar_58));
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_17.y;
    tmpvar_59.y = fetchesOffsetsV_16.y;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_46 + tmpvar_59);
    tmpvar_60.z = shadowCoord_14.z;
    lowp float tmpvar_61;
    tmpvar_61 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_18 = (shadow_18 + ((tmpvar_40.y * tmpvar_43.y) * tmpvar_61));
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_17.z;
    tmpvar_62.y = fetchesOffsetsV_16.y;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_46 + tmpvar_62);
    tmpvar_63.z = shadowCoord_14.z;
    lowp float tmpvar_64;
    tmpvar_64 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_18 = (shadow_18 + ((tmpvar_40.z * tmpvar_43.y) * tmpvar_64));
    highp vec2 tmpvar_65;
    tmpvar_65.x = fetchesOffsetsU_17.x;
    tmpvar_65.y = fetchesOffsetsV_16.z;
    highp vec3 tmpvar_66;
    tmpvar_66.xy = (tmpvar_46 + tmpvar_65);
    tmpvar_66.z = shadowCoord_14.z;
    lowp float tmpvar_67;
    tmpvar_67 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_66);
    shadow_18 = (shadow_18 + ((tmpvar_40.x * tmpvar_43.z) * tmpvar_67));
    highp vec2 tmpvar_68;
    tmpvar_68.x = fetchesOffsetsU_17.y;
    tmpvar_68.y = fetchesOffsetsV_16.z;
    highp vec3 tmpvar_69;
    tmpvar_69.xy = (tmpvar_46 + tmpvar_68);
    tmpvar_69.z = shadowCoord_14.z;
    lowp float tmpvar_70;
    tmpvar_70 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_69);
    shadow_18 = (shadow_18 + ((tmpvar_40.y * tmpvar_43.z) * tmpvar_70));
    highp vec2 tmpvar_71;
    tmpvar_71.x = fetchesOffsetsU_17.z;
    tmpvar_71.y = fetchesOffsetsV_16.z;
    highp vec3 tmpvar_72;
    tmpvar_72.xy = (tmpvar_46 + tmpvar_71);
    tmpvar_72.z = shadowCoord_14.z;
    lowp float tmpvar_73;
    tmpvar_73 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_72);
    shadow_18 = (shadow_18 + ((tmpvar_40.z * tmpvar_43.z) * tmpvar_73));
    tmpvar_15 = mix (1.0, shadow_18, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_74;
  highp vec3 tmpvar_75;
  tmpvar_74 = normalize((CAMERA_WORLDPOSITION - tmpvar_13));
  tmpvar_75 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_76;
  mediump float diffuseTerm_77;
  highp float perceptualRoughness_78;
  mediump vec3 tmpvar_79;
  mediump vec3 albedo_80;
  albedo_80 = tmpvar_3;
  mediump vec3 specColor_81;
  specColor_81 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_80 * tmpvar_4));
  tmpvar_79 = (albedo_80 * (0.7790837 - (tmpvar_4 * 0.7790837)));
  tmpvar_76 = 0.0;
  mediump float alpha_82;
  alpha_82 = tmpvar_76;
  tmpvar_76 = alpha_82;
  mediump float tmpvar_83;
  tmpvar_83 = (1.0 - tmpvar_5);
  perceptualRoughness_78 = tmpvar_83;
  highp vec3 tmpvar_84;
  highp vec3 inVec_85;
  inVec_85 = (tmpvar_75 + tmpvar_74);
  tmpvar_84 = (inVec_85 * inversesqrt(max (0.001, 
    dot (inVec_85, inVec_85)
  )));
  highp float tmpvar_86;
  tmpvar_86 = abs(dot (tmpvar_74, tmpvar_6));
  highp float tmpvar_87;
  tmpvar_87 = clamp (dot (tmpvar_6, tmpvar_75), 0.0, 1.0);
  highp float tmpvar_88;
  tmpvar_88 = clamp (dot (tmpvar_6, tmpvar_84), 0.0, 1.0);
  mediump float tmpvar_89;
  highp float tmpvar_90;
  tmpvar_90 = clamp (dot (tmpvar_75, tmpvar_84), 0.0, 1.0);
  tmpvar_89 = tmpvar_90;
  mediump float tmpvar_91;
  mediump float NdotV_92;
  NdotV_92 = tmpvar_86;
  mediump float NdotL_93;
  NdotL_93 = tmpvar_87;
  mediump float perceptualRoughness_94;
  perceptualRoughness_94 = perceptualRoughness_78;
  mediump float tmpvar_95;
  tmpvar_95 = (0.5 + ((2.0 * tmpvar_89) * (tmpvar_89 * perceptualRoughness_94)));
  mediump float x_96;
  x_96 = (1.0 - NdotL_93);
  mediump float x_97;
  x_97 = (1.0 - NdotV_92);
  tmpvar_91 = ((1.0 + (
    (tmpvar_95 - 1.0)
   * 
    ((x_96 * x_96) * ((x_96 * x_96) * x_96))
  )) * (1.0 + (
    (tmpvar_95 - 1.0)
   * 
    ((x_97 * x_97) * ((x_97 * x_97) * x_97))
  )));
  highp float tmpvar_98;
  tmpvar_98 = (tmpvar_91 * tmpvar_87);
  diffuseTerm_77 = tmpvar_98;
  highp float tmpvar_99;
  tmpvar_99 = max ((perceptualRoughness_78 * perceptualRoughness_78), 0.002);
  highp float tmpvar_100;
  tmpvar_100 = (tmpvar_99 * tmpvar_99);
  highp float tmpvar_101;
  tmpvar_101 = (((
    (tmpvar_88 * tmpvar_100)
   - tmpvar_88) * tmpvar_88) + 1.0);
  mediump vec3 tmpvar_102;
  mediump float x_103;
  x_103 = (1.0 - tmpvar_89);
  tmpvar_102 = (specColor_81 + ((1.0 - specColor_81) * (
    (x_103 * x_103)
   * 
    ((x_103 * x_103) * x_103)
  )));
  outColor_2.xyz = (((
    (tmpvar_79 * LIGHT_COLOR)
   * diffuseTerm_77) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_100)
       / 
        ((tmpvar_101 * tmpvar_101) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_87 * (
          (tmpvar_86 * (1.0 - tmpvar_99))
         + tmpvar_99)) + (tmpvar_86 * (
          (tmpvar_87 * (1.0 - tmpvar_99))
         + tmpvar_99))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_87)) * LIGHT_COLOR)
   * tmpvar_102)) * tmpvar_15);
  lowp vec4 tmpvar_104;
  tmpvar_104 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_104;
  outColor_2.w = ((col_9.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec3 normalTangent_7;
  highp vec2 mg_8;
  highp vec4 col_9;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_9 = tmpvar_10;
  lowp vec2 tmpvar_11;
  tmpvar_11 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_8 = tmpvar_11;
  lowp vec3 tmpvar_12;
  tmpvar_12 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_7 = tmpvar_12;
  normalTangent_7 = ((normalTangent_7 * 2.0) - 1.0);
  tmpvar_3 = col_9.xyz;
  tmpvar_4 = (mg_8.x * _Metallic);
  tmpvar_5 = (mg_8.y * _Smoothness);
  tmpvar_6 = normalize(((
    (normalTangent_7.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_7.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_13;
  tmpvar_13.x = xlv_TEXCOORD1.w;
  tmpvar_13.y = xlv_TEXCOORD2.w;
  tmpvar_13.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_14;
  shadowCoord_14 = xlv_TEXCOORD4;
  highp float tmpvar_15;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_15 = 1.0;
  } else {
    shadowCoord_14.y = (1.0 - xlv_TEXCOORD4.y);
    highp vec4 fetchesOffsetsV_16;
    highp vec4 fetchesOffsetsU_17;
    highp float shadow_18;
    highp vec2 tmpvar_19;
    tmpvar_19 = (shadowCoord_14.xy * vec2((1.0/(LIGHT_PARAM.z))));
    highp vec2 tmpvar_20;
    tmpvar_20 = floor((tmpvar_19 + 0.5));
    highp vec2 tmpvar_21;
    tmpvar_21 = (tmpvar_19 - tmpvar_20);
    highp vec4 texelsWeightsA_22;
    highp vec4 texelsWeightsB_23;
    highp vec4 computedArea_24;
    highp vec4 computedAreaUncut_25;
    highp float tmpvar_26;
    tmpvar_26 = (((tmpvar_21.x + 0.5) * (tmpvar_21.x + 0.5)) * 0.5);
    highp float tmpvar_27;
    tmpvar_27 = (tmpvar_26 - tmpvar_21.x);
    computedArea_24.x = tmpvar_27;
    computedAreaUncut_25.x = tmpvar_27;
    computedArea_24.w = tmpvar_26;
    computedAreaUncut_25.w = tmpvar_26;
    computedAreaUncut_25.y = ((1.5 - tmpvar_21.x) - 0.5);
    highp float tmpvar_28;
    tmpvar_28 = min (tmpvar_21.x, 0.0);
    computedArea_24.y = (computedAreaUncut_25.y - (tmpvar_28 * tmpvar_28));
    computedAreaUncut_25.z = ((1.5 + tmpvar_21.x) - 0.5);
    highp float tmpvar_29;
    tmpvar_29 = max (tmpvar_21.x, 0.0);
    computedArea_24.z = (computedAreaUncut_25.z - (tmpvar_29 * tmpvar_29));
    texelsWeightsA_22.x = (0.081632 * tmpvar_27);
    texelsWeightsA_22.y = (0.081632 * computedAreaUncut_25.y);
    texelsWeightsA_22.z = (0.081632 * (computedAreaUncut_25.y + 1.0));
    texelsWeightsA_22.w = (0.081632 * (computedArea_24.y + 2.0));
    texelsWeightsB_23.x = (0.081632 * (computedArea_24.z + 2.0));
    texelsWeightsB_23.y = (0.081632 * (computedAreaUncut_25.z + 1.0));
    texelsWeightsB_23.z = (0.081632 * computedAreaUncut_25.z);
    texelsWeightsB_23.w = (0.081632 * tmpvar_26);
    highp vec4 texelsWeightsA_30;
    highp vec4 texelsWeightsB_31;
    highp vec4 computedArea_32;
    highp vec4 computedAreaUncut_33;
    highp float tmpvar_34;
    tmpvar_34 = (((tmpvar_21.y + 0.5) * (tmpvar_21.y + 0.5)) * 0.5);
    highp float tmpvar_35;
    tmpvar_35 = (tmpvar_34 - tmpvar_21.y);
    computedArea_32.x = tmpvar_35;
    computedAreaUncut_33.x = tmpvar_35;
    computedArea_32.w = tmpvar_34;
    computedAreaUncut_33.w = tmpvar_34;
    computedAreaUncut_33.y = ((1.5 - tmpvar_21.y) - 0.5);
    highp float tmpvar_36;
    tmpvar_36 = min (tmpvar_21.y, 0.0);
    computedArea_32.y = (computedAreaUncut_33.y - (tmpvar_36 * tmpvar_36));
    computedAreaUncut_33.z = ((1.5 + tmpvar_21.y) - 0.5);
    highp float tmpvar_37;
    tmpvar_37 = max (tmpvar_21.y, 0.0);
    computedArea_32.z = (computedAreaUncut_33.z - (tmpvar_37 * tmpvar_37));
    texelsWeightsA_30.x = (0.081632 * tmpvar_35);
    texelsWeightsA_30.y = (0.081632 * computedAreaUncut_33.y);
    texelsWeightsA_30.z = (0.081632 * (computedAreaUncut_33.y + 1.0));
    texelsWeightsA_30.w = (0.081632 * (computedArea_32.y + 2.0));
    texelsWeightsB_31.x = (0.081632 * (computedArea_32.z + 2.0));
    texelsWeightsB_31.y = (0.081632 * (computedAreaUncut_33.z + 1.0));
    texelsWeightsB_31.z = (0.081632 * computedAreaUncut_33.z);
    texelsWeightsB_31.w = (0.081632 * tmpvar_34);
    highp vec4 tmpvar_38;
    tmpvar_38.xy = texelsWeightsA_22.xz;
    tmpvar_38.zw = texelsWeightsB_23.xz;
    highp vec4 tmpvar_39;
    tmpvar_39.xy = texelsWeightsA_22.yw;
    tmpvar_39.zw = texelsWeightsB_23.yw;
    highp vec4 tmpvar_40;
    tmpvar_40 = (tmpvar_38 + tmpvar_39);
    highp vec4 tmpvar_41;
    tmpvar_41.xy = texelsWeightsA_30.xz;
    tmpvar_41.zw = texelsWeightsB_31.xz;
    highp vec4 tmpvar_42;
    tmpvar_42.xy = texelsWeightsA_30.yw;
    tmpvar_42.zw = texelsWeightsB_31.yw;
    highp vec4 tmpvar_43;
    tmpvar_43 = (tmpvar_41 + tmpvar_42);
    highp vec4 tmpvar_44;
    tmpvar_44.xy = texelsWeightsA_22.yw;
    tmpvar_44.zw = texelsWeightsB_23.yw;
    highp vec4 tmpvar_45;
    tmpvar_45.xy = texelsWeightsA_30.yw;
    tmpvar_45.zw = texelsWeightsB_31.yw;
    fetchesOffsetsU_17 = (((tmpvar_44 / tmpvar_40) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    fetchesOffsetsV_16 = (((tmpvar_45 / tmpvar_43) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
    highp vec2 tmpvar_46;
    tmpvar_46 = (tmpvar_20 * LIGHT_PARAM.zz);
    highp vec2 tmpvar_47;
    tmpvar_47.x = fetchesOffsetsU_17.x;
    tmpvar_47.y = fetchesOffsetsV_16.x;
    highp vec3 tmpvar_48;
    tmpvar_48.xy = (tmpvar_46 + tmpvar_47);
    tmpvar_48.z = shadowCoord_14.z;
    lowp float tmpvar_49;
    tmpvar_49 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_48);
    shadow_18 = ((tmpvar_40.x * tmpvar_43.x) * tmpvar_49);
    highp vec2 tmpvar_50;
    tmpvar_50.x = fetchesOffsetsU_17.y;
    tmpvar_50.y = fetchesOffsetsV_16.x;
    highp vec3 tmpvar_51;
    tmpvar_51.xy = (tmpvar_46 + tmpvar_50);
    tmpvar_51.z = shadowCoord_14.z;
    lowp float tmpvar_52;
    tmpvar_52 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_51);
    shadow_18 = (shadow_18 + ((tmpvar_40.y * tmpvar_43.x) * tmpvar_52));
    highp vec2 tmpvar_53;
    tmpvar_53.x = fetchesOffsetsU_17.z;
    tmpvar_53.y = fetchesOffsetsV_16.x;
    highp vec3 tmpvar_54;
    tmpvar_54.xy = (tmpvar_46 + tmpvar_53);
    tmpvar_54.z = shadowCoord_14.z;
    lowp float tmpvar_55;
    tmpvar_55 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_54);
    shadow_18 = (shadow_18 + ((tmpvar_40.z * tmpvar_43.x) * tmpvar_55));
    highp vec2 tmpvar_56;
    tmpvar_56.x = fetchesOffsetsU_17.w;
    tmpvar_56.y = fetchesOffsetsV_16.x;
    highp vec3 tmpvar_57;
    tmpvar_57.xy = (tmpvar_46 + tmpvar_56);
    tmpvar_57.z = shadowCoord_14.z;
    lowp float tmpvar_58;
    tmpvar_58 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_57);
    shadow_18 = (shadow_18 + ((tmpvar_40.w * tmpvar_43.x) * tmpvar_58));
    highp vec2 tmpvar_59;
    tmpvar_59.x = fetchesOffsetsU_17.x;
    tmpvar_59.y = fetchesOffsetsV_16.y;
    highp vec3 tmpvar_60;
    tmpvar_60.xy = (tmpvar_46 + tmpvar_59);
    tmpvar_60.z = shadowCoord_14.z;
    lowp float tmpvar_61;
    tmpvar_61 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_60);
    shadow_18 = (shadow_18 + ((tmpvar_40.x * tmpvar_43.y) * tmpvar_61));
    highp vec2 tmpvar_62;
    tmpvar_62.x = fetchesOffsetsU_17.y;
    tmpvar_62.y = fetchesOffsetsV_16.y;
    highp vec3 tmpvar_63;
    tmpvar_63.xy = (tmpvar_46 + tmpvar_62);
    tmpvar_63.z = shadowCoord_14.z;
    lowp float tmpvar_64;
    tmpvar_64 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_63);
    shadow_18 = (shadow_18 + ((tmpvar_40.y * tmpvar_43.y) * tmpvar_64));
    highp vec2 tmpvar_65;
    tmpvar_65.x = fetchesOffsetsU_17.z;
    tmpvar_65.y = fetchesOffsetsV_16.y;
    highp vec3 tmpvar_66;
    tmpvar_66.xy = (tmpvar_46 + tmpvar_65);
    tmpvar_66.z = shadowCoord_14.z;
    lowp float tmpvar_67;
    tmpvar_67 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_66);
    shadow_18 = (shadow_18 + ((tmpvar_40.z * tmpvar_43.y) * tmpvar_67));
    highp vec2 tmpvar_68;
    tmpvar_68.x = fetchesOffsetsU_17.w;
    tmpvar_68.y = fetchesOffsetsV_16.y;
    highp vec3 tmpvar_69;
    tmpvar_69.xy = (tmpvar_46 + tmpvar_68);
    tmpvar_69.z = shadowCoord_14.z;
    lowp float tmpvar_70;
    tmpvar_70 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_69);
    shadow_18 = (shadow_18 + ((tmpvar_40.w * tmpvar_43.y) * tmpvar_70));
    highp vec2 tmpvar_71;
    tmpvar_71.x = fetchesOffsetsU_17.x;
    tmpvar_71.y = fetchesOffsetsV_16.z;
    highp vec3 tmpvar_72;
    tmpvar_72.xy = (tmpvar_46 + tmpvar_71);
    tmpvar_72.z = shadowCoord_14.z;
    lowp float tmpvar_73;
    tmpvar_73 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_72);
    shadow_18 = (shadow_18 + ((tmpvar_40.x * tmpvar_43.z) * tmpvar_73));
    highp vec2 tmpvar_74;
    tmpvar_74.x = fetchesOffsetsU_17.y;
    tmpvar_74.y = fetchesOffsetsV_16.z;
    highp vec3 tmpvar_75;
    tmpvar_75.xy = (tmpvar_46 + tmpvar_74);
    tmpvar_75.z = shadowCoord_14.z;
    lowp float tmpvar_76;
    tmpvar_76 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_75);
    shadow_18 = (shadow_18 + ((tmpvar_40.y * tmpvar_43.z) * tmpvar_76));
    highp vec2 tmpvar_77;
    tmpvar_77.x = fetchesOffsetsU_17.z;
    tmpvar_77.y = fetchesOffsetsV_16.z;
    highp vec3 tmpvar_78;
    tmpvar_78.xy = (tmpvar_46 + tmpvar_77);
    tmpvar_78.z = shadowCoord_14.z;
    lowp float tmpvar_79;
    tmpvar_79 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_78);
    shadow_18 = (shadow_18 + ((tmpvar_40.z * tmpvar_43.z) * tmpvar_79));
    highp vec2 tmpvar_80;
    tmpvar_80.x = fetchesOffsetsU_17.w;
    tmpvar_80.y = fetchesOffsetsV_16.z;
    highp vec3 tmpvar_81;
    tmpvar_81.xy = (tmpvar_46 + tmpvar_80);
    tmpvar_81.z = shadowCoord_14.z;
    lowp float tmpvar_82;
    tmpvar_82 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_81);
    shadow_18 = (shadow_18 + ((tmpvar_40.w * tmpvar_43.z) * tmpvar_82));
    highp vec2 tmpvar_83;
    tmpvar_83.x = fetchesOffsetsU_17.x;
    tmpvar_83.y = fetchesOffsetsV_16.w;
    highp vec3 tmpvar_84;
    tmpvar_84.xy = (tmpvar_46 + tmpvar_83);
    tmpvar_84.z = shadowCoord_14.z;
    lowp float tmpvar_85;
    tmpvar_85 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_84);
    shadow_18 = (shadow_18 + ((tmpvar_40.x * tmpvar_43.w) * tmpvar_85));
    highp vec2 tmpvar_86;
    tmpvar_86.x = fetchesOffsetsU_17.y;
    tmpvar_86.y = fetchesOffsetsV_16.w;
    highp vec3 tmpvar_87;
    tmpvar_87.xy = (tmpvar_46 + tmpvar_86);
    tmpvar_87.z = shadowCoord_14.z;
    lowp float tmpvar_88;
    tmpvar_88 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_87);
    shadow_18 = (shadow_18 + ((tmpvar_40.y * tmpvar_43.w) * tmpvar_88));
    highp vec2 tmpvar_89;
    tmpvar_89.x = fetchesOffsetsU_17.z;
    tmpvar_89.y = fetchesOffsetsV_16.w;
    highp vec3 tmpvar_90;
    tmpvar_90.xy = (tmpvar_46 + tmpvar_89);
    tmpvar_90.z = shadowCoord_14.z;
    lowp float tmpvar_91;
    tmpvar_91 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_90);
    shadow_18 = (shadow_18 + ((tmpvar_40.z * tmpvar_43.w) * tmpvar_91));
    highp vec2 tmpvar_92;
    tmpvar_92.x = fetchesOffsetsU_17.w;
    tmpvar_92.y = fetchesOffsetsV_16.w;
    highp vec3 tmpvar_93;
    tmpvar_93.xy = (tmpvar_46 + tmpvar_92);
    tmpvar_93.z = shadowCoord_14.z;
    lowp float tmpvar_94;
    tmpvar_94 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_93);
    shadow_18 = (shadow_18 + ((tmpvar_40.w * tmpvar_43.w) * tmpvar_94));
    tmpvar_15 = mix (1.0, shadow_18, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_95;
  highp vec3 tmpvar_96;
  tmpvar_95 = normalize((CAMERA_WORLDPOSITION - tmpvar_13));
  tmpvar_96 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_97;
  mediump float diffuseTerm_98;
  highp float perceptualRoughness_99;
  mediump vec3 tmpvar_100;
  mediump vec3 albedo_101;
  albedo_101 = tmpvar_3;
  mediump vec3 specColor_102;
  specColor_102 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_101 * tmpvar_4));
  tmpvar_100 = (albedo_101 * (0.7790837 - (tmpvar_4 * 0.7790837)));
  tmpvar_97 = 0.0;
  mediump float alpha_103;
  alpha_103 = tmpvar_97;
  tmpvar_97 = alpha_103;
  mediump float tmpvar_104;
  tmpvar_104 = (1.0 - tmpvar_5);
  perceptualRoughness_99 = tmpvar_104;
  highp vec3 tmpvar_105;
  highp vec3 inVec_106;
  inVec_106 = (tmpvar_96 + tmpvar_95);
  tmpvar_105 = (inVec_106 * inversesqrt(max (0.001, 
    dot (inVec_106, inVec_106)
  )));
  highp float tmpvar_107;
  tmpvar_107 = abs(dot (tmpvar_95, tmpvar_6));
  highp float tmpvar_108;
  tmpvar_108 = clamp (dot (tmpvar_6, tmpvar_96), 0.0, 1.0);
  highp float tmpvar_109;
  tmpvar_109 = clamp (dot (tmpvar_6, tmpvar_105), 0.0, 1.0);
  mediump float tmpvar_110;
  highp float tmpvar_111;
  tmpvar_111 = clamp (dot (tmpvar_96, tmpvar_105), 0.0, 1.0);
  tmpvar_110 = tmpvar_111;
  mediump float tmpvar_112;
  mediump float NdotV_113;
  NdotV_113 = tmpvar_107;
  mediump float NdotL_114;
  NdotL_114 = tmpvar_108;
  mediump float perceptualRoughness_115;
  perceptualRoughness_115 = perceptualRoughness_99;
  mediump float tmpvar_116;
  tmpvar_116 = (0.5 + ((2.0 * tmpvar_110) * (tmpvar_110 * perceptualRoughness_115)));
  mediump float x_117;
  x_117 = (1.0 - NdotL_114);
  mediump float x_118;
  x_118 = (1.0 - NdotV_113);
  tmpvar_112 = ((1.0 + (
    (tmpvar_116 - 1.0)
   * 
    ((x_117 * x_117) * ((x_117 * x_117) * x_117))
  )) * (1.0 + (
    (tmpvar_116 - 1.0)
   * 
    ((x_118 * x_118) * ((x_118 * x_118) * x_118))
  )));
  highp float tmpvar_119;
  tmpvar_119 = (tmpvar_112 * tmpvar_108);
  diffuseTerm_98 = tmpvar_119;
  highp float tmpvar_120;
  tmpvar_120 = max ((perceptualRoughness_99 * perceptualRoughness_99), 0.002);
  highp float tmpvar_121;
  tmpvar_121 = (tmpvar_120 * tmpvar_120);
  highp float tmpvar_122;
  tmpvar_122 = (((
    (tmpvar_109 * tmpvar_121)
   - tmpvar_109) * tmpvar_109) + 1.0);
  mediump vec3 tmpvar_123;
  mediump float x_124;
  x_124 = (1.0 - tmpvar_110);
  tmpvar_123 = (specColor_102 + ((1.0 - specColor_102) * (
    (x_124 * x_124)
   * 
    ((x_124 * x_124) * x_124)
  )));
  outColor_2.xyz = (((
    (tmpvar_100 * LIGHT_COLOR)
   * diffuseTerm_98) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_121)
       / 
        ((tmpvar_122 * tmpvar_122) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_108 * (
          (tmpvar_107 * (1.0 - tmpvar_120))
         + tmpvar_120)) + (tmpvar_107 * (
          (tmpvar_108 * (1.0 - tmpvar_120))
         + tmpvar_120))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_108)) * LIGHT_COLOR)
   * tmpvar_123)) * tmpvar_15);
  lowp vec4 tmpvar_125;
  tmpvar_125 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_125;
  outColor_2.w = ((col_9.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_SHADOWRANGE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (((LIGHT_CAMERA_PROJECTION * 
    (LIGHT_CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_13))
  ).xyz * 0.5) + 0.5);
  highp vec4 tmpvar_14;
  tmpvar_14.w = 1.0;
  tmpvar_14.xyz = tmpvar_1.xyz;
  tmpvar_5.w = -((CAMERA_VIEW * (LOCALWORLD_TRANSFORM * tmpvar_14)).z);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 tmpvar_6;
  highp vec3 normalTangent_7;
  highp vec2 mg_8;
  highp vec4 col_9;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_9 = tmpvar_10;
  lowp vec2 tmpvar_11;
  tmpvar_11 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_8 = tmpvar_11;
  lowp vec3 tmpvar_12;
  tmpvar_12 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_7 = tmpvar_12;
  normalTangent_7 = ((normalTangent_7 * 2.0) - 1.0);
  tmpvar_3 = col_9.xyz;
  tmpvar_4 = (mg_8.x * _Metallic);
  tmpvar_5 = (mg_8.y * _Smoothness);
  tmpvar_6 = normalize(((
    (normalTangent_7.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_7.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_7.z * xlv_TEXCOORD1.xyz)));
  highp vec3 tmpvar_13;
  tmpvar_13.x = xlv_TEXCOORD1.w;
  tmpvar_13.y = xlv_TEXCOORD2.w;
  tmpvar_13.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_14;
  shadowCoord_14 = xlv_TEXCOORD4;
  highp float tmpvar_15;
  if ((xlv_TEXCOORD4.w > CAMERA_SHADOWRANGE.x)) {
    tmpvar_15 = 1.0;
  } else {
    highp vec2 tmpvar_16;
    tmpvar_16.x = LIGHT_PARAM.z;
    tmpvar_16.y = LIGHT_PARAM.z;
    highp vec4 tmpvar_17;
    tmpvar_17.xy = tmpvar_16;
    highp float tmpvar_18;
    tmpvar_18 = (1.0/(LIGHT_PARAM.z));
    tmpvar_17.z = tmpvar_18;
    tmpvar_17.w = tmpvar_18;
    shadowCoord_14.y = (1.0 - xlv_TEXCOORD4.y);
    highp float shadow_19;
    highp vec2 tmpvar_20;
    tmpvar_20 = tmpvar_17.xy;
    shadow_19 = 0.0;
    highp vec3 tmpvar_21;
    tmpvar_21.xy = (shadowCoord_14.xy - LIGHT_PARAM.zz);
    tmpvar_21.z = shadowCoord_14.z;
    highp vec4 tmpvar_22;
    tmpvar_22 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_21.xy);
    highp float tmpvar_23;
    if ((tmpvar_22.x < xlv_TEXCOORD4.z)) {
      tmpvar_23 = 0.0;
    } else {
      tmpvar_23 = 1.0;
    };
    shadow_19 = tmpvar_23;
    highp vec2 tmpvar_24;
    tmpvar_24.x = 0.0;
    tmpvar_24.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_25;
    tmpvar_25.xy = (shadowCoord_14.xy + tmpvar_24);
    tmpvar_25.z = shadowCoord_14.z;
    highp vec4 tmpvar_26;
    tmpvar_26 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_25.xy);
    highp float tmpvar_27;
    if ((tmpvar_26.x < xlv_TEXCOORD4.z)) {
      tmpvar_27 = 0.0;
    } else {
      tmpvar_27 = 1.0;
    };
    shadow_19 = (tmpvar_23 + tmpvar_27);
    highp vec2 tmpvar_28;
    tmpvar_28.x = tmpvar_20.x;
    tmpvar_28.y = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_29;
    tmpvar_29.xy = (shadowCoord_14.xy + tmpvar_28);
    tmpvar_29.z = shadowCoord_14.z;
    highp vec4 tmpvar_30;
    tmpvar_30 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_29.xy);
    highp float tmpvar_31;
    if ((tmpvar_30.x < xlv_TEXCOORD4.z)) {
      tmpvar_31 = 0.0;
    } else {
      tmpvar_31 = 1.0;
    };
    shadow_19 = (shadow_19 + tmpvar_31);
    highp vec2 tmpvar_32;
    tmpvar_32.y = 0.0;
    tmpvar_32.x = -(LIGHT_PARAM.z);
    highp vec3 tmpvar_33;
    tmpvar_33.xy = (shadowCoord_14.xy + tmpvar_32);
    tmpvar_33.z = shadowCoord_14.z;
    highp vec4 tmpvar_34;
    tmpvar_34 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_33.xy);
    highp float tmpvar_35;
    if ((tmpvar_34.x < xlv_TEXCOORD4.z)) {
      tmpvar_35 = 0.0;
    } else {
      tmpvar_35 = 1.0;
    };
    shadow_19 = (shadow_19 + tmpvar_35);
    highp vec4 tmpvar_36;
    tmpvar_36 = texture2D (TEXTURE_SHADOW_DEPTH, shadowCoord_14.xy);
    highp float tmpvar_37;
    if ((tmpvar_36.x < xlv_TEXCOORD4.z)) {
      tmpvar_37 = 0.0;
    } else {
      tmpvar_37 = 1.0;
    };
    shadow_19 = (shadow_19 + tmpvar_37);
    highp vec2 tmpvar_38;
    tmpvar_38.y = 0.0;
    tmpvar_38.x = tmpvar_20.x;
    highp vec3 tmpvar_39;
    tmpvar_39.xy = (shadowCoord_14.xy + tmpvar_38);
    tmpvar_39.z = shadowCoord_14.z;
    highp vec4 tmpvar_40;
    tmpvar_40 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_39.xy);
    highp float tmpvar_41;
    if ((tmpvar_40.x < xlv_TEXCOORD4.z)) {
      tmpvar_41 = 0.0;
    } else {
      tmpvar_41 = 1.0;
    };
    shadow_19 = (shadow_19 + tmpvar_41);
    highp vec2 tmpvar_42;
    tmpvar_42.x = -(LIGHT_PARAM.z);
    tmpvar_42.y = tmpvar_20.y;
    highp vec3 tmpvar_43;
    tmpvar_43.xy = (shadowCoord_14.xy + tmpvar_42);
    tmpvar_43.z = shadowCoord_14.z;
    highp vec4 tmpvar_44;
    tmpvar_44 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_43.xy);
    highp float tmpvar_45;
    if ((tmpvar_44.x < xlv_TEXCOORD4.z)) {
      tmpvar_45 = 0.0;
    } else {
      tmpvar_45 = 1.0;
    };
    shadow_19 = (shadow_19 + tmpvar_45);
    highp vec2 tmpvar_46;
    tmpvar_46.x = 0.0;
    tmpvar_46.y = tmpvar_20.y;
    highp vec3 tmpvar_47;
    tmpvar_47.xy = (shadowCoord_14.xy + tmpvar_46);
    tmpvar_47.z = shadowCoord_14.z;
    highp vec4 tmpvar_48;
    tmpvar_48 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_47.xy);
    highp float tmpvar_49;
    if ((tmpvar_48.x < xlv_TEXCOORD4.z)) {
      tmpvar_49 = 0.0;
    } else {
      tmpvar_49 = 1.0;
    };
    shadow_19 = (shadow_19 + tmpvar_49);
    highp vec3 tmpvar_50;
    tmpvar_50.xy = (shadowCoord_14.xy + LIGHT_PARAM.zz);
    tmpvar_50.z = shadowCoord_14.z;
    highp vec4 tmpvar_51;
    tmpvar_51 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_50.xy);
    highp float tmpvar_52;
    if ((tmpvar_51.x < xlv_TEXCOORD4.z)) {
      tmpvar_52 = 0.0;
    } else {
      tmpvar_52 = 1.0;
    };
    shadow_19 = (shadow_19 + tmpvar_52);
    shadow_19 = (shadow_19 / 9.0);
    tmpvar_15 = mix (1.0, shadow_19, LIGHT_PARAM.y);
  };
  highp vec3 tmpvar_53;
  highp vec3 tmpvar_54;
  tmpvar_53 = normalize((CAMERA_WORLDPOSITION - tmpvar_13));
  tmpvar_54 = -(LIGHT_GIVEN_DIRECTION);
  highp float tmpvar_55;
  mediump float diffuseTerm_56;
  highp float perceptualRoughness_57;
  mediump vec3 tmpvar_58;
  mediump vec3 albedo_59;
  albedo_59 = tmpvar_3;
  mediump vec3 specColor_60;
  specColor_60 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_59 * tmpvar_4));
  tmpvar_58 = (albedo_59 * (0.7790837 - (tmpvar_4 * 0.7790837)));
  tmpvar_55 = 0.0;
  mediump float alpha_61;
  alpha_61 = tmpvar_55;
  tmpvar_55 = alpha_61;
  mediump float tmpvar_62;
  tmpvar_62 = (1.0 - tmpvar_5);
  perceptualRoughness_57 = tmpvar_62;
  highp vec3 tmpvar_63;
  highp vec3 inVec_64;
  inVec_64 = (tmpvar_54 + tmpvar_53);
  tmpvar_63 = (inVec_64 * inversesqrt(max (0.001, 
    dot (inVec_64, inVec_64)
  )));
  highp float tmpvar_65;
  tmpvar_65 = abs(dot (tmpvar_53, tmpvar_6));
  highp float tmpvar_66;
  tmpvar_66 = clamp (dot (tmpvar_6, tmpvar_54), 0.0, 1.0);
  highp float tmpvar_67;
  tmpvar_67 = clamp (dot (tmpvar_6, tmpvar_63), 0.0, 1.0);
  mediump float tmpvar_68;
  highp float tmpvar_69;
  tmpvar_69 = clamp (dot (tmpvar_54, tmpvar_63), 0.0, 1.0);
  tmpvar_68 = tmpvar_69;
  mediump float tmpvar_70;
  mediump float NdotV_71;
  NdotV_71 = tmpvar_65;
  mediump float NdotL_72;
  NdotL_72 = tmpvar_66;
  mediump float perceptualRoughness_73;
  perceptualRoughness_73 = perceptualRoughness_57;
  mediump float tmpvar_74;
  tmpvar_74 = (0.5 + ((2.0 * tmpvar_68) * (tmpvar_68 * perceptualRoughness_73)));
  mediump float x_75;
  x_75 = (1.0 - NdotL_72);
  mediump float x_76;
  x_76 = (1.0 - NdotV_71);
  tmpvar_70 = ((1.0 + (
    (tmpvar_74 - 1.0)
   * 
    ((x_75 * x_75) * ((x_75 * x_75) * x_75))
  )) * (1.0 + (
    (tmpvar_74 - 1.0)
   * 
    ((x_76 * x_76) * ((x_76 * x_76) * x_76))
  )));
  highp float tmpvar_77;
  tmpvar_77 = (tmpvar_70 * tmpvar_66);
  diffuseTerm_56 = tmpvar_77;
  highp float tmpvar_78;
  tmpvar_78 = max ((perceptualRoughness_57 * perceptualRoughness_57), 0.002);
  highp float tmpvar_79;
  tmpvar_79 = (tmpvar_78 * tmpvar_78);
  highp float tmpvar_80;
  tmpvar_80 = (((
    (tmpvar_67 * tmpvar_79)
   - tmpvar_67) * tmpvar_67) + 1.0);
  mediump vec3 tmpvar_81;
  mediump float x_82;
  x_82 = (1.0 - tmpvar_68);
  tmpvar_81 = (specColor_60 + ((1.0 - specColor_60) * (
    (x_82 * x_82)
   * 
    ((x_82 * x_82) * x_82)
  )));
  outColor_2.xyz = (((
    (tmpvar_58 * LIGHT_COLOR)
   * diffuseTerm_56) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_79)
       / 
        ((tmpvar_80 * tmpvar_80) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_66 * (
          (tmpvar_65 * (1.0 - tmpvar_78))
         + tmpvar_78)) + (tmpvar_65 * (
          (tmpvar_66 * (1.0 - tmpvar_78))
         + tmpvar_78))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_66)) * LIGHT_COLOR)
   * tmpvar_81)) * tmpvar_15);
  lowp vec4 tmpvar_83;
  tmpvar_83 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_83;
  outColor_2.w = ((col_9.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"SpotLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_9[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_9[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_3 = col_8.xyz;
  tmpvar_4 = (mg_7.x * _Metallic);
  tmpvar_5 = (mg_7.y * _Smoothness);
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  highp vec3 lightDir_15;
  highp vec3 tmpvar_16;
  tmpvar_16 = (LIGHT_POSITION - tmpvar_12);
  highp float tmpvar_17;
  tmpvar_17 = clamp ((sqrt(
    dot (tmpvar_16, tmpvar_16)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_15 = normalize(tmpvar_16);
  tmpvar_14 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  tmpvar_13 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  highp float tmpvar_18;
  mediump float diffuseTerm_19;
  highp float perceptualRoughness_20;
  mediump vec3 tmpvar_21;
  mediump vec3 albedo_22;
  albedo_22 = tmpvar_3;
  mediump vec3 specColor_23;
  specColor_23 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_22 * tmpvar_4));
  tmpvar_21 = (albedo_22 * (0.7790837 - (tmpvar_4 * 0.7790837)));
  tmpvar_18 = 0.0;
  mediump float alpha_24;
  alpha_24 = tmpvar_18;
  tmpvar_18 = alpha_24;
  mediump float tmpvar_25;
  tmpvar_25 = (1.0 - tmpvar_5);
  perceptualRoughness_20 = tmpvar_25;
  highp vec3 tmpvar_26;
  highp vec3 inVec_27;
  inVec_27 = (lightDir_15 + tmpvar_13);
  tmpvar_26 = (inVec_27 * inversesqrt(max (0.001, 
    dot (inVec_27, inVec_27)
  )));
  highp float tmpvar_28;
  tmpvar_28 = abs(dot (tmpvar_13, tmpvar_14));
  highp float tmpvar_29;
  tmpvar_29 = clamp (dot (tmpvar_14, lightDir_15), 0.0, 1.0);
  highp float tmpvar_30;
  tmpvar_30 = clamp (dot (tmpvar_14, tmpvar_26), 0.0, 1.0);
  mediump float tmpvar_31;
  highp float tmpvar_32;
  tmpvar_32 = clamp (dot (lightDir_15, tmpvar_26), 0.0, 1.0);
  tmpvar_31 = tmpvar_32;
  mediump float tmpvar_33;
  mediump float NdotV_34;
  NdotV_34 = tmpvar_28;
  mediump float NdotL_35;
  NdotL_35 = tmpvar_29;
  mediump float perceptualRoughness_36;
  perceptualRoughness_36 = perceptualRoughness_20;
  mediump float tmpvar_37;
  tmpvar_37 = (0.5 + ((2.0 * tmpvar_31) * (tmpvar_31 * perceptualRoughness_36)));
  mediump float x_38;
  x_38 = (1.0 - NdotL_35);
  mediump float x_39;
  x_39 = (1.0 - NdotV_34);
  tmpvar_33 = ((1.0 + (
    (tmpvar_37 - 1.0)
   * 
    ((x_38 * x_38) * ((x_38 * x_38) * x_38))
  )) * (1.0 + (
    (tmpvar_37 - 1.0)
   * 
    ((x_39 * x_39) * ((x_39 * x_39) * x_39))
  )));
  highp float tmpvar_40;
  tmpvar_40 = (tmpvar_33 * tmpvar_29);
  diffuseTerm_19 = tmpvar_40;
  highp float tmpvar_41;
  tmpvar_41 = max ((perceptualRoughness_20 * perceptualRoughness_20), 0.002);
  highp float tmpvar_42;
  tmpvar_42 = (tmpvar_41 * tmpvar_41);
  highp float tmpvar_43;
  tmpvar_43 = (((
    (tmpvar_30 * tmpvar_42)
   - tmpvar_30) * tmpvar_30) + 1.0);
  mediump vec3 tmpvar_44;
  mediump float x_45;
  x_45 = (1.0 - tmpvar_31);
  tmpvar_44 = (specColor_23 + ((1.0 - specColor_23) * (
    (x_45 * x_45)
   * 
    ((x_45 * x_45) * x_45)
  )));
  outColor_2.xyz = (((
    (tmpvar_21 * LIGHT_COLOR)
   * diffuseTerm_19) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_42)
       / 
        ((tmpvar_43 * tmpvar_43) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_29 * (
          (tmpvar_28 * (1.0 - tmpvar_41))
         + tmpvar_41)) + (tmpvar_28 * (
          (tmpvar_29 * (1.0 - tmpvar_41))
         + tmpvar_41))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_29)) * LIGHT_COLOR)
   * tmpvar_44)) * ((
    (1.0 - tmpvar_17)
   / 
    ((LIGHT_ATTENUATION.x + (tmpvar_17 * LIGHT_ATTENUATION.y)) + ((tmpvar_17 * tmpvar_17) * LIGHT_ATTENUATION.z))
  ) * clamp (
    (1.0 - ((LIGHT_INNER_DIFF_INV.x - dot (lightDir_15, 
      -(LIGHT_GIVEN_DIRECTION)
    )) * LIGHT_INNER_DIFF_INV.y))
  , 0.0, 1.0)));
  lowp vec4 tmpvar_46;
  tmpvar_46 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_46;
  outColor_2.w = ((col_8.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  tmpvar_5.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_3 = col_8.xyz;
  tmpvar_4 = (mg_7.x * _Metallic);
  tmpvar_5 = (mg_7.y * _Smoothness);
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_13;
  highp vec4 tmpvar_14;
  tmpvar_14 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_13.w = tmpvar_14.w;
  shadowCoord_13.xyz = (tmpvar_14.xyz / tmpvar_14.w);
  shadowCoord_13.xyz = ((shadowCoord_13.xyz * 0.5) + 0.5);
  shadowCoord_13.y = (1.0 - shadowCoord_13.y);
  highp vec2 fetchesOffsetsV_15;
  highp vec2 fetchesOffsetsU_16;
  highp float shadow_17;
  highp vec2 tmpvar_18;
  tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_19;
  tmpvar_19 = floor((tmpvar_18 + 0.5));
  highp vec2 tmpvar_20;
  tmpvar_20 = (tmpvar_18 - tmpvar_19);
  highp vec4 computedWeight_21;
  highp vec4 computedArea_22;
  highp vec4 computedAreaUncut_23;
  highp float tmpvar_24;
  tmpvar_24 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_24 - tmpvar_20.x);
  computedArea_22.x = tmpvar_25;
  computedAreaUncut_23.x = tmpvar_25;
  computedArea_22.w = tmpvar_24;
  computedAreaUncut_23.w = tmpvar_24;
  computedAreaUncut_23.y = ((1.5 - tmpvar_20.x) - 0.5);
  highp float tmpvar_26;
  tmpvar_26 = min (tmpvar_20.x, 0.0);
  computedArea_22.y = (computedAreaUncut_23.y - (tmpvar_26 * tmpvar_26));
  computedAreaUncut_23.z = ((1.5 + tmpvar_20.x) - 0.5);
  highp float tmpvar_27;
  tmpvar_27 = max (tmpvar_20.x, 0.0);
  computedArea_22.z = (computedAreaUncut_23.z - (tmpvar_27 * tmpvar_27));
  computedWeight_21 = (computedArea_22 * 0.44444);
  highp vec4 computedWeight_28;
  highp vec4 computedArea_29;
  highp vec4 computedAreaUncut_30;
  highp float tmpvar_31;
  tmpvar_31 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
  highp float tmpvar_32;
  tmpvar_32 = (tmpvar_31 - tmpvar_20.y);
  computedArea_29.x = tmpvar_32;
  computedAreaUncut_30.x = tmpvar_32;
  computedArea_29.w = tmpvar_31;
  computedAreaUncut_30.w = tmpvar_31;
  computedAreaUncut_30.y = ((1.5 - tmpvar_20.y) - 0.5);
  highp float tmpvar_33;
  tmpvar_33 = min (tmpvar_20.y, 0.0);
  computedArea_29.y = (computedAreaUncut_30.y - (tmpvar_33 * tmpvar_33));
  computedAreaUncut_30.z = ((1.5 + tmpvar_20.y) - 0.5);
  highp float tmpvar_34;
  tmpvar_34 = max (tmpvar_20.y, 0.0);
  computedArea_29.z = (computedAreaUncut_30.z - (tmpvar_34 * tmpvar_34));
  computedWeight_28 = (computedArea_29 * 0.44444);
  highp vec2 tmpvar_35;
  tmpvar_35 = (computedWeight_21.xz + computedWeight_21.yw);
  highp vec2 tmpvar_36;
  tmpvar_36 = (computedWeight_28.xz + computedWeight_28.yw);
  fetchesOffsetsU_16 = (((computedWeight_21.yw / tmpvar_35) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  fetchesOffsetsV_15 = (((computedWeight_28.yw / tmpvar_36) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  highp vec2 tmpvar_37;
  tmpvar_37 = (tmpvar_19 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_38;
  tmpvar_38.x = fetchesOffsetsU_16.x;
  tmpvar_38.y = fetchesOffsetsV_15.x;
  highp vec3 tmpvar_39;
  tmpvar_39.xy = (tmpvar_37 + tmpvar_38);
  tmpvar_39.z = shadowCoord_13.z;
  lowp float tmpvar_40;
  tmpvar_40 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_39);
  shadow_17 = ((tmpvar_35.x * tmpvar_36.x) * tmpvar_40);
  highp vec2 tmpvar_41;
  tmpvar_41.x = fetchesOffsetsU_16.y;
  tmpvar_41.y = fetchesOffsetsV_15.x;
  highp vec3 tmpvar_42;
  tmpvar_42.xy = (tmpvar_37 + tmpvar_41);
  tmpvar_42.z = shadowCoord_13.z;
  lowp float tmpvar_43;
  tmpvar_43 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_42);
  shadow_17 = (shadow_17 + ((tmpvar_35.y * tmpvar_36.x) * tmpvar_43));
  highp vec2 tmpvar_44;
  tmpvar_44.x = fetchesOffsetsU_16.x;
  tmpvar_44.y = fetchesOffsetsV_15.y;
  highp vec3 tmpvar_45;
  tmpvar_45.xy = (tmpvar_37 + tmpvar_44);
  tmpvar_45.z = shadowCoord_13.z;
  lowp float tmpvar_46;
  tmpvar_46 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_45);
  shadow_17 = (shadow_17 + ((tmpvar_35.x * tmpvar_36.y) * tmpvar_46));
  highp vec2 tmpvar_47;
  tmpvar_47.x = fetchesOffsetsU_16.y;
  tmpvar_47.y = fetchesOffsetsV_15.y;
  highp vec3 tmpvar_48;
  tmpvar_48.xy = (tmpvar_37 + tmpvar_47);
  tmpvar_48.z = shadowCoord_13.z;
  lowp float tmpvar_49;
  tmpvar_49 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_48);
  shadow_17 = (shadow_17 + ((tmpvar_35.y * tmpvar_36.y) * tmpvar_49));
  highp vec3 tmpvar_50;
  highp vec3 tmpvar_51;
  highp vec3 lightDir_52;
  highp vec3 tmpvar_53;
  tmpvar_53 = (LIGHT_POSITION - tmpvar_12);
  highp float tmpvar_54;
  tmpvar_54 = clamp ((sqrt(
    dot (tmpvar_53, tmpvar_53)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_52 = normalize(tmpvar_53);
  tmpvar_51 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  tmpvar_50 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  highp float tmpvar_55;
  mediump float diffuseTerm_56;
  highp float perceptualRoughness_57;
  mediump vec3 tmpvar_58;
  mediump vec3 albedo_59;
  albedo_59 = tmpvar_3;
  mediump vec3 specColor_60;
  specColor_60 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_59 * tmpvar_4));
  tmpvar_58 = (albedo_59 * (0.7790837 - (tmpvar_4 * 0.7790837)));
  tmpvar_55 = 0.0;
  mediump float alpha_61;
  alpha_61 = tmpvar_55;
  tmpvar_55 = alpha_61;
  mediump float tmpvar_62;
  tmpvar_62 = (1.0 - tmpvar_5);
  perceptualRoughness_57 = tmpvar_62;
  highp vec3 tmpvar_63;
  highp vec3 inVec_64;
  inVec_64 = (lightDir_52 + tmpvar_50);
  tmpvar_63 = (inVec_64 * inversesqrt(max (0.001, 
    dot (inVec_64, inVec_64)
  )));
  highp float tmpvar_65;
  tmpvar_65 = abs(dot (tmpvar_50, tmpvar_51));
  highp float tmpvar_66;
  tmpvar_66 = clamp (dot (tmpvar_51, lightDir_52), 0.0, 1.0);
  highp float tmpvar_67;
  tmpvar_67 = clamp (dot (tmpvar_51, tmpvar_63), 0.0, 1.0);
  mediump float tmpvar_68;
  highp float tmpvar_69;
  tmpvar_69 = clamp (dot (lightDir_52, tmpvar_63), 0.0, 1.0);
  tmpvar_68 = tmpvar_69;
  mediump float tmpvar_70;
  mediump float NdotV_71;
  NdotV_71 = tmpvar_65;
  mediump float NdotL_72;
  NdotL_72 = tmpvar_66;
  mediump float perceptualRoughness_73;
  perceptualRoughness_73 = perceptualRoughness_57;
  mediump float tmpvar_74;
  tmpvar_74 = (0.5 + ((2.0 * tmpvar_68) * (tmpvar_68 * perceptualRoughness_73)));
  mediump float x_75;
  x_75 = (1.0 - NdotL_72);
  mediump float x_76;
  x_76 = (1.0 - NdotV_71);
  tmpvar_70 = ((1.0 + (
    (tmpvar_74 - 1.0)
   * 
    ((x_75 * x_75) * ((x_75 * x_75) * x_75))
  )) * (1.0 + (
    (tmpvar_74 - 1.0)
   * 
    ((x_76 * x_76) * ((x_76 * x_76) * x_76))
  )));
  highp float tmpvar_77;
  tmpvar_77 = (tmpvar_70 * tmpvar_66);
  diffuseTerm_56 = tmpvar_77;
  highp float tmpvar_78;
  tmpvar_78 = max ((perceptualRoughness_57 * perceptualRoughness_57), 0.002);
  highp float tmpvar_79;
  tmpvar_79 = (tmpvar_78 * tmpvar_78);
  highp float tmpvar_80;
  tmpvar_80 = (((
    (tmpvar_67 * tmpvar_79)
   - tmpvar_67) * tmpvar_67) + 1.0);
  mediump vec3 tmpvar_81;
  mediump float x_82;
  x_82 = (1.0 - tmpvar_68);
  tmpvar_81 = (specColor_60 + ((1.0 - specColor_60) * (
    (x_82 * x_82)
   * 
    ((x_82 * x_82) * x_82)
  )));
  outColor_2.xyz = (((
    (tmpvar_58 * LIGHT_COLOR)
   * diffuseTerm_56) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_79)
       / 
        ((tmpvar_80 * tmpvar_80) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_66 * (
          (tmpvar_65 * (1.0 - tmpvar_78))
         + tmpvar_78)) + (tmpvar_65 * (
          (tmpvar_66 * (1.0 - tmpvar_78))
         + tmpvar_78))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_66)) * LIGHT_COLOR)
   * tmpvar_81)) * ((
    ((1.0 - tmpvar_54) / ((LIGHT_ATTENUATION.x + (tmpvar_54 * LIGHT_ATTENUATION.y)) + ((tmpvar_54 * tmpvar_54) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_52, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_17, LIGHT_PARAM.y)));
  lowp vec4 tmpvar_83;
  tmpvar_83 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_83;
  outColor_2.w = ((col_8.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  tmpvar_5.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_3 = col_8.xyz;
  tmpvar_4 = (mg_7.x * _Metallic);
  tmpvar_5 = (mg_7.y * _Smoothness);
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_13;
  highp vec4 tmpvar_14;
  tmpvar_14 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_13.w = tmpvar_14.w;
  shadowCoord_13.xyz = (tmpvar_14.xyz / tmpvar_14.w);
  shadowCoord_13.xyz = ((shadowCoord_13.xyz * 0.5) + 0.5);
  shadowCoord_13.y = (1.0 - shadowCoord_13.y);
  highp vec3 fetchesOffsetsV_15;
  highp vec3 fetchesOffsetsU_16;
  highp float shadow_17;
  highp vec2 tmpvar_18;
  tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_19;
  tmpvar_19 = floor((tmpvar_18 + 0.5));
  highp vec2 tmpvar_20;
  tmpvar_20 = (tmpvar_18 - tmpvar_19);
  highp vec3 texelsWeightsA_21;
  highp vec3 texelsWeightsB_22;
  highp vec4 computedArea_23;
  highp vec4 computedAreaUncut_24;
  highp float tmpvar_25;
  tmpvar_25 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_25 - tmpvar_20.x);
  computedArea_23.x = tmpvar_26;
  computedAreaUncut_24.x = tmpvar_26;
  computedArea_23.w = tmpvar_25;
  computedAreaUncut_24.w = tmpvar_25;
  computedAreaUncut_24.y = ((1.5 - tmpvar_20.x) - 0.5);
  highp float tmpvar_27;
  tmpvar_27 = min (tmpvar_20.x, 0.0);
  computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
  computedAreaUncut_24.z = ((1.5 + tmpvar_20.x) - 0.5);
  highp float tmpvar_28;
  tmpvar_28 = max (tmpvar_20.x, 0.0);
  computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
  texelsWeightsA_21.x = (0.16 * tmpvar_26);
  texelsWeightsA_21.y = (0.16 * computedAreaUncut_24.y);
  texelsWeightsA_21.z = (0.16 * (computedArea_23.y + 1.0));
  texelsWeightsB_22.x = (0.16 * (computedArea_23.z + 1.0));
  texelsWeightsB_22.y = (0.16 * computedAreaUncut_24.z);
  texelsWeightsB_22.z = (0.16 * tmpvar_25);
  highp vec3 texelsWeightsA_29;
  highp vec3 texelsWeightsB_30;
  highp vec4 computedArea_31;
  highp vec4 computedAreaUncut_32;
  highp float tmpvar_33;
  tmpvar_33 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
  highp float tmpvar_34;
  tmpvar_34 = (tmpvar_33 - tmpvar_20.y);
  computedArea_31.x = tmpvar_34;
  computedAreaUncut_32.x = tmpvar_34;
  computedArea_31.w = tmpvar_33;
  computedAreaUncut_32.w = tmpvar_33;
  computedAreaUncut_32.y = ((1.5 - tmpvar_20.y) - 0.5);
  highp float tmpvar_35;
  tmpvar_35 = min (tmpvar_20.y, 0.0);
  computedArea_31.y = (computedAreaUncut_32.y - (tmpvar_35 * tmpvar_35));
  computedAreaUncut_32.z = ((1.5 + tmpvar_20.y) - 0.5);
  highp float tmpvar_36;
  tmpvar_36 = max (tmpvar_20.y, 0.0);
  computedArea_31.z = (computedAreaUncut_32.z - (tmpvar_36 * tmpvar_36));
  texelsWeightsA_29.x = (0.16 * tmpvar_34);
  texelsWeightsA_29.y = (0.16 * computedAreaUncut_32.y);
  texelsWeightsA_29.z = (0.16 * (computedArea_31.y + 1.0));
  texelsWeightsB_30.x = (0.16 * (computedArea_31.z + 1.0));
  texelsWeightsB_30.y = (0.16 * computedAreaUncut_32.z);
  texelsWeightsB_30.z = (0.16 * tmpvar_33);
  highp vec3 tmpvar_37;
  tmpvar_37.xy = texelsWeightsA_21.xz;
  tmpvar_37.z = texelsWeightsB_22.y;
  highp vec3 tmpvar_38;
  tmpvar_38.x = texelsWeightsA_21.y;
  tmpvar_38.yz = texelsWeightsB_22.xz;
  highp vec3 tmpvar_39;
  tmpvar_39 = (tmpvar_37 + tmpvar_38);
  highp vec3 tmpvar_40;
  tmpvar_40.xy = texelsWeightsA_29.xz;
  tmpvar_40.z = texelsWeightsB_30.y;
  highp vec3 tmpvar_41;
  tmpvar_41.x = texelsWeightsA_29.y;
  tmpvar_41.yz = texelsWeightsB_30.xz;
  highp vec3 tmpvar_42;
  tmpvar_42 = (tmpvar_40 + tmpvar_41);
  highp vec3 tmpvar_43;
  tmpvar_43.x = texelsWeightsA_21.y;
  tmpvar_43.yz = texelsWeightsB_22.xz;
  highp vec3 tmpvar_44;
  tmpvar_44.x = texelsWeightsA_29.y;
  tmpvar_44.yz = texelsWeightsB_30.xz;
  fetchesOffsetsU_16 = (((tmpvar_43 / tmpvar_39) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
  fetchesOffsetsV_15 = (((tmpvar_44 / tmpvar_42) + vec3(-2.5, -0.5, 1.5)) * LIGHT_PARAM.zzz);
  highp vec2 tmpvar_45;
  tmpvar_45 = (tmpvar_19 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_46;
  tmpvar_46.x = fetchesOffsetsU_16.x;
  tmpvar_46.y = fetchesOffsetsV_15.x;
  highp vec3 tmpvar_47;
  tmpvar_47.xy = (tmpvar_45 + tmpvar_46);
  tmpvar_47.z = shadowCoord_13.z;
  lowp float tmpvar_48;
  tmpvar_48 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_47);
  shadow_17 = ((tmpvar_39.x * tmpvar_42.x) * tmpvar_48);
  highp vec2 tmpvar_49;
  tmpvar_49.x = fetchesOffsetsU_16.y;
  tmpvar_49.y = fetchesOffsetsV_15.x;
  highp vec3 tmpvar_50;
  tmpvar_50.xy = (tmpvar_45 + tmpvar_49);
  tmpvar_50.z = shadowCoord_13.z;
  lowp float tmpvar_51;
  tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
  shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.x) * tmpvar_51));
  highp vec2 tmpvar_52;
  tmpvar_52.x = fetchesOffsetsU_16.z;
  tmpvar_52.y = fetchesOffsetsV_15.x;
  highp vec3 tmpvar_53;
  tmpvar_53.xy = (tmpvar_45 + tmpvar_52);
  tmpvar_53.z = shadowCoord_13.z;
  lowp float tmpvar_54;
  tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
  shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.x) * tmpvar_54));
  highp vec2 tmpvar_55;
  tmpvar_55.x = fetchesOffsetsU_16.x;
  tmpvar_55.y = fetchesOffsetsV_15.y;
  highp vec3 tmpvar_56;
  tmpvar_56.xy = (tmpvar_45 + tmpvar_55);
  tmpvar_56.z = shadowCoord_13.z;
  lowp float tmpvar_57;
  tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
  shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.y) * tmpvar_57));
  highp vec2 tmpvar_58;
  tmpvar_58.x = fetchesOffsetsU_16.y;
  tmpvar_58.y = fetchesOffsetsV_15.y;
  highp vec3 tmpvar_59;
  tmpvar_59.xy = (tmpvar_45 + tmpvar_58);
  tmpvar_59.z = shadowCoord_13.z;
  lowp float tmpvar_60;
  tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
  shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.y) * tmpvar_60));
  highp vec2 tmpvar_61;
  tmpvar_61.x = fetchesOffsetsU_16.z;
  tmpvar_61.y = fetchesOffsetsV_15.y;
  highp vec3 tmpvar_62;
  tmpvar_62.xy = (tmpvar_45 + tmpvar_61);
  tmpvar_62.z = shadowCoord_13.z;
  lowp float tmpvar_63;
  tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
  shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.y) * tmpvar_63));
  highp vec2 tmpvar_64;
  tmpvar_64.x = fetchesOffsetsU_16.x;
  tmpvar_64.y = fetchesOffsetsV_15.z;
  highp vec3 tmpvar_65;
  tmpvar_65.xy = (tmpvar_45 + tmpvar_64);
  tmpvar_65.z = shadowCoord_13.z;
  lowp float tmpvar_66;
  tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
  shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.z) * tmpvar_66));
  highp vec2 tmpvar_67;
  tmpvar_67.x = fetchesOffsetsU_16.y;
  tmpvar_67.y = fetchesOffsetsV_15.z;
  highp vec3 tmpvar_68;
  tmpvar_68.xy = (tmpvar_45 + tmpvar_67);
  tmpvar_68.z = shadowCoord_13.z;
  lowp float tmpvar_69;
  tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
  shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.z) * tmpvar_69));
  highp vec2 tmpvar_70;
  tmpvar_70.x = fetchesOffsetsU_16.z;
  tmpvar_70.y = fetchesOffsetsV_15.z;
  highp vec3 tmpvar_71;
  tmpvar_71.xy = (tmpvar_45 + tmpvar_70);
  tmpvar_71.z = shadowCoord_13.z;
  lowp float tmpvar_72;
  tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
  shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.z) * tmpvar_72));
  highp vec3 tmpvar_73;
  highp vec3 tmpvar_74;
  highp vec3 lightDir_75;
  highp vec3 tmpvar_76;
  tmpvar_76 = (LIGHT_POSITION - tmpvar_12);
  highp float tmpvar_77;
  tmpvar_77 = clamp ((sqrt(
    dot (tmpvar_76, tmpvar_76)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_75 = normalize(tmpvar_76);
  tmpvar_74 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  tmpvar_73 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  highp float tmpvar_78;
  mediump float diffuseTerm_79;
  highp float perceptualRoughness_80;
  mediump vec3 tmpvar_81;
  mediump vec3 albedo_82;
  albedo_82 = tmpvar_3;
  mediump vec3 specColor_83;
  specColor_83 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_82 * tmpvar_4));
  tmpvar_81 = (albedo_82 * (0.7790837 - (tmpvar_4 * 0.7790837)));
  tmpvar_78 = 0.0;
  mediump float alpha_84;
  alpha_84 = tmpvar_78;
  tmpvar_78 = alpha_84;
  mediump float tmpvar_85;
  tmpvar_85 = (1.0 - tmpvar_5);
  perceptualRoughness_80 = tmpvar_85;
  highp vec3 tmpvar_86;
  highp vec3 inVec_87;
  inVec_87 = (lightDir_75 + tmpvar_73);
  tmpvar_86 = (inVec_87 * inversesqrt(max (0.001, 
    dot (inVec_87, inVec_87)
  )));
  highp float tmpvar_88;
  tmpvar_88 = abs(dot (tmpvar_73, tmpvar_74));
  highp float tmpvar_89;
  tmpvar_89 = clamp (dot (tmpvar_74, lightDir_75), 0.0, 1.0);
  highp float tmpvar_90;
  tmpvar_90 = clamp (dot (tmpvar_74, tmpvar_86), 0.0, 1.0);
  mediump float tmpvar_91;
  highp float tmpvar_92;
  tmpvar_92 = clamp (dot (lightDir_75, tmpvar_86), 0.0, 1.0);
  tmpvar_91 = tmpvar_92;
  mediump float tmpvar_93;
  mediump float NdotV_94;
  NdotV_94 = tmpvar_88;
  mediump float NdotL_95;
  NdotL_95 = tmpvar_89;
  mediump float perceptualRoughness_96;
  perceptualRoughness_96 = perceptualRoughness_80;
  mediump float tmpvar_97;
  tmpvar_97 = (0.5 + ((2.0 * tmpvar_91) * (tmpvar_91 * perceptualRoughness_96)));
  mediump float x_98;
  x_98 = (1.0 - NdotL_95);
  mediump float x_99;
  x_99 = (1.0 - NdotV_94);
  tmpvar_93 = ((1.0 + (
    (tmpvar_97 - 1.0)
   * 
    ((x_98 * x_98) * ((x_98 * x_98) * x_98))
  )) * (1.0 + (
    (tmpvar_97 - 1.0)
   * 
    ((x_99 * x_99) * ((x_99 * x_99) * x_99))
  )));
  highp float tmpvar_100;
  tmpvar_100 = (tmpvar_93 * tmpvar_89);
  diffuseTerm_79 = tmpvar_100;
  highp float tmpvar_101;
  tmpvar_101 = max ((perceptualRoughness_80 * perceptualRoughness_80), 0.002);
  highp float tmpvar_102;
  tmpvar_102 = (tmpvar_101 * tmpvar_101);
  highp float tmpvar_103;
  tmpvar_103 = (((
    (tmpvar_90 * tmpvar_102)
   - tmpvar_90) * tmpvar_90) + 1.0);
  mediump vec3 tmpvar_104;
  mediump float x_105;
  x_105 = (1.0 - tmpvar_91);
  tmpvar_104 = (specColor_83 + ((1.0 - specColor_83) * (
    (x_105 * x_105)
   * 
    ((x_105 * x_105) * x_105)
  )));
  outColor_2.xyz = (((
    (tmpvar_81 * LIGHT_COLOR)
   * diffuseTerm_79) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_102)
       / 
        ((tmpvar_103 * tmpvar_103) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_89 * (
          (tmpvar_88 * (1.0 - tmpvar_101))
         + tmpvar_101)) + (tmpvar_88 * (
          (tmpvar_89 * (1.0 - tmpvar_101))
         + tmpvar_101))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_89)) * LIGHT_COLOR)
   * tmpvar_104)) * ((
    ((1.0 - tmpvar_77) / ((LIGHT_ATTENUATION.x + (tmpvar_77 * LIGHT_ATTENUATION.y)) + ((tmpvar_77 * tmpvar_77) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_75, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_17, LIGHT_PARAM.y)));
  lowp vec4 tmpvar_106;
  tmpvar_106 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_106;
  outColor_2.w = ((col_8.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  tmpvar_5.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform lowp sampler2DShadow TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_3 = col_8.xyz;
  tmpvar_4 = (mg_7.x * _Metallic);
  tmpvar_5 = (mg_7.y * _Smoothness);
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_13;
  highp vec4 tmpvar_14;
  tmpvar_14 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_13.w = tmpvar_14.w;
  shadowCoord_13.xyz = (tmpvar_14.xyz / tmpvar_14.w);
  shadowCoord_13.xyz = ((shadowCoord_13.xyz * 0.5) + 0.5);
  shadowCoord_13.y = (1.0 - shadowCoord_13.y);
  highp vec4 fetchesOffsetsV_15;
  highp vec4 fetchesOffsetsU_16;
  highp float shadow_17;
  highp vec2 tmpvar_18;
  tmpvar_18 = (shadowCoord_13.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_19;
  tmpvar_19 = floor((tmpvar_18 + 0.5));
  highp vec2 tmpvar_20;
  tmpvar_20 = (tmpvar_18 - tmpvar_19);
  highp vec4 texelsWeightsA_21;
  highp vec4 texelsWeightsB_22;
  highp vec4 computedArea_23;
  highp vec4 computedAreaUncut_24;
  highp float tmpvar_25;
  tmpvar_25 = (((tmpvar_20.x + 0.5) * (tmpvar_20.x + 0.5)) * 0.5);
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_25 - tmpvar_20.x);
  computedArea_23.x = tmpvar_26;
  computedAreaUncut_24.x = tmpvar_26;
  computedArea_23.w = tmpvar_25;
  computedAreaUncut_24.w = tmpvar_25;
  computedAreaUncut_24.y = ((1.5 - tmpvar_20.x) - 0.5);
  highp float tmpvar_27;
  tmpvar_27 = min (tmpvar_20.x, 0.0);
  computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
  computedAreaUncut_24.z = ((1.5 + tmpvar_20.x) - 0.5);
  highp float tmpvar_28;
  tmpvar_28 = max (tmpvar_20.x, 0.0);
  computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
  texelsWeightsA_21.x = (0.081632 * tmpvar_26);
  texelsWeightsA_21.y = (0.081632 * computedAreaUncut_24.y);
  texelsWeightsA_21.z = (0.081632 * (computedAreaUncut_24.y + 1.0));
  texelsWeightsA_21.w = (0.081632 * (computedArea_23.y + 2.0));
  texelsWeightsB_22.x = (0.081632 * (computedArea_23.z + 2.0));
  texelsWeightsB_22.y = (0.081632 * (computedAreaUncut_24.z + 1.0));
  texelsWeightsB_22.z = (0.081632 * computedAreaUncut_24.z);
  texelsWeightsB_22.w = (0.081632 * tmpvar_25);
  highp vec4 texelsWeightsA_29;
  highp vec4 texelsWeightsB_30;
  highp vec4 computedArea_31;
  highp vec4 computedAreaUncut_32;
  highp float tmpvar_33;
  tmpvar_33 = (((tmpvar_20.y + 0.5) * (tmpvar_20.y + 0.5)) * 0.5);
  highp float tmpvar_34;
  tmpvar_34 = (tmpvar_33 - tmpvar_20.y);
  computedArea_31.x = tmpvar_34;
  computedAreaUncut_32.x = tmpvar_34;
  computedArea_31.w = tmpvar_33;
  computedAreaUncut_32.w = tmpvar_33;
  computedAreaUncut_32.y = ((1.5 - tmpvar_20.y) - 0.5);
  highp float tmpvar_35;
  tmpvar_35 = min (tmpvar_20.y, 0.0);
  computedArea_31.y = (computedAreaUncut_32.y - (tmpvar_35 * tmpvar_35));
  computedAreaUncut_32.z = ((1.5 + tmpvar_20.y) - 0.5);
  highp float tmpvar_36;
  tmpvar_36 = max (tmpvar_20.y, 0.0);
  computedArea_31.z = (computedAreaUncut_32.z - (tmpvar_36 * tmpvar_36));
  texelsWeightsA_29.x = (0.081632 * tmpvar_34);
  texelsWeightsA_29.y = (0.081632 * computedAreaUncut_32.y);
  texelsWeightsA_29.z = (0.081632 * (computedAreaUncut_32.y + 1.0));
  texelsWeightsA_29.w = (0.081632 * (computedArea_31.y + 2.0));
  texelsWeightsB_30.x = (0.081632 * (computedArea_31.z + 2.0));
  texelsWeightsB_30.y = (0.081632 * (computedAreaUncut_32.z + 1.0));
  texelsWeightsB_30.z = (0.081632 * computedAreaUncut_32.z);
  texelsWeightsB_30.w = (0.081632 * tmpvar_33);
  highp vec4 tmpvar_37;
  tmpvar_37.xy = texelsWeightsA_21.xz;
  tmpvar_37.zw = texelsWeightsB_22.xz;
  highp vec4 tmpvar_38;
  tmpvar_38.xy = texelsWeightsA_21.yw;
  tmpvar_38.zw = texelsWeightsB_22.yw;
  highp vec4 tmpvar_39;
  tmpvar_39 = (tmpvar_37 + tmpvar_38);
  highp vec4 tmpvar_40;
  tmpvar_40.xy = texelsWeightsA_29.xz;
  tmpvar_40.zw = texelsWeightsB_30.xz;
  highp vec4 tmpvar_41;
  tmpvar_41.xy = texelsWeightsA_29.yw;
  tmpvar_41.zw = texelsWeightsB_30.yw;
  highp vec4 tmpvar_42;
  tmpvar_42 = (tmpvar_40 + tmpvar_41);
  highp vec4 tmpvar_43;
  tmpvar_43.xy = texelsWeightsA_21.yw;
  tmpvar_43.zw = texelsWeightsB_22.yw;
  highp vec4 tmpvar_44;
  tmpvar_44.xy = texelsWeightsA_29.yw;
  tmpvar_44.zw = texelsWeightsB_30.yw;
  fetchesOffsetsU_16 = (((tmpvar_43 / tmpvar_39) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
  fetchesOffsetsV_15 = (((tmpvar_44 / tmpvar_42) + vec4(-3.5, -1.5, 0.5, 2.5)) * LIGHT_PARAM.zzzz);
  highp vec2 tmpvar_45;
  tmpvar_45 = (tmpvar_19 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_46;
  tmpvar_46.x = fetchesOffsetsU_16.x;
  tmpvar_46.y = fetchesOffsetsV_15.x;
  highp vec3 tmpvar_47;
  tmpvar_47.xy = (tmpvar_45 + tmpvar_46);
  tmpvar_47.z = shadowCoord_13.z;
  lowp float tmpvar_48;
  tmpvar_48 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_47);
  shadow_17 = ((tmpvar_39.x * tmpvar_42.x) * tmpvar_48);
  highp vec2 tmpvar_49;
  tmpvar_49.x = fetchesOffsetsU_16.y;
  tmpvar_49.y = fetchesOffsetsV_15.x;
  highp vec3 tmpvar_50;
  tmpvar_50.xy = (tmpvar_45 + tmpvar_49);
  tmpvar_50.z = shadowCoord_13.z;
  lowp float tmpvar_51;
  tmpvar_51 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_50);
  shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.x) * tmpvar_51));
  highp vec2 tmpvar_52;
  tmpvar_52.x = fetchesOffsetsU_16.z;
  tmpvar_52.y = fetchesOffsetsV_15.x;
  highp vec3 tmpvar_53;
  tmpvar_53.xy = (tmpvar_45 + tmpvar_52);
  tmpvar_53.z = shadowCoord_13.z;
  lowp float tmpvar_54;
  tmpvar_54 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_53);
  shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.x) * tmpvar_54));
  highp vec2 tmpvar_55;
  tmpvar_55.x = fetchesOffsetsU_16.w;
  tmpvar_55.y = fetchesOffsetsV_15.x;
  highp vec3 tmpvar_56;
  tmpvar_56.xy = (tmpvar_45 + tmpvar_55);
  tmpvar_56.z = shadowCoord_13.z;
  lowp float tmpvar_57;
  tmpvar_57 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_56);
  shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.x) * tmpvar_57));
  highp vec2 tmpvar_58;
  tmpvar_58.x = fetchesOffsetsU_16.x;
  tmpvar_58.y = fetchesOffsetsV_15.y;
  highp vec3 tmpvar_59;
  tmpvar_59.xy = (tmpvar_45 + tmpvar_58);
  tmpvar_59.z = shadowCoord_13.z;
  lowp float tmpvar_60;
  tmpvar_60 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_59);
  shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.y) * tmpvar_60));
  highp vec2 tmpvar_61;
  tmpvar_61.x = fetchesOffsetsU_16.y;
  tmpvar_61.y = fetchesOffsetsV_15.y;
  highp vec3 tmpvar_62;
  tmpvar_62.xy = (tmpvar_45 + tmpvar_61);
  tmpvar_62.z = shadowCoord_13.z;
  lowp float tmpvar_63;
  tmpvar_63 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_62);
  shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.y) * tmpvar_63));
  highp vec2 tmpvar_64;
  tmpvar_64.x = fetchesOffsetsU_16.z;
  tmpvar_64.y = fetchesOffsetsV_15.y;
  highp vec3 tmpvar_65;
  tmpvar_65.xy = (tmpvar_45 + tmpvar_64);
  tmpvar_65.z = shadowCoord_13.z;
  lowp float tmpvar_66;
  tmpvar_66 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_65);
  shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.y) * tmpvar_66));
  highp vec2 tmpvar_67;
  tmpvar_67.x = fetchesOffsetsU_16.w;
  tmpvar_67.y = fetchesOffsetsV_15.y;
  highp vec3 tmpvar_68;
  tmpvar_68.xy = (tmpvar_45 + tmpvar_67);
  tmpvar_68.z = shadowCoord_13.z;
  lowp float tmpvar_69;
  tmpvar_69 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_68);
  shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.y) * tmpvar_69));
  highp vec2 tmpvar_70;
  tmpvar_70.x = fetchesOffsetsU_16.x;
  tmpvar_70.y = fetchesOffsetsV_15.z;
  highp vec3 tmpvar_71;
  tmpvar_71.xy = (tmpvar_45 + tmpvar_70);
  tmpvar_71.z = shadowCoord_13.z;
  lowp float tmpvar_72;
  tmpvar_72 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_71);
  shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.z) * tmpvar_72));
  highp vec2 tmpvar_73;
  tmpvar_73.x = fetchesOffsetsU_16.y;
  tmpvar_73.y = fetchesOffsetsV_15.z;
  highp vec3 tmpvar_74;
  tmpvar_74.xy = (tmpvar_45 + tmpvar_73);
  tmpvar_74.z = shadowCoord_13.z;
  lowp float tmpvar_75;
  tmpvar_75 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_74);
  shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.z) * tmpvar_75));
  highp vec2 tmpvar_76;
  tmpvar_76.x = fetchesOffsetsU_16.z;
  tmpvar_76.y = fetchesOffsetsV_15.z;
  highp vec3 tmpvar_77;
  tmpvar_77.xy = (tmpvar_45 + tmpvar_76);
  tmpvar_77.z = shadowCoord_13.z;
  lowp float tmpvar_78;
  tmpvar_78 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_77);
  shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.z) * tmpvar_78));
  highp vec2 tmpvar_79;
  tmpvar_79.x = fetchesOffsetsU_16.w;
  tmpvar_79.y = fetchesOffsetsV_15.z;
  highp vec3 tmpvar_80;
  tmpvar_80.xy = (tmpvar_45 + tmpvar_79);
  tmpvar_80.z = shadowCoord_13.z;
  lowp float tmpvar_81;
  tmpvar_81 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_80);
  shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.z) * tmpvar_81));
  highp vec2 tmpvar_82;
  tmpvar_82.x = fetchesOffsetsU_16.x;
  tmpvar_82.y = fetchesOffsetsV_15.w;
  highp vec3 tmpvar_83;
  tmpvar_83.xy = (tmpvar_45 + tmpvar_82);
  tmpvar_83.z = shadowCoord_13.z;
  lowp float tmpvar_84;
  tmpvar_84 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_83);
  shadow_17 = (shadow_17 + ((tmpvar_39.x * tmpvar_42.w) * tmpvar_84));
  highp vec2 tmpvar_85;
  tmpvar_85.x = fetchesOffsetsU_16.y;
  tmpvar_85.y = fetchesOffsetsV_15.w;
  highp vec3 tmpvar_86;
  tmpvar_86.xy = (tmpvar_45 + tmpvar_85);
  tmpvar_86.z = shadowCoord_13.z;
  lowp float tmpvar_87;
  tmpvar_87 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_86);
  shadow_17 = (shadow_17 + ((tmpvar_39.y * tmpvar_42.w) * tmpvar_87));
  highp vec2 tmpvar_88;
  tmpvar_88.x = fetchesOffsetsU_16.z;
  tmpvar_88.y = fetchesOffsetsV_15.w;
  highp vec3 tmpvar_89;
  tmpvar_89.xy = (tmpvar_45 + tmpvar_88);
  tmpvar_89.z = shadowCoord_13.z;
  lowp float tmpvar_90;
  tmpvar_90 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_89);
  shadow_17 = (shadow_17 + ((tmpvar_39.z * tmpvar_42.w) * tmpvar_90));
  highp vec2 tmpvar_91;
  tmpvar_91.x = fetchesOffsetsU_16.w;
  tmpvar_91.y = fetchesOffsetsV_15.w;
  highp vec3 tmpvar_92;
  tmpvar_92.xy = (tmpvar_45 + tmpvar_91);
  tmpvar_92.z = shadowCoord_13.z;
  lowp float tmpvar_93;
  tmpvar_93 = shadow2DEXT (TEXTURE_SHADOW_DEPTH, tmpvar_92);
  shadow_17 = (shadow_17 + ((tmpvar_39.w * tmpvar_42.w) * tmpvar_93));
  highp vec3 tmpvar_94;
  highp vec3 tmpvar_95;
  highp vec3 lightDir_96;
  highp vec3 tmpvar_97;
  tmpvar_97 = (LIGHT_POSITION - tmpvar_12);
  highp float tmpvar_98;
  tmpvar_98 = clamp ((sqrt(
    dot (tmpvar_97, tmpvar_97)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_96 = normalize(tmpvar_97);
  tmpvar_95 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  tmpvar_94 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  highp float tmpvar_99;
  mediump float diffuseTerm_100;
  highp float perceptualRoughness_101;
  mediump vec3 tmpvar_102;
  mediump vec3 albedo_103;
  albedo_103 = tmpvar_3;
  mediump vec3 specColor_104;
  specColor_104 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_103 * tmpvar_4));
  tmpvar_102 = (albedo_103 * (0.7790837 - (tmpvar_4 * 0.7790837)));
  tmpvar_99 = 0.0;
  mediump float alpha_105;
  alpha_105 = tmpvar_99;
  tmpvar_99 = alpha_105;
  mediump float tmpvar_106;
  tmpvar_106 = (1.0 - tmpvar_5);
  perceptualRoughness_101 = tmpvar_106;
  highp vec3 tmpvar_107;
  highp vec3 inVec_108;
  inVec_108 = (lightDir_96 + tmpvar_94);
  tmpvar_107 = (inVec_108 * inversesqrt(max (0.001, 
    dot (inVec_108, inVec_108)
  )));
  highp float tmpvar_109;
  tmpvar_109 = abs(dot (tmpvar_94, tmpvar_95));
  highp float tmpvar_110;
  tmpvar_110 = clamp (dot (tmpvar_95, lightDir_96), 0.0, 1.0);
  highp float tmpvar_111;
  tmpvar_111 = clamp (dot (tmpvar_95, tmpvar_107), 0.0, 1.0);
  mediump float tmpvar_112;
  highp float tmpvar_113;
  tmpvar_113 = clamp (dot (lightDir_96, tmpvar_107), 0.0, 1.0);
  tmpvar_112 = tmpvar_113;
  mediump float tmpvar_114;
  mediump float NdotV_115;
  NdotV_115 = tmpvar_109;
  mediump float NdotL_116;
  NdotL_116 = tmpvar_110;
  mediump float perceptualRoughness_117;
  perceptualRoughness_117 = perceptualRoughness_101;
  mediump float tmpvar_118;
  tmpvar_118 = (0.5 + ((2.0 * tmpvar_112) * (tmpvar_112 * perceptualRoughness_117)));
  mediump float x_119;
  x_119 = (1.0 - NdotL_116);
  mediump float x_120;
  x_120 = (1.0 - NdotV_115);
  tmpvar_114 = ((1.0 + (
    (tmpvar_118 - 1.0)
   * 
    ((x_119 * x_119) * ((x_119 * x_119) * x_119))
  )) * (1.0 + (
    (tmpvar_118 - 1.0)
   * 
    ((x_120 * x_120) * ((x_120 * x_120) * x_120))
  )));
  highp float tmpvar_121;
  tmpvar_121 = (tmpvar_114 * tmpvar_110);
  diffuseTerm_100 = tmpvar_121;
  highp float tmpvar_122;
  tmpvar_122 = max ((perceptualRoughness_101 * perceptualRoughness_101), 0.002);
  highp float tmpvar_123;
  tmpvar_123 = (tmpvar_122 * tmpvar_122);
  highp float tmpvar_124;
  tmpvar_124 = (((
    (tmpvar_111 * tmpvar_123)
   - tmpvar_111) * tmpvar_111) + 1.0);
  mediump vec3 tmpvar_125;
  mediump float x_126;
  x_126 = (1.0 - tmpvar_112);
  tmpvar_125 = (specColor_104 + ((1.0 - specColor_104) * (
    (x_126 * x_126)
   * 
    ((x_126 * x_126) * x_126)
  )));
  outColor_2.xyz = (((
    (tmpvar_102 * LIGHT_COLOR)
   * diffuseTerm_100) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_123)
       / 
        ((tmpvar_124 * tmpvar_124) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_110 * (
          (tmpvar_109 * (1.0 - tmpvar_122))
         + tmpvar_122)) + (tmpvar_109 * (
          (tmpvar_110 * (1.0 - tmpvar_122))
         + tmpvar_122))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_110)) * LIGHT_COLOR)
   * tmpvar_125)) * ((
    ((1.0 - tmpvar_98) / ((LIGHT_ATTENUATION.x + (tmpvar_98 * LIGHT_ATTENUATION.y)) + ((tmpvar_98 * tmpvar_98) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_96, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_17, LIGHT_PARAM.y)));
  lowp vec4 tmpvar_127;
  tmpvar_127 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_127;
  outColor_2.w = ((col_8.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"SpotLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_GIVEN_DIRECTION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_INNER_DIFF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_CAMERA_PROJECTION",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_SHADOW_DEPTH",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_7.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (LOCALWORLD_TRANSFORM * tmpvar_8).xyz;
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_10 * _glesNormal));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_11 * _glesTangent));
  highp mat3 tmpvar_12;
  tmpvar_12[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_12[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_12[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_12 * _glesBinormal));
  tmpvar_2.w = tmpvar_9.x;
  tmpvar_3.w = tmpvar_9.y;
  tmpvar_4.w = tmpvar_9.z;
  highp vec4 tmpvar_13;
  tmpvar_13.w = 1.0;
  tmpvar_13.xyz = tmpvar_1.xyz;
  tmpvar_5.xyz = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  tmpvar_5.w = 1.0;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_7 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6)));
  xlv_TEXCOORD4 = tmpvar_5;
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp sampler2D TEXTURE_SHADOW_DEPTH;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 normalWorld_6;
  highp vec3 normalTangent_7;
  highp vec2 mg_8;
  highp vec4 col_9;
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_9 = tmpvar_10;
  lowp vec2 tmpvar_11;
  tmpvar_11 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_8 = tmpvar_11;
  lowp vec3 tmpvar_12;
  tmpvar_12 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_7 = tmpvar_12;
  normalTangent_7 = ((normalTangent_7 * 2.0) - 1.0);
  normalWorld_6 = normalize(((
    (normalTangent_7.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_7.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_7.z * xlv_TEXCOORD1.xyz)));
  tmpvar_3 = col_9.xyz;
  tmpvar_4 = (mg_8.x * _Metallic);
  tmpvar_5 = (mg_8.y * _Smoothness);
  highp vec3 tmpvar_13;
  tmpvar_13.x = xlv_TEXCOORD1.w;
  tmpvar_13.y = xlv_TEXCOORD2.w;
  tmpvar_13.z = xlv_TEXCOORD3.w;
  highp vec4 shadowCoord_14;
  highp vec4 tmpvar_15;
  tmpvar_15 = (LIGHT_CAMERA_PROJECTION * (LIGHT_CAMERA_VIEW * xlv_TEXCOORD4));
  shadowCoord_14.w = tmpvar_15.w;
  shadowCoord_14.xyz = (tmpvar_15.xyz / tmpvar_15.w);
  shadowCoord_14.xyz = ((shadowCoord_14.xyz * 0.5) + 0.5);
  shadowCoord_14.y = (1.0 - shadowCoord_14.y);
  highp vec2 fetchesOffsetsV_16;
  highp vec2 fetchesOffsetsU_17;
  highp float shadow_18;
  shadow_18 = 1.0;
  highp vec2 tmpvar_19;
  tmpvar_19 = (shadowCoord_14.xy * vec2((1.0/(LIGHT_PARAM.z))));
  highp vec2 tmpvar_20;
  tmpvar_20 = floor((tmpvar_19 + 0.5));
  highp vec2 tmpvar_21;
  tmpvar_21 = (tmpvar_19 - tmpvar_20);
  highp vec4 computedWeight_22;
  highp vec4 computedArea_23;
  highp vec4 computedAreaUncut_24;
  highp float tmpvar_25;
  tmpvar_25 = (((tmpvar_21.x + 0.5) * (tmpvar_21.x + 0.5)) * 0.5);
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_25 - tmpvar_21.x);
  computedArea_23.x = tmpvar_26;
  computedAreaUncut_24.x = tmpvar_26;
  computedArea_23.w = tmpvar_25;
  computedAreaUncut_24.w = tmpvar_25;
  computedAreaUncut_24.y = ((1.5 - tmpvar_21.x) - 0.5);
  highp float tmpvar_27;
  tmpvar_27 = min (tmpvar_21.x, 0.0);
  computedArea_23.y = (computedAreaUncut_24.y - (tmpvar_27 * tmpvar_27));
  computedAreaUncut_24.z = ((1.5 + tmpvar_21.x) - 0.5);
  highp float tmpvar_28;
  tmpvar_28 = max (tmpvar_21.x, 0.0);
  computedArea_23.z = (computedAreaUncut_24.z - (tmpvar_28 * tmpvar_28));
  computedWeight_22 = (computedArea_23 * 0.44444);
  highp vec4 computedWeight_29;
  highp vec4 computedArea_30;
  highp vec4 computedAreaUncut_31;
  highp float tmpvar_32;
  tmpvar_32 = (((tmpvar_21.y + 0.5) * (tmpvar_21.y + 0.5)) * 0.5);
  highp float tmpvar_33;
  tmpvar_33 = (tmpvar_32 - tmpvar_21.y);
  computedArea_30.x = tmpvar_33;
  computedAreaUncut_31.x = tmpvar_33;
  computedArea_30.w = tmpvar_32;
  computedAreaUncut_31.w = tmpvar_32;
  computedAreaUncut_31.y = ((1.5 - tmpvar_21.y) - 0.5);
  highp float tmpvar_34;
  tmpvar_34 = min (tmpvar_21.y, 0.0);
  computedArea_30.y = (computedAreaUncut_31.y - (tmpvar_34 * tmpvar_34));
  computedAreaUncut_31.z = ((1.5 + tmpvar_21.y) - 0.5);
  highp float tmpvar_35;
  tmpvar_35 = max (tmpvar_21.y, 0.0);
  computedArea_30.z = (computedAreaUncut_31.z - (tmpvar_35 * tmpvar_35));
  computedWeight_29 = (computedArea_30 * 0.44444);
  highp vec2 tmpvar_36;
  tmpvar_36 = (computedWeight_22.xz + computedWeight_22.yw);
  highp vec2 tmpvar_37;
  tmpvar_37 = (computedWeight_29.xz + computedWeight_29.yw);
  fetchesOffsetsU_17 = (((computedWeight_22.yw / tmpvar_36) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  fetchesOffsetsV_16 = (((computedWeight_29.yw / tmpvar_37) + vec2(-1.5, 0.5)) * LIGHT_PARAM.zz);
  highp vec2 tmpvar_38;
  tmpvar_38 = (tmpvar_20 * LIGHT_PARAM.zz);
  highp vec2 tmpvar_39;
  tmpvar_39.x = fetchesOffsetsU_17.x;
  tmpvar_39.y = fetchesOffsetsV_16.x;
  highp vec3 tmpvar_40;
  tmpvar_40.xy = (tmpvar_38 + tmpvar_39);
  tmpvar_40.z = shadowCoord_14.z;
  highp vec4 tmpvar_41;
  tmpvar_41 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_40.xy);
  highp float tmpvar_42;
  if ((tmpvar_41.x < shadowCoord_14.z)) {
    tmpvar_42 = 0.0;
  } else {
    tmpvar_42 = 1.0;
  };
  shadow_18 = ((tmpvar_36.x * tmpvar_37.x) * tmpvar_42);
  highp vec2 tmpvar_43;
  tmpvar_43.x = fetchesOffsetsU_17.y;
  tmpvar_43.y = fetchesOffsetsV_16.x;
  highp vec3 tmpvar_44;
  tmpvar_44.xy = (tmpvar_38 + tmpvar_43);
  tmpvar_44.z = shadowCoord_14.z;
  highp vec4 tmpvar_45;
  tmpvar_45 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_44.xy);
  highp float tmpvar_46;
  if ((tmpvar_45.x < shadowCoord_14.z)) {
    tmpvar_46 = 0.0;
  } else {
    tmpvar_46 = 1.0;
  };
  shadow_18 = (shadow_18 + ((tmpvar_36.y * tmpvar_37.x) * tmpvar_46));
  highp vec2 tmpvar_47;
  tmpvar_47.x = fetchesOffsetsU_17.x;
  tmpvar_47.y = fetchesOffsetsV_16.y;
  highp vec3 tmpvar_48;
  tmpvar_48.xy = (tmpvar_38 + tmpvar_47);
  tmpvar_48.z = shadowCoord_14.z;
  highp vec4 tmpvar_49;
  tmpvar_49 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_48.xy);
  highp float tmpvar_50;
  if ((tmpvar_49.x < shadowCoord_14.z)) {
    tmpvar_50 = 0.0;
  } else {
    tmpvar_50 = 1.0;
  };
  shadow_18 = (shadow_18 + ((tmpvar_36.x * tmpvar_37.y) * tmpvar_50));
  highp vec2 tmpvar_51;
  tmpvar_51.x = fetchesOffsetsU_17.y;
  tmpvar_51.y = fetchesOffsetsV_16.y;
  highp vec3 tmpvar_52;
  tmpvar_52.xy = (tmpvar_38 + tmpvar_51);
  tmpvar_52.z = shadowCoord_14.z;
  highp vec4 tmpvar_53;
  tmpvar_53 = texture2D (TEXTURE_SHADOW_DEPTH, tmpvar_52.xy);
  highp float tmpvar_54;
  if ((tmpvar_53.x < shadowCoord_14.z)) {
    tmpvar_54 = 0.0;
  } else {
    tmpvar_54 = 1.0;
  };
  shadow_18 = (shadow_18 + ((tmpvar_36.y * tmpvar_37.y) * tmpvar_54));
  highp vec3 tmpvar_55;
  highp vec3 lightDir_56;
  highp vec3 tmpvar_57;
  tmpvar_57 = (LIGHT_POSITION - tmpvar_13);
  highp float tmpvar_58;
  tmpvar_58 = clamp ((sqrt(
    dot (tmpvar_57, tmpvar_57)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  lightDir_56 = normalize(tmpvar_57);
  tmpvar_55 = normalize((CAMERA_WORLDPOSITION - tmpvar_13));
  highp float tmpvar_59;
  mediump float diffuseTerm_60;
  highp float perceptualRoughness_61;
  mediump vec3 tmpvar_62;
  mediump vec3 albedo_63;
  albedo_63 = tmpvar_3;
  mediump vec3 specColor_64;
  specColor_64 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_63 * tmpvar_4));
  tmpvar_62 = (albedo_63 * (0.7790837 - (tmpvar_4 * 0.7790837)));
  tmpvar_59 = 0.0;
  mediump float alpha_65;
  alpha_65 = tmpvar_59;
  tmpvar_59 = alpha_65;
  mediump float tmpvar_66;
  tmpvar_66 = (1.0 - tmpvar_5);
  perceptualRoughness_61 = tmpvar_66;
  highp vec3 tmpvar_67;
  highp vec3 inVec_68;
  inVec_68 = (lightDir_56 + tmpvar_55);
  tmpvar_67 = (inVec_68 * inversesqrt(max (0.001, 
    dot (inVec_68, inVec_68)
  )));
  highp float tmpvar_69;
  tmpvar_69 = abs(dot (tmpvar_55, normalWorld_6));
  highp float tmpvar_70;
  tmpvar_70 = clamp (dot (normalWorld_6, lightDir_56), 0.0, 1.0);
  highp float tmpvar_71;
  tmpvar_71 = clamp (dot (normalWorld_6, tmpvar_67), 0.0, 1.0);
  mediump float tmpvar_72;
  highp float tmpvar_73;
  tmpvar_73 = clamp (dot (lightDir_56, tmpvar_67), 0.0, 1.0);
  tmpvar_72 = tmpvar_73;
  mediump float tmpvar_74;
  mediump float NdotV_75;
  NdotV_75 = tmpvar_69;
  mediump float NdotL_76;
  NdotL_76 = tmpvar_70;
  mediump float perceptualRoughness_77;
  perceptualRoughness_77 = perceptualRoughness_61;
  mediump float tmpvar_78;
  tmpvar_78 = (0.5 + ((2.0 * tmpvar_72) * (tmpvar_72 * perceptualRoughness_77)));
  mediump float x_79;
  x_79 = (1.0 - NdotL_76);
  mediump float x_80;
  x_80 = (1.0 - NdotV_75);
  tmpvar_74 = ((1.0 + (
    (tmpvar_78 - 1.0)
   * 
    ((x_79 * x_79) * ((x_79 * x_79) * x_79))
  )) * (1.0 + (
    (tmpvar_78 - 1.0)
   * 
    ((x_80 * x_80) * ((x_80 * x_80) * x_80))
  )));
  highp float tmpvar_81;
  tmpvar_81 = (tmpvar_74 * tmpvar_70);
  diffuseTerm_60 = tmpvar_81;
  highp float tmpvar_82;
  tmpvar_82 = max ((perceptualRoughness_61 * perceptualRoughness_61), 0.002);
  highp float tmpvar_83;
  tmpvar_83 = (tmpvar_82 * tmpvar_82);
  highp float tmpvar_84;
  tmpvar_84 = (((
    (tmpvar_71 * tmpvar_83)
   - tmpvar_71) * tmpvar_71) + 1.0);
  mediump vec3 tmpvar_85;
  mediump float x_86;
  x_86 = (1.0 - tmpvar_72);
  tmpvar_85 = (specColor_64 + ((1.0 - specColor_64) * (
    (x_86 * x_86)
   * 
    ((x_86 * x_86) * x_86)
  )));
  outColor_2.xyz = (((
    (tmpvar_62 * LIGHT_COLOR)
   * diffuseTerm_60) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_83)
       / 
        ((tmpvar_84 * tmpvar_84) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_70 * (
          (tmpvar_69 * (1.0 - tmpvar_82))
         + tmpvar_82)) + (tmpvar_69 * (
          (tmpvar_70 * (1.0 - tmpvar_82))
         + tmpvar_82))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_70)) * LIGHT_COLOR)
   * tmpvar_85)) * ((
    ((1.0 - tmpvar_58) / ((LIGHT_ATTENUATION.x + (tmpvar_58 * LIGHT_ATTENUATION.y)) + ((tmpvar_58 * tmpvar_58) * LIGHT_ATTENUATION.z)))
   * 
    clamp ((1.0 - ((LIGHT_INNER_DIFF_INV.x - 
      dot (lightDir_56, -(LIGHT_GIVEN_DIRECTION))
    ) * LIGHT_INNER_DIFF_INV.y)), 0.0, 1.0)
  ) * mix (1.0, shadow_18, LIGHT_PARAM.y)));
  lowp vec4 tmpvar_87;
  tmpvar_87 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_87;
  outColor_2.w = ((col_9.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"PointLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_9[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_9[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_3 = col_8.xyz;
  tmpvar_4 = (mg_7.x * _Metallic);
  tmpvar_5 = (mg_7.y * _Smoothness);
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  highp vec3 tmpvar_15;
  highp vec3 tmpvar_16;
  tmpvar_16 = (LIGHT_POSITION - tmpvar_12);
  highp float tmpvar_17;
  tmpvar_17 = clamp ((sqrt(
    dot (tmpvar_16, tmpvar_16)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  tmpvar_15 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  tmpvar_13 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  tmpvar_14 = normalize(tmpvar_16);
  highp float tmpvar_18;
  mediump float diffuseTerm_19;
  highp float perceptualRoughness_20;
  mediump vec3 tmpvar_21;
  mediump vec3 albedo_22;
  albedo_22 = tmpvar_3;
  mediump vec3 specColor_23;
  specColor_23 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_22 * tmpvar_4));
  tmpvar_21 = (albedo_22 * (0.7790837 - (tmpvar_4 * 0.7790837)));
  tmpvar_18 = 0.0;
  mediump float alpha_24;
  alpha_24 = tmpvar_18;
  tmpvar_18 = alpha_24;
  mediump float tmpvar_25;
  tmpvar_25 = (1.0 - tmpvar_5);
  perceptualRoughness_20 = tmpvar_25;
  highp vec3 tmpvar_26;
  highp vec3 inVec_27;
  inVec_27 = (tmpvar_14 + tmpvar_13);
  tmpvar_26 = (inVec_27 * inversesqrt(max (0.001, 
    dot (inVec_27, inVec_27)
  )));
  highp float tmpvar_28;
  tmpvar_28 = abs(dot (tmpvar_13, tmpvar_15));
  highp float tmpvar_29;
  tmpvar_29 = clamp (dot (tmpvar_15, tmpvar_14), 0.0, 1.0);
  highp float tmpvar_30;
  tmpvar_30 = clamp (dot (tmpvar_15, tmpvar_26), 0.0, 1.0);
  mediump float tmpvar_31;
  highp float tmpvar_32;
  tmpvar_32 = clamp (dot (tmpvar_14, tmpvar_26), 0.0, 1.0);
  tmpvar_31 = tmpvar_32;
  mediump float tmpvar_33;
  mediump float NdotV_34;
  NdotV_34 = tmpvar_28;
  mediump float NdotL_35;
  NdotL_35 = tmpvar_29;
  mediump float perceptualRoughness_36;
  perceptualRoughness_36 = perceptualRoughness_20;
  mediump float tmpvar_37;
  tmpvar_37 = (0.5 + ((2.0 * tmpvar_31) * (tmpvar_31 * perceptualRoughness_36)));
  mediump float x_38;
  x_38 = (1.0 - NdotL_35);
  mediump float x_39;
  x_39 = (1.0 - NdotV_34);
  tmpvar_33 = ((1.0 + (
    (tmpvar_37 - 1.0)
   * 
    ((x_38 * x_38) * ((x_38 * x_38) * x_38))
  )) * (1.0 + (
    (tmpvar_37 - 1.0)
   * 
    ((x_39 * x_39) * ((x_39 * x_39) * x_39))
  )));
  highp float tmpvar_40;
  tmpvar_40 = (tmpvar_33 * tmpvar_29);
  diffuseTerm_19 = tmpvar_40;
  highp float tmpvar_41;
  tmpvar_41 = max ((perceptualRoughness_20 * perceptualRoughness_20), 0.002);
  highp float tmpvar_42;
  tmpvar_42 = (tmpvar_41 * tmpvar_41);
  highp float tmpvar_43;
  tmpvar_43 = (((
    (tmpvar_30 * tmpvar_42)
   - tmpvar_30) * tmpvar_30) + 1.0);
  mediump vec3 tmpvar_44;
  mediump float x_45;
  x_45 = (1.0 - tmpvar_31);
  tmpvar_44 = (specColor_23 + ((1.0 - specColor_23) * (
    (x_45 * x_45)
   * 
    ((x_45 * x_45) * x_45)
  )));
  outColor_2.xyz = (((
    (tmpvar_21 * LIGHT_COLOR)
   * diffuseTerm_19) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_42)
       / 
        ((tmpvar_43 * tmpvar_43) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_29 * (
          (tmpvar_28 * (1.0 - tmpvar_41))
         + tmpvar_41)) + (tmpvar_28 * (
          (tmpvar_29 * (1.0 - tmpvar_41))
         + tmpvar_41))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_29)) * LIGHT_COLOR)
   * tmpvar_44)) * ((1.0 - tmpvar_17) / (
    (LIGHT_ATTENUATION.x + (tmpvar_17 * LIGHT_ATTENUATION.y))
   + 
    ((tmpvar_17 * tmpvar_17) * LIGHT_ATTENUATION.z)
  )));
  lowp vec4 tmpvar_46;
  tmpvar_46 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_46;
  outColor_2.w = ((col_8.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"PointLight","ShadowOn"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_RANGE_INV",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_ATTENUATION",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_COLOR",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MetallicGlossMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BumpMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Smoothness",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Metallic",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec3 _glesBinormal;
attribute highp vec3 _glesTangent;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  highp vec3 tmpvar_8;
  tmpvar_8 = (LOCALWORLD_TRANSFORM * tmpvar_7).xyz;
  highp mat3 tmpvar_9;
  tmpvar_9[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_9[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_9[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_2.xyz = normalize((tmpvar_9 * _glesNormal));
  highp mat3 tmpvar_10;
  tmpvar_10[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_10[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_10[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_3.xyz = normalize((tmpvar_10 * _glesTangent));
  highp mat3 tmpvar_11;
  tmpvar_11[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_11[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_11[2] = LOCALWORLD_TRANSFORM[2].xyz;
  tmpvar_4.xyz = normalize((tmpvar_11 * _glesBinormal));
  tmpvar_2.w = tmpvar_8.x;
  tmpvar_3.w = tmpvar_8.y;
  tmpvar_4.w = tmpvar_8.z;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = tmpvar_4;
  gl_Position = (tmpvar_6 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_5)));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
uniform highp vec3 LIGHT_COLOR;
uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform sampler2D _MetallicGlossMap;
uniform sampler2D _BumpMap;
uniform highp float _Smoothness;
uniform highp float _Metallic;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
void main ()
{
  highp vec4 maskCol_1;
  highp vec4 outColor_2;
  highp vec3 tmpvar_3;
  mediump float tmpvar_4;
  mediump float tmpvar_5;
  highp vec3 normalTangent_6;
  highp vec2 mg_7;
  highp vec4 col_8;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_MainTex, xlv_TEXCOORD0);
  col_8 = tmpvar_9;
  lowp vec2 tmpvar_10;
  tmpvar_10 = texture2D (_MetallicGlossMap, xlv_TEXCOORD0).xw;
  mg_7 = tmpvar_10;
  lowp vec3 tmpvar_11;
  tmpvar_11 = texture2D (_BumpMap, xlv_TEXCOORD0).xyz;
  normalTangent_6 = tmpvar_11;
  normalTangent_6 = ((normalTangent_6 * 2.0) - 1.0);
  tmpvar_3 = col_8.xyz;
  tmpvar_4 = (mg_7.x * _Metallic);
  tmpvar_5 = (mg_7.y * _Smoothness);
  highp vec3 tmpvar_12;
  tmpvar_12.x = xlv_TEXCOORD1.w;
  tmpvar_12.y = xlv_TEXCOORD2.w;
  tmpvar_12.z = xlv_TEXCOORD3.w;
  highp vec3 tmpvar_13;
  highp vec3 tmpvar_14;
  highp vec3 tmpvar_15;
  highp vec3 tmpvar_16;
  tmpvar_16 = (LIGHT_POSITION - tmpvar_12);
  highp float tmpvar_17;
  tmpvar_17 = clamp ((sqrt(
    dot (tmpvar_16, tmpvar_16)
  ) * LIGHT_RANGE_INV), 0.0, 1.0);
  tmpvar_15 = normalize(((
    (normalTangent_6.x * xlv_TEXCOORD2.xyz)
   + 
    (normalTangent_6.y * xlv_TEXCOORD3.xyz)
  ) + (normalTangent_6.z * xlv_TEXCOORD1.xyz)));
  tmpvar_13 = normalize((CAMERA_WORLDPOSITION - tmpvar_12));
  tmpvar_14 = normalize(tmpvar_16);
  highp float tmpvar_18;
  mediump float diffuseTerm_19;
  highp float perceptualRoughness_20;
  mediump vec3 tmpvar_21;
  mediump vec3 albedo_22;
  albedo_22 = tmpvar_3;
  mediump vec3 specColor_23;
  specColor_23 = ((vec3(0.2209163, 0.2209163, 0.2209163) * (1.0 - tmpvar_4)) + (albedo_22 * tmpvar_4));
  tmpvar_21 = (albedo_22 * (0.7790837 - (tmpvar_4 * 0.7790837)));
  tmpvar_18 = 0.0;
  mediump float alpha_24;
  alpha_24 = tmpvar_18;
  tmpvar_18 = alpha_24;
  mediump float tmpvar_25;
  tmpvar_25 = (1.0 - tmpvar_5);
  perceptualRoughness_20 = tmpvar_25;
  highp vec3 tmpvar_26;
  highp vec3 inVec_27;
  inVec_27 = (tmpvar_14 + tmpvar_13);
  tmpvar_26 = (inVec_27 * inversesqrt(max (0.001, 
    dot (inVec_27, inVec_27)
  )));
  highp float tmpvar_28;
  tmpvar_28 = abs(dot (tmpvar_13, tmpvar_15));
  highp float tmpvar_29;
  tmpvar_29 = clamp (dot (tmpvar_15, tmpvar_14), 0.0, 1.0);
  highp float tmpvar_30;
  tmpvar_30 = clamp (dot (tmpvar_15, tmpvar_26), 0.0, 1.0);
  mediump float tmpvar_31;
  highp float tmpvar_32;
  tmpvar_32 = clamp (dot (tmpvar_14, tmpvar_26), 0.0, 1.0);
  tmpvar_31 = tmpvar_32;
  mediump float tmpvar_33;
  mediump float NdotV_34;
  NdotV_34 = tmpvar_28;
  mediump float NdotL_35;
  NdotL_35 = tmpvar_29;
  mediump float perceptualRoughness_36;
  perceptualRoughness_36 = perceptualRoughness_20;
  mediump float tmpvar_37;
  tmpvar_37 = (0.5 + ((2.0 * tmpvar_31) * (tmpvar_31 * perceptualRoughness_36)));
  mediump float x_38;
  x_38 = (1.0 - NdotL_35);
  mediump float x_39;
  x_39 = (1.0 - NdotV_34);
  tmpvar_33 = ((1.0 + (
    (tmpvar_37 - 1.0)
   * 
    ((x_38 * x_38) * ((x_38 * x_38) * x_38))
  )) * (1.0 + (
    (tmpvar_37 - 1.0)
   * 
    ((x_39 * x_39) * ((x_39 * x_39) * x_39))
  )));
  highp float tmpvar_40;
  tmpvar_40 = (tmpvar_33 * tmpvar_29);
  diffuseTerm_19 = tmpvar_40;
  highp float tmpvar_41;
  tmpvar_41 = max ((perceptualRoughness_20 * perceptualRoughness_20), 0.002);
  highp float tmpvar_42;
  tmpvar_42 = (tmpvar_41 * tmpvar_41);
  highp float tmpvar_43;
  tmpvar_43 = (((
    (tmpvar_30 * tmpvar_42)
   - tmpvar_30) * tmpvar_30) + 1.0);
  mediump vec3 tmpvar_44;
  mediump float x_45;
  x_45 = (1.0 - tmpvar_31);
  tmpvar_44 = (specColor_23 + ((1.0 - specColor_23) * (
    (x_45 * x_45)
   * 
    ((x_45 * x_45) * x_45)
  )));
  outColor_2.xyz = (((
    (tmpvar_21 * LIGHT_COLOR)
   * diffuseTerm_19) + (
    (max (0.0, (sqrt(
      max (0.0001, (((
        (0.3183099 * tmpvar_42)
       / 
        ((tmpvar_43 * tmpvar_43) + 1e-7)
      ) * (0.5 / 
        (((tmpvar_29 * (
          (tmpvar_28 * (1.0 - tmpvar_41))
         + tmpvar_41)) + (tmpvar_28 * (
          (tmpvar_29 * (1.0 - tmpvar_41))
         + tmpvar_41))) + 0.0001)
      )) * 3.141593))
    ) * tmpvar_29)) * LIGHT_COLOR)
   * tmpvar_44)) * ((1.0 - tmpvar_17) / (
    (LIGHT_ATTENUATION.x + (tmpvar_17 * LIGHT_ATTENUATION.y))
   + 
    ((tmpvar_17 * tmpvar_17) * LIGHT_ATTENUATION.z)
  )));
  lowp vec4 tmpvar_46;
  tmpvar_46 = texture2D (_MaskTex, xlv_TEXCOORD0);
  maskCol_1 = tmpvar_46;
  outColor_2.w = ((col_8.w * maskCol_1.w) * _Opacity);
  gl_FragData[0] = outColor_2;
}

]===],
	},
}


end

function Depth()

	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { DEPTHPASS }

	
Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			},
		vsShader = [===[attribute vec4 _glesVertex;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 LIGHT_PARAM;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
void main ()
{
  highp vec4 row2_1;
  highp vec4 row1_2;
  highp vec4 row0_3;
  highp int tmpvar_4;
  tmpvar_4 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.w) * 3);
  row0_3 = (ANIMATION_MATRIX_ARRAY[tmpvar_4] * _glesBlendWeight.x);
  row1_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 1)] * _glesBlendWeight.x);
  row2_1 = (ANIMATION_MATRIX_ARRAY[(tmpvar_4 + 2)] * _glesBlendWeight.x);
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.y));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.y));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.y));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.z));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.z));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.z));
  row0_3 = (row0_3 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.w));
  row1_2 = (row1_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.w));
  row2_1 = (row2_1 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_8;
  tmpvar_8[0].x = row0_3.x;
  tmpvar_8[0].y = row0_3.y;
  tmpvar_8[0].z = row0_3.z;
  tmpvar_8[0].w = row0_3.w;
  tmpvar_8[1].x = row1_2.x;
  tmpvar_8[1].y = row1_2.y;
  tmpvar_8[1].z = row1_2.z;
  tmpvar_8[1].w = row1_2.w;
  tmpvar_8[2].x = row2_1.x;
  tmpvar_8[2].y = row2_1.y;
  tmpvar_8[2].z = row2_1.z;
  tmpvar_8[2].w = row2_1.w;
  tmpvar_8[3].x = 0.0;
  tmpvar_8[3].y = 0.0;
  tmpvar_8[3].z = 0.0;
  tmpvar_8[3].w = 1.0;
  highp vec4 tmpvar_9;
  tmpvar_9 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_8)));
  highp vec4 clipPos_10;
  clipPos_10.xyw = tmpvar_9.xyw;
  clipPos_10.z = (tmpvar_9.z + (LIGHT_PARAM.x / tmpvar_9.w));
  highp vec4 tmpvar_11;
  tmpvar_11.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_11.y = DEVICE_COORDINATE_Y_FLIP;
  gl_Position = (tmpvar_11 * clipPos_10);
}

]===],
		psShader = [===[void main ()
{
  gl_FragData[0] = vec4(0.0, 0.0, 0.0, 1.0);
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LIGHT_PARAM",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			},
		vsShader = [===[attribute vec4 _glesVertex;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 LIGHT_PARAM;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = _glesVertex.xyz;
  tmpvar_1 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2));
  highp vec4 clipPos_3;
  clipPos_3.xyw = tmpvar_1.xyw;
  clipPos_3.z = (tmpvar_1.z + (LIGHT_PARAM.x / tmpvar_1.w));
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  gl_Position = (tmpvar_4 * clipPos_3);
}

]===],
		psShader = [===[void main ()
{
  gl_FragData[0] = vec4(0.0, 0.0, 0.0, 1.0);
}

]===],
	},
}

end
