

function DefineParams()
	Properties = 
	{
		
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "maintex" },
BOLD = {"bold", FLOATRANGE, "0.0, 0.3, -0.3"},
OUTLINE = {"outline", FLOAT, "0.0"},
TEXTCOLOR = {"Text Color", COLOR, "0.0, 0.0, 0.0, 1.0"},
OUTLINECOLOR = {"Outline Color", COLOR, "0.0, 0.0, 0.0, 1.0"},

HALO = {"halo", FLOAT, "1.0"},

	}
	Attributes = 
	{
		HALO = "Keywords(HALO_ON,HALO_OFF)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "sdf_realtime"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"HALO_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_HALF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BOLD",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OUTLINE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTCOLOR",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OUTLINECOLOR",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp vec3 WORLD_POSITION;
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.zw = vec2(0.0, 1.0);
  tmpvar_1.xy = (((_glesVertex.xy * 
    (vec4(1.0, 1.0, 1.0, 1.0) * LOCALWORLD_TRANSFORM)
  .xy) * CAMERA_RESOLUTION_INV) + (WORLD_POSITION.xy * CAMERA_RESOLUTION_HALF_INV));
  highp vec4 tmpvar_2;
  tmpvar_2.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_2.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_2 * tmpvar_1);
}

]===],
		psShader = [===[#extension GL_OES_standard_derivatives : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float BOLD;
uniform highp float OUTLINE;
uniform highp vec4 TEXTCOLOR;
uniform highp vec4 OUTLINECOLOR;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp float xlat_vardistance_1;
  highp vec4 dist_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  dist_2 = tmpvar_3;
  highp float tmpvar_4;
  tmpvar_4 = dFdx(xlv_TEXCOORD0.x);
  highp float tmpvar_5;
  tmpvar_5 = dFdy(xlv_TEXCOORD0.y);
  highp float tmpvar_6;
  tmpvar_6 = sqrt(((tmpvar_4 * tmpvar_4) + (tmpvar_5 * tmpvar_5)));
  highp float tmpvar_7;
  tmpvar_7 = mix (dot (dist_2.zw, vec2(0.00390625, 1.0)), dot (dist_2.xy, vec2(0.00390625, 1.0)), tmpvar_6);
  highp float tmpvar_8;
  tmpvar_8 = (16.384 * tmpvar_6);
  highp float tmpvar_9;
  highp float edge0_10;
  highp float tmpvar_11;
  tmpvar_11 = (0.5 + BOLD);
  edge0_10 = (tmpvar_11 - tmpvar_8);
  highp float tmpvar_12;
  tmpvar_12 = clamp (((tmpvar_7 - edge0_10) / (
    (tmpvar_11 + tmpvar_8)
   - edge0_10)), 0.0, 1.0);
  highp float edge0_13;
  highp float tmpvar_14;
  tmpvar_14 = (0.5 - BOLD);
  edge0_13 = (tmpvar_14 - tmpvar_8);
  highp float tmpvar_15;
  tmpvar_15 = clamp (((tmpvar_7 - edge0_13) / (
    (tmpvar_14 + tmpvar_8)
   - edge0_13)), 0.0, 1.0);
  tmpvar_9 = ((tmpvar_15 * (tmpvar_15 * 
    (3.0 - (2.0 * tmpvar_15))
  )) - (tmpvar_12 * (tmpvar_12 * 
    (3.0 - (2.0 * tmpvar_12))
  )));
  xlat_vardistance_1 = (((tmpvar_7 - 0.5) * (2.0 - 
    (OUTLINE * 10.0)
  )) + 0.5);
  highp float tmpvar_16;
  tmpvar_16 = clamp (xlat_vardistance_1, 0.0, 1.0);
  xlat_vardistance_1 = tmpvar_16;
  highp vec4 tmpvar_17;
  tmpvar_17 = ((TEXTCOLOR * tmpvar_9) + (OUTLINECOLOR * clamp (
    ((1.0 - abs((
      (tmpvar_16 * 2.0)
     - 1.0))) - tmpvar_9)
  , 0.0, 1.0)));
  gl_FragData[0] = tmpvar_17;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"HALO_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_RESOLUTION_HALF_INV",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BOLD",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OUTLINE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTCOLOR",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OUTLINECOLOR",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp vec3 WORLD_POSITION;
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.zw = vec2(0.0, 1.0);
  tmpvar_1.xy = (((_glesVertex.xy * 
    (vec4(1.0, 1.0, 1.0, 1.0) * LOCALWORLD_TRANSFORM)
  .xy) * CAMERA_RESOLUTION_INV) + (WORLD_POSITION.xy * CAMERA_RESOLUTION_HALF_INV));
  highp vec4 tmpvar_2;
  tmpvar_2.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_2.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_2 * tmpvar_1);
}

]===],
		psShader = [===[#extension GL_OES_standard_derivatives : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float BOLD;
uniform highp float OUTLINE;
uniform highp vec4 TEXTCOLOR;
uniform highp vec4 OUTLINECOLOR;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 dist_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  dist_1 = tmpvar_2;
  highp float tmpvar_3;
  tmpvar_3 = dFdx(xlv_TEXCOORD0.x);
  highp float tmpvar_4;
  tmpvar_4 = dFdy(xlv_TEXCOORD0.y);
  highp float tmpvar_5;
  tmpvar_5 = sqrt(((tmpvar_3 * tmpvar_3) + (tmpvar_4 * tmpvar_4)));
  highp float tmpvar_6;
  tmpvar_6 = mix (dot (dist_1.zw, vec2(0.00390625, 1.0)), dot (dist_1.xy, vec2(0.00390625, 1.0)), tmpvar_5);
  highp float tmpvar_7;
  tmpvar_7 = (16.384 * tmpvar_5);
  highp float tmpvar_8;
  tmpvar_8 = clamp ((0.5 - BOLD), tmpvar_7, (1.0 - tmpvar_7));
  highp float tmpvar_9;
  tmpvar_9 = clamp ((tmpvar_8 - OUTLINE), tmpvar_7, (1.0 - tmpvar_7));
  highp float tmpvar_10;
  highp float edge0_11;
  edge0_11 = (tmpvar_8 - tmpvar_7);
  highp float tmpvar_12;
  tmpvar_12 = clamp (((tmpvar_6 - edge0_11) / (
    (tmpvar_8 + tmpvar_7)
   - edge0_11)), 0.0, 1.0);
  tmpvar_10 = (tmpvar_12 * (tmpvar_12 * (3.0 - 
    (2.0 * tmpvar_12)
  )));
  highp float edge0_13;
  edge0_13 = (tmpvar_9 - tmpvar_7);
  highp float tmpvar_14;
  tmpvar_14 = clamp (((tmpvar_6 - edge0_13) / (
    (tmpvar_9 + tmpvar_7)
   - edge0_13)), 0.0, 1.0);
  highp vec4 tmpvar_15;
  tmpvar_15 = ((TEXTCOLOR * tmpvar_10) + (OUTLINECOLOR * (
    (tmpvar_14 * (tmpvar_14 * (3.0 - (2.0 * tmpvar_14))))
   - tmpvar_10)));
  gl_FragData[0] = tmpvar_15;
}

]===],
	},
}

end
