
function DefineParams()
	Properties = 
	{
		
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "maintex" },
FBO_SIZE = {"FBO Size", VEC2, "2048, 2048"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "sdf_blur"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, ONE, ZERO, ONE, ZERO }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			},
		psBufferSize = "0",
		psUniforms = {
			},
		vsShader = [===[#define gl_Vertex _glesVertex
#define gl_Color _glesColor
#define gl_Normal _glesNormal
#define TANGENT _glesTangent
#define BINORMAL _glesBinormal
#define BLENDWEIGHT _glesBlendWeight
#define BLENDINDICES _glesBlendIndices
#define gl_MultiTexCoord0 _glesMultiTexCoord0
#define gl_MultiTexCoord1 _glesMultiTexCoord1
#define gl_MultiTexCoord2 _glesMultiTexCoord2
#define gl_MultiTexCoord3 _glesMultiTexCoord3
#define gl_MultiTexCoord4 _glesMultiTexCoord4
#define gl_MultiTexCoord5 _glesMultiTexCoord5
#define gl_MultiTexCoord6 _glesMultiTexCoord6
#define gl_MultiTexCoord7 _glesMultiTexCoord7
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;

#line 15
struct v2f {
    highp vec2 uv;
    highp vec4 vertex;
};
#line 9
struct appdata {
    highp vec4 vertex;
    highp vec2 uv;
};
#line 5
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
#line 9
uniform highp mat4 CAMERA_PROJECTION;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
#line 13
uniform highp vec3 LIGHT_POSITION;
uniform highp vec3 WORLD_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
#line 17
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
#line 21
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp vec2 CAMERA_RESOLUTION;
#line 25
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform sampler2D TEXTURE_GRAP;
#line 32
uniform highp float DEVICE_COORDINATE_Y_FLIP;
#line 86
#line 92
#line 97
#line 102
#line 107
#line 112
#line 117
#line 124
#line 129
#line 144
#line 21
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec2 FBO_SIZE;
#line 40
#line 44
#line 50
#line 144
highp vec4 UniformNDC( in highp vec4 vertex ) {
    highp vec4 scale = vec4( 1.0, DEVICE_COORDINATE_Y_FLIP, 1.0, 1.0);
    #line 152
    highp vec4 newVertex = (scale * vertex);
    #line 161
    return newVertex;
}
#line 24
v2f vert( in appdata v ) {
    #line 26
    v2f o;
    highp vec4 pos = (v.vertex * (1.0 / v.vertex.w));
    pos = (LOCALWORLD_TRANSFORM * pos);
    pos.w = 1.0;
    #line 30
    pos.x = (pos.x + WORLD_POSITION.x);
    pos.y = (pos.y + WORLD_POSITION.y);
    o.vertex = pos;
    o.vertex = UniformNDC( o.vertex);
    #line 35
    o.uv = v.uv.xy;
    return o;
}
out highp vec2 xlv_TEXCOORD0;
void main() {
    v2f xl_retval;
    appdata xlt_v;
    xlt_v.vertex = vec4(gl_Vertex);
    xlt_v.uv = vec2(gl_MultiTexCoord0);
    xl_retval = vert( xlt_v);
    xlv_TEXCOORD0 = vec2(xl_retval.uv);
    gl_Position = vec4(xl_retval.vertex);
}
]===],
		psShader = [===[#define gl_FragData _glesFragData
layout(location = 0) out mediump vec4 gl_FragData[1];
#line 15
struct v2f {
    highp vec2 uv;
    highp vec4 vertex;
};
#line 9
struct appdata {
    highp vec4 vertex;
    highp vec2 uv;
};
#line 5
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
#line 9
uniform highp mat4 CAMERA_PROJECTION;
uniform highp mat4 LOCALSCREEN_TRANSVIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp vec3 LIGHT_GIVEN_DIRECTION;
#line 13
uniform highp vec3 LIGHT_POSITION;
uniform highp vec3 WORLD_POSITION;
uniform highp float LIGHT_RANGE_INV;
uniform highp vec4 LIGHT_ATTENUATION;
#line 17
uniform highp vec3 LIGHT_COLOR;
uniform highp vec3 AMBIENT_COLOR;
uniform highp vec2 LIGHT_INNER_DIFF_INV;
uniform highp vec4 LIGHT_PARAM;
#line 21
uniform highp mat4 LIGHT_CAMERA_VIEW;
uniform highp mat4 LIGHT_CAMERA_PROJECTION;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp vec2 CAMERA_RESOLUTION;
#line 25
uniform highp vec2 CAMERA_RESOLUTION_INV;
uniform highp vec2 CAMERA_RESOLUTION_HALF_INV;
uniform highp vec3 CAMERA_SHADOWRANGE;
uniform sampler2D TEXTURE_GRAP;
#line 32
uniform highp float DEVICE_COORDINATE_Y_FLIP;
#line 86
#line 92
#line 97
#line 102
#line 107
#line 112
#line 117
#line 124
#line 129
#line 144
#line 21
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec2 FBO_SIZE;
#line 40
#line 44
#line 50
#line 44
highp vec2 pack16( in highp float value ) {
    highp vec2 comp = fract((value * vec2( 256.0, 1.0)));
    comp -= (comp.xx * vec2( 0.0, 0.00390625));
    return comp;
}
#line 40
highp float unpack16( in highp vec2 color ) {
    return dot( color, vec2( 0.00390625, 1.0));
}
#line 50
highp vec4 frag( in v2f i ) {
    highp float offsetx = (1.0 / FBO_SIZE.x);
    highp float offsety = (1.0 / FBO_SIZE.y);
    #line 55
    highp float x0 = ((i.uv.x - offsetx) - offsetx);
    highp float x1 = (x0 + offsetx);
    highp float x2 = (x1 + offsetx);
    highp float x3 = (x2 + offsetx);
    #line 59
    highp float x4 = (x3 + offsetx);
    highp float y0 = ((i.uv.y - offsety) - offsety);
    highp float y1 = (y0 + offsety);
    #line 63
    highp float y2 = (y1 + offsety);
    highp float y3 = (y2 + offsety);
    highp float y4 = (y3 + offsety);
    #line 67
    highp float xlat_vardistance = 0.0;
    highp vec2 dist = texture( TEXTURE_DIFFUSE, vec2( x2, y2)).xy;
    xlat_vardistance += unpack16( texture( TEXTURE_DIFFUSE, vec2( x0, y0)).xy);
    #line 71
    xlat_vardistance += unpack16( texture( TEXTURE_DIFFUSE, vec2( x1, y0)).xy);
    xlat_vardistance += unpack16( texture( TEXTURE_DIFFUSE, vec2( x2, y0)).xy);
    xlat_vardistance += unpack16( texture( TEXTURE_DIFFUSE, vec2( x3, y0)).xy);
    xlat_vardistance += unpack16( texture( TEXTURE_DIFFUSE, vec2( x4, y0)).xy);
    #line 76
    xlat_vardistance += unpack16( texture( TEXTURE_DIFFUSE, vec2( x0, y1)).xy);
    xlat_vardistance += unpack16( texture( TEXTURE_DIFFUSE, vec2( x1, y1)).xy);
    xlat_vardistance += unpack16( texture( TEXTURE_DIFFUSE, vec2( x2, y1)).xy);
    xlat_vardistance += unpack16( texture( TEXTURE_DIFFUSE, vec2( x3, y1)).xy);
    #line 80
    xlat_vardistance += unpack16( texture( TEXTURE_DIFFUSE, vec2( x4, y1)).xy);
    xlat_vardistance += unpack16( texture( TEXTURE_DIFFUSE, vec2( x0, y2)).xy);
    xlat_vardistance += unpack16( texture( TEXTURE_DIFFUSE, vec2( x1, y2)).xy);
    #line 84
    xlat_vardistance += unpack16( dist);
    xlat_vardistance += unpack16( texture( TEXTURE_DIFFUSE, vec2( x3, y2)).xy);
    xlat_vardistance += unpack16( texture( TEXTURE_DIFFUSE, vec2( x4, y2)).xy);
    #line 88
    xlat_vardistance += unpack16( texture( TEXTURE_DIFFUSE, vec2( x0, y3)).xy);
    xlat_vardistance += unpack16( texture( TEXTURE_DIFFUSE, vec2( x1, y3)).xy);
    xlat_vardistance += unpack16( texture( TEXTURE_DIFFUSE, vec2( x2, y3)).xy);
    xlat_vardistance += unpack16( texture( TEXTURE_DIFFUSE, vec2( x3, y3)).xy);
    #line 92
    xlat_vardistance += unpack16( texture( TEXTURE_DIFFUSE, vec2( x4, y3)).xy);
    xlat_vardistance += unpack16( texture( TEXTURE_DIFFUSE, vec2( x0, y4)).xy);
    xlat_vardistance += unpack16( texture( TEXTURE_DIFFUSE, vec2( x1, y4)).xy);
    #line 96
    xlat_vardistance += unpack16( texture( TEXTURE_DIFFUSE, vec2( x2, y4)).xy);
    xlat_vardistance += unpack16( texture( TEXTURE_DIFFUSE, vec2( x3, y4)).xy);
    xlat_vardistance += unpack16( texture( TEXTURE_DIFFUSE, vec2( x4, y4)).xy);
    #line 100
    xlat_vardistance = (xlat_vardistance / 25.0);
    return vec4( dist, pack16( xlat_vardistance));
}
in highp vec2 xlv_TEXCOORD0;
void main() {
    highp vec4 xl_retval;
    v2f xlt_i;
    xlt_i.uv = vec2(xlv_TEXCOORD0);
    xlt_i.vertex = vec4(0.0);
    xl_retval = frag( xlt_i);
    gl_FragData[0] = vec4(xl_retval);
}
]===],
	},
}

end
