

function DefineParams()
	Properties = 
	{
		
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "maintex" },
_TexOffset = { "uv offset", VEC2, "0.0, 0.0"},
_TexTilling = { "uv tilling", VEC2, "1.0, 1.0"},
_Alpha = {"alpha", FLOATRANGE, "1.0, 1, 0"},

_BlendMode = {"Blend Mode", FLOAT, "0.0"},

_BlendSrc = {"Blend Src", FLOAT, "4.0"},

_BlendDst = {"Blend Dst", FLOAT, "5.0"},
_Opacity = { "Opacity", FLOATRANGE, "1.0, 1, 0" },
_LutMap = {"Lut Map", TEXTURE2D, "white" },
_DefMode = { "Def Mode", FLOAT, "0.0"},

	}
	Attributes = 
	{
		_BlendMode = "Keywords(BLEND_NORMAL,BLEND_MULTIPLY,BLEND_SCREEN,BLEND_HUE,BLEND_SATURATION,BLEND_LUMINOSITY,BLEND_COLOR,BLEND_BLEND,BLEND_EXCLUSION,BLEND_HARDLIGHT,BLEND_VIVIDLIGHT,BLEND_OVERLAY,BLEND_COLORBURN,BLEND_COLORDODGE,BLEND_SOFTLIGHT,BLEND_HARDMIX,BLEND_PINLIGHT,BLEND_LINEARLIGHT,BLEND_DIFF,BLEND_LINEARBURN,BLEND_SUB,BLEND_LUT,BLEND_ADD)", 
		_BlendSrc = "Enum(BlendFactor)", 
		_BlendDst = "Enum(BlendFactor)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "sdfbackground"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND,  "%_BlendSrc",  "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 resultColor_1;
  highp vec4 blendColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_2 = tmpvar_3;
  highp float tmpvar_4;
  tmpvar_4 = (_Opacity * blendColor_2.w);
  highp vec4 tmpvar_5;
  tmpvar_5.xyz = blendColor_2.xyz;
  tmpvar_5.w = tmpvar_4;
  resultColor_1.xyz = tmpvar_5.xyz;
  resultColor_1.w = (tmpvar_4 * _Alpha);
  gl_FragData[0] = resultColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 blendColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_3 = tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * blendColor_3.w);
  highp vec4 tmpvar_6;
  tmpvar_6.xyz = blendColor_3.xyz;
  tmpvar_6.w = tmpvar_5;
  resultColor_2.xyz = tmpvar_6.xyz;
  resultColor_2.w = (tmpvar_5 * _Alpha);
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_MULTIPLY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 resultColor_1;
  highp vec4 blendColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_2 = tmpvar_3;
  blendColor_2 = (vec4(1.0, 1.0, 1.0, 1.0) - ((_Opacity * blendColor_2.w) * (vec4(1.0, 1.0, 1.0, 1.0) - blendColor_2)));
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = blendColor_2.xyz;
  resultColor_1.xyz = tmpvar_4.xyz;
  resultColor_1.w = _Alpha;
  gl_FragData[0] = resultColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_MULTIPLY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 blendColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_3 = tmpvar_4;
  blendColor_3 = (vec4(1.0, 1.0, 1.0, 1.0) - ((_Opacity * blendColor_3.w) * (vec4(1.0, 1.0, 1.0, 1.0) - blendColor_3)));
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = blendColor_3.xyz;
  resultColor_2.xyz = tmpvar_5.xyz;
  resultColor_2.w = _Alpha;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_SCREEN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 resultColor_1;
  highp vec4 blendColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_2 = tmpvar_3;
  blendColor_2 = ((_Opacity * blendColor_2.w) * blendColor_2);
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = blendColor_2.xyz;
  resultColor_1.xyz = tmpvar_4.xyz;
  resultColor_1.w = _Alpha;
  gl_FragData[0] = resultColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_SCREEN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 blendColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_3 = tmpvar_4;
  blendColor_3 = ((_Opacity * blendColor_3.w) * blendColor_3);
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = blendColor_3.xyz;
  resultColor_2.xyz = tmpvar_5.xyz;
  resultColor_2.w = _Alpha;
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_HUE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 blendColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_4 = tmpvar_5;
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * blendColor_4.w);
  highp vec3 rgb_7;
  rgb_7 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_8;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_9;
    tmpvar_9.zw = vec2(-1.0, 0.6666667);
    tmpvar_9.xy = rgb_7.zy;
    tmpvar_8 = tmpvar_9;
  } else {
    highp vec4 tmpvar_10;
    tmpvar_10.zw = vec2(0.0, -0.3333333);
    tmpvar_10.xy = rgb_7.yz;
    tmpvar_8 = tmpvar_10;
  };
  highp vec4 tmpvar_11;
  if ((xlt_fbColor_1.x < tmpvar_8.x)) {
    highp vec4 tmpvar_12;
    tmpvar_12.xyz = tmpvar_8.xyw;
    tmpvar_12.w = rgb_7.x;
    tmpvar_11 = tmpvar_12;
  } else {
    highp vec4 tmpvar_13;
    tmpvar_13.x = rgb_7.x;
    tmpvar_13.yzw = tmpvar_8.yzx;
    tmpvar_11 = tmpvar_13;
  };
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_11.x - min (tmpvar_11.w, tmpvar_11.y));
  highp vec3 tmpvar_15;
  tmpvar_15.x = abs(((
    (tmpvar_11.w - tmpvar_11.y)
   / 
    ((6.0 * tmpvar_14) + 1e-7)
  ) + tmpvar_11.z));
  tmpvar_15.y = tmpvar_14;
  tmpvar_15.z = tmpvar_11.x;
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_11.x - (tmpvar_14 * 0.5));
  highp vec3 tmpvar_17;
  tmpvar_17.x = tmpvar_15.x;
  tmpvar_17.y = (tmpvar_14 / ((1.0 - 
    abs(((2.0 * tmpvar_16) - 1.0))
  ) + 1e-7));
  tmpvar_17.z = tmpvar_16;
  highp vec3 rgb_18;
  rgb_18 = blendColor_4.xyz;
  highp vec4 tmpvar_19;
  if ((blendColor_4.y < blendColor_4.z)) {
    highp vec4 tmpvar_20;
    tmpvar_20.zw = vec2(-1.0, 0.6666667);
    tmpvar_20.xy = rgb_18.zy;
    tmpvar_19 = tmpvar_20;
  } else {
    highp vec4 tmpvar_21;
    tmpvar_21.zw = vec2(0.0, -0.3333333);
    tmpvar_21.xy = rgb_18.yz;
    tmpvar_19 = tmpvar_21;
  };
  highp vec4 tmpvar_22;
  if ((blendColor_4.x < tmpvar_19.x)) {
    highp vec4 tmpvar_23;
    tmpvar_23.xyz = tmpvar_19.xyw;
    tmpvar_23.w = rgb_18.x;
    tmpvar_22 = tmpvar_23;
  } else {
    highp vec4 tmpvar_24;
    tmpvar_24.x = rgb_18.x;
    tmpvar_24.yzw = tmpvar_19.yzx;
    tmpvar_22 = tmpvar_24;
  };
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_22.x - min (tmpvar_22.w, tmpvar_22.y));
  highp vec3 tmpvar_26;
  tmpvar_26.x = abs(((
    (tmpvar_22.w - tmpvar_22.y)
   / 
    ((6.0 * tmpvar_25) + 1e-7)
  ) + tmpvar_22.z));
  tmpvar_26.y = tmpvar_25;
  tmpvar_26.z = tmpvar_22.x;
  highp vec3 tmpvar_27;
  tmpvar_27.x = (abs((
    (6.0 * tmpvar_26.x)
   - 3.0)) - 1.0);
  tmpvar_27.y = (2.0 - abs((
    (6.0 * tmpvar_26.x)
   - 2.0)));
  tmpvar_27.z = (2.0 - abs((
    (6.0 * tmpvar_26.x)
   - 4.0)));
  resultColor_3.xyz = (((
    clamp (tmpvar_27, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_16) - 1.0)))
   * tmpvar_17.y)) + tmpvar_16);
  resultColor_3.w = (tmpvar_6 * _Alpha);
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_HUE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 blendColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_3 = tmpvar_4;
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * blendColor_3.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 rgb_9;
  rgb_9 = srcColor_6.xyz;
  highp vec4 tmpvar_10;
  if ((srcColor_6.y < srcColor_6.z)) {
    highp vec4 tmpvar_11;
    tmpvar_11.zw = vec2(-1.0, 0.6666667);
    tmpvar_11.xy = rgb_9.zy;
    tmpvar_10 = tmpvar_11;
  } else {
    highp vec4 tmpvar_12;
    tmpvar_12.zw = vec2(0.0, -0.3333333);
    tmpvar_12.xy = rgb_9.yz;
    tmpvar_10 = tmpvar_12;
  };
  highp vec4 tmpvar_13;
  if ((srcColor_6.x < tmpvar_10.x)) {
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = tmpvar_10.xyw;
    tmpvar_14.w = rgb_9.x;
    tmpvar_13 = tmpvar_14;
  } else {
    highp vec4 tmpvar_15;
    tmpvar_15.x = rgb_9.x;
    tmpvar_15.yzw = tmpvar_10.yzx;
    tmpvar_13 = tmpvar_15;
  };
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_13.x - min (tmpvar_13.w, tmpvar_13.y));
  highp vec3 tmpvar_17;
  tmpvar_17.x = abs(((
    (tmpvar_13.w - tmpvar_13.y)
   / 
    ((6.0 * tmpvar_16) + 1e-7)
  ) + tmpvar_13.z));
  tmpvar_17.y = tmpvar_16;
  tmpvar_17.z = tmpvar_13.x;
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_13.x - (tmpvar_16 * 0.5));
  highp vec3 tmpvar_19;
  tmpvar_19.x = tmpvar_17.x;
  tmpvar_19.y = (tmpvar_16 / ((1.0 - 
    abs(((2.0 * tmpvar_18) - 1.0))
  ) + 1e-7));
  tmpvar_19.z = tmpvar_18;
  highp vec3 rgb_20;
  rgb_20 = blendColor_3.xyz;
  highp vec4 tmpvar_21;
  if ((blendColor_3.y < blendColor_3.z)) {
    highp vec4 tmpvar_22;
    tmpvar_22.zw = vec2(-1.0, 0.6666667);
    tmpvar_22.xy = rgb_20.zy;
    tmpvar_21 = tmpvar_22;
  } else {
    highp vec4 tmpvar_23;
    tmpvar_23.zw = vec2(0.0, -0.3333333);
    tmpvar_23.xy = rgb_20.yz;
    tmpvar_21 = tmpvar_23;
  };
  highp vec4 tmpvar_24;
  if ((blendColor_3.x < tmpvar_21.x)) {
    highp vec4 tmpvar_25;
    tmpvar_25.xyz = tmpvar_21.xyw;
    tmpvar_25.w = rgb_20.x;
    tmpvar_24 = tmpvar_25;
  } else {
    highp vec4 tmpvar_26;
    tmpvar_26.x = rgb_20.x;
    tmpvar_26.yzw = tmpvar_21.yzx;
    tmpvar_24 = tmpvar_26;
  };
  highp float tmpvar_27;
  tmpvar_27 = (tmpvar_24.x - min (tmpvar_24.w, tmpvar_24.y));
  highp vec3 tmpvar_28;
  tmpvar_28.x = abs(((
    (tmpvar_24.w - tmpvar_24.y)
   / 
    ((6.0 * tmpvar_27) + 1e-7)
  ) + tmpvar_24.z));
  tmpvar_28.y = tmpvar_27;
  tmpvar_28.z = tmpvar_24.x;
  highp vec3 tmpvar_29;
  tmpvar_29.x = (abs((
    (6.0 * tmpvar_28.x)
   - 3.0)) - 1.0);
  tmpvar_29.y = (2.0 - abs((
    (6.0 * tmpvar_28.x)
   - 2.0)));
  tmpvar_29.z = (2.0 - abs((
    (6.0 * tmpvar_28.x)
   - 4.0)));
  resultColor_2.xyz = (((
    clamp (tmpvar_29, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_18) - 1.0)))
   * tmpvar_19.y)) + tmpvar_18);
  resultColor_2.w = (tmpvar_5 * _Alpha);
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_SATURATION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 blendColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_4 = tmpvar_5;
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * blendColor_4.w);
  highp vec3 rgb_7;
  rgb_7 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_8;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_9;
    tmpvar_9.zw = vec2(-1.0, 0.6666667);
    tmpvar_9.xy = rgb_7.zy;
    tmpvar_8 = tmpvar_9;
  } else {
    highp vec4 tmpvar_10;
    tmpvar_10.zw = vec2(0.0, -0.3333333);
    tmpvar_10.xy = rgb_7.yz;
    tmpvar_8 = tmpvar_10;
  };
  highp vec4 tmpvar_11;
  if ((xlt_fbColor_1.x < tmpvar_8.x)) {
    highp vec4 tmpvar_12;
    tmpvar_12.xyz = tmpvar_8.xyw;
    tmpvar_12.w = rgb_7.x;
    tmpvar_11 = tmpvar_12;
  } else {
    highp vec4 tmpvar_13;
    tmpvar_13.x = rgb_7.x;
    tmpvar_13.yzw = tmpvar_8.yzx;
    tmpvar_11 = tmpvar_13;
  };
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_11.x - min (tmpvar_11.w, tmpvar_11.y));
  highp vec3 tmpvar_15;
  tmpvar_15.x = abs(((
    (tmpvar_11.w - tmpvar_11.y)
   / 
    ((6.0 * tmpvar_14) + 1e-7)
  ) + tmpvar_11.z));
  tmpvar_15.y = tmpvar_14;
  tmpvar_15.z = tmpvar_11.x;
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_11.x - (tmpvar_14 * 0.5));
  highp vec3 rgb_17;
  rgb_17 = blendColor_4.xyz;
  highp vec4 tmpvar_18;
  if ((blendColor_4.y < blendColor_4.z)) {
    highp vec4 tmpvar_19;
    tmpvar_19.zw = vec2(-1.0, 0.6666667);
    tmpvar_19.xy = rgb_17.zy;
    tmpvar_18 = tmpvar_19;
  } else {
    highp vec4 tmpvar_20;
    tmpvar_20.zw = vec2(0.0, -0.3333333);
    tmpvar_20.xy = rgb_17.yz;
    tmpvar_18 = tmpvar_20;
  };
  highp vec4 tmpvar_21;
  if ((blendColor_4.x < tmpvar_18.x)) {
    highp vec4 tmpvar_22;
    tmpvar_22.xyz = tmpvar_18.xyw;
    tmpvar_22.w = rgb_17.x;
    tmpvar_21 = tmpvar_22;
  } else {
    highp vec4 tmpvar_23;
    tmpvar_23.x = rgb_17.x;
    tmpvar_23.yzw = tmpvar_18.yzx;
    tmpvar_21 = tmpvar_23;
  };
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_21.x - min (tmpvar_21.w, tmpvar_21.y));
  highp vec3 tmpvar_25;
  tmpvar_25.x = abs(((
    (tmpvar_21.w - tmpvar_21.y)
   / 
    ((6.0 * tmpvar_24) + 1e-7)
  ) + tmpvar_21.z));
  tmpvar_25.y = tmpvar_24;
  tmpvar_25.z = tmpvar_21.x;
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_21.x - (tmpvar_24 * 0.5));
  highp vec3 tmpvar_27;
  tmpvar_27.x = tmpvar_25.x;
  tmpvar_27.y = (tmpvar_24 / ((1.0 - 
    abs(((2.0 * tmpvar_26) - 1.0))
  ) + 1e-7));
  tmpvar_27.z = tmpvar_26;
  highp vec3 tmpvar_28;
  tmpvar_28.x = (abs((
    (6.0 * tmpvar_15.x)
   - 3.0)) - 1.0);
  tmpvar_28.y = (2.0 - abs((
    (6.0 * tmpvar_15.x)
   - 2.0)));
  tmpvar_28.z = (2.0 - abs((
    (6.0 * tmpvar_15.x)
   - 4.0)));
  resultColor_3.xyz = (((
    clamp (tmpvar_28, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_16) - 1.0)))
   * tmpvar_27.y)) + tmpvar_16);
  resultColor_3.w = (tmpvar_6 * _Alpha);
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_SATURATION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 blendColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_3 = tmpvar_4;
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * blendColor_3.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 rgb_9;
  rgb_9 = srcColor_6.xyz;
  highp vec4 tmpvar_10;
  if ((srcColor_6.y < srcColor_6.z)) {
    highp vec4 tmpvar_11;
    tmpvar_11.zw = vec2(-1.0, 0.6666667);
    tmpvar_11.xy = rgb_9.zy;
    tmpvar_10 = tmpvar_11;
  } else {
    highp vec4 tmpvar_12;
    tmpvar_12.zw = vec2(0.0, -0.3333333);
    tmpvar_12.xy = rgb_9.yz;
    tmpvar_10 = tmpvar_12;
  };
  highp vec4 tmpvar_13;
  if ((srcColor_6.x < tmpvar_10.x)) {
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = tmpvar_10.xyw;
    tmpvar_14.w = rgb_9.x;
    tmpvar_13 = tmpvar_14;
  } else {
    highp vec4 tmpvar_15;
    tmpvar_15.x = rgb_9.x;
    tmpvar_15.yzw = tmpvar_10.yzx;
    tmpvar_13 = tmpvar_15;
  };
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_13.x - min (tmpvar_13.w, tmpvar_13.y));
  highp vec3 tmpvar_17;
  tmpvar_17.x = abs(((
    (tmpvar_13.w - tmpvar_13.y)
   / 
    ((6.0 * tmpvar_16) + 1e-7)
  ) + tmpvar_13.z));
  tmpvar_17.y = tmpvar_16;
  tmpvar_17.z = tmpvar_13.x;
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_13.x - (tmpvar_16 * 0.5));
  highp vec3 rgb_19;
  rgb_19 = blendColor_3.xyz;
  highp vec4 tmpvar_20;
  if ((blendColor_3.y < blendColor_3.z)) {
    highp vec4 tmpvar_21;
    tmpvar_21.zw = vec2(-1.0, 0.6666667);
    tmpvar_21.xy = rgb_19.zy;
    tmpvar_20 = tmpvar_21;
  } else {
    highp vec4 tmpvar_22;
    tmpvar_22.zw = vec2(0.0, -0.3333333);
    tmpvar_22.xy = rgb_19.yz;
    tmpvar_20 = tmpvar_22;
  };
  highp vec4 tmpvar_23;
  if ((blendColor_3.x < tmpvar_20.x)) {
    highp vec4 tmpvar_24;
    tmpvar_24.xyz = tmpvar_20.xyw;
    tmpvar_24.w = rgb_19.x;
    tmpvar_23 = tmpvar_24;
  } else {
    highp vec4 tmpvar_25;
    tmpvar_25.x = rgb_19.x;
    tmpvar_25.yzw = tmpvar_20.yzx;
    tmpvar_23 = tmpvar_25;
  };
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_23.x - min (tmpvar_23.w, tmpvar_23.y));
  highp vec3 tmpvar_27;
  tmpvar_27.x = abs(((
    (tmpvar_23.w - tmpvar_23.y)
   / 
    ((6.0 * tmpvar_26) + 1e-7)
  ) + tmpvar_23.z));
  tmpvar_27.y = tmpvar_26;
  tmpvar_27.z = tmpvar_23.x;
  highp float tmpvar_28;
  tmpvar_28 = (tmpvar_23.x - (tmpvar_26 * 0.5));
  highp vec3 tmpvar_29;
  tmpvar_29.x = tmpvar_27.x;
  tmpvar_29.y = (tmpvar_26 / ((1.0 - 
    abs(((2.0 * tmpvar_28) - 1.0))
  ) + 1e-7));
  tmpvar_29.z = tmpvar_28;
  highp vec3 tmpvar_30;
  tmpvar_30.x = (abs((
    (6.0 * tmpvar_17.x)
   - 3.0)) - 1.0);
  tmpvar_30.y = (2.0 - abs((
    (6.0 * tmpvar_17.x)
   - 2.0)));
  tmpvar_30.z = (2.0 - abs((
    (6.0 * tmpvar_17.x)
   - 4.0)));
  resultColor_2.xyz = (((
    clamp (tmpvar_30, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_18) - 1.0)))
   * tmpvar_29.y)) + tmpvar_18);
  resultColor_2.w = (tmpvar_5 * _Alpha);
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_LUMINOSITY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 blendColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_4 = tmpvar_5;
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * blendColor_4.w);
  highp vec3 rgb_7;
  rgb_7 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_8;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_9;
    tmpvar_9.zw = vec2(-1.0, 0.6666667);
    tmpvar_9.xy = rgb_7.zy;
    tmpvar_8 = tmpvar_9;
  } else {
    highp vec4 tmpvar_10;
    tmpvar_10.zw = vec2(0.0, -0.3333333);
    tmpvar_10.xy = rgb_7.yz;
    tmpvar_8 = tmpvar_10;
  };
  highp vec4 tmpvar_11;
  if ((xlt_fbColor_1.x < tmpvar_8.x)) {
    highp vec4 tmpvar_12;
    tmpvar_12.xyz = tmpvar_8.xyw;
    tmpvar_12.w = rgb_7.x;
    tmpvar_11 = tmpvar_12;
  } else {
    highp vec4 tmpvar_13;
    tmpvar_13.x = rgb_7.x;
    tmpvar_13.yzw = tmpvar_8.yzx;
    tmpvar_11 = tmpvar_13;
  };
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_11.x - min (tmpvar_11.w, tmpvar_11.y));
  highp vec3 tmpvar_15;
  tmpvar_15.x = abs(((
    (tmpvar_11.w - tmpvar_11.y)
   / 
    ((6.0 * tmpvar_14) + 1e-7)
  ) + tmpvar_11.z));
  tmpvar_15.y = tmpvar_14;
  tmpvar_15.z = tmpvar_11.x;
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_11.x - (tmpvar_14 * 0.5));
  highp vec3 tmpvar_17;
  tmpvar_17.x = tmpvar_15.x;
  tmpvar_17.y = (tmpvar_14 / ((1.0 - 
    abs(((2.0 * tmpvar_16) - 1.0))
  ) + 1e-7));
  tmpvar_17.z = tmpvar_16;
  highp vec3 rgb_18;
  rgb_18 = blendColor_4.xyz;
  highp vec4 tmpvar_19;
  if ((blendColor_4.y < blendColor_4.z)) {
    highp vec4 tmpvar_20;
    tmpvar_20.zw = vec2(-1.0, 0.6666667);
    tmpvar_20.xy = rgb_18.zy;
    tmpvar_19 = tmpvar_20;
  } else {
    highp vec4 tmpvar_21;
    tmpvar_21.zw = vec2(0.0, -0.3333333);
    tmpvar_21.xy = rgb_18.yz;
    tmpvar_19 = tmpvar_21;
  };
  highp vec4 tmpvar_22;
  if ((blendColor_4.x < tmpvar_19.x)) {
    highp vec4 tmpvar_23;
    tmpvar_23.xyz = tmpvar_19.xyw;
    tmpvar_23.w = rgb_18.x;
    tmpvar_22 = tmpvar_23;
  } else {
    highp vec4 tmpvar_24;
    tmpvar_24.x = rgb_18.x;
    tmpvar_24.yzw = tmpvar_19.yzx;
    tmpvar_22 = tmpvar_24;
  };
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_22.x - ((tmpvar_22.x - 
    min (tmpvar_22.w, tmpvar_22.y)
  ) * 0.5));
  highp vec3 tmpvar_26;
  tmpvar_26.x = (abs((
    (6.0 * tmpvar_15.x)
   - 3.0)) - 1.0);
  tmpvar_26.y = (2.0 - abs((
    (6.0 * tmpvar_15.x)
   - 2.0)));
  tmpvar_26.z = (2.0 - abs((
    (6.0 * tmpvar_15.x)
   - 4.0)));
  resultColor_3.xyz = (((
    clamp (tmpvar_26, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_25) - 1.0)))
   * tmpvar_17.y)) + tmpvar_25);
  resultColor_3.w = (tmpvar_6 * _Alpha);
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LUMINOSITY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 blendColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_3 = tmpvar_4;
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * blendColor_3.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 rgb_9;
  rgb_9 = srcColor_6.xyz;
  highp vec4 tmpvar_10;
  if ((srcColor_6.y < srcColor_6.z)) {
    highp vec4 tmpvar_11;
    tmpvar_11.zw = vec2(-1.0, 0.6666667);
    tmpvar_11.xy = rgb_9.zy;
    tmpvar_10 = tmpvar_11;
  } else {
    highp vec4 tmpvar_12;
    tmpvar_12.zw = vec2(0.0, -0.3333333);
    tmpvar_12.xy = rgb_9.yz;
    tmpvar_10 = tmpvar_12;
  };
  highp vec4 tmpvar_13;
  if ((srcColor_6.x < tmpvar_10.x)) {
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = tmpvar_10.xyw;
    tmpvar_14.w = rgb_9.x;
    tmpvar_13 = tmpvar_14;
  } else {
    highp vec4 tmpvar_15;
    tmpvar_15.x = rgb_9.x;
    tmpvar_15.yzw = tmpvar_10.yzx;
    tmpvar_13 = tmpvar_15;
  };
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_13.x - min (tmpvar_13.w, tmpvar_13.y));
  highp vec3 tmpvar_17;
  tmpvar_17.x = abs(((
    (tmpvar_13.w - tmpvar_13.y)
   / 
    ((6.0 * tmpvar_16) + 1e-7)
  ) + tmpvar_13.z));
  tmpvar_17.y = tmpvar_16;
  tmpvar_17.z = tmpvar_13.x;
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_13.x - (tmpvar_16 * 0.5));
  highp vec3 tmpvar_19;
  tmpvar_19.x = tmpvar_17.x;
  tmpvar_19.y = (tmpvar_16 / ((1.0 - 
    abs(((2.0 * tmpvar_18) - 1.0))
  ) + 1e-7));
  tmpvar_19.z = tmpvar_18;
  highp vec3 rgb_20;
  rgb_20 = blendColor_3.xyz;
  highp vec4 tmpvar_21;
  if ((blendColor_3.y < blendColor_3.z)) {
    highp vec4 tmpvar_22;
    tmpvar_22.zw = vec2(-1.0, 0.6666667);
    tmpvar_22.xy = rgb_20.zy;
    tmpvar_21 = tmpvar_22;
  } else {
    highp vec4 tmpvar_23;
    tmpvar_23.zw = vec2(0.0, -0.3333333);
    tmpvar_23.xy = rgb_20.yz;
    tmpvar_21 = tmpvar_23;
  };
  highp vec4 tmpvar_24;
  if ((blendColor_3.x < tmpvar_21.x)) {
    highp vec4 tmpvar_25;
    tmpvar_25.xyz = tmpvar_21.xyw;
    tmpvar_25.w = rgb_20.x;
    tmpvar_24 = tmpvar_25;
  } else {
    highp vec4 tmpvar_26;
    tmpvar_26.x = rgb_20.x;
    tmpvar_26.yzw = tmpvar_21.yzx;
    tmpvar_24 = tmpvar_26;
  };
  highp float tmpvar_27;
  tmpvar_27 = (tmpvar_24.x - ((tmpvar_24.x - 
    min (tmpvar_24.w, tmpvar_24.y)
  ) * 0.5));
  highp vec3 tmpvar_28;
  tmpvar_28.x = (abs((
    (6.0 * tmpvar_17.x)
   - 3.0)) - 1.0);
  tmpvar_28.y = (2.0 - abs((
    (6.0 * tmpvar_17.x)
   - 2.0)));
  tmpvar_28.z = (2.0 - abs((
    (6.0 * tmpvar_17.x)
   - 4.0)));
  resultColor_2.xyz = (((
    clamp (tmpvar_28, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_27) - 1.0)))
   * tmpvar_19.y)) + tmpvar_27);
  resultColor_2.w = (tmpvar_5 * _Alpha);
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_COLOR"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 blendColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_4 = tmpvar_5;
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * blendColor_4.w);
  highp vec3 rgb_7;
  rgb_7 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_8;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_9;
    tmpvar_9.zw = vec2(-1.0, 0.6666667);
    tmpvar_9.xy = rgb_7.zy;
    tmpvar_8 = tmpvar_9;
  } else {
    highp vec4 tmpvar_10;
    tmpvar_10.zw = vec2(0.0, -0.3333333);
    tmpvar_10.xy = rgb_7.yz;
    tmpvar_8 = tmpvar_10;
  };
  highp vec4 tmpvar_11;
  if ((xlt_fbColor_1.x < tmpvar_8.x)) {
    highp vec4 tmpvar_12;
    tmpvar_12.xyz = tmpvar_8.xyw;
    tmpvar_12.w = rgb_7.x;
    tmpvar_11 = tmpvar_12;
  } else {
    highp vec4 tmpvar_13;
    tmpvar_13.x = rgb_7.x;
    tmpvar_13.yzw = tmpvar_8.yzx;
    tmpvar_11 = tmpvar_13;
  };
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_11.x - ((tmpvar_11.x - 
    min (tmpvar_11.w, tmpvar_11.y)
  ) * 0.5));
  highp vec3 rgb_15;
  rgb_15 = blendColor_4.xyz;
  highp vec4 tmpvar_16;
  if ((blendColor_4.y < blendColor_4.z)) {
    highp vec4 tmpvar_17;
    tmpvar_17.zw = vec2(-1.0, 0.6666667);
    tmpvar_17.xy = rgb_15.zy;
    tmpvar_16 = tmpvar_17;
  } else {
    highp vec4 tmpvar_18;
    tmpvar_18.zw = vec2(0.0, -0.3333333);
    tmpvar_18.xy = rgb_15.yz;
    tmpvar_16 = tmpvar_18;
  };
  highp vec4 tmpvar_19;
  if ((blendColor_4.x < tmpvar_16.x)) {
    highp vec4 tmpvar_20;
    tmpvar_20.xyz = tmpvar_16.xyw;
    tmpvar_20.w = rgb_15.x;
    tmpvar_19 = tmpvar_20;
  } else {
    highp vec4 tmpvar_21;
    tmpvar_21.x = rgb_15.x;
    tmpvar_21.yzw = tmpvar_16.yzx;
    tmpvar_19 = tmpvar_21;
  };
  highp float tmpvar_22;
  tmpvar_22 = (tmpvar_19.x - min (tmpvar_19.w, tmpvar_19.y));
  highp vec3 tmpvar_23;
  tmpvar_23.x = abs(((
    (tmpvar_19.w - tmpvar_19.y)
   / 
    ((6.0 * tmpvar_22) + 1e-7)
  ) + tmpvar_19.z));
  tmpvar_23.y = tmpvar_22;
  tmpvar_23.z = tmpvar_19.x;
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_19.x - (tmpvar_22 * 0.5));
  highp vec3 tmpvar_25;
  tmpvar_25.x = tmpvar_23.x;
  tmpvar_25.y = (tmpvar_22 / ((1.0 - 
    abs(((2.0 * tmpvar_24) - 1.0))
  ) + 1e-7));
  tmpvar_25.z = tmpvar_24;
  highp vec3 tmpvar_26;
  tmpvar_26.x = (abs((
    (6.0 * tmpvar_23.x)
   - 3.0)) - 1.0);
  tmpvar_26.y = (2.0 - abs((
    (6.0 * tmpvar_23.x)
   - 2.0)));
  tmpvar_26.z = (2.0 - abs((
    (6.0 * tmpvar_23.x)
   - 4.0)));
  resultColor_3.xyz = (((
    clamp (tmpvar_26, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_14) - 1.0)))
   * tmpvar_25.y)) + tmpvar_14);
  resultColor_3.w = (tmpvar_6 * _Alpha);
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_COLOR"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 blendColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_3 = tmpvar_4;
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * blendColor_3.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 rgb_9;
  rgb_9 = srcColor_6.xyz;
  highp vec4 tmpvar_10;
  if ((srcColor_6.y < srcColor_6.z)) {
    highp vec4 tmpvar_11;
    tmpvar_11.zw = vec2(-1.0, 0.6666667);
    tmpvar_11.xy = rgb_9.zy;
    tmpvar_10 = tmpvar_11;
  } else {
    highp vec4 tmpvar_12;
    tmpvar_12.zw = vec2(0.0, -0.3333333);
    tmpvar_12.xy = rgb_9.yz;
    tmpvar_10 = tmpvar_12;
  };
  highp vec4 tmpvar_13;
  if ((srcColor_6.x < tmpvar_10.x)) {
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = tmpvar_10.xyw;
    tmpvar_14.w = rgb_9.x;
    tmpvar_13 = tmpvar_14;
  } else {
    highp vec4 tmpvar_15;
    tmpvar_15.x = rgb_9.x;
    tmpvar_15.yzw = tmpvar_10.yzx;
    tmpvar_13 = tmpvar_15;
  };
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_13.x - ((tmpvar_13.x - 
    min (tmpvar_13.w, tmpvar_13.y)
  ) * 0.5));
  highp vec3 rgb_17;
  rgb_17 = blendColor_3.xyz;
  highp vec4 tmpvar_18;
  if ((blendColor_3.y < blendColor_3.z)) {
    highp vec4 tmpvar_19;
    tmpvar_19.zw = vec2(-1.0, 0.6666667);
    tmpvar_19.xy = rgb_17.zy;
    tmpvar_18 = tmpvar_19;
  } else {
    highp vec4 tmpvar_20;
    tmpvar_20.zw = vec2(0.0, -0.3333333);
    tmpvar_20.xy = rgb_17.yz;
    tmpvar_18 = tmpvar_20;
  };
  highp vec4 tmpvar_21;
  if ((blendColor_3.x < tmpvar_18.x)) {
    highp vec4 tmpvar_22;
    tmpvar_22.xyz = tmpvar_18.xyw;
    tmpvar_22.w = rgb_17.x;
    tmpvar_21 = tmpvar_22;
  } else {
    highp vec4 tmpvar_23;
    tmpvar_23.x = rgb_17.x;
    tmpvar_23.yzw = tmpvar_18.yzx;
    tmpvar_21 = tmpvar_23;
  };
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_21.x - min (tmpvar_21.w, tmpvar_21.y));
  highp vec3 tmpvar_25;
  tmpvar_25.x = abs(((
    (tmpvar_21.w - tmpvar_21.y)
   / 
    ((6.0 * tmpvar_24) + 1e-7)
  ) + tmpvar_21.z));
  tmpvar_25.y = tmpvar_24;
  tmpvar_25.z = tmpvar_21.x;
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_21.x - (tmpvar_24 * 0.5));
  highp vec3 tmpvar_27;
  tmpvar_27.x = tmpvar_25.x;
  tmpvar_27.y = (tmpvar_24 / ((1.0 - 
    abs(((2.0 * tmpvar_26) - 1.0))
  ) + 1e-7));
  tmpvar_27.z = tmpvar_26;
  highp vec3 tmpvar_28;
  tmpvar_28.x = (abs((
    (6.0 * tmpvar_25.x)
   - 3.0)) - 1.0);
  tmpvar_28.y = (2.0 - abs((
    (6.0 * tmpvar_25.x)
   - 2.0)));
  tmpvar_28.z = (2.0 - abs((
    (6.0 * tmpvar_25.x)
   - 4.0)));
  resultColor_2.xyz = (((
    clamp (tmpvar_28, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_16) - 1.0)))
   * tmpvar_27.y)) + tmpvar_16);
  resultColor_2.w = (tmpvar_5 * _Alpha);
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_BLEND"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 blendColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_4 = tmpvar_5;
  resultColor_3.xyz = ((dot (vec3(0.299, 0.587, 0.114), xlt_fbColor_1.xyz) * 1.68) * blendColor_4.xyz);
  resultColor_3.w = (_Opacity * blendColor_4.w);
  resultColor_3.w = (resultColor_3.w * _Alpha);
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_BLEND"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 blendColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_3 = tmpvar_4;
  highp vec4 srcColor_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_GRAP, tmpvar_6);
  srcColor_5 = tmpvar_7;
  resultColor_2.xyz = ((dot (vec3(0.299, 0.587, 0.114), srcColor_5.xyz) * 1.68) * blendColor_3.xyz);
  resultColor_2.w = (_Opacity * blendColor_3.w);
  resultColor_2.w = (resultColor_2.w * _Alpha);
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_EXCLUSION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 blendColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_4 = tmpvar_5;
  resultColor_3.xyz = ((xlt_fbColor_1.xyz + blendColor_4.xyz) - ((2.0 * xlt_fbColor_1.xyz) * blendColor_4.xyz));
  resultColor_3.w = (_Opacity * blendColor_4.w);
  resultColor_3.w = (resultColor_3.w * _Alpha);
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_EXCLUSION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 blendColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_3 = tmpvar_4;
  highp vec4 srcColor_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_GRAP, tmpvar_6);
  srcColor_5 = tmpvar_7;
  resultColor_2.xyz = ((srcColor_5.xyz + blendColor_3.xyz) - ((2.0 * srcColor_5.xyz) * blendColor_3.xyz));
  resultColor_2.w = (_Opacity * blendColor_3.w);
  resultColor_2.w = (resultColor_2.w * _Alpha);
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_HARDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 blendColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_4 = tmpvar_5;
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * blendColor_4.w);
  highp float tmpvar_7;
  if ((blendColor_4.x < 0.5)) {
    tmpvar_7 = ((2.0 * blendColor_4.x) * xlt_fbColor_1.x);
  } else {
    tmpvar_7 = (1.0 - ((2.0 * 
      (1.0 - blendColor_4.x)
    ) * (1.0 - xlt_fbColor_1.x)));
  };
  highp float tmpvar_8;
  if ((blendColor_4.y < 0.5)) {
    tmpvar_8 = ((2.0 * blendColor_4.y) * xlt_fbColor_1.y);
  } else {
    tmpvar_8 = (1.0 - ((2.0 * 
      (1.0 - blendColor_4.y)
    ) * (1.0 - xlt_fbColor_1.y)));
  };
  highp float tmpvar_9;
  if ((blendColor_4.z < 0.5)) {
    tmpvar_9 = ((2.0 * blendColor_4.z) * xlt_fbColor_1.z);
  } else {
    tmpvar_9 = (1.0 - ((2.0 * 
      (1.0 - blendColor_4.z)
    ) * (1.0 - xlt_fbColor_1.z)));
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_7;
  tmpvar_10.y = tmpvar_8;
  tmpvar_10.z = tmpvar_9;
  resultColor_3.xyz = tmpvar_10;
  resultColor_3.w = (tmpvar_6 * _Alpha);
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_HARDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 blendColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_3 = tmpvar_4;
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * blendColor_3.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp float tmpvar_9;
  if ((blendColor_3.x < 0.5)) {
    tmpvar_9 = ((2.0 * blendColor_3.x) * srcColor_6.x);
  } else {
    tmpvar_9 = (1.0 - ((2.0 * 
      (1.0 - blendColor_3.x)
    ) * (1.0 - srcColor_6.x)));
  };
  highp float tmpvar_10;
  if ((blendColor_3.y < 0.5)) {
    tmpvar_10 = ((2.0 * blendColor_3.y) * srcColor_6.y);
  } else {
    tmpvar_10 = (1.0 - ((2.0 * 
      (1.0 - blendColor_3.y)
    ) * (1.0 - srcColor_6.y)));
  };
  highp float tmpvar_11;
  if ((blendColor_3.z < 0.5)) {
    tmpvar_11 = ((2.0 * blendColor_3.z) * srcColor_6.z);
  } else {
    tmpvar_11 = (1.0 - ((2.0 * 
      (1.0 - blendColor_3.z)
    ) * (1.0 - srcColor_6.z)));
  };
  highp vec3 tmpvar_12;
  tmpvar_12.x = tmpvar_9;
  tmpvar_12.y = tmpvar_10;
  tmpvar_12.z = tmpvar_11;
  resultColor_2.xyz = tmpvar_12;
  resultColor_2.w = (tmpvar_5 * _Alpha);
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_VIVIDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp float factor_3;
  highp vec4 resultColor_4;
  highp vec4 blendColor_5;
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_5 = tmpvar_6;
  resultColor_4 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_3 = (_Opacity * blendColor_5.w);
  highp float tmpvar_7;
  if ((blendColor_5.x < 0.5)) {
    highp float blend_8;
    blend_8 = (2.0 * blendColor_5.x);
    highp float tmpvar_9;
    if ((blend_8 == 0.0)) {
      tmpvar_9 = blend_8;
    } else {
      tmpvar_9 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.x)
       / blend_8)), 0.0);
    };
    tmpvar_7 = tmpvar_9;
  } else {
    highp float blend_10;
    blend_10 = (2.0 * (blendColor_5.x - 0.5));
    highp float tmpvar_11;
    if ((blend_10 == 1.0)) {
      tmpvar_11 = blend_10;
    } else {
      tmpvar_11 = min ((xlt_fbColor_1.x / (1.0 - blend_10)), 1.0);
    };
    tmpvar_7 = tmpvar_11;
  };
  highp float tmpvar_12;
  if ((blendColor_5.y < 0.5)) {
    highp float blend_13;
    blend_13 = (2.0 * blendColor_5.y);
    highp float tmpvar_14;
    if ((blend_13 == 0.0)) {
      tmpvar_14 = blend_13;
    } else {
      tmpvar_14 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.y)
       / blend_13)), 0.0);
    };
    tmpvar_12 = tmpvar_14;
  } else {
    highp float blend_15;
    blend_15 = (2.0 * (blendColor_5.y - 0.5));
    highp float tmpvar_16;
    if ((blend_15 == 1.0)) {
      tmpvar_16 = blend_15;
    } else {
      tmpvar_16 = min ((xlt_fbColor_1.y / (1.0 - blend_15)), 1.0);
    };
    tmpvar_12 = tmpvar_16;
  };
  highp float tmpvar_17;
  if ((blendColor_5.z < 0.5)) {
    highp float blend_18;
    blend_18 = (2.0 * blendColor_5.z);
    highp float tmpvar_19;
    if ((blend_18 == 0.0)) {
      tmpvar_19 = blend_18;
    } else {
      tmpvar_19 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.z)
       / blend_18)), 0.0);
    };
    tmpvar_17 = tmpvar_19;
  } else {
    highp float blend_20;
    blend_20 = (2.0 * (blendColor_5.z - 0.5));
    highp float tmpvar_21;
    if ((blend_20 == 1.0)) {
      tmpvar_21 = blend_20;
    } else {
      tmpvar_21 = min ((xlt_fbColor_1.z / (1.0 - blend_20)), 1.0);
    };
    tmpvar_17 = tmpvar_21;
  };
  highp vec3 tmpvar_22;
  tmpvar_22.x = tmpvar_7;
  tmpvar_22.y = tmpvar_12;
  tmpvar_22.z = tmpvar_17;
  resultColor_4.xyz = tmpvar_22;
  resultColor_4.w = (factor_3 * _Alpha);
  xlt_fbColor_1 = resultColor_4;
  gl_FragData[0] = resultColor_4;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_VIVIDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp float factor_2;
  highp vec4 resultColor_3;
  highp vec4 blendColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_4 = tmpvar_5;
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_2 = (_Opacity * blendColor_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp float tmpvar_9;
  if ((blendColor_4.x < 0.5)) {
    highp float blend_10;
    blend_10 = (2.0 * blendColor_4.x);
    highp float tmpvar_11;
    if ((blend_10 == 0.0)) {
      tmpvar_11 = blend_10;
    } else {
      tmpvar_11 = max ((1.0 - (
        (1.0 - srcColor_6.x)
       / blend_10)), 0.0);
    };
    tmpvar_9 = tmpvar_11;
  } else {
    highp float blend_12;
    blend_12 = (2.0 * (blendColor_4.x - 0.5));
    highp float tmpvar_13;
    if ((blend_12 == 1.0)) {
      tmpvar_13 = blend_12;
    } else {
      tmpvar_13 = min ((srcColor_6.x / (1.0 - blend_12)), 1.0);
    };
    tmpvar_9 = tmpvar_13;
  };
  highp float tmpvar_14;
  if ((blendColor_4.y < 0.5)) {
    highp float blend_15;
    blend_15 = (2.0 * blendColor_4.y);
    highp float tmpvar_16;
    if ((blend_15 == 0.0)) {
      tmpvar_16 = blend_15;
    } else {
      tmpvar_16 = max ((1.0 - (
        (1.0 - srcColor_6.y)
       / blend_15)), 0.0);
    };
    tmpvar_14 = tmpvar_16;
  } else {
    highp float blend_17;
    blend_17 = (2.0 * (blendColor_4.y - 0.5));
    highp float tmpvar_18;
    if ((blend_17 == 1.0)) {
      tmpvar_18 = blend_17;
    } else {
      tmpvar_18 = min ((srcColor_6.y / (1.0 - blend_17)), 1.0);
    };
    tmpvar_14 = tmpvar_18;
  };
  highp float tmpvar_19;
  if ((blendColor_4.z < 0.5)) {
    highp float blend_20;
    blend_20 = (2.0 * blendColor_4.z);
    highp float tmpvar_21;
    if ((blend_20 == 0.0)) {
      tmpvar_21 = blend_20;
    } else {
      tmpvar_21 = max ((1.0 - (
        (1.0 - srcColor_6.z)
       / blend_20)), 0.0);
    };
    tmpvar_19 = tmpvar_21;
  } else {
    highp float blend_22;
    blend_22 = (2.0 * (blendColor_4.z - 0.5));
    highp float tmpvar_23;
    if ((blend_22 == 1.0)) {
      tmpvar_23 = blend_22;
    } else {
      tmpvar_23 = min ((srcColor_6.z / (1.0 - blend_22)), 1.0);
    };
    tmpvar_19 = tmpvar_23;
  };
  highp vec3 tmpvar_24;
  tmpvar_24.x = tmpvar_9;
  tmpvar_24.y = tmpvar_14;
  tmpvar_24.z = tmpvar_19;
  resultColor_3.xyz = tmpvar_24;
  resultColor_3.w = (factor_2 * _Alpha);
  tmpvar_1 = resultColor_3;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_OVERLAY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 blendColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_4 = tmpvar_5;
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * blendColor_4.w);
  highp float tmpvar_7;
  if ((xlt_fbColor_1.x < 0.5)) {
    tmpvar_7 = ((2.0 * xlt_fbColor_1.x) * blendColor_4.x);
  } else {
    tmpvar_7 = (1.0 - ((2.0 * 
      (1.0 - xlt_fbColor_1.x)
    ) * (1.0 - blendColor_4.x)));
  };
  highp float tmpvar_8;
  if ((xlt_fbColor_1.y < 0.5)) {
    tmpvar_8 = ((2.0 * xlt_fbColor_1.y) * blendColor_4.y);
  } else {
    tmpvar_8 = (1.0 - ((2.0 * 
      (1.0 - xlt_fbColor_1.y)
    ) * (1.0 - blendColor_4.y)));
  };
  highp float tmpvar_9;
  if ((xlt_fbColor_1.z < 0.5)) {
    tmpvar_9 = ((2.0 * xlt_fbColor_1.z) * blendColor_4.z);
  } else {
    tmpvar_9 = (1.0 - ((2.0 * 
      (1.0 - xlt_fbColor_1.z)
    ) * (1.0 - blendColor_4.z)));
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_7;
  tmpvar_10.y = tmpvar_8;
  tmpvar_10.z = tmpvar_9;
  resultColor_3.xyz = tmpvar_10;
  resultColor_3.w = (tmpvar_6 * _Alpha);
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_OVERLAY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 blendColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_3 = tmpvar_4;
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * blendColor_3.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp float tmpvar_9;
  if ((srcColor_6.x < 0.5)) {
    tmpvar_9 = ((2.0 * srcColor_6.x) * blendColor_3.x);
  } else {
    tmpvar_9 = (1.0 - ((2.0 * 
      (1.0 - srcColor_6.x)
    ) * (1.0 - blendColor_3.x)));
  };
  highp float tmpvar_10;
  if ((srcColor_6.y < 0.5)) {
    tmpvar_10 = ((2.0 * srcColor_6.y) * blendColor_3.y);
  } else {
    tmpvar_10 = (1.0 - ((2.0 * 
      (1.0 - srcColor_6.y)
    ) * (1.0 - blendColor_3.y)));
  };
  highp float tmpvar_11;
  if ((srcColor_6.z < 0.5)) {
    tmpvar_11 = ((2.0 * srcColor_6.z) * blendColor_3.z);
  } else {
    tmpvar_11 = (1.0 - ((2.0 * 
      (1.0 - srcColor_6.z)
    ) * (1.0 - blendColor_3.z)));
  };
  highp vec3 tmpvar_12;
  tmpvar_12.x = tmpvar_9;
  tmpvar_12.y = tmpvar_10;
  tmpvar_12.z = tmpvar_11;
  resultColor_2.xyz = tmpvar_12;
  resultColor_2.w = (tmpvar_5 * _Alpha);
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_COLORBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 blendColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_4 = tmpvar_5;
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * blendColor_4.w);
  highp vec3 blend_7;
  blend_7 = blendColor_4.xyz;
  highp float blend_8;
  blend_8 = blend_7.x;
  highp float tmpvar_9;
  if ((blendColor_4.x == 0.0)) {
    tmpvar_9 = blend_8;
  } else {
    tmpvar_9 = max ((1.0 - (
      (1.0 - xlt_fbColor_1.x)
     / blendColor_4.x)), 0.0);
  };
  highp float blend_10;
  blend_10 = blend_7.y;
  highp float tmpvar_11;
  if ((blendColor_4.y == 0.0)) {
    tmpvar_11 = blend_10;
  } else {
    tmpvar_11 = max ((1.0 - (
      (1.0 - xlt_fbColor_1.y)
     / blendColor_4.y)), 0.0);
  };
  highp float blend_12;
  blend_12 = blend_7.z;
  highp float tmpvar_13;
  if ((blendColor_4.z == 0.0)) {
    tmpvar_13 = blend_12;
  } else {
    tmpvar_13 = max ((1.0 - (
      (1.0 - xlt_fbColor_1.z)
     / blendColor_4.z)), 0.0);
  };
  highp vec3 tmpvar_14;
  tmpvar_14.x = tmpvar_9;
  tmpvar_14.y = tmpvar_11;
  tmpvar_14.z = tmpvar_13;
  resultColor_3.xyz = tmpvar_14;
  resultColor_3.w = (tmpvar_6 * _Alpha);
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_COLORBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 blendColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_3 = tmpvar_4;
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * blendColor_3.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 blend_9;
  blend_9 = blendColor_3.xyz;
  highp float blend_10;
  blend_10 = blend_9.x;
  highp float tmpvar_11;
  if ((blendColor_3.x == 0.0)) {
    tmpvar_11 = blend_10;
  } else {
    tmpvar_11 = max ((1.0 - (
      (1.0 - srcColor_6.x)
     / blendColor_3.x)), 0.0);
  };
  highp float blend_12;
  blend_12 = blend_9.y;
  highp float tmpvar_13;
  if ((blendColor_3.y == 0.0)) {
    tmpvar_13 = blend_12;
  } else {
    tmpvar_13 = max ((1.0 - (
      (1.0 - srcColor_6.y)
     / blendColor_3.y)), 0.0);
  };
  highp float blend_14;
  blend_14 = blend_9.z;
  highp float tmpvar_15;
  if ((blendColor_3.z == 0.0)) {
    tmpvar_15 = blend_14;
  } else {
    tmpvar_15 = max ((1.0 - (
      (1.0 - srcColor_6.z)
     / blendColor_3.z)), 0.0);
  };
  highp vec3 tmpvar_16;
  tmpvar_16.x = tmpvar_11;
  tmpvar_16.y = tmpvar_13;
  tmpvar_16.z = tmpvar_15;
  resultColor_2.xyz = tmpvar_16;
  resultColor_2.w = (tmpvar_5 * _Alpha);
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_COLORDODGE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 blendColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_4 = tmpvar_5;
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * blendColor_4.w);
  highp vec3 blend_7;
  blend_7 = blendColor_4.xyz;
  highp float blend_8;
  blend_8 = blend_7.x;
  highp float tmpvar_9;
  if ((blendColor_4.x == 1.0)) {
    tmpvar_9 = blend_8;
  } else {
    tmpvar_9 = min ((xlt_fbColor_1.x / (1.0 - blendColor_4.x)), 1.0);
  };
  highp float blend_10;
  blend_10 = blend_7.y;
  highp float tmpvar_11;
  if ((blendColor_4.y == 1.0)) {
    tmpvar_11 = blend_10;
  } else {
    tmpvar_11 = min ((xlt_fbColor_1.y / (1.0 - blendColor_4.y)), 1.0);
  };
  highp float blend_12;
  blend_12 = blend_7.z;
  highp float tmpvar_13;
  if ((blendColor_4.z == 1.0)) {
    tmpvar_13 = blend_12;
  } else {
    tmpvar_13 = min ((xlt_fbColor_1.z / (1.0 - blendColor_4.z)), 1.0);
  };
  highp vec3 tmpvar_14;
  tmpvar_14.x = tmpvar_9;
  tmpvar_14.y = tmpvar_11;
  tmpvar_14.z = tmpvar_13;
  resultColor_3.xyz = tmpvar_14;
  resultColor_3.w = (tmpvar_6 * _Alpha);
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_COLORDODGE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 blendColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_3 = tmpvar_4;
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * blendColor_3.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 blend_9;
  blend_9 = blendColor_3.xyz;
  highp float blend_10;
  blend_10 = blend_9.x;
  highp float tmpvar_11;
  if ((blendColor_3.x == 1.0)) {
    tmpvar_11 = blend_10;
  } else {
    tmpvar_11 = min ((srcColor_6.x / (1.0 - blendColor_3.x)), 1.0);
  };
  highp float blend_12;
  blend_12 = blend_9.y;
  highp float tmpvar_13;
  if ((blendColor_3.y == 1.0)) {
    tmpvar_13 = blend_12;
  } else {
    tmpvar_13 = min ((srcColor_6.y / (1.0 - blendColor_3.y)), 1.0);
  };
  highp float blend_14;
  blend_14 = blend_9.z;
  highp float tmpvar_15;
  if ((blendColor_3.z == 1.0)) {
    tmpvar_15 = blend_14;
  } else {
    tmpvar_15 = min ((srcColor_6.z / (1.0 - blendColor_3.z)), 1.0);
  };
  highp vec3 tmpvar_16;
  tmpvar_16.x = tmpvar_11;
  tmpvar_16.y = tmpvar_13;
  tmpvar_16.z = tmpvar_15;
  resultColor_2.xyz = tmpvar_16;
  resultColor_2.w = (tmpvar_5 * _Alpha);
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_SOFTLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 blendColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_4 = tmpvar_5;
  resultColor_3.xyz = (((
    (vec3(1.0, 1.0, 1.0) - (vec3(2.0, 2.0, 2.0) * blendColor_4.xyz))
   * xlt_fbColor_1.xyz) * xlt_fbColor_1.xyz) + ((vec3(2.0, 2.0, 2.0) * xlt_fbColor_1.xyz) * blendColor_4.xyz));
  resultColor_3.w = (_Opacity * blendColor_4.w);
  resultColor_3.w = (resultColor_3.w * _Alpha);
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_SOFTLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 blendColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_3 = tmpvar_4;
  highp vec4 srcColor_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_GRAP, tmpvar_6);
  srcColor_5 = tmpvar_7;
  resultColor_2.xyz = (((
    (vec3(1.0, 1.0, 1.0) - (vec3(2.0, 2.0, 2.0) * blendColor_3.xyz))
   * srcColor_5.xyz) * srcColor_5.xyz) + ((vec3(2.0, 2.0, 2.0) * srcColor_5.xyz) * blendColor_3.xyz));
  resultColor_2.w = (_Opacity * blendColor_3.w);
  resultColor_2.w = (resultColor_2.w * _Alpha);
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_HARDMIX"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp float factor_3;
  highp vec4 resultColor_4;
  highp vec4 blendColor_5;
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_5 = tmpvar_6;
  resultColor_4 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_3 = (_Opacity * blendColor_5.w);
  highp float tmpvar_7;
  highp float tmpvar_8;
  if ((blendColor_5.x < 0.5)) {
    highp float blend_9;
    blend_9 = (2.0 * blendColor_5.x);
    highp float tmpvar_10;
    if ((blend_9 == 0.0)) {
      tmpvar_10 = blend_9;
    } else {
      tmpvar_10 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.x)
       / blend_9)), 0.0);
    };
    tmpvar_8 = tmpvar_10;
  } else {
    highp float blend_11;
    blend_11 = (2.0 * (blendColor_5.x - 0.5));
    highp float tmpvar_12;
    if ((blend_11 == 1.0)) {
      tmpvar_12 = blend_11;
    } else {
      tmpvar_12 = min ((xlt_fbColor_1.x / (1.0 - blend_11)), 1.0);
    };
    tmpvar_8 = tmpvar_12;
  };
  if ((tmpvar_8 < 0.5)) {
    tmpvar_7 = 0.0;
  } else {
    tmpvar_7 = 1.0;
  };
  highp float tmpvar_13;
  highp float tmpvar_14;
  if ((blendColor_5.y < 0.5)) {
    highp float blend_15;
    blend_15 = (2.0 * blendColor_5.y);
    highp float tmpvar_16;
    if ((blend_15 == 0.0)) {
      tmpvar_16 = blend_15;
    } else {
      tmpvar_16 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.y)
       / blend_15)), 0.0);
    };
    tmpvar_14 = tmpvar_16;
  } else {
    highp float blend_17;
    blend_17 = (2.0 * (blendColor_5.y - 0.5));
    highp float tmpvar_18;
    if ((blend_17 == 1.0)) {
      tmpvar_18 = blend_17;
    } else {
      tmpvar_18 = min ((xlt_fbColor_1.y / (1.0 - blend_17)), 1.0);
    };
    tmpvar_14 = tmpvar_18;
  };
  if ((tmpvar_14 < 0.5)) {
    tmpvar_13 = 0.0;
  } else {
    tmpvar_13 = 1.0;
  };
  highp float tmpvar_19;
  highp float tmpvar_20;
  if ((blendColor_5.z < 0.5)) {
    highp float blend_21;
    blend_21 = (2.0 * blendColor_5.z);
    highp float tmpvar_22;
    if ((blend_21 == 0.0)) {
      tmpvar_22 = blend_21;
    } else {
      tmpvar_22 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.z)
       / blend_21)), 0.0);
    };
    tmpvar_20 = tmpvar_22;
  } else {
    highp float blend_23;
    blend_23 = (2.0 * (blendColor_5.z - 0.5));
    highp float tmpvar_24;
    if ((blend_23 == 1.0)) {
      tmpvar_24 = blend_23;
    } else {
      tmpvar_24 = min ((xlt_fbColor_1.z / (1.0 - blend_23)), 1.0);
    };
    tmpvar_20 = tmpvar_24;
  };
  if ((tmpvar_20 < 0.5)) {
    tmpvar_19 = 0.0;
  } else {
    tmpvar_19 = 1.0;
  };
  highp vec3 tmpvar_25;
  tmpvar_25.x = tmpvar_7;
  tmpvar_25.y = tmpvar_13;
  tmpvar_25.z = tmpvar_19;
  resultColor_4.xyz = tmpvar_25;
  resultColor_4.w = (factor_3 * _Alpha);
  xlt_fbColor_1 = resultColor_4;
  gl_FragData[0] = resultColor_4;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_HARDMIX"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp float factor_2;
  highp vec4 resultColor_3;
  highp vec4 blendColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_4 = tmpvar_5;
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_2 = (_Opacity * blendColor_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  if ((blendColor_4.x < 0.5)) {
    highp float blend_11;
    blend_11 = (2.0 * blendColor_4.x);
    highp float tmpvar_12;
    if ((blend_11 == 0.0)) {
      tmpvar_12 = blend_11;
    } else {
      tmpvar_12 = max ((1.0 - (
        (1.0 - srcColor_6.x)
       / blend_11)), 0.0);
    };
    tmpvar_10 = tmpvar_12;
  } else {
    highp float blend_13;
    blend_13 = (2.0 * (blendColor_4.x - 0.5));
    highp float tmpvar_14;
    if ((blend_13 == 1.0)) {
      tmpvar_14 = blend_13;
    } else {
      tmpvar_14 = min ((srcColor_6.x / (1.0 - blend_13)), 1.0);
    };
    tmpvar_10 = tmpvar_14;
  };
  if ((tmpvar_10 < 0.5)) {
    tmpvar_9 = 0.0;
  } else {
    tmpvar_9 = 1.0;
  };
  highp float tmpvar_15;
  highp float tmpvar_16;
  if ((blendColor_4.y < 0.5)) {
    highp float blend_17;
    blend_17 = (2.0 * blendColor_4.y);
    highp float tmpvar_18;
    if ((blend_17 == 0.0)) {
      tmpvar_18 = blend_17;
    } else {
      tmpvar_18 = max ((1.0 - (
        (1.0 - srcColor_6.y)
       / blend_17)), 0.0);
    };
    tmpvar_16 = tmpvar_18;
  } else {
    highp float blend_19;
    blend_19 = (2.0 * (blendColor_4.y - 0.5));
    highp float tmpvar_20;
    if ((blend_19 == 1.0)) {
      tmpvar_20 = blend_19;
    } else {
      tmpvar_20 = min ((srcColor_6.y / (1.0 - blend_19)), 1.0);
    };
    tmpvar_16 = tmpvar_20;
  };
  if ((tmpvar_16 < 0.5)) {
    tmpvar_15 = 0.0;
  } else {
    tmpvar_15 = 1.0;
  };
  highp float tmpvar_21;
  highp float tmpvar_22;
  if ((blendColor_4.z < 0.5)) {
    highp float blend_23;
    blend_23 = (2.0 * blendColor_4.z);
    highp float tmpvar_24;
    if ((blend_23 == 0.0)) {
      tmpvar_24 = blend_23;
    } else {
      tmpvar_24 = max ((1.0 - (
        (1.0 - srcColor_6.z)
       / blend_23)), 0.0);
    };
    tmpvar_22 = tmpvar_24;
  } else {
    highp float blend_25;
    blend_25 = (2.0 * (blendColor_4.z - 0.5));
    highp float tmpvar_26;
    if ((blend_25 == 1.0)) {
      tmpvar_26 = blend_25;
    } else {
      tmpvar_26 = min ((srcColor_6.z / (1.0 - blend_25)), 1.0);
    };
    tmpvar_22 = tmpvar_26;
  };
  if ((tmpvar_22 < 0.5)) {
    tmpvar_21 = 0.0;
  } else {
    tmpvar_21 = 1.0;
  };
  highp vec3 tmpvar_27;
  tmpvar_27.x = tmpvar_9;
  tmpvar_27.y = tmpvar_15;
  tmpvar_27.z = tmpvar_21;
  resultColor_3.xyz = tmpvar_27;
  resultColor_3.w = (factor_2 * _Alpha);
  tmpvar_1 = resultColor_3;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_PINLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp float factor_3;
  highp vec4 resultColor_4;
  highp vec4 blendColor_5;
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_5 = tmpvar_6;
  resultColor_4 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_3 = (_Opacity * blendColor_5.w);
  highp float tmpvar_7;
  if ((blendColor_5.x < 0.5)) {
    tmpvar_7 = min ((2.0 * blendColor_5.x), xlt_fbColor_1.x);
  } else {
    tmpvar_7 = max ((2.0 * (blendColor_5.x - 0.5)), xlt_fbColor_1.x);
  };
  highp float tmpvar_8;
  if ((blendColor_5.y < 0.5)) {
    tmpvar_8 = min ((2.0 * blendColor_5.y), xlt_fbColor_1.y);
  } else {
    tmpvar_8 = max ((2.0 * (blendColor_5.y - 0.5)), xlt_fbColor_1.y);
  };
  highp float tmpvar_9;
  if ((blendColor_5.z < 0.5)) {
    tmpvar_9 = min ((2.0 * blendColor_5.z), xlt_fbColor_1.z);
  } else {
    tmpvar_9 = max ((2.0 * (blendColor_5.z - 0.5)), xlt_fbColor_1.z);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_7;
  tmpvar_10.y = tmpvar_8;
  tmpvar_10.z = tmpvar_9;
  resultColor_4.xyz = tmpvar_10;
  resultColor_4.w = (factor_3 * _Alpha);
  xlt_fbColor_1 = resultColor_4;
  gl_FragData[0] = resultColor_4;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_PINLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp float factor_2;
  highp vec4 resultColor_3;
  highp vec4 blendColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_4 = tmpvar_5;
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_2 = (_Opacity * blendColor_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp float tmpvar_9;
  if ((blendColor_4.x < 0.5)) {
    tmpvar_9 = min ((2.0 * blendColor_4.x), srcColor_6.x);
  } else {
    tmpvar_9 = max ((2.0 * (blendColor_4.x - 0.5)), srcColor_6.x);
  };
  highp float tmpvar_10;
  if ((blendColor_4.y < 0.5)) {
    tmpvar_10 = min ((2.0 * blendColor_4.y), srcColor_6.y);
  } else {
    tmpvar_10 = max ((2.0 * (blendColor_4.y - 0.5)), srcColor_6.y);
  };
  highp float tmpvar_11;
  if ((blendColor_4.z < 0.5)) {
    tmpvar_11 = min ((2.0 * blendColor_4.z), srcColor_6.z);
  } else {
    tmpvar_11 = max ((2.0 * (blendColor_4.z - 0.5)), srcColor_6.z);
  };
  highp vec3 tmpvar_12;
  tmpvar_12.x = tmpvar_9;
  tmpvar_12.y = tmpvar_10;
  tmpvar_12.z = tmpvar_11;
  resultColor_3.xyz = tmpvar_12;
  resultColor_3.w = (factor_2 * _Alpha);
  tmpvar_1 = resultColor_3;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_LINEARLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp float factor_3;
  highp vec4 resultColor_4;
  highp vec4 blendColor_5;
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_5 = tmpvar_6;
  resultColor_4 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_3 = (_Opacity * blendColor_5.w);
  highp float tmpvar_7;
  if ((blendColor_5.x < 0.5)) {
    tmpvar_7 = max (((xlt_fbColor_1.x + 
      (2.0 * blendColor_5.x)
    ) - 1.0), 0.0);
  } else {
    tmpvar_7 = min ((xlt_fbColor_1.x + (2.0 * 
      (blendColor_5.x - 0.5)
    )), 1.0);
  };
  highp float tmpvar_8;
  if ((blendColor_5.y < 0.5)) {
    tmpvar_8 = max (((xlt_fbColor_1.y + 
      (2.0 * blendColor_5.y)
    ) - 1.0), 0.0);
  } else {
    tmpvar_8 = min ((xlt_fbColor_1.y + (2.0 * 
      (blendColor_5.y - 0.5)
    )), 1.0);
  };
  highp float tmpvar_9;
  if ((blendColor_5.z < 0.5)) {
    tmpvar_9 = max (((xlt_fbColor_1.z + 
      (2.0 * blendColor_5.z)
    ) - 1.0), 0.0);
  } else {
    tmpvar_9 = min ((xlt_fbColor_1.z + (2.0 * 
      (blendColor_5.z - 0.5)
    )), 1.0);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_7;
  tmpvar_10.y = tmpvar_8;
  tmpvar_10.z = tmpvar_9;
  resultColor_4.xyz = tmpvar_10;
  resultColor_4.w = (factor_3 * _Alpha);
  xlt_fbColor_1 = resultColor_4;
  gl_FragData[0] = resultColor_4;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LINEARLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp float factor_2;
  highp vec4 resultColor_3;
  highp vec4 blendColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_4 = tmpvar_5;
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_2 = (_Opacity * blendColor_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp float tmpvar_9;
  if ((blendColor_4.x < 0.5)) {
    tmpvar_9 = max (((srcColor_6.x + 
      (2.0 * blendColor_4.x)
    ) - 1.0), 0.0);
  } else {
    tmpvar_9 = min ((srcColor_6.x + (2.0 * 
      (blendColor_4.x - 0.5)
    )), 1.0);
  };
  highp float tmpvar_10;
  if ((blendColor_4.y < 0.5)) {
    tmpvar_10 = max (((srcColor_6.y + 
      (2.0 * blendColor_4.y)
    ) - 1.0), 0.0);
  } else {
    tmpvar_10 = min ((srcColor_6.y + (2.0 * 
      (blendColor_4.y - 0.5)
    )), 1.0);
  };
  highp float tmpvar_11;
  if ((blendColor_4.z < 0.5)) {
    tmpvar_11 = max (((srcColor_6.z + 
      (2.0 * blendColor_4.z)
    ) - 1.0), 0.0);
  } else {
    tmpvar_11 = min ((srcColor_6.z + (2.0 * 
      (blendColor_4.z - 0.5)
    )), 1.0);
  };
  highp vec3 tmpvar_12;
  tmpvar_12.x = tmpvar_9;
  tmpvar_12.y = tmpvar_10;
  tmpvar_12.z = tmpvar_11;
  resultColor_3.xyz = tmpvar_12;
  resultColor_3.w = (factor_2 * _Alpha);
  tmpvar_1 = resultColor_3;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_DIFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 blendColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_4 = tmpvar_5;
  resultColor_3.xyz = abs((xlt_fbColor_1.xyz - blendColor_4.xyz));
  resultColor_3.w = (_Opacity * blendColor_4.w);
  resultColor_3.w = (resultColor_3.w * _Alpha);
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_DIFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 blendColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_3 = tmpvar_4;
  highp vec4 srcColor_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_GRAP, tmpvar_6);
  srcColor_5 = tmpvar_7;
  resultColor_2.xyz = abs((srcColor_5.xyz - blendColor_3.xyz));
  resultColor_2.w = (_Opacity * blendColor_3.w);
  resultColor_2.w = (resultColor_2.w * _Alpha);
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_LINEARBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 blendColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_4 = tmpvar_5;
  resultColor_3.xyz = max (((xlt_fbColor_1.xyz + blendColor_4.xyz) - vec3(1.0, 1.0, 1.0)), vec3(0.0, 0.0, 0.0));
  resultColor_3.w = (_Opacity * blendColor_4.w);
  resultColor_3.w = (resultColor_3.w * _Alpha);
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LINEARBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 blendColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_3 = tmpvar_4;
  highp vec4 srcColor_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_GRAP, tmpvar_6);
  srcColor_5 = tmpvar_7;
  resultColor_2.xyz = max (((srcColor_5.xyz + blendColor_3.xyz) - vec3(1.0, 1.0, 1.0)), vec3(0.0, 0.0, 0.0));
  resultColor_2.w = (_Opacity * blendColor_3.w);
  resultColor_2.w = (resultColor_2.w * _Alpha);
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_SUB"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 blendColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_4 = tmpvar_5;
  resultColor_3.xyz = max ((xlt_fbColor_1.xyz - blendColor_4.xyz), vec3(0.0, 0.0, 0.0));
  resultColor_3.w = (_Opacity * blendColor_4.w);
  resultColor_3.w = (resultColor_3.w * _Alpha);
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_SUB"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 blendColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_3 = tmpvar_4;
  highp vec4 srcColor_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_GRAP, tmpvar_6);
  srcColor_5 = tmpvar_7;
  resultColor_2.xyz = max ((srcColor_5.xyz - blendColor_3.xyz), vec3(0.0, 0.0, 0.0));
  resultColor_2.w = (_Opacity * blendColor_3.w);
  resultColor_2.w = (resultColor_2.w * _Alpha);
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_LUT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_LutMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
uniform sampler2D _LutMap;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = gl_LastFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  highp vec4 blendColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_4 = tmpvar_5;
  highp vec2 tmpvar_6;
  tmpvar_6.x = blendColor_4.x;
  tmpvar_6.y = xlt_fbColor_1.x;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_LutMap, tmpvar_6);
  resultColor_3.x = tmpvar_7.x;
  highp vec2 tmpvar_8;
  tmpvar_8.x = blendColor_4.y;
  tmpvar_8.y = xlt_fbColor_1.y;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_LutMap, tmpvar_8);
  resultColor_3.y = tmpvar_9.y;
  highp vec2 tmpvar_10;
  tmpvar_10.x = blendColor_4.z;
  tmpvar_10.y = xlt_fbColor_1.z;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_LutMap, tmpvar_10);
  resultColor_3.z = tmpvar_11.z;
  resultColor_3.w = (_Opacity * blendColor_4.w);
  resultColor_3.w = (resultColor_3.w * _Alpha);
  xlt_fbColor_1 = resultColor_3;
  gl_FragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_LUT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_LutMap",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
uniform sampler2D _LutMap;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 blendColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_3 = tmpvar_4;
  highp vec4 srcColor_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_GRAP, tmpvar_6);
  srcColor_5 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8.x = blendColor_3.x;
  tmpvar_8.y = srcColor_5.x;
  lowp vec4 tmpvar_9;
  tmpvar_9 = texture2D (_LutMap, tmpvar_8);
  resultColor_2.x = tmpvar_9.x;
  highp vec2 tmpvar_10;
  tmpvar_10.x = blendColor_3.y;
  tmpvar_10.y = srcColor_5.y;
  lowp vec4 tmpvar_11;
  tmpvar_11 = texture2D (_LutMap, tmpvar_10);
  resultColor_2.y = tmpvar_11.y;
  highp vec2 tmpvar_12;
  tmpvar_12.x = blendColor_3.z;
  tmpvar_12.y = srcColor_5.z;
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_LutMap, tmpvar_12);
  resultColor_2.z = tmpvar_13.z;
  resultColor_2.w = (_Opacity * blendColor_3.w);
  resultColor_2.w = (resultColor_2.w * _Alpha);
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"FRAMEBUFFER_FETCH","BLEND_ADD"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[#extension GL_EXT_shader_framebuffer_fetch : enable
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 resultColor_1;
  highp vec4 blendColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_2 = tmpvar_3;
  highp float tmpvar_4;
  tmpvar_4 = (_Opacity * blendColor_2.w);
  blendColor_2 = (blendColor_2 * tmpvar_4);
  highp vec4 tmpvar_5;
  tmpvar_5.xyz = blendColor_2.xyz;
  tmpvar_5.w = tmpvar_4;
  resultColor_1.xyz = tmpvar_5.xyz;
  resultColor_1.w = (tmpvar_4 * _Alpha);
  gl_FragData[0] = resultColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"BLEND_ADD"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexTilling",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _TexOffset;
uniform highp vec2 _TexTilling;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1.z = 0.0;
  tmpvar_1.xy = (_glesVertex.xy * 0.01);
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = tmpvar_1;
  tmpvar_2 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_3));
  highp vec4 o_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_2 * 0.5);
  o_4.zw = tmpvar_5.zw;
  o_4.xy = (tmpvar_5.xy + tmpvar_5.ww);
  o_4.y = ((2.0 * tmpvar_5.w) - o_4.y);
  o_4.zw = tmpvar_2.zw;
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((_glesMultiTexCoord0.xy * 0.01) * _TexTilling) + _TexOffset);
  gl_Position = (tmpvar_6 * tmpvar_2);
  xlv_TEXCOORD4 = o_4;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Alpha;
uniform highp float _Opacity;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  highp vec4 blendColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  blendColor_3 = tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * blendColor_3.w);
  blendColor_3 = (blendColor_3 * tmpvar_5);
  highp vec4 tmpvar_6;
  tmpvar_6.xyz = blendColor_3.xyz;
  tmpvar_6.w = tmpvar_5;
  resultColor_2.xyz = tmpvar_6.xyz;
  resultColor_2.w = (tmpvar_5 * _Alpha);
  tmpvar_1 = resultColor_2;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
}

end
