

#DEFPARAMS
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "maintex" },
[Keywords(MASK_ON, MASK_OFF)]
MASK = {"mask", FLOAT, "1.0"},
MASK_DIFFUSE = { "mask Color", TEXTURE2D, "masktex" },
MASK_STRETCH = {"mask stretch", VEC2, "1.0, 1.0"},
[Keywords(MASK_GLOW_ON, MASK_GLOW_OFF)]
MASK_GLOW = {"mask glow", FLOAT, "1.0"},
BOLD = {"bold", FLOATRANGE, "0.0, 0.3, -0.3"},
OUTLINE = {"outline", FLOAT, "0.0"},
TEXTCOLOR = {"Text Color", COLOR, "0.0, 0.0, 0.0, 1.0"},
OUTLINECOLOR = {"Outline Color", COLOR, "0.0, 0.0, 0.0, 1.0"},
[Keywords(HALO_ON, HALO_OFF)]
HALO = {"halo", FLOAT, "1.0"},
[Keywords(EMBOSSED_ON, EMBOSSED_OFF)]
EMBOSSED = {"embossed", FLOAT, "1.0"},
EMBOSSED_SCALE = {"embossed scale", FLOAT, "1.0"},
EMBOSSED_BASE = {"embossed base", FLOAT, "0.0"},
EMBOSSED_HEIGHT = {"embossed height", FLOAT, "1.0"},
EMBOSSED_DIRECTION = {"embossed direction", FLOAT, "0.0"},
[Keywords(RAINBOW_FONT_ON, RAINBOW_FONT_OFF)]
RAINBOW_FONT = {"rainbow font", FLOAT, "1.0"},
RAINBOW_COUNT = {"rainbow count", FLOAT, "7.0"},
[Enum(BlendFactor)]
_BlendSrc = {"Blend Src", FLOAT, "4.0"},
[Enum(BlendFactor)]
_BlendDst = {"Blend Dst", FLOAT, "5.0"},
_Alpha = {"alpha", FLOAT, "1.0"},
[Keywords(BLEND_NORMAL, BLEND_MULTIPLY, BLEND_SCREEN, BLEND_HUE, BLEND_SATURATION, BLEND_LUMINOSITY, BLEND_COLOR, BLEND_BLEND, BLEND_EXCLUSION, BLEND_HARDLIGHT, BLEND_VIVIDLIGHT, BLEND_OVERLAY, BLEND_COLORBURN, BLEND_COLORDODGE, BLEND_SOFTLIGHT, BLEND_HARDMIX, BLEND_PINLIGHT, BLEND_LINEARLIGHT, BLEND_DIFF, BLEND_LINEARBURN, BLEND_SUB, BLEND_LUT, BLEND_ADD)]
_BlendMode = {"Blend Mode", FLOAT, "0.0"},
_Opacity = { "Opacity", FLOATRANGE, "1.0, 1, 0" },
_LutMap = {"Lut Map", TEXTURE2D, "white" },
_DefMode = { "Def Mode", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "realtimesdf3d"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc",  "%_BlendDst" , ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile HALO_ON HALO_OFF
#pragma multi_compile MASK_GLOW_ON MASK_GLOW_OFF
#pragma multi_compile MASK_ON MASK_OFF
#pragma multi_compile EMBOSSED_ON EMBOSSED_OFF
#pragma multi_compile RAINBOW_FONT_ON RAINBOW_FONT_OFF
#pragma multi_compile_fbfetch
#pragma multi_compile BLEND_NORMAL BLEND_MULTIPLY BLEND_SCREEN BLEND_HUE BLEND_SATURATION BLEND_LUMINOSITY BLEND_COLOR BLEND_BLEND BLEND_EXCLUSION BLEND_HARDLIGHT BLEND_VIVIDLIGHT BLEND_OVERLAY BLEND_COLORBURN BLEND_COLORDODGE BLEND_SOFTLIGHT BLEND_HARDMIX BLEND_PINLIGHT BLEND_LINEARLIGHT BLEND_DIFF BLEND_LINEARBURN BLEND_SUB BLEND_LUT BLEND_ADD
#include "common.inc"
#include "blendfunc_plenty.inc"
#include "light.inc"

struct appdata
{
    float2 vertex : POSITION;
    float2 uv : TEXCOORD0;
    float2 uv2 : TEXCOORD1;
    float2 index : TEXCOORD2;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float2 uv2 : TEXCOORD1;
    float4 vertex : SV_POSITION;
    float2 rbuv : TEXCOORD2;
    float4 screenPos : TEXCOORD4;
};

sampler2D TEXTURE_DIFFUSE;
sampler2D MASK_DIFFUSE;
float2 MASK_STRETCH;
float BOLD;
float OUTLINE;
float4 TEXTCOLOR;
float4 OUTLINECOLOR;
float EMBOSSED_SCALE;
float EMBOSSED_BASE;
float EMBOSSED_HEIGHT;
float EMBOSSED_DIRECTION;
float RAINBOW_COUNT;
float _Alpha;
float _Opacity;
sampler2D _LutMap;
float _DefMode;

v2f vert(appdata v)
{
    v2f o;
    float4 pos =ObjectToClipPos(float3(v.vertex * 0.01,0.0));
    o.screenPos = ComputeScreenPos(pos);
    o.vertex = UniformNDC(pos);
    o.uv = v.uv.xy;
    o.uv2 = v.uv2.xy;
    float2 rainbowUV = float2(fmod(v.index.x, RAINBOW_COUNT) * (1.0/RAINBOW_COUNT), 0.5);
    o.rbuv = rainbowUV;
    return o;
}

float outline(float distance, float smoothing, float weight)
{
    float textAlpha = smoothstep(0.5 + weight - smoothing, 0.5 + weight + smoothing, distance);
    float outlineAlpha = smoothstep(0.5 - weight - smoothing, 0.5 - weight + smoothing, distance);
    return outlineAlpha - textAlpha;
}

float4 GetSourceColor(v2f i, float4 fbColor)
{
    #ifdef FRAMEBUFFER_FETCH
    return fbColor;
    #else
    float2 uvCoord = i.screenPos.xy / i.screenPos.w;
    float4 srcColor = tex2D(TEXTURE_GRAP, uvCoord);
    return srcColor;
    #endif
}

float4 GetTextColor(v2f i)
{
    float distance = tex2D(TEXTURE_DIFFUSE, i.uv).a;
    float dx = ddx(i.uv.x);
    float dy = ddy(i.uv.y);
    float smoothing = 0.02 * sqrt(dx * dx + dy * dy) * 2048;

    float4 finalTextColor = TEXTCOLOR;
    #ifdef MASK_ON
    float4 maskColor = float4(0.0,0.0,0.0,1.0);
    #ifdef RAINBOW_FONT_ON
    maskColor = tex2D(MASK_DIFFUSE, i.rbuv);
    #elif RAINBOW_FONT_OFF
    float2 maskUV = i.uv2 * MASK_STRETCH;
    maskColor = tex2D(MASK_DIFFUSE, maskUV);
    #endif
    finalTextColor = TEXTCOLOR * (1.0 - maskColor.a) + maskColor * maskColor.a;
    #endif

    #ifdef EMBOSSED_ON
        float2 ox = float2(1.0/1024, 0);
        float2 oy = float2(0, 1.0/1024);
        float distx = tex2D(TEXTURE_DIFFUSE, i.uv + ox).a - tex2D(TEXTURE_DIFFUSE, i.uv - ox).a;
        float disty = tex2D(TEXTURE_DIFFUSE, i.uv + oy).a - tex2D(TEXTURE_DIFFUSE, i.uv - oy).a;
        float distFactor = 1.0 - smoothstep(EMBOSSED_HEIGHT - 0.02, EMBOSSED_HEIGHT + 0.02, distance);
        float3 light = normalize(float3(cos(EMBOSSED_DIRECTION), sin(EMBOSSED_DIRECTION), 0.7));
        float diffuse = dot( normalize(float3(distx * distFactor, disty * distFactor, 0.08)), light );
        float factor = diffuse * EMBOSSED_SCALE + EMBOSSED_BASE;
        finalTextColor.rgb = finalTextColor.rgb * factor;
    #endif

    #ifdef HALO_OFF
        float bold = clamp(0.5 - BOLD, smoothing, 1.0 - smoothing);
        float textAlpha = smoothstep(bold - smoothing, bold + smoothing, distance);
        finalTextColor.a = finalTextColor.a * textAlpha;
        float4 color = finalTextColor;
        if (OUTLINE > 0)
        {
            float outline = clamp(bold - OUTLINE, smoothing, 1.0 - smoothing);
            float outlineAlpha = smoothstep(outline - smoothing, outline + smoothing, distance);
            float4 outlineColor = OUTLINECOLOR;
            outlineColor.a = outlineColor.a * outlineAlpha;
            finalTextColor = finalTextColor * finalTextColor.a;
            outlineColor = outlineColor * (1.0 - finalTextColor.a);
            color = outlineColor + finalTextColor;
        }
    #elif HALO_ON
        float textAlpha = outline(distance, smoothing, BOLD);
        distance = distance + (0.5 - distance) * OUTLINE;
        distance = clamp(distance, 0, 1);
        float haloAlpha = 1.0 - abs(distance * 2.0 - 1.0);
        float4 outlineColor = OUTLINECOLOR;
        #ifdef MASK_GLOW_ON
            outlineColor = finalTextColor;
        #endif
        finalTextColor.a = finalTextColor.a * textAlpha;
        outlineColor.a = outlineColor.a * haloAlpha;
        finalTextColor = finalTextColor * finalTextColor.a;
        outlineColor = outlineColor * (1.0 - finalTextColor.a);
        float4 color = outlineColor + finalTextColor;
    #endif
    return color;
}


#ifdef FRAMEBUFFER_FETCH
void frag(v2f i, inout float4 fbColor:COLOR0)
#else
fixed4 frag(v2f i) : SV_Target
#endif
{
    float4 blendColor = GetTextColor(i);
    float4 resultColor = float4(1.0, 1.0, 1.0, 1.0);
    float  factor = _Opacity * blendColor.a;

    #ifdef FRAMEBUFFER_FETCH
    float4 fbc = fbColor;
    #else
    float4 fbc = resultColor;
    #endif

    #ifdef BLEND_NORMAL
    resultColor = float4(blendColor.r, blendColor.g, blendColor.b, factor);
    #elif BLEND_MULTIPLY
    float4 whiteColor = float4(1.0, 1.0, 1.0, 1.0);
    blendColor = whiteColor - factor * (whiteColor - blendColor);
    resultColor = float4(blendColor.r, blendColor.g, blendColor.b, 1.0);
    #elif BLEND_SCREEN
    blendColor = factor * blendColor;
    resultColor = float4(blendColor.r, blendColor.g, blendColor.b, 1.0);
    #elif BLEND_HUE
    float4 srcColor = GetSourceColor(i, fbc);
    float3 baseHSL = RGBToHSL(srcColor.rgb);
    float3 blendHSL = RGBToHSL(blendColor.rgb);
    float3 resHSLColor = HSLToRGB(float3(blendHSL.r, baseHSL.g, baseHSL.b));
    resultColor.rgb = resHSLColor;
    resultColor.a = factor;
    #elif BLEND_SATURATION
    float4 srcColor = GetSourceColor(i, fbc);
    float3 baseHSL = RGBToHSL(srcColor.rgb);
    float3 blendHSL = RGBToHSL(blendColor.rgb);
    float3 resHSLColor = HSLToRGB(float3(baseHSL.r, blendHSL.g, baseHSL.b));
    resultColor.rgb = resHSLColor;
    resultColor.a = factor;
    #elif BLEND_LUMINOSITY
    float4 srcColor = GetSourceColor(i, fbc);
    float3 baseHSL = RGBToHSL(srcColor.rgb);
    float3 blendHSL = RGBToHSL(blendColor.rgb);
    float3 resHSLColor = HSLToRGB(float3(baseHSL.r, baseHSL.g, blendHSL.b));
    resultColor.rgb = resHSLColor;
    resultColor.a = factor;
    #elif BLEND_COLOR
    float4 srcColor = GetSourceColor(i, fbc);
    float3 baseHSL = RGBToHSL(srcColor.rgb);
    float3 blendHSL = RGBToHSL(blendColor.rgb);
    float3 resHSLColor = HSLToRGB(float3(blendHSL.r, blendHSL.g, baseHSL.b));
    resultColor.rgb = resHSLColor;
    resultColor.a = factor;
    #elif BLEND_BLEND
    float4 srcColor = GetSourceColor(i, fbc);
    float imgIntensity = dot(float3(0.2990,0.5870,0.1140), srcColor.rgb);
    float3 resIntColor = (imgIntensity * 1.68) * blendColor.rgb;
    resultColor.rgb = resIntColor;
    resultColor.a = factor;
    #elif BLEND_EXCLUSION
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendExclusion(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_HARDLIGHT
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendHardLight(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_VIVIDLIGHT
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendVividLight(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_OVERLAY
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendOverlay(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_COLORBURN
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendColorBurn(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_COLORDODGE
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendColorDodge(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_SOFTLIGHT
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendSoftLight(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_HARDMIX
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendHardMix(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_PINLIGHT
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendPinLight(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_LINEARLIGHT
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendLinearLight(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_DIFF
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendDiff(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_LINEARBURN
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendLinearBurn(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_SUB
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendSub(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
    #elif BLEND_LUT
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.r = tex2D(_LutMap, float2(blendColor.r, srcColor.r)).r;
    resultColor.g = tex2D(_LutMap, float2(blendColor.g, srcColor.g)).g;
    resultColor.b = tex2D(_LutMap, float2(blendColor.b, srcColor.b)).b;
    resultColor.a = factor;
    #elif BLEND_ADD
    blendColor = blendColor * factor;
    resultColor = float4(blendColor.r, blendColor.g, blendColor.b, factor);
    #endif
    resultColor.a = resultColor.a * _Alpha;
    #ifndef FRAMEBUFFER_FETCH
    return resultColor;
    #else
    fbColor = resultColor;
    #endif
}

ENDCG
#END
