function DefineParams()
	Properties = 
	{
		
TEXTURE_DIFFUSE = { "tex diffuse", TEXTURE2D, "white" },
AXIS_RIGHT = { "axis right",  VEC3, "0.0,0.0,0.0" },
AXIS_UP = { "axis up",  VEC3, "0.0,0.0,0.0" },

ORIENT = { "orient",  FLOAT, "1.0" },
LOCK_Y = { "lock y",  FLOAT, "1.0" },
SIM_SPACE = {"sim space", FLOAT, "0.0"},
IMAGE_INFO = {"image info", VEC4, "0.0,0.0,1.0,1.0"},
STRETCHED_SCALE = {"stretched scale", VEC2, "0.0,1.0"},
ROTATE_CENTER = {"rotate center", VEC4, "1.0,1.0,1.0,0.0"},
PIVOT_OFFSET_SCALE = {"pivot offset scale", VEC3, "0.0,0.0,0.0"},
_Opacity = { "Opacity", FLOATRANGE, "1.0, 1, 0" },

_BlendMode = {"Blend Mode", FLOAT, "0.0"},

_BlendSrc = {"Blend Src", FLOAT, "4.0"},

_BlendDst = {"Blend Dst", FLOAT, "5.0"},
_DefMode = { "Def Mode", FLOAT, "0.0"},
_LutMap = {"Lut Map", TEXTURE2D, "white" },

	}
	Attributes = 
	{
		ORIENT = "Keywords(VIEWPLANE,VIEWPOSITION,AXIS,VELOCITY)", 
		_BlendMode = "Keywords(BLEND_NORMAL,BLEND_MULTIPLY,BLEND_SCREEN,BLEND_HUE,BLEND_SATURATION,BLEND_LUMINOSITY,BLEND_COLOR,BLEND_BLEND,BLEND_EXCLUSION,BLEND_HARDLIGHT,BLEND_VIVIDLIGHT,BLEND_OVERLAY,BLEND_COLORBURN,BLEND_COLORDODGE,BLEND_SOFTLIGHT,BLEND_HARDMIX,BLEND_PINLIGHT,BLEND_LINEARLIGHT,BLEND_DIFF,BLEND_LINEARBURN,BLEND_SUB,BLEND_LUT,BLEND_ADD)", 
		_BlendSrc = "Enum(BlendFactor)", 
		_BlendDst = "Enum(BlendFactor)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "particle_billboard"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc",  "%_BlendDst" , ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPLANE","BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_2;
  tmpvar_2 = (tmpvar_1 * xlv_TEXCOORD2);
  highp vec4 tmpvar_3;
  tmpvar_3.xyz = tmpvar_2.xyz;
  tmpvar_3.w = (_Opacity * tmpvar_2.w);
  _glesFragData[0] = tmpvar_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPLANE","BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_3;
  tmpvar_3 = (tmpvar_2 * xlv_TEXCOORD2);
  highp vec4 tmpvar_4;
  tmpvar_4.xyz = tmpvar_3.xyz;
  tmpvar_4.w = (_Opacity * tmpvar_3.w);
  tmpvar_1 = tmpvar_4;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPOSITION","BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_2;
  tmpvar_2 = (tmpvar_1 * xlv_TEXCOORD2);
  highp vec4 tmpvar_3;
  tmpvar_3.xyz = tmpvar_2.xyz;
  tmpvar_3.w = (_Opacity * tmpvar_2.w);
  _glesFragData[0] = tmpvar_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPOSITION","BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_3;
  tmpvar_3 = (tmpvar_2 * xlv_TEXCOORD2);
  highp vec4 tmpvar_4;
  tmpvar_4.xyz = tmpvar_3.xyz;
  tmpvar_4.w = (_Opacity * tmpvar_3.w);
  tmpvar_1 = tmpvar_4;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","AXIS","BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_2;
  tmpvar_2 = (tmpvar_1 * xlv_TEXCOORD2);
  highp vec4 tmpvar_3;
  tmpvar_3.xyz = tmpvar_2.xyz;
  tmpvar_3.w = (_Opacity * tmpvar_2.w);
  _glesFragData[0] = tmpvar_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"AXIS","BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_3;
  tmpvar_3 = (tmpvar_2 * xlv_TEXCOORD2);
  highp vec4 tmpvar_4;
  tmpvar_4.xyz = tmpvar_3.xyz;
  tmpvar_4.w = (_Opacity * tmpvar_3.w);
  tmpvar_1 = tmpvar_4;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VELOCITY","BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_2;
  tmpvar_2 = (tmpvar_1 * xlv_TEXCOORD2);
  highp vec4 tmpvar_3;
  tmpvar_3.xyz = tmpvar_2.xyz;
  tmpvar_3.w = (_Opacity * tmpvar_2.w);
  _glesFragData[0] = tmpvar_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VELOCITY","BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_3;
  tmpvar_3 = (tmpvar_2 * xlv_TEXCOORD2);
  highp vec4 tmpvar_4;
  tmpvar_4.xyz = tmpvar_3.xyz;
  tmpvar_4.w = (_Opacity * tmpvar_3.w);
  tmpvar_1 = tmpvar_4;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPLANE","BLEND_MULTIPLY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_2;
  tmpvar_2 = (tmpvar_1 * xlv_TEXCOORD2);
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = (vec4(1.0, 1.0, 1.0, 1.0) - ((_Opacity * tmpvar_2.w) * (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_2))).xyz;
  _glesFragData[0] = tmpvar_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPLANE","BLEND_MULTIPLY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_3;
  tmpvar_3 = (tmpvar_2 * xlv_TEXCOORD2);
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = (vec4(1.0, 1.0, 1.0, 1.0) - ((_Opacity * tmpvar_3.w) * (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_3))).xyz;
  tmpvar_1 = tmpvar_4;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPOSITION","BLEND_MULTIPLY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_2;
  tmpvar_2 = (tmpvar_1 * xlv_TEXCOORD2);
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = (vec4(1.0, 1.0, 1.0, 1.0) - ((_Opacity * tmpvar_2.w) * (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_2))).xyz;
  _glesFragData[0] = tmpvar_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPOSITION","BLEND_MULTIPLY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_3;
  tmpvar_3 = (tmpvar_2 * xlv_TEXCOORD2);
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = (vec4(1.0, 1.0, 1.0, 1.0) - ((_Opacity * tmpvar_3.w) * (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_3))).xyz;
  tmpvar_1 = tmpvar_4;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","AXIS","BLEND_MULTIPLY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_2;
  tmpvar_2 = (tmpvar_1 * xlv_TEXCOORD2);
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = (vec4(1.0, 1.0, 1.0, 1.0) - ((_Opacity * tmpvar_2.w) * (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_2))).xyz;
  _glesFragData[0] = tmpvar_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"AXIS","BLEND_MULTIPLY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_3;
  tmpvar_3 = (tmpvar_2 * xlv_TEXCOORD2);
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = (vec4(1.0, 1.0, 1.0, 1.0) - ((_Opacity * tmpvar_3.w) * (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_3))).xyz;
  tmpvar_1 = tmpvar_4;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VELOCITY","BLEND_MULTIPLY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_2;
  tmpvar_2 = (tmpvar_1 * xlv_TEXCOORD2);
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = (vec4(1.0, 1.0, 1.0, 1.0) - ((_Opacity * tmpvar_2.w) * (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_2))).xyz;
  _glesFragData[0] = tmpvar_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VELOCITY","BLEND_MULTIPLY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_3;
  tmpvar_3 = (tmpvar_2 * xlv_TEXCOORD2);
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = (vec4(1.0, 1.0, 1.0, 1.0) - ((_Opacity * tmpvar_3.w) * (vec4(1.0, 1.0, 1.0, 1.0) - tmpvar_3))).xyz;
  tmpvar_1 = tmpvar_4;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPLANE","BLEND_SCREEN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_2;
  tmpvar_2 = (tmpvar_1 * xlv_TEXCOORD2);
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = ((_Opacity * tmpvar_2.w) * tmpvar_2).xyz;
  _glesFragData[0] = tmpvar_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPLANE","BLEND_SCREEN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_3;
  tmpvar_3 = (tmpvar_2 * xlv_TEXCOORD2);
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = ((_Opacity * tmpvar_3.w) * tmpvar_3).xyz;
  tmpvar_1 = tmpvar_4;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPOSITION","BLEND_SCREEN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_2;
  tmpvar_2 = (tmpvar_1 * xlv_TEXCOORD2);
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = ((_Opacity * tmpvar_2.w) * tmpvar_2).xyz;
  _glesFragData[0] = tmpvar_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPOSITION","BLEND_SCREEN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_3;
  tmpvar_3 = (tmpvar_2 * xlv_TEXCOORD2);
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = ((_Opacity * tmpvar_3.w) * tmpvar_3).xyz;
  tmpvar_1 = tmpvar_4;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","AXIS","BLEND_SCREEN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_2;
  tmpvar_2 = (tmpvar_1 * xlv_TEXCOORD2);
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = ((_Opacity * tmpvar_2.w) * tmpvar_2).xyz;
  _glesFragData[0] = tmpvar_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"AXIS","BLEND_SCREEN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_3;
  tmpvar_3 = (tmpvar_2 * xlv_TEXCOORD2);
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = ((_Opacity * tmpvar_3.w) * tmpvar_3).xyz;
  tmpvar_1 = tmpvar_4;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VELOCITY","BLEND_SCREEN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_2;
  tmpvar_2 = (tmpvar_1 * xlv_TEXCOORD2);
  highp vec4 tmpvar_3;
  tmpvar_3.w = 1.0;
  tmpvar_3.xyz = ((_Opacity * tmpvar_2.w) * tmpvar_2).xyz;
  _glesFragData[0] = tmpvar_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VELOCITY","BLEND_SCREEN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_3;
  tmpvar_3 = (tmpvar_2 * xlv_TEXCOORD2);
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = ((_Opacity * tmpvar_3.w) * tmpvar_3).xyz;
  tmpvar_1 = tmpvar_4;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPLANE","BLEND_HUE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp vec3 rgb_7;
  rgb_7 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_8;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_9;
    tmpvar_9.zw = vec2(-1.0, 0.6666667);
    tmpvar_9.xy = rgb_7.zy;
    tmpvar_8 = tmpvar_9;
  } else {
    highp vec4 tmpvar_10;
    tmpvar_10.zw = vec2(0.0, -0.3333333);
    tmpvar_10.xy = rgb_7.yz;
    tmpvar_8 = tmpvar_10;
  };
  highp vec4 tmpvar_11;
  if ((xlt_fbColor_1.x < tmpvar_8.x)) {
    highp vec4 tmpvar_12;
    tmpvar_12.xyz = tmpvar_8.xyw;
    tmpvar_12.w = rgb_7.x;
    tmpvar_11 = tmpvar_12;
  } else {
    highp vec4 tmpvar_13;
    tmpvar_13.x = rgb_7.x;
    tmpvar_13.yzw = tmpvar_8.yzx;
    tmpvar_11 = tmpvar_13;
  };
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_11.x - min (tmpvar_11.w, tmpvar_11.y));
  highp vec3 tmpvar_15;
  tmpvar_15.x = abs(((
    (tmpvar_11.w - tmpvar_11.y)
   / 
    ((6.0 * tmpvar_14) + 1e-7)
  ) + tmpvar_11.z));
  tmpvar_15.y = tmpvar_14;
  tmpvar_15.z = tmpvar_11.x;
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_11.x - (tmpvar_14 * 0.5));
  highp vec3 tmpvar_17;
  tmpvar_17.x = tmpvar_15.x;
  tmpvar_17.y = (tmpvar_14 / ((1.0 - 
    abs(((2.0 * tmpvar_16) - 1.0))
  ) + 1e-7));
  tmpvar_17.z = tmpvar_16;
  highp vec3 rgb_18;
  rgb_18 = tmpvar_5.xyz;
  highp vec4 tmpvar_19;
  if ((tmpvar_5.y < tmpvar_5.z)) {
    highp vec4 tmpvar_20;
    tmpvar_20.zw = vec2(-1.0, 0.6666667);
    tmpvar_20.xy = rgb_18.zy;
    tmpvar_19 = tmpvar_20;
  } else {
    highp vec4 tmpvar_21;
    tmpvar_21.zw = vec2(0.0, -0.3333333);
    tmpvar_21.xy = rgb_18.yz;
    tmpvar_19 = tmpvar_21;
  };
  highp vec4 tmpvar_22;
  if ((tmpvar_5.x < tmpvar_19.x)) {
    highp vec4 tmpvar_23;
    tmpvar_23.xyz = tmpvar_19.xyw;
    tmpvar_23.w = rgb_18.x;
    tmpvar_22 = tmpvar_23;
  } else {
    highp vec4 tmpvar_24;
    tmpvar_24.x = rgb_18.x;
    tmpvar_24.yzw = tmpvar_19.yzx;
    tmpvar_22 = tmpvar_24;
  };
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_22.x - min (tmpvar_22.w, tmpvar_22.y));
  highp vec3 tmpvar_26;
  tmpvar_26.x = abs(((
    (tmpvar_22.w - tmpvar_22.y)
   / 
    ((6.0 * tmpvar_25) + 1e-7)
  ) + tmpvar_22.z));
  tmpvar_26.y = tmpvar_25;
  tmpvar_26.z = tmpvar_22.x;
  highp vec3 tmpvar_27;
  tmpvar_27.x = (abs((
    (6.0 * tmpvar_26.x)
   - 3.0)) - 1.0);
  tmpvar_27.y = (2.0 - abs((
    (6.0 * tmpvar_26.x)
   - 2.0)));
  tmpvar_27.z = (2.0 - abs((
    (6.0 * tmpvar_26.x)
   - 4.0)));
  resultColor_3.xyz = (((
    clamp (tmpvar_27, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_16) - 1.0)))
   * tmpvar_17.y)) + tmpvar_16);
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPLANE","BLEND_HUE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 rgb_9;
  rgb_9 = srcColor_6.xyz;
  highp vec4 tmpvar_10;
  if ((srcColor_6.y < srcColor_6.z)) {
    highp vec4 tmpvar_11;
    tmpvar_11.zw = vec2(-1.0, 0.6666667);
    tmpvar_11.xy = rgb_9.zy;
    tmpvar_10 = tmpvar_11;
  } else {
    highp vec4 tmpvar_12;
    tmpvar_12.zw = vec2(0.0, -0.3333333);
    tmpvar_12.xy = rgb_9.yz;
    tmpvar_10 = tmpvar_12;
  };
  highp vec4 tmpvar_13;
  if ((srcColor_6.x < tmpvar_10.x)) {
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = tmpvar_10.xyw;
    tmpvar_14.w = rgb_9.x;
    tmpvar_13 = tmpvar_14;
  } else {
    highp vec4 tmpvar_15;
    tmpvar_15.x = rgb_9.x;
    tmpvar_15.yzw = tmpvar_10.yzx;
    tmpvar_13 = tmpvar_15;
  };
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_13.x - min (tmpvar_13.w, tmpvar_13.y));
  highp vec3 tmpvar_17;
  tmpvar_17.x = abs(((
    (tmpvar_13.w - tmpvar_13.y)
   / 
    ((6.0 * tmpvar_16) + 1e-7)
  ) + tmpvar_13.z));
  tmpvar_17.y = tmpvar_16;
  tmpvar_17.z = tmpvar_13.x;
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_13.x - (tmpvar_16 * 0.5));
  highp vec3 tmpvar_19;
  tmpvar_19.x = tmpvar_17.x;
  tmpvar_19.y = (tmpvar_16 / ((1.0 - 
    abs(((2.0 * tmpvar_18) - 1.0))
  ) + 1e-7));
  tmpvar_19.z = tmpvar_18;
  highp vec3 rgb_20;
  rgb_20 = tmpvar_4.xyz;
  highp vec4 tmpvar_21;
  if ((tmpvar_4.y < tmpvar_4.z)) {
    highp vec4 tmpvar_22;
    tmpvar_22.zw = vec2(-1.0, 0.6666667);
    tmpvar_22.xy = rgb_20.zy;
    tmpvar_21 = tmpvar_22;
  } else {
    highp vec4 tmpvar_23;
    tmpvar_23.zw = vec2(0.0, -0.3333333);
    tmpvar_23.xy = rgb_20.yz;
    tmpvar_21 = tmpvar_23;
  };
  highp vec4 tmpvar_24;
  if ((tmpvar_4.x < tmpvar_21.x)) {
    highp vec4 tmpvar_25;
    tmpvar_25.xyz = tmpvar_21.xyw;
    tmpvar_25.w = rgb_20.x;
    tmpvar_24 = tmpvar_25;
  } else {
    highp vec4 tmpvar_26;
    tmpvar_26.x = rgb_20.x;
    tmpvar_26.yzw = tmpvar_21.yzx;
    tmpvar_24 = tmpvar_26;
  };
  highp float tmpvar_27;
  tmpvar_27 = (tmpvar_24.x - min (tmpvar_24.w, tmpvar_24.y));
  highp vec3 tmpvar_28;
  tmpvar_28.x = abs(((
    (tmpvar_24.w - tmpvar_24.y)
   / 
    ((6.0 * tmpvar_27) + 1e-7)
  ) + tmpvar_24.z));
  tmpvar_28.y = tmpvar_27;
  tmpvar_28.z = tmpvar_24.x;
  highp vec3 tmpvar_29;
  tmpvar_29.x = (abs((
    (6.0 * tmpvar_28.x)
   - 3.0)) - 1.0);
  tmpvar_29.y = (2.0 - abs((
    (6.0 * tmpvar_28.x)
   - 2.0)));
  tmpvar_29.z = (2.0 - abs((
    (6.0 * tmpvar_28.x)
   - 4.0)));
  resultColor_2.xyz = (((
    clamp (tmpvar_29, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_18) - 1.0)))
   * tmpvar_19.y)) + tmpvar_18);
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPOSITION","BLEND_HUE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp vec3 rgb_7;
  rgb_7 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_8;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_9;
    tmpvar_9.zw = vec2(-1.0, 0.6666667);
    tmpvar_9.xy = rgb_7.zy;
    tmpvar_8 = tmpvar_9;
  } else {
    highp vec4 tmpvar_10;
    tmpvar_10.zw = vec2(0.0, -0.3333333);
    tmpvar_10.xy = rgb_7.yz;
    tmpvar_8 = tmpvar_10;
  };
  highp vec4 tmpvar_11;
  if ((xlt_fbColor_1.x < tmpvar_8.x)) {
    highp vec4 tmpvar_12;
    tmpvar_12.xyz = tmpvar_8.xyw;
    tmpvar_12.w = rgb_7.x;
    tmpvar_11 = tmpvar_12;
  } else {
    highp vec4 tmpvar_13;
    tmpvar_13.x = rgb_7.x;
    tmpvar_13.yzw = tmpvar_8.yzx;
    tmpvar_11 = tmpvar_13;
  };
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_11.x - min (tmpvar_11.w, tmpvar_11.y));
  highp vec3 tmpvar_15;
  tmpvar_15.x = abs(((
    (tmpvar_11.w - tmpvar_11.y)
   / 
    ((6.0 * tmpvar_14) + 1e-7)
  ) + tmpvar_11.z));
  tmpvar_15.y = tmpvar_14;
  tmpvar_15.z = tmpvar_11.x;
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_11.x - (tmpvar_14 * 0.5));
  highp vec3 tmpvar_17;
  tmpvar_17.x = tmpvar_15.x;
  tmpvar_17.y = (tmpvar_14 / ((1.0 - 
    abs(((2.0 * tmpvar_16) - 1.0))
  ) + 1e-7));
  tmpvar_17.z = tmpvar_16;
  highp vec3 rgb_18;
  rgb_18 = tmpvar_5.xyz;
  highp vec4 tmpvar_19;
  if ((tmpvar_5.y < tmpvar_5.z)) {
    highp vec4 tmpvar_20;
    tmpvar_20.zw = vec2(-1.0, 0.6666667);
    tmpvar_20.xy = rgb_18.zy;
    tmpvar_19 = tmpvar_20;
  } else {
    highp vec4 tmpvar_21;
    tmpvar_21.zw = vec2(0.0, -0.3333333);
    tmpvar_21.xy = rgb_18.yz;
    tmpvar_19 = tmpvar_21;
  };
  highp vec4 tmpvar_22;
  if ((tmpvar_5.x < tmpvar_19.x)) {
    highp vec4 tmpvar_23;
    tmpvar_23.xyz = tmpvar_19.xyw;
    tmpvar_23.w = rgb_18.x;
    tmpvar_22 = tmpvar_23;
  } else {
    highp vec4 tmpvar_24;
    tmpvar_24.x = rgb_18.x;
    tmpvar_24.yzw = tmpvar_19.yzx;
    tmpvar_22 = tmpvar_24;
  };
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_22.x - min (tmpvar_22.w, tmpvar_22.y));
  highp vec3 tmpvar_26;
  tmpvar_26.x = abs(((
    (tmpvar_22.w - tmpvar_22.y)
   / 
    ((6.0 * tmpvar_25) + 1e-7)
  ) + tmpvar_22.z));
  tmpvar_26.y = tmpvar_25;
  tmpvar_26.z = tmpvar_22.x;
  highp vec3 tmpvar_27;
  tmpvar_27.x = (abs((
    (6.0 * tmpvar_26.x)
   - 3.0)) - 1.0);
  tmpvar_27.y = (2.0 - abs((
    (6.0 * tmpvar_26.x)
   - 2.0)));
  tmpvar_27.z = (2.0 - abs((
    (6.0 * tmpvar_26.x)
   - 4.0)));
  resultColor_3.xyz = (((
    clamp (tmpvar_27, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_16) - 1.0)))
   * tmpvar_17.y)) + tmpvar_16);
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPOSITION","BLEND_HUE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 rgb_9;
  rgb_9 = srcColor_6.xyz;
  highp vec4 tmpvar_10;
  if ((srcColor_6.y < srcColor_6.z)) {
    highp vec4 tmpvar_11;
    tmpvar_11.zw = vec2(-1.0, 0.6666667);
    tmpvar_11.xy = rgb_9.zy;
    tmpvar_10 = tmpvar_11;
  } else {
    highp vec4 tmpvar_12;
    tmpvar_12.zw = vec2(0.0, -0.3333333);
    tmpvar_12.xy = rgb_9.yz;
    tmpvar_10 = tmpvar_12;
  };
  highp vec4 tmpvar_13;
  if ((srcColor_6.x < tmpvar_10.x)) {
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = tmpvar_10.xyw;
    tmpvar_14.w = rgb_9.x;
    tmpvar_13 = tmpvar_14;
  } else {
    highp vec4 tmpvar_15;
    tmpvar_15.x = rgb_9.x;
    tmpvar_15.yzw = tmpvar_10.yzx;
    tmpvar_13 = tmpvar_15;
  };
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_13.x - min (tmpvar_13.w, tmpvar_13.y));
  highp vec3 tmpvar_17;
  tmpvar_17.x = abs(((
    (tmpvar_13.w - tmpvar_13.y)
   / 
    ((6.0 * tmpvar_16) + 1e-7)
  ) + tmpvar_13.z));
  tmpvar_17.y = tmpvar_16;
  tmpvar_17.z = tmpvar_13.x;
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_13.x - (tmpvar_16 * 0.5));
  highp vec3 tmpvar_19;
  tmpvar_19.x = tmpvar_17.x;
  tmpvar_19.y = (tmpvar_16 / ((1.0 - 
    abs(((2.0 * tmpvar_18) - 1.0))
  ) + 1e-7));
  tmpvar_19.z = tmpvar_18;
  highp vec3 rgb_20;
  rgb_20 = tmpvar_4.xyz;
  highp vec4 tmpvar_21;
  if ((tmpvar_4.y < tmpvar_4.z)) {
    highp vec4 tmpvar_22;
    tmpvar_22.zw = vec2(-1.0, 0.6666667);
    tmpvar_22.xy = rgb_20.zy;
    tmpvar_21 = tmpvar_22;
  } else {
    highp vec4 tmpvar_23;
    tmpvar_23.zw = vec2(0.0, -0.3333333);
    tmpvar_23.xy = rgb_20.yz;
    tmpvar_21 = tmpvar_23;
  };
  highp vec4 tmpvar_24;
  if ((tmpvar_4.x < tmpvar_21.x)) {
    highp vec4 tmpvar_25;
    tmpvar_25.xyz = tmpvar_21.xyw;
    tmpvar_25.w = rgb_20.x;
    tmpvar_24 = tmpvar_25;
  } else {
    highp vec4 tmpvar_26;
    tmpvar_26.x = rgb_20.x;
    tmpvar_26.yzw = tmpvar_21.yzx;
    tmpvar_24 = tmpvar_26;
  };
  highp float tmpvar_27;
  tmpvar_27 = (tmpvar_24.x - min (tmpvar_24.w, tmpvar_24.y));
  highp vec3 tmpvar_28;
  tmpvar_28.x = abs(((
    (tmpvar_24.w - tmpvar_24.y)
   / 
    ((6.0 * tmpvar_27) + 1e-7)
  ) + tmpvar_24.z));
  tmpvar_28.y = tmpvar_27;
  tmpvar_28.z = tmpvar_24.x;
  highp vec3 tmpvar_29;
  tmpvar_29.x = (abs((
    (6.0 * tmpvar_28.x)
   - 3.0)) - 1.0);
  tmpvar_29.y = (2.0 - abs((
    (6.0 * tmpvar_28.x)
   - 2.0)));
  tmpvar_29.z = (2.0 - abs((
    (6.0 * tmpvar_28.x)
   - 4.0)));
  resultColor_2.xyz = (((
    clamp (tmpvar_29, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_18) - 1.0)))
   * tmpvar_19.y)) + tmpvar_18);
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","AXIS","BLEND_HUE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp vec3 rgb_7;
  rgb_7 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_8;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_9;
    tmpvar_9.zw = vec2(-1.0, 0.6666667);
    tmpvar_9.xy = rgb_7.zy;
    tmpvar_8 = tmpvar_9;
  } else {
    highp vec4 tmpvar_10;
    tmpvar_10.zw = vec2(0.0, -0.3333333);
    tmpvar_10.xy = rgb_7.yz;
    tmpvar_8 = tmpvar_10;
  };
  highp vec4 tmpvar_11;
  if ((xlt_fbColor_1.x < tmpvar_8.x)) {
    highp vec4 tmpvar_12;
    tmpvar_12.xyz = tmpvar_8.xyw;
    tmpvar_12.w = rgb_7.x;
    tmpvar_11 = tmpvar_12;
  } else {
    highp vec4 tmpvar_13;
    tmpvar_13.x = rgb_7.x;
    tmpvar_13.yzw = tmpvar_8.yzx;
    tmpvar_11 = tmpvar_13;
  };
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_11.x - min (tmpvar_11.w, tmpvar_11.y));
  highp vec3 tmpvar_15;
  tmpvar_15.x = abs(((
    (tmpvar_11.w - tmpvar_11.y)
   / 
    ((6.0 * tmpvar_14) + 1e-7)
  ) + tmpvar_11.z));
  tmpvar_15.y = tmpvar_14;
  tmpvar_15.z = tmpvar_11.x;
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_11.x - (tmpvar_14 * 0.5));
  highp vec3 tmpvar_17;
  tmpvar_17.x = tmpvar_15.x;
  tmpvar_17.y = (tmpvar_14 / ((1.0 - 
    abs(((2.0 * tmpvar_16) - 1.0))
  ) + 1e-7));
  tmpvar_17.z = tmpvar_16;
  highp vec3 rgb_18;
  rgb_18 = tmpvar_5.xyz;
  highp vec4 tmpvar_19;
  if ((tmpvar_5.y < tmpvar_5.z)) {
    highp vec4 tmpvar_20;
    tmpvar_20.zw = vec2(-1.0, 0.6666667);
    tmpvar_20.xy = rgb_18.zy;
    tmpvar_19 = tmpvar_20;
  } else {
    highp vec4 tmpvar_21;
    tmpvar_21.zw = vec2(0.0, -0.3333333);
    tmpvar_21.xy = rgb_18.yz;
    tmpvar_19 = tmpvar_21;
  };
  highp vec4 tmpvar_22;
  if ((tmpvar_5.x < tmpvar_19.x)) {
    highp vec4 tmpvar_23;
    tmpvar_23.xyz = tmpvar_19.xyw;
    tmpvar_23.w = rgb_18.x;
    tmpvar_22 = tmpvar_23;
  } else {
    highp vec4 tmpvar_24;
    tmpvar_24.x = rgb_18.x;
    tmpvar_24.yzw = tmpvar_19.yzx;
    tmpvar_22 = tmpvar_24;
  };
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_22.x - min (tmpvar_22.w, tmpvar_22.y));
  highp vec3 tmpvar_26;
  tmpvar_26.x = abs(((
    (tmpvar_22.w - tmpvar_22.y)
   / 
    ((6.0 * tmpvar_25) + 1e-7)
  ) + tmpvar_22.z));
  tmpvar_26.y = tmpvar_25;
  tmpvar_26.z = tmpvar_22.x;
  highp vec3 tmpvar_27;
  tmpvar_27.x = (abs((
    (6.0 * tmpvar_26.x)
   - 3.0)) - 1.0);
  tmpvar_27.y = (2.0 - abs((
    (6.0 * tmpvar_26.x)
   - 2.0)));
  tmpvar_27.z = (2.0 - abs((
    (6.0 * tmpvar_26.x)
   - 4.0)));
  resultColor_3.xyz = (((
    clamp (tmpvar_27, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_16) - 1.0)))
   * tmpvar_17.y)) + tmpvar_16);
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"AXIS","BLEND_HUE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 rgb_9;
  rgb_9 = srcColor_6.xyz;
  highp vec4 tmpvar_10;
  if ((srcColor_6.y < srcColor_6.z)) {
    highp vec4 tmpvar_11;
    tmpvar_11.zw = vec2(-1.0, 0.6666667);
    tmpvar_11.xy = rgb_9.zy;
    tmpvar_10 = tmpvar_11;
  } else {
    highp vec4 tmpvar_12;
    tmpvar_12.zw = vec2(0.0, -0.3333333);
    tmpvar_12.xy = rgb_9.yz;
    tmpvar_10 = tmpvar_12;
  };
  highp vec4 tmpvar_13;
  if ((srcColor_6.x < tmpvar_10.x)) {
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = tmpvar_10.xyw;
    tmpvar_14.w = rgb_9.x;
    tmpvar_13 = tmpvar_14;
  } else {
    highp vec4 tmpvar_15;
    tmpvar_15.x = rgb_9.x;
    tmpvar_15.yzw = tmpvar_10.yzx;
    tmpvar_13 = tmpvar_15;
  };
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_13.x - min (tmpvar_13.w, tmpvar_13.y));
  highp vec3 tmpvar_17;
  tmpvar_17.x = abs(((
    (tmpvar_13.w - tmpvar_13.y)
   / 
    ((6.0 * tmpvar_16) + 1e-7)
  ) + tmpvar_13.z));
  tmpvar_17.y = tmpvar_16;
  tmpvar_17.z = tmpvar_13.x;
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_13.x - (tmpvar_16 * 0.5));
  highp vec3 tmpvar_19;
  tmpvar_19.x = tmpvar_17.x;
  tmpvar_19.y = (tmpvar_16 / ((1.0 - 
    abs(((2.0 * tmpvar_18) - 1.0))
  ) + 1e-7));
  tmpvar_19.z = tmpvar_18;
  highp vec3 rgb_20;
  rgb_20 = tmpvar_4.xyz;
  highp vec4 tmpvar_21;
  if ((tmpvar_4.y < tmpvar_4.z)) {
    highp vec4 tmpvar_22;
    tmpvar_22.zw = vec2(-1.0, 0.6666667);
    tmpvar_22.xy = rgb_20.zy;
    tmpvar_21 = tmpvar_22;
  } else {
    highp vec4 tmpvar_23;
    tmpvar_23.zw = vec2(0.0, -0.3333333);
    tmpvar_23.xy = rgb_20.yz;
    tmpvar_21 = tmpvar_23;
  };
  highp vec4 tmpvar_24;
  if ((tmpvar_4.x < tmpvar_21.x)) {
    highp vec4 tmpvar_25;
    tmpvar_25.xyz = tmpvar_21.xyw;
    tmpvar_25.w = rgb_20.x;
    tmpvar_24 = tmpvar_25;
  } else {
    highp vec4 tmpvar_26;
    tmpvar_26.x = rgb_20.x;
    tmpvar_26.yzw = tmpvar_21.yzx;
    tmpvar_24 = tmpvar_26;
  };
  highp float tmpvar_27;
  tmpvar_27 = (tmpvar_24.x - min (tmpvar_24.w, tmpvar_24.y));
  highp vec3 tmpvar_28;
  tmpvar_28.x = abs(((
    (tmpvar_24.w - tmpvar_24.y)
   / 
    ((6.0 * tmpvar_27) + 1e-7)
  ) + tmpvar_24.z));
  tmpvar_28.y = tmpvar_27;
  tmpvar_28.z = tmpvar_24.x;
  highp vec3 tmpvar_29;
  tmpvar_29.x = (abs((
    (6.0 * tmpvar_28.x)
   - 3.0)) - 1.0);
  tmpvar_29.y = (2.0 - abs((
    (6.0 * tmpvar_28.x)
   - 2.0)));
  tmpvar_29.z = (2.0 - abs((
    (6.0 * tmpvar_28.x)
   - 4.0)));
  resultColor_2.xyz = (((
    clamp (tmpvar_29, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_18) - 1.0)))
   * tmpvar_19.y)) + tmpvar_18);
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VELOCITY","BLEND_HUE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp vec3 rgb_7;
  rgb_7 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_8;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_9;
    tmpvar_9.zw = vec2(-1.0, 0.6666667);
    tmpvar_9.xy = rgb_7.zy;
    tmpvar_8 = tmpvar_9;
  } else {
    highp vec4 tmpvar_10;
    tmpvar_10.zw = vec2(0.0, -0.3333333);
    tmpvar_10.xy = rgb_7.yz;
    tmpvar_8 = tmpvar_10;
  };
  highp vec4 tmpvar_11;
  if ((xlt_fbColor_1.x < tmpvar_8.x)) {
    highp vec4 tmpvar_12;
    tmpvar_12.xyz = tmpvar_8.xyw;
    tmpvar_12.w = rgb_7.x;
    tmpvar_11 = tmpvar_12;
  } else {
    highp vec4 tmpvar_13;
    tmpvar_13.x = rgb_7.x;
    tmpvar_13.yzw = tmpvar_8.yzx;
    tmpvar_11 = tmpvar_13;
  };
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_11.x - min (tmpvar_11.w, tmpvar_11.y));
  highp vec3 tmpvar_15;
  tmpvar_15.x = abs(((
    (tmpvar_11.w - tmpvar_11.y)
   / 
    ((6.0 * tmpvar_14) + 1e-7)
  ) + tmpvar_11.z));
  tmpvar_15.y = tmpvar_14;
  tmpvar_15.z = tmpvar_11.x;
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_11.x - (tmpvar_14 * 0.5));
  highp vec3 tmpvar_17;
  tmpvar_17.x = tmpvar_15.x;
  tmpvar_17.y = (tmpvar_14 / ((1.0 - 
    abs(((2.0 * tmpvar_16) - 1.0))
  ) + 1e-7));
  tmpvar_17.z = tmpvar_16;
  highp vec3 rgb_18;
  rgb_18 = tmpvar_5.xyz;
  highp vec4 tmpvar_19;
  if ((tmpvar_5.y < tmpvar_5.z)) {
    highp vec4 tmpvar_20;
    tmpvar_20.zw = vec2(-1.0, 0.6666667);
    tmpvar_20.xy = rgb_18.zy;
    tmpvar_19 = tmpvar_20;
  } else {
    highp vec4 tmpvar_21;
    tmpvar_21.zw = vec2(0.0, -0.3333333);
    tmpvar_21.xy = rgb_18.yz;
    tmpvar_19 = tmpvar_21;
  };
  highp vec4 tmpvar_22;
  if ((tmpvar_5.x < tmpvar_19.x)) {
    highp vec4 tmpvar_23;
    tmpvar_23.xyz = tmpvar_19.xyw;
    tmpvar_23.w = rgb_18.x;
    tmpvar_22 = tmpvar_23;
  } else {
    highp vec4 tmpvar_24;
    tmpvar_24.x = rgb_18.x;
    tmpvar_24.yzw = tmpvar_19.yzx;
    tmpvar_22 = tmpvar_24;
  };
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_22.x - min (tmpvar_22.w, tmpvar_22.y));
  highp vec3 tmpvar_26;
  tmpvar_26.x = abs(((
    (tmpvar_22.w - tmpvar_22.y)
   / 
    ((6.0 * tmpvar_25) + 1e-7)
  ) + tmpvar_22.z));
  tmpvar_26.y = tmpvar_25;
  tmpvar_26.z = tmpvar_22.x;
  highp vec3 tmpvar_27;
  tmpvar_27.x = (abs((
    (6.0 * tmpvar_26.x)
   - 3.0)) - 1.0);
  tmpvar_27.y = (2.0 - abs((
    (6.0 * tmpvar_26.x)
   - 2.0)));
  tmpvar_27.z = (2.0 - abs((
    (6.0 * tmpvar_26.x)
   - 4.0)));
  resultColor_3.xyz = (((
    clamp (tmpvar_27, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_16) - 1.0)))
   * tmpvar_17.y)) + tmpvar_16);
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VELOCITY","BLEND_HUE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 rgb_9;
  rgb_9 = srcColor_6.xyz;
  highp vec4 tmpvar_10;
  if ((srcColor_6.y < srcColor_6.z)) {
    highp vec4 tmpvar_11;
    tmpvar_11.zw = vec2(-1.0, 0.6666667);
    tmpvar_11.xy = rgb_9.zy;
    tmpvar_10 = tmpvar_11;
  } else {
    highp vec4 tmpvar_12;
    tmpvar_12.zw = vec2(0.0, -0.3333333);
    tmpvar_12.xy = rgb_9.yz;
    tmpvar_10 = tmpvar_12;
  };
  highp vec4 tmpvar_13;
  if ((srcColor_6.x < tmpvar_10.x)) {
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = tmpvar_10.xyw;
    tmpvar_14.w = rgb_9.x;
    tmpvar_13 = tmpvar_14;
  } else {
    highp vec4 tmpvar_15;
    tmpvar_15.x = rgb_9.x;
    tmpvar_15.yzw = tmpvar_10.yzx;
    tmpvar_13 = tmpvar_15;
  };
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_13.x - min (tmpvar_13.w, tmpvar_13.y));
  highp vec3 tmpvar_17;
  tmpvar_17.x = abs(((
    (tmpvar_13.w - tmpvar_13.y)
   / 
    ((6.0 * tmpvar_16) + 1e-7)
  ) + tmpvar_13.z));
  tmpvar_17.y = tmpvar_16;
  tmpvar_17.z = tmpvar_13.x;
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_13.x - (tmpvar_16 * 0.5));
  highp vec3 tmpvar_19;
  tmpvar_19.x = tmpvar_17.x;
  tmpvar_19.y = (tmpvar_16 / ((1.0 - 
    abs(((2.0 * tmpvar_18) - 1.0))
  ) + 1e-7));
  tmpvar_19.z = tmpvar_18;
  highp vec3 rgb_20;
  rgb_20 = tmpvar_4.xyz;
  highp vec4 tmpvar_21;
  if ((tmpvar_4.y < tmpvar_4.z)) {
    highp vec4 tmpvar_22;
    tmpvar_22.zw = vec2(-1.0, 0.6666667);
    tmpvar_22.xy = rgb_20.zy;
    tmpvar_21 = tmpvar_22;
  } else {
    highp vec4 tmpvar_23;
    tmpvar_23.zw = vec2(0.0, -0.3333333);
    tmpvar_23.xy = rgb_20.yz;
    tmpvar_21 = tmpvar_23;
  };
  highp vec4 tmpvar_24;
  if ((tmpvar_4.x < tmpvar_21.x)) {
    highp vec4 tmpvar_25;
    tmpvar_25.xyz = tmpvar_21.xyw;
    tmpvar_25.w = rgb_20.x;
    tmpvar_24 = tmpvar_25;
  } else {
    highp vec4 tmpvar_26;
    tmpvar_26.x = rgb_20.x;
    tmpvar_26.yzw = tmpvar_21.yzx;
    tmpvar_24 = tmpvar_26;
  };
  highp float tmpvar_27;
  tmpvar_27 = (tmpvar_24.x - min (tmpvar_24.w, tmpvar_24.y));
  highp vec3 tmpvar_28;
  tmpvar_28.x = abs(((
    (tmpvar_24.w - tmpvar_24.y)
   / 
    ((6.0 * tmpvar_27) + 1e-7)
  ) + tmpvar_24.z));
  tmpvar_28.y = tmpvar_27;
  tmpvar_28.z = tmpvar_24.x;
  highp vec3 tmpvar_29;
  tmpvar_29.x = (abs((
    (6.0 * tmpvar_28.x)
   - 3.0)) - 1.0);
  tmpvar_29.y = (2.0 - abs((
    (6.0 * tmpvar_28.x)
   - 2.0)));
  tmpvar_29.z = (2.0 - abs((
    (6.0 * tmpvar_28.x)
   - 4.0)));
  resultColor_2.xyz = (((
    clamp (tmpvar_29, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_18) - 1.0)))
   * tmpvar_19.y)) + tmpvar_18);
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPLANE","BLEND_SATURATION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp vec3 rgb_7;
  rgb_7 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_8;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_9;
    tmpvar_9.zw = vec2(-1.0, 0.6666667);
    tmpvar_9.xy = rgb_7.zy;
    tmpvar_8 = tmpvar_9;
  } else {
    highp vec4 tmpvar_10;
    tmpvar_10.zw = vec2(0.0, -0.3333333);
    tmpvar_10.xy = rgb_7.yz;
    tmpvar_8 = tmpvar_10;
  };
  highp vec4 tmpvar_11;
  if ((xlt_fbColor_1.x < tmpvar_8.x)) {
    highp vec4 tmpvar_12;
    tmpvar_12.xyz = tmpvar_8.xyw;
    tmpvar_12.w = rgb_7.x;
    tmpvar_11 = tmpvar_12;
  } else {
    highp vec4 tmpvar_13;
    tmpvar_13.x = rgb_7.x;
    tmpvar_13.yzw = tmpvar_8.yzx;
    tmpvar_11 = tmpvar_13;
  };
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_11.x - min (tmpvar_11.w, tmpvar_11.y));
  highp vec3 tmpvar_15;
  tmpvar_15.x = abs(((
    (tmpvar_11.w - tmpvar_11.y)
   / 
    ((6.0 * tmpvar_14) + 1e-7)
  ) + tmpvar_11.z));
  tmpvar_15.y = tmpvar_14;
  tmpvar_15.z = tmpvar_11.x;
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_11.x - (tmpvar_14 * 0.5));
  highp vec3 rgb_17;
  rgb_17 = tmpvar_5.xyz;
  highp vec4 tmpvar_18;
  if ((tmpvar_5.y < tmpvar_5.z)) {
    highp vec4 tmpvar_19;
    tmpvar_19.zw = vec2(-1.0, 0.6666667);
    tmpvar_19.xy = rgb_17.zy;
    tmpvar_18 = tmpvar_19;
  } else {
    highp vec4 tmpvar_20;
    tmpvar_20.zw = vec2(0.0, -0.3333333);
    tmpvar_20.xy = rgb_17.yz;
    tmpvar_18 = tmpvar_20;
  };
  highp vec4 tmpvar_21;
  if ((tmpvar_5.x < tmpvar_18.x)) {
    highp vec4 tmpvar_22;
    tmpvar_22.xyz = tmpvar_18.xyw;
    tmpvar_22.w = rgb_17.x;
    tmpvar_21 = tmpvar_22;
  } else {
    highp vec4 tmpvar_23;
    tmpvar_23.x = rgb_17.x;
    tmpvar_23.yzw = tmpvar_18.yzx;
    tmpvar_21 = tmpvar_23;
  };
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_21.x - min (tmpvar_21.w, tmpvar_21.y));
  highp vec3 tmpvar_25;
  tmpvar_25.x = abs(((
    (tmpvar_21.w - tmpvar_21.y)
   / 
    ((6.0 * tmpvar_24) + 1e-7)
  ) + tmpvar_21.z));
  tmpvar_25.y = tmpvar_24;
  tmpvar_25.z = tmpvar_21.x;
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_21.x - (tmpvar_24 * 0.5));
  highp vec3 tmpvar_27;
  tmpvar_27.x = tmpvar_25.x;
  tmpvar_27.y = (tmpvar_24 / ((1.0 - 
    abs(((2.0 * tmpvar_26) - 1.0))
  ) + 1e-7));
  tmpvar_27.z = tmpvar_26;
  highp vec3 tmpvar_28;
  tmpvar_28.x = (abs((
    (6.0 * tmpvar_15.x)
   - 3.0)) - 1.0);
  tmpvar_28.y = (2.0 - abs((
    (6.0 * tmpvar_15.x)
   - 2.0)));
  tmpvar_28.z = (2.0 - abs((
    (6.0 * tmpvar_15.x)
   - 4.0)));
  resultColor_3.xyz = (((
    clamp (tmpvar_28, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_16) - 1.0)))
   * tmpvar_27.y)) + tmpvar_16);
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPLANE","BLEND_SATURATION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 rgb_9;
  rgb_9 = srcColor_6.xyz;
  highp vec4 tmpvar_10;
  if ((srcColor_6.y < srcColor_6.z)) {
    highp vec4 tmpvar_11;
    tmpvar_11.zw = vec2(-1.0, 0.6666667);
    tmpvar_11.xy = rgb_9.zy;
    tmpvar_10 = tmpvar_11;
  } else {
    highp vec4 tmpvar_12;
    tmpvar_12.zw = vec2(0.0, -0.3333333);
    tmpvar_12.xy = rgb_9.yz;
    tmpvar_10 = tmpvar_12;
  };
  highp vec4 tmpvar_13;
  if ((srcColor_6.x < tmpvar_10.x)) {
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = tmpvar_10.xyw;
    tmpvar_14.w = rgb_9.x;
    tmpvar_13 = tmpvar_14;
  } else {
    highp vec4 tmpvar_15;
    tmpvar_15.x = rgb_9.x;
    tmpvar_15.yzw = tmpvar_10.yzx;
    tmpvar_13 = tmpvar_15;
  };
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_13.x - min (tmpvar_13.w, tmpvar_13.y));
  highp vec3 tmpvar_17;
  tmpvar_17.x = abs(((
    (tmpvar_13.w - tmpvar_13.y)
   / 
    ((6.0 * tmpvar_16) + 1e-7)
  ) + tmpvar_13.z));
  tmpvar_17.y = tmpvar_16;
  tmpvar_17.z = tmpvar_13.x;
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_13.x - (tmpvar_16 * 0.5));
  highp vec3 rgb_19;
  rgb_19 = tmpvar_4.xyz;
  highp vec4 tmpvar_20;
  if ((tmpvar_4.y < tmpvar_4.z)) {
    highp vec4 tmpvar_21;
    tmpvar_21.zw = vec2(-1.0, 0.6666667);
    tmpvar_21.xy = rgb_19.zy;
    tmpvar_20 = tmpvar_21;
  } else {
    highp vec4 tmpvar_22;
    tmpvar_22.zw = vec2(0.0, -0.3333333);
    tmpvar_22.xy = rgb_19.yz;
    tmpvar_20 = tmpvar_22;
  };
  highp vec4 tmpvar_23;
  if ((tmpvar_4.x < tmpvar_20.x)) {
    highp vec4 tmpvar_24;
    tmpvar_24.xyz = tmpvar_20.xyw;
    tmpvar_24.w = rgb_19.x;
    tmpvar_23 = tmpvar_24;
  } else {
    highp vec4 tmpvar_25;
    tmpvar_25.x = rgb_19.x;
    tmpvar_25.yzw = tmpvar_20.yzx;
    tmpvar_23 = tmpvar_25;
  };
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_23.x - min (tmpvar_23.w, tmpvar_23.y));
  highp vec3 tmpvar_27;
  tmpvar_27.x = abs(((
    (tmpvar_23.w - tmpvar_23.y)
   / 
    ((6.0 * tmpvar_26) + 1e-7)
  ) + tmpvar_23.z));
  tmpvar_27.y = tmpvar_26;
  tmpvar_27.z = tmpvar_23.x;
  highp float tmpvar_28;
  tmpvar_28 = (tmpvar_23.x - (tmpvar_26 * 0.5));
  highp vec3 tmpvar_29;
  tmpvar_29.x = tmpvar_27.x;
  tmpvar_29.y = (tmpvar_26 / ((1.0 - 
    abs(((2.0 * tmpvar_28) - 1.0))
  ) + 1e-7));
  tmpvar_29.z = tmpvar_28;
  highp vec3 tmpvar_30;
  tmpvar_30.x = (abs((
    (6.0 * tmpvar_17.x)
   - 3.0)) - 1.0);
  tmpvar_30.y = (2.0 - abs((
    (6.0 * tmpvar_17.x)
   - 2.0)));
  tmpvar_30.z = (2.0 - abs((
    (6.0 * tmpvar_17.x)
   - 4.0)));
  resultColor_2.xyz = (((
    clamp (tmpvar_30, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_18) - 1.0)))
   * tmpvar_29.y)) + tmpvar_18);
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPOSITION","BLEND_SATURATION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp vec3 rgb_7;
  rgb_7 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_8;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_9;
    tmpvar_9.zw = vec2(-1.0, 0.6666667);
    tmpvar_9.xy = rgb_7.zy;
    tmpvar_8 = tmpvar_9;
  } else {
    highp vec4 tmpvar_10;
    tmpvar_10.zw = vec2(0.0, -0.3333333);
    tmpvar_10.xy = rgb_7.yz;
    tmpvar_8 = tmpvar_10;
  };
  highp vec4 tmpvar_11;
  if ((xlt_fbColor_1.x < tmpvar_8.x)) {
    highp vec4 tmpvar_12;
    tmpvar_12.xyz = tmpvar_8.xyw;
    tmpvar_12.w = rgb_7.x;
    tmpvar_11 = tmpvar_12;
  } else {
    highp vec4 tmpvar_13;
    tmpvar_13.x = rgb_7.x;
    tmpvar_13.yzw = tmpvar_8.yzx;
    tmpvar_11 = tmpvar_13;
  };
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_11.x - min (tmpvar_11.w, tmpvar_11.y));
  highp vec3 tmpvar_15;
  tmpvar_15.x = abs(((
    (tmpvar_11.w - tmpvar_11.y)
   / 
    ((6.0 * tmpvar_14) + 1e-7)
  ) + tmpvar_11.z));
  tmpvar_15.y = tmpvar_14;
  tmpvar_15.z = tmpvar_11.x;
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_11.x - (tmpvar_14 * 0.5));
  highp vec3 rgb_17;
  rgb_17 = tmpvar_5.xyz;
  highp vec4 tmpvar_18;
  if ((tmpvar_5.y < tmpvar_5.z)) {
    highp vec4 tmpvar_19;
    tmpvar_19.zw = vec2(-1.0, 0.6666667);
    tmpvar_19.xy = rgb_17.zy;
    tmpvar_18 = tmpvar_19;
  } else {
    highp vec4 tmpvar_20;
    tmpvar_20.zw = vec2(0.0, -0.3333333);
    tmpvar_20.xy = rgb_17.yz;
    tmpvar_18 = tmpvar_20;
  };
  highp vec4 tmpvar_21;
  if ((tmpvar_5.x < tmpvar_18.x)) {
    highp vec4 tmpvar_22;
    tmpvar_22.xyz = tmpvar_18.xyw;
    tmpvar_22.w = rgb_17.x;
    tmpvar_21 = tmpvar_22;
  } else {
    highp vec4 tmpvar_23;
    tmpvar_23.x = rgb_17.x;
    tmpvar_23.yzw = tmpvar_18.yzx;
    tmpvar_21 = tmpvar_23;
  };
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_21.x - min (tmpvar_21.w, tmpvar_21.y));
  highp vec3 tmpvar_25;
  tmpvar_25.x = abs(((
    (tmpvar_21.w - tmpvar_21.y)
   / 
    ((6.0 * tmpvar_24) + 1e-7)
  ) + tmpvar_21.z));
  tmpvar_25.y = tmpvar_24;
  tmpvar_25.z = tmpvar_21.x;
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_21.x - (tmpvar_24 * 0.5));
  highp vec3 tmpvar_27;
  tmpvar_27.x = tmpvar_25.x;
  tmpvar_27.y = (tmpvar_24 / ((1.0 - 
    abs(((2.0 * tmpvar_26) - 1.0))
  ) + 1e-7));
  tmpvar_27.z = tmpvar_26;
  highp vec3 tmpvar_28;
  tmpvar_28.x = (abs((
    (6.0 * tmpvar_15.x)
   - 3.0)) - 1.0);
  tmpvar_28.y = (2.0 - abs((
    (6.0 * tmpvar_15.x)
   - 2.0)));
  tmpvar_28.z = (2.0 - abs((
    (6.0 * tmpvar_15.x)
   - 4.0)));
  resultColor_3.xyz = (((
    clamp (tmpvar_28, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_16) - 1.0)))
   * tmpvar_27.y)) + tmpvar_16);
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPOSITION","BLEND_SATURATION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 rgb_9;
  rgb_9 = srcColor_6.xyz;
  highp vec4 tmpvar_10;
  if ((srcColor_6.y < srcColor_6.z)) {
    highp vec4 tmpvar_11;
    tmpvar_11.zw = vec2(-1.0, 0.6666667);
    tmpvar_11.xy = rgb_9.zy;
    tmpvar_10 = tmpvar_11;
  } else {
    highp vec4 tmpvar_12;
    tmpvar_12.zw = vec2(0.0, -0.3333333);
    tmpvar_12.xy = rgb_9.yz;
    tmpvar_10 = tmpvar_12;
  };
  highp vec4 tmpvar_13;
  if ((srcColor_6.x < tmpvar_10.x)) {
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = tmpvar_10.xyw;
    tmpvar_14.w = rgb_9.x;
    tmpvar_13 = tmpvar_14;
  } else {
    highp vec4 tmpvar_15;
    tmpvar_15.x = rgb_9.x;
    tmpvar_15.yzw = tmpvar_10.yzx;
    tmpvar_13 = tmpvar_15;
  };
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_13.x - min (tmpvar_13.w, tmpvar_13.y));
  highp vec3 tmpvar_17;
  tmpvar_17.x = abs(((
    (tmpvar_13.w - tmpvar_13.y)
   / 
    ((6.0 * tmpvar_16) + 1e-7)
  ) + tmpvar_13.z));
  tmpvar_17.y = tmpvar_16;
  tmpvar_17.z = tmpvar_13.x;
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_13.x - (tmpvar_16 * 0.5));
  highp vec3 rgb_19;
  rgb_19 = tmpvar_4.xyz;
  highp vec4 tmpvar_20;
  if ((tmpvar_4.y < tmpvar_4.z)) {
    highp vec4 tmpvar_21;
    tmpvar_21.zw = vec2(-1.0, 0.6666667);
    tmpvar_21.xy = rgb_19.zy;
    tmpvar_20 = tmpvar_21;
  } else {
    highp vec4 tmpvar_22;
    tmpvar_22.zw = vec2(0.0, -0.3333333);
    tmpvar_22.xy = rgb_19.yz;
    tmpvar_20 = tmpvar_22;
  };
  highp vec4 tmpvar_23;
  if ((tmpvar_4.x < tmpvar_20.x)) {
    highp vec4 tmpvar_24;
    tmpvar_24.xyz = tmpvar_20.xyw;
    tmpvar_24.w = rgb_19.x;
    tmpvar_23 = tmpvar_24;
  } else {
    highp vec4 tmpvar_25;
    tmpvar_25.x = rgb_19.x;
    tmpvar_25.yzw = tmpvar_20.yzx;
    tmpvar_23 = tmpvar_25;
  };
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_23.x - min (tmpvar_23.w, tmpvar_23.y));
  highp vec3 tmpvar_27;
  tmpvar_27.x = abs(((
    (tmpvar_23.w - tmpvar_23.y)
   / 
    ((6.0 * tmpvar_26) + 1e-7)
  ) + tmpvar_23.z));
  tmpvar_27.y = tmpvar_26;
  tmpvar_27.z = tmpvar_23.x;
  highp float tmpvar_28;
  tmpvar_28 = (tmpvar_23.x - (tmpvar_26 * 0.5));
  highp vec3 tmpvar_29;
  tmpvar_29.x = tmpvar_27.x;
  tmpvar_29.y = (tmpvar_26 / ((1.0 - 
    abs(((2.0 * tmpvar_28) - 1.0))
  ) + 1e-7));
  tmpvar_29.z = tmpvar_28;
  highp vec3 tmpvar_30;
  tmpvar_30.x = (abs((
    (6.0 * tmpvar_17.x)
   - 3.0)) - 1.0);
  tmpvar_30.y = (2.0 - abs((
    (6.0 * tmpvar_17.x)
   - 2.0)));
  tmpvar_30.z = (2.0 - abs((
    (6.0 * tmpvar_17.x)
   - 4.0)));
  resultColor_2.xyz = (((
    clamp (tmpvar_30, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_18) - 1.0)))
   * tmpvar_29.y)) + tmpvar_18);
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","AXIS","BLEND_SATURATION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp vec3 rgb_7;
  rgb_7 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_8;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_9;
    tmpvar_9.zw = vec2(-1.0, 0.6666667);
    tmpvar_9.xy = rgb_7.zy;
    tmpvar_8 = tmpvar_9;
  } else {
    highp vec4 tmpvar_10;
    tmpvar_10.zw = vec2(0.0, -0.3333333);
    tmpvar_10.xy = rgb_7.yz;
    tmpvar_8 = tmpvar_10;
  };
  highp vec4 tmpvar_11;
  if ((xlt_fbColor_1.x < tmpvar_8.x)) {
    highp vec4 tmpvar_12;
    tmpvar_12.xyz = tmpvar_8.xyw;
    tmpvar_12.w = rgb_7.x;
    tmpvar_11 = tmpvar_12;
  } else {
    highp vec4 tmpvar_13;
    tmpvar_13.x = rgb_7.x;
    tmpvar_13.yzw = tmpvar_8.yzx;
    tmpvar_11 = tmpvar_13;
  };
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_11.x - min (tmpvar_11.w, tmpvar_11.y));
  highp vec3 tmpvar_15;
  tmpvar_15.x = abs(((
    (tmpvar_11.w - tmpvar_11.y)
   / 
    ((6.0 * tmpvar_14) + 1e-7)
  ) + tmpvar_11.z));
  tmpvar_15.y = tmpvar_14;
  tmpvar_15.z = tmpvar_11.x;
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_11.x - (tmpvar_14 * 0.5));
  highp vec3 rgb_17;
  rgb_17 = tmpvar_5.xyz;
  highp vec4 tmpvar_18;
  if ((tmpvar_5.y < tmpvar_5.z)) {
    highp vec4 tmpvar_19;
    tmpvar_19.zw = vec2(-1.0, 0.6666667);
    tmpvar_19.xy = rgb_17.zy;
    tmpvar_18 = tmpvar_19;
  } else {
    highp vec4 tmpvar_20;
    tmpvar_20.zw = vec2(0.0, -0.3333333);
    tmpvar_20.xy = rgb_17.yz;
    tmpvar_18 = tmpvar_20;
  };
  highp vec4 tmpvar_21;
  if ((tmpvar_5.x < tmpvar_18.x)) {
    highp vec4 tmpvar_22;
    tmpvar_22.xyz = tmpvar_18.xyw;
    tmpvar_22.w = rgb_17.x;
    tmpvar_21 = tmpvar_22;
  } else {
    highp vec4 tmpvar_23;
    tmpvar_23.x = rgb_17.x;
    tmpvar_23.yzw = tmpvar_18.yzx;
    tmpvar_21 = tmpvar_23;
  };
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_21.x - min (tmpvar_21.w, tmpvar_21.y));
  highp vec3 tmpvar_25;
  tmpvar_25.x = abs(((
    (tmpvar_21.w - tmpvar_21.y)
   / 
    ((6.0 * tmpvar_24) + 1e-7)
  ) + tmpvar_21.z));
  tmpvar_25.y = tmpvar_24;
  tmpvar_25.z = tmpvar_21.x;
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_21.x - (tmpvar_24 * 0.5));
  highp vec3 tmpvar_27;
  tmpvar_27.x = tmpvar_25.x;
  tmpvar_27.y = (tmpvar_24 / ((1.0 - 
    abs(((2.0 * tmpvar_26) - 1.0))
  ) + 1e-7));
  tmpvar_27.z = tmpvar_26;
  highp vec3 tmpvar_28;
  tmpvar_28.x = (abs((
    (6.0 * tmpvar_15.x)
   - 3.0)) - 1.0);
  tmpvar_28.y = (2.0 - abs((
    (6.0 * tmpvar_15.x)
   - 2.0)));
  tmpvar_28.z = (2.0 - abs((
    (6.0 * tmpvar_15.x)
   - 4.0)));
  resultColor_3.xyz = (((
    clamp (tmpvar_28, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_16) - 1.0)))
   * tmpvar_27.y)) + tmpvar_16);
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"AXIS","BLEND_SATURATION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 rgb_9;
  rgb_9 = srcColor_6.xyz;
  highp vec4 tmpvar_10;
  if ((srcColor_6.y < srcColor_6.z)) {
    highp vec4 tmpvar_11;
    tmpvar_11.zw = vec2(-1.0, 0.6666667);
    tmpvar_11.xy = rgb_9.zy;
    tmpvar_10 = tmpvar_11;
  } else {
    highp vec4 tmpvar_12;
    tmpvar_12.zw = vec2(0.0, -0.3333333);
    tmpvar_12.xy = rgb_9.yz;
    tmpvar_10 = tmpvar_12;
  };
  highp vec4 tmpvar_13;
  if ((srcColor_6.x < tmpvar_10.x)) {
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = tmpvar_10.xyw;
    tmpvar_14.w = rgb_9.x;
    tmpvar_13 = tmpvar_14;
  } else {
    highp vec4 tmpvar_15;
    tmpvar_15.x = rgb_9.x;
    tmpvar_15.yzw = tmpvar_10.yzx;
    tmpvar_13 = tmpvar_15;
  };
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_13.x - min (tmpvar_13.w, tmpvar_13.y));
  highp vec3 tmpvar_17;
  tmpvar_17.x = abs(((
    (tmpvar_13.w - tmpvar_13.y)
   / 
    ((6.0 * tmpvar_16) + 1e-7)
  ) + tmpvar_13.z));
  tmpvar_17.y = tmpvar_16;
  tmpvar_17.z = tmpvar_13.x;
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_13.x - (tmpvar_16 * 0.5));
  highp vec3 rgb_19;
  rgb_19 = tmpvar_4.xyz;
  highp vec4 tmpvar_20;
  if ((tmpvar_4.y < tmpvar_4.z)) {
    highp vec4 tmpvar_21;
    tmpvar_21.zw = vec2(-1.0, 0.6666667);
    tmpvar_21.xy = rgb_19.zy;
    tmpvar_20 = tmpvar_21;
  } else {
    highp vec4 tmpvar_22;
    tmpvar_22.zw = vec2(0.0, -0.3333333);
    tmpvar_22.xy = rgb_19.yz;
    tmpvar_20 = tmpvar_22;
  };
  highp vec4 tmpvar_23;
  if ((tmpvar_4.x < tmpvar_20.x)) {
    highp vec4 tmpvar_24;
    tmpvar_24.xyz = tmpvar_20.xyw;
    tmpvar_24.w = rgb_19.x;
    tmpvar_23 = tmpvar_24;
  } else {
    highp vec4 tmpvar_25;
    tmpvar_25.x = rgb_19.x;
    tmpvar_25.yzw = tmpvar_20.yzx;
    tmpvar_23 = tmpvar_25;
  };
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_23.x - min (tmpvar_23.w, tmpvar_23.y));
  highp vec3 tmpvar_27;
  tmpvar_27.x = abs(((
    (tmpvar_23.w - tmpvar_23.y)
   / 
    ((6.0 * tmpvar_26) + 1e-7)
  ) + tmpvar_23.z));
  tmpvar_27.y = tmpvar_26;
  tmpvar_27.z = tmpvar_23.x;
  highp float tmpvar_28;
  tmpvar_28 = (tmpvar_23.x - (tmpvar_26 * 0.5));
  highp vec3 tmpvar_29;
  tmpvar_29.x = tmpvar_27.x;
  tmpvar_29.y = (tmpvar_26 / ((1.0 - 
    abs(((2.0 * tmpvar_28) - 1.0))
  ) + 1e-7));
  tmpvar_29.z = tmpvar_28;
  highp vec3 tmpvar_30;
  tmpvar_30.x = (abs((
    (6.0 * tmpvar_17.x)
   - 3.0)) - 1.0);
  tmpvar_30.y = (2.0 - abs((
    (6.0 * tmpvar_17.x)
   - 2.0)));
  tmpvar_30.z = (2.0 - abs((
    (6.0 * tmpvar_17.x)
   - 4.0)));
  resultColor_2.xyz = (((
    clamp (tmpvar_30, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_18) - 1.0)))
   * tmpvar_29.y)) + tmpvar_18);
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VELOCITY","BLEND_SATURATION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp vec3 rgb_7;
  rgb_7 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_8;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_9;
    tmpvar_9.zw = vec2(-1.0, 0.6666667);
    tmpvar_9.xy = rgb_7.zy;
    tmpvar_8 = tmpvar_9;
  } else {
    highp vec4 tmpvar_10;
    tmpvar_10.zw = vec2(0.0, -0.3333333);
    tmpvar_10.xy = rgb_7.yz;
    tmpvar_8 = tmpvar_10;
  };
  highp vec4 tmpvar_11;
  if ((xlt_fbColor_1.x < tmpvar_8.x)) {
    highp vec4 tmpvar_12;
    tmpvar_12.xyz = tmpvar_8.xyw;
    tmpvar_12.w = rgb_7.x;
    tmpvar_11 = tmpvar_12;
  } else {
    highp vec4 tmpvar_13;
    tmpvar_13.x = rgb_7.x;
    tmpvar_13.yzw = tmpvar_8.yzx;
    tmpvar_11 = tmpvar_13;
  };
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_11.x - min (tmpvar_11.w, tmpvar_11.y));
  highp vec3 tmpvar_15;
  tmpvar_15.x = abs(((
    (tmpvar_11.w - tmpvar_11.y)
   / 
    ((6.0 * tmpvar_14) + 1e-7)
  ) + tmpvar_11.z));
  tmpvar_15.y = tmpvar_14;
  tmpvar_15.z = tmpvar_11.x;
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_11.x - (tmpvar_14 * 0.5));
  highp vec3 rgb_17;
  rgb_17 = tmpvar_5.xyz;
  highp vec4 tmpvar_18;
  if ((tmpvar_5.y < tmpvar_5.z)) {
    highp vec4 tmpvar_19;
    tmpvar_19.zw = vec2(-1.0, 0.6666667);
    tmpvar_19.xy = rgb_17.zy;
    tmpvar_18 = tmpvar_19;
  } else {
    highp vec4 tmpvar_20;
    tmpvar_20.zw = vec2(0.0, -0.3333333);
    tmpvar_20.xy = rgb_17.yz;
    tmpvar_18 = tmpvar_20;
  };
  highp vec4 tmpvar_21;
  if ((tmpvar_5.x < tmpvar_18.x)) {
    highp vec4 tmpvar_22;
    tmpvar_22.xyz = tmpvar_18.xyw;
    tmpvar_22.w = rgb_17.x;
    tmpvar_21 = tmpvar_22;
  } else {
    highp vec4 tmpvar_23;
    tmpvar_23.x = rgb_17.x;
    tmpvar_23.yzw = tmpvar_18.yzx;
    tmpvar_21 = tmpvar_23;
  };
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_21.x - min (tmpvar_21.w, tmpvar_21.y));
  highp vec3 tmpvar_25;
  tmpvar_25.x = abs(((
    (tmpvar_21.w - tmpvar_21.y)
   / 
    ((6.0 * tmpvar_24) + 1e-7)
  ) + tmpvar_21.z));
  tmpvar_25.y = tmpvar_24;
  tmpvar_25.z = tmpvar_21.x;
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_21.x - (tmpvar_24 * 0.5));
  highp vec3 tmpvar_27;
  tmpvar_27.x = tmpvar_25.x;
  tmpvar_27.y = (tmpvar_24 / ((1.0 - 
    abs(((2.0 * tmpvar_26) - 1.0))
  ) + 1e-7));
  tmpvar_27.z = tmpvar_26;
  highp vec3 tmpvar_28;
  tmpvar_28.x = (abs((
    (6.0 * tmpvar_15.x)
   - 3.0)) - 1.0);
  tmpvar_28.y = (2.0 - abs((
    (6.0 * tmpvar_15.x)
   - 2.0)));
  tmpvar_28.z = (2.0 - abs((
    (6.0 * tmpvar_15.x)
   - 4.0)));
  resultColor_3.xyz = (((
    clamp (tmpvar_28, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_16) - 1.0)))
   * tmpvar_27.y)) + tmpvar_16);
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VELOCITY","BLEND_SATURATION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 rgb_9;
  rgb_9 = srcColor_6.xyz;
  highp vec4 tmpvar_10;
  if ((srcColor_6.y < srcColor_6.z)) {
    highp vec4 tmpvar_11;
    tmpvar_11.zw = vec2(-1.0, 0.6666667);
    tmpvar_11.xy = rgb_9.zy;
    tmpvar_10 = tmpvar_11;
  } else {
    highp vec4 tmpvar_12;
    tmpvar_12.zw = vec2(0.0, -0.3333333);
    tmpvar_12.xy = rgb_9.yz;
    tmpvar_10 = tmpvar_12;
  };
  highp vec4 tmpvar_13;
  if ((srcColor_6.x < tmpvar_10.x)) {
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = tmpvar_10.xyw;
    tmpvar_14.w = rgb_9.x;
    tmpvar_13 = tmpvar_14;
  } else {
    highp vec4 tmpvar_15;
    tmpvar_15.x = rgb_9.x;
    tmpvar_15.yzw = tmpvar_10.yzx;
    tmpvar_13 = tmpvar_15;
  };
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_13.x - min (tmpvar_13.w, tmpvar_13.y));
  highp vec3 tmpvar_17;
  tmpvar_17.x = abs(((
    (tmpvar_13.w - tmpvar_13.y)
   / 
    ((6.0 * tmpvar_16) + 1e-7)
  ) + tmpvar_13.z));
  tmpvar_17.y = tmpvar_16;
  tmpvar_17.z = tmpvar_13.x;
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_13.x - (tmpvar_16 * 0.5));
  highp vec3 rgb_19;
  rgb_19 = tmpvar_4.xyz;
  highp vec4 tmpvar_20;
  if ((tmpvar_4.y < tmpvar_4.z)) {
    highp vec4 tmpvar_21;
    tmpvar_21.zw = vec2(-1.0, 0.6666667);
    tmpvar_21.xy = rgb_19.zy;
    tmpvar_20 = tmpvar_21;
  } else {
    highp vec4 tmpvar_22;
    tmpvar_22.zw = vec2(0.0, -0.3333333);
    tmpvar_22.xy = rgb_19.yz;
    tmpvar_20 = tmpvar_22;
  };
  highp vec4 tmpvar_23;
  if ((tmpvar_4.x < tmpvar_20.x)) {
    highp vec4 tmpvar_24;
    tmpvar_24.xyz = tmpvar_20.xyw;
    tmpvar_24.w = rgb_19.x;
    tmpvar_23 = tmpvar_24;
  } else {
    highp vec4 tmpvar_25;
    tmpvar_25.x = rgb_19.x;
    tmpvar_25.yzw = tmpvar_20.yzx;
    tmpvar_23 = tmpvar_25;
  };
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_23.x - min (tmpvar_23.w, tmpvar_23.y));
  highp vec3 tmpvar_27;
  tmpvar_27.x = abs(((
    (tmpvar_23.w - tmpvar_23.y)
   / 
    ((6.0 * tmpvar_26) + 1e-7)
  ) + tmpvar_23.z));
  tmpvar_27.y = tmpvar_26;
  tmpvar_27.z = tmpvar_23.x;
  highp float tmpvar_28;
  tmpvar_28 = (tmpvar_23.x - (tmpvar_26 * 0.5));
  highp vec3 tmpvar_29;
  tmpvar_29.x = tmpvar_27.x;
  tmpvar_29.y = (tmpvar_26 / ((1.0 - 
    abs(((2.0 * tmpvar_28) - 1.0))
  ) + 1e-7));
  tmpvar_29.z = tmpvar_28;
  highp vec3 tmpvar_30;
  tmpvar_30.x = (abs((
    (6.0 * tmpvar_17.x)
   - 3.0)) - 1.0);
  tmpvar_30.y = (2.0 - abs((
    (6.0 * tmpvar_17.x)
   - 2.0)));
  tmpvar_30.z = (2.0 - abs((
    (6.0 * tmpvar_17.x)
   - 4.0)));
  resultColor_2.xyz = (((
    clamp (tmpvar_30, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_18) - 1.0)))
   * tmpvar_29.y)) + tmpvar_18);
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPLANE","BLEND_LUMINOSITY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp vec3 rgb_7;
  rgb_7 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_8;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_9;
    tmpvar_9.zw = vec2(-1.0, 0.6666667);
    tmpvar_9.xy = rgb_7.zy;
    tmpvar_8 = tmpvar_9;
  } else {
    highp vec4 tmpvar_10;
    tmpvar_10.zw = vec2(0.0, -0.3333333);
    tmpvar_10.xy = rgb_7.yz;
    tmpvar_8 = tmpvar_10;
  };
  highp vec4 tmpvar_11;
  if ((xlt_fbColor_1.x < tmpvar_8.x)) {
    highp vec4 tmpvar_12;
    tmpvar_12.xyz = tmpvar_8.xyw;
    tmpvar_12.w = rgb_7.x;
    tmpvar_11 = tmpvar_12;
  } else {
    highp vec4 tmpvar_13;
    tmpvar_13.x = rgb_7.x;
    tmpvar_13.yzw = tmpvar_8.yzx;
    tmpvar_11 = tmpvar_13;
  };
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_11.x - min (tmpvar_11.w, tmpvar_11.y));
  highp vec3 tmpvar_15;
  tmpvar_15.x = abs(((
    (tmpvar_11.w - tmpvar_11.y)
   / 
    ((6.0 * tmpvar_14) + 1e-7)
  ) + tmpvar_11.z));
  tmpvar_15.y = tmpvar_14;
  tmpvar_15.z = tmpvar_11.x;
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_11.x - (tmpvar_14 * 0.5));
  highp vec3 tmpvar_17;
  tmpvar_17.x = tmpvar_15.x;
  tmpvar_17.y = (tmpvar_14 / ((1.0 - 
    abs(((2.0 * tmpvar_16) - 1.0))
  ) + 1e-7));
  tmpvar_17.z = tmpvar_16;
  highp vec3 rgb_18;
  rgb_18 = tmpvar_5.xyz;
  highp vec4 tmpvar_19;
  if ((tmpvar_5.y < tmpvar_5.z)) {
    highp vec4 tmpvar_20;
    tmpvar_20.zw = vec2(-1.0, 0.6666667);
    tmpvar_20.xy = rgb_18.zy;
    tmpvar_19 = tmpvar_20;
  } else {
    highp vec4 tmpvar_21;
    tmpvar_21.zw = vec2(0.0, -0.3333333);
    tmpvar_21.xy = rgb_18.yz;
    tmpvar_19 = tmpvar_21;
  };
  highp vec4 tmpvar_22;
  if ((tmpvar_5.x < tmpvar_19.x)) {
    highp vec4 tmpvar_23;
    tmpvar_23.xyz = tmpvar_19.xyw;
    tmpvar_23.w = rgb_18.x;
    tmpvar_22 = tmpvar_23;
  } else {
    highp vec4 tmpvar_24;
    tmpvar_24.x = rgb_18.x;
    tmpvar_24.yzw = tmpvar_19.yzx;
    tmpvar_22 = tmpvar_24;
  };
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_22.x - ((tmpvar_22.x - 
    min (tmpvar_22.w, tmpvar_22.y)
  ) * 0.5));
  highp vec3 tmpvar_26;
  tmpvar_26.x = (abs((
    (6.0 * tmpvar_15.x)
   - 3.0)) - 1.0);
  tmpvar_26.y = (2.0 - abs((
    (6.0 * tmpvar_15.x)
   - 2.0)));
  tmpvar_26.z = (2.0 - abs((
    (6.0 * tmpvar_15.x)
   - 4.0)));
  resultColor_3.xyz = (((
    clamp (tmpvar_26, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_25) - 1.0)))
   * tmpvar_17.y)) + tmpvar_25);
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPLANE","BLEND_LUMINOSITY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 rgb_9;
  rgb_9 = srcColor_6.xyz;
  highp vec4 tmpvar_10;
  if ((srcColor_6.y < srcColor_6.z)) {
    highp vec4 tmpvar_11;
    tmpvar_11.zw = vec2(-1.0, 0.6666667);
    tmpvar_11.xy = rgb_9.zy;
    tmpvar_10 = tmpvar_11;
  } else {
    highp vec4 tmpvar_12;
    tmpvar_12.zw = vec2(0.0, -0.3333333);
    tmpvar_12.xy = rgb_9.yz;
    tmpvar_10 = tmpvar_12;
  };
  highp vec4 tmpvar_13;
  if ((srcColor_6.x < tmpvar_10.x)) {
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = tmpvar_10.xyw;
    tmpvar_14.w = rgb_9.x;
    tmpvar_13 = tmpvar_14;
  } else {
    highp vec4 tmpvar_15;
    tmpvar_15.x = rgb_9.x;
    tmpvar_15.yzw = tmpvar_10.yzx;
    tmpvar_13 = tmpvar_15;
  };
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_13.x - min (tmpvar_13.w, tmpvar_13.y));
  highp vec3 tmpvar_17;
  tmpvar_17.x = abs(((
    (tmpvar_13.w - tmpvar_13.y)
   / 
    ((6.0 * tmpvar_16) + 1e-7)
  ) + tmpvar_13.z));
  tmpvar_17.y = tmpvar_16;
  tmpvar_17.z = tmpvar_13.x;
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_13.x - (tmpvar_16 * 0.5));
  highp vec3 tmpvar_19;
  tmpvar_19.x = tmpvar_17.x;
  tmpvar_19.y = (tmpvar_16 / ((1.0 - 
    abs(((2.0 * tmpvar_18) - 1.0))
  ) + 1e-7));
  tmpvar_19.z = tmpvar_18;
  highp vec3 rgb_20;
  rgb_20 = tmpvar_4.xyz;
  highp vec4 tmpvar_21;
  if ((tmpvar_4.y < tmpvar_4.z)) {
    highp vec4 tmpvar_22;
    tmpvar_22.zw = vec2(-1.0, 0.6666667);
    tmpvar_22.xy = rgb_20.zy;
    tmpvar_21 = tmpvar_22;
  } else {
    highp vec4 tmpvar_23;
    tmpvar_23.zw = vec2(0.0, -0.3333333);
    tmpvar_23.xy = rgb_20.yz;
    tmpvar_21 = tmpvar_23;
  };
  highp vec4 tmpvar_24;
  if ((tmpvar_4.x < tmpvar_21.x)) {
    highp vec4 tmpvar_25;
    tmpvar_25.xyz = tmpvar_21.xyw;
    tmpvar_25.w = rgb_20.x;
    tmpvar_24 = tmpvar_25;
  } else {
    highp vec4 tmpvar_26;
    tmpvar_26.x = rgb_20.x;
    tmpvar_26.yzw = tmpvar_21.yzx;
    tmpvar_24 = tmpvar_26;
  };
  highp float tmpvar_27;
  tmpvar_27 = (tmpvar_24.x - ((tmpvar_24.x - 
    min (tmpvar_24.w, tmpvar_24.y)
  ) * 0.5));
  highp vec3 tmpvar_28;
  tmpvar_28.x = (abs((
    (6.0 * tmpvar_17.x)
   - 3.0)) - 1.0);
  tmpvar_28.y = (2.0 - abs((
    (6.0 * tmpvar_17.x)
   - 2.0)));
  tmpvar_28.z = (2.0 - abs((
    (6.0 * tmpvar_17.x)
   - 4.0)));
  resultColor_2.xyz = (((
    clamp (tmpvar_28, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_27) - 1.0)))
   * tmpvar_19.y)) + tmpvar_27);
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPOSITION","BLEND_LUMINOSITY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp vec3 rgb_7;
  rgb_7 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_8;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_9;
    tmpvar_9.zw = vec2(-1.0, 0.6666667);
    tmpvar_9.xy = rgb_7.zy;
    tmpvar_8 = tmpvar_9;
  } else {
    highp vec4 tmpvar_10;
    tmpvar_10.zw = vec2(0.0, -0.3333333);
    tmpvar_10.xy = rgb_7.yz;
    tmpvar_8 = tmpvar_10;
  };
  highp vec4 tmpvar_11;
  if ((xlt_fbColor_1.x < tmpvar_8.x)) {
    highp vec4 tmpvar_12;
    tmpvar_12.xyz = tmpvar_8.xyw;
    tmpvar_12.w = rgb_7.x;
    tmpvar_11 = tmpvar_12;
  } else {
    highp vec4 tmpvar_13;
    tmpvar_13.x = rgb_7.x;
    tmpvar_13.yzw = tmpvar_8.yzx;
    tmpvar_11 = tmpvar_13;
  };
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_11.x - min (tmpvar_11.w, tmpvar_11.y));
  highp vec3 tmpvar_15;
  tmpvar_15.x = abs(((
    (tmpvar_11.w - tmpvar_11.y)
   / 
    ((6.0 * tmpvar_14) + 1e-7)
  ) + tmpvar_11.z));
  tmpvar_15.y = tmpvar_14;
  tmpvar_15.z = tmpvar_11.x;
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_11.x - (tmpvar_14 * 0.5));
  highp vec3 tmpvar_17;
  tmpvar_17.x = tmpvar_15.x;
  tmpvar_17.y = (tmpvar_14 / ((1.0 - 
    abs(((2.0 * tmpvar_16) - 1.0))
  ) + 1e-7));
  tmpvar_17.z = tmpvar_16;
  highp vec3 rgb_18;
  rgb_18 = tmpvar_5.xyz;
  highp vec4 tmpvar_19;
  if ((tmpvar_5.y < tmpvar_5.z)) {
    highp vec4 tmpvar_20;
    tmpvar_20.zw = vec2(-1.0, 0.6666667);
    tmpvar_20.xy = rgb_18.zy;
    tmpvar_19 = tmpvar_20;
  } else {
    highp vec4 tmpvar_21;
    tmpvar_21.zw = vec2(0.0, -0.3333333);
    tmpvar_21.xy = rgb_18.yz;
    tmpvar_19 = tmpvar_21;
  };
  highp vec4 tmpvar_22;
  if ((tmpvar_5.x < tmpvar_19.x)) {
    highp vec4 tmpvar_23;
    tmpvar_23.xyz = tmpvar_19.xyw;
    tmpvar_23.w = rgb_18.x;
    tmpvar_22 = tmpvar_23;
  } else {
    highp vec4 tmpvar_24;
    tmpvar_24.x = rgb_18.x;
    tmpvar_24.yzw = tmpvar_19.yzx;
    tmpvar_22 = tmpvar_24;
  };
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_22.x - ((tmpvar_22.x - 
    min (tmpvar_22.w, tmpvar_22.y)
  ) * 0.5));
  highp vec3 tmpvar_26;
  tmpvar_26.x = (abs((
    (6.0 * tmpvar_15.x)
   - 3.0)) - 1.0);
  tmpvar_26.y = (2.0 - abs((
    (6.0 * tmpvar_15.x)
   - 2.0)));
  tmpvar_26.z = (2.0 - abs((
    (6.0 * tmpvar_15.x)
   - 4.0)));
  resultColor_3.xyz = (((
    clamp (tmpvar_26, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_25) - 1.0)))
   * tmpvar_17.y)) + tmpvar_25);
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPOSITION","BLEND_LUMINOSITY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 rgb_9;
  rgb_9 = srcColor_6.xyz;
  highp vec4 tmpvar_10;
  if ((srcColor_6.y < srcColor_6.z)) {
    highp vec4 tmpvar_11;
    tmpvar_11.zw = vec2(-1.0, 0.6666667);
    tmpvar_11.xy = rgb_9.zy;
    tmpvar_10 = tmpvar_11;
  } else {
    highp vec4 tmpvar_12;
    tmpvar_12.zw = vec2(0.0, -0.3333333);
    tmpvar_12.xy = rgb_9.yz;
    tmpvar_10 = tmpvar_12;
  };
  highp vec4 tmpvar_13;
  if ((srcColor_6.x < tmpvar_10.x)) {
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = tmpvar_10.xyw;
    tmpvar_14.w = rgb_9.x;
    tmpvar_13 = tmpvar_14;
  } else {
    highp vec4 tmpvar_15;
    tmpvar_15.x = rgb_9.x;
    tmpvar_15.yzw = tmpvar_10.yzx;
    tmpvar_13 = tmpvar_15;
  };
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_13.x - min (tmpvar_13.w, tmpvar_13.y));
  highp vec3 tmpvar_17;
  tmpvar_17.x = abs(((
    (tmpvar_13.w - tmpvar_13.y)
   / 
    ((6.0 * tmpvar_16) + 1e-7)
  ) + tmpvar_13.z));
  tmpvar_17.y = tmpvar_16;
  tmpvar_17.z = tmpvar_13.x;
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_13.x - (tmpvar_16 * 0.5));
  highp vec3 tmpvar_19;
  tmpvar_19.x = tmpvar_17.x;
  tmpvar_19.y = (tmpvar_16 / ((1.0 - 
    abs(((2.0 * tmpvar_18) - 1.0))
  ) + 1e-7));
  tmpvar_19.z = tmpvar_18;
  highp vec3 rgb_20;
  rgb_20 = tmpvar_4.xyz;
  highp vec4 tmpvar_21;
  if ((tmpvar_4.y < tmpvar_4.z)) {
    highp vec4 tmpvar_22;
    tmpvar_22.zw = vec2(-1.0, 0.6666667);
    tmpvar_22.xy = rgb_20.zy;
    tmpvar_21 = tmpvar_22;
  } else {
    highp vec4 tmpvar_23;
    tmpvar_23.zw = vec2(0.0, -0.3333333);
    tmpvar_23.xy = rgb_20.yz;
    tmpvar_21 = tmpvar_23;
  };
  highp vec4 tmpvar_24;
  if ((tmpvar_4.x < tmpvar_21.x)) {
    highp vec4 tmpvar_25;
    tmpvar_25.xyz = tmpvar_21.xyw;
    tmpvar_25.w = rgb_20.x;
    tmpvar_24 = tmpvar_25;
  } else {
    highp vec4 tmpvar_26;
    tmpvar_26.x = rgb_20.x;
    tmpvar_26.yzw = tmpvar_21.yzx;
    tmpvar_24 = tmpvar_26;
  };
  highp float tmpvar_27;
  tmpvar_27 = (tmpvar_24.x - ((tmpvar_24.x - 
    min (tmpvar_24.w, tmpvar_24.y)
  ) * 0.5));
  highp vec3 tmpvar_28;
  tmpvar_28.x = (abs((
    (6.0 * tmpvar_17.x)
   - 3.0)) - 1.0);
  tmpvar_28.y = (2.0 - abs((
    (6.0 * tmpvar_17.x)
   - 2.0)));
  tmpvar_28.z = (2.0 - abs((
    (6.0 * tmpvar_17.x)
   - 4.0)));
  resultColor_2.xyz = (((
    clamp (tmpvar_28, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_27) - 1.0)))
   * tmpvar_19.y)) + tmpvar_27);
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","AXIS","BLEND_LUMINOSITY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp vec3 rgb_7;
  rgb_7 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_8;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_9;
    tmpvar_9.zw = vec2(-1.0, 0.6666667);
    tmpvar_9.xy = rgb_7.zy;
    tmpvar_8 = tmpvar_9;
  } else {
    highp vec4 tmpvar_10;
    tmpvar_10.zw = vec2(0.0, -0.3333333);
    tmpvar_10.xy = rgb_7.yz;
    tmpvar_8 = tmpvar_10;
  };
  highp vec4 tmpvar_11;
  if ((xlt_fbColor_1.x < tmpvar_8.x)) {
    highp vec4 tmpvar_12;
    tmpvar_12.xyz = tmpvar_8.xyw;
    tmpvar_12.w = rgb_7.x;
    tmpvar_11 = tmpvar_12;
  } else {
    highp vec4 tmpvar_13;
    tmpvar_13.x = rgb_7.x;
    tmpvar_13.yzw = tmpvar_8.yzx;
    tmpvar_11 = tmpvar_13;
  };
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_11.x - min (tmpvar_11.w, tmpvar_11.y));
  highp vec3 tmpvar_15;
  tmpvar_15.x = abs(((
    (tmpvar_11.w - tmpvar_11.y)
   / 
    ((6.0 * tmpvar_14) + 1e-7)
  ) + tmpvar_11.z));
  tmpvar_15.y = tmpvar_14;
  tmpvar_15.z = tmpvar_11.x;
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_11.x - (tmpvar_14 * 0.5));
  highp vec3 tmpvar_17;
  tmpvar_17.x = tmpvar_15.x;
  tmpvar_17.y = (tmpvar_14 / ((1.0 - 
    abs(((2.0 * tmpvar_16) - 1.0))
  ) + 1e-7));
  tmpvar_17.z = tmpvar_16;
  highp vec3 rgb_18;
  rgb_18 = tmpvar_5.xyz;
  highp vec4 tmpvar_19;
  if ((tmpvar_5.y < tmpvar_5.z)) {
    highp vec4 tmpvar_20;
    tmpvar_20.zw = vec2(-1.0, 0.6666667);
    tmpvar_20.xy = rgb_18.zy;
    tmpvar_19 = tmpvar_20;
  } else {
    highp vec4 tmpvar_21;
    tmpvar_21.zw = vec2(0.0, -0.3333333);
    tmpvar_21.xy = rgb_18.yz;
    tmpvar_19 = tmpvar_21;
  };
  highp vec4 tmpvar_22;
  if ((tmpvar_5.x < tmpvar_19.x)) {
    highp vec4 tmpvar_23;
    tmpvar_23.xyz = tmpvar_19.xyw;
    tmpvar_23.w = rgb_18.x;
    tmpvar_22 = tmpvar_23;
  } else {
    highp vec4 tmpvar_24;
    tmpvar_24.x = rgb_18.x;
    tmpvar_24.yzw = tmpvar_19.yzx;
    tmpvar_22 = tmpvar_24;
  };
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_22.x - ((tmpvar_22.x - 
    min (tmpvar_22.w, tmpvar_22.y)
  ) * 0.5));
  highp vec3 tmpvar_26;
  tmpvar_26.x = (abs((
    (6.0 * tmpvar_15.x)
   - 3.0)) - 1.0);
  tmpvar_26.y = (2.0 - abs((
    (6.0 * tmpvar_15.x)
   - 2.0)));
  tmpvar_26.z = (2.0 - abs((
    (6.0 * tmpvar_15.x)
   - 4.0)));
  resultColor_3.xyz = (((
    clamp (tmpvar_26, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_25) - 1.0)))
   * tmpvar_17.y)) + tmpvar_25);
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"AXIS","BLEND_LUMINOSITY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 rgb_9;
  rgb_9 = srcColor_6.xyz;
  highp vec4 tmpvar_10;
  if ((srcColor_6.y < srcColor_6.z)) {
    highp vec4 tmpvar_11;
    tmpvar_11.zw = vec2(-1.0, 0.6666667);
    tmpvar_11.xy = rgb_9.zy;
    tmpvar_10 = tmpvar_11;
  } else {
    highp vec4 tmpvar_12;
    tmpvar_12.zw = vec2(0.0, -0.3333333);
    tmpvar_12.xy = rgb_9.yz;
    tmpvar_10 = tmpvar_12;
  };
  highp vec4 tmpvar_13;
  if ((srcColor_6.x < tmpvar_10.x)) {
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = tmpvar_10.xyw;
    tmpvar_14.w = rgb_9.x;
    tmpvar_13 = tmpvar_14;
  } else {
    highp vec4 tmpvar_15;
    tmpvar_15.x = rgb_9.x;
    tmpvar_15.yzw = tmpvar_10.yzx;
    tmpvar_13 = tmpvar_15;
  };
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_13.x - min (tmpvar_13.w, tmpvar_13.y));
  highp vec3 tmpvar_17;
  tmpvar_17.x = abs(((
    (tmpvar_13.w - tmpvar_13.y)
   / 
    ((6.0 * tmpvar_16) + 1e-7)
  ) + tmpvar_13.z));
  tmpvar_17.y = tmpvar_16;
  tmpvar_17.z = tmpvar_13.x;
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_13.x - (tmpvar_16 * 0.5));
  highp vec3 tmpvar_19;
  tmpvar_19.x = tmpvar_17.x;
  tmpvar_19.y = (tmpvar_16 / ((1.0 - 
    abs(((2.0 * tmpvar_18) - 1.0))
  ) + 1e-7));
  tmpvar_19.z = tmpvar_18;
  highp vec3 rgb_20;
  rgb_20 = tmpvar_4.xyz;
  highp vec4 tmpvar_21;
  if ((tmpvar_4.y < tmpvar_4.z)) {
    highp vec4 tmpvar_22;
    tmpvar_22.zw = vec2(-1.0, 0.6666667);
    tmpvar_22.xy = rgb_20.zy;
    tmpvar_21 = tmpvar_22;
  } else {
    highp vec4 tmpvar_23;
    tmpvar_23.zw = vec2(0.0, -0.3333333);
    tmpvar_23.xy = rgb_20.yz;
    tmpvar_21 = tmpvar_23;
  };
  highp vec4 tmpvar_24;
  if ((tmpvar_4.x < tmpvar_21.x)) {
    highp vec4 tmpvar_25;
    tmpvar_25.xyz = tmpvar_21.xyw;
    tmpvar_25.w = rgb_20.x;
    tmpvar_24 = tmpvar_25;
  } else {
    highp vec4 tmpvar_26;
    tmpvar_26.x = rgb_20.x;
    tmpvar_26.yzw = tmpvar_21.yzx;
    tmpvar_24 = tmpvar_26;
  };
  highp float tmpvar_27;
  tmpvar_27 = (tmpvar_24.x - ((tmpvar_24.x - 
    min (tmpvar_24.w, tmpvar_24.y)
  ) * 0.5));
  highp vec3 tmpvar_28;
  tmpvar_28.x = (abs((
    (6.0 * tmpvar_17.x)
   - 3.0)) - 1.0);
  tmpvar_28.y = (2.0 - abs((
    (6.0 * tmpvar_17.x)
   - 2.0)));
  tmpvar_28.z = (2.0 - abs((
    (6.0 * tmpvar_17.x)
   - 4.0)));
  resultColor_2.xyz = (((
    clamp (tmpvar_28, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_27) - 1.0)))
   * tmpvar_19.y)) + tmpvar_27);
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VELOCITY","BLEND_LUMINOSITY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp vec3 rgb_7;
  rgb_7 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_8;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_9;
    tmpvar_9.zw = vec2(-1.0, 0.6666667);
    tmpvar_9.xy = rgb_7.zy;
    tmpvar_8 = tmpvar_9;
  } else {
    highp vec4 tmpvar_10;
    tmpvar_10.zw = vec2(0.0, -0.3333333);
    tmpvar_10.xy = rgb_7.yz;
    tmpvar_8 = tmpvar_10;
  };
  highp vec4 tmpvar_11;
  if ((xlt_fbColor_1.x < tmpvar_8.x)) {
    highp vec4 tmpvar_12;
    tmpvar_12.xyz = tmpvar_8.xyw;
    tmpvar_12.w = rgb_7.x;
    tmpvar_11 = tmpvar_12;
  } else {
    highp vec4 tmpvar_13;
    tmpvar_13.x = rgb_7.x;
    tmpvar_13.yzw = tmpvar_8.yzx;
    tmpvar_11 = tmpvar_13;
  };
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_11.x - min (tmpvar_11.w, tmpvar_11.y));
  highp vec3 tmpvar_15;
  tmpvar_15.x = abs(((
    (tmpvar_11.w - tmpvar_11.y)
   / 
    ((6.0 * tmpvar_14) + 1e-7)
  ) + tmpvar_11.z));
  tmpvar_15.y = tmpvar_14;
  tmpvar_15.z = tmpvar_11.x;
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_11.x - (tmpvar_14 * 0.5));
  highp vec3 tmpvar_17;
  tmpvar_17.x = tmpvar_15.x;
  tmpvar_17.y = (tmpvar_14 / ((1.0 - 
    abs(((2.0 * tmpvar_16) - 1.0))
  ) + 1e-7));
  tmpvar_17.z = tmpvar_16;
  highp vec3 rgb_18;
  rgb_18 = tmpvar_5.xyz;
  highp vec4 tmpvar_19;
  if ((tmpvar_5.y < tmpvar_5.z)) {
    highp vec4 tmpvar_20;
    tmpvar_20.zw = vec2(-1.0, 0.6666667);
    tmpvar_20.xy = rgb_18.zy;
    tmpvar_19 = tmpvar_20;
  } else {
    highp vec4 tmpvar_21;
    tmpvar_21.zw = vec2(0.0, -0.3333333);
    tmpvar_21.xy = rgb_18.yz;
    tmpvar_19 = tmpvar_21;
  };
  highp vec4 tmpvar_22;
  if ((tmpvar_5.x < tmpvar_19.x)) {
    highp vec4 tmpvar_23;
    tmpvar_23.xyz = tmpvar_19.xyw;
    tmpvar_23.w = rgb_18.x;
    tmpvar_22 = tmpvar_23;
  } else {
    highp vec4 tmpvar_24;
    tmpvar_24.x = rgb_18.x;
    tmpvar_24.yzw = tmpvar_19.yzx;
    tmpvar_22 = tmpvar_24;
  };
  highp float tmpvar_25;
  tmpvar_25 = (tmpvar_22.x - ((tmpvar_22.x - 
    min (tmpvar_22.w, tmpvar_22.y)
  ) * 0.5));
  highp vec3 tmpvar_26;
  tmpvar_26.x = (abs((
    (6.0 * tmpvar_15.x)
   - 3.0)) - 1.0);
  tmpvar_26.y = (2.0 - abs((
    (6.0 * tmpvar_15.x)
   - 2.0)));
  tmpvar_26.z = (2.0 - abs((
    (6.0 * tmpvar_15.x)
   - 4.0)));
  resultColor_3.xyz = (((
    clamp (tmpvar_26, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_25) - 1.0)))
   * tmpvar_17.y)) + tmpvar_25);
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VELOCITY","BLEND_LUMINOSITY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 rgb_9;
  rgb_9 = srcColor_6.xyz;
  highp vec4 tmpvar_10;
  if ((srcColor_6.y < srcColor_6.z)) {
    highp vec4 tmpvar_11;
    tmpvar_11.zw = vec2(-1.0, 0.6666667);
    tmpvar_11.xy = rgb_9.zy;
    tmpvar_10 = tmpvar_11;
  } else {
    highp vec4 tmpvar_12;
    tmpvar_12.zw = vec2(0.0, -0.3333333);
    tmpvar_12.xy = rgb_9.yz;
    tmpvar_10 = tmpvar_12;
  };
  highp vec4 tmpvar_13;
  if ((srcColor_6.x < tmpvar_10.x)) {
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = tmpvar_10.xyw;
    tmpvar_14.w = rgb_9.x;
    tmpvar_13 = tmpvar_14;
  } else {
    highp vec4 tmpvar_15;
    tmpvar_15.x = rgb_9.x;
    tmpvar_15.yzw = tmpvar_10.yzx;
    tmpvar_13 = tmpvar_15;
  };
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_13.x - min (tmpvar_13.w, tmpvar_13.y));
  highp vec3 tmpvar_17;
  tmpvar_17.x = abs(((
    (tmpvar_13.w - tmpvar_13.y)
   / 
    ((6.0 * tmpvar_16) + 1e-7)
  ) + tmpvar_13.z));
  tmpvar_17.y = tmpvar_16;
  tmpvar_17.z = tmpvar_13.x;
  highp float tmpvar_18;
  tmpvar_18 = (tmpvar_13.x - (tmpvar_16 * 0.5));
  highp vec3 tmpvar_19;
  tmpvar_19.x = tmpvar_17.x;
  tmpvar_19.y = (tmpvar_16 / ((1.0 - 
    abs(((2.0 * tmpvar_18) - 1.0))
  ) + 1e-7));
  tmpvar_19.z = tmpvar_18;
  highp vec3 rgb_20;
  rgb_20 = tmpvar_4.xyz;
  highp vec4 tmpvar_21;
  if ((tmpvar_4.y < tmpvar_4.z)) {
    highp vec4 tmpvar_22;
    tmpvar_22.zw = vec2(-1.0, 0.6666667);
    tmpvar_22.xy = rgb_20.zy;
    tmpvar_21 = tmpvar_22;
  } else {
    highp vec4 tmpvar_23;
    tmpvar_23.zw = vec2(0.0, -0.3333333);
    tmpvar_23.xy = rgb_20.yz;
    tmpvar_21 = tmpvar_23;
  };
  highp vec4 tmpvar_24;
  if ((tmpvar_4.x < tmpvar_21.x)) {
    highp vec4 tmpvar_25;
    tmpvar_25.xyz = tmpvar_21.xyw;
    tmpvar_25.w = rgb_20.x;
    tmpvar_24 = tmpvar_25;
  } else {
    highp vec4 tmpvar_26;
    tmpvar_26.x = rgb_20.x;
    tmpvar_26.yzw = tmpvar_21.yzx;
    tmpvar_24 = tmpvar_26;
  };
  highp float tmpvar_27;
  tmpvar_27 = (tmpvar_24.x - ((tmpvar_24.x - 
    min (tmpvar_24.w, tmpvar_24.y)
  ) * 0.5));
  highp vec3 tmpvar_28;
  tmpvar_28.x = (abs((
    (6.0 * tmpvar_17.x)
   - 3.0)) - 1.0);
  tmpvar_28.y = (2.0 - abs((
    (6.0 * tmpvar_17.x)
   - 2.0)));
  tmpvar_28.z = (2.0 - abs((
    (6.0 * tmpvar_17.x)
   - 4.0)));
  resultColor_2.xyz = (((
    clamp (tmpvar_28, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_27) - 1.0)))
   * tmpvar_19.y)) + tmpvar_27);
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPLANE","BLEND_COLOR"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp vec3 rgb_7;
  rgb_7 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_8;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_9;
    tmpvar_9.zw = vec2(-1.0, 0.6666667);
    tmpvar_9.xy = rgb_7.zy;
    tmpvar_8 = tmpvar_9;
  } else {
    highp vec4 tmpvar_10;
    tmpvar_10.zw = vec2(0.0, -0.3333333);
    tmpvar_10.xy = rgb_7.yz;
    tmpvar_8 = tmpvar_10;
  };
  highp vec4 tmpvar_11;
  if ((xlt_fbColor_1.x < tmpvar_8.x)) {
    highp vec4 tmpvar_12;
    tmpvar_12.xyz = tmpvar_8.xyw;
    tmpvar_12.w = rgb_7.x;
    tmpvar_11 = tmpvar_12;
  } else {
    highp vec4 tmpvar_13;
    tmpvar_13.x = rgb_7.x;
    tmpvar_13.yzw = tmpvar_8.yzx;
    tmpvar_11 = tmpvar_13;
  };
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_11.x - ((tmpvar_11.x - 
    min (tmpvar_11.w, tmpvar_11.y)
  ) * 0.5));
  highp vec3 rgb_15;
  rgb_15 = tmpvar_5.xyz;
  highp vec4 tmpvar_16;
  if ((tmpvar_5.y < tmpvar_5.z)) {
    highp vec4 tmpvar_17;
    tmpvar_17.zw = vec2(-1.0, 0.6666667);
    tmpvar_17.xy = rgb_15.zy;
    tmpvar_16 = tmpvar_17;
  } else {
    highp vec4 tmpvar_18;
    tmpvar_18.zw = vec2(0.0, -0.3333333);
    tmpvar_18.xy = rgb_15.yz;
    tmpvar_16 = tmpvar_18;
  };
  highp vec4 tmpvar_19;
  if ((tmpvar_5.x < tmpvar_16.x)) {
    highp vec4 tmpvar_20;
    tmpvar_20.xyz = tmpvar_16.xyw;
    tmpvar_20.w = rgb_15.x;
    tmpvar_19 = tmpvar_20;
  } else {
    highp vec4 tmpvar_21;
    tmpvar_21.x = rgb_15.x;
    tmpvar_21.yzw = tmpvar_16.yzx;
    tmpvar_19 = tmpvar_21;
  };
  highp float tmpvar_22;
  tmpvar_22 = (tmpvar_19.x - min (tmpvar_19.w, tmpvar_19.y));
  highp vec3 tmpvar_23;
  tmpvar_23.x = abs(((
    (tmpvar_19.w - tmpvar_19.y)
   / 
    ((6.0 * tmpvar_22) + 1e-7)
  ) + tmpvar_19.z));
  tmpvar_23.y = tmpvar_22;
  tmpvar_23.z = tmpvar_19.x;
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_19.x - (tmpvar_22 * 0.5));
  highp vec3 tmpvar_25;
  tmpvar_25.x = tmpvar_23.x;
  tmpvar_25.y = (tmpvar_22 / ((1.0 - 
    abs(((2.0 * tmpvar_24) - 1.0))
  ) + 1e-7));
  tmpvar_25.z = tmpvar_24;
  highp vec3 tmpvar_26;
  tmpvar_26.x = (abs((
    (6.0 * tmpvar_23.x)
   - 3.0)) - 1.0);
  tmpvar_26.y = (2.0 - abs((
    (6.0 * tmpvar_23.x)
   - 2.0)));
  tmpvar_26.z = (2.0 - abs((
    (6.0 * tmpvar_23.x)
   - 4.0)));
  resultColor_3.xyz = (((
    clamp (tmpvar_26, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_14) - 1.0)))
   * tmpvar_25.y)) + tmpvar_14);
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPLANE","BLEND_COLOR"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 rgb_9;
  rgb_9 = srcColor_6.xyz;
  highp vec4 tmpvar_10;
  if ((srcColor_6.y < srcColor_6.z)) {
    highp vec4 tmpvar_11;
    tmpvar_11.zw = vec2(-1.0, 0.6666667);
    tmpvar_11.xy = rgb_9.zy;
    tmpvar_10 = tmpvar_11;
  } else {
    highp vec4 tmpvar_12;
    tmpvar_12.zw = vec2(0.0, -0.3333333);
    tmpvar_12.xy = rgb_9.yz;
    tmpvar_10 = tmpvar_12;
  };
  highp vec4 tmpvar_13;
  if ((srcColor_6.x < tmpvar_10.x)) {
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = tmpvar_10.xyw;
    tmpvar_14.w = rgb_9.x;
    tmpvar_13 = tmpvar_14;
  } else {
    highp vec4 tmpvar_15;
    tmpvar_15.x = rgb_9.x;
    tmpvar_15.yzw = tmpvar_10.yzx;
    tmpvar_13 = tmpvar_15;
  };
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_13.x - ((tmpvar_13.x - 
    min (tmpvar_13.w, tmpvar_13.y)
  ) * 0.5));
  highp vec3 rgb_17;
  rgb_17 = tmpvar_4.xyz;
  highp vec4 tmpvar_18;
  if ((tmpvar_4.y < tmpvar_4.z)) {
    highp vec4 tmpvar_19;
    tmpvar_19.zw = vec2(-1.0, 0.6666667);
    tmpvar_19.xy = rgb_17.zy;
    tmpvar_18 = tmpvar_19;
  } else {
    highp vec4 tmpvar_20;
    tmpvar_20.zw = vec2(0.0, -0.3333333);
    tmpvar_20.xy = rgb_17.yz;
    tmpvar_18 = tmpvar_20;
  };
  highp vec4 tmpvar_21;
  if ((tmpvar_4.x < tmpvar_18.x)) {
    highp vec4 tmpvar_22;
    tmpvar_22.xyz = tmpvar_18.xyw;
    tmpvar_22.w = rgb_17.x;
    tmpvar_21 = tmpvar_22;
  } else {
    highp vec4 tmpvar_23;
    tmpvar_23.x = rgb_17.x;
    tmpvar_23.yzw = tmpvar_18.yzx;
    tmpvar_21 = tmpvar_23;
  };
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_21.x - min (tmpvar_21.w, tmpvar_21.y));
  highp vec3 tmpvar_25;
  tmpvar_25.x = abs(((
    (tmpvar_21.w - tmpvar_21.y)
   / 
    ((6.0 * tmpvar_24) + 1e-7)
  ) + tmpvar_21.z));
  tmpvar_25.y = tmpvar_24;
  tmpvar_25.z = tmpvar_21.x;
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_21.x - (tmpvar_24 * 0.5));
  highp vec3 tmpvar_27;
  tmpvar_27.x = tmpvar_25.x;
  tmpvar_27.y = (tmpvar_24 / ((1.0 - 
    abs(((2.0 * tmpvar_26) - 1.0))
  ) + 1e-7));
  tmpvar_27.z = tmpvar_26;
  highp vec3 tmpvar_28;
  tmpvar_28.x = (abs((
    (6.0 * tmpvar_25.x)
   - 3.0)) - 1.0);
  tmpvar_28.y = (2.0 - abs((
    (6.0 * tmpvar_25.x)
   - 2.0)));
  tmpvar_28.z = (2.0 - abs((
    (6.0 * tmpvar_25.x)
   - 4.0)));
  resultColor_2.xyz = (((
    clamp (tmpvar_28, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_16) - 1.0)))
   * tmpvar_27.y)) + tmpvar_16);
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPOSITION","BLEND_COLOR"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp vec3 rgb_7;
  rgb_7 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_8;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_9;
    tmpvar_9.zw = vec2(-1.0, 0.6666667);
    tmpvar_9.xy = rgb_7.zy;
    tmpvar_8 = tmpvar_9;
  } else {
    highp vec4 tmpvar_10;
    tmpvar_10.zw = vec2(0.0, -0.3333333);
    tmpvar_10.xy = rgb_7.yz;
    tmpvar_8 = tmpvar_10;
  };
  highp vec4 tmpvar_11;
  if ((xlt_fbColor_1.x < tmpvar_8.x)) {
    highp vec4 tmpvar_12;
    tmpvar_12.xyz = tmpvar_8.xyw;
    tmpvar_12.w = rgb_7.x;
    tmpvar_11 = tmpvar_12;
  } else {
    highp vec4 tmpvar_13;
    tmpvar_13.x = rgb_7.x;
    tmpvar_13.yzw = tmpvar_8.yzx;
    tmpvar_11 = tmpvar_13;
  };
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_11.x - ((tmpvar_11.x - 
    min (tmpvar_11.w, tmpvar_11.y)
  ) * 0.5));
  highp vec3 rgb_15;
  rgb_15 = tmpvar_5.xyz;
  highp vec4 tmpvar_16;
  if ((tmpvar_5.y < tmpvar_5.z)) {
    highp vec4 tmpvar_17;
    tmpvar_17.zw = vec2(-1.0, 0.6666667);
    tmpvar_17.xy = rgb_15.zy;
    tmpvar_16 = tmpvar_17;
  } else {
    highp vec4 tmpvar_18;
    tmpvar_18.zw = vec2(0.0, -0.3333333);
    tmpvar_18.xy = rgb_15.yz;
    tmpvar_16 = tmpvar_18;
  };
  highp vec4 tmpvar_19;
  if ((tmpvar_5.x < tmpvar_16.x)) {
    highp vec4 tmpvar_20;
    tmpvar_20.xyz = tmpvar_16.xyw;
    tmpvar_20.w = rgb_15.x;
    tmpvar_19 = tmpvar_20;
  } else {
    highp vec4 tmpvar_21;
    tmpvar_21.x = rgb_15.x;
    tmpvar_21.yzw = tmpvar_16.yzx;
    tmpvar_19 = tmpvar_21;
  };
  highp float tmpvar_22;
  tmpvar_22 = (tmpvar_19.x - min (tmpvar_19.w, tmpvar_19.y));
  highp vec3 tmpvar_23;
  tmpvar_23.x = abs(((
    (tmpvar_19.w - tmpvar_19.y)
   / 
    ((6.0 * tmpvar_22) + 1e-7)
  ) + tmpvar_19.z));
  tmpvar_23.y = tmpvar_22;
  tmpvar_23.z = tmpvar_19.x;
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_19.x - (tmpvar_22 * 0.5));
  highp vec3 tmpvar_25;
  tmpvar_25.x = tmpvar_23.x;
  tmpvar_25.y = (tmpvar_22 / ((1.0 - 
    abs(((2.0 * tmpvar_24) - 1.0))
  ) + 1e-7));
  tmpvar_25.z = tmpvar_24;
  highp vec3 tmpvar_26;
  tmpvar_26.x = (abs((
    (6.0 * tmpvar_23.x)
   - 3.0)) - 1.0);
  tmpvar_26.y = (2.0 - abs((
    (6.0 * tmpvar_23.x)
   - 2.0)));
  tmpvar_26.z = (2.0 - abs((
    (6.0 * tmpvar_23.x)
   - 4.0)));
  resultColor_3.xyz = (((
    clamp (tmpvar_26, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_14) - 1.0)))
   * tmpvar_25.y)) + tmpvar_14);
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPOSITION","BLEND_COLOR"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 rgb_9;
  rgb_9 = srcColor_6.xyz;
  highp vec4 tmpvar_10;
  if ((srcColor_6.y < srcColor_6.z)) {
    highp vec4 tmpvar_11;
    tmpvar_11.zw = vec2(-1.0, 0.6666667);
    tmpvar_11.xy = rgb_9.zy;
    tmpvar_10 = tmpvar_11;
  } else {
    highp vec4 tmpvar_12;
    tmpvar_12.zw = vec2(0.0, -0.3333333);
    tmpvar_12.xy = rgb_9.yz;
    tmpvar_10 = tmpvar_12;
  };
  highp vec4 tmpvar_13;
  if ((srcColor_6.x < tmpvar_10.x)) {
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = tmpvar_10.xyw;
    tmpvar_14.w = rgb_9.x;
    tmpvar_13 = tmpvar_14;
  } else {
    highp vec4 tmpvar_15;
    tmpvar_15.x = rgb_9.x;
    tmpvar_15.yzw = tmpvar_10.yzx;
    tmpvar_13 = tmpvar_15;
  };
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_13.x - ((tmpvar_13.x - 
    min (tmpvar_13.w, tmpvar_13.y)
  ) * 0.5));
  highp vec3 rgb_17;
  rgb_17 = tmpvar_4.xyz;
  highp vec4 tmpvar_18;
  if ((tmpvar_4.y < tmpvar_4.z)) {
    highp vec4 tmpvar_19;
    tmpvar_19.zw = vec2(-1.0, 0.6666667);
    tmpvar_19.xy = rgb_17.zy;
    tmpvar_18 = tmpvar_19;
  } else {
    highp vec4 tmpvar_20;
    tmpvar_20.zw = vec2(0.0, -0.3333333);
    tmpvar_20.xy = rgb_17.yz;
    tmpvar_18 = tmpvar_20;
  };
  highp vec4 tmpvar_21;
  if ((tmpvar_4.x < tmpvar_18.x)) {
    highp vec4 tmpvar_22;
    tmpvar_22.xyz = tmpvar_18.xyw;
    tmpvar_22.w = rgb_17.x;
    tmpvar_21 = tmpvar_22;
  } else {
    highp vec4 tmpvar_23;
    tmpvar_23.x = rgb_17.x;
    tmpvar_23.yzw = tmpvar_18.yzx;
    tmpvar_21 = tmpvar_23;
  };
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_21.x - min (tmpvar_21.w, tmpvar_21.y));
  highp vec3 tmpvar_25;
  tmpvar_25.x = abs(((
    (tmpvar_21.w - tmpvar_21.y)
   / 
    ((6.0 * tmpvar_24) + 1e-7)
  ) + tmpvar_21.z));
  tmpvar_25.y = tmpvar_24;
  tmpvar_25.z = tmpvar_21.x;
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_21.x - (tmpvar_24 * 0.5));
  highp vec3 tmpvar_27;
  tmpvar_27.x = tmpvar_25.x;
  tmpvar_27.y = (tmpvar_24 / ((1.0 - 
    abs(((2.0 * tmpvar_26) - 1.0))
  ) + 1e-7));
  tmpvar_27.z = tmpvar_26;
  highp vec3 tmpvar_28;
  tmpvar_28.x = (abs((
    (6.0 * tmpvar_25.x)
   - 3.0)) - 1.0);
  tmpvar_28.y = (2.0 - abs((
    (6.0 * tmpvar_25.x)
   - 2.0)));
  tmpvar_28.z = (2.0 - abs((
    (6.0 * tmpvar_25.x)
   - 4.0)));
  resultColor_2.xyz = (((
    clamp (tmpvar_28, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_16) - 1.0)))
   * tmpvar_27.y)) + tmpvar_16);
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","AXIS","BLEND_COLOR"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp vec3 rgb_7;
  rgb_7 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_8;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_9;
    tmpvar_9.zw = vec2(-1.0, 0.6666667);
    tmpvar_9.xy = rgb_7.zy;
    tmpvar_8 = tmpvar_9;
  } else {
    highp vec4 tmpvar_10;
    tmpvar_10.zw = vec2(0.0, -0.3333333);
    tmpvar_10.xy = rgb_7.yz;
    tmpvar_8 = tmpvar_10;
  };
  highp vec4 tmpvar_11;
  if ((xlt_fbColor_1.x < tmpvar_8.x)) {
    highp vec4 tmpvar_12;
    tmpvar_12.xyz = tmpvar_8.xyw;
    tmpvar_12.w = rgb_7.x;
    tmpvar_11 = tmpvar_12;
  } else {
    highp vec4 tmpvar_13;
    tmpvar_13.x = rgb_7.x;
    tmpvar_13.yzw = tmpvar_8.yzx;
    tmpvar_11 = tmpvar_13;
  };
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_11.x - ((tmpvar_11.x - 
    min (tmpvar_11.w, tmpvar_11.y)
  ) * 0.5));
  highp vec3 rgb_15;
  rgb_15 = tmpvar_5.xyz;
  highp vec4 tmpvar_16;
  if ((tmpvar_5.y < tmpvar_5.z)) {
    highp vec4 tmpvar_17;
    tmpvar_17.zw = vec2(-1.0, 0.6666667);
    tmpvar_17.xy = rgb_15.zy;
    tmpvar_16 = tmpvar_17;
  } else {
    highp vec4 tmpvar_18;
    tmpvar_18.zw = vec2(0.0, -0.3333333);
    tmpvar_18.xy = rgb_15.yz;
    tmpvar_16 = tmpvar_18;
  };
  highp vec4 tmpvar_19;
  if ((tmpvar_5.x < tmpvar_16.x)) {
    highp vec4 tmpvar_20;
    tmpvar_20.xyz = tmpvar_16.xyw;
    tmpvar_20.w = rgb_15.x;
    tmpvar_19 = tmpvar_20;
  } else {
    highp vec4 tmpvar_21;
    tmpvar_21.x = rgb_15.x;
    tmpvar_21.yzw = tmpvar_16.yzx;
    tmpvar_19 = tmpvar_21;
  };
  highp float tmpvar_22;
  tmpvar_22 = (tmpvar_19.x - min (tmpvar_19.w, tmpvar_19.y));
  highp vec3 tmpvar_23;
  tmpvar_23.x = abs(((
    (tmpvar_19.w - tmpvar_19.y)
   / 
    ((6.0 * tmpvar_22) + 1e-7)
  ) + tmpvar_19.z));
  tmpvar_23.y = tmpvar_22;
  tmpvar_23.z = tmpvar_19.x;
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_19.x - (tmpvar_22 * 0.5));
  highp vec3 tmpvar_25;
  tmpvar_25.x = tmpvar_23.x;
  tmpvar_25.y = (tmpvar_22 / ((1.0 - 
    abs(((2.0 * tmpvar_24) - 1.0))
  ) + 1e-7));
  tmpvar_25.z = tmpvar_24;
  highp vec3 tmpvar_26;
  tmpvar_26.x = (abs((
    (6.0 * tmpvar_23.x)
   - 3.0)) - 1.0);
  tmpvar_26.y = (2.0 - abs((
    (6.0 * tmpvar_23.x)
   - 2.0)));
  tmpvar_26.z = (2.0 - abs((
    (6.0 * tmpvar_23.x)
   - 4.0)));
  resultColor_3.xyz = (((
    clamp (tmpvar_26, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_14) - 1.0)))
   * tmpvar_25.y)) + tmpvar_14);
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"AXIS","BLEND_COLOR"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 rgb_9;
  rgb_9 = srcColor_6.xyz;
  highp vec4 tmpvar_10;
  if ((srcColor_6.y < srcColor_6.z)) {
    highp vec4 tmpvar_11;
    tmpvar_11.zw = vec2(-1.0, 0.6666667);
    tmpvar_11.xy = rgb_9.zy;
    tmpvar_10 = tmpvar_11;
  } else {
    highp vec4 tmpvar_12;
    tmpvar_12.zw = vec2(0.0, -0.3333333);
    tmpvar_12.xy = rgb_9.yz;
    tmpvar_10 = tmpvar_12;
  };
  highp vec4 tmpvar_13;
  if ((srcColor_6.x < tmpvar_10.x)) {
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = tmpvar_10.xyw;
    tmpvar_14.w = rgb_9.x;
    tmpvar_13 = tmpvar_14;
  } else {
    highp vec4 tmpvar_15;
    tmpvar_15.x = rgb_9.x;
    tmpvar_15.yzw = tmpvar_10.yzx;
    tmpvar_13 = tmpvar_15;
  };
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_13.x - ((tmpvar_13.x - 
    min (tmpvar_13.w, tmpvar_13.y)
  ) * 0.5));
  highp vec3 rgb_17;
  rgb_17 = tmpvar_4.xyz;
  highp vec4 tmpvar_18;
  if ((tmpvar_4.y < tmpvar_4.z)) {
    highp vec4 tmpvar_19;
    tmpvar_19.zw = vec2(-1.0, 0.6666667);
    tmpvar_19.xy = rgb_17.zy;
    tmpvar_18 = tmpvar_19;
  } else {
    highp vec4 tmpvar_20;
    tmpvar_20.zw = vec2(0.0, -0.3333333);
    tmpvar_20.xy = rgb_17.yz;
    tmpvar_18 = tmpvar_20;
  };
  highp vec4 tmpvar_21;
  if ((tmpvar_4.x < tmpvar_18.x)) {
    highp vec4 tmpvar_22;
    tmpvar_22.xyz = tmpvar_18.xyw;
    tmpvar_22.w = rgb_17.x;
    tmpvar_21 = tmpvar_22;
  } else {
    highp vec4 tmpvar_23;
    tmpvar_23.x = rgb_17.x;
    tmpvar_23.yzw = tmpvar_18.yzx;
    tmpvar_21 = tmpvar_23;
  };
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_21.x - min (tmpvar_21.w, tmpvar_21.y));
  highp vec3 tmpvar_25;
  tmpvar_25.x = abs(((
    (tmpvar_21.w - tmpvar_21.y)
   / 
    ((6.0 * tmpvar_24) + 1e-7)
  ) + tmpvar_21.z));
  tmpvar_25.y = tmpvar_24;
  tmpvar_25.z = tmpvar_21.x;
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_21.x - (tmpvar_24 * 0.5));
  highp vec3 tmpvar_27;
  tmpvar_27.x = tmpvar_25.x;
  tmpvar_27.y = (tmpvar_24 / ((1.0 - 
    abs(((2.0 * tmpvar_26) - 1.0))
  ) + 1e-7));
  tmpvar_27.z = tmpvar_26;
  highp vec3 tmpvar_28;
  tmpvar_28.x = (abs((
    (6.0 * tmpvar_25.x)
   - 3.0)) - 1.0);
  tmpvar_28.y = (2.0 - abs((
    (6.0 * tmpvar_25.x)
   - 2.0)));
  tmpvar_28.z = (2.0 - abs((
    (6.0 * tmpvar_25.x)
   - 4.0)));
  resultColor_2.xyz = (((
    clamp (tmpvar_28, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_16) - 1.0)))
   * tmpvar_27.y)) + tmpvar_16);
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VELOCITY","BLEND_COLOR"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp vec3 rgb_7;
  rgb_7 = xlt_fbColor_1.xyz;
  highp vec4 tmpvar_8;
  if ((xlt_fbColor_1.y < xlt_fbColor_1.z)) {
    highp vec4 tmpvar_9;
    tmpvar_9.zw = vec2(-1.0, 0.6666667);
    tmpvar_9.xy = rgb_7.zy;
    tmpvar_8 = tmpvar_9;
  } else {
    highp vec4 tmpvar_10;
    tmpvar_10.zw = vec2(0.0, -0.3333333);
    tmpvar_10.xy = rgb_7.yz;
    tmpvar_8 = tmpvar_10;
  };
  highp vec4 tmpvar_11;
  if ((xlt_fbColor_1.x < tmpvar_8.x)) {
    highp vec4 tmpvar_12;
    tmpvar_12.xyz = tmpvar_8.xyw;
    tmpvar_12.w = rgb_7.x;
    tmpvar_11 = tmpvar_12;
  } else {
    highp vec4 tmpvar_13;
    tmpvar_13.x = rgb_7.x;
    tmpvar_13.yzw = tmpvar_8.yzx;
    tmpvar_11 = tmpvar_13;
  };
  highp float tmpvar_14;
  tmpvar_14 = (tmpvar_11.x - ((tmpvar_11.x - 
    min (tmpvar_11.w, tmpvar_11.y)
  ) * 0.5));
  highp vec3 rgb_15;
  rgb_15 = tmpvar_5.xyz;
  highp vec4 tmpvar_16;
  if ((tmpvar_5.y < tmpvar_5.z)) {
    highp vec4 tmpvar_17;
    tmpvar_17.zw = vec2(-1.0, 0.6666667);
    tmpvar_17.xy = rgb_15.zy;
    tmpvar_16 = tmpvar_17;
  } else {
    highp vec4 tmpvar_18;
    tmpvar_18.zw = vec2(0.0, -0.3333333);
    tmpvar_18.xy = rgb_15.yz;
    tmpvar_16 = tmpvar_18;
  };
  highp vec4 tmpvar_19;
  if ((tmpvar_5.x < tmpvar_16.x)) {
    highp vec4 tmpvar_20;
    tmpvar_20.xyz = tmpvar_16.xyw;
    tmpvar_20.w = rgb_15.x;
    tmpvar_19 = tmpvar_20;
  } else {
    highp vec4 tmpvar_21;
    tmpvar_21.x = rgb_15.x;
    tmpvar_21.yzw = tmpvar_16.yzx;
    tmpvar_19 = tmpvar_21;
  };
  highp float tmpvar_22;
  tmpvar_22 = (tmpvar_19.x - min (tmpvar_19.w, tmpvar_19.y));
  highp vec3 tmpvar_23;
  tmpvar_23.x = abs(((
    (tmpvar_19.w - tmpvar_19.y)
   / 
    ((6.0 * tmpvar_22) + 1e-7)
  ) + tmpvar_19.z));
  tmpvar_23.y = tmpvar_22;
  tmpvar_23.z = tmpvar_19.x;
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_19.x - (tmpvar_22 * 0.5));
  highp vec3 tmpvar_25;
  tmpvar_25.x = tmpvar_23.x;
  tmpvar_25.y = (tmpvar_22 / ((1.0 - 
    abs(((2.0 * tmpvar_24) - 1.0))
  ) + 1e-7));
  tmpvar_25.z = tmpvar_24;
  highp vec3 tmpvar_26;
  tmpvar_26.x = (abs((
    (6.0 * tmpvar_23.x)
   - 3.0)) - 1.0);
  tmpvar_26.y = (2.0 - abs((
    (6.0 * tmpvar_23.x)
   - 2.0)));
  tmpvar_26.z = (2.0 - abs((
    (6.0 * tmpvar_23.x)
   - 4.0)));
  resultColor_3.xyz = (((
    clamp (tmpvar_26, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_14) - 1.0)))
   * tmpvar_25.y)) + tmpvar_14);
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VELOCITY","BLEND_COLOR"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 rgb_9;
  rgb_9 = srcColor_6.xyz;
  highp vec4 tmpvar_10;
  if ((srcColor_6.y < srcColor_6.z)) {
    highp vec4 tmpvar_11;
    tmpvar_11.zw = vec2(-1.0, 0.6666667);
    tmpvar_11.xy = rgb_9.zy;
    tmpvar_10 = tmpvar_11;
  } else {
    highp vec4 tmpvar_12;
    tmpvar_12.zw = vec2(0.0, -0.3333333);
    tmpvar_12.xy = rgb_9.yz;
    tmpvar_10 = tmpvar_12;
  };
  highp vec4 tmpvar_13;
  if ((srcColor_6.x < tmpvar_10.x)) {
    highp vec4 tmpvar_14;
    tmpvar_14.xyz = tmpvar_10.xyw;
    tmpvar_14.w = rgb_9.x;
    tmpvar_13 = tmpvar_14;
  } else {
    highp vec4 tmpvar_15;
    tmpvar_15.x = rgb_9.x;
    tmpvar_15.yzw = tmpvar_10.yzx;
    tmpvar_13 = tmpvar_15;
  };
  highp float tmpvar_16;
  tmpvar_16 = (tmpvar_13.x - ((tmpvar_13.x - 
    min (tmpvar_13.w, tmpvar_13.y)
  ) * 0.5));
  highp vec3 rgb_17;
  rgb_17 = tmpvar_4.xyz;
  highp vec4 tmpvar_18;
  if ((tmpvar_4.y < tmpvar_4.z)) {
    highp vec4 tmpvar_19;
    tmpvar_19.zw = vec2(-1.0, 0.6666667);
    tmpvar_19.xy = rgb_17.zy;
    tmpvar_18 = tmpvar_19;
  } else {
    highp vec4 tmpvar_20;
    tmpvar_20.zw = vec2(0.0, -0.3333333);
    tmpvar_20.xy = rgb_17.yz;
    tmpvar_18 = tmpvar_20;
  };
  highp vec4 tmpvar_21;
  if ((tmpvar_4.x < tmpvar_18.x)) {
    highp vec4 tmpvar_22;
    tmpvar_22.xyz = tmpvar_18.xyw;
    tmpvar_22.w = rgb_17.x;
    tmpvar_21 = tmpvar_22;
  } else {
    highp vec4 tmpvar_23;
    tmpvar_23.x = rgb_17.x;
    tmpvar_23.yzw = tmpvar_18.yzx;
    tmpvar_21 = tmpvar_23;
  };
  highp float tmpvar_24;
  tmpvar_24 = (tmpvar_21.x - min (tmpvar_21.w, tmpvar_21.y));
  highp vec3 tmpvar_25;
  tmpvar_25.x = abs(((
    (tmpvar_21.w - tmpvar_21.y)
   / 
    ((6.0 * tmpvar_24) + 1e-7)
  ) + tmpvar_21.z));
  tmpvar_25.y = tmpvar_24;
  tmpvar_25.z = tmpvar_21.x;
  highp float tmpvar_26;
  tmpvar_26 = (tmpvar_21.x - (tmpvar_24 * 0.5));
  highp vec3 tmpvar_27;
  tmpvar_27.x = tmpvar_25.x;
  tmpvar_27.y = (tmpvar_24 / ((1.0 - 
    abs(((2.0 * tmpvar_26) - 1.0))
  ) + 1e-7));
  tmpvar_27.z = tmpvar_26;
  highp vec3 tmpvar_28;
  tmpvar_28.x = (abs((
    (6.0 * tmpvar_25.x)
   - 3.0)) - 1.0);
  tmpvar_28.y = (2.0 - abs((
    (6.0 * tmpvar_25.x)
   - 2.0)));
  tmpvar_28.z = (2.0 - abs((
    (6.0 * tmpvar_25.x)
   - 4.0)));
  resultColor_2.xyz = (((
    clamp (tmpvar_28, vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   - 0.5) * (
    (1.0 - abs(((2.0 * tmpvar_16) - 1.0)))
   * tmpvar_27.y)) + tmpvar_16);
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPLANE","BLEND_BLEND"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3.xyz = ((dot (vec3(0.299, 0.587, 0.114), xlt_fbColor_1.xyz) * 1.68) * tmpvar_5.xyz);
  resultColor_3.w = (_Opacity * tmpvar_5.w);
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPLANE","BLEND_BLEND"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  highp vec4 srcColor_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture (TEXTURE_GRAP, tmpvar_6);
  srcColor_5 = tmpvar_7;
  resultColor_2.xyz = ((dot (vec3(0.299, 0.587, 0.114), srcColor_5.xyz) * 1.68) * tmpvar_4.xyz);
  resultColor_2.w = (_Opacity * tmpvar_4.w);
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPOSITION","BLEND_BLEND"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3.xyz = ((dot (vec3(0.299, 0.587, 0.114), xlt_fbColor_1.xyz) * 1.68) * tmpvar_5.xyz);
  resultColor_3.w = (_Opacity * tmpvar_5.w);
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPOSITION","BLEND_BLEND"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  highp vec4 srcColor_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture (TEXTURE_GRAP, tmpvar_6);
  srcColor_5 = tmpvar_7;
  resultColor_2.xyz = ((dot (vec3(0.299, 0.587, 0.114), srcColor_5.xyz) * 1.68) * tmpvar_4.xyz);
  resultColor_2.w = (_Opacity * tmpvar_4.w);
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","AXIS","BLEND_BLEND"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3.xyz = ((dot (vec3(0.299, 0.587, 0.114), xlt_fbColor_1.xyz) * 1.68) * tmpvar_5.xyz);
  resultColor_3.w = (_Opacity * tmpvar_5.w);
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"AXIS","BLEND_BLEND"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  highp vec4 srcColor_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture (TEXTURE_GRAP, tmpvar_6);
  srcColor_5 = tmpvar_7;
  resultColor_2.xyz = ((dot (vec3(0.299, 0.587, 0.114), srcColor_5.xyz) * 1.68) * tmpvar_4.xyz);
  resultColor_2.w = (_Opacity * tmpvar_4.w);
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VELOCITY","BLEND_BLEND"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3.xyz = ((dot (vec3(0.299, 0.587, 0.114), xlt_fbColor_1.xyz) * 1.68) * tmpvar_5.xyz);
  resultColor_3.w = (_Opacity * tmpvar_5.w);
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VELOCITY","BLEND_BLEND"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  highp vec4 srcColor_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture (TEXTURE_GRAP, tmpvar_6);
  srcColor_5 = tmpvar_7;
  resultColor_2.xyz = ((dot (vec3(0.299, 0.587, 0.114), srcColor_5.xyz) * 1.68) * tmpvar_4.xyz);
  resultColor_2.w = (_Opacity * tmpvar_4.w);
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPLANE","BLEND_EXCLUSION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3.xyz = ((xlt_fbColor_1.xyz + tmpvar_5.xyz) - ((2.0 * xlt_fbColor_1.xyz) * tmpvar_5.xyz));
  resultColor_3.w = (_Opacity * tmpvar_5.w);
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPLANE","BLEND_EXCLUSION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  highp vec4 srcColor_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture (TEXTURE_GRAP, tmpvar_6);
  srcColor_5 = tmpvar_7;
  resultColor_2.xyz = ((srcColor_5.xyz + tmpvar_4.xyz) - ((2.0 * srcColor_5.xyz) * tmpvar_4.xyz));
  resultColor_2.w = (_Opacity * tmpvar_4.w);
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPOSITION","BLEND_EXCLUSION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3.xyz = ((xlt_fbColor_1.xyz + tmpvar_5.xyz) - ((2.0 * xlt_fbColor_1.xyz) * tmpvar_5.xyz));
  resultColor_3.w = (_Opacity * tmpvar_5.w);
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPOSITION","BLEND_EXCLUSION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  highp vec4 srcColor_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture (TEXTURE_GRAP, tmpvar_6);
  srcColor_5 = tmpvar_7;
  resultColor_2.xyz = ((srcColor_5.xyz + tmpvar_4.xyz) - ((2.0 * srcColor_5.xyz) * tmpvar_4.xyz));
  resultColor_2.w = (_Opacity * tmpvar_4.w);
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","AXIS","BLEND_EXCLUSION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3.xyz = ((xlt_fbColor_1.xyz + tmpvar_5.xyz) - ((2.0 * xlt_fbColor_1.xyz) * tmpvar_5.xyz));
  resultColor_3.w = (_Opacity * tmpvar_5.w);
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"AXIS","BLEND_EXCLUSION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  highp vec4 srcColor_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture (TEXTURE_GRAP, tmpvar_6);
  srcColor_5 = tmpvar_7;
  resultColor_2.xyz = ((srcColor_5.xyz + tmpvar_4.xyz) - ((2.0 * srcColor_5.xyz) * tmpvar_4.xyz));
  resultColor_2.w = (_Opacity * tmpvar_4.w);
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VELOCITY","BLEND_EXCLUSION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3.xyz = ((xlt_fbColor_1.xyz + tmpvar_5.xyz) - ((2.0 * xlt_fbColor_1.xyz) * tmpvar_5.xyz));
  resultColor_3.w = (_Opacity * tmpvar_5.w);
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VELOCITY","BLEND_EXCLUSION"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  highp vec4 srcColor_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture (TEXTURE_GRAP, tmpvar_6);
  srcColor_5 = tmpvar_7;
  resultColor_2.xyz = ((srcColor_5.xyz + tmpvar_4.xyz) - ((2.0 * srcColor_5.xyz) * tmpvar_4.xyz));
  resultColor_2.w = (_Opacity * tmpvar_4.w);
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPLANE","BLEND_HARDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp float tmpvar_7;
  if ((tmpvar_5.x < 0.5)) {
    tmpvar_7 = ((2.0 * tmpvar_5.x) * xlt_fbColor_1.x);
  } else {
    tmpvar_7 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_5.x)
    ) * (1.0 - xlt_fbColor_1.x)));
  };
  highp float tmpvar_8;
  if ((tmpvar_5.y < 0.5)) {
    tmpvar_8 = ((2.0 * tmpvar_5.y) * xlt_fbColor_1.y);
  } else {
    tmpvar_8 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_5.y)
    ) * (1.0 - xlt_fbColor_1.y)));
  };
  highp float tmpvar_9;
  if ((tmpvar_5.z < 0.5)) {
    tmpvar_9 = ((2.0 * tmpvar_5.z) * xlt_fbColor_1.z);
  } else {
    tmpvar_9 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_5.z)
    ) * (1.0 - xlt_fbColor_1.z)));
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_7;
  tmpvar_10.y = tmpvar_8;
  tmpvar_10.z = tmpvar_9;
  resultColor_3.xyz = tmpvar_10;
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPLANE","BLEND_HARDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp float tmpvar_9;
  if ((tmpvar_4.x < 0.5)) {
    tmpvar_9 = ((2.0 * tmpvar_4.x) * srcColor_6.x);
  } else {
    tmpvar_9 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_4.x)
    ) * (1.0 - srcColor_6.x)));
  };
  highp float tmpvar_10;
  if ((tmpvar_4.y < 0.5)) {
    tmpvar_10 = ((2.0 * tmpvar_4.y) * srcColor_6.y);
  } else {
    tmpvar_10 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_4.y)
    ) * (1.0 - srcColor_6.y)));
  };
  highp float tmpvar_11;
  if ((tmpvar_4.z < 0.5)) {
    tmpvar_11 = ((2.0 * tmpvar_4.z) * srcColor_6.z);
  } else {
    tmpvar_11 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_4.z)
    ) * (1.0 - srcColor_6.z)));
  };
  highp vec3 tmpvar_12;
  tmpvar_12.x = tmpvar_9;
  tmpvar_12.y = tmpvar_10;
  tmpvar_12.z = tmpvar_11;
  resultColor_2.xyz = tmpvar_12;
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPOSITION","BLEND_HARDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp float tmpvar_7;
  if ((tmpvar_5.x < 0.5)) {
    tmpvar_7 = ((2.0 * tmpvar_5.x) * xlt_fbColor_1.x);
  } else {
    tmpvar_7 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_5.x)
    ) * (1.0 - xlt_fbColor_1.x)));
  };
  highp float tmpvar_8;
  if ((tmpvar_5.y < 0.5)) {
    tmpvar_8 = ((2.0 * tmpvar_5.y) * xlt_fbColor_1.y);
  } else {
    tmpvar_8 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_5.y)
    ) * (1.0 - xlt_fbColor_1.y)));
  };
  highp float tmpvar_9;
  if ((tmpvar_5.z < 0.5)) {
    tmpvar_9 = ((2.0 * tmpvar_5.z) * xlt_fbColor_1.z);
  } else {
    tmpvar_9 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_5.z)
    ) * (1.0 - xlt_fbColor_1.z)));
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_7;
  tmpvar_10.y = tmpvar_8;
  tmpvar_10.z = tmpvar_9;
  resultColor_3.xyz = tmpvar_10;
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPOSITION","BLEND_HARDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp float tmpvar_9;
  if ((tmpvar_4.x < 0.5)) {
    tmpvar_9 = ((2.0 * tmpvar_4.x) * srcColor_6.x);
  } else {
    tmpvar_9 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_4.x)
    ) * (1.0 - srcColor_6.x)));
  };
  highp float tmpvar_10;
  if ((tmpvar_4.y < 0.5)) {
    tmpvar_10 = ((2.0 * tmpvar_4.y) * srcColor_6.y);
  } else {
    tmpvar_10 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_4.y)
    ) * (1.0 - srcColor_6.y)));
  };
  highp float tmpvar_11;
  if ((tmpvar_4.z < 0.5)) {
    tmpvar_11 = ((2.0 * tmpvar_4.z) * srcColor_6.z);
  } else {
    tmpvar_11 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_4.z)
    ) * (1.0 - srcColor_6.z)));
  };
  highp vec3 tmpvar_12;
  tmpvar_12.x = tmpvar_9;
  tmpvar_12.y = tmpvar_10;
  tmpvar_12.z = tmpvar_11;
  resultColor_2.xyz = tmpvar_12;
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","AXIS","BLEND_HARDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp float tmpvar_7;
  if ((tmpvar_5.x < 0.5)) {
    tmpvar_7 = ((2.0 * tmpvar_5.x) * xlt_fbColor_1.x);
  } else {
    tmpvar_7 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_5.x)
    ) * (1.0 - xlt_fbColor_1.x)));
  };
  highp float tmpvar_8;
  if ((tmpvar_5.y < 0.5)) {
    tmpvar_8 = ((2.0 * tmpvar_5.y) * xlt_fbColor_1.y);
  } else {
    tmpvar_8 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_5.y)
    ) * (1.0 - xlt_fbColor_1.y)));
  };
  highp float tmpvar_9;
  if ((tmpvar_5.z < 0.5)) {
    tmpvar_9 = ((2.0 * tmpvar_5.z) * xlt_fbColor_1.z);
  } else {
    tmpvar_9 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_5.z)
    ) * (1.0 - xlt_fbColor_1.z)));
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_7;
  tmpvar_10.y = tmpvar_8;
  tmpvar_10.z = tmpvar_9;
  resultColor_3.xyz = tmpvar_10;
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"AXIS","BLEND_HARDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp float tmpvar_9;
  if ((tmpvar_4.x < 0.5)) {
    tmpvar_9 = ((2.0 * tmpvar_4.x) * srcColor_6.x);
  } else {
    tmpvar_9 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_4.x)
    ) * (1.0 - srcColor_6.x)));
  };
  highp float tmpvar_10;
  if ((tmpvar_4.y < 0.5)) {
    tmpvar_10 = ((2.0 * tmpvar_4.y) * srcColor_6.y);
  } else {
    tmpvar_10 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_4.y)
    ) * (1.0 - srcColor_6.y)));
  };
  highp float tmpvar_11;
  if ((tmpvar_4.z < 0.5)) {
    tmpvar_11 = ((2.0 * tmpvar_4.z) * srcColor_6.z);
  } else {
    tmpvar_11 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_4.z)
    ) * (1.0 - srcColor_6.z)));
  };
  highp vec3 tmpvar_12;
  tmpvar_12.x = tmpvar_9;
  tmpvar_12.y = tmpvar_10;
  tmpvar_12.z = tmpvar_11;
  resultColor_2.xyz = tmpvar_12;
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VELOCITY","BLEND_HARDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp float tmpvar_7;
  if ((tmpvar_5.x < 0.5)) {
    tmpvar_7 = ((2.0 * tmpvar_5.x) * xlt_fbColor_1.x);
  } else {
    tmpvar_7 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_5.x)
    ) * (1.0 - xlt_fbColor_1.x)));
  };
  highp float tmpvar_8;
  if ((tmpvar_5.y < 0.5)) {
    tmpvar_8 = ((2.0 * tmpvar_5.y) * xlt_fbColor_1.y);
  } else {
    tmpvar_8 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_5.y)
    ) * (1.0 - xlt_fbColor_1.y)));
  };
  highp float tmpvar_9;
  if ((tmpvar_5.z < 0.5)) {
    tmpvar_9 = ((2.0 * tmpvar_5.z) * xlt_fbColor_1.z);
  } else {
    tmpvar_9 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_5.z)
    ) * (1.0 - xlt_fbColor_1.z)));
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_7;
  tmpvar_10.y = tmpvar_8;
  tmpvar_10.z = tmpvar_9;
  resultColor_3.xyz = tmpvar_10;
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VELOCITY","BLEND_HARDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp float tmpvar_9;
  if ((tmpvar_4.x < 0.5)) {
    tmpvar_9 = ((2.0 * tmpvar_4.x) * srcColor_6.x);
  } else {
    tmpvar_9 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_4.x)
    ) * (1.0 - srcColor_6.x)));
  };
  highp float tmpvar_10;
  if ((tmpvar_4.y < 0.5)) {
    tmpvar_10 = ((2.0 * tmpvar_4.y) * srcColor_6.y);
  } else {
    tmpvar_10 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_4.y)
    ) * (1.0 - srcColor_6.y)));
  };
  highp float tmpvar_11;
  if ((tmpvar_4.z < 0.5)) {
    tmpvar_11 = ((2.0 * tmpvar_4.z) * srcColor_6.z);
  } else {
    tmpvar_11 = (1.0 - ((2.0 * 
      (1.0 - tmpvar_4.z)
    ) * (1.0 - srcColor_6.z)));
  };
  highp vec3 tmpvar_12;
  tmpvar_12.x = tmpvar_9;
  tmpvar_12.y = tmpvar_10;
  tmpvar_12.z = tmpvar_11;
  resultColor_2.xyz = tmpvar_12;
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPLANE","BLEND_VIVIDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp float factor_3;
  highp vec4 resultColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_6;
  tmpvar_6 = (tmpvar_5 * xlv_TEXCOORD2);
  resultColor_4 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_3 = (_Opacity * tmpvar_6.w);
  highp float tmpvar_7;
  if ((tmpvar_6.x < 0.5)) {
    highp float blend_8;
    blend_8 = (2.0 * tmpvar_6.x);
    highp float tmpvar_9;
    if ((blend_8 == 0.0)) {
      tmpvar_9 = blend_8;
    } else {
      tmpvar_9 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.x)
       / blend_8)), 0.0);
    };
    tmpvar_7 = tmpvar_9;
  } else {
    highp float blend_10;
    blend_10 = (2.0 * (tmpvar_6.x - 0.5));
    highp float tmpvar_11;
    if ((blend_10 == 1.0)) {
      tmpvar_11 = blend_10;
    } else {
      tmpvar_11 = min ((xlt_fbColor_1.x / (1.0 - blend_10)), 1.0);
    };
    tmpvar_7 = tmpvar_11;
  };
  highp float tmpvar_12;
  if ((tmpvar_6.y < 0.5)) {
    highp float blend_13;
    blend_13 = (2.0 * tmpvar_6.y);
    highp float tmpvar_14;
    if ((blend_13 == 0.0)) {
      tmpvar_14 = blend_13;
    } else {
      tmpvar_14 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.y)
       / blend_13)), 0.0);
    };
    tmpvar_12 = tmpvar_14;
  } else {
    highp float blend_15;
    blend_15 = (2.0 * (tmpvar_6.y - 0.5));
    highp float tmpvar_16;
    if ((blend_15 == 1.0)) {
      tmpvar_16 = blend_15;
    } else {
      tmpvar_16 = min ((xlt_fbColor_1.y / (1.0 - blend_15)), 1.0);
    };
    tmpvar_12 = tmpvar_16;
  };
  highp float tmpvar_17;
  if ((tmpvar_6.z < 0.5)) {
    highp float blend_18;
    blend_18 = (2.0 * tmpvar_6.z);
    highp float tmpvar_19;
    if ((blend_18 == 0.0)) {
      tmpvar_19 = blend_18;
    } else {
      tmpvar_19 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.z)
       / blend_18)), 0.0);
    };
    tmpvar_17 = tmpvar_19;
  } else {
    highp float blend_20;
    blend_20 = (2.0 * (tmpvar_6.z - 0.5));
    highp float tmpvar_21;
    if ((blend_20 == 1.0)) {
      tmpvar_21 = blend_20;
    } else {
      tmpvar_21 = min ((xlt_fbColor_1.z / (1.0 - blend_20)), 1.0);
    };
    tmpvar_17 = tmpvar_21;
  };
  highp vec3 tmpvar_22;
  tmpvar_22.x = tmpvar_7;
  tmpvar_22.y = tmpvar_12;
  tmpvar_22.z = tmpvar_17;
  resultColor_4.xyz = tmpvar_22;
  resultColor_4.w = factor_3;
  xlt_fbColor_1 = resultColor_4;
  _glesFragData[0] = resultColor_4;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPLANE","BLEND_VIVIDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp float factor_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_2 = (_Opacity * tmpvar_5.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp float tmpvar_9;
  if ((tmpvar_5.x < 0.5)) {
    highp float blend_10;
    blend_10 = (2.0 * tmpvar_5.x);
    highp float tmpvar_11;
    if ((blend_10 == 0.0)) {
      tmpvar_11 = blend_10;
    } else {
      tmpvar_11 = max ((1.0 - (
        (1.0 - srcColor_6.x)
       / blend_10)), 0.0);
    };
    tmpvar_9 = tmpvar_11;
  } else {
    highp float blend_12;
    blend_12 = (2.0 * (tmpvar_5.x - 0.5));
    highp float tmpvar_13;
    if ((blend_12 == 1.0)) {
      tmpvar_13 = blend_12;
    } else {
      tmpvar_13 = min ((srcColor_6.x / (1.0 - blend_12)), 1.0);
    };
    tmpvar_9 = tmpvar_13;
  };
  highp float tmpvar_14;
  if ((tmpvar_5.y < 0.5)) {
    highp float blend_15;
    blend_15 = (2.0 * tmpvar_5.y);
    highp float tmpvar_16;
    if ((blend_15 == 0.0)) {
      tmpvar_16 = blend_15;
    } else {
      tmpvar_16 = max ((1.0 - (
        (1.0 - srcColor_6.y)
       / blend_15)), 0.0);
    };
    tmpvar_14 = tmpvar_16;
  } else {
    highp float blend_17;
    blend_17 = (2.0 * (tmpvar_5.y - 0.5));
    highp float tmpvar_18;
    if ((blend_17 == 1.0)) {
      tmpvar_18 = blend_17;
    } else {
      tmpvar_18 = min ((srcColor_6.y / (1.0 - blend_17)), 1.0);
    };
    tmpvar_14 = tmpvar_18;
  };
  highp float tmpvar_19;
  if ((tmpvar_5.z < 0.5)) {
    highp float blend_20;
    blend_20 = (2.0 * tmpvar_5.z);
    highp float tmpvar_21;
    if ((blend_20 == 0.0)) {
      tmpvar_21 = blend_20;
    } else {
      tmpvar_21 = max ((1.0 - (
        (1.0 - srcColor_6.z)
       / blend_20)), 0.0);
    };
    tmpvar_19 = tmpvar_21;
  } else {
    highp float blend_22;
    blend_22 = (2.0 * (tmpvar_5.z - 0.5));
    highp float tmpvar_23;
    if ((blend_22 == 1.0)) {
      tmpvar_23 = blend_22;
    } else {
      tmpvar_23 = min ((srcColor_6.z / (1.0 - blend_22)), 1.0);
    };
    tmpvar_19 = tmpvar_23;
  };
  highp vec3 tmpvar_24;
  tmpvar_24.x = tmpvar_9;
  tmpvar_24.y = tmpvar_14;
  tmpvar_24.z = tmpvar_19;
  resultColor_3.xyz = tmpvar_24;
  resultColor_3.w = factor_2;
  tmpvar_1 = resultColor_3;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPOSITION","BLEND_VIVIDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp float factor_3;
  highp vec4 resultColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_6;
  tmpvar_6 = (tmpvar_5 * xlv_TEXCOORD2);
  resultColor_4 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_3 = (_Opacity * tmpvar_6.w);
  highp float tmpvar_7;
  if ((tmpvar_6.x < 0.5)) {
    highp float blend_8;
    blend_8 = (2.0 * tmpvar_6.x);
    highp float tmpvar_9;
    if ((blend_8 == 0.0)) {
      tmpvar_9 = blend_8;
    } else {
      tmpvar_9 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.x)
       / blend_8)), 0.0);
    };
    tmpvar_7 = tmpvar_9;
  } else {
    highp float blend_10;
    blend_10 = (2.0 * (tmpvar_6.x - 0.5));
    highp float tmpvar_11;
    if ((blend_10 == 1.0)) {
      tmpvar_11 = blend_10;
    } else {
      tmpvar_11 = min ((xlt_fbColor_1.x / (1.0 - blend_10)), 1.0);
    };
    tmpvar_7 = tmpvar_11;
  };
  highp float tmpvar_12;
  if ((tmpvar_6.y < 0.5)) {
    highp float blend_13;
    blend_13 = (2.0 * tmpvar_6.y);
    highp float tmpvar_14;
    if ((blend_13 == 0.0)) {
      tmpvar_14 = blend_13;
    } else {
      tmpvar_14 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.y)
       / blend_13)), 0.0);
    };
    tmpvar_12 = tmpvar_14;
  } else {
    highp float blend_15;
    blend_15 = (2.0 * (tmpvar_6.y - 0.5));
    highp float tmpvar_16;
    if ((blend_15 == 1.0)) {
      tmpvar_16 = blend_15;
    } else {
      tmpvar_16 = min ((xlt_fbColor_1.y / (1.0 - blend_15)), 1.0);
    };
    tmpvar_12 = tmpvar_16;
  };
  highp float tmpvar_17;
  if ((tmpvar_6.z < 0.5)) {
    highp float blend_18;
    blend_18 = (2.0 * tmpvar_6.z);
    highp float tmpvar_19;
    if ((blend_18 == 0.0)) {
      tmpvar_19 = blend_18;
    } else {
      tmpvar_19 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.z)
       / blend_18)), 0.0);
    };
    tmpvar_17 = tmpvar_19;
  } else {
    highp float blend_20;
    blend_20 = (2.0 * (tmpvar_6.z - 0.5));
    highp float tmpvar_21;
    if ((blend_20 == 1.0)) {
      tmpvar_21 = blend_20;
    } else {
      tmpvar_21 = min ((xlt_fbColor_1.z / (1.0 - blend_20)), 1.0);
    };
    tmpvar_17 = tmpvar_21;
  };
  highp vec3 tmpvar_22;
  tmpvar_22.x = tmpvar_7;
  tmpvar_22.y = tmpvar_12;
  tmpvar_22.z = tmpvar_17;
  resultColor_4.xyz = tmpvar_22;
  resultColor_4.w = factor_3;
  xlt_fbColor_1 = resultColor_4;
  _glesFragData[0] = resultColor_4;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPOSITION","BLEND_VIVIDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp float factor_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_2 = (_Opacity * tmpvar_5.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp float tmpvar_9;
  if ((tmpvar_5.x < 0.5)) {
    highp float blend_10;
    blend_10 = (2.0 * tmpvar_5.x);
    highp float tmpvar_11;
    if ((blend_10 == 0.0)) {
      tmpvar_11 = blend_10;
    } else {
      tmpvar_11 = max ((1.0 - (
        (1.0 - srcColor_6.x)
       / blend_10)), 0.0);
    };
    tmpvar_9 = tmpvar_11;
  } else {
    highp float blend_12;
    blend_12 = (2.0 * (tmpvar_5.x - 0.5));
    highp float tmpvar_13;
    if ((blend_12 == 1.0)) {
      tmpvar_13 = blend_12;
    } else {
      tmpvar_13 = min ((srcColor_6.x / (1.0 - blend_12)), 1.0);
    };
    tmpvar_9 = tmpvar_13;
  };
  highp float tmpvar_14;
  if ((tmpvar_5.y < 0.5)) {
    highp float blend_15;
    blend_15 = (2.0 * tmpvar_5.y);
    highp float tmpvar_16;
    if ((blend_15 == 0.0)) {
      tmpvar_16 = blend_15;
    } else {
      tmpvar_16 = max ((1.0 - (
        (1.0 - srcColor_6.y)
       / blend_15)), 0.0);
    };
    tmpvar_14 = tmpvar_16;
  } else {
    highp float blend_17;
    blend_17 = (2.0 * (tmpvar_5.y - 0.5));
    highp float tmpvar_18;
    if ((blend_17 == 1.0)) {
      tmpvar_18 = blend_17;
    } else {
      tmpvar_18 = min ((srcColor_6.y / (1.0 - blend_17)), 1.0);
    };
    tmpvar_14 = tmpvar_18;
  };
  highp float tmpvar_19;
  if ((tmpvar_5.z < 0.5)) {
    highp float blend_20;
    blend_20 = (2.0 * tmpvar_5.z);
    highp float tmpvar_21;
    if ((blend_20 == 0.0)) {
      tmpvar_21 = blend_20;
    } else {
      tmpvar_21 = max ((1.0 - (
        (1.0 - srcColor_6.z)
       / blend_20)), 0.0);
    };
    tmpvar_19 = tmpvar_21;
  } else {
    highp float blend_22;
    blend_22 = (2.0 * (tmpvar_5.z - 0.5));
    highp float tmpvar_23;
    if ((blend_22 == 1.0)) {
      tmpvar_23 = blend_22;
    } else {
      tmpvar_23 = min ((srcColor_6.z / (1.0 - blend_22)), 1.0);
    };
    tmpvar_19 = tmpvar_23;
  };
  highp vec3 tmpvar_24;
  tmpvar_24.x = tmpvar_9;
  tmpvar_24.y = tmpvar_14;
  tmpvar_24.z = tmpvar_19;
  resultColor_3.xyz = tmpvar_24;
  resultColor_3.w = factor_2;
  tmpvar_1 = resultColor_3;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","AXIS","BLEND_VIVIDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp float factor_3;
  highp vec4 resultColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_6;
  tmpvar_6 = (tmpvar_5 * xlv_TEXCOORD2);
  resultColor_4 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_3 = (_Opacity * tmpvar_6.w);
  highp float tmpvar_7;
  if ((tmpvar_6.x < 0.5)) {
    highp float blend_8;
    blend_8 = (2.0 * tmpvar_6.x);
    highp float tmpvar_9;
    if ((blend_8 == 0.0)) {
      tmpvar_9 = blend_8;
    } else {
      tmpvar_9 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.x)
       / blend_8)), 0.0);
    };
    tmpvar_7 = tmpvar_9;
  } else {
    highp float blend_10;
    blend_10 = (2.0 * (tmpvar_6.x - 0.5));
    highp float tmpvar_11;
    if ((blend_10 == 1.0)) {
      tmpvar_11 = blend_10;
    } else {
      tmpvar_11 = min ((xlt_fbColor_1.x / (1.0 - blend_10)), 1.0);
    };
    tmpvar_7 = tmpvar_11;
  };
  highp float tmpvar_12;
  if ((tmpvar_6.y < 0.5)) {
    highp float blend_13;
    blend_13 = (2.0 * tmpvar_6.y);
    highp float tmpvar_14;
    if ((blend_13 == 0.0)) {
      tmpvar_14 = blend_13;
    } else {
      tmpvar_14 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.y)
       / blend_13)), 0.0);
    };
    tmpvar_12 = tmpvar_14;
  } else {
    highp float blend_15;
    blend_15 = (2.0 * (tmpvar_6.y - 0.5));
    highp float tmpvar_16;
    if ((blend_15 == 1.0)) {
      tmpvar_16 = blend_15;
    } else {
      tmpvar_16 = min ((xlt_fbColor_1.y / (1.0 - blend_15)), 1.0);
    };
    tmpvar_12 = tmpvar_16;
  };
  highp float tmpvar_17;
  if ((tmpvar_6.z < 0.5)) {
    highp float blend_18;
    blend_18 = (2.0 * tmpvar_6.z);
    highp float tmpvar_19;
    if ((blend_18 == 0.0)) {
      tmpvar_19 = blend_18;
    } else {
      tmpvar_19 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.z)
       / blend_18)), 0.0);
    };
    tmpvar_17 = tmpvar_19;
  } else {
    highp float blend_20;
    blend_20 = (2.0 * (tmpvar_6.z - 0.5));
    highp float tmpvar_21;
    if ((blend_20 == 1.0)) {
      tmpvar_21 = blend_20;
    } else {
      tmpvar_21 = min ((xlt_fbColor_1.z / (1.0 - blend_20)), 1.0);
    };
    tmpvar_17 = tmpvar_21;
  };
  highp vec3 tmpvar_22;
  tmpvar_22.x = tmpvar_7;
  tmpvar_22.y = tmpvar_12;
  tmpvar_22.z = tmpvar_17;
  resultColor_4.xyz = tmpvar_22;
  resultColor_4.w = factor_3;
  xlt_fbColor_1 = resultColor_4;
  _glesFragData[0] = resultColor_4;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"AXIS","BLEND_VIVIDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp float factor_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_2 = (_Opacity * tmpvar_5.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp float tmpvar_9;
  if ((tmpvar_5.x < 0.5)) {
    highp float blend_10;
    blend_10 = (2.0 * tmpvar_5.x);
    highp float tmpvar_11;
    if ((blend_10 == 0.0)) {
      tmpvar_11 = blend_10;
    } else {
      tmpvar_11 = max ((1.0 - (
        (1.0 - srcColor_6.x)
       / blend_10)), 0.0);
    };
    tmpvar_9 = tmpvar_11;
  } else {
    highp float blend_12;
    blend_12 = (2.0 * (tmpvar_5.x - 0.5));
    highp float tmpvar_13;
    if ((blend_12 == 1.0)) {
      tmpvar_13 = blend_12;
    } else {
      tmpvar_13 = min ((srcColor_6.x / (1.0 - blend_12)), 1.0);
    };
    tmpvar_9 = tmpvar_13;
  };
  highp float tmpvar_14;
  if ((tmpvar_5.y < 0.5)) {
    highp float blend_15;
    blend_15 = (2.0 * tmpvar_5.y);
    highp float tmpvar_16;
    if ((blend_15 == 0.0)) {
      tmpvar_16 = blend_15;
    } else {
      tmpvar_16 = max ((1.0 - (
        (1.0 - srcColor_6.y)
       / blend_15)), 0.0);
    };
    tmpvar_14 = tmpvar_16;
  } else {
    highp float blend_17;
    blend_17 = (2.0 * (tmpvar_5.y - 0.5));
    highp float tmpvar_18;
    if ((blend_17 == 1.0)) {
      tmpvar_18 = blend_17;
    } else {
      tmpvar_18 = min ((srcColor_6.y / (1.0 - blend_17)), 1.0);
    };
    tmpvar_14 = tmpvar_18;
  };
  highp float tmpvar_19;
  if ((tmpvar_5.z < 0.5)) {
    highp float blend_20;
    blend_20 = (2.0 * tmpvar_5.z);
    highp float tmpvar_21;
    if ((blend_20 == 0.0)) {
      tmpvar_21 = blend_20;
    } else {
      tmpvar_21 = max ((1.0 - (
        (1.0 - srcColor_6.z)
       / blend_20)), 0.0);
    };
    tmpvar_19 = tmpvar_21;
  } else {
    highp float blend_22;
    blend_22 = (2.0 * (tmpvar_5.z - 0.5));
    highp float tmpvar_23;
    if ((blend_22 == 1.0)) {
      tmpvar_23 = blend_22;
    } else {
      tmpvar_23 = min ((srcColor_6.z / (1.0 - blend_22)), 1.0);
    };
    tmpvar_19 = tmpvar_23;
  };
  highp vec3 tmpvar_24;
  tmpvar_24.x = tmpvar_9;
  tmpvar_24.y = tmpvar_14;
  tmpvar_24.z = tmpvar_19;
  resultColor_3.xyz = tmpvar_24;
  resultColor_3.w = factor_2;
  tmpvar_1 = resultColor_3;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VELOCITY","BLEND_VIVIDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp float factor_3;
  highp vec4 resultColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_6;
  tmpvar_6 = (tmpvar_5 * xlv_TEXCOORD2);
  resultColor_4 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_3 = (_Opacity * tmpvar_6.w);
  highp float tmpvar_7;
  if ((tmpvar_6.x < 0.5)) {
    highp float blend_8;
    blend_8 = (2.0 * tmpvar_6.x);
    highp float tmpvar_9;
    if ((blend_8 == 0.0)) {
      tmpvar_9 = blend_8;
    } else {
      tmpvar_9 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.x)
       / blend_8)), 0.0);
    };
    tmpvar_7 = tmpvar_9;
  } else {
    highp float blend_10;
    blend_10 = (2.0 * (tmpvar_6.x - 0.5));
    highp float tmpvar_11;
    if ((blend_10 == 1.0)) {
      tmpvar_11 = blend_10;
    } else {
      tmpvar_11 = min ((xlt_fbColor_1.x / (1.0 - blend_10)), 1.0);
    };
    tmpvar_7 = tmpvar_11;
  };
  highp float tmpvar_12;
  if ((tmpvar_6.y < 0.5)) {
    highp float blend_13;
    blend_13 = (2.0 * tmpvar_6.y);
    highp float tmpvar_14;
    if ((blend_13 == 0.0)) {
      tmpvar_14 = blend_13;
    } else {
      tmpvar_14 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.y)
       / blend_13)), 0.0);
    };
    tmpvar_12 = tmpvar_14;
  } else {
    highp float blend_15;
    blend_15 = (2.0 * (tmpvar_6.y - 0.5));
    highp float tmpvar_16;
    if ((blend_15 == 1.0)) {
      tmpvar_16 = blend_15;
    } else {
      tmpvar_16 = min ((xlt_fbColor_1.y / (1.0 - blend_15)), 1.0);
    };
    tmpvar_12 = tmpvar_16;
  };
  highp float tmpvar_17;
  if ((tmpvar_6.z < 0.5)) {
    highp float blend_18;
    blend_18 = (2.0 * tmpvar_6.z);
    highp float tmpvar_19;
    if ((blend_18 == 0.0)) {
      tmpvar_19 = blend_18;
    } else {
      tmpvar_19 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.z)
       / blend_18)), 0.0);
    };
    tmpvar_17 = tmpvar_19;
  } else {
    highp float blend_20;
    blend_20 = (2.0 * (tmpvar_6.z - 0.5));
    highp float tmpvar_21;
    if ((blend_20 == 1.0)) {
      tmpvar_21 = blend_20;
    } else {
      tmpvar_21 = min ((xlt_fbColor_1.z / (1.0 - blend_20)), 1.0);
    };
    tmpvar_17 = tmpvar_21;
  };
  highp vec3 tmpvar_22;
  tmpvar_22.x = tmpvar_7;
  tmpvar_22.y = tmpvar_12;
  tmpvar_22.z = tmpvar_17;
  resultColor_4.xyz = tmpvar_22;
  resultColor_4.w = factor_3;
  xlt_fbColor_1 = resultColor_4;
  _glesFragData[0] = resultColor_4;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VELOCITY","BLEND_VIVIDLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp float factor_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_2 = (_Opacity * tmpvar_5.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp float tmpvar_9;
  if ((tmpvar_5.x < 0.5)) {
    highp float blend_10;
    blend_10 = (2.0 * tmpvar_5.x);
    highp float tmpvar_11;
    if ((blend_10 == 0.0)) {
      tmpvar_11 = blend_10;
    } else {
      tmpvar_11 = max ((1.0 - (
        (1.0 - srcColor_6.x)
       / blend_10)), 0.0);
    };
    tmpvar_9 = tmpvar_11;
  } else {
    highp float blend_12;
    blend_12 = (2.0 * (tmpvar_5.x - 0.5));
    highp float tmpvar_13;
    if ((blend_12 == 1.0)) {
      tmpvar_13 = blend_12;
    } else {
      tmpvar_13 = min ((srcColor_6.x / (1.0 - blend_12)), 1.0);
    };
    tmpvar_9 = tmpvar_13;
  };
  highp float tmpvar_14;
  if ((tmpvar_5.y < 0.5)) {
    highp float blend_15;
    blend_15 = (2.0 * tmpvar_5.y);
    highp float tmpvar_16;
    if ((blend_15 == 0.0)) {
      tmpvar_16 = blend_15;
    } else {
      tmpvar_16 = max ((1.0 - (
        (1.0 - srcColor_6.y)
       / blend_15)), 0.0);
    };
    tmpvar_14 = tmpvar_16;
  } else {
    highp float blend_17;
    blend_17 = (2.0 * (tmpvar_5.y - 0.5));
    highp float tmpvar_18;
    if ((blend_17 == 1.0)) {
      tmpvar_18 = blend_17;
    } else {
      tmpvar_18 = min ((srcColor_6.y / (1.0 - blend_17)), 1.0);
    };
    tmpvar_14 = tmpvar_18;
  };
  highp float tmpvar_19;
  if ((tmpvar_5.z < 0.5)) {
    highp float blend_20;
    blend_20 = (2.0 * tmpvar_5.z);
    highp float tmpvar_21;
    if ((blend_20 == 0.0)) {
      tmpvar_21 = blend_20;
    } else {
      tmpvar_21 = max ((1.0 - (
        (1.0 - srcColor_6.z)
       / blend_20)), 0.0);
    };
    tmpvar_19 = tmpvar_21;
  } else {
    highp float blend_22;
    blend_22 = (2.0 * (tmpvar_5.z - 0.5));
    highp float tmpvar_23;
    if ((blend_22 == 1.0)) {
      tmpvar_23 = blend_22;
    } else {
      tmpvar_23 = min ((srcColor_6.z / (1.0 - blend_22)), 1.0);
    };
    tmpvar_19 = tmpvar_23;
  };
  highp vec3 tmpvar_24;
  tmpvar_24.x = tmpvar_9;
  tmpvar_24.y = tmpvar_14;
  tmpvar_24.z = tmpvar_19;
  resultColor_3.xyz = tmpvar_24;
  resultColor_3.w = factor_2;
  tmpvar_1 = resultColor_3;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPLANE","BLEND_OVERLAY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp float tmpvar_7;
  if ((xlt_fbColor_1.x < 0.5)) {
    tmpvar_7 = ((2.0 * xlt_fbColor_1.x) * tmpvar_5.x);
  } else {
    tmpvar_7 = (1.0 - ((2.0 * 
      (1.0 - xlt_fbColor_1.x)
    ) * (1.0 - tmpvar_5.x)));
  };
  highp float tmpvar_8;
  if ((xlt_fbColor_1.y < 0.5)) {
    tmpvar_8 = ((2.0 * xlt_fbColor_1.y) * tmpvar_5.y);
  } else {
    tmpvar_8 = (1.0 - ((2.0 * 
      (1.0 - xlt_fbColor_1.y)
    ) * (1.0 - tmpvar_5.y)));
  };
  highp float tmpvar_9;
  if ((xlt_fbColor_1.z < 0.5)) {
    tmpvar_9 = ((2.0 * xlt_fbColor_1.z) * tmpvar_5.z);
  } else {
    tmpvar_9 = (1.0 - ((2.0 * 
      (1.0 - xlt_fbColor_1.z)
    ) * (1.0 - tmpvar_5.z)));
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_7;
  tmpvar_10.y = tmpvar_8;
  tmpvar_10.z = tmpvar_9;
  resultColor_3.xyz = tmpvar_10;
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPLANE","BLEND_OVERLAY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp float tmpvar_9;
  if ((srcColor_6.x < 0.5)) {
    tmpvar_9 = ((2.0 * srcColor_6.x) * tmpvar_4.x);
  } else {
    tmpvar_9 = (1.0 - ((2.0 * 
      (1.0 - srcColor_6.x)
    ) * (1.0 - tmpvar_4.x)));
  };
  highp float tmpvar_10;
  if ((srcColor_6.y < 0.5)) {
    tmpvar_10 = ((2.0 * srcColor_6.y) * tmpvar_4.y);
  } else {
    tmpvar_10 = (1.0 - ((2.0 * 
      (1.0 - srcColor_6.y)
    ) * (1.0 - tmpvar_4.y)));
  };
  highp float tmpvar_11;
  if ((srcColor_6.z < 0.5)) {
    tmpvar_11 = ((2.0 * srcColor_6.z) * tmpvar_4.z);
  } else {
    tmpvar_11 = (1.0 - ((2.0 * 
      (1.0 - srcColor_6.z)
    ) * (1.0 - tmpvar_4.z)));
  };
  highp vec3 tmpvar_12;
  tmpvar_12.x = tmpvar_9;
  tmpvar_12.y = tmpvar_10;
  tmpvar_12.z = tmpvar_11;
  resultColor_2.xyz = tmpvar_12;
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPOSITION","BLEND_OVERLAY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp float tmpvar_7;
  if ((xlt_fbColor_1.x < 0.5)) {
    tmpvar_7 = ((2.0 * xlt_fbColor_1.x) * tmpvar_5.x);
  } else {
    tmpvar_7 = (1.0 - ((2.0 * 
      (1.0 - xlt_fbColor_1.x)
    ) * (1.0 - tmpvar_5.x)));
  };
  highp float tmpvar_8;
  if ((xlt_fbColor_1.y < 0.5)) {
    tmpvar_8 = ((2.0 * xlt_fbColor_1.y) * tmpvar_5.y);
  } else {
    tmpvar_8 = (1.0 - ((2.0 * 
      (1.0 - xlt_fbColor_1.y)
    ) * (1.0 - tmpvar_5.y)));
  };
  highp float tmpvar_9;
  if ((xlt_fbColor_1.z < 0.5)) {
    tmpvar_9 = ((2.0 * xlt_fbColor_1.z) * tmpvar_5.z);
  } else {
    tmpvar_9 = (1.0 - ((2.0 * 
      (1.0 - xlt_fbColor_1.z)
    ) * (1.0 - tmpvar_5.z)));
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_7;
  tmpvar_10.y = tmpvar_8;
  tmpvar_10.z = tmpvar_9;
  resultColor_3.xyz = tmpvar_10;
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPOSITION","BLEND_OVERLAY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp float tmpvar_9;
  if ((srcColor_6.x < 0.5)) {
    tmpvar_9 = ((2.0 * srcColor_6.x) * tmpvar_4.x);
  } else {
    tmpvar_9 = (1.0 - ((2.0 * 
      (1.0 - srcColor_6.x)
    ) * (1.0 - tmpvar_4.x)));
  };
  highp float tmpvar_10;
  if ((srcColor_6.y < 0.5)) {
    tmpvar_10 = ((2.0 * srcColor_6.y) * tmpvar_4.y);
  } else {
    tmpvar_10 = (1.0 - ((2.0 * 
      (1.0 - srcColor_6.y)
    ) * (1.0 - tmpvar_4.y)));
  };
  highp float tmpvar_11;
  if ((srcColor_6.z < 0.5)) {
    tmpvar_11 = ((2.0 * srcColor_6.z) * tmpvar_4.z);
  } else {
    tmpvar_11 = (1.0 - ((2.0 * 
      (1.0 - srcColor_6.z)
    ) * (1.0 - tmpvar_4.z)));
  };
  highp vec3 tmpvar_12;
  tmpvar_12.x = tmpvar_9;
  tmpvar_12.y = tmpvar_10;
  tmpvar_12.z = tmpvar_11;
  resultColor_2.xyz = tmpvar_12;
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","AXIS","BLEND_OVERLAY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp float tmpvar_7;
  if ((xlt_fbColor_1.x < 0.5)) {
    tmpvar_7 = ((2.0 * xlt_fbColor_1.x) * tmpvar_5.x);
  } else {
    tmpvar_7 = (1.0 - ((2.0 * 
      (1.0 - xlt_fbColor_1.x)
    ) * (1.0 - tmpvar_5.x)));
  };
  highp float tmpvar_8;
  if ((xlt_fbColor_1.y < 0.5)) {
    tmpvar_8 = ((2.0 * xlt_fbColor_1.y) * tmpvar_5.y);
  } else {
    tmpvar_8 = (1.0 - ((2.0 * 
      (1.0 - xlt_fbColor_1.y)
    ) * (1.0 - tmpvar_5.y)));
  };
  highp float tmpvar_9;
  if ((xlt_fbColor_1.z < 0.5)) {
    tmpvar_9 = ((2.0 * xlt_fbColor_1.z) * tmpvar_5.z);
  } else {
    tmpvar_9 = (1.0 - ((2.0 * 
      (1.0 - xlt_fbColor_1.z)
    ) * (1.0 - tmpvar_5.z)));
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_7;
  tmpvar_10.y = tmpvar_8;
  tmpvar_10.z = tmpvar_9;
  resultColor_3.xyz = tmpvar_10;
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"AXIS","BLEND_OVERLAY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp float tmpvar_9;
  if ((srcColor_6.x < 0.5)) {
    tmpvar_9 = ((2.0 * srcColor_6.x) * tmpvar_4.x);
  } else {
    tmpvar_9 = (1.0 - ((2.0 * 
      (1.0 - srcColor_6.x)
    ) * (1.0 - tmpvar_4.x)));
  };
  highp float tmpvar_10;
  if ((srcColor_6.y < 0.5)) {
    tmpvar_10 = ((2.0 * srcColor_6.y) * tmpvar_4.y);
  } else {
    tmpvar_10 = (1.0 - ((2.0 * 
      (1.0 - srcColor_6.y)
    ) * (1.0 - tmpvar_4.y)));
  };
  highp float tmpvar_11;
  if ((srcColor_6.z < 0.5)) {
    tmpvar_11 = ((2.0 * srcColor_6.z) * tmpvar_4.z);
  } else {
    tmpvar_11 = (1.0 - ((2.0 * 
      (1.0 - srcColor_6.z)
    ) * (1.0 - tmpvar_4.z)));
  };
  highp vec3 tmpvar_12;
  tmpvar_12.x = tmpvar_9;
  tmpvar_12.y = tmpvar_10;
  tmpvar_12.z = tmpvar_11;
  resultColor_2.xyz = tmpvar_12;
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VELOCITY","BLEND_OVERLAY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp float tmpvar_7;
  if ((xlt_fbColor_1.x < 0.5)) {
    tmpvar_7 = ((2.0 * xlt_fbColor_1.x) * tmpvar_5.x);
  } else {
    tmpvar_7 = (1.0 - ((2.0 * 
      (1.0 - xlt_fbColor_1.x)
    ) * (1.0 - tmpvar_5.x)));
  };
  highp float tmpvar_8;
  if ((xlt_fbColor_1.y < 0.5)) {
    tmpvar_8 = ((2.0 * xlt_fbColor_1.y) * tmpvar_5.y);
  } else {
    tmpvar_8 = (1.0 - ((2.0 * 
      (1.0 - xlt_fbColor_1.y)
    ) * (1.0 - tmpvar_5.y)));
  };
  highp float tmpvar_9;
  if ((xlt_fbColor_1.z < 0.5)) {
    tmpvar_9 = ((2.0 * xlt_fbColor_1.z) * tmpvar_5.z);
  } else {
    tmpvar_9 = (1.0 - ((2.0 * 
      (1.0 - xlt_fbColor_1.z)
    ) * (1.0 - tmpvar_5.z)));
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_7;
  tmpvar_10.y = tmpvar_8;
  tmpvar_10.z = tmpvar_9;
  resultColor_3.xyz = tmpvar_10;
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VELOCITY","BLEND_OVERLAY"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp float tmpvar_9;
  if ((srcColor_6.x < 0.5)) {
    tmpvar_9 = ((2.0 * srcColor_6.x) * tmpvar_4.x);
  } else {
    tmpvar_9 = (1.0 - ((2.0 * 
      (1.0 - srcColor_6.x)
    ) * (1.0 - tmpvar_4.x)));
  };
  highp float tmpvar_10;
  if ((srcColor_6.y < 0.5)) {
    tmpvar_10 = ((2.0 * srcColor_6.y) * tmpvar_4.y);
  } else {
    tmpvar_10 = (1.0 - ((2.0 * 
      (1.0 - srcColor_6.y)
    ) * (1.0 - tmpvar_4.y)));
  };
  highp float tmpvar_11;
  if ((srcColor_6.z < 0.5)) {
    tmpvar_11 = ((2.0 * srcColor_6.z) * tmpvar_4.z);
  } else {
    tmpvar_11 = (1.0 - ((2.0 * 
      (1.0 - srcColor_6.z)
    ) * (1.0 - tmpvar_4.z)));
  };
  highp vec3 tmpvar_12;
  tmpvar_12.x = tmpvar_9;
  tmpvar_12.y = tmpvar_10;
  tmpvar_12.z = tmpvar_11;
  resultColor_2.xyz = tmpvar_12;
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPLANE","BLEND_COLORBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp vec3 blend_7;
  blend_7 = tmpvar_5.xyz;
  highp float blend_8;
  blend_8 = blend_7.x;
  highp float tmpvar_9;
  if ((tmpvar_5.x == 0.0)) {
    tmpvar_9 = blend_8;
  } else {
    tmpvar_9 = max ((1.0 - (
      (1.0 - xlt_fbColor_1.x)
     / tmpvar_5.x)), 0.0);
  };
  highp float blend_10;
  blend_10 = blend_7.y;
  highp float tmpvar_11;
  if ((tmpvar_5.y == 0.0)) {
    tmpvar_11 = blend_10;
  } else {
    tmpvar_11 = max ((1.0 - (
      (1.0 - xlt_fbColor_1.y)
     / tmpvar_5.y)), 0.0);
  };
  highp float blend_12;
  blend_12 = blend_7.z;
  highp float tmpvar_13;
  if ((tmpvar_5.z == 0.0)) {
    tmpvar_13 = blend_12;
  } else {
    tmpvar_13 = max ((1.0 - (
      (1.0 - xlt_fbColor_1.z)
     / tmpvar_5.z)), 0.0);
  };
  highp vec3 tmpvar_14;
  tmpvar_14.x = tmpvar_9;
  tmpvar_14.y = tmpvar_11;
  tmpvar_14.z = tmpvar_13;
  resultColor_3.xyz = tmpvar_14;
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPLANE","BLEND_COLORBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 blend_9;
  blend_9 = tmpvar_4.xyz;
  highp float blend_10;
  blend_10 = blend_9.x;
  highp float tmpvar_11;
  if ((tmpvar_4.x == 0.0)) {
    tmpvar_11 = blend_10;
  } else {
    tmpvar_11 = max ((1.0 - (
      (1.0 - srcColor_6.x)
     / tmpvar_4.x)), 0.0);
  };
  highp float blend_12;
  blend_12 = blend_9.y;
  highp float tmpvar_13;
  if ((tmpvar_4.y == 0.0)) {
    tmpvar_13 = blend_12;
  } else {
    tmpvar_13 = max ((1.0 - (
      (1.0 - srcColor_6.y)
     / tmpvar_4.y)), 0.0);
  };
  highp float blend_14;
  blend_14 = blend_9.z;
  highp float tmpvar_15;
  if ((tmpvar_4.z == 0.0)) {
    tmpvar_15 = blend_14;
  } else {
    tmpvar_15 = max ((1.0 - (
      (1.0 - srcColor_6.z)
     / tmpvar_4.z)), 0.0);
  };
  highp vec3 tmpvar_16;
  tmpvar_16.x = tmpvar_11;
  tmpvar_16.y = tmpvar_13;
  tmpvar_16.z = tmpvar_15;
  resultColor_2.xyz = tmpvar_16;
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPOSITION","BLEND_COLORBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp vec3 blend_7;
  blend_7 = tmpvar_5.xyz;
  highp float blend_8;
  blend_8 = blend_7.x;
  highp float tmpvar_9;
  if ((tmpvar_5.x == 0.0)) {
    tmpvar_9 = blend_8;
  } else {
    tmpvar_9 = max ((1.0 - (
      (1.0 - xlt_fbColor_1.x)
     / tmpvar_5.x)), 0.0);
  };
  highp float blend_10;
  blend_10 = blend_7.y;
  highp float tmpvar_11;
  if ((tmpvar_5.y == 0.0)) {
    tmpvar_11 = blend_10;
  } else {
    tmpvar_11 = max ((1.0 - (
      (1.0 - xlt_fbColor_1.y)
     / tmpvar_5.y)), 0.0);
  };
  highp float blend_12;
  blend_12 = blend_7.z;
  highp float tmpvar_13;
  if ((tmpvar_5.z == 0.0)) {
    tmpvar_13 = blend_12;
  } else {
    tmpvar_13 = max ((1.0 - (
      (1.0 - xlt_fbColor_1.z)
     / tmpvar_5.z)), 0.0);
  };
  highp vec3 tmpvar_14;
  tmpvar_14.x = tmpvar_9;
  tmpvar_14.y = tmpvar_11;
  tmpvar_14.z = tmpvar_13;
  resultColor_3.xyz = tmpvar_14;
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPOSITION","BLEND_COLORBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 blend_9;
  blend_9 = tmpvar_4.xyz;
  highp float blend_10;
  blend_10 = blend_9.x;
  highp float tmpvar_11;
  if ((tmpvar_4.x == 0.0)) {
    tmpvar_11 = blend_10;
  } else {
    tmpvar_11 = max ((1.0 - (
      (1.0 - srcColor_6.x)
     / tmpvar_4.x)), 0.0);
  };
  highp float blend_12;
  blend_12 = blend_9.y;
  highp float tmpvar_13;
  if ((tmpvar_4.y == 0.0)) {
    tmpvar_13 = blend_12;
  } else {
    tmpvar_13 = max ((1.0 - (
      (1.0 - srcColor_6.y)
     / tmpvar_4.y)), 0.0);
  };
  highp float blend_14;
  blend_14 = blend_9.z;
  highp float tmpvar_15;
  if ((tmpvar_4.z == 0.0)) {
    tmpvar_15 = blend_14;
  } else {
    tmpvar_15 = max ((1.0 - (
      (1.0 - srcColor_6.z)
     / tmpvar_4.z)), 0.0);
  };
  highp vec3 tmpvar_16;
  tmpvar_16.x = tmpvar_11;
  tmpvar_16.y = tmpvar_13;
  tmpvar_16.z = tmpvar_15;
  resultColor_2.xyz = tmpvar_16;
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","AXIS","BLEND_COLORBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp vec3 blend_7;
  blend_7 = tmpvar_5.xyz;
  highp float blend_8;
  blend_8 = blend_7.x;
  highp float tmpvar_9;
  if ((tmpvar_5.x == 0.0)) {
    tmpvar_9 = blend_8;
  } else {
    tmpvar_9 = max ((1.0 - (
      (1.0 - xlt_fbColor_1.x)
     / tmpvar_5.x)), 0.0);
  };
  highp float blend_10;
  blend_10 = blend_7.y;
  highp float tmpvar_11;
  if ((tmpvar_5.y == 0.0)) {
    tmpvar_11 = blend_10;
  } else {
    tmpvar_11 = max ((1.0 - (
      (1.0 - xlt_fbColor_1.y)
     / tmpvar_5.y)), 0.0);
  };
  highp float blend_12;
  blend_12 = blend_7.z;
  highp float tmpvar_13;
  if ((tmpvar_5.z == 0.0)) {
    tmpvar_13 = blend_12;
  } else {
    tmpvar_13 = max ((1.0 - (
      (1.0 - xlt_fbColor_1.z)
     / tmpvar_5.z)), 0.0);
  };
  highp vec3 tmpvar_14;
  tmpvar_14.x = tmpvar_9;
  tmpvar_14.y = tmpvar_11;
  tmpvar_14.z = tmpvar_13;
  resultColor_3.xyz = tmpvar_14;
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"AXIS","BLEND_COLORBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 blend_9;
  blend_9 = tmpvar_4.xyz;
  highp float blend_10;
  blend_10 = blend_9.x;
  highp float tmpvar_11;
  if ((tmpvar_4.x == 0.0)) {
    tmpvar_11 = blend_10;
  } else {
    tmpvar_11 = max ((1.0 - (
      (1.0 - srcColor_6.x)
     / tmpvar_4.x)), 0.0);
  };
  highp float blend_12;
  blend_12 = blend_9.y;
  highp float tmpvar_13;
  if ((tmpvar_4.y == 0.0)) {
    tmpvar_13 = blend_12;
  } else {
    tmpvar_13 = max ((1.0 - (
      (1.0 - srcColor_6.y)
     / tmpvar_4.y)), 0.0);
  };
  highp float blend_14;
  blend_14 = blend_9.z;
  highp float tmpvar_15;
  if ((tmpvar_4.z == 0.0)) {
    tmpvar_15 = blend_14;
  } else {
    tmpvar_15 = max ((1.0 - (
      (1.0 - srcColor_6.z)
     / tmpvar_4.z)), 0.0);
  };
  highp vec3 tmpvar_16;
  tmpvar_16.x = tmpvar_11;
  tmpvar_16.y = tmpvar_13;
  tmpvar_16.z = tmpvar_15;
  resultColor_2.xyz = tmpvar_16;
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VELOCITY","BLEND_COLORBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp vec3 blend_7;
  blend_7 = tmpvar_5.xyz;
  highp float blend_8;
  blend_8 = blend_7.x;
  highp float tmpvar_9;
  if ((tmpvar_5.x == 0.0)) {
    tmpvar_9 = blend_8;
  } else {
    tmpvar_9 = max ((1.0 - (
      (1.0 - xlt_fbColor_1.x)
     / tmpvar_5.x)), 0.0);
  };
  highp float blend_10;
  blend_10 = blend_7.y;
  highp float tmpvar_11;
  if ((tmpvar_5.y == 0.0)) {
    tmpvar_11 = blend_10;
  } else {
    tmpvar_11 = max ((1.0 - (
      (1.0 - xlt_fbColor_1.y)
     / tmpvar_5.y)), 0.0);
  };
  highp float blend_12;
  blend_12 = blend_7.z;
  highp float tmpvar_13;
  if ((tmpvar_5.z == 0.0)) {
    tmpvar_13 = blend_12;
  } else {
    tmpvar_13 = max ((1.0 - (
      (1.0 - xlt_fbColor_1.z)
     / tmpvar_5.z)), 0.0);
  };
  highp vec3 tmpvar_14;
  tmpvar_14.x = tmpvar_9;
  tmpvar_14.y = tmpvar_11;
  tmpvar_14.z = tmpvar_13;
  resultColor_3.xyz = tmpvar_14;
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VELOCITY","BLEND_COLORBURN"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 blend_9;
  blend_9 = tmpvar_4.xyz;
  highp float blend_10;
  blend_10 = blend_9.x;
  highp float tmpvar_11;
  if ((tmpvar_4.x == 0.0)) {
    tmpvar_11 = blend_10;
  } else {
    tmpvar_11 = max ((1.0 - (
      (1.0 - srcColor_6.x)
     / tmpvar_4.x)), 0.0);
  };
  highp float blend_12;
  blend_12 = blend_9.y;
  highp float tmpvar_13;
  if ((tmpvar_4.y == 0.0)) {
    tmpvar_13 = blend_12;
  } else {
    tmpvar_13 = max ((1.0 - (
      (1.0 - srcColor_6.y)
     / tmpvar_4.y)), 0.0);
  };
  highp float blend_14;
  blend_14 = blend_9.z;
  highp float tmpvar_15;
  if ((tmpvar_4.z == 0.0)) {
    tmpvar_15 = blend_14;
  } else {
    tmpvar_15 = max ((1.0 - (
      (1.0 - srcColor_6.z)
     / tmpvar_4.z)), 0.0);
  };
  highp vec3 tmpvar_16;
  tmpvar_16.x = tmpvar_11;
  tmpvar_16.y = tmpvar_13;
  tmpvar_16.z = tmpvar_15;
  resultColor_2.xyz = tmpvar_16;
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPLANE","BLEND_COLORDODGE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp vec3 blend_7;
  blend_7 = tmpvar_5.xyz;
  highp float blend_8;
  blend_8 = blend_7.x;
  highp float tmpvar_9;
  if ((tmpvar_5.x == 1.0)) {
    tmpvar_9 = blend_8;
  } else {
    tmpvar_9 = min ((xlt_fbColor_1.x / (1.0 - tmpvar_5.x)), 1.0);
  };
  highp float blend_10;
  blend_10 = blend_7.y;
  highp float tmpvar_11;
  if ((tmpvar_5.y == 1.0)) {
    tmpvar_11 = blend_10;
  } else {
    tmpvar_11 = min ((xlt_fbColor_1.y / (1.0 - tmpvar_5.y)), 1.0);
  };
  highp float blend_12;
  blend_12 = blend_7.z;
  highp float tmpvar_13;
  if ((tmpvar_5.z == 1.0)) {
    tmpvar_13 = blend_12;
  } else {
    tmpvar_13 = min ((xlt_fbColor_1.z / (1.0 - tmpvar_5.z)), 1.0);
  };
  highp vec3 tmpvar_14;
  tmpvar_14.x = tmpvar_9;
  tmpvar_14.y = tmpvar_11;
  tmpvar_14.z = tmpvar_13;
  resultColor_3.xyz = tmpvar_14;
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPLANE","BLEND_COLORDODGE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 blend_9;
  blend_9 = tmpvar_4.xyz;
  highp float blend_10;
  blend_10 = blend_9.x;
  highp float tmpvar_11;
  if ((tmpvar_4.x == 1.0)) {
    tmpvar_11 = blend_10;
  } else {
    tmpvar_11 = min ((srcColor_6.x / (1.0 - tmpvar_4.x)), 1.0);
  };
  highp float blend_12;
  blend_12 = blend_9.y;
  highp float tmpvar_13;
  if ((tmpvar_4.y == 1.0)) {
    tmpvar_13 = blend_12;
  } else {
    tmpvar_13 = min ((srcColor_6.y / (1.0 - tmpvar_4.y)), 1.0);
  };
  highp float blend_14;
  blend_14 = blend_9.z;
  highp float tmpvar_15;
  if ((tmpvar_4.z == 1.0)) {
    tmpvar_15 = blend_14;
  } else {
    tmpvar_15 = min ((srcColor_6.z / (1.0 - tmpvar_4.z)), 1.0);
  };
  highp vec3 tmpvar_16;
  tmpvar_16.x = tmpvar_11;
  tmpvar_16.y = tmpvar_13;
  tmpvar_16.z = tmpvar_15;
  resultColor_2.xyz = tmpvar_16;
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPOSITION","BLEND_COLORDODGE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp vec3 blend_7;
  blend_7 = tmpvar_5.xyz;
  highp float blend_8;
  blend_8 = blend_7.x;
  highp float tmpvar_9;
  if ((tmpvar_5.x == 1.0)) {
    tmpvar_9 = blend_8;
  } else {
    tmpvar_9 = min ((xlt_fbColor_1.x / (1.0 - tmpvar_5.x)), 1.0);
  };
  highp float blend_10;
  blend_10 = blend_7.y;
  highp float tmpvar_11;
  if ((tmpvar_5.y == 1.0)) {
    tmpvar_11 = blend_10;
  } else {
    tmpvar_11 = min ((xlt_fbColor_1.y / (1.0 - tmpvar_5.y)), 1.0);
  };
  highp float blend_12;
  blend_12 = blend_7.z;
  highp float tmpvar_13;
  if ((tmpvar_5.z == 1.0)) {
    tmpvar_13 = blend_12;
  } else {
    tmpvar_13 = min ((xlt_fbColor_1.z / (1.0 - tmpvar_5.z)), 1.0);
  };
  highp vec3 tmpvar_14;
  tmpvar_14.x = tmpvar_9;
  tmpvar_14.y = tmpvar_11;
  tmpvar_14.z = tmpvar_13;
  resultColor_3.xyz = tmpvar_14;
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPOSITION","BLEND_COLORDODGE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 blend_9;
  blend_9 = tmpvar_4.xyz;
  highp float blend_10;
  blend_10 = blend_9.x;
  highp float tmpvar_11;
  if ((tmpvar_4.x == 1.0)) {
    tmpvar_11 = blend_10;
  } else {
    tmpvar_11 = min ((srcColor_6.x / (1.0 - tmpvar_4.x)), 1.0);
  };
  highp float blend_12;
  blend_12 = blend_9.y;
  highp float tmpvar_13;
  if ((tmpvar_4.y == 1.0)) {
    tmpvar_13 = blend_12;
  } else {
    tmpvar_13 = min ((srcColor_6.y / (1.0 - tmpvar_4.y)), 1.0);
  };
  highp float blend_14;
  blend_14 = blend_9.z;
  highp float tmpvar_15;
  if ((tmpvar_4.z == 1.0)) {
    tmpvar_15 = blend_14;
  } else {
    tmpvar_15 = min ((srcColor_6.z / (1.0 - tmpvar_4.z)), 1.0);
  };
  highp vec3 tmpvar_16;
  tmpvar_16.x = tmpvar_11;
  tmpvar_16.y = tmpvar_13;
  tmpvar_16.z = tmpvar_15;
  resultColor_2.xyz = tmpvar_16;
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","AXIS","BLEND_COLORDODGE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp vec3 blend_7;
  blend_7 = tmpvar_5.xyz;
  highp float blend_8;
  blend_8 = blend_7.x;
  highp float tmpvar_9;
  if ((tmpvar_5.x == 1.0)) {
    tmpvar_9 = blend_8;
  } else {
    tmpvar_9 = min ((xlt_fbColor_1.x / (1.0 - tmpvar_5.x)), 1.0);
  };
  highp float blend_10;
  blend_10 = blend_7.y;
  highp float tmpvar_11;
  if ((tmpvar_5.y == 1.0)) {
    tmpvar_11 = blend_10;
  } else {
    tmpvar_11 = min ((xlt_fbColor_1.y / (1.0 - tmpvar_5.y)), 1.0);
  };
  highp float blend_12;
  blend_12 = blend_7.z;
  highp float tmpvar_13;
  if ((tmpvar_5.z == 1.0)) {
    tmpvar_13 = blend_12;
  } else {
    tmpvar_13 = min ((xlt_fbColor_1.z / (1.0 - tmpvar_5.z)), 1.0);
  };
  highp vec3 tmpvar_14;
  tmpvar_14.x = tmpvar_9;
  tmpvar_14.y = tmpvar_11;
  tmpvar_14.z = tmpvar_13;
  resultColor_3.xyz = tmpvar_14;
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"AXIS","BLEND_COLORDODGE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 blend_9;
  blend_9 = tmpvar_4.xyz;
  highp float blend_10;
  blend_10 = blend_9.x;
  highp float tmpvar_11;
  if ((tmpvar_4.x == 1.0)) {
    tmpvar_11 = blend_10;
  } else {
    tmpvar_11 = min ((srcColor_6.x / (1.0 - tmpvar_4.x)), 1.0);
  };
  highp float blend_12;
  blend_12 = blend_9.y;
  highp float tmpvar_13;
  if ((tmpvar_4.y == 1.0)) {
    tmpvar_13 = blend_12;
  } else {
    tmpvar_13 = min ((srcColor_6.y / (1.0 - tmpvar_4.y)), 1.0);
  };
  highp float blend_14;
  blend_14 = blend_9.z;
  highp float tmpvar_15;
  if ((tmpvar_4.z == 1.0)) {
    tmpvar_15 = blend_14;
  } else {
    tmpvar_15 = min ((srcColor_6.z / (1.0 - tmpvar_4.z)), 1.0);
  };
  highp vec3 tmpvar_16;
  tmpvar_16.x = tmpvar_11;
  tmpvar_16.y = tmpvar_13;
  tmpvar_16.z = tmpvar_15;
  resultColor_2.xyz = tmpvar_16;
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VELOCITY","BLEND_COLORDODGE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_6;
  tmpvar_6 = (_Opacity * tmpvar_5.w);
  highp vec3 blend_7;
  blend_7 = tmpvar_5.xyz;
  highp float blend_8;
  blend_8 = blend_7.x;
  highp float tmpvar_9;
  if ((tmpvar_5.x == 1.0)) {
    tmpvar_9 = blend_8;
  } else {
    tmpvar_9 = min ((xlt_fbColor_1.x / (1.0 - tmpvar_5.x)), 1.0);
  };
  highp float blend_10;
  blend_10 = blend_7.y;
  highp float tmpvar_11;
  if ((tmpvar_5.y == 1.0)) {
    tmpvar_11 = blend_10;
  } else {
    tmpvar_11 = min ((xlt_fbColor_1.y / (1.0 - tmpvar_5.y)), 1.0);
  };
  highp float blend_12;
  blend_12 = blend_7.z;
  highp float tmpvar_13;
  if ((tmpvar_5.z == 1.0)) {
    tmpvar_13 = blend_12;
  } else {
    tmpvar_13 = min ((xlt_fbColor_1.z / (1.0 - tmpvar_5.z)), 1.0);
  };
  highp vec3 tmpvar_14;
  tmpvar_14.x = tmpvar_9;
  tmpvar_14.y = tmpvar_11;
  tmpvar_14.z = tmpvar_13;
  resultColor_3.xyz = tmpvar_14;
  resultColor_3.w = tmpvar_6;
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VELOCITY","BLEND_COLORDODGE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  resultColor_2 = vec4(1.0, 1.0, 1.0, 1.0);
  highp float tmpvar_5;
  tmpvar_5 = (_Opacity * tmpvar_4.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp vec3 blend_9;
  blend_9 = tmpvar_4.xyz;
  highp float blend_10;
  blend_10 = blend_9.x;
  highp float tmpvar_11;
  if ((tmpvar_4.x == 1.0)) {
    tmpvar_11 = blend_10;
  } else {
    tmpvar_11 = min ((srcColor_6.x / (1.0 - tmpvar_4.x)), 1.0);
  };
  highp float blend_12;
  blend_12 = blend_9.y;
  highp float tmpvar_13;
  if ((tmpvar_4.y == 1.0)) {
    tmpvar_13 = blend_12;
  } else {
    tmpvar_13 = min ((srcColor_6.y / (1.0 - tmpvar_4.y)), 1.0);
  };
  highp float blend_14;
  blend_14 = blend_9.z;
  highp float tmpvar_15;
  if ((tmpvar_4.z == 1.0)) {
    tmpvar_15 = blend_14;
  } else {
    tmpvar_15 = min ((srcColor_6.z / (1.0 - tmpvar_4.z)), 1.0);
  };
  highp vec3 tmpvar_16;
  tmpvar_16.x = tmpvar_11;
  tmpvar_16.y = tmpvar_13;
  tmpvar_16.z = tmpvar_15;
  resultColor_2.xyz = tmpvar_16;
  resultColor_2.w = tmpvar_5;
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPLANE","BLEND_SOFTLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3.xyz = (((
    (vec3(1.0, 1.0, 1.0) - (vec3(2.0, 2.0, 2.0) * tmpvar_5.xyz))
   * xlt_fbColor_1.xyz) * xlt_fbColor_1.xyz) + ((vec3(2.0, 2.0, 2.0) * xlt_fbColor_1.xyz) * tmpvar_5.xyz));
  resultColor_3.w = (_Opacity * tmpvar_5.w);
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPLANE","BLEND_SOFTLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  highp vec4 srcColor_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture (TEXTURE_GRAP, tmpvar_6);
  srcColor_5 = tmpvar_7;
  resultColor_2.xyz = (((
    (vec3(1.0, 1.0, 1.0) - (vec3(2.0, 2.0, 2.0) * tmpvar_4.xyz))
   * srcColor_5.xyz) * srcColor_5.xyz) + ((vec3(2.0, 2.0, 2.0) * srcColor_5.xyz) * tmpvar_4.xyz));
  resultColor_2.w = (_Opacity * tmpvar_4.w);
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPOSITION","BLEND_SOFTLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3.xyz = (((
    (vec3(1.0, 1.0, 1.0) - (vec3(2.0, 2.0, 2.0) * tmpvar_5.xyz))
   * xlt_fbColor_1.xyz) * xlt_fbColor_1.xyz) + ((vec3(2.0, 2.0, 2.0) * xlt_fbColor_1.xyz) * tmpvar_5.xyz));
  resultColor_3.w = (_Opacity * tmpvar_5.w);
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPOSITION","BLEND_SOFTLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  highp vec4 srcColor_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture (TEXTURE_GRAP, tmpvar_6);
  srcColor_5 = tmpvar_7;
  resultColor_2.xyz = (((
    (vec3(1.0, 1.0, 1.0) - (vec3(2.0, 2.0, 2.0) * tmpvar_4.xyz))
   * srcColor_5.xyz) * srcColor_5.xyz) + ((vec3(2.0, 2.0, 2.0) * srcColor_5.xyz) * tmpvar_4.xyz));
  resultColor_2.w = (_Opacity * tmpvar_4.w);
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","AXIS","BLEND_SOFTLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3.xyz = (((
    (vec3(1.0, 1.0, 1.0) - (vec3(2.0, 2.0, 2.0) * tmpvar_5.xyz))
   * xlt_fbColor_1.xyz) * xlt_fbColor_1.xyz) + ((vec3(2.0, 2.0, 2.0) * xlt_fbColor_1.xyz) * tmpvar_5.xyz));
  resultColor_3.w = (_Opacity * tmpvar_5.w);
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"AXIS","BLEND_SOFTLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  highp vec4 srcColor_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture (TEXTURE_GRAP, tmpvar_6);
  srcColor_5 = tmpvar_7;
  resultColor_2.xyz = (((
    (vec3(1.0, 1.0, 1.0) - (vec3(2.0, 2.0, 2.0) * tmpvar_4.xyz))
   * srcColor_5.xyz) * srcColor_5.xyz) + ((vec3(2.0, 2.0, 2.0) * srcColor_5.xyz) * tmpvar_4.xyz));
  resultColor_2.w = (_Opacity * tmpvar_4.w);
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VELOCITY","BLEND_SOFTLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3.xyz = (((
    (vec3(1.0, 1.0, 1.0) - (vec3(2.0, 2.0, 2.0) * tmpvar_5.xyz))
   * xlt_fbColor_1.xyz) * xlt_fbColor_1.xyz) + ((vec3(2.0, 2.0, 2.0) * xlt_fbColor_1.xyz) * tmpvar_5.xyz));
  resultColor_3.w = (_Opacity * tmpvar_5.w);
  xlt_fbColor_1 = resultColor_3;
  _glesFragData[0] = resultColor_3;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VELOCITY","BLEND_SOFTLIGHT"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "STRETCHED_SCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
in vec4 _glesMultiTexCoord3;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec2 STRETCHED_SCALE;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisForward_3;
  highp vec4 worldPosition_4;
  highp vec2 ExtraStretch_5;
  highp vec3 velocity_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec3 tmpvar_11;
  tmpvar_11 = -(_glesMultiTexCoord3.xyz);
  velocity_6 = tmpvar_11;
  ExtraStretch_5 = vec2(1.0, 1.0);
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_12;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_12);
    highp vec4 tmpvar_13;
    tmpvar_13.w = 0.0;
    tmpvar_13.xyz = tmpvar_11;
    velocity_6 = (LOCALWORLD_TRANSFORM * tmpvar_13).xyz;
  };
  axisForward_3 = (CAMERA_WORLDPOSITION - worldPosition_4.xyz);
  highp vec3 tmpvar_14;
  tmpvar_14 = normalize(velocity_6);
  highp vec3 tmpvar_15;
  tmpvar_15 = normalize(((axisForward_3.yzx * tmpvar_14.zxy) - (axisForward_3.zxy * tmpvar_14.yzx)));
  ExtraStretch_5.x = (STRETCHED_SCALE.y + (sqrt(
    dot (velocity_6, velocity_6)
  ) * STRETCHED_SCALE.x));
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(((tmpvar_14.yzx * tmpvar_15.zxy) - (tmpvar_14.zxy * tmpvar_15.yzx)));
  axisForward_3 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.x);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.x);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.y);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.y);
  highp float tmpvar_21;
  tmpvar_21 = cos(_glesNormal.z);
  highp float tmpvar_22;
  tmpvar_22 = sin(_glesNormal.z);
  highp mat3 tmpvar_23;
  tmpvar_23[uint(0)].x = (tmpvar_21 * tmpvar_19);
  tmpvar_23[uint(0)].y = (tmpvar_19 * tmpvar_22);
  tmpvar_23[uint(0)].z = -(tmpvar_20);
  tmpvar_23[1u].x = (((tmpvar_21 * tmpvar_20) * tmpvar_18) - (tmpvar_17 * tmpvar_22));
  tmpvar_23[1u].y = ((tmpvar_21 * tmpvar_17) + ((tmpvar_22 * tmpvar_20) * tmpvar_18));
  tmpvar_23[1u].z = (tmpvar_19 * tmpvar_18);
  tmpvar_23[2u].x = ((tmpvar_22 * tmpvar_18) + ((tmpvar_21 * tmpvar_17) * tmpvar_20));
  tmpvar_23[2u].y = (((tmpvar_17 * tmpvar_20) * tmpvar_22) - (tmpvar_21 * tmpvar_18));
  tmpvar_23[2u].z = (tmpvar_19 * tmpvar_17);
  highp mat3 tmpvar_24;
  tmpvar_24[uint(0)].x = tmpvar_14.x;
  tmpvar_24[uint(0)].y = tmpvar_14.y;
  tmpvar_24[uint(0)].z = tmpvar_14.z;
  tmpvar_24[1u].x = tmpvar_15.x;
  tmpvar_24[1u].y = tmpvar_15.y;
  tmpvar_24[1u].z = tmpvar_15.z;
  tmpvar_24[2u].x = tmpvar_16.x;
  tmpvar_24[2u].y = tmpvar_16.y;
  tmpvar_24[2u].z = tmpvar_16.z;
  highp vec3 tmpvar_25;
  tmpvar_25.z = 0.0;
  tmpvar_25.xy = ExtraStretch_5;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_24 * tmpvar_23) * (
    ((tmpvar_8.xyz * tmpvar_25) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_26 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_26) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_27 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_27) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_28;
  highp vec4 tmpvar_29;
  tmpvar_29 = (tmpvar_7 * 0.5);
  o_28.zw = tmpvar_29.zw;
  o_28.xy = (tmpvar_29.xy + tmpvar_29.ww);
  o_28.y = ((2.0 * tmpvar_29.w) - o_28.y);
  o_28.zw = tmpvar_7.zw;
  highp vec4 tmpvar_30;
  tmpvar_30.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_30.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_7);
  tmpvar_7 = tmpvar_31;
  gl_Position = tmpvar_31;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_28;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp vec4 resultColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_4;
  tmpvar_4 = (tmpvar_3 * xlv_TEXCOORD2);
  highp vec4 srcColor_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture (TEXTURE_GRAP, tmpvar_6);
  srcColor_5 = tmpvar_7;
  resultColor_2.xyz = (((
    (vec3(1.0, 1.0, 1.0) - (vec3(2.0, 2.0, 2.0) * tmpvar_4.xyz))
   * srcColor_5.xyz) * srcColor_5.xyz) + ((vec3(2.0, 2.0, 2.0) * srcColor_5.xyz) * tmpvar_4.xyz));
  resultColor_2.w = (_Opacity * tmpvar_4.w);
  tmpvar_1 = resultColor_2;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPLANE","BLEND_HARDMIX"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp float factor_3;
  highp vec4 resultColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_6;
  tmpvar_6 = (tmpvar_5 * xlv_TEXCOORD2);
  resultColor_4 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_3 = (_Opacity * tmpvar_6.w);
  highp float tmpvar_7;
  highp float tmpvar_8;
  if ((tmpvar_6.x < 0.5)) {
    highp float blend_9;
    blend_9 = (2.0 * tmpvar_6.x);
    highp float tmpvar_10;
    if ((blend_9 == 0.0)) {
      tmpvar_10 = blend_9;
    } else {
      tmpvar_10 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.x)
       / blend_9)), 0.0);
    };
    tmpvar_8 = tmpvar_10;
  } else {
    highp float blend_11;
    blend_11 = (2.0 * (tmpvar_6.x - 0.5));
    highp float tmpvar_12;
    if ((blend_11 == 1.0)) {
      tmpvar_12 = blend_11;
    } else {
      tmpvar_12 = min ((xlt_fbColor_1.x / (1.0 - blend_11)), 1.0);
    };
    tmpvar_8 = tmpvar_12;
  };
  if ((tmpvar_8 < 0.5)) {
    tmpvar_7 = 0.0;
  } else {
    tmpvar_7 = 1.0;
  };
  highp float tmpvar_13;
  highp float tmpvar_14;
  if ((tmpvar_6.y < 0.5)) {
    highp float blend_15;
    blend_15 = (2.0 * tmpvar_6.y);
    highp float tmpvar_16;
    if ((blend_15 == 0.0)) {
      tmpvar_16 = blend_15;
    } else {
      tmpvar_16 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.y)
       / blend_15)), 0.0);
    };
    tmpvar_14 = tmpvar_16;
  } else {
    highp float blend_17;
    blend_17 = (2.0 * (tmpvar_6.y - 0.5));
    highp float tmpvar_18;
    if ((blend_17 == 1.0)) {
      tmpvar_18 = blend_17;
    } else {
      tmpvar_18 = min ((xlt_fbColor_1.y / (1.0 - blend_17)), 1.0);
    };
    tmpvar_14 = tmpvar_18;
  };
  if ((tmpvar_14 < 0.5)) {
    tmpvar_13 = 0.0;
  } else {
    tmpvar_13 = 1.0;
  };
  highp float tmpvar_19;
  highp float tmpvar_20;
  if ((tmpvar_6.z < 0.5)) {
    highp float blend_21;
    blend_21 = (2.0 * tmpvar_6.z);
    highp float tmpvar_22;
    if ((blend_21 == 0.0)) {
      tmpvar_22 = blend_21;
    } else {
      tmpvar_22 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.z)
       / blend_21)), 0.0);
    };
    tmpvar_20 = tmpvar_22;
  } else {
    highp float blend_23;
    blend_23 = (2.0 * (tmpvar_6.z - 0.5));
    highp float tmpvar_24;
    if ((blend_23 == 1.0)) {
      tmpvar_24 = blend_23;
    } else {
      tmpvar_24 = min ((xlt_fbColor_1.z / (1.0 - blend_23)), 1.0);
    };
    tmpvar_20 = tmpvar_24;
  };
  if ((tmpvar_20 < 0.5)) {
    tmpvar_19 = 0.0;
  } else {
    tmpvar_19 = 1.0;
  };
  highp vec3 tmpvar_25;
  tmpvar_25.x = tmpvar_7;
  tmpvar_25.y = tmpvar_13;
  tmpvar_25.z = tmpvar_19;
  resultColor_4.xyz = tmpvar_25;
  resultColor_4.w = factor_3;
  xlt_fbColor_1 = resultColor_4;
  _glesFragData[0] = resultColor_4;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPLANE","BLEND_HARDMIX"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec4 worldPosition_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.xy = _glesVertex.xy;
  tmpvar_5 = tmpvar_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_8;
  tmpvar_8 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_4 = tmpvar_9;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_4 = (LOCALWORLD_TRANSFORM * tmpvar_9);
  };
  highp vec3 tmpvar_10;
  tmpvar_10.x = CAMERA_VIEW[0].x;
  tmpvar_10.y = CAMERA_VIEW[1].x;
  tmpvar_10.z = CAMERA_VIEW[2].x;
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * tmpvar_11));
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_10.yzx * axisUp_3.zxy) - (tmpvar_10.zxy * axisUp_3.yzx)));
  highp float tmpvar_13;
  tmpvar_13 = cos(_glesNormal.x);
  highp float tmpvar_14;
  tmpvar_14 = sin(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.y);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.z);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.z);
  highp mat3 tmpvar_19;
  tmpvar_19[uint(0)].x = (tmpvar_17 * tmpvar_15);
  tmpvar_19[uint(0)].y = (tmpvar_15 * tmpvar_18);
  tmpvar_19[uint(0)].z = -(tmpvar_16);
  tmpvar_19[1u].x = (((tmpvar_17 * tmpvar_16) * tmpvar_14) - (tmpvar_13 * tmpvar_18));
  tmpvar_19[1u].y = ((tmpvar_17 * tmpvar_13) + ((tmpvar_18 * tmpvar_16) * tmpvar_14));
  tmpvar_19[1u].z = (tmpvar_15 * tmpvar_14);
  tmpvar_19[2u].x = ((tmpvar_18 * tmpvar_14) + ((tmpvar_17 * tmpvar_13) * tmpvar_16));
  tmpvar_19[2u].y = (((tmpvar_13 * tmpvar_16) * tmpvar_18) - (tmpvar_17 * tmpvar_14));
  tmpvar_19[2u].z = (tmpvar_15 * tmpvar_13);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = tmpvar_10.x;
  tmpvar_20[uint(0)].y = tmpvar_10.y;
  tmpvar_20[uint(0)].z = tmpvar_10.z;
  tmpvar_20[1u].x = axisUp_3.x;
  tmpvar_20[1u].y = axisUp_3.y;
  tmpvar_20[1u].z = axisUp_3.z;
  tmpvar_20[2u].x = tmpvar_12.x;
  tmpvar_20[2u].y = tmpvar_12.y;
  tmpvar_20[2u].z = tmpvar_12.z;
  worldPosition_4.xyz = (worldPosition_4.xyz + ((tmpvar_20 * tmpvar_19) * (
    ((tmpvar_6.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_8.xyx)));
  highp float tmpvar_21;
  tmpvar_21 = float((tmpvar_7.x >= 0.0));
  uv_2.x = ((tmpvar_21 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_21) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_7.y >= 0.0));
  uv_2.y = ((tmpvar_22 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_5 = (CAMERA_VIEWPROJ * worldPosition_4);
  highp vec4 o_23;
  highp vec4 tmpvar_24;
  tmpvar_24 = (tmpvar_5 * 0.5);
  o_23.zw = tmpvar_24.zw;
  o_23.xy = (tmpvar_24.xy + tmpvar_24.ww);
  o_23.y = ((2.0 * tmpvar_24.w) - o_23.y);
  o_23.zw = tmpvar_5.zw;
  highp vec4 tmpvar_25;
  tmpvar_25.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_25.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_25 * tmpvar_5);
  tmpvar_5 = tmpvar_26;
  gl_Position = tmpvar_26;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_23;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp float factor_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_2 = (_Opacity * tmpvar_5.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  if ((tmpvar_5.x < 0.5)) {
    highp float blend_11;
    blend_11 = (2.0 * tmpvar_5.x);
    highp float tmpvar_12;
    if ((blend_11 == 0.0)) {
      tmpvar_12 = blend_11;
    } else {
      tmpvar_12 = max ((1.0 - (
        (1.0 - srcColor_6.x)
       / blend_11)), 0.0);
    };
    tmpvar_10 = tmpvar_12;
  } else {
    highp float blend_13;
    blend_13 = (2.0 * (tmpvar_5.x - 0.5));
    highp float tmpvar_14;
    if ((blend_13 == 1.0)) {
      tmpvar_14 = blend_13;
    } else {
      tmpvar_14 = min ((srcColor_6.x / (1.0 - blend_13)), 1.0);
    };
    tmpvar_10 = tmpvar_14;
  };
  if ((tmpvar_10 < 0.5)) {
    tmpvar_9 = 0.0;
  } else {
    tmpvar_9 = 1.0;
  };
  highp float tmpvar_15;
  highp float tmpvar_16;
  if ((tmpvar_5.y < 0.5)) {
    highp float blend_17;
    blend_17 = (2.0 * tmpvar_5.y);
    highp float tmpvar_18;
    if ((blend_17 == 0.0)) {
      tmpvar_18 = blend_17;
    } else {
      tmpvar_18 = max ((1.0 - (
        (1.0 - srcColor_6.y)
       / blend_17)), 0.0);
    };
    tmpvar_16 = tmpvar_18;
  } else {
    highp float blend_19;
    blend_19 = (2.0 * (tmpvar_5.y - 0.5));
    highp float tmpvar_20;
    if ((blend_19 == 1.0)) {
      tmpvar_20 = blend_19;
    } else {
      tmpvar_20 = min ((srcColor_6.y / (1.0 - blend_19)), 1.0);
    };
    tmpvar_16 = tmpvar_20;
  };
  if ((tmpvar_16 < 0.5)) {
    tmpvar_15 = 0.0;
  } else {
    tmpvar_15 = 1.0;
  };
  highp float tmpvar_21;
  highp float tmpvar_22;
  if ((tmpvar_5.z < 0.5)) {
    highp float blend_23;
    blend_23 = (2.0 * tmpvar_5.z);
    highp float tmpvar_24;
    if ((blend_23 == 0.0)) {
      tmpvar_24 = blend_23;
    } else {
      tmpvar_24 = max ((1.0 - (
        (1.0 - srcColor_6.z)
       / blend_23)), 0.0);
    };
    tmpvar_22 = tmpvar_24;
  } else {
    highp float blend_25;
    blend_25 = (2.0 * (tmpvar_5.z - 0.5));
    highp float tmpvar_26;
    if ((blend_25 == 1.0)) {
      tmpvar_26 = blend_25;
    } else {
      tmpvar_26 = min ((srcColor_6.z / (1.0 - blend_25)), 1.0);
    };
    tmpvar_22 = tmpvar_26;
  };
  if ((tmpvar_22 < 0.5)) {
    tmpvar_21 = 0.0;
  } else {
    tmpvar_21 = 1.0;
  };
  highp vec3 tmpvar_27;
  tmpvar_27.x = tmpvar_9;
  tmpvar_27.y = tmpvar_15;
  tmpvar_27.z = tmpvar_21;
  resultColor_3.xyz = tmpvar_27;
  resultColor_3.w = factor_2;
  tmpvar_1 = resultColor_3;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","VIEWPOSITION","BLEND_HARDMIX"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp float factor_3;
  highp vec4 resultColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_6;
  tmpvar_6 = (tmpvar_5 * xlv_TEXCOORD2);
  resultColor_4 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_3 = (_Opacity * tmpvar_6.w);
  highp float tmpvar_7;
  highp float tmpvar_8;
  if ((tmpvar_6.x < 0.5)) {
    highp float blend_9;
    blend_9 = (2.0 * tmpvar_6.x);
    highp float tmpvar_10;
    if ((blend_9 == 0.0)) {
      tmpvar_10 = blend_9;
    } else {
      tmpvar_10 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.x)
       / blend_9)), 0.0);
    };
    tmpvar_8 = tmpvar_10;
  } else {
    highp float blend_11;
    blend_11 = (2.0 * (tmpvar_6.x - 0.5));
    highp float tmpvar_12;
    if ((blend_11 == 1.0)) {
      tmpvar_12 = blend_11;
    } else {
      tmpvar_12 = min ((xlt_fbColor_1.x / (1.0 - blend_11)), 1.0);
    };
    tmpvar_8 = tmpvar_12;
  };
  if ((tmpvar_8 < 0.5)) {
    tmpvar_7 = 0.0;
  } else {
    tmpvar_7 = 1.0;
  };
  highp float tmpvar_13;
  highp float tmpvar_14;
  if ((tmpvar_6.y < 0.5)) {
    highp float blend_15;
    blend_15 = (2.0 * tmpvar_6.y);
    highp float tmpvar_16;
    if ((blend_15 == 0.0)) {
      tmpvar_16 = blend_15;
    } else {
      tmpvar_16 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.y)
       / blend_15)), 0.0);
    };
    tmpvar_14 = tmpvar_16;
  } else {
    highp float blend_17;
    blend_17 = (2.0 * (tmpvar_6.y - 0.5));
    highp float tmpvar_18;
    if ((blend_17 == 1.0)) {
      tmpvar_18 = blend_17;
    } else {
      tmpvar_18 = min ((xlt_fbColor_1.y / (1.0 - blend_17)), 1.0);
    };
    tmpvar_14 = tmpvar_18;
  };
  if ((tmpvar_14 < 0.5)) {
    tmpvar_13 = 0.0;
  } else {
    tmpvar_13 = 1.0;
  };
  highp float tmpvar_19;
  highp float tmpvar_20;
  if ((tmpvar_6.z < 0.5)) {
    highp float blend_21;
    blend_21 = (2.0 * tmpvar_6.z);
    highp float tmpvar_22;
    if ((blend_21 == 0.0)) {
      tmpvar_22 = blend_21;
    } else {
      tmpvar_22 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.z)
       / blend_21)), 0.0);
    };
    tmpvar_20 = tmpvar_22;
  } else {
    highp float blend_23;
    blend_23 = (2.0 * (tmpvar_6.z - 0.5));
    highp float tmpvar_24;
    if ((blend_23 == 1.0)) {
      tmpvar_24 = blend_23;
    } else {
      tmpvar_24 = min ((xlt_fbColor_1.z / (1.0 - blend_23)), 1.0);
    };
    tmpvar_20 = tmpvar_24;
  };
  if ((tmpvar_20 < 0.5)) {
    tmpvar_19 = 0.0;
  } else {
    tmpvar_19 = 1.0;
  };
  highp vec3 tmpvar_25;
  tmpvar_25.x = tmpvar_7;
  tmpvar_25.y = tmpvar_13;
  tmpvar_25.z = tmpvar_19;
  resultColor_4.xyz = tmpvar_25;
  resultColor_4.w = factor_3;
  xlt_fbColor_1 = resultColor_4;
  _glesFragData[0] = resultColor_4;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"VIEWPOSITION","BLEND_HARDMIX"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEW",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCK_Y",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEW;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float LOCK_Y;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisForward_4;
  highp vec4 worldPosition_5;
  highp vec4 tmpvar_6;
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = _glesVertex.xy;
  tmpvar_6 = tmpvar_7;
  highp vec2 tmpvar_8;
  tmpvar_8 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_9;
  tmpvar_9 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_5 = tmpvar_10;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_5 = (LOCALWORLD_TRANSFORM * tmpvar_10);
  };
  axisForward_4 = (CAMERA_WORLDPOSITION - worldPosition_5.xyz);
  highp vec3 tmpvar_11;
  tmpvar_11.x = CAMERA_VIEW[0].y;
  tmpvar_11.y = CAMERA_VIEW[1].y;
  tmpvar_11.z = CAMERA_VIEW[2].y;
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(((tmpvar_11.yzx * axisForward_4.zxy) - (tmpvar_11.zxy * axisForward_4.yzx)));
  axisUp_3 = ((LOCK_Y * vec3(0.0, 1.0, 0.0)) + ((1.0 - LOCK_Y) * normalize(
    ((axisForward_4.yzx * tmpvar_12.zxy) - (axisForward_4.zxy * tmpvar_12.yzx))
  )));
  highp vec3 tmpvar_13;
  tmpvar_13 = ((tmpvar_12.yzx * axisUp_3.zxy) - (tmpvar_12.zxy * axisUp_3.yzx));
  axisForward_4 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = cos(_glesNormal.x);
  highp float tmpvar_15;
  tmpvar_15 = sin(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = cos(_glesNormal.y);
  highp float tmpvar_17;
  tmpvar_17 = sin(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = cos(_glesNormal.z);
  highp float tmpvar_19;
  tmpvar_19 = sin(_glesNormal.z);
  highp mat3 tmpvar_20;
  tmpvar_20[uint(0)].x = (tmpvar_18 * tmpvar_16);
  tmpvar_20[uint(0)].y = (tmpvar_16 * tmpvar_19);
  tmpvar_20[uint(0)].z = -(tmpvar_17);
  tmpvar_20[1u].x = (((tmpvar_18 * tmpvar_17) * tmpvar_15) - (tmpvar_14 * tmpvar_19));
  tmpvar_20[1u].y = ((tmpvar_18 * tmpvar_14) + ((tmpvar_19 * tmpvar_17) * tmpvar_15));
  tmpvar_20[1u].z = (tmpvar_16 * tmpvar_15);
  tmpvar_20[2u].x = ((tmpvar_19 * tmpvar_15) + ((tmpvar_18 * tmpvar_14) * tmpvar_17));
  tmpvar_20[2u].y = (((tmpvar_14 * tmpvar_17) * tmpvar_19) - (tmpvar_18 * tmpvar_15));
  tmpvar_20[2u].z = (tmpvar_16 * tmpvar_14);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = tmpvar_12.x;
  tmpvar_21[uint(0)].y = tmpvar_12.y;
  tmpvar_21[uint(0)].z = tmpvar_12.z;
  tmpvar_21[1u].x = axisUp_3.x;
  tmpvar_21[1u].y = axisUp_3.y;
  tmpvar_21[1u].z = axisUp_3.z;
  tmpvar_21[2u].x = tmpvar_13.x;
  tmpvar_21[2u].y = tmpvar_13.y;
  tmpvar_21[2u].z = tmpvar_13.z;
  worldPosition_5.xyz = (worldPosition_5.xyz + ((tmpvar_21 * tmpvar_20) * (
    ((tmpvar_7.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_9.xyx)));
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_8.x >= 0.0));
  uv_2.x = ((tmpvar_22 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_22) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_8.y >= 0.0));
  uv_2.y = ((tmpvar_23 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_6 = (CAMERA_VIEWPROJ * worldPosition_5);
  highp vec4 o_24;
  highp vec4 tmpvar_25;
  tmpvar_25 = (tmpvar_6 * 0.5);
  o_24.zw = tmpvar_25.zw;
  o_24.xy = (tmpvar_25.xy + tmpvar_25.ww);
  o_24.y = ((2.0 * tmpvar_25.w) - o_24.y);
  o_24.zw = tmpvar_6.zw;
  highp vec4 tmpvar_26;
  tmpvar_26.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_26.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_27;
  tmpvar_27 = (tmpvar_26 * tmpvar_6);
  tmpvar_6 = tmpvar_27;
  gl_Position = tmpvar_27;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_24;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
in highp vec4 xlv_TEXCOORD4;
void main ()
{
  lowp vec4 tmpvar_1;
  highp float factor_2;
  highp vec4 resultColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_5;
  tmpvar_5 = (tmpvar_4 * xlv_TEXCOORD2);
  resultColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_2 = (_Opacity * tmpvar_5.w);
  highp vec4 srcColor_6;
  highp vec2 tmpvar_7;
  tmpvar_7 = (xlv_TEXCOORD4.xy / xlv_TEXCOORD4.w);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_GRAP, tmpvar_7);
  srcColor_6 = tmpvar_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  if ((tmpvar_5.x < 0.5)) {
    highp float blend_11;
    blend_11 = (2.0 * tmpvar_5.x);
    highp float tmpvar_12;
    if ((blend_11 == 0.0)) {
      tmpvar_12 = blend_11;
    } else {
      tmpvar_12 = max ((1.0 - (
        (1.0 - srcColor_6.x)
       / blend_11)), 0.0);
    };
    tmpvar_10 = tmpvar_12;
  } else {
    highp float blend_13;
    blend_13 = (2.0 * (tmpvar_5.x - 0.5));
    highp float tmpvar_14;
    if ((blend_13 == 1.0)) {
      tmpvar_14 = blend_13;
    } else {
      tmpvar_14 = min ((srcColor_6.x / (1.0 - blend_13)), 1.0);
    };
    tmpvar_10 = tmpvar_14;
  };
  if ((tmpvar_10 < 0.5)) {
    tmpvar_9 = 0.0;
  } else {
    tmpvar_9 = 1.0;
  };
  highp float tmpvar_15;
  highp float tmpvar_16;
  if ((tmpvar_5.y < 0.5)) {
    highp float blend_17;
    blend_17 = (2.0 * tmpvar_5.y);
    highp float tmpvar_18;
    if ((blend_17 == 0.0)) {
      tmpvar_18 = blend_17;
    } else {
      tmpvar_18 = max ((1.0 - (
        (1.0 - srcColor_6.y)
       / blend_17)), 0.0);
    };
    tmpvar_16 = tmpvar_18;
  } else {
    highp float blend_19;
    blend_19 = (2.0 * (tmpvar_5.y - 0.5));
    highp float tmpvar_20;
    if ((blend_19 == 1.0)) {
      tmpvar_20 = blend_19;
    } else {
      tmpvar_20 = min ((srcColor_6.y / (1.0 - blend_19)), 1.0);
    };
    tmpvar_16 = tmpvar_20;
  };
  if ((tmpvar_16 < 0.5)) {
    tmpvar_15 = 0.0;
  } else {
    tmpvar_15 = 1.0;
  };
  highp float tmpvar_21;
  highp float tmpvar_22;
  if ((tmpvar_5.z < 0.5)) {
    highp float blend_23;
    blend_23 = (2.0 * tmpvar_5.z);
    highp float tmpvar_24;
    if ((blend_23 == 0.0)) {
      tmpvar_24 = blend_23;
    } else {
      tmpvar_24 = max ((1.0 - (
        (1.0 - srcColor_6.z)
       / blend_23)), 0.0);
    };
    tmpvar_22 = tmpvar_24;
  } else {
    highp float blend_25;
    blend_25 = (2.0 * (tmpvar_5.z - 0.5));
    highp float tmpvar_26;
    if ((blend_25 == 1.0)) {
      tmpvar_26 = blend_25;
    } else {
      tmpvar_26 = min ((srcColor_6.z / (1.0 - blend_25)), 1.0);
    };
    tmpvar_22 = tmpvar_26;
  };
  if ((tmpvar_22 < 0.5)) {
    tmpvar_21 = 0.0;
  } else {
    tmpvar_21 = 1.0;
  };
  highp vec3 tmpvar_27;
  tmpvar_27.x = tmpvar_9;
  tmpvar_27.y = tmpvar_15;
  tmpvar_27.z = tmpvar_21;
  resultColor_3.xyz = tmpvar_27;
  resultColor_3.w = factor_2;
  tmpvar_1 = resultColor_3;
  _glesFragData[0] = tmpvar_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FRAMEBUFFER_FETCH","AXIS","BLEND_HARDMIX"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
#extension GL_EXT_shader_framebuffer_fetch : enable
layout(location=0) inout mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float _Opacity;
in highp vec2 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD2;
void main ()
{
  highp vec4 xlt_fbColor_1;
  mediump vec4 tmpvar_2;
  tmpvar_2 = _glesFragData[0];
  xlt_fbColor_1 = tmpvar_2;
  highp float factor_3;
  highp vec4 resultColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_6;
  tmpvar_6 = (tmpvar_5 * xlv_TEXCOORD2);
  resultColor_4 = vec4(1.0, 1.0, 1.0, 1.0);
  factor_3 = (_Opacity * tmpvar_6.w);
  highp float tmpvar_7;
  highp float tmpvar_8;
  if ((tmpvar_6.x < 0.5)) {
    highp float blend_9;
    blend_9 = (2.0 * tmpvar_6.x);
    highp float tmpvar_10;
    if ((blend_9 == 0.0)) {
      tmpvar_10 = blend_9;
    } else {
      tmpvar_10 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.x)
       / blend_9)), 0.0);
    };
    tmpvar_8 = tmpvar_10;
  } else {
    highp float blend_11;
    blend_11 = (2.0 * (tmpvar_6.x - 0.5));
    highp float tmpvar_12;
    if ((blend_11 == 1.0)) {
      tmpvar_12 = blend_11;
    } else {
      tmpvar_12 = min ((xlt_fbColor_1.x / (1.0 - blend_11)), 1.0);
    };
    tmpvar_8 = tmpvar_12;
  };
  if ((tmpvar_8 < 0.5)) {
    tmpvar_7 = 0.0;
  } else {
    tmpvar_7 = 1.0;
  };
  highp float tmpvar_13;
  highp float tmpvar_14;
  if ((tmpvar_6.y < 0.5)) {
    highp float blend_15;
    blend_15 = (2.0 * tmpvar_6.y);
    highp float tmpvar_16;
    if ((blend_15 == 0.0)) {
      tmpvar_16 = blend_15;
    } else {
      tmpvar_16 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.y)
       / blend_15)), 0.0);
    };
    tmpvar_14 = tmpvar_16;
  } else {
    highp float blend_17;
    blend_17 = (2.0 * (tmpvar_6.y - 0.5));
    highp float tmpvar_18;
    if ((blend_17 == 1.0)) {
      tmpvar_18 = blend_17;
    } else {
      tmpvar_18 = min ((xlt_fbColor_1.y / (1.0 - blend_17)), 1.0);
    };
    tmpvar_14 = tmpvar_18;
  };
  if ((tmpvar_14 < 0.5)) {
    tmpvar_13 = 0.0;
  } else {
    tmpvar_13 = 1.0;
  };
  highp float tmpvar_19;
  highp float tmpvar_20;
  if ((tmpvar_6.z < 0.5)) {
    highp float blend_21;
    blend_21 = (2.0 * tmpvar_6.z);
    highp float tmpvar_22;
    if ((blend_21 == 0.0)) {
      tmpvar_22 = blend_21;
    } else {
      tmpvar_22 = max ((1.0 - (
        (1.0 - xlt_fbColor_1.z)
       / blend_21)), 0.0);
    };
    tmpvar_20 = tmpvar_22;
  } else {
    highp float blend_23;
    blend_23 = (2.0 * (tmpvar_6.z - 0.5));
    highp float tmpvar_24;
    if ((blend_23 == 1.0)) {
      tmpvar_24 = blend_23;
    } else {
      tmpvar_24 = min ((xlt_fbColor_1.z / (1.0 - blend_23)), 1.0);
    };
    tmpvar_20 = tmpvar_24;
  };
  if ((tmpvar_20 < 0.5)) {
    tmpvar_19 = 0.0;
  } else {
    tmpvar_19 = 1.0;
  };
  highp vec3 tmpvar_25;
  tmpvar_25.x = tmpvar_7;
  tmpvar_25.y = tmpvar_13;
  tmpvar_25.z = tmpvar_19;
  resultColor_4.xyz = tmpvar_25;
  resultColor_4.w = factor_3;
  xlt_fbColor_1 = resultColor_4;
  _glesFragData[0] = resultColor_4;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"AXIS","BLEND_HARDMIX"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_RIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AXIS_UP",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIM_SPACE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "IMAGE_INFO",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROTATE_CENTER",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PIVOT_OFFSET_SCALE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Opacity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesColor;
in vec3 _glesNormal;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord1;
in vec4 _glesMultiTexCoord2;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec3 AXIS_RIGHT;
uniform highp vec3 AXIS_UP;
uniform highp float SIM_SPACE;
uniform highp vec4 IMAGE_INFO;
uniform highp vec4 ROTATE_CENTER;
uniform highp vec3 PIVOT_OFFSET_SCALE;
out highp vec2 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD2;
out highp vec4 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec2 uv_2;
  highp vec3 axisUp_3;
  highp vec3 axisRight_4;
  highp vec3 axisForward_5;
  highp vec4 worldPosition_6;
  highp vec4 tmpvar_7;
  highp vec4 tmpvar_8;
  tmpvar_8.zw = vec2(0.0, 1.0);
  tmpvar_8.xy = _glesVertex.xy;
  tmpvar_7 = tmpvar_8;
  highp vec2 tmpvar_9;
  tmpvar_9 = sign(_glesMultiTexCoord1.xy);
  highp vec2 tmpvar_10;
  tmpvar_10 = abs(_glesMultiTexCoord1.xy);
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _glesMultiTexCoord2.xyz;
  worldPosition_6 = tmpvar_11;
  if ((SIM_SPACE < 2.0)) {
    worldPosition_6 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  };
  axisRight_4 = normalize(AXIS_RIGHT);
  highp vec3 tmpvar_12;
  tmpvar_12 = normalize(AXIS_UP);
  axisUp_3 = tmpvar_12;
  if ((ROTATE_CENTER.w > 0.0)) {
    highp vec3 tmpvar_13;
    tmpvar_13 = normalize((worldPosition_6.xyz - ROTATE_CENTER.xyz));
    axisForward_5 = tmpvar_13;
    highp vec3 tmpvar_14;
    tmpvar_14 = ((tmpvar_12.yzx * tmpvar_13.zxy) - (tmpvar_12.zxy * tmpvar_13.yzx));
    axisRight_4 = tmpvar_14;
    axisUp_3 = ((tmpvar_13.yzx * tmpvar_14.zxy) - (tmpvar_13.zxy * tmpvar_14.yzx));
  } else {
    axisForward_5 = normalize(((axisRight_4.yzx * axisUp_3.zxy) - (axisRight_4.zxy * axisUp_3.yzx)));
  };
  highp float tmpvar_15;
  tmpvar_15 = cos(_glesNormal.x);
  highp float tmpvar_16;
  tmpvar_16 = sin(_glesNormal.x);
  highp float tmpvar_17;
  tmpvar_17 = cos(_glesNormal.y);
  highp float tmpvar_18;
  tmpvar_18 = sin(_glesNormal.y);
  highp float tmpvar_19;
  tmpvar_19 = cos(_glesNormal.z);
  highp float tmpvar_20;
  tmpvar_20 = sin(_glesNormal.z);
  highp mat3 tmpvar_21;
  tmpvar_21[uint(0)].x = (tmpvar_19 * tmpvar_17);
  tmpvar_21[uint(0)].y = (tmpvar_17 * tmpvar_20);
  tmpvar_21[uint(0)].z = -(tmpvar_18);
  tmpvar_21[1u].x = (((tmpvar_19 * tmpvar_18) * tmpvar_16) - (tmpvar_15 * tmpvar_20));
  tmpvar_21[1u].y = ((tmpvar_19 * tmpvar_15) + ((tmpvar_20 * tmpvar_18) * tmpvar_16));
  tmpvar_21[1u].z = (tmpvar_17 * tmpvar_16);
  tmpvar_21[2u].x = ((tmpvar_20 * tmpvar_16) + ((tmpvar_19 * tmpvar_15) * tmpvar_18));
  tmpvar_21[2u].y = (((tmpvar_15 * tmpvar_18) * tmpvar_20) - (tmpvar_19 * tmpvar_16));
  tmpvar_21[2u].z = (tmpvar_17 * tmpvar_15);
  highp mat3 tmpvar_22;
  tmpvar_22[uint(0)].x = axisRight_4.x;
  tmpvar_22[uint(0)].y = axisRight_4.y;
  tmpvar_22[uint(0)].z = axisRight_4.z;
  tmpvar_22[1u].x = axisUp_3.x;
  tmpvar_22[1u].y = axisUp_3.y;
  tmpvar_22[1u].z = axisUp_3.z;
  tmpvar_22[2u].x = axisForward_5.x;
  tmpvar_22[2u].y = axisForward_5.y;
  tmpvar_22[2u].z = axisForward_5.z;
  worldPosition_6.xyz = (worldPosition_6.xyz + ((tmpvar_22 * tmpvar_21) * (
    ((tmpvar_8.xyz * vec3(1.0, 1.0, 0.0)) + PIVOT_OFFSET_SCALE)
   * tmpvar_10.xyx)));
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_9.x >= 0.0));
  uv_2.x = ((tmpvar_23 * _glesMultiTexCoord0.x) + ((1.0 - tmpvar_23) * (1.0 - _glesMultiTexCoord0.x)));
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_9.y >= 0.0));
  uv_2.y = ((tmpvar_24 * _glesMultiTexCoord0.y) + ((1.0 - tmpvar_24) * (1.0 - _glesMultiTexCoord0.y)));
  tmpvar_7 = (CAMERA_VIEWPROJ * worldPosition_6);
  highp vec4 o_25;
  highp vec4 tmpvar_26;
  tmpvar_26 = (tmpvar_7 * 0.5);
  o_25.zw = tmpvar_26.zw;
  o_25.xy = (tmpvar_26.xy + tmpvar_26.ww);
  o_25.y = ((2.0 * tmpvar_26.w) - o_25.y);
  o_25.zw = tmpvar_7.zw;
  highp vec4 tmpvar_27;
  tmpvar_27.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_27.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_28;
  tmpvar_28 = (tmpvar_27 * tmpvar_7);
  tmpvar_7 = tmpvar_28;
  gl_Position = tmpvar_28;
  xlv_TEXCOORD0 = ((_glesMultiTexCoord1.zw + uv_2) * IMAGE_INFO.zw);
  xlv_TEXCOORD2 = tmpvar_1;
  xlv_TEXCOORD4 = o_25;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D TEXTURE_DIFFUSE;
uni