
#DEFPARAMS
_MainTex = { "main Color", TEXTURE2D, "white" },
_MaskTex = { "mask Color", TEXTURE2D, "white"},
_MainTexTile = {"Main Tex Tile", VEC2, "1.0,1.0"},
_MainTexOffset = {"offset", VEC2, "0.0,0.0"},
_MainTexSpeed = {"Main Tex Speed", VEC2, "0.0,0.0"},
_FadeScale = {"Fade Scale", FLOAT, "1.0"},
_EdgeSmoothScale = {"Edge Smooth Scale", FLOAT, "1.0"},
_DisortSpeed = {"Disort Speed", VEC2, "0.0,0.0"},
_DisortTex = { "main Color", TEXTURE2D, "white" },
_Color = { "Color", COLOR, "1.0,1.0,1.0,1.0"},
_ColorScale = { "Color Scale", FLOAT, "1.0"},
_DisortTex_UV_Speed = { "DisortTex UV Speed", VEC2, "0.0,0.0"},
_MaskTex = { "Mask Tex", TEXTURE2D, "white"},
_MaskTexTile = { "Mask Tex Tile", VEC2, "1.0,1.0"},
_MaskTexOffset = { "Mask Tex Offset", VEC2, "0.0,0.0"},
_Power = {"Power", FLOAT, "1.0"},
[Keywords(DISORT_ON,DISORT_OFF)]
_Disort = {"Disort", FLOAT, "1.0"},
[Keywords(BLEND_NORMAL,BLEND_ADD)]
_BlendMode = {"Blend Mode", FLOAT, "0.0"},
[Enum(BlendFactor)]
_BlendSrc = {"Blend Src", FLOAT, "4.0"},
[Enum(BlendFactor)]
_BlendDst = {"Blend Dst", FLOAT, "5.0"},
_DefMode = { "Def Mode", FLOAT, "0.0"},

MESH_PARTICLE_COLOR = { "MESH PARTICLE COLOR", COLOR, "1.0,1.0,1.0,1.0"},
_Itensity = { "Itensity", FLOAT, "0.0"},
_Tex2 = { "Tex2", TEXTURE2D, "white" },
_Tex2_UV_Speed = { "Tex2 UV Speed", VEC2, "0.0,0.0"},
_Tex2Tile = { "Tex2 Tile", VEC2, "1.0,1.0"},
_Tex2Offset = { "Tex2 Offset", VEC2, "0.0,0.0"},



#END

#DEFTAG
ShaderName = "particle_mesh_uvamitation"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc",  "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_MASK_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile DISORT_ON DISORT_OFF
#pragma multi_compile BLEND_NORMAL BLEND_ADD
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
	float3 normal : NORMAL;
	
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float2 origin_uv : TEXCOORD2;
	float disturb : TEXCOORD1; 
	float4 vertex : SV_POSITION;
};

sampler2D _MainTex;
sampler2D _MaskTex;
float2    _MainTexSpeed;
float2    _MainTexTile;
float2    _MainTexOffset;
float     _FadeScale;
float     _EdgeSmoothScale;
float2    _DisortSpeed;
sampler2D _DisortTex;
float4 	  _Color;
float     _ColorScale;
float2    _MaskTexTile;
float2    _MaskTexOffset;
float     _Power;
float     _Itensity;
float4    MESH_PARTICLE_COLOR;
float     SYSTEM_TIME;
sampler2D _Tex2;
float2    _Tex2_UV_Speed;
float2    _Tex2Tile;
float2    _Tex2Offset;


v2f vert(appdata v)
{
	
	v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	
	float2 uv = v.uv.xy;
	o.origin_uv = v.uv.xy ;
	uv = uv *_MainTexTile + _MainTexOffset;
	uv += _MainTexSpeed*SYSTEM_TIME ;
	o.uv = uv;
	o.disturb = sin(v.uv.y) * _FadeScale + (1.0 - _FadeScale);

	float3 worldNormal = ObjectToWorldNormal(v.normal).xyz;
	float3 worldViewDir =  normalize(CAMERA_WORLDPOSITION - ObjectToWorldPos(v.vertex).xyz);
	o.disturb = o.disturb * (abs(dot(worldViewDir, worldNormal)) * _EdgeSmoothScale + (1.0 - _EdgeSmoothScale));
	return o;
}

float4 frag(v2f i) : SV_Target
{
	float2 uv_Origin = i.origin_uv * _MainTexTile + _MainTexOffset;
	float2 uv_MainTex = i.uv.xy;

	#ifdef DISORT_ON
		float2 uv_DisortTex = uv_Origin + _DisortSpeed * SYSTEM_TIME ;
		float distort = tex2D(_DisortTex, uv_DisortTex).r;
		uv_MainTex += float2(distort,distort) * _Itensity;
	#endif
	
	float alpha = tex2D(_MaskTex, i.uv.xy).r * i.disturb;
	float4 mainColor = MESH_PARTICLE_COLOR *tex2D(_MainTex, uv_MainTex);
	
	float2 uv_Tex2 = i.origin_uv * _Tex2Tile + _Tex2Offset + _Tex2_UV_Speed * SYSTEM_TIME;
    float4 Tex2Color = tex2D(_Tex2, uv_Tex2);
    mainColor *= Tex2Color;
	
	float2 uv_Mask = i.origin_uv * _MaskTexTile + _MaskTexOffset;
    float4 maskColor = tex2D(_MaskTex, uv_Mask);
    float maskAlpha = pow(maskColor.r,_Power);
	
	mainColor.a = mainColor.a * _Color.a *_ColorScale * maskAlpha * i.disturb ;
	#ifdef BLEND_NORMAL
	   mainColor.rgb = mainColor.rgb * _Color.rgb *_ColorScale ;
	#else
	   mainColor.rgb = mainColor.rgb * _Color.rgb *_ColorScale * mainColor.a;
	#endif
	
	return mainColor;
}
ENDCG
#END
