
function DefineParams()
	Properties = 
	{
		
_MainTex = { "main Color", TEXTURE2D, "white" },
_MaskTex = { "mask Color", TEXTURE2D, "white"},
_MainTexTile = {"Main Tex Tile", VEC2, "1.0,1.0"},
_MainTexOffset = {"offset", VEC2, "0.0,0.0"},
_MainTexSpeed = {"Main Tex Speed", VEC2, "0.0,0.0"},
_FadeScale = {"Fade Scale", FLOAT, "1.0"},
_EdgeSmoothScale = {"Edge Smooth Scale", FLOAT, "1.0"},
_DisortSpeed = {"Disort Speed", VEC2, "0.0,0.0"},
_DisortTex = { "main Color", TEXTURE2D, "white" },
_Color = { "Color", COLOR, "1.0,1.0,1.0,1.0"},
_ColorScale = { "Color Scale", FLOAT, "1.0"},
_DisortTex_UV_Speed = { "DisortTex UV Speed", VEC2, "0.0,0.0"},
_MaskTex = { "Mask Tex", TEXTURE2D, "white"},
_MaskTexTile = { "Mask Tex Tile", VEC2, "1.0,1.0"},
_MaskTexOffset = { "Mask Tex Offset", VEC2, "0.0,0.0"},
_Power = {"Power", FLOAT, "1.0"},

_Disort = {"Disort", FLOAT, "1.0"},

_BlendMode = {"Blend Mode", FLOAT, "0.0"},

_BlendSrc = {"Blend Src", FLOAT, "4.0"},

_BlendDst = {"Blend Dst", FLOAT, "5.0"},
_DefMode = { "Def Mode", FLOAT, "0.0"},

MESH_PARTICLE_COLOR = { "MESH PARTICLE COLOR", COLOR, "1.0,1.0,1.0,1.0"},
_Itensity = { "Itensity", FLOAT, "0.0"},
_Tex2 = { "Tex2", TEXTURE2D, "white" },
_Tex2_UV_Speed = { "Tex2 UV Speed", VEC2, "0.0,0.0"},
_Tex2Tile = { "Tex2 Tile", VEC2, "1.0,1.0"},
_Tex2Offset = { "Tex2 Offset", VEC2, "0.0,0.0"},




	}
	Attributes = 
	{
		_Disort = "Keywords(DISORT_ON,DISORT_OFF)", 
		_BlendMode = "Keywords(BLEND_NORMAL,BLEND_ADD)", 
		_BlendSrc = "Enum(BlendFactor)", 
		_BlendDst = "Enum(BlendFactor)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "particle_mesh_uvamitation"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc",  "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_MASK_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"DISORT_ON","BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexSpeed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FadeScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EdgeSmoothScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SYSTEM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DisortSpeed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DisortTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Color",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ColorScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Power",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Itensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MESH_PARTICLE_COLOR",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SYSTEM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Tile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Offset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainTexSpeed;
uniform highp vec2 _MainTexTile;
uniform highp vec2 _MainTexOffset;
uniform highp float _FadeScale;
uniform highp float _EdgeSmoothScale;
uniform highp float SYSTEM_TIME;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 uv_2;
  highp float tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  uv_2 = ((_glesMultiTexCoord0.xy * _MainTexTile) + _MainTexOffset);
  uv_2 = (uv_2 + (_MainTexSpeed * SYSTEM_TIME));
  tmpvar_3 = ((sin(_glesMultiTexCoord0.y) * _FadeScale) + (1.0 - _FadeScale));
  highp mat3 tmpvar_6;
  tmpvar_6[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_6[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_6[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_3 = (tmpvar_3 * ((
    abs(dot (normalize((CAMERA_WORLDPOSITION - 
      (LOCALWORLD_TRANSFORM * tmpvar_7)
    .xyz)), normalize((tmpvar_6 * _glesNormal))))
   * _EdgeSmoothScale) + (1.0 - _EdgeSmoothScale)));
  xlv_TEXCOORD0 = uv_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_3;
  gl_Position = (tmpvar_5 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4)));
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform highp vec2 _MainTexTile;
uniform highp vec2 _MainTexOffset;
uniform highp vec2 _DisortSpeed;
uniform sampler2D _DisortTex;
uniform highp vec4 _Color;
uniform highp float _ColorScale;
uniform highp vec2 _MaskTexTile;
uniform highp vec2 _MaskTexOffset;
uniform highp float _Power;
uniform highp float _Itensity;
uniform highp vec4 MESH_PARTICLE_COLOR;
uniform highp float SYSTEM_TIME;
uniform sampler2D _Tex2;
uniform highp vec2 _Tex2_UV_Speed;
uniform highp vec2 _Tex2Tile;
uniform highp vec2 _Tex2Offset;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 maskColor_1;
  highp vec4 Tex2Color_2;
  highp vec4 mainColor_3;
  highp float distort_4;
  highp vec2 uv_MainTex_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (((xlv_TEXCOORD2 * _MainTexTile) + _MainTexOffset) + (_DisortSpeed * SYSTEM_TIME));
  lowp float tmpvar_7;
  tmpvar_7 = texture2D (_DisortTex, tmpvar_6).x;
  distort_4 = tmpvar_7;
  uv_MainTex_5 = (xlv_TEXCOORD0 + (vec2(distort_4) * _Itensity));
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_MainTex, uv_MainTex_5);
  highp vec2 tmpvar_9;
  tmpvar_9 = (((xlv_TEXCOORD2 * _Tex2Tile) + _Tex2Offset) + (_Tex2_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (_Tex2, tmpvar_9);
  Tex2Color_2 = tmpvar_10;
  mainColor_3 = ((MESH_PARTICLE_COLOR * tmpvar_8) * Tex2Color_2);
  highp vec2 tmpvar_11;
  tmpvar_11 = ((xlv_TEXCOORD2 * _MaskTexTile) + _MaskTexOffset);
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture2D (_MaskTex, tmpvar_11);
  maskColor_1 = tmpvar_12;
  mainColor_3.w = (((
    (mainColor_3.w * _Color.w)
   * _ColorScale) * pow (maskColor_1.x, _Power)) * xlv_TEXCOORD1);
  mainColor_3.xyz = ((mainColor_3.xyz * _Color.xyz) * _ColorScale);
  gl_FragData[0] = mainColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DISORT_OFF","BLEND_NORMAL"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexSpeed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FadeScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EdgeSmoothScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SYSTEM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Color",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ColorScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Power",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MESH_PARTICLE_COLOR",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SYSTEM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Tile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Offset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainTexSpeed;
uniform highp vec2 _MainTexTile;
uniform highp vec2 _MainTexOffset;
uniform highp float _FadeScale;
uniform highp float _EdgeSmoothScale;
uniform highp float SYSTEM_TIME;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 uv_2;
  highp float tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  uv_2 = ((_glesMultiTexCoord0.xy * _MainTexTile) + _MainTexOffset);
  uv_2 = (uv_2 + (_MainTexSpeed * SYSTEM_TIME));
  tmpvar_3 = ((sin(_glesMultiTexCoord0.y) * _FadeScale) + (1.0 - _FadeScale));
  highp mat3 tmpvar_6;
  tmpvar_6[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_6[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_6[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_3 = (tmpvar_3 * ((
    abs(dot (normalize((CAMERA_WORLDPOSITION - 
      (LOCALWORLD_TRANSFORM * tmpvar_7)
    .xyz)), normalize((tmpvar_6 * _glesNormal))))
   * _EdgeSmoothScale) + (1.0 - _EdgeSmoothScale)));
  xlv_TEXCOORD0 = uv_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_3;
  gl_Position = (tmpvar_5 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4)));
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform highp vec4 _Color;
uniform highp float _ColorScale;
uniform highp vec2 _MaskTexTile;
uniform highp vec2 _MaskTexOffset;
uniform highp float _Power;
uniform highp vec4 MESH_PARTICLE_COLOR;
uniform highp float SYSTEM_TIME;
uniform sampler2D _Tex2;
uniform highp vec2 _Tex2_UV_Speed;
uniform highp vec2 _Tex2Tile;
uniform highp vec2 _Tex2Offset;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 maskColor_1;
  highp vec4 Tex2Color_2;
  highp vec4 mainColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_MainTex, xlv_TEXCOORD0);
  highp vec2 tmpvar_5;
  tmpvar_5 = (((xlv_TEXCOORD2 * _Tex2Tile) + _Tex2Offset) + (_Tex2_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_Tex2, tmpvar_5);
  Tex2Color_2 = tmpvar_6;
  mainColor_3 = ((MESH_PARTICLE_COLOR * tmpvar_4) * Tex2Color_2);
  highp vec2 tmpvar_7;
  tmpvar_7 = ((xlv_TEXCOORD2 * _MaskTexTile) + _MaskTexOffset);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_MaskTex, tmpvar_7);
  maskColor_1 = tmpvar_8;
  mainColor_3.w = (((
    (mainColor_3.w * _Color.w)
   * _ColorScale) * pow (maskColor_1.x, _Power)) * xlv_TEXCOORD1);
  mainColor_3.xyz = ((mainColor_3.xyz * _Color.xyz) * _ColorScale);
  gl_FragData[0] = mainColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DISORT_ON","BLEND_ADD"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexSpeed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FadeScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EdgeSmoothScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SYSTEM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DisortSpeed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_DisortTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Color",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ColorScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Power",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Itensity",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MESH_PARTICLE_COLOR",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SYSTEM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Tile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Offset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainTexSpeed;
uniform highp vec2 _MainTexTile;
uniform highp vec2 _MainTexOffset;
uniform highp float _FadeScale;
uniform highp float _EdgeSmoothScale;
uniform highp float SYSTEM_TIME;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 uv_2;
  highp float tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  uv_2 = ((_glesMultiTexCoord0.xy * _MainTexTile) + _MainTexOffset);
  uv_2 = (uv_2 + (_MainTexSpeed * SYSTEM_TIME));
  tmpvar_3 = ((sin(_glesMultiTexCoord0.y) * _FadeScale) + (1.0 - _FadeScale));
  highp mat3 tmpvar_6;
  tmpvar_6[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_6[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_6[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_3 = (tmpvar_3 * ((
    abs(dot (normalize((CAMERA_WORLDPOSITION - 
      (LOCALWORLD_TRANSFORM * tmpvar_7)
    .xyz)), normalize((tmpvar_6 * _glesNormal))))
   * _EdgeSmoothScale) + (1.0 - _EdgeSmoothScale)));
  xlv_TEXCOORD0 = uv_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_3;
  gl_Position = (tmpvar_5 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4)));
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform highp vec2 _MainTexTile;
uniform highp vec2 _MainTexOffset;
uniform highp vec2 _DisortSpeed;
uniform sampler2D _DisortTex;
uniform highp vec4 _Color;
uniform highp float _ColorScale;
uniform highp vec2 _MaskTexTile;
uniform highp vec2 _MaskTexOffset;
uniform highp float _Power;
uniform highp float _Itensity;
uniform highp vec4 MESH_PARTICLE_COLOR;
uniform highp float SYSTEM_TIME;
uniform sampler2D _Tex2;
uniform highp vec2 _Tex2_UV_Speed;
uniform highp vec2 _Tex2Tile;
uniform highp vec2 _Tex2Offset;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 maskColor_1;
  highp vec4 Tex2Color_2;
  highp vec4 mainColor_3;
  highp float distort_4;
  highp vec2 uv_MainTex_5;
  highp vec2 tmpvar_6;
  tmpvar_6 = (((xlv_TEXCOORD2 * _MainTexTile) + _MainTexOffset) + (_DisortSpeed * SYSTEM_TIME));
  lowp float tmpvar_7;
  tmpvar_7 = texture2D (_DisortTex, tmpvar_6).x;
  distort_4 = tmpvar_7;
  uv_MainTex_5 = (xlv_TEXCOORD0 + (vec2(distort_4) * _Itensity));
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_MainTex, uv_MainTex_5);
  highp vec2 tmpvar_9;
  tmpvar_9 = (((xlv_TEXCOORD2 * _Tex2Tile) + _Tex2Offset) + (_Tex2_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_10;
  tmpvar_10 = texture2D (_Tex2, tmpvar_9);
  Tex2Color_2 = tmpvar_10;
  mainColor_3 = ((MESH_PARTICLE_COLOR * tmpvar_8) * Tex2Color_2);
  highp vec2 tmpvar_11;
  tmpvar_11 = ((xlv_TEXCOORD2 * _MaskTexTile) + _MaskTexOffset);
  lowp vec4 tmpvar_12;
  tmpvar_12 = texture2D (_MaskTex, tmpvar_11);
  maskColor_1 = tmpvar_12;
  mainColor_3.w = (((
    (mainColor_3.w * _Color.w)
   * _ColorScale) * pow (maskColor_1.x, _Power)) * xlv_TEXCOORD1);
  mainColor_3.xyz = ((mainColor_3.xyz * _Color.xyz) * (_ColorScale * mainColor_3.w));
  gl_FragData[0] = mainColor_3;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DISORT_OFF","BLEND_ADD"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexSpeed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MainTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FadeScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_EdgeSmoothScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SYSTEM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Color",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ColorScale",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexTile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTexOffset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Power",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MESH_PARTICLE_COLOR",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SYSTEM_TIME",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2_UV_Speed",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Tile",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Tex2Offset",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 _MainTexSpeed;
uniform highp vec2 _MainTexTile;
uniform highp vec2 _MainTexOffset;
uniform highp float _FadeScale;
uniform highp float _EdgeSmoothScale;
uniform highp float SYSTEM_TIME;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 uv_2;
  highp float tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  uv_2 = ((_glesMultiTexCoord0.xy * _MainTexTile) + _MainTexOffset);
  uv_2 = (uv_2 + (_MainTexSpeed * SYSTEM_TIME));
  tmpvar_3 = ((sin(_glesMultiTexCoord0.y) * _FadeScale) + (1.0 - _FadeScale));
  highp mat3 tmpvar_6;
  tmpvar_6[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_6[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_6[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp vec4 tmpvar_7;
  tmpvar_7.w = 1.0;
  tmpvar_7.xyz = tmpvar_1.xyz;
  tmpvar_3 = (tmpvar_3 * ((
    abs(dot (normalize((CAMERA_WORLDPOSITION - 
      (LOCALWORLD_TRANSFORM * tmpvar_7)
    .xyz)), normalize((tmpvar_6 * _glesNormal))))
   * _EdgeSmoothScale) + (1.0 - _EdgeSmoothScale)));
  xlv_TEXCOORD0 = uv_2;
  xlv_TEXCOORD2 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_3;
  gl_Position = (tmpvar_5 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4)));
}

]===],
		psShader = [===[uniform sampler2D _MainTex;
uniform sampler2D _MaskTex;
uniform highp vec4 _Color;
uniform highp float _ColorScale;
uniform highp vec2 _MaskTexTile;
uniform highp vec2 _MaskTexOffset;
uniform highp float _Power;
uniform highp vec4 MESH_PARTICLE_COLOR;
uniform highp float SYSTEM_TIME;
uniform sampler2D _Tex2;
uniform highp vec2 _Tex2_UV_Speed;
uniform highp vec2 _Tex2Tile;
uniform highp vec2 _Tex2Offset;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD2;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 maskColor_1;
  highp vec4 Tex2Color_2;
  highp vec4 mainColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_MainTex, xlv_TEXCOORD0);
  highp vec2 tmpvar_5;
  tmpvar_5 = (((xlv_TEXCOORD2 * _Tex2Tile) + _Tex2Offset) + (_Tex2_UV_Speed * SYSTEM_TIME));
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_Tex2, tmpvar_5);
  Tex2Color_2 = tmpvar_6;
  mainColor_3 = ((MESH_PARTICLE_COLOR * tmpvar_4) * Tex2Color_2);
  highp vec2 tmpvar_7;
  tmpvar_7 = ((xlv_TEXCOORD2 * _MaskTexTile) + _MaskTexOffset);
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture2D (_MaskTex, tmpvar_7);
  maskColor_1 = tmpvar_8;
  mainColor_3.w = (((
    (mainColor_3.w * _Color.w)
   * _ColorScale) * pow (maskColor_1.x, _Power)) * xlv_TEXCOORD1);
  mainColor_3.xyz = ((mainColor_3.xyz * _Color.xyz) * (_ColorScale * mainColor_3.w));
  gl_FragData[0] = mainColor_3;
}

]===],
	},
}

end
