

function DefineParams()
	Properties = 
	{
		
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "white" },
_FadeFactor = { "factor", FLOATRANGE, "1.0, 10.0, 0.0" },
_UVYMin = { "src Min", FLOATRANGE, "0.9, 1.0, 0.8" },
_UVYFactor = { "_UVY bottom Factor", FLOATRANGE, "0.0, 2.0, 1.0" },
MESH_PARTICLE_COLOR = { "particle Color", VEC4, "1.0,1.0,1.0,1.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "particle_mesh"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MESH_PARTICLE_COLOR",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FadeFactor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UVYMin",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_UVYFactor",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = tmpvar_1.xyz;
  highp mat3 tmpvar_3;
  tmpvar_3[0] = LOCALWORLD_TRANSFORM[0].xyz;
  tmpvar_3[1] = LOCALWORLD_TRANSFORM[1].xyz;
  tmpvar_3[2] = LOCALWORLD_TRANSFORM[2].xyz;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_5 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2)));
  xlv_TEXCOORD1 = abs(dot (normalize(
    ((LOCALWORLD_TRANSFORM * tmpvar_4).xyz - CAMERA_WORLDPOSITION)
  ), normalize(
    normalize((tmpvar_3 * _glesNormal))
  )));
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec4 MESH_PARTICLE_COLOR;
uniform highp float _FadeFactor;
uniform highp float _UVYMin;
uniform highp float _UVYFactor;
varying highp vec2 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 col_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_3;
  tmpvar_3 = (tmpvar_2 * MESH_PARTICLE_COLOR);
  col_1.xyz = tmpvar_3.xyz;
  col_1.w = (((tmpvar_3.w * xlv_TEXCOORD1) * _FadeFactor) * pow (xlv_TEXCOORD0.y, 3.0));
  if ((xlv_TEXCOORD0.y > _UVYMin)) {
    col_1.w = (col_1.w * pow ((1.0 - 
      ((1.0/((1.0 - _UVYMin))) * (xlv_TEXCOORD0.y - _UVYMin))
    ), _UVYFactor));
  };
  gl_FragData[0] = col_1;
}

]===],
	},
}

end
