

function DefineParams()
	Properties = 
	{
		
_BGTex = { "BG Texture", TEXTURE2D, "white" },
_MaskTex = { "Mask Texture", TEXTURE2D, "white" },
_CutOff = { "CutOff", FLOAT, "0.2" },
_Color =  { "_Color", FLOAT, "3" },

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "avatardepthmask"
RenderQueue = "Overlay"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_BGTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_CutOff",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Color",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec4 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.w = 1.0;
  tmpvar_1.xyz = _glesVertex.xyz;
  highp vec4 tmpvar_2;
  tmpvar_2.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_2.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_3;
  tmpvar_3 = (tmpvar_2 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_1)));
  gl_Position = tmpvar_3;
  xlv_TEXCOORD0 = tmpvar_3;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D _BGTex;
uniform sampler2D _MaskTex;
uniform highp float _CutOff;
uniform highp float _Color;
in highp vec4 xlv_TEXCOORD0;
void main ()
{
  highp vec4 bgcolor_1;
  highp vec4 maskcolor_2;
  highp vec2 uv_3;
  uv_3 = (((xlv_TEXCOORD0.xy / xlv_TEXCOORD0.w) + vec2(1.0, 1.0)) / 2.0);
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (_MaskTex, uv_3);
  maskcolor_2 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (_BGTex, uv_3);
  bgcolor_1.xyz = tmpvar_5.xyz;
  if ((maskcolor_2[int(_Color)] < _CutOff)) {
    discard;
  };
  bgcolor_1.w = maskcolor_2[int(_Color)];
  _glesFragData[0] = bgcolor_1;
}

]===],
	},
}

end
