

function DefineParams()
	Properties = 
	{
		
_MainTex = { "main Color", TEXTURE2D, "white" },

_BlendSrc = {"blendsrc", FLOAT, "4.0"},

_BlendDst = {"blenddst", FLOAT, "5.0"},
_TexAspect = {"TexAspect", FLOAT, "1.0"}

	}
	Attributes = 
	{
		_BlendSrc = "Enum(BlendFunc)", 
		_BlendDst = "Enum(BlendFunc)", 
	}
	
end




function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "sticker_quad"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc", "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexAspect",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _TexAspect;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.zw = _glesVertex.zw;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[uint(0)].x = row0_4.x;
  tmpvar_9[uint(0)].y = row0_4.y;
  tmpvar_9[uint(0)].z = row0_4.z;
  tmpvar_9[uint(0)].w = row0_4.w;
  tmpvar_9[1u].x = row1_3.x;
  tmpvar_9[1u].y = row1_3.y;
  tmpvar_9[1u].z = row1_3.z;
  tmpvar_9[1u].w = row1_3.w;
  tmpvar_9[2u].x = row2_2.x;
  tmpvar_9[2u].y = row2_2.y;
  tmpvar_9[2u].z = row2_2.z;
  tmpvar_9[2u].w = row2_2.w;
  tmpvar_9[3u].x = 0.0;
  tmpvar_9[3u].y = 0.0;
  tmpvar_9[3u].z = 0.0;
  tmpvar_9[3u].w = 1.0;
  bool tmpvar_10;
  tmpvar_10 = (_TexAspect >= 0.999);
  bool tmpvar_11;
  tmpvar_11 = (0.999 >= _TexAspect);
  tmpvar_1.x = (_glesVertex.x * ((
    float(tmpvar_10)
   * _TexAspect) + float(tmpvar_11)));
  tmpvar_1.y = (_glesVertex.y * (float(tmpvar_10) + (
    float(tmpvar_11)
   / _TexAspect)));
  highp vec4 tmpvar_12;
  tmpvar_12.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_12.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_12 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * 
    (tmpvar_1 * tmpvar_9)
  )));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D _MainTex;
in highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 mainColor_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture (_MainTex, xlv_TEXCOORD0);
  mainColor_1 = tmpvar_2;
  _glesFragData[0] = mainColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexAspect",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_MainTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _TexAspect;
out highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.zw = _glesVertex.zw;
  bool tmpvar_2;
  tmpvar_2 = (_TexAspect >= 0.999);
  bool tmpvar_3;
  tmpvar_3 = (0.999 >= _TexAspect);
  tmpvar_1.x = (_glesVertex.x * ((
    float(tmpvar_2)
   * _TexAspect) + float(tmpvar_3)));
  tmpvar_1.y = (_glesVertex.y * (float(tmpvar_2) + (
    float(tmpvar_3)
   / _TexAspect)));
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_5;
  tmpvar_5.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_5.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_5 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4)));
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D _MainTex;
in highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 mainColor_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture (_MainTex, xlv_TEXCOORD0);
  mainColor_1 = tmpvar_2;
  _glesFragData[0] = mainColor_1;
}

]===],
	},
}

end
