#DEFPARAMS
_TexMask = {"TexMask", TEXTURE2D, "white" },
_TexR = {"TexR", TEXTURE2D, "white" },
_TexG = {"TexG", TEXTURE2D, "white" },


_MaskR = {"MaskR", FLOAT, "1.0"},
_MaskG = {"MaskG", FLOAT, "1.0"},
_BiasR = {"BiasR", FLOAT, "0.0"},
_BiasG = {"BiasG", FLOAT, "0.0"},

_TransMaskR = {"TransMaskR", FLOAT, "1.0"},
_TransMaskG = {"TransMaskG", FLOAT, "1.0"},
_TransBiasR = {"TransBiasR", FLOAT, "0.0"},
_TransBiasG = {"TransBiasG", FLOAT, "0.0"},

#END

#DEFTAG
ShaderName = "MixBySegment_t"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "light.inc"
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv     : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D _TexMask;
sampler2D  _TexR;
sampler2D  _TexG;


float _MaskR;
float _MaskG;
float _BiasR;
float _BiasG;

float _TransMaskR;
float _TransMaskG;
float _TransBiasR;
float _TransBiasG;


v2f vert(appdata v)
{
	v2f o;
	float4 pos = v.vertex * (1.0 / v.vertex.w);
	pos = mul(LOCALWORLD_TRANSFORM, pos);
	pos.w = 1.0;
	pos.x = pos.x + WORLD_POSITION.x;
	pos.y = pos.y + WORLD_POSITION.y;
	o.vertex = UniformNDC(pos);
	o.uv = v.uv.xy;
	return o;
}

float4 frag(v2f i) : SV_Target
{	
	float2 maskuv =  i.uv;

    fixed maskcolor  = tex2D(_TexMask, maskuv).a;

	fixed4 colorr  = tex2D(_TexR, i.uv).rgba;
	fixed4 colorg  = tex2D(_TexG, i.uv).rgba;


	fixed4 frameColor = colorr*(maskcolor*_MaskR+_BiasR)
					  + colorg*((1-maskcolor)*_MaskG+_BiasG);

	fixed alpha = (maskcolor*_TransMaskR+_TransBiasR)+((1-maskcolor)*_TransMaskG+_TransBiasG);
	frameColor.a = alpha;
	
    return frameColor;
}
ENDCG
#END
