function DefineParams()
	Properties = 
	{
		
_TexMask = {"TexMask", TEXTURE2D, "white" },
_TexR = {"TexR", TEXTURE2D, "white" },
_TexG = {"TexG", TEXTURE2D, "white" },


_MaskR = {"MaskR", FLOAT, "1.0"},
_MaskG = {"MaskG", FLOAT, "1.0"},
_BiasR = {"BiasR", FLOAT, "0.0"},
_BiasG = {"BiasG", FLOAT, "0.0"},

_TransMaskR = {"TransMaskR", FLOAT, "1.0"},
_TransMaskG = {"TransMaskG", FLOAT, "1.0"},
_TransBiasR = {"TransBiasR", FLOAT, "0.0"},
_TransBiasG = {"TransBiasG", FLOAT, "0.0"},


	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "MixBySegment_t"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "WORLD_POSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "_TexMask",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TexG",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskR",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_MaskG",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BiasR",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BiasG",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TransMaskR",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TransMaskG",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TransBiasR",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TransBiasG",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp vec3 WORLD_POSITION;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 pos_1;
  pos_1.xyz = (LOCALWORLD_TRANSFORM * (_glesVertex * (1.0/(_glesVertex.w)))).xyz;
  pos_1.w = 1.0;
  pos_1.xy = (pos_1.xy + WORLD_POSITION.xy);
  highp vec4 tmpvar_2;
  tmpvar_2.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_2.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_2 * pos_1);
}

]===],
		psShader = [===[uniform sampler2D _TexMask;
uniform sampler2D _TexR;
uniform sampler2D _TexG;
uniform highp float _MaskR;
uniform highp float _MaskG;
uniform highp float _BiasR;
uniform highp float _BiasG;
uniform highp float _TransMaskR;
uniform highp float _TransMaskG;
uniform highp float _TransBiasR;
uniform highp float _TransBiasG;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  lowp float alpha_2;
  lowp vec4 frameColor_3;
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (_TexMask, xlv_TEXCOORD0);
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_TexR, xlv_TEXCOORD0);
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_TexG, xlv_TEXCOORD0);
  highp vec4 tmpvar_7;
  tmpvar_7 = ((tmpvar_5 * (
    (tmpvar_4.w * _MaskR)
   + _BiasR)) + (tmpvar_6 * (
    ((1.0 - tmpvar_4.w) * _MaskG)
   + _BiasG)));
  frameColor_3.xyz = tmpvar_7.xyz;
  highp float tmpvar_8;
  tmpvar_8 = (((tmpvar_4.w * _TransMaskR) + _TransBiasR) + ((
    (1.0 - tmpvar_4.w)
   * _TransMaskG) + _TransBiasG));
  alpha_2 = tmpvar_8;
  frameColor_3.w = alpha_2;
  tmpvar_1 = frameColor_3;
  gl_FragData[0] = tmpvar_1;
}

]===],
	},
}

end
