function DefineParams()
	Properties = 
	{
		
_BlendTex =     {"2_Texture         ", TEXTURE2D, "white"},

_BlendMode =    {"3_Belnd Mode  ", FLOAT, "0.0"},
_Alpha =        {"4_Opacity         ", FLOATRANGE, "1.0,1.0,0.0"},

_DepthTest =    {"5_Depth Test    ", FLOAT, "1.0"},

_StretchMode =    {"6_Stretch Mode ", FLOAT, "0.0"},

_FlipHorizon =  {"7_Flip Horizon", FLOAT, "0.0"},

_FlipVertical = {"8_Flip Vertical", FLOAT, "0.0"},
_TextureRatio =    {"9_TextureRatio ", FLOAT, "0.0"},
_WindowRatio =    {"10_WindowRatio ", FLOAT, "1.0"},
_ScaleXRatio =    {"11_ScaleXRatio ", FLOAT, "1.0"},
_ScaleYRatio =    {"12_ScaleYRatio ", FLOAT, "1.0"},

_BGFill =    {"13_BackGround Fill ", FLOAT, "0.0"},
_SingleColor = {"14_SingleColor", VEC4, "0.0,0.0,0.0,1.0"},
_XRepeat = {"15_XRepeat", FLOAT, "1.0"},
_YRepeat = {"16_YRepeat", FLOAT, "1.0"},
_GaussianStep = {"17_GaussianStep", VEC2, "1.0, 1.0"},

	}
	Attributes = 
	{
		_BlendMode = "Enum(Normal,0,Add,1,Lighten,2,Multiply,3,Overlay,4,Screen,5,Lighter,6)", 
		_DepthTest = "Enum(ON,0,OFF,1)", 
		_StretchMode = "Enum(Fit,0,Fill,1,Stretch,2,FitHeight,3,FitWidth,4,FillAndCut,5)", 
		_FlipHorizon = "Enum(HON,0,HOFF,1)", 
		_FlipVertical = "Enum(ON,0,VOFF,1)", 
		_BGFill = "Enum(Blur,0,Solid,1,Mirror,2,Tile,3)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "screenimage"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"GPUSKIN4"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_StretchMode",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FlipVertical",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FlipHorizon",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TextureRatio",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_WindowRatio",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ScaleXRatio",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ScaleYRatio",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendMode",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_StretchMode",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BGFill",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_SingleColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_XRepeat",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_YRepeat",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GaussianStep",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _StretchMode;
uniform highp float _FlipVertical;
uniform highp float _FlipHorizon;
uniform highp float _TextureRatio;
uniform highp float _WindowRatio;
uniform highp float _ScaleXRatio;
uniform highp float _ScaleYRatio;
in highp vec4 _glesBlendIndices;
in highp vec4 _glesBlendWeight;
out highp vec2 xlv_TEXCOORD0;
out highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  highp vec2 tmpvar_2;
  highp vec4 row2_3;
  highp vec4 row1_4;
  highp vec4 row0_5;
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_9;
  tmpvar_9 = (int(_glesBlendIndices.w) * 3);
  row0_5 = (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.x);
  row1_4 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.x);
  row2_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.x);
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.y));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.y));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.y));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.z));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.z));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.z));
  row0_5 = (row0_5 + (ANIMATION_MATRIX_ARRAY[tmpvar_9] * _glesBlendWeight.w));
  row1_4 = (row1_4 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 1)] * _glesBlendWeight.w));
  row2_3 = (row2_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_9 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_10;
  tmpvar_10[uint(0)].x = row0_5.x;
  tmpvar_10[uint(0)].y = row0_5.y;
  tmpvar_10[uint(0)].z = row0_5.z;
  tmpvar_10[uint(0)].w = row0_5.w;
  tmpvar_10[1u].x = row1_4.x;
  tmpvar_10[1u].y = row1_4.y;
  tmpvar_10[1u].z = row1_4.z;
  tmpvar_10[1u].w = row1_4.w;
  tmpvar_10[2u].x = row2_3.x;
  tmpvar_10[2u].y = row2_3.y;
  tmpvar_10[2u].z = row2_3.z;
  tmpvar_10[2u].w = row2_3.w;
  tmpvar_10[3u].x = 0.0;
  tmpvar_10[3u].y = 0.0;
  tmpvar_10[3u].z = 0.0;
  tmpvar_10[3u].w = 1.0;
  highp vec4 tmpvar_11;
  tmpvar_11 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_10)));
  highp vec2 tmpvar_12;
  tmpvar_12.x = tmpvar_11.x;
  tmpvar_12.y = -(tmpvar_11.y);
  tmpvar_2 = (((tmpvar_12 / tmpvar_11.w) + 1.0) / 2.0);
  highp vec4 tmpvar_13;
  tmpvar_13.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_13.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_14;
  tmpvar_14 = (tmpvar_13 * tmpvar_11);
  tmpvar_1 = _glesMultiTexCoord0.xy;
  if ((_StretchMode == 5.0)) {
    if ((((_ScaleXRatio / _ScaleYRatio) * _WindowRatio) > _TextureRatio)) {
      tmpvar_1.y = (((
        (_glesMultiTexCoord0.y * _ScaleYRatio)
       / _ScaleXRatio) * _TextureRatio) / _WindowRatio);
      tmpvar_1.y = (tmpvar_1.y + ((1.0 - 
        (((_ScaleYRatio / _ScaleXRatio) * _TextureRatio) / _WindowRatio)
      ) / 2.0));
    } else {
      tmpvar_1.x = (((
        (_glesMultiTexCoord0.x * _ScaleXRatio)
       / _ScaleYRatio) * _WindowRatio) / _TextureRatio);
      tmpvar_1.x = (tmpvar_1.x + ((1.0 - 
        (((_ScaleXRatio / _ScaleYRatio) * _WindowRatio) / _TextureRatio)
      ) / 2.0));
    };
  };
  if (bool(_FlipHorizon)) {
    tmpvar_1.x = (1.0 - tmpvar_1.x);
  };
  if (bool(_FlipVertical)) {
    tmpvar_1.y = (1.0 - tmpvar_1.y);
  };
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = tmpvar_2;
  gl_Position = tmpvar_14;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _BlendTex;
uniform highp float _BlendMode;
uniform highp float _StretchMode;
uniform highp float _Alpha;
uniform highp float _BGFill;
uniform highp vec4 _SingleColor;
uniform highp float _XRepeat;
uniform highp float _YRepeat;
uniform highp vec2 _GaussianStep;
in highp vec2 xlv_TEXCOORD0;
in highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1 = xlv_TEXCOORD0;
  highp vec4 mainColor_2;
  highp vec4 dstColor_3;
  dstColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp int tmpvar_4;
  tmpvar_4 = int((_BGFill + 1.5));
  if ((tmpvar_4 == 1)) {
    highp float Weight_6[7];
    Weight_6[6] = 0.05;
    Weight_6[0] = 0.05;
    Weight_6[5] = 0.1;
    Weight_6[1] = 0.1;
    Weight_6[4] = 0.15;
    Weight_6[2] = 0.15;
    Weight_6[3] = 0.4;
    dstColor_3 = vec4(0.0, 0.0, 0.0, 0.0);
    for (highp int row_5 = -3; row_5 <= 3; row_5++) {
      highp vec2 tmpvar_7;
      tmpvar_7.x = (tmpvar_1.x + (float(row_5) * _GaussianStep.x));
      tmpvar_7.y = (tmpvar_1.y + (_GaussianStep.y * -3.0));
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture (_BlendTex, tmpvar_7);
      dstColor_3 = (dstColor_3 + ((Weight_6[
        (row_5 + 3)
      ] * Weight_6[0]) * tmpvar_8));
      highp vec2 tmpvar_9;
      tmpvar_9.x = (tmpvar_1.x + (float(row_5) * _GaussianStep.x));
      tmpvar_9.y = (tmpvar_1.y + (_GaussianStep.y * -2.0));
      lowp vec4 tmpvar_10;
      tmpvar_10 = texture (_BlendTex, tmpvar_9);
      dstColor_3 = (dstColor_3 + ((Weight_6[
        (row_5 + 3)
      ] * Weight_6[1]) * tmpvar_10));
      highp vec2 tmpvar_11;
      tmpvar_11.x = (tmpvar_1.x + (float(row_5) * _GaussianStep.x));
      tmpvar_11.y = (tmpvar_1.y - _GaussianStep.y);
      lowp vec4 tmpvar_12;
      tmpvar_12 = texture (_BlendTex, tmpvar_11);
      dstColor_3 = (dstColor_3 + ((Weight_6[
        (row_5 + 3)
      ] * Weight_6[2]) * tmpvar_12));
      highp vec2 tmpvar_13;
      tmpvar_13.x = (tmpvar_1.x + (float(row_5) * _GaussianStep.x));
      tmpvar_13.y = tmpvar_1.y;
      lowp vec4 tmpvar_14;
      tmpvar_14 = texture (_BlendTex, tmpvar_13);
      dstColor_3 = (dstColor_3 + ((Weight_6[
        (row_5 + 3)
      ] * Weight_6[3]) * tmpvar_14));
      highp vec2 tmpvar_15;
      tmpvar_15.x = (tmpvar_1.x + (float(row_5) * _GaussianStep.x));
      tmpvar_15.y = (tmpvar_1.y + _GaussianStep.y);
      lowp vec4 tmpvar_16;
      tmpvar_16 = texture (_BlendTex, tmpvar_15);
      dstColor_3 = (dstColor_3 + ((Weight_6[
        (row_5 + 3)
      ] * Weight_6[4]) * tmpvar_16));
      highp vec2 tmpvar_17;
      tmpvar_17.x = (tmpvar_1.x + (float(row_5) * _GaussianStep.x));
      tmpvar_17.y = (tmpvar_1.y + (_GaussianStep.y * 2.0));
      lowp vec4 tmpvar_18;
      tmpvar_18 = texture (_BlendTex, tmpvar_17);
      dstColor_3 = (dstColor_3 + ((Weight_6[
        (row_5 + 3)
      ] * Weight_6[5]) * tmpvar_18));
      highp vec2 tmpvar_19;
      tmpvar_19.x = (tmpvar_1.x + (float(row_5) * _GaussianStep.x));
      tmpvar_19.y = (tmpvar_1.y + (_GaussianStep.y * 3.0));
      lowp vec4 tmpvar_20;
      tmpvar_20 = texture (_BlendTex, tmpvar_19);
      dstColor_3 = (dstColor_3 + ((Weight_6[
        (row_5 + 3)
      ] * Weight_6[6]) * tmpvar_20));
    };
  } else {
    if ((tmpvar_4 == 2)) {
      dstColor_3 = _SingleColor;
    } else {
      if ((tmpvar_4 == 3)) {
        highp vec4 rgba2_21;
        highp vec4 rgba1_22;
        highp vec2 tmpvar_23;
        tmpvar_23.x = (xlv_TEXCOORD0.x + 0.25);
        tmpvar_23.y = xlv_TEXCOORD0.y;
        highp vec2 tmpvar_24;
        tmpvar_24.x = (1.25 - xlv_TEXCOORD0.x);
        tmpvar_24.y = xlv_TEXCOORD0.y;
        lowp vec4 tmpvar_25;
        tmpvar_25 = texture (_BlendTex, tmpvar_23);
        rgba1_22 = tmpvar_25;
        lowp vec4 tmpvar_26;
        tmpvar_26 = texture (_BlendTex, tmpvar_24);
        rgba2_21 = tmpvar_26;
        bool tmpvar_27;
        tmpvar_27 = (xlv_TEXCOORD0.x >= 0.5);
        dstColor_3 = ((float(tmpvar_27) * rgba2_21) + ((1.0 - 
          float(tmpvar_27)
        ) * rgba1_22));
      } else {
        if ((_StretchMode == 2.0)) {
          highp vec2 tex_coord_28;
          highp float tmpvar_29;
          tmpvar_29 = (1.0/(_XRepeat));
          tex_coord_28.x = ((xlv_TEXCOORD0.x - (
            float(int((xlv_TEXCOORD0.x / tmpvar_29)))
           * tmpvar_29)) * _XRepeat);
          highp float tmpvar_30;
          tmpvar_30 = (1.0/(_YRepeat));
          tex_coord_28.y = ((xlv_TEXCOORD0.y - (
            float(int((xlv_TEXCOORD0.y / tmpvar_30)))
           * tmpvar_30)) * _YRepeat);
          lowp vec4 tmpvar_31;
          tmpvar_31 = texture (_BlendTex, tex_coord_28);
          dstColor_3 = tmpvar_31;
        } else {
          lowp vec4 tmpvar_32;
          tmpvar_32 = texture (_BlendTex, xlv_TEXCOORD0);
          dstColor_3 = tmpvar_32;
        };
      };
    };
  };
  lowp vec4 tmpvar_33;
  tmpvar_33 = texture (TEXTURE_GRAP, xlv_TEXCOORD1);
  mainColor_2 = tmpvar_33;
  highp int mode_34;
  mode_34 = int((_BlendMode + 1.5));
  bool tmpvar_35;
  tmpvar_35 = bool(1);
  highp vec3 tmpvar_36;
  if ((mode_34 == 1)) {
    tmpvar_36 = (((
      (mainColor_2.xyz * (1.0 - dstColor_3.w))
     + 
      (dstColor_3.xyz * dstColor_3.w)
    ) * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
    tmpvar_35 = bool(0);
  } else {
    if ((mode_34 == 2)) {
      tmpvar_36 = ((min (
        (mainColor_2.xyz + dstColor_3.xyz)
      , vec3(1.0, 1.0, 1.0)) * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
      tmpvar_35 = bool(0);
    } else {
      if ((mode_34 == 3)) {
        tmpvar_36 = ((max (dstColor_3.xyz, mainColor_2.xyz) * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
        tmpvar_35 = bool(0);
      } else {
        if ((mode_34 == 4)) {
          tmpvar_36 = (((mainColor_2.xyz * dstColor_3.xyz) * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
          tmpvar_35 = bool(0);
        } else {
          if ((mode_34 == 5)) {
            highp float tmpvar_37;
            if ((mainColor_2.x < 0.5)) {
              tmpvar_37 = ((2.0 * mainColor_2.x) * dstColor_3.x);
            } else {
              tmpvar_37 = (1.0 - ((2.0 * 
                (1.0 - mainColor_2.x)
              ) * (1.0 - dstColor_3.x)));
            };
            highp float tmpvar_38;
            if ((mainColor_2.y < 0.5)) {
              tmpvar_38 = ((2.0 * mainColor_2.y) * dstColor_3.y);
            } else {
              tmpvar_38 = (1.0 - ((2.0 * 
                (1.0 - mainColor_2.y)
              ) * (1.0 - dstColor_3.y)));
            };
            highp float tmpvar_39;
            if ((mainColor_2.z < 0.5)) {
              tmpvar_39 = ((2.0 * mainColor_2.z) * dstColor_3.z);
            } else {
              tmpvar_39 = (1.0 - ((2.0 * 
                (1.0 - mainColor_2.z)
              ) * (1.0 - dstColor_3.z)));
            };
            highp vec3 tmpvar_40;
            tmpvar_40.x = tmpvar_37;
            tmpvar_40.y = tmpvar_38;
            tmpvar_40.z = tmpvar_39;
            tmpvar_36 = ((tmpvar_40 * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
            tmpvar_35 = bool(0);
          } else {
            if ((mode_34 == 6)) {
              tmpvar_36 = (((vec3(1.0, 1.0, 1.0) - 
                ((vec3(1.0, 1.0, 1.0) - mainColor_2.xyz) * (vec3(1.0, 1.0, 1.0) - dstColor_3.xyz))
              ) * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
              tmpvar_35 = bool(0);
            } else {
              if ((mode_34 == 7)) {
                highp vec3 tmpvar_41;
                if ((((mainColor_2.x + mainColor_2.y) + mainColor_2.z) > ((dstColor_3.x + dstColor_3.y) + dstColor_3.z))) {
                  tmpvar_41 = mainColor_2.xyz;
                } else {
                  tmpvar_41 = dstColor_3.xyz;
                };
                tmpvar_36 = ((tmpvar_41 * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
                tmpvar_35 = bool(0);
              };
            };
          };
        };
      };
    };
  };
  if (tmpvar_35) {
    tmpvar_36 = vec3(1.0, 0.0, 0.0);
    tmpvar_35 = bool(0);
  };
  highp vec4 tmpvar_42;
  tmpvar_42.xyz = tmpvar_36;
  tmpvar_42.w = dstColor_3.w;
  _glesFragData[0] = tmpvar_42;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_StretchMode",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FlipVertical",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_FlipHorizon",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_TextureRatio",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_WindowRatio",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ScaleXRatio",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_ScaleYRatio",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_GRAP",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendTex",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BlendMode",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_StretchMode",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_Alpha",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_BGFill",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_SingleColor",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_XRepeat",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_YRepeat",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "_GaussianStep",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float _StretchMode;
uniform highp float _FlipVertical;
uniform highp float _FlipHorizon;
uniform highp float _TextureRatio;
uniform highp float _WindowRatio;
uniform highp float _ScaleXRatio;
uniform highp float _ScaleYRatio;
out highp vec2 xlv_TEXCOORD0;
out highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  highp vec2 tmpvar_2;
  highp vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = _glesVertex.xyz;
  tmpvar_3 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_4));
  highp vec2 tmpvar_5;
  tmpvar_5.x = tmpvar_3.x;
  tmpvar_5.y = -(tmpvar_3.y);
  tmpvar_2 = (((tmpvar_5 / tmpvar_3.w) + 1.0) / 2.0);
  highp vec4 tmpvar_6;
  tmpvar_6.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_6.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_6 * tmpvar_3);
  tmpvar_1 = _glesMultiTexCoord0.xy;
  if ((_StretchMode == 5.0)) {
    if ((((_ScaleXRatio / _ScaleYRatio) * _WindowRatio) > _TextureRatio)) {
      tmpvar_1.y = (((
        (_glesMultiTexCoord0.y * _ScaleYRatio)
       / _ScaleXRatio) * _TextureRatio) / _WindowRatio);
      tmpvar_1.y = (tmpvar_1.y + ((1.0 - 
        (((_ScaleYRatio / _ScaleXRatio) * _TextureRatio) / _WindowRatio)
      ) / 2.0));
    } else {
      tmpvar_1.x = (((
        (_glesMultiTexCoord0.x * _ScaleXRatio)
       / _ScaleYRatio) * _WindowRatio) / _TextureRatio);
      tmpvar_1.x = (tmpvar_1.x + ((1.0 - 
        (((_ScaleXRatio / _ScaleYRatio) * _WindowRatio) / _TextureRatio)
      ) / 2.0));
    };
  };
  if (bool(_FlipHorizon)) {
    tmpvar_1.x = (1.0 - tmpvar_1.x);
  };
  if (bool(_FlipVertical)) {
    tmpvar_1.y = (1.0 - tmpvar_1.y);
  };
  xlv_TEXCOORD0 = tmpvar_1;
  xlv_TEXCOORD1 = tmpvar_2;
  gl_Position = tmpvar_7;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_GRAP;
uniform sampler2D _BlendTex;
uniform highp float _BlendMode;
uniform highp float _StretchMode;
uniform highp float _Alpha;
uniform highp float _BGFill;
uniform highp vec4 _SingleColor;
uniform highp float _XRepeat;
uniform highp float _YRepeat;
uniform highp vec2 _GaussianStep;
in highp vec2 xlv_TEXCOORD0;
in highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1 = xlv_TEXCOORD0;
  highp vec4 mainColor_2;
  highp vec4 dstColor_3;
  dstColor_3 = vec4(1.0, 1.0, 1.0, 1.0);
  highp int tmpvar_4;
  tmpvar_4 = int((_BGFill + 1.5));
  if ((tmpvar_4 == 1)) {
    highp float Weight_6[7];
    Weight_6[6] = 0.05;
    Weight_6[0] = 0.05;
    Weight_6[5] = 0.1;
    Weight_6[1] = 0.1;
    Weight_6[4] = 0.15;
    Weight_6[2] = 0.15;
    Weight_6[3] = 0.4;
    dstColor_3 = vec4(0.0, 0.0, 0.0, 0.0);
    for (highp int row_5 = -3; row_5 <= 3; row_5++) {
      highp vec2 tmpvar_7;
      tmpvar_7.x = (tmpvar_1.x + (float(row_5) * _GaussianStep.x));
      tmpvar_7.y = (tmpvar_1.y + (_GaussianStep.y * -3.0));
      lowp vec4 tmpvar_8;
      tmpvar_8 = texture (_BlendTex, tmpvar_7);
      dstColor_3 = (dstColor_3 + ((Weight_6[
        (row_5 + 3)
      ] * Weight_6[0]) * tmpvar_8));
      highp vec2 tmpvar_9;
      tmpvar_9.x = (tmpvar_1.x + (float(row_5) * _GaussianStep.x));
      tmpvar_9.y = (tmpvar_1.y + (_GaussianStep.y * -2.0));
      lowp vec4 tmpvar_10;
      tmpvar_10 = texture (_BlendTex, tmpvar_9);
      dstColor_3 = (dstColor_3 + ((Weight_6[
        (row_5 + 3)
      ] * Weight_6[1]) * tmpvar_10));
      highp vec2 tmpvar_11;
      tmpvar_11.x = (tmpvar_1.x + (float(row_5) * _GaussianStep.x));
      tmpvar_11.y = (tmpvar_1.y - _GaussianStep.y);
      lowp vec4 tmpvar_12;
      tmpvar_12 = texture (_BlendTex, tmpvar_11);
      dstColor_3 = (dstColor_3 + ((Weight_6[
        (row_5 + 3)
      ] * Weight_6[2]) * tmpvar_12));
      highp vec2 tmpvar_13;
      tmpvar_13.x = (tmpvar_1.x + (float(row_5) * _GaussianStep.x));
      tmpvar_13.y = tmpvar_1.y;
      lowp vec4 tmpvar_14;
      tmpvar_14 = texture (_BlendTex, tmpvar_13);
      dstColor_3 = (dstColor_3 + ((Weight_6[
        (row_5 + 3)
      ] * Weight_6[3]) * tmpvar_14));
      highp vec2 tmpvar_15;
      tmpvar_15.x = (tmpvar_1.x + (float(row_5) * _GaussianStep.x));
      tmpvar_15.y = (tmpvar_1.y + _GaussianStep.y);
      lowp vec4 tmpvar_16;
      tmpvar_16 = texture (_BlendTex, tmpvar_15);
      dstColor_3 = (dstColor_3 + ((Weight_6[
        (row_5 + 3)
      ] * Weight_6[4]) * tmpvar_16));
      highp vec2 tmpvar_17;
      tmpvar_17.x = (tmpvar_1.x + (float(row_5) * _GaussianStep.x));
      tmpvar_17.y = (tmpvar_1.y + (_GaussianStep.y * 2.0));
      lowp vec4 tmpvar_18;
      tmpvar_18 = texture (_BlendTex, tmpvar_17);
      dstColor_3 = (dstColor_3 + ((Weight_6[
        (row_5 + 3)
      ] * Weight_6[5]) * tmpvar_18));
      highp vec2 tmpvar_19;
      tmpvar_19.x = (tmpvar_1.x + (float(row_5) * _GaussianStep.x));
      tmpvar_19.y = (tmpvar_1.y + (_GaussianStep.y * 3.0));
      lowp vec4 tmpvar_20;
      tmpvar_20 = texture (_BlendTex, tmpvar_19);
      dstColor_3 = (dstColor_3 + ((Weight_6[
        (row_5 + 3)
      ] * Weight_6[6]) * tmpvar_20));
    };
  } else {
    if ((tmpvar_4 == 2)) {
      dstColor_3 = _SingleColor;
    } else {
      if ((tmpvar_4 == 3)) {
        highp vec4 rgba2_21;
        highp vec4 rgba1_22;
        highp vec2 tmpvar_23;
        tmpvar_23.x = (xlv_TEXCOORD0.x + 0.25);
        tmpvar_23.y = xlv_TEXCOORD0.y;
        highp vec2 tmpvar_24;
        tmpvar_24.x = (1.25 - xlv_TEXCOORD0.x);
        tmpvar_24.y = xlv_TEXCOORD0.y;
        lowp vec4 tmpvar_25;
        tmpvar_25 = texture (_BlendTex, tmpvar_23);
        rgba1_22 = tmpvar_25;
        lowp vec4 tmpvar_26;
        tmpvar_26 = texture (_BlendTex, tmpvar_24);
        rgba2_21 = tmpvar_26;
        bool tmpvar_27;
        tmpvar_27 = (xlv_TEXCOORD0.x >= 0.5);
        dstColor_3 = ((float(tmpvar_27) * rgba2_21) + ((1.0 - 
          float(tmpvar_27)
        ) * rgba1_22));
      } else {
        if ((_StretchMode == 2.0)) {
          highp vec2 tex_coord_28;
          highp float tmpvar_29;
          tmpvar_29 = (1.0/(_XRepeat));
          tex_coord_28.x = ((xlv_TEXCOORD0.x - (
            float(int((xlv_TEXCOORD0.x / tmpvar_29)))
           * tmpvar_29)) * _XRepeat);
          highp float tmpvar_30;
          tmpvar_30 = (1.0/(_YRepeat));
          tex_coord_28.y = ((xlv_TEXCOORD0.y - (
            float(int((xlv_TEXCOORD0.y / tmpvar_30)))
           * tmpvar_30)) * _YRepeat);
          lowp vec4 tmpvar_31;
          tmpvar_31 = texture (_BlendTex, tex_coord_28);
          dstColor_3 = tmpvar_31;
        } else {
          lowp vec4 tmpvar_32;
          tmpvar_32 = texture (_BlendTex, xlv_TEXCOORD0);
          dstColor_3 = tmpvar_32;
        };
      };
    };
  };
  lowp vec4 tmpvar_33;
  tmpvar_33 = texture (TEXTURE_GRAP, xlv_TEXCOORD1);
  mainColor_2 = tmpvar_33;
  highp int mode_34;
  mode_34 = int((_BlendMode + 1.5));
  bool tmpvar_35;
  tmpvar_35 = bool(1);
  highp vec3 tmpvar_36;
  if ((mode_34 == 1)) {
    tmpvar_36 = (((
      (mainColor_2.xyz * (1.0 - dstColor_3.w))
     + 
      (dstColor_3.xyz * dstColor_3.w)
    ) * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
    tmpvar_35 = bool(0);
  } else {
    if ((mode_34 == 2)) {
      tmpvar_36 = ((min (
        (mainColor_2.xyz + dstColor_3.xyz)
      , vec3(1.0, 1.0, 1.0)) * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
      tmpvar_35 = bool(0);
    } else {
      if ((mode_34 == 3)) {
        tmpvar_36 = ((max (dstColor_3.xyz, mainColor_2.xyz) * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
        tmpvar_35 = bool(0);
      } else {
        if ((mode_34 == 4)) {
          tmpvar_36 = (((mainColor_2.xyz * dstColor_3.xyz) * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
          tmpvar_35 = bool(0);
        } else {
          if ((mode_34 == 5)) {
            highp float tmpvar_37;
            if ((mainColor_2.x < 0.5)) {
              tmpvar_37 = ((2.0 * mainColor_2.x) * dstColor_3.x);
            } else {
              tmpvar_37 = (1.0 - ((2.0 * 
                (1.0 - mainColor_2.x)
              ) * (1.0 - dstColor_3.x)));
            };
            highp float tmpvar_38;
            if ((mainColor_2.y < 0.5)) {
              tmpvar_38 = ((2.0 * mainColor_2.y) * dstColor_3.y);
            } else {
              tmpvar_38 = (1.0 - ((2.0 * 
                (1.0 - mainColor_2.y)
              ) * (1.0 - dstColor_3.y)));
            };
            highp float tmpvar_39;
            if ((mainColor_2.z < 0.5)) {
              tmpvar_39 = ((2.0 * mainColor_2.z) * dstColor_3.z);
            } else {
              tmpvar_39 = (1.0 - ((2.0 * 
                (1.0 - mainColor_2.z)
              ) * (1.0 - dstColor_3.z)));
            };
            highp vec3 tmpvar_40;
            tmpvar_40.x = tmpvar_37;
            tmpvar_40.y = tmpvar_38;
            tmpvar_40.z = tmpvar_39;
            tmpvar_36 = ((tmpvar_40 * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
            tmpvar_35 = bool(0);
          } else {
            if ((mode_34 == 6)) {
              tmpvar_36 = (((vec3(1.0, 1.0, 1.0) - 
                ((vec3(1.0, 1.0, 1.0) - mainColor_2.xyz) * (vec3(1.0, 1.0, 1.0) - dstColor_3.xyz))
              ) * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
              tmpvar_35 = bool(0);
            } else {
              if ((mode_34 == 7)) {
                highp vec3 tmpvar_41;
                if ((((mainColor_2.x + mainColor_2.y) + mainColor_2.z) > ((dstColor_3.x + dstColor_3.y) + dstColor_3.z))) {
                  tmpvar_41 = mainColor_2.xyz;
                } else {
                  tmpvar_41 = dstColor_3.xyz;
                };
                tmpvar_36 = ((tmpvar_41 * _Alpha) + (mainColor_2.xyz * (1.0 - _Alpha)));
                tmpvar_35 = bool(0);
              };
            };
          };
        };
      };
    };
  };
  if (tmpvar_35) {
    tmpvar_36 = vec3(1.0, 0.0, 0.0);
    tmpvar_35 = bool(0);
  };
  highp vec4 tmpvar_42;
  tmpvar_42.xyz = tmpvar_36;
  tmpvar_42.w = dstColor_3.w;
  _glesFragData[0] = tmpvar_42;
}

]===],
	},
}

end

