#DEFPARAMS
_BlendTex =     {"2_Texture         ", TEXTURE2D, "white"},
[Enum(Normal, 0, Add, 1, Lighten, 2, Multiply, 3, Overlay, 4, Screen, 5, Lighter, 6)]
_BlendMode =    {"3_Belnd Mode  ", FLOAT, "0.0"},
_Alpha =        {"4_Opacity         ", FLOATRANGE, "1.0,1.0,0.0"},
[Enum(ON, 0, OFF, 1)]
_DepthTest =    {"5_Depth Test    ", FLOAT, "1.0"},
[Enum(Fit, 0, Fill, 1, Stretch, 2, FitHeight, 3, FitWidth, 4, FillAndCut, 5)]
_StretchMode =    {"6_Stretch Mode ", FLOAT, "0.0"},
[Enum(HON, 0, HOFF, 1)]
_FlipHorizon =  {"7_Flip Horizon", FLOAT, "0.0"},
[Enum(ON, 0, VOFF, 1)]
_FlipVertical = {"8_Flip Vertical", FLOAT, "0.0"},
_TextureRatio =    {"9_TextureRatio ", FLOAT, "0.0"},
_WindowRatio =    {"10_WindowRatio ", FLOAT, "1.0"},
_ScaleXRatio =    {"11_ScaleXRatio ", FLOAT, "1.0"},
_ScaleYRatio =    {"12_ScaleYRatio ", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName = "screenimage"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_skin
#include "common.inc"
#include "blendfunc.inc"

struct appdata
{
  float4 vertex : POSITION;
  float2 uv : TEXCOORD0;
  ANI_ATTRIBUTE
};

struct v2f
{
  float2 uv : TEXCOORD0;
  float2 uv2: TEXCOORD1;
  float4 vertex : SV_POSITION;
};

sampler2D _BlendTex;
float     _BlendMode;
float     _StretchMode;
float     _Alpha;
float     _FlipVertical;
float     _FlipHorizon;
float     _TextureRatio;
float     _WindowRatio;
float     _ScaleXRatio;
float     _ScaleYRatio;

v2f vert(appdata v)
{
  COMPUTE_BONE_MATERIX(v);
  v2f o;
  float4 pos = ObjectToClipPos(v.vertex);
  o.uv2 = (float2(pos.x, -pos.y) / pos.w + 1.0) / 2.0;
  o.vertex = UniformNDC(pos);

  o.uv = v.uv.xy;

  if(_StretchMode == 5.0) //FillAndCut
  {
    if(_ScaleXRatio / _ScaleYRatio * _WindowRatio  > _TextureRatio)
    {
    //CLIP Y  // FitWidth
      o.uv.y = o.uv.y * _ScaleYRatio / _ScaleXRatio * _TextureRatio / _WindowRatio;
      o.uv.y =  o.uv.y + (1.0 - _ScaleYRatio / _ScaleXRatio * _TextureRatio / _WindowRatio)/ 2.0;
    }
    else
    {
    //CLIP X // FitHeight
      o.uv.x = o.uv.x * _ScaleXRatio / _ScaleYRatio * _WindowRatio / _TextureRatio;
      o.uv.x =  o.uv.x + (1.0 - _ScaleXRatio / _ScaleYRatio  * _WindowRatio / _TextureRatio)/ 2.0;
    }
  }

  if (_FlipHorizon)
  {
    o.uv.x = 1.0 - o.uv.x;
  }
  if (_FlipVertical)
  {
    o.uv.y = 1.0 - o.uv.y;
  }
  
  return o;
}

float4 frag(v2f i) : SV_Target
{
  float4 mainColor = tex2D(TEXTURE_GRAP, i.uv2);
  float4 blendColor = tex2D(_BlendTex, i.uv);
  float3 blendR = float3(1.0,0.0,0.0);
  int iBlendMode = int(_BlendMode + 1.5);
  blendR = blend(iBlendMode, mainColor, blendColor, _Alpha);
  return float4(blendR.r, blendR.g, blendR.b, blendColor.a);
}
ENDCG
#END

