#DEFPARAMS
UNIFORM_ASPECTRATIO = {"UNIFORM_ASPECTRATIO", FLOAT, "1.0"},
TEXTURE_DIFFUSE = {"TEXTURE_DIFFUSE", TEXTURE2D, "white"},
#END

#DEFTAG
ShaderName = "faceliquify"
RenderQueue = "Overlay"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 in_Position : POSITION;
	float2 in_Coordinate : TEXCOORD0;
};

struct v2f
{
	float2 out_Coordinate : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

// float UNIFORM_LIKEEVERSION;
float2 UNIFORM_POINTS[8];
float2 UNIFORM_RADIUSES[8];
float2 UNIFORM_SCALERATIOS[8];

float2 UNIFORM_RADIUS_RATIO;
float2 UNIFORM_FACEDIR_X;

float UNIFORM_ASPECTRATIO;

float3x3 UNIFORM_ZOOMSCALE;

float2 scaleWarpPositionToUse(float2 centerPostion, float2 currentPosition, float radius, float scaleRatio, float aspectRatio)
{

    float2 currentPositionToUse = float2(currentPosition.x, currentPosition.y * aspectRatio);
    float2 centerPostionToUse = float2(centerPostion.x, centerPostion.y * aspectRatio);

    float2  rvec = currentPositionToUse - centerPostionToUse;
    float rdot = dot(rvec, rvec);

    float radius_square = radius * radius;
    if(rdot > radius_square)
    {
        return currentPosition;
    }

    float r = sqrt(rdot);
    float factor = r / radius - 1.0;
    float alpha = 1.0 - scaleRatio * factor * factor;
    float2 positionToUse = centerPostion + alpha * (currentPosition - centerPostion);

    return positionToUse;
}

float2 scaleWarpEllipsePositionToUse(float2 centerPostion, float2 currentPosition, float2 face_dir_x, float r, float2 radiusRatio,float scaleRatio, float aspectRatio)
{
    float2 face_dir_y = float2(face_dir_x.y, -face_dir_x.x);

    float2 currentPositionToUse = float2(currentPosition.x, currentPosition.y * aspectRatio);
    float2 centerPostionToUse = float2(centerPostion.x, centerPostion.y * aspectRatio);

    float radiusGradient = radiusRatio.y/radiusRatio.x;

    float2  rvec = currentPositionToUse - centerPostionToUse;
    rvec = float2(dot(rvec, face_dir_x), dot(rvec, face_dir_y));
    rvec.y = rvec.y/radiusGradient;
    float rdot = dot(rvec, rvec);

    float radius = r * radiusRatio.x;
    float radius_square = radius * radius;
    if(rdot > radius_square)
    {
        return currentPosition;
    }

    float r_ = sqrt(rdot);
    float factor = r_/radius -1.0;
    float alpha = 1.0 - scaleRatio * factor * factor;

    float2 positionToUse = centerPostionToUse + alpha * rvec.x * face_dir_x + alpha * rvec.y * radiusGradient * face_dir_y;
    positionToUse.y = positionToUse.y/aspectRatio;

    return positionToUse;
}

// R the max radius, r the reference inner radius, ellipse_alpha is a/b for ellipse, face_dir_x is the direction vector for x of face

float2 warpObliqueEllipseScalePositionToUse(float2 center, float2 p, float2 face_dir_x, float r, float R, float inten, float ratio, float ellipse_alpha)
{
    // cos(agnle) = face_dir.x; sin(angle) = - face_dir.y;
    float2 face_dir_y = float2(-face_dir_x.y, face_dir_x.x);
    float2 m_point = p;
    float2 p_u = float2(p.x, p.y * ratio + 0.5 - 0.5 * ratio * ellipse_alpha);
    float2 c_u = float2(center.x, center.y * ratio + 0.5 - 0.5 * ratio * ellipse_alpha);
    float2 vec_pc = p_u - c_u;
    float2  p_r = float2(dot(vec_pc, face_dir_x), dot(vec_pc, face_dir_y));

    float d = sqrt(p_r.x * p_r.x + p_r.y * p_r.y * ellipse_alpha * ellipse_alpha);
    float scale = (R - r) / r * inten;
    float r_m = r * (1.0 + scale);
    if (d < r_m)
    {
        float alpha = 1.0 / (1.0 + scale);
        m_point = center + (p - center) * alpha;
    }
    else if (d < R)
    {
        float percent = (R - d) / (R - r_m);
        m_point = center + (p - center) * (R - percent * (R - r)) / d;
    }
	return m_point;
}

v2f vert(appdata v)
{
  #define pts UNIFORM_POINTS
  #define radiuses UNIFORM_RADIUSES
  #define scaleRatios UNIFORM_SCALERATIOS

  #define radiusRatio UNIFORM_RADIUS_RATIO

  #define face_dir_x UNIFORM_FACEDIR_X

  float4 in_Position = v.in_Position;
  float2 in_TexCooridate = v.in_Coordinate;

  float aspectRatio = UNIFORM_ASPECTRATIO;
  
  float3x3 zoomscale = UNIFORM_ZOOMSCALE;

  float2 newpos = (mul(float3(in_Position.xy,1.0), zoomscale)).xy;
  float4 outPos = float4(newpos,in_Position.z,in_Position.a);

  float2 newTexCooridate = float2((newpos.x+1.0)*0.5,(newpos.y+1.0)*0.5);
  float2 positionToUse  = newTexCooridate * 2.0 - 1.0;

  float2 displacement = float2(0,0);
  float2 new_position;

  for (int i = 0; i<8; i++)
  {
      positionToUse = scaleWarpEllipsePositionToUse(pts[i], positionToUse, face_dir_x, radiuses[i][0], radiusRatio, scaleRatios[i][0], aspectRatio);
    //   positionToUse = scaleWarpPositionToUse(pts[i], positionToUse, radiuses[i][0], scaleRatios[i][0], aspectRatio);

  }

  float2 out_TexCooridate =  0.5 * positionToUse + 0.5;

  v2f o;
  o.vertex = UniformNDC(outPos);
  o.out_Coordinate = float2(out_TexCooridate.x, 1.0 - out_TexCooridate.y);
  return o;
}

sampler2D TEXTURE_DIFFUSE;
float4 frag(v2f i) : SV_Target
{
	#define inputImageTexture TEXTURE_DIFFUSE
	float2 textureCoordinate = i.out_Coordinate.xy;

	float4 outColor = tex2D(inputImageTexture,float2(clamp(textureCoordinate.x,0.001,0.999),clamp(textureCoordinate.y,0.001,0.999)));
	return outColor;
}

ENDCG
#END
