

#DEFPARAMS
_MainTex = { "main Color", TEXTURE2D, "white" },
#END

#DEFTAG
ShaderName = "unlit"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_skin
#pragma multi_compile_fbfetch
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
	ANI_ATTRIBUTE
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D _MainTex;

v2f vert(appdata v)
{
    COMPUTE_BONE_MATERIX(v);
	v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	o.uv = v.uv.xy;

	return o;
}

#ifdef FRAMEBUFFER_FETCH
void frag(v2f i, inout float4 fbColor:COLOR0)
#else
float4 frag(v2f i) : SV_Target
#endif
{
	#ifdef FRAMEBUFFER_FETCH
	// sample the texture
	fbColor = tex2D(_MainTex, i.uv) + fbColor;
	#else
	float4 mainColor = tex2D(_MainTex, i.uv);
	return mainColor;
	#endif
}
ENDCG
#END
