

#DEFPARAMS
_MainTex = { "main Color", TEXTURE2D, "white" },
#END

#DEFTAG
ShaderName = "grapTest"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGB
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
	float4 screenPos : TEXCOORD1;
};

sampler2D _MainTex;

v2f vert(appdata v)
{
	v2f o;
	// simple transform
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	o.screenPos = ComputeScreenPos(pos);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
	// sample the texture
	float2 uvCoord = i.screenPos.xy / i.screenPos.w;
	float4 mainColor = tex2D(TEXTURE_GRAP, uvCoord);

	return mainColor;
}
ENDCG
#END
