

#DEFPARAMS
ERODE_STEP = { "ERODE_STEP", VEC2, "5.0,5.0" },
INPUTSIZE = { "INPUTSIZE", VEC2, "500.0,500.0" },
#END

#DEFTAG
ShaderName = "Erode"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
float2 INPUTSIZE;
float2 ERODE_STEP;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;


	return o;
}

float4 frag(v2f i) : SV_Target
{
	float2 step = ERODE_STEP / (INPUTSIZE) * 10;
	float4 color = tex2D(TEXTURE_DIFFUSE, i.uv);
	float halfWidth = int(max(max(step.x, step.y), 2));
	float2 onestep = ERODE_STEP / INPUTSIZE / halfWidth;
	for(int j=1; j<=halfWidth; j++)
	{
		float2 step =  j * onestep;
		// float2 uv1 = clamp(i.uv - step, float2(0.001,0.001), float2(0.999,0.999));
		// float2 uv2 = clamp(i.uv + step, float2(0.001,0.001), float2(0.999,0.999));
		color = min(tex2D(TEXTURE_DIFFUSE, i.uv - step), color);
		color = min(tex2D(TEXTURE_DIFFUSE, i.uv + step), color);
	}
	return color;
}
ENDCG
#END
