#DEFPARAMS

#END

#DEFTAG
ShaderName = "ContourSmooth1"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
    float4 vIn = tex2D(TEXTURE_DIFFUSE, i.uv);
	float vIn_a = max(min((vIn.a-0.25)/0.75, 1.0), 0.0);
	float smooth = smoothstep(0.1, 0.9, vIn_a)*vIn_a;
	return float4(0, 0, 0, smooth);
}
ENDCG
#END