
#DEFPARAMS
TEXTURE_MASK = {"TEXTURE_MASK", TEXTURE2D, "white"},
#END

#DEFTAG
ShaderName = "alpha_mask"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

float2 BGSIZE;

struct appdata
{
	float4 in_Position : POSITION;
	float2 in_Coordinate : TEXCOORD0;
};

struct v2f
{
	float2 out_Coordinate : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

v2f vert(appdata v)
{
	v2f o;
	float4 in_Position = v.in_Position;
	half2 in_Coordinate = v.in_Coordinate;

	o.out_Coordinate = in_Coordinate;
	o.vertex = UniformNDC(in_Position);
	return o;
}

sampler2D TEXTURE_MASK;

float4 frag(v2f i) : SV_Target
{
	float4 m = tex2D(TEXTURE_MASK, float2(i.out_Coordinate.x , i.out_Coordinate.y));
	return float4(0, 0, 0, m.a);
}

ENDCG
#END
