local Object = require "classic"
local PostEffectRender = require "stylish_filter.posteffect_render"

local MainCameraSequence = Object:extend();

function MainCameraSequence:new(mcsConfig, camera)
    self.posteffect_render = PostEffectRender(mcsConfig, camera); --创建后处理渲染
end

function MainCameraSequence:Release()
    self.posteffect_render:Release()
    self.posteffect_render = nil
end

function MainCameraSequence:Update(frameIndex)
    --与rect的渲染保持一致，rect文件是从1开始的，在posteffector_render中会将帧好减1
    self.posteffect_render:Update(frameIndex + 1);
end

function MainCameraSequence:SetShow(show)
    self.posteffect_render:SetShow(show)
end

return MainCameraSequence;
