local _DEBUG = true;
require "venusdebug"
require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local nodeutility = require "apolloutility.nodeutility"
local apollonode = require "apolloutility.apollonode"
local super3d = require "superme3d.superme3d"
local environment = require "superme3d.environment"
local pbrlighting = require "apolloutility.pbrlighting"
local videodecet = require "videodecet"
local textureloader = require "apolloutility.asynctexture.textureloader"
local emptyimage = require "apolloutility.emptyimage"

local renderqueue = require "apolloutility.renderqueue"

local vnectdection = require "avatar.posedection.vnectdection"
--local cameracorrection = require "avatar.skeletonfit.camera_correction"
--local skeletonfit = require "avatar.skeletonfit.skeletonfit_pos"
local lowpassfilter = require "avatar.filter.lowpassfilter"
local fourierfiltering = require "avatar.filter.fourier_filtering"

local debugske = require "avatar.posedection.debugske"
local debug2d = require "avatar.posedection.debug2d"

local mlaa = require "superme3d.model.mlaa"

local laplacian = require "avatar.retarget.laplacianretarget"
local emafilter = require "avatar.filter.exp_moving_avg"

local collisionhandler = require "avatar.retarget.collisionhandler"
local optimization = require "optimization"

local faceseg = require "videodecet.faceseg"
local videodefined = require"videodecet.defined"
local ExpressionDetect = require "emoji.expressiondetect"
local apolloDefine = require "apolloutility.defiend"

local main = {}
g_callbackhandle = main;

--以下为固定接口
function main:RegisterCallback(func)
  local index = self.callbackindex;
  self.callbackindex = self.callbackindex + 1;
  self.servicecallbacks[index] = func;
  return self._Agent, index;
end

function main:CallbackFunction(index, ...)
  _COROUTINES_ON();
  local func = self.servicecallbacks[index];
  if func then
    local res = func(...);
  end
  _COROUTINES_OFF();
  return res;
end

function main:Timespan()
  local now = venuscore.ITimerSystem:GetTimevalue();
  local def = now - self.begintime;
  self.begintime = now;
  self.cumtime = self.cumtime + def;
  self.fps = self.fps + 1;
  
  if self.cumtime > 5 then
    local fps = self.fps / self.cumtime;
    self.fps = 0;
    self.cumtime = 0;
    LOG("FPS "..fps);
  end
  return def;
end


function main:CreateCameras(near, far, pos, lookat, up) 

  self.maincamera = apollonode.CameraNode();--新建摄像机
	self.maincamera:CreatePerspectiveProjection(near, far);--设置摄像机
	self.maincamera:LookAt(pos, lookat, up);
  self.maincamera:Activate();--激活主摄像机
  
 -- self.post =   self.maincamera:CreatePostEffect();
 -- self.post:CreateResource("scrs:apolloutility/posteffect/superme_blur.lua");

end

function main:AttachRenderTarget(fbo, texture)
  LOG("platform android, fbo:"..fbo);
  self.rendertarget = apolloengine.RenderTargetEntity();--创建一个FBO
  self.rendertarget:PushMetadata(--设置FBO格式
          apolloengine.RenderTargetResourceMetadata(
                  apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
                  mathfunction.Color(0.0,1.0,1.0,1),--清屏颜色
                  apolloengine.Framework:GetResolution(),--分辨率
                  fbo));
  self.outputtexture = self.rendertarget:MakeTextureAttachment(
          apolloengine.RenderTargetEntity.TA_COLOR_0);--增加color0纹理
  self.outputtexture:PushMetadata(--创建纹理
          apolloengine.TextureResourceMetadata(
                  apolloengine.Framework:GetResolution(),
                  texture));
  self.rendertarget:CreateResource();
  self.maincamera:AttachRenderTarget(self.rendertarget);    
  return true ; 
end

--加载换脸配置表
function main:FacecuteLoadResource(path)
  _COROUTINES_ON();
  local res = super3d:LoadResource(path);
  self.isloaded = res;
  _COROUTINES_OFF();
  return self.isloaded;
end


local bonelength = {102, 53, 90, 57, 43, 90, 57, 43, 25, 100, 75, 25, 100, 75, 0}

local bonepair = {
   -- 15 is additional root joint
  {15, 13},--head
  {13, 14},
  
  {15, 1},--rarm
  {1, 2}, 
  {2, 3},
  
  {15, 4},--larm
  {4, 5}, 
  {5, 6},
  
  {15, 7},--rleg
  {7, 8}, 
  {8, 9},
  
  {15, 10},--lleg
  {10, 11}, 
  {11, 12},
  
  {15, 15} --root
}

function main:Initialize()
  _COROUTINES_ON();
  faceseg:RegisterAllSeg();
  faceseg:SetSegMark(videodefined.detectType.Face,true);
  ExpressionDetect:Initialize(self.maincamera);
  
  self.servicecallbacks = {}
  self.callbackindex = 1;
  setmetatable(self.servicecallbacks, {__mode = "v"}) --弱引用 
  
  self.begintime = venuscore.ITimerSystem:GetTimevalue();
  self.testCounter = 1;
  self.bFirstFrame = true;

  self.cumtime = 0;
  self.fps = 0;
  self:CreateCameras(1,15,
    mathfunction.vector3( 0,1,2.5),
		mathfunction.vector3(0,1,0),
		mathfunction.vector3(0,1,0));
  
  self.ambient = apollonode.LightNode(apolloengine.LightComponent.LT_AMBIENT);
  self.ambient:SetColor(
    mathfunction.vector3(0.5,0.5,0.5));

  local nativescene = apolloengine.SceneManager:GetNativeScene(apolloDefine.default_scene_name);  
  nativescene:SetMainCamera(self.maincamera:GetNode());
  nativescene:SetMaxShadowDistance(5.0);
  nativescene:SetShadowQuality(0);
  apolloengine.IEnvironmentSystem:EnableShadow();  --默认开启阴影

  self.direct = apollonode.LightNode(apolloengine.LightComponent.LT_DIRECTIONAL);
  self.direct:SetColor(
    mathfunction.vector3(0.294,0.294,0.294));
  local lightDirection = mathfunction.vector3(0.27, -0.452, -0.85);
  lightDirection:NormalizeSelf();
  self.direct:SetLocalDirection(lightDirection);

  self.direct:EnableShadowCaster(apolloengine.LightComponent.OPAQUE_SHADOW);
  
  
  self.rotation = mathfunction.Quaternion();

  
  super3d:Initialize(self.maincamera);
  
  textureloader:Initialize();
  emptyimage:Initialize();
  renderqueue:Initialize(self.maincamera);
  
  local video_path = "test:bodyvnect/";
  videodecet:Initialize(video_path, "%04d.jpg", "point.txt", false);
  vnectdection:Initialize("test:bodyvnect/rt07.ep_120.bigonn", video_path);
  
  lowpassfilter:Initialize(0,1.5,0,1.0);
  fourierfiltering:Initialize();
  emafilter:Initialize({7, 4, 2, 1, 0.5});
  --cameracorrection:Initialize(46, 12, 23); --from heatmap size
  --skeletonfit:Initialize(bonelength, bonepair, cameracorrection.viewmat);
  debugske:Initialize();
  debug2d:Initialize();
  
  super3d:LoadBackground("test:nikki_ske/IBLSkybox/Superme3D.json");
  super3d:LoadResource("test:nikki_ske/bottom/Superme3D1.json");
  --super3d:LoadResource("test:nikki_ske/bottom/Superme3D2.json");
  super3d:LoadResource("test:nikki_ske/top/Superme3D1.json");
  super3d:LoadResource("test:nikki_ske/top/Superme3D2.json");
  super3d:LoadResource("test:nikki_ske/top/Superme3D3.json");
  super3d:LoadResource("test:nikki_ske/leg/Superme3D.json");
  super3d:LoadResource("test:nikki_ske/hair/Superme3D.json");
  super3d:LoadResource("test:nikki_ske/neck/Superme3D.json");
  super3d:LoadResource("test:nikki_ske/head/Superme3D.json");
  super3d:LoadResource("test:nikki_ske/eye/Superme3D.json");
  super3d:LoadResource("test:nikki_ske/hand/Superme3D.json");
  --super3d:LoadResource("test:nikki_ske/hairphy/Superme3D.json");
  --super3d:LoadResource("test:nikki_ske/bottomphy/Superme3D.json");
  local needIK = true;
  

  super3d:LoadSkeleton(needIK,"test:nikki_ske/skeleton");
  

  --super3d:LoadPhysics("test:nikki_ske/phyxskirt/physicsconfig.json");
  --super3d:LoadPhysics("test:nikki_ske/phyx/physicsconfig.json");
  
  local nodemgr = super3d:GetNodeMgr();
  self.skenode = nil;
  
  if nodemgr.skeletonNodePose then
    self.skenode = nodemgr.skeletonNodePose
  else
    self.skenode = nodemgr.skeletonNode
  end
  
  collisionhandler:Init(self.skenode);
  
  local legr = nodemgr.skeletonNode.skeleton:GetHostNode():GetNodeByName("m_avg_R_Hip");
  local legl = nodemgr.skeletonNode.skeleton:GetHostNode():GetNodeByName("m_avg_L_Hip");
  local legpel = nodemgr.skeletonNode.skeleton:GetHostNode():GetNodeByName("m_avg_Pelvis");
  
  local neck = nodemgr.skeletonNode.skeleton:GetHostNode():GetNodeByName("m_avg_Spine2");
  
  local rarm = nodemgr.skeletonNode.skeleton:GetHostNode():GetNodeByName("m_avg_R_Elbow");
  local larm = nodemgr.skeletonNode.skeleton:GetHostNode():GetNodeByName("m_avg_L_Elbow");
  
  local scene = apolloengine.SceneManager:GetScene(apolloDefine.default_scene_name);  

  self.noder = scene:CreateNode(apolloengine.Node.CT_NODE);
  self.nodel = scene:CreateNode(apolloengine.Node.CT_NODE);
  self.nodepel = scene:CreateNode(apolloengine.Node.CT_NODE);
  self.nodesdr = scene:CreateNode(apolloengine.Node.CT_NODE);
  
  self.noderarm = scene:CreateNode(apolloengine.Node.CT_NODE);
  self.nodelarm = scene:CreateNode(apolloengine.Node.CT_NODE);

  local transr = self.noder:CreateComponent(apolloengine.Node.CT_TRANSFORM);
  legr:AttachNode(self.noder);
  transr:SetLocalScale(mathfunction.vector3(1,1,1));
  transr:SetLocalPosition(mathfunction.vector3(0.005,-0.16, 0.01));

  local transl = self.nodel:CreateComponent(apolloengine.Node.CT_TRANSFORM);
  legl:AttachNode(self.nodel);
  transl:SetLocalScale(mathfunction.vector3(1,1,1));
  transl:SetLocalPosition(mathfunction.vector3(0.005,-0.16, 0.01));

  local transpel = self.nodepel:CreateComponent(apolloengine.Node.CT_TRANSFORM);
  legpel:AttachNode(self.nodepel);
  transpel:SetLocalScale(mathfunction.vector3(1,1,1));
  transpel:SetLocalPosition(mathfunction.vector3(0,0.14,0.0));

  local transsdr = self.nodesdr:CreateComponent(apolloengine.Node.CT_TRANSFORM);
  neck:AttachNode(self.nodesdr);
  transsdr:SetLocalScale(mathfunction.vector3(1,1,1));
  transsdr:SetLocalPosition(mathfunction.vector3(0,-2.5,-4));
  
  local transrarm = self.noderarm:CreateComponent(apolloengine.Node.CT_TRANSFORM);
  rarm:AttachNode(self.noderarm);
  transrarm:SetLocalScale(mathfunction.vector3(1,1,1));
  transrarm:SetLocalPosition(mathfunction.vector3(-0.2,  0.0, 0.0 ));
  local rotation = mathfunction.Quaternion();
  rotation:RotateXYZ(0.0 , 0.0 , 0.0)
  transrarm:SetLocalRotation(rotation);
  
  local translarm = self.nodelarm:CreateComponent(apolloengine.Node.CT_TRANSFORM);
  larm:AttachNode(self.nodelarm);
  translarm:SetLocalScale(mathfunction.vector3(1,1,1));
  translarm:SetLocalPosition(mathfunction.vector3(0.18,  0.0, 0.0 ));
  rotation = mathfunction.Quaternion();
  rotation:RotateXYZ(0.0 , 0.0 , 0.0)
  translarm:SetLocalRotation(rotation);


  local rigidr = self.noder:CreateComponent(apolloengine.Node.CT_RIGID_BODY);
  local rigidl = self.nodel:CreateComponent(apolloengine.Node.CT_RIGID_BODY);
  local rigidpel = self.nodepel:CreateComponent(apolloengine.Node.CT_RIGID_BODY);
  local rigidsdr = self.nodesdr:CreateComponent(apolloengine.Node.CT_RIGID_BODY);

  rigidr.CollisionGroup = 1;
  rigidr.CollisionMask = 1;
  rigidl.CollisionGroup = 1;
  rigidl.CollisionMask = 1;
  rigidpel.CollisionGroup = 1;
  rigidpel.CollisionMask = 1;

  rigidsdr.CollisionGroup = 2;
  rigidsdr.CollisionMask = 1;
  
  local rigidrarm = self.noderarm:CreateComponent(apolloengine.Node.CT_RIGID_BODY);
  local rigidlarm = self.nodelarm:CreateComponent(apolloengine.Node.CT_RIGID_BODY);
  
  rigidr:SetCollisionShape(apolloengine.RigidBodyComponent.CST_CAPSULE);
  self.shaper = rigidr:GetCollisionShape();
  self.shaper.CapsuleRadius = 0.07;
  self.shaper.CapsuleHeight = 0.23;
  self.shaper.CapsuleAxis = apolloengine.CapsuleShape.Axis_Y;
  rigidr:SetKinematic();
  rigidr:CleanMotion();
  --rigidr:EnableDebug();

  self.rigidr = rigidr;

  rigidl:SetCollisionShape(apolloengine.RigidBodyComponent.CST_CAPSULE);
  self.shapel = rigidl:GetCollisionShape();
  self.shapel.CapsuleRadius = 0.07;
  self.shapel.CapsuleHeight = 0.23;
  self.shapel.CapsuleAxis = apolloengine.CapsuleShape.Axis_Y;
  rigidl:SetKinematic();
  rigidl:CleanMotion();
  --rigidl:EnableDebug();

  rigidpel:SetCollisionShape(apolloengine.RigidBodyComponent.CST_CAPSULE);
  self.shapepel = rigidpel:GetCollisionShape();
  self.shapepel.CapsuleRadius = 0.1;
  self.shapepel.CapsuleHeight = 0.3;
  self.shapepel.CapsuleAxis = apolloengine.CapsuleShape.Axis_Y;
  rigidpel:SetKinematic();
  rigidpel:CleanMotion();
  --rigidpel:EnableDebug();
  
  self.rigidl = rigidl;

  rigidsdr:SetCollisionShape(apolloengine.RigidBodyComponent.CST_CAPSULE);
  self.shapesdr = rigidsdr:GetCollisionShape();
  self.shapesdr.CapsuleRadius = 0.07;
  self.shapesdr.CapsuleHeight = 0.08;
  self.shapesdr.CapsuleAxis = apolloengine.CapsuleShape.Axis_X;
  rigidsdr:SetKinematic();
  rigidsdr:CleanMotion();
  --rigidsdr:EnableDebug();
  
  rigidrarm:SetCollisionShape(apolloengine.RigidBodyComponent.CST_CAPSULE);
  self.shaperarm = rigidrarm:GetCollisionShape();
  self.shaperarm.CapsuleRadius = 0.035;
  self.shaperarm.CapsuleHeight = 0.28;
  self.shaperarm.CapsuleAxis = apolloengine.CapsuleShape.Axis_X;
  rigidrarm:SetKinematic();
  rigidrarm:CleanMotion();
  --rigidrarm:EnableDebug();
  
  rigidlarm:SetCollisionShape(apolloengine.RigidBodyComponent.CST_CAPSULE);
  self.shapelarm = rigidlarm:GetCollisionShape();
  self.shapelarm.CapsuleRadius = 0.035;
  self.shapelarm.CapsuleHeight = 0.28;
  self.shapelarm.CapsuleAxis = apolloengine.CapsuleShape.Axis_X;
  rigidlarm:SetKinematic();
  rigidlarm:CleanMotion();
  --rigidlarm:EnableDebug();
  
  

  self.rigidsdr = rigidsdr;

  self.firstjump = true;

  self.LaplacianRetarget = optimization.LaplacianRetarget();
  self.RootEstimate = optimization.RootEstimate();

  
  local static_anchors = {7, 10};
  self.LaplacianRetarget:SetupStaticAnchor(static_anchors, 4000.0);
  local bonepair = {{1,2},{2,3},{4,5},{5,6},{7,8},{8,9},{10,11},{11,12}};
  self.LaplacianRetarget:SetBonePair(bonepair,2000.0);
  local links = {  {2,{4,7,10,13,14}},
                   {3,{4,7,10,13,14,6}},
                   {5,{1,7,10,13,14}},
                   {6,{1,7,10,13,14,3}},
                   {8,{1,4,10,11,12}},
                   {9,{1,4,10,11,12}},
                   {11,{1,4,7,8,9}},
                   {12,{1,4,7,8,9}},
                   {13,{1,4,7,10}},
                   {14,{1,4,7,10}},
                   {1,{4,7,10}},
                   {4,{1,7,10}},
                   };
  self.LaplacianRetarget:SetBoneLink(links,20.0);
  self.LaplacianRetarget:SetupFrameLinkData(200);
  local bondIds = collisionhandler:getCollisionBoneId();
  self.LaplacianRetarget:SetupCollisionBone(bondIds, 2000);
  
  self.LaplacianRetarget:SetupCeres(14);
  
  self.RootEstimate:SetCameraParam(23,23,6,12);
  self.RootEstimate:SetContinueWeight(0.003);
  

  apolloengine.Framework:AddSynchronizeUpdateCallback(self._Agent, "SyncUpdate");--添加同步更新
  apolloengine.Framework:AddTouchCallback(self._Agent, "OnTouch");
  
  LOG("initialize done");

  self.headJ = nodemgr.skeletonNode.skeleton:GetHostNode():GetNodeByName("m_avg_Head");
  self.pelvisJ = nodemgr.skeletonNode.skeleton:GetHostNode():GetNodeByName("m_avg_Pelvis");

  self.headInitPos = self.headJ:GetComponent(apolloengine.Node.CT_TRANSFORM):GetWorldPosition();
  self.pelvisInitPos = self.pelvisJ:GetComponent(apolloengine.Node.CT_TRANSFORM):GetWorldPosition();

  local skirtNode = nodemgr:GetMeshNode("skirt", 1);
  self.skirtCloth = skirtNode:CreateComponent(apolloengine.Node.CT_CLOTH);
  --self.skirtCloth.Frequency = 60;
  self.skirtCloth:AddCapsule(self.noder);
  self.skirtCloth:AddCapsule(self.nodel);

  local hairNode_Front = nodemgr:GetMeshNode("DollHair", 1);
  local hairNode_Back  = nodemgr:GetMeshNode("DollHair", 2);
  self.hairFrontPhy    = hairNode_Front:CreateComponent(apolloengine.Node.CT_CLOTH);
  self.hairBackPhy     = hairNode_Back:CreateComponent(apolloengine.Node.CT_CLOTH);
  --self.hairFrontPhy.Frequency = 60;
  --self.hairBackPhy.Frequency = 60;

  self.skirtCloth:Initialize();
  self.hairFrontPhy:Initialize();
  self.hairBackPhy:Initialize();
  self.skirtCloth:SetSelfCollision(true);
  self.skirtCloth:SetSelfCollisionDistance(0.005);
  self.skirtCloth:SetMaxDistance(0.5);
  self.skirtCloth:SetPoseMatchStiffness(0.03);
  
  self.skirtCloth:SetDamping(mathfunction.vector3(0.8, 0.5, 0.8));
  self.hairFrontPhy:SetDamping(mathfunction.vector3(0.5, 0.2, 0.5));
  self.hairBackPhy:SetDamping(mathfunction.vector3(0.6, 0.2, 0.6));


  self.hairFrontPhy:AddCapsule(self.nodelarm);
  self.hairFrontPhy:AddCapsule(self.noderarm);
  self.hairFrontPhy:AddCapsule(self.nodepel);
  self.hairFrontPhy:SetPoseMatchStiffness(0.008);
  self.hairFrontPhy:SetMaxDistance(1);

  self.hairBackPhy:AddCapsule(self.nodelarm);
  self.hairBackPhy:AddCapsule(self.noderarm);
  self.hairBackPhy:AddCapsule(self.nodepel);
  self.hairBackPhy:SetPoseMatchStiffness(0.008);
  self.hairBackPhy:SetMaxDistance(1);
  
  _COROUTINES_OFF();
  return true;
end


function main:SyncUpdate()
  _COROUTINES_ON();
  
  local def = self:Timespan();
  videodecet:Update(def);
  self.testCounter = self.testCounter + 1;

  local currentrgb = videodecet:GetVideoFrameRGB();
  local pos2d,pos3d,scores = vnectdection:Estimate(currentrgb);
 
  videodecet:SetBodyPoints(pos2d);
  
  if self.lastroot==nil then
    self.lastroot = {0,0,3000}
  end

  self.RootEstimate:SetRootPose(mathfunction.vector3(self.lastroot[1],self.lastroot[2],self.lastroot[3]));
  self.RootEstimate:SetPose3D(pos3d);
  self.RootEstimate:SetPose2D(pos2d);
  self.lastroot = self.RootEstimate:Minimize();
  
  cameraT = mathfunction.vector3(self.lastroot[1],-self.lastroot[2],-self.lastroot[3]);
  cameraT =  cameraT + mathfunction.vector3(0,1000,1000);
  
  pos3d[15] = nil
  for i=1,14 do
    pos3d[i][1] = pos3d[i][1]/1000
    pos3d[i][2] = -pos3d[i][2]/1000
    pos3d[i][3] = -pos3d[i][3]/1000
  end
 
  debugske:Draw(pos3d)
  debug2d:Draw(pos2d)
 
  self.skenode:UpdateSkeleton(pos3d, cameraT, cameraR)


  local modelpose = self.skenode:GetCurrentPose();

  
  local J,collision, jac, luacoll = collisionhandler:CaculatePD(pos3d);
  if jac ~= nil and luacoll ~= nil  then
    self.LaplacianRetarget:SetupCollision(jac, luacoll);
  end
  
  
  self.LaplacianRetarget:SetupInitPose(pos3d, modelpose);

  self.LaplacianRetarget:CaculateWeightFromLink();

  self.LaplacianRetarget:SetupBoneData();

  
  local pose3dlua = {};
  local retpose3dlua = {};
  local retpose3d;
 
  local nbeforeMIN = os.clock();
  retpose3d = self.LaplacianRetarget:Minimize();
  local nafterMIN = os.clock();
  local nt = string.format( "C++:Minimize cost is %.8f", nafterMIN - nbeforeMIN );
  --LOG(nt);


  for i=1,14 do
    retpose3dlua[i] = {};
    retpose3dlua[i][1] = retpose3d[i][1];
    retpose3dlua[i][2] = retpose3d[i][2];
    retpose3dlua[i][3] = retpose3d[i][3];
  end
  
  retpose3dlua[15] = {cameraT:x(),cameraT:y(),cameraT:z()};
  --[[
  if fourierfiltering.start_filtering then
    retpose3dlua = fourierfiltering:Filter(retpose3dlua);
  else
    retpose3dlua = fourierfiltering:Filter(retpose3dlua);
    retpose3dlua = lowpassfilter:Filter(retpose3dlua);
  end]]
  --retpose3dlua = lowpassfilter:Filter(retpose3dlua);
  retpose3dlua[15] = nil;
  super3d:UpdatePose(def,retpose3dlua,cameraT, cameraR); 

  super3d:UpdateIK(cameraT, cameraR,scores);

  if self.firstjump == true then
    self.firstjump = false;
    self.rigidl:CleanMotion();
    self.rigidr:CleanMotion();
    self.rigidsdr:CleanMotion();
    local nodemgr = super3d:GetNodeMgr();
    local softBodyies = nodemgr:GetSoftbodies();
   
    local pelvisPos = self.pelvisJ:GetComponent(apolloengine.Node.CT_TRANSFORM):GetWorldPosition();
    local headPos = self.headJ:GetComponent(apolloengine.Node.CT_TRANSFORM):GetWorldPosition();

    --[[local sb = softBodyies[1]:GetSoftBody();
    sb:SetWorldPosition(pelvisPos - self.pelvisInitPos);
    sb = softBodyies[2]:GetSoftBody();
    sb:SetWorldPosition(headPos - self.headInitPos);
    softBodyies[1].rigidbody[1]:CleanMotion();
    softBodyies[2].rigidbody[1]:CleanMotion();
    self.skirtCloth:ClearInertia(true);]]
  end

  local position = ExpressionDetect:GetPosition(self.maincamera);
  local expr_data = ExpressionDetect:ReceiveInputDatas();
  super3d:UpdateExpression(def, position, expr_data);

  super3d:Update(def);
  local scene = apolloengine.SceneManager:GetScene(apolloDefine.default_scene_name);
  scene:Update(def);
  _COROUTINES_OFF();
 
end


function main:Ontime()
  _COROUTINES_ON();
  self.gestureanimation:Update();
  
 
  
  _COROUTINES_OFF();
end


function main:OnTouch(touchinfo)
	_COROUTINES_ON();
	
	local vec2 = touchinfo:GetTouchPoint(1);
  
	local tt = touchinfo:GetTouchType(1);
	if apolloengine.TouchInfo.TT_PRESS == tt  then
		self.point = vec2;
    
	elseif apolloengine.TouchInfo.TT_MOVE == tt then
		local rd = vec2 - self.point;
		self.point = vec2;
		local x = rd:x();
		local pos = self.maincamera:GetPosition();
		local dir = self.maincamera:GetForward();
		local rot = mathfunction.Mathutility:RotateAxis(
		mathfunction.vector3(0,1,0),
		-x);
		pos = pos * rot;
		dir = dir * rot;
		self.maincamera:SetPosition(pos);
		self.maincamera:SetForward(dir);
	end

	_COROUTINES_OFF();
  
end

--设置摄像机FBO
function main:AttachRenderTarget(fbo, texture)
  LOG("platform android, fbo:"..fbo);
  self.rendertarget = apolloengine.RenderTargetEntity();--创建一个FBO
  self.rendertarget:PushMetadata(--设置FBO格式
          apolloengine.RenderTargetResourceMetadata(
                  apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
                  apolloengine.Framework:GetResolution(),--分辨率
                  fbo));
  self.outputtexture = self.rendertarget:MakeTextureAttachment(
          apolloengine.RenderTargetEntity.TA_COLOR_0);--增加color0纹理
  self.outputtexture:PushMetadata(--创建纹理
          apolloengine.TextureResourceMetadata(
                  apolloengine.Framework:GetResolution(),
                  texture));
  self.rendertarget:CreateResource();
  self.maincamera:AttachRenderTarget(self.rendertarget);    
  return true ; 
end

function main:Abort()
  apolloengine.Framework:RemoveAsynchronousUpdateCallback(self._Agent, "Update");
  venuscore.IApplication:Abort();
end

--设置摄像机采集图片尺寸和id
function main:SetVideoTexture(size, video)
  videodecet:SetTexture(size, video)
  return true;
end


return main;