require "venusdebug"
local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local math = require "math"
local apolloengine = require "apolloengine"
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
--local filterqueue = require "apolloutility.filterqueue"
local defined = require "apolloutility.defiend"
local basehistoricalframe   = require "apolloutility.basehistoricalframe"
local videodetect = require "videodecet"

local shinemain={};
shinemain.FrameID = 0;

local LightSampleStep =  0.005;
local NumLightSamples = 40;
local NumFrameChange = 24;
local ColorDampenRatio = 1.0;

function shinemain:Initialize(cameraLayer, config)
  self.cameraLayer = cameraLayer
  local maincamera = renderqueue:GetCamera(self.cameraLayer);
  if maincamera == nil then
    return;
  end
  
  self.frame_manager = basehistoricalframe(self.cameraLayer, 2, -76543, defined.blit_material_path);

  self.config = config;

  self.post = maincamera:CreatePostEffect();
  self.post:CreateResource("comm:script/apolloengine/posteffect/shine.lua");  
    
  
  if not (self:SetShaderParameters(config)) then
    self:Clear();
    return;
  end  
  

  --self.splice:SetShow(true);
end

function shinemain:Clear()
  local maincamera = renderqueue:GetCamera(self.cameraLayer);
  maincamera:DeletePostEffect(self.post);
  self.post = nil;
  self.frame_manager:Clear();
  self.frame_manager = nil;  
end

function shinemain:SetShaderParameters(config)
  local motion_material_path = venuscore.IFileSystem:PathAssembly("docs:material/shinemotion.material");
  self.post:RegisterParameter("CUR_FRAME_TEXTURE", "docs:material/shinemotion.material");
  self.post:RegisterParameter("PRE_FRAME_TEXTURE", "docs:material/shinemotion.material");
  
  local blur_material_path = venuscore.IFileSystem:PathAssembly("docs:material/shineseperateblur.material")
  self.post:RegisterParameter("MOTION_TEXTURE", "docs:material/shineseperateblur.material");
  self.post:RegisterParameter("RADIUS", "docs:material/shineseperateblur.material");
  self.post:RegisterParameter("UNIFORM_OFFSET", "docs:material/shineseperateblur.material");

  local volumn_material_path = venuscore.IFileSystem:PathAssembly("docs:material/shinevolumnlight.material");
  self.post:RegisterParameter("FRAME_TEXTURE", "docs:material/shinevolumnlight.material");
  self.post:RegisterParameter("BRIGHT_TEXTURE", "docs:material/shinevolumnlight.material");
  self.post:RegisterParameter("UNIFORM_LIGHT_COLOR", "docs:material/shinevolumnlight.material");
  self.post:RegisterParameter("SAMPLES", "docs:material/shinevolumnlight.material");
  self.post:RegisterParameter("STEP", "docs:material/shinevolumnlight.material");

  LightSampleStep = config.light_sample_step or LightSampleStep;
  NumLightSamples = config.num_light_samples or NumLightSamples;
  NumFrameChange = config.num_frame_change or NumFrameChange;
  ColorDampenRatio = config.color_dampen_ratio or ColorDampenRatio;

  self.post:SAMPLES(mathfunction.vector1(NumLightSamples));
  self.post:STEP(mathfunction.vector1(LightSampleStep));
  self.post:UNIFORM_LIGHT_COLOR(mathfunction.vector3(ColorDampenRatio, ColorDampenRatio, ColorDampenRatio));
  return true;
end

function shinemain:Update(def)
  if self.frame_manager == nil then
    return;
  end

  local tex = renderqueue:GetLinkedTexture(self.cameraLayer)
  if tex == nil then
    return;
  end
  
  self.frame_manager:SetVideoTexture(tex);
  self.frame_manager:SetShow(true);
  self.frame_manager:Update();
  
  self.FrameID = self.FrameID + 1;

  if self.FrameID == 1 then
    self.post:Disable();
    return;
  end
  self.post:Enable();
  local tex_queue = self.frame_manager:GetFrame();
  self.post:CUR_FRAME_TEXTURE(tex_queue[1]);
  self.post:PRE_FRAME_TEXTURE(tex_queue[2]);
  self.post:FRAME_TEXTURE(tex_queue[1]);
end

function shinemain:Exit()
  self:Clear()
end

function shinemain:SetShow(show)
  if self.post then
    if show then
      self.post:Enable()
    else
      self.post:Disable()
    end
  end
end

return shinemain;