﻿local apolloDefine = require "apolloutility.defiend"
apolloDefine.default_scene_name = "video_cutter"

local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local apollocore = require "apollocore"
local apollonode = require "apolloutility.apollonode"
local emptyimage = require "apolloutility.emptyimage"
local mathfunction = require "mathfunction"
local venusjson = require "venusjson"
local TC = require "bluecore.base.transaction_center"
local textureloader = require "apolloutility.asynctexture.textureloader"
local editormixeffect = require "editorscene.editor_mix_effect_manager"
local video_cutter = require "videocutter.video_cutter"
local editorTouchMagic = require "editorscene.editor_touch_magic_manager"
local editorSDFSubtitle = require "editorscene.editor_sdf_subtitle_manager"
local audiostretch = require "audio.audio_stretch"
local likeapp = require "likeapp"

require "utility"

local smartEnhanceProxy = require "smartEnhanceProxy"

local TAG = "main_cutter"

-- sequence值作为base,不同类别的素材基于不同的base做到类别以及层级区分
-- 同类别的每个素材resourceType基于base自增,用于区分单个素材,做到在同一个scene不同素材互不影响
-- 同类别每个素材的原有camera的sequence作为offset,当前的最大sequence作为base,进行素材camera的sequence的重新设置
-- 保证后加的素材最后渲染在最上层显示
local SEQUENCE_MIX_EFFECT = 3000; -- mix
local SEQUENCE_TOUCH_MAGIC = 4000; --touch magic
local SEQUENCE_SDF_SUBTITLE = 5000; --字幕

--暂时关闭JIT防止JIT失败导致的效率下降
if _PLATFORM_ANDROID or _PROFILER then
    jit.off();
    jit.flush();
    LOG("turn off jit")
end

local main = {}

_NeedPause = function()
  main:_NeedPause();
end


if _KRATOSEDITOR then
    main._Agent = main
else
    g_callbackhandle = main
    gMain = main

    --初始化回调
    main.servicecallbacks = {}
    main.callbackindex = 1
    setmetatable(main.servicecallbacks, {__mode = "v"}) --弱引用
    --以下为固定接口
    function main:RegisterCallback(func)
        local index = self.callbackindex
        self.callbackindex = self.callbackindex + 1
        self.servicecallbacks[index] = func
        return self._Agent, index
    end

    function main:CallbackFunction(index, ...)
        --_COROUTINES_ON();
        local func = self.servicecallbacks[index]
        local res = true
        if func then
            res = func(...)
        end
        --_COROUTINES_OFF();
        return res
    end
end

function main:Initialize()
    LOG(string.format("[%s::initialize]", TAG))

    _COROUTINES_ON()

    --创建一个场景
    self.cutterScene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name)

    self.mainCamera =
        self:_CreateCameras(
        0.01,
        20,
        mathfunction.vector3(0, 0, 0),
        mathfunction.vector3(0, 0, -1),
        mathfunction.vector3(0, 1, 0)
    )

    self.swaprt, self.swaptexture = self:_CreateBlitterRT(apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE)

    textureloader:Initialize();
    emptyimage:Initialize();
    video_cutter:Initialize(self.mainCamera, "test:palm/", "output%04d.jpg", "point.txt")

    editormixeffect:Initialize(SEQUENCE_MIX_EFFECT);
    editorTouchMagic:Initialize(SEQUENCE_TOUCH_MAGIC);
    editorSDFSubtitle:Initialize(self.cutterScene, SEQUENCE_SDF_SUBTITLE);

    audiostretch:Initialize();

    --testshell下没有设置fbo
    if _PLATFORM_WINDOWS then
        --editormixeffect:SetMainrt(self.swaprt)
        --editorTouchMagic:SetMainrt(self.swaprt)
        
        --self:SetTouchMagic("test:lanfenhudie1228_01/scene.json")

        --self:StartApplyTouchMagic(0, 100)
    end

    TC:SetOnRequest( function(requestType, requestId, timeout, jsonData)
        if likeapp.AI.OnRequest then
            likeapp.AI:OnRequest(requestType, requestId, timeout, jsonData)
        end
    end );

    apolloengine.Framework:AddSynchronizeUpdateCallback(self._Agent, "SyncUpdate") --添加同步更新
    apolloengine.Framework:AddTouchCallback(self._Agent, "OnTouch");

    self.begintime = venuscore.ITimerSystem:GetTimevalue()
    self.cumtime = 0
    self.fps = 0

    self.frameIndex = 0
    self.lastpts = 0
    self.curdef = 0
    self.mixEffectPts = 0
    self.previewMode = false

    LOG(string.format("[%s::initialize] done", TAG))

    _COROUTINES_OFF()

    return true
end

function main:Exit()
  --WARNING("*************************************************************main cutter");
    apolloengine.Framework:RemoveSynchronizeUpdateCallback(self._Agent, "SyncUpdate")
    apolloengine.Framework:RemoveTouchCallback(self._Agent, "OnTouch");
    local sceneID = self.cutterScene:GetStaticID();
    apolloengine.SceneManager:DeleteSceneByID(sceneID);
    --退出剪辑页清楚字体缓存
    editorSDFSubtitle:Exit();
    --apolloengine.SceneManager:DeleteScene(apolloDefine.default_scene_name)
    return true
end

function main:SetVideoTexture(size, inputTex)
    video_cutter:SetTexture(size, inputTex)
    collectgarbage()
    --apolloengine.Framework:ForceClear();

    apolloengine.DeviceResource:PushDeviceResource(
        apolloDefine.LAST_QUEUE_TEXTURE,
        video_cutter:GetVideoTexture());

    return true
end

function main:AttachRenderTarget(fbo, texture)
    LOG(string.format("[%s::AttachRenderTarget]platform android, fbo: %d", TAG, fbo))
    self.rendertarget = apolloengine.RenderTargetEntity() --创建一个FBO
    self.rendertarget:PushMetadata(
        --设置FBO格式
        apolloengine.RenderTargetResourceMetadata(
            apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
            apolloengine.Framework:GetResolution(),
            --分辨率
            fbo
        )
    )
    self.outputtexture = self.rendertarget:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0) --增加color0纹理
    self.outputtexture:PushMetadata(
        --创建纹理
        apolloengine.TextureResourceMetadata(apolloengine.Framework:GetResolution(), texture)
    )
    self.rendertarget:CreateResource()
    self.mainCamera:AttachRenderTarget(self.rendertarget);
    editormixeffect:SetMainrt(self.rendertarget)
    editorTouchMagic:SetMainrt(self.rendertarget)
    editorSDFSubtitle:SetMainrt(self.rendertarget)

    return true
end

function main:OnResizeView(x, y, w, h)
    LOG(string.format("[%s::OnResizeView]%d %d %d %d", TAG, x, y, w, h))
end

--[[
enable  -- true: enable; false: disable
level   -- 0: low-level, 1: mid-level, 2: high-level
shiftMs -- 0: shift directly;  >0:  shift gradually
--]]
function main:EnableSmartEnhance(enable, level, shiftMs)
    _COROUTINES_ON();
    LOG(string.format("[%s::EnableSmartEnhance]enable: %s, level: %d, shiftMs: %d", TAG, tostring(enable), level, shiftMs))
    if enable == true then
        if smartEnhanceProxy:IsInit() ~= true then
            smartEnhanceProxy:Init(self.mainCamera)
        end
        smartEnhanceProxy:Enable(level, shiftMs)
    else
        smartEnhanceProxy:Disable()
    end

    collectgarbage()
    
    _COROUTINES_OFF();
    return true
end

function main:Timespan()
    local now = venuscore.ITimerSystem:GetTimevalue()
    local def = now - self.begintime
    self.begintime = now

    self.cumtime = self.cumtime + def
    self.fps = self.fps + 1
    if self.cumtime > 5 then
        local fps = self.fps / self.cumtime
        self.fps = 0
        self.cumtime = 0
        LOG("logic fps " .. fps)
    end
    return def
end

function main:SyncUpdate()
    --_COROUTINES_ON();
    self:_Running()
    --_COROUTINES_OFF();
end

function main:Update()
    --LOG("Update")
    self:_Running()
end

function main:UpdateFrameIndexAndPts(frameIndex, pts)
    --LOG("UpdateFrameIndexAndPts frame=" .. frameIndex .. ", pts=" ..pts);
    self.frameIndex = frameIndex;
    self.lastpts = pts;
    return true
end

function main:SetMixeffect(path)
    _COROUTINES_ON()
    LOG("SetMixeffect Path:" .. path)
    local rootconfig = venusjson.LaodJsonFile(path)
    local res = editormixeffect:LoadMixeffect(self.cutterScene, path, rootconfig)
    _COROUTINES_OFF()
    return res
end

function main:RemoveLastMixeffect(effectNum)
    _COROUTINES_ON()
    LOG("RemoveLastMixeffect")
    local isMixeffect = editormixeffect:RemoveLastMixeffect(effectNum, self.cutterScene)
    collectgarbage();
    _COROUTINES_OFF()
    --if isMixeffect ~= true then
    --    self.lastpts = 0
    --    self.curdef = 0
    --end
    return true
end

function main:SetCurMixeffectRange(startFrameIndex, endFrameIndex)
    _COROUTINES_ON()
    editormixeffect:SetCurMixeffectRange(startFrameIndex, endFrameIndex)
    _COROUTINES_OFF()
    return true;
end

function main:ClearMixeffect()
    _COROUTINES_ON()
    LOG("ClearMixeffect")
    editormixeffect:ClearMixeffect(self.cutterScene)
    collectgarbage();
    _COROUTINES_OFF()
    return true;
end

function main:OnRecordStart()
    -- for protect crash while switching main script
    return true
end

----------------------- touch magic statr----------------------

function main:SetTouchMagic(path)
    local res = false
    _COROUTINES_ON()
    LOG("SetTouchMagic Path:" .. path)
    if editorTouchMagic:HasTouchMagicLoaded(path) then
      LOG("SetTouchMagic has preload!")
      res = true
    else
      local rootconfig = venusjson.LaodJsonFile(path)
      res = editorTouchMagic:LoadTouchMagic(self.cutterScene, path, rootconfig)
    end
    _COROUTINES_OFF()
    return res
end

function main:StartApplyTouchMagic(startFrameIndex, frameNum)
    _COROUTINES_ON()
    LOG("StartApplyTouchMagic " .. tostring(startFrameIndex) .. " " .. tostring(frameNum))
    editorTouchMagic:StartApplyTouchMagic()
    _COROUTINES_OFF()
    return true;
end

function main:StopApplyTouchMagic(endFrameIndex)
    _COROUTINES_ON()
    LOG("StopApplyTouchMagic " .. tostring(endFrameIndex))
    editorTouchMagic:StopApplyTouchMagic(endFrameIndex)
    
    --预加载素材
    self:SetTouchMagic(editorTouchMagic:GetLastTouchMagicPath())
    LOG("StopApplyTouchMagic preload")
    _COROUTINES_OFF()
    return true;
end

function main:OnTouch(touchinfo)
    _COROUTINES_ON();
    editorTouchMagic:SetTouchInfo(touchinfo)
    _COROUTINES_OFF();
end

function main:RemoveLastTouchMagic(magicNum)
    _COROUTINES_ON()
    LOG("RemoveLastTouchMagic")
    local isTouchMagic = editorTouchMagic:RemoveLastTouchMagic(magicNum, self.cutterScene)
    collectgarbage();
    _COROUTINES_OFF()
    --if isTouchMagic ~= true then
    --    self.lastpts = 0
    --    self.curdef = 0
    --end
    return true
end

function main:ClearTouchMagic()
    _COROUTINES_ON()
    LOG("ClearTouchMagic")
    editorTouchMagic:ClearTouchMagic(self.cutterScene)
    collectgarbage();
    _COROUTINES_OFF()
    return true;
end

function main:SetParticleScale(scale)
  _COROUTINES_ON()
  editorTouchMagic:SetParticleScale(scale)
  _COROUTINES_OFF()
  return true
end

--color RGB
function main:SetParticleColor(color)
  _COROUTINES_ON()
  editorTouchMagic:SetParticleColor(color)
  _COROUTINES_OFF()
  return true
end

---一个素材可能有多个particleComponent
function main:GetParticleScale()
  local res = 1
  _COROUTINES_ON()
  res = editorTouchMagic:GetParticleScale()
  _COROUTINES_OFF()
  return res
end

--color RGB
function main:GetParticleColor()
  local res = 0
  _COROUTINES_ON()
  res = editorTouchMagic:GetParticleColor()
  _COROUTINES_OFF()
  return res
end

--预览粒子效果
function main:StartPreviewTouchMagic(frameIndex) 
  _COROUTINES_ON()
  self.previewMode = true
  editorTouchMagic:StartPreviewTouchMagic(frameIndex)
  _COROUTINES_OFF()
  return true
end

--结束预览粒子效果
function main:StopPreviewTouchMagic()
  _COROUTINES_ON()
  self.previewMode = false
  editorTouchMagic:StopPreviewTouchMagic()
  _COROUTINES_OFF()
  return true
end

--编辑页进入touch magic页面时，保存上次的touch，用于页面返回撤销
function main:StoreTouchMagicState()
  _COROUTINES_ON()
  editorTouchMagic:StoreTouchMagicState()
  _COROUTINES_OFF()
  return true
end

--touch magic页面撤销返回编辑页，恢复上次的touch magic
function main:RestoreTouchMagicState(restore)
  _COROUTINES_ON()
  editorTouchMagic:RestoreTouchMagicState(restore, self.cutterScene)
  _COROUTINES_OFF()
  return true
end
----------------------- touch magic end----------------------

function main:SetDefaultFontPaths(fontPaths)
    editorSDFSubtitle:SetDefaultFontPaths(fontPaths)
end

function main:EnterEditState()
    return editorSDFSubtitle:EnterEditState()
end

function main:ExitEditState(save)
    return editorSDFSubtitle:ExitEditState(save)
end

function main:AddSubtitle(resourcePath, textStr)
    return editorSDFSubtitle:AddSubtitle(resourcePath, textStr)
end

function main:RemoveSubtitle(subtitleId)
    return editorSDFSubtitle:RemoveSubtitle(subtitleId)
end

function main:RemoveAllSubtitles()
    return editorSDFSubtitle:RemoveAllSubtitles()
end

function main:SetSubtitleVisible(subtitleId, visible)
    return editorSDFSubtitle:SetSubtitleVisible(subtitleId, visible)
end

function main:UpdateSubtitleResource(subtitleId, resourcePath)
    return editorSDFSubtitle:UpdateSubtitleResource(subtitleId, resourcePath)
end

function main:UpdateSubtitleText(subtitleId, text)
    return editorSDFSubtitle:UpdateSubtitleText(subtitleId, text)
end

function main:UpdateSubtitleFontPath(subtitleId, ttfPath)
    return editorSDFSubtitle:UpdateSubtitleFontPath(subtitleId, ttfPath)
end

function main:UpdateSubtitleTimeRange(subtitleId, startTs, duration)
    return editorSDFSubtitle:UpdateSubtitleTimeRange(subtitleId, startTs, duration)
end

function main:UpdateFontColor(subtitleId, rgba, useGradient)
    return editorSDFSubtitle:UpdateFontColor(subtitleId, rgba, useGradient)
end

--screenPos: 0~1.0
function main:SetSubtitleFontPosition(subtitleId, screenPos)
    return editorSDFSubtitle:SetSubtitleFontPosition(subtitleId, screenPos)
end

--rotationZ: 0~1.0
function main:SetSubtitleFontRotation(subtitleId, rotationZ)
    return editorSDFSubtitle:SetSubtitleFontRotation(subtitleId, rotationZ)
end

function main:SetSubtitleFontScale(subtitleId, scale, isFinalize)
    return editorSDFSubtitle:SetSubtitleFontScale(subtitleId, scale, isFinalize)
end

function main:GetSubtitleInfo(subtitleId)
    return editorSDFSubtitle:GetSubtitleInfo(subtitleId)
end

function main:SetSubtitleFontAlpha(subtitleId, alpha)
    return editorSDFSubtitle:SetSubtitleFontAlpha(subtitleId, alpha)
end

function main:SetTopRenderOrder(subtitleId)
    return editorSDFSubtitle:SetTopRenderOrder(subtitleId)
end

function main:SetOriginRenderOrder(subtitleId)
    return editorSDFSubtitle:SetOriginRenderOrder(subtitleId)
end

function main:PushResponse(request_type, request_id, jsonData)
    WARNING("[PushResponse] "..tostring(request_type)..","..tostring(request_id)..","..tostring(jsonData))
    TC:Response(request_type, request_id, jsonData)
end

----------------------------private----------------------------

function main:_CreateBlitterRT(swap)
    local rt = apolloengine.RenderTargetEntity();--创建一个FBO
    rt:PushMetadata(--设置FBO格式
    apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        swap,--标记作用，主要用于底层资源共享
        apolloengine.Framework:GetViewport(),
        apolloengine.Framework:GetResolution()
      )
    );--分辨率
    local depth = rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_DEPTH_STENCIL);--增加深度纹理
    depth:PushMetadata(
        apolloengine.DepthRenderBufferMetadata(
        swap,
        apolloengine.Framework:GetResolution(),
        apolloengine.TextureEntity.PF_DEPTH24_STENCIL8
      ));
    local tex = rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);--增加color0纹理
    tex:PushMetadata(--创建纹理
    apolloengine.TextureRenderMetadata(
        swap,--此处的纹理swap和尺寸必须和rt的相同不然将导致未定义的错误
        apolloengine.Framework:GetResolution()
      )
    );
    rt:CreateResource();
    return rt, tex;
end

function main:_CreateBackgroundNode(scene, texture)
    local backgroundNode = scene:CreateNode(apollocore.Node.CT_NODE);
    backgroundNode:SetName("backgroundNode");

    local bgTrans = backgroundNode:CreateComponent(apollocore.Node.CT_TRANSFORM);
    bgTrans:SetLocalPosition(mathfunction.vector3(0.0,0.0,0.0));

    local bgRender = backgroundNode:CreateComponent(apolloengine.Node.CT_RENDER);
    bgRender:EraseRenderProperty(apolloengine.RenderComponent.RP_CULL);
    bgRender:PushMetadata(--传入材质原始数据
            apolloengine.RenderObjectMaterialMetadata(
                    apolloengine.PathMetadata("comm:documents/material/imageblit.material")));

    bgRender:PushMetadata(--传入信息创建元
            apolloengine.RenderObjectMeshMetadate(
                    apolloengine.RenderComponent.RM_TRIANGLES,
                    apolloengine.QuadVertexMetadata(false, false),
                    apolloengine.QuadIndicesMetadata()));

    bgRender:CreateResource();
    bgRender:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, texture);

    return backgroundNode
end

function main:_CreateCameras(near, far, pos, lookat, up)
    local maincamera = apollonode.CameraNode() --新建摄像机
    maincamera:SetName("MainCamera")
    maincamera:CreateRealCameraProjection(near, far) --设置摄像机
    maincamera:LookAt(pos, lookat, up)
    maincamera:Recalculate() --手动更新矩阵
    maincamera:Activate();--激活主摄像机
    maincamera:SetSequenceCulling(false);
    maincamera:SetSequence(-100);
    return maincamera
end

function main:_Running()
    _COROUTINES_ON()

    local delts = self:Timespan()

    TC:Update(delts);
    video_cutter:Update(delts)
    smartEnhanceProxy:OnUpdated(delts)

    if _PLATFORM_WINDOWS then --windows测试代码
        self.curdef = delts;
        self.frameIndex = (self.frameIndex + 24 * self.curdef) % 100;
        self.mixEffectPts = self.curdef;
    elseif self.previewMode then
        self.curdef = self.curdef + delts * 1000;
        --touch magic预览的时候，mix effect pts不更新
    else
        self.curdef = self.lastpts;
        self.mixEffectPts = self.curdef;
    end

    editormixeffect:updateFrameInfo(self.frameIndex, self.mixEffectPts)
    editorTouchMagic:updateFrameInfo(self.frameIndex, self.curdef)
    editorSDFSubtitle:UpdateFrameInfo(self.frameIndex, self.mixEffectPts)

    _PROFILER_UPDATE()
    _COROUTINES_OFF()
end

function main:CreartAudioStretch()
    return audiostretch:CreartAudioStretch(self.cutterScene);
end

function main:AudioStretchSetParam(file,value)
    return audiostretch:SetParam(file,value);
end

function main:AudioStretchStart()
    return audiostretch:Start();
end

function main:AudioStretchStop()
    return audiostretch:Stop();
end

function main:AudioStretchClear()
    return audiostretch:Clear(self.cutterScene);
end

return main
