require "venusdebug"
local facecover3 = require "facecute.facechange.facecover3New"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local Object = require "classic"
local renderqueue = require "apolloutility.renderqueue"
local facedefined = require "facecute.facechange.facedefined"
local facecoverpri = require "facecute.facechange.facecoverpri"
local facechange = require "facecute.facechange.facechange"
local EffectAgent = require "facecute.effectagent"
--管理多个facechange
local facechange3 = facechange:extend();

--传入数据表，解析数据生成face组件
function facechange3:ParseConfig(config,para)
  
  if(config==nil or para==nil)
  then
    return false;
  end

  local res = true;
  
  local index = 1;
  local faceroot = config["faceMorph"];
  if (faceroot~=nil) then
    
    self.facecoverpri:ParseConfig(config,nil);

    local faceMakeUps = faceroot["makeups"];
    local compress_root = config["compress_root"];
    local faceLen = table.getn(faceMakeUps);
    for i=1,faceLen do
      --for i=6,6 do
      if(faceMakeUps[i]["enable"]==true) 
      then
        local b= facecover3(self.maincamera);
        --renderqueue:After(b);
        --renderqueue:Queue(index+facedefined.queue_camera_count_s,b);
        -- para["layerOrder"] =index+facedefined.queue_camera_count_s;
        --renderqueue:Queue(index+facedefined.queue_camera_count_s,b);
        para["layerOrder"] = index+facedefined.queue_camera_count_s;
        para["facecoverpri"]=self.facecoverpri;
        para["addIndex"] = i;
        
        --para["zOrder"] = -i;
        if(self:IsNeedSwap(faceMakeUps[i]["tag"])--[[faceMakeUps[i]["tag"]==3 or faceMakeUps[i]["tag"]==5]])
        then
            index = index+1;
            b.needswap = true;
        end
        res = res and b:ParseConfig(faceMakeUps[i], para, compress_root);
        b:SetName(faceMakeUps[i]["name"]);
        table.insert(self.facechanges, EffectAgent(b, faceMakeUps[i]["name"]));
        table.insert(self.facechangenames,faceMakeUps[i]["name"]);
      end
    end
  end
  local isFullFace =false;
  local isNotFullFace = false;
  local isNeedZDepth = false;
  local isNotNeedZDepth = false;
  local len = #self.facechanges;
  for i=1,len do
    local f = self.facechanges[i]:GetEffectObj()
    if(f:IsBeFullFace())
    then
      isFullFace = true;
    else
      isNotFullFace = true;
    end
    if(f:IsNeedZDepth())
    then
      isNeedZDepth = true; 
    else
      isNotNeedZDepth = true;
    end
  end
  
  local pripara={isFullFace,isNotFullFace,isNeedZDepth,isNotNeedZDepth};
  self.facecoverpri.isFullFace = pripara[1];
  self.facecoverpri.isNotFullFace = pripara[2];
  self.facecoverpri.isNeedZDepth = pripara[3];
  self.facecoverpri.isNotNeedZDepth = pripara[4];
  self:AddToRenderQueue();
  return res;
end

function facechange3:SetRootNode(rootNode)
  rootNode:AttachNode(self.facecoverpri);
  for _, def in ipairs(self.facechanges) do
    def:SetRootNode(rootNode)
  end

end


function facechange3:AddToRenderQueue()
  local index =1;
  local len = #self.facechanges;
  for i =1, len do
    local b = self.facechanges[i]:GetEffectObj();
    b.addIndex = index;
    index = index+1;
    renderqueue:AddObjs(b);
  end

  local maxz = -10000;
  for i=1,len do
    local b = self.facechanges[i]:GetEffectObj();
    local zorder = b:GetRenderOrder();
    maxz = math.max(maxz,zorder);
  end
  renderqueue:SetMaxFaceOrder(maxz);
end

--for美妆
function facechange3:SetMakeupStrength(strength)
  local len = #self.facechanges;
  for i =1, len do
    self.facechanges[i]:SetFade(strength);
  end
end

function facechange3:ReleaseResource()
  facechange3.super.ReleaseResource(self);
end



return facechange3;
