local mathfunction = require "mathfunction"
local Object = require "classic"
local utility = require "emoji.emojiUtility"

-- model
local model = Object:extend();

function model:new()
  self.model = nil;
  self.has_blendshape = false;
  self.attached_models = {};
end

function model:Release()
  if self.model ~= nil then
    self.model:Destroy()
  end
end

-- parse the json file, and attach the created model to the attach_to_node
function model:CreateModel(config, attach_to_model, boundingbox, render_before)
  self.model = utility.CreateModel(config); 
  self:AttachToModel(attach_to_model);  
  self:SetBindBox(boundingbox);
  self:SetRenderQueue(render_before);
end

-- attach to node
function model:AttachToModel(other_model)
  if (other_model ~= nil and self.model ~= nil) then
    local internal_model = other_model:GetModel();
    if (internal_model ~= nil) then
      internal_model:AttachNode(self.model);
      table.insert(other_model:GetAttachedModels(), self); 
    end
  end
end

function model:GetAttachedModels()
  return self.attached_models;
end

-- show model
function model:SetShow(show)
  if (self.model ~= nil) then
    self.model:SetShow(show);
  end
end

-- adjust the incoming weight if needed
function model:AdjustWeight(weights_dict)
end

-- update the model, mainly for the blendshape update and animation update
function model:UpdateModel(user_data, def)
end

-- set the bounding box
function model:SetBindBox(bbox)
  if (self.model ~= nil) then
    self.model:SetBindBox(bbox);
  end
end

-- get internal model
function model:GetModel()
  return self.model;
end

function model:HasBlendshape()
  return self.has_blendshape;
end

function model:SetRenderQueue(render_before, is_anamation)
  if (self.model ~= nil) then
    utility.SetRenderQueue(self.model, render_before, is_anamation);
  end
end

return model;