local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local Object = require "classic"
local renderqueue = require "apolloutility.renderqueue"
require "math"

eyeBlinkLName = "eyeBlink_L";
eyeBlinkRName = "eyeBlink_R"
jawOpenName = "jawOpen";
jawLeftName = "jawLeft";
jawRightName = "jawRight";
jawForwardName = "jawForward";
mouthPuckerName = "mouthPucker";
mouthSmileName = "mouthSmile";
mouthLeftName = "mouthLeft";
mouthRightName = "mouthRight";

EPSILON = 1e-3; -- math epsilon

emojiUtility = {}

function emojiUtility.CreateAnimationModel(rootpath, pos, loop, playNow)
    local model = apollonode.ModelNode();
  
  if (model:CreateResource(rootpath) == false) then
    LOG("3D Emoji load failed: "..rootpath);
    model = nil; 
  else
    if (pos ~= nil) then
      model:SetLocalPosition(mathfunction.vector3(pos[1],pos[2],pos[3]));
    end
    model:SetShow(false);
    model:SetLoop(loop);
    if (playNow == true) then
      model:Play();
      model:UpdateAnimation(0);
      model:Stop();
    end
  end
  return model;  
end

function emojiUtility.LoadModel(model, intable)
  if (model == nil) then
    return false;
  end
    
  model:SetShow(false);
  model.render:SetKeepSource(true);
  
  local render  = intable.render;
	local outline = intable.outline;
	local pos     = intable.pos;
	local texture = intable.texture;
	local mesh    = intable.mesh;
	local normal = intable.normal;
	local pbr_amr = intable.pbr_amr;
  
  if(texture ~= nil) then
    model:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,texture);
    --model:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_ALDEBO,texture);
  end
  
  if normal ~= nil then
    --model:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_NORMAL,normal);
    model:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_BUMP,normal);
  end  
    
  if pbr_amr ~= nil then
    --model:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_AMR,pbr_amr);
  end

  if model:CreateResource(mesh,render,Nil,Nil,Nil,Nil,apolloengine.VertexBufferEntity.MU_DYNAMIC, outline) == false then
    LOG("3D Emoji load failed: "..mesh);
    return false;
  end
    
  if(pos ~= nil) then 
    model:SetLocalPosition(mathfunction.vector3(pos[1],pos[2],pos[3]));      
  end
  
  return true;
end

function emojiUtility.CreateModel(intable)
  local model = apollonode.MeshNode();
  if(emojiUtility.LoadModel(model, intable) == false) then
    model = nil;
  end
  return model;
end

function emojiUtility.CreateBlendshapeModel(intable)  
  local model = apollonode.BlendshapeNode();
	if(emojiUtility.LoadModel(model, intable) == false) then
    model = nil;
  else
    local blendshape = intable.blendshape;  
    if(model:AttachBlendshape(blendshape.path, blendshape.models) == false) then
      model = nil;
    end
  end
  
  return model;  
end


function emojiUtility.SetRenderQueue(model, render_before, is_animation)
  if (model ~= nil ) then
    if render_before ~= nil and render_before == true then
      --renderqueue:Before(model);
      renderqueue:Queue("Sticker",model);  
    else
      renderqueue:After(model);
    end
    
    if(not is_animation) then
      model:SetCull(false);
    end  
  end
end

function emojiUtility.GetStep(from, to, step)
  local absolute = math.abs(from - to);
  if (absolute < EPSILON) then
    return 0;
  end
  
  local sign = (to - from) / absolute;
  return step * sign;
end

function emojiUtility.DegreeToYawPitchRoll(degreeXYZTable)
  return mathfunction.Mathutility:YawPitchRoll(math.rad(degreeXYZTable[2]),math.rad(degreeXYZTable[1]),math.rad(degreeXYZTable[3]));
end

function emojiUtility.RotateFollowJaw(rotWeight, faceWeights)  
  local jawOpenWeight = faceWeights[jawOpenName] or 0;  
  local rot = rotWeight * jawOpenWeight;
  return mathfunction.Mathutility:YawPitchRoll(math.rad(0.0), math.rad(rot), math.rad(0.0));
end

function emojiUtility.TransFollowJaw(transLeftWeight, transRightWeight, transForwardWeight, faceWeights)
  local jawLeftWeight = faceWeights[jawLeftName] or 0;
  local jawRightWeight = faceWeights[jawRightName] or 0;
  local jawForwardWeight = faceWeights[jawForwardName] or 0;  
  
  local dx = -transLeftWeight*jawLeftWeight + transRightWeight*jawRightWeight;
  local dz = transForwardWeight*jawForwardWeight;
  return mathfunction.vector3(dx, 0.0, dz);
end

return emojiUtility;

