local venusemoji = require "emoji.venusemoji"
local posture = require "facecute.estimates.transposture"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"
local venusjson = require "venusjson"
local venuscore = require "venuscore"

local emoji={};

function emoji:Initialize()
end

function emoji:LoadConfig(path)
  local rootconfig = venusjson.LaodJsonFile(path);
  if rootconfig.blendshape then
    local pathDir= string.match(path, "(.+)/[^/]*%.%w+$");
    local rootdir = pathDir.."/";
    venuscore.IFileSystem:SetResourcePath(rootdir);
    return self:LoadEmojiConfig(rootconfig.blendshape);
  end
  return true;
end

function emoji:LoadEmojiConfig(consfig)
  self.emoji3d = venusemoji();
  if self.emoji3d:ParseConfig(consfig) == false then
    self.emoji3d = nil;
    return false;
  end
  return true;
end

function emoji:ReleaseResource()
  if self.emoji3d then
    self.emoji3d:Release();
    self.emoji3d = nil;
  end
end

function emoji:GetPosition(maincamera)
  local faces = videodecet:GetFaces();
  if faces then
    posture:Update(faces,maincamera);
    local postures = posture:GetPostures();
    if #postures >= 1 then
      return postures[1];
    end
  end
  return nil;
end

function emoji:Positioning()
  local position = self:GetPosition();
  if position ~= nil and self.emoji3d ~= nil then
    self.emoji3d:SetPosition(position);
    return true;
  end
  return false;
end

function emoji:GetEmojiData()
  return self.emoji3d:ReceiveInputDatas(); 
end


function emoji:Update(def)
  if self.emoji3d then
    if self:Positioning() then
      self:_UpdateExpression(def);
      self.emoji3d:SetShow(true);
    else
      self.emoji3d:SetShow(false);
    end
  end
end

function emoji:UpdateExp(def)
  if self.emoji3d then
    self.emoji3d.trans:SetWorldScale(mathfunction.vector3(0.9,0.9,0.9));
    self:_UpdateExpression(def);
    self.emoji3d:SetShow(true);
  end
end

function emoji:GetRootNode()
  return self.emoji3d; 
end

function emoji:_UpdateExpression(def)
  local emoji_data = self:GetEmojiData();
  if(emoji_data == nil) then
    return;
  end
  self.emoji3d:UpdateData(emoji_data);
  self.emoji3d:UpdateModel(emoji_data, def);
end


return emoji;
